/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

class JarResources {
    private Hashtable htSizes = new Hashtable();
    private Hashtable htJarContents = new Hashtable();
    private String jarFileName;

    JarResources(String string) throws IOException {
        this.jarFileName = string;
        this.init();
    }

    byte[] getResource(String string) {
        return (byte[])this.htJarContents.get(string);
    }

    private void init() throws IOException {
        Object object;
        ZipFile zipFile = new ZipFile(this.jarFileName);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            this.htSizes.put(((ZipEntry)object).getName(), new Integer((int)((ZipEntry)object).getSize()));
        }
        zipFile.close();
        object = new FileInputStream(this.jarFileName);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            int n = (int)zipEntry.getSize();
            if (n == -1) {
                n = (Integer)this.htSizes.get(zipEntry.getName());
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                n2 += n3;
            }
            this.htJarContents.put(zipEntry.getName(), byArray);
        }
    }
}

