/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.util.StringTokenizer;
import snmp.SNMPBadValueException;
import snmp.SNMPOctetString;

public class SNMPIPAddress
extends SNMPOctetString {
    public SNMPIPAddress() {
        this.tag = (byte)64;
        this.data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.data[i] = 0;
        }
    }

    public SNMPIPAddress(String string) throws SNMPBadValueException {
        this.tag = (byte)64;
        this.data = this.parseIPAddress(string);
    }

    public SNMPIPAddress(byte[] byArray) throws SNMPBadValueException {
        this.tag = (byte)64;
        if (byArray.length != 4) {
            throw new SNMPBadValueException(" IPAddress: bad BER encoding supplied to set value ");
        }
        this.data = byArray;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof byte[] && ((byte[])object).length == 4) {
            this.data = (byte[])object;
        } else if (object instanceof String) {
            this.data = this.parseIPAddress((String)object);
        } else {
            throw new SNMPBadValueException(" IPAddress: bad data supplied to set value ");
        }
    }

    public String toString() {
        String string = new String();
        if (this.data.length > 0) {
            int n = this.data[0];
            if (n < 0) {
                n += 256;
            }
            string = string + n;
            for (int i = 1; i < this.data.length; ++i) {
                n = this.data[i];
                if (n < 0) {
                    n += 256;
                }
                string = string + "." + n;
            }
        }
        return string;
    }

    private byte[] parseIPAddress(String string) throws SNMPBadValueException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                stringTokenizer.nextToken();
            }
            if (n != 4) {
                throw new SNMPBadValueException(" IPAddress: wrong number of components supplied to set value ");
            }
            byte[] byArray = new byte[n];
            stringTokenizer = new StringTokenizer(string, " .");
            for (int i = 0; i < n; ++i) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 < 0 || n2 > 255) {
                    throw new SNMPBadValueException(" IPAddress: invalid component supplied to set value ");
                }
                byArray[i] = (byte)n2;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SNMPBadValueException(" IPAddress: invalid component supplied to set value ");
        }
    }
}

