<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/fail2ban/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/collectors/go.d.plugin/modules/fail2ban/metadata.yaml"
sidebar_label: "Fail2ban"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Authentication and Authorization"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Fail2ban


<img src="https://netdata.cloud/img/fail2ban.png" width="150"/>


Plugin: go.d.plugin
Module: fail2ban

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector tracks two main metrics for each jail: currently banned IPs and active failure incidents. It relies on the [`fail2ban-client`](https://linux.die.net/man/1/fail2ban-client) CLI tool but avoids directly executing the binary. Instead, it utilizes `ndsudo`, a Netdata helper specifically designed to run privileged commands securely within the Netdata environment. This approach eliminates the need to use `sudo`, improving security and potentially simplifying permission management.




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per jail

These metrics refer to the Jail.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| jail | Jail's name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| fail2ban.jail_banned_ips | banned | addresses |
| fail2ban.jail_active_failures | active_failures | failures |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/fail2ban.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/fail2ban.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| timeout | fail2ban-client binary execution timeout. | 2 | no |

</details>

#### Examples

##### Custom update_every

Allows you to override the default data collection interval.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: fail2ban
    update_every: 5  # Collect Fail2Ban jails statistics every 5 seconds

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `fail2ban` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m fail2ban
  ```


