<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/tomcat/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/tomcat/metadata.yaml"
sidebar_label: "Tomcat"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Web Servers and Web Proxies"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Tomcat


<img src="https://netdata.cloud/img/tomcat.svg" width="150"/>


Plugin: python.d.plugin
Module: tomcat

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Tomcat metrics about bandwidth, processing time, threads and more.


It parses the information provided by the http endpoint of the `/manager/status` in XML format


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

You need to provide the username and the password, to access the webserver's status page. Create a seperate user with read only rights for this particular endpoint

### Default Behavior

#### Auto-Detection

If the Netdata Agent and the Tomcat webserver are in the same host, without configuration, module attempts to connect to http://localhost:8080/manager/status?XML=true, without any credentials. So it will probably fail.

#### Limits

This module is not supporting SSL communication. If you want a Netdata Agent to monitor a Tomcat deployment, you shouldnt try to monitor it via public network (public internet). Credentials are passed by Netdata in an unsecure port

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Tomcat instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| tomcat.accesses | accesses, errors | requests/s |
| tomcat.bandwidth | sent, received | KiB/s |
| tomcat.processing_time | processing time | seconds |
| tomcat.threads | current, busy | current threads |
| tomcat.jvm | free, eden, survivor, tenured, code cache, compressed, metaspace | MiB |
| tomcat.jvm_eden | used, committed, max | MiB |
| tomcat.jvm_survivor | used, committed, max | MiB |
| tomcat.jvm_tenured | used, committed, max | MiB |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Create a read-only `netdata` user, to monitor the `/status` endpoint.

This is necessary for configuring the collector.


### Configuration

#### File

The configuration file name for this integration is `python.d/tomcat.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/tomcat.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details open><summary>Config options per job</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| url | The URL of the Tomcat server's status endpoint. Always add the suffix ?XML=true. | no | yes |
| user | A valid user with read permission to access the /manager/status endpoint of the server. Required if the endpoint is password protected | no | no |
| pass | A valid password for the user in question. Required if the endpoint is password protected | no | no |
| connector_name | The connector component that communicates with a web connector via the AJP protocol, e.g ajp-bio-8009 |  | no |

</details>

#### Examples

##### Basic

A basic example configuration

```yaml
localhost:
  name : 'local'
  url  : 'http://localhost:8080/manager/status?XML=true'

```
##### Using an IPv4 endpoint

A typical configuration using an IPv4 endpoint

<details open><summary>Config</summary>

```yaml
local_ipv4:
  name : 'local'
  url  : 'http://127.0.0.1:8080/manager/status?XML=true'

```
</details>

##### Using an IPv6 endpoint

A typical configuration using an IPv6 endpoint

<details open><summary>Config</summary>

```yaml
local_ipv6:
  name : 'local'
  url  : 'http://[::1]:8080/manager/status?XML=true'

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `tomcat` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin tomcat debug trace
  ```


