<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/exim/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/exim/metadata.yaml"
sidebar_label: "Exim"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Mail Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Exim


<img src="https://netdata.cloud/img/exim.jpg" width="150"/>


Plugin: python.d.plugin
Module: exim

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Exim mail queue.

It uses the `exim` command line binary to get the statistics.

This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

Assuming setup prerequisites are met, the collector will try to gather statistics using the method described above, even without any configuration.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Exim instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| exim.qemails | emails | emails |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Exim configuration - local installation

The module uses the `exim` binary, which can only be executed as root by default. We need to allow other users to `exim` binary. We solve that adding `queue_list_requires_admin` statement in exim configuration and set to `false`, because it is `true` by default. On many Linux distributions, the default location of `exim` configuration is in `/etc/exim.conf`.

1. Edit the `exim` configuration with your preferred editor and add:
`queue_list_requires_admin = false`
2. Restart `exim` and Netdata


#### Exim configuration - WHM (CPanel) server

On a WHM server, you can reconfigure `exim` over the WHM interface with the following steps.

1. Login to WHM
2. Navigate to Service Configuration --> Exim Configuration Manager --> tab Advanced Editor
3. Scroll down to the button **Add additional configuration setting** and click on it.
4. In the new dropdown which will appear above we need to find and choose:
`queue_list_requires_admin` and set to `false`
5. Scroll to the end and click the **Save** button.



### Configuration

#### File

The configuration file name for this integration is `python.d/exim.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/exim.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| command | Path and command to the `exim` binary | exim -bpc | no |

</details>

#### Examples

##### Local exim install

A basic local exim install

```yaml
local:
 command: 'exim -bpc'

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `exim` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin exim debug trace
  ```


