// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package finspacedataiface provides an interface to enable mocking the FinSpace Public API service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package finspacedataiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/finspacedata"
)

// FinSpaceDataAPI provides an interface to enable mocking the
// finspacedata.FinSpaceData service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // FinSpace Public API.
//    func myFunc(svc finspacedataiface.FinSpaceDataAPI) bool {
//        // Make svc.CreateChangeset request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := finspacedata.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockFinSpaceDataClient struct {
//        finspacedataiface.FinSpaceDataAPI
//    }
//    func (m *mockFinSpaceDataClient) CreateChangeset(input *finspacedata.CreateChangesetInput) (*finspacedata.CreateChangesetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockFinSpaceDataClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type FinSpaceDataAPI interface {
	CreateChangeset(*finspacedata.CreateChangesetInput) (*finspacedata.CreateChangesetOutput, error)
	CreateChangesetWithContext(aws.Context, *finspacedata.CreateChangesetInput, ...request.Option) (*finspacedata.CreateChangesetOutput, error)
	CreateChangesetRequest(*finspacedata.CreateChangesetInput) (*request.Request, *finspacedata.CreateChangesetOutput)

	GetProgrammaticAccessCredentials(*finspacedata.GetProgrammaticAccessCredentialsInput) (*finspacedata.GetProgrammaticAccessCredentialsOutput, error)
	GetProgrammaticAccessCredentialsWithContext(aws.Context, *finspacedata.GetProgrammaticAccessCredentialsInput, ...request.Option) (*finspacedata.GetProgrammaticAccessCredentialsOutput, error)
	GetProgrammaticAccessCredentialsRequest(*finspacedata.GetProgrammaticAccessCredentialsInput) (*request.Request, *finspacedata.GetProgrammaticAccessCredentialsOutput)

	GetWorkingLocation(*finspacedata.GetWorkingLocationInput) (*finspacedata.GetWorkingLocationOutput, error)
	GetWorkingLocationWithContext(aws.Context, *finspacedata.GetWorkingLocationInput, ...request.Option) (*finspacedata.GetWorkingLocationOutput, error)
	GetWorkingLocationRequest(*finspacedata.GetWorkingLocationInput) (*request.Request, *finspacedata.GetWorkingLocationOutput)
}

var _ FinSpaceDataAPI = (*finspacedata.FinSpaceData)(nil)
