# checkstyle
[![GoDoc](https://godoc.org/github.com/phayes/checkstyle?status.svg)](https://godoc.org/github.com/phayes/checkstyle)
[![Go Report Card](https://goreportcard.com/badge/github.com/phayes/checkstyle)](https://goreportcard.com/report/github.com/phayes/checkstyle)
[![Build Status](https://scrutinizer-ci.com/g/phayes/checkstyle/badges/build.png?b=master)](https://scrutinizer-ci.com/g/phayes/checkstyle/build-status/master)

Read and write checksyle_report.xml files with golang

Checkstyle XML files are a standard file format for reporting errors in source code, and is often generated by static analysis tools.

Example usage:

```go

import "github.com/phayes/checkstyle"

// Print XML into human readable format
checkSyle, err := checkstyle.ReadFile("checkstyle_report.xml")
if err != nil {
  log.Fatal(err)
}
for _, file := range checkStyle.File {
  fmt.Println(File.Name)
  for _, codingError := range file.Error {
    fmt.Println("\t", codingError.Line, codingError.Message)
  }
}

// Create a new XML file from scratch
check := checkstyle.New()

// Ensure that a file has been added
file := check.EnsureFile("/path/to/file")

// Create an error on line 10
codingError := checkstyle.NewError(10, "format", "line must end with a full stop")

// Add the error to the file
file.AddError(codingError)

// Output XML
fmt.Print(check)
```

For more information on checkstyle XML see: http://checkstyle.sourceforge.net/checks.html
