/*-
 * Copyright (c) 2001 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: opt.c,v 1.14 2004/05/10 08:42:35 vlm Exp $
 */

#include "headers.h"
#include "storage.h"
#include "wrap_oclose.h"

volatile sig_atomic_t daemon_mode = 0;
volatile sig_atomic_t display_now = 0;
volatile sig_atomic_t signoff_now = 0;

volatile int max_clients = 10;
pthread_mutex_t max_clients_lock;
pthread_mutex_t packet_sources_list_lock;
pthread_mutex_t pndev_lock;

pthread_attr_t	thread_attr_detach;

int
init_pthread_options() {

	if(pthread_mutex_init(&max_clients_lock, NULL) == -1)
		return -1;

	if(pthread_mutex_init(&packet_sources_list_lock, NULL) == -1)
		return -1;

	if(pthread_mutex_init(&pndev_lock, NULL) == -1)
		return -1;

	if(pthread_mutex_init(&fd_pool_mutex, NULL) == -1)
		return -1;

	if(pthread_mutex_init(&active_storage.storage_lock, NULL) == -1)
		return -1;

	if(pthread_mutex_init(&checkpoint_storage.storage_lock, NULL) == -1)
		return -1;

	if(pthread_mutex_init(&netflow_storage.storage_lock, NULL) == -1)
		return -1;

	/* Init thread attribute: Detach thread */
	if(pthread_attr_init(&thread_attr_detach) == -1)
		return -1;

	if(pthread_attr_setdetachstate(&thread_attr_detach, 1) == -1)
		return -1;

	return 0;
}


