/*-
 * Copyright (c) 2001 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: headers.h,v 1.35 2005/09/06 02:43:23 vlm Exp $
 */
#ifndef	__HEADERS_H__
#define	__HEADERS_H__

#ifndef	__need_sig_atomic_t
#define	__need_sig_atomic_t	1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef	HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef	HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef	HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef	HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef	HAVE_SYS_FILE_H
#include <sys/file.h>
#endif

#ifdef	HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef	HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#ifdef	HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#ifdef	HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_NET_IF_H
#include <net/if.h>
#endif

#ifdef HAVE_NET_ROUTE_H
#include <net/route.h>
#endif

#ifdef HAVE_IFADDRS_H
#include <ifaddrs.h>
#endif

#ifdef HAVE_NET_ETHERNET_H
#include <net/ethernet.h>
#endif

#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#endif

#ifdef	HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef	HAVE_NETINET_IP_H
#include <netinet/ip.h>
#endif

#ifdef	HAVE_NETINET_TCP_H
#include <netinet/tcp.h>
#endif

#ifdef	HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#ifdef HAVE_NETINET_IF_ETHER_H
#include <netinet/if_ether.h>
#endif

#ifdef	HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef	HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef	HAVE_LIBGEN_H
#include <libgen.h>		/* for dirname(3) */
#else
#define	dirname(foo)	(foo)	/* Fine approximation. */
#endif

#ifdef	HAVE_SYSEXITS_H
#include <sysexits.h>
#endif

#ifdef	HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef	HAVE_PTHREAD_H
#include <pthread.h>
#endif

#ifdef	HAVE_PATHS_H
#include <paths.h>
#endif

#include <poll.h>
#include <signal.h>
#include <fnmatch.h>

#include <assert.h>

#ifndef	IPPROTO_SCTP
#define	IPPROTO_SCTP	132	/* Stream Control Transmission Protocol */
#endif	/* IPPROTO_SCTP */

#ifndef	_PATH_DEVNULL
#define	_PATH_DEVNULL	"/dev/null"
#endif	/* _PATH_DEVNULL */

#ifndef ETHER_HDR_LEN
#define ETHER_ADDR_LEN 6
#define ETHER_TYPE_LEN 2
#define ETHER_HDR_LEN	(ETHER_ADDR_LEN*2+ETHER_TYPE_LEN)
#endif	/* ETHER_HDR_LEN */

#ifdef	HAVE_ASM_TYPES_H
#include <asm/types.h>
#endif

#ifdef	HAVE_LINUX_SOCKET_H
#include <linux/socket.h>
#endif

#ifdef	HAVE_LINUX_NETLINK_H
#include <linux/netlink.h>
#endif

#ifdef	HAVE_LINUX_NETFILTER_H
#include <linux/netfilter.h>
#endif

/*
 * Linux ULOG support
 */
#ifdef	HAVE_LINUX_NETFILTER_IPV4_IPT_ULOG_H
#include <linux/netfilter_ipv4/ipt_ULOG.h>
#define	PSRC_ulog
#endif

/*
 * Linux IPQ/libipq(3) support
 */
#ifdef	HAVE_LINUX_NETFILTER_IPV4_IP_QUEUE_H
#include <linux/netfilter_ipv4/ip_queue.h>
#define	PSRC_ipq
#endif


#if defined(HAVE_NET_BPF_H) 
#include <net/bpf.h>
#endif	/* #ifdef HAVE_NET_BPF_H */

#ifdef	HAVE_PCAP_H
#include <pcap.h>
#else	/* #ifdef HAVE_PCAP_H */
#ifdef	HAVE_PCAP_PCAP_H
#include <pcap/pcap.h>
#else	/* #ifdef HAVE_PCAP_PCAP_H */
#if defined(HAVE_NET_BPF_H)
/* Whooh */
#else
#error	No BPF or PCAP installed. Aborting.
#endif
#endif	/* #ifdef HAVE_PCAP_PCAP_H */
#endif	/* #ifdef HAVE_PCAP_H */

#if	defined(HAVE_NET_ROUTE_H) && !defined(__linux__)
#define	IPCAD_DYNAMIC_ROUTING_SOCKET
#endif

#if	defined(HAVE_IFADDRS_H) && defined(HAVE_GETIFADDRS)
#define	IPCAD_IFLIST_USE_GETIFADDRS
#endif

#ifndef HAVE_SOCKLEN_T
typedef size_t	socklen_t;
#endif

#ifndef HAVE_IN_ADDR_T
typedef unsigned int in_addr_t;
#endif

#ifndef	HAVE_STRTOULL
#ifdef	HAVE_STRTOUQ
#define	strtoull(a,b,c)	strtouq(a,b,c)
#else	/* HAVE_STRTOUQ */
#warning Neither strtoull() nor strtouq() functions are present!
#warning Byte count type width limited to "long" width.
#define	strtoull(a,b,c)	strtoul(a,b,c)
#endif	/* HAVE_STRTOUQ */
#endif	/* HAVE_SRTOULL */

#ifndef	HAVE_INET_ATON
#ifdef	HAVE_INET_PTON
#define	inet_aton(a,b)	inet_pton(AF_INET, a, b)
#else	/* HAVE_INET_PTON */
#error	Neither inet_aton() nor inet_pton() functions are present!
#endif	/* HAVE_INET_PTON */
#endif	/* HAVE_INET_ATON */

#ifndef	offsetof
#define	offsetof(T, m)	(((void *)&(((T *)0)->m)) - (void *)0)
#endif	/* offsetof */

#ifndef	MIN
#define	MIN(a,b)	((a)<(b)?(a):(b))
#endif	/* MIN */

#endif	/* __HEADERS_H__ */
