/*-
 * Copyright (c) 2001 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: cfgread.c,v 1.10 2004/03/06 05:22:42 vlm Exp $
 */

#include "ipcad.h"

int ipcacfgparse();

extern int ipcacfglineno;
void ipcacfgrestart( FILE * );

int
cfgread(const char *cfname) {
	FILE *fp;
	struct stat sb;

	if(!cfname) {
		fprintf(stderr, "-ERR: filename required.\n");
		return -1;
	}

	if(!(fp=fopen(cfname, "r")) || fstat(fileno(fp), &sb)) {
		fprintf(stderr, "-ERR: %s: Can't open config file.\n", cfname);
		return -1;
	}

	if((sb.st_mode & S_IFMT) != S_IFREG) {
		fprintf(stderr, "-ERR: %s: Not a regular file.\n", cfname);
		return -1;
	}

	ipcacfglineno = 1;

	ipcacfgrestart(fp);

	if(ipcacfgparse()) {
		fclose(fp);
		return 1;
	}

	fclose(fp);

	return 0;
}

