#include <gdbm.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "db.h"
#include "utils.h"
#include "error.h"


void * open_database(char *parameters, char open_mode)
{
	int block_size;
	int flags;

	GDBM_FILE *dbf = (GDBM_FILE *)mymalloc(sizeof(GDBM_FILE), "open_database: GDBM_FILE object");

	if (open_mode == DB_OPEN_READ)
		flags = GDBM_READER;
	else if (open_mode == DB_OPEN_WRITE)
		flags = GDBM_WRCREAT;
	else
		error_exit("open_database: %d not recognised as an open mode\n", open_mode);

/* get block_size from sysconf */
/*... */
block_size=512;

	*dbf = gdbm_open(parameters, block_size, flags, S_IRUSR | S_IWUSR, NULL);

	if (*dbf == NULL)
		error_exit("open_database: failed to open database with parameters '%s': %s (mode: %s)\n", parameters, gdbm_strerror(gdbm_errno), open_mode == DB_OPEN_READ ? "read" : "write");

	return dbf;
}

void database_transaction_start(void *handle)
{
	/* not applicable for gdbm */
}

void database_transaction_end(void *handle)
{
	/* not applicable for gdbm */
}

void insert_or_replace_into_database(void *handle, char *key, char *content)
{
	int rc;
	datum	dkey;
	datum	dcontent;

	dkey.dptr = key;
	dkey.dsize = strlen(key);

	dcontent.dptr = content;
	dcontent.dsize = strlen(content);

	if ((rc = gdbm_store(*(GDBM_FILE *)handle, dkey, dcontent, GDBM_REPLACE)) != 0)
		error_exit("insert_into_database: failed to insert key '%s' with content '%s' into database, reason: %d/%s.\n", key, content, rc, gdbm_strerror(gdbm_errno));
}

char * retrieve_from_database(void *handle, char *key)
{
	char	*out;
	datum	dcontent;
	datum	dkey;

	dkey.dptr = key;
	dkey.dsize = strlen(key);

	/* search */
	dcontent = gdbm_fetch(*(GDBM_FILE *)handle, dkey);

	/* found? */
	if (!dcontent.dptr)
	{
		return NULL;	/* not found */
	}

	/* found, allocate memory */
	out = (char *)mymalloc(dcontent.dsize + 1, "retrieve_from_database: found object");

	/* copy & make 0x00-terminated */
	memcpy(out, dcontent.dptr, dcontent.dsize);
	out[dcontent.dsize] = 0x00;

	return out;
}

void close_database(void *handle)
{
	gdbm_close(*(GDBM_FILE *)handle);
}

void increase_counter_database(void *handle, char *key, int how_much)
{
	char buffer[128];
	char *dummy;
	int cur_counter = how_much;

	database_transaction_start(handle);

	dummy = retrieve_from_database(handle, key);
	if (dummy)
	{
		cur_counter = atoi(dummy) + how_much;
		free(dummy);
	}

	sprintf(buffer, "%d", cur_counter);
	insert_or_replace_into_database(handle, key, buffer);

	database_transaction_end(handle);
}
