#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "conf.h"
#include "utils.h"
#include "br.h"

conf * load_config(char *file)
{
	int fd;
	conf *pnt = (conf *)mymalloc(sizeof(conf), "load_config: conf-object");

	memset(pnt, 0x00, sizeof(conf));

	fd = open(file, O_RDONLY);
	if (fd == -1)
	{
		fprintf(stderr, "Cannot open file %s: %s\n", file, strerror(errno));
		exit(1);
	}

	buffered_reader	br(fd);

	for(;;)
	{
		char *line = br.read_line();
		if (!line)
			break;

		char *is = strchr(line, '=');
		char *cmd, *par = NULL;

		cmd = get_token(line);
		if (is)
			par = get_token(is + 1);

		if (strcasecmp(cmd, "db_good") == 0)
		{
			pnt -> good_db_parameters = mystrdup(par);
		}
		else if (strcasecmp(cmd, "db_bad") == 0)
		{
			pnt -> bad_db_parameters = mystrdup(par);
		}
		else if (strcasecmp(cmd, "db_conf") == 0)
		{
			pnt -> conf_db_parameters = mystrdup(par);
		}
		else if (strcasecmp(cmd, "logfile") == 0)
		{
			pnt -> logfile = mystrdup(par);
		}
		else
		{
			fprintf(stderr, "Configline '%s' is not recognized.\n");
			exit(1);
		}

		free(cmd);
		free(par);
		free(line);
	}

	close(fd);

	if (!pnt -> bad_db_parameters || !pnt -> good_db_parameters || !pnt -> conf_db_parameters)
	{
		fprintf(stderr, "No specification for good/bad/conf db found.\n");
		exit(1);
	}

	if (!pnt -> logfile)
	{
		fprintf(stderr, "No logfile specified.\n");
		exit(1);
	}

	return pnt;
}
