<NodesDefinition>
<config  field_mand="name, descr, size" />
<config  field_attr="name" type="ascii" />
<config  field_attr="descr" type="ascii" />
<config  field_attr="size" type="hexa" />
<config  field_attr="type" type="ascii" />
<config  field_attr="rw" type="enum" >
	<enum  name="OP" value="OP" />
	<enum  name="ReadOnly" value="RO" />
	<enum  name="ReadWrite" value="RW" />
	<enum  name="WriteOnly" value="WO" />
</config>
<config  field_attr="access" type="enum" >
	<enum  name="Index" value="INDEX" />
	<enum  name="OP" value="OP" />
	<enum  name="ReadOnly" value="RO" />
	<enum  name="ReadWrite" value="RW" />
	<enum  name="WriteOnly" value="WO" />
</config>
<config  field_attr="enum" type="enumval" />
<config  big_endian_arr="1" />
<config  field_attr="selected_by" type="ascii" used_for="node" />
<config  field_attr="union_selector" type="ascii" used_for="node" />
<config  field_attr="mlxconfig_desc" type="ascii" />
<config  field_attr="mlxconfig_name" type="ascii" />
<config  field_attr="xuefi" type="ascii" />
<config  field_attr="supported_from_version" type="ascii" />
<config  field_attr="dependency" type="ascii" />
<config  field_attr="valid_bit" type="ascii" />
<config  field_attr="tempvars" type="ascii" />
<config  field_attr="minval" type="ascii" />
<config  field_attr="maxval" type="ascii" />
<config  field_attr="rule" type="ascii" />
<config  field_attr="regex" type="ascii" />
<config  field_attr="capability" type="ascii" />
<config  field_attr="target" type="ascii" />
<config  field_attr="version" type="ascii" />
<info source_doc_name="" source_doc_version="Rev 1.55.171" />
<node name="FMQC_ext" descr="" size="0xc.0" >
	<field name="lp" descr="local port\;CPU port is not supported\;" access="INDEX" offset="0x0.0" size="0x0.10" />
	<field name="s" descr="status\;0: failure \;1: success" access="RO" offset="0x0.16" size="0x0.1" />
	<field name="modifier_cluster" descr="modifier cluster\;Reserved when status != success" access="RO" offset="0x4.0" size="0x0.11" />
</node>

<node name="FSDB_ext" descr="" size="0x78.0" >
	<field name="acl_group_id" descr="ACL Group Identifier or ACL group element\;For ACL group identifier, range of group id is 0..cap_max_acl_groups-1.\;For ACL group element, range of group element is 0..cap_max_acl_tot_groups-1." access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="sem_op" descr="0: nop - no operation\;1: lock_semaphore\;2: unlock\;Note - Reserved when db_op is remove/remove all or when an EMAD query operation." access="OP" enum="nop=0x0,lock_semaphore=0x1,unlock=0x2" offset="0x4.0" size="0x0.2" />
	<field name="db_op" descr="0: nop\;1: read - reads 64bit value \;2: write_data\;3: remove_entry_with_failure_indication\;4: remove_entry_w/o_failure_indication\;5: remove_all_partition_entries\;\;Note-\;- remove must be set with sem_op = unlock\;- write can&quot;t be set with sem_op = lock\;- when db_op = remove_all (5), only partition_id relevant\;\;Reserved when EMAD query operation.\;\;" access="OP" enum="nop=0x0,read=0x1,write_data=0x2,remove_entry_with_failure_indication=0x3,remove_entry_w_o_failure_indication=0x4,remove_all_partition_entries=0x5" offset="0x4.4" size="0x0.3" />
	<field name="partition_id" descr="Valid values 0..(cap_max_sf_db_parititions-1). \;Indicates to which partition to associate the entry" access="INDEX" offset="0x4.8" size="0x0.3" />
	<field name="fr" descr="Failure Reason\;\;0: db_overflow \;1: max_semaphore_counter \;2: unlock_invalid_entry \;3: remove_invalid_entry \;4: insertion_failure \;5-7: reserved \;\;\;\;\;Reserved when s = success (1) or when db_op = remove all entries (5) or on EMAD query" access="RO" enum="db_overflow=0x0,max_semaphore_counter=0x1,unlock_invalid_entry=0x2,remove_invalid_entry=0x3,insertion_failure=0x4" offset="0x4.16" size="0x0.3" />
	<field name="sem_lock_cnt" descr="counter of retries of semaphore locks, stuck at max value\;\;Reserved when EMAD write operation." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="sem_val" descr="Last semaphore value for the read entry\;0: sem_unlocked\;1: sem_locked\;\;reserved when db_op = remove (3-5)" access="RO" enum="sem_unlocked=0x0,sem_locked=0x1" offset="0x8.24" size="0x0.1" />
	<field name="a" descr="activity bit indication\;0: no_activity\;1: active\;\;Reserved when EMAD write operation.\;\;" access="RO" enum="no_activity=0x0,active=0x1" offset="0x8.25" size="0x0.1" />
	<field name="hit" descr="hit indication\;0: entry_was_not_found_in_db \;1: entry_was_found_in_db \;\;Note- Reserved when db_op is remove all (5).\;" access="RO" enum="entry_was_not_found_in_db=0x0,entry_was_found_in_db=0x1" offset="0x8.26" size="0x0.1" />
	<field name="s" descr="Status bit\;0: operation_failure\;1: operation_success\;\;Reserved when EMAD query operation." access="RO" enum="operation_failure=0x0,operation_success=0x1" offset="0x8.31" size="0x0.1" />
	<field name="data" descr="read/write data\;Reserved when db_op = remove or remove_all" subnode="uint64" access="RW" offset="0x10.0" size="0x8.0" />
	<field name="key_data" descr="ACL Key data as described in Section 11.6.2, &quot;Flex2 ACL Key Blocks Layout&quot;, on page 2635\;The key must be masked according to the ERP (if ERPs exist for the region) or according to master_mask (if no ERPs for the region)" access="INDEX" high_bound="23" low_bound="0" offset="0x18.0" size="0x60.0" />
</node>

<node name="FSFH_ext" descr="" size="0xac.0" >
	<field name="failure_reason" descr="0: db_overflow\;1: max_semaphore_counter\;2: unlock_invalid_entry\;3: remove_invalid_entry\;4: insertion_failure\;5-7: reserved" access="INDEX" enum="db_overflow=0x0,max_semaphore_counter=0x1,unlock_invalid_entry=0x2,remove_invalid_entry=0x3,insertion_failure=0x4" offset="0x0.0" size="0x0.3" />
	<field name="action_info" descr="Action-set to perform when rule is matched.\;See Section 2575, &quot;Flexible Action Set: Supported Actions&quot;, on page 2823.\;Must be zero padded if action set is shorter." subnode="flexible_action_set_ext" access="RW" offset="0x4.0" size="0xa8.0" />
</node>

<node name="FSGCR_ext" descr="" size="0xc.0" >
	<field name="sem_lock_protection_en" descr="Semaphore Lock Counter Protection:\;0: sem_protct_dis - disable semaphore lock protection\;1: sem_protct_en - enable semaphore lock protection. Can trigger FSFH.failure_reason of type &quot;max semaphore counter&quot; in case of num of lock retries violates sem_poll_max_retries.\;\;Can be changed on the fly\;\;" access="RW" enum="sem_protct_dis=0x0,sem_protct_en=0x1" offset="0x0.0" size="0x0.1" />
	<field name="failure_on_invalid_lock" descr="0: ignore_failure - ignore failure on unlocking an invalid entry\;1: treat_failure - Treat unlocking of invalid entry as a failure\;\;Can be changed on the fly" access="RW" enum="ignore_failure=0x0,treat_failure=0x1" offset="0x0.1" size="0x0.1" />
	<field name="sem_poll_max_retries" descr="Polling retry counter\;valid values: 1-255\;\;Can be changed on the fly.\;" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="ticket_cb_index" descr="valid values: 0..(cap_max_custom_byte_sets-1).\;when ticket machine is enabled on rx port, HW is storing ticket info in the specified cb index\;\;Can&apos;t be changed on the fly nor during traffic" access="RW" offset="0x4.16" size="0x0.4" />
	<field name="linear_group_id" descr="For ACL group identifier, range of group id is 0..cap_max_acl_groups-1.\;For ACL group element, range of group element is 0..cap_max_acl_tot_groups-1.\;Used to indicate the group id allocated for the linear key\;" access="RW" offset="0x8.0" size="0x0.16" />
</node>

<node name="FSHE_ext" descr="" size="0x8.0" >
	<field name="op" descr="0: read\;1: read_and_clear" access="OP" enum="read=0x0,read_and_clear=0x1" offset="0x0.0" size="0x0.2" />
	<field name="hw_errors" descr="0: ticket_machine_error\;1-31: reserved" access="RO" enum="ticket_machine_error=0x0" offset="0x4.0" size="0x4.0" />
</node>

<node name="FSPS_ext" descr="" size="0x10.0" >
	<field name="partition_id" descr="partition index\;valid values: 0..(cap_max_sf_db_partitions-1)" access="INDEX" offset="0x0.0" size="0x0.3" />
	<field name="tbw" descr="Trigger by crossing warning threshold" access="RO" offset="0x0.8" size="0x0.1" />
	<field name="tbm" descr="Trigger by crossing max threshold" access="RO" offset="0x0.9" size="0x0.1" />
	<field name="warning_threshold" descr="warning threshold" access="RO" offset="0x4.0" size="0x0.19" />
	<field name="max_threshold" descr="maximum threshold" access="RO" offset="0x8.0" size="0x0.19" />
	<field name="occupancy" descr="entries occupancy gauge\;Returns actual KVD lines count" access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="FSTM_ext" descr="" size="0x414.0" >
	<field name="record_num" descr="number of valid port configuration records" access="OP" offset="0x0.0" size="0x0.9" />
	<field name="port_ticket_info" descr="list of port_ticket_info * 260 which indicates per port whether ticket machine should be enabled or disabled." subnode="fstm_port_ticket_info_ext" access="RW" high_bound="259" low_bound="0" offset="0x4.0" size="0x410.0" />
</node>

<node name="IB_long_portcntrs_attribute_grp_data_ext" descr="" size="0xf8.0" >
	<field name="symbol_error_counter_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="symbol_error_counter_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="link_error_recovery_counter_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="link_error_recovery_counter_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="link_downed_counter_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="link_downed_counter_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="port_rcv_errors_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="port_rcv_errors_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="port_rcv_remote_physical_errors_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="port_rcv_remote_physical_errors_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="port_rcv_switch_relay_errors_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="port_rcv_switch_relay_errors_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="port_xmit_discards_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="port_xmit_discards_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="port_xmit_constraint_errors_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="port_xmit_constraint_errors_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="port_rcv_constraint_errors_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="port_rcv_constraint_errors_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="local_link_integrity_errors_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="local_link_integrity_errors_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="excessive_buffer_overrun_errors_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="excessive_buffer_overrun_errors_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="vl_15_dropped_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="vl_15_dropped_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="port_xmit_data_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="port_xmit_data_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="port_rcv_data_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="port_rcv_data_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="port_xmit_pkts_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x70.0" size="0x4.0" />
	<field name="port_xmit_pkts_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="port_rcv_pkts_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x78.0" size="0x4.0" />
	<field name="port_rcv_pkts_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x7C.0" size="0x4.0" />
	<field name="port_xmit_wait_high" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x80.0" size="0x4.0" />
	<field name="port_xmit_wait_low" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x84.0" size="0x4.0" />
	<field name="qp1_dropped_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x88.0" size="0x4.0" />
	<field name="qp1_dropped_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x8C.0" size="0x4.0" />
	<field name="port_unicast_xmit_pkts_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x90.0" size="0x4.0" />
	<field name="port_unicast_xmit_pkts_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x94.0" size="0x4.0" />
	<field name="port_multicast_xmit_pkts_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x98.0" size="0x4.0" />
	<field name="port_multicast_xmit_pkts_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0x9C.0" size="0x4.0" />
	<field name="port_unicast_rcv_pkts_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0xA0.0" size="0x4.0" />
	<field name="port_unicast_rcv_pkts_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0xA4.0" size="0x4.0" />
	<field name="port_multicast_rcv_pkts_high" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0xA8.0" size="0x4.0" />
	<field name="port_multicast_rcv_pkts_low" descr="For counter description please refer to the InfiniBand specification" access="RO" offset="0xAC.0" size="0x4.0" />
</node>

<node name="IB_portcntrs_attribute_grp_data_ext" descr="" size="0xf8.0" >
	<field name="link_downed_counter" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="link_error_recovery_counter" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="symbol_error_counter" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x0.16" size="0x0.16" />
	<field name="port_rcv_remote_physical_errors" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="port_rcv_errors" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x4.16" size="0x0.16" />
	<field name="port_xmit_discards" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="port_rcv_switch_relay_errors" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x8.16" size="0x0.16" />
	<field name="excessive_buffer_overrun_errors" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0xC.0" size="0x0.4" />
	<field name="local_link_integrity_errors" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0xC.4" size="0x0.4" />
	<field name="port_rcv_constraint_errors" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0xC.16" size="0x0.8" />
	<field name="port_xmit_constraint_errors" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0xC.24" size="0x0.8" />
	<field name="vl_15_dropped" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="qp1_dropped" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x10.16" size="0x0.16" />
	<field name="port_xmit_data" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="port_rcv_data" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="port_xmit_pkts" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="port_rcv_pkts" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="port_xmit_wait" descr="For counter description please refer to the InfiniBand specification\;" access="RO" offset="0x24.0" size="0x4.0" />
</node>

<node name="ITGCR_reg_ext" descr="" size="0x8.0" >
	<field name="l4_validity" descr="0: USE_L4_FROM_L3 - use layer 4 offset as post layer 3 (valid L4 header is not mandatory). Hence, L3 offset + L3 header size.\;1: USE_PARSED_L4 - packet must have a valid (and known) parsed L4 header" access="RW" enum="USE_L4_FROM_L3=0x0,USE_PARSED_L4=0x1" offset="0x0.0" size="0x0.1" />
	<field name="def_masking_size" descr="Default masking size in case of no match\;Units of 1B\;Granularity of 2B\;Min value: 48B\;Max value: 512B" access="RW" offset="0x4.0" size="0x0.10" />
</node>

<node name="ITPR_reg_ext" descr="" size="0x14.0" >
	<field name="trunc_prof" descr="Truncation profile\;Default mapping:\;0..7: Mirror agents profiles\;8: ARN\;9: CNP\;\;12-15: ACL" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="tr_size" descr="truncation size\;Units of 1B\;Granularity of 4B\;Min value: 64B\;\;Note: \;when mode = (2), max size is 512B\;" access="RW" offset="0x4.0" size="0x0.14" />
	<field name="mode" descr="mode:\;0: DISABLE - \;1: STATIC_ONLY - static truncation only\;2: STATIC_AND_MASK - static truncation + parsing based masking\;\;" access="RW" enum="DISABLE=0x0,STATIC_ONLY=0x1,STATIC_AND_MASK=0x2" offset="0x8.0" size="0x0.2" />
	<field name="dd" descr="default disable\;In case packet has no matching header found to at least one of the selected headers in masking_label_en:\;0: USE_DEFAULT_MASKING_SIZE - (ITGCR.def_masking_size)\;1: NO_TRUNC_NO_MASK - no truncation and no masking are applied\;Reserved when mode != (2)" access="RW" enum="USE_DEFAULT_MASKING_SIZE=0x0,NO_TRUNC_NO_MASK=0x1" offset="0x8.8" size="0x0.1" />
	<field name="masking_label_en" descr="Bitmask use the following bitmap headers as base for packet masking:\;0: CB_SET_0\;1: CB_SET_1\;2: PAYLOAD \;3: INNER_L4_HEADER \;4: INNER_L3_HEADER\;5: INNER_L2_HEADER\;6: OUTER_L4_HEADER\;7: OUTER_L3_HEADER\;8: OUTER_L2_HEADER\;\;" access="RW" offset="0xC.0" size="0x0.9" />
	<field name="addition_masking_offset_en" descr="Bitmask defines per label (bitmap) whether addition_masking_offset should be added to the label in case of masking:\;0: CB_SET_0\;1: CB_SET_1\;2: PAYLOAD \;3: INNER_L4_HEADER \;4: INNER_L3_HEADER\;5: INNER_L2_HEADER\;6: OUTER_L4_HEADER\;7: OUTER_L3_HEADER\;8: OUTER_L2_HEADER\;\;Reserved when mode != (2)" access="RW" offset="0x10.0" size="0x0.9" />
	<field name="addition_masking_offset" descr="number of bytes to be added on top of the matching label upon masking is applied\;\;Units of 1B\;Granularity of 2B\;Max value: 512 Bytes\;\;Reserved when mode != (2)" access="RW" offset="0x10.16" size="0x0.9" />
</node>

<node name="MCFS_ext" descr="" size="0x20.0" >
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.12" size="0x0.4" />
	<field name="module" descr="Module number\;Switch: Range 0 .. MGPIR.max_modules_per_slot -1" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="freq" descr="Module Frequency\;0: 400_KHz\;1: 1_MHz\;2: 100_KHz\;3: Reserved" access="RW" offset="0x4.0" size="0x0.2" />
</node>

<node name="MFMI_ext" descr="" size="0x18.0" >
	<field name="fm_state" descr="Specifies the current FM state.\;FM states as follows:\;0: Reserved\;1: Offline\;2: Standby\;3: Configured\;4: Reserved (Timeoout)\;5: Error" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="time_point_last_restart" descr="Epoch timestamp of FM restart, in seconds.\;This value is stable as long FM didn&apos;t restart." subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
	<field name="duration_since_last_restart" descr="Time passed since last restart, in seconds.\;Should be incremented in each report." subnode="uint64" access="RO" offset="0x10.0" size="0x8.0" />
</node>

<node name="MLPC_ext" descr="" size="0x40.0" >
	<field name="lp_msb" descr="port MSB\;Used to identify the L1 controller associated to the desired HW counters." access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="port\;Used to identify the L1 controller associated to the desired HW counters." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="cnt_64bit" descr="Bit mask to configure extended 64 bits long counters.\;Bit per even HW counter. When bit [i] is set, counter[2i] and counter[2i+1] will be used to form a 64-bit counter.\;The odd counter cnt_sel[2i+1], will serve as the selector to configure the 64 bit counter.\;The odd counter cnt_val[2i+1], will serve as the LSB of the counter.\;The even counter cnt_val[2i], will serve as the MSB of the counter." access="RW" offset="0x4.0" size="0x0.4" />
	<field name="stop_at_ff" descr="When set, when one of the perf counters reaches FFs, all the counters will stop counting." access="RW" offset="0x4.29" size="0x0.1" />
	<field name="counter_rst" descr="Force reset for all the counters" access="WO" offset="0x4.30" size="0x0.1" />
	<field name="counter_en" descr="Enable for the HW counters" access="RW" offset="0x4.31" size="0x0.1" />
	<field name="force_count_mask" descr="Force count bit mask, when bit[i] is set, pref_counter&lt;i&gt; will count with no consideration of any enable/reset/stop signals." access="RW" offset="0xC.0" size="0x0.8" />
	<field name="cnt_type" descr="See Table 624, &quot;L1 Performance Counter Type,&quot; on page 956" access="RW" high_bound="7" low_bound="0" offset="0x10.28" size="0x4.0" />
	<field name="cnt_val" descr="HW counter value.\;The counter value can be configured to an initial value before enabling the feature." access="RW" high_bound="7" low_bound="0" offset="0x20.0" size="0x20.0" />
</node>

<node name="MMAM_ext" descr="" size="0x10.0" >
	<field name="module" descr="(Global) Module number\;Switch: Range 0 .. MGPIR.max_modules_per_slot -1\;" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="ga" descr="Geographical Address of the ASIC which controls the module\;\;Reserved when module type is chip2chip or backplane." access="RO" offset="0x4.0" size="0x0.4" />
	<field name="local_module" descr="Local module number" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="module_type" descr="module_type:\;0: Backplane_with_4_lanes\;1: QSFP\;2: SFP\;3: No_Cage\;4: Backplane_with_single_lane\;8: Backplane_with_two_lanes\;10: Chip2Chip4x\;11: Chip2Chip2x\;12: Chip2Chip1x\;14: QSFP_DD\;15: OSFP\;16: SFP_DD\;17: DSFP\;18: Chip2Chip8x\;19: Twisted_Pair\;20: Backplane_with_8_lanes" access="RO" offset="0xC.0" size="0x0.8" />
</node>

<node name="MMCR_ext" descr="" size="0x50.0" >
	<field name="next_module_control" descr="Next Module Control\;bit 0: indication for module 0. \;bit 1: indication for module 1.\;..\;bit 63: indication of module 63.\;\;For each module, \;0: FW controls module\;1: SW controls module\;\;Valid bits: 0 .. (MGPIR.max_modules_per_slot -1)\;Rest of the bits are ignored.\;" access="RW" high_bound="3" low_bound="0" offset="0x0.0" size="0x10.0" />
	<field name="module_control_mask" descr="Module Control Mask\;bit 0: indication for module 0. \;bit 1: indication for module 1.\;..\;bit 63: indication of module 63.\;\;On read:\;FW will return mask = 0xffff from module 0 until (MGPIR.max_modules_per_slot -1)\;\;On write:\;0: ignore module_control\;1: Set according to module_control\;Valid bits: 0 .. (MGPIR.max_modules_per_slot -1)\;Rest of the bits are ignored." access="RW" high_bound="3" low_bound="0" offset="0x20.0" size="0x10.0" />
	<field name="curr_module_control" descr="Current Module Control\;bit 0: indication for module 0. \;bit 1: indication for module 1.\;..\;bit 63: indication of module 63.\;\;For each module, \;0: FW controls module\;1: SW controls module\;\;Valid bits: 0 .. (MGPIR.max_modules_per_slot -1)\;Rest of the bits are ignored.\;" access="RO" high_bound="3" low_bound="0" offset="0x40.0" size="0x10.0" />
</node>

<node name="MOCBR_ext" descr="" size="0xc.0" >
	<field name="e" descr="0: Meter by reference feature is disabled\;1: Meter by reference feature is enabled" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="l" descr="Long index\;0: Use short indexing (only 16bit is taken from cb set LSB)\;1: Use long indexing (16 bit is taken from cb set LSB and additional 3 bits are taken from cb set +1). \;Cbset is defined in COUNTER_BY_REF_PARAM.cbset.\;See Table 2604, &quot;COUNTER_BY_REF_PARAM Block Layout,&quot; on page 2851" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="base_counter_index" descr="Range for flow counters: \;0 .. cap_shared_counter_pool_size - 1\;Range for accuFlow counters: \;cap_start_accuflow .. cap_start_accuflow + cap_max_accuflow - 1\;Used to calculate the desired counter index.\;Counter Index = MOCBR.base_counter_index + (cbset value)" access="RW" offset="0x8.0" size="0x0.24" />
</node>

<node name="MOCBS_ext" descr="" size="0xc.0" >
	<field name="op" descr="Operation.\;0: Read_only \;1: Read_and_Clear_cause" access="OP" enum="Read_only=0x0,Read_and_Clear_cause=0x1" offset="0x0.0" size="0x0.2" />
	<field name="cnt_err" descr="0: No indication of counter Id calculation mismatch\;1: Global Counter Id calculation mismatch indication" access="RO" offset="0x4.0" size="0x0.1" />
</node>

<node name="MOFTC_bitmap512_ext" descr="" size="0x88.0" >
	<field name="port_bitmask" descr="Port bitmask request\;Port0 (bit0, cpu port) is reserved\;Service ports are allowed.\;8x ports are not allowed." access="RW" high_bound="15" low_bound="0" offset="0x0.0" size="0x40.0" />
	<field name="port_bitmask_actual" descr="prio bitmask actual\;FW may choose to provide more ports than requested.\;FW will not choose to provide more TC/PG/Prio than. requested" access="RO" high_bound="15" low_bound="0" offset="0x40.0" size="0x40.0" />
</node>

<node name="MOFTC_bitmap544_ext" descr="" size="0x88.0" >
	<field name="port_bitmask" descr="Port bitmask request\;Port0 (bit0, cpu port) is reserved\;Service ports are allowed.\;8x ports are not allowed." access="RW" high_bound="16" low_bound="0" offset="0x0.0" size="0x44.0" />
	<field name="port_bitmask_actual" descr="prio bitmask actual\;FW may choose to provide more ports than requested.\;FW will not choose to provide more TC/PG/Prio than. requested" access="RO" high_bound="16" low_bound="0" offset="0x44.0" size="0x44.0" />
</node>

<node name="MOFTC_ext" descr="" size="0x108.0" >
	<field name="clear_mbo" descr="Clear Max Buff Occupancy\;Will clear the max_buff_occup, will not clear counters. \;Applies for the Traffic classes enabled by tc_bitmask.\;Values:\;0: not_clear\;1: clear" access="RW" enum="not_clear=0x0,clear=0x1" offset="0x0.31" size="0x0.1" />
	<field name="prio_bitmask" descr="Priority bitmask" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="tc_bitmask" descr="Traffic Class bitmask" access="RW" offset="0x8.0" size="0x0.17" />
	<field name="pg_bitmask" descr="PG bitmask" access="RW" offset="0xC.0" size="0x0.9" />
	<field name="metadata_bitmask" descr="For each bit, see definition in the sample, see Table , &quot;,&quot; on page 1138" access="RW" offset="0x10.0" size="0x4.0" />
	<field name="global_counters_bitmask" descr="For each bit, see definition in the sample see Table , &quot;,&quot; on page 1138" access="RW" offset="0x18.0" size="0x4.0" />
	<field name="port_counters_bitmask" descr="For each bit, see definition in the sample see Table , &quot;,&quot; on page 1138" subnode="uint64" access="RW" offset="0x20.0" size="0x8.0" />
	<field name="flow_counter_base_0" descr="Base of the flow counters to read. Set 0\;Range 0.. cap_shared_counter_pool_size-2" access="RW" offset="0x30.0" size="0x0.24" />
	<field name="flow_counter_num_0" descr="Number of consecutive counters to read. Set 0" access="RW" offset="0x34.0" size="0x0.16" />
	<field name="flow_counter_base_1" descr="Base of the flow counters to read. Set 1\;Range 0.. cap_shared_counter_pool_size-2" access="RW" offset="0x38.0" size="0x0.24" />
	<field name="flow_counter_num_1" descr="Number of consecutive counters to read. Set 1" access="RW" offset="0x3C.0" size="0x0.16" />
	<field name="bitmap_size" descr="0: BITMAP_512\;1: BITMAP_544" access="OP" enum="BITMAP_512=0x0,BITMAP_544=0x1" offset="0x7C.0" size="0x0.4" />
	<field name="port_bitmask" descr="See Table 1129, &quot;MOFTC - 512 Port Bitmap Layout,&quot; on page 1372\;See Table 1131, &quot;MOFTC - 544 Port Bitmap Layout,&quot; on page 1372" subnode="MOFTC_port_bitmask_auto_ext" access="RW" offset="0x80.0" size="0x88.0" union_selector="$(parent).bitmap_size" />
</node>

<node name="MOFTC_port_bitmask_auto_ext" descr="" attr_is_union="1" size="0x88.0" >
	<field name="MOFTC_bitmap512_ext" descr="" subnode="MOFTC_bitmap512_ext" offset="0x0.0" selected_by="BITMAP_512" size="0x88.0" />
	<field name="MOFTC_bitmap544_ext" descr="" subnode="MOFTC_bitmap544_ext" offset="0x0.0" selected_by="BITMAP_544" size="0x88.0" />
</node>

<node name="MOFTD_ext" descr="" size="0x24.0" >
	<field name="num_rec" descr="number of records (entries) in this register. \;Entry is 32bit.\;" access="RO" offset="0x0.0" size="0x0.12" />
	<field name="itr_index" descr="Iteration counter value" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="num_entries_in_itr" descr="num_of_entries in an iteration" access="RO" offset="0x8.0" size="0x0.20" />
	<field name="entry_index" descr="Index of the first entry in this chunk (MOFTD)\;Example:\;num_entries_in_itr=20,000:\;1st chunk (MOFTD) had 9000 entries, entry_index=0\;2nd chunk (MOFTD) has 9000 entries, entry_index=9000\;3rd chunk (MOFTD) has 2000 entries, entry_index=18,000" access="RO" offset="0xC.0" size="0x0.20" />
	<field name="num_entries_per_port" descr="Number of entries per port (entry is 32bit)\;If there are no ports then value is 0" access="RO" offset="0x10.0" size="0x0.12" />
	<field name="first_port_in_chunk" descr="First port in this chunk (in this MOFTD)\;Reserved when num_entries_per_port = 0" access="RO" offset="0x10.16" size="0x0.10" />
	<field name="user_cookie" descr="Cookie from MOCS" subnode="uint64" access="RO" offset="0x18.0" size="0x8.0" />
	<field name="entry" descr="Entries from the sample.\;See Table 882, &quot;HFT Sample,&quot; on page 1138" access="RO" arr_is_dynamic="1" high_bound="VARIABLE" low_bound="0" offset="0x20.0" size="0x4.0" size_condition="$(parent).num_rec" />
</node>

<node name="MRFV_CVB_ext" descr="" size="0x4.0" >
	<field name="cvb_voltage" descr="CVB Voltage\;Returns required CVB voltage in mV.\;" access="RO" offset="0x0.0" size="0x0.10" />
</node>

<node name="MRFV_PVS_MAIN_ext" descr="" size="0x4.0" >
	<field name="pvs_main_data" descr="PVS Data\;Range 0.675 - 0.75\;Vdd = 750mV - (fuse value - 1)*5mV" access="RO" offset="0x0.0" size="0x0.5" />
</node>

<node name="MRFV_PVS_TILE_ext" descr="" size="0x4.0" >
	<field name="pvs_tile_data" descr="PVS tile Data\;Range 0.675 - 0.72\;Vdd = 750mV - (fuse value - 1)*5mV" access="RO" offset="0x0.0" size="0x0.5" />
</node>

<node name="MRFV_ULT_ext" descr="" size="0xc.0" >
	<field name="ult_lot_digit_1" descr="" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="ult_lot_digit_2" descr="" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="ult_lot_digit_3" descr="" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="ult_lot_digit_4" descr="" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="ult_lot_digit_5" descr="" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="ult_lot_digit_6" descr="" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="ult_lot_digit_7" descr="" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="ult_lot_digit_8" descr="" access="RO" offset="0x4.24" size="0x0.8" />
	<field name="ult_y" descr="" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="ult_x" descr="" access="RO" offset="0x8.8" size="0x0.8" />
	<field name="ult_wafer_number" descr="" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="ult_err_detection" descr="" access="RO" offset="0x8.29" size="0x0.3" />
</node>

<node name="MRFV_data_auto_ext" descr="" attr_is_union="1" size="0xc.0" >
	<field name="MRFV_CVB_ext" descr="" subnode="MRFV_CVB_ext" offset="0x0.0" selected_by="cvb" size="0x4.0" />
	<field name="MRFV_ULT_ext" descr="" subnode="MRFV_ULT_ext" offset="0x0.0" selected_by="ULT" size="0xc.0" />
	<field name="MRFV_PVS_MAIN_ext" descr="" subnode="MRFV_PVS_MAIN_ext" offset="0x0.0" selected_by="pvs_main_die" size="0x4.0" />
	<field name="MRFV_PVS_TILE_ext" descr="" subnode="MRFV_PVS_TILE_ext" offset="0x0.0" selected_by="pvs_tile_0" size="0x4.0" />
</node>

<node name="MRFV_ext" descr="" size="0x40.0" >
	<field name="fuse_id" descr="Fuse Index\;0: cvb - CVB Main Die, used for Retimer\;1: ULT - used for Retimer\;2: pvs_main_die - (used for SPC-4)\;3: pvs_tile_0 - (used for SPC-4)\;4: pvs_tile_1 - (used for SPC-4)\;5: pvs_tile_2 - (used for SPC-4)\;6: pvs_tile_3 - (used for SPC-4)\;7: pvs_tile_4 - (used for SPC-4)\;8: pvs_tile_5 - (used for SPC-4)\;9: pvs_tile_6 - (used for SPC-4)\;10: pvs_tile_7 - (used for SPC-4)\;Other values reserved\;Reserved when fm = 1" access="INDEX" enum="cvb=0x0,ULT=0x1,pvs_main_die=0x2,pvs_tile_0=0x3,pvs_tile_1=0x4,pvs_tile_2=0x5,pvs_tile_3=0x6,pvs_tile_4=0x7,pvs_tile_5=0x8,pvs_tile_6=0x9,pvs_tile_7=0xa" offset="0x0.0" size="0x0.8" />
	<field name="fm" descr="Fuse Mismatch\;0: No fuse mismatch\;1: Fuse mismatch found\;2-3: Reserved" access="RO" offset="0x0.24" size="0x0.2" />
	<field name="v" descr="Valid bit\;0: Fuse reading is not supported for this system\;1: Response is valid\;2-3: Reserved\;Reserved when fm = 1" access="RO" offset="0x0.30" size="0x0.2" />
	<field name="data" descr="Data\;See Table 730, &quot;MRFV entry - CVB Layout,&quot; on page 1033\;See Table 732, &quot;MRFV entry - ULT Layout,&quot; on page 1034\;See Table 734, &quot;MRFV entry - PVS_MAIN Layout,&quot; on page 1035\;See Table 736, &quot;MRFV entry - PVS_Tile Layout,&quot; on page 1036\;Reserved when fm = 1" subnode="MRFV_data_auto_ext" access="RO" offset="0x10.0" size="0xc.0" union_selector="$(parent).fuse_id" />
</node>

<node name="MSECQ_reg_ext" descr="" size="0x40.0" >
	<field name="local_enhanced_ssm_code" descr="The enhanced SSM code to be delivered when on holdover." access="RO" offset="0x4.0" size="0x0.8" />
	<field name="local_ssm_code" descr="The SSM code to be delivered when on holdover." access="RO" offset="0x4.8" size="0x0.4" />
	<field name="network_option" descr="The network option of this device (as defined in ITU-T G.781).\;1: Network option 1\;2: Network option 2" access="RO" offset="0x4.12" size="0x0.2" />
	<field name="local_clock_identity" descr="The SyncE clock identity of the device." subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
</node>

<node name="MSEES_reg_ext" descr="" size="0x40.0" >
	<field name="lp_msb" descr="2-bit expansion of the local port. Represents the local_port[9:8] bits" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type, determines the way local_port is interpreted:\;0: Local port number\;1: Label port number\;3: Out of band or PCI" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number\;Not supported for CPU port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="field_select" descr="Field select indicates which fields to modify in write operation to this register. \;Bit 0: enable field_select\;Bit 1: admin_status\;Bit 2: admin_freq_measure\;Bits 3-31: Reserved" access="WO" offset="0x4.0" size="0x4.0" />
	<field name="failure_reason" descr="0: undefined error \;1: port down\;2: too high frequency_diff\;3: network synchronizer device error\;4: lack of resources for tracking \;5-255: reserved for future use \;\;Note: Reserved when oper_status is different than 4" access="RO" offset="0x8.0" size="0x0.9" />
	<field name="oper_freq_measure" descr="0: frequency_diff field is not valid\;1: frequency_diff field is valid" access="RO" offset="0x8.9" size="0x0.1" />
	<field name="admin_freq_measure" descr="0: don&apos;t measure frequency_diff\;1: measure frequency_diff" access="RW" offset="0x8.10" size="0x0.1" />
	<field name="ho_acq" descr="Holdover acquired.\;0: The device does not have enough data to go into holdover.\;1: The device has enough data to go into holdover." access="RO" offset="0x8.23" size="0x0.1" />
	<field name="oper_status" descr="0: free running - the device is using internal oscillator as timing source \;1: self track - the device is in sync with this timing source\;2: other track - the device is in sync with other timing source\;3: holdover - the device is using the internal oscillator and past information as a timing source.\;4: Holdover due to failure (see field failure_reason)\;5: Free running due to failure (see field failure_reason)." access="RO" offset="0x8.24" size="0x0.4" />
	<field name="admin_status" descr="0: holdover/free running - the device will use internal oscillator as timing source. \;Free running is the default value.\;Device holdover / free running will take place only if admin status = 0 across all other ports.\;1: track - the device will sync to this timing source. When writing admin status = 1 to a port, all other ports will move to admin status = 0." access="RW" offset="0x8.28" size="0x0.4" />
	<field name="frequency_diff" descr="The FFO (Fractional Frequency Offset) between the rx and tx symbol rate: (rx_frequency- tx_frequency) /rx_frequency.\;Value is in ppt (2&apos;s complement).\;Any value larger than 0x7FFFFFFF represented as 0x7FFFFFFF. \;Any value smaller than 0x80000000 represented as 0x80000000.\;\;Note: Reserved when oper_freq is different than &apos;1&apos;." access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="MSPI_ext" descr="" size="0x18.0" >
	<field name="vendor_id" descr="Vendor Id:\;0: Renesas\;1: SiTime 148\;2: SiTime 348\;3: TI\;4-15: Reserved\;Reserved when synce_support = 0" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="clk_dev" descr="Clock Device\;Valid values 0/1\;Supported for SPC-4 only\;" access="INDEX" offset="0x0.16" size="0x0.2" />
	<field name="synce_support" descr="SyncE Support:\;0: SyncE is not supported by FW\;1: SyncE is supported by FW" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="config_version_id" descr="Configuration version id\;\;Reserved when synce_support = 0" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="bcc" descr="burned configuration count\;Counts how many times the configuration was burned to the clock sync&apos; device. Non cleared counter \;\;Reserved when synce_support = 0" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="obs_temperature" descr="On Board Sensor Temperature \;Units of 0.125 Celsius degrees.\;For negative values 2&apos;s complement is used (for example: -\;3.25 Celsius will read as 0xFFE6)" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="obtv" descr="On Board Temperature validity\;0: temperature data is not valid\;1: temperature data is valid" access="RO" offset="0x10.31" size="0x0.1" />
	<field name="bis_temperature" descr="Built In Sensor Temperature \;Units of 0.125 Celsius degrees.\;For negative values 2&apos;s complement is used (for example: -\;3.25 Celsius will read as 0xFFE6)" access="RO" offset="0x14.0" size="0x0.16" />
	<field name="bitv" descr="Built In OCXO sensor Temperature validity\;0: temperature data is not valid\;1: temperature data is valid\;" access="RO" offset="0x14.31" size="0x0.1" />
</node>

<node name="PPCR_ext" descr="" size="0x10.0" >
	<field name="lp_msb" descr="Local port[9:8]\;Reserved for HCA" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number.\;" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="aggregated_port" descr="Aggregated Port number to be reflected in MAD.\;0 means N/A\;\;Reserved for HCA" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="plane" descr="Plane number to be reflected in MAD.\;0 means N/A\;\;Reserved for HCA" access="RW" offset="0x8.16" size="0x0.3" />
	<field name="split" descr="When planarized  the FW shall respond to Hierarchy Info.Split with the following split value.\;\;In this use case it represents the split of the APort.\;\;When split = 0, the FW shall send Hierarchy Info without the split field. (meaning it is NA)\;\;When Non planarized (num_of_planes = 0), Hierarchy Info.Split will reflect the actual split value, when 2X- it&apos;ll hold the location within the 4x.\;\;0: NA\;1: Split 1.\;2: Split 2.\;3-7: Reserved\;Reserved for HCA" access="RW" offset="0x8.24" size="0x0.3" />
	<field name="num_of_planes" descr="The number of planes comprising this Aggregated port\;" access="RW" offset="0xC.0" size="0x0.8" />
	<field name="p_type" descr="[DWIP]\;Planarization Type\;0: non planarized\;1: planirized_gen1\;2-7: Reserved" access="RW" offset="0xC.16" size="0x0.3" />
</node>

<node name="PPIR_ext" descr="" size="0x8.0" >
	<field name="lcnf_pln" descr="Last Core Negotiation Failed due to Planarized.\;When there is no match between local and remote fields compared to local config by PPCR\;" access="RO" offset="0x0.0" size="0x0.1" />
	<field name="lpnf_phy" descr="Last Phy Negotiation Failed due to Phy\;No partner detected for a long period" access="RO" offset="0x0.8" size="0x0.1" />
	<field name="lpnf_no_hcd" descr="Last Phy Negotiation Failed due to Highest Common Denominator mismatch.\;" access="RO" offset="0x0.9" size="0x0.1" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="peer_num_of_planes" descr="The number of planes comprising the peer Aggregated port\;" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="peer_p_type" descr="Peer Planarization Type\;0: non planarized\;1: planirized_gen1\;2-7: Reserved" access="RO" offset="0x4.16" size="0x0.3" />
</node>

<node name="SF_PAGE_DUMP_MODE_0_ext" descr="" size="0x50.0" >
	<field name="key_54B" descr="See Table 2253, &quot;Flex2 Key 54B Layout,&quot; on page 2636" subnode="flex2_key_54b_ext" access="RO" offset="0x0.0" size="0x38.0" />
	<field name="a" descr="Activity bit\;0: inactive\;1: active" access="RO" enum="inactive=0x0,active=0x1" offset="0x38.16" size="0x0.1" />
	<field name="sem_s" descr="semaphore state\;0: unlocked\;1: locked" access="RO" enum="unlocked=0x0,locked=0x1" offset="0x38.19" size="0x0.1" />
	<field name="partition" descr="Partition id" access="RO" offset="0x38.20" size="0x0.3" />
	<field name="key_size" descr="3: key_size_54_bytes" access="RO" enum="key_size_54_bytes=0x3" offset="0x38.28" size="0x0.2" />
	<field name="valid" descr="0: page_not_valid\;1: page_valid" access="RO" enum="page_not_valid=0x0,page_valid=0x1" offset="0x38.31" size="0x0.1" />
	<field name="data" descr="" subnode="uint64" access="RO" offset="0x40.0" size="0x8.0" />
	<field name="region_id" descr="region id" access="RO" offset="0x48.0" size="0x0.16" />
	<field name="sem_count" descr="semaphore count" access="RO" offset="0x48.16" size="0x0.16" />
</node>

<node name="SF_PAGE_DUMP_MODE_1_RECORD_ext" descr="" size="0x28.0" >
	<field name="key_18B" descr="See Table 2257, &quot;Flex2 Key 18B Layout,&quot; on page 2639" subnode="flex2_key_18b_ext" access="RO" offset="0x0.0" size="0x14.0" />
	<field name="a" descr="activity bit\;0: inactive\;1: active\;\;Reserved when valid = 0" access="RW" offset="0x14.16" size="0x0.1" />
	<field name="sem_s" descr="Semaphore state\;0: unlocked\;1: locked" access="RO" offset="0x14.19" size="0x0.1" />
	<field name="partition" descr="Partition id" access="RO" offset="0x14.20" size="0x0.3" />
	<field name="key_size" descr="0: key_size_9_bytes\;1: key_size_18_bytes" access="RO" enum="key_size_9_bytes=0x0,key_size_18_bytes=0x1" offset="0x14.28" size="0x0.2" />
	<field name="valid" descr="0: record is not valid\;1: record is valid" access="RO" offset="0x14.31" size="0x0.1" />
	<field name="data" descr="" subnode="uint64" access="RO" offset="0x18.0" size="0x8.0" />
	<field name="region_id" descr="region id" access="RO" offset="0x20.0" size="0x0.16" />
	<field name="sem_count" descr="semaphore count" access="RO" offset="0x20.16" size="0x0.16" />
</node>

<node name="SF_PAGE_DUMP_MODE_1_ext" descr="" size="0x50.0" >
	<field name="record" descr="See Table 3407, &quot;SF Record Type 1 Layout,&quot; on page 3660" subnode="SF_PAGE_DUMP_MODE_1_RECORD_ext" access="RO" high_bound="1" low_bound="0" offset="0x0.0" size="0x50.0" />
</node>

<node name="SLCRV2_ext" descr="" size="0x50.0" >
	<field name="type" descr="Hash type\;0: CRC (default)\;1: XOR \;2: Random\;3: CRC2, For Spectrum-2 and on\;\; \;" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="sh" descr="0: Disabled\;1: Symmetric hash \;When set, the hash calculation will result in the same hash value as when the source address (layer 2 and layer 3) is swapped. This ensures that the same conversions will result in the same hash value.\;Note: When this bit is set, enabling addresses in outer_header_fields_enables and inner_header_fields_enables\;For SwitchX/-2 must be in couples - both source and destination. This includes the following sets:\;- SMAC, DMAC\;- SIP, DIP\;- TCP/UDP source port, TCP/UDP destination port\;- SID, DID, for SwitchX/-2 only\;\;\;" access="RW" offset="0x0.8" size="0x0.2" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Ingress Local port number\;Supported from CPU port\;Not supported from router port\;Reserved when pp = Global Configuration" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="pp" descr="Per Port Configuration\;0: Global Configuration (for all ports)\;1: Per port configuration, based on local_port field.\;Note: SW must not read as global if last write was not global." access="INDEX" offset="0x0.24" size="0x0.1" />
	<field name="seed" descr="LAG seed value\;The seed is the same for all ports (latest configuration configures the seed for all ports)." access="RW" offset="0x8.0" size="0x4.0" />
	<field name="general_fields" descr="This is a bit mask, in which each bit enables a specific field to be included in the hash calculation. \;Bit 0: Ingress port\;Bit 1: custom_bytes are set by cbsets field.\;Bit i: custom_bytes i-2\;i = 2 .. 2 + (cap_max_custom_byte_sets_for_hash * cap_custom_byte_entry_size - 1). Reserved when Bit1 = 1.\;See Section 11.3.14, &quot;Custom Bytes&quot;, on page 2513" access="RW" offset="0xC.0" size="0x4.0" />
	<field name="outer_header_enables" descr="Outer header enables. Each bit enables a specific layer field to be included in the hash calculation. Layers that are not listed below are enabled by default.\;Bit 0: Enable Layer2 fields if packet is not IPv4/6\;Bit 1: Enable Layer2 fields if packet is IPv4\;Bit 2: Enable Layer2 fields if packet is IPv6\;Bit 3: Enable IPv4 fields if packet is not TCP and not UDP\;Bit 4: Enable IPv4 fields if packet is either TCP or UDP\;Bit 5: Enable IPv6 fields if packet is not TCP and not UDP\;Bit 6: Enable IPv6 fields if packet is either TCP or UDP\;Bit 7: Enable TCP/UDP header fields if packet is IPv4\;Bit 8: Enable TCP/UDP header fields if packet is IPv6" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="outer_header_fields_enable" descr="Layer2 fields, subject to outer_header_enables:\;Bit 0: SMAC\;Bit 1: DMAC\;Bit 2: Ethertype\;Bit 3: Outer VID\;Bit 4: Outer PCP\;Bit 5: Outer DEI\;Bit 6: Inner VID\;Bit 7: Inner PCP\;Bit 8: Inner DEI\;\;IPv4 fields, subject to outer_header_enables:\;Bits 12:9: IPv4 SIP 0-3 enable per byte. For ARP all bytes are used\;Bits 16:13: IPv4 DIP 0-3 enable per byte. For ARP all bytes are used\;Bit 17: IPv4 Protocol\;Bit 18: IPv4 DSCP\;Bit 19: IPv4 ECN\;Bit 20: IPv4 IP L3 Length - length field bits [13:10]\;\;IPv6 fields, subject to outer_header_enables:\;Bits 21: IPv6 enable bytes of SIP 0-7. For ARP all bytes are used\;Bits 28:22 reserved\;Bits 36:29: IPv6 SIP 8-15 enable per byte. For ARP all bytes are used\;Bits 37: IPv6 enable bytes of DIP 0-7. For ARP all bytes are used\;Bits 44:38 reserved\;Bits 52:45: IPv6 DIP 8-15 enable per byte. For ARP all bytes are used\;Bit 53: IPv6 Next Header\;Bit 54: IPv6 DSCP\;Bit 55: IPv6 ECN\;Bit 56: IPv6 IP L3 Length - length field bits [13:10]\;Bit 57: IPv6 Flow label\;\;" access="RW" high_bound="4" low_bound="0" offset="0x14.0" size="0x14.0" />
	<field name="inner_header_enables" descr="Inner header enables. Each bit enables a specific layer field to be included in the hash calculation. Layers that are not listed below are enabled by default.\;Bit 0: Enable inner Layer2 fields if inner packet is not IPv4/6\;Bit 1: Enable inner Layer2 fields if inner packet is IPv4\;Bit 2: Enable inner Layer2 fields if inner packet is IPv6\;Bit 3: Enable inner IPv4 fields if inner packet is not TCP and not UDP\;Bit 4: Enable inner IPv4 fields if inner packet is either TCP or UDP\;Bit 5: Enable inner IPv6 fields if inner packet is not TCP and not UDP\;Bit 6: Enable inner IPv6 fields if inner packet is either TCP or UDP\;Bit 7: Enable inner TCP/UDP header fields if inner packet is IPv4\;Bit 8: Enable inner TCP/UDP header fields if inner packet is IPv6\;others: reserved" access="RW" offset="0x2C.0" size="0x0.16" />
	<field name="inner_header_fields_enable" descr="Inner header fields enable.\;\;Inner Layer2 fields, subject to inner_header_enables:\;Bit 0: SMAC\;Bit 1: DMAC\;Bit 2: Ethertype\;\;Inner IPv4 fields, subject to inner_header_enables:\;Bits 6:3: IPv4 SIP 0-3 enable per byte\;Bits 10:7: IPv4 DIP 0- 3 enable per byte\;Bit 11: IPv4 Protocol\;\;Inner IPv6 fields, subject to inner_header_enables:\;Bits 12: IPv6 enable bytes of SIP 0-7\;Bits 19:13 reserved\;Bits 27:20: IPv6 SIP 8-15 enable per byte\;Bits 28: IPv6 enable bytes of DIP 0-7\;Bits 35:29 reserved\;Bits 43:36: IPv6 DIP 8-15 enable per byte\;Bit 44: IPv6 Next Header\;Bit 45: IPv6 Flow label\;\;Inner TCP /UDP header fields, subject to inner_header_enables:\;Bit 46: TCP/UDP source port\;Bit 47: TCP/UDP destination port\;others: reserved" subnode="uint64" access="RW" offset="0x30.0" size="0x8.0" />
	<field name="cbsets" descr="Custom Byte Sets.\;For more details refer to Table 1396, &quot;cbsets Layout&quot;.\;Reserved when general_fields.Bit1 = 0.\;Reserved when Spectrum\;Indices are up to cap_max_custom_byte_sets_for_hash-1" access="RW" high_bound="3" low_bound="0" offset="0x40.0" size="0x10.0" />
</node>

<node name="access_reg_summary_ctrl_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="id" descr="" subnode="enum_entry" enum="HGCR=0x7000,HCAP=0x7001,HPKT=0x7003,HTGT=0x7002,HOPF=0x7081,HMCB=0x7082,HMON=0x7084,HRWC=0x7088,HCTR=0x7083,HTAC=0x7085,HCOT=0x7087,HRDQT=0x7022,HTACG=0x7023,HTEC=0x7092,HTCR=0x7093,HCPNC=0x7096,HUKT=0x7094,HETT=0x7089,HCCR=0x7095,HTHM=0x7091,MPEIN=0x9050,MPCNT=0x9051,MPIR=0x9059,MPECS=0x905b,MLCR=0x902b,MGCR=0x903a,MJTAG=0x901f,MFM=0x901d,MHSR=0x901e,MTPPS=0x9053,MTUTC=0x9055,MTPPST=0x9057,MSECQ=0x9155,MSEES=0x9156,MSPI=0x9029,MCIA=0x9014,MCION=0x9052,MCFS=0x9165,PMAOS=0x5012,PMTM=0x5067,PMPC=0x501f,PMPE=0x5024,MDDT=0x9160,MDDQ=0x9161,MDDC=0x9163,MGPIR=0x9100,MDRCR=0x9102,MDFCR=0x9101,MTCAP=0x9009,MTECR=0x9109,MTMP=0x900a,MTWE=0x900b,MTEWE=0x910b,MTBR=0x900f,MVCAP=0x902e,MVCR=0x900c,MSPS=0x900d,MCPP=0x900e,MPSCR=0x910f,MLPC=0x9166,MPPCR=0x9173,MPPGCR=0x9174,MPPGS=0x9175,MPPGH=0x9176,MPPDR=0x9177,MRSR=0x9023,MBTR=0x9077,MCQS=0x9060,MCQI=0x9061,MCC=0x9062,MCDA=0x9063,MCDD=0x905c,MIRC=0x9162,MQIS=0x9064,MGIR=0x9020,MSGI=0x9021,MCGI=0x917c,MSCI=0x902a,MDIR=0x911a,MSSIR=0x9105,MINI=0x905e,MCAM=0x907f,MECCC=0x905f,MMAM=0x9170,MFMI=0x9078,MRFV=0x906d,MBCT=0x9120,MRCS=0x9151,MDSR=0x9110,MFSV=0x9115,MTCQ=0x9065,MQDIK=0x9116,MKDC=0x9066,MSPMER=0x9070,MFCDR=0x9178,MSGCR=0x9179,MNVDA=0x9024,MNVDI=0x9025,MNVQC=0x9030,MNVIA=0x9033,MNVGC=0x9034,MTRC_CAP=0x9040,MTRC_CONF=0x9041,MTRC_STDB=0x9042,MTRC_STDB_V2=0x9210,MTRC_STDB_V3=0x9211,MTRC_CTRL=0x9043,MTEIM=0x9118,MTIE=0x911b,MTIM=0x911c,MTDC=0x911d,MFPA=0x9010,MFBA=0x9011,MFBE=0x9012,MFMC=0x9013,MFCR=0x9001,MFSC=0x9002,MFSM=0x9003,MFSL=0x9004,FORE=0x9007,MFNR=0x903b,MPCIR=0x905a,MERR=0x903c,MRPR=0x9117,MDCR=0x9111,MHMPR=0x905d,MFRC=0x9069,MMCR=0x906c,MFRI=0x906b,MFRP=0x906a,MOGCR=0x9086,MPRS=0x9083,MDRI=0x9084,MRRR=0x9087,MONI=0x90f4,MOLP=0x90f9,MFBD=0x90fb,MMGCR=0x90e9,MPAT=0x901a,MPAR=0x901b,MPAGR=0x9089,MOMTE=0x908d,MOCMI=0x9098,MOTRM=0x9402,MPSC=0x9080,MGPC=0x9081,MGPCB=0x9096,MOCS=0x9095,MAFCR=0x908a,MAFTI=0x908b,MAFRI=0x908c,MAFBI=0x9097,MOCA=0x90e3,MOFPH=0x90e4,MOFPC=0x90e5,MOFRB=0x90e6,MOCBR=0x90e7,MOCBS=0x90e8,MOFTC=0x9400,MOFTD=0x9401,MTPPPC=0x9090,MTPPTR=0x9091,MTPTPT=0x9092,MTPCPC=0x9093,MTPSPU=0x9094,MODCR=0x9099,MORD=0x9153,SGCR=0x2000,SPAD=0x2002,SFDAT=0x2009,SFD=0x200a,SFD_V2=0x201a,SFN=0x200b,SFDD=0x2024,SFDB=0x2028,SFDB_V2=0x202d,SPGT=0x200c,SMID=0x2007,SMID_V2=0x2034,SMPU=0x2006,SSPR=0x2008,SPMS=0x200d,SPMS_V2=0x2032,SPVID=0x200e,SPEVET=0x202a,SPVTR=0x201d,SPVM=0x200f,SPAFT=0x2010,SFGC=0x2011,SFTR=0x2012,SFTR_V2=0x202f,SVFA=0x201c,SFDF=0x2013,SLDR=0x2014,SLMT=0x2037,SLCR=0x2015,SLCR_V2=0x2021,SFDT=0x2022,SFDT_V2=0x202e,SLCOR=0x2016,SLECR=0x2017,SPVMLR=0x2020,SVPE=0x201e,SFMR=0x201f,SVER=0x2025,SPVC=0x2026,SPFSR=0x2023,SFFP=0x2029,SMPE=0x202b,SMPEB=0x202c,SMHT=0x2035,SVPCN=0x2036,PCAM=0x507f,PCAP=0x5001,PTYS=0x5004,PAOS=0x5006,PLTC=0x5046,PPCNT=0x5008,PUDE=0x5009,PTSE=0x5047,PIPG=0x5017,PGMR=0x5039,PTER=0x5055,PREI=0x5058,PMLP=0x5002,PMPR=0x5013,PMTDB=0x501a,PMECR=0x501b,PMLPE=0x501c,PMSC=0x501d,PMMP=0x5044,PMCR=0x5045,PEPC=0x5056,PMPT=0x5064,PMPD=0x5065,PPSC=0x5011,PRTL=0x5014,PPLR=0x5018,PEIR=0x5019,PPLM=0x5023,SLTP=0x5027,SLTPv2=0x502f,SLRG=0x5028,PDDR=0x5031,PPTT=0x5036,PPRT=0x5037,PPHCR=0x503e,PPAOS=0x5040,PCNR=0x5050,PPBMP=0x5051,PPBMC=0x5052,PPBME=0x5053,SLRED=0x505a,PEMI=0x506e,PBGCR=0x5100,PMTU=0x5003,PPAD=0x5005,PFCC=0x5007,PPTB=0x500b,PBMC=0x500c,PSPA=0x500d,PGUID=0x5066,PVLC=0x500f,PLBF=0x5015,PIFR=0x5016,PIFR_V2=0x50e0,PHBR=0x5034,PHRR=0x5035,PBSR=0x5038,PCMR=0x5041,PFSC=0x5043,PLLP=0x504a,PPCR=0x504c,PPIR=0x50eb,PRTSR=0x5402,PLDT=0x504d,PLDC=0x504e,PLIB=0x500a,PLIBDB=0x50e1,PPSLC=0x50e2,PPSLS=0x50e3,PPSLD=0x50e4,PPSPI=0x50ed,PPSPGC=0x50ef,PPSPC=0x50ee,PBWC=0x50e7,PBWR=0x50e8,IGCR=0x3801,IDDD=0x3802,IDDDS=0x3803,IEDR=0x3804,IEDS=0x3805,IFBO=0x3810,IICR=0x3811,IPAC=0x3812,IPSR=0x3815,IPER=0x3816,IHSR=0x3813,IHSCR=0x3814,ICSR=0x38f0,IRQR=0x3870,ICAM=0x387f,ITPR=0x3820,ITGCR=0x3821,IPCR=0x3823,IPFR=0x3824,SPZR=0x6002,IBFMR=0x6003,IBFMRC=0x6004,IBSNI=0x6005,IBISSU=0x6006,SBGCR=0xb000,SBPR=0xb001,SBCM=0xb002,SBPM=0xb003,SBMM=0xb004,SBME=0xb00e,SBSR=0xb005,SBSRD=0xb015,SBIB=0xb006,SBDCC=0xb007,SBDCM=0xb008,SBDCR=0xb019,SBHBR=0xb00a,SBHRR=0xb00b,SBHBR_V2=0xb011,SBHRR_V2=0xb012,SBCTC=0xb00c,SBCTR=0xb00d,SBCTS=0xb00f,SBHPC=0xb013,SBSNT=0xb020,SBSNS=0xb021,SBSNTE=0xb022,SBCAM=0xb01f,MPGCR=0x8801,MPILM=0x8802,MPIBE=0x8803,MPNHLFE=0x8804,MPNHLFEB=0x8805,MPFT=0x8806,MPEPM=0x8810,MPQDR=0x8811,MPILEM=0x8812,TNGCR=0xa001,TNPC=0xa020,TNGEE=0xa021,TNCR=0xa002,TNCR_V2=0xa004,TNUMT=0xa003,TNQCR=0xa010,TNQDR=0xa011,TNEEM=0xa012,TNDEM=0xa013,TNIFR=0xa014,TNIFR_V2=0xa017,TNIPSD=0xa015,TIGCR=0xa801,TIQCR=0xa810,TIQDR=0xa811,TIEEM=0xa812,TIDEM=0xa813,RCAP=0x8000,RGCR=0x8001,RITR=0x8002,RIGR_V2=0x8023,RTAR=0x8004,RECR=0x8005,RECR_V2=0x8025,RUFT=0x8006,RMFT=0x8007,RMFT_V2=0x8027,RMFTAD=0x8028,RRCR=0x800f,RATR=0x8008,RATRB=0x8024,RATRAD=0x8022,RTDP=0x8020,RIPS=0x8021,RDPM=0x8009,RICNT=0x800b,RALTA=0x8010,RALST=0x8011,RALTB=0x8012,RALUE=0x8013,RAUHT=0x8014,RAUHTD=0x8018,RALEU=0x8015,RALBU=0x8016,RALCM=0x8017,RMID=0x8030,RMID_V2=0x8036,RMPE=0x8031,RMPU=0x8032,RMEIR=0x8033,REIV=0x8034,RNGCR=0x8045,RXLTE=0x8050,RXLTM=0x8051,RXLTCC=0x8052,RLPMCE=0x8056,RLCME=0x8053,RLCMLE=0x8054,RLCMLD=0x8055,RARGCR=0x806a,RARPC=0x8060,RARSR=0x8069,RARPR=0x8061,RARCL=0x8062,RARGMC=0x8074,RARPTM=0x8076,RARPPM=0x8077,RARLU=0x8068,RARFT=0x8064,RARFTB=0x8079,RARLPGT=0x8065,RARCC=0x8067,RARTM=0x806b,RARNGC=0x8070,RARNPC=0x8078,RARNPR=0x8071,RARNCP=0x8072,RARNCG=0x8075,RARNS=0x8073,RSNH=0x8066,RTCA=0x800d,RTPS=0x800e,RIVA=0x8044,RIRT=0x8046,CWGCR=0x2801,CWTP=0x2802,CWPP=0x2804,CWTPM=0x2803,CPQE=0x2806,CHLTR=0x2810,CHLTM=0x2811,CHLMM=0x2812,CEGCR=0x2820,CEPC=0x2821,CEDR=0x2822,CEER=0x2823,QGCR=0x4000,QCAP=0x4001,QPTS=0x4002,QDPM=0x4003,QPDPM=0x4013,QEPM=0x4014,QPCR=0x4004,QPBR=0x400c,QETCR=0x4005,QSHR=0x4030,QEEC=0x400d,QPDP=0x4007,QPDPC=0x4017,QPRT=0x4008,QTCT=0x400a,QTCTM=0x401a,QSPIP=0x400e,QSPCP=0x401e,QRWE=0x400f,QPEM=0x4010,QPDSM=0x4011,QPPM=0x4012,QSLL=0x4015,QHLL=0x4016,QSIPG=0x4018,QCAM=0x4019,QTTTL=0x4040,QTQCR=0x4041,QTQDR=0x4042,QTEEM=0x4043,QTDEM=0x4044,QPTG=0x4050,QTGTC=0x4051,PGCR=0x3001,PPBT=0x3002,PEVPB=0x302e,PVGT=0x3009,PVBT=0x3003,PRBT=0x3013,PEMRBT=0x3014,PERB=0x3040,PERBRG=0x3041,PERBEG=0x3042,PACL=0x3004,PAGT=0x3005,PAGT_V2=0x3045,PAGTQ=0x3046,PTAR=0x3006,PERLA=0x3036,PERAR=0x3026,PERCR=0x302a,PERERP=0x302b,PERD=0x302c,PTCE=0x3007,PTCE_V2=0x3017,PTCE_V3=0x3027,PTCEAD=0x3028,PEFA=0x300f,PEFAAD=0x3029,PRCR=0x300d,PPRR=0x3008,PFCA=0x300a,PFCNT=0x300b,PPBS=0x300c,PUET=0x300e,PPBMI=0x3012,PECB=0x3010,PERPT=0x3021,PEABFE=0x3022,PEAPBL=0x3024,PEAPBM=0x3025,PEAPS=0x302d,PECNRE=0x3030,PECNRR=0x3031,PECNEE=0x3032,PECNER=0x3033,PECKC=0x3034,PETCM=0x3037,FGCR=0x4800,FPUMS=0x4801,FPHHC=0x4880,FPPC=0x4881,FPFTT=0x4882,FPHTT=0x4883,FPTS=0x4884,FMTC=0x4901,FMTE=0x4902,FMTM=0x4903,FMEP=0x4904,FMQC=0x4905,FSGCR=0x4920,FSDB=0x4921,FSPT=0x4922,FSPS=0x4923,FSDC=0x492c,FSTM=0x4924,FSED=0x4925,FSHE=0x4926,FSFH=0x4927,FMTPC=0x4928,FMTPA=0x4929,FMTB=0x492a,FRAR=0x492b,UGCAP=0x6400,UPCAP=0x6401,UGCR=0x6402,UPCON=0x6403,UMTU=0x6404,UVER=0x6410,UPVC=0x6411,UPAFT=0x6412,UTAR=0x6428,UPBT=0x6420,UTCE=0x6422,URCR=0x6423,USADB=0x6424,USAK=0x6425,USACN=0x6426,UTCC=0x6427,UPCNT=0x6430,UPRR=0x6440,UCCR=0x6450,UTFD=0x6451,UTFC=0x6452,UTER=0x6453" offset="0x0.0" size="0x4.0" />
</node>

<node name="access_reg_summary_ext" descr="" attr_is_union="1" size="0x26e0" >
	<field name="hgcr" descr="" subnode="hgcr_ext" capability="0" offset="0x0.0" selected_by="HGCR" size="0x1c" />
	<field name="hcap" descr="" subnode="hcap_ext" capability="0" offset="0x0.0" selected_by="HCAP" size="0x14" />
	<field name="hpkt" descr="" subnode="hpkt_ext" capability="0" offset="0x0.0" selected_by="HPKT" size="0x10" />
	<field name="htgt" descr="" subnode="htgt_ext" capability="0" offset="0x0.0" selected_by="HTGT" size="0x44" />
	<field name="hopf" descr="" subnode="hopf_ext" capability="0" offset="0x0.0" selected_by="HOPF" size="0x14" />
	<field name="hmcb" descr="" subnode="hmcb_ext" capability="0" offset="0x0.0" selected_by="HMCB" size="0x10" />
	<field name="hmon" descr="" subnode="hmon_ext" capability="0" offset="0x0.0" selected_by="HMON" size="0x220" />
	<field name="hrwc" descr="" subnode="hrwc_ext" capability="0" offset="0x0.0" selected_by="HRWC" size="0x220" />
	<field name="hctr" descr="" subnode="hctr_ext" capability="0" offset="0x0.0" selected_by="HCTR" size="0x10" />
	<field name="htac" descr="" subnode="htac_ext" capability="0" offset="0x0.0" selected_by="HTAC" size="0x30" />
	<field name="hcot" descr="" subnode="hcot_ext" capability="0" offset="0x0.0" selected_by="HCOT" size="0x30" />
	<field name="hrdqt" descr="" subnode="hrdqt_ext" capability="0" offset="0x0.0" selected_by="HRDQT" size="0xc" />
	<field name="htacg" descr="" subnode="htacg_ext" capability="0" offset="0x0.0" selected_by="HTACG" size="0x90" />
	<field name="htec" descr="" subnode="htec_ext" capability="0" offset="0x0.0" selected_by="HTEC" size="0x30" />
	<field name="htcr" descr="" subnode="htcr_ext" capability="0" offset="0x0.0" selected_by="HTCR" size="0x210" />
	<field name="hcpnc" descr="" subnode="hcpnc_ext" capability="0" offset="0x0.0" selected_by="HCPNC" size="0x20" />
	<field name="hukt" descr="" subnode="hukt_ext" capability="0" offset="0x0.0" selected_by="HUKT" size="0xc" />
	<field name="hett" descr="" subnode="hett_ext" capability="0" offset="0x0.0" selected_by="HETT" size="0x14" />
	<field name="hccr" descr="" subnode="hccr_ext" capability="0" offset="0x0.0" selected_by="HCCR" size="0x4" />
	<field name="hthm" descr="" subnode="hthm_ext" capability="0" offset="0x0.0" selected_by="HTHM" size="0x8" />
	<field name="mpein_reg" descr="" subnode="mpein_reg_ext" capability="0" offset="0x0.0" selected_by="MPEIN" size="0x30" />
	<field name="mpcnt_reg" descr="" subnode="mpcnt_reg_ext" capability="0" offset="0x0.0" selected_by="MPCNT" size="0x100" />
	<field name="mpir" descr="" subnode="mpir_ext" capability="0" offset="0x0.0" selected_by="MPIR" size="0x10" />
	<field name="mpecs_reg" descr="" subnode="mpecs_reg_ext" capability="0" offset="0x0.0" selected_by="MPECS" size="0x20" />
	<field name="mlcr" descr="" subnode="mlcr_ext" capability="0" offset="0x0.0" selected_by="MLCR" size="0xc" />
	<field name="mgcr_reg" descr="" subnode="mgcr_reg_ext" capability="0" offset="0x0.0" selected_by="MGCR" size="0x20" />
	<field name="mjtag" descr="" subnode="mjtag_ext" capability="0" offset="0x0.0" selected_by="MJTAG" size="0x30" />
	<field name="mfm" descr="" subnode="mfm_ext" capability="0" offset="0x0.0" selected_by="MFM" size="0x18" />
	<field name="mhsr" descr="" subnode="mhsr_ext" capability="0" offset="0x0.0" selected_by="MHSR" size="0x8" />
	<field name="mtpps_reg" descr="" subnode="mtpps_reg_ext" capability="0" offset="0x0.0" selected_by="MTPPS" size="0x38" />
	<field name="mtutc_reg" descr="" subnode="mtutc_reg_ext" capability="0" offset="0x0.0" selected_by="MTUTC" size="0x1c" />
	<field name="mtppst" descr="" subnode="mtppst_ext" capability="0" offset="0x0.0" selected_by="MTPPST" size="0x10" />
	<field name="MSECQ_reg" descr="" subnode="MSECQ_reg_ext" capability="0" offset="0x0.0" selected_by="MSECQ" size="0x40" />
	<field name="MSEES_reg" descr="" subnode="MSEES_reg_ext" capability="0" offset="0x0.0" selected_by="MSEES" size="0x40" />
	<field name="MSPI" descr="" subnode="MSPI_ext" capability="0" offset="0x0.0" selected_by="MSPI" size="0x18" />
	<field name="mcia" descr="" subnode="mcia_ext" capability="0" offset="0x0.0" selected_by="MCIA" size="0x94" />
	<field name="mcion" descr="" subnode="mcion_ext" capability="0" offset="0x0.0" selected_by="MCION" size="0x18" />
	<field name="MCFS" descr="" subnode="MCFS_ext" capability="0" offset="0x0.0" selected_by="MCFS" size="0x20" />
	<field name="pmaos_reg" descr="" subnode="pmaos_reg_ext" capability="0" offset="0x0.0" selected_by="PMAOS" size="0x10" />
	<field name="pmtm_reg" descr="" subnode="pmtm_reg_ext" capability="0" offset="0x0.0" selected_by="PMTM" size="0x10" />
	<field name="pmpc_reg" descr="" subnode="pmpc_reg_ext" capability="0" offset="0x0.0" selected_by="PMPC" size="0x20" />
	<field name="pmpe_reg" descr="" subnode="pmpe_reg_ext" capability="0" offset="0x0.0" selected_by="PMPE" size="0x10" />
	<field name="mddt_reg" descr="" subnode="mddt_reg_ext" capability="0" offset="0x0.0" selected_by="MDDT" size="0x110" />
	<field name="mddq" descr="" subnode="mddq_ext" capability="0" offset="0x0.0" selected_by="MDDQ" size="0x30" />
	<field name="mddc" descr="" subnode="mddc_ext" capability="0" offset="0x0.0" selected_by="MDDC" size="0x30" />
	<field name="mgpir" descr="" subnode="mgpir_ext" capability="0" offset="0x0.0" selected_by="MGPIR" size="0xa0" />
	<field name="mdrcr" descr="" subnode="mdrcr_ext" capability="0" offset="0x0.0" selected_by="MDRCR" size="0x30" />
	<field name="mdfcr_reg" descr="" subnode="mdfcr_reg_ext" capability="0" offset="0x0.0" selected_by="MDFCR" size="0x60" />
	<field name="mtcap" descr="" subnode="mtcap_ext" capability="0" offset="0x0.0" selected_by="MTCAP" size="0x10" />
	<field name="mtecr" descr="" subnode="mtecr_ext" capability="0" offset="0x0.0" selected_by="MTECR" size="0x60" />
	<field name="mtmp" descr="" subnode="mtmp_ext" capability="0" offset="0x0.0" selected_by="MTMP" size="0x20" />
	<field name="mtwe" descr="" subnode="mtwe_ext" capability="0" offset="0x0.0" selected_by="MTWE" size="0x10" />
	<field name="mtewe" descr="" subnode="mtewe_ext" capability="0" offset="0x0.0" selected_by="MTEWE" size="0x5c" />
	<field name="mtbr_reg" descr="" subnode="mtbr_reg_ext" capability="0" offset="0x0.0" selected_by="MTBR" size="0x410" />
	<field name="mvcap_reg" descr="" subnode="mvcap_reg_ext" capability="0" offset="0x0.0" selected_by="MVCAP" size="0x10" />
	<field name="mvcr" descr="" subnode="mvcr_ext" capability="0" offset="0x0.0" selected_by="MVCR" size="0x18" />
	<field name="msps" descr="" subnode="msps_ext" capability="0" offset="0x0.0" selected_by="MSPS" size="0xa0" />
	<field name="mcpp_reg" descr="" subnode="mcpp_reg_ext" capability="0" offset="0x0.0" selected_by="MCPP" size="0x10" />
	<field name="mpscr" descr="" subnode="mpscr_ext" capability="0" offset="0x0.0" selected_by="MPSCR" size="0x20" />
	<field name="MLPC" descr="" subnode="MLPC_ext" capability="0" offset="0x0.0" selected_by="MLPC" size="0x40" />
	<field name="mppcr" descr="" subnode="mppcr_ext" capability="0" offset="0x0.0" selected_by="MPPCR" size="0x40" />
	<field name="mppgcr" descr="" subnode="mppgcr_ext" capability="0" offset="0x0.0" selected_by="MPPGCR" size="0x24" />
	<field name="mppgs" descr="" subnode="mppgs_ext" capability="0" offset="0x0.0" selected_by="MPPGS" size="0x10" />
	<field name="mppgh" descr="" subnode="mppgh_ext" capability="0" offset="0x0.0" selected_by="MPPGH" size="0x30" />
	<field name="mppdr" descr="" subnode="mppdr_ext" capability="0" offset="0x0.0" selected_by="MPPDR" size="0x40" />
	<field name="mrsr" descr="" subnode="mrsr_ext" capability="0" offset="0x0.0" selected_by="MRSR" size="0x8" />
	<field name="mbtr" descr="" subnode="mbtr_ext" capability="0" offset="0x0.0" selected_by="MBTR" size="0x8" />
	<field name="mcqs_reg" descr="" subnode="mcqs_reg_ext" capability="0" offset="0x0.0" selected_by="MCQS" size="0x10" />
	<field name="mcqi_reg" descr="" subnode="mcqi_reg_ext" capability="0" offset="0x0.0" selected_by="MCQI" size="0x94" />
	<field name="mcc_reg" descr="" subnode="mcc_reg_ext" capability="0" offset="0x0.0" selected_by="MCC" size="0x20" />
	<field name="mcda_reg" descr="" subnode="mcda_reg_ext" capability="0" offset="0x0.0" selected_by="MCDA" size="0x90" />
	<field name="mcdd_reg" descr="" subnode="mcdd_reg_ext" capability="0" offset="0x0.0" selected_by="MCDD" size="0x20" />
	<field name="mirc_reg" descr="" subnode="mirc_reg_ext" capability="0" offset="0x0.0" selected_by="MIRC" size="0x8" />
	<field name="mqis_reg" descr="" subnode="mqis_reg_ext" capability="0" offset="0x0.0" selected_by="MQIS" size="0x18" />
	<field name="mgir" descr="" subnode="mgir_ext" capability="0" offset="0x0.0" selected_by="MGIR" size="0xa0" />
	<field name="msgi" descr="" subnode="msgi_ext" capability="0" offset="0x0.0" selected_by="MSGI" size="0x80" />
	<field name="mcgi" descr="" subnode="mcgi_ext" capability="0" offset="0x0.0" selected_by="MCGI" size="0x34" />
	<field name="msci" descr="" subnode="msci_ext" capability="0" offset="0x0.0" selected_by="MSCI" size="0xc" />
	<field name="mdir_reg" descr="" subnode="mdir_reg_ext" capability="0" offset="0x0.0" selected_by="MDIR" size="0x40" />
	<field name="mssir_reg" descr="" subnode="mssir_reg_ext" capability="0" offset="0x0.0" selected_by="MSSIR" size="0x88" />
	<field name="mini" descr="" subnode="mini_ext" capability="0" offset="0x0.0" selected_by="MINI" size="0x50" />
	<field name="mcam_reg" descr="" subnode="mcam_reg_ext" capability="0" offset="0x0.0" selected_by="MCAM" size="0x48" />
	<field name="meccc" descr="" subnode="meccc_ext" capability="0" offset="0x0.0" selected_by="MECCC" size="0x14" />
	<field name="MMAM" descr="" subnode="MMAM_ext" capability="0" offset="0x0.0" selected_by="MMAM" size="0x10" />
	<field name="MFMI" descr="" subnode="MFMI_ext" capability="0" offset="0x0.0" selected_by="MFMI" size="0x18" />
	<field name="MRFV" descr="" subnode="MRFV_ext" capability="0" offset="0x0.0" selected_by="MRFV" size="0x40" />
	<field name="mbct" descr="" subnode="mbct_ext" capability="0" offset="0x0.0" selected_by="MBCT" size="0x420" />
	<field name="mrcs_reg" descr="" subnode="mrcs_reg_ext" capability="0" offset="0x0.0" selected_by="MRCS" size="0x18" />
	<field name="mdsr_reg" descr="" subnode="mdsr_reg_ext" capability="0" offset="0x0.0" selected_by="MDSR" size="0x30" />
	<field name="mfsv_reg" descr="" subnode="mfsv_reg_ext" capability="0" offset="0x0.0" selected_by="MFSV" size="0x30" />
	<field name="mtcq_reg" descr="" subnode="mtcq_reg_ext" capability="0" offset="0x0.0" selected_by="MTCQ" size="0x70" />
	<field name="mqdik_reg" descr="" subnode="mqdik_reg_ext" capability="0" offset="0x0.0" selected_by="MQDIK" size="0x208" />
	<field name="mkdc_reg" descr="" subnode="mkdc_reg_ext" capability="0" offset="0x0.0" selected_by="MKDC" size="0x2c" />
	<field name="mspmer" descr="" subnode="mspmer_ext" capability="0" offset="0x0.0" selected_by="MSPMER" size="0x30" />
	<field name="mfcdr_reg" descr="" subnode="mfcdr_reg_ext" capability="0" offset="0x0.0" selected_by="MFCDR" size="0x8" />
	<field name="msgcr_reg" descr="" subnode="msgcr_reg_ext" capability="0" offset="0x0.0" selected_by="MSGCR" size="0x8" />
	<field name="mnvda_reg" descr="" subnode="mnvda_reg_ext" capability="0" offset="0x0.0" selected_by="MNVDA" size="0x10c" />
	<field name="mnvdi_reg" descr="" subnode="mnvdi_reg_ext" capability="0" offset="0x0.0" selected_by="MNVDI" size="0xc" />
	<field name="mnvqc_reg" descr="" subnode="mnvqc_reg_ext" capability="0" offset="0x0.0" selected_by="MNVQC" size="0x8" />
	<field name="mnvia_reg" descr="" subnode="mnvia_reg_ext" capability="0" offset="0x0.0" selected_by="MNVIA" size="0x8" />
	<field name="mnvgc_reg" descr="" subnode="mnvgc_reg_ext" capability="0" offset="0x0.0" selected_by="MNVGC" size="0x10" />
	<field name="mtrc_cap_reg" descr="" subnode="mtrc_cap_reg_ext" capability="0" offset="0x0.0" selected_by="MTRC_CAP" size="0x84" />
	<field name="mtrc_conf_reg" descr="" subnode="mtrc_conf_reg_ext" capability="0" offset="0x0.0" selected_by="MTRC_CONF" size="0x80" />
	<field name="mtrc_stdb_reg" descr="" subnode="mtrc_stdb_reg_ext" capability="0" offset="0x0.0" selected_by="MTRC_STDB" size="0xc" />
	<field name="mtrc_stdb_v2" descr="" subnode="mtrc_stdb_v2_ext" capability="0" offset="0x0.0" selected_by="MTRC_STDB_V2" size="0x5a0" />
	<field name="mtrc_stdb_v3" descr="" subnode="mtrc_stdb_v3_ext" capability="0" offset="0x0.0" selected_by="MTRC_STDB_V3" size="0x26e0" />
	<field name="mtrc_ctrl_reg" descr="" subnode="mtrc_ctrl_reg_ext" capability="0" offset="0x0.0" selected_by="MTRC_CTRL" size="0x40" />
	<field name="mteim_reg" descr="" subnode="mteim_reg_ext" capability="0" offset="0x0.0" selected_by="MTEIM" size="0x30" />
	<field name="mtie" descr="" subnode="mtie_ext" capability="0" offset="0x0.0" selected_by="MTIE" size="0x30" />
	<field name="mtim" descr="" subnode="mtim_ext" capability="0" offset="0x0.0" selected_by="MTIM" size="0x10" />
	<field name="mtdc" descr="" subnode="mtdc_ext" capability="0" offset="0x0.0" selected_by="MTDC" size="0x20" />
	<field name="mfpa_reg" descr="" subnode="mfpa_reg_ext" capability="0" offset="0x0.0" selected_by="MFPA" size="0x20" />
	<field name="mfba_reg" descr="" subnode="mfba_reg_ext" capability="0" offset="0x0.0" selected_by="MFBA" size="0x10c" />
	<field name="mfbe_reg" descr="" subnode="mfbe_reg_ext" capability="0" offset="0x0.0" selected_by="MFBE" size="0xc" />
	<field name="mfmc_reg" descr="" subnode="mfmc_reg_ext" capability="0" offset="0x0.0" selected_by="MFMC" size="0x1c" />
	<field name="mfcr" descr="" subnode="mfcr_ext" capability="0" offset="0x0.0" selected_by="MFCR" size="0x8" />
	<field name="mfsc" descr="" subnode="mfsc_ext" capability="0" offset="0x0.0" selected_by="MFSC" size="0x8" />
	<field name="mfsm" descr="" subnode="mfsm_ext" capability="0" offset="0x0.0" selected_by="MFSM" size="0x8" />
	<field name="mfsl" descr="" subnode="mfsl_ext" capability="0" offset="0x0.0" selected_by="MFSL" size="0xc" />
	<field name="fore" descr="" subnode="fore_ext" capability="0" offset="0x0.0" selected_by="FORE" size="0xc" />
	<field name="mfnr" descr="" subnode="mfnr_ext" capability="0" offset="0x0.0" selected_by="MFNR" size="0x30" />
	<field name="mpcir" descr="" subnode="mpcir_ext" capability="0" offset="0x0.0" selected_by="MPCIR" size="0x10" />
	<field name="merr" descr="" subnode="merr_ext" capability="0" offset="0x0.0" selected_by="MERR" size="0x14" />
	<field name="mrpr_reg" descr="" subnode="mrpr_reg_ext" capability="0" offset="0x0.0" selected_by="MRPR" size="0x108" />
	<field name="mdcr" descr="" subnode="mdcr_ext" capability="0" offset="0x0.0" selected_by="MDCR" size="0x60" />
	<field name="mhmpr_reg" descr="" subnode="mhmpr_reg_ext" capability="0" offset="0x0.0" selected_by="MHMPR" size="0x14" />
	<field name="mfrc" descr="" subnode="mfrc_ext" capability="0" offset="0x0.0" selected_by="MFRC" size="0xc" />
	<field name="MMCR" descr="" subnode="MMCR_ext" capability="0" offset="0x0.0" selected_by="MMCR" size="0x50" />
	<field name="mfri" descr="" subnode="mfri_ext" capability="0" offset="0x0.0" selected_by="MFRI" size="0x30" />
	<field name="mfrp" descr="" subnode="mfrp_ext" capability="0" offset="0x0.0" selected_by="MFRP" size="0x1c" />
	<field name="mogcr" descr="" subnode="mogcr_ext" capability="0" offset="0x0.0" selected_by="MOGCR" size="0x20" />
	<field name="mprs" descr="" subnode="mprs_ext" capability="0" offset="0x0.0" selected_by="MPRS" size="0x14" />
	<field name="mdri" descr="" subnode="mdri_ext" capability="0" offset="0x0.0" selected_by="MDRI" size="0x120" />
	<field name="mrrr" descr="" subnode="mrrr_ext" capability="0" offset="0x0.0" selected_by="MRRR" size="0x8" />
	<field name="moni" descr="" subnode="moni_ext" capability="0" offset="0x0.0" selected_by="MONI" size="0x8" />
	<field name="molp" descr="" subnode="molp_ext" capability="0" offset="0x0.0" selected_by="MOLP" size="0x8" />
	<field name="mfbd" descr="" subnode="mfbd_ext" capability="0" offset="0x0.0" selected_by="MFBD" size="0x24" />
	<field name="mmgcr" descr="" subnode="mmgcr_ext" capability="0" offset="0x0.0" selected_by="MMGCR" size="0x4" />
	<field name="mpat_reg" descr="" subnode="mpat_reg_ext" capability="0" offset="0x0.0" selected_by="MPAT" size="0x84" />
	<field name="mpar" descr="" subnode="mpar_ext" capability="0" offset="0x0.0" selected_by="MPAR" size="0xc" />
	<field name="mpagr" descr="" subnode="mpagr_ext" capability="0" offset="0x0.0" selected_by="MPAGR" size="0xc" />
	<field name="momte" descr="" subnode="momte_ext" capability="0" offset="0x0.0" selected_by="MOMTE" size="0x10" />
	<field name="mocmi" descr="" subnode="mocmi_ext" capability="0" offset="0x0.0" selected_by="MOCMI" size="0x10" />
	<field name="motrm_reg" descr="" subnode="motrm_reg_ext" capability="0" offset="0x0.0" selected_by="MOTRM" size="0xc" />
	<field name="mpsc" descr="" subnode="mpsc_ext" capability="0" offset="0x0.0" selected_by="MPSC" size="0x14" />
	<field name="mgpc" descr="" subnode="mgpc_ext" capability="0" offset="0x0.0" selected_by="MGPC" size="0x18" />
	<field name="mgpcb" descr="" subnode="mgpcb_ext" capability="0" offset="0x0.0" selected_by="MGPCB" size="0x410" />
	<field name="mocs" descr="" subnode="mocs_ext" capability="0" offset="0x0.0" selected_by="MOCS" size="0xe8" />
	<field name="mafcr" descr="" subnode="mafcr_ext" capability="0" offset="0x0.0" selected_by="MAFCR" size="0xc" />
	<field name="mafti" descr="" subnode="mafti_ext" capability="0" offset="0x0.0" selected_by="MAFTI" size="0x308" />
	<field name="mafri" descr="" subnode="mafri_ext" capability="0" offset="0x0.0" selected_by="MAFRI" size="0x410" />
	<field name="mafbi" descr="" subnode="mafbi_ext" capability="0" offset="0x0.0" selected_by="MAFBI" size="0x308" />
	<field name="moca" descr="" subnode="moca_ext" capability="0" offset="0x0.0" selected_by="MOCA" size="0xc" />
	<field name="mofph" descr="" subnode="mofph_ext" capability="0" offset="0x0.0" selected_by="MOFPH" size="0x20" />
	<field name="mofpc" descr="" subnode="mofpc_ext" capability="0" offset="0x0.0" selected_by="MOFPC" size="0xc" />
	<field name="mofrb" descr="" subnode="mofrb_ext" capability="0" offset="0x0.0" selected_by="MOFRB" size="0x210" />
	<field name="MOCBR" descr="" subnode="MOCBR_ext" capability="0" offset="0x0.0" selected_by="MOCBR" size="0xc" />
	<field name="MOCBS" descr="" subnode="MOCBS_ext" capability="0" offset="0x0.0" selected_by="MOCBS" size="0xc" />
	<field name="MOFTC" descr="" subnode="MOFTC_ext" capability="0" offset="0x0.0" selected_by="MOFTC" size="0x108" />
	<field name="MOFTD" descr="" subnode="MOFTD_ext" capability="0" offset="0x0.0" selected_by="MOFTD" size="0x24" />
	<field name="mtpppc" descr="" subnode="mtpppc_ext" capability="0" offset="0x0.0" selected_by="MTPPPC" size="0x28" />
	<field name="mtpptr" descr="" subnode="mtpptr_ext" capability="0" offset="0x0.0" selected_by="MTPPTR" size="0x50" />
	<field name="mtptpt" descr="" subnode="mtptpt_ext" capability="0" offset="0x0.0" selected_by="MTPTPT" size="0x8" />
	<field name="mtpcpc" descr="" subnode="mtpcpc_ext" capability="0" offset="0x0.0" selected_by="MTPCPC" size="0x28" />
	<field name="mtpspu" descr="" subnode="mtpspu_ext" capability="0" offset="0x0.0" selected_by="MTPSPU" size="0x8" />
	<field name="modcr" descr="" subnode="modcr_ext" capability="0" offset="0x0.0" selected_by="MODCR" size="0x14" />
	<field name="resource_dump" descr="" subnode="resource_dump_ext" capability="0" offset="0x0.0" selected_by="MORD" size="0xc8" />
	<field name="sgcr" descr="" subnode="sgcr_ext" capability="0" offset="0x0.0" selected_by="SGCR" size="0x10" />
	<field name="spad" descr="" subnode="spad_ext" capability="0" offset="0x0.0" selected_by="SPAD" size="0x10" />
	<field name="sfdat" descr="" subnode="sfdat_ext" capability="0" offset="0x0.0" selected_by="SFDAT" size="0x8" />
	<field name="sfd" descr="" subnode="sfd_ext" capability="0" offset="0x0.0" selected_by="SFD" size="0x410" />
	<field name="sfd_v2" descr="" subnode="sfd_v2_ext" capability="0" offset="0x0.0" selected_by="SFD_V2" size="0x30" />
	<field name="sfn" descr="" subnode="sfn_ext" capability="0" offset="0x0.0" selected_by="SFN" size="0x410" />
	<field name="sfdd" descr="" subnode="sfdd_ext" capability="0" offset="0x0.0" selected_by="SFDD" size="0x420" />
	<field name="sfdb" descr="" subnode="sfdb_ext" capability="0" offset="0x0.0" selected_by="SFDB" size="0x48" />
	<field name="sfdb_v2" descr="" subnode="sfdb_v2_ext" capability="0" offset="0x0.0" selected_by="SFDB_V2" size="0x84" />
	<field name="spgt" descr="" subnode="spgt_ext" capability="0" offset="0x0.0" selected_by="SPGT" size="0x240" />
	<field name="smid" descr="" subnode="smid_ext" capability="0" offset="0x0.0" selected_by="SMID" size="0x240" />
	<field name="smid_v2" descr="" subnode="smid_v2_ext" capability="0" offset="0x0.0" selected_by="SMID_V2" size="0x120" />
	<field name="smpu" descr="" subnode="smpu_ext" capability="0" offset="0x0.0" selected_by="SMPU" size="0x410" />
	<field name="sspr" descr="" subnode="sspr_ext" capability="0" offset="0x0.0" selected_by="SSPR" size="0x8" />
	<field name="spms" descr="" subnode="spms_ext" capability="0" offset="0x0.0" selected_by="SPMS" size="0x404" />
	<field name="spms_v2" descr="" subnode="spms_v2_ext" capability="0" offset="0x0.0" selected_by="SPMS_V2" size="0x400" />
	<field name="spvid" descr="" subnode="spvid_ext" capability="0" offset="0x0.0" selected_by="SPVID" size="0x8" />
	<field name="spevet" descr="" subnode="spevet_ext" capability="0" offset="0x0.0" selected_by="SPEVET" size="0x8" />
	<field name="spvtr" descr="" subnode="spvtr_ext" capability="0" offset="0x0.0" selected_by="SPVTR" size="0x10" />
	<field name="spvm" descr="" subnode="spvm_ext" capability="0" offset="0x0.0" selected_by="SPVM" size="0x400" />
	<field name="spaft" descr="" subnode="spaft_ext" capability="0" offset="0x0.0" selected_by="SPAFT" size="0x8" />
	<field name="sfgc" descr="" subnode="sfgc_ext" capability="0" offset="0x0.0" selected_by="SFGC" size="0x14" />
	<field name="sftr" descr="" subnode="sftr_ext" capability="0" offset="0x0.0" selected_by="SFTR" size="0x240" />
	<field name="sftr_v2" descr="" subnode="sftr_v2_ext" capability="0" offset="0x0.0" selected_by="SFTR_V2" size="0x120" />
	<field name="svfa" descr="" subnode="svfa_ext" capability="0" offset="0x0.0" selected_by="SVFA" size="0x18" />
	<field name="sfdf" descr="" subnode="sfdf_ext" capability="0" offset="0x0.0" selected_by="SFDF" size="0x14" />
	<field name="sldr" descr="" subnode="sldr_ext" capability="0" offset="0x0.0" selected_by="SLDR" size="0x108" />
	<field name="slmt" descr="" subnode="slmt_ext" capability="0" offset="0x0.0" selected_by="SLMT" size="0x8" />
	<field name="slcr" descr="" subnode="slcr_ext" capability="0" offset="0x0.0" selected_by="SLCR" size="0x10" />
	<field name="SLCRV2" descr="" subnode="SLCRV2_ext" capability="0" offset="0x0.0" selected_by="SLCR_V2" size="0x50" />
	<field name="sfdt" descr="" subnode="sfdt_ext" capability="0" offset="0x0.0" selected_by="SFDT" size="0x2e0" />
	<field name="sfdt_v2" descr="" subnode="sfdt_v2_ext" capability="0" offset="0x0.0" selected_by="SFDT_V2" size="0x2e0" />
	<field name="slcor" descr="" subnode="slcor_ext" capability="0" offset="0x0.0" selected_by="SLCOR" size="0x10" />
	<field name="slecr" descr="" subnode="slecr_ext" capability="0" offset="0x0.0" selected_by="SLECR" size="0x10" />
	<field name="spvmlr" descr="" subnode="spvmlr_ext" capability="0" offset="0x0.0" selected_by="SPVMLR" size="0x400" />
	<field name="svpe" descr="" subnode="svpe_ext" capability="0" offset="0x0.0" selected_by="SVPE" size="0x4" />
	<field name="sfmr" descr="" subnode="sfmr_ext" capability="0" offset="0x0.0" selected_by="SFMR" size="0x2c" />
	<field name="sver" descr="" subnode="sver_ext" capability="0" offset="0x0.0" selected_by="SVER" size="0x10" />
	<field name="spvc" descr="" subnode="spvc_ext" capability="0" offset="0x0.0" selected_by="SPVC" size="0xc" />
	<field name="spfsr" descr="" subnode="spfsr_ext" capability="0" offset="0x0.0" selected_by="SPFSR" size="0x8" />
	<field name="sffp" descr="" subnode="sffp_ext" capability="0" offset="0x0.0" selected_by="SFFP" size="0xc" />
	<field name="smpe" descr="" subnode="smpe_ext" capability="0" offset="0x0.0" selected_by="SMPE" size="0xc" />
	<field name="smpeb" descr="" subnode="smpeb_ext" capability="0" offset="0x0.0" selected_by="SMPEB" size="0x420" />
	<field name="smht" descr="" subnode="smht_ext" capability="0" offset="0x0.0" selected_by="SMHT" size="0xa0" />
	<field name="svpcn" descr="" subnode="svpcn_ext" capability="0" offset="0x0.0" selected_by="SVPCN" size="0x10" />
	<field name="pcam_reg" descr="" subnode="pcam_reg_ext" capability="0" offset="0x0.0" selected_by="PCAM" size="0x50" />
	<field name="pcap_reg" descr="" subnode="pcap_reg_ext" capability="0" offset="0x0.0" selected_by="PCAP" size="0x14" />
	<field name="ptys_reg" descr="" subnode="ptys_reg_ext" capability="0" offset="0x0.0" selected_by="PTYS" size="0x44" />
	<field name="paos_reg" descr="" subnode="paos_reg_ext" capability="0" offset="0x0.0" selected_by="PAOS" size="0x10" />
	<field name="pltc_reg" descr="" subnode="pltc_reg_ext" capability="0" offset="0x0.0" selected_by="PLTC" size="0x10" />
	<field name="ppcnt_reg" descr="" subnode="ppcnt_reg_ext" capability="0" offset="0x0.0" selected_by="PPCNT" size="0x100" />
	<field name="pude_reg" descr="" subnode="pude_reg_ext" capability="0" offset="0x0.0" selected_by="PUDE" size="0x10" />
	<field name="ptse_reg" descr="" subnode="ptse_reg_ext" capability="0" offset="0x0.0" selected_by="PTSE" size="0x8" />
	<field name="pipg_reg" descr="" subnode="pipg_reg_ext" capability="0" offset="0x0.0" selected_by="PIPG" size="0x8" />
	<field name="pgmr" descr="" subnode="pgmr_ext" capability="0" offset="0x0.0" selected_by="PGMR" size="0x2c" />
	<field name="pter_reg" descr="" subnode="pter_reg_ext" capability="0" offset="0x0.0" selected_by="PTER" size="0x20" />
	<field name="prei_reg" descr="" subnode="prei_reg_ext" capability="0" offset="0x0.0" selected_by="PREI" size="0x18" />
	<field name="pmlp_reg" descr="" subnode="pmlp_reg_ext" capability="0" offset="0x0.0" selected_by="PMLP" size="0x40" />
	<field name="pmpr_reg" descr="" subnode="pmpr_reg_ext" capability="0" offset="0x0.0" selected_by="PMPR" size="0x10" />
	<field name="pmtdb_reg" descr="" subnode="pmtdb_reg_ext" capability="0" offset="0x0.0" selected_by="PMTDB" size="0x40" />
	<field name="pmecr_reg" descr="" subnode="pmecr_reg_ext" capability="0" offset="0x0.0" selected_by="PMECR" size="0x20" />
	<field name="pmlpe_reg" descr="" subnode="pmlpe_reg_ext" capability="0" offset="0x0.0" selected_by="PMLPE" size="0x40" />
	<field name="pmsc_reg" descr="" subnode="pmsc_reg_ext" capability="0" offset="0x0.0" selected_by="PMSC" size="0x40" />
	<field name="pmmp_reg" descr="" subnode="pmmp_reg_ext" capability="0" offset="0x0.0" selected_by="PMMP" size="0x2c" />
	<field name="pmcr_reg" descr="" subnode="pmcr_reg_ext" capability="0" offset="0x0.0" selected_by="PMCR" size="0x20" />
	<field name="pepc_reg" descr="" subnode="pepc_reg_ext" capability="0" offset="0x0.0" selected_by="PEPC" size="0x10" />
	<field name="pmpt_reg" descr="" subnode="pmpt_reg_ext" capability="0" offset="0x0.0" selected_by="PMPT" size="0x1c" />
	<field name="pmpd_reg" descr="" subnode="pmpd_reg_ext" capability="0" offset="0x0.0" selected_by="PMPD" size="0x30" />
	<field name="ppsc_reg" descr="" subnode="ppsc_reg_ext" capability="0" offset="0x0.0" selected_by="PPSC" size="0x30" />
	<field name="prtl_reg" descr="" subnode="prtl_reg_ext" capability="0" offset="0x0.0" selected_by="PRTL" size="0x20" />
	<field name="pplr_reg" descr="" subnode="pplr_reg_ext" capability="0" offset="0x0.0" selected_by="PPLR" size="0x8" />
	<field name="peir_reg" descr="" subnode="peir_reg_ext" capability="0" offset="0x0.0" selected_by="PEIR" size="0xc" />
	<field name="pplm_reg" descr="" subnode="pplm_reg_ext" capability="0" offset="0x0.0" selected_by="PPLM" size="0x50" />
	<field name="sltp_reg" descr="" subnode="sltp_reg_ext" capability="0" offset="0x0.0" selected_by="SLTP" size="0x4c" />
	<field name="sltpv2_reg" descr="" subnode="sltpv2_reg_ext" capability="0" offset="0x0.0" selected_by="SLTPv2" size="0x10c" />
	<field name="slrg_reg" descr="" subnode="slrg_reg_ext" capability="0" offset="0x0.0" selected_by="SLRG" size="0x28" />
	<field name="pddr_reg" descr="" subnode="pddr_reg_ext" capability="0" offset="0x0.0" selected_by="PDDR" size="0x100" />
	<field name="pptt_reg" descr="" subnode="pptt_reg_ext" capability="0" offset="0x0.0" selected_by="PPTT" size="0x1c" />
	<field name="pprt_reg" descr="" subnode="pprt_reg_ext" capability="0" offset="0x0.0" selected_by="PPRT" size="0x24" />
	<field name="pphcr" descr="" subnode="pphcr_ext" capability="0" offset="0x0.0" selected_by="PPHCR" size="0x50" />
	<field name="ppaos_reg" descr="" subnode="ppaos_reg_ext" capability="0" offset="0x0.0" selected_by="PPAOS" size="0x10" />
	<field name="pcnr_reg" descr="" subnode="pcnr_reg_ext" capability="0" offset="0x0.0" selected_by="PCNR" size="0xc" />
	<field name="ppbmp_reg" descr="" subnode="ppbmp_reg_ext" capability="0" offset="0x0.0" selected_by="PPBMP" size="0x30" />
	<field name="ppbmc_reg" descr="" subnode="ppbmc_reg_ext" capability="0" offset="0x0.0" selected_by="PPBMC" size="0x10" />
	<field name="ppbme_reg" descr="" subnode="ppbme_reg_ext" capability="0" offset="0x0.0" selected_by="PPBME" size="0x10" />
	<field name="slred_reg" descr="" subnode="slred_reg_ext" capability="0" offset="0x0.0" selected_by="SLRED" size="0xa8" />
	<field name="pemi" descr="" subnode="pemi_ext" capability="0" offset="0x0.0" selected_by="PEMI" size="0x100" />
	<field name="pbgcr" descr="" subnode="pbgcr_ext" capability="0" offset="0x0.0" selected_by="PBGCR" size="0xc" />
	<field name="pmtu_reg" descr="" subnode="pmtu_reg_ext" capability="0" offset="0x0.0" selected_by="PMTU" size="0x10" />
	<field name="ppad_reg" descr="" subnode="ppad_reg_ext" capability="0" offset="0x0.0" selected_by="PPAD" size="0x10" />
	<field name="pfcc_reg" descr="" subnode="pfcc_reg_ext" capability="0" offset="0x0.0" selected_by="PFCC" size="0x20" />
	<field name="pptb_reg" descr="" subnode="pptb_reg_ext" capability="0" offset="0x0.0" selected_by="PPTB" size="0x10" />
	<field name="pbmc_reg" descr="" subnode="pbmc_reg_ext" capability="0" offset="0x0.0" selected_by="PBMC" size="0x6c" />
	<field name="pspa_reg" descr="" subnode="pspa_reg_ext" capability="0" offset="0x0.0" selected_by="PSPA" size="0x8" />
	<field name="pguid_reg" descr="" subnode="pguid_reg_ext" capability="0" offset="0x0.0" selected_by="PGUID" size="0x60" />
	<field name="pvlc_reg" descr="" subnode="pvlc_reg_ext" capability="0" offset="0x0.0" selected_by="PVLC" size="0x10" />
	<field name="plbf_reg" descr="" subnode="plbf_reg_ext" capability="0" offset="0x0.0" selected_by="PLBF" size="0x8" />
	<field name="pifr_reg" descr="" subnode="pifr_reg_ext" capability="0" offset="0x0.0" selected_by="PIFR" size="0x60" />
	<field name="pifr_v2" descr="" subnode="pifr_v2_ext" capability="0" offset="0x0.0" selected_by="PIFR_V2" size="0x120" />
	<field name="phbr" descr="" subnode="phbr_ext" capability="0" offset="0x0.0" selected_by="PHBR" size="0x1c" />
	<field name="phrr_reg" descr="" subnode="phrr_reg_ext" capability="0" offset="0x0.0" selected_by="PHRR" size="0x68" />
	<field name="pbsr_reg" descr="" subnode="pbsr_reg_ext" capability="0" offset="0x0.0" selected_by="PBSR" size="0x64" />
	<field name="pcmr_reg" descr="" subnode="pcmr_reg_ext" capability="0" offset="0x0.0" selected_by="PCMR" size="0xc" />
	<field name="pfsc_reg" descr="" subnode="pfsc_reg_ext" capability="0" offset="0x0.0" selected_by="PFSC" size="0x10" />
	<field name="pllp_reg" descr="" subnode="pllp_reg_ext" capability="0" offset="0x0.0" selected_by="PLLP" size="0x14" />
	<field name="PPCR" descr="" subnode="PPCR_ext" capability="0" offset="0x0.0" selected_by="PPCR" size="0x10" />
	<field name="PPIR" descr="" subnode="PPIR_ext" capability="0" offset="0x0.0" selected_by="PPIR" size="0x8" />
	<field name="prtsr" descr="" subnode="prtsr_ext" capability="0" offset="0x0.0" selected_by="PRTSR" size="0x10" />
	<field name="pldt" descr="" subnode="pldt_ext" capability="0" offset="0x0.0" selected_by="PLDT" size="0xc" />
	<field name="pldc" descr="" subnode="pldc_ext" capability="0" offset="0x0.0" selected_by="PLDC" size="0x14" />
	<field name="plib_reg" descr="" subnode="plib_reg_ext" capability="0" offset="0x0.0" selected_by="PLIB" size="0x10" />
	<field name="plibdb" descr="" subnode="plibdb_ext" capability="0" offset="0x0.0" selected_by="PLIBDB" size="0x10" />
	<field name="ppslc" descr="" subnode="ppslc_ext" capability="0" offset="0x0.0" selected_by="PPSLC" size="0x34" />
	<field name="ppsls" descr="" subnode="ppsls_ext" capability="0" offset="0x0.0" selected_by="PPSLS" size="0x8" />
	<field name="ppsld" descr="" subnode="ppsld_ext" capability="0" offset="0x0.0" selected_by="PPSLD" size="0x14" />
	<field name="ppspi" descr="" subnode="ppspi_ext" capability="0" offset="0x0.0" selected_by="PPSPI" size="0x3c" />
	<field name="ppspgc" descr="" subnode="ppspgc_ext" capability="0" offset="0x0.0" selected_by="PPSPGC" size="0xc" />
	<field name="ppspc" descr="" subnode="ppspc_ext" capability="0" offset="0x0.0" selected_by="PPSPC" size="0x28" />
	<field name="pbwc" descr="" subnode="pbwc_ext" capability="0" offset="0x0.0" selected_by="PBWC" size="0x8" />
	<field name="pbwr" descr="" subnode="pbwr_ext" capability="0" offset="0x0.0" selected_by="PBWR" size="0x94" />
	<field name="igcr" descr="" subnode="igcr_ext" capability="0" offset="0x0.0" selected_by="IGCR" size="0x10" />
	<field name="iddd" descr="" subnode="iddd_ext" capability="0" offset="0x0.0" selected_by="IDDD" size="0x8" />
	<field name="iddds" descr="" subnode="iddds_ext" capability="0" offset="0x0.0" selected_by="IDDDS" size="0x440" />
	<field name="iedr" descr="" subnode="iedr_ext" capability="0" offset="0x0.0" selected_by="IEDR" size="0x210" />
	<field name="ieds" descr="" subnode="ieds_ext" capability="0" offset="0x0.0" selected_by="IEDS" size="0x8" />
	<field name="ifbo" descr="" subnode="ifbo_ext" capability="0" offset="0x0.0" selected_by="IFBO" size="0x28" />
	<field name="iicr" descr="" subnode="iicr_ext" capability="0" offset="0x0.0" selected_by="IICR" size="0x34" />
	<field name="ipac" descr="" subnode="ipac_ext" capability="0" offset="0x0.0" selected_by="IPAC" size="0xb0" />
	<field name="ipsr" descr="" subnode="ipsr_ext" capability="0" offset="0x0.0" selected_by="IPSR" size="0x14" />
	<field name="iper" descr="" subnode="iper_ext" capability="0" offset="0x0.0" selected_by="IPER" size="0x20" />
	<field name="ihsr" descr="" subnode="ihsr_ext" capability="0" offset="0x0.0" selected_by="IHSR" size="0x50" />
	<field name="ihscr" descr="" subnode="ihscr_ext" capability="0" offset="0x0.0" selected_by="IHSCR" size="0xa8" />
	<field name="icsr" descr="" subnode="icsr_ext" capability="0" offset="0x0.0" selected_by="ICSR" size="0x410" />
	<field name="irqr" descr="" subnode="irqr_ext" capability="0" offset="0x0.0" selected_by="IRQR" size="0xc" />
	<field name="icam_reg" descr="" subnode="icam_reg_ext" capability="0" offset="0x0.0" selected_by="ICAM" size="0x18" />
	<field name="ITPR_reg" descr="" subnode="ITPR_reg_ext" capability="0" offset="0x0.0" selected_by="ITPR" size="0x14" />
	<field name="ITGCR_reg" descr="" subnode="ITGCR_reg_ext" capability="0" offset="0x0.0" selected_by="ITGCR" size="0x8" />
	<field name="ipcr" descr="" subnode="ipcr_ext" capability="0" offset="0x0.0" selected_by="IPCR" size="0xc" />
	<field name="ipfr" descr="" subnode="ipfr_ext" capability="0" offset="0x0.0" selected_by="IPFR" size="0x8" />
	<field name="spzr" descr="" subnode="spzr_ext" capability="0" offset="0x0.0" selected_by="SPZR" size="0x78" />
	<field name="ibfmr" descr="" subnode="ibfmr_ext" capability="0" offset="0x0.0" selected_by="IBFMR" size="0x10" />
	<field name="ibfmrc" descr="" subnode="ibfmrc_ext" capability="0" offset="0x0.0" selected_by="IBFMRC" size="0x4" />
	<field name="ibsni" descr="" subnode="ibsni_ext" capability="0" offset="0x0.0" selected_by="IBSNI" size="0x148" />
	<field name="ibissu" descr="" subnode="ibissu_ext" capability="0" offset="0x0.0" selected_by="IBISSU" size="0x4" />
	<field name="sbgcr" descr="" subnode="sbgcr_ext" capability="0" offset="0x0.0" selected_by="SBGCR" size="0x8" />
	<field name="sbpr" descr="" subnode="sbpr_ext" capability="0" offset="0x0.0" selected_by="SBPR" size="0x18" />
	<field name="sbcm" descr="" subnode="sbcm_ext" capability="0" offset="0x0.0" selected_by="SBCM" size="0x28" />
	<field name="sbpm" descr="" subnode="sbpm_ext" capability="0" offset="0x0.0" selected_by="SBPM" size="0x20" />
	<field name="sbmm" descr="" subnode="sbmm_ext" capability="0" offset="0x0.0" selected_by="SBMM" size="0x28" />
	<field name="sbme" descr="" subnode="sbme_ext" capability="0" offset="0x0.0" selected_by="SBME" size="0x28" />
	<field name="sbsr" descr="" subnode="sbsr_ext" capability="0" offset="0x0.0" selected_by="SBSR" size="0x41c" />
	<field name="sbsrd" descr="" subnode="sbsrd_ext" capability="0" offset="0x0.0" selected_by="SBSRD" size="0x450" />
	<field name="sbib" descr="" subnode="sbib_ext" capability="0" offset="0x0.0" selected_by="SBIB" size="0x10" />
	<field name="sbdcc" descr="" subnode="sbdcc_ext" capability="0" offset="0x0.0" selected_by="SBDCC" size="0x210" />
	<field name="sbdcm" descr="" subnode="sbdcm_ext" capability="0" offset="0x0.0" selected_by="SBDCM" size="0x14" />
	<field name="sbdcr" descr="" subnode="sbdcr_ext" capability="0" offset="0x0.0" selected_by="SBDCR" size="0x14" />
	<field name="sbhbr" descr="" subnode="sbhbr_ext" capability="0" offset="0x0.0" selected_by="SBHBR" size="0x1c" />
	<field name="sbhrr" descr="" subnode="sbhrr_ext" capability="0" offset="0x0.0" selected_by="SBHRR" size="0x60" />
	<field name="sbhbr_v2" descr="" subnode="sbhbr_v2_ext" capability="0" offset="0x0.0" selected_by="SBHBR_V2" size="0x20" />
	<field name="sbhrr_v2" descr="" subnode="sbhrr_v2_ext" capability="0" offset="0x0.0" selected_by="SBHRR_V2" size="0x90" />
	<field name="sbctc" descr="" subnode="sbctc_ext" capability="0" offset="0x0.0" selected_by="SBCTC" size="0x20" />
	<field name="sbctr" descr="" subnode="sbctr_ext" capability="0" offset="0x0.0" selected_by="SBCTR" size="0x18" />
	<field name="sbcts" descr="" subnode="sbcts_ext" capability="0" offset="0x0.0" selected_by="SBCTS" size="0x14" />
	<field name="sbhpc" descr="" subnode="sbhpc_ext" capability="0" offset="0x0.0" selected_by="SBHPC" size="0x24" />
	<field name="sbsnt" descr="" subnode="sbsnt_ext" capability="0" offset="0x0.0" selected_by="SBSNT" size="0x4" />
	<field name="sbsns" descr="" subnode="sbsns_ext" capability="0" offset="0x0.0" selected_by="SBSNS" size="0x18" />
	<field name="sbsnte" descr="" subnode="sbsnte_ext" capability="0" offset="0x0.0" selected_by="SBSNTE" size="0x10" />
	<field name="sbcam" descr="" subnode="sbcam_ext" capability="0" offset="0x0.0" selected_by="SBCAM" size="0x4c" />
	<field name="mpgcr" descr="" subnode="mpgcr_ext" capability="0" offset="0x0.0" selected_by="MPGCR" size="0x24" />
	<field name="mpilm" descr="" subnode="mpilm_ext" capability="0" offset="0x0.0" selected_by="MPILM" size="0x18" />
	<field name="mpibe" descr="" subnode="mpibe_ext" capability="0" offset="0x0.0" selected_by="MPIBE" size="0x28" />
	<field name="mpnhlfe" descr="" subnode="mpnhlfe_ext" capability="0" offset="0x0.0" selected_by="MPNHLFE" size="0x5c" />
	<field name="mpnhlfeb" descr="" subnode="mpnhlfeb_ext" capability="0" offset="0x0.0" selected_by="MPNHLFEB" size="0x410" />
	<field name="mpft" descr="" subnode="mpft_ext" capability="0" offset="0x0.0" selected_by="MPFT" size="0x8" />
	<field name="mpepm" descr="" subnode="mpepm_ext" capability="0" offset="0x0.0" selected_by="MPEPM" size="0x14" />
	<field name="mpqdr" descr="" subnode="mpqdr_ext" capability="0" offset="0x0.0" selected_by="MPQDR" size="0x8" />
	<field name="mpilem" descr="" subnode="mpilem_ext" capability="0" offset="0x0.0" selected_by="MPILEM" size="0x8" />
	<field name="tngcr" descr="" subnode="tngcr_ext" capability="0" offset="0x0.0" selected_by="TNGCR" size="0x64" />
	<field name="tnpc" descr="" subnode="tnpc_ext" capability="0" offset="0x0.0" selected_by="TNPC" size="0x1c" />
	<field name="tngee" descr="" subnode="tngee_ext" capability="0" offset="0x0.0" selected_by="TNGEE" size="0x50" />
	<field name="tncr" descr="" subnode="tncr_ext" capability="0" offset="0x0.0" selected_by="TNCR" size="0x30" />
	<field name="tncr_v2" descr="" subnode="tncr_v2_ext" capability="0" offset="0x0.0" selected_by="TNCR_V2" size="0x38" />
	<field name="tnumt" descr="" subnode="tnumt_ext" capability="0" offset="0x0.0" selected_by="TNUMT" size="0x20" />
	<field name="tnqcr" descr="" subnode="tnqcr_ext" capability="0" offset="0x0.0" selected_by="TNQCR" size="0xc" />
	<field name="tnqdr" descr="" subnode="tnqdr_ext" capability="0" offset="0x0.0" selected_by="TNQDR" size="0x8" />
	<field name="tneem" descr="" subnode="tneem_ext" capability="0" offset="0x0.0" selected_by="TNEEM" size="0xc" />
	<field name="tndem" descr="" subnode="tndem_ext" capability="0" offset="0x0.0" selected_by="TNDEM" size="0xc" />
	<field name="tnifr" descr="" subnode="tnifr_ext" capability="0" offset="0x0.0" selected_by="TNIFR" size="0x60" />
	<field name="tnifr_v2" descr="" subnode="tnifr_v2_ext" capability="0" offset="0x0.0" selected_by="TNIFR_V2" size="0x120" />
	<field name="tnipsd" descr="" subnode="tnipsd_ext" capability="0" offset="0x0.0" selected_by="TNIPSD" size="0x420" />
	<field name="tigcr" descr="" subnode="tigcr_ext" capability="0" offset="0x0.0" selected_by="TIGCR" size="0x18" />
	<field name="tiqcr" descr="" subnode="tiqcr_ext" capability="0" offset="0x0.0" selected_by="TIQCR" size="0xc" />
	<field name="tiqdr" descr="" subnode="tiqdr_ext" capability="0" offset="0x0.0" selected_by="TIQDR" size="0x8" />
	<field name="tieem" descr="" subnode="tieem_ext" capability="0" offset="0x0.0" selected_by="TIEEM" size="0xc" />
	<field name="tidem" descr="" subnode="tidem_ext" capability="0" offset="0x0.0" selected_by="TIDEM" size="0xc" />
	<field name="rcap" descr="" subnode="rcap_ext" capability="0" offset="0x0.0" selected_by="RCAP" size="0x8" />
	<field name="rgcr" descr="" subnode="rgcr_ext" capability="0" offset="0x0.0" selected_by="RGCR" size="0x28" />
	<field name="ritr" descr="" subnode="ritr_ext" capability="0" offset="0x0.0" selected_by="RITR" size="0x40" />
	<field name="rigr_v2" descr="" subnode="rigr_v2_ext" capability="0" offset="0x0.0" selected_by="RIGR_V2" size="0xb0" />
	<field name="rtar_tcam" descr="" subnode="rtar_tcam_ext" capability="0" offset="0x0.0" selected_by="RTAR" size="0x8" />
	<field name="recr" descr="" subnode="recr_ext" capability="0" offset="0x0.0" selected_by="RECR" size="0x10" />
	<field name="recr_v2" descr="" subnode="recr_v2_ext" capability="0" offset="0x0.0" selected_by="RECR_V2" size="0x50" />
	<field name="ruft" descr="" subnode="ruft_ext" capability="0" offset="0x0.0" selected_by="RUFT" size="0x78" />
	<field name="rmft" descr="" subnode="rmft_ext" capability="0" offset="0x0.0" selected_by="RMFT" size="0x90" />
	<field name="rmft_v2" descr="" subnode="rmft_v2_ext" capability="0" offset="0x0.0" selected_by="RMFT_V2" size="0x128" />
	<field name="rmftad" descr="" subnode="rmftad_ext" capability="0" offset="0x0.0" selected_by="RMFTAD" size="0x220" />
	<field name="rrcr" descr="" subnode="rrcr_ext" capability="0" offset="0x0.0" selected_by="RRCR" size="0x24" />
	<field name="ratr" descr="" subnode="ratr_ext" capability="0" offset="0x0.0" selected_by="RATR" size="0x2c" />
	<field name="ratrb" descr="" subnode="ratrb_ext" capability="0" offset="0x0.0" selected_by="RATRB" size="0x420" />
	<field name="ratrad" descr="" subnode="ratrad_ext" capability="0" offset="0x0.0" selected_by="RATRAD" size="0x210" />
	<field name="rtdp" descr="" subnode="rtdp_ext" capability="0" offset="0x0.0" selected_by="RTDP" size="0x44" />
	<field name="rips_ip" descr="" subnode="rips_ip_ext" capability="0" offset="0x0.0" selected_by="RIPS" size="0x14" />
	<field name="rdpm" descr="" subnode="rdpm_ext" capability="0" offset="0x0.0" selected_by="RDPM" size="0x40" />
	<field name="ricnt_inter" descr="" subnode="ricnt_inter_ext" capability="0" offset="0x0.0" selected_by="RICNT" size="0x100" />
	<field name="ralta" descr="" subnode="ralta_ext" capability="0" offset="0x0.0" selected_by="RALTA" size="0x4" />
	<field name="ralst" descr="" subnode="ralst_ext" capability="0" offset="0x0.0" selected_by="RALST" size="0x104" />
	<field name="raltb" descr="" subnode="raltb_ext" capability="0" offset="0x0.0" selected_by="RALTB" size="0x4" />
	<field name="ralue" descr="" subnode="ralue_ext" capability="0" offset="0x0.0" selected_by="RALUE" size="0x3c" />
	<field name="rauht_lpm_unicast" descr="" subnode="rauht_lpm_unicast_ext" capability="0" offset="0x0.0" selected_by="RAUHT" size="0x74" />
	<field name="rauhtd" descr="" subnode="rauhtd_ext" capability="0" offset="0x0.0" selected_by="RAUHTD" size="0x20" />
	<field name="raleu" descr="" subnode="raleu_ext" capability="0" offset="0x0.0" selected_by="RALEU" size="0x30" />
	<field name="ralbu" descr="" subnode="ralbu_ext" capability="0" offset="0x0.0" selected_by="RALBU" size="0x20" />
	<field name="ralcm" descr="" subnode="ralcm_ext" capability="0" offset="0x0.0" selected_by="RALCM" size="0x4" />
	<field name="rmid" descr="" subnode="rmid_ext" capability="0" offset="0x0.0" selected_by="RMID" size="0x40" />
	<field name="rmid_v2" descr="" subnode="rmid_v2_ext" capability="0" offset="0x0.0" selected_by="RMID_V2" size="0xa0" />
	<field name="rmpe" descr="" subnode="rmpe_ext" capability="0" offset="0x0.0" selected_by="RMPE" size="0xc" />
	<field name="rmpu" descr="" subnode="rmpu_ext" capability="0" offset="0x0.0" selected_by="RMPU" size="0x110" />
	<field name="rmeir" descr="" subnode="rmeir_ext" capability="0" offset="0x0.0" selected_by="RMEIR" size="0x210" />
	<field name="reiv" descr="" subnode="reiv_ext" capability="0" offset="0x0.0" selected_by="REIV" size="0x420" />
	<field name="rngcr" descr="" subnode="rngcr_ext" capability="0" offset="0x0.0" selected_by="RNGCR" size="0xc" />
	<field name="rxlte" descr="" subnode="rxlte_ext" capability="0" offset="0x0.0" selected_by="RXLTE" size="0xc" />
	<field name="rxltm" descr="" subnode="rxltm_ext" capability="0" offset="0x0.0" selected_by="RXLTM" size="0x14" />
	<field name="rxltcc" descr="" subnode="rxltcc_ext" capability="0" offset="0x0.0" selected_by="RXLTCC" size="0x68" />
	<field name="rlpmce" descr="" subnode="rlpmce_ext" capability="0" offset="0x0.0" selected_by="RLPMCE" size="0x4" />
	<field name="rlcme" descr="" subnode="rlcme_ext" capability="0" offset="0x0.0" selected_by="RLCME" size="0x3c" />
	<field name="rlcmle" descr="" subnode="rlcmle_ext" capability="0" offset="0x0.0" selected_by="RLCMLE" size="0x38" />
	<field name="rlcmld" descr="" subnode="rlcmld_ext" capability="0" offset="0x0.0" selected_by="RLCMLD" size="0x30" />
	<field name="rargcr" descr="" subnode="rargcr_ext" capability="0" offset="0x0.0" selected_by="RARGCR" size="0x8" />
	<field name="rarpc" descr="" subnode="rarpc_ext" capability="0" offset="0x0.0" selected_by="RARPC" size="0xd0" />
	<field name="rarsr" descr="" subnode="rarsr_ext" capability="0" offset="0x0.0" selected_by="RARSR" size="0x8" />
	<field name="rarpr" descr="" subnode="rarpr_ext" capability="0" offset="0x0.0" selected_by="RARPR" size="0x14" />
	<field name="rarcl" descr="" subnode="rarcl_ext" capability="0" offset="0x0.0" selected_by="RARCL" size="0x2c" />
	<field name="rargmc" descr="" subnode="rargmc_ext" capability="0" offset="0x0.0" selected_by="RARGMC" size="0x20" />
	<field name="rarptm" descr="" subnode="rarptm_ext" capability="0" offset="0x0.0" selected_by="RARPTM" size="0x8" />
	<field name="rarppm" descr="" subnode="rarppm_ext" capability="0" offset="0x0.0" selected_by="RARPPM" size="0x8" />
	<field name="rarlu" descr="" subnode="rarlu_ext" capability="0" offset="0x0.0" selected_by="RARLU" size="0xc" />
	<field name="rarft" descr="" subnode="rarft_ext" capability="0" offset="0x0.0" selected_by="RARFT" size="0x10" />
	<field name="rarftb" descr="" subnode="rarftb_ext" capability="0" offset="0x0.0" selected_by="RARFTB" size="0x8" />
	<field name="rarlpgt" descr="" subnode="rarlpgt_ext" capability="0" offset="0x0.0" selected_by="RARLPGT" size="0xa0" />
	<field name="rarcc" descr="" subnode="rarcc_ext" capability="0" offset="0x0.0" selected_by="RARCC" size="0x20" />
	<field name="rartm" descr="" subnode="rartm_ext" capability="0" offset="0x0.0" selected_by="RARTM" size="0x44" />
	<field name="rarngc" descr="" subnode="rarngc_ext" capability="0" offset="0x0.0" selected_by="RARNGC" size="0x1c" />
	<field name="rarnpc" descr="" subnode="rarnpc_ext" capability="0" offset="0x0.0" selected_by="RARNPC" size="0x10" />
	<field name="rarnpr" descr="" subnode="rarnpr_ext" capability="0" offset="0x0.0" selected_by="RARNPR" size="0xc" />
	<field name="rarncp" descr="" subnode="rarncp_ext" capability="0" offset="0x0.0" selected_by="RARNCP" size="0xc" />
	<field name="rarncg" descr="" subnode="rarncg_ext" capability="0" offset="0x0.0" selected_by="RARNCG" size="0x20" />
	<field name="rarns" descr="" subnode="rarns_ext" capability="0" offset="0x0.0" selected_by="RARNS" size="0x8" />
	<field name="rsnh" descr="" subnode="rsnh_ext" capability="0" offset="0x0.0" selected_by="RSNH" size="0x10" />
	<field name="rtca" descr="" subnode="rtca_ext" capability="0" offset="0x0.0" selected_by="RTCA" size="0x14" />
	<field name="rtps" descr="" subnode="rtps_ext" capability="0" offset="0x0.0" selected_by="RTPS" size="0x8" />
	<field name="riva" descr="" subnode="riva_ext" capability="0" offset="0x0.0" selected_by="RIVA" size="0x10" />
	<field name="rirt" descr="" subnode="rirt_ext" capability="0" offset="0x0.0" selected_by="RIRT" size="0x50" />
	<field name="cwgcr" descr="" subnode="cwgcr_ext" capability="0" offset="0x0.0" selected_by="CWGCR" size="0x14" />
	<field name="cwtp" descr="" subnode="cwtp_ext" capability="0" offset="0x0.0" selected_by="CWTP" size="0x40" />
	<field name="cwpp" descr="" subnode="cwpp_ext" capability="0" offset="0x0.0" selected_by="CWPP" size="0x20" />
	<field name="cwtpm" descr="" subnode="cwtpm_ext" capability="0" offset="0x0.0" selected_by="CWTPM" size="0x44" />
	<field name="cpqe" descr="" subnode="cpqe_ext" capability="0" offset="0x0.0" selected_by="CPQE" size="0x14" />
	<field name="chltr" descr="" subnode="chltr_ext" capability="0" offset="0x0.0" selected_by="CHLTR" size="0xc" />
	<field name="chltm" descr="" subnode="chltm_ext" capability="0" offset="0x0.0" selected_by="CHLTM" size="0x14" />
	<field name="chlmm" descr="" subnode="chlmm_ext" capability="0" offset="0x0.0" selected_by="CHLMM" size="0x14" />
	<field name="cegcr" descr="" subnode="cegcr_ext" capability="0" offset="0x0.0" selected_by="CEGCR" size="0x20" />
	<field name="cepc" descr="" subnode="cepc_ext" capability="0" offset="0x0.0" selected_by="CEPC" size="0x8" />
	<field name="cedr" descr="" subnode="cedr_ext" capability="0" offset="0x0.0" selected_by="CEDR" size="0x20" />
	<field name="ceer" descr="" subnode="ceer_ext" capability="0" offset="0x0.0" selected_by="CEER" size="0xa0" />
	<field name="qgcr" descr="" subnode="qgcr_ext" capability="0" offset="0x0.0" selected_by="QGCR" size="0x8" />
	<field name="qcap" descr="" subnode="qcap_ext" capability="0" offset="0x0.0" selected_by="QCAP" size="0x14" />
	<field name="qpts" descr="" subnode="qpts_ext" capability="0" offset="0x0.0" selected_by="QPTS" size="0x8" />
	<field name="qdpm" descr="" subnode="qdpm_ext" capability="0" offset="0x0.0" selected_by="QDPM" size="0x40" />
	<field name="qpdpm" descr="" subnode="qpdpm_ext" capability="0" offset="0x0.0" selected_by="QPDPM" size="0x84" />
	<field name="qepm" descr="" subnode="qepm_ext" capability="0" offset="0x0.0" selected_by="QEPM" size="0x14" />
	<field name="qpcr" descr="" subnode="qpcr_ext" capability="0" offset="0x0.0" selected_by="QPCR" size="0x28" />
	<field name="qpbr" descr="" subnode="qpbr_ext" capability="0" offset="0x0.0" selected_by="QPBR" size="0x10" />
	<field name="qetcr" descr="" subnode="qetcr_ext" capability="0" offset="0x0.0" selected_by="QETCR" size="0x50" />
	<field name="qshr" descr="" subnode="qshr_ext" capability="0" offset="0x0.0" selected_by="QSHR" size="0x50" />
	<field name="qeec" descr="" subnode="qeec_ext" capability="0" offset="0x0.0" selected_by="QEEC" size="0x20" />
	<field name="qpdp" descr="" subnode="qpdp_ext" capability="0" offset="0x0.0" selected_by="QPDP" size="0x8" />
	<field name="qpdpc" descr="" subnode="qpdpc_ext" capability="0" offset="0x0.0" selected_by="QPDPC" size="0x8" />
	<field name="qprt" descr="" subnode="qprt_ext" capability="0" offset="0x0.0" selected_by="QPRT" size="0x8" />
	<field name="qtct" descr="" subnode="qtct_ext" capability="0" offset="0x0.0" selected_by="QTCT" size="0x8" />
	<field name="qtctm" descr="" subnode="qtctm_ext" capability="0" offset="0x0.0" selected_by="QTCTM" size="0x8" />
	<field name="qspip" descr="" subnode="qspip_ext" capability="0" offset="0x0.0" selected_by="QSPIP" size="0x8" />
	<field name="qspcp" descr="" subnode="qspcp_ext" capability="0" offset="0x0.0" selected_by="QSPCP" size="0xc" />
	<field name="qrwe" descr="" subnode="qrwe_ext" capability="0" offset="0x0.0" selected_by="QRWE" size="0x8" />
	<field name="qpem" descr="" subnode="qpem_ext" capability="0" offset="0x0.0" selected_by="QPEM" size="0x104" />
	<field name="qpdsm" descr="" subnode="qpdsm_ext" capability="0" offset="0x0.0" selected_by="QPDSM" size="0x44" />
	<field name="qppm" descr="" subnode="qppm_ext" capability="0" offset="0x0.0" selected_by="QPPM" size="0x44" />
	<field name="qsll" descr="" subnode="qsll_ext" capability="0" offset="0x0.0" selected_by="QSLL" size="0x8" />
	<field name="qhll" descr="" subnode="qhll_ext" capability="0" offset="0x0.0" selected_by="QHLL" size="0xc" />
	<field name="qsipg" descr="" subnode="qsipg_ext" capability="0" offset="0x0.0" selected_by="QSIPG" size="0x8" />
	<field name="qcam" descr="" subnode="qcam_ext" capability="0" offset="0x0.0" selected_by="QCAM" size="0x48" />
	<field name="qtttl" descr="" subnode="qtttl_ext" capability="0" offset="0x0.0" selected_by="QTTTL" size="0xc" />
	<field name="qtqcr" descr="" subnode="qtqcr_ext" capability="0" offset="0x0.0" selected_by="QTQCR" size="0xc" />
	<field name="qtqdr" descr="" subnode="qtqdr_ext" capability="0" offset="0x0.0" selected_by="QTQDR" size="0x8" />
	<field name="qteem" descr="" subnode="qteem_ext" capability="0" offset="0x0.0" selected_by="QTEEM" size="0xc" />
	<field name="qtdem" descr="" subnode="qtdem_ext" capability="0" offset="0x0.0" selected_by="QTDEM" size="0xc" />
	<field name="qptg" descr="" subnode="qptg_ext" capability="0" offset="0x0.0" selected_by="QPTG" size="0x8" />
	<field name="qtgtc" descr="" subnode="qtgtc_ext" capability="0" offset="0x0.0" selected_by="QTGTC" size="0x10" />
	<field name="pgcr" descr="" subnode="pgcr_ext" capability="0" offset="0x0.0" selected_by="PGCR" size="0x20" />
	<field name="ppbt" descr="" subnode="ppbt_ext" capability="0" offset="0x0.0" selected_by="PPBT" size="0x14" />
	<field name="pevpb" descr="" subnode="pevpb_ext" capability="0" offset="0x0.0" selected_by="PEVPB" size="0x8" />
	<field name="pvgt" descr="" subnode="pvgt_ext" capability="0" offset="0x0.0" selected_by="PVGT" size="0x8" />
	<field name="pvbt" descr="" subnode="pvbt_ext" capability="0" offset="0x0.0" selected_by="PVBT" size="0x14" />
	<field name="prbt" descr="" subnode="prbt_ext" capability="0" offset="0x0.0" selected_by="PRBT" size="0x14" />
	<field name="pemrbt" descr="" subnode="pemrbt_ext" capability="0" offset="0x0.0" selected_by="PEMRBT" size="0x14" />
	<field name="perb" descr="" subnode="perb_ext" capability="0" offset="0x0.0" selected_by="PERB" size="0xe4" />
	<field name="perbrg" descr="" subnode="perbrg_ext" capability="0" offset="0x0.0" selected_by="PERBRG" size="0x10" />
	<field name="perbeg" descr="" subnode="perbeg_ext" capability="0" offset="0x0.0" selected_by="PERBEG" size="0x10" />
	<field name="pacl" descr="" subnode="pacl_ext" capability="0" offset="0x0.0" selected_by="PACL" size="0x70" />
	<field name="pagt" descr="" subnode="pagt_ext" capability="0" offset="0x0.0" selected_by="PAGT" size="0x80" />
	<field name="pagt_v2" descr="" subnode="pagt_v2_ext" capability="0" offset="0x0.0" selected_by="PAGT_V2" size="0x18" />
	<field name="pagtq" descr="" subnode="pagtq_ext" capability="0" offset="0x0.0" selected_by="PAGTQ" size="0x110" />
	<field name="ptar" descr="" subnode="ptar_ext" capability="0" offset="0x0.0" selected_by="PTAR" size="0x30" />
	<field name="perla" descr="" subnode="perla_ext" capability="0" offset="0x0.0" selected_by="PERLA" size="0x8" />
	<field name="perar" descr="" subnode="perar_ext" capability="0" offset="0x0.0" selected_by="PERAR" size="0x8" />
	<field name="percr" descr="" subnode="percr_ext" capability="0" offset="0x0.0" selected_by="PERCR" size="0x80" />
	<field name="pererp" descr="" subnode="pererp_ext" capability="0" offset="0x0.0" selected_by="PERERP" size="0x1c" />
	<field name="perd" descr="" subnode="perd_ext" capability="0" offset="0x0.0" selected_by="PERD" size="0x50" />
	<field name="ptce" descr="" subnode="ptce_ext" capability="0" offset="0x0.0" selected_by="PTCE" size="0xf0" />
	<field name="ptce_v2" descr="" subnode="ptce_v2_ext" capability="0" offset="0x0.0" selected_by="PTCE_V2" size="0x188" />
	<field name="ptce_v3" descr="" subnode="ptce_v3_ext" capability="0" offset="0x0.0" selected_by="PTCE_V3" size="0xa4" />
	<field name="ptcead" descr="" subnode="ptcead_ext" capability="0" offset="0x0.0" selected_by="PTCEAD" size="0x220" />
	<field name="pefa" descr="" subnode="pefa_ext" capability="0" offset="0x0.0" selected_by="PEFA" size="0xb0" />
	<field name="pefaad" descr="" subnode="pefaad_ext" capability="0" offset="0x0.0" selected_by="PEFAAD" size="0x420" />
	<field name="prcr" descr="" subnode="prcr_ext" capability="0" offset="0x0.0" selected_by="PRCR" size="0x40" />
	<field name="pprr" descr="" subnode="pprr_ext" capability="0" offset="0x0.0" selected_by="PPRR" size="0x14" />
	<field name="pfca" descr="" subnode="pfca_ext" capability="0" offset="0x0.0" selected_by="PFCA" size="0xc" />
	<field name="pfcnt" descr="" subnode="pfcnt_ext" capability="0" offset="0x0.0" selected_by="PFCNT" size="0x28" />
	<field name="ppbs" descr="" subnode="ppbs_ext" capability="0" offset="0x0.0" selected_by="PPBS" size="0x1c" />
	<field name="puet" descr="" subnode="puet_ext" capability="0" offset="0x0.0" selected_by="PUET" size="0x10" />
	<field name="ppbmi" descr="" subnode="ppbmi_ext" capability="0" offset="0x0.0" selected_by="PPBMI" size="0x18" />
	<field name="pecb" descr="" subnode="pecb_ext" capability="0" offset="0x0.0" selected_by="PECB" size="0x210" />
	<field name="perpt" descr="" subnode="perpt_ext" capability="0" offset="0x0.0" selected_by="PERPT" size="0x80" />
	<field name="peabfe" descr="" subnode="peabfe_ext" capability="0" offset="0x0.0" selected_by="PEABFE" size="0x410" />
	<field name="peapbl" descr="" subnode="peapbl_ext" capability="0" offset="0x0.0" selected_by="PEAPBL" size="0x20" />
	<field name="peapbm" descr="" subnode="peapbm_ext" capability="0" offset="0x0.0" selected_by="PEAPBM" size="0xf8" />
	<field name="peaps" descr="" subnode="peaps_ext" capability="0" offset="0x0.0" selected_by="PEAPS" size="0x34" />
	<field name="pecnre" descr="" subnode="pecnre_ext" capability="0" offset="0x0.0" selected_by="PECNRE" size="0x10" />
	<field name="pecnrr" descr="" subnode="pecnrr_ext" capability="0" offset="0x0.0" selected_by="PECNRR" size="0x20" />
	<field name="pecnee" descr="" subnode="pecnee_ext" capability="0" offset="0x0.0" selected_by="PECNEE" size="0x18" />
	<field name="pecner" descr="" subnode="pecner_ext" capability="0" offset="0x0.0" selected_by="PECNER" size="0x38" />
	<field name="peckc" descr="" subnode="peckc_ext" capability="0" offset="0x0.0" selected_by="PECKC" size="0x30" />
	<field name="petcm" descr="" subnode="petcm_ext" capability="0" offset="0x0.0" selected_by="PETCM" size="0x20" />
	<field name="fgcr" descr="" subnode="fgcr_ext" capability="0" offset="0x0.0" selected_by="FGCR" size="0x10" />
	<field name="fpums" descr="" subnode="fpums_ext" capability="0" offset="0x0.0" selected_by="FPUMS" size="0x14" />
	<field name="fphhc" descr="" subnode="fphhc_ext" capability="0" offset="0x0.0" selected_by="FPHHC" size="0xc" />
	<field name="fppc" descr="" subnode="fppc_ext" capability="0" offset="0x0.0" selected_by="FPPC" size="0x60" />
	<field name="fpftt" descr="" subnode="fpftt_ext" capability="0" offset="0x0.0" selected_by="FPFTT" size="0x14" />
	<field name="fphtt" descr="" subnode="fphtt_ext" capability="0" offset="0x0.0" selected_by="FPHTT" size="0x8" />
	<field name="fpts" descr="" subnode="fpts_ext" capability="0" offset="0x0.0" selected_by="FPTS" size="0xc" />
	<field name="fmtc" descr="" subnode="fmtc_ext" capability="0" offset="0x0.0" selected_by="FMTC" size="0x4c" />
	<field name="fmte" descr="" subnode="fmte_ext" capability="0" offset="0x0.0" selected_by="FMTE" size="0x14" />
	<field name="fmtm" descr="" subnode="fmtm_ext" capability="0" offset="0x0.0" selected_by="FMTM" size="0x8" />
	<field name="fmep" descr="" subnode="fmep_ext" capability="0" offset="0x0.0" selected_by="FMEP" size="0x8" />
	<field name="FMQC" descr="" subnode="FMQC_ext" capability="0" offset="0x0.0" selected_by="FMQC" size="0xc" />
	<field name="FSGCR" descr="" subnode="FSGCR_ext" capability="0" offset="0x0.0" selected_by="FSGCR" size="0xc" />
	<field name="FSDB" descr="" subnode="FSDB_ext" capability="0" offset="0x0.0" selected_by="FSDB" size="0x78" />
	<field name="fspt" descr="" subnode="fspt_ext" capability="0" offset="0x0.0" selected_by="FSPT" size="0x44" />
	<field name="FSPS" descr="" subnode="FSPS_ext" capability="0" offset="0x0.0" selected_by="FSPS" size="0x10" />
	<field name="fsdc" descr="" subnode="fsdc_ext" capability="0" offset="0x0.0" selected_by="FSDC" size="0x10" />
	<field name="FSTM" descr="" subnode="FSTM_ext" capability="0" offset="0x0.0" selected_by="FSTM" size="0x414" />
	<field name="fsed" descr="" subnode="fsed_ext" capability="0" offset="0x0.0" selected_by="FSED" size="0x590" />
	<field name="FSHE" descr="" subnode="FSHE_ext" capability="0" offset="0x0.0" selected_by="FSHE" size="0x8" />
	<field name="FSFH" descr="" subnode="FSFH_ext" capability="0" offset="0x0.0" selected_by="FSFH" size="0xac" />
	<field name="fmtpc" descr="" subnode="fmtpc_ext" capability="0" offset="0x0.0" selected_by="FMTPC" size="0x14" />
	<field name="fmtpa" descr="" subnode="fmtpa_ext" capability="0" offset="0x0.0" selected_by="FMTPA" size="0x10" />
	<field name="fmtb" descr="" subnode="fmtb_ext" capability="0" offset="0x0.0" selected_by="FMTB" size="0x1c" />
	<field name="frar" descr="" subnode="frar_ext" capability="0" offset="0x0.0" selected_by="FRAR" size="0x110" />
	<field name="ugcap" descr="" subnode="ugcap_ext" capability="0" offset="0x0.0" selected_by="UGCAP" size="0x18" />
	<field name="upcap" descr="" subnode="upcap_ext" capability="0" offset="0x0.0" selected_by="UPCAP" size="0x8" />
	<field name="ugcr" descr="" subnode="ugcr_ext" capability="0" offset="0x0.0" selected_by="UGCR" size="0x10" />
	<field name="upcon" descr="" subnode="upcon_ext" capability="0" offset="0x0.0" selected_by="UPCON" size="0xc" />
	<field name="umtu" descr="" subnode="umtu_ext" capability="0" offset="0x0.0" selected_by="UMTU" size="0x8" />
	<field name="uver" descr="" subnode="uver_ext" capability="0" offset="0x0.0" selected_by="UVER" size="0x8" />
	<field name="upvc" descr="" subnode="upvc_ext" capability="0" offset="0x0.0" selected_by="UPVC" size="0x8" />
	<field name="upaft" descr="" subnode="upaft_ext" capability="0" offset="0x0.0" selected_by="UPAFT" size="0x8" />
	<field name="utar" descr="" subnode="utar_ext" capability="0" offset="0x0.0" selected_by="UTAR" size="0xc" />
	<field name="upbt" descr="" subnode="upbt_ext" capability="0" offset="0x0.0" selected_by="UPBT" size="0x1c" />
	<field name="utce" descr="" subnode="utce_ext" capability="0" offset="0x0.0" selected_by="UTCE" size="0x84" />
	<field name="urcr" descr="" subnode="urcr_ext" capability="0" offset="0x0.0" selected_by="URCR" size="0x10" />
	<field name="usadb" descr="" subnode="usadb_ext" capability="0" offset="0x0.0" selected_by="USADB" size="0x34" />
	<field name="usak" descr="" subnode="usak_ext" capability="0" offset="0x0.0" selected_by="USAK" size="0x24" />
	<field name="usacn" descr="" subnode="usacn_ext" capability="0" offset="0x0.0" selected_by="USACN" size="0x28" />
	<field name="utcc" descr="" subnode="utcc_ext" capability="0" offset="0x0.0" selected_by="UTCC" size="0x88" />
	<field name="upcnt" descr="" subnode="upcnt_ext" capability="0" offset="0x0.0" selected_by="UPCNT" size="0x68" />
	<field name="uprr" descr="" subnode="uprr_ext" capability="0" offset="0x0.0" selected_by="UPRR" size="0xc" />
	<field name="uccr" descr="" subnode="uccr_ext" capability="0" offset="0x0.0" selected_by="UCCR" size="0x8" />
	<field name="utfd" descr="" subnode="utfd_ext" capability="0" offset="0x0.0" selected_by="UTFD" size="0xf8" />
	<field name="utfc" descr="" subnode="utfc_ext" capability="0" offset="0x0.0" selected_by="UTFC" size="0x10" />
	<field name="uter" descr="" subnode="uter_ext" capability="0" offset="0x0.0" selected_by="UTER" size="0x30" />
</node>

<node name="access_reg_summary_selector_ext" descr="" attr_is_union="1" size="0x26e0" >
	<field name="access_reg_summary" descr="" subnode="access_reg_summary_ext" offset="0x0.0" size="0x26e0" union_selector="$(parent).ctrl.id" />
	<field name="ctrl" descr="" subnode="access_reg_summary_ctrl_ext" offset="0x0.0" size="0x4.0" />
</node>

<node name="acl_id_record_ext" descr="" size="0x4.0" >
	<field name="acl_id" descr="ACL identifier\;Range 0 .. cap_max_acl_regions - 1" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="commit" descr="ACL Commit\;0: No dedicated commit when the ACL is ended\;1: Do a commit when the ACL is ended\;All ACLs of a multi-ACL should have the same commit value\;Reserved when SwitchX/-2 and for Spectrum" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="multi" descr="Multi-ACL\;0: This ACL is the last ACL in the multi-ACL\;1: This ACL is part of a multi-ACL\;Reserved when SwitchX/-2 and for Spectrum" access="RW" offset="0x0.31" size="0x0.1" />
</node>

<node name="action_buffer_snap_ext" descr="" size="0x8.0" >
	<field name="snap_id" descr="Snapshot Trigger ID (see SBSNS.trigger_id):\;0: 0x10\;...\;7: 0x17" offset="0x0.0" size="0x0.3" />
</node>

<node name="action_counting_cardinality_counter_ext" descr="" size="0x10.0" >
	<field name="cbset" descr="Cbset index\;Range 0 .. cap_max_custom_byte_sets-1" offset="0x0.0" size="0x0.4" />
</node>

<node name="action_counting_cardinality_ext" descr="" size="0x18.0" >
	<field name="type" descr="0: Counter\;" enum="Counter=0x0" offset="0x0.0" size="0x0.4" />
	<field name="meter_params" descr="See Table 2604, &quot;COUNTER_BY_REF_PARAM Block Layout,&quot; on page 2856" subnode="action_counting_cardinality_meter_params_auto_ext" offset="0x8.0" size="0x10.0" union_selector="$(parent).type" />
</node>

<node name="action_counting_cardinality_meter_params_auto_ext" descr="" attr_is_union="1" size="0x10.0" >
	<field name="action_counting_cardinality_counter_ext" descr="" subnode="action_counting_cardinality_counter_ext" offset="0x0.0" selected_by="Counter" size="0x10.0" />
</node>

<node name="action_custom_bytes_alu_field_ext" descr="" size="0x10.0" >
	<field name="cbset" descr="Custom Bytes set" offset="0x0.0" size="0x0.8" />
	<field name="opcode" descr="Opcode:\;0: SET_FIELD\;1: ADD_FIELD\;2: AND_FIELD\;3: OR_FIELD\;4: SUB_FIELD\;5: XOR_FIELD\;6: ADDC_FIELD\;7: SUBC_FIELD" offset="0x0.16" size="0x0.8" />
	<field name="field_select" descr="Field select, see Table 2666, &quot;Fields Select,&quot; on page 2903" offset="0x4.0" size="0x0.8" />
	<field name="mask" descr="mask\;Mask != 0\;Mask must have successive 1&quot;s\;E.g.:\;0001_1111_1000_0000" offset="0x8.0" size="0x0.16" />
	<field name="shr" descr="Shift right" offset="0xC.0" size="0x0.4" />
</node>

<node name="action_custom_bytes_alu_imm_ext" descr="" size="0x10.0" >
	<field name="dest_cbset" descr="DEST Custom Bytes set" offset="0x0.0" size="0x0.8" />
	<field name="opcode" descr="Opcode:\;0: SET_IMM\;1: ADD_IMM\;2: AND_IMM\;3: OR_IMM" offset="0x0.16" size="0x0.8" />
	<field name="imm" descr="Immediate" offset="0x4.0" size="0x0.16" />
	<field name="mask" descr="mask\;Mask != 0\;Mask has successive 1&quot;s\;E.g.:\;0001_1111_1000_0000" offset="0x8.0" size="0x0.16" />
</node>

<node name="action_custom_bytes_alu_reg_ext" descr="" size="0x10.0" >
	<field name="dest_cbset" descr="DEST Custom Bytes set" offset="0x0.0" size="0x0.8" />
	<field name="opcode" descr="Opcode:\;0: SET_REG\;1: ADD_REG\;2: AND_REG\;3: OR_REG\;4: SUB_REG\;5: XOR_REG\;6: ADDC_REG\;7: SUBC_REG" offset="0x0.16" size="0x0.8" />
	<field name="src_cbset" descr="SRC Custom Bytes set" offset="0x4.0" size="0x0.8" />
	<field name="mask" descr="mask\;Mask != 0\;Mask has successive 1&quot;s\;E.g.:\;0001_1111_1000_0000" offset="0x8.0" size="0x0.16" />
	<field name="shr" descr="Shift right" offset="0xC.0" size="0x0.4" />
</node>

<node name="action_custom_bytes_move_ext" descr="" size="0x10.0" >
	<field name="dest_cbset" descr="DEST Custom Bytes set\;Reserved when opcode = MSTR" offset="0x0.0" size="0x0.8" />
	<field name="size" descr="Number of custom_byte_sets/ fields to move\;Starting from src_cbset/dest_cbset/field_select" offset="0x0.8" size="0x0.8" />
	<field name="opcode" descr="Opcode:\;0: MMOVE\;1: MLOAD\;2: MSTR" enum="MMOVE=0x0,MLOAD=0x1,MSTR=0x2" offset="0x0.16" size="0x0.8" />
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0x0.31" size="0x0.1" />
	<field name="src_cbset" descr="SRC Custom Bytes set\;Reserved when opcode = MLOAD" offset="0x4.0" size="0x0.8" />
	<field name="field_select" descr="Field select, see Table 2666, &quot;Fields Select,&quot; on page 2903\;Reserved when opcode = MMOVE" offset="0x8.0" size="0x0.8" />
</node>

<node name="action_fields_move_ext" descr="" size="0x10.0" >
	<field name="dest_field_select" descr="DEST Field select, see Table 2666, &quot;Fields Select,&quot; on page 2903" offset="0x0.0" size="0x0.8" />
	<field name="size" descr="Number of fields to set\;Starting from dest_field_select/src_field_select" offset="0x0.8" size="0x0.8" />
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0x0.31" size="0x0.1" />
	<field name="src_field_select" descr="SRC Field select, see Table 2666, &quot;Fields Select,&quot; on page 2903" offset="0x4.0" size="0x0.8" />
</node>

<node name="action_fields_set_imm_ext" descr="" size="0x10.0" >
	<field name="dest_field_select" descr="DEST Field select, see Table 2666, &quot;Fields Select,&quot; on page 2903" offset="0x0.0" size="0x0.8" />
	<field name="size" descr="Number of fields to set (all with same imm value)\;Starting from dest_field_select" offset="0x0.8" size="0x0.8" />
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0x0.31" size="0x0.1" />
	<field name="imm" descr="Immediate" offset="0x4.0" size="0x0.16" />
</node>

<node name="action_flex_modifier_emt_bind_ext" descr="" size="0x4.0" >
	<field name="modify_offset" descr="Modify offset (the EMT will be inserted/edited starting at this offset):\;0: offset = custom_bytes_set_0_offset\;1: offset = custom_bytes_set_1_offset\;\;From Spectrum-4 and above:\;When offset_type = (1) then value is used to defined constant offset. \;Resolution is in 4B and valid values are 0, 4, 8 ..60\;\;Reserved when emt_bind = 0 or 3" offset="0x0.0" size="0x0.8" />
	<field name="emt_pointer" descr="EMT pointer\;Range: 0 .. cap_max_emts - 1\;See FMTC, FMTE\;\;Reserved when emt_bind = 0 or 3" offset="0x0.8" size="0x0.8" />
	<field name="modifier_base" descr="Modifier Base Label.\;\;Push/Edit/Pop will be applied in the beginning of the following selected field of encapsulated header:\;Note: Pop is allowed only with SOP (0).\;\;0: SOP (start of packet )\;1: New MAC header\;2: New ETHERTYPE \;3: New IPv4/IPv6 header\;4: New MPLS \;5: New VxLAN/Geneve/VxLAN-GPE/NVGRE \;6: New GRE header\;7: New UDP header\;8: New Flex Encap \;9: New Inner MAC header \;\;11: New Inner ETHER Type \;\;Supported from Spectrum-4 and above.\;Reserved when offset_type = 0 (use custom byte)\;Reserved when emt_bind = 0 or 3" offset="0x0.16" size="0x0.4" />
	<field name="emt_bind" descr="Bind an EMT:\;0: NOP - do not change state\;1: PUSH - bind as push\;2: EDIT - bind as edit\;3: DISABLE - disable emt_bind_x\;4: POP - [Spectrum-4 only]\;\;The NOP is added for the case that e.g. emt_bind_0 is used but emt_bind_1 is not used (so it is NOP)" enum="NOP=0x0,PUSH=0x1,EDIT=0x2,DISABLE=0x3,POP=0x4" offset="0x0.24" size="0x0.4" />
	<field name="offset_type" descr="Offset Type\;0: modify_offset selects cb_set 0 or cb_set 1 (backward compatible)\;1: modify_offset is a constant value. Granularity is in 4B\;\;Supported from Spectrum-4 and above\;Reserved when emt_bind = 0 or 3" offset="0x0.30" size="0x0.1" />
</node>

<node name="action_flex_modifier_emt_ext" descr="" size="0x10.0" >
	<field name="emt_bind_0" descr="Egress Modifier Template binding 0\;See Table 2646, &quot;emt_bind_record Block Layout,&quot; on page 2885" subnode="action_flex_modifier_emt_bind_ext" offset="0x0.0" size="0x4.0" />
	<field name="emt_bind_1" descr="Egress Modifier Template binding 1\;See Table 2646, &quot;emt_bind_record Block Layout,&quot; on page 2885" subnode="action_flex_modifier_emt_bind_ext" offset="0x4.0" size="0x4.0" />
</node>

<node name="action_flow_estimator_ext" descr="" size="0x8.0" >
	<field name="profile" descr="Profile index\;Range 0...3" offset="0x0.0" size="0x0.3" />
	<field name="counter_index" descr="Counter Index for flow counters.\;See Section 5.2, &quot;Flow Counters&quot;, on page 1127" offset="0x4.0" size="0x0.24" />
</node>

<node name="action_forward_ext" descr="" size="0x10.0" >
	<field name="type" descr="Type:\;0: PBS - Policy Based Switching\;1: OUTPUT - OpenFlow output type" offset="0x0.24" size="0x0.2" />
	<field name="record" descr="See Table 2596, &quot;FORWARDING_ACTION Block, PBS Record Layout,&quot; on page 2850\;See Table 2598, &quot;FORWARDING_ACTION Block, Output Record Layout,&quot; on page 2850" subnode="action_forward_record_auto_ext" offset="0x4.0" size="0xc.0" />
</node>

<node name="action_forward_output_ext" descr="" size="0xc.0" >
	<field name="defer" descr="Defer\;0: action will be applied immediately, a duplication of the packet is generated by the device\;1: action will be written to action set" offset="0x0.0" size="0x0.1" />
	<field name="nd_clear_soft_drop" descr="No Defer: Clear soft drop\;For non-defer packets: \;0: do not clear the soft drop\;1: clear soft drop on the duplicated packet\;Reserved when defer = 1\;" offset="0x0.1" size="0x0.1" />
	<field name="pbs_ptr" descr="A pointer to an entry configured by PPBS register, see Table 2743, &quot;PPBS - Policy-Engine Policy Based Switching Register Layout,&quot; on page 2979\;Note: forward to IP router is not supported with this option \;Reserved when in_port =1" offset="0x4.0" size="0x0.24" />
	<field name="in_port" descr="In port:\;0: The output of the packet is according to pbs_ptr\;" offset="0x8.0" size="0x0.1" />
</node>

<node name="action_forward_pbs_ext" descr="" size="0xc.0" >
	<field name="pbs_ptr" descr="A pointer to the PBS entry configured by PPBS register, see Table 2743, &quot;PPBS - Policy-Engine Policy Based Switching Register Layout,&quot; on page 2979" offset="0x4.0" size="0x0.24" />
</node>

<node name="action_forward_record_auto_ext" descr="" attr_is_union="1" size="0xc.0" >
	<field name="action_forward_pbs_ext" descr="" subnode="action_forward_pbs_ext" offset="0x0.0" size="0xc.0" />
	<field name="action_forward_output_ext" descr="" subnode="action_forward_output_ext" offset="0x0.0" size="0xc.0" />
</node>

<node name="action_fs_db_ext" descr="" size="0xc.0" >
	<field name="key_type" descr="0: Use ACL Group Id\;1: Use Linear db index\;\;Reserved when sem_op = nop and db_op = nop" offset="0x0.0" size="0x0.1" />
	<field name="key_id" descr="when key_type = 0:\;ACL Group Id\;\;when key_type = 1:\;linear index. valid values 0.. (cap_max_sf_db_linear_entries-1)\;\;Reserved when sem_op = nop and db_op = nop" offset="0x0.16" size="0x0.16" />
	<field name="sem_op" descr="0: nop - (no operation)\;1: lock_semaphore\;2: unlock\;\;Reserved when db_op is remove." enum="nop=0x0,lock_semaphore=0x1,unlock=0x2" offset="0x4.0" size="0x0.2" />
	<field name="db_op" descr="0: nop\;1: read_64bit_value\;2: write_data\;3: remove_entry_with_failure_indication\;4: remove_entry_wo_failure_indication\;\;\;Notes:\;- remove must be set with sem_op = unlock\;- write can&quot;t be set with sem_op = lock\;- when db_op = remove_all (5), only virtual db is relevant\;" offset="0x4.4" size="0x0.3" />
	<field name="partition_id" descr="Valid values 0..(cap_max_sf_db_parititions-1). \;Indicates to which virtual db to associate the entry" offset="0x4.8" size="0x0.3" />
	<field name="ticket_op" descr="0: nop - no operation\;1: release\;2: check - check sequence before lookup\;\;Note that ticket_op = check sequence number before lookup is not allowed during sempahore lock" enum="nop=0x0,release=0x1,check=0x2" offset="0x4.16" size="0x0.2" />
	<field name="cbs_index" descr="cb_set[index*4]..cb_set[index*4+3]\;each cb_set is in length of 2B\;total data size is 64 bits.\;\;For example, \;for i=0, we use R0+R1+R2+R3\;for i=1, we use R4+R5+R6+R7\;for i=2, we use R8+R9+R10+R11\;\;\;valid values: 0 .. (cap_max_custom_byte_set/4-1).\;Reserved when db_op = nop or db_op = remove." offset="0x4.24" size="0x0.4" />
</node>

<node name="action_hash_ext" descr="" size="0x10.0" >
	<field name="hash_cmd" descr="0: NONE \;1: SET the hash value according to hash_value (ignore the original_hash)\;2: XOR: do a XOR of original_hash with hash_value \;3: RANDOM (ignore the original_hash)\;4: COPY from other hash type (if type = LAG then copy from ecmp. If type = ECMP then copy from lag) \;5: SWAP betweens lag and ecmp, ignore type \;6: CRC: do a CRC of original_hash with a 32bit field according to hash_fields and hash_mask" offset="0x0.0" size="0x0.4" />
	<field name="type" descr="0: LAG\;1: ECMP\;Reserved when hash_cmd = 5" offset="0x0.30" size="0x0.2" />
	<field name="hash_fields" descr="0: smac 31:0 // dmac,smac only on iACL, eACL\;1: dmac 31:0 \;2: smac47:32, dmac 47:32\;3: dmac47:32, smac 47:32\;\;sip is reserved when Spectrum\;4: sip 31:0 \;5: sip 63:32\;6: sip 95:64\;7: sip 127:96\;\;8: dip 31:0 \;9: dip 63:32\;10: dip 95:64\;11: dip 127:96\;\;14: next_protocol\;15: {sport, dport}\;16: {dport, sport}17: spi\;\;inner_sip is reserved when Spectrum\;18: inner_sip 31:0\;19: inner_sip 63:32\;20: inner_sip 95:64\;21: inner_sip 127:96 \;\;22: inner_dip 31:0 \;23: inner_dip 63:32\;24: inner_dip 95:64\;25: inner_dip 127:96\;\;26: {inner_sip 15:0, inner_dip 15:0}\;27: {inner_dip 15:0, inner_sip 15:0}\;28: inner_next_protocol\;29: {inner_sport, inner_dport}\;30: {inner_dport, inner_sport}\;\;These and below are not supported by Spectrum:\;31: custom_bytes 3,2,1,0\;32: custom_bytes 7,6,5,4\;33: custom_bytes 11,10,9,8\;34: custom_bytes 15,14,13,12\;35: hash_value // bits 31:12 are &apos;0&apos;" offset="0x4.0" size="0x0.7" />
	<field name="hash_value" descr="hash value when hash_cmd = 1 or 2, else reserved" offset="0x4.16" size="0x0.12" />
	<field name="hash_mask" descr="Mask which bits defined by hash_fields are used for hash calculation\;Per bit:\;0: disable\;1: enable" offset="0x8.0" size="0x4.0" />
</node>

<node name="action_ignore_ext" descr="" size="0x10.0" >
	<field name="set_elephant" descr="Set Elephant or set Mice state\;0: do not set\;1: set Elephant state\;2: set Mice state \;Note: sets the attribute of the packet without setting the detection state of the CEDR" offset="0x0.0" size="0x0.2" />
	<field name="disable_security" descr="0: Regular flow \;1: Disable security lookup\;Reserved when Spectrum-1" offset="0x0.28" size="0x0.1" />
	<field name="disable_learning" descr="Disable learning (overwrite ingress port decision):\;0: Regular flow\;1: Disable learning \;Note: if Disable was set on a packet there is no rollback\;Note: does not apply for NVE decap" offset="0x0.29" size="0x0.1" />
	<field name="ignore_vl_filter" descr="Ignore vlan commands (filter and untagged):\;0: Regular flow\;1: Ignore egress VLAN filtering and ignore egress VLAN untagged command\;Note: if ignore_vl_filter was set on a packet there is no rollback" offset="0x0.30" size="0x0.1" />
	<field name="ignore_stp" descr="Ignore STP: \;0: Regular flow\;1: Ignore Egress STP filtering\;Note: if Ignore was set on a packet there is no rollback" offset="0x0.31" size="0x0.1" />
	<field name="ar_packet_prof_id" descr="Packet_profile_id:\;0: HBF\;1: AR profile 0\;2: AR profile 1\;Supported from Spectrum-2 and on" offset="0x4.24" size="0x0.2" />
	<field name="ar_packet_prof_cmd" descr="AR packet profile:\;0: do nothing\;1: set ar packet prof id to ar_packet_prof_id\;Supported from Spectrum-2 and on" offset="0x4.28" size="0x0.1" />
	<field name="disable_ovl_learning" descr="Disable overlay learning:\;0: regular flow\;1: disable overlay learning after Decap\;Reserved when Spectrum" offset="0x8.31" size="0x0.1" />
	<field name="cond_mirroring_val" descr="[Spectrum-4]\;Conditional mirroring:\;Disables a dynamic mirror trigger\;For both Elephant and for non-Elephant packets\;\;Bitwise vector, value per mirror trigger (e.g. bit 3 for trigger 0x3 Tail drop mirror)\;Value per bit:\;0: Enable mirror trigger \;1: Disable mirror trigger\;\;Notes: \;1. the enable does not trigger the mirror, it just allows the mirror\;2. applies only to dynamic mirror triggers\;Bits of static mirror triggers are reserved\;\;Supported only from Spectrum-4" offset="0xC.0" size="0x0.16" />
	<field name="cond_mirroring_mask" descr="[Spectrum-4]\;Conditional mirroring mask:\;per bit, allow setting the value of cond_mirroring_val\;Supported only from Spectrum-4\;[Spectrum-4]" offset="0xC.16" size="0x0.16" />
</node>

<node name="action_l4_port_ext" descr="" size="0x10.0" >
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0x0.0" size="0x0.1" />
	<field name="s_d" descr="Source or Destination:\;0: configure src_l4_port\;1: configure dst_l4_port" offset="0x0.31" size="0x0.1" />
	<field name="l4_port" descr="" offset="0x8.0" size="0x0.16" />
</node>

<node name="action_mac_ttl_ext" descr="" size="0x10.0" >
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0x0.0" size="0x0.1" />
	<field name="ttl_value" descr="TTL Value" offset="0x0.16" size="0x0.8" />
	<field name="ttl_cmd" descr="TTL Command\;0: Do nothing\;1: Set packet TTL to ttl_value \;2: Decrement packet TTL by ttl_value \;Supported also as a bridge\;Not supported when eRIF-tunnel" offset="0x0.29" size="0x0.3" />
	<field name="mac_cmd" descr="MAC Command\;0: NOP - do nothing \;1: SMAC_TO_MAC - set SMAC to MAC\;2: DMAC_TO_MAC - set DMAC to MAC \;\;Note that at iACL, takes action prior to the bridge.\;Not supported when eRIF-tunnel" enum="NOP=0x0,SMAC_TO_MAC=0x1,DMAC_TO_MAC=0x2" offset="0x4.30" size="0x0.2" />
	<field name="mac_47_32" descr="MAC Address" offset="0x8.0" size="0x0.16" />
	<field name="mac_31_0" descr="MAC Address" offset="0xC.0" size="0x4.0" />
</node>

<node name="action_mc_router_ext" descr="" size="0x10.0" >
	<field name="expected_irif" descr="Expected Ingress RIF\;Reserved when eir_type = &apos;1&apos;\;Reserved when rpf_action is NOP" offset="0x0.0" size="0x0.16" />
	<field name="eir_type" descr="Expected Ingress RIF Type\;0: expected irif\;1: expected irif list\;Reserved when rpf_action is NOP" offset="0x0.24" size="0x0.1" />
	<field name="rpf_action" descr="RPF and assert action\;0: NOP\;1: RPF_TRAP (Trap ID is RPF)\;3: RPF_DISCARD_ERROR" offset="0x0.28" size="0x0.3" />
	<field name="expected_irif_list_index" descr="Expected Ingress RIF List Index\;An index to the list of expected ingress RIFs\;For Spectrum/-2, this is in KVD Linear, see Section A.4.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3813\;expected_irif_list_index must be align to cap_exp_irif_mc_size.\;Reserved when eir_type = &apos;0&apos;\;Reserved when rpf_action is NOP" offset="0x4.0" size="0x0.24" />
	<field name="min_mtu" descr="The minimum MTU among the group of the egress RIFs. Units of Bytes." offset="0x8.0" size="0x0.16" />
	<field name="rigr_rmid_index" descr="When vrmid=0:\;Pointer to Router Interface Group (RIGR) Table.\;For Spectrum/-2 the index is to the KVD linear, see Section A.4.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3813\;When vrmid=1:\;RMID Index\;Range 0 .. max_mid - 1\;For Spectrum/-2 the index is to the Port Group Table, see Section A.4.2, &quot;Port Group Table (PGT)&quot;, on page 3813" offset="0xC.0" size="0x0.24" />
	<field name="vrmid" descr="Valid RMID:\;rigr_rmid_index is used as RMID" offset="0xC.31" size="0x0.1" />
</node>

<node name="action_metadata_ext" descr="" size="0x10.0" >
	<field name="meta_data" descr="Used Meta Data\;" offset="0x8.0" size="0x0.16" />
	<field name="mask" descr="Mask for meta_data update.\;Set bits allows updating of the switch meta-data information while a cleared mask bit will preserve the previous meta-data value for the relevant bit." offset="0xC.0" size="0x0.16" />
</node>

<node name="action_mirror_sampler_ext" descr="" size="0x10.0" >
	<field name="mirror_agent" descr="mirror_agent" offset="0x4.0" size="0x0.3" />
	<field name="mirror_probability_rate" descr="For mirroring: sampling rate = 1 out of rate packets \;Valid values are: 1 to 2^24-1\;\;Values of 0 behaves like 1" offset="0x8.0" size="0x0.24" />
</node>

<node name="action_mpls_ext" descr="" size="0x10.0" >
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set\;Reserved when Spectrum" offset="0x0.0" size="0x0.1" />
	<field name="ttl" descr="The TTL \;Note: when used as part of router flow the Erif table may do dec(1) in addition" offset="0x0.16" size="0x0.8" />
	<field name="ttl_cmd" descr="TTL Command\;0: Do nothing\;1: Set packet TTL to ttl\;2: Decrement packet TTL by ttl\;Notes:\;- For iACL and irifACL, if the packet will pass LSR then the ttl will be decremented by the LSR\;- Does not effect the inner LSP (does effect all labels added/edited)\;- For ingress LER, applied only by erifACL and eACL" offset="0x0.29" size="0x0.3" />
	<field name="exp" descr="the value of the exp bits" offset="0x4.0" size="0x0.3" />
	<field name="exp_cmd" descr="0: Do nothing \;1: Set exp to exp\;For ingress LER, the &apos;set&apos; applied only by erifACL and eACL" offset="0x4.30" size="0x0.2" />
	<field name="exp_rw" descr="EXP Re-write\;Indicates how to handle the REWRITE bit of EXP which is used later on the pipe based on ACN and ECN:\;0: PRESERVE - Preserve the value of the rewrite_enable bit.\;1: SET - Set the rewrite_enable bit.\;2: CLEAR - Clear the rewrite_enable bit." enum="PRESERVE=0x0,SET=0x1,CLEAR=0x2" offset="0x8.30" size="0x0.2" />
</node>

<node name="action_null_ext" descr="" size="0x1c.0" >
	<field name="null_field" descr="" offset="0x0.0" size="0x0.1" />
</node>

<node name="action_policing_counting_ext" descr="" size="0x10.0" >
	<field name="c_p" descr="Counter or Policer\;Indicates whether the action binds a policer or a counter to the flow.\;0: Counter\;1: Policer" offset="0x0.31" size="0x0.1" />
	<field name="counter_index" descr="Counter Index for flow counters.\;See Section 5.2, &quot;Flow Counters&quot;, on page 1127\;reserved when c_p = 1" offset="0x4.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters.\;See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128 \;Must never be set to &apos;0&apos; (No Count)\;reserved when c_p = 1" offset="0x4.24" size="0x0.8" />
	<field name="pid" descr="Policer ID\;See pid in QPCR, Section 12.14.7, &quot;QPCR - QoS Policer Configuration Register&quot;, on page 3066\;reserved when c_p = 0\;Spectrum-4: allowed" offset="0x8.0" size="0x0.14" />
</node>

<node name="action_port_filter_ext" descr="" size="0x10.0" >
	<field name="egress_port_list_64" descr="Each bit represents an egress_port (local_port)\;0: Deny sending through this port\;1: Permit sending through this port\;Not supported towards CPU port (port0)" offset="0x4.0" size="0x0.1" />
	<field name="egress_port_list" descr="Each bit represents an egress_port (local_port)\;0: Deny sending through this port\;1: Permit sending through this port\;Not supported towards CPU port (port0)" subnode="uint64" offset="0x8.0" size="0x8.0" />
</node>

<node name="action_port_filter_ext1_ext" descr="" size="0x10.0" >
	<field name="egress_port_list" descr="Each bit represents an egress_port (local_port)\;0: Deny sending through this port\;1: Permit sending through this port" subnode="uint64" offset="0x8.0" size="0x8.0" />
</node>

<node name="action_port_filter_ext2_ext" descr="" size="0x10.0" >
	<field name="page" descr="Page:\;0: local_ports 1..64\;1: local_ports 65..128\;...\;7: local ports 449..512\;8: local ports 513..577\;\;Page range support:\;Spectrum-1: Page 0\;Spectrum-2/-3: Pages 0..1\;Spectrum-4: Pages 0..3, Page 4 for service ports\;Spectrum-5: Pages 0..7, Page 8 for service ports" offset="0x0.0" size="0x0.4" />
	<field name="egress_port_list" descr="Each bit represents an egress_port. Bit 0 represents the first port in the page.\;0: Deny sending through this port\;1: Permit sending through this port" subnode="uint64" offset="0x8.0" size="0x8.0" />
</node>

<node name="action_qos_ext" descr="" size="0x10.0" >
	<field name="defer" descr="Defer \;0: action will be applied immediately\;1: action will be written to action set\;For Spectrum: defer only dscp and ecn\;For Spectrum-2: defer all fields except dscp_rw, pcp_rw" offset="0x0.0" size="0x0.1" />
	<field name="dscp" descr="DSCP Value" offset="0x4.0" size="0x0.6" />
	<field name="dscp_cmd" descr="0: Do nothing\;1: Set DSCP 3 LSB bits according to dscp[2:0]\;2: Set DSCP 3 MSB bits according to dscp[5:3]\;3: Set DSCP 6 bits according to dscp[5:0]" offset="0x4.14" size="0x0.2" />
	<field name="color" descr="0: Green \;1: Yellow\;2: Red" offset="0x4.16" size="0x0.3" />
	<field name="color_cmd" descr="0: Do nothing \;1: Set color to color" offset="0x4.22" size="0x0.2" />
	<field name="ecn" descr="ECN value" offset="0x4.24" size="0x0.2" />
	<field name="ecn_cmd" descr="0: Do nothing \;1: Set the ECN to ecn" offset="0x4.29" size="0x0.3" />
	<field name="switch_prio" descr="Switch Priority" offset="0x8.0" size="0x0.4" />
	<field name="switch_prio_cmd" descr="0: Do nothing \;1: Set Switch Priority to switch_prio" offset="0x8.14" size="0x0.2" />
	<field name="tclass" descr="valid values are from 0..(cap_max_tclass-1)\;Note that (cap_max_tclass-1) is valid, used for control traffic from CPU" offset="0xC.0" size="0x0.5" />
	<field name="tclass_cmd" descr="0: Do nothing \;1: Set tclass to tclass" offset="0xC.7" size="0x0.1" />
	<field name="pcp_rw" descr="PCP Re-write Enable\;Controlling the rewrite_enable for PCP:\;0: PRESERVE - Preserve the value of the rewrite_enable bit\;1: SET - Set the rewrite_enable bit\;2: CLEAR - Clear the rewrite_enable bit\;3: reserved" enum="PRESERVE=0x0,SET=0x1,CLEAR=0x2,reserved=0x3" offset="0xC.28" size="0x0.2" />
	<field name="dscp_rw" descr="DSCP Re-write Enable\;Controlling the rewrite_enable for DSCP:\;0: PRESERVE - Preserve the value of the rewrite_enable bit\;1: SET - Set the rewrite_enable bit\;2: CLEAR - Clear the rewrite_enable bit\;3: reserved" enum="PRESERVE=0x0,SET=0x1,CLEAR=0x2,reserved=0x3" offset="0xC.30" size="0x0.2" />
</node>

<node name="action_sip_dip_ext" descr="" size="0x10.0" >
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0x0.0" size="0x0.1" />
	<field name="m_l" descr="MSB or LSB:\;0: LSB: ip[63:0] refers to ip[63:0]\;1: MSB: ip[63:0] refers to ip[127:64]" offset="0x0.30" size="0x0.1" />
	<field name="s_d" descr="Sourde or Destination:\;0: ip refers to dip\;1: ip refers to sip" offset="0x0.31" size="0x0.1" />
	<field name="ip" descr="" subnode="uint64" offset="0x8.0" size="0x8.0" />
</node>

<node name="action_trap_ext" descr="" size="0x10.0" >
	<field name="forward_action" descr="Forward Action\;0: NOP\;1: FORWARD \;2: SOFT_DISCARD_ERROR - soft drop the packet and increment the ACL error counter\;3: DISCARD - hard drop in HW \;4: DISCARD_ERROR - hard drop error, drop will be counted" enum="NOP=0x0,FORWARD=0x1,SOFT_DISCARD_ERROR=0x2,DISCARD=0x3,DISCARD_ERROR=0x4" offset="0x0.0" size="0x0.4" />
	<field name="trap_action" descr="Trap Action\;0: NOP \;1: CLEAR_TRAP_STATE\;2: TRAP \;3: NO_TRAP - note that this can be overran by CLEAR_TRAP_STATE" enum="NOP=0x0,CLEAR_TRAP_STATE=0x1,TRAP=0x2,NO_TRAP=0x3" offset="0x0.24" size="0x0.4" />
	<field name="trap_id" descr="Trap ID, see Section 2.8.3, &quot;Trap Identifier (Trap-ID)&quot;, on page 439.\;Reserved when trap_action is NOP, CLEAR_TRAP_STATE or NO_TRAP" offset="0x4.0" size="0x0.10" />
	<field name="mirror_enable" descr="mirror enable\;Note that for iACL, irifACL, erifACL the mirror is ingress mirror\;For eACL the mirror is egress mirror" offset="0x8.24" size="0x0.1" />
	<field name="mirror_agent" descr="mirror agent" offset="0x8.29" size="0x0.3" />
	<field name="preserve_cookie" descr="Preserve Cookie\;0: don&apos;t preserve cookie and override it with value 0\;1: preserve cookie\;\;Note: cookie (AKA user_def_val) can be set either\;a. Trap Action: Set value 0\;b. Trap Action w/ cookie: user_def_val value. Section 2584, &quot;TRAP_W_USERDEF_ACTION Block layout&quot;, on page 2840\;c. ALU field Select. Section 2666, &quot;Fields Select&quot;, on page 2903\;\;Supported from Spectrum-4 and on." offset="0xC.30" size="0x0.1" />
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0xC.31" size="0x0.1" />
</node>

<node name="action_trap_w_userd_ext" descr="" size="0x10.0" >
	<field name="forward_action" descr="Forward Action\;0: NOP\;1: FORWARD \;\;2: SOFT_DISCARD_ERROR - soft drop the packet and increment the ACL error counter\;3: DISCARD - hard drop in HW \;4: DISCARD_ERROR - hard drop error, drop will be counted" enum="NOP=0x0,FORWARD=0x1,SOFT_DISCARD_ERROR=0x2,DISCARD=0x3,DISCARD_ERROR=0x4" offset="0x0.0" size="0x0.4" />
	<field name="trap_action" descr="Trap Action\;0: NOP \;1: CLEAR_TRAP_STATE\;2: TRAP \;3: NO_TRAP - note that this can be overran by CLEAR_TRAP_STATE" enum="NOP=0x0,CLEAR_TRAP_STATE=0x1,TRAP=0x2,NO_TRAP=0x3" offset="0x0.24" size="0x0.4" />
	<field name="trap_id" descr="Trap ID, see Section 2.8.3, &quot;Trap Identifier (Trap-ID)&quot;, on page 439.\;Reserved when trap_action is NOP, CLEAR_TRAP_STATE or NO_TRAP" offset="0x4.0" size="0x0.10" />
	<field name="mirror_enable" descr="mirror enable" offset="0x8.24" size="0x0.1" />
	<field name="mirror_agent" descr="mirror agent" offset="0x8.29" size="0x0.3" />
	<field name="user_def_val" descr="Value for the SW usage\;Can be used to pass information of which rule has caused a trap. This may be overwritten by later traps. This field does a set on the packet&apos;s user_def_val only if this is the first trap_id or if the trap_id has replaced the previous packet&apos;s trap_id\;Default value is 0\;" offset="0xC.0" size="0x0.20" />
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0xC.31" size="0x0.1" />
</node>

<node name="action_truncation_ext" descr="" size="0x10.0" >
	<field name="en" descr="Truncation profile enable:\;0: disable\;1: enable" offset="0x0.0" size="0x0.1" />
	<field name="tr_prof" descr="Pointer to truncation profile\;See Table 1242, &quot;ITPR - Infrastructure Truncation Profile Register Layout,&quot; on page 1480\;Reserved when en = disable (0)" offset="0x4.0" size="0x0.2" />
</node>

<node name="action_uc_router_ar_ext" descr="" size="0xc.0" >
	<field name="ar_lookup_prof_id" descr="AR lookup profile_id:\;0: HBF\;1: AR profile 0\;2: AR profile 1" offset="0x0.0" size="0x0.2" />
	<field name="dr" descr="Default Route.\;This bit indicated whether this entry is a default route.\;" offset="0x0.31" size="0x0.1" />
	<field name="arlpgt_pointer" descr="Pointer to AR Local port group table (ARLPGT), see RARLPGT\;Range 0.. cap_max_arlpgt-1" offset="0x4.0" size="0x0.16" />
	<field name="ecmp_size" descr="ECMP Size\;Values are according to the FG ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175." offset="0x4.16" size="0x0.13" />
	<field name="arft_pointer" descr="Pointer to adaptive routing flow table (ARFT) base, pointer to profile0, see RARFT\;If profile1 is later selected then the HW will point to profile1 which is arft_pointer+ecmp_size\;For Spectrum-2 pointer to PGT Table" offset="0x8.0" size="0x0.20" />
</node>

<node name="action_uc_router_ext" descr="" size="0x10.0" >
	<field name="type" descr="PBR actions:\;0: IP_ROUTER - IP Remote (Adjacency)\;1: IP_LOCAL - IP Local\;2: TUNNEL_TERMINATION - Tunnel Decap \;- PBL actions\;3: MPLS_ILM\;\;5: AR - Adaptive Routing" enum="IP_ROUTER=0x0,IP_LOCAL=0x1,TUNNEL_TERMINATION=0x2,MPLS_ILM=0x3,AR=0x5" offset="0x0.24" size="0x0.3" />
	<field name="record" descr="Table 2612, &quot;UC_ROUTER_ACTION Block, IP Remote Record Layout,&quot; on page 2861.\;Table 2614, &quot;UC_ROUTER_ACTION Block, IP local Record Layout,&quot; on page 2862.\;Table 2616, &quot;UC_ROUTER_ACTION Block, Tunnel Decap Record Layout,&quot; on page 2862\;Table 2618, &quot;UC_ROUTER_ACTION Block, MPLS ILM Record Layout,&quot; on page 2863\;Table 2622, &quot;UC_ROUTER_ACTION Block, AR Record Layout,&quot; on page 2865" subnode="action_uc_router_record_auto_ext" offset="0x4.0" size="0xc.0" union_selector="$(parent).type" />
</node>

<node name="action_uc_router_ip_local_ext" descr="" size="0xc.0" >
	<field name="dr" descr="Default Route.\;This bit indicated whether this entry is a default route.\;" offset="0x0.31" size="0x0.1" />
	<field name="local_erif" descr="Egress Router Interface" offset="0x8.0" size="0x0.16" />
</node>

<node name="action_uc_router_ip_remote_ext" descr="" size="0xc.0" >
	<field name="adjacency_index" descr="adjacency_index points to the first entry of the group-based ECMP." offset="0x0.0" size="0x0.24" />
	<field name="dr" descr="Default Route.\;This bit indicated whether this entry is a default route.\;" offset="0x0.31" size="0x0.1" />
	<field name="ecmp_size" descr="ecmp_size is the amount of sequential entries from the adjacency_index (the number of ECMPs). \;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175." offset="0x4.0" size="0x0.13" />
</node>

<node name="action_uc_router_mpls_ilm_ext" descr="" size="0xc.0" >
	<field name="ilm_ptr" descr="ILM Pointer to KVD Linear. See PPBMI, See Table 2757, &quot;PPBMI - Policy-Engine Policy Based MPLS ILM Register Layout,&quot; on page 2989" offset="0x4.0" size="0x0.24" />
</node>

<node name="action_uc_router_record_auto_ext" descr="" attr_is_union="1" size="0xc.0" >
	<field name="action_uc_router_ip_remote_ext" descr="" subnode="action_uc_router_ip_remote_ext" offset="0x0.0" selected_by="IP_ROUTER" size="0xc.0" />
	<field name="action_uc_router_ip_local_ext" descr="" subnode="action_uc_router_ip_local_ext" offset="0x0.0" selected_by="IP_LOCAL" size="0xc.0" />
	<field name="action_uc_router_tt_ext" descr="" subnode="action_uc_router_tt_ext" offset="0x0.0" selected_by="TUNNEL_TERMINATION" size="0xc.0" />
	<field name="action_uc_router_mpls_ilm_ext" descr="" subnode="action_uc_router_mpls_ilm_ext" offset="0x0.0" selected_by="MPLS_ILM" size="0xc.0" />
	<field name="action_uc_router_ar_ext" descr="" subnode="action_uc_router_ar_ext" offset="0x0.0" selected_by="AR" size="0xc.0" />
</node>

<node name="action_uc_router_tt_ext" descr="" size="0xc.0" >
	<field name="tunnel_ptr" descr="Tunnel Pointer for L2 or for L3 tunnel termination. See Section 14.15.16, &quot;RTDP - Routing Tunnel Decap Properties Register&quot;, on page 3297" offset="0x4.0" size="0x0.24" />
</node>

<node name="action_virtual_forwarding_ext" descr="" size="0x10.0" >
	<field name="virtual_router" descr="Virtual Router ID or MPLS label space" offset="0x0.0" size="0x0.16" />
	<field name="vr_cmd" descr="0: Do nothing \;1: Set virtual router or MPLS label space to virtual_router\;Relevant at erifACL for IPinIP encap and at NVE overlay router for setting underlay vr" offset="0x0.29" size="0x0.3" />
	<field name="fid" descr="The FID value" offset="0x8.0" size="0x0.16" />
	<field name="fid_cmd" descr="0: Do nothing \;1: Set the Forwarding Identifier (FID) to fid" offset="0x8.29" size="0x0.3" />
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set\;Reserved when Spectrum" offset="0xC.0" size="0x0.1" />
</node>

<node name="action_vlan_ext" descr="" size="0x10.0" >
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set" offset="0x0.0" size="0x0.1" />
	<field name="vlan_tag_cmd" descr="0: Do nothing \;1: Push VLAN tag.The vid_cmd, ethertype_cmd, pcp_cmd and dei_cmd must set the outer fields\;\;2: Pop VLAN tag\;Supported only if there are two or more VLAN tags. If vid_cmd, ethertype_cmd, pcp_cmd or dei_cmd are used with Pop then the inner fields should be set since these commands are done before Pop" offset="0x0.29" size="0x0.3" />
	<field name="vid" descr="The VID for vid_cmd 1 and 2" offset="0x4.0" size="0x0.12" />
	<field name="vid_cmd" descr="0: NOP - Do nothing \;1: SET_OUTER - Set outer VID to vid \;2: SET_INNER - Set inner VID to vid \;3: COPY_OUTER_TO_INNER - Copy VID from outer to inner,supported only if there are two or more VLAN tags\;4: COPY_INNER_TO_OUTER - Copy VID from inner to outer,supported only if there are two or more VLAN tags\;5: SWAP - Swap inner and outer headers" enum="NOP=0x0,SET_OUTER=0x1,SET_INNER=0x2,COPY_OUTER_TO_INNER=0x3,COPY_INNER_TO_OUTER=0x4,SWAP=0x5" offset="0x4.29" size="0x0.3" />
	<field name="pcp" descr="PCP for pcp_cmd 1 and 2" offset="0x8.8" size="0x0.3" />
	<field name="pcp_cmd" descr="0: NOP - Do nothing \;1: SET_OUTER - Set the outer PCP according to pcp\;2: SET_INNER - Set the inner PCP according to pcp\;3: COPY_OUTER_TO_INNER - Copy vlan priority from outer to inner\;4: COPY_INNER_TO_OUTER - Copy vlan priority from inner to outers\;5: SWAP - Swap vlan priority inner to outer" enum="NOP=0x0,SET_OUTER=0x1,SET_INNER=0x2,COPY_OUTER_TO_INNER=0x3,COPY_INNER_TO_OUTER=0x4,SWAP=0x5" offset="0x8.13" size="0x0.3" />
	<field name="ethertype" descr="0: ether_type0\;1: ether_type1\;2: ether_type2\;3: ethertype according to egress port configuration (SPEVET.et_vlan)\;for ethertype 0-2 ethertype IDs are configured by SVER, see Section 7.12.40, &quot;SVER - Switch VLAN EtherType Register&quot;, on page 1671\;For ethertype=3 see Table 1342, &quot;SPEVET - Switch Port Egress VLAN Ethertype Register Layout,&quot; on page 1612\;This field is valid when ethertype_cmd is 1 or 2" offset="0x8.24" size="0x0.3" />
	<field name="ethertype_cmd" descr="0: NOP - Do nothing \;1: SET_OUTER - Set outer EtherType to ethertype\;2: SET_INNER - Set inner EtherType to ethertype\;3: COPY_OUTER_TO_INNER - Copy EtherType from outer to inner\;4: COPY_INNER_TO_OUTER - Copy EtherType from inner to outer\;5: SWAP - Swap EtherType inner outer" enum="NOP=0x0,SET_OUTER=0x1,SET_INNER=0x2,COPY_OUTER_TO_INNER=0x3,COPY_INNER_TO_OUTER=0x4,SWAP=0x5" offset="0x8.29" size="0x0.3" />
	<field name="dei" descr="DEI value for dei_cmd 1 and 2" offset="0xC.24" size="0x0.1" />
	<field name="dei_cmd" descr="0: NOP - Do nothing \;1: SET_OUTER - Set the outer DEI to dei\;2: SET_INNER - Set the inner DEI to dei\;3: COPY_OUTER_TO_INNER - Copy DEI from outer to inner\;4: COPY_INNER_TO_OUTER - Copy DEI from inner to outer\;5: SWAP - Swap DEI inner outer" enum="NOP=0x0,SET_OUTER=0x1,SET_INNER=0x2,COPY_OUTER_TO_INNER=0x3,COPY_INNER_TO_OUTER=0x4,SWAP=0x5" offset="0xC.29" size="0x0.3" />
</node>

<node name="action_vni_ext" descr="" size="0x10.0" >
	<field name="defer" descr="Defer\;0: action will be applied immediately\;1: action will be written to action set\;Reserved when Spectrum" offset="0x0.0" size="0x0.1" />
	<field name="vni" descr="The new VNI value" offset="0x8.0" size="0x0.24" />
	<field name="set_vni" descr="0: none\;1: set" offset="0x8.31" size="0x0.1" />
</node>

<node name="aged_out_mac_lag_record_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="type_0x8" descr="0x8: Aged_out_MAC_LAG_Record - this record\;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RO" enum="Aged_out_MAC_LAG_Record=0x8" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID\;Reserved when Spectrum/-2" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="fid" descr="Filtering identifier" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="lag_id" descr="LAGID (pointer into the LAG descriptor table)" access="RO" offset="0xC.0" size="0x0.10" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RO" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX/-2" access="RO" offset="0x1C.24" size="0x0.8" />
</node>

<node name="aged_out_mac_record_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="type_0x7" descr="0x7: Aged_out_MAC_Record - this record\;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RO" enum="Aged_out_MAC_Record=0x7" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID\;Reserved when Spectrum/-2" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="MAC address" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="fid" descr="Filtering identifier" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="system_port" descr="Unique port identifier for the final destination of the packet" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RO" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX/-2" access="RO" offset="0x1C.24" size="0x0.8" />
</node>

<node name="aged_out_unicast_tunnel_fdb_record_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="type_0xE" descr="0xE: Aged_out_Unicast_Tunnel_FDB_Record - this record\;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RO" enum="Aged_out_Unicast_Tunnel_FDB_Record=0xe" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID\;Reserved when Spectrum/-2" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="MAC address" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="fid" descr="Filtering ID\;Only FIDs that are from vFID type are valid." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="udip_msb" descr="If protocol is IPv4:\;The underlay source IPv4 of the remote NVE (the most significant bits)\;If protocol is IPv6: reserved" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="udip_lsb" descr="If protocol is IPv4:\;The underlay destination IPV4 of the remote VTEP (the least significant bits)" access="RO" offset="0xC.0" size="0x0.24" />
	<field name="protocol" descr="Protocol:\;0: IPv4\;1: IPv6\;Reserved when Spectrum\;" access="RO" offset="0xC.27" size="0x0.1" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RO" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX/-2" access="RO" offset="0x1C.24" size="0x0.8" />
</node>

<node name="ar_action_ext" descr="" size="0x14.0" >
	<field name="trap_id" descr="Trap-ID is RTR_INGRESS0 .. RTR_INGRESS3.\;For trap_action of NOP, MIRROR and DISCARD_ERROR, trap_id is reserved" access="RW" offset="0x0.0" size="0x0.9" />
	<field name="trap_action" descr="Trap Action\;0: NOP\;1: TRAP\;2: MIRROR_TO_CPU\;3: MIRROR\;4: DISCARD_ERROR, see DISCARD_ROUTER2 trap_id" access="RW" offset="0x0.28" size="0x0.4" />
	<field name="ar_lookup_prof_id" descr="AR lookup profile_id:\;0: HBF\;1: AR profile 0\;2: AR profile 1" access="RW" offset="0x4.0" size="0x0.4" />
	<field name="arft_pointer" descr="Pointer to adaptive routing flow table (ARFT) base, pointer to profile0, see RARFT\;If profile1 is later selected then the HW will point to profile1 which is arft_pointer+ecmp_size\;For Spectrum-2 pointer to PGT Table\;[DWIP] Note: In stateless AR mode, no flow table allocation needed\;" access="RW" offset="0x8.0" size="0x0.20" />
	<field name="ecmp_size" descr="ECMP Size\;Values are according to the FG ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175.\;Note: this size is per ar_profile, and each row contains cap_max_arft_entries_in_row.\;Total number of rows in the database = ecmp_size * num_of_ar_profiles / cap_max_arft_entries_in_row." access="RW" offset="0xC.0" size="0x0.13" />
	<field name="arlpgt_pointer" descr="Pointer to AR Local port group table (ARLPGT), see RARLPGT\;Range 0.. cap_max_ar_rgt-1" access="RW" offset="0x10.0" size="0x0.16" />
</node>

<node name="arn_encap_adjacency_ext" descr="" size="0x14.0" >
	<field name="dip_type" descr="0: IPv4\;1: IPv6\;Note: the type field (IPv4 or IPv6) must match the configuration of the overlay router interface, see protocol field in Table 2987, &quot;Loopback USIP Router Interface Properties Layout&quot;" access="RW" offset="0x0.16" size="0x0.2" />
	<field name="uirif" descr="Underlay Ingress RIF" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="tqos_profile" descr="Tunnel QoS profile\;Range 0..cap_max_tqos_profile - 1" access="RW" offset="0x4.24" size="0x0.4" />
	<field name="ipv4_udip" descr="Underlay ipv4 dip\;Reserved when dip_type is IPv6" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="ipv6_ptr" descr="Pointer to IPv6 underlay destination ip address\;See Section 14.15.17, &quot;RIPS - Router IP version Six Register&quot;, on page 3305\;For Spectrum: Pointer to KVD linear space, see Appendix A.4.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3813)\;Reserved when dip_type is IPv4." access="RW" offset="0xC.0" size="0x0.24" />
	<field name="next_arn_ptr" descr="Points to the next ARN_Encap entry.\;See Section 14.15.13, &quot;RATR - Router Adjacency Table Register&quot;, on page 3274." access="RW" offset="0x10.0" size="0x0.24" />
	<field name="vnext" descr="Next valid\;The next_arn_ptr is valid" access="RW" offset="0x10.31" size="0x0.1" />
</node>

<node name="array128_auto" descr="" size="0x10.0" >
	<field name="array128_auto" descr="Auto generated" high_bound="3" low_bound="0" offset="0x0.0" size="0x10.0" />
</node>

<node name="array256_auto" descr="" size="0x20.0" >
	<field name="array256_auto" descr="Auto generated" high_bound="7" low_bound="0" offset="0x0.0" size="0x20.0" />
</node>

<node name="beabfe_bloom_filter_ext" descr="" size="0x4.0" >
	<field name="bf_index" descr="Bloom filter entry\;Range is 0.. 2^cap_max_bf_log -1" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="bf_bank" descr="Bloom filter bank and erp table bank\;Range 0 .. cap_max_erp_table_banks-1" access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="state" descr="Bloom filter state\;0: clear (default)\;1: set" access="RW" offset="0x0.31" size="0x0.1" />
</node>

<node name="bufferx_reg_ext" descr="" size="0x8.0" >
	<field name="size" descr="The part of the packet buffer array is allocated for the specific buffer.\;Units are represented in cells.\;\;For shared_headroom_pool, this field represents the maximum loan from the shared headroom pool and it can be set only when port_shared_buffer is enabled.\;Range is 0..cap_max_shared_headroom_pool_loan_size. \;" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="epsb" descr="Eligible for Port Shared buffer.\;If epsb is set, packets assigned to bufferX are allowed to insert the port shared buffer.\;For port_shared_buffer, this field is reserved.\;For shared_headroom_pool, this field is reserved.\;When lossy==1 this field is reserved.\;The field is reserved for Switch-X/-2." access="RW" offset="0x0.24" size="0x0.1" />
	<field name="lossy" descr="The field indicates if the buffer is lossy.\;0: Lossless\;1: Lossy\;\;The field is reserved for Switch-X/-2.\;For port_shared_buffer, this field is reserved.\;For shared_headroom_pool, this field is reserved.\;NOTE: This field does NOT affect the pause control. Pause control is configured using PFCC register." access="RW" offset="0x0.25" size="0x0.1" />
	<field name="xon_threshold" descr="When the amount of data in the buffer goes below this value, device stops sending pause frames for the Prios associated with the buffer. Units are represented in cells.\;In Spectrum xon_threshold is reserved for buffer[9].\;For Spectrum, if lossy is set on, this field is reserved.\;For shared_headroom_pool, this field is reserved." access="RW" offset="0x4.0" size="0x0.16" />
	<field name="xoff_threshold" descr="Once the amount of data in the buffer goes above this value, device starts sending Pause frames for all Prios associated with the buffer. Units are represented in cells.\;In Spectrum xoff_threshold is reserved for buffer[9].\;For Spectrum, if lossy is set on, this field is reserved.\;For shared_headroom_pool, this field is reserved." access="RW" offset="0x4.16" size="0x0.16" />
</node>

<node name="cedr_ext" descr="" size="0x20.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port\;Not supported by CPU port\;" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="clear" descr="Clear:\;0: Don&apos;t clear the detection_table\;1: Clear the detection_table" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="detection_table" descr="Detection Table\;Every bit represent the corresponding entry on the table \;0: the entry is not an elephant (it may be mice or floating)\;1: the entry is an elephant\;Offset 10h, bit31 is entry0" access="RO" high_bound="3" low_bound="0" offset="0x10.0" size="0x10.0" />
</node>

<node name="ceer_ext" descr="" size="0xa0.0" >
	<field name="detection_entry" descr="Detection Table Entry.\;When used as trap the device chooses the entries which are detected as elephants." access="INDEX" offset="0x0.0" size="0x0.7" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port\;Not supported by CPU port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="clear" descr="Clear:\;0: Don&apos;t clear the elephant state of the entry.\;1: Clear the elephant state of the entry. The entry becomes mice and is removed the table. The flow may return again at candidate state.\;When used as a trap it is set to &apos;1&apos;." access="OP" offset="0x0.31" size="0x0.1" />
	<field name="det" descr="Detected\;The entry is detected as elephant\;When det =0 then all fields may return 0\;\;E.g. when CEGCR.sticky is clear SW may read an entry which is no longer an elephant" access="RO" offset="0x4.31" size="0x0.1" />
	<field name="l2_type" descr="L2 type:\;0: NO_ETH\;1: ETH" access="RO" enum="NO_ETH=0x0,ETH=0x1" offset="0xC.0" size="0x0.4" />
	<field name="vlan_type" descr="Vlan Type:\;0: NO_TAG\;1: PRIO_TAG\;2: VLAN_TAG\;3: QINQ - 2 or more VLAN tags\;" access="RO" enum="NO_TAG=0x0,PRIO_TAG=0x1,VLAN_TAG=0x2,QINQ=0x3" offset="0x10.0" size="0x0.4" />
	<field name="l3_type" descr="L3 type (L2 next header):\;0: IPv4\;1: IPv6\;2: GRH\;3: FiberChannel\;15: Unknown \;" access="RO" enum="IPv4=0x0,IPv6=0x1,GRH=0x2,FiberChannel=0x3,Unknown=0xf" offset="0x10.8" size="0x0.4" />
	<field name="l4_type" descr="L4 type (L3 next header):\;0: TCP\;1: UDP\;2: ICMP\;3: IGMP\;4: BTH\;5: BTH_over_UDP\;6: AH - IPSec Authentication Header\;7: ESP - IPSec Encapsulating Security Payload \;15: Unknown" access="RO" enum="TCP=0x0,UDP=0x1,ICMP=0x2,IGMP=0x3,BTH=0x4,BTH_over_UDP=0x5,AH=0x6,ESP=0x7,Unknown=0xf" offset="0x10.16" size="0x0.4" />
	<field name="tunnel_type" descr="Tunnel Type:\;0: NO_TUNNEL\;1: VXLAN - VXLAN, VXLAN-GPE, GENEVE\;2: NVGRE\;3: IP_IN_IP - no GRE\;4: IP_IN_GRE_IN_IP - with or without a key \;5: MPLS" access="RO" enum="NO_TUNNEL=0x0,VXLAN=0x1,NVGRE=0x2,IP_IN_IP=0x3,IP_IN_GRE_IN_IP=0x4,MPLS=0x5" offset="0x10.24" size="0x0.4" />
	<field name="extra_data_type" descr="extra data type:\;0: NONE\;1: TUNNEL\;2: MPLS\;\;When used as trap and extra_data_type=0 then the CEER length is shorter (not having the extra_data field)" access="RO" enum="NONE=0x0,TUNNEL=0x1,MPLS=0x2" offset="0x10.28" size="0x0.4" />
	<field name="lag_hash" descr="Reserved when hash_valid is &apos;0&apos;" access="RO" offset="0x18.0" size="0x0.12" />
	<field name="hash_valid" descr="" access="RO" offset="0x18.31" size="0x0.1" />
	<field name="router_hash" descr="Reserved when hash_valid is &apos;0&apos;" access="RO" offset="0x1C.0" size="0x0.12" />
	<field name="dmac_47_32" descr="dmac\;Reserved when l2_type is not ETH" access="RO" offset="0x20.0" size="0x0.16" />
	<field name="dmac_31_0" descr="dmac\;Reserved when l2_type is not ETH" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="smac_47_32" descr="smac\;Reserved when l2_type is not ETH" access="RO" offset="0x28.0" size="0x0.16" />
	<field name="smac_31_0" descr="smac\;Reserved when l2_type is not ETH" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="vid" descr="VLAN ID\;Reserved when vlan_type is one of: NO_TAG, PRIO_TAG" access="RO" offset="0x30.0" size="0x0.12" />
	<field name="dei" descr="Reserved when vlan_type is one of: NO_TAG" access="RO" offset="0x30.12" size="0x0.1" />
	<field name="pcp" descr="Reserved when vlan_type is one of: NO_TAG" access="RO" offset="0x30.13" size="0x0.3" />
	<field name="inner_vid" descr="Inner VLAN ID\;Reserved when vlan_type is not QINQ" access="RO" offset="0x34.0" size="0x0.12" />
	<field name="inner_dei" descr="Reserved when vlan_type is not QINQ" access="RO" offset="0x34.12" size="0x0.1" />
	<field name="inner_pcp" descr="Reserved when vlan_type is not QINQ" access="RO" offset="0x34.13" size="0x0.3" />
	<field name="dont_frag" descr="Reserved when l3_type is not one of: IPv4, IPv6, GRH" access="RO" offset="0x38.0" size="0x0.1" />
	<field name="ttl" descr="Reserved when l3_type is not one of: IPv4, IPv6, GRH" access="RO" offset="0x38.8" size="0x0.8" />
	<field name="ecn" descr="Reserved when l3_type is not one of: IPv4, IPv6, GRH" access="RO" offset="0x38.16" size="0x0.2" />
	<field name="dscp" descr="Reserved when l3_type is not one of: IPv4, IPv6, GRH" access="RO" offset="0x38.18" size="0x0.6" />
	<field name="dport" descr="Reserved when l4_type is not one of: TCP, UDP\;Reserved when tunnel_type is VXLAN" access="RO" offset="0x3C.0" size="0x0.16" />
	<field name="sport" descr="Reserved when l4_type is not one of: TCP, UDP" access="RO" offset="0x3C.16" size="0x0.16" />
	<field name="sip" descr="Reserved when l3_type is not one of: IPv4, IPv6, GRH\;For l3_type of IPV4, only bits [31:0] are relevant" access="RO" high_bound="3" low_bound="0" offset="0x40.0" size="0x10.0" />
	<field name="dip" descr="Reserved when l3_type is not one of: IPv4, IPv6, GRH\;For l3_type of IPV4, only bits [31:0] are relevant" access="RO" high_bound="3" low_bound="0" offset="0x50.0" size="0x10.0" />
	<field name="extra_data" descr="When extra_data_type is NONE: Reserved\;Table 2948, &quot;CEER - extra_fields NONE Layout,&quot; on page 3152\;When extra_data_type is TUNNEL:\;Table 2944, &quot;CEER - extra_fields tunnel Layout,&quot; on page 3148\;When extra_data_type is MPLS:\;Table 2946, &quot;CEER - extra_fields MPLS Layout,&quot; on page 3150\;\;When used as trap and extra_data_type=0 then the CEER length is shorter (not having the extra_data field)" subnode="ceer_extra_data_auto_ext" access="RW" offset="0x60.0" size="0x40.0" union_selector="$(parent).extra_data_type" />
</node>

<node name="ceer_extra_data_auto_ext" descr="" attr_is_union="1" size="0x40.0" >
	<field name="ceer_extra_fields_NONE_ext" descr="" subnode="ceer_extra_fields_NONE_ext" offset="0x0.0" selected_by="NONE" size="0x4.0" />
	<field name="ceer_extra_fields_ext" descr="" subnode="ceer_extra_fields_ext" offset="0x0.0" selected_by="TUNNEL" size="0x40.0" />
	<field name="ceer_extra_fields_MPLS_ext" descr="" subnode="ceer_extra_fields_MPLS_ext" offset="0x0.0" selected_by="MPLS" size="0x18.0" />
</node>

<node name="ceer_extra_fields_MPLS_ext" descr="" size="0x18.0" >
	<field name="mpls_exp" descr="" access="RO" offset="0x0.0" size="0x0.3" />
	<field name="mpls_bos" descr="BoS bit was detected in the last valid label\;If there are many labels (more than exposed by this register, or more than allowed by parsing) then the BoS label may be &apos;0&apos;" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="mpls_label0_ttl" descr="Reserved when mpls_lb0_v is &apos;0&apos;" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="mpls_label0_label_id" descr="Reserved when mpls_lb0_v is &apos;0&apos;\;" access="RO" offset="0x4.8" size="0x0.20" />
	<field name="mpls_lb0_v" descr="Label 0 valid\;Label0 is the outermost label (top of stack)" access="RO" offset="0x4.31" size="0x0.1" />
	<field name="mpls_label1_ttl" descr="Reserved when mpls_lb1_v is &apos;0&apos;" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="mpls_label1_label_id" descr="Reserved when mpls_lb1_v is &apos;0&apos;\;" access="RO" offset="0x8.8" size="0x0.20" />
	<field name="mpls_lb1_v" descr="" access="RO" offset="0x8.31" size="0x0.1" />
	<field name="mpls_label2_ttl" descr="Reserved when mpls_lb2_v is &apos;0&apos;" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="mpls_label2_label_id" descr="Reserved when mpls_lb2_v is &apos;0&apos;" access="RO" offset="0xC.8" size="0x0.20" />
	<field name="mpls_lb2_v" descr="" access="RO" offset="0xC.31" size="0x0.1" />
	<field name="mpls_label3_ttl" descr="Reserved when mpls_lb3_v is &apos;0&apos;\;" access="RO" offset="0x10.0" size="0x0.8" />
	<field name="mpls_label3_label_id" descr="Reserved when mpls_lb3_v is &apos;0&apos;\;" access="RO" offset="0x10.8" size="0x0.20" />
	<field name="mpls_lb3_v" descr="" access="RO" offset="0x10.31" size="0x0.1" />
	<field name="mpls_label4_ttl" descr="Reserved when mpls_lb4_v is &apos;0&apos;\;" access="RO" offset="0x14.0" size="0x0.8" />
	<field name="mpls_label4_label_id" descr="Reserved when mpls_lb4_v is &apos;0&apos;\;" access="RO" offset="0x14.8" size="0x0.20" />
	<field name="mpls_lb4_v" descr="" access="RO" offset="0x14.31" size="0x0.1" />
</node>

<node name="ceer_extra_fields_NONE_ext" descr="" size="0x4.0" >
</node>

<node name="ceer_extra_fields_ext" descr="" size="0x40.0" >
	<field name="vni" descr="Reserved when tunnel_type is not one of: VXLAN, NVGRE\;" access="RO" offset="0x0.0" size="0x0.24" />
	<field name="inner_dmac_47_32" descr="Inner DMAC\;Reserved when tunnel_type is not one of: VXLAN, NVGRE" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="inner_dmac_31_0" descr="Inner DMAC\;Reserved when tunnel_type is not one of: VXLAN, NVGRE" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="inner_smac_47_32" descr="Inner SMAC\;Reserved when tunnel_type is not one of: VXLAN, NVGRE" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="inner_smac_31_0" descr="Inner SMAC\;Reserved when tunnel_type is not one of: VXLAN, NVGRE" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="inner_dont_frag" descr="reserved when inner_l3_type is not IPV4" access="RO" offset="0x1C.0" size="0x0.1" />
	<field name="inner_ttl" descr="reserved when inner_l3_type is not IPV4\;" access="RO" offset="0x1C.8" size="0x0.8" />
	<field name="inner_ecn" descr="reserved when inner_l3_type is not IPV4\;" access="RO" offset="0x1C.16" size="0x0.2" />
	<field name="inner_dscp" descr="reserved when inner_l3_type is not IPV4" access="RO" offset="0x1C.18" size="0x0.6" />
	<field name="inner_l3_type" descr="Inner L3 type:\;0: IPV4\;1: other\;\;" access="RO" enum="IPV4=0x0,other=0x1" offset="0x1C.24" size="0x0.4" />
	<field name="inner_sip" descr="Inner source IP\;reserved when inner_l3_type is not IPV4\;" access="RO" high_bound="3" low_bound="0" offset="0x20.0" size="0x10.0" />
	<field name="inner_dip" descr="Inner destination IP\;reserved when inner_l3_type is not IPV4\;" access="RO" high_bound="3" low_bound="0" offset="0x30.0" size="0x10.0" />
</node>

<node name="cegcr_ext" descr="" size="0x20.0" >
	<field name="sticky" descr="Sticky Elephants\;0: A flow which was detected as an elephant flow may become floating or mice\;1: A flow which was detected as an elephant flow will not change state until cleared by CEER.clear" access="RW" offset="0x0.1" size="0x0.1" />
	<field name="f2e" descr="Floating to Elephants\;If a flow is at candidate state (at range of higher than RR-MT) for max_floating_time and f2e is set then the flow becomes an elephant\;" access="RW" offset="0x0.2" size="0x0.1" />
	<field name="max_floating_time" descr="Max floating time\;If a flow is at floating state for max_floating_time and f2e is set then the flow becomes an elephant\;Units of Sec\;Reserved when f2e = 0\;" access="RW" offset="0x4.0" size="0x0.10" />
	<field name="reference_rate" descr="Reference Rate (RR)\;Flows with a rate higher than RR and a burst higher than EBS are detected as elephant flows.\;Flows with a rate lower than RR and a burst delta higher than MBS are detected as mice flows.\;Other flows are floating flows (not yet detected as elephants or mice).\;Units are 10^6 bits/sec\;Minimum allowed rate is 2*10^6 bps\;" access="RW" offset="0x10.0" size="0x4.0" />
	<field name="elephants_thr" descr="Elephants Threshold (ET)\;Flows with a rate higher than RR and a burst higher than ET are detected as elephant flows.\;Units are 10^6 bits\;" access="RW" offset="0x14.0" size="0x0.20" />
	<field name="elephants_max_thr" descr="Elephants Max Threshold. Used for non-sticky mode so that an elephant flow will not gain a too high Ci value. Reason: if Ci becomes to high it may take the flow a long time to become a mice.\;Units are 10^6 bits/sec\;Reserved when Spectrum" access="RW" offset="0x18.0" size="0x0.20" />
	<field name="mice_thr" descr="Mice Threshold (MT)\;Flows with a rate lower than RR and a burst lower than MT are detected as mice flows.\;Units are 10^6 bits\;" access="RW" offset="0x1C.0" size="0x0.20" />
</node>

<node name="cepc_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pp" descr="Per port:\;0: global configuration\;1: per port configuration" access="INDEX" offset="0x0.15" size="0x0.1" />
	<field name="local_port" descr="Ingress Local Port\;Not supported by CPU port\;Reserved when pp=0" access="INDEX" offset="0x0.16" size="0x0.9" />
	<field name="en_ed" descr="Enable Elephants detection:\;0: disabled (default)\;1: enabled" access="RW" offset="0x4.0" size="0x0.1" />
</node>

<node name="chlmm_ext" descr="" size="0x14.0" >
	<field name="switch_prio" descr="Switch Priority" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="hlt_table_pointer" descr="High Latency Table pointer for multicast packets\;Range 0 .. cap_max_high_latency_table - 1\;" access="RW" offset="0x10.0" size="0x0.8" />
</node>

<node name="chltm_ext" descr="" size="0x14.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number\;CPU port is not supported" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="traffic_class" descr="Traffic Class\;Range is 0..cap_max_tclass_data-1" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="hlt_table_pointer" descr="High Latency Table pointer for unicast packets\;Range 0 .. cap_max_high_latency_table - 1\;" access="RW" offset="0x10.0" size="0x0.8" />
</node>

<node name="chltr_ext" descr="" size="0xc.0" >
	<field name="hlt_table_index" descr="High Latency Table index\;Range 0 .. cap_max_high_latency_table - 1\;" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="high_latency_thr" descr="High latency threshold\;Units of 1uSec\;\;Note: HW has latency measurement error of   250nSec\;Note: packets with a latency larger than 4Sec latency may not be latency-mirrored. Thus it is recommended to set SLL to 4Sec\;\;" access="RW" offset="0x8.0" size="0x0.20" />
</node>

<node name="command_payload_ext" descr="" size="0x104.0" >
	<field name="data" descr="Command data. It may be a request or a response data." access="RW" high_bound="64" low_bound="0" offset="0x0.0" size="0x104.0" />
</node>

<node name="config_item_ext" descr="" size="0xc.0" >
	<field name="length" descr="Length of configuration item data in bytes (not including header). Must be between 0 and 256." access="RW" offset="0x0.0" size="0x0.9" />
	<field name="host_id_valid" descr="Host ID valid:\;1: the type_index.host_id field is valid\;Valid only when MNVGC.priv_nv_other_host=1 and the type_class is a Host" access="RO" offset="0x0.9" size="0x0.1" />
	<field name="version" descr="Configuration item version - defines the data structure following the header (together with the type field)." access="RW" offset="0x0.12" size="0x0.4" />
	<field name="writer_id" descr="The entity which configured this parameter\;0x0: UNSPECIFIED\;0x1: CHASSIS_BMC\;0x2: MAD\;0x3: BMC\;0x4: COMMAND_INTERFACE\;0x5: ICMD - with unspecified source\;0x6: ICMD_UEFI_HII - configured by the NIC&apos;s UEFI expansion ROM&quot;s HII menu.\;0x7: ICMD_UEFI_CLP - configured by the NIC&apos;s expansion ROM&quot;s CLP.\;0x8: ICMD_Flexboot - configured by the NIC&quot;s legacy expansion ROM.\;0x9: ICMD_mlxconfig - configured by Mellanox mlxconfig tool\;0xA: ICMD_USER1 - value available for customer created tools that uses the ICMD interface for writing TLVs.\;0xB: ICMD_USER2 - value available for customer created tools that uses the ICMD interface for writing TLVs.\;0xC: ICMD_MLXCONFIG_SET_RAW - configures by\;mlxconfig set raw operation.\;0xD: ICMD_FLEXBOOT_CLP - configured by Legacy Expansion ROM CLP\;0x10: BMC_APP1 - Configuration was done over the BMC by application #1 (application name is OEM specific)\;0x11: BMC_APP2 - Configuration was done over the BMC by application #2 (application name is OEM specific)\;0x12: BMP_APP3 - Configuration was done over the BMC by application #3 (application name is OEM specific)\;0x1F: OTHER - the parameter was written by the NIC due to other reasons. \;\;Note - This field is writeable only when using the ICMD interface. The only value that are valid for writes are 0x6 through 0xB. Other values will be replaced by 0x5ICMD." access="RO" enum="UNSPECIFIED=0x0,CHASSIS_BMC=0x1,MAD=0x2,BMC=0x3,COMMAND_INTERFACE=0x4,ICMD=0x5,ICMD_UEFI_HII=0x6,ICMD_UEFI_CLP=0x7,ICMD_Flexboot=0x8,ICMD_mlxconfig=0x9,ICMD_USER1=0xa,ICMD_USER2=0xb,ICMD_MLXCONFIG_SET_RAW=0xc,ICMD_FLEXBOOT_CLP=0xd,BMC_APP1=0x10,BMC_APP2=0x11,BMP_APP3=0x12,OTHER=0x1f" offset="0x0.16" size="0x0.5" />
	<field name="access_mode" descr="Defines which value of the Configuration Item will be accessed.\;0: NEXT - Next value to be applied\;1: CURRENT - Currently set values (only valid for Query operation) Supported only if NVGC.nvda_read_current_settings==1.\;2: FACTORY - Default factory values (only valid for Query operation). Supported only if NVGC.nvda_read_factory_settings==1." access="INDEX" enum="NEXT=0x0,CURRENT=0x1,FACTORY=0x2" offset="0x0.22" size="0x0.2" />
	<field name="rd_en" descr="Read Enable\;Controls the read operation during different life-cycle stages.\;0: TLV cannot be read by the subsequent life-cycle priorities.\;1: TLV can be read by the subsequent life-cycle priorities." access="RW" offset="0x0.24" size="0x0.1" />
	<field name="ovr_en" descr="Override Enable\;0: Can only be overwritten by the current life-cycle priority.\;1: Allowed to be over-written by the subsequent life-cycle priorities." access="RW" offset="0x0.25" size="0x0.1" />
	<field name="priority" descr="The life-cycle priority of this configuration.\;0x0: USER,\;0x1: OEM,\;0x2: Reserved  \;0x3: MLNX\;\;The priority is set by either:\;1. When using MNVDA, the TLV will have user priority\;2. When using NVCONFIG, each TLV has its own priority" access="RO" offset="0x0.28" size="0x0.2" />
	<field name="type" descr="Configuration item index according to its type_class. \;Table 784, &quot;Configuration Item Data Type Class Global Layout,&quot; on page 1074\;Table 786, &quot;Configuration Item Data Type Class Physical Port Layout,&quot; on page 1074\;Table 788, &quot;Configuration Item Data Type Class Per Host-PF Layout,&quot; on page 1075\;Table 790, &quot;Configuration Item Data Type Class Log Layout,&quot; on page 1075\;Table 792, &quot;Configuration Item Data Type Class File Layout,&quot; on page 1076\;Table 796, &quot;Configuration Item Data Type Class Switch Global Layout,&quot; on page 1077\;Table 798, &quot;Configuration Item Data Type Class Module Layout,&quot; on page 1077\;Table 800, &quot;Configuration Item Data Type Class Multi Instance Layout,&quot; on page 1078" subnode="config_item_type_auto_ext" access="INDEX" offset="0x4.0" size="0x4.0" />
</node>

<node name="config_item_type_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="configuration_item_type_class_global_ext" descr="" subnode="configuration_item_type_class_global_ext" offset="0x0.0" size="0x4.0" />
	<field name="configuration_item_type_class_physical_port_ext" descr="" subnode="configuration_item_type_class_physical_port_ext" offset="0x0.0" size="0x4.0" />
	<field name="configuration_item_type_class_per_host_pf_ext" descr="" subnode="configuration_item_type_class_per_host_pf_ext" offset="0x0.0" size="0x4.0" />
	<field name="configuration_item_type_class_log_ext" descr="" subnode="configuration_item_type_class_log_ext" offset="0x0.0" size="0x4.0" />
	<field name="configuration_item_type_class_file_ext" descr="" subnode="configuration_item_type_class_file_ext" offset="0x0.0" size="0x4.0" />
	<field name="configuration_item_type_class_switch_global_ext" descr="" subnode="configuration_item_type_class_switch_global_ext" offset="0x0.0" size="0x4.0" />
	<field name="configuration_item_type_class_module_ext" descr="" subnode="configuration_item_type_class_module_ext" offset="0x0.0" size="0x4.0" />
	<field name="configuration_item_type_class_multi_instance_ext" descr="" subnode="configuration_item_type_class_multi_instance_ext" offset="0x0.0" size="0x4.0" />
</node>

<node name="configuration_item_type_class_file_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="type_class" descr="type_class = 0x6" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="configuration_item_type_class_global_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="type_class" descr="type_class = 0x0" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="configuration_item_type_class_log_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="type_class" descr="type_class = 0x5" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="configuration_item_type_class_module_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.14" />
	<field name="module_index" descr="Module Index" access="INDEX" offset="0x0.14" size="0x0.10" />
	<field name="type_class" descr="type_class = 0x9" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="configuration_item_type_class_multi_instance_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.12" />
	<field name="type_class" descr="type_class = 0xA" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="configuration_item_type_class_per_host_pf_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.10" />
	<field name="pci_bus_index" descr="" access="RW" offset="0x0.10" size="0x0.8" />
	<field name="pf_index" descr="" access="RW" offset="0x0.18" size="0x0.6" />
	<field name="type_class" descr="type_class = 0x3" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="configuration_item_type_class_physical_port_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="port" descr="" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="type_class" descr="type_class = 0x1" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="configuration_item_type_class_switch_global_ext" descr="" size="0x4.0" >
	<field name="parameter_index" descr="" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="type_class" descr="type_class = 0x8" access="INDEX" offset="0x0.24" size="0x0.8" />
</node>

<node name="cpqe_ext" descr="" size="0x14.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Egress Local Port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="marking_percent" descr="ECN Marking percentage when the local_port rate is above the phantom queue rate.\;Range is 0..100, units of integer percentage" access="RW" offset="0x8.16" size="0x0.7" />
	<field name="rate" descr="Units of 1000bps, bps only\;Granularity is 200mbps\;Error is up to 3% from configuration (for example: at 100Gbps, rate is configured to 200mbps, actual rate may be 206mbps)\;ECN marking is done when the rate is above phantom_queue_rate." access="RW" offset="0xC.0" size="0x0.31" />
	<field name="en" descr="Phantom queue configuration enable. Enables configuration of the phantom queue rate and bs\;0: disable\;1: enable\;Not supported for CPU port" access="RW" offset="0xC.31" size="0x0.1" />
	<field name="bs" descr="Burst size.\;If writing 0: value will be set to 11.\;Burst size is 2^bs * 512 [bits].\;Range is: 11..25.\;" access="RW" offset="0x10.0" size="0x0.6" />
</node>

<node name="crspace_access_payload_ext" descr="" size="0x104.0" >
	<field name="address" descr="Starting address" access="WO" offset="0x0.0" size="0x4.0" />
	<field name="data" descr="CrSpace data" access="RW" high_bound="63" low_bound="0" offset="0x4.0" size="0x100.0" />
</node>

<node name="cwgcr_ext" descr="" size="0x14.0" >
	<field name="aqs_time" descr="Average queue size time\;Time from current_queue_size to previous_aqs\;The time is 2^aqs_time * 64nSec\;Valid range is 0..24" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="aqs_weight" descr="Average queue size weight.\;The average queue size (aqs) is calculated by:\;aqs = ((current_queue_size)*2^-w) + ((previous_aqs)*(1-2^-w)) \;where w is aqs_weight\;The time between current_queue_size and previous_aqs is configured by aqs_time\;Note: when mode=percentage then there is no moving average (the aqs_weight is effectively 0). See Section 13.7.2, &quot;CWTP - Congestion WRED ECN TClass Profile Register&quot;, on page 3129\;" access="RW" offset="0x0.8" size="0x0.4" />
	<field name="scd" descr="Enable ECN Source Congestion Detection only. Don&apos;t mark victim packets.\;" access="RW" offset="0x0.16" size="0x0.1" />
	<field name="en" descr="enable bits:\;bit2: WRED drop enable\;For Spectrum, ingress mirror of WRED can utilize this configuration, see Section 5.16.3, &quot;MPAR - Monitoring Port Analyzer Register&quot;, on page 1284" access="RW" offset="0x0.24" size="0x0.4" />
	<field name="cece" descr="Count ECN for Congestion Experienced\;0: do not count &quot;ECN mark&quot; for a packet which has Congestion Experienced (ECN=11 at ingress) \;1: do count ECN mark for a packet which has Congestion Experienced (ECN=11 at ingress) and experiences congestion in the switch (default)\;In any case, a packet coming with ECN=00 is not counted as ECN." access="RW" offset="0x4.0" size="0x0.1" />
	<field name="mece" descr="Mirror ECN for Congestion Experienced\;0: do not ecn-mirror a packet which has Congestion Experienced (ECN=11 at ingress)\;1: do ecn-mirror for a packet which has Congestion Experienced (ECN=11 at ingress) and experiences congestion in the switch (default)\;In any case, a packet coming with ECN=00 is not ecn-mirrored\;Reserved when Spectrum\;Reserved when Quantum which always does ecn-mirror regardless of fecn in the packet" access="RW" offset="0x4.1" size="0x0.1" />
	<field name="ece_inner_en" descr="Only for Eth Switches:\;When ECE is event then:\;0: OUTER - only for outer TCP (if exists)\;1: OUTER_OR_INNER - for either outer (if exists) or inner TCP (if exists)\;Reserved when Spectrum/-2/-3\;Supported from Spectrum-4 and above." access="RW" offset="0x4.4" size="0x0.1" />
</node>

<node name="cwpp_ext" descr="" size="0x20.0" >
	<field name="pool" descr="Egress pool in the switch shared buffer\;Range is 0..cap_num_pool_supported-1" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="profile" descr="See Table 2924, &quot;CWPP - Profile Layout,&quot; on page 3131" subnode="cwpp_profile_ext" access="RW" high_bound="2" low_bound="0" offset="0x8.0" size="0x18.0" />
</node>

<node name="cwpp_profile_ext" descr="" size="0x8.0" >
	<field name="min" descr="Minimum Average Queue Size of the profile number &lt;i&gt;, in cells. Valid inputs are 0..cap_total_buffer_size/cap_cell_size\;For Spectrum: must be a multiple of 64.\;Note: for Spectrum, must be larger than 2^aqs_weight cells, see Section 13.7.1, &quot;CWGCR - Congestion WRED ECN General Configuration Register&quot;, on page 3126" access="RW" offset="0x0.0" size="0x0.20" />
	<field name="max" descr="Maximum Average Queue Size of the profile number &lt;i&gt;, in cells. Valid inputs are 0..cap_total_buffer_size/cap_cell_size\;For Spectrum: must be a multiple of 64" access="RW" offset="0x4.0" size="0x0.20" />
	<field name="percent" descr="Percentage of WRED and ECN marking for Maximum Average Queue Size of the profile number &lt;i&gt;\;Range is 0..100, units of integer percentage\;Default is 0" access="RW" offset="0x4.24" size="0x0.7" />
</node>

<node name="cwtp_ext" descr="" size="0x40.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. Determines the way local_port is interpreted:\;0: Local_port_number\;" access="INDEX" enum="Local_port_number=0x0" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number\;CPU port is not supported" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="traffic_class" descr="Traffic Class\;Range is 0..cap_max_tclass_data-1" access="INDEX" offset="0x20.0" size="0x0.8" />
	<field name="mode" descr="Mode of thresholds for WRED and ECN:\;0: Fixed\;1: Percentage" access="RW" enum="Fixed=0x0,Percentage=0x1" offset="0x24.24" size="0x0.1" />
	<field name="profile1_min" descr="Minimum Average Queue Size of the profile number &lt;i&gt;\;When mode is Fixed:\;Cells. Valid inputs are 1..cap_total_buffer_size/cap_cell_size.\;For Spectrum: must be a multiple of 64\;Note: for Spectrum, must be larger than 2^aqs_weight cells, see Section 13.7.1, &quot;CWGCR - Congestion WRED ECN General Configuration Register&quot;, on page 3126\;When mode is Percentage:\;Percentage of the quota of local_port,traffic_class. Range is 0..100, units of integer percentage. When ECN Source Congestion Detection is enabled then congestion occurs when there are at least 256 cells in the buffer\;" access="RW" offset="0x28.0" size="0x0.20" />
	<field name="profile1_max" descr="Maximum Average Queue Size of the profile number &lt;i&gt;\;When mode is Fixed:\;Cells. Valid inputs are 1..cap_total_buffer_size/cap_cell_size\;For Spectrum: must be a multiple of 64\;When mode is Percentage:\;Percentage of the quota of local_port,traffic_class. Range is 0..100, units of integer percentage.\;profile&lt;i&gt;_max must always be equal or greater than profile&lt;i&gt;_min" access="RW" offset="0x2C.0" size="0x0.20" />
	<field name="profile1_percent" descr="Percentage of WRED and ECN marking for Maximum Average Queue Size of the profile number &lt;i&gt;\;Range is 0..100, units of integer percentage\;Default is 0" access="RW" offset="0x2C.24" size="0x0.7" />
	<field name="profile2_min" descr="Same as above." access="RW" offset="0x30.0" size="0x0.20" />
	<field name="profile2_max" descr="Same as above." access="RW" offset="0x34.0" size="0x0.20" />
	<field name="profile2_percent" descr="Same as above." access="RW" offset="0x34.24" size="0x0.7" />
	<field name="profile3_min" descr="Same as above." access="RW" offset="0x38.0" size="0x0.20" />
	<field name="profile3_max" descr="Same as above." access="RW" offset="0x3C.0" size="0x0.20" />
	<field name="profile3_percent" descr="Same as above." access="RW" offset="0x3C.24" size="0x0.7" />
</node>

<node name="cwtpm_ext" descr="" size="0x44.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. Determines the way local_port is interpreted:\;0: Local_port_number\;" access="INDEX" enum="Local_port_number=0x0" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number\;CPU port is not supported" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="traffic_class" descr="Traffic Class\;Range is 0..cap_max_tclass_data-1" access="INDEX" offset="0x20.0" size="0x0.8" />
	<field name="ee" descr="Enable ECN on traffic class\;0: Disable\;1: Enable\;Default is 0\;Reserved when Quantum" access="RW" enum="Disable=0x0,Enable=0x1" offset="0x24.0" size="0x0.1" />
	<field name="ew" descr="Enable WRED on traffic class:\;0: Disable\;1: Enable\;Default is 0\;Reserved when Quantum" access="RW" enum="Disable=0x0,Enable=0x1" offset="0x24.1" size="0x0.1" />
	<field name="ece" descr="Eth switch only:\;Enable ECE (TCP.ECE setting by the switch):\;Note: for ECE only tcp_g is used (tcp_y, tcp_r, ntcp_* ignored)\;Note: when both ece and ew are set, then if WRED does a drop then efficiently the ECE has no significance.\;Reserved when IB Switches and when Spectrum/-2/-3\;\;0: Disable\;1: Enable\;Default is 0\;\;Supported from Spectrum-4 and above." access="RW" enum="Disable=0x0,Enable=0x1" offset="0x24.2" size="0x0.1" />
	<field name="tcp_g" descr="TCP Green Profile Number\;0 for disabling both WRED and ECN for this type of traffic.\;Default is 0\;Reserved when Quantum and NIC" access="RW" offset="0x34.0" size="0x0.2" />
	<field name="tcp_r" descr="TCP Red Profile Number\;0 for disabling both WRED and ECN for this type of traffic.\;Default is 0\;Reserved when Quantum and NIC" access="RW" offset="0x38.0" size="0x0.2" />
	<field name="tcp_y" descr="TCP Yellow Profile Number\;0 for disabling both WRED and ECN for this type of traffic.\;Default is 0\;Reserved when Quantum and NIC" access="RW" offset="0x38.16" size="0x0.2" />
	<field name="ntcp_g" descr="Non-TCP Green Profile Number\;0 for disabling both WRED and ECN for this type of traffic.\;Default is 0\;Reserved when Quantum and NIC" access="RW" offset="0x3C.0" size="0x0.2" />
	<field name="ntcp_r" descr="Non-TCP Red Profile Number\;0 for disabling both WRED and ECN for this type of traffic.\;Default is 0\;Reserved when Quantum and NIC" access="RW" offset="0x40.0" size="0x0.2" />
	<field name="ntcp_y" descr="Non-TCP Yellow Profile Number\;0 for disabling both WRED and ECN for this type of traffic.\;Default is 0\;Reserved when Quantum and NIC" access="RW" offset="0x40.16" size="0x0.2" />
</node>

<node name="date_time_layout_ext" descr="" size="0x8.0" >
	<field name="hours" descr="hour (UTC) - 2 packed BCD digits" access="RW" offset="0x0.8" size="0x0.8" />
	<field name="minutes" descr="minutes - 2 packed BCD digits" access="RW" offset="0x0.16" size="0x0.8" />
	<field name="seconds" descr="seconds - 2 packed BCD digits" access="RW" offset="0x0.24" size="0x0.8" />
	<field name="day" descr="day - 2 packed BCD digits" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="month" descr="month - 2 packed BCD digits" access="RW" offset="0x4.8" size="0x0.8" />
	<field name="year" descr="year - 4 packed BCD digits" access="RW" offset="0x4.16" size="0x0.16" />
</node>

<node name="elport_record_ext" descr="" size="0x4.0" >
	<field name="evid" descr="egress vid, range 0..4095" access="RW" offset="0x0.0" size="0x0.12" />
	<field name="update" descr="Update enable (when write):\;0: do not update the entry\;1: update the entry" access="OP" offset="0x0.31" size="0x0.1" />
</node>

<node name="emt_binding_info_ext" descr="" size="0x8.0" >
	<field name="emt_bitmask" descr="bitmask describes which spare EMTs can be used for the specific program\;\;Reserved when atomic = 0" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="atomic" descr="0: non atomic\;1: atomic" access="RW" offset="0x0.16" size="0x0.1" />
</node>

<node name="enum_entry" descr="" size="0x4.0" >
</node>

<node name="eth_2819_cntrs_grp_data_layout_ext" descr="" size="0xf8.0" >
	<field name="ether_stats_drop_events_high" descr="The total number of events in which packets were dropped by the probe due to lack of resources.\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="ether_stats_drop_events_low" descr="The total number of events in which packets were dropped by the probe due to lack of resources.\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="ether_stats_octets_high" descr="The total number of octets of data (including those in bad packets) received (excluding framing bits but including FCS octets).\;" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="ether_stats_octets_low" descr="The total number of octets of data (including those in bad packets) received (excluding framing bits but including FCS octets).\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="ether_stats_pkts_high" descr="The total number of packets (including bad packets, broadcast packets, and multicast packets) received.\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="ether_stats_pkts_low" descr="The total number of packets (including bad packets, broadcast packets, and multicast packets) received.\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="ether_stats_broadcast_pkts_high" descr="The total number of good packets received that were directed to the broadcast address. \;Note: This does not include multicast packets.\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="ether_stats_broadcast_pkts_low" descr="The total number of good packets received that were directed to the broadcast address. \;Note: This does not include multicast packets.\;" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="ether_stats_multicast_pkts_high" descr="The total number of good packets received that were directed to a multicast MAC address. \;Note: This number does not include packets directed to the broadcast address.\;" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="ether_stats_multicast_pkts_low" descr="The total number of good packets received that were directed to a multicast MAC address. \;Note: This number does not include packets directed to the broadcast address.\;" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="ether_stats_crc_align_errors_high" descr="The total number of packets received that had a length (excluding framing bits, but including FCS octets) of between 64 and MTU octets, inclusive, but had either a bad frame check sequence (FCS) with an integral number of octets (FCS error) or a bad FCS with a non-integral number of octets (alignment error).\;" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="ether_stats_crc_align_errors_low" descr="The total number of packets received that had a length (excluding framing bits, but including FCS octets) of between 64 and MTU octets, inclusive, but had either a bad frame check sequence (FCS) with an integral number of octets (FCS error) or a bad FCS with a non-integral number of octets (alignment error).\;" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="ether_stats_undersize_pkts_high" descr="The total number of packets received that were less than 64 octets long (excluding framing bits, but including FCS octets) and were otherwise well formed.\;" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="ether_stats_undersize_pkts_low" descr="The total number of packets received that were less than 64 octets long (excluding framing bits, but including FCS octets) and were otherwise well formed.\;" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="ether_stats_oversize_pkts_high" descr="The total number of packets received that were longer than MTU octets (excluding framing bits, but including FCS octets) but were otherwise well formed.\;" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="ether_stats_oversize_pkts_low" descr="The total number of packets received that were longer than MTU octets (excluding framing bits, but including FCS octets) but were otherwise well formed.\;" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="ether_stats_fragments_high" descr="The total number of packets received that were less than 64 octets in length (excluding framing bits but including FCS octets) and had either a bad FCS with an integral number of octets (FCS error) or a bad FCS with a non-integral number of octets (alignment error).\;" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="ether_stats_fragments_low" descr="The total number of packets received that were less than 64 octets in length (excluding framing bits but including FCS octets) and had either a bad FCS with an integral number of octets (FCS error) or a bad FCS with a non-integral number of octets (alignment error).\;" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="ether_stats_jabbers_high" descr="The total number of packets received that were longer than MTU octets (excluding framing bits, but including FCS octets), and had either a bad FCS with an integral number of octets (FCS error) or a bad FCS with a non-integral number of octets (alignment error).\;" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="ether_stats_jabbers_low" descr="The total number of packets received that were longer than MTU octets (excluding framing bits, but including FCS octets), and had either a bad FCS with an integral number of octets (FCS error) or a bad FCS with a non-integral number of octets (alignment error).\;" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="ether_stats_collisions_high" descr="The best estimate of the total number of collisions on this Ethernet segment.\;" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="ether_stats_collisions_low" descr="The best estimate of the total number of collisions on this Ethernet segment.\;" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="ether_stats_pkts64octets_high" descr="The total number of packets (including bad packets) received that were 64 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x58.0" size="0x4.0" />
	<field name="ether_stats_pkts64octets_low" descr="The total number of packets (including bad packets) received that were 64 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="ether_stats_pkts65to127octets_high" descr="The total number of packets (including bad packets) received that were between 65 and 127 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x60.0" size="0x4.0" />
	<field name="ether_stats_pkts65to127octets_low" descr="The total number of packets (including bad packets) received that were between 65 and 127 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x64.0" size="0x4.0" />
	<field name="ether_stats_pkts128to255octets_high" descr="The total number of packets (including bad packets) received that were between 128 and 255 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x68.0" size="0x4.0" />
	<field name="ether_stats_pkts128to255octets_low" descr="The total number of packets (including bad packets) received that were between 128 and 255 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="ether_stats_pkts256to511octets_high" descr="The total number of packets (including bad packets) received that were between 256 and 511 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x70.0" size="0x4.0" />
	<field name="ether_stats_pkts256to511octets_low" descr="The total number of packets (including bad packets) received that were between 256 and 511 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x74.0" size="0x4.0" />
	<field name="ether_stats_pkts512to1023octets_high" descr="The total number of packets (including bad packets) received that were between 512 and 1023 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x78.0" size="0x4.0" />
	<field name="ether_stats_pkts512to1023octets_low" descr="The total number of packets (including bad packets) received that were between 512 and 1023 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x7C.0" size="0x4.0" />
	<field name="ether_stats_pkts1024to1518octets_high" descr="The total number of packets (including bad packets) received that were between 1024 and 1518 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x80.0" size="0x4.0" />
	<field name="ether_stats_pkts1024to1518octets_low" descr="The total number of packets (including bad packets) received that were between 1024 and 1518 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x84.0" size="0x4.0" />
	<field name="ether_stats_pkts1519to2047octets_high" descr="The total number of packets (including bad packets) received that were between 1519 and 2047 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x88.0" size="0x4.0" />
	<field name="ether_stats_pkts1519to2047octets_low" descr="The total number of packets (including bad packets) received that were between 1519 and 2047 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x8C.0" size="0x4.0" />
	<field name="ether_stats_pkts2048to4095octets_high" descr="The total number of packets (including bad packets) received that were between 2048 and 4095 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x90.0" size="0x4.0" />
	<field name="ether_stats_pkts2048to4095octets_low" descr="The total number of packets (including bad packets) received that were between 2048 and 4095 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x94.0" size="0x4.0" />
	<field name="ether_stats_pkts4096to8191octets_high" descr="The total number of packets (including bad packets) received that were between 4096 and 8191 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x98.0" size="0x4.0" />
	<field name="ether_stats_pkts4096to8191octets_low" descr="The total number of packets (including bad packets) received that were between 4096 and 8191 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x9C.0" size="0x4.0" />
	<field name="ether_stats_pkts8192to10239octets_high" descr="The total number of packets (including bad packets) received that were between 8192 and 10239 octets in length (excluding framing bits but including FCS octets).\;" access="RO" offset="0xA0.0" size="0x4.0" />
	<field name="ether_stats_pkts8192to10239octets_low" descr="The total number of packets (including bad packets) received that were between 8192 and 10239 octets in length (excluding framing bits but including FCS octets).\;" access="RO" offset="0xA4.0" size="0x4.0" />
</node>

<node name="eth_2863_cntrs_grp_data_layout_ext" descr="" size="0xf8.0" >
	<field name="if_in_octets_high" descr="The total number of octets received, including framing characters. Including MAC control frames.\;\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="if_in_octets_low" descr="The total number of octets received, including framing characters. Including MAC control frames.\;\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="if_in_ucast_pkts_high" descr="The number of packets successfully received, which were not addressed to a multicast or broadcast MAC address.\;" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="if_in_ucast_pkts_low" descr="The number of packets successfully received, which were not addressed to a multicast or broadcast MAC address.\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="if_in_discards_high" descr="The number of inbound packets which were chosen to be discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;\;\;\;\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="if_in_discards_low" descr="The number of inbound packets which were chosen to be discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;\;\;\;\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="if_in_errors_high" descr="The number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol. \;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="if_in_errors_low" descr="The number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol. \;" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="if_in_unknown_protos_high" descr="The number of packets received via the interface which were discarded because of an unknown or unsupported protocol.\;" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="if_in_unknown_protos_low" descr="The number of packets received via the interface which were discarded because of an unknown or unsupported protocol.\;" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="if_out_octets_high" descr="The total number of octets transmitted out of the interface, including framing characters.\;" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="if_out_octets_low" descr="The total number of octets transmitted out of the interface, including framing characters.\;" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="if_out_ucast_pkts_high" descr="The total number of packets that higher-level protocols requested be transmitted and were not addressed to a multicast or broadcast MAC address, including those that were discarded or not sent.\;" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="if_out_ucast_pkts_low" descr="The total number of packets that higher-level protocols requested be transmitted and were not addressed to a multicast or broadcast MAC address, including those that were discarded or not sent.\;" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="if_out_discards_high" descr="The number of outbound packets which were chosen to be discarded, even though no errors had been detected to prevent their being transmitted. \;" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="if_out_discards_low" descr="The number of outbound packets which were chosen to be discarded, even though no errors had been detected to prevent their being transmitted. \;" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="if_out_errors_high" descr="The number of outbound packets that could not be transmitted because of errors.\;" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="if_out_errors_low" descr="The number of outbound packets that could not be transmitted because of errors.\;" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="if_in_multicast_pkts_high" descr="The number of packets successfully received, which were addressed to a multicast MAC address.\;" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="if_in_multicast_pkts_low" descr="The number of packets successfully received, which were addressed to a multicast MAC address.\;" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="if_in_broadcast_pkts_high" descr="The number of packets successfully received, which were addressed to a broadcast MAC address.\;" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="if_in_broadcast_pkts_low" descr="The number of packets successfully received, which were addressed to a broadcast MAC address.\;" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="if_out_multicast_pkts_high" descr="The total number of packets that higher-level protocols requested be transmitted, and which were addressed to a multicast MAC address, including those that were discarded or not sent.\;" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="if_out_multicast_pkts_low" descr="The total number of packets that higher-level protocols requested be transmitted, and which were addressed to a multicast MAC address, including those that were discarded or not sent.\;" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="if_out_broadcast_pkts_high" descr="The total number of packets that higher-level protocols requested be transmitted, and which were addressed to a broadcast MAC address, including those that were discarded or not sent.\;" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="if_out_broadcast_pkts_low" descr="The total number of packets that higher-level protocols requested be transmitted, and which were addressed to a broadcast MAC address, including those that were discarded or not sent.\;" access="RO" offset="0x64.0" size="0x4.0" />
</node>

<node name="eth_3635_cntrs_grp_data_layout_ext" descr="" size="0xf8.0" >
	<field name="dot3stats_alignment_errors_high" descr="A count of frames received that are not an integral number of octets in length and do not pass the FCS check.\;" access="RW" offset="0x0.0" size="0x4.0" />
	<field name="dot3stats_alignment_errors_low" descr="A count of frames received that are not an integral number of octets in length and do not pass the FCS check.\;" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="dot3stats_fcs_errors_high" descr="A count of frames received that are an integral number of octets in length but do not pass the FCS check. This count does not include frames received with frame-too-long or frame-too-short errors.\;" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="dot3stats_fcs_errors_low" descr="A count of frames received that are an integral number of octets in length but do not pass the FCS check. This count does not include frames received with frame-too-long or frame-too-short errors.\;" access="RW" offset="0xC.0" size="0x4.0" />
	<field name="dot3stats_single_collision_frames_high" descr="A count of frames that are involved in a single collision, and are subsequently transmitted successfully.\;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x10.0" size="0x4.0" />
	<field name="dot3stats_single_collision_frames_low" descr="A count of frames that are involved in a single collision, and are subsequently transmitted successfully.\;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x14.0" size="0x4.0" />
	<field name="dot3stats_multiple_collision_frames_high" descr="A count of frames that are involved in more than one collision and are subsequently transmitted successfully. \;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x18.0" size="0x4.0" />
	<field name="dot3stats_multiple_collision_frames_low" descr="A count of frames that are involved in more than one collision and are subsequently transmitted successfully. \;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x1C.0" size="0x4.0" />
	<field name="dot3stats_sqe_test_errors_high" descr="A count of times that the SQE TEST ERROR is received on a particular interface.\;This counter does not increment on interfaces operating at speeds greater than 10 Mb/s, or on interfaces operating in full-duplex mode. \;" access="RW" offset="0x20.0" size="0x4.0" />
	<field name="dot3stats_sqe_test_errors_low" descr="A count of times that the SQE TEST ERROR is received on a particular interface.\;This counter does not increment on interfaces operating at speeds greater than 10 Mb/s, or on interfaces operating in full-duplex mode. \;" access="RW" offset="0x24.0" size="0x4.0" />
	<field name="dot3stats_deferred_transmissions_high" descr="A count of frames for which the first transmission attempt on a particular interface is delayed because the medium is busy. \;This counter does not increment when the interface is operating in full-duplex mode. \;" access="RW" offset="0x28.0" size="0x4.0" />
	<field name="dot3stats_deferred_transmissions_low" descr="A count of frames for which the first transmission attempt on a particular interface is delayed because the medium is busy. \;This counter does not increment when the interface is operating in full-duplex mode. \;" access="RW" offset="0x2C.0" size="0x4.0" />
	<field name="dot3stats_late_collisions_high" descr="The number of times that a collision is detected on a particular interface later than one slotTime into the transmission of a packet.\;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x30.0" size="0x4.0" />
	<field name="dot3stats_late_collisions_low" descr="The number of times that a collision is detected on a particular interface later than one slotTime into the transmission of a packet.\;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x34.0" size="0x4.0" />
	<field name="dot3stats_excessive_collisions_high" descr="A count of frames for which transmission on a particular interface fails due to excessive collisions.\;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x38.0" size="0x4.0" />
	<field name="dot3stats_excessive_collisions_low" descr="A count of frames for which transmission on a particular interface fails due to excessive collisions.\;This counter does not increment when the interface is operating in full-duplex mode.\;" access="RW" offset="0x3C.0" size="0x4.0" />
	<field name="dot3stats_internal_mac_transmit_errors_high" descr="A count of frames for which transmission failed and were discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;" access="RW" offset="0x40.0" size="0x4.0" />
	<field name="dot3stats_internal_mac_transmit_errors_low" descr="A count of frames for which transmission failed and were discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;" access="RW" offset="0x44.0" size="0x4.0" />
	<field name="dot3stats_carrier_sense_errors_high" descr="The number of times that the carrier sense condition was lost or never asserted when attempting to transmit a frame on a particular interface. \;This counter does not increment when the interface is operating in full-duplex mode. \;" access="RW" offset="0x48.0" size="0x4.0" />
	<field name="dot3stats_carrier_sense_errors_low" descr="The number of times that the carrier sense condition was lost or never asserted when attempting to transmit a frame on a particular interface. \;This counter does not increment when the interface is operating in full-duplex mode. \;" access="RW" offset="0x4C.0" size="0x4.0" />
	<field name="dot3stats_frame_too_longs_high" descr="A count of frames received that exceed the maximum permitted frame size.\;" access="RW" offset="0x50.0" size="0x4.0" />
	<field name="dot3stats_frame_too_longs_low" descr="A count of frames received that exceed the maximum permitted frame size.\;" access="RW" offset="0x54.0" size="0x4.0" />
	<field name="dot3stats_internal_mac_receive_errors_high" descr="A count of frames for which reception failed and were discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;" access="RW" offset="0x58.0" size="0x4.0" />
	<field name="dot3stats_internal_mac_receive_errors_low" descr="A count of frames for which reception failed and were discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;" access="RW" offset="0x5C.0" size="0x4.0" />
	<field name="dot3stats_symbol_errors_high" descr="The number of times the receiving media is non-idle (a carrier event) for a period of time equal to or greater than minFrameSize, and during which there was at least one occurrence of an event that causes the PHY to indicate &quot;Receive Error&quot;.\;\;" access="RW" offset="0x60.0" size="0x4.0" />
	<field name="dot3stats_symbol_errors_low" descr="The number of times the receiving media is non-idle (a carrier event) for a period of time equal to or greater than minFrameSize, and during which there was at least one occurrence of an event that causes the PHY to indicate &quot;Receive Error&quot;.\;\;" access="RW" offset="0x64.0" size="0x4.0" />
	<field name="dot3control_in_unknown_opcodes_high" descr="A count of MAC Control frames received that contain an opcode that is not supported.\;" access="RW" offset="0x68.0" size="0x4.0" />
	<field name="dot3control_in_unknown_opcodes_low" descr="A count of MAC Control frames received that contain an opcode that is not supported.\;" access="RW" offset="0x6C.0" size="0x4.0" />
	<field name="dot3in_pause_frames_high" descr="A count of MAC Control frames received with an opcode indicating the PAUSE operation.\;\;" access="RW" offset="0x70.0" size="0x4.0" />
	<field name="dot3in_pause_frames_low" descr="A count of MAC Control frames received with an opcode indicating the PAUSE operation.\;\;" access="RW" offset="0x74.0" size="0x4.0" />
	<field name="dot3out_pause_frames_high" descr="A count of MAC Control frames transmitted with an opcode indicating the PAUSE operation.\;\;" access="RW" offset="0x78.0" size="0x4.0" />
	<field name="dot3out_pause_frames_low" descr="A count of MAC Control frames transmitted with an opcode indicating the PAUSE operation.\;\;" access="RW" offset="0x7C.0" size="0x4.0" />
</node>

<node name="eth_802_3_cntrs_grp_data_layout_ext" descr="" size="0xf8.0" >
	<field name="a_frames_transmitted_ok_high" descr="A count of frames that are successfully transmitted. \;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="a_frames_transmitted_ok_low" descr="A count of frames that are successfully transmitted. \;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="a_frames_received_ok_high" descr="A count of frames that are successfully received. This does not include frames received with frame-too-long, frame check sequence (FCS), length or alignment errors, or frames lost due to other MAC errors.\;\;" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="a_frames_received_ok_low" descr="A count of frames that are successfully received. This does not include frames received with frame-too-long, frame check sequence (FCS), length or alignment errors, or frames lost due to other MAC errors.\;\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="a_frame_check_sequence_errors_high" descr="A count of receive frames that are an integral number of octets in length and do not pass the FCS check. This does not include frames received with frame-too-long, or frame-too-short (frame fragment) errors.\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="a_frame_check_sequence_errors_low" descr="A count of receive frames that are an integral number of octets in length and do not pass the FCS check. This does not include frames received with frame-too-long, or frame-too-short (frame fragment) errors.\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="a_alignment_errors_high" descr="A count of frames that are not an integral number of octets in length and do not pass the FCS check.\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="a_alignment_errors_low" descr="A count of frames that are not an integral number of octets in length and do not pass the FCS check.\;" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="a_octets_transmitted_ok_high" descr="A count of data and padding octets of frames that are successfully transmitted.\;" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="a_octets_transmitted_ok_low" descr="A count of data and padding octets of frames that are successfully transmitted.\;" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="a_octets_received_ok_high" descr="A count of data and padding octets in frames that are successfully received. This does not include octets in frames received with frame-too-long, FCS, length or alignment errors, or frames lost due to other MAC errors.\;" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="a_octets_received_ok_low" descr="A count of data and padding octets in frames that are successfully received. This does not include octets in frames received with frame-too-long, FCS, length or alignment errors, or frames lost due to other MAC errors.\;" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="a_multicast_frames_xmitted_ok_high" descr="A count of frames that are successfully transmitted to a group destination address other than broadcast.\;" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="a_multicast_frames_xmitted_ok_low" descr="A count of frames that are successfully transmitted to a group destination address other than broadcast.\;" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="a_broadcast_frames_xmitted_ok_high" descr="A count of the frames that were successfully transmitted to the broadcast address. Frames transmitted to multicast addresses are not broadcast frames and are excluded.\;" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="a_broadcast_frames_xmitted_ok_low" descr="A count of the frames that were successfully transmitted to the broadcast address. Frames transmitted to multicast addresses are not broadcast frames and are excluded.\;" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="a_multicast_frames_received_ok_high" descr="A count of frames that are successfully received and directed to an active nonbroadcast group address. This does not include frames received with frame-too-long, FCS, length or alignment errors, or frames lost due to internal MAC sublayer error. \;" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="a_multicast_frames_received_ok_low" descr="A count of frames that are successfully received and directed to an active nonbroadcast group address. This does not include frames received with frame-too-long, FCS, length or alignment errors, or frames lost due to internal MAC sublayer error. \;" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="a_broadcast_frames_received_ok_high" descr="A count of the frames that were successfully transmitted to the broadcast address. Frames transmitted to multicast addresses are not broadcast frames and are excluded. \;" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="a_broadcast_frames_received_ok_low" descr="A count of the frames that were successfully transmitted to the broadcast address. Frames transmitted to multicast addresses are not broadcast frames and are excluded. \;" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="a_in_range_length_errors_high" descr="A count of frames with a length/type field value between the minimum unpadded MAC client data size and the maximum allowed MAC client data size, inclusive, that does not match the number of MAC client data octets received. The counter also increments for frames whose length/type field value is less than the minimum allowed unpadded MAC client data size and the number of MAC client data octets received is greater than the minimum unpadded MAC client data size.\;" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="a_in_range_length_errors_low" descr="A count of frames with a length/type field value between the minimum unpadded MAC client data size and the maximum allowed MAC client data size, inclusive, that does not match the number of MAC client data octets received. The counter also increments for frames whose length/type field value is less than the minimum allowed unpadded MAC client data size and the number of MAC client data octets received is greater than the minimum unpadded MAC client data size.\;" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="a_out_of_range_length_field_high" descr="A count of frames with a length field value greater than the maximum allowed LLC data size. \;" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="a_out_of_range_length_field_low" descr="A count of frames with a length field value greater than the maximum allowed LLC data size. \;" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="a_frame_too_long_errors_high" descr="A count of frames received that exceed the maximum permitted frame size by IEEE 802.3 (MTU size).\;" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="a_frame_too_long_errors_low" descr="A count of frames received that exceed the maximum permitted frame size by IEEE 802.3 (MTU size).\;" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="a_symbol_error_during_carrier_high" descr="For full duplex operation at 1000 Mb/s, it is a count of the number of times the receiving media is non-idle (a carrier event) for a period of time equal to or greater than minFrameSize, and during which there was at least one occurrence of an event that causes the PHY to indicate &quot;Data reception error&quot;.\;For operation at 10 Gb/s, 40 Gb/s, and 100 Gb/s, it is a count of the number of times the receiving media is non-idle for a period of time equal to or greater than minFrameSize, and during which there was at least one occurrence of an event that causes the PHY to indicate\;Error.\;" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="a_symbol_error_during_carrier_low" descr="For full duplex operation at 1000 Mb/s, it is a count of the number of times the receiving media is non-idle (a carrier event) for a period of time equal to or greater than minFrameSize, and during which there was at least one occurrence of an event that causes the PHY to indicate &quot;Data reception error&quot;.\;For operation at 10 Gb/s, 40 Gb/s, and 100 Gb/s, it is a count of the number of times the receiving media is non-idle for a period of time equal to or greater than minFrameSize, and during which there was at least one occurrence of an event that causes the PHY to indicate\;Error.\;" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="a_mac_control_frames_transmitted_high" descr="A count of MAC Control frames passed to the MAC sublayer for transmission.\;" access="RO" offset="0x70.0" size="0x4.0" />
	<field name="a_mac_control_frames_transmitted_low" descr="A count of MAC Control frames passed to the MAC sublayer for transmission.\;" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="a_mac_control_frames_received_high" descr="A count of MAC Control frames passed by the MAC sublayer to the MAC Control sublayer.\;" access="RO" offset="0x78.0" size="0x4.0" />
	<field name="a_mac_control_frames_received_low" descr="A count of MAC Control frames passed by the MAC sublayer to the MAC Control sublayer.\;" access="RO" offset="0x7C.0" size="0x4.0" />
	<field name="a_unsupported_opcodes_received_high" descr="A count of MAC Control frames received that contain an opcode that is not supported by the device.\;" access="RO" offset="0x80.0" size="0x4.0" />
	<field name="a_unsupported_opcodes_received_low" descr="A count of MAC Control frames received that contain an opcode that is not supported by the device.\;" access="RO" offset="0x84.0" size="0x4.0" />
	<field name="a_pause_mac_ctrl_frames_received_high" descr="A count of MAC PAUSE frames passed by the MAC sublayer to the MAC Control sublayer.\;" access="RO" offset="0x88.0" size="0x4.0" />
	<field name="a_pause_mac_ctrl_frames_received_low" descr="A count of MAC PAUSE frames passed by the MAC sublayer to the MAC Control sublayer.\;" access="RO" offset="0x8C.0" size="0x4.0" />
	<field name="a_pause_mac_ctrl_frames_transmitted_high" descr="A count of PAUSE frames passed to the MAC sublayer for transmission.\;" access="RO" offset="0x90.0" size="0x4.0" />
	<field name="a_pause_mac_ctrl_frames_transmitted_low" descr="A count of PAUSE frames passed to the MAC sublayer for transmission.\;" access="RO" offset="0x94.0" size="0x4.0" />
</node>

<node name="eth_adjacency_ext" descr="" size="0x18.0" >
	<field name="destination_mac_47_32" descr="MAC address of the destination next-hop." access="RW" offset="0x0.0" size="0x0.16" />
	<field name="destination_mac_31_0" descr="MAC address of the destination next-hop." access="RW" offset="0x4.0" size="0x4.0" />
</node>

<node name="eth_discard_cntrs_grp_ext" descr="" size="0xf8.0" >
	<field name="ingress_general_high" descr="Ingress general \;\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="ingress_general_low" descr="Ingress general \;\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="ingress_policy_engine_high" descr="Ingress policy engine discards" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="ingress_policy_engine_low" descr="Ingress policy engine discards" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="ingress_vlan_membership_high" descr="Ingress VLAN membership filter discards" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="ingress_vlan_membership_low" descr="Ingress VLAN membership filter discards" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="ingress_tag_frame_type_high" descr="Ingress VLAN tag allowance (tagged, untagged and prio-tagged) filter discards" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="ingress_tag_frame_type_low" descr="Ingress VLAN tag allowance (tagged, untagged and prio-tagged) filter discards" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="egress_vlan_membership_high" descr="Egress VLAN membership filter discards" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="egress_vlan_membership_low" descr="Egress VLAN membership filter discards" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="loopback_filter_high" descr="Loop-back filter discards" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="loopback_filter_low" descr="Loop-back filter discards" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="egress_general_high" descr="Egress general discards\;" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="egress_general_low" descr="Egress general discards\;" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="egress_hoq_high" descr="Head-of-Queue time-out discards" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="egress_hoq_low" descr="Head-of-Queue time-out discards" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="port_isolation_high" descr="Port isolation filter discards\;[IInternal] Not supported due to HW bug." access="RO" offset="0x48.0" size="0x4.0" />
	<field name="port_isolation_low" descr="Port isolation filter discards\;[IInternal] Not supported due to HW bug." access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="egress_policy_engine_high" descr="Egress policy engine discards" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="egress_policy_engine_low" descr="Egress policy engine discards" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="ingress_tx_link_down_high" descr="Per ingress port count dropped packets due to egress link down" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="ingress_tx_link_down_low" descr="Per ingress port count dropped packets due to egress link down" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="egress_stp_filter_high" descr="Egress spanning tree filter" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="egress_stp_filter_low" descr="Egress spanning tree filter" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="egress_hoq_stall_high" descr="Number of sequential packets dropped, due to Head-Of-Queue Lifetime Limit, that causes the port to enter the Stall state \;\;Reserved for Switches" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="egress_hoq_stall_low" descr="Number of sequential packets dropped, due to Head-Of-Queue Lifetime Limit, that causes the port to enter the Stall state \;\;Reserved for Switches" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="egress_sll_high" descr="Number of packets dropped, because the Switch Lifetime Limit was exceeded. \;\;Applies for switches only. Reserved for HCAs" access="RO" offset="0x70.0" size="0x4.0" />
	<field name="egress_sll_low" descr="Number of packets dropped, because the Switch Lifetime Limit was exceeded. \;\;Applies for switches only. Reserved for HCAs" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="ingress_discard_all_high" descr="Number of packets dropped for of any reason.\; Note: see description in the description area for limitations of this counter.\;Applies for switches only. Reserved for HCAs\;\;Note: deprecated for all Ethernet devices" access="RO" offset="0x78.0" size="0x4.0" />
	<field name="ingress_discard_all_low" descr="Number of packets dropped for of any reason.\; Note: see description in the description area for limitations of this counter.\;Applies for switches only. Reserved for HCAs\;\;Note: deprecated for all Ethernet devices" access="RO" offset="0x7C.0" size="0x4.0" />
</node>

<node name="eth_extended_cntrs_grp_data_layout_ext" descr="" size="0xf8.0" >
	<field name="port_transmit_wait_high" descr="The time (in 4ns resolution) during which the port selected had data to transmit but no data was sent.\;time = port_transmit_wait*4 [ns]\;\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="port_transmit_wait_low" descr="The time (in 4ns resolution) during which the port selected had data to transmit but no data was sent.\;time = port_transmit_wait*4 [ns]\;\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="ecn_marked_high" descr="A count of packets marked as ECN or potentially marked as ECN.\;ECN Counting enable/disable is configurable. \;Valid only for Spectrum family.\;\;" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="ecn_marked_low" descr="A count of packets marked as ECN or potentially marked as ECN.\;ECN Counting enable/disable is configurable. \;Valid only for Spectrum family.\;\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="no_buffer_discard_mc_high" descr="The number of multicast packets dropped due to lack of egress buffer resources.\;Valid only for Spectrum.\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="no_buffer_discard_mc_low" descr="The number of multicast packets dropped due to lack of egress buffer resources.\;Valid only for Spectrum.\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="rx_ebp_high" descr="The number of received EBP packets.\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="rx_ebp_low" descr="The number of received EBP packets.\;" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="tx_ebp_high" descr="The number of transmitted EBP packets.\;" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="tx_ebp_low" descr="The number of transmitted EBP packets.\;" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="rx_buffer_almost_full_high" descr="The number of events where the port rx buffer has passed a fullness threshold \;\;Reserved for Switches." access="RO" offset="0x28.0" size="0x4.0" />
	<field name="rx_buffer_almost_full_low" descr="The number of events where the port rx buffer has passed a fullness threshold \;\;Reserved for Switches." access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="rx_buffer_full_high" descr="The number of events where the port rx buffer has reached 100% fullness \;\;Reserved for Switches." access="RO" offset="0x30.0" size="0x4.0" />
	<field name="rx_buffer_full_low" descr="The number of events where the port rx buffer has reached 100% fullness \;\;Reserved for Switches." access="RO" offset="0x34.0" size="0x4.0" />
	<field name="rx_icrc_encapsulated_high" descr="The number of roce packets with ICRC error\;\;Reserved for Switches." access="RO" offset="0x38.0" size="0x4.0" />
	<field name="rx_icrc_encapsulated_low" descr="The number of roce packets with ICRC error\;\;Reserved for Switches." access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="tx_stats_pkts64octets_high" descr="The total number of packets (including bad packets) transmitted that were 64 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x50.0" size="0x4.0" />
	<field name="tx_stats_pkts64octets_low" descr="The total number of packets (including bad packets) transmitted that were 64 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x54.0" size="0x4.0" />
	<field name="tx_stats_pkts65to127octets_high" descr="The total number of packets (including bad packets) transmitted that were between 65 and 127 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x58.0" size="0x4.0" />
	<field name="tx_stats_pkts65to127octets_low" descr="The total number of packets (including bad packets) transmitted that were between 65 and 127 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="tx_stats_pkts128to255octets_high" descr="The total number of packets (including bad packets) transmitted that were between 128 and 255 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x60.0" size="0x4.0" />
	<field name="tx_stats_pkts128to255octets_low" descr="The total number of packets (including bad packets) transmitted that were between 128 and 255 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x64.0" size="0x4.0" />
	<field name="tx_stats_pkts256to511octets_high" descr="The total number of packets (including bad packets) transmitted that were between 256 and 511 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x68.0" size="0x4.0" />
	<field name="tx_stats_pkts256to511octets_low" descr="The total number of packets (including bad packets) transmitted that were between 256 and 511 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="tx_stats_pkts512to1023octets_high" descr="The total number of packets (including bad packets) transmitted that were between 512 and 1023 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x70.0" size="0x4.0" />
	<field name="tx_stats_pkts512to1023octets_low" descr="The total number of packets (including bad packets) transmitted that were between 512 and 1023 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x74.0" size="0x4.0" />
	<field name="tx_stats_pkts1024to1518octets_high" descr="The total number of packets (including bad packets) transmitted that were between 1024 and 1518 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x78.0" size="0x4.0" />
	<field name="tx_stats_pkts1024to1518octets_low" descr="The total number of packets (including bad packets) transmitted that were between 1024 and 1518 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x7C.0" size="0x4.0" />
	<field name="tx_stats_pkts1519to2047octets_high" descr="The total number of packets (including bad packets) transmitted that were between 1519 and 2047 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x80.0" size="0x4.0" />
	<field name="tx_stats_pkts1519to2047octets_low" descr="The total number of packets (including bad packets) transmitted that were between 1519 and 2047 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x84.0" size="0x4.0" />
	<field name="tx_stats_pkts2048to4095octets_high" descr="The total number of packets (including bad packets) transmitted that were between 2048 and 4095 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x88.0" size="0x4.0" />
	<field name="tx_stats_pkts2048to4095octets_low" descr="The total number of packets (including bad packets) transmitted that were between 2048 and 4095 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x8C.0" size="0x4.0" />
	<field name="tx_stats_pkts4096to8191octets_high" descr="The total number of packets (including bad packets) transmitted that were between 4096 and 8191 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x90.0" size="0x4.0" />
	<field name="tx_stats_pkts4096to8191octets_low" descr="The total number of packets (including bad packets) transmitted that were between 4096 and 8191 octets in length (excluding framing bits but including FCS octets)." access="RO" offset="0x94.0" size="0x4.0" />
	<field name="tx_stats_pkts8192to10239octets_high" descr="The total number of packets (including bad packets) transmitted that were between 8192 and 10239 octets in length (excluding framing bits but including FCS octets).transmitted\;" access="RO" offset="0x98.0" size="0x4.0" />
	<field name="tx_stats_pkts8192to10239octets_low" descr="The total number of packets (including bad packets) transmitted that were between 8192 and 10239 octets in length (excluding framing bits but including FCS octets).transmitted\;" access="RO" offset="0x9C.0" size="0x4.0" />
	<field name="ece_marked_high" descr="A count of packets marked as ECE or potentially marked as ECE." access="RO" offset="0xA0.0" size="0x4.0" />
	<field name="ece_marked_low" descr="A count of packets marked as ECE or potentially marked as ECE." access="RO" offset="0xA4.0" size="0x4.0" />
	<field name="tx_int_cksm_err_high" descr="Counter is incremented upon packet payload internal checksum error" access="RO" offset="0xA8.0" size="0x4.0" />
	<field name="tx_int_cksm_err_low" descr="Counter is incremented upon packet payload internal checksum error" access="RO" offset="0xAC.0" size="0x4.0" />
</node>

<node name="eth_per_prio_grp_data_layout_ext" descr="" size="0xf8.0" >
	<field name="rx_octets_high" descr="The total number of octets received, including framing characters.\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="rx_octets_low" descr="The total number of octets received, including framing characters.\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="rx_frames_high" descr="The total number of packets received for this priority (not including pause frames).\;" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="rx_frames_low" descr="The total number of packets received for this priority (not including pause frames).\;" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="tx_octets_high" descr="The total number of octets transmitted, including framing characters.\;\;\;" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="tx_octets_low" descr="The total number of octets transmitted, including framing characters.\;\;\;" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="tx_frames_high" descr="The total number of packets transmitted.\;\;\;" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="tx_frames_low" descr="The total number of packets transmitted.\;\;\;" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="rx_pause_high" descr="The total number of PAUSE frames received from the far-end port.\;" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="rx_pause_low" descr="The total number of PAUSE frames received from the far-end port.\;" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="rx_pause_duration_high" descr="The total time in microseconds that transmission of packets to the far-end port have been paused.\;Note that if pause is global then tclass &quot;0&quot; will increment\;\;" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="rx_pause_duration_low" descr="The total time in microseconds that transmission of packets to the far-end port have been paused.\;Note that if pause is global then tclass &quot;0&quot; will increment\;\;" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="tx_pause_high" descr="The total number of PAUSE or PFC frames sent to the far-end port.\;\;\;" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="tx_pause_low" descr="The total number of PAUSE or PFC frames sent to the far-end port.\;\;\;" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="tx_pause_duration_high" descr="The total time in microseconds that the far-end port have been requested to pause.\;\;" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="tx_pause_duration_low" descr="The total time in microseconds that the far-end port have been requested to pause.\;\;" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="rx_pause_transition_high" descr="Counts the number of transitions from Xoff to Xon.\;\;" access="RO" offset="0x70.0" size="0x4.0" />
	<field name="rx_pause_transition_low" descr="Counts the number of transitions from Xoff to Xon.\;\;" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="rx_discards_high" descr="The number of inbound packets which were chosen to be discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;\;\;\;" access="RO" offset="0x78.0" size="0x4.0" />
	<field name="rx_discards_low" descr="The number of inbound packets which were chosen to be discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\;\;\;\;" access="RO" offset="0x7C.0" size="0x4.0" />
	<field name="device_stall_minor_watermark_cnt_high" descr="The number of times the device detected a stalled state for a period longer than device_stall_minor_watermark\;The counter is presented in priority 0, but is a sum of all events on all priorities (including global pause)." access="RO" offset="0x80.0" size="0x4.0" />
	<field name="device_stall_minor_watermark_cnt_low" descr="The number of times the device detected a stalled state for a period longer than device_stall_minor_watermark\;The counter is presented in priority 0, but is a sum of all events on all priorities (including global pause)." access="RO" offset="0x84.0" size="0x4.0" />
	<field name="device_stall_critical_watermark_cnt_high" descr="The number of times the device detected a stalled state for a period longer than device_stall_critical_watermark\;The counter is presented in priority 0, but is a sum of all events on all priorities (including global pause).\;" access="RO" offset="0x88.0" size="0x4.0" />
	<field name="device_stall_critical_watermark_cnt_low" descr="The number of times the device detected a stalled state for a period longer than device_stall_critical_watermark\;The counter is presented in priority 0, but is a sum of all events on all priorities (including global pause).\;" access="RO" offset="0x8C.0" size="0x4.0" />
</node>

<node name="eth_per_traffic_class_cong_layout_ext" descr="" size="0xf8.0" >
	<field name="wred_discard_high" descr="The number of packet that are dropped by the Weighted Random Early Detection (WRED) function.\;For switches - valid only for Spectrum and on\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="wred_discard_low" descr="The number of packet that are dropped by the Weighted Random Early Detection (WRED) function.\;For switches - valid only for Spectrum and on\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="ecn_marked_tc_high" descr="A count of packets marked as ECN or potentially marked as ECN.\;ECN Counting enable/disable is configurable. \;For switches - valid only for Spectrum-3 and on\;\;" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="ecn_marked_tc_low" descr="A count of packets marked as ECN or potentially marked as ECN.\;ECN Counting enable/disable is configurable. \;For switches - valid only for Spectrum-3 and on\;\;" access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="eth_per_traffic_class_layout_ext" descr="" size="0xf8.0" >
	<field name="transmit_queue_high" descr="Contains the transmit queue depth in bytes on traffic class selected by traffic_class of the port selected by local_port.\;\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="transmit_queue_low" descr="Contains the transmit queue depth in bytes on traffic class selected by traffic_class of the port selected by local_port.\;\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="no_buffer_discard_uc_high" descr="The number of unicast packets dropped due to lack of shared buffer resources.\;Valid only for Spectrum.\;Valid for HCA when ppcnt_no_buffer_uc is set in PCAM." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="no_buffer_discard_uc_low" descr="The number of unicast packets dropped due to lack of shared buffer resources.\;Valid only for Spectrum.\;Valid for HCA when ppcnt_no_buffer_uc is set in PCAM." access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="ets_ext" descr="" size="0x8.0" >
	<field name="bw_allocation" descr="For SwitchX/-2:\;The percentage of bandwidth guaranteed to TClass within its TClass Group.\;The sum of bw_allocation value across all TClasses within one group must equal 100.\;" access="RW" offset="0x0.0" size="0x0.7" />
	<field name="group" descr="TClass Group assigned to a TClass.\;Range 0..7\;0x8 value indicates no TClass Group is assigned to the TClass." access="RW" offset="0x0.16" size="0x0.4" />
	<field name="r" descr="Rate limit update. Enables update of the rate limiter (with the max_bw_units, max_bw_value). If this bit is cleared, the rate limiter value will not change." access="WO" offset="0x0.29" size="0x0.1" />
	<field name="b" descr="Bandwidth allocation update. Enables update of the ETS bandwidth allocation (with the bw_allocation). If this bit is cleared, the bandwidth allocation value will not change." access="WO" offset="0x0.30" size="0x0.1" />
	<field name="g" descr="Group update. Enables update of the group assigned to the TClass. If this bit is cleared, the group value will not change." access="WO" offset="0x0.31" size="0x0.1" />
	<field name="max_bw_value" descr="The maximal bandwidth allowed for the use TClass\;Units according to max_bw_units\;Reserved when max_bw_units = 0" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="max_bw_units" descr="Encoding of max_bw_units:\;0x0: DISABLED - rate limiter disabled\;0x3: HUNDREDS_MBPS - max_bw_value is in 100 Mbps units\;0x4: GBPS - max_bw_value is in 1 Gbps units\;Note - Query response returns value in units that allow the most accurate number, not in the units configured using Set()." access="RW" enum="DISABLED=0x0,HUNDREDS_MBPS=0x3,GBPS=0x4" offset="0x4.16" size="0x0.4" />
</node>

<node name="ets_global_ext" descr="" size="0x8.0" >
	<field name="r" descr="Rate limit update. Enables update of the rate limiter (with the max_bw_units, max_bw_value). If this bit is cleared, the rate limiter value will not change." access="WO" offset="0x0.29" size="0x0.1" />
	<field name="max_bw_value" descr="The maximal bandwidth allowed for the use for the port\;Encoding of max_bw_units:\;0x0: DISABLED - rate limiter disabled\;0x3: HUNDREDS_MBPS - max_bw_value is in 100 Mbps units\;0x4: GBPS - max_bw_value is in 1 Gbps units\;Note - Query response will return value in units that allow the most accurate number, not in the units configured using Set()." access="RW" offset="0x4.0" size="0x0.8" />
	<field name="max_bw_units" descr="The maximal bandwidth allowed for the use for the port\;Encoding of max_bw_units:\;0x0: DISABLED - rate limiter disabled\;0x3: HUNDREDS_MBPS - max_bw_value is in 100 Mbps units\;0x4: GBPS - max_bw_value is in 1 Gbps units\;Note - Query response will return value in units that allow the most accurate number, not in the units configured using Set()." access="RW" enum="DISABLED=0x0,HUNDREDS_MBPS=0x3,GBPS=0x4" offset="0x4.16" size="0x0.4" />
</node>

<node name="ext_occu_stat_ext" descr="" size="0x4.0" >
	<field name="ext_buff_occupancy" descr="Extended current buffer occupancy\;Includes also all of the min_buff of the relevant PG buffer or traffic class associated to this pool\;Reserved when Spectrum, supported by Spectrum-2 and on and Quantum.\;" access="RO" offset="0x0.0" size="0x0.24" />
</node>

<node name="fgcr_ext" descr="" size="0x10.0" >
	<field name="flat_sec_offset" descr="Indicates Secondary lines offset in General Purpose SRAM from primary base when using atomic option.\;Relevant both for SRAM0 and SRAM1.\;\;Supported from Spectrum-4 and above." access="RW" offset="0x0.0" size="0x0.8" />
</node>

<node name="flex2_key_18b_ext" descr="" size="0x14.0" >
	<field name="flex_key3_high" descr="Flexible ACL key block as defined in: Section 11.6.4, &quot;Flex2 ACL Key Blocks Detailed&quot;, on page 2654" offset="0x0.0" size="0x0.16" />
	<field name="flex_key2_high" descr="" offset="0x4.0" size="0x0.12" />
	<field name="flex_key3_low" descr="" offset="0x4.12" size="0x0.20" />
	<field name="flex_key1_high" descr="" offset="0x8.0" size="0x0.8" />
	<field name="flex_key2_low" descr="" offset="0x8.8" size="0x0.24" />
	<field name="flex_key0_high" descr="" offset="0xC.0" size="0x0.4" />
	<field name="flex_key1_low" descr="" offset="0xC.4" size="0x0.28" />
	<field name="flex_key0_low" descr="" offset="0x10.0" size="0x4.0" />
</node>

<node name="flex2_key_54b_ext" descr="" size="0x38.0" >
	<field name="flex_key11_high" descr="Flexible ACL key block as defined in: Section 11.6.4, &quot;Flex2 ACL Key Blocks Detailed&quot;, on page 2654" offset="0x0.0" size="0x0.16" />
	<field name="flex_key10_high" descr="" offset="0x4.0" size="0x0.12" />
	<field name="flex_key11_low" descr="" offset="0x4.12" size="0x0.20" />
	<field name="flex_key9_high" descr="" offset="0x8.0" size="0x0.8" />
	<field name="flex_key10_low" descr="" offset="0x8.8" size="0x0.24" />
	<field name="flex_key8_high" descr="" offset="0xC.0" size="0x0.4" />
	<field name="flex_key9_low" descr="" offset="0xC.4" size="0x0.28" />
	<field name="flex_key8_low" descr="" offset="0x10.0" size="0x4.0" />
	<field name="flex_key7_high" descr="" offset="0x14.0" size="0x4.0" />
	<field name="flex_key6_high" descr="" offset="0x18.0" size="0x0.28" />
	<field name="flex_key7_low" descr="" offset="0x18.28" size="0x0.4" />
	<field name="flex_key5_high" descr="" offset="0x1C.0" size="0x0.24" />
	<field name="flex_key6_low" descr="" offset="0x1C.24" size="0x0.8" />
	<field name="flex_key4_high" descr="" offset="0x20.0" size="0x0.20" />
	<field name="flex_key5_low" descr="" offset="0x20.20" size="0x0.12" />
	<field name="flex_key3_high" descr="" offset="0x24.0" size="0x0.16" />
	<field name="flex_key4_low" descr="" offset="0x24.16" size="0x0.16" />
	<field name="flex_key2_high" descr="" offset="0x28.0" size="0x0.12" />
	<field name="flex_key3_low" descr="" offset="0x28.12" size="0x0.20" />
	<field name="flex_key1_high" descr="" offset="0x2C.0" size="0x0.8" />
	<field name="flex_key2_low" descr="" offset="0x2C.8" size="0x0.24" />
	<field name="flex_key0_high" descr="" offset="0x30.0" size="0x0.4" />
	<field name="flex_key1_low" descr="" offset="0x30.4" size="0x0.28" />
	<field name="flex_key0_low" descr="" offset="0x34.0" size="0x4.0" />
</node>

<node name="flexible_action_data_action_auto_ext" descr="" attr_is_union="1" size="0x1c.0" >
	<field name="action_null_ext" descr="" subnode="action_null_ext" offset="0x0.0" size="0x1c.0" />
	<field name="action_mac_ttl_ext" descr="" subnode="action_mac_ttl_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_vlan_ext" descr="" subnode="action_vlan_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_trap_ext" descr="" subnode="action_trap_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_trap_w_userd_ext" descr="" subnode="action_trap_w_userd_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_port_filter_ext" descr="" subnode="action_port_filter_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_port_filter_ext1_ext" descr="" subnode="action_port_filter_ext1_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_port_filter_ext2_ext" descr="" subnode="action_port_filter_ext2_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_qos_ext" descr="" subnode="action_qos_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_forward_ext" descr="" subnode="action_forward_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_policing_counting_ext" descr="" subnode="action_policing_counting_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_counting_cardinality_ext" descr="" subnode="action_counting_cardinality_ext" offset="0x0.0" size="0x18.0" />
	<field name="action_buffer_snap_ext" descr="" subnode="action_buffer_snap_ext" offset="0x0.0" size="0x8.0" />
	<field name="action_metadata_ext" descr="" subnode="action_metadata_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_uc_router_ext" descr="" subnode="action_uc_router_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_mc_router_ext" descr="" subnode="action_mc_router_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_vni_ext" descr="" subnode="action_vni_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_mpls_ext" descr="" subnode="action_mpls_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_hash_ext" descr="" subnode="action_hash_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_virtual_forwarding_ext" descr="" subnode="action_virtual_forwarding_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_ignore_ext" descr="" subnode="action_ignore_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_sip_dip_ext" descr="" subnode="action_sip_dip_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_l4_port_ext" descr="" subnode="action_l4_port_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_mirror_sampler_ext" descr="" subnode="action_mirror_sampler_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_truncation_ext" descr="" subnode="action_truncation_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_flex_modifier_emt_ext" descr="" subnode="action_flex_modifier_emt_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_custom_bytes_alu_imm_ext" descr="" subnode="action_custom_bytes_alu_imm_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_custom_bytes_alu_reg_ext" descr="" subnode="action_custom_bytes_alu_reg_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_custom_bytes_alu_field_ext" descr="" subnode="action_custom_bytes_alu_field_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_custom_bytes_move_ext" descr="" subnode="action_custom_bytes_move_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_fields_set_imm_ext" descr="" subnode="action_fields_set_imm_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_fields_move_ext" descr="" subnode="action_fields_move_ext" offset="0x0.0" size="0x10.0" />
	<field name="action_fs_db_ext" descr="" subnode="action_fs_db_ext" offset="0x0.0" size="0xc.0" />
	<field name="action_flow_estimator_ext" descr="" subnode="action_flow_estimator_ext" offset="0x0.0" size="0x8.0" />
</node>

<node name="flexible_action_data_ext" descr="" size="0x1c.0" >
	<field name="action" descr="Table  2576, &quot;NULL_ACTION Block layout,&quot; on page  2831\;Table  2578, &quot;MAC_TTL_ACTION Block layout,&quot; on page  2832\;Table  2580, &quot;VLAN_ACTION Block layout,&quot; on page  2833\;Table  2582, &quot;TRAP_ACTION Block layout,&quot; on page  2837\;Table  2584, &quot;TRAP_W_USERDEF_ACTION Block layout,&quot; on page  2840\;Table  2586, &quot;PORT_FILTERING_ACTION Block layout,&quot; on page  2843\;Table  2588, &quot;PORT_FILTERING_EXT_ACTION Block layout,&quot; on page  2844\;Table  2590, &quot;PORT_FILTERING_EXT2_ACTION Block layout,&quot; on page  2845\;Table  2592, &quot;QOS_ACTION Block layout,&quot; on page  2847\;Table  2594, &quot;FORWARDING_ACTION Block Layout,&quot; on page  2849\;Table  2600, &quot;POLICING_COUNTING_ACTION Block Layout,&quot; on page  2852\;Table  2602, &quot;POLICING_COUNTING_AND_CARDINALITY_BY_REF ACTION Block Layout,&quot; on page  2854\;Table  2606, &quot;BUFFER_SNAP_ACTION Block Layout,&quot; on page  2857\;Table  2608, &quot;META_DATA_ACTION Block layout,&quot; on page  2858\;Table  2610, &quot;UC_ROUTER_ACTION Block Layout,&quot; on page  2859\;Table  2624, &quot;MC_ROUTING_ACTION Block Layout,&quot; on page  2867\;Table  2626, &quot;VNI VNI_ACTION Block Layout,&quot; on page  2870\;Table  2628, &quot;MPLS_ACTION Block Layout,&quot; on page  2871\;Table  2630, &quot;HASH_ACTION Block Layout,&quot; on page  2873\;Table  2632, &quot;VR_AND_FID_ACTION Block Layout,&quot; on page  2876\;Table  2634, &quot;IGNORE_ACTION Block Layout,&quot; on page  2877\;Table  2636, &quot;SIP_DIP_ACTION Block Layout,&quot; on page  2880\;Table  2638, &quot;L4_PORT_ACTION Block Layout,&quot; on page  2881\;Table  2640, &quot;MIRROR_SAMPLER_ACTION Block Layout,&quot; on page  2882\;Table  2642, &quot;TRUNCATION_ACTION Block Layout,&quot; on page  2883\;Table  2644, &quot;FLEX_MODIFIER_EMT_ACTION Block Layout,&quot; on page  2884\;Table  2648, &quot;CUSTOM_BYTES_ALU_IMM_ACTION Block Layout,&quot; on page  2888\;Table  2650, &quot;CUSTOM_BYTES_ALU_REG_ACTION Block Layout,&quot; on page  2890\;Table  2652, &quot;CUSTOM_BYTES_ALU_FIELD_ACTION Block Layout,&quot; on page  2891\;Table  2654, &quot;CUSTOM_BYTES_MOVE_ACTION Block Layout,&quot; on page  2893\;Table  2656, &quot;FIELDS_SET_IMM_ACTION Block Layout,&quot; on page  2895\;Table  2658, &quot;FIELDS_MOVE_ACTION Block Layout,&quot; on page  2896\;Table  2660, &quot;FS_DB_ACTION Block Layout,&quot; on page  2897\;Table  2662, &quot;FLOW_ESTIMATOR_ACTION Block Layout,&quot; on page  2900\;" subnode="flexible_action_data_action_auto_ext" offset="0x0.0" size="0x1c.0" />
</node>

<node name="flexible_action_set_ext" descr="" size="0xa8.0" >
	<field name="action0_type" descr="Action ID\;For the supported action types refer to Table 2575, &quot;Flexible Action Set: Supported Actions,&quot; on page 2826" offset="0x0.24" size="0x0.6" />
	<field name="action0" descr="Action\;Content is based on the action type defined above.\;See Table 2565, &quot;Flexible Action Set - Action Layout,&quot; on page 2817." subnode="flexible_action_data_ext" offset="0x4.0" size="0x1c.0" />
	<field name="action1_type" descr="Action ID\;For the supported action types refer to Table 2575, &quot;Flexible Action Set: Supported Actions,&quot; on page 2826" offset="0x20.24" size="0x0.6" />
	<field name="action1" descr="Action\;Content is based on the action type defined above.\;An action of size 2 consumes 2 consecutive actions.\;See Table 2565, &quot;Flexible Action Set - Action Layout,&quot; on page 2817." subnode="flexible_action_data_ext" offset="0x24.0" size="0x1c.0" />
	<field name="action2_type" descr="Action ID\;For the supported action types refer to Table 2575, &quot;Flexible Action Set: Supported Actions,&quot; on page 2826" offset="0x40.24" size="0x0.6" />
	<field name="action2" descr="Action\;Content is based on the action type defined above.\;If action0 or action1 had a size of 2 then this entry must be a NULL action.\;See Table 2565, &quot;Flexible Action Set - Action Layout,&quot; on page 2817." subnode="flexible_action_data_ext" offset="0x44.0" size="0x1c.0" />
	<field name="type" descr="0: TYPE_NEXT - pointer Record\;1: TYPE_GOTO - record" enum="TYPE_NEXT=0x0,TYPE_GOTO=0x1" offset="0xA0.28" size="0x0.4" />
	<field name="next_goto_record" descr="Next / Goto\;Encoding is based on type field.\;TYPE_NEXT: Table 2567, &quot;Next action set record layout,&quot; on page 2819\;TYPE_GOTO: Table 2569, &quot;Goto action set record layout,&quot; on page 2820" subnode="flexible_action_set_next_goto_record_auto_ext" offset="0xA4.0" size="0x4.0" union_selector="$(parent).type" />
</node>

<node name="flexible_action_set_next_goto_record_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="next_action_set_record_ext" descr="" subnode="next_action_set_record_ext" offset="0x0.0" selected_by="TYPE_NEXT" size="0x4.0" />
	<field name="goto_action_set_record_ext" descr="" subnode="goto_action_set_record_ext" offset="0x0.0" selected_by="TYPE_GOTO" size="0x4.0" />
</node>

<node name="flexible_key_ext" descr="" size="0x10.0" >
	<field name="key" descr="Encoding of flexible key block, \;For Flexible: see encoding field in Table 2142, &quot;Flexible ACL Key Blocks,&quot; on page 2565\;For Flex2: see encoding field in Table 2265, &quot;Flex2 ACL Key Blocks,&quot; on page 2644\;Number of keys must be up to cap_flexible_keys. \;key&lt;i&gt; for i larger than cap_flexible_keys are reserved\;Invalid keys should be configured as a NULL Key. \;For large keys, Key[11,..6] are msb" access="WO" high_bound="15" low_bound="0" offset="0x0.24" size="0x10.0" />
</node>

<node name="flow_estimator_record_ext" descr="" size="0x8.0" >
	<field name="num_rec" descr="Number of records to read\;Range 1..cap_max_flow_estimator_bins" access="RW" offset="0x0.0" size="0x0.11" />
	<field name="counter_index_base" descr="Counter Index base\;Range 0..cap_shared_counter_pool_size - 1" access="RW" offset="0x4.0" size="0x0.24" />
</node>

<node name="flush_mc_dmac_uc_and_fid_ext" descr="" size="0x8.0" >
	<field name="fid" descr="When ubridge = 0, for router sub-port interface, FID is cap_fid + rif \;Otherwise, valid range is 1..cap_fid-1" access="INDEX" offset="0x4.0" size="0x0.16" />
</node>

<node name="flush_per_fid_ext" descr="" size="0x8.0" >
	<field name="fid" descr="When ubridge = 0, for router sub-port interface, FID is cap_fid + rif \;Otherwise, valid range is 1..cap_fid-1" access="INDEX" offset="0x4.0" size="0x0.16" />
</node>

<node name="flush_per_lag_and_fid_ext" descr="" size="0x8.0" >
	<field name="lag_id" descr="" access="INDEX" offset="0x0.0" size="0x0.10" />
	<field name="fid" descr="" access="INDEX" offset="0x4.0" size="0x0.16" />
</node>

<node name="flush_per_lag_ext" descr="" size="0x8.0" >
	<field name="lag_id" descr="" access="INDEX" offset="0x4.0" size="0x0.10" />
</node>

<node name="flush_per_nve_and_fid_ext" descr="" size="0x8.0" >
	<field name="fid" descr="When ubridge = 0, for router sub-port interface, FID is cap_fid + rif \;Otherwise, valid range is 1..cap_fid-1" access="INDEX" offset="0x4.0" size="0x0.16" />
</node>

<node name="flush_per_port_and_fid_ext" descr="" size="0x8.0" >
	<field name="system_port" descr="" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="fid" descr="" access="INDEX" offset="0x4.0" size="0x0.16" />
</node>

<node name="flush_per_port_ext" descr="" size="0x8.0" >
	<field name="system_port" descr="" access="INDEX" offset="0x4.0" size="0x0.16" />
</node>

<node name="flush_per_tunnel_port_ext" descr="" size="0x8.0" >
	<field name="tport" descr="bit0: NVE\;bit1: VPLS\;bit2: Flex_tunnel0\;bit3: Flex_tunnel1" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="tport_mask" descr="When bit i is set, the tport[i] will be matched, otherwise ignored\;bit0: NVE\;bit1: VPLS\;bit2: Flex_tunnel0\;bit3: Flex_tunnel1" access="INDEX" offset="0x0.16" size="0x0.4" />
</node>

<node name="flush_per_tunnel_port_fid_ext" descr="" size="0x8.0" >
	<field name="tport" descr="bit0: NVE\;bit1: VPLS\;bit2: Flex_tunnel0\;bit3: Flex_tunnel1" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="tport_mask" descr="When bit i is set, the tport[i] will be matched, otherwise ignored\;bit0: NVE\;bit1: VPLS\;bit2: Flex_tunnel0\;bit3: Flex_tunnel1" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="fid" descr="fid" access="INDEX" offset="0x4.0" size="0x0.16" />
</node>

<node name="fmep_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Receive local port\;Reserved when global = 1" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="global" descr="Configure all ports:\;0: per port\;1: global\;When read from global then read from local_port 1\;CPU port is not supported.\;" access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="ext_mod_parsing" descr="Extended parsing for modifier.\;Units of 1B.\;Granularity of 2B.\;Default 0.\;" access="RW" offset="0x4.0" size="0x0.9" />
</node>

<node name="fmtb_bind_info_auto_ext" descr="" attr_is_union="1" size="0x8.0" >
	<field name="emt_binding_info_ext" descr="" subnode="emt_binding_info_ext" offset="0x0.0" selected_by="EMT" size="0x8.0" />
	<field name="ram_binding_info_ext" descr="" subnode="ram_binding_info_ext" offset="0x0.0" selected_by="RAM" size="0x8.0" />
</node>

<node name="fmtb_ext" descr="" size="0x1c.0" >
	<field name="prog_idx" descr="program id" access="INDEX" offset="0x0.0" size="0x0.2" />
	<field name="enable" descr="0: Program is not active \;1: Program is active \;\;Note:\;In order to program to run we need to enable FMTB.enable &amp; FMTPA.e" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="type" descr="0: EMT\;1: RAM" access="RW" enum="EMT=0x0,RAM=0x1" offset="0x10.0" size="0x0.2" />
	<field name="bind_info" descr="See Table 3371, &quot;BINDING INFO layout,&quot; on page 3631\;See Table 3373, &quot;RAM BINDING INFO layout,&quot; on page 3631" subnode="fmtb_bind_info_auto_ext" access="RW" offset="0x14.0" size="0x8.0" union_selector="$(parent).type" />
</node>

<node name="fmtc_ext" descr="" size="0x4c.0" >
	<field name="emt_index" descr="EMT (Egress Modifier Template) index\;Range 0 .. cap_max_emts - 1" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="length_cb_mask" descr="Bit mask on Custom Byte chosen by length_cb\;Note: the mask does not have to have serial 0&quot;s or serial 1&quot;s\;bitmask values:\;0: don&apos;t write to bit\;1: write to bit\;Supported from Spectrum-4 an on" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="length_cb" descr="Custom Byte used for length calculation\;Range 0..2*cap_max_custom_byte_sets_for_hash - 1\;Supported from Spectrum-4 an on\;\;For more info see Table 3329, &quot;Spectrum Custom Bytes Sets,&quot; on page 3572\;" access="RW" offset="0x4.8" size="0x0.8" />
	<field name="length" descr="Length of template (constant add)\;Units of words (word = 2Bytes)\;When EMT used for push/edit: 0..cap_max_emt_size \;When EMT used for pop: 0..cap_max_emt_pop_size - 1" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="length_math_shift" descr="Value for shifting (multiplying/dividing) of Length\;Range 0 .. 7\;Supported from Spectrum-4 an on" access="RW" offset="0x8.16" size="0x0.3" />
	<field name="length_math_shift_left" descr="Length shift left:\;0: shift left (multiply)\;1: shift right (division)\;Supported from Spectrum-4 an on" access="RW" offset="0x8.20" size="0x0.1" />
	<field name="length_math_add_pos" descr="length_math_add adds or subtract:\;0: add length\;1: subtract length\;Applies both to non-bitmap and bitmap modes\;Supported from Spectrum-4 an on" access="RW" offset="0x8.24" size="0x0.1" />
	<field name="length_math_bitmap" descr="Length is bitmap mode:\;0: length packet field holds a value\;1: sum of all set bits in the field\;Supported from Spectrum-4 an on" access="RW" offset="0x8.28" size="0x0.1" />
	<field name="update_ipv4_length" descr="Has effect only when the template is bound as a push/pop template" access="RW" offset="0x10.0" size="0x0.1" />
	<field name="update_ipv6_length" descr="Has effect only when the template is bound as a push/pop template" access="RW" offset="0x10.1" size="0x0.1" />
	<field name="update_hbh_length" descr="Has effect only when the template is bound as a push template" access="RW" offset="0x10.2" size="0x0.1" />
	<field name="update_ipv4_ihl" descr="Update IPv4 length\;Supported from Spectrum-4 an on" access="RW" offset="0x10.3" size="0x0.1" />
	<field name="update_udp_tcp_length" descr="Has effect only when the template is bound as a push template\;" access="RW" offset="0x10.4" size="0x0.1" />
	<field name="update_geneve_length" descr="Has effect only when the template is bound as a push template" access="RW" offset="0x10.8" size="0x0.1" />
	<field name="clear_udp_cs" descr="Clear UDP checksum\;0: UDP checksum not set to 0\;1: UDP checksum set to 0" access="RW" offset="0x14.0" size="0x0.1" />
	<field name="update_udp_tcp_cs" descr="Update UDP or TCP checksum" access="RW" offset="0x14.4" size="0x0.1" />
	<field name="update_ipv4_cs" descr="Update IPv4 checksum\;Supported from Spectrum-4 an on" access="RW" offset="0x14.5" size="0x0.1" />
	<field name="max_latency" descr="Latency is invalid if:\;packet_latency (nSec) &gt; (max_latency * 2^24) or \;packet_latency (nSec) &gt; 4Sec\;Range 1..256\;" access="RW" offset="0x20.0" size="0x0.9" />
	<field name="latency_invalid_value" descr="When latency is invalid the value is latency_invalid_value" access="RW" offset="0x24.0" size="0x4.0" />
	<field name="buffer_fill_level_invalid_value" descr="When buffer_fill_level is invalid the value is buffer_fill_level_invalid_value\;Valid values:\;0xFFFF_FFFF \;Or\;0x7FFF_FFFF \;" access="RW" offset="0x28.0" size="0x4.0" />
	<field name="enc_l2_uirif" descr="IPv4/IPv6 underlay iRIF, used for encap of L2 flex gen_enc. The uSIP is deducted from the uirif.\;* Note: must have same value as configured by TNGEE* \;\;*** Note: all fields FMTC.enc_ are used only for flex tunnel***" access="RW" offset="0x30.0" size="0x0.16" />
	<field name="enc_ipv4_frag_offset" descr="When IPv4 encap: fragment offset" access="RW" offset="0x38.0" size="0x0.13" />
	<field name="enc_ipv4_flag" descr="When IPv4 encap: fragment flags\;" access="RW" offset="0x38.13" size="0x0.3" />
	<field name="enc_ipv4_id" descr="When IPv4 encap: ID" access="RW" offset="0x38.16" size="0x0.16" />
	<field name="enc_next_header" descr="For L2 and for L3 flex gen_enc:\;Next header field (a.k.a. protocol in IPv4" access="RW" offset="0x3C.16" size="0x0.8" />
	<field name="enc_fl_suffix" descr="For L2, L3 Tunnel Encapsulation: Flow Label Suffix\;For Tunnel encapsulation the 8 least significant bits are calculated as follow:\;enc_flh=0: 8 lsb = enc_fl_suffix\;enc_flh=1: 8 lsb = enc_fl_suffix | hash [7:0] (bitwise OR)\;Reserved when enc_flc = 1" access="RW" offset="0x40.0" size="0x0.8" />
	<field name="enc_fl_prefix" descr="For L2, L3 Tunnel Encapsulation: Flow Label Prefix\;For Tunnel encapsulation: Constant 12 most significant bits of the flow label." access="RW" offset="0x40.8" size="0x0.12" />
	<field name="enc_flh" descr="For L2, L3 Tunnel Encapsulation: Flow Label Hash\;For Tunnel encapsulation:\;0: Flow Label is static, by {enc_fl_prefix, enc_fl_suffix}\;1: Flow Label 8 least significant bits are calculated from ECMP hash bitwise OR with enc_fl_suffix, and 12msb are configured by enc_fl_prefix\;See Section 14.15.6, &quot;RECR - Router ECMP Configuration Register&quot;, on page 3252, Section 14.15.7, &quot;RECR_V2 - Router ECMP Configuration Version 2 Register&quot;, on page 3254" access="RW" offset="0x40.24" size="0x0.1" />
	<field name="enc_flc" descr="For L2, L3 Tunnel encapsulation: Flow Label Copy from inner \;0: Calculate flow label using enc_flh.\;1: If packet is IPv6 and encapsulation is IPv6, copy the whole flow label from the packet header. Otherwise, calculate flow label using enc_flh." access="RW" offset="0x40.25" size="0x0.1" />
	<field name="s0_offset" descr="SRAM 0 Offset\;Granularity of SRAM lines\;Range 0 .. (max_cap_gp_sram_size-1)\;Supported from Spectrum-4 and above.\;\;Note:\;1. Can&apos;t be changed if FPMTA was already issued." access="RW" offset="0x44.0" size="0x0.9" />
	<field name="s0_sel_mode" descr="SRAM 0 Selected By Mode\;0: Flat\;\;\;Supported from Spectrum-4 and above." access="RW" offset="0x44.16" size="0x0.3" />
	<field name="s1_offset" descr="SRAM 1 Offset\;Granularity of SRAM lines\;Range 0 .. (max_cap_gp_sram_size-1)\;Supported from Spectrum-4 and above.\;\;Note:\;1. Can&apos;t be changed if FPMTA was already issued." access="RW" offset="0x48.0" size="0x0.9" />
	<field name="s1_sel_mode" descr="SRAM 1 Selected By Mode\;0: Flat\;\;\;Supported from Spectrum-4 and above." access="RW" offset="0x48.16" size="0x0.3" />
</node>

<node name="fmte_ext" descr="" size="0x14.0" >
	<field name="emt_index" descr="EMT (Egress Modifier Template) index\;Range 0 .. cap_max_emts - 1" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="entry_index" descr="Entry index in the EMT\;Range 0 .. cap_max_emt_size - 1\;Note that entry_index&apos;s which are larger than the emt length have no significance" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="cmd_id" descr="Command ID\;See Table 3336, &quot;EMT Commands,&quot; on page 3589\;Reserved when edit_en = 0" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="imm" descr="Immediate\;Reserved when edit_en = 0" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="iim" descr="Immediate is mask:\;0: imm is immediate\;1: imm is bitwise mask\;Has effect only when the template is bound as an edit template." access="RW" offset="0xC.16" size="0x0.1" />
	<field name="edit_en" descr="Edit enable:\;0: Skip this word in the packet\;1: Edit this word in the packet\;Has effect only when the template is bound as an edit template.\;Note that edit_en for words after FMTC.length must be set to &apos;0&apos;" access="RW" offset="0x10.0" size="0x0.1" />
</node>

<node name="fmtm_ext" descr="" size="0x8.0" >
	<field name="emt_index_out" descr="EMT (Egress Modifier Template) index\;Range 0 .. cap_max_emts - 1\;Default 0" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="emt_index_in" descr="EMT (Egress Modifier Template) \;Range 0 .. cap_max_emts - 1\;Note: there is only 1 mapper! The emt_index_in is not an Index\;Default 0" access="RW" offset="0x4.16" size="0x0.8" />
</node>

<node name="fmtpa_ext" descr="" size="0x10.0" >
	<field name="prog_idx" descr="Program index" access="INDEX" offset="0x0.0" size="0x0.2" />
	<field name="lp_msb" descr="Local port [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="bound_emt" descr="EMT associated to this program\;" access="RW" offset="0x4.0" size="0x0.3" />
	<field name="e" descr="Enable\;0: Program is not active (on that port)\;1: Program is active (on that port)\;\;Can be changed on the fly" access="OP" offset="0x4.31" size="0x0.1" />
	<field name="reg0" descr="global register 0" access="RW" offset="0x8.0" size="0x0.16" />
</node>

<node name="fmtpc_ext" descr="" size="0x14.0" >
	<field name="pc" descr="Program counter" access="INDEX" offset="0x0.0" size="0x0.6" />
	<field name="prog_idx" descr="Program index" access="INDEX" offset="0x0.16" size="0x0.2" />
	<field name="op_code" descr="operation code. See Table 3366, &quot;OpCodes and Params,&quot; on page 3626" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="operand0" descr="operand 0. See Table 3366, &quot;OpCodes and Params,&quot; on page 3626" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="operand1" descr="operand 1. See Table 3366, &quot;OpCodes and Params,&quot; on page 3626" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="operand2" descr="operand 2. See Table 3366, &quot;OpCodes and Params,&quot; on page 3626" access="RW" offset="0x10.0" size="0x0.16" />
</node>

<node name="fore_ext" descr="" size="0xc.0" >
	<field name="fan_under_limit" descr="Fan speed is below the low limit defined in MFSL register. Each bit relates to a single tachometer and indicates the specific tachometer reading is below the threshold.\;Bitmask, per bit:\;0: not_under_thr\;1: under_thr" access="RO" offset="0x0.16" size="0x0.10" />
	<field name="fan_under_limit_msb" descr="Fan speed is below the low limit defined in MFSL register. Each bit relates to a single tachometer and indicates the specific tachometer reading is below the threshold.\;Bitmask, per bit:\;0: not_under_thr\;1: under_thr" access="RO" offset="0x0.26" size="0x0.6" />
	<field name="fan_over_limit" descr="Fan speed is above the high limit defined in MFSL register. Each bit relates to a single tachometer and indicates the specific tachometer reading is above the threshold.\;Bitmask, per bit:\;0: not_over_limit\;1: over_limit" access="RO" offset="0x4.16" size="0x0.10" />
	<field name="fan_over_limit_msb" descr="Fan speed is above the high limit defined in MFSL register. Each bit relates to a single tachometer and indicates the specific tachometer reading is above the threshold.\;Bitmask, per bit:\;0: not_over_limit\;1: over_limit" access="RO" offset="0x4.26" size="0x0.6" />
</node>

<node name="fpftt_ext" descr="" size="0x14.0" >
	<field name="entry_index" descr="Entry Index\;Range 0 .. cap_max_flex_transition_table_size -1" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="tran_en" descr="Transition enabled\;default 0" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="cur_ph" descr="Lookup on current parser header \;See ph_id in table Table 3325, &quot;Parser Headers (PH&apos;s),&quot; on page 3554\;Reserved when tran_en = 0\;At least one of cur_ph, next_ph must be of type FPH" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="next_protocol_value" descr="Lookup on next protocol field for the current parser header\;See &quot;next_protocol field&quot; and &quot;next_protocol width (bits)&quot; columns in table Table 3325, &quot;Parser Headers (PH&apos;s),&quot; on page 3554\;The msb after the allowed width (bits) must be &apos;0&apos;\;Reserved when tran_en = 0" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="next_ph" descr="Next parser header\;See ph_id in table Table 3325, &quot;Parser Headers (PH&apos;s),&quot; on page 3554\;Reserved when tran_en = 0" access="RW" offset="0x10.0" size="0x0.8" />
	<field name="next_ph_inner" descr="Next header fields and fields of all subsequent header are inner fields\;Reserved when tran_en = 0\;" access="RW" offset="0x10.16" size="0x0.1" />
</node>

<node name="fphhc_ext" descr="" size="0xc.0" >
	<field name="hph" descr="Hard Parser Header (HPH)\;See Table 3325, &quot;Parser Headers (PH&apos;s),&quot; on page 3554\;Reserved when PHs are &quot;is FPH&quot;" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="my_ftlv_fpp" descr="Flex Parser Program (FPP) which will parse the FTLV of current HPH\;Range 0 .. cap_max_flex_fpp - 1\;Reserved when my_ftlv_outer_en=0 AND my_ftlv_inner_en=0" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="my_ftlv_inner_en" descr="Enable flex tlv from current HPH when inner\;Reserved when PHs are not &quot;can have my_ftlv&quot;\;" access="RW" offset="0x8.30" size="0x0.1" />
	<field name="my_ftlv_outer_en" descr="Enable flex tlv from current HPH when outer\;Reserved when PHs are not &quot;can have my_ftlv&quot;" access="RW" offset="0x8.31" size="0x0.1" />
</node>

<node name="fphtt_ext" descr="" size="0x8.0" >
	<field name="entry_index" descr="Entry Index\;Must be from the Hard Transition Table\;See Table 3327, &quot;Hard Transition Table,&quot; on page 3561" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="tran_en" descr="Transition enabled\;0: Disabled\;1: Enabled\;Defaults are defined in the hard transition table" access="RW" offset="0x4.0" size="0x0.1" />
</node>

<node name="fppc_ext" descr="" size="0x60.0" >
	<field name="fpp" descr="Flex Parser Program (FPP)\;Range 0 .. cap_max_flex_fpp - 1" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="as_ftlv" descr="Flex Parser Header function:\;0: FPH\;1: FTLV\;When FPH: FPH index = fpp. e.g. if fpp = 2 then FPH2" access="RW" offset="0x0.28" size="0x0.1" />
	<field name="empty_fph" descr="FPH is empty\;When empty: \;- header_length value is 0\;- no flex extraction points\;- no my_tlv from this FPH\;- next_protocol may be extracted\;Reserved when as_ftlv = 1" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="protocol" descr="Protocol:\;When as_ftlv = 0: next_protocol\;When as_ftlv = 1: tlv_type\;See Table 3346, &quot;Protocol Union Layout,&quot; on page 3613" subnode="fppc_protocol_union_ext" access="RW" offset="0x10.0" size="0x10.0" />
	<field name="header_length" descr="FPH or FTLV length\;See Table 3348, &quot;Header_length Union Layout,&quot; on page 3614\;Reserved when empty_fph = 1" subnode="fppc_header_length_ext" access="RW" offset="0x20.0" size="0x10.0" />
	<field name="fexp_st" descr="Flexible extraction points from start of header\;See Table 3350, &quot;fexp_st Union Layout,&quot; on page 3616\;Reserved when empty_fph = 1" subnode="fppc_fexp_st_ext" access="RW" offset="0x30.0" size="0x10.0" />
	<field name="fexp_of" descr="Flexible extraction points in an offset in the header\;See Table 3352, &quot;fexp_of Union Layout,&quot; on page 3617\;Reserved when empty_fph = 1\;Not supported in CPU port." subnode="fppc_fexp_of_ext" access="RW" offset="0x40.0" size="0x10.0" />
	<field name="my_tlv" descr="My TLV\;See Table 3354, &quot;My_TLV Union Layout,&quot; on page 3619\;Reserved when as_ftlv = 1\;Reserved when empty_fph = 1" subnode="fppc_my_tlv_ext" access="RW" offset="0x50.0" size="0x10.0" />
</node>

<node name="fppc_fexp_of_ext" descr="" size="0x10.0" >
	<field name="fexp_of_tlv_type" descr="Flex Extraction Point based on offset in the FPH is matched only if tlv type equals to this value\;Reserved when as_tlv = 0 (header)\;Reserved when fexp_of_en = 0" access="RW" offset="0x0.0" size="0x0.24" />
	<field name="fexp_of_id" descr="Flex Extraction Point ID, based on offset in the FPH\;Range 0 .. cap_max_flex_ext_points - 1\;Note: a fexp_id can be used by different FPH only if they are orthogonal protocols (e.g. after IPv4 and after IPv6)\;Reserved when fexp_of_en = 0" access="RW" offset="0x0.24" size="0x0.3" />
	<field name="fexp_of_en" descr="Flex Extraction Point enable - for fexp offset" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="field_offset_bytes_fexp_of" descr="Bytes within the dword\;Range: 0 .. 3" access="RW" offset="0x4.0" size="0x0.2" />
	<field name="field_offset_dword_fexp_of" descr="Offset in cur_ph in order to find the field of fexp_of\;Units of 4B\;Range 0 .. 3\;" access="RW" offset="0x4.8" size="0x0.2" />
	<field name="field_mask_fexp_of" descr="Bit mask\;Note: the mask does not have to have serial 0&quot;s or serial 1&quot;s" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="fexp_of_math_shift" descr="Value for shifting (multiplying/dividing) of Length\;Range 0 .. 7" access="RW" offset="0xC.0" size="0x0.3" />
	<field name="fexp_of_math_shift_left" descr="Length shift left:\;0: shift left (multiply)\;1: shift right (division)" access="RW" offset="0xC.8" size="0x0.1" />
	<field name="fexp_of_math_add" descr="Length constant add\;Range 0 .. 127" access="RW" offset="0xC.16" size="0x0.7" />
	<field name="fexp_of_math_add_pos" descr="length_math_add adds or subtract:\;0: add\;1: subtract\;Applies both to non-bitmap and bitmap modes" access="RW" offset="0xC.24" size="0x0.1" />
	<field name="fexp_of_math_bitmap" descr="Length is bitmap mode:\;0: length packet field holds a value\;1: length packet field is a bitmap" access="RW" offset="0xC.28" size="0x0.1" />
</node>

<node name="fppc_fexp_st_ext" descr="" size="0x10.0" >
	<field name="fexp_st_tlv_type" descr="Flex Extraction Point based on start of FPH is matched only if tlv type equals to this value\;Reserved when as_ftlv = 0 (header)\;Reserved when fexp_st_en = 0" access="RW" offset="0x0.0" size="0x0.24" />
	<field name="fexp_st_id" descr="Flex Extraction Point ID, based on start of FPH\;Range 0 .. cap_max_flex_ext_points - 1\;Note: a fexp_id can be used by different FPH only if they are orthogonal protocols (e.g. after IPv4 and after IPv6)\;Reserved when fexp_st_en = 0" access="RW" offset="0x0.24" size="0x0.3" />
	<field name="fexp_st_en" descr="Flex Extraction Point enable - for fexp start\;This flex extraction point is always from the start of the FPH" access="RW" offset="0x0.31" size="0x0.1" />
</node>

<node name="fppc_header_length_ext" descr="" size="0x10.0" >
	<field name="field_offset_bytes_length" descr="Bytes within the dword\;Range: 0 .. 3" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="field_offset_dword_length" descr="Offset in cur_ph in order to find the field of length\;Units of 4B\;Range 0 .. 3\;" access="RW" offset="0x0.8" size="0x0.2" />
	<field name="field_mask_length" descr="Bit mask\;Note: the mask does not have to have serial 0&quot;s or serial 1&quot;s" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="length_math_shift" descr="Value for shifting (multiplying/dividing) of Length\;Range 0 .. 7" access="RW" offset="0x8.0" size="0x0.3" />
	<field name="length_math_shift_left" descr="Length shift left:\;0: shift left (multiply)\;1: shift right (division)" access="RW" offset="0x8.8" size="0x0.1" />
	<field name="length_math_add" descr="Length constant add\;Range 0 .. 127" access="RW" offset="0x8.16" size="0x0.7" />
	<field name="length_math_add_pos" descr="length_math_add adds or subtract:\;0: add\;1: subtract\;Applies both to non-bitmap and bitmap modes" access="RW" offset="0x8.24" size="0x0.1" />
	<field name="length_math_bitmap" descr="Length is bitmap mode:\;0: length packet field holds a value\;1: length packet field is a bitmap" access="RW" offset="0x8.28" size="0x0.1" />
</node>

<node name="fppc_my_tlv_ext" descr="" size="0x10.0" >
	<field name="my_ftlv_fpp" descr="Flex Parser Program (FPP) which will parse the FTLV of current PH\;Range 0 .. cap_max_flex_fpp - 1\;Reserved when my_ftlv_en = 0" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="my_ftlv_start" descr="Start of FTLV\;Units of 4B\;Must be greater than 0\;Reserved when my_ftlv_en = 0" access="RW" offset="0x0.16" size="0x0.6" />
	<field name="my_ftlv_en" descr="Enable tlv from current FPH" access="RW" offset="0x0.31" size="0x0.1" />
</node>

<node name="fppc_protocol_union_ext" descr="" size="0x10.0" >
	<field name="field_offset_bytes_prot" descr="Bytes within the dword\;Range: 0 .. 2\;Note: when as_ftlv=1 then Range is 0..1\;" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="field_offset_dword_prot" descr="Offset in cur_ph in order to find the field of next_ph or tlv_type\;Units of 4B\;Range 0 .. 3\;Reserved when empty_fph = 1 (allows extracting on first 4B after the empty header)\;" access="RW" offset="0x0.8" size="0x0.2" />
	<field name="field_mask_prot_non_tlv" descr="Bit mask\;Note: the mask does not have to have serial 0&quot;s or serial 1&quot;s\;The bit mask must not jump to next dword, If next dword then relevant mask bits must be 0.\;Reserved when as_ftlv=1\;" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="field_mask_prot_tlv" descr="Bit mask\;Note: the mask does not have to have serial 0&quot;s or serial 1&quot;s\;The bit mask must not jump to next dword, If next dword then relevant mask bits must be 0.\;Reserved when as_ftlv=0" access="RW" offset="0x8.0" size="0x0.24" />
</node>

<node name="fpts_ext" descr="" size="0xc.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Receive local port\;Reserved when global = 1\;CPU port not supported.\;" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="global" descr="Configure all ports:\;0: per port\;1: global\;When read from global then read from local_port 1\;" access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="tran_type" descr="Transition type:\;0: Start parsing MAC- default\;1: Start parsing Flex" access="RW" offset="0x4.0" size="0x0.4" />
	<field name="next_ph" descr="Next parser header, must be FPH\;See ph_id in table Table 3325, &quot;Parser Headers (PH&apos;s),&quot; on page 3554\;Reserved when tran_type = 0" access="RW" offset="0x8.0" size="0x0.8" />
</node>

<node name="fpums_ext" descr="" size="0x14.0" >
	<field name="bitmap_size" descr="Bitmap size in DWORDs.\;Range is 16..255.\;Value 0 is reserved for 512 port bitmap for backwards-compatibility.\;E.g. bitmap_size 16 is for 512 ports, 17 for 544 ports, 32 for 1024 ports, etc." access="OP" offset="0x0.0" size="0x0.8" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Ingress local port\;Supported also from CPU port\;Reserved when global != 0" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="global" descr="Global:\;0: PER_PORT - per port, local_port is used\;1: ALL_PORTS - global for all ports. When get, read from local_port 1\;2: PORT_MASK - port_mask is used when set. When get, read from local_port 1" access="INDEX" enum="PER_PORT=0x0,ALL_PORTS=0x1,PORT_MASK=0x2" offset="0x0.28" size="0x0.2" />
	<field name="mask" descr="Mask, which bits to set at write:\;0: the relevant bit will not be set\;1: the relevant bit will be set\;Reserved when read\;" access="OP" offset="0x8.0" size="0x0.8" />
	<field name="port_user_mem" descr="Port User Memory" access="RW" offset="0xC.0" size="0x0.8" />
	<field name="port_mask" descr="Port mask array, read as one bitmap.\;Bitmap of local_port to set\;per bit:\;0: don&apos;t set\;1: set\;Reserved when global != 2\;Reserved when get" access="RW" arr_is_dynamic="1" high_bound="VARIABLE" low_bound="0" offset="0x10.0" size="0x4.0" size_condition="$(parent).bitmap_size" />
</node>

<node name="frar_ext" descr="" size="0x110.0" >
	<field name="entries_count" descr="Defines how many entries\;Range 1 .. 16" access="OP" offset="0x0.0" size="0x0.9" />
	<field name="sram_info" descr="See Table 3415, &quot;FRAR - Flex RAM Info Layout,&quot; on page 3665" subnode="frar_info_ext" access="RW" high_bound="15" low_bound="0" offset="0x10.0" size="0x100.0" />
</node>

<node name="frar_info_ext" descr="" size="0x10.0" >
	<field name="sram_id" descr="0: SRAM 0\;1: SRAM 1\;2-3: Reserved" access="INDEX" offset="0x0.0" size="0x0.2" />
	<field name="sram_base_offset" descr="SRAM Base Offset" access="INDEX" offset="0x0.8" size="0x0.9" />
	<field name="bitmask" descr="bitmask \;bit 0: don&apos;t write to word\;bit 1: write word\;Granularity of 2B (word) per bit" access="OP" offset="0x4.0" size="0x0.4" />
	<field name="data" descr="Data to store to SRAM" access="RW" high_bound="3" low_bound="0" offset="0x8.16" size="0x8.0" />
</node>

<node name="fsdc_ext" descr="" size="0x10.0" >
	<field name="filter_fields" descr="filter fields:\;If a bit is &apos;0&apos; then the relevant field is ignored and dump is\;done regardless of the field value\;\;0: partition id\;1: activity\;2: semaphore state\;3: group id\;\;All set filters are relevant (there is AND between the filters)" access="OP" offset="0x0.0" size="0x0.4" />
	<field name="sif" descr="Stop if found\;0: Count all entries \;1: Stop counting when found at least one entry" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="entry_partition_id" descr="Count only if entry partition has value of entry_parition\;Reserved when filter_fields bit0 is &apos;0&apos;" access="INDEX" offset="0x4.0" size="0x0.3" />
	<field name="entry_activity" descr="Count only if activity has value of entry_activity\;Reserved when filter_fields bit1 is &apos;0&apos;" access="INDEX" offset="0x4.8" size="0x0.1" />
	<field name="entry_sem_s" descr="Count only if semaphore state has value of entry_sem_s\;Reserved when filter_fields bit2 is &apos;0&apos;" access="INDEX" offset="0x4.9" size="0x0.1" />
	<field name="group_id" descr="Count only if Group id equals to the value mentioned\;Reserved when filter_fields bit3 is &apos;0&apos;" access="INDEX" offset="0x4.16" size="0x0.16" />
	<field name="num_entries" descr="Number of stateful DB entries\;Note: The returned value is the number of DB entries. \;" access="RO" offset="0x8.0" size="0x0.20" />
</node>

<node name="fsed_ext" descr="" size="0x590.0" >
	<field name="num_pages" descr="Number of pages dumped\;Range for response is 0..14" access="RO" offset="0x0.16" size="0x0.9" />
	<field name="num_of_entries" descr="Total number of entries.\;Range 0 - 28" access="RO" offset="0x4.16" size="0x0.10" />
	<field name="sf_dump_page" descr="dumped entries list\;See Table 3402, &quot;SF Page Dump Mode Fields,&quot; on page 3657" subnode="fsed_page_dump_mode_ext" access="RO" high_bound="15" low_bound="0" offset="0x10.0" size="0x580.0" />
</node>

<node name="fsed_page_dump_mode_dump_page_auto_ext" descr="" attr_is_union="1" size="0x50.0" >
	<field name="SF_PAGE_DUMP_MODE_0_ext" descr="" subnode="SF_PAGE_DUMP_MODE_0_ext" offset="0x0.0" selected_by="mode_0" size="0x50.0" />
	<field name="SF_PAGE_DUMP_MODE_1_ext" descr="" subnode="SF_PAGE_DUMP_MODE_1_ext" offset="0x0.0" selected_by="mode_1" size="0x50.0" />
</node>

<node name="fsed_page_dump_mode_ext" descr="" size="0x58.0" >
	<field name="mode" descr="0: mode_0 - 54B\;1: mode_1 - 9B/18B" access="RO" enum="mode_0=0x0,mode_1=0x1" offset="0x0.0" size="0x0.1" />
	<field name="dump_page" descr="dumped entries list\;See Table 3403, &quot;SF Page Dump Mode 0 Layout,&quot; on page 3658\;See Table 3405, &quot;SF Page Dump Mode 1 Layout,&quot; on page 3660" subnode="fsed_page_dump_mode_dump_page_auto_ext" offset="0x8.0" size="0x50.0" union_selector="$(parent).mode" />
</node>

<node name="fspt_ext" descr="" size="0x44.0" >
	<field name="set_partitions_bitmap" descr="bitmap per each partition index\;0: ignore configuration for partition\;1: set the partition relevant threshold" access="OP" offset="0x0.0" size="0x0.8" />
	<field name="warning_th_partition" descr="warning threshold for db partition &lt;i&gt;.\;partition &lt;i&gt; reserved when set_partitions_bitmap.bit&lt;i&gt; is not set.\;See Table 3389, &quot;FSPT - Threshold Layout,&quot; on page 3650" subnode="fspt_threshold_ext" access="RW" high_bound="7" low_bound="0" offset="0x4.0" size="0x20.0" />
	<field name="max_th_partition" descr="max threshold for db partition &lt;i&gt;.\;partition &lt;i&gt; reserved when set_partitions_bitmap.bit&lt;i&gt; is not set.\;See Table 3389, &quot;FSPT - Threshold Layout,&quot; on page 3650" subnode="fspt_threshold_ext" access="RW" high_bound="7" low_bound="0" offset="0x24.0" size="0x20.0" />
</node>

<node name="fspt_threshold_ext" descr="" size="0x4.0" >
	<field name="threshold" descr="Threshold value" access="RW" offset="0x0.0" size="0x0.19" />
</node>

<node name="fstm_port_ticket_info_ext" descr="" size="0x4.0" >
	<field name="lport" descr="local port number \;Not supported for CPU port" access="WO" offset="0x0.0" size="0x0.10" />
	<field name="ticket_machine_en" descr="0: ticket_machine_is_disabled \;1: ticket_machine_is_enabled \;\;Note-\;- When port has ticket machine enabled, a dedicated custom byte is allocated to store ticket info. Use FSGCR.ticket_cb_index to define which cb should be used.\;- Ticket machine enable/disable can&apos;t be changed on the fly during traffic\;\;" access="RW" enum="ticket_machine_is_disabled=0x0,ticket_machine_is_enabled=0x1" offset="0x0.15" size="0x0.1" />
</node>

<node name="goto_action_set_record_ext" descr="" size="0x4.0" >
	<field name="next_binding" descr="SwitchX/-2: acl/group id to bind\;Spectrum/-2: group_id\;Reserved when: NONE, BREAK and TERMINATE" offset="0x0.0" size="0x0.16" />
	<field name="binding_cmd" descr="0: NONE - continue as usual\;1: JUMP - jump to the next binding point no return. Does not change state of inner or outer loop.\; \;2: CALL - call the next binding point and return to the current list\;Valid when at outer loop \;3: BREAK - break exit from the current loop. If in outer loop then exit from the binding loop/list. If in the inner loop/list then exit to the outer \;4: TERMINATE - terminate the acl binding" offset="0x0.24" size="0x0.3" />
	<field name="g" descr="Group\;0: bind an ACL\;1: bind an ACL group\;Must be set for Spectrum/-2" offset="0x0.29" size="0x0.1" />
	<field name="clear_actions_stack" descr="clear the action stack. Need to be cleared at the end of every binding section in case there is no commit" offset="0x0.30" size="0x0.1" />
	<field name="commit" descr="commit all the defer action up to this point and clear the action set. clear_actions_stack is not recommended during this operation since it will clear the action stack before the commit\;See Table 2562, &quot;ACL Commit Clear action set order of operation,&quot; on page 2814" offset="0x0.31" size="0x0.1" />
</node>

<node name="hcap_ext" descr="" size="0x14.0" >
	<field name="max_cpu_ingress_tclass" descr="Maximum number of CPU ingress traffic classes supported" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="max_num_trap_groups" descr="Maximum number of trap groups supported" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="max_num_dr_paths" descr="Maximum number of direct route (DR) paths in the DR Path table." access="RO" offset="0x10.0" size="0x0.4" />
</node>

<node name="hccr_ext" descr="" size="0x4.0" >
	<field name="use_nve_opt_chk" descr="Use DISCARD_DEC_NVE_OPTIONS check.\;0: the check DISCARD_DEC_NVE_OPTIONS will be part of DISCARD_DEC_PKT\;1: the check DISCARD_DEC_NVE_OPTIONS will be assign to trap_id 193h\;" access="RW" offset="0x0.0" size="0x0.1" />
</node>

<node name="hcot_ext" descr="" size="0x30.0" >
	<field name="trap_id" descr="Trap_id\;Allowed trap_id&apos;s:\;240h..243h: CONFT_SWITCH_0..3\;250h..253h: CONFT_ROUTER_0..3\;260h..263h: CONFT_SWITCH_ENC_0..3\;270h..273h: CONFT_SWITCH_DEC_0..3 // overlay switch" access="INDEX" offset="0x0.0" size="0x0.10" />
	<field name="key_type" descr="Key types:\;0: ethertype\;1: next_proto\;2: layer4_port\;3: icmp_igmp_type" access="RW" enum="ethertype=0x0,next_proto=0x1,layer4_port=0x2,icmp_igmp_type=0x3" offset="0x4.0" size="0x0.8" />
	<field name="key" descr="Used bits according to key_type.\;E.g. when key_type=0 then only 16 lsb are used\;if key_type=0 then the key is explained in Table 328, &quot;HCOT Key_type Ethertype Layout,&quot; on page 662\;if key_type=1 then the key is explained in Table 330, &quot;HCOT Key_type Next_proto Layout,&quot; on page 663\;if key_type=2 then the key is explained in Table 332, &quot;HCOT Key_type layer4_port Layout,&quot; on page 664\;if key_type=3 then the key is explained in Table 334, &quot;HCOT Key_type Icmp_Igmp_Type Layout,&quot; on page 665\;" subnode="hcot_key_auto_ext" access="RW" offset="0x10.0" size="0x10.0" union_selector="$(parent).key_type" />
	<field name="mask" descr="Note: all fields must have a mask with the same value for the whole field. Example etherype field which is 16bits must have all 16bits with same mask value\;if key_type=0 then the mask is explained in Table 328, &quot;HCOT Key_type Ethertype Layout,&quot; on page 662\;if key_type=1 then the mask is explained in Table 330, &quot;HCOT Key_type Next_proto Layout,&quot; on page 663\;if key_type=2 then the mask is explained in Table 332, &quot;HCOT Key_type layer4_port Layout,&quot; on page 664\;if key_type=3 then the mask is explained in Table 334, &quot;HCOT Key_type Icmp_Igmp_Type Layout,&quot; on page 665" subnode="hcot_mask_auto_ext" access="RW" offset="0x20.0" size="0x10.0" union_selector="$(parent).key_type" />
</node>

<node name="hcot_key_auto_ext" descr="" attr_is_union="1" size="0x10.0" >
	<field name="hcot_key_ethernet_ext" descr="" subnode="hcot_key_ethernet_ext" offset="0x0.0" selected_by="ethertype" size="0x10.0" />
	<field name="hcot_key_next_proto_ext" descr="" subnode="hcot_key_next_proto_ext" offset="0x0.0" selected_by="next_proto" size="0x10.0" />
	<field name="hcot_key_layer4_port_ext" descr="" subnode="hcot_key_layer4_port_ext" offset="0x0.0" selected_by="layer4_port" size="0x10.0" />
	<field name="hcot_key_icmp_igmp_type_ext" descr="" subnode="hcot_key_icmp_igmp_type_ext" offset="0x0.0" selected_by="icmp_igmp_type" size="0x10.0" />
</node>

<node name="hcot_key_ethernet_ext" descr="" size="0x10.0" >
	<field name="ethertype" descr="The first Ethertype that doesn&quot;t point to either:\;VLAN, CNTAG or configurable Ethertype" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="tunnel_port" descr="Tunnel port:\;1: NVE\;2: VPLS\;4: Flex_tunnel0\;8: Flex_tunnel1\;\;This field cannot be masked\;Reserved when trap_id is not CONFT_SWITCH_ENC_0..3" access="RW" offset="0x4.0" size="0x0.4" />
</node>

<node name="hcot_key_icmp_igmp_type_ext" descr="" size="0x10.0" >
	<field name="min" descr="Minimum range for packet type field\;Must not be masked" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="max" descr="Maximum range for packet type field\;Must not be masked" access="RW" offset="0x0.8" size="0x0.8" />
	<field name="is_ipv4" descr="0: Packet is IPv6\;1: Packet is IPv4" access="RW" offset="0x0.16" size="0x0.1" />
	<field name="is_igmp" descr="0: Packet is ICMP\;1: Packet is IGMP. Reserved when is_ipv4=0" access="RW" offset="0x0.17" size="0x0.1" />
	<field name="tunnel_port" descr="Tunnel port:\;1: NVE\;2: VPLS\;4: Flex_tunnel0\;8: Flex_tunnel1\;\;\;This field cannot be masked\;Reserved when trap_id is not CONFT_SWITCH_ENC_0..3" access="RW" offset="0x4.0" size="0x0.4" />
</node>

<node name="hcot_key_layer4_port_ext" descr="" size="0x10.0" >
	<field name="l4_port" descr="When UDP: destination port \;When TCP: match on destination port or on source port" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="is_ipv4" descr="0: Packet is IPv6\;1: Packet is IPv4" access="RW" offset="0x0.16" size="0x0.1" />
	<field name="is_udp" descr="0: Packet is TCP\;1: Packet is UDP" access="RW" offset="0x0.17" size="0x0.1" />
	<field name="tunnel_port" descr="Tunnel port:\;1: NVE\;2: VPLS\;4: Flex_tunnel0\;8: Flex_tunnel1\;\;\;This field cannot be masked\;Reserved when trap_id is not CONFT_SWITCH_ENC_0..3" access="RW" offset="0x4.0" size="0x0.4" />
</node>

<node name="hcot_key_next_proto_ext" descr="" size="0x10.0" >
	<field name="ip_proto" descr="For IPv4: next_ protocol\;For IPv6: next header" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="is_ipv4" descr="0: Packet is IPv6\;1: Packet is IPv4" access="RW" offset="0x0.16" size="0x0.1" />
	<field name="tunnel_port" descr="Tunnel port:\;1: NVE\;2: VPLS\;4: Flex_tunnel0\;8: Flex_tunnel1\;\;\;This field cannot be masked\;Reserved when trap_id is not CONFT_SWITCH_ENC_0..3" access="RW" offset="0x4.0" size="0x0.4" />
</node>

<node name="hcot_mask_auto_ext" descr="" attr_is_union="1" size="0x10.0" >
	<field name="hcot_key_ethernet_ext" descr="" subnode="hcot_key_ethernet_ext" offset="0x0.0" selected_by="ethertype" size="0x10.0" />
	<field name="hcot_key_next_proto_ext" descr="" subnode="hcot_key_next_proto_ext" offset="0x0.0" selected_by="next_proto" size="0x10.0" />
	<field name="hcot_key_layer4_port_ext" descr="" subnode="hcot_key_layer4_port_ext" offset="0x0.0" selected_by="layer4_port" size="0x10.0" />
	<field name="hcot_key_icmp_igmp_type_ext" descr="" subnode="hcot_key_icmp_igmp_type_ext" offset="0x0.0" selected_by="icmp_igmp_type" size="0x10.0" />
</node>

<node name="hcpnc_ext" descr="" size="0x20.0" >
	<field name="cnt_type" descr="Counter Type:\;0: Ingress CPU port to network (from host to network)\;1: TAC to network (Spectrum-4 only)" access="INDEX" offset="0x0.0" size="0x0.5" />
	<field name="clr" descr="Clear counters.\;If this field is set, the counter will be cleared after read." access="OP" offset="0x0.31" size="0x0.1" />
	<field name="pkt_ok_cnt" descr="Packet Ok Counter.\;Counts the number of packet transmitted to network." subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
	<field name="byte_ok_cnt" descr="Byte Ok Counter.\;Counts the number of Bytes transmitted to network." subnode="uint64" access="RO" offset="0x10.0" size="0x8.0" />
	<field name="pkt_discard_cnt" descr="Packet Discard Counter.\;Counts the number of discard packets due to TBD" subnode="uint64" access="RO" offset="0x18.0" size="0x8.0" />
</node>

<node name="hctr_ext" descr="" size="0x10.0" >
	<field name="custom_trap_index" descr="Custom Trap:\;0: IP2ME_CUSTOM0\;1: IP2ME_CUSTOM1\;2: IP2ME_CUSTOM2, reserved when Spectrum\;3: IP2ME_CUSTOM3, reserved when Spectrum" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="udp_dport" descr="Extraction point is udp dport" access="RW" offset="0x4.1" size="0x0.1" />
	<field name="tcp_sport" descr="Extraction point is tcp sport" access="RW" offset="0x4.2" size="0x0.1" />
	<field name="tcp_dport" descr="Extraction point is tcp dport" access="RW" offset="0x4.3" size="0x0.1" />
	<field name="range_min" descr="Minimum range" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="range_max" descr="Maximum range" access="RW" offset="0xC.0" size="0x0.16" />
</node>

<node name="hett_ext" descr="" size="0x14.0" >
	<field name="status" descr="Status:\;0: IDLE\;1: BUSY" access="RO" enum="IDLE=0x0,BUSY=0x1" offset="0x0.0" size="0x0.2" />
	<field name="opcode" descr="Opcode\;0: START - start a session. Rejected when status = BUSY\;1: CANCEL - cancel the session" access="WO" enum="START=0x0,CANCEL=0x1" offset="0x0.8" size="0x0.1" />
	<field name="trap_group_bitmap" descr="Trap group bitmap.\;The device will send HETT_TRAP to each of the trap groups that are set (per bit)" subnode="uint64" access="INDEX" offset="0x8.0" size="0x8.0" />
	<field name="trap_group" descr="Trap group\;Used for the HETT_TRAP.\;Range is 0 .. cap_max_num_trap_groups - 1\;Reserved when not a trap." access="RO" offset="0x10.0" size="0x0.8" />
</node>

<node name="hgcr_ext" descr="" size="0x1c.0" >
	<field name="truncation_size" descr="Truncation Size.\;For packets of trap_ids where HPKT.tr_en=1\;Sets the packet size after truncation (when truncation is enabled). \;Unit is 1 byte.\;Default is 16K-1 (no truncation)\;For Switch-IB 2: Granularity is 32B.\;For Spectrum-2/3/4: Granularity is 4B.\;Reserved when Switch-IB and Spectrum (no truncation).\;For Switch-IB 2: minimum value is 32B\;For Quantum and Spectrum-2/3/4: minimum value is 48B.\;" access="RW" offset="0x0.0" size="0x0.14" />
	<field name="regtlve" descr="REG_TLV Extended Length support for event traps\;0: do not use REG_TLV.elen field (support up to 8KB registers)\;1: use REG_TLV.elen field (allow registers to be bigger than 8KB)\;" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="truncation_size_prof1" descr="Truncation Size Profile 1\;Supported from Spectrum-4 and Quantum-2 and above.\;See truncation_size for limitations.\;When 0 (reserved) treated as 16K-1." access="RW" offset="0x10.0" size="0x0.14" />
	<field name="truncation_size_prof2" descr="Truncation Size Profile 2\;Supported from Spectrum-4 and Quantum-2 and above.\;See truncation_size for limitations.\;When 0 (reserved) treated as 16K-1." access="RW" offset="0x14.0" size="0x0.14" />
	<field name="tac_crawler_action" descr="Supported from Spectrum-4 and above. Reserved when IB Switches.\;\;Crawler actions:\;0: flush_and_report - default\;1: flush_no_report\;2: report_only - may cause pkt_count overflow, note: no LRU eviction" access="RW" enum="flush_and_report=0x0,flush_no_report=0x1,report_only=0x2" offset="0x18.0" size="0x0.2" />
	<field name="tac_crawler_timer" descr="Every T the crawler will flush and/or report\;T = 2^tac_crawler_timer mSec\;Range: 0..13  // up to 8Sec since HW TAC can hold pkt_count up to 16Sec\;Value of 31 will stop the crawler\;Default: 31\;Supported from Spectrum-4 and above.\;Reserved when IB Switches" access="RW" offset="0x18.8" size="0x0.5" />
	<field name="tac_mirror_action" descr="TAC Mirror Action\;0: TAC_TO_CPU\;2: TAC_TO_MIRROR - to mirroring agent only\;" access="RW" enum="TAC_TO_CPU=0x0,TAC_TO_MIRROR=0x2" offset="0x18.16" size="0x0.2" />
	<field name="tac_ver" descr="[DWIP]\;TAC version.\;Note: Changing the version doesn&apos;t affect TAC&apos;s structures.\;\;Default value:\;Spectrum-4: 0x0\;Spectrum-5: 0x1\;\;Only for Spectrum-4 and above, reserved for the rest." access="RW" offset="0x18.24" size="0x0.4" />
</node>

<node name="hmcb_ext" descr="" size="0x10.0" >
	<field name="mc_index" descr="Index to the start point in the database where there are pointers to multicast identifiers.\;For Spectrum: index to KVD Central Database, see Appendix A.4.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3813)" access="RW" offset="0x4.0" size="0x0.24" />
</node>

<node name="hmon_ext" descr="" size="0x220.0" >
	<field name="crdq" descr="Clear RDQ\;Range 0.. cap_max_num_rdq - 1\;Reserved when clr = 0\;Reserved when cprdq = 0\;Reserved when Spectrum-1\;Note: all counters are read regardless of cprdq and crdq" access="INDEX" offset="0x0.0" size="0x0.6" />
	<field name="cprdq" descr="Per RDQ:\;0: CLEAR_ALL: clear all counters of all RDQs\;1: CLEAR_PER_RDQ: clear counter of RQD crdq\;Reserved when clr = 0\;Reserved when Spectrum" access="INDEX" offset="0x0.30" size="0x0.1" />
	<field name="clr" descr="Clear counters" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="wqe_of_wrap" descr="WQE overflow wrap around. The wqe_overflow had a wrap around\;Reserved when Spectrum-2 and on\;" access="RO" offset="0x4.31" size="0x0.1" />
	<field name="wqe_overflow_high" descr="WQE overflow for sum of all RDQs\;Spectrum: 8bit rolling counter\;Reserved when Spectrum-2 and on\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="wqe_overflow_low" descr="WQE overflow for sum of all RDQs\;Spectrum: 8bit rolling counter\;Reserved when Spectrum-2 and on\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="wqe_overflow_rdq" descr="See Table 308, &quot;HMON - wqe_overflow_rdq Layout,&quot; on page 651\;Entries above cap_max_num_rdq are not valid\;Reserved when SwitchX/-2, Switch-IB/2, Spectrum" subnode="uint64" access="RW" high_bound="63" low_bound="0" offset="0x20.0" size="0x200.0" />
</node>

<node name="hopf_ext" descr="" size="0x14.0" >
	<field name="flow_number" descr="For send flows: Packet Send Flow (PSF)\;For receive flow: Packet Receive Flow (PRF)\;\;Note that the PSFs are a shared resource with SDQs\;Note that the PRFs are a shared resource with RDQs\;For send flows: range from 0..cap_max_num_sdq-1\;For send flows: range from 0..cap_max_num_rdq-1" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="cqe_ver" descr="CQE Version\;0: CQE Version 1\;1: CQE Version 2\;Reserved when sr = 1 (SEND)\;Informative: for OOB there is no CQE on SEND flow. On RECEIVE flow the CQE is appended to the begging of the packetReserved when profile cqe_version is 0\;Reserved when SwitchX/-2, Switch-IB/2" access="RW" offset="0x0.24" size="0x0.4" />
	<field name="sr" descr="Send/receive\;0: RECEIVE Packet Flow\;1: SEND Packet Flow" access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="i_f" descr="Interface:\;0: OOB Ethernet link 0\;1: OOB Ethernet link 1\;Note: does not affect when ETHEMAD trap_id (interface according to EMAD send interface)\;" access="RW" offset="0x4.0" size="0x0.3" />
	<field name="vport" descr="Send Virtual port\;0: port0\;1: VHCA portReserved when sr = 0 (RECEIVE)\;Reserved when SwitchX/-2" access="RW" offset="0x4.8" size="0x0.4" />
	<field name="cpu_tclass" descr="Send Flow: CPU Egress TClass\;Reserved when sr = 0 (RECEIVE)\;Range is 0.. cap_max_cpu_egress_tclass-1\;Reserved when Switch-IB/2 and Quantum" access="RW" offset="0x4.16" size="0x0.4" />
	<field name="rcv_cpu_tclass" descr="Reserved when sr = 1 (SEND)\;Receive Flow: per Interface (per OOB0,1) CPU Ingress Traffic Class\;Range is 0.. cap_max_oob_cpu_ingress_tclass-1\;Note: for different pcp values the rcv_cpu_tclass must be different\;Reserved when SwitchX/-2" access="RW" offset="0x4.24" size="0x0.4" />
	<field name="mac_47_32" descr="Destination Mac address associated with the specific packet flow (used by the device to send packets to).\;Note: for Switch-IB/2 and Quantum: the 42 msb bits must be the same for all packet_flow . The last configured mac will modify the msb for all macs of all packet_flow.\;Note: does not affect when ETHEMAD trap_id (DMAC according to EMAD send SMAC)\;Reserved when sr = 1 (SEND)" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="mac_31_0" descr="Destination Mac address associated with the specific packet flow (used by the device to send packets to).\;Note: for Switch-IB/2 and Quantum: the 42 msb bits must be the same for all packet_flow . The last configured mac will modify the msb for all macs of all packet_flow.\;Note: does not affect when ETHEMAD trap_id (DMAC according to EMAD send SMAC)\;Reserved when sr = 1 (SEND)" access="RW" offset="0xC.0" size="0x4.0" />
	<field name="vid" descr="VLAN ID\;For receive flows, adds the VID to the OOB packet\;Range 0.. cap_max_oob_vid \;Reserved when vlan_ex = 0\;Reserved when sr = 1 (SEND)\;Reserved when SwitchX/-2" access="RW" offset="0x10.0" size="0x0.12" />
	<field name="pcp" descr="For receive flows, adds the PCP to the OOB packet\;Reserved when vlan_ex = 0\;Reserved when sr = 1 (SEND)\;Reserved when SwitchX/-2\;" access="RW" offset="0x10.12" size="0x0.3" />
	<field name="dei" descr="For receive flows, adds the DEI to the OOB packet\;Reserved when vlan_ex = 0\;Reserved when sr = 1 (SEND)\;Reserved when SwitchX/-2" access="RW" offset="0x10.15" size="0x0.1" />
	<field name="vlan_ex" descr="Vlan tag exists\;0: no VLAN tag\;1: with a VLAN tag\;For receive flows, adds a vlan_tag to the OOB packet\;Reserved when sr = 1 (SEND)\;Reserved when SwitchX/-2" access="RW" offset="0x10.16" size="0x0.1" />
</node>

<node name="hpkt_ext" descr="" size="0x10.0" >
	<field name="trap_id" descr="Trap ID to configure. See Table 132, &quot;TRAP IDs,&quot; on page 439.\;Note: A trap_id can only be associated with a single trap_group. The SwitchX will associate the trap_id with the last trap_group configured.\;Note: for SwitchX/-2, Switch-IB/2 and Spectrum the range is 0..255." access="INDEX" offset="0x0.0" size="0x0.10" />
	<field name="trap_group" descr="Trap group configured for trap_id\;Range 0.. cap_max_num_trap_groups - 1\;For Switch-X/2: Range 0.. HCAP.max_num_trap_groups -1\;Reserved when ((action is NOP) and (trap_id is not Soure trap) and (trap_id is not Event trap))\;Reserved when source != 0." access="RW" offset="0x0.12" size="0x0.6" />
	<field name="action" descr="Action to perform on trap_id\;0: NOP - packet will be forwarded by the switch based on normal switching rules. The packet may get other traps \;1: TRAP - CPU receives the sole copy\;2: MIRROR_TO_CPU - CPU receives a replica of the packet, Reserved when Switch-IB/2 and Quantum. Note that this is not a mirror, it is actually &quot;trap and forward&quot;\;3: DISCARD_ERROR\;4: SOFT_DISCARD_ERROR - allows other traps and allows Policy Engine to set Forward rule. Not supported by SwitchX/-2\;5: TRAP_AND_SOFT_DISCARD_ERROR - allows other traps to overwrite this trap and allows Policy Engine to set Forward rule. Not supported by SwitchX/-2, Switch-IB/2 and Quantum\;6: EXCEPTION_TRAP - CPU receives the sole copy and an error is counted. Not supported by SwitchX/-2, Switch-IB/2 and Quantum\;7: FWD_DISCARD_ERROR - same as DISCARD_ERROR but allows previous traps (if were). \;15: SET_FW_DEFAULT - set the FW_Default value. Must not be used for trap_ids which do not have a FW_Default. This value is a WO.\;\;This field is reserved when trap_id&apos;s are Source traps, see Source trap column in Table 132, &quot;TRAP IDs,&quot; on page 439\;When Event traps - allow only NOP and TRAP, see Event trap column in Table 132, &quot;TRAP IDs,&quot; on page 439" access="RW" enum="NOP=0x0,TRAP=0x1,MIRROR_TO_CPU=0x2,DISCARD_ERROR=0x3,SOFT_DISCARD_ERROR=0x4,TRAP_AND_SOFT_DISCARD_ERROR=0x5,EXCEPTION_TRAP=0x6,FWD_DISCARD_ERROR=0x7,SET_FW_DEFAULT=0xf" offset="0x0.20" size="0x0.4" />
	<field name="source" descr="[DWIP]\;Source of request:\;0: SW_over_PCIe\;1: BMC_over_I2C_I3C" access="INDEX" enum="SW_over_PCIe=0x0,BMC_over_I2C_I3C=0x1" offset="0x0.28" size="0x0.3" />
	<field name="tr_en" descr="Truncation enabled\;0: no_truncation\;1: truncation_enabled\;Truncation size is according to HGCR.truncation_size\;Reserved when SwitchX/-2, Switch-IB/2 and Spectrum" access="RW" enum="no_truncation=0x0,truncation_enabled=0x1" offset="0x4.0" size="0x0.1" />
	<field name="tr_prof" descr="[DWIP]\;Host truncation_profile, values 0,1,2. Configured using HGCR. See Table 282, &quot;HGCR - Host Global Configuration Register Fields,&quot; on page 633\;reserved when tr_en = 0\;Supported from Spectrum-4 and Quantum-2 and above.\;" access="RW" offset="0x4.8" size="0x0.2" />
	<field name="ctrl" descr="Control Packet\;Packets configured as control traffic will use dedicated buffer resources. For more details see Section 10.3, &quot;Packet to Buffer Classification&quot;, on page 2414\;0: Keep_factory_defaults\;1: Do_not_use_control_buffer - for this Trap-ID\;2: Use_control_buffer - for the Trap-ID\;Note that not all Trap-IDs can use the control buffer. See the Control Packet column in Table 132, &quot;TRAP IDs,&quot; on page 439\;Reserved when SwitchX/-2 and Switch-IB/2" access="RW" enum="Keep_factory_defaults=0x0,Do_not_use_control_buffer=0x1,Use_control_buffer=0x2" offset="0x4.16" size="0x0.2" />
</node>

<node name="hrdqt_ext" descr="" size="0xc.0" >
	<field name="rdq" descr="" access="INDEX" offset="0x0.0" size="0x0.6" />
	<field name="tac_en" descr="TAC Enable:\;0: tac_disabled (default)\;1: tac_enabled\;\;Note: should not be enabled for a cyclic-RDQ or chain-RDQ.\;[Internal] When user asks for tac_disable, FW will trigger the grepper to evict without report all the rdq entries from the TAC.\;" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="mirror_agent" descr="Mirror Agent.\;Reserved when HGCR.tac_mirror_action = TAC_TO_CPU" access="RW" offset="0x8.8" size="0x0.4" />
</node>

<node name="hrwc_ext" descr="" size="0x220.0" >
	<field name="crdq" descr="Clear RDQ\;Range 0.. cap_max_num_rdq - 1\;Reserved when clr = 0\;Reserved when cprdq = 0\;Note: all counters are read regardless of cprdq and crdq" access="INDEX" offset="0x0.0" size="0x0.6" />
	<field name="cprdq" descr="Per RDQ:\;0: CLEAR_ALL: clear all counters of all RDQs\;1: CLEAR_PER_RDQ: clear counter of RQD crdq\;Reserved when clr = 0" access="INDEX" offset="0x0.30" size="0x0.1" />
	<field name="clr" descr="Clear counters" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="rdq_wqe_counter" descr="See Table 310, &quot;HRWC - Host RDQ WQE Counter Register Layout,&quot; on page 653\;Entries above cap_max_num_rdq are not valid" subnode="uint64" access="RW" high_bound="63" low_bound="0" offset="0x20.0" size="0x200.0" />
</node>

<node name="htac_attr_ethertype_ext" descr="" size="0x10.0" >
	<field name="ethertype" descr="Ethertype" access="RW" offset="0xC.0" size="0x0.16" />
</node>

<node name="htac_attr_icmp_ext" descr="" size="0x10.0" >
	<field name="icmp_type" descr="ICMP Type" access="RW" offset="0xC.0" size="0x0.8" />
</node>

<node name="htac_attr_igmp_ext" descr="" size="0x10.0" >
	<field name="igmp_type" descr="IGMP Type" access="RW" offset="0xC.0" size="0x0.8" />
</node>

<node name="htac_attr_udp_ext" descr="" size="0x10.0" >
	<field name="dport" descr="UDP Destination Port" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="en" descr="Enable" access="RW" offset="0xC.16" size="0x0.1" />
</node>

<node name="htac_attributes0_auto_ext" descr="" attr_is_union="1" size="0x10.0" >
	<field name="htac_attr_icmp_ext" descr="" subnode="htac_attr_icmp_ext" offset="0x0.0" size="0x10.0" />
	<field name="htac_attr_ethertype_ext" descr="" subnode="htac_attr_ethertype_ext" offset="0x0.0" size="0x10.0" />
	<field name="htac_attr_igmp_ext" descr="" subnode="htac_attr_igmp_ext" offset="0x0.0" size="0x10.0" />
	<field name="htac_attr_udp_ext" descr="" subnode="htac_attr_udp_ext" offset="0x0.0" size="0x10.0" />
</node>

<node name="htac_attributes1_auto_ext" descr="" attr_is_union="1" size="0x10.0" >
	<field name="htac_attr_icmp_ext" descr="" subnode="htac_attr_icmp_ext" offset="0x0.0" size="0x10.0" />
	<field name="htac_attr_ethertype_ext" descr="" subnode="htac_attr_ethertype_ext" offset="0x0.0" size="0x10.0" />
	<field name="htac_attr_igmp_ext" descr="" subnode="htac_attr_igmp_ext" offset="0x0.0" size="0x10.0" />
	<field name="htac_attr_udp_ext" descr="" subnode="htac_attr_udp_ext" offset="0x0.0" size="0x10.0" />
</node>

<node name="htac_ext" descr="" size="0x30.0" >
	<field name="trap_id" descr="Trap_id\;Allowed trap_id&apos;s:\;ICMPV6_CONF_TYPE0, ICMPV6_CONF_TYPE1,\;NVE_DECAP_ICMPV6_CONF_TYPE,\;NVE_DECAP_ET,\;CONF_ET0, CONF_ET1\;NVE_DECAP_IGMP_CONF_TYPE\;NVE_DECAP_UDP_CONF_TYPE" access="INDEX" offset="0x0.0" size="0x0.10" />
	<field name="attributes0" descr="Attributes per trap_id:\;ICMPV6_CONF_TYPE0, ICMPV6_CONF_TYPE1, NVE_DECAP_ICMPV6_CONF_TYPE: ICMP type, 8bits\;CONF_ET0, CONF_ET1: Ethertype, 16bits\;NVE_DECAP_ET: Ethertype0, 16bits\;NVE_DECAP_IGMP_CONF_TYPE: 8bits\;NVE_DECAP_UDP_CONF_TYPE: IPv4 dport: 15:0, enable IPv4: bit16\;Lsb&apos;s are at offset 0xC within this field\;\;See Table 318, &quot;HTAC - ICMP Type Attribute Layout,&quot; on page 657\;See Table 320, &quot;HTAC - Ethertype Attribute Layout,&quot; on page 658\;See Table 322, &quot;HTAC - IGMP Type Attribute Layout,&quot; on page 658\;See Table 324, &quot;HTAC - UDP Attribute Layout,&quot; on page 659" subnode="htac_attributes0_auto_ext" access="RW" offset="0x10.0" size="0x10.0" />
	<field name="attributes1" descr="Attributes per trap_id:\;ICMPV6_CONF_TYPE0, ICMPV6_CONF_TYPE1, NVE_DECAP_ICMPV6_CONF_TYPE: Reserved\;CONF_ET0, CONF_ET1: Reserved\;NVE_DECAP_ET: Ethertype1, 16bits\;NVE_DECAP_IGMP_CONF_TYPE: Reserved\;NVE_DECAP_UDP_CONF_TYPE: IPv6 dport: 15:0, enable IPv6: bit16\;Lsb&apos;s are at offset 0xC within this field\;\;See Table 318, &quot;HTAC - ICMP Type Attribute Layout,&quot; on page 657\;See Table 320, &quot;HTAC - Ethertype Attribute Layout,&quot; on page 658\;See Table 322, &quot;HTAC - IGMP Type Attribute Layout,&quot; on page 658\;See Table 324, &quot;HTAC - UDP Attribute Layout,&quot; on page 659" subnode="htac_attributes1_auto_ext" access="RW" offset="0x20.0" size="0x10.0" />
</node>

<node name="htacg_ext" descr="" size="0x90.0" >
	<field name="status" descr="0: idle\;1: busy\;2: done (only for event)" access="RO" offset="0x0.0" size="0x0.2" />
	<field name="tac_flush" descr="0: flush_and_report - default\;1: flush_no_report\;2: report_only" access="RW" enum="flush_and_report=0x0,flush_no_report=0x1,report_only=0x2" offset="0x4.0" size="0x0.2" />
	<field name="fields" descr="SeeTable 342, &quot;HTACG - Fields Layout,&quot; on page 673" subnode="htacg_fields_ext" access="RW" offset="0x10.0" size="0x40.0" />
	<field name="mask" descr="See Table 342, &quot;HTACG - Fields Layout,&quot; on page 673" subnode="htacg_fields_ext" access="RW" offset="0x50.0" size="0x40.0" />
</node>

<node name="htacg_fields_ext" descr="" size="0x40.0" >
	<field name="mirror_reason" descr="For field description see mirror_reason in Table 85, &quot;Completion Queue Element Version 2 (CQEv2) Fields,&quot; on page 384" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="trap_id" descr="The trap id of the packet" access="RW" offset="0x4.0" size="0x0.10" />
	<field name="rdq" descr="The rdq of the packet" access="RW" offset="0x4.24" size="0x0.6" />
	<field name="tx" descr="If UC: Egress HW port (local_port - 1) of the packet.\;If mc: 0x1fe\;If unknown: 0x1ff\;For port numbering see Table 9.3, &quot;Port Numbering,&quot; on page 1710\;\;Note: unknown is when the egress port is not known because the packet trapped before the egress port was determined" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="traffic_class" descr="Traffic class of the packet.\;If the trap happens before traffic_class was assigned, the value of this field will be 0xff." access="RW" offset="0x8.16" size="0x0.5" />
	<field name="max_mirror_cong" descr="Max value of mirror_cong of all aggregated packets.\;Ignore 0xFFFF values while performing maximum.\;If all packets had value 0xFFFF, the value of this field will be 0xFFFF.\;For field description see mirror_cong in Table 85, &quot;Completion Queue Element Version 2 (CQEv2) Fields,&quot; on page 384\;" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="last_ts" descr="Last timestamp\;according to CONFIG_PROFILE.cqe_time_stamp_type:\;Default: units of 1.024nSec\;FRC: units of 1nSec\;UTC: bits[31:26]=Sec, bits[25:0]=16nSec" access="RW" offset="0x10.0" size="0x4.0" />
	<field name="packet_count" descr="Number of packets that hits the same entry" access="RW" offset="0x14.0" size="0x4.0" />
	<field name="byte_count_39_32" descr="Length of the packet in Bytes (after ingress truncation, before trap truncation)." access="RW" offset="0x18.0" size="0x0.8" />
	<field name="byte_count_31_0" descr="Length of the packet in Bytes (after ingress truncation, before trap truncation)." access="RW" offset="0x1C.0" size="0x4.0" />
</node>

<node name="htcr_ext" descr="" size="0x210.0" >
	<field name="clr" descr="Clear counters.\;If this field is set, the counters will be cleared after read." access="OP" offset="0x0.31" size="0x0.1" />
	<field name="tac_received_pkts" descr="TAC received packets counter.\;Number of packets entered to TAC." subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
	<field name="ingress_drop_rdq" descr="TAC drop counter per RDQ.\;This counter increment when a packet cannot enter the TAC because the TAC is full and it do not have credits to evict." subnode="uint64" access="RO" high_bound="63" low_bound="0" offset="0x10.0" size="0x200.0" />
</node>

<node name="htec_ext" descr="" size="0x30.0" >
	<field name="tac_event_header" descr="TAC event header.\;When HGCR.tac_mirror_action = TAC_TO_CPU see Table 358, &quot;TAC to CPU header Layout,&quot; on page 689\;When HGCR.tac_mirror_action = TAC_TO_MIRROR see Table 360, &quot;TAC to Mirror header Layout,&quot; on page 690" subnode="htec_tac_event_header_auto_ext" access="RW" offset="0x0.0" size="0x20.0" />
	<field name="res_reg_tlv" descr="Default value 0x0" access="RW" offset="0x20.0" size="0x0.16" />
	<field name="reg_tlv_type" descr="Default value 0x3" access="RW" offset="0x20.27" size="0x0.5" />
	<field name="res_4_new" descr="Default value 0x0" access="RW" offset="0x24.4" size="0x0.12" />
	<field name="new_hdr_type" descr="Default value 0x1" access="RW" offset="0x24.27" size="0x0.5" />
	<field name="res_4_agg" descr="Default value 0x0" access="RW" offset="0x28.4" size="0x0.12" />
	<field name="agg_hdr_type" descr="Default value 0x2" access="RW" offset="0x28.27" size="0x0.5" />
	<field name="res_end_tlv" descr="Default value 0x0" access="RW" offset="0x2C.0" size="0x0.16" />
	<field name="end_tlv_len" descr="Default value 0x1" access="RW" offset="0x2C.16" size="0x0.11" />
	<field name="end_tlv_type" descr="Default value 0x0" access="RW" offset="0x2C.27" size="0x0.5" />
</node>

<node name="htec_tac_event_header_auto_ext" descr="" attr_is_union="1" size="0x20.0" >
	<field name="tac2cpu_ext" descr="" subnode="tac2cpu_ext" offset="0x0.0" size="0x20.0" />
	<field name="tac2mirror_ext" descr="" subnode="tac2mirror_ext" offset="0x0.0" size="0x20.0" />
</node>

<node name="htgt_ext" descr="" size="0x44.0" >
	<field name="trap_group" descr="Trap group\;Range is 0 .. cap_max_num_trap_groups - 1\;For Switch-X/2: Range 0.. HCAP.max_num_trap_groups -1" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="type" descr="Type:\;0: LOCAL - used for locally attached CPU \;15: NULL - trap group disabled" access="RW" enum="LOCAL=0x0,NULL=0xf" offset="0x0.8" size="0x0.4" />
	<field name="swid" descr="Switch Partition ID\;Note that event traps have swid value of &apos;254&apos; (all-swid)Reserved when Spectrum/-2" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="pid" descr="Policer ID for trap group trap_group.\;Host Interface Policers should be allocated out of the Global Policers.\;Range is 0..(cap_max_policers_cpu-1)\;Note: the policer affects only packets which are trapped to CPU, mirrored packets on trap_group are not subject to policer." access="RW" offset="0x4.0" size="0x0.14" />
	<field name="pide" descr="Policer enable\;For more details about policers, refer to Section 11.7.6, &quot;Policer&quot;, on page 2805.\;Note: must not be set for MIRROR_SESSION trap_ids\;" access="RW" offset="0x4.15" size="0x0.1" />
	<field name="mirror_agent" descr="Mirroring port analyzer ID (pa_id), see Section 5.15.1, &quot;MOGCR - Monitoring Global Configuration Register&quot;, on page 1241\;Reserved when mirror_action is TRAP_TO_CPU" access="RW" offset="0x8.0" size="0x0.3" />
	<field name="mirror_action" descr="Trap Mirror Action\;0: TRAP_TO_CPU - packet is forwarded to the CPU based on the path configured \;1: TRAP_TO_CPU_AND_MIRROR - trap to CPU and Mirror to a mirroring agent\;2: TRAP_TO_MIRROR - mirror to mirroring agent and do not trap to the CPU.\;Reserved when SwitchX/-2, Switch-IB/2 and Quantum" access="RW" enum="TRAP_TO_CPU=0x0,TRAP_TO_CPU_AND_MIRROR=0x1,TRAP_TO_MIRROR=0x2" offset="0x8.8" size="0x0.2" />
	<field name="priority" descr="Trap Group Priority\;In case a packet matches multiple classification rules, the packet will only be trapped once, based on the Trap-ID associated with the group with the highest priority value. Higher values mean higher priority.\;Range is 0..cap_max_trap_group_priorities-1\;Reserved when SwitchX/-2, Switch-IB/2 and Quantum. For these devices the priority value equals the trap_group value." access="RW" offset="0xC.0" size="0x0.4" />
	<field name="path" descr="Path to designated CPU\;Reserved when type != 0\;See Table 289, &quot;LOCAL Path Layout,&quot; on page 641" subnode="local_path_ext" access="RW" offset="0x10.0" size="0x10.0" />
	<field name="mirror_probability_rate" descr="For mirroring: sampling rate = 1 out of rate packets \;Valid values are: 1 to 3.5*10^9\;Values of 0 behaves like 1\;Default 1\;Note: high values are round by HW to: 10^9 * {4.3, 2.15, 1.43, 1.08, 0.86, 0.72, 0.61, 0.54}. \;Reserved when mirror_action is TRAP_TO_CPU\;Reserved when SwitchX/-2, Switch-IB/2, Spectrum, Quantum.\;" access="RW" offset="0x40.0" size="0x4.0" />
</node>

<node name="hthm_ext" descr="" size="0x8.0" >
	<field name="trap_id" descr="Trap ID.\;Not all the Trap IDs can be used in this register because some of the trap id associated with multiple hw_trap_ids. See Table 132, &quot;TRAP IDs,&quot; on page 439.\;To differentiate which Trap ID is valid, look at the ACL Key column." access="INDEX" offset="0x0.0" size="0x0.10" />
	<field name="hw_trap_id" descr="HW Trap Id." access="RO" offset="0x4.0" size="0x0.10" />
	<field name="vld" descr="Indicate if this trap id is valid.\;0: trap_id_not_valid\;1: trap_id_valid - hw_trap_id can be used." access="RO" enum="trap_id_not_valid=0x0,trap_id_valid=0x1" offset="0x4.31" size="0x0.1" />
</node>

<node name="hukt_ext" descr="" size="0xc.0" >
	<field name="type" descr="Type:\;0: user_key\;1: time\;Default value is 0." access="INDEX" offset="0x0.0" size="0x0.2" />
	<field name="user_key" descr="User key.\;This value will be static in TAC header, see \;Reserved when type = 1\;Default value is 0." access="RW" offset="0x4.0" size="0x0.5" />
	<field name="time_resolution" descr="Time.\;Units of uSec.\;Range 1...1,000,000\;Default value 1mSec.\;Reserved when type = 0\;" access="RW" offset="0x8.0" size="0x4.0" />
</node>

<node name="ibfmr_ext" descr="" size="0x10.0" >
	<field name="atm_v" descr="Attribute Modifier valid\;The attribute_modifier is valid\;" access="RO" offset="0x0.0" size="0x0.1" />
	<field name="attribute_id" descr="Attribute ID of the received MAD\;Supported:\;0x0019: LinearForwardingTable\;0x001B: MulticastForwardingTable" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="attribute_modifier" descr="AttributeModifier of the received MAD" access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="ibfmrc_ext" descr="" size="0x4.0" >
	<field name="attr_id_en" descr="Attribute ID enable:\;bit0: 0x0019: LinearForwardingTable\;bit1: 0x001B: MulticastForwardingTable\;" access="RW" offset="0x0.0" size="0x4.0" />
</node>

<node name="ibissu_ext" descr="" size="0x4.0" >
	<field name="req_to_sm" descr="Request to SM:\;0: Idle (default)\;1: Request\;Set to 1 by SW.\;Set to 0 by the device after sending the MAD." access="RW" offset="0x0.0" size="0x0.1" />
	<field name="sm_approve" descr="SM has approved ISSU:\;0: Idle (default, cleared after reset and after ISSU)\;1: Allowed. Set after ISSUApprove.issu_approved = 1\;2: Not_allowed. Set after ISSUApprove.issu_approved = 2" access="RO" offset="0x0.8" size="0x0.2" />
</node>

<node name="ibsni_ext" descr="" size="0x148.0" >
	<field name="ipv4_record" descr="See Table 1456, &quot;IBNSI - IPv4 record Layout,&quot; on page 1702\;Entry 0 refer to out-of-band interfaces (e.g, box, alias or physical). \;Entry 1 refers to IPoIB interface\;" subnode="ibsni_ipv4_ext" access="RW" high_bound="3" low_bound="0" offset="0x8.0" size="0x20.0" />
	<field name="ipv6_record" descr="See Table 1458, &quot;IBSNI - IPv6 record Layout,&quot; on page 1702\;Entry 0 refer to out-of-band interfaces (e.g, box, alias or physical). \;Entry 1 refers to IPoIB interface\;" subnode="ibsni_ipv6_ext" access="RW" high_bound="3" low_bound="0" offset="0x28.0" size="0x80.0" />
	<field name="ipv4_record_port2" descr="For CPU port2\;See Table 1456, &quot;IBNSI - IPv4 record Layout,&quot; on page 1702\;Entry 0 refer to out-of-band interfaces (e.g, box, alias or physical). \;Entry 1 refers to IPoIB interface\;" subnode="ibsni_ipv4_ext" access="RW" high_bound="3" low_bound="0" offset="0xA8.0" size="0x20.0" />
	<field name="ipv6_record_port2" descr="For CPU port2\;See Table 1458, &quot;IBSNI - IPv6 record Layout,&quot; on page 1702\;Entry 0 refer to out-of-band interfaces (e.g, box, alias or physical). \;Entry 1 refers to IPoIB interface\;" subnode="ibsni_ipv6_ext" access="RW" high_bound="3" low_bound="0" offset="0xC8.0" size="0x80.0" />
</node>

<node name="ibsni_ipv4_ext" descr="" size="0x8.0" >
	<field name="ipv4" descr="IPv4 address" access="RW" offset="0x0.0" size="0x4.0" />
	<field name="netmask" descr="Netmask" access="RW" offset="0x4.0" size="0x4.0" />
</node>

<node name="ibsni_ipv6_ext" descr="" size="0x20.0" >
	<field name="ipv6" descr="IPv6 address" access="RW" high_bound="3" low_bound="0" offset="0x0.0" size="0x10.0" />
	<field name="netmask" descr="Netmask" access="RW" high_bound="3" low_bound="0" offset="0x10.0" size="0x10.0" />
</node>

<node name="icam_reg_ext" descr="" size="0x18.0" >
	<field name="access_reg_group" descr="Access Register ID groups \;0: REG_IDs 0x3800 to 0x387F\;1: REG_IDs 0x3880 to 0x38FF" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="infr_access_reg_cap_mask" descr="Supported infrastructure&apos;s access register bitmask. Based on access_reg_group index. \;When bit is set to &apos;1&apos;, The register is supported in the device. \;For example, when access_reg_group == 1:\;Bit 112: ICSR\;Bit0 is at 08h.bit0\;Bit 127 is at 14h.bit31" access="RO" high_bound="3" low_bound="0" offset="0x8.0" size="0x10.0" />
</node>

<node name="icsr_ext" descr="" size="0x410.0" >
	<field name="base_address" descr="Base cr-space address for reading" access="INDEX" offset="0x4.0" size="0x4.0" />
	<field name="num_reads" descr="Number of cr-space consecutive reads.\;Each read is 4B (DWord)\;Range 1..256" access="OP" offset="0x8.0" size="0x0.9" />
	<field name="data" descr="The cr-space read data" access="RO" high_bound="255" low_bound="0" offset="0x10.0" size="0x400.0" />
</node>

<node name="iddd_ext" descr="" size="0x8.0" >
	<field name="entry_type" descr="Entry type\;For Spectrum-2 hash entries see Appendix A.5.1.1, &quot;KVD Central Database Hash-based&quot; (page 3821)\;For Spectrum-2 linear entries see Appendix A.5.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3823)" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="duplication" descr="Duplication\;Valid values:\;1, 2, 4, 8, 16\;Default is 1\;\;" access="RW" offset="0x4.0" size="0x0.5" />
</node>

<node name="iddds_ext" descr="" size="0x440.0" >
	<field name="pipe" descr="Pipe\;See Table 1212, &quot;IDDDS - pipe entry Layout,&quot; on page 1447" subnode="iddds_pipeline_entry_ext" access="RW" high_bound="15" low_bound="0" offset="0x40.0" size="0x400.0" />
</node>

<node name="iddds_pipeline_entry_ext" descr="" size="0x40.0" >
	<field name="entry_type" descr="Entry type\;Per entry type: read percentage of utilization (lookups/time) in database\;Range 0..100\;For Spectrum-2 hash entries see Appendix A.5.1.1, &quot;KVD Central Database Hash-based&quot; (page 3821)\;For Spectrum-2 linear entries see Appendix A.5.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3823)" access="RO" high_bound="63" low_bound="0" offset="0x0.24" size="0x40.0" />
</node>

<node name="iedr_ext" descr="" size="0x210.0" >
	<field name="num_rec" descr="Number of records\;Range 1..64\;When bg=1 the num_rec =1 and this field is reserved" access="OP" offset="0x0.0" size="0x0.8" />
	<field name="bg" descr="Background delete:\;0: immediate delete operation (a.k.a. sync)\;1: background delete operation (a.k.a. async). SW must poll for IEDS.ed_status=0 before attempting new deletes" access="OP" offset="0x0.24" size="0x0.1" />
	<field name="record" descr="See Table 1216, &quot;IEDR record Layout,&quot; on page 1450" subnode="iedr_record_ext" access="RW" high_bound="63" low_bound="0" offset="0x10.0" size="0x200.0" />
</node>

<node name="iedr_record_ext" descr="" size="0x8.0" >
	<field name="size" descr="Size of entries do be deleted.\;The unit is 1 entry, regardless of entry type\;Range 1..4096" access="OP" offset="0x0.0" size="0x0.13" />
	<field name="type" descr="Resource type\;For Spectrum-2, see Section A.5.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3823" access="OP" offset="0x0.24" size="0x0.8" />
	<field name="index_start" descr="Resource index start" access="OP" offset="0x4.0" size="0x0.24" />
</node>

<node name="ieds_ext" descr="" size="0x8.0" >
	<field name="edpr" descr="Entry Delete Priority\;When set FW will give higher priority for the current ongoing entry delete process. Can be set also while entry delete process is ongoing. Affects only current process. By default all process start as low prio\;" access="OP" offset="0x0.0" size="0x0.1" />
	<field name="ed_status" descr="Entry delete status:\;0: No entry delete process is ongoing\;1: Entry delete process is ongoing" access="RO" offset="0x4.0" size="0x0.4" />
</node>

<node name="ifbo_ext" descr="" size="0x28.0" >
	<field name="type" descr="Hash type\;2: Random\;3: CRC2\;4: XOR2 - this is a always symmetric hash function, always symmetric also for inner fields (L2, L3,L4). \;\;" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="outer_header_enables" descr="Outer header enables. Each bit enables a specific layer field to be included in the hash calculation. Layers that are not listed below are enabled by default.\;Bit 0: Enable Layer2 fields if packet is not IPv4/6\;Bit 1: Enable Layer2 fields if packet is IPv4\;Bit 2: Enable Layer2 fields if packet is IPv6\;Bit 3: Enable IPv4 fields if packet is not TCP and not UDP\;Bit 4: Enable IPv4 fields if packet is either TCP or UDP\;Bit 5: Enable IPv6 fields if packet is not TCP and not UDP\;Bit 6: Enable IPv6 fields if packet is either TCP or UDP\;Bit 7: Enable TCP/UDP header fields if packet is IPv4\;Bit 8: Enable TCP/UDP header fields if packet is IPv6" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="outer_header_fields_enable" descr="By defaults, all fields are &apos;0&apos;\;Layer2 fields, subject to outer_header_enables:\;Bit 0: SMAC\;Bit 1: DMAC\;Bit 2: Ethertype\;Bit 3: Outer VID\;Bit 4: Outer PCP\;Bit 5: Outer DEI\;Bit 6: Inner VID\;Bit 7: Inner PCP\;Bit 8: Inner DEI\;\;IPv4 fields, subject to outer_header_enables:\;Bits 12:9: IPv4 SIP 0-3 enable per byte. For ARP all bytes are used\;Bits 16:13: IPv4 DIP 0-3 enable per byte. For ARP all bytes are used\;Bit 17: IPv4 Protocol\;Bit 18: IPv4 DSCP\;Bit 19: IPv4 ECN\;Bit 20: IPv4 IP L3 Length - length field bits [13:10]\;\;IPv6 fields, subject to outer_header_enables:\;Bits 21: IPv6 enable bytes of SIP 0. For ARP all bytes are used\;Bits 28:22 reserved\;Bits 36:29: IPv6 SIP 8-15 enable per byte. For ARP all bytes are used\;Bits 37: IPv6 enable bytes of DIP 0. For ARP all bytes are used\;Bits 44:38 reserved\;Bits 52:45: IPv6 DIP 8-15 enable per byte. For ARP all bytes are used\;Bit 53: IPv6 Next Header\;Bit 54: IPv6 DSCP\;Bit 55: IPv6 ECN\;Bit 56: IPv6 IP L3 Length - length field bits [13:10]\;Bit 57: IPv6 Flow label\;\;" access="RW" high_bound="4" low_bound="0" offset="0x14.0" size="0x14.0" />
</node>

<node name="igcr_ext" descr="" size="0x10.0" >
	<field name="ddd_lpm_high_ipv4" descr="For DDD for IPv4 LPM\;LPM_High is for routes with prefixes from ddd_lpm_high_ipv4 .. 32\;LPM_Low is for routes with prefixes from 1 to  ddd_lpm_high_ipv4-1\;Range: 1..32, default: 9\;Note: can only be changed when the router is disabled\;" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="ddd_lpm_high_ipv6" descr="For DDD for IPv6 LPM\;LPM_High is for routes with prefixes from ddd_lpm_high_ipv6 .. 128\;LPM_Low is for routes with prefixes from 1 to ddd_lpm_high_ipv6-1\;Range: 1..128, default: 33\;Note: can only be changed when the router is disabled" access="RW" offset="0x0.16" size="0x0.8" />
	<field name="ddd_pe_actions_priority" descr="For DDD on ACL actions\;ACL actions which are pointed by a rule with priority equal to or smaller than this value will have DDD\;For example if the value is 0 then only default actions will have DDD\;Default 0" access="RW" offset="0x8.0" size="0x0.24" />
	<field name="pisbo" descr="Port isolation bridge only:\;0: port isolation also after router\;1: port isolation does not work if packet was routed\;Note that the NVE isolation (TNIFR) is orthogonal to this configuration\;Reserved when Spectrum-1\;" access="RW" offset="0xC.0" size="0x0.1" />
	<field name="ddd_lag_mode" descr="0: entry is duplicated by 8 times \;1: no entry duplication (DDD disabled)\;\;Note:\;1. Can be changed only when there is no LAG configuration applied\;2. Supported when config_profile.lag_mode = 1 (SW managed)" access="RW" offset="0xC.8" size="0x0.4" />
</node>

<node name="ihscr_ext" descr="" size="0xa8.0" >
	<field name="inner_l2_type" descr="Bit0: others\;Bit1: Ethernet" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="profile_index" descr="Index of classifier.\;Range 0 - cap_max_signature_hash_classifiers - 1\;If packet match classifier index X, signature hash index X will be performed on the packet." access="INDEX" offset="0x0.29" size="0x0.3" />
	<field name="l3_type" descr="Ethertype\;Bit0: None \;Bit1: IPv4\;Bit2: IPv6\;Bit3: GRH\;Bit4: Fiber-Channel\;Bit5: ARP\;Bit6: Raw Bit7: MPLS\;" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="inner_l3_type" descr="same as for l3_type" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="inner_ip_frag" descr="same as for ip_frag" access="RW" offset="0xC.0" size="0x0.2" />
	<field name="ip_frag" descr="IP Packet is fragmented:\;Bit0: fragmented\;Bit1: not fragmented" access="RW" offset="0xC.8" size="0x0.2" />
	<field name="l4_type" descr="Bit0: others \;Bit1: Raw \;Bit2: TCP\;Bit3: UDP\;Bit4: BTH\;Bit5: BTH_over_UDP\;Bit6: ICMP\;Bit7: IGMP\;Bit8: AH\;Bit9: ESP\;" access="RW" offset="0x10.0" size="0x0.11" />
	<field name="inner_l4_type" descr="same as for l4_type" access="RW" offset="0x14.0" size="0x0.11" />
	<field name="tunnel_type" descr="Bit0: others \;Bit1: VxLAN\;Bit2: NVGRE\;Bit3: MPLS\;Bit4: IPinIP - no GRE\;Bit5: IPinGREinIP_Key - with GRE and a key\;Bit6: IPinGREinIP - with GRE, without a key\;Bit8: Flex" access="RW" offset="0x18.0" size="0x0.9" />
	<field name="mask_outer" descr="If tunnel, all outer fields are don&apos;t care (match to classifier)" access="RW" offset="0x1C.0" size="0x0.1" />
	<field name="mask_inner" descr="If no tunnel, all inner fields are don&apos;t care (match to classifier)" access="RW" offset="0x1C.1" size="0x0.1" />
	<field name="fpp_index" descr="Bit0 : if set, fpp (flex parser program) was not used\;Bit1-Bit8: fpp index + 1" access="RW" offset="0x20.0" size="0x0.9" />
	<field name="inner_fpp_index" descr="Bit0 : if set, inner fpp was not used\;Bit1-Bit8: inner fpp index + 1" access="RW" offset="0x24.0" size="0x0.9" />
	<field name="ports_bitmap" descr="Bitmap off all ports.\;Index according to local port numbering." access="RW" high_bound="31" low_bound="0" offset="0x28.0" size="0x80.0" />
</node>

<node name="ihsr_ext" descr="" size="0x50.0" >
	<field name="type" descr="Hash type\;0: CRC" access="RW" enum="CRC=0x0" offset="0x0.0" size="0x0.4" />
	<field name="gsh" descr="Global Symmetric Hash Configuration\;When set, the hash calculation will result in the same hash value as when the source address (layer 2, layer 3 and layer 4) is swapped. This ensures that the same conversions will result in the same hash value.\;bit 0: When set, applies symmetric hash on outer header\;bit 1: When set, applies symmetric hash on inner header\;bit 2: When set, applies symmetric hash cbset.\;The following cbset pairs are applied with symmetric action: [0,1], [2,3], [4,5], [6,7]" access="RW" offset="0x0.8" size="0x0.3" />
	<field name="hash_profile" descr="Index of hash.\;Range 0 - cap_max_signature_hash_profiles - 1" access="INDEX" offset="0x0.16" size="0x0.3" />
	<field name="general_fields" descr="This is a bit mask, in which each bit enables a specific field to be included in the hash calculation. \;Bit 0: Ingress port\;Bit 1: custom_bytes are set by cbsets field.\;Bit i: custom_bytes i-2\;i = 2 .. 2 + (cap_max_custom_byte_sets_for_hash * cap_custom_byte_entry_size - 1)\;See Section 11.3.14, &quot;Custom Bytes&quot;, on page 2513" access="RW" offset="0xC.0" size="0x4.0" />
	<field name="outer_header_enables" descr="Outer header enables. Each bit enables a specific layer field to be included in the hash calculation. Layers that are not listed below are enabled by default.\;Bit 0: Enable Layer2 fields if packet is not IPv4/6\;Bit 1: Enable Layer2 fields if packet is IPv4\;Bit 2: Enable Layer2 fields if packet is IPv6\;Bit 3: Enable IPv4 fields if packet is not TCP and not UDP\;Bit 4: Enable IPv4 fields if packet is either TCP or UDP\;Bit 5: Enable IPv6 fields if packet is not TCP and not UDP\;Bit 6: Enable IPv6 fields if packet is either TCP or UDP\;Bit 7: Enable TCP/UDP header fields if packet is IPv4\;Bit 8: Enable TCP/UDP header fields if packet is IPv6\;Bit 9: IPv4 mask fragments - mask ipv4 fragmented packets (mask all fields after ipv4 header)\;\;" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="outer_header_fields_enable" descr="Layer2 fields, subject to outer_header_enables:\;Bit 0: SMAC\;Bit 1: DMAC\;Bit 2: Ethertype\;Bit 3: Outer VLAN VID\;Bit 4: Outer VLAN PCP\;Bit 5: Outer VLAN DEI (cfi)\;Bit 6: Inner VLAN VID\;Bit 7: Inner VLAN PCP\;Bit 8: Inner VLAN DEI (cfi)\;\;IPv4 fields, subject to outer_header_enables:\;Bits 12:9: IPv4 SIP 0-3 enable per byte. For ARP all bytes are used\;Bits 16:13: IPv4 DIP 0-3 enable per byte. For ARP all bytes are used\;Bit 17: IPv4 Protocol\;Bit 18: IPv4 DSCP\;Bit 19: IPv4 ECN\;Bit 20: IPv4 IP L3 Length - length field bits [13:10]\;\;IPv6 fields, subject to outer_header_enables:\;Bits 21: IPv6 enable bytes of SIP 0-7. For ARP all bytes are used\;Bits 28:22 reserved\;Bits 36:29: IPv6 SIP 8-15 enable per byte. For ARP all bytes are used\;Bits 37: IPv6 enable bytes of DIP 0-7. For ARP all bytes are used\;Bits 44:38 reserved\;Bits 52:45: IPv6 DIP 8-15 enable per byte. For ARP all bytes are used\;Bit 53: IPv6 Next Header\;Bit 54: IPv6 DSCP\;Bit 55: IPv6 ECN\;Bit 56: IPv6 IP L3 Length - length field bits [13:10]\;Bit 57: IPv6 Flow label" access="RW" high_bound="4" low_bound="0" offset="0x14.0" size="0x14.0" />
	<field name="inner_header_enables" descr="Inner header enables. Each bit enables a specific layer field to be included in the hash calculation. Layers that are not listed below are enabled by default.\;Bit 0: Enable inner Layer2 fields if inner packet is not IPv4/6\;Bit 1: Enable inner Layer2 fields if inner packet is IPv4\;Bit 2: Enable inner Layer2 fields if inner packet is IPv6\;Bit 3: Enable inner IPv4 fields if inner packet is not TCP and not UDP\;Bit 4: Enable inner IPv4 fields if inner packet is either TCP or UDP\;Bit 5: Enable inner IPv6 fields if inner packet is not TCP and not UDP\;Bit 6: Enable inner IPv6 fields if inner packet is either TCP or UDP\;Bit 7: Enable inner TCP/UDP header fields if inner packet is IPv4\;Bit 8: Enable inner TCP/UDP header fields if inner packet is IPv6\;Bit 9: inner IPv4 mask fragments - mask ipv4 fragmented packets (mask all fields after ipv4 header)\;others: reserved" access="RW" offset="0x2C.0" size="0x0.16" />
	<field name="inner_header_fields_enable" descr="Inner header fields enable.\;\;Inner Layer2 fields, subject to inner_header_enables:\;Bit 0: SMAC\;Bit 1: DMAC\;Bit 2: Ethertype\;\;Inner IPv4 fields, subject to inner_header_enables:\;Bits 6:3: IPv4 SIP 0-3 enable per byte\;Bits 10:7: IPv4 DIP 0- 3 enable per byte\;Bit 11: IPv4 Protocol\;\;Inner IPv6 fields, subject to inner_header_enables:\;Bits 12: IPv6 enable bytes of SIP 0-7\;Bits 19:13 reserved\;Bits 27:20: IPv6 SIP 8-15 enable per byte\;Bits 28: IPv6 enable bytes of DIP 0-7\;Bits 35:29 reserved\;Bits 43:36: IPv6 DIP 8-15 enable per byte\;Bit 44: IPv6 Next Header\;Bit 45: IPv6 Flow label\;\;Inner TCP /UDP header fields, subject to inner_header_enables:\;Bit 46: TCP/UDP source port\;Bit 47: TCP/UDP destination port\;\;Inner BTH header fields, subject to inner_header_enables:\;Bit 48: BTH dest qp\;Bit 49: BTH opcode\;Bit50: BTH pkey\;\;Inner DETH fields, subject to inner_header_enables:\;Bit 51: DETH_qkey_en\;Bit 52: DETH_source_qp_en" subnode="uint64" access="RW" offset="0x30.0" size="0x8.0" />
	<field name="cbsets" descr="Custom Byte Sets.\;For more details refer to Table 1396, &quot;cbsets Layout&quot;.\;Reserved when Spectrum\;Reserved up to cap_max_custom_byte_sets-1" access="RW" high_bound="3" low_bound="0" offset="0x40.0" size="0x10.0" />
</node>

<node name="iicr_ext" descr="" size="0x34.0" >
	<field name="kvh_mark_clear" descr="KVH mark and clear\;0: Nop \;1: Mark all KVH entries (e.g. before FW-ISSU)\;2: Clear (delete) all marked KVH entries (e.g. after FW-ISSU)\;Spectrum: mark/delete only KVH hash entries\;Spectrum-2: mark/delete KVH hash and KVH linear entries\;Note: dump sessions must not be ongoing between mark and clear. e.g. SFN, SFDD, RAUHTD, PEFAAD, MPNHLFED, TNIPSN" access="OP" offset="0x8.0" size="0x0.4" />
	<field name="clear_mc_rtr_tcam_mask" descr="For Spectrum only:\;clear (deallocate) Multicast Router TCAM regions if:\;(1) group[bit] = clear_pe_regions_value[bit]\;(2) and clear_mc_rtr_tcam_mask[bit]=1\;Note: a used TCAM region must not be cleared (if traffic is passing through this region). An ACL may point to this unused TCAM region\;For the 2 Mc Router groups see RTAR.key_type.\;If mask=0 then this is a Nop" access="OP" offset="0xC.0" size="0x0.2" />
	<field name="clear_mc_rtr_tcam_value" descr="For Spectrum only:\;clear (deallocate) Multicast Router TCAM regions if:\;(1) group[bit] = clear_pe_regions_value[bit]\;(2) and clear_mc_rtr_tcam_mask[bit]=1\;Note: a used TCAM region must not be cleared (if traffic is passing through this region). An ACL may point to this unused TCAM region\;For the 2 Mc Router groups see RTAR.key_type.\;If mask=0 then this is a Nop" access="OP" offset="0xC.4" size="0x0.2" />
	<field name="clear_pe_regions_value" descr="clear (deallocate) policy engine TCAM regions if:\;(1) region[bit] = clear_pe_regions_value[bit]\;(2) and clear_pe_regions_mask[bit]=1\;Note: a used TCAM region must not be cleared (if traffic is passing through this region). An ACL may point to this unused TCAM region.\;If mask=0 then this is a Nop" access="OP" offset="0x10.0" size="0x0.16" />
	<field name="clear_pe_regions_mask" descr="clear (deallocate) policy engine TCAM regions if:\;(1) region[bit] = clear_pe_regions_value[bit]\;(2) and clear_pe_regions_mask[bit]=1\;Note: a used TCAM region must not be cleared (if traffic is passing through this region). An ACL may point to this unused TCAM region.\;If mask=0 then this is a Nop" access="OP" offset="0x14.0" size="0x0.16" />
	<field name="clear_rifs_value" descr="clear (deallocate) router interface (RIF) if:\;(1) rif[bit] = clear_rifs_value[bit]\;(2) and clear_rifs_mask[bit]=1\;Note: a used RIF must not be cleared (if traffic is passing through this RIF).\;If mask=0 then this is a Nop" access="OP" offset="0x18.0" size="0x0.16" />
	<field name="clear_rifs_mask" descr="clear (deallocate) router interface (RIF) if:\;(1) rif[bit] = clear_rifs_value[bit]\;(2) and clear_rifs_mask[bit]=1\;Note: a used RIF must not be cleared (if traffic is passing through this RIF).\;If mask=0 then this is a Nop" access="OP" offset="0x1C.0" size="0x0.16" />
	<field name="traps_2_default" descr="Set all trap_id&apos;s actions to default as after reset." access="OP" offset="0x20.0" size="0x0.1" />
	<field name="clear_acl_group_ids_value" descr="clear (deallocate) policy engine ACL groups (which were configured with PAGT) if:\;(1) group[bit] = clear_acl_group_ids_value[bit]\;(2) and clear_acl_group_ids_mask[bit]=1\;Note: a used ACL group must not be cleared (if traffic is passing through this ACL group).\;If mask=0 then this is a Nop.\;Note: Mutual exclusive with clear_acl_group_elements_value and clear_acl_group_elements_mask." access="OP" offset="0x24.0" size="0x0.16" />
	<field name="clear_acl_group_ids_mask" descr="clear (deallocate) policy engine ACL groups (which were configured with PAGT) if:\;(1) group[bit] = clear_acl_group_ids_value[bit]\;(2) and clear_acl_group_ids_mask[bit]=1\;Note: a used ACL group must not be cleared (if traffic is passing through this ACL group).\;If mask=0 then this is a Nop.\;Note: Mutual exclusive with clear_acl_group_elements_value and clear_acl_group_elements_mask." access="OP" offset="0x28.0" size="0x0.16" />
	<field name="clear_acl_group_elements_value" descr="clear (deallocate) policy engine ACL group elements (which were configured with PAGT_V2) if:\;(1) element[bit] = clear_acl_group_elements_value[bit]\;(2) and clear_acl_group_elements_mask[bit]=1\;Note: a used ACL group element must not be cleared (if traffic is passing through this ACL group element).\;If mask=0 then this is a Nop.\;Note: Mutual exclusive with clear_acl_group_ids_value and clear_acl_group_ids_mask." access="OP" offset="0x2C.0" size="0x0.16" />
	<field name="clear_acl_group_elements_mask" descr="clear (deallocate) policy engine ACL group elements (which were configured with PAGT_V2) if:\;(1) element[bit] = clear_acl_group_elements_value[bit]\;(2) and clear_acl_group_elements_mask[bit]=1\;Note: a used ACL group element must not be cleared (if traffic is passing through this ACL group element).\;If mask=0 then this is a Nop.\;Note: Mutual exclusive with clear_acl_group_ids_value and clear_acl_group_ids_mask." access="OP" offset="0x30.0" size="0x0.16" />
</node>

<node name="index_dump" descr="" size="0x4.0" >
	<field name="index_dump" descr="" offset="0x0.0" size="0x0.24" />
</node>

<node name="ip2me_ext" descr="" size="0x14.0" >
	<field name="trap_action" descr="Trap Action\;0: NOP\;3: MIRROR. Note that if the packet is trapped as IP2ME (see description in v) then it will not be trapped as MIRROR.\;Reserved when v = 0" access="RW" offset="0x0.28" size="0x0.4" />
	<field name="tunnel_ptr" descr="Tunnel Pointer for NVE or IPinIP tunnel decapsulation. See Section 14.15.16, &quot;RTDP - Routing Tunnel Decap Properties Register&quot;, on page 3297\;For Spectrum, pointer to KVD Linear, see Section A.4.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3813\;" access="RW" offset="0x4.0" size="0x0.24" />
	<field name="v" descr="Valid bit for the tunnel_ptr field\;If valid = 0 then trap to CPU as IP2ME trap id\;If valid = 1 and the packet format allows NVE or IPinIP tunnel decapsulation then tunnel decapsulation is done\;If valid = 1 and packet format does not allow NVE or IPinIP tunnel decapsulation then trap as IP2ME trap id" access="RW" offset="0x4.31" size="0x0.1" />
</node>

<node name="ip_gw_adjacency_ext" descr="" size="0x14.0" >
	<field name="irif" descr="RIF post NAT operation" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="new_header_type" descr="new IP header type:\;0: Build IPv4, set by new_ipv4_udip\;1: Build IPv6, set by new_ipv6_ptr\;Note: the type field (IPv4 or IPv6) must match the configuration of the router interface, see protocol field in Table 2987, &quot;Loopback USIP Router Interface Properties Layout,&quot; on page 3234" access="RW" offset="0x0.24" size="0x0.4" />
	<field name="qos_profile" descr="qos profile\;valid values 0..(cap_max_tqos_profile-1)" access="RW" offset="0x4.24" size="0x0.4" />
	<field name="new_ipv4_udip" descr="New IPv4 dip\;Reserved when nat_type is IPv6" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="new_ipv6_ptr" descr="Pointer to IPv6 dip\;See Section 14.15.17, &quot;RIPS - Router IP version Six Register&quot;, on page 3305\;Pointer to KVD linear space, see A.4.1.2 &quot;KVD Central Database Linear Entries,&quot; on page 3813\;Reserved when nat_type is IPv4" access="RW" offset="0xC.0" size="0x0.24" />
	<field name="exp_l3" descr="Expected Layer 3 Header:\;0: Any \;1: IPv4\;2: IPv6" access="RW" offset="0x10.0" size="0x0.2" />
</node>

<node name="ipac_ext" descr="" size="0xb0.0" >
	<field name="profile_index" descr="Profile Index\;Range 0..cap_max_infra_profiles-1" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="status" descr="Status:\;0: IDLE\;1: BUSY\;2: CANCELED - After the trap the status moves to IDLE\;3: ERROR - After the trap the status moves to IDLE\;" access="RO" enum="IDLE=0x0,BUSY=0x1,CANCELED=0x2,ERROR=0x3" offset="0x4.0" size="0x0.2" />
	<field name="opcode" descr="Opcode\;0: START a session. Per session rejected when status = BUSY.\;1: CANCEL the session, see explanation above.\;2: CANCEL_AND_CLEAR cancel session and clear the profile.\;Note that a session is per type, thus multi sessions are allowed for different types.\;Opcode START cannot be set when a session is BUSY" access="WO" offset="0x4.8" size="0x0.2" />
	<field name="port_mask" descr="Local port\;Each bit represents a local port. Refer to Section 9.3, &quot;Port Numbering&quot;, on page 1710 for port numbering scheme.\;CPU port is supported\;Router port is not supported" access="RW" high_bound="31" low_bound="0" offset="0x20.0" size="0x80.0" />
	<field name="log_op_time" descr="Log: how long the operation took in background\;Units of mSec" access="RO" offset="0xA0.0" size="0x0.16" />
	<field name="log_op_registers" descr="Log: how many &quot;PRM registers&quot; were configured, e.g. if PMTU was done for 128 ports then reveal 128." access="RO" offset="0xA4.0" size="0x4.0" />
	<field name="error_register_id" descr="When status = ERROR:\;register_id on which there was an error" access="RO" offset="0xA8.0" size="0x0.16" />
	<field name="error_local_port" descr="When status = ERROR:\;local_port on which there was an error" access="RO" offset="0xA8.16" size="0x0.8" />
	<field name="error_lp_msb" descr="error_local_port[9:8]" access="RO" offset="0xA8.24" size="0x0.2" />
	<field name="error_entry_index" descr="When status = ERROR:\;Index of the entry in the profile that had an error" access="RO" offset="0xAC.0" size="0x0.16" />
	<field name="error_status" descr="When status = ERROR:\;Returned status.\;See Table 188, &quot;EMADs Return Status Summary,&quot; on page 540" access="RO" offset="0xAC.16" size="0x0.7" />
</node>

<node name="ipcr_ext" descr="" size="0xc.0" >
	<field name="dest_pgt_ptr" descr="Destination PGT address pointer" access="OP" offset="0x0.0" size="0x0.16" />
	<field name="source_pgt_ptr" descr="Source PGT address pointer" access="OP" offset="0x4.0" size="0x0.16" />
	<field name="size" descr="Number of entries to copy\;Range 1 .. 2K" access="OP" offset="0x8.0" size="0x0.15" />
</node>

<node name="iper_ext" descr="" size="0x20.0" >
	<field name="profile_index" descr="Profile Index\;Range 0..cap_max_infra_profiles-1" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="entry_index" descr="Entry index" access="INDEX" offset="0x4.0" size="0x0.16" />
	<field name="register_id" descr="Register_ID of the entry\;Reserved when valid=0" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="valid" descr="The entry has a valid value" access="RO" offset="0x8.16" size="0x0.1" />
	<field name="register_fields" descr="First 16B of the register fields\;Reserved when valid=0" access="RO" high_bound="3" low_bound="0" offset="0x10.0" size="0x10.0" />
</node>

<node name="ipfr_ext" descr="" size="0x8.0" >
	<field name="pgt_base_ptr" descr="PGT address base pointer" access="OP" offset="0x0.0" size="0x0.16" />
	<field name="size" descr="Number of entries to flush" access="OP" offset="0x4.0" size="0x0.16" />
</node>

<node name="ipinip_encap_adjacency_ext" descr="" size="0x18.0" >
	<field name="ipip_type" descr="Underlay destination ip type:\;0: IPv4, set by ipv4_udip\;1: IPv6, set by ipv6_ptr\;Note: the type field (IPv4 or IPv6) must match the configuration of the router interface, see protocol field in Table 2989, &quot;Loopback IPinIP Overlay Router Interface Properties Layout&quot;" access="RW" offset="0x0.16" size="0x0.4" />
	<field name="uirif" descr="Underlay Ingress RIF\;Reserved when Spectrum (Gen-1)" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="uirif_v" descr="uirif is valid\;Note: if set then overwrite the RITR uirif for this ECMP entry\;Reserved when Spectrum (Gen-1)" access="RW" offset="0x4.16" size="0x0.1" />
	<field name="tqos_profile" descr="Tunnel QoS profile\;0..cap_max_tqos_profile\;Reserved when Spectrum-1" access="RW" offset="0x4.24" size="0x0.4" />
	<field name="tqos_profile_en" descr="0: Use FW hard-coded value. See more detail in Table 12.13, &quot;Tunnel QoS Profiles,&quot; on page 3052\;1: Use tqos_profile_id" access="OP" offset="0x4.31" size="0x0.1" />
	<field name="ipv4_udip" descr="Underlay ipv4 dip\;Reserved when ipip_type is IPv6" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="ipv6_ptr" descr="Pointer to IPv6 underlay destination ip address\;See Section 14.15.17, &quot;RIPS - Router IP version Six Register&quot;, on page 3305\;For Spectrum: Pointer to KVD linear space, see Appendix A.4.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3813)" access="RW" offset="0xC.0" size="0x0.24" />
</node>

<node name="ipoib_multicast_adjacency_ext" descr="" size="0x18.0" >
	<field name="dlid" descr="Destination local ID.\;For multicast, this is actually mlid - multicast LID." access="RW" offset="0x0.0" size="0x0.16" />
	<field name="sl" descr="Service level" access="RW" offset="0x0.20" size="0x0.4" />
	<field name="tclass" descr="Traffic class" access="RW" offset="0x8.0" size="0x0.8" />
</node>

<node name="ipoib_unicast_with_grh_adjacency_ext" descr="" size="0x18.0" >
	<field name="dlid" descr="Destination local ID" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="sl" descr="Service level" access="RW" offset="0x0.20" size="0x0.4" />
	<field name="my_lid" descr="LID path bits, to be masked by the interface LMC and added to the SLID base configured for the router port." access="RW" offset="0x0.24" size="0x0.7" />
	<field name="dqpn" descr="Destination queue pair number" access="RW" offset="0x4.0" size="0x0.24" />
	<field name="dgid" descr="Destination global ID" access="RW" high_bound="3" low_bound="0" offset="0x8.0" size="0x10.0" />
</node>

<node name="ipoib_unicast_without_grh_adjacency_ext" descr="" size="0x18.0" >
	<field name="dlid" descr="Destination local ID" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="sl" descr="Service level" access="RW" offset="0x0.20" size="0x0.4" />
	<field name="dqpn" descr="Destination queue pair number" access="RW" offset="0x4.0" size="0x0.24" />
	<field name="my_lid" descr="LID path bits, to be masked by the interface LMC and added to the SLID base configured for the router port." access="RW" offset="0x8.0" size="0x0.7" />
</node>

<node name="ipsr_ext" descr="" size="0x14.0" >
	<field name="profile_index" descr="Profile Index\;Range 0..cap_max_infra_profiles-1" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="cap_size" descr="Capability size\;Units of KB." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="current_size" descr="Current size\;Units of KB." access="RO" offset="0xC.0" size="0x0.16" />
	<field name="current_entries" descr="Current number of entries" access="RO" offset="0x10.0" size="0x0.16" />
</node>

<node name="irqr_ext" descr="" size="0xc.0" >
	<field name="resource_id" descr="Resource ID as described by Device Resources, see Appendix A, &quot;Device Resources&quot; (page 3805)" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="resource_value_39_32" descr="Resources capability of this resource_id" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="v" descr="valid:\;0: resource_id has no valid value\;1: resource_id is valid" access="RO" offset="0x4.31" size="0x0.1" />
	<field name="resource_value_31_0" descr="Resources capability of this resource_id" access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="l3_generic_encap_adjacency_ext" descr="" size="0x18.0" >
	<field name="emt_pointer" descr="EMT pointer\;Range: 0 .. cap_max_emts - 1\;See FMTC, FMTE" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="u_ip_ver" descr="Underlay ip version:\;0: IPv4, set by ipv4_udip\;1: IPv6, set by ipv6_ptr\;Note: the u_ip_ver field (IPv4 or IPv6) must match the configuration of the router interface, see protocol field in Table 2989, &quot;Loopback IPinIP Overlay Router Interface Properties Layout&quot;" access="RW" offset="0x0.16" size="0x0.4" />
	<field name="uirif" descr="Underlay Ingress RIF" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="tqos_profile" descr="Tunnel QoS profile\;0..cap_max_tqos_profile \;Reserved when Spectrum" access="RW" offset="0x4.24" size="0x0.4" />
	<field name="ipv4_udip" descr="Underlay ipv4 dip\;Reserved when ipip_type is IPv6" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="ipv6_ptr" descr="Pointer to IPv6 underlay destination ip address\;See Section 14.15.17, &quot;RIPS - Router IP version Six Register&quot;, on page 3305\;For Spectrum: Pointer to KVD linear space, see Section A.4.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3813\;Reserved when ipip_type is IPv4" access="RW" offset="0xC.0" size="0x0.24" />
	<field name="cbset_y_set_en" descr="Enable setting value on cbset_y" access="RW" offset="0x10.0" size="0x0.1" />
	<field name="cbset_x_set_en" descr="Enable setting value on cbset_x" access="RW" offset="0x10.1" size="0x0.1" />
	<field name="cbset_y_select" descr="Select cbset_y:\;Spectrum-2: Range 0..7\;" access="RW" offset="0x10.16" size="0x0.3" />
	<field name="cbset_x_select" descr="Select cbset_x:\;Spectrum-2: Range 0..7\;" access="RW" offset="0x10.24" size="0x0.3" />
	<field name="cbset_y_val" descr="Value for setting cbset_y, if cbset_y_set_en = 1" access="RW" offset="0x14.0" size="0x0.16" />
	<field name="cbset_x_val" descr="Value for setting cbset_x, if cbset_x_set_en = 1" access="RW" offset="0x14.16" size="0x0.16" />
</node>

<node name="lane_2_module_mapping_ext" descr="" size="0x4.0" >
	<field name="module" descr="Module number" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA \;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="RW" offset="0x0.8" size="0x0.4" />
	<field name="tx_lane" descr="TX lane. \;When m_lane_m field is set, this field is ignored (Reserved). \;When rxtx field is cleared, this field is used for RX as well." access="RW" offset="0x0.16" size="0x0.4" />
	<field name="rx_lane" descr="RX lane.\;When m_lane_m field is set, this field is ignored (Reserved). \;When rxtx field is cleared, this field is ignored and RX lane is equal to TX lane." access="RW" offset="0x0.24" size="0x0.4" />
</node>

<node name="learned_mac_lag_notification_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address." access="RO" offset="0x0.0" size="0x0.16" />
	<field name="type_0x6" descr="0x6: Learned_MAC_LAG_Notification - this record \;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RO" enum="Learned_MAC_LAG_Notification=0x6" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID.\;Reserved when Spectrum/-2" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="MAC address." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="fid" descr="Filtering Identifier." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="lag_id" descr="LAGID (pointer into the LAG descriptor table)." access="RO" offset="0xC.0" size="0x0.10" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RO" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Note: exists for a roamed entry, will be type 0 for a learned entry\;Not supported by SwitchX/-2" access="RO" offset="0x1C.24" size="0x0.8" />
</node>

<node name="learned_mac_notification_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address." access="RO" offset="0x0.0" size="0x0.16" />
	<field name="type_0x5" descr="0x5: Learned_MAC_Notification - this record\;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RO" enum="Learned_MAC_Notification=0x5" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID.\;Reserved when Spectrum/-2" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="MAC address." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="fid" descr="Filtering identifier." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="system_port" descr="Unique port identifier for the final destination of the packet." access="RO" offset="0xC.0" size="0x0.16" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RO" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Note: exists for a roamed entry, will be type 0 for a learned entry\;Not supported by SwitchX/-2" access="RO" offset="0x1C.24" size="0x0.8" />
</node>

<node name="learned_unicast_tunnel_fdb_notification_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="type_0xD" descr="0xD:Learned_Unicast_Tunnel_FDB_Notification - this record\;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RO" enum="Learned_Unicast_Tunnel_FDB_Notification=0xd" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID\;Reserved when Spectrum/-2" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="MAC address" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="fid" descr="Filtering ID\;Only FIDs that are from vFID type are valid." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="uip_msb" descr="If protocol is IPv4:\;The underlay source IPv4 of the remote NVE (the most significant bits)\;If protocol is IPv6: reserved" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="uip_lsb" descr="If protocol is IPv4:\;The underlay destination IPV4 of the remote VTEP (the least significant bits)" access="RO" offset="0xC.0" size="0x0.24" />
	<field name="protocol" descr="Protocol:\;0: IPv4\;1: IPv6\;Reserved when Spectrum\;" access="RO" offset="0xC.27" size="0x0.1" />
	<field name="tunnel_port" descr="Tunnel port:\;0: NVE\;1: VPLS\;2: Flex_tunnel0\;3: Flex_tunnel1\;Reserved when Spectrum-1" access="RW" offset="0x10.0" size="0x0.4" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RO" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Note: exists for a roamed entry, will be type 0 for a learned entry\;Not supported by SwitchX/-2" access="RO" offset="0x1C.24" size="0x0.8" />
</node>

<node name="local_action_ext" descr="" size="0x14.0" >
	<field name="trap_id" descr="For Spectrum Trap-ID is RTR_INGRESS0 or RTR_INGRESS1.\;For Spectrum-2/3, Trap-ID is RTR_INGRESS0 .. RTR_INGRESS3.\;For trap_action of NOP, MIRROR and DISCARD_ERROR, trap_id is reserved" access="RW" offset="0x0.0" size="0x0.9" />
	<field name="trap_action" descr="Trap Action\;0: NOP\;1: TRAP\;2: MIRROR_TO_CPU\;3: MIRROR\;4: DISCARD_ERROR, see DISCARD_ROUTER2 trap_id" access="RW" offset="0x0.28" size="0x0.4" />
	<field name="local_erif" descr="Egress Router Interface" access="RW" offset="0x4.0" size="0x0.16" />
</node>

<node name="local_path_ext" descr="" size="0x10.0" >
	<field name="rdq" descr="For asynchronous queue transport: CPU receive descriptor queue for trap group trap_group.\;For packet-flow transport: PRF (packet receive flow).\;\;an RDQ is a PRF if (1) configured by HOPF and (2) not configured by SW2HW_DQ. \;See Table 2.17.5, &quot;HOPF - Host Out-of-Band Packet Flow Register,&quot; on page 645\;See Section 2.16.3.1, &quot;SW2HW_DQ - Software to Hardware DQ&quot;, on page 608" access="RW" offset="0x0.0" size="0x0.6" />
	<field name="cpu_tclass" descr="CPU Ingress Traffic Class for trap group trap_group\;Range is 0.. cap_max_cpu_ingress_tclass-1\;For Switch-IB/2 and for Quantum: Reserved when PRF (packet receive flow)" access="RW" offset="0x0.16" size="0x0.6" />
</node>

<node name="local_span_ext" descr="" size="0x10.0" >
	<field name="tclass" descr="Traffic Class on which the mirrored packet is queued\;For Spectrum: Switch Priority\;Reserved when qos is QoS maintain\;Reserved when system_port is to CPU since HTGT.cpu_tclass is used\;Reserved when imp=1" access="RW" offset="0xC.0" size="0x0.4" />
</node>

<node name="mafbi_entry_auto_ext" descr="" attr_is_union="1" size="0x300.0" >
	<field name="mafbi_entry_type0_ext" descr="" subnode="mafbi_entry_type0_ext" offset="0x0.0" selected_by="entry_type0" size="0x300.0" />
</node>

<node name="mafbi_entry_type0_ext" descr="" size="0x300.0" >
	<field name="record" descr="See Table 1092, &quot;MAFTI - record Layout,&quot; on page 1329" subnode="mafti_record_ext" access="RW" high_bound="63" low_bound="0" offset="0x0.0" size="0x300.0" />
</node>

<node name="mafbi_ext" descr="" size="0x308.0" >
	<field name="num_rec" descr="Number of records\;Range 1..64\;\;" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="type" descr="Type:\;0: entry_type0 - Looks like MAFTI w/o bank_id" access="RO" enum="entry_type0=0x0" offset="0x0.24" size="0x0.2" />
	<field name="entry" descr="See Table 1096, &quot;MAFBI - entry_type0 Layout,&quot; on page 1331" subnode="mafbi_entry_auto_ext" access="RW" offset="0x8.0" size="0x300.0" union_selector="$(parent).type" />
</node>

<node name="mafcr_ext" descr="" size="0xc.0" >
	<field name="clear" descr="Clear counter_accu_overflow counter" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="counter_accu_overflow" descr="Counter of accuflow overflow.\;When system behaves &quot;well&quot; then this counter will always be 0.\;If ((FW polling is too slow) or (HW increment is too high)) then the HW accuflow becomes overflowed. In this case new accuflow counter increments are not counted.\;This counter is stuck at 0xF...FF" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="bytes_inc_units" descr="Bytes inc units\;Units of 1 byte\;Note: this value will change only after boot/ISSU \;\;\;" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="packets_inc_units" descr="Backets inc units\;Units of 1 packet\;Note: this value will change only after boot/ISSU \;\;" access="RO" offset="0x8.16" size="0x0.16" />
</node>

<node name="mafri_ext" descr="" size="0x410.0" >
	<field name="num_rec" descr="Number of records to read\;Range 1..128" access="OP" offset="0x0.0" size="0x0.8" />
	<field name="event" descr="Event generation:\;0: NO_EVENT - Do not generate MAFRI event\;1: EVENTS - Generate MAFRI event\;Note: return of EMAD must be after the MAFRI event!" access="OP" offset="0x0.16" size="0x0.1" />
	<field name="fsf" descr="Flush spill fifo\;0: NO_FLUSH_SPILL\;1: FLUSH_SPILL - will trigger MAFTI events for all relevant spill -fifos\;Note: return of EMAD must be after the MAFTI event! if both fsf and event are set, MAFTI event will be sent before MAFRI event.\;" access="OP" offset="0x0.24" size="0x0.1" />
	<field name="counter_index_base" descr="Counter Index base\;Counters will be read starting at counter_index_base\;Range: cap_start_accuflow .. cap_start_accuflow+cap_max_accuflow - 1\;Note: counter_index_base + num_rec must be equal or lower than cap_max_accuflow" access="OP" offset="0x4.0" size="0x0.24" />
	<field name="user_val" descr="User val:\;Opaque field to be returned on MAFRI trap" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="record" descr="See Table 1102, &quot;MAFRI - record Layout,&quot; on page 1334\;When event = 1, the records will be zero." subnode="mafri_record_ext" access="RW" high_bound="127" low_bound="0" offset="0x10.0" size="0x400.0" />
</node>

<node name="mafri_record_ext" descr="" size="0x8.0" >
	<field name="bytes_inc" descr="Bytes to increment to bytes counter\;Unit of MAFCR.bytes_inc_units\;Note that user needs to add 64B for each packet\;\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="packets_inc" descr="Packets to increment to packets counter\;Unit is MAFCR.packets_inc_units\;" access="RO" offset="0x4.0" size="0x4.0" />
</node>

<node name="mafti_ext" descr="" size="0x308.0" >
	<field name="num_rec" descr="Number of records\;Range 1..64\;\;" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="record" descr="See Table 1092, &quot;MAFTI - record Layout,&quot; on page 1329" subnode="mafti_record_ext" access="RW" high_bound="63" low_bound="0" offset="0x8.0" size="0x300.0" />
</node>

<node name="mafti_record_ext" descr="" size="0xc.0" >
	<field name="counter_index" descr="Counter Index for flow counters.\;Note: different MAFTI records may have the exact same counter_index.\;For Spectrum-2 see Section 5.2, &quot;Flow Counters&quot;, on page 1127" access="RO" offset="0x0.0" size="0x0.24" />
	<field name="bytes_inc" descr="Bytes to increment to bytes counter\;Unit of MAFCR.bytes_inc_units\;Note that user needs to add 64B for each packet\;\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="packets_inc" descr="Packets to increment to packets counter\;Unit is MAFCR.packets_inc_units\;" access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="mbct_ext" descr="" size="0x420.0" >
	<field name="slot_index" descr="Slot index. \;0: Reserved." access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="data_size" descr="actual data field size in bytes for the current data transfer" access="WO" offset="0x4.0" size="0x0.11" />
	<field name="ini_status" descr="ini status\;0: Empty_not_valid\;1: Valid - (Magic Pattern applied)\;2: Ready_to_use\;3: In_use\;Other values are Reserved" access="RO" enum="Empty_not_valid=0x0,Valid=0x1,Ready_to_use=0x2,In_use=0x3" offset="0x4.29" size="0x0.3" />
	<field name="oee" descr="Opcode Event Enable. When set to &apos;1&apos;, an event will be sent once the opcode was executed and the fsm_state has changed. This bit will be cleared once the event was sent." access="WO" offset="0x8.25" size="0x0.1" />
	<field name="last" descr="Indicates that the current data field is the last chunk of the INI." access="WO" offset="0x8.26" size="0x0.1" />
	<field name="op" descr="When the register is used in a &apos;Query&apos; mode, only option 7 (Query Status) is legal.\;0: Reserved\;1: Erase_INI_image\;2: Data_transfer - (download)\;3: Activate\;4: Deactivate\;5: Abort\;6: Clear_Errors\;7: Query_Status\;Other values are Reserved" access="WO" enum="Reserved=0x0,Erase_INI_image=0x1,Data_transfer=0x2,Activate=0x3,Deactivate=0x4,Abort=0x5,Clear_Errors=0x6,Query_Status=0x7" offset="0x8.28" size="0x0.4" />
	<field name="fsm_state" descr="0: Idle\;1: Data_transfer - (download)\;2: Magic_Pattern_Valid\;3: Ready\;4: Erase\;5: INI_in_use\;6: Error\;Other values are Reserved" access="RO" enum="Idle=0x0,Data_transfer=0x1,Magic_Pattern_Valid=0x2,Ready=0x3,Erase=0x4,INI_in_use=0x5,Error=0x6" offset="0xC.16" size="0x0.4" />
	<field name="status" descr="Status\;0: NA\;1: Busy\;2: Partial - partial data transfer completed successfully and ready for next data transfer\;3: Last_data - last data transfer completed, applying magic pattern. \;4: Erase_is_complete\;5: Error_Attempted_Erase_INI_in_use - Trying to erase INI while it being used.\;6: Transfer_failure - (bad data received or write error)\;7: Erase_failure\;8: INI_error\;9: Activation_of_INI_failed\;10: Deactivation_of_INI_failed\;11: Error_Illegal_operation\;Other values are Reserved" access="RO" enum="NA=0x0,Busy=0x1,Partial=0x2,Last_data=0x3,Erase_is_complete=0x4,Error_Attempted_Erase_INI_in_use=0x5,Transfer_failure=0x6,Erase_failure=0x7,INI_error=0x8,Activation_of_INI_failed=0x9,Deactivation_of_INI_failed=0xa,Error_Illegal_operation=0xb" offset="0xC.24" size="0x0.5" />
	<field name="data" descr="Up to 1KB of data." access="WO" high_bound="255" low_bound="0" offset="0x20.0" size="0x400.0" />
</node>

<node name="mbtr_ext" descr="" size="0x8.0" >
	<field name="cmd" descr="Command\;0: Perform_graceful_reset_procedure -  Not supported for query operations. Will return BAD_PARAM.\;1: PVS_tuning_was_set" access="WO" enum="Perform_graceful_reset_procedure=0x0,PVS_tuning_was_set=0x1" offset="0x0.0" size="0x0.8" />
	<field name="status" descr="0: Success\;1: ADC_value_is_out_of_limit\;2: ADC_cant_be_compared_due_to_fuse_not_burned \;3: ADC_cant_be_compared_due_to_invalid_fuse_value\;Valid only if cmd = 1" access="RO" enum="Success=0x0,ADC_value_is_out_of_limit=0x1,ADC_cant_be_compared_due_to_fuse_not_burned=0x2,ADC_cant_be_compared_due_to_invalid_fuse_value=0x3" offset="0x4.0" size="0x0.8" />
</node>

<node name="mcam_reg_ext" descr="" size="0x48.0" >
	<field name="access_reg_group" descr="Access Register ID groups \;0: First_128_REG_ID - Register IDs 0x9001 - 0x907F)\;1: Register_IDs_0x9080 - 0x90FF (bit 0 in mng_access_reg_cap_mask represent register ID 0x9080 while bit 127 represents register ID 0x90FF).\;2: Register_IDs_0x9100 - 0x917F (bit 0 in mng_access_reg_cap_mask represent register ID 0x9100 while bit 127 represents register ID 0x917F).\;3: Register_IDs_0x9180 - 0x91FF (bit 0 in mng_access_reg_cap_mask represent register ID 0x9180 while bit 127 represents register ID 0x91FF)." access="INDEX" enum="First_128_REG_ID=0x0,Register_IDs_0x9080=0x1,Register_IDs_0x9100=0x2,Register_IDs_0x9180=0x3" offset="0x0.0" size="0x0.8" />
	<field name="feature_group" descr="Feature list mask index: \;0: enhanced_features" access="INDEX" enum="enhanced_features=0x0" offset="0x0.16" size="0x0.8" />
	<field name="mng_access_reg_cap_mask" descr="Supported management&apos;s access register bitmask. Based on access_reg_group index. \;When bit is set, the register is supported in the device. \;For example:\;Bit 1: MFCR_0x9001\;Bit 2: MFSC_0x9002\;Bit 3: MFSM_0x9003\;Bit 4: MFSL_0x9004\;Bit 58: MGCR_0x903A\;Bit 73: MPPF_0x9049\;Bit 127: MCAP_0x907F" access="RO" enum="MFCR_0x9001=0x2,MFSC_0x9002=0x4,MFSM_0x9003=0x8,MFSL_0x9004=0x10,MGCR_0x903A=0x4000000,MPPF_0x9049=0x200,MCAP_0x907F=0x80000000" high_bound="3" low_bound="0" offset="0x8.0" size="0x10.0" />
	<field name="mng_feature_cap_mask" descr="Supported port&apos;s enhanced features.Based on feature_group index.\;When bit is set, The feature is supported in the device: \;Bit 0: MPCNT counter group- PCIE performance counters supported\;Bit 1: mtpps_fs - If set, field_select field in MTPPS register is supported.\;Bit 2: mtpps_enhanced_out_periodic_adjustment - If set, enhanced_out_periodic_adjustment field in MTPPS register is supported.\;Bit 3: tx_lossy_overflow_oper - If set, tx_overflow_buffer_pkt counter in MPCNT register is supported.\;Bit 4: pcie_outbound_stalled - if set, outbound_stalled_reads, outbound_stalled_writes, outbound_stalled_reads_events and outbound_stalled_writes_events counters in MPCNT are supported.\;Bit 5: Management pass through is supported\;Bit 6: sensor_map - If set, sensor_map is supported in MTCAP register.\;Bit 7: if set, module_status bit 8 (Module Low Power) in MCION register is supported. \;Bit 8: beacon_capability_disable - If set, beacon feature, as appears in MLCR register, in not supported by the device. \;Bit 9: dynamic_tx_overflow - If set, tx_overflow_sense field is supported in MPEGC register. \;Bit 10: mark_tx_action_cqe is supported if set to &apos;1&apos;.\;Bit 11: mark_tx_action_cnp is supported if set to &apos;1&apos;.\;Bit 12: dev_info is supported in  register is set to &apos;1&apos;.\;Bit 13: sensor_count field is 12bit size in MTMP and MTBR\;Bit 14: cs_tokens_supported is supported \;Bit 15: debug_fw_tokens_supported\;Bit 16: long_keys is supported \;Bit 17: pwr_status and pci_power are supported in MPEIN\;Bit 18: If set, accessing through device_type and device_index is supported in MCC, MCQI and MCQS\;Bit 19: pcie_sync_for_fw_update_supported is set to &apos;1&apos;\;Bit 20: ptpCyc2Realtime_modify - If set, the cycle to realtime translation offload is supported\;Bit 21: If set to &apos;1&apos;, reset_state in MFRL is supported\;Bit 22: If set to &apos;1&apos;, link_peer_max_speed is supported in MPEIN Register\;Bit 23: If set to &apos;1&apos;, slot_index field is supported in: MCIA, MCAS, MCION, MQSP, MTCAP, MTECR, MTMP, MTEWE, MTBR, MVCAP, MVCR, MGPIR, MDDT, MDCR.\;Bit 24: If set, transceiver burn flow is supported in MCC, MCQI and MCQS.\;Bit 26: If set, progress field is supported in MCQS\;Bit 28: If set, number_of_slots field is supported in MGPIR.\;Bit 29: If set, virtual hot plug / unplug is supported in MPEGC.\;Bit 30: If set, my_pf_number is supported in MPPF.\;Bit 31: If set, sdee is supported in MTMP\;Bit 34: If set, MCIA supports 32 D-words. Otherwise, 12 D-words.\;Bit 35: If set, MGIR.hw_info.technology is supported. \;Bit 37: If set, lp_msb is supported for MLCR, MPIR \;Bit 39: If set, MRCS and RMDT tokens are supported in MCQS\;Bit 40: If set, &apos;encryption&apos; field in MGIR is supported\;Bit 43: If set, MFCR supports tacho_active_msb field\;Bit 44: If set, FORE supports fan_under_limit_msb and fan_over_limit_msb fields\;Bit 45: If set, MFRL.pci_rescan_required is supported\;Bit 46: time_adjust_range_extended - if set, the MTUTC.time_adjustment range is extended to -200,000 to +200,000\;Bit 47: If set, MTUTC.freq_adj_units=1 is supported\;Bit 48: If set, MRSR.command=6 is supported\;Bit 49: If set, MCQS.identifier support CRCS and CRDT tokens\;Bit 51: If set, MTUTC.freq_adj_units=2 is supported\;Bit 53: If set, Mlx mlxfwreset with downstream port is supported by FW [Internal]: NIC only, FW rejects reset till user committed that traffic is disabled\;Bit 59: If set, MCC.component_specific_error_code is valid for LinkX devices\;Bit 60: If set, MGNLE.clr is supported\;Bit 61: If set, MGIR supports life_cycle_msb and pds fields in FW info and development field in HW info.\;\;\;Bit 65: If set, MVCR support current_sensor_value_msb\;Bit 66: If set. MFRL supports pci_reset_req_method, pci_switch_exist fields. [DWIP]\;Bit 67: If set, MRSR.cmd = 6 works with SBR" access="RO" high_bound="3" low_bound="0" offset="0x28.0" size="0x10.0" />
</node>

<node name="mcc_reg_ext" descr="" size="0x20.0" >
	<field name="instruction" descr="Command to be executed by the FSM\;0x1: LOCK_UPDATE_HANDLE\;0x2: RELEASE_UPDATE_HANDLE \;0x3: UPDATE_COMPONENT\;0x4: VERIFY_COMPONENT\;0x6: ACTIVATE\;0x7: READ_COMPONENT\;0x8: CANCEL\;0x9: CHECK_UPDATE_HANDLE\;0xA: FORCE_HANDLE_RELEASE\;0xB: READ_PENDING_COMPONENT\;0xC: DOWNSRTEAM_DEVICE_TRANSFER\;Other values are reserved. Applicable for write operation only." access="RW" enum="LOCK_UPDATE_HANDLE=0x1,RELEASE_UPDATE_HANDLE=0x2,UPDATE_COMPONENT=0x3,VERIFY_COMPONENT=0x4,ACTIVATE=0x6,READ_COMPONENT=0x7,CANCEL=0x8,CHECK_UPDATE_HANDLE=0x9,FORCE_HANDLE_RELEASE=0xa,READ_PENDING_COMPONENT=0xb,DOWNSRTEAM_DEVICE_TRANSFER=0xc" offset="0x0.0" size="0x0.8" />
	<field name="activation_delay_sec" descr="This is a configuration that delays the activation of the component in seconds. Relevant only for activate command.\;This configuration is volatile." access="RW" offset="0x0.8" size="0x0.8" />
	<field name="time_elapsed_since_last_cmd" descr="The number of seconds elapsed since the update_handle owner last issued a command. The time saturates at 0xFFF." access="RO" offset="0x0.16" size="0x0.12" />
	<field name="component_index" descr="Index of the accessed component. \;Value from MCQS.component_index\;Valid for \;UPDATE_COMPONENT, ACTIVATE_COMPONENET, READ_COMPONENT and READ_PENDING_COMPONENT instructions. Otherwise, this field is reserved." access="INDEX" offset="0x4.0" size="0x0.16" />
	<field name="update_handle" descr="Token representing the current flow executed by the FSM." access="RW" offset="0x8.0" size="0x0.24" />
	<field name="auto_update" descr="Auto-update to all matching downstream devices is requested." access="WO" offset="0x8.31" size="0x0.1" />
	<field name="control_state" descr="Current Update FSM state\;0x0: IDLE\;0x1: LOCKED\;0x2: INITIALIZE\;0x3: DOWNLOAD\;0x4: VERIFY\;0x5: APPLY\;0x6: ACTIVATE\;0x7: UPLOAD\;0x8: UPLOAD_PENDING\;0x9: DOWNSRTEAM_DEVICE_TRANSFER\;Other values are reserved" access="RO" enum="IDLE=0x0,LOCKED=0x1,INITIALIZE=0x2,DOWNLOAD=0x3,VERIFY=0x4,APPLY=0x5,ACTIVATE=0x6,UPLOAD=0x7,UPLOAD_PENDING=0x8,DOWNSRTEAM_DEVICE_TRANSFER=0x9" offset="0xC.0" size="0x0.4" />
	<field name="error_code" descr="Indicates the successful completion of the instruction, or the reason it failed. \;0x0: OK\;0x1: ERROR\;0x2: REJECTED_DIGEST_ERR\;0x3: REJECTED_NOT_APPLICABLE\;0x4: REJECTED_UNKNOWN_KEY\;0x5: REJECTED_AUTH_FAILED\;0x6: REJECTED_UNSIGNED\;0x7: REJECTED_KEY_NOT_APPLICABLE\;0x8: REJECTED_BAD_FORMAT\;0x9: BLOCKED_PENDING_RESET\;0xA: REJECTED_NOT_A_SECURED_FW\;0xB: REJECTED_MFG_BASE_MAC_NOT_LISTED\;0xC: REJECTED_NO_DEBUG_TOKEN\;0xD: REJECTED_VERSION_NUM_MISMATCH\;0xE: REJECTED_USER_TIMESTAMP_MISMATCH\;0xF: REJECTED_FORBIDDEN_VERSION\;0x10: FLASH_ERASE_ERROR\;0x11: REJECTED_REBURN_RUNNING_AND_RETRY\;0x12: REJECTED_LINKX_TYPE_NOT_SUPPORTED\;0x13: REJECTED_HOST_STORAGE_IN_USE\;0x14: REJECTED_LINKX_TRANSFER (see module index in rejected_device_index)\;0x15: REJECTED_LINKX_ACTIVATE (see module index in rejected_device_index)\;0x16: REJECTED_INCOMPATIBLE_FLASH\;0x17: REJECTED_TOKEN_ALREADY_APPLIED\;0x18: REJECTED_FW_BURN_DRAM_NOT_AVAILABLE\;0x19: FW_BURN_REJECTED_INVALID_SECURITY_VERSION\;0x1A: FW_BURN_REJECTED_CERT_CER509 \;0x1B: FW_BURN_REJECTED_CERT_SIGNATURE\;0x1C: FW_BURN_REJECTED_CERT_METADATA\;0x1D: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_0 \;0x1E: FW_BURN_REJECTED_CERT_NO_PLACE\;0x1F: FW_BURN_REJECTED_CERT_REMOVAL_NO_MATCH_CERT_UIDD\;0x20: FW_BURN_REJECTED_CERTI_INTERNAL_ERROR_1 \;0x21: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_2 0x22: FW_BURN_REJECTED_CERT_OF_NUM_OF_SWAP\;0x23: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_3 \;0x24: FW_BURN_REJECTED_CERT_INTERNAL_ERROR_4 \;0x25: FW_BURN_REJECTED_CERT_NOT_ALLOWED_SAME_CERT_UIDD \;0x26: FW_BURN_REJECTED_CERTIFICATE_INTERNAL_ERROR_5 \;0x27: FW_BURN_REJECTED_CERTIFICATE_INTERNAL_ERROR_6 \;0x28: REJECTED_FLASH_WP\;\;Other values should be treated as an unknown error." access="RO" offset="0xC.8" size="0x0.8" />
	<field name="control_progress" descr="Indicates the estimated progress status of the current operation executed by the FSM. Valid values are 0..100.\;101 indicates that progress reporting is not supported for this update state." access="RO" offset="0xC.16" size="0x0.7" />
	<field name="handle_owner_host_id" descr="For handle_owner_type BMC, command-interface and ICMD, indicates the identifier of the host of the handle owner.\;Otherwise reserved" access="RO" offset="0xC.24" size="0x0.4" />
	<field name="handle_owner_type" descr="Type of entity holding the update handle:\;0x0: unspecified\;0x1: Chassis BMC\;0x2: MAD\;0x3: BMC\;0x4: command interface\;0x5: ICMD \;Other values are reserved." access="RO" offset="0xC.28" size="0x0.4" />
	<field name="component_size" descr="Component size in bytes. \;Valid for UPDATE_COMPONENT instruction. Specifying the size may shorten the update time.\;Value 0x0 means that size is unspecified." access="WO" offset="0x10.0" size="0x4.0" />
	<field name="device_type" descr="Peripheral device type:\;0: Switch_or_NIC\;1: Gearbox" access="INDEX" enum="Switch_or_NIC=0x0,Gearbox=0x1" offset="0x14.0" size="0x0.8" />
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die. \;For cables, the index represents the module index starting at index 1. Index 0 indicates the host device." access="INDEX" offset="0x14.16" size="0x0.12" />
	<field name="device_index_size" descr="In multiple downstream devices action, the action will be executed starting on device_index and ending on device_index + device_index_size - 1." access="RW" offset="0x18.0" size="0x0.12" />
	<field name="rejected_device_index" descr="The device index that the action has been rejected to." access="RO" offset="0x18.16" size="0x0.12" />
	<field name="component_specific_err_code" descr="[DWIP]:\;Component Specific Error Code\;Relevant only for Linkx failed updates" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mcda_reg_ext" descr="" size="0x90.0" >
	<field name="update_handle" descr="Update handle registered when the FSM was activated." access="RW" offset="0x0.0" size="0x0.24" />
	<field name="offset" descr="Offset of accessed address relative to component start. Accesses must be in accordance to log_mcda_word_size in Table 665, &quot;MCQI CAPABILITIES Info Layout,&quot; on page 986" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="size" descr="Size of the data accessed, given in bytes" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="data" descr="Data block accessed" access="RW" high_bound="31" low_bound="0" offset="0x10.0" size="0x80.0" />
</node>

<node name="mcdd_reg_ext" descr="" size="0x20.0" >
	<field name="update_handle" descr="Update handle registered when the FSM was activated." access="RW" offset="0x0.0" size="0x0.24" />
	<field name="offset" descr="Offset of accessed address relative to component start." access="RW" offset="0x4.0" size="0x4.0" />
	<field name="size" descr="Size of the data accessed, given in bytes" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="data_page_phys_addr_msb" descr="Physical address of the FW component data page." access="RW" offset="0x10.0" size="0x4.0" />
	<field name="data_page_phys_addr_lsb" descr="Physical address of the FW component data page." access="RW" offset="0x14.0" size="0x4.0" />
	<field name="mailbox_page_phys_addr_msb" descr="Physical address of the mailbox page." access="RW" offset="0x18.0" size="0x4.0" />
	<field name="mailbox_page_phys_addr_lsb" descr="Physical address of the mailbox page." access="RW" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mcgi_ext" descr="" size="0x34.0" >
	<field name="chassis_slot_index" descr="[DWIP]\;Slot index\;Info provided from the chassis EEPROM (FRU) if exists." access="RO" offset="0x0.0" size="0x0.8" />
	<field name="tray_index" descr="Tray Index\;Info provided from the chassis EEPROM (FRU) if exists. \;In Oberon, valid values 0-8" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="chassis_id" descr="Chassis Id, null terminated string" access="RO" high_bound="3" low_bound="0" offset="0x10.0" size="0x10.0" />
	<field name="chassis_topology_id" descr="Chassis Part Number\;0: Loopback\;1: Oberon-36\;2: Oberon-72\;3-6: Reserved\;7: Other" access="RO" offset="0x30.0" size="0x0.8" />
</node>

<node name="mcia_ext" descr="" size="0x94.0" >
	<field name="status" descr="Module Status\;0: SUCCESS\;1: NO_EEPROM_MODULE. No response from module&apos;s EEPROM.\;2: MODULE_NOT_SUPPORTED. Module type not supported by the device. 3: MODULE_NOT_CONNECTED. No module present indication. \;4: MODULE_TYPE_INVALID - module is not supported by INI. \;\;9: I2C_ERROR. Error occurred while trying to access the module&apos;s EEPROM using I2C.\;16: MODULE_DISABLED - module is disabled \;" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.12" size="0x0.4" />
	<field name="module" descr="Module number\;\;Switch: Range 0 .. MGPIR.max_modules_per_slot -1" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="pnv" descr="[DWIP]:\;Page Number Valid\;0: write page number\;1: don&apos;t write page number\;Valid only if module is in SW control" access="OP" offset="0x0.29" size="0x0.1" />
	<field name="l" descr="Lock Page bit. \;When bit is set, FW can access the last accessed page.\;After boot and ISSU, default value is 0.\;\;" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="device_address" descr="Device address" access="INDEX" offset="0x4.0" size="0x0.16" />
	<field name="page_number" descr="Page number\;Reserved when MCIA.l = 1 or when MCIA.pnv = 1" access="INDEX" offset="0x4.16" size="0x0.8" />
	<field name="i2c_device_address" descr="I2C device address\;" access="INDEX" offset="0x4.24" size="0x0.8" />
	<field name="size" descr="Number of bytes to read/write (up to 128 bytes)" access="INDEX" offset="0x8.0" size="0x0.16" />
	<field name="bank_number" descr="Bank number" access="INDEX" offset="0x8.16" size="0x0.8" />
	<field name="passwd_length" descr="0: password length is 4B (password_msb is reserved)\;1: password length is 8B (password_msb is used)" access="OP" offset="0x8.28" size="0x0.1" />
	<field name="password" descr="The password that is written to the module password field.\;This field is reserved when passwd_cap is not set to 1. \;Reserved when module is in SW control." access="OP" offset="0xC.0" size="0x4.0" />
	<field name="dword" descr="Bytes to read/write\;Note: some FW versions support only 12*4B\;See MCAM bit34" access="RW" high_bound="31" low_bound="0" offset="0x10.0" size="0x80.0" />
	<field name="password_msb" descr="password msb\;Supported only when MCAM bit34 is set\;Supported only when passwd_cap is set\;Reserved when passwd_length = 0" access="RW" offset="0x90.0" size="0x4.0" />
</node>

<node name="mcion_ext" descr="" size="0x18.0" >
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.12" size="0x0.4" />
	<field name="module" descr="Module number\;\;Switch: Range 0 .. MGPIR.max_modules_per_slot -1" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="module_status_bits" descr="Module IO status, as defined by SFF and CMIS:\;Bit 0: Present\;Bit 1: RX_LOS\;Bit 2: TX_Fault\;Bit 6: LPMode\;[DWIP] Bit 7: Interrupt (IntL)\;Bit 8: Low Power Mode Status \;[DWIP] Bit 9: Power Good\;If bit 0 (Present) is clear, all other bits are reserved." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="module_inputs" descr="[DWIP][SwitchOnly]\;Module inputs: \;Bit 0: ResetL - low polarity\;Bit 1: LPMode\;Bit 2: Power Enable\;Reserved when module is controlled by FW" access="RW" offset="0xC.0" size="0x0.4" />
	<field name="module_status_bits_valid" descr="[DWIP][SwitchOnly]\;Module Inputs Valid Bitmask\;Bitmask which mentions the validity of module_inputs fields.\;For each bit, 0 means valid, 1 means not valid.\;For example:\;Bit 0: if set, present bit value is ignored. If cleared, value is valid.\;Bit 1: if set, rx loss value is ignored. when cleared, value is valid and so on for all bits mentioned in module_inputs.\;Reserved when module is controlled by FW" access="RO" offset="0xC.16" size="0x0.16" />
	<field name="module_inputs_mask" descr="[DWIP][SwitchOnly]\;On write commands, indicates which of the bits from module_inputs field are updated. \;For each bit, 0 means bit is valid, 1 means not valid (ignored).\;Reserved on read operations. \;Reserved when module is controlled by FW" access="RW" offset="0x10.0" size="0x0.4" />
</node>

<node name="mcpp_reg_ext" descr="" size="0x10.0" >
	<field name="enoc" descr="Enable Over Current Events\;Enable power policer according to indication of Over Current which is provided by device interface (e.g. OC_WARN pin in Spectrum)\;0 - disable \;1 - enable (default)" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="ent" descr="Enable Temperature Events\;Enable power policer according to high temperature\;0 - disable (default)\;1 - enable" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="hysteresis_temperature" descr="Below this temperature the Temperature Event is cleared. Units are Celsius\;Default 95\;hysteresis_temperature must be lower or equal to warning_temperature\;Reserved when ent = 0" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="warning_temperature" descr="Above this temperature the Temperature Event is set. Units are Celsius\;Default 105\;Reserved when ent = 0" access="RW" offset="0x4.16" size="0x0.8" />
	<field name="wsoc" descr="Warning State due to Over Current Event:\;0 - Yellow_State\;1 - Red_State (default)" access="RW" offset="0x8.30" size="0x0.1" />
	<field name="wst" descr="Warning State due to Temperature Event:\;0 - Yellow_State (default)\;1 - Red_State" access="RW" offset="0x8.31" size="0x0.1" />
	<field name="yellow_state_rate" descr="Port rate at Yellow_State. Units are percentage from Green_State port rate\;Default 50" access="RW" offset="0xC.0" size="0x0.8" />
	<field name="red_state_rate" descr="Port rate at Red_State. Units are percentage from Green_State port rate\;red_state_rate must be lower or equal to yellow_state_rate\;Default 0" access="RW" offset="0xC.16" size="0x0.8" />
</node>

<node name="mcqi_activation_method_ext" descr="" size="0x7c.0" >
	<field name="all_hosts_sync" descr="When set, the operation needed to move the component form ACTIVE_PENDING_RESET to ACTIVE should happen simultaneously on all hosts." access="RO" offset="0x0.0" size="0x0.1" />
	<field name="auto_activate" descr="This component will be ACTIVE or ACTIVE_PENDING_RESET after the APPLY state." access="RO" offset="0x0.1" size="0x0.1" />
	<field name="pending_fw_reset" descr="This component goes to ACTIVE_PENDING_RESET after activation.\;A FW reset will move it to ACTIVE state." access="RO" offset="0x0.2" size="0x0.1" />
	<field name="pending_server_reboot" descr="This component goes to ACTIVE_PENDING_RESET state after activation.\;A server reset (PCIe PERST#), will move it ACTIVE state." access="RO" offset="0x0.3" size="0x0.1" />
	<field name="pending_server_dc_power_cycle" descr="This component goes to ACTIVE_PENDING_RESET state after activation.\;DC power cycle (power cycle of PCI power rails), will move it ACTIVE state." access="RO" offset="0x0.4" size="0x0.1" />
	<field name="pending_server_ac_power_cycle" descr="This component goes to ACTIVE_PENDING_RESET state after activation.\;AC power cycle (power cycle for both PCI power rails and AUX power), will move it ACTIVE state." access="RO" offset="0x0.5" size="0x0.1" />
	<field name="self_activation" descr="When set, the component supports self activation. For cables, please refer to activation_type in LINKX_PROPERTIES data for more details." access="RO" offset="0x0.6" size="0x0.1" />
</node>

<node name="mcqi_cap_ext" descr="" size="0x7c.0" >
	<field name="supported_info_bitmask" descr="Bitmask indicating which info_type(s) are supported for this component. Set bit indicates the property set is supported\;bit 1: VERSION\;bit 5: ACTIVATION_METHOD\;Other bits are reserved. CAPABILITIES set is always supported.\;bit 6: LinkX\;bit 7: Clock Synchronizer\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="component_size" descr="The size of the component given in bytes. Value 0x0 indicates that the size in unknown.\;For some components, size may only be available in the READ_COMPONENT state." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="max_component_size" descr="Maximum size for this component, given in bytes." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="mcda_max_write_size" descr="Maximal write size for MCDA" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="log_mcda_word_size" descr="Log 2 of the access word size in bytes.\;Read and write access must be aligned to the word size. Write access must be done for an integer number of words." access="RO" offset="0xC.28" size="0x0.4" />
	<field name="match_base_guid_mac" descr="The device only accepts updates for this component that explicitly lists its base MAC and/or base GUID" access="RW" offset="0x10.26" size="0x0.1" />
	<field name="check_user_timestamp" descr="A user defined timestamp (MVTS) is active for this component." access="RW" offset="0x10.27" size="0x0.1" />
	<field name="match_psid" descr="PSID is validated for this component update." access="RW" offset="0x10.28" size="0x0.1" />
	<field name="match_chip_id" descr="Chip ID (device_hw_revision) is validated for this component update." access="RW" offset="0x10.29" size="0x0.1" />
	<field name="signed_updates_only" descr="Only signed components are accepted." access="RW" offset="0x10.30" size="0x0.1" />
	<field name="rd_en" descr="When set, this components may be read" access="RO" offset="0x10.31" size="0x0.1" />
</node>

<node name="mcqi_clock_source_properties_ext" descr="" size="0x4.0" >
	<field name="image_version_minor" descr="Image Version Minor Number" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="image_version_major" descr="Image Version Major Number" access="RO" offset="0x0.4" size="0x0.4" />
	<field name="vendor_id" descr="Clock Source Device Vendor Id\;0: Renesas\;1: SiTime 148\;2: SiTime 348\;3: TI\;4-255: Reserved" access="RO" offset="0x0.16" size="0x0.8" />
</node>

<node name="mcqi_linkx_properties_ext" descr="" size="0x7c.0" >
	<field name="fw_image_status_bitmap" descr="Bit 0: Image A is running\;Bit 1: Image A is committed, module boots from image A\;Bit 2: Image A is erased / empty\;Bit 3: Reserved\;Bit 4: Image B is running\;Bit 5: Image B is committed, module boots from image B\;Bit 6: Image B is erased / empty\;Bit 7: Reserved" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="fw_image_info_bitmap" descr="Bit 0: FW image A is present \;Bit 1: FW image B is present\;Bit 2: Factory / boot image is present\;Bits 3-7: Reserved" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="image_a_minor" descr="Image A FW minor version" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="image_a_major" descr="Image A FW major version" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="image_a_subminor" descr="Image A FW subminor number" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="image_b_minor" descr="Image B FW minor version" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="image_b_major" descr="Image B FW major version" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="image_b_subminor" descr="Image B FW subminor number" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="factory_image_minor" descr="Factory / boot image FW minor version" access="RO" offset="0x14.0" size="0x0.8" />
	<field name="factory_image_major" descr="Factory / boot image FW major version" access="RO" offset="0x14.8" size="0x0.8" />
	<field name="factory_image_subminor" descr="Factory / boot image FW subminor number" access="RO" offset="0x18.0" size="0x0.16" />
	<field name="management_interface_protocol" descr="0: Does not support either one of the FW update procedures defined below\;1: SFF-8636 management interface and pseudo-CMIS FW. Update is supported\;2: CMIS 4.0 is implemented" access="RO" offset="0x1C.0" size="0x0.6" />
	<field name="activation_type" descr="0: HW reset is required. Host should be prepared to power cycle a cable after sending a RunFWImage command.\;1: Self-activation with HW reset contained in the RunFWImage command. No additional actions required from the host.\;2:Self-activation with hitless reset contained in the RunFWImage command. No additional actions required from the host.\;3-15: Reserved" access="RO" offset="0x1C.10" size="0x0.4" />
	<field name="vendor_sn" descr="Vendor Serial Number" access="RO" offset="0x20.0" size="0x0.16" />
</node>

<node name="mcqi_reg_data_auto_ext" descr="" attr_is_union="1" size="0x7c.0" >
	<field name="mcqi_cap_ext" descr="" subnode="mcqi_cap_ext" offset="0x0.0" selected_by="CAPABILITIES" size="0x7c.0" />
	<field name="mcqi_version_ext" descr="" subnode="mcqi_version_ext" offset="0x0.0" selected_by="VERSION" size="0x7c.0" />
	<field name="mcqi_activation_method_ext" descr="" subnode="mcqi_activation_method_ext" offset="0x0.0" selected_by="ACTIVATION_METHOD" size="0x7c.0" />
	<field name="mcqi_linkx_properties_ext" descr="" subnode="mcqi_linkx_properties_ext" offset="0x0.0" selected_by="LINKX_PROPERTIES" size="0x7c.0" />
	<field name="mcqi_clock_source_properties_ext" descr="" subnode="mcqi_clock_source_properties_ext" offset="0x0.0" selected_by="CLOCK_SOURCE_PROPERTIES" size="0x4.0" />
</node>

<node name="mcqi_reg_ext" descr="" size="0x94.0" >
	<field name="component_index" descr="Component index gathered by &quot;MCQS - Management Component Query Status&quot;" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die. \;For cables, the index represents the module index starting at index 1. Index 0 indicates the host device.\;\;For Clock Source EEPROM, the index represents the Clock Source Index, starting from 1" access="INDEX" offset="0x0.16" size="0x0.12" />
	<field name="read_pending_component" descr="When set, the register will return information about the pending component (if available)" access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="device_type" descr="Peripheral device type:\;0: Switch / NIC\;1: Gearbox" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="info_type" descr="Component properties set.\;0x0: CAPABILITIES\;0x1: VERSION\;0x5: ACTIVATION_METHOD\;0x6: LINKX_PROPERTIES\;0x7: CLOCK_SOURCE_PROPERTIES\;Other values are reserved" access="RW" enum="CAPABILITIES=0x0,VERSION=0x1,ACTIVATION_METHOD=0x5,LINKX_PROPERTIES=0x6,CLOCK_SOURCE_PROPERTIES=0x7" offset="0x8.0" size="0x0.5" />
	<field name="info_size" descr="Properties set structure size, given in bytes." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="offset" descr="The requested/returned data offset from the section start, given in bytes.\;Must be DWORD aligned.\;If offset is invalid, FW will return an error." access="RW" offset="0x10.0" size="0x4.0" />
	<field name="data_size" descr="The requested/returned data size, given in bytes.\;If data_size is not DWORD aligned, the last bytes are zero padded.\;If size is invalid, FW will return an error." access="RW" offset="0x14.0" size="0x0.16" />
	<field name="data" descr="Properties set structure according to info_type.\;CAPABILITIES - See Table 665, &quot;MCQI CAPABILITIES Info Layout,&quot; on page 986\;VERSION - See Table 667, &quot;MCQI VERSION Info Layout,&quot; on page 988\;ACTIVATION_METHOD - See Table 671, &quot;MCQI ACTIVATION_METHOD Info Layout,&quot; on page 990\;LINKX_PROPERTIES - See Table 673, &quot;MCQI LINKX_PROPERTIES Info Layout,&quot; on page 991\;CLOCK_SOURCE_PROPERTIES - See Table 675, &quot;MCQI CLOCK_SOURCE_PROPERTIES Layout,&quot; on page 993" subnode="mcqi_reg_data_auto_ext" access="RO" offset="0x18.0" size="0x7c.0" union_selector="$(parent).info_type" />
</node>

<node name="mcqi_version_ext" descr="" size="0x7c.0" >
	<field name="version_string_length" descr="" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="user_defined_time_valid" descr="When set, the component has a valid user-defined version time-stamp in user_defined_time" access="RW" offset="0x0.28" size="0x0.1" />
	<field name="build_time_valid" descr="When set, the component has a valid creation time-stamp in build_time" access="RW" offset="0x0.29" size="0x0.1" />
	<field name="version" descr="Version number" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="build_time" descr="Time of component creation. Valid only if build_time_valid is set. See Table 669, &quot;Date-Time Layout,&quot; on page 990" subnode="date_time_layout_ext" access="RW" offset="0x8.0" size="0x8.0" />
	<field name="user_defined_time" descr="User-defined time assigned to the component version. Valid only if user_defined_time_valid is set. See Table 669, &quot;Date-Time Layout,&quot; on page 990" subnode="date_time_layout_ext" access="RW" offset="0x10.0" size="0x8.0" />
	<field name="build_tool_version" descr="Build tool version number.\;Valid only when not equal to 0" access="RW" offset="0x18.0" size="0x4.0" />
	<field name="version_string" descr="NULL terminated string representing the version." access="RW" high_bound="91" low_bound="0" offset="0x20.24" size="0x5c.0" />
</node>

<node name="mcqs_reg_ext" descr="" size="0x10.0" >
	<field name="component_index" descr="Component Index. Values range from 0 to the last component indicated by last_index_flag." access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die. \;For cables, the index represents the module index starting at index 1. Index 0 indicates the host device.\;For Clock synchronizer, index is used to represent the clock sync&apos; device index. Starting from 1." access="INDEX" offset="0x0.16" size="0x0.12" />
	<field name="last_index_flag" descr="When set, this component is the last component (highest component_index)." access="RO" offset="0x0.31" size="0x0.1" />
	<field name="identifier" descr="This field uniquely identifies a specific component type. \;0x1: BOOT_IMG\;0x4: OEM_NVCONFIG\;0x5: MLNX_NVCONFIG\;0x6: CS_TOKEN\;0x7: DBG_TOKEN\;0xA: Gearbox\;0xB: CC_ALGO - Congestion Control Algorithm\;0xC: LINKX_IMG\;0xD: CRYPTO_TO_COMMISSIONING\;0xE: RMCS_TOKEN\;0xF: RMDT_TOKEN\;0x10: CRCS_TOKEN. \;0x11: CRDT_TOKEN. \;0x12: CLOCK_SYNC_EEPROM.  \;\;Other values are reserved" access="RO" enum="BOOT_IMG=0x1,OEM_NVCONFIG=0x4,MLNX_NVCONFIG=0x5,CS_TOKEN=0x6,DBG_TOKEN=0x7,Gearbox=0xa,CC_ALGO=0xb,LINKX_IMG=0xc,CRYPTO_TO_COMMISSIONING=0xd,RMCS_TOKEN=0xe,RMDT_TOKEN=0xf,CRCS_TOKEN_=0x10,CRDT_TOKEN_=0x11,CLOCK_SYNC_EEPROM_=0x12" offset="0x4.0" size="0x0.16" />
	<field name="component_update_state" descr="Component state in update flow\;0x0: IDLE\;0x1: IN_PROGRESS\;0x2: APPLIED\;0x3: ACTIVE \;0x4: ACTIVE_PENDING_RESET\;0x5: FAILED\;0x6: CANCELED\;0x7: BUSY\;\;Other values are reserved" access="RO" enum="IDLE=0x0,IN_PROGRESS=0x1,APPLIED=0x2,ACTIVE=0x3,ACTIVE_PENDING_RESET=0x4,FAILED=0x5,CANCELED=0x6,BUSY=0x7" offset="0x8.0" size="0x0.4" />
	<field name="component_status" descr="The status of the component:\;0x0: NOT_PRESENT - The component is supported by the device but, currently not present\;0x1: PRESENT - This component is present. For downstream devices link LinkX component, this is an indication that the binary image is present at the host device memory.\;0x2: IN_USE - The component is present and currently in use." access="RO" enum="NOT_PRESENT=0x0,PRESENT=0x1,IN_USE=0x2" offset="0x8.4" size="0x0.5" />
	<field name="progress" descr="Progress in percentage (from 0 to 100). This field is only relevant for cables." access="RO" offset="0x8.9" size="0x0.7" />
	<field name="device_type" descr="Peripheral device type:\;0: Switch_or_NIC\;1: Gearbox" access="INDEX" offset="0xC.0" size="0x0.8" />
	<field name="last_update_state_changer_host_id" descr="For last_update_state_changer_type BMC, command-interface and ICMD, indicates the identifier of the host of the handle owner. Otherwise reserved." access="RO" offset="0xC.24" size="0x0.4" />
	<field name="last_update_state_changer_type" descr="Indicates which entity was the last to change the component_update_state of this component.\;0x0: unspecified\;0x1: Chassis_BMC\;0x2: MAD\;0x3: BMC\;0x4: command_interface\;0x5: ICMD\;\;Other values are reserved" access="RO" enum="unspecified=0x0,Chassis_BMC=0x1,MAD=0x2,BMC=0x3,command_interface=0x4,ICMD=0x5" offset="0xC.28" size="0x0.4" />
</node>

<node name="mdcr_ext" descr="" size="0x60.0" >
	<field name="device_type" descr="Peripheral device type\;1: XM" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="device_index" descr="Device number \;For gearboxes, the index represents the gearbox die." access="INDEX" offset="0x4.0" size="0x0.12" />
	<field name="device_status_data" descr="Device initialization Data. \;For XM status, see Table 876, &quot;MDCR - XM Data Layout,&quot; on page 1125" subnode="mdcr_xm_data_ext" access="RO" offset="0x10.0" size="0x50.0" />
</node>

<node name="mdcr_xm_data_ext" descr="" size="0x50.0" >
	<field name="xm_status" descr="XM load status.\;0: Pending\;1: No connection (At least 1 of the two Ethernet ports is not up)\;2: Version mismatch (major and minor are different from major_expected and minor_expected)\;3: Loaded successfully" access="RO" offset="0x0.20" size="0x0.4" />
	<field name="xm_major" descr="XM major version" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="xm_minor" descr="XM minor version" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="xm_build_id" descr="XM build ID" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="xm_expected_major" descr="XM expected major version" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="xm_expected_minor" descr="XM expected minor version" access="RO" offset="0x14.0" size="0x0.16" />
</node>

<node name="mddc_ext" descr="" size="0x30.0" >
	<field name="slot_index" descr="Slot index\;0: Reserved" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="index" descr="Index related to the specific granularity type.\;For level = 0, this field is neglected" access="INDEX" offset="0x0.9" size="0x0.8" />
	<field name="level" descr="Granularity of control and configuration.\;0: Configurations per line card \;1: Configuration per device\;2-15: Reserved" access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="device_enable" descr="When set, FW is the manager and allowed to program the Downstream Device." access="RW" offset="0x4.28" size="0x0.1" />
	<field name="rst" descr="Reset request\;0: No reset\;1: Soft Reset\;2-7: Reserved" access="OP" offset="0x4.29" size="0x0.3" />
</node>

<node name="mddq_data_auto_ext" descr="" attr_is_union="1" size="0x20.0" >
	<field name="mddq_slot_info_ext" descr="" subnode="mddq_slot_info_ext" offset="0x0.0" selected_by="slot_info" size="0x20.0" />
	<field name="mddq_device_info_ext" descr="" subnode="mddq_device_info_ext" offset="0x0.0" selected_by="device_info" size="0x20.0" />
	<field name="mddq_slot_name_ext" descr="" subnode="mddq_slot_name_ext" offset="0x0.0" selected_by="slot_name" size="0x20.0" />
</node>

<node name="mddq_device_info_ext" descr="" size="0x20.0" >
	<field name="device_index" descr="Device index\;The first device should number 0" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="flash_id" descr="The flash ID that the device is using." access="RO" offset="0x0.16" size="0x0.8" />
	<field name="lc_pwr_on" descr="If set to &apos;1&apos;, the fields related to the device are valid since the line-card is powered on and plugged and matching the INI version. \;Note: this bit is not an indication to validity of the fields related to the specific FW capabilities and version." access="RO" offset="0x0.28" size="0x0.1" />
	<field name="thermal_sd" descr="Thermal Shutdown. If set, the device was shut down due to thermal event." access="RO" offset="0x0.29" size="0x0.1" />
	<field name="flash_owner" descr="If set to &apos;1&apos;, the device is the flash owner. Otherwise, a shared flash is used by this device (another device is the flash owner)." access="RO" offset="0x0.30" size="0x0.1" />
	<field name="uses_flash" descr="If set, the device uses a flash" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="device_type" descr="0: Amos Gearbox\;1: Abir Gearbox" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="fw_major" descr="Major FW version number. Valid only after the FW is burnt. Otherwise, the value should be &apos;0&apos;." access="RO" offset="0x4.16" size="0x0.16" />
	<field name="fw_sub_minor" descr="Sub-minor FW version number. Valid only after the FW is burnt. Otherwise, the value should be &apos;0&apos;." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="fw_minor" descr="Minor FW version number. Valid only after the FW is burnt. Otherwise, the value should be &apos;0&apos;." access="RO" offset="0x8.16" size="0x0.16" />
	<field name="max_cmd_write_size_supp" descr="Maximum write size (in D-Words) that the device supports for its PRM commands." access="RO" offset="0xC.0" size="0x0.8" />
	<field name="max_cmd_read_size_supp" descr="Maximum read size (in D-Words) that the device supports for its PRM commands." access="RO" offset="0xC.8" size="0x0.8" />
	<field name="device_type_name" descr="Device type ASCII name. Up to 8 chars\;" access="RO" high_bound="7" low_bound="0" offset="0x10.24" size="0x8.0" />
</node>

<node name="mddq_ext" descr="" size="0x30.0" >
	<field name="slot_index" descr="Slot index\;0: Reserved" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="query_type" descr="0: Reserved\;1: slot_info\;2: device_info - for a device on the slot. If there are no devices on the slot, data_valid will be &apos;0&apos;.\;3: slot_name - Name of the slot (string)" access="INDEX" enum="Reserved=0x0,slot_info=0x1,device_info=0x2,slot_name=0x3" offset="0x0.16" size="0x0.8" />
	<field name="sie" descr="Slot info event enable\;When set to &apos;1&apos;, each change in the MDDQ.slot_info.provisioned / sr_valid / active / ready will generate an DSDSC event." access="RW" offset="0x0.31" size="0x0.1" />
	<field name="request_message_sequence" descr="Request message sequential number. \;The first message number should be 0" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="response_message_sequence" descr="Response message sequential number. \;For a specific request, the response message sequential number is the following one. \;In addition, the last message should be 0." access="RO" offset="0x4.16" size="0x0.8" />
	<field name="query_index" descr="Index related to the specific query_type. \;For query_type = 1,2,3 this field is neglected." access="INDEX" offset="0x8.0" size="0x0.8" />
	<field name="data_valid" descr="If set, the data in the data field is valid and contain the information for the queried index. \;Note: This field is not reflecting any validity of the data while accessing a non-existing query entity. Querying with an out of range index will lead to BAD_PARAM status of the register." access="RO" offset="0x8.31" size="0x0.1" />
	<field name="data" descr="Properties of that field are based on query_type.\;For slot information query_type data - see Table 568, &quot;MDDQ slot_info Layout,&quot; on page 911\;For devices on slot query_type data - see Table 570, &quot;MDDQ device_info Register Layout,&quot; on page 912\;For slot name query_type data - see Table 572, &quot;MDDQ slot_name Layout,&quot; on page 914" subnode="mddq_data_auto_ext" access="RO" offset="0x10.0" size="0x20.0" union_selector="$(parent).query_type" />
</node>

<node name="mddq_slot_info_ext" descr="" size="0x20.0" >
	<field name="active" descr="If set, the FW has completed the MDDC.device_enable command" access="RO" offset="0x0.27" size="0x0.1" />
	<field name="lc_ready" descr="If set, the LC is powered on, matching the INI version and a new FW version can be burnt (if necessary)\;0: Not ready\;1: Ready\;2: Error\;3: Reserved" access="RO" offset="0x0.28" size="0x0.2" />
	<field name="sr_valid" descr="If set, Shift Register is valid (after being provisioned) and data can be sent from the switch ASIC to the line-card CPLD over Shift-Register." access="RO" offset="0x0.30" size="0x0.1" />
	<field name="provisioned" descr="If set, the INI file is ready and the card is provisioned" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="ini_file_version" descr="User-configured version number of the current INI file.\;Valid only when active or lc_ready are &apos;1&apos;." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="hw_revision" descr="HW revision of the line-card as it appears in the current INI file.\;Valid only when active or lc_ready are &apos;1&apos;." access="RO" offset="0x4.16" size="0x0.16" />
	<field name="card_type" descr="Card type\;0x00: Buffalo 4x400G\;0x01: Buffalo 8x200G\;0x02: Buffalo 16x100G\;" access="RO" offset="0x8.0" size="0x0.8" />
</node>

<node name="mddq_slot_name_ext" descr="" size="0x20.0" >
	<field name="slot_ascii_name" descr="Slot&apos;s ASCII name. Up to 20 chars\;" access="RO" high_bound="19" low_bound="0" offset="0x0.24" size="0x14.0" />
</node>

<node name="mddt_reg_ext" descr="" size="0x110.0" >
	<field name="device_index" descr="Device index" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="slot_index" descr="Slot index" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="type" descr="0: PRM_Register\;1: Command\;2: CrSpace_access" access="OP" enum="PRM_Register=0x0,Command=0x1,CrSpace_access=0x2" offset="0x4.0" size="0x0.2" />
	<field name="write_size" descr="Write size in D-Words." access="OP" offset="0x4.16" size="0x0.8" />
	<field name="read_size" descr="Read size in D-Words." access="OP" offset="0x4.24" size="0x0.8" />
	<field name="payload" descr="Payload\;For PRM Register type payload - See Table 560, &quot;PRM Register Payload Layout,&quot; on page 907\;For Command type payload - See Table 562, &quot;Command Payload Layout,&quot; on page 907\;For CrSpace type payload - See Table 564, &quot;CrSpace access Payload Layout,&quot; on page 908" subnode="mddt_reg_payload_auto_ext" access="RW" offset="0xC.0" size="0x104.0" union_selector="$(parent).type" />
</node>

<node name="mddt_reg_payload_auto_ext" descr="" attr_is_union="1" size="0x104.0" >
	<field name="prm_register_payload_ext" descr="" subnode="prm_register_payload_ext" offset="0x0.0" selected_by="PRM_Register" size="0x104.0" />
	<field name="command_payload_ext" descr="" subnode="command_payload_ext" offset="0x0.0" selected_by="Command" size="0x104.0" />
	<field name="crspace_access_payload_ext" descr="" subnode="crspace_access_payload_ext" offset="0x0.0" selected_by="CrSpace_access" size="0x104.0" />
</node>

<node name="mdfcr_reg_ext" descr="" size="0x60.0" >
	<field name="device_type" descr="Peripheral device type\;1: Vega_Gearbox\;2: Tile" access="INDEX" enum="Vega_Gearbox=0x1,Tile=0x2" offset="0x0.0" size="0x0.8" />
	<field name="device_index" descr="Device number \;For gearboxes, the index represents the gearbox die." access="INDEX" offset="0x4.0" size="0x0.12" />
	<field name="all" descr="All devices are selected and device_index is ignored\;When set to &apos;1&apos;, the fw_status should represent the worst case of any of the devices. fw_version, build_id, major and minor should be of device number 0." access="INDEX" offset="0x4.31" size="0x0.1" />
	<field name="first_fw_status_device" descr="The first device representing the fw_status" access="RO" offset="0xC.0" size="0x0.12" />
	<field name="fw_status" descr="FW load status.\;0: No errors, FW has loaded successfully. \;1: Flash error. \;2: FW load error. 15: Not ready yet for displaying the status." access="RO" offset="0xC.20" size="0x0.4" />
	<field name="expected_fw_version" descr="Expected FW version" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="fw_version" descr="FW version" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="build_id" descr="FW build ID" access="RO" offset="0x18.0" size="0x0.16" />
	<field name="major" descr="FW major version" access="RO" offset="0x1C.0" size="0x0.8" />
	<field name="minor" descr="FW minor version" access="RO" offset="0x20.0" size="0x0.8" />
	<field name="error_id" descr="FW burning status error.\;\;1: no_errors\;2: error_in_total_size\;3: error_in_iRAM_size_read\;4: error_in_DRAM_size_read\;5: SPI_read_from_EEPROM_time-out\;6: CRC_on_downloaded_EEPROM_content\;7: Download_process_is_on-going\;8: SPI_reset_time-out\;9: memory_protection\;10: unknown_parameter_was_received_by_bootloader \;11: invalid_message_was_received_by_bootloader\;12: message_was_aborted_by_host\;\;Values from 13-32 are reserved" access="RO" enum="no_errors=0x1,error_in_total_size=0x2,error_in_iRAM_size_read=0x3,error_in_DRAM_size_read=0x4,SPI_read_from_EEPROM_time=0x5,CRC_on_downloaded_EEPROM_content=0x6,Download_process_is_on=0x7,SPI_reset_time=0x8,memory_protection=0x9,unknown_parameter_was_received_by_bootloader=0xa,invalid_message_was_received_by_bootloader=0xb,message_was_aborted_by_host=0xc" offset="0x24.11" size="0x0.5" />
</node>

<node name="mdir_reg_ext" descr="" size="0x40.0" >
	<field name="device_id" descr="Device ID" access="RO" high_bound="7" low_bound="0" offset="0x0.0" size="0x20.0" />
</node>

<node name="mdrcr_ext" descr="" size="0x30.0" >
	<field name="device_type" descr="Peripheral device type\;1: Gearbox\;" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="device_index" descr="Device number \;For gearboxes, the index represents the gearbox die." access="INDEX" offset="0x4.0" size="0x0.12" />
	<field name="all" descr="All devices are selected and device_index is ignored\;When set to &apos;1&apos;, the rst_status should represent the worst case of any of the devices." access="INDEX" offset="0x4.31" size="0x0.1" />
	<field name="rst_op" descr="Reset Operation.\;0: Query of the reset status which is displayed through rst_status.\;1: Full Reset of the selected device(s).\;2-8: Reserved." access="RW" offset="0xC.0" size="0x0.3" />
	<field name="rst_status" descr="Reset status.\;0: Reset completed successfully. 1: Reset operation has not finished yet." access="RO" offset="0xC.16" size="0x0.4" />
</node>

<node name="mdri_ext" descr="" size="0x120.0" >
	<field name="clear" descr="Per bit:\;Bit 0: clear global_reasons\;Bit 1: clear port_reasons\;Bit 2: clear buffer_reasons\;Bit 3: clear ethernet_reasons\;Bit 4: clear ip_reasons\;Bit 5: clear mpls_reasons\;Bit 6: clear tunnel_reasons\;Bit 7: clear host_reasons" access="OP" offset="0x0.0" size="0x0.8" />
	<field name="read" descr="Per bit:\;Bit 0: read global_reasons\;Bit 1: read port_reasons\;Bit 2: read buffer_reasons\;Bit 3: read ethernet_reasons\;Bit 4: read ip_reasons\;Bit 5: read mpls_reasons\;Bit 6: read tunnel_reasons\;Bit 7: read host_reasons" access="OP" offset="0x4.0" size="0x0.8" />
	<field name="global_reasons" descr="Bit0: TCAM ECC Error (had a correctable ECC error)\;Bit1: no egress port (e.g. MC group is empty, port-isolation)\;\;Bit3: MAFCR.counter_accu_overflow was incremented (this is not a discard, but it&apos;s a bad behavior), [Spectrum-5] reserved in Spectrum-5 onwards." access="RO" high_bound="7" low_bound="0" offset="0x20.0" size="0x20.0" />
	<field name="port_reasons" descr="Bit0: receive buffer overflow\;\;Bit1: egress mtu error" access="RO" high_bound="7" low_bound="0" offset="0x40.0" size="0x20.0" />
	<field name="buffer_reasons" descr="Bit0: sll" access="RO" high_bound="7" low_bound="0" offset="0x60.0" size="0x20.0" />
	<field name="ethernet_reasons" descr="Bit0: smac is mc\;Bit1: smac equal dmac\;Bit2: invalid ethertype (0x05DC &lt; ethertype &lt; 0x600)Bit3: ingress spanning tree\;Bit4: fdb_miss, same as trap_id FDB_MISS\;Bit5: fdb_mismatch, same as trap_id FDB_MISMATCH\;Bit6: fid miss, same as trap_id FID_MISS" access="RO" high_bound="7" low_bound="0" offset="0x80.0" size="0x20.0" />
	<field name="ip_reasons" descr="Bit0: packet to router is not ip/mpls/arp (no ip header)\;Bit1: disabled irif \;Bit2: uc dip over mc or bc mac\;Bit3: dip is loopback address \;for ipv6: (dip==::1/128) || (dip==0:0:0:0:0:ffff:7f00:0/104)\;for ipv4: dip==127.0.0.0/8\;Bit4: sip is mc \;for ipv6: (SIP == FF00::/8)\;for ipv4: (SIP == 224.0.0.0: 239.255.255.255 aka 224.0.0.0/4)\;Bit5: sip is in class e\;(pkt is ipv4) &amp;&amp; (sip == 240.0.0.0/4) &amp;&amp; (sip != 255.255.255.255)\;Bit6: sip is loopback\;for ipv6: sip == ::1/128\;for ipv4: sip == 127.0.0.0/8\;Bit7: sip is unspecified\;for ipv6: sip == ::0\;for ipv4: sip == 0.0.0.0/32\;Bit8: ip header not okay (IPVer, checksum, IHL)Bit9: mc mac mismatch\;\;Bit10: sip equal dip\;Bit11: ipv4 sip is limited broadcast\;Bit12: lpm no route uc ipv4\;Bit13: lpm no route uc ipv6\;Bit14: uc dip is link local, same as trap_id&apos;s DISCARD_ING_ROUTER_DIP_LINK_LOCAL, IPV6_LINK_LOCAL_DEST\;Bit15: sip is link local, same as trap_id&apos;s DISCARD_ING_ROUTER_SIP_LINK_LOCAL, IPV6_LINK_LOCAL_SRC\;Bit16: mc egress mtu aggregated\;Bit17: mc RPF \;Bit18: uc RPF Bit20: IPv4 dip is limited broadcast (dip==bc)\;Bit21: IPv4 dip is local network (dip == 0.0.0.0/8)\;Bit22: NVE packet to overlay router \;\;Bit23: mc dip over uc mac\;Bit24: mc dip is link local, same as trap_id: LOCALNETWORK, IPV6_MC_LINK_LOCALDEST\;Bit25: ingress MTU (this check is configured as forward)\;Bit26: mc egress mtu, (both for UC and for MC, MPLS)\;Bit29: ttl_error, same as trap_id TTLERROR\;Bit30: disabled erif \;\;Bit31: host miss ipv4, same as trap_id HOST_MISS_IPV4\;Bit32: host miss ipv6, same as trap_id HOST_MISS_IPV6\;Bit33: loopback error, same as trap_id LBERROR\;Bit34: ipv6 dip is unspecified, dip==::0/128, same as trap_id" access="RO" high_bound="7" low_bound="0" offset="0xA0.0" size="0x20.0" />
	<field name="mpls_reasons" descr="Bit0: outer label is not valid\;\;Bit1: no IP after decap (or after php)\;\;Bit3: mpls uc Ethertype (0x8847) over mc or bc mac\;Bit4: mpls mc Ethertype over not allowed mac\;Bit5: MPLS min ingress label allowed (label too low)\;Bit6: MPLS max ingress label allowed (label too high)\;Bit7: ReservedBit8: php decap and no ip header or ip header is not okay\;\;Bit9: ilm miss, same as trap_id MPLS_ILM_MISS\;Bit10: mpls loopback filter" access="RO" high_bound="7" low_bound="0" offset="0xC0.0" size="0x20.0" />
	<field name="tunnel_reasons" descr="Bit0: decap_encap_prevention - same as trap_id DECAP_ENCAP\;Bit1: ipip_tunnel_loop \;\;Bit2: reserved\;\;Bit3: ipip_decap_error - same as trap_id IPIP_DECAP_ERROR\;Bit4: ipip_error - same as trap_id IPIP_ERROR. For Spectrum-2 catches nothing \;Bit7: nve_decap_frag_error - same as trap_id NVE_DECAP_FRAG_ERROR\;Bit8: overlay_port_isolation - see TNIFR\;\;Bit10: overlay_smac_is_mc\;Bit11: overlay_smac_equal_dmac\;Bit12: overlay_is_too_short - (decap remains with short packet) - also catches VLAN removal. Only for Spectrum-1/2/3. \;Bit13: decap_underlay_is_too_long - (decap of more than 126 bytes)\;\;Bit14: nve_decap_error - same as trap_id NVE_DECAP _TAG_ERROR\;Bit15: decap_ecn - same as trap_id DECAP_ECN0, DECAP_ECN1\;" access="RO" high_bound="7" low_bound="0" offset="0xE0.0" size="0x20.0" />
	<field name="host_reasons" descr="Bit0: tx_base_header_is_wrong - (version or base type)\;Bit1: tx_base_header_system_port_is_out_of_range" access="RO" high_bound="7" low_bound="0" offset="0x100.0" size="0x20.0" />
</node>

<node name="mdsr_reg_ext" descr="" size="0x30.0" >
	<field name="status" descr="0: The debug session ended successfully\;1: Failed to execute the operation. See additional_info for more details.\;2: Debug session active. See type_of_token for more details.\;3: No token applied\;4: Challenge provided, no token installed yet, see type_of_token for details.\;5: Timeout before token installed, see type_of_token for details\;6: Timeout of active token.\;7-15: Reserved\;\;Note: Status might be &apos;0&apos; even when debug query is not allowed and additional_info field will expose the reason." access="RO" offset="0x0.0" size="0x0.4" />
	<field name="additional_info" descr="0: No additional information available \;1: There is no debug session in progress\;2: FW is not secured, debug session cannot be ended\;3: Fail - Debug end request cannot be accepted. \;4: Fail - Host is not allowed to query debug session\;5: Debug session active" access="RO" offset="0x0.8" size="0x0.6" />
	<field name="type_of_token" descr="0: CS token \;1: Debug FW token \;2: FRC token \;3: RMCS token\;4: RMDT token \;5: CRCS token \;6: CRDT token" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="end" descr="Set to &apos;1&apos; to end debug session.\;Setting to &apos;0&apos; will not trigger any operation." access="WO" offset="0x4.31" size="0x0.1" />
	<field name="time_left" descr="Time left in seconds.\;In case that status is 2 (debug session active) - time left for token operation\;In case that status is 4 (challenge provided, no token installed yet) - time left for token installation\;For any other status, field should be zero" access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="meccc_ext" descr="" size="0x14.0" >
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="device_index" descr="Device index\;For gearboxes, the index represents the gearbox die" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="clr" descr="Clear counters\;" access="OP" offset="0x4.0" size="0x0.1" />
	<field name="ecc_crt_cnt" descr="ECC Correctable Counter\;Counter increments 1 time per each SRAM (including TCAM) which had 1 or more ECC correctable events. \;Cleared at: (1) reset (including soft_reset), (2) clear bit\;Counts from: (1) main, (2) all tiles" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="ecc_ucrt_cnt" descr="ECC Uncorrectable Counter\;Cleared at: (1) reset (including soft_reset), (2) clear bit\;" access="RO" offset="0x10.0" size="0x0.8" />
</node>

<node name="merr_ext" descr="" size="0x14.0" >
	<field name="ent_type" descr="Entity type.\;0: Reserved\;1: QSFP Module (the relevant signals are: present, reset, interrupt, power enable, low power mode, power good, modsel, QSFP LEDs)" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="current_index" descr="Current entity index" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="target_index" descr="Entity number to be mapped to." access="RW" offset="0x4.0" size="0x0.8" />
</node>

<node name="mfba_reg_ext" descr="" size="0x10c.0" >
	<field name="fs" descr="Flash select - selects the flash device.\;Only zero is supported for NICs with a single flash device \;Range between 0 .. MFPA.flash_num -1" access="INDEX" offset="0x0.4" size="0x0.2" />
	<field name="add_cap_32b" descr="Capability bit - If set to &apos;1&apos;, address field is 32 bit length." access="RO" offset="0x0.31" size="0x0.1" />
	<field name="size" descr="The size of the data to be written or read in bytes\;Should comply with block_size and block_alignment fields in MFPA." access="OP" offset="0x4.0" size="0x0.9" />
	<field name="address" descr="The start address of this read or write access in bytes. Should comply with block_size and block_alignment fields in MFPA." access="INDEX" offset="0x8.0" size="0x4.0" />
	<field name="data" descr="The data to be written or read data." access="RW" high_bound="63" low_bound="0" offset="0xC.0" size="0x100.0" />
</node>

<node name="mfbd_ext" descr="" size="0x24.0" >
	<field name="time_res" descr="Time Resolution\;0: time units are in microseconds \;1: time units are in milliseconds" access="OP" offset="0x0.0" size="0x0.1" />
	<field name="fw_init_total_time" descr="FW init time." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="fw_init_open_ports_time" descr="FW init time to open all ports." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="boot_time" descr="boot and bootrom time" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="init_tiles_time" descr="Tiles boot time" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="init_phy_power_time" descr="Phy power time" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="init_usr_algo_time" descr="User Algo&apos; time" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="init_gearbox_time" descr="Time of init Gearbox" access="RO" offset="0x20.0" size="0x4.0" />
</node>

<node name="mfbe_reg_ext" descr="" size="0xc.0" >
	<field name="fs" descr="Flash select - selects the flash device.\;Only zero is supported for NICs with a single flash device. \;Range between 0 .. MFPA.flash_num -1" access="INDEX" offset="0x0.4" size="0x0.2" />
	<field name="bulk_64kb_erase" descr="Erase a 64KB flash area in one bulk operation." access="WO" offset="0x0.29" size="0x0.1" />
	<field name="bulk_32kb_erase" descr="Erase a 32KB flash area in one bulk operation." access="WO" offset="0x0.30" size="0x0.1" />
	<field name="add_cap_32b" descr="Capability bit - If set to &apos;1&apos;, address field is 32 bit length." access="RO" offset="0x0.31" size="0x0.1" />
	<field name="address" descr="The start address (in bytes) of this erase operation. Must be aligned with the selected erase size (sector, 32KB or 64KB)." access="INDEX" offset="0x8.0" size="0x4.0" />
</node>

<node name="mfcdr_reg_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="port MSB" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="status" descr="0: N/A \;1: Fake cable detected\;2: NVIDIA Cable detected\;3: Reserved" access="RO" offset="0x4.0" size="0x0.2" />
</node>

<node name="mfcr_ext" descr="" size="0x8.0" >
	<field name="pwm_frequency" descr="Controls the frequency of the PWM signal.\;Supported frequencies are:\;0x0: 11Hz \;0x1: 14.7Hz\;0x2: 22.1Hz\;0x3 - 0111111: Reserved\;0x40: 1.4KHz\;0x41: 5KHz\;0x42: 20KHz\;0x43: 22.5KHz\;0x44: 25KHz\;0x45 - 0x7F: Reserved" access="RW" offset="0x0.0" size="0x0.7" />
	<field name="pwm_active" descr="Indicates which of the PWM control is active (bit per PWM)" access="RO" offset="0x4.0" size="0x0.5" />
	<field name="tacho_active" descr="Indicates which of the tachometer is active (bit per tachometer)\;Bitmask, per bit:\;0: not active\;1: active" access="RO" offset="0x4.16" size="0x0.10" />
	<field name="tacho_active_msb" descr="Indicates which of the tachometer is active (bit per tachometer)\;Bitmask, per bit:\;0: not active\;1: active" access="RO" offset="0x4.26" size="0x0.6" />
</node>

<node name="mfm_ext" descr="" size="0x18.0" >
	<field name="index" descr="Index to the fabric memory table." access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="memory_high" descr="Holds software-written data.\;Default value: 0x0\;Device reset will reset to the default value." access="RW" offset="0x8.0" size="0x4.0" />
	<field name="memory_low" descr="Holds software-written data.\;Default value: 0x0\;Device reset will reset to the default value." access="RW" offset="0xC.0" size="0x4.0" />
	<field name="memory_mask_high" descr="On write commands, indicates which of the bits from memory field are updated. Reserved on read operations." access="WO" offset="0x10.0" size="0x4.0" />
	<field name="memory_mask_low" descr="On write commands, indicates which of the bits from memory field are updated. Reserved on read operations." access="WO" offset="0x14.0" size="0x4.0" />
</node>

<node name="mfmc_reg_ext" descr="" size="0x1c.0" >
	<field name="fs" descr="Flash select - selects the flash device.\;Only zero is supported for NICs with a single flash device. \;Range between 0 .. MFPA.flash_num -1" access="INDEX" offset="0x0.4" size="0x0.2" />
	<field name="wrp_block_count" descr="Power of 2 of the write protect block count\;0: 1 block\;1: 2 blocks\;2: 4 blocks\;3: 8 blocks etc.\;Range 0..5\;Note that per flash device there may be invalid configurations\;Reserved when wrp_en = 0" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="block_size" descr="Block size\;0: write protect sub-sector blocks\;1: write protect sector blocks\;Reserved when wrp_en = 0\;Note that not all block sizes are supported on all flash device, need to check MFPA capabilities" access="RW" offset="0x4.16" size="0x0.2" />
	<field name="wrp_en" descr="Write protect enable\;Set write protect of flash device" access="RW" offset="0x4.31" size="0x0.1" />
	<field name="sub_sector_protect_size" descr="Power of 2 for sub_sector size in 4Kbytes.\;0: 4Kbyte.\;1: 8 Kbyte\;2: 16Kbyte.\;Etc." access="RO" offset="0x8.0" size="0x0.6" />
	<field name="sector_protect_size" descr="Power of 2 for sector size in 4Kbytes.\;0: 4Kbyte.\;1: 8 Kbyte\;2: 16Kbyte.\;Etc." access="RO" offset="0x8.8" size="0x0.6" />
	<field name="quad_en" descr="Quad enable IO bit in the device status register" access="RW" offset="0x10.24" size="0x0.1" />
	<field name="dummy_clock_cycles" descr="The number of dummy clock cycles subsequent to all FAST READ commands. \;Reserved if not supported by the device" access="RW" offset="0x18.0" size="0x0.4" />
</node>

<node name="mfnr_ext" descr="" size="0x30.0" >
	<field name="fan_index" descr="Fan tachometer index.\;" access="INDEX" offset="0x0.0" size="0x0.5" />
	<field name="serial_number" descr="Fan serial number (ASCII string)\;Value of &apos;0&apos;: Some error (Fan not present, disconnected etc.)" access="RO" high_bound="5" low_bound="0" offset="0x4.0" size="0x18.0" />
	<field name="part_number" descr="Fan part number (ASCII string)\;Value of &apos;0&apos;: Some error (Fan not present, disconnected etc.)" access="RO" high_bound="4" low_bound="0" offset="0x1C.0" size="0x14.0" />
</node>

<node name="mfpa_reg_ext" descr="" size="0x20.0" >
	<field name="fs" descr="Flash select - selects the flash device.\;Only zero is supported for NICs with a single flash device.\;Range between 0 .. flash_num -1\;" access="INDEX" offset="0x0.4" size="0x0.2" />
	<field name="add_cap_32b" descr="Capability bit - If set to &apos;1&apos;, boot_address field is 32 bit length." access="RO" offset="0x0.31" size="0x0.1" />
	<field name="boot_address" descr="The flash address from which the firmware will boot in the next reset (warm start)." access="RW" offset="0x4.0" size="0x4.0" />
	<field name="flash_num" descr="The number of flash devices1: there is 1 flash device, etc." access="RO" offset="0x10.0" size="0x0.4" />
	<field name="sub_sector_wrp_en" descr="If set, MFMC register supports setting write protect with sub-sector- blocks\;Sub-sector block size is available in MFMC.sub_sector_protect_size" access="RO" offset="0x10.16" size="0x0.1" />
	<field name="sector_wrp_en" descr="If set, MFMC register supports setting write protect with sector blocks.\;Sector block size is available in MFMC.sector_protect_size" access="RO" offset="0x10.17" size="0x0.1" />
	<field name="bulk_64kb_erase_en" descr="If set, MFBE register supports 64KB bulk erase operation.\;" access="RO" offset="0x10.29" size="0x0.1" />
	<field name="bulk_32kb_erase_en" descr="If set, MFBE register supports 32KB bulk erase operation." access="RO" offset="0x10.30" size="0x0.1" />
	<field name="wip" descr="Work In Progress. Indicates that the flash is currently busy." access="RO" offset="0x10.31" size="0x0.1" />
	<field name="jedec_id" descr="Return the flash JEDEC ID value returned by the standard Read JEDEC ID command that is available in most flash devices." access="RO" offset="0x14.0" size="0x0.24" />
	<field name="sector_size" descr="The minimal unit that can be erased with and MFBE command (in bytes)." access="RO" offset="0x18.0" size="0x0.10" />
	<field name="block_alignment" descr="Log 2 of the requested write alignment in bytes. Write access to the flash\;must not cross this alignment.\;Read and write access must be aligned to this value." access="RO" offset="0x18.16" size="0x0.8" />
	<field name="block_size" descr="The block size in byes of the flash device, max read size for MFBA (typically 128 bytes)." access="RO" offset="0x18.24" size="0x0.8" />
	<field name="capability_mask" descr="Bitmask indicates which capabilities are supported.\;Bit 15..0: reserved \;\;Bit 16: Set write protect supported (register MFMC supports setting write protection)\;Bit 17: quad enable read write is supported (register MFMC supports setting quad enable)\;Bit 18: set dummy cycle supported (register MFMC supports setting dummy cycles)" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mfrc_ext" descr="" size="0xc.0" >
	<field name="e" descr="Enable bit\;Applies to all fast recovery features.See full behavior of disable below table. \;0: disables the feature and all it&quot;s triggers, without clearing\;the visibility counters of the feature. 1: enables the fast recovery feature. When set after the feature was disabled, all counters are cleared.\;Reserved when trigger is not 0." access="RW" offset="0x0.0" size="0x0.1" />
	<field name="trigger" descr="Trigger of the fast recovery feature: \;0: All (used for &quot;e&quot; bit only)\;2: Credit watchdog.\;4: Raw BER.\;5: Effective BER.\;6: Symbol BER.\;Else, reserved." access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="capability_bits" descr="capability bits of the fast recovery feature\;0: When set, Credit watchdog notification is supported\;1: When set, Raw BER notification is supported\;2: When set, Effective BER notification is supported\;3: When set, Symbol BER notification is supported" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="en_normal_notification" descr="Enables fast recovery normal notifications (traps) to host (MFRI event). Fast recovery notification are best effort and might drop when congested. \;Reserved when trigger = 0." access="RW" offset="0x8.29" size="0x0.1" />
	<field name="en_warning_notification" descr="Enables fast recovery warning notifications (traps) to host (MFRI event). Fast recovery notification are best effort and might drop when congested. \;Reserved when trigger = 0." access="RW" offset="0x8.30" size="0x0.1" />
	<field name="en_error_notification" descr="Enables fast recovery error notifications (traps) to host (MFRI event). Fast recovery notification are best effort and might drop when congested. \;Reserved when trigger = 0." access="RW" offset="0x8.31" size="0x0.1" />
</node>

<node name="mfri_ext" descr="" size="0x30.0" >
	<field name="port" descr="Local Port Number" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="field_select" descr="Field select bitmask.\;When reading, this is will ignored.\;On the response / trap this will have the bit mask of the valid fields. \;0: num_errors\;1: num_warnings\;2: num_normals\;3: min_value\;4: max_value\;5: consecutive_normal\;6: last_value[0] \;7: last_value[1]\;8: last_value[2]\;Else, reserved." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="thr_type" descr="threshold type exceeded. \;0: Reserved\;1: Error threshold \;2: Warning threshold\;3: Normal TH\;Reserved when not a trap." access="RO" offset="0x4.16" size="0x0.2" />
	<field name="trigger" descr="Trigger of the fast recovery feature: \;2: Credit watchdog.\;4: Raw BER.\;5: Effective BER.\;6: Symbol BER.\;Else, reserved." access="INDEX" offset="0x4.24" size="0x0.8" />
	<field name="fields_overflow" descr="fields over flow bit-mask. \;Due to counters size differences between triggers, when a bit is set, it means that the counter got to the max value it can count:\;0: num_errors\;1: num_warnings\;2: num_normals\;3: min_value\;4: max_value\;5: consecutive_normal\;6: last_value[0] \;7: last_value[1]\;8: last_value[2]\;Else, reserved." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="num_errors" descr="Accumulated number of error events since last reset." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="num_warnings" descr="Number of warning events." access="RO" offset="0x10.0" size="0x4.0" />
	<field name="min_value" descr="Minimum value pet time window." access="RO" offset="0x18.0" size="0x4.0" />
	<field name="max_value" descr="Maximum value pet time window." access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="consecutive_normal" descr="The number of consecutive time windows which the port was in Normal mode.\;Reserved when last_value isn&apos;t normal." access="RO" offset="0x20.0" size="0x4.0" />
	<field name="last_value" descr="The values of the last time windows,\;when last[0] is the latest.\;" access="RO" high_bound="2" low_bound="0" offset="0x24.0" size="0xc.0" />
</node>

<node name="mfrp_ext" descr="" size="0x1c.0" >
	<field name="trigger" descr="Trigger of the fast recovery feature: \;2: Credit watchdog.\;4: aw BER.\;5: Effective BER.\;6: Symbol BER.\;Else, reserved." access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="lp_msb" descr="port MSB" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="en_thr" descr="Enable thresholds: \;0: No thresholds activated\;1: Only Error threshold is activated\;2: Only Warning and Normal thresholds are activated\;3: All three thresholds are activated" access="RO" offset="0x4.0" size="0x0.2" />
	<field name="error_thr_action" descr="Action required when exceeding error_thr.\;0: Do nothing\;1: Toggle the physical link (drop to polling).\;2: Change logical state to Init." access="RO" offset="0x4.4" size="0x0.2" />
	<field name="error_thr" descr="Error threshold- refers to the number of credit watchdog events that occurred in the specific time window. \;When the switch reaches this threshold it shall drop the logical link. \;Reserved when en_thr is 0 or 2." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="warning_thr" descr="Warning threshold- number of credit watchdog events that occurred in the specific time window. \;Shall be smaller than error_thr when set.\;Reserved when en_thr is 0 or 1." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="normal_thr" descr="Normal threshold- number of credit watchdog events that occurred in the specific time window. \;Shall be smaller than warning_thr.\;Reserved when en_thr is 0 or 1." access="RO" offset="0x10.0" size="0x4.0" />
	<field name="time_window" descr="The time frame which the events are grouped. This is a tumbling window (not a sliding window), means that each window is uncorrelated to the adjacent windows events. \;Time frame to measure Normal_thr.\;Units of sampling_rate.\;Value of zero is non valid." access="RO" offset="0x14.0" size="0x4.0" />
	<field name="sampling_rate" descr="Time frame to measure warning threshold and error threshold. \;Units of 10mSec, range 0..1Sec." access="RO" offset="0x18.0" size="0x4.0" />
</node>

<node name="mfsc_ext" descr="" size="0x8.0" >
	<field name="pwm" descr="Fan pwm to control / monitor" access="INDEX" offset="0x0.24" size="0x0.3" />
	<field name="pwm_duty_cycle" descr="Controls the duty cycle of the PWM. Value range from 0..255 to represent duty cycle of 0%...100%" access="RW" offset="0x4.0" size="0x0.8" />
</node>

<node name="mfsl_ext" descr="" size="0xc.0" >
	<field name="ie" descr="Interrupt Enable. If the ie bit is set and the Tachometer reading is out of range as defined by tach_min and tach_max, the FERR# will be asserted." access="RW" offset="0x0.0" size="0x0.1" />
	<field name="ee" descr="Event Enable.\;0 - Do not generate event\;1 - Generate Event \;2 - Generate single event\;For Fan Error Evet details refer to Section  4.13.10, &quot;MRSV - Management Read Straps Value Register&quot;." access="RW" offset="0x0.2" size="0x0.2" />
	<field name="tacho" descr="Fan tachometer index" access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="tach_min" descr="Tachometer minimum value (minimum RPM)." access="RW" offset="0x4.0" size="0x0.16" />
	<field name="tach_max" descr="Tachometer maximum value (maximum RPM)." access="RW" offset="0x8.0" size="0x0.16" />
</node>

<node name="mfsm_ext" descr="" size="0x8.0" >
	<field name="n" descr="" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="tacho" descr="Fan tachometer index" access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="rpm" descr="Fan speed (round per minute) calculated based on the time measurement between n fan pulses.\;Note that in order for the RPM to be correct, the n value should correspond to the number of tach pulses per rotation measured by the tachometer." access="RO" offset="0x4.0" size="0x0.16" />
</node>

<node name="mfsv_reg_ext" descr="" size="0x30.0" >
	<field name="efuses_prog_en" descr="When this bit is set, it indicates that it is allowed for the boot FW to program the FW security version related EFUSEs if needed. This bit is not relevant in case the FW operates in an automatically EFUSEs programming approach (set in the INI file). Once set to 1, this configuration will be relevant only for the upcoming boot, thus this configuration will be set back to 0 upon next boot.\;\;" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="fw_sec_ver_stat" descr="Firmware security version status.0: EFUSEs value is equal to the currently running FW image value. No change is needed.1: EFUSEs value is smaller than the currently running FW image value. An update to the EFUSEs is required.2: There is pending image, MFSV is rejected\;3: Reserved\;\;" access="RO" offset="0x0.1" size="0x0.2" />
	<field name="efuses_prog_method" descr="EFUSEs programming method.0: manually. Upon boot, if FW indicates that FW_sec_ver_stat is 1 and only if EFUSEs_prog_en is 1, it will program the EFUSEs as needed.1: automatically. Upon boot, if FW indicates that FW_sec_ver_stat is 1, it will program the EFUSEs as needed.\;\;" access="RO" offset="0x0.3" size="0x0.1" />
	<field name="revoke_efuse_prog" descr="0: EFUSEs value is equal to the currently running FW image value. No change is needed. \;1: EFUSEs value is smaller than the currently running FW image value. An update to the EFUSEs is required. \;" access="RW" offset="0x0.4" size="0x0.1" />
	<field name="pending_efuse_prog" descr="0: No pending EFUSE programming command \;1: There is pending MFSV command \;\;" access="RO" offset="0x0.5" size="0x0.1" />
	<field name="fuse_failure" descr="" access="RO" offset="0x0.8" size="0x0.2" />
	<field name="img_sec_ver" descr="Image security version value" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="efuses_sec_ver" descr="EFUSEs security version value" access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="mgcr_reg_ext" descr="" size="0x20.0" >
	<field name="segment" descr="The GPIO segment which the command&apos;s parameters apply" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="segments_count" descr="Ceiling function of total number of GPIOs / 32 in the system." access="RO" offset="0x0.8" size="0x0.8" />
	<field name="GPIO_data_in" descr="Input value of accessible GPIO[i] signals.\;When GPIO_access_en[i] = 0, GPIO_data_in[i] always returns 0" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="GPIO_data_out" descr="Output value of accessible GPIO signals.\;When GPIO_access_en[i] = 0, GPIO_data_out[i] always returns 0" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="GPIO_set" descr="These 2 fields are used together to control GPIO signals in the following manner:\;GPIO_set[i]=0, GPIO_clear[i]=0 : GPIO_data_out[i] = No Change\;GPIO_set[i]=0, GPIO_clear[i]=1 : GPIO_data_out[i] = 0\;GPIO_set[i]=1, GPIO_clear[i]=0 : GPIO_data_out[i] = 1\;GPIO_set[i]=1, GPIO_clear[i]=1 : GPIO_data_out[i] = not(GPIO_data_out[i])\;Ignored for non-controllable GPIO signals." access="WO" offset="0xC.0" size="0x4.0" />
	<field name="GPIO_clear" descr="These 2 fields are used together to control GPIO signals in the following manner:\;GPIO_set[i]=0, GPIO_clear[i]=0 : GPIO_data_out[i] = No Change\;GPIO_set[i]=0, GPIO_clear[i]=1 : GPIO_data_out[i] = 0\;GPIO_set[i]=1, GPIO_clear[i]=0 : GPIO_data_out[i] = 1\;GPIO_set[i]=1, GPIO_clear[i]=1 : GPIO_data_out[i] = not(GPIO_data_out[i])\;Ignored for non-controllable GPIO signals." access="WO" offset="0x10.0" size="0x4.0" />
	<field name="GPIO_access_en" descr="Access allowance to the corresponding GPIO signal.\;0: GPIO[i] is not observable / controllable by the host SW.\;1: GPIO[i] is observable / controllable by the host SW." access="RO" offset="0x14.0" size="0x4.0" />
	<field name="direction" descr="0: GPIO[i] is an input only signal\;1: GPIO[i] is an output signal. Data out can be updates by the host SW and data in can be queried by the host SW.\;For non-accessible GPIOs, the corresponding value is 0." access="RO" offset="0x18.0" size="0x4.0" />
	<field name="drive_type" descr="0: GPIO[i] is an open drain output. The device can only drive the GPIO[i] output pin low when GPIO_data_out[i] is 0. When GPIO_data_out[i] is 1, GPIO[i] is in HighZ. \;1: GPIO[i] is a full-drive output pin\;When GPIO_access_en[i] =0, direction[i] and drive_type[i] are always read as 0." access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mgir_dev_info_ext" descr="" size="0x1c.0" >
	<field name="dev_branch_tag" descr="The format of the string represented by ASCII." access="RO" high_bound="27" low_bound="0" offset="0x0.24" size="0x1c.0" />
</node>

<node name="mgir_ext" descr="" size="0xa0.0" >
	<field name="hw_info" descr="Hardware Information, see Table 689, &quot;Hardware Info Layout,&quot; on page 1004" subnode="mgir_hardware_info_ext" access="RW" offset="0x0.0" size="0x20.0" />
	<field name="fw_info" descr="Firmware Information, see Table 692, &quot;Firmware Info Layout,&quot; on page 1008" subnode="mgir_fw_info_ext" access="RW" offset="0x20.0" size="0x40.0" />
	<field name="sw_info" descr="Software Information, see Table 694, &quot;Software Info Layout,&quot; on page 1011\;This field indicates the oldest software version compatible with the current firmware" subnode="mgir_sw_info_ext" access="RW" offset="0x60.0" size="0x20.0" />
	<field name="dev_info" descr="Development Information, see Table 698, &quot;Development Info Layout,&quot; on page 1015" subnode="mgir_dev_info_ext" access="RW" offset="0x80.0" size="0x1c.0" />
</node>

<node name="mgir_fw_info_ext" descr="" size="0x40.0" >
	<field name="sub_minor" descr="Sub-minor firmware version number.\;Deprecated and returns &apos;0&apos;. \;Refer to extended_sub_minor." access="RO" offset="0x0.0" size="0x0.8" />
	<field name="minor" descr="Minor firmware version number.\;Deprecated and returns &apos;0&apos;. \;Refer to extended_minor." access="RO" offset="0x0.8" size="0x0.8" />
	<field name="major" descr="Major firmware version number.\;Deprecated and returns &apos;0&apos;. \;Refer to extended_major." access="RO" offset="0x0.16" size="0x0.8" />
	<field name="secured" descr="When set, the device is running firmware with secure-firmware updates capabilities." access="RO" offset="0x0.24" size="0x0.1" />
	<field name="signed_fw" descr="When set the device is running a signed FW binaries." access="RO" offset="0x0.25" size="0x0.1" />
	<field name="debug" descr="When set, the device is running a debug firmware. &apos;debug&apos; binary can only be installed on specific devices (identified by their &apos;Factory base MAC&apos;), which currently run a specific firmware version. These restrictions are expressed by a signed &apos;debug&apos; token that must be loaded to the device before installing the debug binary." access="RO" offset="0x0.26" size="0x0.1" />
	<field name="dev" descr="*NOTE* this field has diff meaning for Switch vs. NIC \;\;\;\;Switch &amp; Retimer:\;The device is running:\;0: regular FW branch\;1: development branch" access="RO" offset="0x0.27" size="0x0.1" />
	<field name="string_tlv" descr="When set, string-TLV is supported.\;For Retimer - always return 0 (not supported)." access="RO" offset="0x0.28" size="0x0.1" />
	<field name="dev_sc" descr="*NOTE* for NICs same as dev field\;Development-secure:\;The device is running:\;0: a regular-secure firmware version\;1: a development-secure firmware version" access="RO" offset="0x0.30" size="0x0.1" />
	<field name="build_id" descr="Firmware Build ID. Optional. \;Note: Deprecated for switches and returns &apos;0&apos;." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="year" descr="Firmware installation date. \;\;For example: 3 May 2004 will be coded as Month= 0x05, Day= 0x03, and Year= 0x04" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="day" descr="Firmware installation date. \;\;For example: 3 May 2004 will be coded as Month= 0x05, Day= 0x03, and Year= 0x04" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="month" descr="Firmware installation date. \;\;For example: 3 May 2004 will be coded as Month= 0x05, Day= 0x03, and Year= 0x04" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="hour" descr="Firmware installation hour.\;For example 17:43 will be coded as 0x1743" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="psid" descr="FW PSID" access="RO" high_bound="15" low_bound="0" offset="0x10.24" size="0x10.0" />
	<field name="ini_file_version" descr="User-configured version number of the current INI file." access="RO" offset="0x20.0" size="0x4.0" />
	<field name="extended_major" descr="FW version&apos;s Major field in extended (32b) format." access="RO" offset="0x24.0" size="0x4.0" />
	<field name="extended_minor" descr="FW version&apos;s Minor field in extended (32b) format." access="RO" offset="0x28.0" size="0x4.0" />
	<field name="extended_sub_minor" descr="FW version&apos;s SubMinor field in extended (32b) format." access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="isfu_major" descr="incremented by one when version is not ISSUable" access="RO" offset="0x30.0" size="0x0.16" />
	<field name="disabled_tiles_bitmap" descr="Bitmap representing the disabled tiles in the ASIC. Tile &apos;0&apos; is represented by the msb bit. \;0: tile is enabled\;1: tile is disabled\;\;The total number of tiles can be derived through MGPIR register." access="RO" offset="0x30.16" size="0x0.16" />
	<field name="life_cycle" descr="0: Production\;1: GA Secured\;2: GA Non-Secured\;3: RMA\;4: Pre Production\;Note: has also msb bits in life_cycle_msb.\;" access="RO" offset="0x34.0" size="0x0.2" />
	<field name="sec_boot" descr="0: Disable\;1: Enable" access="RO" offset="0x34.2" size="0x0.1" />
	<field name="encryption" descr="0: Disable\;1: Enable" access="RO" offset="0x34.3" size="0x0.1" />
	<field name="life_cycle_msb" descr="[DWIP]\;MSB of the life cycle.\;Supported in QM3, CX8 and on." access="RO" offset="0x34.4" size="0x0.3" />
	<field name="issu_able" descr="[DWIP]\;ISSU-able:\;0: not ISSUable\;1: ISSUable\;Supported from Quantum-3 and on\;Supported for Retimers\;Based on FW decisions: fuse, INI, NV and version on flash vs. running version" access="RO" offset="0x34.13" size="0x0.1" />
	<field name="pds" descr="[DWIP]\;0: PSC is not PDS mode\;1: PSC in PDS mode\;Supported in QM3,CX8 and on." access="RO" offset="0x34.14" size="0x0.1" />
</node>

<node name="mgir_hardware_info_ext" descr="" size="0x20.0" >
	<field name="device_id" descr="PCI device ID. For specific device IDs, see Table 14, &quot;Switch Supported PCI Device IDs,&quot; on page 312" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="device_hw_revision" descr="See Table 691, &quot;Device HW Revision Descriptions,&quot; on page 1006" access="RO" offset="0x0.16" size="0x0.16" />
	<field name="pvs" descr="Process Voltage Scaling\;Supported nominal V_CORE voltage (in 50mV units) for the device." access="RO" offset="0x4.0" size="0x0.5" />
	<field name="technology" descr="Process technology\;0: N/A\;1: 40nm\;2: 28nm\;3: 16nm\;4: 7nm\;5: 5nm\;6-31: Reserved" access="RO" offset="0x4.11" size="0x0.5" />
	<field name="num_ports" descr="Number of physical port the device supports.\;For Retimer: returns the number of data path \;" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="ib_mad_gen" descr="[DWIP]\;IB MAD Protocol. Based on value from ConfigProfile\;0: IBg1\;1: IBg2\;2-7: Reserved" access="RO" offset="0x4.28" size="0x0.3" />
	<field name="hw_dev_id" descr="The PCI device-ID of the NIC/HCA in recovery (Livefish) mode." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="development" descr="[DWIP]\;The device is running:\;0: a regular-secure firmware version\;1: a development-secure firmware version\;\;Supported in QM3,CX8 and on." access="RO" offset="0xC.30" size="0x0.1" />
	<field name="manufacturing_base_mac_47_32" descr="MSB of the &quot;base&quot; MAC address of the NIC that was allocate during manufacturing. The NIC derives the MAC addresses for the different PCI PFs from this MAC address. This parameter can be used as a canonical unique identifier of the NIC.\;manufacturing_base_mac of value 0 means field is not supported." access="RO" offset="0x10.0" size="0x0.16" />
	<field name="ga" descr="[DWIP]\;Geographical Address\;0: ASIC 0\;1: ASIC 1\;2: ASIC 2\;3: ASIC 3\;Valid for multi ASIC platforms only" access="RO" offset="0x10.16" size="0x0.6" />
	<field name="chip_type" descr="[DWIP]\;Chip Type\;0: Real chip\;1: Emulation\;2: ChipSim\;3: SimX \;Supported from Quantum-3 and ArcusE" access="RO" offset="0x10.24" size="0x0.4" />
	<field name="manufacturing_base_mac_31_0" descr="LSB of the &quot;base&quot; MAC address of the NIC that was allocate during manufacturing. The NIC derives the MAC addresses for the different PCI PFs from this MAC address. This parameter can be used as a canonical unique identifier of the NIC.\;manufacturing_base_mac of value 0 means field is not supported." access="RO" offset="0x14.0" size="0x4.0" />
	<field name="device_ticks_per_msec" descr="Device Ticks per msec\;Reserved when chip_type = Real chip (0)" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="uptime" descr="Time (in secs.) since last reset0" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mgir_sw_info_ext" descr="" size="0x20.0" >
	<field name="sub_minor" descr="Sub-minor Driver version number.\;" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="minor" descr="Minor Driver version number.\;" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="major" descr="Major Driver version number.\;" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="rom3_type" descr="ROM 3 type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="rom3_arch" descr="Arch type of ROM 3:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.4" size="0x0.4" />
	<field name="rom2_type" descr="ROM 2type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.8" size="0x0.4" />
	<field name="rom2_arch" descr="Arch type of ROM 2:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.12" size="0x0.4" />
	<field name="rom1_type" descr="ROM 1type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.16" size="0x0.4" />
	<field name="rom1_arch" descr="Arch type of ROM 1:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.20" size="0x0.4" />
	<field name="rom0_type" descr="ROM 0 type:\;0x0: none\;0x1: Flexboot\;0x2: UEFI\;0x3: UEFI-CLP\;0x4: NVME\;0x5: FCODE\;0x6: UEFI Virtio net\;0x7: UEFI Virtio blk\;0x8: PXE Virtio net\;0x9-0xF: Reserved" access="RO" offset="0x4.24" size="0x0.4" />
	<field name="rom0_arch" descr="Arch type of ROM 0:\;0x0: unspecified\;0x1: AMD64 - x86 64bit architecture\;0x2: AARCH64 - ARM Architecture 64 bits\;0x3: AMD64_AARCH64 - ROM code supporting both AMD64 and AARCH64 architectures\;0x4: IA32 - Intel Architecture 32 bits" access="RO" offset="0x4.28" size="0x0.4" />
	<field name="rom0_version" descr="ROM 0 version." subnode="rom_version_ext" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="rom1_version" descr="ROM 1 version." subnode="rom_version_ext" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="rom2_version" descr="ROM 2version." subnode="rom_version_ext" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="rom3_version" descr="ROM 3 version." subnode="rom_version_ext" access="RO" offset="0x14.0" size="0x4.0" />
</node>

<node name="mgpc_ext" descr="" size="0x18.0" >
	<field name="counter_index" descr="counter index\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Range 0 .. cap_shared_counter_pool_size - 1" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128" access="OP" offset="0x0.24" size="0x0.8" />
	<field name="opcode" descr="0: Nop\;\;2: Flush Counters - when counter set is un-bound, flush ensures counters will not be updated due to packets in the pipe. Valid only on Write operation\;8: Clear counters. Setting the clr bit will reset the counter value for all counters of the specified Router Interface.\;" access="OP" offset="0x4.28" size="0x0.4" />
	<field name="byte_counter" descr="Byte counter value" subnode="uint64" access="RW" offset="0x8.0" size="0x8.0" />
	<field name="packet_counter" descr="Packet counter value\;Spectrum HW has 58bits for packet counters" subnode="uint64" access="RW" offset="0x10.0" size="0x8.0" />
</node>

<node name="mgpcb_ext" descr="" size="0x410.0" >
	<field name="counter_index_base" descr="Counter Index base\;Range 0..cap_shared_counter_pool_size - 1\;Supported only for counter_set_type = 0x3 Packets and Byte" access="OP" offset="0x0.0" size="0x0.24" />
	<field name="num_rec" descr="Number of valid records\;Range 1..64" access="OP" offset="0x4.0" size="0x0.8" />
	<field name="opcode" descr="0: Nop\;8: Clear counters" access="OP" offset="0x8.0" size="0x0.4" />
	<field name="record" descr="See Table 1046, &quot;MGPCB - record Layout,&quot; on page 1297\;" subnode="mgpcb_record_ext" access="RW" high_bound="63" low_bound="0" offset="0x10.0" size="0x400.0" />
</node>

<node name="mgpcb_record_ext" descr="" size="0x10.0" >
	<field name="byte_counter" descr="Bytes counter value" subnode="uint64" access="RO" offset="0x0.0" size="0x8.0" />
	<field name="packet_counter" descr="Packets counter value" subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
</node>

<node name="mgpir_ext" descr="" size="0xa0.0" >
	<field name="hw_info" descr="Hardware Information, see Table 578, &quot;Hardware Info Layout,&quot; on page 916" subnode="mgpir_hw_info_ext" access="RW" offset="0x0.0" size="0x20.0" />
</node>

<node name="mgpir_hw_info_ext" descr="" size="0x20.0" >
	<field name="num_of_devices" descr="Number of devices of device_type. \;" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="num_of_modules_per_system" descr="Total number of modules within the specific ASIC.\;\;Note: \;For multi ASIC platforms, this field will provide the total number of modules for all ASICs combined together.\;For single ASIC platforms, the value will be the same as numfer_of_modules" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="devices_per_flash" descr="Number of devices of device_type per flash. \;" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="device_type" descr="Device type.\;0: No devices on system of that type.\;1: Gearbox \;2: Tiles\;3: No Info Available\;4: XM" access="RO" offset="0x0.24" size="0x0.4" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.28" size="0x0.4" />
	<field name="num_of_modules" descr="Number of modules within the specific ASIC.\;" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="num_of_slots" descr="Number of slots in the system. To eliminate receiving &apos;bad param&apos; status, the user should query that field with slot_index set to 0." access="RO" offset="0x4.8" size="0x0.8" />
	<field name="max_modules_per_slot" descr="Maximum number of modules that can be connected per slot. Includes internal and external modules." access="RO" offset="0x4.16" size="0x0.8" />
</node>

<node name="mhmpr_reg_ext" descr="" size="0x14.0" >
	<field name="upm" descr="&apos;0&apos; - if the ports are managed by host.\;&apos;1&apos; - if the ports are not managed by host" access="RW" offset="0x0.0" size="0x0.1" />
</node>

<node name="mhsr_ext" descr="" size="0x8.0" >
	<field name="health" descr="Software health state:\;0 - Failure\;1 - Reserved\;2 - Normal Operation\;3 - Boot / Init (default state)" access="WO" offset="0x0.0" size="0x0.4" />
</node>

<node name="mid" descr="" size="0x4.0" >
	<field name="mid" descr="" offset="0x0.0" size="0x0.16" />
</node>

<node name="mini_data_auto_ext" descr="" attr_is_union="1" size="0x40.0" >
	<field name="mini_module_i2c_mapping_ext" descr="" subnode="mini_module_i2c_mapping_ext" offset="0x0.0" selected_by="module_i2c_mapping" size="0x40.0" />
	<field name="mini_module_power_level_ext" descr="" subnode="mini_module_power_level_ext" offset="0x0.0" selected_by="module_power_level" size="0x4.0" />
	<field name="mini_fused_out_ports_ext" descr="" subnode="mini_fused_out_ports_ext" offset="0x0.0" selected_by="fused_out_ports" size="0x40.0" />
</node>

<node name="mini_ext" descr="" size="0x50.0" >
	<field name="type" descr="Type:\;\;3: module_i2c_mapping\;4: module_power_level\;5: fused_out_ports\;" access="INDEX" enum="module_i2c_mapping=0x3,module_power_level=0x4,fused_out_ports=0x5" offset="0x0.0" size="0x0.8" />
	<field name="index" descr="index\;Index depends on MINI.type \;" access="INDEX" offset="0x0.16" size="0x0.16" />
	<field name="valid" descr="Valid:\;0: the relevant type is not supported by this Firmware version\;1: the relevant type is valid" access="RO" offset="0x4.0" size="0x0.1" />
	<field name="data" descr="This field takes meaning per type\;For module_i2c_mapping see Table  720, &quot;MINI type module_i2c_mapping Register Layout,&quot; on page  1027\;For module_power_level see Table  722, &quot;MINI type module_power_level Layout,&quot; on page  1028\;For disabled_ports see Table  724, &quot;MINI type fused_out_ports Layout,&quot; on page  1029\;" subnode="mini_data_auto_ext" access="RW" offset="0x10.0" size="0x40.0" union_selector="$(parent).type" />
</node>

<node name="mini_fused_out_ports_ext" descr="" size="0x40.0" >
	<field name="fused_out_ports_bitmap" descr="Bitmap for indicating which ports are being disabled\;For each bit\;0: Port is enabled\;1: Port is disabled\;" access="RO" high_bound="7" low_bound="0" offset="0x0.0" size="0x20.0" />
</node>

<node name="mini_module_i2c_mapping_ext" descr="" size="0x40.0" >
	<field name="module_gw_num" descr="Module I2C GW Id" access="RO" offset="0x0.0" size="0x0.8" />
</node>

<node name="mini_module_power_level_ext" descr="" size="0x4.0" >
	<field name="spl" descr="Supported Power Level\;Units of 0.25Watt\;0 = 0W\;1 = 0.25W\;2 = 0.5W\;3 = 0.75W\;and so on\;" access="RO" offset="0x0.0" size="0x0.8" />
</node>

<node name="mirc_reg_ext" descr="" size="0x8.0" >
	<field name="status_code" descr="Indicates the successful completion of the instruction, or the reason it failed. \;0x0: OK\;0x1: BUSY\;0x2: PROHIBITED_FW_VER_ERR\;0x3: FIRST_PAGE_COPY_FAILED\;0x4: FIRST_PAGE_ERASE_FAILED\;0x5: FIRST_PAGE_RESTORE_FAILED\;0x6: CANDIDATE_FW_DEACTIVATION_FAILED\;0x7: FW_ALREADY_ACTIVATED\;0x8: ERROR_DEVICE_RESET_REQUIRED\;0x9: ERROR_FW_PROGRAMMING_NEEDED\;Other values should be treated as an unknown error." access="RO" offset="0x0.0" size="0x0.8" />
</node>

<node name="mjtag_ext" descr="" size="0x30.0" >
	<field name="size" descr="Size of operation - relevant for JTAG interface access commands only, indicating the number of transaction bytes to execute. Maximum size supported is 40.\;Note: when size=0, no operation is performed (clock is not toggled). The tdo is sampled and provided in the response at jtag_transaction_set_0." access="WO" offset="0x0.0" size="0x0.8" />
	<field name="sequence_number" descr="Command sequence number - to prevent re-execution of the same command due to command retransmission, this command includes a sequence number.\;The enable and disable commands MUST be issues with sequence_number = 0 while any JTAG access command must increase the sequence_number by 1 (the first JTAG access command should start at sequence_number = 1)." access="WO" offset="0x0.24" size="0x0.4" />
	<field name="cmd" descr="Command\;0 - JTAG interface disable - JTAG interface is disabled\;1 - JTAG interface enable - enabling JTAG interface\;2 - JTAG interface access" access="RW" offset="0x0.30" size="0x0.2" />
	<field name="jtag_transaction_set" descr="See Table 498, &quot;JTAG Transaction Set Byte Layout,&quot; on page 849" access="RW" high_bound="43" low_bound="0" offset="0x4.24" size="0x2c.0" />
</node>

<node name="mkdc_reg_ext" descr="" size="0x2c.0" >
	<field name="error_code" descr="Indicates the successful completion of the instruction or the reason it failed:\;0: OK\;1: BAD_SESSION_ID\;2: BAD_KEEP_ALIVE_COUNTER\;3: BAD_SOURCE_ADDRESS\;4: SESSION_TIMEOUT\;Other values are Reserved." access="RO" enum="OK=0x0,BAD_SESSION_ID=0x1,BAD_KEEP_ALIVE_COUNTER=0x2,BAD_SOURCE_ADDRESS=0x3,SESSION_TIMEOUT=0x4" offset="0x0.0" size="0x0.4" />
	<field name="session_id" descr="Unique debug session identifier." access="INDEX" offset="0x0.16" size="0x0.16" />
	<field name="current_keep_alive_counter" descr="Running counter that states the current sequence number of each keep-alive session." access="INDEX" offset="0x4.0" size="0x4.0" />
	<field name="next_keep_alive_counter" descr="Running counter that states the expected next sequence number of each keep-alive session." access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="mlcr_ext" descr="" size="0xc.0" >
	<field name="led_type" descr="Led type (only supported when cap_local_or_uid_only==1.)\;0: LOCALP_AND_UID - not supported\;1: UID \;2: LOCALP - local port" access="INDEX" enum="LOCALP_AND_UID=0x0,UID=0x1,LOCALP=0x2" offset="0x0.0" size="0x0.4" />
	<field name="cap_local_or_uid_only" descr="If set, led_type of type UID and LOCAL Port only are supported." access="RO" offset="0x0.4" size="0x0.1" />
	<field name="operation_cap" descr="If set to &apos;1&apos;, operation field is supported." access="RO" offset="0x0.5" size="0x0.1" />
	<field name="operation" descr="0: Controlled by HW / Beacon\;1: LED on - \;LED Scheme #1: PHY LED amber on, Logic LED off\;LED Scheme #2: PHY LED amber on, Logic LED Green On\;2: LED off - PHY and Logic LEDs are off\;Others: Reserved" access="RW" offset="0x0.12" size="0x0.4" />
	<field name="local_port" descr="Local port number\;Not supported for CPU port\;Valid only when led_type = LOCALP (2)" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="lp_msb" descr="2-bit expansion of the local port. Represents the local_port[9:8] bits\;Valid only when led_type = LOCALP (2)" access="INDEX" offset="0x0.24" size="0x0.2" />
	<field name="beacon_duration" descr="Duration of the beacon to be active, units of seconds\;The value of 0x0 will turn off the beacon\;The value of 0xffff will set the beacon to infinity" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="beacon_remain" descr="Remaining duration of the beacon, units of seconds\;The value of 0xffff means infinity" access="RO" offset="0x8.0" size="0x0.16" />
</node>

<node name="mmgcr_ext" descr="" size="0x4.0" >
	<field name="device_uid" descr="Device UID.\;Default value is 0.\;This field will configure the mirror_device_uid TLV for the mirror header - Table 942, &quot;ETH-ERSPAN Mirror Header TLV MIRROR_DEVICE_UID Frame Fields,&quot; on page 1184" access="RW" offset="0x0.0" size="0x0.24" />
</node>

<node name="mnvda_reg_ext" descr="" size="0x10c.0" >
	<field name="configuration_item_header" descr="Configuration Item Header" subnode="config_item_ext" access="RW" offset="0x0.0" size="0xc.0" />
	<field name="configuration_item_data" descr="Configuration Item Data" access="RW" high_bound="63" low_bound="0" offset="0xC.0" size="0x100.0" />
</node>

<node name="mnvdi_reg_ext" descr="" size="0xc.0" >
	<field name="configuration_item_header" descr="" subnode="config_item_ext" access="RW" offset="0x0.0" size="0xc.0" />
</node>

<node name="mnvgc_reg_ext" descr="" size="0x10.0" >
	<field name="nvda_read_factory_settings" descr="0:unsupported\;1: supported" access="RO" offset="0x0.0" size="0x0.1" />
	<field name="nvda_read_current_settings" descr="NVDA Read current settings. Indicates if reading the current settings by NVDA is supported.\;0: unsupported\;1: supported" access="RO" offset="0x0.1" size="0x0.1" />
	<field name="priv_nv_other_host" descr="When set, TLVs of other hosts may be modified." access="RO" offset="0x0.2" size="0x0.1" />
</node>

<node name="mnvia_reg_ext" descr="" size="0x8.0" >
	<field name="target" descr="Information targeted for invalidation\;0: ALL - all NVRAM parameters.\; All other values are reserved." access="WO" offset="0x0.0" size="0x0.3" />
	<field name="writer_id" descr="The entity which perform the invalidate.\;The encoding same as writer_id in Configuration Item register (See Table 782, &quot;Configuration Item Header Layout,&quot; on page 1070)." access="RW" offset="0x0.4" size="0x0.5" />
</node>

<node name="mnvqc_reg_ext" descr="" size="0x8.0" >
	<field name="type" descr="Configuration item type according to its class. \;Table 784, &quot;Configuration Item Data Type Class Global Layout,&quot; on page 1074\;Table 786, &quot;Configuration Item Data Type Class Physical Port Layout,&quot; on page 1074\;Table 788, &quot;Configuration Item Data Type Class Per Host-PF Layout,&quot; on page 1075\;Table 790, &quot;Configuration Item Data Type Class Log Layout,&quot; on page 1075\;Table 792, &quot;Configuration Item Data Type Class File Layout,&quot; on page 1076\;Table 796, &quot;Configuration Item Data Type Class Switch Global Layout,&quot; on page 1077\;Table 800, &quot;Configuration Item Data Type Class Multi Instance Layout,&quot; on page 1078" access="INDEX" offset="0x0.0" size="0x4.0" />
	<field name="support_rd" descr="The configuration item is supported and can be read" access="RO" offset="0x4.0" size="0x0.1" />
	<field name="support_wr" descr="The configuration item is supported and can be updated" access="RO" offset="0x4.1" size="0x0.1" />
	<field name="version" descr="The maximal version of the configuration item supported by the device" access="RO" offset="0x4.4" size="0x0.4" />
</node>

<node name="moca_ext" descr="" size="0xc.0" >
	<field name="counter_index" descr="counter index\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Range 0 .. cap_shared_counter_pool_size - 1" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="counter_type" descr="0: flow counter\;1: flow estimator counter\;" access="RW" offset="0x0.24" size="0x0.8" />
	<field name="size" descr="Amount of counters to allocate from counter_index.\;Counter_index + size must not exceedcap_shared_counter_pool_size - 1\;Reserved when read." access="OP" offset="0x8.0" size="0x0.24" />
</node>

<node name="mocmi_ext" descr="" size="0x10.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number (Rx ports)\;Not supported from CPU port\;Not supported from router port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="cond_nelp" descr="Conditional mirroring:\;Disables a dynamic mirror trigger per ingress local_port\;For non-Elephant packets only\;\;Bitwise vector, value per mirror trigger (e.g. bit 3 for trigger 0x3 Tail drop mirror)\;Value per bit:\;0: Enable mirror trigger \;1: Disable mirror trigger\;\;Notes: \;1. the enable does not trigger the mirror, it just allows the mirror\;2. applies only to dynamic mirror triggers\;Bits of static mirror triggers are reserved\;" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="cond_elp" descr="Conditional mirroring:\;Disables a dynamic mirror trigger per ingress local_port\;Same logic as for cond_nelp\;For Elephant packets only" access="RW" offset="0xC.0" size="0x0.16" />
</node>

<node name="mocs_ceer_ext" descr="" size="0x40.0" >
	<field name="port_mask" descr="Local port.\;Each bit represents a local port.Refer to Section 9.3, &quot;Port Numbering&quot;, on page 1710 for port numbering scheme.\;CPU port is not supported.\;Router port is not supported.\;\;The device will report information only about flows that were identified as elephant flows (thus the CEER.detection_entry will be chosen by the device). \;When MOCS.clear is set then for the trap the CEER.clear=1. \;Endianity example: local_port 1 is at 3Ch bit1" access="RW" high_bound="15" low_bound="0" offset="0x0.0" size="0x40.0" />
</node>

<node name="mocs_entry_auto_ext" descr="" attr_is_union="1" size="0xc8.0" >
	<field name="mocs_ppcnt_ext" descr="" subnode="mocs_ppcnt_ext" offset="0x0.0" selected_by="PPCNT_SES1" size="0xa0.0" />
	<field name="mocs_ppcnt_v2_ext" descr="" subnode="mocs_ppcnt_v2_ext" offset="0x0.0" selected_by="PPCNT_V2_SES1" size="0xc8.0" />
	<field name="mocs_mgpcb_ext" descr="" subnode="mocs_mgpcb_ext" offset="0x0.0" selected_by="MGPCB" size="0x8.0" />
	<field name="mocs_pbsr_ext" descr="" subnode="mocs_pbsr_ext" offset="0x0.0" selected_by="PBSR" size="0x40.0" />
	<field name="mocs_pbsr_v2_ext" descr="" subnode="mocs_pbsr_v2_ext" offset="0x0.0" selected_by="PBSR_V2" size="0x14.0" />
	<field name="mocs_sbsrd_ext" descr="" subnode="mocs_sbsrd_ext" offset="0x0.0" selected_by="SBSRD" size="0x4.0" />
	<field name="mocs_ceer_ext" descr="" subnode="mocs_ceer_ext" offset="0x0.0" selected_by="CEER" size="0x40.0" />
	<field name="mocs_mafbi_ext" descr="" subnode="mocs_mafbi_ext" offset="0x0.0" selected_by="MAFBI" size="0x8.0" />
	<field name="mocs_fsed_ext" descr="" subnode="mocs_fsed_ext" offset="0x0.0" selected_by="FSED" size="0x10.0" />
	<field name="mocs_usacn_ext" descr="" subnode="mocs_usacn_ext" offset="0x0.0" selected_by="USACN" size="0x48.0" />
	<field name="mocs_utcc_ext" descr="" subnode="mocs_utcc_ext" offset="0x0.0" selected_by="UTCC" size="0x44.0" />
	<field name="mocs_upcnt_ext" descr="" subnode="mocs_upcnt_ext" offset="0x0.0" selected_by="UPCNT" size="0x48.0" />
	<field name="mocs_mofrb_ext" descr="" subnode="mocs_mofrb_ext" offset="0x0.0" selected_by="MOFRB" size="0x60.0" />
	<field name="mocs_moftd_ext" descr="" subnode="mocs_moftd_ext" offset="0x0.0" selected_by="MOFTD" size="0x10.0" />
	<field name="mocs_rarftbr_ext" descr="" subnode="mocs_rarftbr_ext" offset="0x0.0" selected_by="RARFTBR" size="0x14.0" />
</node>

<node name="mocs_ext" descr="" size="0xe8.0" >
	<field name="type" descr="Session type:\;0x0: PPCNT_SES0 - (provides PPCNT traps)\;0x1: PPCNT_SES1 - (provides PPCNT traps)\;0x2: MGPCB\;0x3: PBSR\;0x4: SBSRD\;0x5: CEER\;0x6: MAFBI\;0x7: MOPCE - from Spectrum-1 and above.\;0x8: FSED - from Spectrum-4 and above.\;0xA: USACN - Spectrum-4 only.\;0xB: UTCC - Spectrum-4 only.\;0xC: UPCNT - Spectrum-4 only.\;0xD: MOFRB - from Spectrum-2 and above.\;0xE: MOFTD - from Spectrum-4 and above. [DWIP]\;0x10: RARFTBR - [DWIP]\;0x20: PPCNT_V2_SES0 - [DWIP]\;0x21: PPCNT_V2_SES1 - [DWIP]\;0x23: PBSR_V2 - [DWIP]\;" access="INDEX" enum="PPCNT_SES0=0x0,PPCNT_SES1=0x1,MGPCB=0x2,PBSR=0x3,SBSRD=0x4,CEER=0x5,MAFBI=0x6,MOPCE=0x7,FSED=0x8,USACN=0xa,UTCC=0xb,UPCNT=0xc,MOFRB=0xd,MOFTD=0xe,RARFTBR=0x10,PPCNT_V2_SES0=0x20,PPCNT_V2_SES1=0x21,PBSR_V2=0x23" offset="0x0.0" size="0x0.8" />
	<field name="status" descr="Status:\;0: IDLE\;1: BUSY\;2: CANCELED\;3: CONT" access="RO" enum="IDLE=0x0,BUSY=0x1,CANCELED=0x2,CONT=0x3" offset="0x4.0" size="0x0.2" />
	<field name="opcode" descr="Opcode.\;Note that a session is per type, thus multi sessions are allowed for different types.\;Opcode START cannot be set when a session is BUSY.\;\;0: START - start a session. Per session rejected when status = BUSY.\;1: CANCEL - cancel the session, see explanation above." access="WO" enum="START=0x0,CANCEL=0x1" offset="0x4.8" size="0x0.1" />
	<field name="clear" descr="Clear the counters:\;0x0: READ_NO_CLEAR\;0x1: READ_AND_CLEAR\;0x2: CLEAR_ONLY - no read, for faster operation. Will provide only MOCS_DONE trap when finished.\;\;Reserved when type = 0x7, 0x8, 0xE" access="RW" enum="READ_NO_CLEAR=0x0,READ_AND_CLEAR=0x1,CLEAR_ONLY=0x2" offset="0x4.16" size="0x0.2" />
	<field name="event_tid" descr="Transaction ID to be returned in the event EMADs\;Example: \;- MOCS had tid=3 and event_tid=17\;- MOCS returned with tid=3 and event_tid=17\;- PPCNT returned with tid=17\;- MOCS_DONE returned with tid=17 and event_tid=17" subnode="uint64" access="RW" offset="0x8.0" size="0x8.0" />
	<field name="num_of_iter" descr="[DWIP]\;Number of iterations\;Reserved when type is not MOFTD, RARFTBR" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="min_iter_time" descr="[DWIP]\;Minimum time for one iteration from start to start\;Units of 50uSec (e.g. value of 12 means 0.6mSec)\;If the iteration takes shorter than min_iter_time then FW will wait before starting the next iteration.\;The iteration may take longer than min_iter_time\;Range 2 and above\;Reserved when iter_mode = 0\;Reserved when num_of_iter = 0" access="RW" offset="0x10.16" size="0x0.8" />
	<field name="iter_mode" descr="[DWIP]\;Iteration mode:\;0: AFAP - as fast as possible\;1: WAIT - wait iter_time from start to start\;Reserved when num_of_iter = 0" access="RW" enum="AFAP=0x0,WAIT=0x1" offset="0x10.28" size="0x0.2" />
	<field name="iter_md_op" descr="[DWIP]\;Metadata operation selector for iterations.\;0: Before every REG TLV\;1: Before new iteration REG TLVs only\;Reserved when metadata=0.\;" access="OP" offset="0x14.23" size="0x0.1" />
	<field name="metadata" descr="[DWIP]\;Metadata selector.\;Only 1 metadata TLV per event is supported.\;0: None\;1: Iteration\;2: Iteration + timestamp\;" access="OP" offset="0x14.24" size="0x0.8" />
	<field name="entry" descr="See Table 1050, &quot;MOCS entry - PPCNT Layout,&quot; on page 1303\;See Table 1052, &quot;MOCS entry - PPCNT V2 Layout,&quot; on page 1305\;See Table 1054, &quot;MOCS entry - MGPCB Layout,&quot; on page 1307\;See Table 1056, &quot;MOCS entry - PBSR Layout,&quot; on page 1308\;See Table 1058, &quot;MOCS entry - PBSR V2 Layout,&quot; on page 1309\;See Table 1060, &quot;MOCS entry - SBSRD Layout,&quot; on page 1310\;See Table 1062, &quot;MOCS entry - CEER Layout,&quot; on page 1311\;See Table 1064, &quot;MOCS entry - MAFBI Layout,&quot; on page 1312\;See Table 1066, &quot;MOCS entry - FSED Layout,&quot; on page 1313\;See Table 1068, &quot;MOCS entry - USACN Layout,&quot; on page 1315\;See Table 1070, &quot;MOCS entry - UTCC Layout,&quot; on page 1316\;See Table 1072, &quot;MOCS entry - UPCNT Layout,&quot; on page 1317\;See Table 1074, &quot;MOCS entry - MOFRB Layout,&quot; on page 1318\;See Table 1078, &quot;MOCS entry - MOFTD Layout,&quot; on page 1320\;See Table 1080, &quot;MOCS entry - RARFTBR Layout,&quot; on page 1321\;" subnode="mocs_entry_auto_ext" access="RW" offset="0x20.0" size="0xc8.0" union_selector="$(parent).type" />
</node>

<node name="mocs_fsed_ext" descr="" size="0x10.0" >
	<field name="filter_fields" descr="filter fields:\;If a bit is &apos;0&apos; then the relevant field is ignored and dump is\;done regardless of the field value\;\;0: partition_id\;1: activity\;2: semaphore_state\;3: group_id\;\;All set filters are relevant (there is AND between the filters)" access="OP" enum="partition_id=0x0,activity=0x1,semaphore_state=0x2,group_id=0x3" offset="0x0.0" size="0x0.4" />
	<field name="op" descr="Operation\;0: Dump_entries \;1: Clear_activity_for_all_dumped_entries\;2: Clear_activity_only - (no dump)\;" access="OP" enum="Dump_entries=0x0,Clear_activity_for_all_dumped_entries=0x1,Clear_activity_only=0x2" offset="0x0.8" size="0x0.2" />
	<field name="entry_partition_id" descr="Dump only if entry partition has value of entry_parition\;Reserved when filter_fields bit0 is &apos;0&apos;" access="INDEX" offset="0x4.0" size="0x0.3" />
	<field name="entry_activity" descr="Dump only if activity has value of entry_activity\;Reserved when filter_fields bit1 is &apos;0&apos;" access="INDEX" offset="0x4.8" size="0x0.1" />
	<field name="entry_sem_s" descr="Dump only if semaphore state has value of entry_sem_s\;Reserved when filter_fields bit2 is &apos;0&apos;" access="INDEX" offset="0x4.9" size="0x0.1" />
	<field name="group_id" descr="Dump only if Group id equals to the value mentioned\;Reserved when filter_fields bit3 is &apos;0&apos;" access="INDEX" offset="0x4.16" size="0x0.16" />
	<field name="num_rec" descr="Number of records to read\;Range 0 .. (cap_kvd_size-1)\;\;Reserved when op = Clear only (2)" access="RW" offset="0x8.0" size="0x0.20" />
	<field name="nt" descr="New transaction\;0: continue_from_last_transaction\;1: start_new_transaction" access="OP" enum="continue_from_last_transaction=0x0,start_new_transaction=0x1" offset="0xC.0" size="0x0.1" />
</node>

<node name="mocs_mafbi_ext" descr="" size="0x8.0" >
	<field name="num_rec" descr="Number of records to read\;Must have a value of 32*N \;Range: 32.. cap_max_accuflow/2" access="RW" offset="0x0.0" size="0x0.24" />
	<field name="type" descr="type" access="RW" offset="0x0.28" size="0x0.2" />
	<field name="flush" descr="Flush:\;0: do not flush the counters, read immediately\;1: flush the counters" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="counter_index_base" descr="Counter Index base\;Must have a value of 32*N \;Range: cap_start_accuflow .. cap_start_accuflow+cap_max_accuflow" access="RW" offset="0x4.0" size="0x0.24" />
</node>

<node name="mocs_mgpcb_ext" descr="" size="0x8.0" >
	<field name="num_rec" descr="Number of records to read\;Range 1..cap_shared_counter_pool_size" access="RW" offset="0x0.0" size="0x0.24" />
	<field name="flush" descr="Flush:\;0: do not flush the counters, read immediately\;1: flush the counters\;" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="counter_index_base" descr="Counter Index base\;Range 0..cap_shared_counter_pool_size - 1\;Supported only for counter_set_type = 0x3 Packets and Byte" access="RW" offset="0x4.0" size="0x0.24" />
</node>

<node name="mocs_mofrb_ext" descr="" size="0x60.0" >
	<field name="flow_estimator_record" descr="See" subnode="flow_estimator_record_ext" access="RW" high_bound="11" low_bound="0" offset="0x0.0" size="0x60.0" />
</node>

<node name="mocs_moftd_ext" descr="" size="0x10.0" >
	<field name="user_cookie" descr="User cookie that will be sent with the data\;Opaque value" subnode="uint64" access="RW" offset="0x8.0" size="0x8.0" />
</node>

<node name="mocs_pbsr_ext" descr="" size="0x40.0" >
	<field name="port_mask" descr="Local port.\;Each bit represents a local port. Refer to Section 9.3, &quot;Port Numbering&quot;, on page 1710 for port numbering scheme.\;CPU port is supported\;Router port is not supported\;Endianity example: local_port 1 is at 3Ch bit1" access="RW" high_bound="15" low_bound="0" offset="0x0.0" size="0x40.0" />
</node>

<node name="mocs_pbsr_v2_ext" descr="" size="0x14.0" >
	<field name="bitmap_size" descr="Bitmap size in DWORDs.\;Range is 0..255.\;E.g. bitmap_size 16 is for 512 ports, 17 for 544 ports, 32 for 1024 ports, etc.\;" access="OP" offset="0x0.0" size="0x0.8" />
	<field name="port_mask" descr="Port mask array, read as one bitmap.\;Each bit represents a local port. Refer to Section 9.3, &quot;Port Numbering&quot;, on page 1710 for port numbering scheme.\;CPU port is supported\;Router port is not supported\;Endianity example: local_port 1 is at 3Ch bit1" access="RW" arr_is_dynamic="1" high_bound="VARIABLE" low_bound="0" offset="0x10.0" size="0x4.0" size_condition="$(parent).bitmap_size" />
</node>

<node name="mocs_ppcnt_ext" descr="" size="0xa0.0" >
	<field name="port_mask" descr="Local port\;Each bit represents a PPCNT.local_port\;Endianity example: local_port 1 is at 3Ch bit1" access="RW" high_bound="15" low_bound="0" offset="0x0.0" size="0x40.0" />
	<field name="grp_mask" descr="PPCNT Group mask\;Each bit represents a PPCNT.grp" access="RW" high_bound="3" low_bound="0" offset="0x40.0" size="0x10.0" />
	<field name="tc_mask" descr="PPCNT tclass mask - valid only for relevant groups\;Each bit represents a PPCNT.prio_tc" access="RW" offset="0x50.0" size="0x4.0" />
	<field name="rx_buffer_mask" descr="PPCNT rx_buffer mask - valid only for relevant groups\;Each bit represents a PPCNT.prio_tc" access="RW" offset="0x54.0" size="0x0.16" />
	<field name="prio_mask" descr="PPCNT prio mask - valid only for relevant groups\;Each bit represents a PPCNT.prio_tc" access="RW" offset="0x54.16" size="0x0.16" />
</node>

<node name="mocs_ppcnt_v2_ext" descr="" size="0xc8.0" >
	<field name="grp_mask" descr="PPCNT Group mask\;Each bit represents a PPCNT.grp" access="RW" high_bound="3" low_bound="0" offset="0x20.0" size="0x10.0" />
	<field name="tc_mask" descr="PPCNT tclass mask - valid only for relevant groups\;Each bit represents a PPCNT.prio_tc" access="RW" offset="0x30.0" size="0x4.0" />
	<field name="prio_mask" descr="PPCNT prio mask - valid only for relevant groups\;Each bit represents a PPCNT.prio_tc" access="RW" offset="0x34.0" size="0x0.16" />
	<field name="rx_buffer_mask" descr="PPCNT rx_buffer mask - valid only for relevant groups\;Each bit represents a PPCNT.prio_tc" access="RW" offset="0x38.0" size="0x0.16" />
	<field name="port_bitmap_size" descr="Bitmap size in DWORDs.\;Range is 0..255.\;E.g. bitmap_size 16 is for 512 ports, 17 for 544 ports, 32 for 1024 ports, etc.\;" access="OP" offset="0xC0.0" size="0x0.8" />
	<field name="port_mask" descr="Port mask array, read as one bitmap.\;Each bit represents a local port. Refer to Section 9.3, &quot;Port Numbering&quot;, on page 1710 for port numbering scheme.\;Each bit represents a PPCNT.local_port" access="RW" arr_is_dynamic="1" high_bound="VARIABLE" low_bound="0" offset="0xC4.0" size="0x4.0" size_condition="$(parent).bitmap_size" />
</node>

<node name="mocs_rarftbr_ext" descr="" size="0x14.0" >
	<field name="num_job" descr="Number of RARFTBR calls.\;Range is 0..512." access="OP" offset="0x0.0" size="0x0.12" />
	<field name="job" descr="RARFTBR job records.\;See Table 1082, &quot;MOCS-RARFTBR - RARFTBR Record Layout,&quot; on page 1321" subnode="mocs_rarftbr_record_ext" access="RW" high_bound="VARIABLE" low_bound="0" offset="0x4.0" size="0x10.0" />
</node>

<node name="mocs_rarftbr_record_ext" descr="" size="0x10.0" >
	<field name="num_rec" descr="Number of Flow Table entries.\;Not to be confused with table rows that holds several AR flow table entries.\;Note: every row holds &apos;cap_max_arft_entries_in_row&apos; entries.\;Stops reading rows on the first encounter of non-AR flow row, hence returned numbers of entries can be lower." access="OP" offset="0x0.0" size="0x0.16" />
	<field name="arft_index" descr="The first AR Flow Table index to begin with." access="INDEX" offset="0x4.0" size="0x0.20" />
</node>

<node name="mocs_sbsrd_ext" descr="" size="0x4.0" >
	<field name="desc" descr="read descriptors status" access="RW" offset="0x0.28" size="0x0.1" />
	<field name="cells" descr="read cells status" access="RW" offset="0x0.29" size="0x0.1" />
	<field name="snap" descr="read snapshot\;Note that clear will not take affect on snapshot" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="curr" descr="read current status\;Order of traps is:\;1. {current, cells}\;2. {snap, cells}\;3. {current, desc}\;4. {snap, desc}" access="RW" offset="0x0.31" size="0x0.1" />
</node>

<node name="mocs_upcnt_ext" descr="" size="0x48.0" >
	<field name="port_mask" descr="Local port.\;Each bit represents a local port" access="RW" high_bound="15" low_bound="0" offset="0x0.0" size="0x40.0" />
	<field name="grp_mask" descr="UPCNT Group mask\;Each bit represents a UPCNT.grp" subnode="uint64" access="RW" offset="0x40.0" size="0x8.0" />
</node>

<node name="mocs_usacn_ext" descr="" size="0x48.0" >
	<field name="port_mask" descr="Local port.\;Each bit represents a local port" access="RW" high_bound="15" low_bound="0" offset="0x0.0" size="0x40.0" />
	<field name="side" descr="Bit 0: Host\;Bit 1: Line" access="RW" offset="0x40.0" size="0x0.4" />
	<field name="num_rec" descr="Number of records to read\;Range: 1.. cap_sadb_entries - sadb_entry_index_base" access="RW" offset="0x44.0" size="0x0.16" />
	<field name="sadb_entry_index_base" descr="SADB entry index base\;Range 0.. cap_sadb_entries - 1\;Note: cap_sadb_entries is provided by UGCAP" access="RW" offset="0x44.16" size="0x0.16" />
</node>

<node name="mocs_utcc_ext" descr="" size="0x44.0" >
	<field name="port_mask" descr="Local port.\;Each bit represents a local port" access="RW" high_bound="15" low_bound="0" offset="0x0.0" size="0x40.0" />
	<field name="side" descr="Bit 0: Host\;Bit 1: Line" access="RW" offset="0x40.0" size="0x0.4" />
</node>

<node name="modcr_ext" descr="" size="0x14.0" >
	<field name="clear" descr="Clear the coutners" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="fatal_asserts" descr="Count number of fatal asserts" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="normal_asserts" descr="Count number of normal asserts" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="debug_asserts" descr="Count number of debug asserts" access="RO" offset="0x10.0" size="0x4.0" />
</node>

<node name="module_latched_flag_info_ext" descr="" size="0xf8.0" >
	<field name="rx_los_cap" descr="when set, indicates modules supports rx los indication" access="RO" offset="0x0.0" size="0x0.1" />
	<field name="dp_fw_fault" descr="Valid for CMIS based modules only\;Latched modules Datapath fw fault flag" access="RO" offset="0x0.22" size="0x0.1" />
	<field name="mod_fw_fault" descr="Valid for CMIS based modules only\;Latched module fw fault flag" access="RO" offset="0x0.23" size="0x0.1" />
	<field name="vcc_flags" descr="Latched VCC flags of module\;Bit 0: high_vcc_alarm\;Bit 1: low_vcc_alarm\;Bit 2: high_vcc_warning\;Bit 3: low_vcc_warning" access="RO" enum="high_vcc_alarm=0x1,low_vcc_alarm=0x2,high_vcc_warning=0x4,low_vcc_warning=0x8" offset="0x0.24" size="0x0.4" />
	<field name="temp_flags" descr="Latched temperature flags of module\;Bit 0: high_temp_alarm\;Bit 1: low_temp_alarm\;Bit 2: high_temp_warning\;Bit 3: low_temp_warning" access="RO" enum="high_temp_alarm=0x1,low_temp_alarm=0x2,high_temp_warning=0x4,low_temp_warning=0x8" offset="0x0.28" size="0x0.4" />
	<field name="tx_ad_eq_fault" descr="Reserved for SFP\;Bitmask for latched Tx adaptive equalization fault flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="tx_cdr_lol" descr="Bitmask for latched Tx cdr loss of lock flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="tx_los" descr="Reserved for SFP\;Bitmask for latched Tx loss of signal flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="tx_fault" descr="Bitmask for latched Tx fault flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x4.24" size="0x0.8" />
	<field name="tx_power_lo_war" descr="Bitmask for latched Tx power low warning flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="tx_power_hi_war" descr="Bitmask for latched Tx power high warning flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x8.8" size="0x0.8" />
	<field name="tx_power_lo_al" descr="Bitmask for latched Tx power low alarm flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="tx_power_hi_al" descr="Bitmask for latched Tx power high alarm flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="tx_bias_lo_war" descr="Bitmask for latched Tx bias low warning flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="tx_bias_hi_war" descr="Bitmask for latched Tx bias high warning flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="tx_bias_lo_al" descr="Bitmask for latched Tx bias low alarm flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0xC.16" size="0x0.8" />
	<field name="tx_bias_hi_al" descr="Bitmask for latched Tx bias high alarm flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0xC.24" size="0x0.8" />
	<field name="rx_cdr_lol" descr="Bitmask for latched Rx cdr loss of lock flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x10.16" size="0x0.8" />
	<field name="rx_los" descr="Bitmask for latched Rx loss of signal flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x10.24" size="0x0.8" />
	<field name="rx_power_lo_war" descr="Bitmask for latched Rx power low warning flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x14.0" size="0x0.8" />
	<field name="rx_power_hi_war" descr="Bitmask for latched Rx power high warning flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x14.8" size="0x0.8" />
	<field name="rx_power_lo_al" descr="Bitmask for latched Rx power low alarm flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x14.16" size="0x0.8" />
	<field name="rx_power_hi_al" descr="Bitmask for latched Rx power high alarm flag per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x14.24" size="0x0.8" />
	<field name="rx_output_valid_change" descr="Bitmask for latched rx output valid change per lane.\;Bit 0 - lane 0 ... Bit 7 - lane 7" access="RO" offset="0x18.0" size="0x0.8" />
</node>

<node name="mofpc_ext" descr="" size="0xc.0" >
	<field name="profile" descr="Flow Estimator profile index\;range 0 - cap_max_flow_estimator_profile - 1" access="INDEX" offset="0x0.0" size="0x0.3" />
	<field name="log_num_of_bins" descr="Number of bins for flow estimator must be power of 2.\;Number of bins = 2^log_num_of_bins\;Range 0 - cap_max_flow_estimator_bins_log\;Default value is 0." access="RW" offset="0x4.0" size="0x0.4" />
</node>

<node name="mofph_ext" descr="" size="0x20.0" >
	<field name="type" descr="Hash type\;0: CRC - (default)\;1: XOR_HASH\;2: Random" access="RW" enum="CRC=0x0,XOR_HASH=0x1,Random=0x2" offset="0x0.0" size="0x0.4" />
	<field name="profile" descr="Flow Estimator Profile Index\;Range 0 - cap_max_flow_estimator_profile - 1" access="INDEX" offset="0x0.8" size="0x0.3" />
	<field name="seed_by_sw" descr="8 bit of seed for hash function.\;Reserved when seed_en is disabled or by HW." access="RW" offset="0x4.0" size="0x0.8" />
	<field name="seed_en" descr="0: Disabled\;1: Seed_by_HW\;2: Seed_by_SW\;" access="RW" enum="Disabled=0x0,Seed_by_HW=0x1,Seed_by_SW=0x2" offset="0x4.30" size="0x0.2" />
	<field name="outer_header_enables" descr="Outer header enables. Each bit enables a specific layer field to be included in the hash calculation. Layers that are not listed below are enabled by default.\;Bit 0: Enable IPv4 fields if packet is not TCP and not UDP\;Bit 1: Enable IPv4 fields if packet is either TCP or UDP\;Bit 2: Enable IPv6 fields if packet is not TCP and not UDP\;Bit 3: Enable IPv6 fields if packet is either TCP or UDP\;Bit 4: Enable TCP/UDP header fields if packet is IPv4\;Bit 5: Enable TCP/UDP header fields if packet is IPv6" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="outer_header_hash" descr="If a bit is set, the relevant field will be calculated in the hash.\;ipv4:\;0-3: ipv4 dip bytes 0-3\;4-7: ipv4 sip bytes 0-3\;8: IPv4 mask fragments - mask ipv4 fragmented packets (mask all fields after ipv4 header)\;9: ipv4 next protocol\;ipv6:\;10: ipv6 dip bytes 0-7 (one bit for all 8 bytes)\;11-18: ipv6 dip bytes 8-15\;19: ipv6 sip bytes 0-7 (one bit for all 8 bytes)\;20-27: ipv6 sip bytes 8-15\;29: ipv6 next protocol\;L4:\;30: L4 dest port (only for UDP and TCP)\;31: L4 source port (only for UDP and TCP)\;mpls:\;33: mpls exp\;34-39: mpls label 0-5\;40: mask label after extension - mask the label after the indication label for the extension reserved labels (label 15)\;41: mask labels and headers after entropy - mask all the labels and headers after entropy label, note that both ELI and EL are not masked, all headers after MPLS stack are masked (e.g ip header)\;42: if mpls, mask all the headers after mpls header\;43: mask reserved labels - supports up to 256 reserved labels. not mask ELs (entropy labels)\;general:\;44: arp dip\;45: arp sip\;46: bth_dest_qp\;47: mask after flex (mask all the headers after flex)\;48: grh dip\;49: grh next protocol\;50: grh sip\;51: if packet is vxlan/geneve/gpe, mask all next headers after UDP\;52: if packet is vxlan/geneve/gpe, mask all header after vxlan/geneve/gpe\;53: ingress port\;54: if packet is nvgre - mask all next headers after nvgre" subnode="uint64" access="RW" offset="0x10.0" size="0x8.0" />
	<field name="inner_header_enables" descr="Inner header enables. Each bit enables a specific layer field to be included in the hash calculation. Layers that are not listed below are enabled by default.\;Bit 0: Enable IPv4 fields if packet is not TCP and not UDP\;Bit 1: Enable IPv4 fields if packet is either TCP or UDP\;Bit 2: Enable IPv6 fields if packet is not TCP and not UDP\;Bit 3: Enable IPv6 fields if packet is either TCP or UDP\;Bit 4: Enable TCP/UDP header fields if packet is IPv4\;Bit 5: Enable TCP/UDP header fields if packet is IPv6" access="RW" offset="0x18.0" size="0x0.16" />
	<field name="inner_header_hash" descr="If a bit is set, the relevant field will be calculated in the hash.\;\;ipv4:\;0-3: ipv4 dip bytes 0-3 (arp dip is not supported for inner)\;4-7: ipv4 sip bytes 0-3\;8: IPv4 mask fragments - mask ipv4 fragmented packets (mask all fields after ipv4 header)\;9: ipv4 next protocol\;\;ipv6:\;10: ipv6 dip bytes 0-7 (one bit for all 8 bytes)\;11-18: ipv6 dip bytes 8-15\;19: ipv6 sip bytes 0-7 (one bit for all 8 bytes)\;20-27: ipv6 sip bytes 8-15\;28: ipv6 flow label\;29: ipv6 next protocol\;\;L4:\;30: L4 dest port (only for UDP and TCP)\;31: L4 source port (only for UDP and TCP)" access="RW" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mofrb_ext" descr="" size="0x210.0" >
	<field name="num_rec" descr="On Query: Number of records to read\;0 .. cap_max_flow_estimator_bins" access="RW" offset="0x0.0" size="0x0.11" />
	<field name="clear" descr="clear:\;0: do NOT clear the bins\;1: clear the bins" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="counter_index_base" descr="counter index of the first bin\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Range 0 .. cap_shared_counter_pool_size - 1" access="INDEX" offset="0x4.0" size="0x0.24" />
	<field name="flow_estimator_bin" descr="Flow estimator bin value" access="RO" high_bound="511" low_bound="0" offset="0x10.24" size="0x200.0" />
</node>

<node name="mogcr_ext" descr="" size="0x20.0" >
	<field name="ptp_eftc" descr="PTP Egress FIFO Trap Clear\;The PTP_EGR_FIFO trap provides MTPPTR with clr according to this value. Default 0.\;Reserved when IB switches and when SwitchX/-2, Spectrum-2" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="ptp_iftc" descr="PTP Ingress FIFO Trap Clear\;The PTP_ING_FIFO trap provides MTPPTR with clr according to this value. Default 0.\;Reserved when IB switches and when SwitchX/-2, Spectrum-2" access="RW" offset="0x0.1" size="0x0.1" />
	<field name="tele_managed" descr="Telemetry is managed:\;0: telemetery is unmanged (default for IB switches)\;1: telemetery is manged (default for Eth switches)\;When unmanaged - the events are by VS-MADs\;When managed - the events are by EMADs\;Reserved when Ethernet switches" access="RW" offset="0x0.8" size="0x0.1" />
	<field name="sid" descr="Sample ingress discards:\;0: ingress discards are not sampled\;1: ingress discards are sampled\;Reserved when Switch-IB/2, Quantum" access="RW" offset="0x8.0" size="0x0.1" />
	<field name="mirroring_pid_base" descr="Base policer id for mirroring policers.\;Must have an even value (e.g. 1000, not 1001).\;Reserved when SwitchX/-2, Switch-IB/2, Spectrum and Quantum/-2" access="RW" offset="0xC.0" size="0x0.14" />
	<field name="e2e_time_scale" descr="[Spectrum-3-phase2]\;End to end time scale\;Units of nSec\;For Spectrum-4: values are 1,2,4..32768nSec\;Default 64nSec\;See Section 5.8, &quot;End-to-End Time Measurement&quot;, on page 1194\;Reserved when Spectrum/-2/-3\;Supported by Quantum HW, not yet opened by FW, Jan 2019" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="mirror_latency_units" descr="Units of mirror header latency\;Units of nSec\;For Spectrum-2/3: values are 1,2,4..32768nSec\;Default 64nSec\;See Table 924, &quot;ERSPAN Mirror Header TLV LATENCY Frame Layout,&quot; on page 1176\;Reserved when Spectrum" access="RW" offset="0x14.0" size="0x0.16" />
	<field name="latency_histogram_units" descr="Units of latency histograms\;Units of nSec\;For Spectrum-2/3: values are 1,2,4..32768nSec\;Default 64nSec\;See Section 10.6.4.1, &quot;Latency Histograms&quot;, on page 2417\;Reserved when Spectrum\;" access="RW" offset="0x18.0" size="0x0.16" />
	<field name="toc_fmt" descr="Timestamp over CRC format:\;0: Free_Running_Clock\;1: UTC" access="RW" enum="Free_Running_Clock=0x0,UTC=0x1" offset="0x1C.24" size="0x0.1" />
</node>

<node name="molp_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local Port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="label_port" descr="Label on the front panel.\;Used for mirror header and for EMT (Egress Modifier Template)." access="RW" offset="0x4.0" size="0x0.16" />
</node>

<node name="momte_ext" descr="" size="0x10.0" >
	<field name="mngr_type" descr="Manager Type\;0: HYPERVISOR\;1: LNM - local network manager\;Reserved when Spectrum/-2" access="OP" enum="HYPERVISOR=0x0,LNM=0x1" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="If (mngr_type == &quot;Hypervisor&quot;)\;Unique port identifier for the final destination of the packet\;If (mngr_type == &quot;Local Network Manager&quot;) and the port from which the command came from is InfiniBand: \;ib port number\;If (mngr_type == &quot;Local Network Manager&quot;) and the port from which the command came from is Ethernet: \;Local Port\;\;For Quantum:\;- Supported to/from Aggregation Node\;- Not supported to/from IB Router port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="swid" descr="Switch Partition ID\;Reserved when mngr_type = LNM\;Reserved when Ethernet switches" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="type" descr="See Section 5.4.1, &quot;Mirror Triggers&quot;, on page 1142\;Type:\;0x20: WRED_egress - no CPU port\;0x31: SHARED_BUFFER_TClass - egress\;0x32: Shared_buffer_TClass_descriptors - egress [advanced]\;0x33: SHARED_BUFFER_Egress_Port - egress\;0x40: ING_CONG - ingress\;0x50: EGR_CONG - egress\;0x60: ECN - egress, no CPU port\;0x70: HIGH_LATENCY - egress, no CPU port" access="INDEX" enum="WRED_egress=0x20,SHARED_BUFFER_TClass=0x31,Shared_buffer_TClass_descriptors=0x32,SHARED_BUFFER_Egress_Port=0x33,ING_CONG=0x40,EGR_CONG=0x50,ECN=0x60,HIGH_LATENCY=0x70" offset="0x4.0" size="0x0.8" />
	<field name="tclass_en_high" descr="TClass/PG mirror enable (for IB switches this is VL enable)\;Each bit represents corresponding tclass\;0: disable (default)\;1: enable\;When type = 0x33: only bit0 is used, representing the port\;Valid bits for Ethernet devices: 0.. cap_max_tclass_data - 1" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="tclass_en_low" descr="TClass/PG mirror enable (for IB switches this is VL enable)\;Each bit represents corresponding tclass\;0: disable (default)\;1: enable\;When type = 0x33: only bit0 is used, representing the port\;Valid bits for Ethernet devices: 0.. cap_max_tclass_data - 1" access="RW" offset="0xC.0" size="0x4.0" />
</node>

<node name="moni_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port\;Not supported for CPU port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="en" descr="Enable monitoring on network interface:\;0: disable (default)\;1: enable" access="RW" offset="0x4.0" size="0x0.1" />
</node>

<node name="motrm_reg_ext" descr="" size="0xc.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number (Rx ports)\;Not supported from CPU port\;Not supported from router port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="en_nvl" descr="For NVLink packets:\;Enable trigger mirror according to NVLink LRH.Trig field\;0: Disable mirror trigger \;1: Enable mirror trigger" access="RW" offset="0x8.0" size="0x0.1" />
	<field name="en_ing2" descr="For IBg2 packets:\;Enable trigger mirror according to IP.DSCP[0] field\;0: Disable mirror trigger \;1: Enable mirror trigger" access="RW" offset="0x8.1" size="0x0.1" />
</node>

<node name="mpagr_ext" descr="" size="0xc.0" >
	<field name="trigger" descr="Mirror trigger \;See Table 883, &quot;Mirror Triggers,&quot; on page 1142\;Reserved when the mirror binding is not Global" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="mngr_type" descr="Manager Type\;0: HYPERVISOR - config all ports\;1: LNM - local network manager - config all ports of the SWID\;Reserved when Ethernet switches" access="OP" enum="HYPERVISOR=0x0,LNM=0x1" offset="0x0.8" size="0x0.4" />
	<field name="swid" descr="Switch Partition ID\;Reserved when mngr_type = LNM\;Reserved when Ethernet switches" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="pa_id" descr="Port analyzer ID" access="RW" offset="0x4.0" size="0x0.4" />
	<field name="enable" descr="Enable mirroring \;By default, port mirroring is disabled for all ports.\;Reserved when Quantum and Spectrum-2." access="RW" offset="0x4.31" size="0x0.1" />
	<field name="probability_rate" descr="Sampling rate = 1 out of rate packets \;Valid values are: 1 to 3.5*10^9\;Value of 1 means &quot;sample all&quot;\;Default 1\;Note: high values are round by HW to: 10^9 * {4.3, 2.15, 1.43, 1.08, 0.86, 0.72, 0.61, 0.54}." access="RW" offset="0x8.0" size="0x4.0" />
</node>

<node name="mpar_ext" descr="" size="0xc.0" >
	<field name="i_e" descr="Ingress/egress\;See Table 883, &quot;Mirror Triggers,&quot; on page 1142\;Reserved when the mirror binding is not per Rx or per Tx" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.4" size="0x0.2" />
	<field name="local_port" descr="When Ethernet: always Local Port\;\;When IB:\;If (mngr_type == &quot;Hypervisor&quot;):\;Unique port identifier\;If (mngr_type == &quot;Local Network Manager&quot;):\;ib port number\;\;For SwitchX/-2 and Spectrum family:\;- Supported from CPU port\;For Switch-IB/2, Quantum/-2:\;- Supported to/from CPU port\;- Supported to/from Aggregation Node\;- Not supported to/from IB Router port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="mngr_type" descr="Manager Type\;0: HYPERVISOR\;1: LNM - local network manager\;Reserved for Spectrum family." access="OP" enum="HYPERVISOR=0x0,LNM=0x1" offset="0x0.24" size="0x0.4" />
	<field name="pa_id" descr="Port Analyzer ID (a.k.a mirror-agent)\;Reserved when enable=0" access="RW" offset="0x4.0" size="0x0.4" />
	<field name="enable" descr="Enable mirroring \;By default, port mirroring is disabled for all ports." access="RW" offset="0x4.31" size="0x0.1" />
	<field name="probability_rate" descr="Sampling rate = 1 out of rate packets \;Valid values are: 1 to 4.3*10^9\;Values of 0 behaves like 1\;Default 1\;Note: high values are round by HW to: 10^9 * {4.3, 2.15, 1.43, 1.08, 0.86, 0.72, 0.61, 0.54}. \;Reserved when SwitchX/-2, Switch-IB/2 and Spectrum\;Supported for Quantum and Spectrum-2 and on" access="RW" offset="0x8.0" size="0x4.0" />
</node>

<node name="mpat_encap_localib_ext" descr="" size="0x10.0" >
	<field name="vl" descr="Virtual Lane on which the mirrored packet is queued.\;Mirrored packets cannot be queued on VL-15" access="RW" offset="0xC.0" size="0x0.4" />
</node>

<node name="mpat_encap_remoteib_ext" descr="" size="0x4c.0" >
	<field name="dlid" descr="Destination LID. \;Note that the analyzer port is configured by the system_port field and not by forwarding the packet based on the dlid field." access="RW" offset="0x0.0" size="0x0.16" />
	<field name="dpa" descr="Dynamic port analyzer. When set to dynamic mode, the analyzer port is set based on the forwarding information for the {swid, dlid} on private-LFT 0 instead of the system_port field. In static mode, the packet is transmitted to the configured system_port regardless of the forwarding database.\;0: static analyzer port\;1: dynamic analyzer port" access="RW" offset="0x0.16" size="0x0.2" />
	<field name="sl" descr="Service Level" access="RW" offset="0x0.20" size="0x0.4" />
	<field name="we" descr="Write enable:\;0: write all fields\;1: write only psn_init_val" access="WO" offset="0x0.24" size="0x0.8" />
	<field name="slid" descr="Source LID (LID of the sending device)" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="version" descr="Remote SPAN InfiniBand encapsulation header version\;1: V1 - Mirror Header Version 1\;2: V2 - Mirror Header Version 2\;" access="RW" offset="0x4.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID\;Reserved when dpa = static analyzer port\;Reserved when mngr_type = local port manager\;Switch partition ID is used for dynamic analyzer port, to set the analyzer port based on the desired forwarding table (the one that belong to the swid)." access="RW" offset="0x4.24" size="0x0.8" />
	<field name="vl" descr="Virtual Lane on which the mirrored packet is queued.\;Mirrored packets cannot be queued on VL-15." access="RW" offset="0xC.0" size="0x0.4" />
	<field name="flow_label" descr="GRH FlowLabel" access="RW" offset="0x10.0" size="0x0.20" />
	<field name="tclass" descr="GRH TClass" access="RW" offset="0x10.20" size="0x0.8" />
	<field name="hop_limit" descr="GHR HopLmt" access="RW" offset="0x14.0" size="0x0.8" />
	<field name="sgid" descr="GRH SGID[127:0]" access="RW" high_bound="3" low_bound="0" offset="0x18.0" size="0x10.0" />
	<field name="dgid" descr="GRH DGID[127:0]" access="RW" high_bound="3" low_bound="0" offset="0x28.0" size="0x10.0" />
	<field name="pkey" descr="BTH PKey" access="RW" offset="0x38.0" size="0x0.16" />
	<field name="m" descr="BTH m" access="RW" offset="0x38.22" size="0x0.1" />
	<field name="se" descr="BTH se" access="RW" offset="0x38.23" size="0x0.1" />
	<field name="dest_qp" descr="BTH dest QP" access="RW" offset="0x3C.0" size="0x0.24" />
	<field name="psn_init_val" descr="BTH packet sequence number initial value\;Note: when reading, HW will reveal the current packet sequence number" access="RW" offset="0x40.0" size="0x0.24" />
	<field name="ar" descr="BTH MLNX adaptive routing enable flag" access="RW" offset="0x40.30" size="0x0.1" />
	<field name="qkey" descr="DETH QKey" access="RW" offset="0x44.0" size="0x4.0" />
	<field name="src_qp" descr="DETH source QP" access="RW" offset="0x48.0" size="0x0.24" />
</node>

<node name="mpat_encap_rmtethl2_ext" descr="" size="0x10.0" >
	<field name="mac_47_32" descr="Destination MAC address" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="dpa" descr="Dynamic port analyzer. \;When set to dynamic mode, the analyzer port is set based on the forwarding information for the {mac, vid} combination and not based on the system_port field. In static mode, the packet is transmitted to the configured system_port regardless of the forwarding database. Note that in Dynamic mode, if the switch FDB does not hold a filtering entry for the {mac, vid}, the mirroring copy is not flooded - it is discarded.\;0: STATIC_ANALYZER - static analyzer port\;1: DYNAMIC_ANALYZER - dynamic analyzer port\;Reserved when ubridge=1" access="RW" enum="STATIC_ANALYZER=0x0,DYNAMIC_ANALYZER=0x1" offset="0x0.16" size="0x0.2" />
	<field name="version" descr="ERSPAN mirror header version.\;0: V0 - Mirror Header Version 0\;1: V1 - Mirror Header Version 1. Reserved when SwitchX/-2\;2: V2 - Mirror Header Version 2. Reserved when SwitchX/-2 and for Spectrum\;\;15: NO_HEADER - No Mirror header" access="RW" enum="V0=0x0,V1=0x1,V2=0x2,NO_HEADER=0xf" offset="0x0.18" size="0x0.4" />
	<field name="swid" descr="Switch partition ID\;Reserved when dpa = static analyzer port\;Reserved when mngr_type = local port manager\;Switch partition ID is used for dynamic analyzer port, to set the Analyzer port based on the desired forwarding table (the one that belong to the swid).\;Reserved when Spectrum/-2" access="RW" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="Destination MAC address" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="vid" descr="When dpa = 0: Encapsulation header VLAN ID\;When dpa = 1 and fid &lt; 4K (fid_msb = 0) then: VLAN ID\;When dpa = 1 and fid &gt;=4K (fid_msb != 0) then: FID lsb" access="RW" offset="0x8.0" size="0x0.12" />
	<field name="dei" descr="Encapsulation header DEI. \;Reserved when qos is QoS maintain\;Reserved when tp = 0\;Reserved when SwitchX/-2" access="RW" offset="0x8.12" size="0x0.1" />
	<field name="pcp" descr="Encapsulation header PCP. \;Reserved when qos is QoS maintain\;Reserved when tp = 0" access="RW" offset="0x8.13" size="0x0.3" />
	<field name="tp" descr="Tag Packet. Indicates the mirroring header should be VLAN tagged.\;0: Mirror packet is un-tagged\;1: Mirror packet is tagged" access="RW" offset="0x8.16" size="0x0.1" />
	<field name="tclass" descr="Traffic Class\;For Spectrum: Switch Priority\;Reserved when qos is QoS maintain\;Reserved when imp=1" access="RW" offset="0xC.0" size="0x0.4" />
	<field name="vlan_et_id" descr="Encapsulation header VLAN Ethertype ID\;Default is &apos;0&apos;\;Ethertype IDs are configured by SVER, see Section 7.12.40, &quot;SVER - Switch VLAN EtherType Register&quot;, on page 1671\;Reserved when SwitchX/-2" access="RW" offset="0xC.16" size="0x0.2" />
	<field name="fid_msb" descr="FID msb\;Reserved when dpa=0" access="RW" offset="0xC.24" size="0x0.4" />
</node>

<node name="mpat_encap_rmtethl3gre_ext" descr="" size="0x50.0" >
	<field name="mac_47_32" descr="Destination MAC address" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="dpa" descr="Dynamic port analyzer. \;When set to dynamic mode, the analyzer port is set based on the forwarding information for the {mac, vid} combination and not based on the system_port field. In static mode, the packet is transmitted to the configured system_port regardless of the forwarding database. Note that in Dynamic mode, if the switch FDB does not hold a filtering entry for the {mac, vid}, the mirroring copy is not flooded - it is discarded.\;0: STATIC_ANALYZER - static analyzer port\;1: DYNAMIC_ANALYZER - dynamic analyzer port\;Reserved when ubridge=1" access="RW" enum="STATIC_ANALYZER=0x0,DYNAMIC_ANALYZER=0x1" offset="0x0.16" size="0x0.2" />
	<field name="version" descr="ERSPAN mirror header version.\;\;1: V1 - Mirror Header Version 1. Reserved when SwitchX/-2\;2: V2 - Mirror Header Version 2. Reserved when SwitchX/-2 and for Spectrum\;\;15: NO_HEADER - No Mirror header" access="RW" enum="V1=0x1,V2=0x2,NO_HEADER=0xf" offset="0x0.18" size="0x0.4" />
	<field name="swid" descr="Switch partition ID\;Reserved when dpa = static analyzer port\;Reserved when mngr_type = local port manager\;Switch partition ID is used for dynamic analyzer port, to set the Analyzer port based on the desired forwarding table (the one that belong to the swid).\;Reserved when Spectrum/-2" access="RW" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="Destination MAC address" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="vid" descr="When dpa = 0: Encapsulation header VLAN ID\;When dpa = 1 and fid &lt; 4K (fid_msb = 0) then: VLAN ID\;When dpa = 1 and fid &gt;=4K (fid_msb != 0) then: FID lsb" access="RW" offset="0x8.0" size="0x0.12" />
	<field name="dei" descr="Encapsulation header DEI. \;Reserved when qos is QoS maintain\;Reserved when tp = 0\;Reserved when SwitchX/-2" access="RW" offset="0x8.12" size="0x0.1" />
	<field name="pcp" descr="Encapsulation header PCP. \;Reserved when qos is QoS maintain\;Reserved when tp = 0" access="RW" offset="0x8.13" size="0x0.3" />
	<field name="tp" descr="Tag Packet. Indicates the mirroring header should be VLAN tagged.\;0: Mirror packet is un-tagged\;1: Mirror packet is tagged" access="RW" offset="0x8.16" size="0x0.1" />
	<field name="dscp" descr="Encapsulation header DSCP\;Reserved when qos is QoS maintain" access="RW" offset="0x8.18" size="0x0.6" />
	<field name="protocol" descr="0: IPV4\;1: IPV6" access="RW" enum="IPV4=0x0,IPV6=0x1" offset="0x8.24" size="0x0.4" />
	<field name="tclass" descr="Traffic Class\;For Spectrum: Switch Priority\;Reserved when qos is QoS maintain\;Reserved when imp=1" access="RW" offset="0xC.0" size="0x0.4" />
	<field name="ttl" descr="Encapsulation header Time-to-Live/HopLimit" access="RW" offset="0xC.4" size="0x0.8" />
	<field name="ecn" descr="Encapsulation header ECN" access="RW" offset="0xC.12" size="0x0.2" />
	<field name="vlan_et_id" descr="Encapsulation header VLAN Ethertype ID\;Default is &apos;0&apos;\;Ethertype IDs are configured by SVER, see Section 7.12.40, &quot;SVER - Switch VLAN EtherType Register&quot;, on page 1671\;Reserved when SwitchX/-2" access="RW" offset="0xC.16" size="0x0.2" />
	<field name="fid_msb" descr="FID msb\;Reserved when dpa=0" access="RW" offset="0xC.24" size="0x0.4" />
	<field name="smac_47_32" descr="Source MAC address" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="smac_31_0" descr="Source MAC address" access="RW" offset="0x14.0" size="0x4.0" />
	<field name="dip" descr="Destination IP address\;The IP version is configured by protocol\;IPv4 address uses bits dip[31:0] and bits dip[127:32] are reserved." access="RW" high_bound="3" low_bound="0" offset="0x30.0" size="0x10.0" />
	<field name="sip" descr="Source IP address\;The IP version is configured by protocol\;IPv4 address uses bits dip[31:0] and bits dip[127:32] are reserved." access="RW" high_bound="3" low_bound="0" offset="0x40.0" size="0x10.0" />
</node>

<node name="mpat_encap_rmtethvlan_ext" descr="" size="0x10.0" >
	<field name="vid" descr="Encapsulation header VLAN ID" access="RW" offset="0x8.0" size="0x0.12" />
	<field name="dei" descr="Encapsulation header DEI\;Reserved when qos is QoS maintain\;Reserved when SwitchX/-2" access="RW" offset="0x8.12" size="0x0.1" />
	<field name="pcp" descr="Encapsulation header PCP\;Reserved when qos is QoS maintain" access="RW" offset="0x8.13" size="0x0.3" />
	<field name="tclass" descr="Traffic Class.\;For Spectrum: Switch Priority\;Reserved when qos is QoS maintain\;Reserved when imp=1" access="RW" offset="0xC.0" size="0x0.4" />
	<field name="vlan_et_id" descr="Encapsulation header VLAN Ethertype ID\;Default is &apos;0&apos;\;Ethertype IDs are configured by SVER, see Section 7.12.40, &quot;SVER - Switch VLAN EtherType Register&quot;, on page 1671\;Reserved when SwitchX/-2" access="RW" offset="0xC.16" size="0x0.2" />
</node>

<node name="mpat_reg_encapsulation_auto_ext" descr="" attr_is_union="1" size="0x50.0" >
	<field name="local_span_ext" descr="" subnode="local_span_ext" offset="0x0.0" selected_by="LOCAL_ETH" size="0x10.0" />
	<field name="mpat_encap_rmtethvlan_ext" descr="" subnode="mpat_encap_rmtethvlan_ext" offset="0x0.0" selected_by="REMOTE_ETH" size="0x10.0" />
	<field name="mpat_encap_rmtethl2_ext" descr="" subnode="mpat_encap_rmtethl2_ext" offset="0x0.0" selected_by="REMOTE_ETH_L2" size="0x10.0" />
	<field name="mpat_encap_rmtethl3gre_ext" descr="" subnode="mpat_encap_rmtethl3gre_ext" offset="0x0.0" selected_by="REMOTE_ETH_L3" size="0x50.0" />
	<field name="mpat_encap_localib_ext" descr="" subnode="mpat_encap_localib_ext" offset="0x0.0" selected_by="LOCAL_IB" size="0x10.0" />
	<field name="remote_span_ib_local_ud_ext" descr="" subnode="remote_span_ib_local_ud_ext" offset="0x0.0" selected_by="REMOTE_IB_LOCAL_UD" size="0x4c.0" />
	<field name="mpat_encap_remoteib_ext" descr="" subnode="mpat_encap_remoteib_ext" offset="0x0.0" selected_by="REMOTE_IB_GLOBAL_UD" size="0x4c.0" />
</node>

<node name="mpat_reg_ext" descr="" size="0x84.0" >
	<field name="system_port" descr="If (mngr_type == &quot;Hypervisor&quot;)\;Unique port identifier for the final destination of the packet\;If (mngr_type == &quot;Local Network Manager&quot;) and the port from which the command came from is InfiniBand: \;ib port number\;If (mngr_type == &quot;Local Network Manager&quot;) and the port from which the command came from is Ethernet: \;Local Port\;For SwitchX/-2, Switch-IB/2 and Spectrum: CPU port is not supported\;For Quantum/-2: CPU port is supported\;For Spectrum-2: CPU port is supported\;Note: when CPU port:\;1. span_type must be LOCAL_ETH or LOCAL_IB\;2. tr is reserved (no truncation)\;Reserved when dpa = 1\;Reserved when imp=1" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="mngr_type" descr="Manager Type\;0: HYPERVISOR\;1: LOCAL_NETWORK_MANAGER\;For more details regarding Manager Type, refer to Section 2.14, &quot;Management Security Hierarchy&quot;, on page 563." access="OP" enum="HYPERVISOR=0x0,LOCAL_NETWORK_MANAGER=0x1" offset="0x0.16" size="0x0.4" />
	<field name="session_id" descr="Mirror Session ID.\;Used for MIRROR_SESSION&lt;i&gt; trap\;Reserved when SwitchX/-2, Switch-IB/2 and Spectrum" access="RW" offset="0x0.24" size="0x0.4" />
	<field name="pa_id" descr="Port Analyzer ID (a.k.a mirror-agent)\;Range 0 .. cap_max_span_analyzers - 1" access="INDEX" offset="0x0.28" size="0x0.4" />
	<field name="span_type" descr="See Table 1013, &quot;Span Types,&quot; on page 1267\;0x0: LOCAL_ETH\;0x1: REMOTE_ETH\;0x2: REMOTE_ETH_L2\;0x3: REMOTE_ETH_L3\;0x4: LOCAL_IB\;0xA: REMOTE_IB_LOCAL_UD\;0xB: REMOTE_IB_GLOBAL_UD" access="RW" enum="LOCAL_ETH=0x0,REMOTE_ETH=0x1,REMOTE_ETH_L2=0x2,REMOTE_ETH_L3=0x3,LOCAL_IB=0x4,REMOTE_IB_LOCAL_UD=0xa,REMOTE_IB_GLOBAL_UD=0xb" offset="0x4.0" size="0x0.4" />
	<field name="stclass" descr="Stacking TClass. TClass to be used if the packet is transmitted on a stacking port to be transmitted on a port in a different device.\;Reserved from Switch-IB/2, Quantum and Spectrum" access="RW" offset="0x4.13" size="0x0.3" />
	<field name="imp" descr="Is Multi Port:\;0: Mirror only to one port - according to system_port description\;1: Mirror to one of the multi_ports, see nmp description\;\;If nmp != 0, the decision to which port to mirror will be according to multi_port[ingress_port_lag_hash[1:0]]" access="OP" offset="0x4.16" size="0x0.1" />
	<field name="nmp" descr="Number of Multi Port:\;0: mirror to single port, multi_port[0]\;1: mirror to one of 2 ports, multi_port[0] and multi_port[1]\;2: mirror to one of 4 ports, multi_port[0] - multi_port[3]\;Reserved when imp = 0." access="OP" offset="0x4.17" size="0x0.2" />
	<field name="tr" descr="Truncate. Indicates all packets mirrored to this Analyzer port will be truncated.\;Truncation size is defined by truncation_size\;For Spectrum, packets from CPU to a truncation-enabled agent will not be mirrored. \;For Spectrum-2, packets from CPU to a truncation-enabled agent will be mirrored\;Reserved when system_port is to CPU\;Reserved when MPAT.itc = 1" access="RW" offset="0x4.24" size="0x0.1" />
	<field name="be" descr="Best Effort. Indicates mirroring traffic should not cause packet drop or back pressure but will discard the mirroring packets. Mirroring packets will be forwarded in a best effort manner.\;0: NOT_DISCARD - Do not discard mirrored packets\;1: DISCARD - Discard mirrored packets if causing congestion\;Relevant both for ingress mirror and egress mirror\;\;" access="RW" enum="NOT_DISCARD=0x0,DISCARD=0x1" offset="0x4.25" size="0x0.1" />
	<field name="qos" descr="Quality of Service mode\;0: CONFIGURED - QoS parameters (Switch Priority, and encapsulation PCP, DEI, DSCP or VL) are configured\;1: MAINTAIN - QoS parameters (Switch Priority, Color) are the same as in the original packet that has triggered the mirroring. For SPAN also the pcp,dei are maintained. Reserved when Spectrum.\;For SPAN packets the PCP, DEI is as mirrored packet\;For SwitchX/-2: this field is reserved.\;" access="RW" enum="CONFIGURED=0x0,MAINTAIN=0x1" offset="0x4.26" size="0x0.1" />
	<field name="c" descr="Clear counters\;Clears the buffer_drop and be_drop counters" access="OP" offset="0x4.28" size="0x0.1" />
	<field name="e" descr="Enable. Indicating the Port Analyzer is enabled\;Note: before disabling a port analyzer, software should make sure no port / rule is associated with the Port Analyzer to be disabled." access="RW" offset="0x4.31" size="0x0.1" />
	<field name="truncation_size" descr="Truncation Size.\;Sets the truncation size in case truncation is enabled. \;Unit is 1 byte.\;Granularity is 4 bytes. \;For Switch-IB/2 and Spectrum-1: minimum value is 32B\;For Quantum and Spectrum-2/3: minimum value is 48B\;For Spectrum-4: minimum value is 64B. \;For Switch-IB/2, all port analyzers must have the same truncation size.\;For SwitchX/-2, this value is set to 64 bytes and can not be changed in current FW version. For more details, contact NVIDIA Support.\;Reserved when span_type is LOCALIB\;Reserved when MPAT.itc = 1" access="RW" offset="0x8.0" size="0x0.13" />
	<field name="switch_prio" descr="Switch Prio for the mirrored packet.\;Reserved when imp=0.\;Reserved when q=1 (MAINTAIN).\;Reserved for IB-switch." access="RW" offset="0x8.16" size="0x0.4" />
	<field name="tclass" descr="Traffic class of the mirrored packet.\;Reserved when the mirror port is CPU port (it is set by HTGT.cpu_tclass).\;Reserved when imp=0.\;Reserved when q=1 (MAINTAIN).\;Reserved for IB-switch." access="RW" offset="0x8.24" size="0x0.4" />
	<field name="itc" descr="Ignore Truncation Configuration\;0: use MPAT.tr and MPAT.truncation_size to configure truncation profile\;1: use ITPR to configure truncation profile. See Table 1243, &quot;ITPR - Infrastructure Truncation Profile Register Fields,&quot; on page 1481\;Valid for Spectrum-4 and on." access="RW" offset="0x8.31" size="0x0.1" />
	<field name="pid" descr="Policer ID\;Range MOGCR.mirroring_pid_base .. (MOGCR.mirroring_pid_base + cap_max_span_analyzers - 1)\;See pid in QPCR, Section 12.14.7, &quot;QPCR - QoS Policer Configuration Register&quot;, on page 3066\;Note: the policer takes packet length prior to truncation. The policer must have color_aware=not, type=srDCM, violate_action=discard.\;Reserved when SwitchX/-2, Switch-IB/2, Spectrum and Quantum/-2" access="RW" offset="0xC.0" size="0x0.14" />
	<field name="pide" descr="Policer enable\;For more details about policers, refer to Section 11.7.6, &quot;Policer&quot;, on page 2805\;Note: for mirror to CPU: MPAT.pid is enabled then the trap-group-policer will not police\;Reserved when SwitchX/-2, Switch-IB/2, Spectrum and Quantum/-2" access="RW" offset="0xC.15" size="0x0.1" />
	<field name="encapsulation" descr="Remote SPAN encapsulation. The encapsulation information is based on the span_type field. The following tables provide a reference to the encapsulation fields for the different SPAN types: \;Table 1014, &quot;Local SPAN Layout,&quot; on page 1269.\;Table 1016, &quot;Remote SPAN Ethernet VLAN Layout,&quot; on page 1270.\;Table 1018, &quot;Encapsulated Remote SPAN Ethernet L2 Layout,&quot; on page 1271.\;Table 1020, &quot;Encapsulated Remote SPAN Ethernet L3 Layout,&quot; on page 1273.\;Table 1022, &quot;Local SPAN InfiniBand Layout,&quot; on page 1276.\;Table 1024, &quot;Remote SPAN InfiniBand Local UD Layout,&quot; on page 1277.\;Table 1026, &quot;Remote SPAN InfiniBand Global UD Layout,&quot; on page 1279." subnode="mpat_reg_encapsulation_auto_ext" access="RW" offset="0x10.0" size="0x50.0" union_selector="$(parent).span_type" />
	<field name="buffer_drop_high" descr="Counter:\;Number of packet drops on the analyzer agent due to buffer size\;Not supported when SwitchX/-2, Switch-IB and Quantum" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="buffer_drop_low" descr="Counter:\;Number of packet drops on the analyzer agent due to buffer size\;Not supported when SwitchX/-2, Switch-IB and Quantum" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="be_drop_high" descr="Counter:\;Number of packet drops on the analyzer agent due to Best Effort when be is enabled\;Not supported for SwitchX/2 and Switch-IB and Quantum" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="be_drop_low" descr="Counter:\;Number of packet drops on the analyzer agent due to Best Effort when be is enabled\;Not supported for SwitchX/2 and Switch-IB and Quantum" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="pc" descr="Pad Count\;0: No_padding\;1: TwoBytes_padding\;\;Supported from Spectrum-4 and above." access="RW" enum="No_padding=0x0,TwoBytes_padding=0x1" offset="0x78.0" size="0x0.2" />
	<field name="multi_port" descr="System port.\;If nmp != 0, CPU port cannot be used.\;If (mngr_type == &quot;Hypervisor&quot;)\;Unique port identifier for the final destination of the packet\;If (mngr_type == &quot;Local Network Manager&quot;) and the port from which the command came from is Ethernet: \;Local Port\;When CPU port:\;1. span_type must be LOCAL_ETH or LOCAL_IB\;2. tr is reserved (no truncation)" access="RW" high_bound="3" low_bound="0" offset="0x7C.16" size="0x8.0" />
</node>

<node name="mpcir_ext" descr="" size="0x10.0" >
	<field name="all" descr="If set to &apos;01&apos;, activates the flow of preparation for FW ISSU, on all services. The values in op-codes for &quot;per-service&quot; are ignored.\;If set to &apos;10&apos;, returns to operational state on all services. The values in op-codes for &quot;per-service&quot; are ignored.\;11 - Reserved" access="OP" offset="0x0.30" size="0x0.2" />
	<field name="ports" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields." access="OP" offset="0x4.0" size="0x0.2" />
	<field name="cpld" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.2" size="0x0.2" />
	<field name="module_mng" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.4" size="0x0.2" />
	<field name="thermal" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.6" size="0x0.2" />
	<field name="fans" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.8" size="0x0.2" />
	<field name="power" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.10" size="0x0.2" />
	<field name="voltage_current" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.12" size="0x0.2" />
	<field name="leds" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.14" size="0x0.2" />
	<field name="gearbox" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.16" size="0x0.2" />
	<field name="mads" descr="For each of the services, the following operations are available:\;0: N/A (no action)\;1: start preparation flow for FW ISSU \;2: return to operational service (end of FW ISSU flow)\;3: get status\;\;When set to &apos;3&apos;, the current status will appear in corresponding _stat fields.\;\;Note: mads is for IB only" access="OP" offset="0x4.18" size="0x0.2" />
	<field name="ports_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.0" size="0x0.2" />
	<field name="cpld_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.2" size="0x0.2" />
	<field name="module_mng_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.4" size="0x0.2" />
	<field name="thermal_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.6" size="0x0.2" />
	<field name="fans_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.8" size="0x0.2" />
	<field name="power_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.10" size="0x0.2" />
	<field name="voltage_current_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.12" size="0x0.2" />
	<field name="leds_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.14" size="0x0.2" />
	<field name="gearbox_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.16" size="0x0.2" />
	<field name="mads_stat" descr="Status for each of the services. \;0: not in FW ISSU flow state (FW ISSU flow is not initiated) \;1: done with preparations for FW ISSU flow\;2: Preparation for FW ISSU flow started but FW still not done service handling [Internal]: busy with some other critical flow)." access="RO" offset="0xC.18" size="0x0.2" />
</node>

<node name="mpcnt_reg_counter_set_auto_ext" descr="" attr_is_union="1" size="0xf8.0" >
	<field name="pcie_perf_counters_ext" descr="" subnode="pcie_perf_counters_ext" offset="0x0.0" selected_by="PCIE_performance_counters" size="0xf8.0" />
	<field name="pcie_physical_layer_ext" descr="" subnode="pcie_physical_layer_ext" offset="0x0.0" selected_by="PCIE_physical_layer_indications" size="0x4.0" />
</node>

<node name="mpcnt_reg_ext" descr="" size="0x100.0" >
	<field name="grp" descr="Performance counter group.\;0: PCIE_performance_counters\;3: PCIE_physical_layer_indications\; \;" access="INDEX" enum="PCIE_performance_counters=0x0,PCIE_physical_layer_indications=0x3" offset="0x0.0" size="0x0.6" />
	<field name="node" descr="the node within each depth." access="INDEX" offset="0x0.8" size="0x0.8" />
	<field name="pcie_index" descr="PCIe index number (Internal domain index)\;Reserved when access is from the host" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="depth" descr="depth level of the DUT of some hierarchy" access="INDEX" offset="0x0.24" size="0x0.6" />
	<field name="clr" descr="Clear counters. Setting the clr bit will reset the counter value for all counters in the counter group. This bit can be set for both Set() and Get() operation." access="WO" offset="0x4.31" size="0x0.1" />
	<field name="counter_set" descr="Counter set as described in\;Table 362, &quot;PCIe Performance Counters Data Layout,&quot; on page 690\;Table 368, &quot;PCIE Physical Layer Indication Layout,&quot; on page 696" subnode="mpcnt_reg_counter_set_auto_ext" access="RO" offset="0x8.0" size="0xf8.0" union_selector="$(parent).grp" />
</node>

<node name="mpecs_reg_ext" descr="" size="0x20.0" >
	<field name="node" descr="the node within each depth." access="INDEX" offset="0x0.8" size="0x0.8" />
	<field name="pcie_index" descr="PCIE index number\;Reserved when access is from the host" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="depth" descr="depth level of the DUT of some hierarchy" access="INDEX" offset="0x0.24" size="0x0.6" />
	<field name="capability_id" descr="capability ID as defined in PCIE spec" access="INDEX" offset="0x4.0" size="0x0.16" />
	<field name="reg_num" descr="Register number\;Byte offset from the beginning of the capability ID" access="INDEX" offset="0x8.0" size="0x0.16" />
	<field name="byte_enable" descr="Enable bit per byte\;bit 0 - byte 0 (bits 7:0)\;bit 1 - byte 1 (bits 15:8)\;bit 2 - byte 2 (bits 23:16)\;bit 3 - byte 3 (bits 31:24)\;Reserved for read operation." access="WO" offset="0xC.0" size="0x0.4" />
	<field name="status" descr="PCIE configuration space access status: \;0x0: SUCCESS - successful access\;0x1: FUNC_NUM_FAILURE - accessing unsupported configuration space function number\;0x2: CAP_ID_FAILURE - accessing unsupported configuration space capability ID number\;0x3: REG_NUM_FAILURE - accessing unsupported configuration space register number\;0x4: WRITE_FAILURE - write access to read-only configuration space\;0x5: PROTECTED_FAILURE - protected configuration" access="RO" enum="SUCCESS=0x0,FUNC_NUM_FAILURE=0x1,CAP_ID_FAILURE=0x2,REG_NUM_FAILURE=0x3,WRITE_FAILURE=0x4,PROTECTED_FAILURE=0x5" offset="0xC.8" size="0x0.8" />
	<field name="func_num" descr="Function number\;physical function index - see PCIE spec" access="INDEX" offset="0xC.16" size="0x0.8" />
	<field name="ext" descr="Extended or regular configuration space, as defined in PCIE spec:\;0 - Regular\;1 - Extended" access="INDEX" offset="0x10.0" size="0x0.2" />
	<field name="data" descr="" access="RW" offset="0x14.0" size="0x4.0" />
</node>

<node name="mpein_reg_ext" descr="" size="0x30.0" >
	<field name="node" descr="the node within each depth." access="INDEX" offset="0x0.8" size="0x0.8" />
	<field name="pcie_index" descr="PCIe index number (Internal domain index)\;Reserved when access is from the host, but can be used when operating in Socket-Direct mode." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="depth" descr="depth level of the DUT of some hierarchy" access="INDEX" offset="0x0.24" size="0x0.6" />
	<field name="link_speed_enabled" descr="Max Link Speed:\;Bit 0: 2.5G - (Gen1)\;Bit 1: 5G - (Gen2)\;Bit 2: 8G - (Gen3)\;Bit 4: 16G - (Gen4)\;Bit 5: 32G (Gen5)\;Bit 6: 32G PAM-4 (Gen6)" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="link_width_enabled" descr="Maximum Link Width enabled:\;1: 1x\;2: 2x\;4: 4x\;8: 8x\;16: 16x" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="link_speed_active" descr="Current Link Speed:\;Bit 0: 2.5G (Gen1)\;Bit 1: 5G (Gen2)\;Bit 2: 8G (Gen3)\;Bit 4: 16G (Gen4)\;Bit 5: 32G (Gen5)\;Bit 6: 32G PAM-4 (Gen6)" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="link_width_active" descr="Negotiated Link Width, pcie_link_width active:\;1: 1x\;2: 2x\;4: 4x\;8: 8x\;16: 16x" access="RO" offset="0xC.16" size="0x0.8" />
	<field name="lane0_physical_position" descr="The physical lane position of logical lane0" access="RO" offset="0xC.24" size="0x0.8" />
	<field name="num_of_vfs" descr="Number of Total Virtual Functions (for all PFs)" access="RO" offset="0x10.0" size="0x0.16" />
	<field name="num_of_pfs" descr="Number of Physical Functions (PFs)" access="RO" offset="0x10.16" size="0x0.16" />
	<field name="bdf0" descr="Bus Device Function - only for function0" access="RO" offset="0x14.16" size="0x0.16" />
	<field name="lane_reversal" descr="Reversal mode of the link:\;0 - straight \;1 - reversal\;\;Note: together with lane0_physical_position provide the physical lane." access="RO" offset="0x18.0" size="0x0.1" />
	<field name="port_type" descr="Indicates the specific type of this PCI Express Function. Note that different Functions in a multi-Function device can generally be of different types.\;0 - PCI Express Endpoint port\;4 - Root Port of PCI Express Root Complex\;5 - PCI Express Upstream port\;6 - PCI Express Downstream port" access="RO" offset="0x18.12" size="0x0.4" />
	<field name="pwr_status" descr="Indicates the status of PCI power consumption limitations.\;0: PCI power report could not be read.\;1: Sufficient power reported.\;2: Insufficient power reported.\;3-7: Reserved" access="RO" offset="0x18.16" size="0x0.3" />
	<field name="max_payload_size" descr="Max payload size in bytes:\;0 - 128B\;1 - 256B\;2 - 512B\;3 - 1024B\;4 - 2048B\;5 - 4096B" access="RO" offset="0x18.24" size="0x0.4" />
	<field name="max_read_request_size" descr="Max read request size in bytes:\;0 - 128B\;1 - 256B\;2 - 512B\;3 - 1024B\;4 - 2048B\;5 - 4096B" access="RO" offset="0x18.28" size="0x0.4" />
	<field name="pci_power" descr="Power reported by the PCI device. The units are in Watts.\;0: Power is unknown." access="RO" offset="0x1C.0" size="0x0.12" />
	<field name="link_peer_max_speed" descr="Peer Max Link Speed:\;Bit 0: 2.5G - (Gen1)\;Bit 1: 5G - (Gen2)\;Bit 2: 8G - (Gen3)\;Bit 4: 16G - (Gen4)\;Bit 5: 32G (Gen5)\;Bit 6: 32G PAM-4 (Gen6)" access="RO" offset="0x1C.16" size="0x0.16" />
	<field name="flit_sup" descr="FLIT is supported for the current active speed" access="RO" offset="0x20.0" size="0x0.1" />
	<field name="precode_sup" descr="Precoding is supported for the current active speed" access="RO" offset="0x20.1" size="0x0.1" />
	<field name="flit_active" descr="FLIT is active for the current speed" access="RO" offset="0x20.8" size="0x0.1" />
	<field name="precode_active" descr="precoding is active for the current speed" access="RO" offset="0x20.9" size="0x0.1" />
	<field name="device_status" descr="device_status bit mask:\;Bit 0: Correctable_error\;Bit 1: Non_Fatal_Error_detection\;Bit 2: Fatal_Error_detected\;Bit 3: Unsupported_request_detected\;Bit 4: AUX_power \;Bit 5: Transaction_Pending" access="RO" enum="Correctable_error=0x1,Non_Fatal_Error_detection=0x2,Fatal_Error_detected=0x4,Unsupported_request_detected=0x8,AUX_power=0x10,Transaction_Pending=0x20" offset="0x24.16" size="0x0.16" />
</node>

<node name="mpepm_ext" descr="" size="0x14.0" >
	<field name="exp" descr="EXP entry is the EXP to Switch Priority mapping.\;For more details, refer to Section 3265, &quot;mpepm_exp Layout&quot;, on page 3477" access="RW" high_bound="7" low_bound="0" offset="0x4.16" size="0x10.0" />
</node>

<node name="mpft_ext" descr="" size="0x8.0" >
	<field name="rif" descr="Router Interface to be bypassed by FRR" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="av" descr="label action valid:\;0 - set label_action to &apos;0&apos;: no php, no push\;1 - keep the label_action as is\;See Section 15.8.4.1, &quot;MPNHLFE Parameters - Forward to Ethernet&quot;, on page 3457" access="WO" offset="0x4.0" size="0x0.1" />
</node>

<node name="mpgcr_ext" descr="" size="0x24.0" >
	<field name="ler_exp_rw" descr="Ingress LER EXP Re-write Enable\;Initial value for exp_rewrite_en for ingress LER:\;2: Disable the exp_rewrite_en\;3: Enable the exp_rewrite_en" access="RW" offset="0x0.20" size="0x0.2" />
	<field name="mpls_pcp_rw" descr="LSR and LER PCP Re-write Enable\;Indicates how the MPLS handles the pcp_rewrite_en:\;0: Preserve the value of the pcp_rewrite_en\;2: Disable the pcp_rewrite_en\;3: Enable the pcp_rewrite_en\;Note: for ingress LER the RGCR may set the pcp_rw, and then the mpls will set it again." access="RW" offset="0x0.22" size="0x0.2" />
	<field name="mpls_et" descr="At ingress: MPLS Ethertype accepted for LSR and egress LER:\;1: Ethertype 0x8847\;2: Ethertype 0x8848\;3: Ethertype 0x8847 or Ethertype 0x8848\;If Ethertype not allowed then the packet is discarded at iRIF. \;" access="RW" offset="0x0.28" size="0x0.2" />
	<field name="ingress_ler_ttl_value" descr="Ingress LER TTL Value\;The value used in MPLS encapsulation when pushing a new label over IP packet in ingress LER. This value will not be decremented.\;Reserved when ingress_ler_ttl is 0\;Reserved when Spectrum-2, See QTTTL.enc_ttlc_uc" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="lsr_egress_ttl" descr="Egress LSR TTL (also for LSR PHP to Labels)\;Configures how the TTL of the exposed labels are set at LSR egress:\;1: COPY - The TTL is taken from the first popped label \;2: MINIMUM - The TTL is the minimum value between all popped labels\;Note: &quot;exposed labels&quot; are the labels pushed by NHLFE\;Note: the decrement of the TTL is done after the new value is set" access="RW" offset="0x4.16" size="0x0.2" />
	<field name="egress_ler_ttl" descr="Configures the TTL of IP header when IP packet is exposed\;\;0: PRESERVE - The TTL is taken from the IP header\;If the packet goes to IP router then the IP router will decrement the TTL\;\;1: COPY - The TTL is taken from the first popped label\;If the packet goes to IP router then the IP router will decrement the TTL\;If the packet is forwarded to outgoing interface then the TTL will be decremented\;\;2: MINIMUM - The TTL is the minimum value between all popped labels and the IP header\;If the packet goes to IP router then the IP router may decrement the TTL\;If the packet is forwarded to outgoing interface and TTL is taken from IP header then the TTL is not decremented\;If the packet is forwarded to outgoing interface and TTL is taken from Labels then the TTL is decremented\;Reserved when Spectrum-2, See QTTTL.decap_ttl" access="RW" offset="0x4.20" size="0x0.2" />
	<field name="ingress_ler_ttl" descr="Ingress LER TTL\;This flag indicates which value of TTL is written in the new pushed label in ingress LER: \;0: TTL is taken from the IP header\;1: TTL is configured by ingress_ler_ttl_value\;Note that the IP TTL was already decremented by the IP router. At ingress LER flow the LSR does not decremented the MPLS TTL.\;\;\;Reserved when Spectrum-2, See QTTTL.enc_ttlc" access="RW" offset="0x4.22" size="0x0.1" />
	<field name="hrlsn" descr="High Reserved Label ID Space Number\;Label IDs from 0 to hrlsn (inclusive) are accepted" access="RW" offset="0xC.0" size="0x0.8" />
	<field name="label_id_min" descr="Label IDs from label_id_min to label_id_max (inclusive both) are accepted" access="RW" offset="0x10.0" size="0x0.20" />
	<field name="label_id_max" descr="Label IDs from label_id_min to label_id_max (inclusive both) are accepted" access="RW" offset="0x14.0" size="0x0.20" />
	<field name="default_label_space" descr="Default label_space (default is 0)\;Range 0..cap_mpls_label_space-1\;" access="RW" offset="0x1C.0" size="0x0.16" />
	<field name="irif_vr_en" descr="irif virtual router enable\;0: use default_label_space or ACL based label space\;1: label_space is same as virtual_router" access="RW" offset="0x1C.16" size="0x0.1" />
	<field name="activity_dis_mpnhlfe" descr="Disable activity bit in MPNHLFE:\;0: enable - activity will be set when an entries are hit\;(default)\;1: disable - activity will not be set when an entries are hit\;See Section 15.8.4, &quot;MPNHLFE - MPLS NHLFE Table Register&quot;, on page 3455" access="RW" offset="0x20.0" size="0x0.1" />
</node>

<node name="mpibe_ext" descr="" size="0x28.0" >
	<field name="label_space" descr="Label Space\;Range 0 .. cap_mpls_label_space - 1" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="nhlfe_ptr" descr="NHLFE entry pointer which is used for matching on the existing entries in the ILM table" access="INDEX" offset="0x10.0" size="0x0.24" />
	<field name="ecmp_size" descr="ECMP size used for matching on the existing entries in the ILM table\;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175." access="INDEX" offset="0x14.0" size="0x0.13" />
	<field name="new_nhlfe_ptr" descr="New NHLFE pointer and ECMP size values" access="WO" offset="0x20.0" size="0x0.24" />
	<field name="new_ecmp_size" descr="New NHLFE pointer and ECMP size values" access="WO" offset="0x24.0" size="0x0.13" />
</node>

<node name="mpilem_ext" descr="" size="0x8.0" >
	<field name="mpls_ecn" descr="ECN of the pushed MPLS label" access="RW" offset="0x0.16" size="0x0.2" />
	<field name="ip_ecn" descr="ECN of the IP header in the ingress LER" access="INDEX" offset="0x0.24" size="0x0.2" />
</node>

<node name="mpilm_ext" descr="" size="0x18.0" >
	<field name="label_space" descr="Label Space\;Range 0 .. cap_mpls_label_space - 1" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="op" descr="Operation\;For Write:\;0: Write or over-write operation. \;1: Reserved \;2: Reserved \;3: Delete operation. Used to delete an existing entry. If entry doesn&apos;t exist, the operation fails.\;For Query:\;0: Read operation. If entry doesn&apos;t exist, the operation fails.\;" access="OP" offset="0x0.28" size="0x0.3" />
	<field name="label_id" descr="Label ID" access="INDEX" offset="0x4.0" size="0x0.20" />
	<field name="nhlfe_ptr" descr="Pointer to NHLFE.\;When using ECMP, points to the first entry in the ECMP list\;For Spectrum family, the index is to the KVD linear." access="RW" offset="0x8.0" size="0x0.24" />
	<field name="ecmp_size" descr="The amount of sequential entries starting from the nhlfe_ptr (the number of ECMPs)\;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175." access="RW" offset="0xC.0" size="0x0.13" />
	<field name="npop" descr="Number of labels to pop from the label stack.\;Range from 0 to cap_mpls_ilm_entry_pop" access="RW" offset="0xC.24" size="0x0.2" />
	<field name="trap_id" descr="Trap ID to be reported to CPU\;For Spectrum Trap-ID is MPLS_ILM0 or MPLS_ILM1\;For Spectrum-2/3 Trap-ID is MPLS_ILM0 .. MPLS_ILM3\;For trap_action of NOP, MIRROR and DISCARD_ERROR, trap_id is reserved" access="RW" offset="0x10.0" size="0x0.9" />
	<field name="trap_action" descr="Trap Action\;0: NOP\;1: TRAP\;2: MIRROR_TO_CPU\;3: MIRROR\;4: DISCARD_ERROR" access="RW" enum="NOP=0x0,TRAP=0x1,MIRROR_TO_CPU=0x2,MIRROR=0x3,DISCARD_ERROR=0x4" offset="0x10.28" size="0x0.4" />
	<field name="counter_index" descr="Counter Index for flow counters.\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX and SwitchX-2" access="RW" offset="0x14.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters.\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX and SwitchX-2" access="RW" offset="0x14.24" size="0x0.8" />
</node>

<node name="mpir_ext" descr="" size="0x10.0" >
	<field name="host_buses" descr="Number of PCIe buses available for the host to connect ot the device.\;&apos;0&apos; when operating in non-Socket-Direct mode." access="RO" offset="0x0.0" size="0x0.4" />
	<field name="node" descr="the node within each depth." access="INDEX" offset="0x0.8" size="0x0.8" />
	<field name="pcie_index" descr="Internal domain index" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="depth" descr="depth level of the DUT of some hierarchy" access="INDEX" offset="0x0.24" size="0x0.6" />
	<field name="sdm" descr="Socket-Direct mode indication.\;0: non-Socket-Direct mode (single host or multi-host)\;1: Socket-Direct mode, for querying host" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="subordinate_bus" descr="sunbordinate bus - the highest bus number that subordinates to switch.\;Default value of &apos;0&apos; in case it is not a switch port." access="RO" offset="0x4.0" size="0x0.8" />
	<field name="secondary_bus" descr="secondary bus - the internal logic bus in the switch. \;Default value of &apos;0&apos; in case it is not a switch port." access="RO" offset="0x4.8" size="0x0.8" />
	<field name="device" descr="PCIe device number." access="RO" offset="0x8.3" size="0x0.5" />
	<field name="lp_msb" descr="2-bit expansion of the local port. Represents the local_port[9:8] bits" access="RO" offset="0x8.12" size="0x0.2" />
	<field name="bus" descr="PCIe bus number." access="RO" offset="0x8.16" size="0x0.8" />
	<field name="local_port" descr="Local port number" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="slot_number" descr="Slot number" access="RO" offset="0xC.0" size="0x0.13" />
	<field name="num_con_devices" descr="number of PCIe connected deices / EP on the current port." access="RO" offset="0xC.16" size="0x0.8" />
	<field name="slot_cap" descr="If set to &apos;1&apos;, slot_number field is supported." access="RO" offset="0xC.31" size="0x0.1" />
</node>

<node name="mpls_adjacency_ext" descr="" size="0x18.0" >
	<field name="nhlfe_ptr" descr="NHLFE entry pointer\;Points to the NHLFE table. When using ECMP, points to the first entry in the ECMP list." access="RW" offset="0x0.0" size="0x0.24" />
	<field name="ecmp_size" descr="ecmp_size is the amount of sequential entries from the nhlfe_ptr (the number of ECMPs). \;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175." access="RW" offset="0x4.0" size="0x0.13" />
	<field name="tqos_profile" descr="Tunnel QoS profile\;0..cap_max_tqos_profile \;Reserved when Spectrum" access="RW" offset="0x4.24" size="0x0.4" />
	<field name="underlay_router_interface" descr="Underlay ingress router interfaceReserved when Spectrum" access="RW" offset="0x10.0" size="0x0.16" />
</node>

<node name="mpnhlfe_ext" descr="" size="0x5c.0" >
	<field name="a" descr="Activity. Set for new entries. Set if a packet lookup has hit on the specific entry. \;To clear the a bit, use &quot;clear activity&quot; ca operation.\;Enabled by activity_dis in MPGCR, see Section 15.8.1, &quot;MPGCR - MPLS General Configuration Register&quot;, on page 3448" access="RO" offset="0x0.16" size="0x0.1" />
	<field name="ca" descr="Clear activity, valid only for read access:\;0: do not clear activity\;1: clear activity" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="nhlfe_ptr" descr="NHLFE Index\;For Spectrum, the index is to the KVD linear, see Appendix A.4.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3813)" access="INDEX" offset="0x4.0" size="0x0.24" />
	<field name="v" descr="Valid indication\;" access="RW" offset="0x4.31" size="0x0.1" />
	<field name="forward_action" descr="NHLFE Action\;0: Forward_to_Ethernet\;1: Forward_to_IP_Router\;2: Continue_Lookups - if there is another label then lookup ILM, else Forward to IP Router\;3: Next_NHLFE\;" access="RW" enum="Forward_to_Ethernet=0x0,Forward_to_IP_Router=0x1,Continue_Lookups=0x2,Next_NHLFE=0x3" offset="0x8.0" size="0x0.4" />
	<field name="trap_id" descr="Trap ID to be reported to CPU\;For Spectrum Trap-ID is MPLS_NHLFE0 or MPLS_NHLFE1\;For Spectrum-2/3 Trap-ID is MPLS_NHLFE0 .. MPLS_NHLFE3\;For trap_action of NOP, MIRROR and DISCARD__ERROR trap_id is reserved" access="RW" offset="0xC.0" size="0x0.9" />
	<field name="trap_action" descr="Trap Action\;0: NOP\;1: TRAP\;2: MIRROR_TO_CPU\;3: MIRROR\;4: DISCARD_ERROR, see DISCARD_LSR3 trap_id" access="RW" offset="0xC.28" size="0x0.4" />
	<field name="counter_index" descr="Counter Index for flow counters.\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX and SwitchX-2" access="RW" offset="0x10.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters.\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX and SwitchX-2" access="RW" offset="0x10.24" size="0x0.8" />
	<field name="nhlfe_parameters" descr="The fields in parameters are depended on forward_action as follows:\;Table 3247, &quot;Parameters - Forward to Ethernet Layout,&quot; on page 3457\;Table 3249, &quot;Parameters - Forward to IP Router Layout,&quot; on page 3461\;Table 3251, &quot;Parameters - Continue Lookups Layout,&quot; on page 3464\;Table 3253, &quot;Parameters - Next NHLFE Layout,&quot; on page 3468\;" subnode="mpnhlfe_nhlfe_parameters_auto_ext" access="RW" offset="0x30.0" size="0x2c.0" union_selector="$(parent).forward_action" />
</node>

<node name="mpnhlfe_nhlfe_parameters_auto_ext" descr="" attr_is_union="1" size="0x2c.0" >
	<field name="mpnhlfe_param_eth_ext" descr="" subnode="mpnhlfe_param_eth_ext" offset="0x0.0" selected_by="Forward_to_Ethernet" size="0x2c.0" />
	<field name="mpnhlfe_param_iprouter_ext" descr="" subnode="mpnhlfe_param_iprouter_ext" offset="0x0.0" selected_by="Forward_to_IP_Router" size="0x2c.0" />
	<field name="mpnhlfe_param_lookups_ext" descr="" subnode="mpnhlfe_param_lookups_ext" offset="0x0.0" selected_by="Continue_Lookups" size="0x2c.0" />
	<field name="next_nhlfe_ext" descr="" subnode="next_nhlfe_ext" offset="0x0.0" selected_by="Next_NHLFE" size="0x2c.0" />
</node>

<node name="mpnhlfe_param_eth_ext" descr="" size="0x2c.0" >
	<field name="bos_check" descr="Check BoS field:\;0: Do not check BoS field\;1: BoS field must be &apos;0&apos;, do not forward to IP Router\;2: Bos Field must be &apos;1&apos;\;Reserved when Spectrum" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="tqos_profile" descr="Tunnel QoS profile\;Reserved when Spectrum-2/-3\;Spectrum-2/3: hard coded to &apos;2&apos; by the HW\;Supported from Spectrum-4" access="RW" offset="0x0.12" size="0x0.4" />
	<field name="exp" descr="EXP value for set_exp\;Ignored by the device when protection_active = 1" access="RW" offset="0x0.16" size="0x0.3" />
	<field name="set_exp" descr="Set the packet EXP with exp value\;Ignored by the device when protection_active = 1" access="RW" offset="0x0.19" size="0x0.1" />
	<field name="exp_rw" descr="EXP Re-write\;0: Preserve the value of the rewrite_enable\;1: Set the rewrite_enable\;2: Clear the rewrite_enable\;Ignored by the device when protection_active = 1" access="RW" offset="0x0.20" size="0x0.2" />
	<field name="usp_exp" descr="Update Switch Priority and Packet Color based on EXP\;Forces recalculation of the Switch Priority and Packet Color based on the packet&apos;s EXP field as configured by MPEPM. Relevant for packets within the MPLS domain.\;Note: the function of set_exp is done prior to the function of usp_exp\;Ignored by the device when protection_active = 1\;See Section 15.8.7, &quot;MPEPM - MPLS EXP to Priority Mapping Register&quot;, on page 3477." access="RW" offset="0x0.24" size="0x0.1" />
	<field name="usp_dscp" descr="Update Switch Priority and Packet Color based on DSCP\;Forces recalculation of the Switch Priority and Packet Color based on the packet&apos;s DSCP field as configured by RDPM. \;Reserved when label_action != 1 (PHP)\;Ignored by the device when protection_active = 1\;See Section 14.15.18, &quot;RDPM - Router DSCP to Priority Mapping Register&quot;, on page 3306\;" access="RW" offset="0x0.25" size="0x0.1" />
	<field name="uecn_exp" descr="Update ECN from EXP.\;Forces recalculation of the ECN based on the packet&apos;s EXP field as configured by QEPM of the ingress port.\;Reserved when Spectrum" access="RW" offset="0x0.26" size="0x0.1" />
	<field name="dscp_rw" descr="DSCP Re-write Enable.\;Controlling the rewrite_enable for DSCP:\;0: Preserve the value of the rewrite_enable bit\;1: Set the rewrite_enable bit\;2: Clear the rewrite_enable bit\;Reserved when label_action != 1 (PHP)\;Ignored by the device when protection_active = 1\;" access="RW" offset="0x0.28" size="0x0.2" />
	<field name="label_id" descr="Label id to push to the label stack\;Reserved when label_action is &apos;0&apos;, &apos;1&apos;" access="RW" offset="0x4.0" size="0x0.20" />
	<field name="label_action" descr="Label action:\;\;1: php. Enables updating the EXP/DSCP and TTL of outermost label. When protection_active = &apos;1&apos; this does nothing.\;2: push label. Push a new label with label id label_id \;\;\;\;" access="RW" offset="0x4.24" size="0x0.3" />
	<field name="dmac_47_32" descr="Destination MAC\;The MAC address of the next hop\;Ignored by the device when protection_active = 1" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="dmac_31_0" descr="Destination MAC\;The MAC address of the next hop\;Ignored by the device when protection_active = 1" access="RW" offset="0xC.0" size="0x4.0" />
	<field name="egress_router_interface" descr="Egress RIF\;Ignored by the device when protection_active = 1" access="RW" offset="0x10.0" size="0x0.16" />
</node>

<node name="mpnhlfe_param_iprouter_ext" descr="" size="0x2c.0" >
	<field name="tqos_profile" descr="Tunnel QoS profile\;0..cap_max_tqos_profile \;Reserved when Spectrum" access="RW" offset="0x0.16" size="0x0.4" />
	<field name="usp_exp" descr="Update Switch Priority and Packet Color based on EXP\;Forces recalculation of the Switch Priority and Packet Color based on the packet&apos;s EXP field as configured by MPEPM. Relevant for packets within the MPLS domain.\;Note: the function of set_exp is done prior to the function of usp_exp\;Ignored by the device when protection_active = 1\;See Section 15.8.7, &quot;MPEPM - MPLS EXP to Priority Mapping Register&quot;, on page 3477.\;Reserved when Spectrum" access="RW" offset="0x0.24" size="0x0.1" />
	<field name="usp_dscp" descr="Update Switch Priority and Packet Color based on DSCP\;Forces recalculation of the Switch Priority and Packet Color based on the packet&apos;s DSCP field as configured by RDPM. Note that this field is takes effect only if the IP header tis exposed as a result of this NHLFE action. See Section 14.15.18, &quot;RDPM - Router DSCP to Priority Mapping Register&quot;, on page 3306\;When Spectrum-2 then reserved when irifv = &apos;0&apos;\;" access="RW" offset="0x0.25" size="0x0.1" />
	<field name="uecn_exp" descr="Update ECN from EXP.\;Forces recalculation of the ECN based on the packet&apos;s EXP field as configured by QEPM of the ingress port.\;Reserved when Spectrum" access="RW" offset="0x0.26" size="0x0.1" />
	<field name="dscp_rw" descr="DSCP Re-write Enable\;Controlling the rewrite_enable for DSCP:\;0: Preserve the value of the rewrite_enable bit\;1: Set the rewrite_enable bit\;2: Clear the rewrite_enable bit\;Note that this field takes effect only if the IP header is exposed as a result of this NHLFE action.\;When Spectrum-2 then reserved when irifv = &apos;0&apos;\;" access="RW" offset="0x0.28" size="0x0.2" />
	<field name="irif" descr="Ingress Router Interface used for forwarding the packet to the router. \;Reserved when irifv = &apos;0&apos;" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="irifv" descr="irif is valid \;Indicates that the irif, dscp_rw, usp_dscp are field is valid. \;Useful for the case that Continue Lookups have a valid irif. If multiple NHLFE lookups are performed, the device will use the last valid iri. SW must make sure that at least 1 irif is valid otherwise the packet will be discarded\;" access="RW" offset="0xC.24" size="0x0.1" />
	<field name="egress_router_interface" descr="Egress RIF \;Reserved when erifv = &apos;0&apos;\;Reserved when Spectrum" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="erifv" descr="egress_router_interface is valid\;Erif is needed as MPLS erif when forward to IP router. If another lookup is done then the erif is stored for this packet for later use.\;SW must make sure that at least 1 erif is valid otherwise the packet will be discarded\;Reserved when Spectrum" access="RW" offset="0x10.24" size="0x0.1" />
	<field name="cbset_select" descr="Select cbset:\;Spectrum-2: Range 0..7\;" access="RW" offset="0x18.0" size="0x0.3" />
	<field name="cbset_val" descr="Value for setting cbset\;Reserved when Spectrum" access="RW" offset="0x1C.0" size="0x0.16" />
	<field name="cbset_mask" descr="Mask for setting cbset_val\;Per bit:\;0: do not update\;1: update\;Reserved when Spectrum" access="RW" offset="0x20.0" size="0x0.16" />
</node>

<node name="mpnhlfe_param_lookups_ext" descr="" size="0x2c.0" >
	<field name="bos_check" descr="Check BoS field:\;0: Do not check BoS field\;1: BoS field must be &apos;0&apos;, do not forward to IP Router\;2: Bos Field must be &apos;1&apos;, note: behaves like &quot;Forward to IP Router&quot;\;Reserved when Spectrum" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="tqos_profile" descr="Tunnel QoS profile\;0..cap_max_tqos_profile \;Reserved when Spectrum" access="RW" offset="0x0.16" size="0x0.4" />
	<field name="usp_exp" descr="Update Switch Priority and Packet Color based on EXP\;Forces recalculation of the Switch Priority and Packet Color based on the packet&apos;s EXP field as configured by MPEPM. Relevant for packets within the MPLS domain.\;Note: the function of set_exp is done prior to the function of usp_exp\;Ignored by the device when protection_active = 1\;See Section 15.8.7, &quot;MPEPM - MPLS EXP to Priority Mapping Register&quot;, on page 3477.\;Reserved when Spectrum" access="RW" offset="0x0.24" size="0x0.1" />
	<field name="usp_dscp" descr="Update Switch Priority and Packet Color based on DSCP\;Forces recalculation of the Switch Priority and Packet Color based on the packet&apos;s DSCP field as configured by RDPM. \;This field is ignored by the device when lookup on next label is done\;See Section 14.15.18, &quot;RDPM - Router DSCP to Priority Mapping Register&quot;, on page 3306\;When Spectrum-2 then reserved when irifv = &apos;0&apos;\;" access="RW" offset="0x0.25" size="0x0.1" />
	<field name="uecn_exp" descr="Update ECN from EXP.\;Forces recalculation of the ECN based on the packet&apos;s EXP field as configured by QEPM of the ingress port.\;Reserved when Spectrum" access="RW" offset="0x0.26" size="0x0.1" />
	<field name="dscp_rw" descr="DSCP Re-write Enable\;Controlling the rewrite_enable for DSCP:\;0: Preserve the value of the rewrite_enable bit\;1: Set the rewrite_enable bit\;2: Clear the rewrite_enable bit\;This field is ignored by the device when lookup on next label is done\;When Spectrum-2 then reserved when irifv = &apos;0&apos;\;" access="RW" offset="0x0.28" size="0x0.2" />
	<field name="irif" descr="Ingress Router Interface used for forwarding the packet to the router. \;Reserved when irifv = &apos;0&apos;" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="irifv" descr="irif is valid\;Indicates that the irif, dscp_rw, usp_dscp are field is valid. \;Irif is needed for forward to IP router. If another lookup is done then the irif is stored for this packet for later use.\;SW must make sure that at least 1 irif is valid otherwise the packet will be discarded\;" access="RW" offset="0xC.24" size="0x0.1" />
	<field name="egress_router_interface" descr="Egress RIF \;Reserved when erifv = &apos;0&apos;\;Reserved when Spectrum" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="erifv" descr="egress_router_interface is valid\;Erif is needed as MPLS erif when forward to IP router. If another lookup is done then the erif is stored for this packet for later use.\;SW must make sure that at least 1 erif is valid otherwise the packet will be discarded\;Reserved when Spectrum" access="RW" offset="0x10.24" size="0x0.1" />
	<field name="cbset_select" descr="Select cbset:\;Spectrum-2: Range 0..7\;" access="RW" offset="0x18.0" size="0x0.3" />
	<field name="cbset_val" descr="Value for setting cbset" access="RW" offset="0x1C.0" size="0x0.16" />
	<field name="cbset_mask" descr="Mask for setting cbset_val\;Per bit:\;0: do not update\;1: update" access="RW" offset="0x20.0" size="0x0.16" />
</node>

<node name="mpnhlfeb_ext" descr="" size="0x410.0" >
	<field name="v" descr="Valid\;0: Remove ecmp entries\;1: Write ecmp entries" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="nhlfe_ptr" descr="Index in the NHLFE table\;For Spectrum, the index is to the KVD linear, see Section A.4.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3813" access="INDEX" offset="0x4.0" size="0x0.24" />
	<field name="num_rec" descr="Number of records" access="OP" offset="0x8.0" size="0x0.8" />
	<field name="trap_id" descr="Trap ID to be reported to CPU\;Trap-ID is MPLS_NHLFE0 .. MPLS_NHLFE3\;For trap_action of NOP, MIRROR and DISCARD__ERROR trap_id is reserved" access="WO" offset="0xC.0" size="0x0.9" />
	<field name="trap_action" descr="Trap Action\;0: NOP\;1: TRAP\;2: MIRROR_TO_CPU\;3: MIRROR\;4: DISCARD_ERROR" access="WO" enum="NOP=0x0,TRAP=0x1,MIRROR_TO_CPU=0x2,MIRROR=0x3,DISCARD_ERROR=0x4" offset="0xC.28" size="0x0.4" />
	<field name="counter_index" descr="Counter Index for flow counters.\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX and SwitchX-2" access="WO" offset="0x10.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters.\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX and SwitchX-2" access="WO" offset="0x10.24" size="0x0.8" />
	<field name="record" descr="Record\;See Table 3259, &quot;MPNHLFEB - Record Layout,&quot; on page 3475" subnode="mpnhlfeb_record_ext" access="WO" high_bound="20" low_bound="0" offset="0x20.0" size="0x3f0.0" />
</node>

<node name="mpnhlfeb_record_ext" descr="" size="0x30.0" >
	<field name="size" descr="Size\;The amount of entries to be written for this record. Allows writing this record multiple consecutive times\;Range 1..4095" access="WO" offset="0x0.16" size="0x0.12" />
	<field name="forward_action" descr="NHLFE Action:\;0: Forward_to_Ethernet\;1: Forward_to_IP_Router\;2: Continue_Lookups - If there is another label then lookup ILM, else Forward to IP Router\;3: Next_NHLFE" access="WO" enum="Forward_to_Ethernet=0x0,Forward_to_IP_Router=0x1,Continue_Lookups=0x2,Next_NHLFE=0x3" offset="0x0.28" size="0x0.4" />
	<field name="nhlfe_parameters" descr="The fields in parameters are depended on forward_action as follows:\;Table 3247, &quot;Parameters - Forward to Ethernet Layout,&quot; on page 3457\;Table 3249, &quot;Parameters - Forward to IP Router Layout,&quot; on page 3461\;Table 3251, &quot;Parameters - Continue Lookups Layout,&quot; on page 3464\;Table 3253, &quot;Parameters - Next NHLFE Layout,&quot; on page 3468" subnode="mpnhlfeb_record_nhlfe_parameters_auto_ext" access="WO" offset="0x4.0" size="0x2c.0" union_selector="$(parent).forward_action" />
</node>

<node name="mpnhlfeb_record_nhlfe_parameters_auto_ext" descr="" attr_is_union="1" size="0x2c.0" >
	<field name="mpnhlfe_param_eth_ext" descr="" subnode="mpnhlfe_param_eth_ext" offset="0x0.0" selected_by="Forward_to_Ethernet" size="0x2c.0" />
	<field name="mpnhlfe_param_iprouter_ext" descr="" subnode="mpnhlfe_param_iprouter_ext" offset="0x0.0" selected_by="Forward_to_IP_Router" size="0x2c.0" />
	<field name="mpnhlfe_param_lookups_ext" descr="" subnode="mpnhlfe_param_lookups_ext" offset="0x0.0" selected_by="Continue_Lookups" size="0x2c.0" />
	<field name="next_nhlfe_ext" descr="" subnode="next_nhlfe_ext" offset="0x0.0" selected_by="Next_NHLFE" size="0x2c.0" />
</node>

<node name="mppcr_ext" descr="" size="0x40.0" >
	<field name="profile_id" descr="Profile id\;Valid values: 0-15" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="v" descr="Valid\;0: Profile is not valid\;1: Profile is valid" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="param_b" descr="reserved for future use" access="RW" high_bound="3" low_bound="0" offset="0x4.24" size="0x4.0" />
	<field name="profile_name" descr="Profile Name. Array of 20 char, Null terminated\;Can&apos;t change profile which is currently used by FW" access="RW" high_bound="19" low_bound="0" offset="0x8.24" size="0x14.0" />
	<field name="profile_config" descr="Profile configuration" subnode="power_profile_config_ext" access="RW" high_bound="1" low_bound="0" offset="0x20.0" size="0x20.0" />
</node>

<node name="mppdr_ext" descr="" size="0x40.0" >
	<field name="vr_power" descr="Power consumption read from VR" access="RO" high_bound="63" low_bound="0" offset="0x0.24" size="0x40.0" />
</node>

<node name="mppgcr_ext" descr="" size="0x24.0" >
	<field name="e" descr="Enable\;0: Power profiling is disabled\;1: Power profiling is enabled \;2-3: Reserved" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="curr_profile_id" descr="The actual profile id used by the FW.\;See Table 627, &quot;MPPCR - Management Power Profiling Configuration Register Layout,&quot; on page 959\;Valid values: 0-15" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="next_profile_id" descr="The next profile id to be used by the FW.\;See Table 627, &quot;MPPCR - Management Power Profiling Configuration Register Layout,&quot; on page 959\;Valid values: 0-15" access="RW" offset="0x4.16" size="0x0.8" />
	<field name="idle_power_a_factor" descr="Idle Power A factor to be used when calculating Idle power\;" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="idle_power_b_factor" descr="Idle Power B factor to be used when calculating Idle power" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="port_power_factor" descr="" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="active_power_factor" descr="" access="RW" offset="0x14.0" size="0x0.16" />
	<field name="port_peak_c_dyn" descr="" access="RW" offset="0x18.0" size="0x0.16" />
	<field name="sampling_time" descr="Units of 0.5 msec\;Defines the INA sampling time done by the FW" access="RW" offset="0x1C.0" size="0x0.8" />
	<field name="shaper_adj_num_of_iter" descr="Num of MPPGCR.sampling_time iterations to update the shaper" access="RW" offset="0x1C.16" size="0x0.8" />
	<field name="min_shaper" descr="Min shaper value to be used by FW" access="RW" offset="0x20.0" size="0x0.8" />
</node>

<node name="mppgh_ext" descr="" size="0x30.0" >
	<field name="op" descr="Operation\;0: Read only\;1: Clear counters and Read" access="OP" offset="0x0.0" size="0x0.2" />
	<field name="shaper_bin" descr="Shaper Bin\;Each bin represent 5 percent.\;For example, \;shaper_bin[0] will be incremented every time FW configured shaper value 0%-6.25%.\;shaper_bin[1] will be incremented every time FW configured shaper value 6.25%-12.5%\;..\;shaper_bin[15] will be incremented every time FW configured shaper value 93.75%-100%" access="RO" high_bound="15" low_bound="0" offset="0x10.16" size="0x20.0" />
</node>

<node name="mppgs_ext" descr="" size="0x10.0" >
	<field name="op" descr="Operation\;0: Read only\;1: Clear counters and Read" access="OP" offset="0x0.0" size="0x0.2" />
	<field name="critical_power_cnt" descr="Number of times identified critical power indication." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="short_win_power_avg" descr="Power average calculated on the short window" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="long_win_power_avg" descr="Power average calculated on the long window" access="RO" offset="0xC.0" size="0x0.16" />
</node>

<node name="mpqdr_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number (receive port)\;Supported from CPU port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="exp" descr="For ingress LER, the default EXP" access="RW" offset="0x4.0" size="0x0.3" />
</node>

<node name="mprs_ext" descr="" size="0x14.0" >
	<field name="parsing_depth" descr="Minimum Parsing Depth\;Units of Bytes. \;Need to enlarge parsing depth according to L3, MPLS, tunnels, ACL rules, custom_bytes, traps, hash etc. \;Default is 96B\;Value must be larger than 0\;The device will parse no deeper than cap_max_parsing_depth\;Reserved when SwitchX/-2\;\;" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="ctipl_dis" descr="If set, ctipl_l2_length and ctipl fields are reserved.\;Default value is 0.\;[Spectrum-5] Reserved in Spectrum-5." access="OP" offset="0x0.29" size="0x0.1" />
	<field name="prs_depth_dis" descr="If set, parsing_depth and parsing_en fields are reserved.\;Default value is 0." access="OP" offset="0x0.30" size="0x0.1" />
	<field name="en_l4_raw_prs" descr="Enable L4 RAW parsing and L4 inner RAW parsing.\;Parser will extract 4 bytes after IP header to l4_raw and will extract 4 bytes after inner IP header for inner_l4_raw.\;See l4_extended_types in Table 2136, &quot;ACL Key Elements - L4 Group,&quot; on page 2549\;Default value is 0.\;" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="parsing_en" descr="Parsing enable\;Bit0: enable parsing of NVE of types VXLAN, VXLAN-GPE, GENEVE and NVGRE, default enabled\;Note: for proper parsing the parsing_depth must also be configured\;Reserved when SwitchX/-2 also reserved when Spectrum-2 since Spectrum-2 supports concurrent QinQ and NVE" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="ctipl_l2_length" descr="L2 header length to be added to IP length for Cut Through IP Length Based mode\;This length should include DMAC, SMAC, L2 tags (VLANs etc.), MPLS labels. e.g. configure 52 for DMAC+SMAC + 10 tags/labels\;Units of Bytes\;Reserved when ctipl = 0.\;[Spectrum-5] Reserved in Spectrum-5." access="RW" offset="0x8.0" size="0x0.7" />
	<field name="ctipl" descr="Cut Through IP Length Based\;0: Cut through from low to high rate is based on MTU and port rates (default)\;1: Cut through from low to high rate is based on IP Length and port rates for IP packets, else, based on MTU\;[Spectrum-5] Reserved in Spectrum-5." access="RW" offset="0x8.8" size="0x0.1" />
	<field name="vxlan_udp_dport" descr="VXLAN UDP destination port\;Used for identifying VXLAN packets and for dport field in encapsulation\;Default 4789" access="RW" offset="0x10.0" size="0x0.16" />
</node>

<node name="mpsc_ext" descr="" size="0x14.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number (Rx ports)\;Not supported from CPU port\;Not supported from router port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="cong" descr="Congestion\;Sample only when egress congestion\;The congestion configuration is done by SBCTC, see\;Section 10.11.1, &quot;SBCTC - Shared Buffer Congestion Threshold Configuration Register&quot;, on page 2468\;For Switch-IB/2 the congestion is port congestion. Thus need to configure port congestion in SBGCR.tele_entitiy, see Section 10.8.1, &quot;SBGCR - Shared Buffer Global Configuration Register&quot;, on page 2429\;For Switch-IB/2 this is a global configuration, affecting all local_ports\;Reserved when Spectrum/-2/-3" access="RW" offset="0x4.29" size="0x0.1" />
	<field name="e" descr="Enable\;0: Disable sampling on port local_port (disabled)\;1: Enable sampling on port local_port" access="RW" offset="0x4.30" size="0x0.1" />
	<field name="c" descr="Clear counter\;Clears the count_sample_drop" access="OP" offset="0x4.31" size="0x0.1" />
	<field name="rate" descr="Sampling rate = 1 out of rate packets (with randomization around the point)\;Valid values are: 1 to 3.5*10^9\;" access="RW" offset="0x8.0" size="0x4.0" />
	<field name="count_sample_drops_high" descr="A count of frames that were discarded after sampling. Discard is due to CPU policers or lack of resources towards the CPU.\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="count_sample_drops_low" descr="A count of frames that were discarded after sampling. Discard is due to CPU policers or lack of resources towards the CPU.\;" access="RO" offset="0x10.0" size="0x4.0" />
</node>

<node name="mpscr_ext" descr="" size="0x20.0" >
	<field name="warning_inactive_time" descr="Thermal Throttling (FW mode) warning inactive time\;Each unit is equivalent to 100uSec\;Reserved for Switch.\;" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="warning_active_time" descr="Thermal Throttling (FW mode) warning active time\;Each unit is equivalent to 100uSec\;Reserved for Switch.\;" access="RW" offset="0x4.16" size="0x0.8" />
	<field name="critical_inactive_time" descr="Thermal Throttling (FW mode) critical inactive time\;Each unit is equivalent to 100uSec\;Reserved for Switch.\;" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="critical_active_time" descr="Thermal Throttling (FW mode) critical active time\;Each unit is equivalent to 100uSec\;Reserved for Switch.\;" access="RW" offset="0x8.16" size="0x0.8" />
	<field name="cc" descr="Clear Counters\;0: Don&apos;t clear MTSR counters\;1: Clear MTSR counters\;Reserved for Switch." access="OP" offset="0x10.0" size="0x0.1" />
	<field name="queue_depth_th" descr="[DWIP][SwitchOnly]:\;Queue Depth Threshold\;Defines the threshold that above it we move to L1 Idle (not in desire).\;Relevant for normal queues only (high-priority queues are considered empty only if the queue has no PCB line usage at all).\;For Quantum-3: Units of 64Bytes\;\;Relevant for switches only. Unit are line of PCB" access="RW" offset="0x14.0" size="0x0.16" />
</node>

<node name="mqdik_reg_ext" descr="" size="0x208.0" >
	<field name="algorithm" descr="0: ECC. Used for any of the P256, P385, P521 curves.\;1: RSA. Used for 2048 or 4096 keys." access="RO" offset="0x0.0" size="0x0.8" />
	<field name="key_size" descr="Number of Bytes in the public_key" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="status" descr="0: Key is not ready for query\;1: Key is provided in the response" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="public_key" descr="Public-key value, per the specific algorithm." access="RO" high_bound="127" low_bound="0" offset="0x8.0" size="0x200.0" />
</node>

<node name="mqis_reg_ext" descr="" size="0x18.0" >
	<field name="info_type" descr="Type of information string to be queried:\;0x0: VPD - Read the PCI Vital Product Data capability content.\;0x1: MODEL_NAME\;0x2: MODEL_DESCRIPTION\;0x3: IMAGE_VSD\;0x4: DEVICE_VSD\;0x5: ROM_INFO\;other values are reserved." access="INDEX" enum="MODEL_NAME=0x1,MODEL_DESCRIPTION=0x2,IMAGE_VSD=0x3,DEVICE_VSD=0x4,ROM_INFO=0x5" offset="0x0.0" size="0x0.8" />
	<field name="info_length" descr="Total size of the information string, according to info_type. Value given in bytes." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="read_length" descr="Number of bytes requested. The device returns the number of bytes actually read." access="RW" offset="0x8.0" size="0x0.16" />
	<field name="read_offset" descr="Offset in bytes of the first byte requested to read." access="INDEX" offset="0x8.16" size="0x0.16" />
	<field name="info_string" descr="Information string accessed, according to info_type. If the information is not available, a NULL string is returned." access="RO" high_bound="7" low_bound="0" offset="0x10.24" size="0x8.0" />
</node>

<node name="mrci_info_ext" descr="" size="0xc.0" >
	<field name="measured_freq" descr="clock frequency measurement in last 100msec" access="RO" offset="0x0.0" size="0x0.24" />
	<field name="min_freq" descr="min of clock frequency measured. Units of 0.1 KHz" access="RO" offset="0x4.0" size="0x0.24" />
	<field name="max_freq" descr="max of clock frequency measured. Units of 0.1 KHz" access="RO" offset="0x8.0" size="0x0.24" />
	<field name="max_freq_delta" descr="observed max delta frequency in window of 100msec. Units of 0.1 KHz" access="RO" offset="0x8.24" size="0x0.8" />
</node>

<node name="mrcs_reg_ext" descr="" size="0x18.0" >
	<field name="ref_clk_info" descr="clock frequency measurement in last 100msec" subnode="mrci_info_ext" access="RO" high_bound="1" low_bound="0" offset="0x0.0" size="0x18.0" />
</node>

<node name="mrpr_reg_ext" descr="" size="0x108.0" >
	<field name="type" descr="Runtime parameter to access or query\;" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="status" descr="0: Parameter is not supported\;1: Parameter is supported but is not ready for read\;2: Successful read\;3: Successful write\;Else - Reserved" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="length" descr="Number of Bytes in the parameter data section.\;When reading an unsupported /unavailable parameter, this field is 0 and there is no data field in the read response." access="RW" offset="0x0.24" size="0x0.8" />
	<field name="data" descr="Parameter data.\;Writing to this field for read-only parameter has no effect. \;Reading this field for a write-only parameter returns unpredicted value." access="RW" high_bound="63" low_bound="0" offset="0x8.0" size="0x100.0" />
</node>

<node name="mrrr_ext" descr="" size="0x8.0" >
	<field name="init_rr" descr="Initiate resource release:\;0: Resource release type 0 \;1: Resource release type 1 \;If rr_status is &quot;1&quot; then this operation fails" access="WO" offset="0x0.0" size="0x0.4" />
	<field name="rr_status" descr="Resource release status:\;0: No resource release process is ongoing\;1: Resource release process is ongoing" access="RO" offset="0x4.0" size="0x0.4" />
</node>

<node name="mrsr_ext" descr="" size="0x8.0" >
	<field name="command" descr="Reset/shutdown command\;0: clear state of reset_at_pci_disable\;1: software reset immediate (switch soft reset).\;6: reset_at_pci_disable - reset will be done at PCI_DISABLE. See MCAM bit48. Note: when no PCI (e.g. unmanaged switches or for Retimers) will do reset without waiting for PCI_DISABLE\;7: fw_link_reset_at_pci_disable - PCIe FW Link Reset, core is up [DWIP]" access="WO" offset="0x0.0" size="0x0.4" />
</node>

<node name="msci_ext" descr="" size="0xc.0" >
	<field name="index" descr="CPLD index" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="version" descr="CPLD version" access="RO" offset="0x4.0" size="0x4.0" />
</node>

<node name="msgcr_reg_ext" descr="" size="0x8.0" >
	<field name="fake_cable_detect_en" descr="0: fake cable detection is disabled\;1: fake cable detection is enabled" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="support_perst_gpio" descr="[DWIP]:\;0: PERST GPIO assertion will NOT trigger ASIC reset\;1: PERST GPIO assertion will trigger ASIC reset\;" access="RO" offset="0x4.0" size="0x0.1" />
	<field name="support_inter_asic_block" descr="[DWIP]:\;Support inter ASIC blocking\;0: Disable_Link GPIO assertion will NOT trigger Inter ASIC communication blocking\;1: Disable_Link GPIO assertion will trigger Inter ASIC communication blocking\;" access="RO" offset="0x4.1" size="0x0.1" />
	<field name="support_error_injection" descr="[DWIP]:\;Support Error injection \;0: Deny any error injection operation (Thermal/Link/PCI)\;1: Allow error injection trigger\;" access="RO" offset="0x4.8" size="0x0.1" />
</node>

<node name="msgi_ext" descr="" size="0x80.0" >
	<field name="serial_number" descr="ASIC serial number (ASCII string)" access="RO" high_bound="5" low_bound="0" offset="0x0.0" size="0x18.0" />
	<field name="part_number" descr="ASIC part number (ASCII string)" access="RO" high_bound="4" low_bound="0" offset="0x20.0" size="0x14.0" />
	<field name="revision" descr="Revision (ASCII string)" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="product_name" descr="Product Name (ASCII string)" access="RO" high_bound="15" low_bound="0" offset="0x40.0" size="0x40.0" />
</node>

<node name="mspmer_ext" descr="" size="0x30.0" >
	<field name="device_index" descr="Device Index\;0: Main_board_or_NIC\;" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="status" descr="Status\;0: Success\;1: Physical monitor is not supported\;2: Device index is not valid" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="clr" descr="Clear Counters\;0: don&apos;t clear counters\;1: clear counters" access="OP" offset="0x4.16" size="0x0.1" />
	<field name="prev_en" descr="Prevention Enable\;0: Notification only. Prevention is disabled \;1: Prevention is enabled\;\;In Spectrum-4 only, controlled by NV_SWITCH_PHY_SEC_CONF.pvpm. See Table 397, &quot;NV_SWITCH_PHY_SEC_CONF Layout,&quot; on page 742" access="RO" offset="0x4.24" size="0x0.1" />
	<field name="supported_physical_monitor" descr="31: FMON - Frequency MONitor\;30: VMON - Voltage MONitor\;29: SCPM - Secure Canary Path Monitor\;0: General \;\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="fmon_ctr" descr="Frequency Monitor Counter\;\;Stuck at 0xF, cleared only at hard reset (RST_) or power down or clr bit." access="RO" offset="0x14.0" size="0x0.4" />
	<field name="vmon_ctr" descr="Voltage Monitor Counter\;\;Stuck at 0xF, cleared only at hard reset (RST_) or power down or clr bit." access="RO" offset="0x14.4" size="0x0.4" />
	<field name="scpm_ctr" descr="Security Canary Path Monitor Counter\;A circuit macro used to flag timing slack violations as part of mitigations for physical security attacks.\;\;Stuck at 0xF, cleared only at hard reset (RST_) or power down or clr bit." access="RO" offset="0x14.8" size="0x0.4" />
	<field name="general_err" descr="General Error indication\;Cleared only at hard reset (RST_) or power down or clr bit." access="RO" offset="0x14.12" size="0x0.1" />
</node>

<node name="msps_ext" descr="" size="0xa0.0" >
	<field name="psu0" descr="System Power Supply 0 Status" access="RO" high_bound="19" low_bound="0" offset="0x0.0" size="0x50.0" />
	<field name="psu1" descr="System Power Supply 1 Status" access="RO" high_bound="19" low_bound="0" offset="0x50.0" size="0x50.0" />
</node>

<node name="mssir_firebird_ext" descr="" size="0x80.0" >
	<field name="crc" descr="Each bit represent whether a CRC error occured on the management interface to the tile number." access="RO" offset="0x0.0" size="0x0.8" />
	<field name="bypass" descr="Each bit represent whether a bypass clock is run on the corresponding tile." access="RO" offset="0x4.0" size="0x0.8" />
	<field name="fatal_dft" descr="" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="freq0" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0xC.0" size="0x0.5" />
	<field name="freq1" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0xC.5" size="0x0.5" />
	<field name="freq2" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0xC.10" size="0x0.5" />
	<field name="freq3" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0xC.15" size="0x0.5" />
	<field name="freq4" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0xC.20" size="0x0.5" />
	<field name="freq5" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0xC.25" size="0x0.5" />
	<field name="freq6" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0x10.0" size="0x0.5" />
	<field name="freq7" descr="Each field represent the frequency dividing factor for the core clock for each of the tiles" access="RO" offset="0x10.5" size="0x0.5" />
</node>

<node name="mssir_reg_ext" descr="" size="0x88.0" >
	<field name="sys_indx" descr="System Identifier\;0: Firebird\;" access="INDEX" enum="Firebird=0x0" offset="0x0.0" size="0x0.4" />
	<field name="sys_info" descr="Firebird System Information, see Table 710, &quot;MSSIR - Management System Status Information Register Layout,&quot; on page 1020" subnode="mssir_firebird_ext" access="RW" offset="0x8.0" size="0x80.0" />
</node>

<node name="mtbr_reg_ext" descr="" size="0x410.0" >
	<field name="base_sensor_index" descr="Base sensor index\;Sensors are read starting from base_sensor_index\;Sensor 0 is the ASIC sensor, sensors 1-63 are ambient sensors and sensors 64-127 are mapped to the SFP+/QSFP modules sequentially (module 0 is mapped to sensor 64, module 1 to sensor 65 and so on). Gearbox sensors starts from 256 index." access="INDEX" offset="0x0.0" size="0x0.12" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="num_rec" descr="Number of records to read\;Range 1..256" access="OP" offset="0x4.0" size="0x0.8" />
	<field name="temperature_record" descr="Temperature record\;See Table 598, &quot;MTBR - Temperature Record Layout,&quot; on page 936" subnode="mtbr_temp_record_ext" access="RO" high_bound="255" low_bound="0" offset="0x10.0" size="0x400.0" />
</node>

<node name="mtbr_temp_record_ext" descr="" size="0x4.0" >
	<field name="temperature" descr="Temperature reading from the sensor. Units of 0.125 Celsius degrees.\;If no ambient sensor is present then the value is &apos;0&apos;. Also for a passive copper case.\;0x8000:NO_CONN- No cable or device&apos;s sensor is connected.\;0x8001: NO_TEMP_SENS - In case a cable or device is connected but the temperature sensing is not supported.\;0x8002: INDX_NA- No such cable or device&apos;s sensor index. Bigger than the number of modules.\;0x8003: INCORRECT_SENS_INFO - Sensor information is incorrect." access="RO" offset="0x0.0" size="0x0.16" />
	<field name="max_temperature" descr="The highest measured temperature from the sensor.\;When the bit relevant MTMP.mte is cleared, the field max_temperature is reserved.\;The value will be &apos;0&apos; for any of the &apos;800X&apos; temperature values and for &apos;0&apos; value." access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="mtcap_ext" descr="" size="0x10.0" >
	<field name="sensor_count" descr="Number of ASIC+platform sensors supported by the device \;This includes the ASIC and the ambient sensors. Module sensors are not included.\;This actually is equal to sum of all &apos;1&apos; in sensor_map\;Range 1..64\;\;Known sensors:\;0: current asic temp, FW exposes current max(all diode temp sensors)\;1..63: ambient, supported only for unmanaged switch, defined by ini\;64..127: modules (not exposed by this field)" access="RO" offset="0x0.0" size="0x0.7" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="internal_sensor_count" descr="Number of sensors supported by the device that are on the ASIC.\;Exposes how many ASIC diodes exist. \;The FW exposes all of them as sensor[0]" access="RO" offset="0x4.0" size="0x0.7" />
	<field name="sensor_map" descr="Mapping of system sensors supported by the device. Only ASIC and ambient sensors are supported. Each bit represents a sensor.\;Per bit:\;0: Not_connected_or_not_supported\;1: Supports_temperature_measurements" subnode="uint64" access="RO" offset="0x8.0" size="0x8.0" />
</node>

<node name="mtcq_reg_ext" descr="" size="0x70.0" >
	<field name="device_index" descr="Device number.\;For gearboxes, the index represents the gearbox die.\;For cables, the index represents the module index starting at index 1 while index 0 indicates the host device." access="INDEX" offset="0x0.0" size="0x0.12" />
	<field name="status" descr="Indicates the status of the desired token we are generating the challenge for.\;0x0 - OK\;0x1 - TOKEN_ALREADY_APPLIED\;0x2 - TOKEN_NOT_SUPPORTED\;0x3 - NO_KEY_CONFIGURED (there is no public_key that can be used for this token) \;0x4 - INTERFACE_NOT_ALLOWED (asking for local token from remote interface, or remote token from local interface)" access="RO" offset="0x0.16" size="0x0.8" />
	<field name="token_opcode" descr="The token which a challenge is generated for.\;0: RMCS\;1: RMDT\;2: CRCS - supported from Spectrum-4 and above\;3: CRDT - supported from Spectrum-4 and above\;Other: Reserved" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="keypair_uuid" descr="The UUID of the key used to generate the challenge." access="RO" high_bound="3" low_bound="0" offset="0x4.0" size="0x10.0" />
	<field name="base_mac" descr="Device base MAC address / unique identifier." subnode="uint64" access="RO" offset="0x14.0" size="0x8.0" />
	<field name="psid" descr="Device PSID" access="RO" high_bound="3" low_bound="0" offset="0x1C.0" size="0x10.0" />
	<field name="fw_version_39_32" descr="Device FW version" access="RO" offset="0x2C.0" size="0x0.8" />
	<field name="fw_version_31_0" descr="Device FW version" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="source_address" descr="Source address of debug requester. DLID for Infiniband\;Valid only for RMCS/RMDT." access="RO" high_bound="3" low_bound="0" offset="0x34.0" size="0x10.0" />
	<field name="session_id" descr="Unique debug session identifier. \;See details in REMOTE_DEBUG_KEEP_ALIVE.\;Valid only for RMCS." access="RO" offset="0x44.0" size="0x0.16" />
	<field name="challenge_version" descr="Version of the challenge format." access="RO" offset="0x44.24" size="0x0.8" />
	<field name="challenge" descr="Random generated field. Used for randomness and replay-protection." access="RO" high_bound="7" low_bound="0" offset="0x48.0" size="0x20.0" />
</node>

<node name="mtdc_ext" descr="" size="0x20.0" >
	<field name="tracer_limit_en" descr="Tracer writing to PCI is limited.When this mode is enable, the hw tracer pointer cannot override the software read index pointer.If software will not update the read index pointer, new events will fall and will not be sent.\;0: NA - ignored, does not perform any operation \;1: Enable\;2: Disable" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="tlb_addr_msb" descr="The lsb of the address for the cyclic buffer in the host memory." access="RW" offset="0x8.0" size="0x4.0" />
	<field name="tlb_addr_lsb" descr="The lsb of the for the cyclic buffer address in the host memory." access="RW" offset="0xC.12" size="0x0.20" />
	<field name="hw_pointer" descr="Pointer of the current hw index the tracer is writing to.\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="sw_pointer" descr="Pointer to the last tracer event index that the software consumed.\;" access="RW" offset="0x14.0" size="0x4.0" />
</node>

<node name="mtecr_ext" descr="" size="0x60.0" >
	<field name="sensor_count" descr="Number of sensors supported by the ASIC+platform\;This includes the ASIC, ambient sensors, module sensors, Gearboxes etc. \;This actually is equal to sum of all &apos;1&apos; in sensor_map\;\;Known sensors:\;0: current asic temp, FW exposes current max(all diode temp sensors)\;1..62: ambient, supported only for unmanaged switch, defined by ini\;64..255: modules\;256..288: Gearbox\;289..704: reserved for future" access="RO" offset="0x0.0" size="0x0.12" />
	<field name="last_sensor" descr="Last sensor index that is available in the system to read from.\;e.g. when 32modules: 64+32-1 = 95" access="RO" offset="0x0.16" size="0x0.12" />
	<field name="internal_sensor_count" descr="Number of sensors supported by the device that are on the ASIC. \;Exposes how many ASIC diodes exist. \;The FW exposes all of them as sensor[0]" access="RO" offset="0x4.0" size="0x0.7" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x4.28" size="0x0.4" />
	<field name="sensor_map" descr="Mapping of system sensors supported by the device. Each bit represents a sensor.\;This field is size variable based on the last_sensor field and in granularity of 32bits.\;Per bit:\;0: Not connected or not supported\;1: Supports temperature measurements\;\;In case of last_sensor = 704 (22*32):\;sensor_warning[0] bit31 is sensor_warning[703]\;sensor_warning[0] bit0 is sensor_warning[703-31]\;sensor_warning[21] bit31 is sensor_warning[31]\;sensor_warning[21] bit0 is sensor_warning[0]\;\;In case if last_sensor = 259 (22*32):\;Note: roundup(259,32)=288\;sensor_warning[0] bit31 is sensor_warning[287]\;sensor_warning[0] bit0 is sensor_warning[287-31=256]\;sensor_warning[8] bit31 is sensor_warning[31]\;sensor_warning[8] bit0 is sensor_warning[0]\;sensor_warning[9..21] are not used\;\;64-192 of sensor_index are mapped to the modules sequentially (module 0 is mapped to sensor_index 64, module 1 to sensor_index 65 and so on)." access="RO" high_bound="21" low_bound="0" offset="0x8.0" size="0x58.0" />
</node>

<node name="mteim_reg_ext" descr="" size="0x30.0" >
	<field name="cap_core_tile" descr="Number of processors per tile ASIC." access="RO" offset="0x0.0" size="0x0.8" />
	<field name="cap_core_main" descr="Number of processors in the main ASIC." access="RO" offset="0x0.8" size="0x0.8" />
	<field name="cap_core_dpa" descr="Number of processors in the DPA unit." access="RO" offset="0x0.16" size="0x0.8" />
	<field name="cap_num_of_tile" descr="Number of tiles per device. For devices without tiles (only main ASIC), this field should be &apos;0&apos;." access="RO" offset="0x0.24" size="0x0.8" />
	<field name="type_core_tile" descr="Processor type.\;0: N/A\;1: IRISC\;2: RISC5\;Else: Reserved" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="type_core_main" descr="Processor type.\;0: N/A\;1: IRISC\;2: RISC5\;Else: Reserved" access="RO" offset="0x4.4" size="0x0.4" />
	<field name="type_core_dpa" descr="Processor type.\;0: N/A\;1: IRISC\;2: RISC5\;Else: Reserved" access="RO" offset="0x4.8" size="0x0.4" />
	<field name="is_phy_uc_supported" descr="Indicates wether Phy_UC tracers mapping are supported by the device FW. \;When set, The event_id of the Phy UC of the instance will be calculated by first_tile/main _core _event_id[i] + cap_core_tile/main.\;When clear the Phy UC will be ignored." access="RO" offset="0x4.30" size="0x0.1" />
	<field name="is_dwsn_msb_supported" descr="When set to &apos;1&apos;, the device supports dwsn_msb bit within the FW trace layout." access="RO" offset="0x4.31" size="0x0.1" />
	<field name="first_dpa_core_event_id" descr="The mapping for the rest of the DPA ASIC processors are sequential and the mapping is defined as:\;processor[x]=first_dpacore_event_id+x" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="first_main_core_event_id" descr="The mapping for the rest of the main ASIC processors are sequential and the mapping is defined as:\;processor[x]=first_main_core_event_id+x" access="RO" offset="0x8.24" size="0x0.8" />
	<field name="first_tile_core_event_id" descr="The mapping for the rest of the tile[y] ASIC processors are sequential and the mapping is defined as:\;processor[x]=first_tile_core_event_id[y]+x" access="RO" high_bound="7" low_bound="0" offset="0xC.24" size="0x8.0" />
</node>

<node name="mtewe_ext" descr="" size="0x5c.0" >
	<field name="sensor_count" descr="Number of sensors supported by the device\;This includes the ASIC, ambient sensors, Gearboxes etc.\;\;Known sensors:\;0: current asic temp, FW exposes current max(all diode temp sensors)\;1..62: ambient, supported only for unmanaged switch, defined by ini\;64..255: modules\;256..288: Gearbox\;289..704: reserved for future" access="RO" offset="0x0.0" size="0x0.12" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.12" size="0x0.4" />
	<field name="last_sensor" descr="Last sensor index that is available in the system to read from." access="RO" offset="0x0.16" size="0x0.12" />
	<field name="sensor_warning" descr="Bit vector indicating which of the sensor reading is above threshold.\;This field is size dependent and based on last_sensor field and in granularity of 32bits.\;\;In case of last_sensor = 704 (22*32):\;sensor_warning[0] bit31 is sensor_warning[703]\;sensor_warning[0] bit0 is sensor_warning[703-31]\;sensor_warning[21] bit31 is sensor_warning[31]\;sensor_warning[21] bit0 is sensor_warning[0]\;\;In case if last_sensor = 259 (22*32):\;Note: roundup(259,32)=288\;sensor_warning[0] bit31 is sensor_warning[287]\;sensor_warning[0] bit0 is sensor_warning[287-31=256]\;sensor_warning[8] bit31 is sensor_warning[31]\;sensor_warning[8] bit0 is sensor_warning[0]\;sensor_warning[9..21] are not used" access="RO" high_bound="21" low_bound="0" offset="0x4.0" size="0x58.0" />
</node>

<node name="mtie_ext" descr="" size="0x30.0" >
	<field name="enable_all" descr="Enable/Disable all FW tracer initiator and ignore mask.\;Starts from bit 0.\;0: Use bit mask\;1: Enable all\;2: Disable all" access="OP" offset="0x0.0" size="0x0.2" />
	<field name="log_delay" descr="Adding delay to log events in usecs\;" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="source_id_bitmask" descr="Bit mask of all the possible tracer initiators.\;Reserved when enable_all != 0.\;The mapping of source id to HW unit is unique per device and can be fetched from FW code.\;" access="RW" high_bound="7" low_bound="0" offset="0x10.0" size="0x20.0" />
</node>

<node name="mtim_ext" descr="" size="0x10.0" >
	<field name="log_level" descr="The verbosity of the log. \;0: LOG_DEBUG\;1: LOG_INFO\;2: LOG_WARNING\;3: LOG_ERROR\;\;The lower value reflects higher verbosity than higher value.\;e.g: LOG_INFO contains LOG_WARNING and LOG_ERROR" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="log_bit_mask" descr="Bit mask of the different FW units that can be activated for the FW log.\;The mapping of source id to FW unit is unique per device and can be fetched from FW code.\;" access="RW" offset="0x4.0" size="0x4.0" />
</node>

<node name="mtmp_ext" descr="" size="0x20.0" >
	<field name="sensor_index" descr="Sensors index\;0: current asic temp, FW exposes current max(all diode temp sensors)\;1..62: ambient, supported only for unmanaged switch, defined by ini\;64..255: modules 256..288: Gearbox\;Others up to 704 are reserved" access="INDEX" offset="0x0.0" size="0x0.12" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="temperature" descr="Temperature reading from the sensor. \;Units of 0.125 Celsius degrees.\;For negative values 2&apos;s complement is used (for example: -3.25 Celsius will read as 0xFFE6)" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="max_temperature" descr="The highest measured temperature from the sensor.\;Reserved when mte = 0\;Cleared by mtr = 1\;Valid only when i = 0\;" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="sdme" descr="Shut Down Events Modify Set Enable:\;0: all fields are set\;1: only sdee field is set, all other fields reserved" access="OP" offset="0x8.28" size="0x0.1" />
	<field name="weme" descr="Warning Events Modify Set Enable:\;0: all fields are set\;1: only tee field is set, all other fields reserved" access="OP" offset="0x8.29" size="0x0.1" />
	<field name="mtr" descr="Max Temperature Reset:\;0: do not modify the value of the max temperature register\;1: clear the value of the max temperature register" access="OP" offset="0x8.30" size="0x0.1" />
	<field name="mte" descr="Max Temperature Enable:\;0: disable measuring the max temperature on a sensor\;1: enables measuring the max temperature on a sensor" access="RW" offset="0x8.31" size="0x0.1" />
	<field name="temperature_threshold_hi" descr="temperature_threshold_hi refers to the high threshold of Warning Event. \;If the sensor temperature measurement is above the threshold (and events are enabled), an event will be generated.\;threshold_hi and threshold_lo implements hysteresis mechanism of the threshold preventing toggling of the indication.\;Note that temperature_threshold_hi must be equal or lower than the system requirement.\;System requirement for module is the module warning temperature.\;System requirement for board/silicon sensors is according to product information parameters\;Note that the temperature threshold can be used to generate an event message or an interrupt using GPIO" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="sdee" descr="Temperature Shut Down Event Enable (MTSDE Register)\;0: do_not_generate_event\;1: generate_event\;2: generate_single_event\;\;Supported in downstream devices (devices on slots)." access="RW" offset="0xC.28" size="0x0.2" />
	<field name="tee" descr="Temperature Warning Event Enable (MTEWE Register)\;0: do_not_generate_event\;1: generate_event\;2: generate_single_event\;\;" access="RW" enum="do_not_generate_event=0x0,generate_event=0x1,generate_single_event=0x2" offset="0xC.30" size="0x0.2" />
	<field name="temperature_threshold_lo" descr="temperature_threshold_lo refers to the low threshold of Warning Event. \;The offset threshold_lo implements the lower threshold for the hysteresis mechanism of over temperature alert. Once alert is set, if the temperature goes below this threshold, the alert is cleared.\;Note that temperature_threshold_lo must be at least 5 degrees lower than temperature_threshold_hi" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="temperature_critical_threshold_low" descr="[Draft][SwitchOnly]\;temperature_critical_threshold_low refers to the low threshold of Critical Event. \;Must be configured with value lower than MTMP.temperature_critical_threshold_hi.\;Supported only for modules index." access="RW" offset="0x14.0" size="0x0.16" />
	<field name="temperature_critical_threshold_hi" descr="[Draft][SwitchOnly]\;temperature_threshold_lo refers to the high threshold of Critical Event. \;Must be configured with value &lt;= MTMP.max_operational_temperature.\;Supported only for modules index." access="RW" offset="0x14.16" size="0x0.16" />
	<field name="sensor_name_hi" descr="Sensor Name\;8 character long sensor name\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="sensor_name_lo" descr="Sensor Name\;8 character long sensor name\;" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="mtpcpc_ext" descr="" size="0x28.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="local_port\;Supported to/from CPU port\;Reserved when pport = 0" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="pport" descr="Per port:\;0: config is global. When reading - the local_port is 1\;1: config is per port" access="INDEX" offset="0x0.31" size="0x0.1" />
	<field name="ptp_trap_en" descr="Enable PTP traps\;The trap_id is configured by MTPTPT" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="ing_correction_message_type" descr="Bitwise vector of PTP message types to update correctionField\;MessageType field as defined by IEEE 1588\;Each bit corresponds to a value (e.g. Bit0: Sync, Bit1: Delay_Req)\;Supported also from CPU port\;Default all 0\;Reserved when Quantum-3" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="egr_correction_message_type" descr="Bitwise vector of PTP message types to update correctionField\;MessageType field as defined by IEEE 1588\;Each bit corresponds to a value (e.g. Bit0: Sync, Bit1: Delay_Req)\;Supported also from CPU port\;Default all 0" access="RW" offset="0x14.0" size="0x0.16" />
	<field name="ptp_pkey" descr="For IB Switches only:\;The PTP Pkey\;Used for identifying the PTP packets.\;Reserved when Ethernet switches" access="RW" offset="0x18.0" size="0x0.15" />
	<field name="num_domains" descr="Number of valid domains for match:\;0: ignore domain field (&quot;always match&quot;)\;1: Match only if domain[0] has a match\;2: Match only if domain[0] or [1] have a match\;etc.\;Range 0..cap_max_ptp_domains\;" access="RW" offset="0x20.0" size="0x0.8" />
	<field name="domain" descr="domain for matching\;" access="RW" high_bound="3" low_bound="0" offset="0x24.24" size="0x4.0" />
</node>

<node name="mtpppc_ext" descr="" size="0x28.0" >
	<field name="ing_timestamp_message_type" descr="Bitwise vector of PTP message types to timestamp at ingress\;MessageType field as defined by IEEE 1588\;Each bit corresponds to a value (e.g. Bit0: Sync, Bit1: Delay_Req)\;Default all 0\;" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="egr_timestamp_message_type" descr="Bitwise vector of PTP message types to timestamp at egress.\;MessageType field as defined by IEEE 1588\;Each bit corresponds to a value (e.g. Bit0: Sync, Bit1: Delay_Req)\;Default all 0\;" access="RW" offset="0xC.0" size="0x0.16" />
</node>

<node name="mtpps_reg_ext" descr="" size="0x38.0" >
	<field name="cap_max_num_of_pps_out_pins" descr="Maximum number of pps out pins supported on device." access="RO" offset="0x0.0" size="0x0.4" />
	<field name="cap_max_num_of_pps_in_pins" descr="Maximum number of pps in pins supported on device." access="RO" offset="0x0.8" size="0x0.4" />
	<field name="cap_number_of_pps_pins" descr="Total number of pps pins supported on device.\;The virtual pins are not counted here" access="RO" offset="0x0.16" size="0x0.4" />
	<field name="cap_pin_0_mode" descr="Capability of PPS pin #0\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0x8.0" size="0x0.4" />
	<field name="cap_pin_1_mode" descr="Capability of PPS pin #1\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0x8.8" size="0x0.4" />
	<field name="cap_pin_2_mode" descr="Capability of PPS pin #2\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0x8.16" size="0x0.4" />
	<field name="cap_pin_3_mode" descr="Capability of PPS pin #3\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0x8.24" size="0x0.4" />
	<field name="cap_pin_4_mode" descr="Capability of PPS pin #4\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0xC.0" size="0x0.4" />
	<field name="cap_pin_5_mode" descr="Capability of PPS pin #5\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0xC.8" size="0x0.4" />
	<field name="cap_pin_6_mode" descr="Capability of PPS pin #6\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0xC.16" size="0x0.4" />
	<field name="cap_pin_7_mode" descr="Capability of PPS pin #7\;Bit0: support_pps_in\;Bit1: support_pps_out\;Bit2: support_virtual_pin" access="RO" enum="support_pps_in=0x1,support_pps_out=0x2,support_virtual_pin=0x4" offset="0xC.24" size="0x0.4" />
	<field name="field_select" descr="Field select indicates which fields to modify in write operation to this register. This field selector supported only when MCAM.mtpps_fs==1. if MCAM.mtpps_fs==0 then SW should ensure that all the WO/RW fields are valid. \;Bit 0: enable\;Bit 1: utc_mode\;Bit 2: pattern\;Bit 3: pin_mode\;Bit 4: time_stamp\;Bit 5: out_pulse_duration\;\;" access="WO" enum="enable=0x1,utc_mode=0x2,pattern=0x4,pin_mode=0x8,time_stamp=0x10,out_pulse_duration=0x20" offset="0x10.0" size="0x4.0" />
	<field name="pin" descr="Pin to be configured or queried out of the supported pins." access="INDEX" offset="0x20.0" size="0x0.8" />
	<field name="pin_mode" descr="Pin mode to be used. The mode must comply with the supported modes of the requested pin.\;0x0: pps_in\;0x1: pps_out\;0x2: virtual_pin\;0x3: pps_out_and_virtual_pin\;\;Operation will fail if pin does not support the required mode." access="RW" enum="pps_in=0x0,pps_out=0x1,virtual_pin=0x2,pps_out_and_virtual_pin=0x3" offset="0x20.8" size="0x0.4" />
	<field name="pattern" descr="When pin_mode = pps_in:\;0x0: Rising edge \;0x1: Falling edge \;\;When pin_mode = pps_out:\;0x0: Pulse - (one shot) The device will generate a pulse at time_stamp time with a duration of out_pulse_duration. \;0x1: Periodic - the device will generate periodical pulses with pulse duration  of  out_pulse_duration every 1 second  according to internal clock. The 1st pulse will be generated at time_stamp time.\;\;Reserved when pin_mode = 0x2 virtual_pin\;\;" access="RW" offset="0x20.16" size="0x0.4" />
	<field name="utc_mode" descr="UTC time:\;0x0: FREE_RUNNING - time_stamp is by free running clock\;0x1: UTC - time_stamp is UTC" access="RW" enum="FREE_RUNNING=0x0,UTC=0x1" offset="0x20.30" size="0x0.1" />
	<field name="enable" descr="Enables the PPS functionality the specific pin.\;0x0: Disable \;0x1: Enable" access="RW" enum="Disable=0x0,Enable=0x1" offset="0x20.31" size="0x0.1" />
	<field name="time_stamp" descr="When pin_mode = pps_in, the latched device time when it was triggered from the external GPIO pin. \;When pin_mode = pps_out or virtual_pin or pps_out_and_virtual_pin, the target time to generate next output signal. \;When utc_mode = FREE_RUNNING - Time is in units of device clock. \;\;\;" subnode="uint64" access="RW" offset="0x28.0" size="0x8.0" />
	<field name="out_pulse_duration" descr="Output pulse duration in units of mSec. \;Range is 1 to 1000. \;Reserved when pin_mode != ptp_out\;In case the set value is 0, device default will be used.\;" access="RW" offset="0x30.16" size="0x0.16" />
</node>

<node name="mtppst_ext" descr="" size="0x10.0" >
	<field name="pin" descr="Pin to be configured or queried out of the supported pins." access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="timestamp_msb" descr="Device time when it was triggered from the external GPIO pin.\;Time in units of device clock (free running counter or UTC)" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="timestamp_lsb" descr="Device time when it was triggered from the external GPIO pin.\;Time in units of device clock (free running counter or UTC)" access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="mtpptr_ext" descr="" size="0x50.0" >
	<field name="dir" descr="Direction\;0: Ingress\;1: Egress" access="INDEX" offset="0x0.0" size="0x0.1" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="local_port\;Not supported for CPU port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="ovf" descr="Overflow\;The HW timestamp FIFO had an overflow\;The overflow state is cleared when clr = 1" access="RO" offset="0x4.0" size="0x0.1" />
	<field name="read_one" descr="Read up to one record\;May response with num_rec = 0 or 1\;" access="OP" offset="0x4.30" size="0x0.1" />
	<field name="clr" descr="Clear the records" access="OP" offset="0x4.31" size="0x0.1" />
	<field name="num_rec" descr="Number of valid records in the response\;When read_one = 1 then this equals to 1 and only 1 record responded, even if the HW FIFO has more than 1 record\;Range 0.. cap_ptp_timestamp_fifo" access="RO" offset="0x8.0" size="0x0.4" />
	<field name="record" descr="Records, see Table 1139, &quot;MTPPTR - Record Layout,&quot; on page 1379" subnode="mtpptr_record_ext" access="RW" high_bound="3" low_bound="0" offset="0x10.0" size="0x40.0" />
</node>

<node name="mtpptr_record_ext" descr="" size="0x10.0" >
	<field name="domain_number" descr="domainNumber field as defined by IEEE 1588" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="message_type" descr="MessageType field as defined by IEEE 1588\;Each bit corresponds to a value (e.g. Bit0: Sync, Bit1: Delay_Req)" access="RO" offset="0x0.8" size="0x0.4" />
	<field name="sequence_id" descr="SequenceId field as defined by IEEE 1588" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="timestamp_high" descr="Timestamp of when the PTP packet has passed through the port\;Units of PLL clock time\;For Spectrum-1 the PLL clock is 156.25Mhz and PLL clock time is 6.4nSec" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="timestamp_low" descr="Timestamp of when the PTP packet has passed through the port\;Units of PLL clock time\;For Spectrum-1 the PLL clock is 156.25Mhz and PLL clock time is 6.4nSec" access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="mtpspu_ext" descr="" size="0x8.0" >
	<field name="message_type" descr="Set UTC on packets from CPU for PTP packets with the configured message_types.\;This is a necessary but insufficient condition since need to enable also per port. See Section 5.18.4, &quot;MTPCPC - Monitoring Time Precision Correction Port Configuration&quot;, on page 1382\;Message types are defined by IEEE 1588\;Each bit corresponds to a value (e.g. Bit0: Sync, Bit1: Delay_Req)\;\;Valid bits are 0-3 only.\;Bits 4-15 are reserved as TS shall not be applied to general messages." access="RW" offset="0x4.0" size="0x0.16" />
</node>

<node name="mtptpt_ext" descr="" size="0x8.0" >
	<field name="trap_id" descr="Trap id:\;0: PTP0\;1: PTP1\;2: PTP_IBG1\;See Table 950, &quot;PTP Traps,&quot; on page 1201 for details on which opcode is supported per device" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="message_type" descr="Bitwise vector of PTP message types to trap. This is a necessary but non-sufficient condition since need to enable also per port. See Section 5.18.1, &quot;MTPPPC - Monitoring Time Precision Packet Port Configuration&quot;, on page 1376\;Message types are defined by IEEE 1588\;Each bit corresponds to a value (e.g. Bit0: Sync, Bit1: Delay_Req)" access="RW" offset="0x4.0" size="0x0.16" />
</node>

<node name="mtrc_cap_reg_ext" descr="" size="0x84.0" >
	<field name="num_string_db" descr="Number of different string sections building the database" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="trc_ver" descr="Indicates the version of the tracing mechanism.\;0x0: VER_0\;0x1: VER_1\;Other values are reserved.\;Reserved in Switch" access="RO" offset="0x0.24" size="0x0.2" />
	<field name="trace_to_memory" descr="When set the device supports logging traces to memory\;0: FIFO Mode\;1: Host Memory Mode" access="RO" offset="0x0.30" size="0x0.1" />
	<field name="trace_owner" descr="Write 0x1 to register for tracer ownership, write 0x0 to de-register.\;Read value 0x1 indicates tracer ownership is granted.\;" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="num_string_trace" descr="The number of consecutive event_id that should be interpreted as a string trace" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="first_string_trace" descr="The lowest event_id that should be interpreted as a string trace" access="RO" offset="0x4.24" size="0x0.8" />
	<field name="log_max_trace_buffer_size" descr="Log 2 of the maximal size of the trace buffer given in units of 4KB" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="tracer_capabilities" descr="Tracer suppported capbailities bitmask:\;0: FIFO.\;1: MEM mode.\;else, reserved." access="RO" offset="0x8.30" size="0x0.2" />
	<field name="string_db_param" descr="String DB section parameters." subnode="string_db_parameters_ext" access="RO" high_bound="7" low_bound="0" offset="0x10.0" size="0x40.0" />
</node>

<node name="mtrc_conf_reg_ext" descr="" size="0x80.0" >
	<field name="trace_mode" descr="Tracing mode\;0x0: FIFO\;0x1: TRACE_TO_MEMORY\;Other values are reserved." access="RW" offset="0x0.0" size="0x0.4" />
	<field name="log_trace_buffer_size" descr="Log 2 of the Size of the trace buffer, given in units of 4KB.\;Value should not exceed log_max_trace_buffer_size.\;Valid only for trace_mode TRACE_TO_MEMORY.\;Modifying this parameter after the tracer was active may cause loss of sync regarding the location of the next trace." access="RW" offset="0x4.0" size="0x0.8" />
	<field name="trace_mkey" descr="MKey registered for the trace buffer access.\;Valid only for trace_mode TRACE_TO_MEMORY.\;Modifying this parameter after the tracer was active may cause loss of sync regarding the location of the next trace.\;Reserved for Switches." access="RW" offset="0x8.0" size="0x4.0" />
</node>

<node name="mtrc_ctrl_reg_ext" descr="" size="0x40.0" >
	<field name="modify_field_select" descr="Field select indicated which writable fields to modify\;bit 0: trace_status\;Other bits are reserved." access="WO" offset="0x0.0" size="0x0.16" />
	<field name="arm_event" descr="When set, an event will be generated if new Tracer events were logged since last event.\;Reserved in Switches." access="WO" offset="0x0.27" size="0x0.1" />
	<field name="trace_status" descr="Current status of the tracer\;0x0: DISABLED - logging traces is stopped\;0x1: ACTIVE - logging traces is active" access="RW" offset="0x0.30" size="0x0.2" />
	<field name="current_timestamp_52_32" descr="MSB of the current timesatmp counter" access="RO" offset="0x8.0" size="0x0.21" />
	<field name="current_timestamp_31_0" descr="LSB of the current timesatmp counter" access="RO" offset="0xC.0" size="0x4.0" />
</node>

<node name="mtrc_stdb_reg_ext" descr="" size="0xc.0" >
	<field name="read_size" descr="The number of bytes to read from the String DB. The number of bytes must:\;Be a multiple of 64B\;Not exceed the String DB section (with start_offset)\;Not exceed the limitations defined by the medium carrying the Register." access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="string_db_index" descr="The section of the String DB being accessed" access="INDEX" offset="0x0.28" size="0x0.4" />
	<field name="start_offset" descr="The offset in the String DB to read from, given in Bytes. The offset must:\;Be a multiple of 64B\;Not exceed the String DB section (with read_size)" access="INDEX" offset="0x4.0" size="0x4.0" />
	<field name="string_db_data" descr="Strings from the database. The size of this field is defined by read_size" access="RO" arr_is_dynamic="1" high_bound="VARIABLE" low_bound="0" offset="0x8.0" size="0x4.0" size_condition="$(parent).read_size" />
</node>

<node name="mtrc_stdb_v2_ext" descr="" size="0x5a0.0" >
	<field name="read_size" descr="The number of bytes to read from the String DB. The number of bytes must:\;Be a multiple of 64B\;Not exceed the String DB section (with start_offset)\;Not exceed the limitations defined by the medium carrying the Register." access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="string_db_index" descr="The section of the String DB being accessed" access="INDEX" offset="0x0.28" size="0x0.4" />
	<field name="start_offset" descr="The offset in the String DB to read from, given in Bytes. The offset must:\;Be a multiple of 64B\;Not exceed the String DB section (with read_size)" access="INDEX" offset="0x4.0" size="0x4.0" />
	<field name="string_db_data" descr="Strings from the database. The size of this field is defined by read_size" access="RO" high_bound="357" low_bound="0" offset="0x8.0" size="0x598.0" />
</node>

<node name="mtrc_stdb_v3_ext" descr="" size="0x26e0.0" >
	<field name="read_size" descr="The number of bytes to read from the String DB. The number of bytes must:\;Be a multiple of 64B\;Not exceed the String DB section (with start_offset)\;Not exceed the limitations defined by the medium carrying the Register." access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="string_db_index" descr="The section of the String DB being accessed" access="INDEX" offset="0x0.28" size="0x0.4" />
	<field name="start_offset" descr="The offset in the String DB to read from, given in Bytes. The offset must:\;Be a multiple of 64B\;Not exceed the String DB section (with read_size)" access="INDEX" offset="0x4.0" size="0x4.0" />
	<field name="string_db_data" descr="Strings from the database. The size of this field is defined by read_size" access="RO" high_bound="2485" low_bound="0" offset="0x8.0" size="0x26d8.0" />
</node>

<node name="mtutc_reg_ext" descr="" size="0x1c.0" >
	<field name="operation" descr="Operation:\;0: SET_TIME_AT_NEXT_SEC - the utc_sec will be sampled at the next PPS (of either virtual_pin or hw_utc_nsec wrap around)\;1: SET_TIME_IMMEDIATE - reserved when Spectrum-1\;2: ADJUST_TIME\;3: ADJUST_FREQ_UTC \;4: ADJUST_FREQ_FRC - Free Running Clock (DWIP and Switch only)\;5: ADJUST_FREQ_BOTH - (DWIP and Switch only)\;6: ADJUST_PHASE - Supported only if MCAM.mng_feature_cap_mask bit 54 is set." access="OP" enum="SET_TIME_AT_NEXT_SEC=0x0,ADJUST_TIME=0x2,ADJUST_FREQ_UTC=0x3,ADJUST_FREQ_FRC=0x4,ADJUST_FREQ_BOTH=0x5,ADJUST_PHASE=0x6" offset="0x0.0" size="0x0.4" />
	<field name="log_max_phase_adjustment" descr="[DWIP]\;range is from -(2^ log_max_phase_adjustment) to +2^ log_max_phase_adjustment) in units of ns." access="RO" offset="0x0.5" size="0x0.6" />
	<field name="log_max_freq_adjustment" descr="If 0: Range is from -50,000,000 ppb to +50,000,000 ppb.\;Otherwise: range is from -(2^log_max_freq_adjustment) ppb to +2^log_max_freq_adjustment ppb.\;" access="RO" offset="0x0.16" size="0x0.5" />
	<field name="freq_adj_units" descr="Updated when operation is ADJUST_FREQ.\;\;0: units_are_ppb - every PPS the HW frequency will be adjusted by this value\;1: units_are_parts_per_million - but with a 16 bit binary fractional field\;2: units_are_parts_per_billion - but with a 16 bit binary fractional field" access="RW" enum="units_are_ppb=0x0,units_are_parts_per_million=0x1,units_are_parts_per_billion=0x2" offset="0x0.24" size="0x0.3" />
	<field name="freq_adjustment" descr="Units are per MTUTC.freq_adj_units value. Frequency adjustment: Every PPS the HW frequency will be adjusted by this value. \; field.\;Updated when operation is ADJUST_FREQ\;\;Range is from -50,000,000 ppb to +50,000,000 ppb" access="RW" offset="0x4.0" size="0x4.0" />
	<field name="utc_sec" descr="UTC seconds\;Updated when operation is SET_TIME_IMMEDIATE or at next PPS when operation is SET_TIME_AT_NEXT_SEC" access="WO" offset="0x10.0" size="0x4.0" />
	<field name="utc_nsec" descr="UTC nSecs\;Range 0..(10^9-1)\;Updated when operation is SET_TIME_IMMEDIATE\;Reserved when Spectrum-1" access="WO" offset="0x14.0" size="0x0.30" />
	<field name="time_adjustment" descr="Time or phase adjustment\;Updated when operation is ADJUST_TIME or ADJUST_PHASE.\;\;When ADJUST_TIME:\;Time adjustment, Units of nSec, Range is from -32768 to 32768.\;If MCAM.time_adjust_range_extended==1, range is from -200,000 to +200,000.\;\;\;When ADJUST_PHASE:\;Phase adjustment, Units of nSec, Range is according to log_max_ phase_adjustment field.\;Reserved when Spectrum-1" access="WO" offset="0x18.0" size="0x4.0" />
</node>

<node name="mtwe_ext" descr="" size="0x10.0" >
	<field name="sensor_warning" descr="Bit vector indicating which of the sensor reading is above threshold.\;Address 00h bit31 is sensor_warning[127]\;Address 0Ch bit0 is sensor_warning[0]" access="RO" high_bound="3" low_bound="0" offset="0x0.0" size="0x10.0" />
</node>

<node name="multicast_fdb_record_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address." access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="a" descr="Activity. Set for new static entries. Set for static entries if a forwarding lookup has hit the entry.\;To clear the a bit, use &quot;query and clear activity&quot; op.\;Enabled by activity_dis in SGCR, see Section 7.12.1, &quot;SGCR - Switch General Configuration Register&quot;, on page 1571\;Not supported by SwitchX/-2" access="RO" offset="0x0.16" size="0x0.1" />
	<field name="policy" descr="0: STATIC_POLICY - roaming disabled, aging disabled\;1: DYNAMIC_LEARN - HW learning enabled, aging disabled.\;\; -" access="RW" enum="STATIC_POLICY=0x0,DYNAMIC_LEARN=0x1" offset="0x0.17" size="0x0.1" />
	<field name="type_0x2" descr="0x2: Multicast_Record - this record\;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RW" enum="Multicast_Record=0x2" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID.\;Reserved when Spectrum/-2" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="MAC address." access="INDEX" offset="0x4.0" size="0x4.0" />
	<field name="fid_vid" descr="VLAN identifier for SwitchX/-2.\;Filtering identifier (FID) for Spectrum." access="INDEX" offset="0x8.0" size="0x0.16" />
	<field name="pgi" descr="Multicast port group index - index into the port group table.\;Value 0x1FFF indicates the pgi should point to the MID entry.\;For Spectrum this value must be set to 0x1FFF" access="RW" offset="0x8.16" size="0x0.13" />
	<field name="mid" descr="Multicast identifier - global identifier that represents the multicast group across all devices.\;For Spectrum, pointer to PGT table, see Appendix A.4.2, &quot;Port Group Table (PGT)&quot; (page 3813)" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="action" descr="Action to apply on the packet:\;0: NOP - forward\;1: MIRROR_TO_CPU - forward and trap, trap_id is FDB_TRAP\;2: TRAP - (and do not forward), trap_id is FDB_TRAP\;15: DISCARD_ERROR" access="RW" offset="0xC.28" size="0x0.4" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RW" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX/-2\;Note: when the multicast is also to router to a router-sub-port inerface then the counter does not count" access="RW" offset="0x1C.24" size="0x0.8" />
</node>

<node name="multicast_tunnel_ext" descr="" size="0x10.0" >
	<field name="fid" descr="Filtering identifier (FID)\;Reserved when v_fid = 0\;Reserved when ubridge=1\;Reserved when Spectrum-2\;" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="underlay_mc_ptr_msb" descr="Most significant bits of Underlay Multicast Pointer. Used as a pointer to the first entry of the group based link lists of MC entries (for NVE tunnels). For Spectrum the number of link lists in the group is configured by TNGCR.nve_group_size_mc.\;The pointer points to entries which are configured by TNUMT or by TNGEE\;For Spectrum family, this points to an entry in the KVD Linear, see Appendix A.5.1, &quot;KVD Central Database&quot; (page 3820)" access="RW" offset="0x0.16" size="0x0.16" />
	<field name="mid" descr="Multicast identifier - global identifier that represents the multicast group across all devices" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="v_fid" descr="valid FID:\;0: .1Q bridge\;1: .1D bridge\;Reserved when ubridge=1\;Reserved when Spectrum-2\;" access="RW" offset="0x4.23" size="0x0.1" />
	<field name="underlay_mc_ptr_lsb" descr="Least significant bits of pointer to link list of flooding entries (for NVE tunnels)\;The pointer may point to TNGEE" access="RW" offset="0x4.24" size="0x0.8" />
	<field name="lbf_tunnel_port_bitmap" descr="Loopback Filter on Tunnel port when generic L2 encapsulation, bitmap:\;bit0: NVE\;bit1: VPLS\;bit2: Flex_tunnel0\;bit3: Flex_tunnel1\;bits4..15: reserved\;At least one bit must be set. If all bits are cleared then NVE is treated as set \;This is used only for loopback filter check\;" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="ecmp_size" descr="ecmp_size:\;ecmp_size is the amount of sequential entries starting from the\;pointer to the first TNUMT/TNGEE (the number of ECMPs).\;0: controlled by TNGCR.nve_group_size_mc\;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175.\;" access="RW" offset="0xC.0" size="0x0.13" />
</node>

<node name="multicast_tunnel_fdb_record_ext" descr="" size="0x20.0" >
	<field name="mac_47_32" descr="MAC address." access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="a" descr="Activity. \;Set for new STATIC_POLICY entries. Set for STATIC_POLICY entries if a frame lookup has hit the entry.\;To clear the a bit, use &quot;query and clear activity&quot; op.\;Enabled by activity_dis in SGCR, see Section 7.12.1, &quot;SGCR - Switch General Configuration Register&quot;, on page 1571\;Not supported by SwitchX and SwitchX2" access="RO" offset="0x0.16" size="0x0.1" />
	<field name="policy" descr="0: STATIC_POLICY - roaming disabled, aging disabled\;1: DYNAMIC_LEARN - HW learning enabled, aging disabled.\;\; -" access="RW" enum="STATIC_POLICY=0x0,DYNAMIC_LEARN=0x1" offset="0x0.17" size="0x0.1" />
	<field name="type_0xF" descr="0xF: Multicast_Tunnel_FDB_Record - this record\;See Section 7.2.18, &quot;FDB Records&quot;, on page 1516" access="RW" offset="0x0.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID.\;Reserved when Spectrum/-2" access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="mac_31_0" descr="MAC address." access="INDEX" offset="0x4.0" size="0x4.0" />
	<field name="fid" descr="Filtering ID\;When ubridge=0: only FIDs that are from vFID type are valid." access="INDEX" offset="0x8.0" size="0x0.16" />
	<field name="mid" descr="Multicast identifier - global identifier that represents the multicast group across all devices.\;For Spectrum, pointer to PGT table, see Appendix A.4.2, &quot;Port Group Table (PGT)&quot; (page 3813)" access="RW" offset="0x8.16" size="0x0.16" />
	<field name="underlay_mc_ptr" descr="Underlay Multicast Pointer. Used as a pointer to the first entry of the group based link lists of MC entries (for NVE tunnels). \;For Spectrum the number of link lists in the group is configured by TNGCR.nve_group_size_mc.\;The pointer points to entries which are configured by TNUMT or to TNGEE.\;For Spectrum family, this points to an entry in the KVD Linear, see Appendix A.4.1, &quot;KVD Central Database&quot; (page 3809)" access="RW" offset="0xC.0" size="0x0.24" />
	<field name="action" descr="Action to apply on the packet:\;0: NOP\;1: MIRROR_TO_CPU - (forward and trap), trap_id is FDB_TRAP" access="RW" enum="NOP=0x0,MIRROR_TO_CPU=0x1" offset="0xC.28" size="0x0.4" />
	<field name="tunnel_port_lbf_bitmap" descr="Tunnel port vector for the loopback filter. Bitmap:\;bit0: NVE\;bit1: VPLS\;bit2: Flex_tunnel0\;bit3: Flex_tunnel1\;bits4..15: reserved\;At least one bit must be set. If all bits are cleared then NVE is treated as set \;This is used only for loopback filter check. The check itself is configured by TNPC.\;" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="ecmp_size" descr="Ecmp_size:\;ecmp_size is the amount of sequential entries starting from the\;pointer to the first TNUMT/TNGEE (the number of ECMPs).\;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175.\;\;Reserevd when Spectrum and SwitchX/-2" access="RW" offset="0x14.0" size="0x0.13" />
	<field name="counter_index" descr="Counter Index for flow counters\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Not supported by SwitchX/-2" access="RW" offset="0x1C.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type for flow counters\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128\;Not supported by SwitchX/-2" access="RW" offset="0x1C.24" size="0x0.8" />
</node>

<node name="mvcap_reg_ext" descr="" size="0x10.0" >
	<field name="sensor_map" descr="Mapping of system sensors supported by the device. Each bit represents a sensor. \;The bitmap refers only for ambient sensors, no module and no ASIC.\;0: Not connected or not supported\;1: Supports voltage and current measurements" subnode="uint64" access="RO" offset="0x0.0" size="0x8.0" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x8.0" size="0x0.4" />
</node>

<node name="mvcr_ext" descr="" size="0x18.0" >
	<field name="sensor_index" descr="Sensors:\;- 0..max_system_sensors-1 are ambient sensors on the system (max_system_sensors from INI)\;" access="INDEX" offset="0x0.0" size="0x0.7" />
	<field name="slot_index" descr="Slot index\;0: Main board" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="voltage_sensor_value" descr="Voltage reading from the sensor. \;Voltage units are 0.01V." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="current_sensor_value" descr="Current reading from the sensor." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="current_sensor_value_msb" descr="Current reading from the sensor msb." access="RO" offset="0x8.16" size="0x0.16" />
	<field name="sensor_name" descr="Sensor Name\;8 character long sensor name.\;Reserved for index 64 - 127 (modules sensors)\;" subnode="uint64" access="RO" offset="0x10.0" size="0x8.0" />
</node>

<node name="next_action_set_record_ext" descr="" size="0x4.0" >
	<field name="next_action_set_ptr" descr="A pointer to the next action set in the KVD Centralized database.\;Points to KVH Linear\;For Spectrum-2: range is 0.. cap_max_kvd_action_sets - 1" offset="0x0.0" size="0x0.24" />
</node>

<node name="next_nhlfe_ext" descr="" size="0x2c.0" >
	<field name="exp" descr="EXP value for set_exp\;Reserved when Spectrum" access="RW" offset="0x0.16" size="0x0.3" />
	<field name="set_exp" descr="Set the packet EXP with exp value\;Reserved when Spectrum" access="RW" offset="0x0.19" size="0x0.1" />
	<field name="exp_rw" descr="EXP Re-write\;0: Preserve the value of the rewrite_enable\;1: Set the rewrite_enable\;2: Clear the rewrite_enable\;Reserved when Spectrum" access="RW" offset="0x0.20" size="0x0.2" />
	<field name="label_id" descr="Label id to push to the label stack\;Reserved when label_action is &apos;0&apos;" access="RW" offset="0x4.0" size="0x0.20" />
	<field name="label_action" descr="Label action:\;0: no push\;2: push label. Push a new label with label id label_id \;\;" access="RW" offset="0x4.24" size="0x0.3" />
	<field name="next_nhlfe" descr="NHLFE entry pointer\;Points to the NHLFE table. When using ECMP, points to the\;first entry in the ECMP list." access="RW" offset="0x10.0" size="0x0.24" />
	<field name="ecmp_size" descr="ecmp_size is the amount of sequential entries from the next_nhlfe pointer (the number of ECMPs). \;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175." access="RW" offset="0x14.0" size="0x0.13" />
</node>

<node name="pacl_ext" descr="" size="0x70.0" >
	<field name="acl_type" descr="Type of ACL.\;See Table 2109, &quot;ACL Types,&quot; on page 2483 for the supported ACL types.\;Reserved for Spectrum family.\;\;" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="v" descr="Valid. Setting the v bit makes the ACL valid. It should not be cleared while the ACL is bounded to either a port, VLAN or ACL rule." access="RW" offset="0x0.24" size="0x0.1" />
	<field name="e" descr="Type of ACL group. Only valid on Create ACL Group operation and Read.\;0: iACL\;1: eACL\;" access="INDEX" enum="iACL=0x0,eACL=0x1" offset="0x0.31" size="0x0.1" />
	<field name="acl_id" descr="An identifier representing the ACL (managed by software)\;Range 0 .. cap_max_acl_regions - 1\;" access="INDEX" offset="0x8.0" size="0x0.16" />
	<field name="tcam_region_info" descr="Information that represents the TCAM region to be used for the ACL. The region information is obtained by PTAR. \;The number of valid regions is derived from the ACL type. The first region will be used for the first packet type in the ACL type list and so forth.\;For Spectrum family entry [0] is used and entries [1..3] are reserved.\;For tcam_region_info [1..3] the value &apos;0&apos; indicates NULL region and can be used to indicate no rules for a specific packet type.\;Note: tcam_region_info[n] is mapped from (acl_id+n).\;\;" subnode="array128_auto" access="RW" high_bound="3" low_bound="0" offset="0x30.0" size="0x40.0" />
</node>

<node name="pagt_ext" descr="" size="0x80.0" >
	<field name="size" descr="Number of ACLs in the group.\;0: invalidate the group\;1 or more: add ACLs to the group\;Range 0 .. cap_max_acl_group_size\;Total number of ACLs in all groups must be lower or equal to cap_max_acl_tot_groups\;Note: a group which is binded must not be invalidated" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="e" descr="0: iACL\;1: eACL\;Reserved for Spectrum family\;" access="INDEX" enum="iACL=0x0,eACL=0x1" offset="0x0.31" size="0x0.1" />
	<field name="acl_group_id" descr="ACL group identifier\;Range of 0 .. cap_max_acl_groups-1" access="INDEX" offset="0x8.0" size="0x0.16" />
	<field name="acl_id_record" descr="See Table 2703, &quot;ACL ID Record Layout,&quot; on page 2936" subnode="acl_id_record_ext" access="RW" high_bound="19" low_bound="0" offset="0x30.0" size="0x50.0" />
</node>

<node name="pagt_v2_ext" descr="" size="0x18.0" >
	<field name="acl_group_element" descr="ACL group element\;Range of 0 .. cap_max_acl_tot_groups-1" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="n_v" descr="Next ACL group element is valid.\;0: not valid\;1: valid\;" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="id_v" descr="ACL ID is valid.\;0: not valid\;1: valid\;" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="next_acl_group_element" descr="Next ACL group element\;Range of 0 .. cap_max_acl_tot_groups-1\;Reserved when n_v=0" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="acl_id" descr="ACL identifier\;Range 0 .. cap_max_acl_regions - 1\;Reserved when id_v=0\;" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="commit" descr="ACL Commit\;0: No dedicated commit when the ACL is ended\;1: Do a commit when the ACL is ended\;All ACLs of a multi-ACL should have the same commit value\;Reserved when id_v=0\;Reserved when SwitchX/-2 and for Spectrum" access="RW" offset="0x8.30" size="0x0.1" />
	<field name="multi" descr="Multi-ACL\;0: This ACL is the last ACL in the multi-ACL\;1: This ACL is part of a multi-ACL\;Reserved when id_v=0\;Reserved when SwitchX/-2 and for Spectrum" access="RW" offset="0x8.31" size="0x0.1" />
</node>

<node name="pagtq_ext" descr="" size="0x110.0" >
	<field name="busy_selector" descr="Busy definition selector.\;An ACL group element is busy if:\;0: BUSY_ACL_ID - ACL ID is valid\;1: BUSY_ACL_ID_OR_NEXT - ACL ID is valid or next ACL group element is valid" access="OP" enum="BUSY_ACL_ID=0x0,BUSY_ACL_ID_OR_NEXT=0x1" offset="0x0.31" size="0x0.1" />
	<field name="acl_group_element_busy_bitmap" descr="Each bit represents an ACL group element from range 0 .. cap_max_acl_tot_groups-1.\;Bits cap_max_acl_tot_groups .. 2047 are reserved.\;0: not busy\;1: busy" access="RO" high_bound="63" low_bound="0" offset="0x10.0" size="0x100.0" />
</node>

<node name="paos_reg_ext" descr="" size="0x10.0" >
	<field name="oper_status" descr="Port operational state:\;1: up\;2: down\;4: down_by_port_failure - (transitioned by the hardware)\;  \;" access="RO" enum="up=0x1,down=0x2,down_by_port_failure=0x4" offset="0x0.0" size="0x0.4" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="admin_status" descr="Port administrative state (the desired state of the interface):\;1: up\;2: down_by_configuration\;3: up_once - if the port goes up and then down, the operational status should go to &quot;down by port failure&quot; and can only go back up upon explicit command\;4: disabled_by_system - this mode cannot be set by the software, only by the hardware.\;6: sleep - can be configured only if sleep_cap is set. Note that a sleep setting will cause the port to transition immediately into sleep state regardless of previous admin_status.\;\;\;[Internal] - up_once shall not be used for GPU case. In order to define link down state set PLDS register" access="RW" enum="up=0x1,down_by_configuration=0x2,up_once=0x3,disabled_by_system=0x4,sleep=0x6" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="swid" descr="For HCA: must always be 0.\;Switch partition ID with which to associate the port.\;Switch partitions are numbered from 0 to 7 inclusively.\;The swid field is only valid when the local_port is the router port. In this case, the swid indicates which of the router ports to configure/query." access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="e" descr="Event generation on operational state change (oper_status):\;0: Do_not_generate_event\;1: Generate_Event \;2: Generate_Single_Event\;\;Not Supported for HCA." access="RW" enum="Do_not_generate_event=0x0,Generate_Event=0x1,Generate_Single_Event=0x2" offset="0x4.0" size="0x0.2" />
	<field name="physical_state_status" descr="IB Port Physical link state:\;0: N/A\;1: Sleep\;2: Polling\;3: Disabled\;4: PortConfigurationTraining\;5: LinkUp\;6-15: reserved\;Note that physical state of 1,2,3,4 will all be reflected as oper_status = down.\;[internal] Note: Supported from XDR devices onwards\;Ethernet devices that support this field will use only bits 2,3,5." access="RO" enum="N_A=0x0,Sleep=0x1,Polling=0x2,Disabled=0x3,PortConfigurationTraining=0x4,LinkUp=0x5" offset="0x4.4" size="0x0.4" />
	<field name="fd" descr="Force down.\;Supported only when indicated in PCAM\;Can be set only with admin_status = 2 (&apos;down_by_configuration&apos;), will force link to be down. \;" access="RW" offset="0x4.8" size="0x0.1" />
	<field name="sleep_cap" descr="Sleep capability:\;0: Sleep state is not supported\;1: Sleep state supported" access="RO" offset="0x4.9" size="0x0.1" />
	<field name="ps_e" descr="Event generation for physical state.\;On set operation, will be ignored if ee_ps is not set.\;When bit is set, will generate an event for transition into state.\;Bit 0: Sleep\;Bit 1: LinkUp \;Note - LinkUp for an Ethernet link refers to PhyUp state where local side is ready, but not necessarily that peer side is also ready.\;Bit 2: Disabled\;Bit 3: PortConfigurationTraining\;Not Supported for HCA." access="RW" enum="Sleep=0x1,LinkUp=0x2,Disabled=0x4,PortConfigurationTraining=0x8" offset="0x4.12" size="0x0.4" />
	<field name="logical_state_status" descr="IB or NVLink Port Logical link state:\;0: N/A\;1: Down\;2: Init\;3: Arm\;4: Active" access="RO" enum="N_A=0x0,Down=0x1,Init=0x2,Arm=0x3,Active=0x4" offset="0x4.16" size="0x0.3" />
	<field name="ls_e" descr="event generation mask for logical state.\;On set operation, will be ignored when ee_ls is not set.\;When bit is set, will generate event for transition into state.\;Bit 0: Down\;Bit 1: Init\;Bit 2: Arm\;Bit 3: Active\;Not Supported for HCA." access="RW" enum="Down=0x1,Init=0x2,Arm=0x4,Active=0x8" offset="0x4.20" size="0x0.4" />
	<field name="ee_ps" descr="Event update enable for physical state. If this bit is set, event generation will be updated based on the ps_e field. Only relevant on Set operations.\;Not Supported for HCA." access="WO" offset="0x4.28" size="0x0.1" />
	<field name="ee_ls" descr="Event update enable for logical state. If this bit is set, event generation will be updated based on the ls_e field. Only relevant on Set operations.\;Not Supported for HCA." access="WO" offset="0x4.29" size="0x0.1" />
	<field name="ee" descr="Event update enable. If this bit is set, event generation will be updated based on the e field. Only relevant on Set operations.\;Not Supported for HCA." access="WO" offset="0x4.30" size="0x0.1" />
	<field name="ase" descr="Admin state update enable. If this bit is set, admin state will be updated based on admin_state field. Only relevant on Set() operations." access="WO" offset="0x4.31" size="0x0.1" />
</node>

<node name="pbgcr_ext" descr="" size="0xc.0" >
	<field name="psbtt" descr="Port Shared Buffer Threshold Type:\;0: DEFAULT_THRESHOLD - calculated by FW\;1: AUTO_AR_THRESHOLD - calculated by FW for AR optimization\;2: USER_VALUE - user value of the delta to add total headroom size.\;3: SET_SIB_AND_DIB_ABS_VALUE - [internal] values are set according to user_value and dib_user_value field (valid values are 0...511)." access="OP" enum="DEFAULT_THRESHOLD=0x0,AUTO_AR_THRESHOLD=0x1,USER_VALUE=0x2" offset="0x0.0" size="0x0.4" />
	<field name="ptb_index" descr="PTB index.\;If per_ptb=1 - the index of min_used_lines_for_sib[i]" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="per_ptb" descr="Per PTB.\;0: global_configuration\;1: per_PTB" access="OP" enum="global_configuration=0x0,per_PTB=0x1" offset="0x0.30" size="0x0.2" />
	<field name="user_val" descr="User Value for shared buffer threshold.\;Range 0...cap_max_headroom_size\;Units ??? TBD\;Default value 160\;\;Reserved when ppbt != 2\;" access="WO" offset="0x4.0" size="0x0.9" />
</node>

<node name="pbmc_reg_ext" descr="" size="0x6c.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="xoff_refresh" descr="The time before a new pause frame should be sent to refresh the pause state. Using the same units as xoff_timer_value above." access="RW" offset="0x4.0" size="0x0.16" />
	<field name="xoff_timer_value" descr="When device generates a pause frame, it uses this value as the pause timer.\;The pause timer is measured in units of pause &quot;quanta&quot;, where each unit is equal to 512 bit times." access="RW" offset="0x4.16" size="0x0.16" />
	<field name="port_buffer_size" descr="Total packet buffer array available for the port. The sum of buffer array allocated to bufferX must not exceed port_buffer_size.\;In Spectrum and above- Max supported Headroom buffer for port. \;" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="fullness_threshold" descr="Almost full threshold configuration.\;Percentage of buffer fullness which indicates &quot;almost full&quot; occurrence\;Range: 0-100%\;Reserved for Switches." access="RW" offset="0x8.16" size="0x0.7" />
	<field name="buffer" descr="Configuring per-buffer parameters. i=0..9" subnode="bufferx_reg_ext" access="RW" high_bound="9" low_bound="0" offset="0xC.0" size="0x50.0" />
	<field name="shared_headroom_pool" descr="Configuring shared haeadroom pool parameters. Using the same layout as in BufferX, for details see Table 1965, &quot;bufferX Register Layout,&quot; on page 2323.\;Not supported in SwitchX and SwitchX-2\;Not supported in HCA (See PCAM shp_pbmc_pbsr_support bit)." subnode="bufferx_reg_ext" access="RW" offset="0x5C.0" size="0x8.0" />
	<field name="port_shared_buffer" descr="Configuring port shared buffer parameters. Using the same layout as in BufferX, for details see Table 1965, &quot;bufferX Register Layout,&quot; on page 2323.\;Not supported in SwitchX and SwitchX-2\;Valid for HCA when pbmc_port_shared_buffer is set in PCAM." subnode="bufferx_reg_ext" access="RW" offset="0x64.0" size="0x8.0" />
</node>

<node name="pbsr_reg_ext" descr="" size="0x64.0" >
	<field name="buffer_type" descr="Valid only for 8x port setting (see PMLP): \;1: Main buffer\;2: Secondary buffer" access="INDEX" offset="0x0.0" size="0x0.2" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="clear_wm_buff_mask" descr="Each bit represents a stat_buffer\;per bit:\;0: do not clear watermark\;1: clear watermark\;Reserved when clear_wm = 1" access="OP" offset="0x4.0" size="0x0.10" />
	<field name="used_shared_headroom_buffer" descr="Number of currently used shared headroom buffer cells." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="clear_wm" descr="Clear watermarks for all PGs" access="OP" offset="0x8.31" size="0x0.1" />
	<field name="stat_buffer" descr="status per-buffer parameters. i=0..9\;" subnode="stat_bufferx_reg_ext" access="RO" high_bound="9" low_bound="0" offset="0xC.0" size="0x50.0" />
	<field name="stat_shared_headroom_pool" descr="status of shared headroom pool parameters. Using the same layout as in stat_BufferX, for details see Table 1988, &quot;stat_bufferX Register Layout,&quot; on page 2355.\;Not supported in SwitchX and SwitchX-2\;Not supported in HCA (See PCAM shp_pbmc_pbsr_support bit). \;Not supported in GPUNet" subnode="stat_bufferx_reg_ext" access="RO" offset="0x5C.0" size="0x8.0" />
</node>

<node name="pbwc_ext" descr="" size="0x8.0" >
	<field name="log_time_interval" descr="Log time interval.\;This field determine the time between measurements T:\;T = (2^log_time_interval) * 64uSec\;Range is dependent on the port&apos;s rate:\;800Gbps: 0..10\;400Gbps: 0..10\;200Gbps: 0..11\;100Gbps: 0..12\;50Gbps: 0..13\;25Gbps: 0..14\;10Gbps: 0..15\;Default is 7, means that T = (2^7) * 64uSec = 8mSec\;" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="alpha_factor" descr="Alpha for the exponential moving average formula.\;Alpha = 1/(2^alpha_factor)\;Range 0..7\;\;Default is 2" access="RW" offset="0x4.0" size="0x0.3" />
</node>

<node name="pbwr_ext" descr="" size="0x94.0" >
	<field name="local_port_bitmap" descr="Local port\;Each bit represents a local port. Refer to Section 9.3, &quot;Port Numbering&quot;, on page 1710 for port numbering scheme.\;Ports order in the bitmask is from bottom to top. e.g for setting local port 1, bit 1 in the last DWORD (offset 0x7Ch) should be set.\;CPU port is not supported.\;Router port is not supported" access="INDEX" high_bound="31" low_bound="0" offset="0x0.0" size="0x80.0" />
	<field name="num_rec" descr="Number of records.\;Range 0..1024.\;Range 1025..2047 is reserved." access="OP" offset="0x80.0" size="0x0.11" />
	<field name="dir" descr="Direction:\;0: ingress\;1: egress" access="OP" enum="ingress=0x0,egress=0x1" offset="0x80.31" size="0x0.1" />
	<field name="bw_record" descr="BW of the corresponding local port. Valid only if the corresponding bit at local_port_bitmap is set (1).\;Units of Mega bits.\;\;" access="RO" arr_is_dynamic="1" high_bound="VARIABLE" low_bound="0" offset="0x90.0" size="0x4.0" size_condition="$(parent).num_rec" />
</node>

<node name="pcam_reg_ext" descr="" size="0x50.0" >
	<field name="access_reg_group" descr="Access Register ID groups\;0: RegID_0x5000_to_0x507F\;1: RegID_0x5080_to_50FF\;Values 2-255 are Reserved" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="pl_op" descr="Reserved for non-planarized port.\;Features and access regs will be presented according to:\;0: aggregated_port_access\;1: plane_port_access" access="OP" enum="aggregated_port_access=0x0,plane_port_access=0x1" offset="0x0.8" size="0x0.1" />
	<field name="feature_group" descr="Feature list mask index: \;0: enhanced_features \;Values 1 - 255 are Reserved" access="INDEX" enum="enhanced_features=0x0" offset="0x0.16" size="0x0.8" />
	<field name="port_access_reg_cap_mask" descr="Supported port&apos;s access register bitmaks. Based on access_reg_group index.\;When bit is set , The register is supported in the device. \;When access_reg_group == 0 :\;Bit_0: 0x5000 \;Bit_1: 0x5001 (PCAP)\;Bit_2: 0x5002 (PMLP)\;Bit_3: 0x5003 (PMTU)\;Bit_4: 0x5004 (PTYS)\;Bit_127: 0x507F (PCAM)\;" access="RO" high_bound="3" low_bound="0" offset="0x8.0" size="0x10.0" />
	<field name="feature_cap_mask" descr="Supported port&apos;s enhanced features. Based on feature_group index.\;When bit is set, The feature is supported in the device:\;Bit 0: PPCNT_counter_group_Phy_statistical_counter_group \;Bit 1 - PPCNT_counter_group_Discard_counter_group\;Bit 9: PFCC - support of stall mask and global rx,tx mask. \;Bit 10: PMCR - support of tx_disable override.\;Bit 11: PPCNT_counter_group - IB Extended port counter group\;Bit 12: PPCNT_Extended_Ethernet_group - tx packet size histograms\;Bit 13: PTYS_extended_Ethernet_support\;Bit 14: PMAOS_reset_toggle_support\;Bit 15: Set_Module_low_power_supported \;Bit 16: Module_power_optimization_is_supported_in_PPSC\;Bit 17: Support_of_IB_force_state_machine_in_PTYS - (an_disable)\;Bit 18: PPCNT_Extended_Ethernet_group_icrc_counter\;Bit 19: cm2_en_is_supported_in_PCAP\;Bit 20: time_tolink_up_is_supported_in_PDDR\;Bit 21: gearbox_die_num_field_is_supported_in_PMDR\;Bit 22: force_entropy_entropy_calc_entropy_gre_calc - and capability bits are supported in PCMR\;Bit 23: FEC_override_support_for_50G_per_lane_is_supported_in_PPLM\;Bit 25: PTYS_allow_both_extended_and_legacy_protocol_masks\;Bit 26: PPCNT_eth_per_tc_cong_group_supported\;Bit 27: pnat_sup_host - the device supports pnat = 2 (host) when set to &apos;1&apos;\;Bit 28: ppcnt_no_buffer_discard_uc - this counter is supported in PPCNT when set to &apos;1&apos;\;Bit 29: pbmc_port_shared_buffer - supported in PBMC.\;Bit 30: PLR_max_retry_window_support - PPCNT group 0x22 max retry per window\;Bit 32: PDDR_ext_eth_proto_support\;Bit 41: PMAOS - support of &quot;opertional_notifcation&quot; field\;Bit 42: PRBS_polarity_support - support of polarity bits in PPTT and PPRT\;Bit 43: PDDR_register_is_supported\;Bit 44: pfcc_buffer_onwership - PFCC buffer ownership is supported.\;Bit 45: force_down - supported in PAOS reg.\;Bit 46: pmlp_lane_mapping_off - Support of m_lane_m field in PMLP.\;Bit 51: ppcnt_symobl_ber\;Bit 52: shp_pbmc_pbsr_support\;Bit 54: ppcnt_effective_error_counter\;Bit 55: FEC_override_support_for_100G_per_lane_is_supported_in_PPLM\;Bit 57: PMECR_option_to_not_generate_events_upon_PMLP_set\;Bit 64: Local_port_MSB - bits [9:8] supported\;Bit 65: PDDR_moule_latched_info_page_supported\;Bit 66: PDDR_module_info_ext_supported\;Bit 70: SLTP_tx_policy_supported\;Bit 71: pmcr_capability_bits_supported\;Bit 72: pmtu_max_admin_mtu_supported\;Bit 73: PPCNT_grp_profile_supported\;Bit 77: PPCNT.physical_layer_counters_RS_FEC_8_lanes_supported\;Bit 85: PPCNT.counters_cap\;Bit 86: SLTP.lane_broadcast_supported\;Bit 87: PMMP.apply_im_supported\;Bit 91: SLRG.all_lanes_supported\;Bit 92: PIPG.ipg_oper_ipg_cap_idx_supported\;Bit 93: PPBMP_clr_supported\;Bit 94: PIPG.dic1_1g_supported\;Other bits are reserved" access="RO" enum="PPCNT_counter_group_Phy_statistical_counter_group=0x1,PFCC=0x200,PMCR=0x400,PPCNT_counter_group=0x800,PPCNT_Extended_Ethernet_group=0x1000,PTYS_extended_Ethernet_support=0x2000,PMAOS_reset_toggle_support=0x4000,Set_Module_low_power_supported=0x8000,Module_power_optimization_is_supported_in_PPSC=0x10000,Support_of_IB_force_state_machine_in_PTYS=0x20000,PPCNT_Extended_Ethernet_group_icrc_counter=0x40000,cm2_en_is_supported_in_PCAP=0x80000,time_tolink_up_is_supported_in_PDDR=0x100000,gearbox_die_num_field_is_supported_in_PMDR=0x200000,force_entropy_entropy_calc_entropy_gre_calc=0x400000,FEC_override_support_for_50G_per_lane_is_supported_in_PPLM=0x800000,PTYS_allow_both_extended_and_legacy_protocol_masks=0x2000000,PPCNT_eth_per_tc_cong_group_supported=0x4000000,pnat_sup_host=0x8000000,ppcnt_no_buffer_discard_uc=0x10000000,pbmc_port_shared_buffer=0x20000000,PLR_max_retry_window_support=0x40000000,PDDR_ext_eth_proto_support=0x1,PMAOS=0x200,PRBS_polarity_support=0x400,PDDR_register_is_supported=0x800,pfcc_buffer_onwership=0x1000,force_down=0x2000,pmlp_lane_mapping_off=0x4000,ppcnt_symobl_ber=0x80000,shp_pbmc_pbsr_support=0x100000,ppcnt_effective_error_counter=0x400000,FEC_override_support_for_100G_per_lane_is_supported_in_PPLM=0x800000,PMECR_option_to_not_generate_events_upon_PMLP_set=0x2000000,Local_port_MSB=0x1,PDDR_moule_latched_info_page_supported=0x2,PDDR_module_info_ext_supported=0x4,SLTP_tx_policy_supported=0x40,pmcr_capability_bits_supported=0x80,pmtu_max_admin_mtu_supported=0x100,PPCNT_grp_profile_supported=0x200,PPCNT_physical_layer_counters_RS_FEC_8_lanes_supported=0x2000,PPCNT_counters_cap=0x200000,SLTP_lane_broadcast_supported=0x400000,PMMP_apply_im_supported=0x800000,SLRG_all_lanes_supported=0x8000000,PIPG_ipg_oper_ipg_cap_idx_supported=0x10000000,PPBMP_clr_supported=0x20000000,PIPG_dic1_1g_supported=0x40000000" high_bound="3" low_bound="0" offset="0x28.0" size="0x10.0" />
</node>

<node name="pcap_reg_ext" descr="" size="0x14.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="cm2_en" descr="port_capability_mask[95:80] is supported if set to &apos;1&apos;." access="RW" offset="0x0.31" size="0x0.1" />
	<field name="port_capability_mask" descr="Sets the PortInfoCapabilityMask:\;Specifies the supported capabilities of this node. A bit set to 1 for affirmation of supported capability.\;port_capability_mask[127:96] is mapped to CapabilityMask in PortInfo MAD.\;port_capability_mask[95:80] is mapped to CapabilityMask2 in PortInfo MAD.\;\;\;" access="RW" high_bound="3" low_bound="0" offset="0x4.0" size="0x10.0" />
</node>

<node name="pcie_perf_counters_ext" descr="" size="0xf8.0" >
	<field name="rx_errors" descr="Number of transitions to recovery due to Framing errors and CRC (dlp and tlp) errors." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="tx_errors" descr="Number of transitions to recovery due to EIEOS and TS errors." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="crc_error_dllp" descr="Number of transitions to recovery due to identifying CRC DLLP errors" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="crc_error_tlp" descr="Number of transitions to recovery due to identifying CRC TLP errors" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="tx_overflow_buffer_pkt" descr="The number of packets dropped due to lack of PCIe buffers or receive path from NIC port toward the hosts." subnode="uint64" access="RO" offset="0x28.0" size="0x8.0" />
	<field name="outbound_stalled_reads" descr="The percentage of time within the last second that the NIC had outbound non-posted read requests but could not perform the operation due to insufficient non-posted credits.\;Supported only when MCAM.pcie_outbound_stalled ==1." access="RO" offset="0x30.0" size="0x4.0" />
	<field name="outbound_stalled_writes" descr="The percentage of time within the last second that the NIC had outbound posted writes requests but could not perform the operation due to insufficient posted credits.\;Supported only when MCAM.pcie_outbound_stalled ==1." access="RO" offset="0x34.0" size="0x4.0" />
	<field name="outbound_stalled_reads_events" descr="The number of events where outbound_stalled_reads was above a threshold.\;The threshold is configured by outbound_stalled_reads_th in MPEGC.\;Supported only when MCAM.pcie_outbound_stalled ==1." access="RO" offset="0x38.0" size="0x4.0" />
	<field name="outbound_stalled_writes_events" descr="The number of events where outbound_stalled_writes was above a threshold.\;The threshold is configured by outbound_stalled_writes_th in MPEGC.\;Supported only when MCAM.pcie_outbound_stalled ==1." access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="tx_overflow_buffer_marked_pkt" descr="The number of packets marked due to lack of PCIe buffers or receive path from NIC port toward the hosts.\;Supported only if MCAM.mark_tx_action_cqe or MCAM.mark_tx_action_cnp are set to &apos;1&apos;." subnode="uint64" access="RO" offset="0x40.0" size="0x8.0" />
	<field name="effective_ber_coef" descr="Effective_BER = effective_ber_coef*10^(-effective_ber_magnitude)" access="RO" offset="0x48.0" size="0x0.4" />
	<field name="effective_ber_magnitude" descr="Effective_BER = effective_ber_coef*10^(-effective_ber_magnitude)" access="RO" offset="0x48.8" size="0x0.8" />
	<field name="fec_correctable_error_counter" descr="FEC correctable error counter when FLIT is enabled" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="fec_uncorrectable_error_counter" descr="FEC uncorrectable error counter when FLIT is enabled" access="RO" offset="0x58.0" size="0x4.0" />
</node>

<node name="pcie_physical_layer_ext" descr="" size="0x4.0" >
	<field name="eqlz_timeout_ph0" descr="" access="RO" offset="0x0.0" size="0x0.1" />
	<field name="eqlz_timeout_ph1" descr="" access="RO" offset="0x0.1" size="0x0.1" />
	<field name="eqlz_timeout_ph2" descr="" access="RO" offset="0x0.2" size="0x0.1" />
	<field name="eqlz_timeout_ph3" descr="" access="RO" offset="0x0.3" size="0x0.1" />
</node>

<node name="pcmr_reg_ext" descr="" size="0xc.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number\;" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="fcs_cap" descr="Specifies the check enable/disable capabilities of the local port. A bit set to 1 for affirmation of supported enable/disable capability: \;FCS check disable/enable capability" access="RO" offset="0x4.1" size="0x0.1" />
	<field name="rx_ts_over_crc_cap" descr="Specifies the ingress timestamps enable/disable capabilities of the local port. A bit set to 1 for affirmation of supported enable/disable capability" access="RO" offset="0x4.13" size="0x0.1" />
	<field name="rx_fcs_drop_cap" descr="Specifies the ingress drop enable/disable capabilities of the local port. A bit set to 1 for affirmation of supported enable/disable capability" access="RO" offset="0x4.14" size="0x0.1" />
	<field name="tx_fcs_recalc_cap" descr="Specifies the egress drop enable/disable capabilities of the local port. A bit set to 1 for affirmation of supported enable/disable capability" access="RO" offset="0x4.15" size="0x0.1" />
	<field name="tx_ts_over_crc_cap" descr="Specifies the egress timestamps enable/disable capabilities of the local port. A bit set to 1 for affirmation of supported enable/disable capability" access="RO" offset="0x4.16" size="0x0.1" />
	<field name="fcs_chk" descr="FCS check\;Values:\;0: disable check. \;1: perform check\;Note: when disabling a check, it will also affects the relevant counters." access="RW" offset="0x8.1" size="0x0.1" />
	<field name="rx_ts_over_crc" descr="RX TimeStamp over FCS\;0: no TS over FCS\;1: TS over FCS\;Note: \;1. If this filed is changed while traffic is passing then some packets may be dropped due to incorrect FCS.\;2. Default value is (1) - TS over FCS\;Reserved when GPUNet" access="RW" offset="0x8.13" size="0x0.1" />
	<field name="rx_fcs_drop" descr="RX FCS drop control:\;0: ingress port will drop a packet with bad FCS (Default)\;1: ingress port will not drop a packet with bad FCS\;NOTE: All FCS counters (PPCNT) are valid for both drop modes.\;NOTE: Reserved when PCMR.fcs_cap=1 &amp; PCMR.fcs_chk=0" access="RW" offset="0x8.14" size="0x0.1" />
	<field name="tx_fcs_recalc" descr="TX FCS recalculation:\;0: egress port will recalculate and overwrite FCS value (Default) \;1: egress port will not overwrite FCS value \;NOTE: when this bit is set, any modification of the packet will result in a bad FCS.\;Reserved when GPUNet" access="RW" offset="0x8.15" size="0x0.1" />
	<field name="tx_ts_over_crc" descr="TX TimeStamp over FCS\;0: no TS over FCS\;1: TS over FCS\;Reserved when tx_fcs_recalc is set\;Reserved when GPUNet" access="RW" offset="0x8.16" size="0x0.1" />
</node>

<node name="pcnr_reg_ext" descr="" size="0xc.0" >
	<field name="tuning_override" descr="When set, port will override tuning process upon following link-up command (PAOS.admin_status = UP).\;Cleared by FW once PAOS.admin_status = UP command is set.\;\;The tuning_override is recommended to be set when port operational status is UP (PAOS.oper_status=0x1).\;If the field is set while operational status is DOWN (PAOS.oper_status=0x2), port will do best effort of fast linkup on the possible parts of the link (that is, known internal links that cannot change)." access="WO" offset="0x0.0" size="0x0.1" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="keep_phy_setting" descr="When Set, The port will keep the same phy setting upon link down event that occurs only upon link down command of peer port. In the event of Down command/cable disconnect, entire link up flow will be initialized.\;\;NOTE: This mode can be configured only when PTYS.an_disable_admin is set (i.e. AN is disabled). \;NOTE: if physical environment was changed (i.e. replacement of module, temp change, etc) there is a possibility that link won&apos;t be established or will be established with high BER" access="WO" offset="0x4.0" size="0x0.1" />
</node>

<node name="pddr_c2p_link_enabed_eth_ext" descr="" size="0x4.0" >
	<field name="core_to_phy_link_eth_enabled" descr="Ethernet protocols admin state: see PTYS.ext_eth_proto_admin" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_c2p_link_enabed_ib_ext" descr="" size="0x4.0" >
	<field name="core_to_phy_link_proto_enabled" descr="ib link enabled speed:\;Bit 0: SDR\;Bit 1: DDR\;Bit 2: QDR\;Bit 3: FDR10\;Bit 4: FDR\;Bit 5: EDR\;Bit 6: HDR\;Bit 7: NDR\;Bit 8: XDR" access="RO" enum="SDR=0x1,DDR=0x2,QDR=0x4,FDR10=0x8,FDR=0x10,EDR=0x20,HDR=0x40,NDR=0x80,XDR=0x100" offset="0x0.0" size="0x0.16" />
	<field name="core_to_phy_link_width_enabled" descr="ib link enabled width:\;Bit 0: 1x\;Bit 1: 2x\;Bit 2: 4x\;\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_cable_cap_eth_ext" descr="" size="0x4.0" >
	<field name="cable_ext_eth_proto_cap" descr="Cable Ethernet protocols cap. If PTYS.ext_eth_proto_cap filed is supported, use for opcode definition PTYS.ext_eth_proto_capIf PTYS.ext_eth_proto_capability mask is empty, use For opcode definition PTYS.eth_proto_cap." access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_cable_cap_ib_ext" descr="" size="0x4.0" >
	<field name="cable_link_speed_cap" descr="Cable support IB speed:\;Bit 0: SDR\;Bit 1: DDR\;Bit 2: QDR\;Bit 3: FDR10\;Bit 4: FDR\;Bit 5: EDR\;Bit 6: HDR\;Bit 7: NDR\;Bit 8: XDR" access="RO" enum="SDR=0x1,DDR=0x2,QDR=0x4,FDR10=0x8,FDR=0x10,EDR=0x20,HDR=0x40,NDR=0x80,XDR=0x100" offset="0x0.0" size="0x0.16" />
	<field name="cable_link_width_cap" descr="Cable support IB width:\;Bit 0: 1x\;Bit 1: 2x\;Bit 2: 4x\;\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_link_active_eth_ext" descr="" size="0x4.0" >
	<field name="link_eth_active" descr="Ethernet protocols active : see PTYS.ext_eth_proto_oper" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_link_active_ib_ext" descr="" size="0x4.0" >
	<field name="link_speed_active" descr="ib link active speed:\;Bit 0: SDR\;Bit 1: DDR\;Bit 2: QDR\;Bit 3: FDR10\;Bit 4: FDR\;Bit 5: EDR\;Bit 6: HDR\;Bit 7: NDR\;Bit 8: XDR" access="RO" enum="SDR=0x1,DDR=0x2,QDR=0x4,FDR10=0x8,FDR=0x10,EDR=0x20,HDR=0x40,NDR=0x80,XDR=0x100" offset="0x0.0" size="0x0.16" />
	<field name="link_width_active" descr="ib link active width:\;Bit 0: 1x\;Bit 1: 2x\;Bit 2: 4x\;\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_link_down_info_page_ext" descr="" size="0xf4.0" >
	<field name="down_blame" descr="Which receiver caused last link down: \;0: Unknown\;1: Local_phy\;2: Remote_phy" access="RO" enum="Unknown=0x0,Local_phy=0x1,Remote_phy=0x2" offset="0x0.0" size="0x0.4" />
	<field name="local_reason_opcode" descr="Opcde of link down reason for local / remote side: \;0: No_link_down_indication\;1: Unknown_reason\;2: Hi_SER_or_Hi_BER\;3: Block_Lock_loss\;4: Alignment_loss\;5: FEC_sync_loss\;6: PLL_lock_loss\;7: FIFO_overflow\;8: false_SKIP_condition\;9: Minor_Error_threshold_exceeded\;10: Physical_layer_retransmission_timeout\;11: Heartbeat_errors\;12: Link_Layer_credit_monitoring_watchdog\;13: Link_Layer_integrity_threshold_exceeded\;14: Link_Layer_buffer_overrun\;15: Down_by_outband_command_with_healthy_link\;16: Down_by_outband_command_for_link_with_hi_ber\;17: Down_by_inband_command_with_healthy_link\;18: Down_by_inband_command_for_link_with_hi_ber\;19: Down_by_verification_GW\;20: Received_Remote_Fault \;21: Received_TS1\;22: Down_by_management_command\;23: Cable_was_unplugged\;24: Cable_access_issue \;25: Thermal_shutdown \;26: Current_issue \;27: Power_budget\;28: Fast_recovery_raw_ber\;29: Fast_recovery_effective_ber\;30: Fast_recovery_symbol_ber\;31: Fast_recovery_credit_watchdog\;32: Peer_side_down_to_sleep_state\;33: Peer_side_down_to_disable_state\;34: Peer_side_down_to_disable_and_port_lock\;35: Peer_side_down_due_to_thermal_event\;36: Peer_side_down_due_to_force_event\;37: Peer_side_down_due_to_reset_event" access="RO" enum="No_link_down_indication=0x0,Unknown_reason=0x1,Hi_SER_or_Hi_BER=0x2,Block_Lock_loss=0x3,Alignment_loss=0x4,FEC_sync_loss=0x5,PLL_lock_loss=0x6,FIFO_overflow=0x7,false_SKIP_condition=0x8,Minor_Error_threshold_exceeded=0x9,Physical_layer_retransmission_timeout=0xa,Heartbeat_errors=0xb,Link_Layer_credit_monitoring_watchdog=0xc,Link_Layer_integrity_threshold_exceeded=0xd,Link_Layer_buffer_overrun=0xe,Down_by_outband_command_with_healthy_link=0xf,Down_by_outband_command_for_link_with_hi_ber=0x10,Down_by_inband_command_with_healthy_link=0x11,Down_by_inband_command_for_link_with_hi_ber=0x12,Down_by_verification_GW=0x13,Received_Remote_Fault=0x14,Received_TS1=0x15,Down_by_management_command=0x16,Cable_was_unplugged=0x17,Cable_access_issue=0x18,Thermal_shutdown=0x19,Current_issue=0x1a,Power_budget=0x1b,Fast_recovery_raw_ber=0x1c,Fast_recovery_effective_ber=0x1d,Fast_recovery_symbol_ber=0x1e,Fast_recovery_credit_watchdog=0x1f,Peer_side_down_to_sleep_state=0x20,Peer_side_down_to_disable_state=0x21,Peer_side_down_to_disable_and_port_lock=0x22,Peer_side_down_due_to_thermal_event=0x23,Peer_side_down_due_to_force_event=0x24,Peer_side_down_due_to_reset_event=0x25" offset="0x4.0" size="0x0.8" />
	<field name="remote_reason_opcode" descr="Opcde of link down reason for local / remote side: \;0: No_link_down_indication\;1: Unknown_reason\;2: Hi_SER_or_Hi_BER\;3: Block_Lock_loss\;4: Alignment_loss\;5: FEC_sync_loss\;6: PLL_lock_loss\;7: FIFO_overflow\;8: false_SKIP_condition\;9: Minor_Error_threshold_exceeded\;10: Physical_layer_retransmission_timeout\;11: Heartbeat_errors\;12: Link_Layer_credit_monitoring_watchdog\;13: Link_Layer_integrity_threshold_exceeded\;14: Link_Layer_buffer_overrun\;15: Down_by_outband_command_with_healthy_link\;16: Down_by_outband_command_for_link_with_hi_ber\;17: Down_by_inband_command_with_healthy_link\;18: Down_by_inband_command_for_link_with_hi_ber\;19: Down_by_verification_GW\;20: Received_Remote_Fault \;21: Received_TS1\;22: Down_by_management_command\;23: Cable_was_unplugged\;24: Cable_access_issue \;25: Thermal_shutdown \;26: Current_issue \;27: Power_budget\;28: Fast_recovery_raw_ber\;29: Fast_recovery_effective_ber\;30: Fast_recovery_symbol_ber\;31: Fast_recovery_credit_watchdog\;32: Peer_side_down_to_sleep_state\;33: Peer_side_down_to_disable_state\;34: Peer_side_down_to_disable_and_port_lock\;35: Peer_side_down_due_to_thermal_event\;36: Peer_side_down_due_to_force_event\;37: Peer_side_down_due_to_reset_event" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="e2e_reason_opcode" descr="see local_reason_opcode for local reason opcode\;for remote reason opcode: local_reason_opcode+100" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="ts1_opcode" descr="TS1 opcode describes the reason the peer requested to ramp down the link:\;0x8: TS1.Sleep\;0x9: TS1.Disable\;0xA: TS1.PortLock\;0xB: TS1.Thermal\;0xC: TS1.Clean \;0xD  : TS1.Force\;0xE: TS1.reset_req\;\;Note: This field is valid in case the local_reason_opcode = 21 or 32-38" access="RO" offset="0xC.12" size="0x0.4" />
	<field name="min_est_eff_ber_magnitude" descr="Minimal estimated effective BER window measured.\;\;Estimated_Effective_BER = min_est_eff_ber_coef*10^(-min_esteff_ber_magnitude)" access="RO" offset="0x30.0" size="0x0.8" />
	<field name="min_est_eff_ber_coef" descr="Minimal estimated effective BER window measured.\;\;Estimated_Effective_BER = min_est_eff_ber_coef*10^(-min_esteff_ber_magnitude)" access="RO" offset="0x30.8" size="0x0.4" />
	<field name="mean_est_eff_ber_magnitude" descr="Mean estimated effective BER window measured.\;\;Estimated_Effective_BER = mean_est_eff_ber_coef*10^(-mean_est_eff_ber_magnitude)" access="RO" offset="0x30.16" size="0x0.8" />
	<field name="mean_est_eff_ber_coef" descr="Mean estimated effective BER window measured.\;\;Estimated_Effective_BER = mean_est_eff_ber_coef*10^(-mean_est_eff_ber_magnitude)" access="RO" offset="0x30.24" size="0x0.4" />
	<field name="max_est_eff_ber_magnitude" descr="Maximal estimated effective BER window measured.\;\;Estimated_Effective_BER = max_est_eff_ber_coef*10^(-max_est_eff_ber_magnitude)" access="RO" offset="0x34.0" size="0x0.8" />
	<field name="max_est_eff_ber_coef" descr="Maximal estimated effective BER window measured.\;\;Estimated_Effective_BER = max_est_eff_ber_coef*10^(-max_est_eff_ber_magnitude)" access="RO" offset="0x34.8" size="0x0.4" />
	<field name="num_of_est_eff_ber_alarms" descr="Number of Estimated Effective BER Windows that crossed alarm threshold" access="RO" offset="0x38.0" size="0x0.16" />
	<field name="num_of_est_eff_ber_warnings" descr="Number of Estimated Effective BER Windows that crossed warning threshold\;" access="RO" offset="0x38.16" size="0x0.16" />
</node>

<node name="pddr_module_info_ext" descr="" size="0xd8.0" >
	<field name="ethernet_compliance_code" descr="QSFP:\;Ethernet Compliance Codes bit mask (10/40G/100G)\;Byte131 per SFF-8636 \;Bit 7 - Extended Specification Compliance valid\;Bit 6 - 10GBASE-LRM\;Bit 5 - 10GBASE-LR\;Bit 4 - 10GBASE-SR\;Bit 3 - 40GBASE-CR4\;Bit 2 - 40GBASE-SR4\;Bit 1 - 40GBASE-LR4\;Bit 0 - 40G Active Cable (XLPPI)\;\;SFP : \;10G Ethernet Compliance Codes\;Byte3 per SFF-8472:\;Bit 7 - 10G Base-ER \;Bit 6 - 10G Base-LRM \;Bit 5 - 10G Base-LR \;Bit 4 - 10G Base-SR\;\;CMIS based (QSFP-DD/ SFP-DD / OSFP)\;Byte 87 - Module Media Interface" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="ext_ethernet_compliance_code" descr="Extended Specification Compliance Codes \;for SFP:\;byte 36 per SFF-8472\;\;for QSFP:\;byte192 per SFF-8636 (QSFP28) \;\;for CMIS (SFP-DD / QSFP-DD/ OSFP):\;Byte 86 - Host Electrical Interface" access="RW" offset="0x0.8" size="0x0.8" />
	<field name="cable_breakout" descr="Reserved for SFP. \;\;For QSFP:\;Byte113 per SFF-8636\;\;For CMIS based modules:\;\;XX naming is according to cable_identifier name\;For example: if cable_identifier = ,6 XX string is QSFP-DD\;\;0 - Unspecified\;1 - XX to XX\;2 - XX to 2xQSFP or 2xXX (depopulated / 4 lanes)\;3 - XX to 4xDSFP or 4xQSFP (depopulated / 2 lanes)\;4 - XX to 8xSFP\;5 - XX (depopulated / 4 lanes) to QSFP or XX (depopulated / 4 lanes)\;6 - XX (depopulated / 4 lanes) to 2xXX(depopulated / 2 lanes) or 2xSFP-DD\;7 - XX (depopulated / 4 lanes) to 4xSFP\;8 - XX(/ 2 lane module) to XX\;9 - XX(/ 2 lane module) to 2xSFP" access="RW" offset="0x0.16" size="0x0.8" />
	<field name="cable_technology" descr="QSFP: \;Byte 147 per SFF-8636.\;\;SFP:\;SFP+ Cable Technology: \;byte8 per SFF-8472:\;Bit 3 - Active Cable\;Bit 2 - Passive Cable\;\;CMIS based (QSFP-DD / OSFP/ SFP-DD):\;Byte 212" access="RW" offset="0x0.24" size="0x0.8" />
	<field name="cable_power_class" descr="Module maximum power consumption for SFP/QSFP:\;0: Power_Class_0 - (1.0 W max)\;1: Power_Class_1 - (1.5 W max)\;2: Power_Class_2 - (2.0 W max)\;3: Power_Class_3 - (2.5 W max)\;4: Power_Class_4 - (3.5 W max)\;5: Power_Class_5 - (4.0 W max)\;6: Power_Class_6 - (4.5 W max)\;7: Power_Class_7 - (5.0 W max)\;8: Power_Class_8 - (power from max_power field)\;\;Module maximum power consumption for SFP-DD:\;0: Power_Class_0 - (0.5 W max)\;1: Power_Class_1 - (1.0 W max)\;2: Power_Class_2 - (1.5 W max)\;3: Power_Class_3 - (2.0 W max)\;4: Power_Class_4 - (3.5 W max)\;5: Power_Class_5 - (5.0 W max)\;6: reserved\;7: reserved\;8: Power_Class_8 - (power from max_power field)\;\;Module maximum power consumption for QSFP-DD/OSFP:\;1 - Power_Class_1 - (1.5 W max)\;2 - Power_Class_2 - (3.5 W max)\;3 - Power_Class_3 - (7.0 W max)\;4 - Power_Class_4 - (8.0 W max)\;5 - Power_Class_5 - (10 W max)\;6 - Power_Class_6 - (12 W max)\;7 - Power_Class_7 - (14 W max)\;8 - Power_Class_8 - (power from max_power field)" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="cable_identifier" descr="0: QSFP28\;1: QSFP_Plus\;2: SFP28_or_SFP_Plus\;3: QSA - (QSFP-&gt;SFP)\;4: Backplane\;5: SFP_DD\;6: QSFP_DD\;7: QSFP_CMIS\;8: OSFP\;9: C2C\;10: DSFP\;11: QSFP_Split_Cable\;\;identifiers that are CMIS compliant are: 5,6,7,8,10" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="cable_length" descr="Cable length in 1m units.\;\;For CMIS modules:\;bits 6:7 represent cable_length_multiplier for calculating cable length\;00 - 0.1 multiplier (0.1 to 6.3m)\;01- 1 multiplier (1 to 63m)\;10 - 10 multiplier (10 to 630m)\;11 - 100 multiplier (100 to 6300m)\;\;bits 0:5 represent cable_length_value for calculating cable length.\;length is calculated with cable_length_value * cable_length_multiplier" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="cable_vendor" descr="Cable vendor:\;0: Other\;1: Mellanox\;2: Known_OUI\;3: NVIDIA\;" access="RO" enum="Other=0x0,Mellanox=0x1,Known_OUI=0x2,NVIDIA=0x3" offset="0x4.24" size="0x0.4" />
	<field name="cable_type" descr="Cable/module type:\;0: Unidentified\;1: Active_cable - (active copper / optics)\;2: Optical_Module - (separated)\;3: Passive_copper_cable\;4: Cable_unplugged\;5: Twisted_pair\;" access="RO" enum="Unidentified=0x0,Active_cable=0x1,Optical_Module=0x2,Passive_copper_cable=0x3,Cable_unplugged=0x4,Twisted_pair=0x5" offset="0x4.28" size="0x0.4" />
	<field name="cable_tx_equalization" descr="\;" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="cable_rx_emphasis" descr="\;For CMIS (QSFP-DD/ SFP-DD/ OSFP) field will represent Rx pre-emphasis." access="RO" offset="0x8.8" size="0x0.8" />
	<field name="cable_rx_amp" descr="Reserved for SFP\;" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="max_power" descr="Reserved for SFP, QSFP\;Byte 201 for CMIS (QSFP-DD/ SFP-DD/ OSFP)\;Other Cable ignore field." access="RO" offset="0x8.24" size="0x0.8" />
	<field name="cable_attenuation_5g" descr="Reserved for SFP" access="RO" offset="0xC.0" size="0x0.8" />
	<field name="cable_attenuation_7g" descr="Reserved for SFP" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="cable_attenuation_12g" descr="Reserved for SFP" access="RO" offset="0xC.16" size="0x0.8" />
	<field name="cable_attenuation_25g" descr="Valid only for CMIS (QSFP-DD/ SFP-DD/ OSFP)\;Other Cable ignore field." access="RO" offset="0xC.24" size="0x0.8" />
	<field name="tx_cdr_state" descr="Reserved for SFP\;\;Bit 0 - TX CDR on/off on channel 0 \;Bit 1 - TX CDR on/off on channel 1 \;Bit 2 - TX CDR on/off on channel 2 \;Bit 3 - TX CDR on/off on channel 3 \;Bit 4 - TX CDR on/off on channel 4 \;Bit 5 - TX CDR on/off on channel 5 \;Bit 6 - TX CDR on/off on channel 6 \;Bit 7 - TX CDR on/off on channel 7 \;\;CDR on - when bit is set.\;CDR off - when bit is clear.\;" access="RO" offset="0x10.0" size="0x0.8" />
	<field name="rx_cdr_state" descr="Reserved for SFP\;\;Bit 0 - RX CDR on/off on channel 0 \;Bit 1 - RX CDR on/off on channel 1 \;Bit 2 - RX CDR on/off on channel 2 \;Bit 3 - RX CDR on/off on channel 3\;Bit 4 - RX CDR on/off on channel 4 \;Bit 5 - RX CDR on/off on channel 5 \;Bit 6 - RX CDR on/off on channel 6 \;Bit 7 - RX CDR on/off on channel 7 \;\;CDR on - when bit is set.\;CDR off - when bit is clear.\;" access="RO" offset="0x10.8" size="0x0.8" />
	<field name="tx_cdr_cap" descr="0 - No CDR\;1 - Build-in CDR with on/off control \;2 - Build-in CDR without on/off control" access="RO" offset="0x10.16" size="0x0.4" />
	<field name="rx_cdr_cap" descr="0 - No CDR\;1 - Build-in CDR with on/off control \;2 - Build-in CDR without on/off control" access="RO" offset="0x10.20" size="0x0.4" />
	<field name="cable_rx_post_emphasis" descr="Valid only for CMIS (QSFP-DD/ SFP-DD/ OSFP)\;Rx post-emphasis." access="RO" offset="0x10.24" size="0x0.8" />
	<field name="vendor_name" descr="ASCII Vendor name left-aligned and padded on the right with\;ASCII spaces (20h)" access="RO" high_bound="3" low_bound="0" offset="0x14.0" size="0x10.0" />
	<field name="vendor_pn" descr="Vendor Part Number left-aligned and padded on the right with ASCII spaces (20h)" access="RO" high_bound="3" low_bound="0" offset="0x24.0" size="0x10.0" />
	<field name="vendor_rev" descr="ASCII Vendor revision aligned to right padded with 0h on the left" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="fw_version" descr="If information is not available by the module: set to 0" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="vendor_sn" descr="Vendor Serial Number" access="RO" high_bound="3" low_bound="0" offset="0x3C.0" size="0x10.0" />
	<field name="voltage" descr="Internally measured supply voltage in 100uV" access="RO" offset="0x4C.00" size="0x0.16" />
	<field name="temperature" descr="module temperature in 1/256 C" access="RO" offset="0x4C.16" size="0x0.16" />
	<field name="rx_power_lane1" descr="RX measured power channel 1.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x50.0" size="0x0.16" />
	<field name="rx_power_lane0" descr="RX measured power channel 0.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x50.16" size="0x0.16" />
	<field name="rx_power_lane3" descr="RX measured power channel 3.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x54.0" size="0x0.16" />
	<field name="rx_power_lane2" descr="RX measured power channel 2.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x54.16" size="0x0.16" />
	<field name="rx_power_lane5" descr="RX measured power channel 5.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x58.0" size="0x0.16" />
	<field name="rx_power_lane4" descr="RX measured power channel 4.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x58.16" size="0x0.16" />
	<field name="rx_power_lane7" descr="RX measured power channel 7.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x5C.0" size="0x0.16" />
	<field name="rx_power_lane6" descr="RX measured power channel 6.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x5C.16" size="0x0.16" />
	<field name="tx_power_lane1" descr="TX measured power channel 1.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x60.0" size="0x0.16" />
	<field name="tx_power_lane0" descr="TX measured power channel 0.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x60.16" size="0x0.16" />
	<field name="tx_power_lane3" descr="TX measured power channel 3.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x64.0" size="0x0.16" />
	<field name="tx_power_lane2" descr="TX measured power channel 2.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x64.16" size="0x0.16" />
	<field name="tx_power_lane5" descr="TX measured power channel 5.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x68.0" size="0x0.16" />
	<field name="tx_power_lane4" descr="TX measured power channel 4.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x68.16" size="0x0.16" />
	<field name="tx_power_lane7" descr="TX measured power channel 7.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x6C.0" size="0x0.16" />
	<field name="tx_power_lane6" descr="TX measured power channel 6.\;measured in dBm/uW according to module_info_ext value" access="RO" offset="0x6C.16" size="0x0.16" />
	<field name="tx_bias_lane1" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x70.0" size="0x0.16" />
	<field name="tx_bias_lane0" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x70.16" size="0x0.16" />
	<field name="tx_bias_lane3" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x74.0" size="0x0.16" />
	<field name="tx_bias_lane2" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x74.16" size="0x0.16" />
	<field name="tx_bias_lane5" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x78.0" size="0x0.16" />
	<field name="tx_bias_lane4" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x78.16" size="0x0.16" />
	<field name="tx_bias_lane7" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x7C.0" size="0x0.16" />
	<field name="tx_bias_lane6" descr="TX measured bias current on channel [i] in 2uA unit.\;\;The real sample value in uA units should be calculated as follows:\;tx_bias_lane[i] * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x7C.16" size="0x0.16" />
	<field name="temperature_low_th" descr="Alarm low temperature threshold in 1/256 C" access="RO" offset="0x80.0" size="0x0.16" />
	<field name="temperature_high_th" descr="Alarm high temperature threshold in 1/256 C" access="RO" offset="0x80.16" size="0x0.16" />
	<field name="voltage_low_th" descr="Alarm low Voltage threshold in 100uV" access="RO" offset="0x84.0" size="0x0.16" />
	<field name="voltage_high_th" descr="Alarm high Voltage threshold in 100uV" access="RO" offset="0x84.16" size="0x0.16" />
	<field name="rx_power_low_th" descr="Alarm low RX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x88.0" size="0x0.16" />
	<field name="rx_power_high_th" descr="Alarm high RX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x88.16" size="0x0.16" />
	<field name="tx_power_low_th" descr="Alarm low TX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x8C.0" size="0x0.16" />
	<field name="tx_power_high_th" descr="Alarm high TX Power threshold in dBm. \;Taking only from channel 0." access="RO" offset="0x8C.16" size="0x0.16" />
	<field name="tx_bias_low_th" descr="Alarm low TX Bias current threshold in 2 uA. \;\;The real threshold value in uA units should be calculated as follows:\;tx_bias_high_th * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x90.0" size="0x0.16" />
	<field name="tx_bias_high_th" descr="Alarm high TX Bias current threshold in 2 uA.\;\;The real threshold value in uA units should be calculated as follows:\;tx_bias_high_th * 2 * tx_bias_scaling_factor[enum_value]" access="RO" offset="0x90.16" size="0x0.16" />
	<field name="wavelength" descr="Nominal laser wavelength in nm" access="RO" offset="0x94.0" size="0x0.16" />
	<field name="smf_length" descr="SMF link length\;SFP per byte 14,15.\;QSFP per byte 142\;for CMIS based modules, per byte 132\;\;bit 9:8 - 00 length base in 1 km units\;bit 9:8 - 01 length base in 100m units\;bits 7:0 - length base" access="RO" offset="0x94.16" size="0x0.10" />
	<field name="rx_output_valid_cap" descr="when set, indicates rx_output_valid is supported by the module" access="RW" offset="0x94.26" size="0x0.1" />
	<field name="did_cap" descr="set in case of Linear Direct Drive module" access="RO" offset="0x94.27" size="0x0.1" />
	<field name="rx_power_type" descr="rx power measurement type\;0: OMA\;1: Average_power" access="RO" enum="OMA=0x0,Average_power=0x1" offset="0x94.28" size="0x0.1" />
	<field name="module_st" descr="Valid for CMIS modules only.\;Module state:\;0: reserved\;1: LowPwr_state\;2: PwrUp_state\;3: Ready_state\;4: PwrDn_state\;5: Fault_state" access="RO" enum="reserved=0x0,LowPwr_state=0x1,PwrUp_state=0x2,Ready_state=0x3,PwrDn_state=0x4,Fault_state=0x5" offset="0x94.29" size="0x0.3" />
	<field name="ib_compliance_code" descr="Byte 164 of SFF-8636\;For CMIS modules IB Protocols." access="RO" offset="0x98.0" size="0x0.8" />
	<field name="tx_bias_scaling_factor" descr="Valid for CMIS modules only.\;This field is relevant for the following fields: tx_bias_lane[7:0], tx_bias_high_th and tx_bias_low_th.\;The value of the above fields should be multiplied according to the tx_bias_scaling_factor value.\;0: multiply_1x\;1: multiply_2x\;2: multiply_4x\;" access="RW" enum="multiply_1x=0x0,multiply_2x=0x1,multiply_4x=0x2" offset="0x98.10" size="0x0.2" />
	<field name="active_set_media_compliance_code" descr="Valid for CMIS modules only.\;According to current Active set, value of Module Media Interface byte" access="RO" offset="0x98.16" size="0x0.8" />
	<field name="active_set_host_compliance_code" descr="Valid for CMIS modules only.\;According to current Active set, value of Host Electrical Interface byte" access="RO" offset="0x98.24" size="0x0.8" />
	<field name="ib_width" descr="Bitmask of width of IB Protocols" access="RO" offset="0x9C.0" size="0x0.6" />
	<field name="monitor_cap_mask" descr="monitoring capabilities mask\;Bit 0 - temperature monitoring implemented\;Bit 1 - voltage monitoring implemented\;Bit 2 - tx power monitoring implemented\;Bit 3 - rx power monitoring implemented\;Bit 4 - tx bias monitoring implemented" access="RO" offset="0x9C.8" size="0x0.8" />
	<field name="nbr100" descr="Nominal bit rate in units of 100Mb/s" access="RO" offset="0x9C.16" size="0x0.8" />
	<field name="nbr250" descr="Nominal bit rate in units of 250Mb/s" access="RO" offset="0x9C.24" size="0x0.8" />
	<field name="dp_st_lane" descr="DataPath state for lane&lt;i&gt;\;1: DPDeactivated\;2: DPInit\;3: DPDeinit\;4: DPActivated\;5: DPTxTurnOn\;6: DPTxTurnOff\;7: DPInitialized" access="RO" enum="DPDeactivated=0x1,DPInit=0x2,DPDeinit=0x3,DPActivated=0x4,DPTxTurnOn=0x5,DPTxTurnOff=0x6,DPInitialized=0x7" high_bound="7" low_bound="0" offset="0xA0.28" size="0x4.0" />
	<field name="length_om5" descr="OM5 fiber length supported in units of 2m" access="RO" offset="0xA4.0" size="0x0.8" />
	<field name="length_om4" descr="OM4 fiber length supported in units of 2m\;SFP in units of 10m" access="RO" offset="0xA4.8" size="0x0.8" />
	<field name="length_om3" descr="OM3 fiber length supported in units of 2m\;SFP in units of 10m" access="RO" offset="0xA4.16" size="0x0.8" />
	<field name="length_om2" descr="OM2 fiber length supported in units of 1m\;SFP in units of 10m" access="RO" offset="0xA4.24" size="0x0.8" />
	<field name="memory_map_rev" descr="memory map revision" access="RO" offset="0xA8.0" size="0x0.8" />
	<field name="wavelength_tolerance" descr="16-bit integer value for the laser wavelength tolerance in nm divided by 200 (units of 0.005nm)." access="RO" offset="0xA8.8" size="0x0.16" />
	<field name="length_om1" descr="OM1 fiber length supported in units of 10m" access="RO" offset="0xA8.24" size="0x0.8" />
	<field name="memory_map_compliance" descr="memory map compliance in ASCII.\;SFF-8472 / SFF-8636/ CMIS" access="RO" offset="0xAC.0" size="0x4.0" />
	<field name="date_code" descr="ASCII code for vendor&apos;s date code.\;63:48- 2 digit for date code year, 00 = year 2000\;47:32 - 2 digit for date code month.\;31:16 - 2 digit for day of the month code.\;15:0 - 2 digit LOT code." subnode="uint64" access="RO" offset="0xB0.0" size="0x8.0" />
	<field name="vendor_oui" descr="vendor oui" access="RO" offset="0xB8.0" size="0x0.24" />
	<field name="connector_type" descr="connector type based on SFF-8024" access="RO" offset="0xB8.24" size="0x0.8" />
	<field name="rx_output_valid" descr="Rx output status indication per lane" access="RO" offset="0xBC.0" size="0x0.8" />
	<field name="cable_attenuation_53g" descr="cable attenuation at 53GHz" access="RO" offset="0xBC.8" size="0x0.8" />
	<field name="tx_input_freq_sync" descr="Defines which Tx input lanes must be frequency synchronous.\;0: Tx_input_lanes_1_8\;1: Tx_input_lanes_1_4_and_5-8\;2: Tx_input_lanes_1_2_and_3_4_and_5_6_and_7_8\;3: Lanes_may_be_asynchronous_in_frequency" access="RO" enum="Tx_input_lanes_1_8=0x0,Tx_input_lanes_1_4_and_5=0x1,Tx_input_lanes_1_2_and_3_4_and_5_6_and_7_8=0x2,Lanes_may_be_asynchronous_in_frequency=0x3" offset="0xBC.16" size="0x0.2" />
	<field name="error_code" descr="Relevant for CMIS modules only\;Error Code response for ConrolSet configuration of DataPath.\;0x0: ConfigUndefined\;0x1: ConfigSuccess\;0x2: ConfigRejected\;0x3: ConfigRejectedInvalidAppSel\;0x4: ConfigRejectedInvalidDataPath\;0x5: ConfigRejectedInvalidSI\;0x6: ConfigRejectedLanesInUse\;0x7: ConfigRejectedPartialDataPath\;0xC: ConfigInProgress" access="RO" enum="ConfigUndefined=0x0,ConfigSuccess=0x1,ConfigRejected=0x2,ConfigRejectedInvalidAppSel=0x3,ConfigRejectedInvalidDataPath=0x4,ConfigRejectedInvalidSI=0x5,ConfigRejectedLanesInUse=0x6,ConfigRejectedPartialDataPath=0x7,ConfigInProgress=0xc" offset="0xC0.0" size="0x0.4" />
	<field name="max_fiber_length" descr="Maximum length of allowed fiber in meters" access="RO" offset="0xC0.16" size="0x0.16" />
</node>

<node name="pddr_monitor_opcode_ext" descr="" size="0x4.0" >
	<field name="monitor_opcode" descr="Status opcode: \;\;PHY FW indication (0 - 1023):\;0 - No issue observed\;1 - Port is close by command (see PAOS).\;2,3,4,38,39 - AN failure \;5,6,7,8 - Link training failure. \;9,10,11,12,13 - Logical mismatch between link partners\;14 - Remote fault received\;15,42,17,48,49,52, - Bad signal integrity \;16,24-32 - Cable compliance code mismatch (protocol mismatch between cable and port) \;23,22,19,18,50,55- Internal error\;34,35 - Speed degradation\;56 - module_lanes_frequency_not_synced\;57 - signal not detected\;60 - no partner detected for long time\;128 - Troubleshooting in process\;1023- Info not available\;\;MNG FW issues (1024 - 2047):\;1024 - Cable is unplugged\;1025 - Long Range for non Mellanox cable/module .\;1026 - Bus stuck (I2C Data or clock shorted) \;1027 - Bad/unsupported EEPROM \;1028 - Part number list\;1029 - Unsupported cable.\;1030 - Module temperature shutdown\;1031 - Shorted cable\;1032 - Power budget exceeded\;1033 - Management forced down the port\;1034 - Module is disabled by command\;1035 - System Power is Exceeded therefore the module is powered off.\;1036 - Module&apos;s PMD type is not enabled (see PMTPS).\;1040 - pcie system power slot Exceeded\;1042 - Module state machine fault\;1043,1044,1045,1046 - Module&apos;s stamping speed degeneration\;1047, 1048 - Modules DataPath FSM fault\;1050, 1051, 1052, 1053- Module Boot Error\;1054 - Module Forced to Low Power by command\;Core/Driver (2048 - 3071):" access="RW" offset="0x0.0" size="0x0.16" />
</node>

<node name="pddr_operation_info_page_cable_proto_cap_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_cable_cap_ib_ext" descr="" subnode="pddr_cable_cap_ib_ext" offset="0x0.0" size="0x4.0" />
	<field name="pddr_cable_cap_eth_ext" descr="" subnode="pddr_cable_cap_eth_ext" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_core_to_phy_link_enabled_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_c2p_link_enabed_ib_ext" descr="" subnode="pddr_c2p_link_enabed_ib_ext" offset="0x0.0" size="0x4.0" />
	<field name="pddr_c2p_link_enabed_eth_ext" descr="" subnode="pddr_c2p_link_enabed_eth_ext" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_ext" descr="" size="0xf8.0" >
	<field name="neg_mode_active" descr="0: protocol_was_not_negotiated - (force mode)\;1: MLPN_rev0_negotiated\;2: CL73_Ethernet_negotiated\;3: Protocol_according_to_Parallel_detect - (remote port in force mode)\;4: Standard_IB_negotiated\;8: NLPN_rev2_negotiated\;9: HS_NLPN_rev2_negotiated_" access="RO" enum="protocol_was_not_negotiated=0x0,MLPN_rev0_negotiated=0x1,CL73_Ethernet_negotiated=0x2,Protocol_according_to_Parallel_detect=0x3,Standard_IB_negotiated=0x4,NLPN_rev2_negotiated=0x8,HS_NLPN_rev2_negotiated_=0x9" offset="0x0.16" size="0x0.4" />
	<field name="proto_active" descr="Active protocol:\;Bit 0: InfiniBand\;Bit 2: Ethernet\;Bit 3: NVLink" access="RO" enum="InfiniBand=0x1,Ethernet=0x4,NVLink=0x8" offset="0x0.20" size="0x0.4" />
	<field name="ib_phy_fsm_state" descr="FW IB state machine:\;0x0: IB_AN_FSM_DISABLED\;0x1: IB_AN_FSM_INITIALY\;0x2: IB_AN_FSM_RCVR_CFG\;0x3: IB_AN_FSM_CFG_TEST\;0x4: IB_AN_FSM_WAIT_RMT_TEST\;0x5: IB_AN_FSM_WAIT_CFG_ENHANCED\;0x6: IB_AN_FSM_CFG_IDLE\;0x7: IB_AN_FSM_LINK_UP\;0x8: IB_AN_FSM_POLLING" access="RO" enum="IB_AN_FSM_DISABLED=0x0,IB_AN_FSM_INITIALY=0x1,IB_AN_FSM_RCVR_CFG=0x2,IB_AN_FSM_CFG_TEST=0x3,IB_AN_FSM_WAIT_RMT_TEST=0x4,IB_AN_FSM_WAIT_CFG_ENHANCED=0x5,IB_AN_FSM_CFG_IDLE=0x6,IB_AN_FSM_LINK_UP=0x7,IB_AN_FSM_POLLING=0x8" offset="0x4.8" size="0x0.8" />
	<field name="eth_an_fsm_state" descr="Ethernet (CL73) Auto-negotiation FSM state:\;0x0: ETH_AN_FSM_ENABLE\;0x1: ETH_AN_FSM_XMIT_DISABLE\;0x2: ETH_AN_FSM_ABILITY_DETECT\;0x3: ETH_AN_FSM_ACK_DETECT\;0x4: ETH_AN_FSM_COMPLETE_ACK\;0x5: ETH_AN_FSM_AN_GOOD_CHECK\;0x6: ETH_AN_FSM_AN_GOOD\;0x7: ETH_AN_FSM_NEXT_PAGE_WAIT" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="phy_mngr_fsm_state" descr="FW Phy Manager FSM state:\;0: Disabled \;1: Open_port\;2: Polling\;3: Active\;4: Close_port\;5: Phy_up\;6: Sleep\;7: Rx_disable\;8: Signal_detect\;9: Receiver_detect\;10: Sync_peer\;11: Negotiation\;12: Training\;13: SubFSM_active" access="RO" enum="Disabled=0x0,Open_port=0x1,Polling=0x2,Active=0x3,Close_port=0x4,Phy_up=0x5,Sleep=0x6,Rx_disable=0x7,Signal_detect=0x8,Receiver_detect=0x9,Sync_peer=0xa,Negotiation=0xb,Training=0xc,SubFSM_active=0xd" offset="0x4.24" size="0x0.8" />
	<field name="phy_manager_link_enabled" descr="For IB: Table 1715, &quot;PDDR - Phy manager link enabled IB layout,&quot; on page 2043\;For Ethernet: Table 1717, &quot;PDDR - Phy manager link enabled Eth layout,&quot; on page 2043\;" subnode="pddr_operation_info_page_phy_manager_link_enabled_auto_ext" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="core_to_phy_link_enabled" descr="For IB: Table 1719, &quot;PDDR - core2phy link enabled IB layout,&quot; on page 2044\;For Ethernet: Table 1721, &quot;PDDR - Core2Phy link enabled Eth layout,&quot; on page 2045" subnode="pddr_operation_info_page_core_to_phy_link_enabled_auto_ext" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="cable_proto_cap" descr="For IB: Table 1723, &quot;PDDR - cable cap IB layout,&quot; on page 2046\;For Ethernet: Table 1725, &quot;PDDR - cable cap Eth layout,&quot; on page 2047\;" subnode="pddr_operation_info_page_cable_proto_cap_auto_ext" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="link_active" descr="For IB: Table 1727, &quot;PDDR - Link Active IB layout,&quot; on page 2048\;For Ethernet: Table 1729, &quot;PDDR - Link Active Eth layout,&quot; on page 2048" subnode="pddr_operation_info_page_link_active_auto_ext" access="RO" offset="0x14.0" size="0x4.0" union_selector="$(parent).proto_active" />
	<field name="loopback_mode" descr="0: No_loopback_active\;1: Phy_remote_loopback \;2: Phy_local_loopback -When set the port&apos;s egress traffic is looped back to the receiver and the port transmitter is disabled. \;4: External_local_loopback -Enables the port&apos;s transmitter to link with the port&apos;s receiver using an external loopback connector." access="RO" enum="No_loopback_active=0x0,Phy_remote_loopback=0x1,Phy_local_loopback=0x2,External_local_loopback=0x4" offset="0x18.0" size="0x0.12" />
	<field name="fec_mode_request" descr="FEC mode request\;See fec_mode_active\;for supported retransmission mode see PPLM.fec_mode_capability" access="RO" offset="0x1C.0" size="0x0.16" />
	<field name="fec_mode_active" descr="FEC mode active\;0: No_FEC\;1: Firecode_FEC\;2: Standard_RS_FEC - RS(528,514)\;3: Standard_LL_RS_FEC - RS(271,257)\;6: Interleaved_Standard_RS-FEC - (544,514)\;7: Standard_RS-FEC - (544,514)\;9: Ethernet_Consortium_LL_50G_RS_FEC- (272,257+1)\;10: Interleaved_Ethernet_Consortium_LL_50G_RS_FEC - (272,257+1)" access="RO" enum="No_FEC=0x0,Firecode_FEC=0x1,Standard_RS_FEC=0x2,Standard_LL_RS_FEC=0x3,Interleaved_Standard_RS=0x6,Standard_RS=0x7,Ethernet_Consortium_LL_50G_RS_FEC=0x9,Interleaved_Ethernet_Consortium_LL_50G_RS_FEC=0xa" offset="0x1C.16" size="0x0.16" />
	<field name="eth_100g_fec_support" descr="FEC 100G (25Gb/s per lane) supported FEC include override masking , should reflect current phy configuration after link is up\;\;Bit 0 - No FEC\;Bit 2 - Standard RS-FEC - RS(528,514)\;" access="RO" offset="0x20.0" size="0x0.4" />
	<field name="eth_25g_50g_fec_support" descr="FEC 25G/50G (25Gb/s per lane) supported FEC include override masking , should reflect current phy configuration after link is up\;Bit 0 - No FEC\;Bit 1 - Firecode FEC\;Bit 2 - Standard RS-FEC - RS(528,514)\;" access="RO" offset="0x20.4" size="0x0.4" />
	<field name="eth_an_link_enabled" descr="For IB: Table 1739, &quot;PDDR - ETH AN Link Enabled Eth Layout,&quot; on page 2051" access="RO" offset="0x2C.0" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_link_active_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_link_active_ib_ext" descr="" subnode="pddr_link_active_ib_ext" offset="0x0.0" selected_by="InfiniBand" size="0x4.0" />
	<field name="pddr_link_active_eth_ext" descr="" subnode="pddr_link_active_eth_ext" offset="0x0.0" selected_by="Ethernet" size="0x4.0" />
</node>

<node name="pddr_operation_info_page_phy_manager_link_enabled_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_phy_manager_link_enabed_ib_ext" descr="" subnode="pddr_phy_manager_link_enabed_ib_ext" offset="0x0.0" size="0x4.0" />
	<field name="pddr_phy_manager_link_enabed_eth_ext" descr="" subnode="pddr_phy_manager_link_enabed_eth_ext" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_phy_info_page_ext" descr="" size="0xf8.0" >
	<field name="port_notifications" descr="Port notifications bit mask\;Bit 0 - Link partner advertised capabilities \;Bit 1 - Speed degradation" access="RO" offset="0x0.0" size="0x0.8" />
	<field name="negotiation_mask" descr="Bit 0: eth_base_page\;Bit 1: ib_base_page\;Bit 2: ib_base_page_rev2 - XDR onwards\;Bit 3: Consurtium\;Bit 4: MLPN_rev0\;Bit 5: MLPN_rev1\;Bit 6: NLPN_rev2" access="RO" offset="0x0.8" size="0x0.8" />
	<field name="remote_device_type" descr="Remote device type: \;0 - Unknown (3rd party , Force , legacy MLPN)  \;1 - CX4\;2 - CX4_LX\;3 - CX5\;4 - CX5_LX\;5 - CX6\;6 - CX6_LX\;7 - CX6_DX\;8 - CX7\;9 - Bluefield-2\;10 - CX8\;11 - Bluefield-3\;12-99 Reserved\;\;100 - SwitchIB\;101 - Spectrum \;102 - SwitchIB-2\;103 - Quantum\;104 - Spectrum-2\;105 - Spectrum-3\;106 - Quantum-2\;107 - Spectrum-4\;108 -Quantum-3\;109-199 -Reserved\;\;200 - GBxxx (GB100/102/200)\;201-255 - reserved" access="RO" offset="0x0.24" size="0x0.8" />
	<field name="lp_ib_revision" descr="Link partner IB TS revision \;\;" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="ib_revision" descr="IB TS revision \;" access="RO" offset="0x4.8" size="0x0.8" />
	<field name="num_of_negotiation_attempts" descr="Negotiation attempt counter" access="RO" offset="0x4.16" size="0x0.16" />
	<field name="phy_manager_disable_mask" descr="Phy manager disable bit mask: \;Bit 0 - Module not present (module absence/cage power off)\;Bit 1 - PAOS command\;Bit 2 - MAD IB PortInfo down command\;Bit 3 - Long range cable (Non Mellanox) \;Bit 4 - Verification command\;Bit 5 - ekey command\;Bit 6 - High power - cable require higher power than allowed.\;Bit 7 - Unknown Identifier (Module)\;Bit 8 - PAOS up once \;Bit 9 - Stamping failure\;Bit 10 - Calibration not done\;Bit 11 - Module Locking\;Bit 13 - Power budget exceeded\;Bit 14 - Interrupt Event / Module Temp\;Bit 15 - TEC flow / module bring up issue" access="RO" offset="0x8.0" size="0x0.24" />
	<field name="hw_link_phy_state" descr="IBP HW FSM Reflected State:\;0x10: sleeping_delay\;0x11: sleeping_quiet\;0x20: polling_active\;0x21: polling_quiet\;0x30: disable\;0x40: config_debounce\;0x41: config_receiver\;0x42: config_wait_remote\;0x43: config_tx_reverse_lanes\;0x44: config_enhanced    \;0x45: config_test\;0x46: confg_wait_remote_test\;0x47: config_wait_cfg_enhanced\;0x48: config_idle\;0x50: linkup\;0x51: Linkup_Tx_Idle\;0x52: Linkup_Tx_Empty\;0x60: recover_retrain\;0x61: recover_wait_remote\;0x62: recover_idle\;0x70: test\;- Force Modes\;0x80: Force_send_ts1 - command may be given only on disable state\;0x90: Force_send_ts2\;0xA0: Force_Sent_Idle\;0xB0: Force_send_ts_Mlnx\;0xC0: Force_send_ts3\;0xD0: Force_LinkUp\;- L1\;0xE0: Go_To_Quiet\;0xE1: Retimer_Align\;0xE2: Quiet_Entry\;0xE3: Quiet\;0xE4: Wake\;0xE5: Wake_Tx_Sleep0\;0xE6: Send_Announce\;0xE7: Tx_HS\;0xE8: Wait_For_Cdr_Lock" access="RO" enum="sleeping_delay=0x10,sleeping_quiet=0x11,polling_active=0x20,polling_quiet=0x21,disable=0x30,config_debounce=0x40,config_receiver=0x41,config_wait_remote=0x42,config_tx_reverse_lanes=0x43,config_enhanced=0x44,config_test=0x45,confg_wait_remote_test=0x46,config_wait_cfg_enhanced=0x47,config_idle=0x48,linkup=0x50,Linkup_Tx_Idle=0x51,Linkup_Tx_Empty=0x52,recover_retrain=0x60,recover_wait_remote=0x61,recover_idle=0x62,test=0x70,Force_send_ts1=0x80,Force_send_ts2=0x90,Force_Sent_Idle=0xa0,Force_send_ts_Mlnx=0xb0,Force_send_ts3=0xc0,Force_LinkUp=0xd0,Go_To_Quiet=0xe0,Retimer_Align=0xe1,Quiet_Entry=0xe2,Quiet=0xe3,Wake=0xe4,Wake_Tx_Sleep0=0xe5,Send_Announce=0xe6,Tx_HS=0xe7,Wait_For_Cdr_Lock=0xe8" offset="0x8.24" size="0x0.8" />
	<field name="pcs_phy_state" descr="PCS HW state:\;Bits 0-7: Block lock\;Bits 8-15: AM lock\;Bits 16-23: FEC lock\;Bits 24: Align_status\;Bits 25: Hi_BER\;Bits 26: Hi_SER" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="lp_proto_enabled" descr="IB ports : \;Link partner advertised speeds (first TS3)\;See ib_link_speed_enabled encoding.\;\;Ethernet ports:\;Link partner advertised Ethernet protocols active state: see PTYS.lp_advertise" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="lp_fec_mode_request" descr="Reserved when negotiation wasn&apos;t performed according to port_notifications.Link partner advertised capabilities value.\;Advertised link partner FEC mode request" access="RO" offset="0x14.0" size="0x0.16" />
	<field name="lp_fec_mode_support" descr="Reserved when negotiation wasn&apos;t performed according to port_notifications.Link partner advertised capabilities value.\;\;Advertised link partner FEC mode support\;Bit 0 - No FEC\;Bit 1 - Firecode FEC\;Bit 2 - Standard RS-FEC - RS(528,514)\;Bit 3 - Standard LL RS-FEC - RS(271,257)\;Bit 4 - Mellanox Strong RS-FEC - RS(277,257)\;Bit 5 - Mellanox LL RS-FEC - RS(163,155)\;Bit 6 - Reserved\;Bit 7 - Standard RS-FEC (544,514)\;Bit 8 - Zero Latency FEC\;Bit 12 - RS-FEC (544,514) + PLR\;Bit 13 - LL-FEC (271,257) + PLR\;\;" access="RO" offset="0x14.16" size="0x0.16" />
	<field name="ib_last_link_down_reason" descr="Bit 0 - heartbeat_ack_received\;Bit 1 - heartbeat_send_received\;Bit 2 - heartbeat_err\;Bit 3 - tx_width_reduction_done_1x\;Bit 4 - tx_width_reduction_done_full\;Bit 5 - rx_width_reduction_done_1x\;Bit 6 - rx_width_reduction_done_full\;Bit 7 - width_reduction_timeout\;Bit 8 - ibl_link_retrain\;Bit 9 - rx_comskp_timeout\;Bit 10 - fifo_full_err\;Bit 11 - ts_at_linkup\;Bit 12 - minor_threshold_reached\;Bit 13 - link_fail\;Bit 14 - rx_eb_full_r\;Bit 15 - rx_8_10_lane_err\;Bit 16 - llr_link_retrain_set\;Bit 17 - fc_timeout\;Bit 18 - phy_error\;Bit 19 - lli_err\;Bit 20 - excessive_buffer_err\;Bit 21 - remote_init\;Bit 22 - plr_retry_expired\;Bit 23 - port_didnt_exit_plr_sync\;Bit 24 - eq_failed\;Bits 31-24 - Reserved" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="eth_last_link_down_lane" descr="Bit 0 - block_lock_failed\;Bit 1 - skip_detected\;Bit 2 - fec_sync_failed\;Bit 3 - fec_block_sync\;Bit 4 - fec_block_sync_lost" access="RO" high_bound="3" low_bound="0" offset="0x1C.24" size="0x4.0" />
	<field name="speed_deg_db" descr="Bit 0 - Speed degradation database Valid\;Bit 1 - Speed degradation Serdes Rx database valid\;BIts 3-2 - reserved\;Bit 4 - rx_reversal\;Bit 5 - tx_reversal\;Bit 7-6 - reserved\;Bits 11:8 - failed_qdr/fdr10 - bit per lane.\;Bits 15:12 - failed_fdr - bit per lane.\;Bits 19:16- failed_edr - bit per lane.\;Bits 24:20 - peer_failed_test\;Bits 26-25 - reserved\;Bit 27 - first_test_speed" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="degrade_grade_lane0" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x28.0" size="0x0.24" />
	<field name="degrade_grade_lane1" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x2C.0" size="0x0.24" />
	<field name="degrade_grade_lane2" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x30.0" size="0x0.24" />
	<field name="degrade_grade_lane3" descr="Valid only when port_notifications.Speed degradation is asserted \;" access="RO" offset="0x34.0" size="0x0.24" />
	<field name="num_of_presets_tested_lane7" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.0" size="0x0.5" />
	<field name="num_of_presets_tested_lane6" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.8" size="0x0.5" />
	<field name="num_of_presets_tested_lane5" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.16" size="0x0.5" />
	<field name="num_of_presets_tested_lane4" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x38.24" size="0x0.5" />
	<field name="kr_startup_debug_indications_5" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x3C.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_4" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x3C.16" size="0x0.16" />
	<field name="kr_startup_debug_indications_7" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x40.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_6" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x40.16" size="0x0.16" />
	<field name="num_of_presets_tested_lane3" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.0" size="0x0.5" />
	<field name="num_of_presets_tested_lane2" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.8" size="0x0.5" />
	<field name="num_of_presets_tested_lane1" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.16" size="0x0.5" />
	<field name="num_of_presets_tested_lane0" descr="presets tested in TX tuning flow counter or in KR Startup" access="RO" offset="0x44.24" size="0x0.5" />
	<field name="kr_startup_fsm_lane" descr="Per lane KR startup state:\;0: KR_FSM_INITIALIZE\;1: KR_FSM_SEND_TRAINING\;2: KR_FSM_TRAIN_LOCAL_TX\;3: KR_FSM_TRAIN_LOCAL_RX\;4: KR_FSM_TRAIN_REMOTE\;5: KR_FSM_LINK_READY\;6: KR_FSM_SEND_DATA\;7: KR_FSM_NVLT\;8: KR_ABORT\;9: KR_TIMEOUT\;10: KR_FSM_IN_IDLE" access="RO" enum="KR_FSM_INITIALIZE=0x0,KR_FSM_SEND_TRAINING=0x1,KR_FSM_TRAIN_LOCAL_TX=0x2,KR_FSM_TRAIN_LOCAL_RX=0x3,KR_FSM_TRAIN_REMOTE=0x4,KR_FSM_LINK_READY=0x5,KR_FSM_SEND_DATA=0x6,KR_FSM_NVLT=0x7,KR_ABORT=0x8,KR_TIMEOUT=0x9,KR_FSM_IN_IDLE=0xa" high_bound="7" low_bound="0" offset="0x48.24" size="0x8.0" />
	<field name="eth_an_debug_indication" descr="eth_an_debug bit mask:\;Bit 0 - Force link up\;Bit 1 - No HCD\;Bit 2 - Entered ACK_detect\;Bit 3 - Entered Good\;Bit 4 - Entered Good_Check\;Bit 5 - Entered Extra_tune\;Bit 6 - Entered Fix_Reversals\;Bit 7 - Entered Next_Page\;Bit 8 - Entered Sub-FSM Fail\;Bit 9 - Tuning timeout\;Bit 10 - No markers detected (during Good check)\;Bit 11 - Do KR-startup\;Bits 15:18 - KR startup failure mask" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="ib_phy_fsm_state_trace" descr="FW IB state machine:\;HDR Gen\;Bit 0 - entered IB_AN_FSM_DISABLED\;Bit 1 - entered IB_AN_FSM_INITIALY\;Bit 2 - entered IB_AN_FSM_RCVR_CFG\;Bit 3 - entered IB_AN_FSM_CFG_TEST\;Bit 4 - entered IB_AN_FSM_WAIT_RMT_TEST\;Bit 5 - entered IB_AN_FSM_WAIT_CFG_ENHANCED\;Bit 6 - entered IB_AN_FSM_CFG_IDLE\;Bit 7 - entered IB_AN_FSM_LINK_UP\;Bit 8 - Failed from CFG_IDLE\;\;NDR Gen:\;Bit 0 - entered IB_AN_FSM_DISABLED\;Bit 1 - entered IB_AN_FSM_POLLING\;Bit 2 - entered IB_AN_FSM_INITIALY\;Bit 3 - entered IB_AN_FSM_CFG_TEST\;Bit 4 - entered IB_AN_FSM_WAIT_RMT_TEST\;Bit 5 - entered IB_AN_FSM_WAIT_CFG_ENHANCED\;Bit 6 - entered IB_AN_FSM_CFG_IDLE\;Bit 7 - entered IB_AN_FSM_SYNC_CHECK\;Bit 8 - entered IB_AN_FSM_LINK_UP\;Bit 9 - Failed from CFG_IDLE\;Bit 10 - peer requested KR\;Bit 11 - speed degradation needed - &quot;best_grade&quot; didn&quot;t reach threshold\;\;" access="RO" offset="0x54.0" size="0x0.16" />
	<field name="rounds_waited_for_peer_to_end_test" descr="" access="RO" offset="0x54.16" size="0x0.5" />
	<field name="eth_an_watchdog_cnt" descr="counts ETH Watchdog was performed (and closed the IB fsm)." access="RO" offset="0x54.21" size="0x0.2" />
	<field name="fall_from_cfg_idle_cdr_cnt" descr="count falls from Cfg_idle (before linkup) due cdr not lock" access="RO" offset="0x54.23" size="0x0.3" />
	<field name="fall_from_cfg_idle_cnt" descr="count falls from Cfg_idle (before linkup) due amps lock on PLU" access="RO" offset="0x54.26" size="0x0.3" />
	<field name="cdr_not_locked_cnt" descr="count the cdr not locked after EQ" access="RO" offset="0x54.29" size="0x0.3" />
	<field name="kr_startup_debug_indications_1" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x58.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_0" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x58.16" size="0x0.16" />
	<field name="kr_startup_debug_indications_3" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x5C.0" size="0x0.16" />
	<field name="kr_startup_debug_indications_2" descr="kr_stratup_debug_indication_&lt;i&gt; bit mask:\;Bit 0 - Local_frame_lock\;Bit 1 - Remote_frame_lock\;Bit 2 - Local_Frame_lock_timer_expired\;Bit 3 - Remote_Frame_lock_timer_expired \;Bit 4 - Local_receiver_ready\;Bit 5 - Remote_receiver_ready\;Bit 6 - max_wait_timer_expired \;Bit 7 - Wait_timer_done\;Bit 8 - Hold_off_timer_expired\;Bit 9 - link_fail_inhibit_timer _expired" access="RO" offset="0x5C.16" size="0x0.16" />
	<field name="tx_tuning_stages_lane" descr="Stages mask per lane:\;Bit 0 - Single preset stage\;Bit 1 - multiple preset stage\;Bit 2 - LMS" access="RO" high_bound="7" low_bound="0" offset="0x60.28" size="0x4.0" />
	<field name="plu_tx_pwrup" descr="PLU power up status per lane" access="RO" offset="0x64.0" size="0x0.8" />
	<field name="plu_rx_pwrup" descr="PLU power up status per lane" access="RO" offset="0x64.8" size="0x0.8" />
	<field name="plu_tx_polarity" descr="Configured PLU polarity per lane" access="RO" offset="0x64.16" size="0x0.8" />
	<field name="plu_rx_polarity" descr="Configured PLU polarity per lane" access="RO" offset="0x64.24" size="0x0.8" />
	<field name="irisc_status" descr="" access="RO" offset="0x68.0" size="0x0.4" />
	<field name="ib_cfg_delay_timeout" descr="0 - Default as defined in IB Spec.\;1 - Override default with 64msec timeout for all speeds.\;2 - Reserved\;3 - Reserved" access="RO" offset="0x68.4" size="0x0.2" />
	<field name="sd_valid" descr="when set, signal_detected has valid value." access="RO" offset="0x68.6" size="0x0.1" />
	<field name="plu_tx_speed" descr="PLU configured speed:\;" access="RO" offset="0x68.8" size="0x0.4" />
	<field name="plu_rx_speed" descr="PLU configured speed:\;" access="RO" offset="0x68.12" size="0x0.4" />
	<field name="plr_outstanding_cells" descr="" access="RO" offset="0x68.16" size="0x0.8" />
	<field name="signal_detected" descr="valid only when sd_valid is set\;Bitmask per lane.\;When set signal has been detected on the lane" access="RO" offset="0x68.24" size="0x0.8" />
	<field name="stamping_reason" descr="Bit 0 - com_codes_is_zero \;Bit 1- rx_cdr_check_force_mode \;Bit 2- com_code_complaince \;Bit 3- eth_56g_stamped\;Bit 4- non_mlx_qsfp_tranciver\;Bit 5- non_mlx_sfp_tranciver\;Bit 6-ib_comp_codes\;Bit 7-edr_comp\;Bit 8-fdr_comp" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="kr_frame_lock_tuning_failure_events_count" descr="Number of times that fast tuning (50ms) for KR lock failed to achieve frame lock." access="RO" offset="0x70.0" size="0x4.0" />
	<field name="kr_full_tuning_failure_count" descr="Number of times that full tuning (0.5sec/3sec) for KR full tuning flow failed to achieve desire SI performance" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="pm_debug_indication" descr="Bit 0: phy_test_mode\;Bit 1: force_mode_en" access="RO" enum="phy_test_mode=0x1,force_mode_en=0x2" offset="0x78.0" size="0x0.16" />
	<field name="ib_debug_indication" descr="Bit 0: cause_plr_tx_max_outstanding_cells" access="RO" enum="cause_plr_tx_max_outstanding_cells=0x1" offset="0x78.16" size="0x0.16" />
	<field name="pm_catastrophic_enum" descr="Phy Manager catastrophic enum" access="RO" offset="0x7C.0" size="0x0.7" />
	<field name="pm_cat_val" descr="When set, indicates the pm_catastrophic_enum is valid" access="RO" offset="0x7C.7" size="0x0.1" />
	<field name="an_catastrophic_enum" descr="Auto-neg catastrophic enum" access="RO" offset="0x7C.8" size="0x0.7" />
	<field name="an_cat_val" descr="When set, indicates the an_catastrophic_enum is valid" access="RO" offset="0x7C.15" size="0x0.1" />
	<field name="hst_catastrophic_enum" descr="HST catastrophic enum" access="RO" offset="0x7C.16" size="0x0.7" />
	<field name="hst_cat_val" descr="When set, indicates the hst_catastrophic_enum is valid" access="RO" offset="0x7C.23" size="0x0.1" />
	<field name="pd_catastrophic_enum" descr="Parallel Detect catastrophic enum" access="RO" offset="0x7C.24" size="0x0.7" />
	<field name="pd_cat_val" descr="When set, indicates the pd_catastrophic_enum is valid" access="RO" offset="0x7C.31" size="0x0.1" />
	<field name="pd_debug_indication" descr="Bit 0: speed_change_high_speed_module\;Bit 1: False_positive_signal_detect\;Bit 2: Nv2nv_force\;Bit 3: bad_kr_mask \;Bit 4: kr_mlx_peer\;Bit 5: entered_signal_detect\;Bit 6: entered_rate_config\;Bit 7: entered_activate_sunfsm\;Bit 8: entered_done\;Bit 9: entered_subfsm_fail" access="RO" enum="speed_change_high_speed_module=0x1,False_positive_signal_detect=0x2,Nv2nv_force=0x4,bad_kr_mask=0x8,kr_mlx_peer=0x10,entered_signal_detect=0x20,entered_rate_config=0x40,entered_activate_sunfsm=0x80,entered_done=0x100,entered_subfsm_fail=0x200" offset="0x80.0" size="0x4.0" />
	<field name="pd_count" descr="Parallel detect cycles counter" access="RO" offset="0x84.0" size="0x0.6" />
	<field name="fp_signal_detect_count" descr="False Positive signal detect count" access="RO" offset="0x84.8" size="0x0.6" />
	<field name="hst_mismatch_reason" descr="0: speed\;1: FEC\;2: precoding\;3: Gray coding" access="RO" offset="0x84.16" size="0x0.2" />
	<field name="psi_collision2" descr="FSM 2 to call sub fsm of PSI that caused collision\;see fsm_mask in debug page for FSM numbering" access="RO" offset="0x84.22" size="0x0.5" />
	<field name="psi_collision1" descr="FSM 1 to call sub fsm of PSI that caused collision\;see fsm_mask in debug page for FSM numbering" access="RO" offset="0x84.27" size="0x0.5" />
	<field name="nlpn_debug_ind_mask" descr="Bit 0: nonce_match_fail\;Bit 1: timeout - rst cause idle in npln\;Bit 2: hs_neg\;Bit 3: dme_neg" access="RO" enum="nonce_match_fail=0x1,timeout=0x2,hs_neg=0x4,dme_neg=0x8" offset="0x88.0" size="0x0.8" />
	<field name="phy2mod_speed_req" descr="phy 2 module requested speed, aka speed_apsel_value\;bitmask according to PTYS.ext_ethernet_protocl for ETH speeds\;or ib_ext_protocols for IB speeds" access="RO" offset="0x8C.0" size="0x4.0" />
	<field name="phy2mod_deactivate_lanes" descr="Bitmask per lane for phy2mod deactivate request status.\;0 - allow DP activation\;1 - Deactivate module DP" access="RO" offset="0x90.0" size="0x0.8" />
	<field name="phy2mod_ack_lanes" descr="Bitmask per lane for phy2mod request status.\;0 - ack\;1 - nack" access="RO" offset="0x90.8" size="0x0.8" />
	<field name="one_pll_mod" descr="indicates module has one pll for all lanes of the module." access="RO" offset="0x90.29" size="0x0.1" />
	<field name="no_dme_mod" descr="no_dme_module indicates module doesn&apos;t support low speed signaling such as 312.5 MB/s for DME ETH AN signaling or SDR (2.5 GB/s) for IB low speed AN." access="RO" offset="0x90.30" size="0x0.1" />
	<field name="eeprom_prsnt" descr="eeprom present indication" access="RO" offset="0x90.31" size="0x0.1" />
	<field name="rx_bypass_mux_plt0" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.0" size="0x0.2" />
	<field name="rx_bypass_mux_plt1" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.2" size="0x0.2" />
	<field name="tx_bypass_mux_plt0" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.4" size="0x0.2" />
	<field name="tx_bypass_mux_plt1" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.6" size="0x0.2" />
	<field name="reconciliation_mux_plt0" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.8" size="0x0.2" />
	<field name="reconciliation_mux_plt1" descr="1 bit per each split; 1-enabled; 0-Bypass (No MacSec)" access="RO" offset="0x94.10" size="0x0.2" />
	<field name="macsec_en_plt0_s0" descr="MacSec enabled plt0 split 0" access="RO" offset="0x94.12" size="0x0.1" />
	<field name="macsec_en_plt0_s1" descr="MacSec enabled plt0 split 1" access="RO" offset="0x94.13" size="0x0.1" />
	<field name="macsec_en_plt1_s0" descr="MacSec enabled plt1 split 0" access="RO" offset="0x94.14" size="0x0.1" />
	<field name="macsec_en_plt1_s1" descr="MacSec enabled plt1 split 1" access="RO" offset="0x94.15" size="0x0.1" />
	<field name="cnt_rx_frame_received_ok_s0" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.16" size="0x0.4" />
	<field name="cnt_rx_frame_received_ok_s1" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.20" size="0x0.4" />
	<field name="port_xmit_pkts_inc_s0" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.24" size="0x0.4" />
	<field name="port_xmit_pkts_inc_s1" descr="MacSec Engine Wrapper, debug counter" access="RO" offset="0x94.28" size="0x0.4" />
	<field name="plr_rtt_ndr_threshold" descr="rtt threshold in 1 ns units for NDR speeds\;" access="RO" offset="0x98.0" size="0x0.16" />
	<field name="plr_rtt_hdr_threshold" descr="rtt threshold in 1 ns units for HDR speeds" access="RO" offset="0x98.16" size="0x0.16" />
	<field name="plr_rtt_xdr_threshold" descr="rtt threshold in 1 ns units for XDR speeds\;" access="RO" offset="0x9C.16" size="0x0.16" />
</node>

<node name="pddr_phy_manager_link_enabed_eth_ext" descr="" size="0x4.0" >
	<field name="phy_manager_link_eth_enabled" descr="Ethernet protocols admin state: see PTYS.ext_eth_proto_admin" access="RO" offset="0x0.0" size="0x4.0" />
</node>

<node name="pddr_phy_manager_link_enabed_ib_ext" descr="" size="0x4.0" >
	<field name="phy_manager_link_proto_enabled" descr="ib link enabled speed:\;Bit 0 - SDR\;Bit 1 - DDR\;Bit 2 - QDR\;Bit 3 - FDR10\;Bit 4 - FDR\;Bit 5 - EDR\;Bit 6 - HDR\;Bit 7 - NDR\;Bit 8 - XDR" access="RO" offset="0x0.0" size="0x0.16" />
	<field name="phy_manager_link_width_enabled" descr="ib link enabled width:\;Bit 0 - 1x\;Bit 1 - 2x\;Bit 2 - 4x\;Other - reserved" access="RO" offset="0x0.16" size="0x0.16" />
</node>

<node name="pddr_reg_ext" descr="" size="0x100.0" >
	<field name="port_type" descr="Supported only when indicated by PCAM \;0: Network_port\;1: Near_End_Port - (For Retimer/Gearbox - Host side)\;2: Internal_IC_LR_Port \;3: Far_End_Port - (For Retimer/Gearbox - Line side)\;Other values are reserved." access="INDEX" enum="Network_port=0x0,Near_End_Port=0x1,Internal_IC_LR_Port=0x2,Far_End_Port=0x3" offset="0x0.4" size="0x0.4" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0: Local_port_number\;1: IB_port_number\;3: Out_of_band_or_PCI" access="INDEX" enum="Local_port_number=0x0,IB_port_number=0x1,Out_of_band_or_PCI=0x3" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="page_select" descr="page select index:\;0: Operational_info_page\;1: Troubleshooting_info_page\;2: Phy_info_page\;3: Module_info_page\;6: link_down_info\;9: Module_latched_flag_info_page" access="INDEX" enum="Operational_info_page=0x0,Troubleshooting_info_page=0x1,Phy_info_page=0x2,Module_info_page=0x3,link_down_info=0x6,Module_latched_flag_info_page=0x9" offset="0x4.0" size="0x0.8" />
	<field name="module_info_ext" descr="Module info extended configurations.\;resolution for rx_power, rx_power_high_th, rx_power_low_th tx_power, tx_power_high_th, tx_power_low_th in module info page\;0: dbm\;1: uW" access="OP" enum="dbm=0x0,uW=0x1" offset="0x4.29" size="0x0.2" />
	<field name="page_data" descr="Table 1713, &quot;Operation Info Page Layout,&quot; on page 2035\;Table 1749, &quot;Troubleshooting info Page layout,&quot; on page 2086\;Table 1741, &quot;Phy Info Page Layout,&quot; on page 2052\;Table 1747, &quot;Module Info Page Layout,&quot; on page 2073\;Table 1743, &quot;Link Down Info Page layout,&quot; on page 2067\;Table 1761, &quot;Module Latched Flag Info Page Layout,&quot; on page 2104\;" subnode="pddr_reg_page_data_auto_ext" access="RO" offset="0x8.0" size="0xf8.0" union_selector="$(parent).page_select" />
</node>

<node name="pddr_reg_page_data_auto_ext" descr="" attr_is_union="1" size="0xf8.0" >
	<field name="pddr_operation_info_page_ext" descr="" subnode="pddr_operation_info_page_ext" offset="0x0.0" selected_by="Operational_info_page" size="0xf8.0" />
	<field name="pddr_troubleshooting_page_ext" descr="" subnode="pddr_troubleshooting_page_ext" offset="0x0.0" selected_by="Troubleshooting_info_page" size="0xf8.0" />
	<field name="pddr_phy_info_page_ext" descr="" subnode="pddr_phy_info_page_ext" offset="0x0.0" selected_by="Phy_info_page" size="0xf8.0" />
	<field name="pddr_module_info_ext" descr="" subnode="pddr_module_info_ext" offset="0x0.0" selected_by="Module_info_page" size="0xd8.0" />
	<field name="pddr_link_down_info_page_ext" descr="" subnode="pddr_link_down_info_page_ext" offset="0x0.0" selected_by="link_down_info" size="0xf4.0" />
	<field name="module_latched_flag_info_ext" descr="" subnode="module_latched_flag_info_ext" offset="0x0.0" selected_by="Module_latched_flag_info_page" size="0xf8.0" />
</node>

<node name="pddr_troubleshooting_page_ext" descr="" size="0xf8.0" >
	<field name="group_opcode" descr="0: Monitor_opcodes" access="INDEX" enum="Monitor_opcodes=0x0" offset="0x0.0" size="0x0.16" />
	<field name="status_opcode" descr="Status opcode described in:\;Table 1751, &quot;PDDR - Monitor opcodes layout,&quot; on page 2087" subnode="pddr_troubleshooting_page_status_opcode_auto_ext" access="RO" offset="0x4.0" size="0x4.0" union_selector="$(parent).group_opcode" />
	<field name="status_message" descr="ASCII code message\;All Messages are terminated by a Null character &apos;\0&apos;" access="RO" high_bound="58" low_bound="0" offset="0xC.0" size="0xec.0" />
</node>

<node name="pddr_troubleshooting_page_status_opcode_auto_ext" descr="" attr_is_union="1" size="0x4.0" >
	<field name="pddr_monitor_opcode_ext" descr="" subnode="pddr_monitor_opcode_ext" offset="0x0.0" selected_by="Monitor_opcodes" size="0x4.0" />
</node>

<node name="peabfe_ext" descr="" size="0x410.0" >
	<field name="size" descr="Number of BF entries to be updated\;Range is 1..256" access="OP" offset="0x0.0" size="0x0.9" />
	<field name="bf_entry" descr="Bloom Filter entry\;See Table 2775, &quot;PEABFE - Bloom Filter Entry Layout,&quot; on page 3000\;" subnode="beabfe_bloom_filter_ext" access="RW" high_bound="255" low_bound="0" offset="0x10.0" size="0x400.0" />
</node>

<node name="peapbl_ext" descr="" size="0x20.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1\;Note: the register updates all duplicated regions" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="erp_id" descr="erp id" access="INDEX" offset="0x10.0" size="0x0.4" />
	<field name="num_rec" descr="Number of records to be updated\;Range is 1..36" access="WO" offset="0x10.16" size="0x0.8" />
	<field name="pruning_ctcam_cs" descr="Pruning C-TCAM clear or set. Clear or set defined by c_s\;0: don&apos;t modify prune_ctcam bit\;1: modify the prune_ctcam bit" access="WO" offset="0x10.28" size="0x0.1" />
	<field name="c_s" descr="Clear or set:\;0: prune clear\;1: prune set" access="WO" offset="0x10.31" size="0x0.1" />
	<field name="pruning_vector_cs" descr="Pruning vector clear or set. Modify option defined by c_s\;Per bit:\;0: don&apos;t modify pruning_vector bit\;1: modify the pruning_vector bit" access="WO" offset="0x14.0" size="0x0.16" />
</node>

<node name="peapbm_ext" descr="" size="0xf8.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1\;Note: the register updates all duplicated regions" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="erp_id" descr="erp id" access="INDEX" offset="0x10.0" size="0x0.4" />
	<field name="erp_id_mask" descr="erp id mask, per bit:\;0: for both values of erp_id bit\;1: for value according to erp_id bit\;Example: mask 1111 - update only erp_id, mask 0000 - update all erps" access="INDEX" offset="0x10.8" size="0x0.4" />
	<field name="pruning_ctcam_cs" descr="Pruning C-TCAM clear or set. Clear or set defined by c_s\;0: don&apos;t modify prune_ctcam bit\;1: modify the prune_ctcam bit" access="WO" offset="0x10.28" size="0x0.1" />
	<field name="c_s" descr="Clear or set:\;0: prune clear\;1: prune set" access="WO" offset="0x10.31" size="0x0.1" />
	<field name="pruning_vector_cs" descr="Pruning vector clear or set. Modify option defined by c_s\;Per bit:\;0: don&apos;t modify pruning_vector bit\;1: modify the pruning_vector bit" access="WO" offset="0x14.0" size="0x0.16" />
	<field name="priority_start" descr="Update will be from priority_start (inclusive) to priority_end (inclusive).\;For Spectrum-2 range is 1.. cap_kvd_size-1" access="INDEX" offset="0x18.0" size="0x0.24" />
	<field name="priority_end" descr="Update will be from priority_start (inclusive) to priority_end (inclusive).\;For Spectrum-2 range is 1.. cap_kvd_size-1" access="INDEX" offset="0x1C.0" size="0x0.24" />
	<field name="key" descr="ACL Key as described in Section 11.6.2, &quot;Flex2 ACL Key Blocks Layout&quot;, on page 2635\;Note: for regions which have 12 Key Blocks the 6 lsb Key Blocks are valid and the 6 msb Key Blocks are not used for this function" access="INDEX" high_bound="23" low_bound="0" offset="0x20.0" size="0x60.0" />
	<field name="key_mask" descr="Mask\;Mask entries which match the key with this mask. Per bit:\;0: ignore bit key (always match)\;1: compare bit in key\;Note: for regions which have 12 Key Blocks the 6 lsb Key Blocks are valid and the 6 msb Key Blocks are not used for this function" access="INDEX" high_bound="23" low_bound="0" offset="0x80.0" size="0x60.0" />
	<field name="large_entry_key_id" descr="Large entry key ID\;A key for 12 Key block rules\;Reserved when the region has 2, 4 or 6 key blocks\;Range 0 .. cap_max_pe_large_key_id- 1" access="INDEX" offset="0xE0.0" size="0x0.24" />
	<field name="large_entry_key_id_mask" descr="Large entry key ID mask\;0: ignore bit large_entry_key_id (always match)\;1: compare bit in large_entry_key_id\;Reserved when the region has 2, 4 or 6 key blocks\;Range 0 .. cap_max_pe_large_key_id- 1" access="INDEX" offset="0xE4.0" size="0x0.24" />
	<field name="delta_start" descr="Start point of delta value and mask\;Units of bits\;Reserved when delta_mask = 0" access="INDEX" offset="0xF0.0" size="0x0.10" />
	<field name="delta_value" descr="Delta value\;Relevant only for large keys when delta_start &gt;= 27*8bits\;For all other cases the delta_value is given in the key" access="INDEX" offset="0xF4.0" size="0x0.8" />
	<field name="delta_mask" descr="Delta mask\;Per bit:\;0: ignore relevant bit from offset delta_start\;1: compare relevant bit from offset delta_start" access="INDEX" offset="0xF4.16" size="0x0.8" />
</node>

<node name="peaps_ext" descr="" size="0x34.0" >
	<field name="ovf" descr="Overflow:\;0: previous session ended okay\;1: previous session had an overflow \;Overflow example: value of 90 was shifted by -100 to -10\;This field is cleared at every read or write access\;Regardless of region" access="RO" offset="0x0.30" size="0x0.1" />
	<field name="busy" descr="Busy:\;0: READY - can accept a new priority shift command\;1: BUSY - cannot accept a new priority shift command\;Regardless of region" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="ct_offset" descr="Offset within the C-TCAM region to start the priority shift\;Reserved when ct_size = 0" access="WO" offset="0x8.0" size="0x0.16" />
	<field name="ct_size" descr="The number of rules in the C-TCAM to do the priority shift, starting from ct_offset" access="WO" offset="0xC.0" size="0x0.16" />
	<field name="tcam_region_info" descr="Opaque object that represents the TCAM region\;This is the base region. All duplicated region_id&apos;s will be shifted as well. See Section 11.9.20, &quot;PERD - Policy-Engine Region Duplication Register&quot;, on page 2955" access="WO" high_bound="3" low_bound="0" offset="0x10.0" size="0x10.0" />
	<field name="priority_start" descr="Initial start priority\;For Spectrum-2 range is 1.. cap_kvd_size-1" access="WO" offset="0x20.0" size="0x0.24" />
	<field name="priority_end" descr="Initial end priority\;Must be equal or greater than priority_start\;For Spectrum-2 range is 1.. cap_kvd_size-1" access="WO" offset="0x24.0" size="0x0.24" />
	<field name="priority_inc" descr="2&apos;s complement value for priority increase or decrease" access="WO" offset="0x30.0" size="0x0.24" />
</node>

<node name="pecb_ext" descr="" size="0x210.0" >
	<field name="tfst" descr="Take First\;0: take last (in packet offset) extraction point (default)\;1: take first (in packet offset) extraction point\;Example1: L2-&gt;L3-&gt;UDP-&gt;FPH3-&gt;FPH3-&gt;FPH3\;Take the first or last FPH3\;Example2: IPv4-&gt;UDP. Take IPv4 (first) or UDP (last)\;Reserved when Spectrum (which supports only last)." access="RW" offset="0x0.0" size="0x0.1" />
	<field name="cbset" descr="Custom Bytes Set\;Range 0 .. cap_max_custom_byte_sets-1\;See encoding in Table 3329, &quot;Spectrum Custom Bytes Sets,&quot; on page 3572" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="ext_point" descr="Extraction point protocol encoding\;Extraction point protocol encoding is define by Table 3334, &quot;Custom Bytes Extraction Points,&quot; on page 3575\;Example: ext_point &quot;IPv6 Payload&quot; is at index 11 (0xB)\;Maximum number of concurrent enabled extraction points per cbset is cap_max_ext_points\;See Table 2761, &quot;Extraction_point Layout,&quot; on page 2992" access="RW" high_bound="255" low_bound="0" offset="0x10.16" size="0x200.0" />
</node>

<node name="peckc_ext" descr="" size="0x30.0" >
	<field name="key" descr="Key:\;0: has_conf_et\;1: dscp_range\;2: or_tcp_control_or_ecn\;4: ipv6_custom_extension\;5: inner_ipv6_custom_extension\;6: ipv6_hbh_custom_option\;7: inner_ipv6_hbh_custom_option" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="index" descr="Index\;For example: dscp_range[2]: key=1, index=2\;Valid bits according to the key" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="attributes0" descr="Attributes per key:\;has_conf_et: ethertype, 16bits\;\;dscp_range: dscp_min, 6bits\;\;or_tcp_control_or_ecn: xor, 9bits\;\;ipv6_custom_extension: value, 8bits\;inner_ipv6_custom_extension: value, 8bits\;\;ipv6_hbh_custom_option: value, 8bits\;inner_ipv6_hbh_custom_option: value, 8bits" access="RW" high_bound="3" low_bound="0" offset="0x10.0" size="0x10.0" />
	<field name="attributes1" descr="Attributes per key:\;has_conf_et: tag length\;\;dscp_range: dscp_max, 6bits\;\;or_tcp_control_or_ecn: mask, 9bits\;or_tcp_control_or_ecn[i] = ({tcp_control,tcp_ecn_bits} ^ xor) &amp; mask)\;\;ipv6_custom_extension: mask, 8bits\;inner_ipv6_custom_extension: mask, 8bits\;\;ipv6_hbh_custom_option: mask, 8bits\;inner_ipv6_hbh_custom_option: mask, 8bits" access="RW" high_bound="3" low_bound="0" offset="0x20.0" size="0x10.0" />
</node>

<node name="pecnee_ext" descr="" size="0x18.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1\;Note: the counter (PECNER) is always enabled. It is suggested to clear the counter (PECNER.clear) after changing the region_id, erp_id_bitwise or ctcam" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="region_id_mask" descr="Region_id mask\;Per bit:\;0: ignore region_id relevant bit\;1: compare region_id relevant bit\;Can be used for a binary search on regions with high count values\;Range 0 .. 2^ (round_down(log2(cap_max_regions-1)) + 1)" access="RW" offset="0xC.0" size="0x0.16" />
	<field name="erp_id_bitwise" descr="Erp ID to count on\;Value as bitwise. Can set either one erp or all erps. (e.g. value of b&apos;101 is not allowed).\;When more than 1 region is counted then all erps are counted\;Reserved when region_id_mask != FF&apos;s (more than 1 region)\;\;" access="RW" offset="0x10.0" size="0x0.16" />
	<field name="ctcam" descr="Count on C-TCAM\;When more than 1 region then all C-TCAM access are counted\;Reserved when region_id_mask != 0 (more than 1 region)" access="RW" offset="0x14.0" size="0x0.1" />
</node>

<node name="pecner_ext" descr="" size="0x38.0" >
	<field name="clear" descr="Clear counters" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="erp_initial_high" descr="ERP or C-TCAM is initial active after erpt_vector (phase 1)\;Note: if n (erps + ctcam) are enabled then the counter may increase by 0..n for a given region lookup" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="erp_initial_low" descr="ERP or C-TCAM is initial active after erpt_vector (phase 1)\;Note: if n (erps + ctcam) are enabled then the counter may increase by 0..n for a given region lookup" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="erp_post_bf_high" descr="ERP active after bloom filter (phase 2)\;Doesn&apos;t increment as C-TCAM\;Note: if n erps are enabled then the counter may increase by 0..n for a given region lookup\;Note: when PERCR.bf_bypass=1 then this counter does not count." access="RO" offset="0x18.0" size="0x4.0" />
	<field name="erp_post_bf_low" descr="ERP active after bloom filter (phase 2)\;Doesn&apos;t increment as C-TCAM\;Note: if n erps are enabled then the counter may increase by 0..n for a given region lookup\;Note: when PERCR.bf_bypass=1 then this counter does not count." access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="erp_lookup_high" descr="ERP or CTCAM had a lookup - active after bloom filter and pruning (phase 3)\;Note: if n erps + ctcam are enabled then the counter may increase by 0..n for a given region lookup" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="erp_lookup_low" descr="ERP or CTCAM had a lookup - active after bloom filter and pruning (phase 3)\;Note: if n erps + ctcam are enabled then the counter may increase by 0..n for a given region lookup" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="erp_any_match_high" descr="ERP or CTCAM had a match (not yet a final match - later priority will choose the final)\;Note: if n erps + ctcam are enabled then the counter may increase by 0..n for a given region lookup" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="erp_any_match_low" descr="ERP or CTCAM had a match (not yet a final match - later priority will choose the final)\;Note: if n erps + ctcam are enabled then the counter may increase by 0..n for a given region lookup" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="erp_final_match_high" descr="ERP or CTCAM had a final match\;Note: the counter may increase by 0..1 for a given region lookup" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="erp_final_match_low" descr="ERP or CTCAM had a final match\;Note: the counter may increase by 0..1 for a given region lookup" access="RO" offset="0x34.0" size="0x4.0" />
</node>

<node name="pecnre_ext" descr="" size="0x10.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1\;Note: the counter (PECNRR) is always enabled. It is suggested to clear the counter (PECNRR.clear) after changing the region_id" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="region_id_mask" descr="Region_id mask\;Per bit:\;0: ignore region_id relevant bit\;1: compare region_id relevant bit\;Can be used for a binary search on regions with high count values\;Note: value of all &apos;0&apos; is not supported \;Range 0 .. 2^ (round_down(log2(cap_max_regions-1)) + 1)" access="RW" offset="0xC.0" size="0x0.16" />
</node>

<node name="pecnrr_ext" descr="" size="0x20.0" >
	<field name="clear" descr="Clear counters" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="tcam_trigger_high" descr="Count number of tcam triggers (bind to ACL group)\;For example: if a packet has iACL and eirfACL then inc by 2\;Note: packets from CPU ingress are not counted" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="tcam_trigger_low" descr="Count number of tcam triggers (bind to ACL group)\;For example: if a packet has iACL and eirfACL then inc by 2\;Note: packets from CPU ingress are not counted" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="tcam_full_lookup_high" descr="Count number of tcam triggers which needed a full lookup\;\;Note: packets from CPU ingress are not counted\;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="tcam_full_lookup_low" descr="Count number of tcam triggers which needed a full lookup\;\;Note: packets from CPU ingress are not counted\;" access="RO" offset="0x1C.0" size="0x4.0" />
</node>

<node name="pefa_ext" descr="" size="0xb0.0" >
	<field name="index" descr="Index in the KVD Linear Centralized Database. For more details \;see Appendix A.4.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3813)\;Range is 0.. cap_max_kvd_action_sets - 1" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="pind" descr="Partial Index\;Used for partial action set\;0: full action set\;1: double partial action sets \;2: partial action set, partial index 0\;3: partial action set, partial index 1\;Note that &quot;full action set&quot; and &quot;partial action set, partial index 0&quot; have the same pointer but different indexes\;Reserved when Spectrum" access="INDEX" offset="0x0.30" size="0x0.2" />
	<field name="as_user_val" descr="Action set user value\;Can be used for activity dump, see PEFAAD\;Note: for partial action sets, both action sets in the same index have the same as_user_val\;Reserved when ddd_en = 1\;Reserved when Spectrum\;" access="RW" offset="0x4.0" size="0x0.10" />
	<field name="ddd_en" descr="The action is DDD enabled\;Note that action DDD must be enabled if (1) DDD is enabled for actions and (2) the action is pointed by a ddd priority.\;See IDDD and IGCR.ddd_pe_actions_priority\;Note: for partial action sets, both action sets in the same index have the same ddd_en\;" access="RW" offset="0x4.20" size="0x0.1" />
	<field name="ca" descr="Clear activity:\;When write: \;0: activity is set\;1: activity is cleared\;2: activity is maintained (used for updating)\;When read:\;0, 2: activity is maintained\;1: after reading the activity is cleared\;Reserved when Spectrum\;When pind=1 then applies to both partials" access="OP" offset="0x4.24" size="0x0.2" />
	<field name="a1" descr="Activity of partial1\;Reserved when pind = 0 or pind = 2" access="RO" offset="0x4.28" size="0x0.1" />
	<field name="a" descr="Activity of full or partial0For a new entry: set if ca=0, clear if ca=1\;Set if a packet lookup has hit on the specific entry\;Reserved when Spectrum\;When pind=&quot;double partial&quot; then applies to partial 0\;Reserved when pind = 3\;" access="RO" offset="0x4.29" size="0x0.1" />
	<field name="flexible_action_set" descr="Action-set to perform when rule is matched.\;See Table 2563, &quot;Flexible Action Set Layout,&quot; on page 2815\;Must be zero padded if action set is shorter." subnode="flexible_action_set_ext" access="RW" offset="0x8.0" size="0xa8.0" />
</node>

<node name="pefaad_ext" descr="" size="0x420.0" >
	<field name="filter_fields" descr="Filter Fields:\;if a bit is &apos;0&apos; then the relevant field is ignored and dump is done regardless of the field value\;Bit0: filter by activity: entry_a\;Bit1: filter by action set user value: as_user_val when ddd_en=0\;All set filters are relevant (there is AND between the filters)\;Reserved when op is Clear activity" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="num_rec" descr="At request: number of records requested\;At response: number of records dumped\;Range for request is 1..256\;Range for response is 0..256" access="OP" offset="0x4.0" size="0x0.9" />
	<field name="op" descr="Operation\;0: Dump entries\;1: Dump entries and force end of session (clear activity will clear this session while next dump will be a new session)\;2: Clear activity for all entries which were dumped in the current session" access="OP" offset="0x4.24" size="0x0.2" />
	<field name="entry_a" descr="Dump only if activity has value of entry_a\;Reserved when filter_fields bit0 is &apos;0&apos;" access="INDEX" offset="0x8.16" size="0x0.1" />
	<field name="as_user_val" descr="Action set user value\;Reserved when ddd_en = 1\;Reserved when filter_fields bit1 is &apos;0&apos;" access="INDEX" offset="0x10.0" size="0x0.10" />
	<field name="index_dump" descr="Dumped index\;For Spectrum-2 pointer to policy engine actions array which is in the KVH Linear." subnode="index_dump" access="RO" high_bound="255" low_bound="0" offset="0x20.0" size="0x400.0" />
</node>

<node name="peir_reg_ext" descr="" size="0xc.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="error_count" descr="Error Count\;Number of times the port will generate the configured error.\;0 indicates not to generate error.\;Reading error_count will return the number of left errors to inject. When 0, all requested errors has been injected." access="RW" offset="0x4.16" size="0x0.4" />
	<field name="error_type" descr="Error Type to generate\;0 - No Error\;---- Physical Errors ----\;1 - 8/10 Symbol Error (per lane)\;2 - 8/10 Disparity Error (per lane)\;3:7 - Reserved\;8 - 64/66 Sync Header (per lane, with block count)\;9 - 64/66 Alignment Marker (per lane, with block count)\;10 - 64/66 Block Type (per lane, with block count)\;---- Packet Errors ----\;16 - EBP marking (with packet count)\;17 - Corrupt data packet ICRC\;18 - Corrupt data packet VCRC\;19 - Corrupt credit packet LPCRC\;" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="lane" descr="Bit vector for lane (bit 0, lane 0)\;Only relevant for specific errors at physical layer" access="RW" offset="0x8.16" size="0x0.4" />
</node>

<node name="pemi_SNR_Samples_ext" descr="" size="0xf8.0" >
	<field name="snr_media_lane1" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x0.0" size="0x0.16" />
	<field name="snr_media_lane0" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x0.16" size="0x0.16" />
	<field name="snr_media_lane3" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x4.0" size="0x0.16" />
	<field name="snr_media_lane2" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x4.16" size="0x0.16" />
	<field name="snr_media_lane5" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="snr_media_lane4" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x8.16" size="0x0.16" />
	<field name="snr_media_lane7" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0xC.0" size="0x0.16" />
	<field name="snr_media_lane6" descr="SNR value on the media lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0xC.16" size="0x0.16" />
	<field name="snr_host_lane1" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x10.0" size="0x0.16" />
	<field name="snr_host_lane0" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x10.16" size="0x0.16" />
	<field name="snr_host_lane3" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x14.0" size="0x0.16" />
	<field name="snr_host_lane2" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x14.16" size="0x0.16" />
	<field name="snr_host_lane5" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x18.0" size="0x0.16" />
	<field name="snr_host_lane4" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x18.16" size="0x0.16" />
	<field name="snr_host_lane7" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x1C.0" size="0x0.16" />
	<field name="snr_host_lane6" descr="SNR value on the host lane &lt;i&gt;. In unit scale of 1/256 dB.\;The SNR value represents the electrical signal-to-noise ratio on an optical lane, and is defined as the minimum of the three individual eye SNR values." access="RO" offset="0x1C.16" size="0x0.16" />
</node>

<node name="pemi_ext" descr="" size="0x100.0" >
	<field name="status" descr="The status of the page reading:\;0: READ_SUCCESSFUL - read operation was successful\;1: OPERATION_NOT_SUPPORTED\;2: NO_EEPROM_MODULE - no response from module&apos;s \;EEPROM.\;3: MODULE_NOT_CONNECTED - no module present indication.\;4: I2C_ERROR - an Error occurred while trying to access the module&apos;s EEPROM using I2C.\;5: MODULE_IN_PROGRESS - indicates that the module is still busy.\;6: CDB_STSATUS_FAILED - the CDB return status is FAILED." access="RO" enum="READ_SUCCESSFUL=0x0,OPERATION_NOT_SUPPORTED=0x1,NO_EEPROM_MODULE=0x2,MODULE_NOT_CONNECTED=0x3,I2C_ERROR=0x4,MODULE_IN_PROGRESS=0x5,CDB_STSATUS_FAILED=0x6" offset="0x0.0" size="0x0.8" />
	<field name="lp_msb" descr="Local port number [9:8]\;\;for Retimer: reserved" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is \;interpreted:\;0: Local_port_number\;1: IB_port_number\;3: Out_of_band_or_PCI\;\;for Retimer: reserved" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number\;for Retimer: Data path number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="page_select" descr="The user can select to read a sampled data page or a properties page.\;\;1: SNR_Samples\;16: Module_Status_Properties" access="INDEX" enum="SNR_Samples=0x1" offset="0x4.0" size="0x0.5" />
	<field name="group_cap_mask" descr="Group capability mask:\;Bit 1: SNR" access="RO" enum="SNR=0x2" offset="0x4.16" size="0x0.16" />
	<field name="page_data" descr="Page data:\;Table 1902, &quot;SNR Samples page - Layout,&quot; on page 2261" subnode="pemi_page_data_auto_ext" access="RO" offset="0x8.0" size="0xf8.0" union_selector="$(parent).page_select" />
</node>

<node name="pemi_page_data_auto_ext" descr="" attr_is_union="1" size="0xf8.0" >
	<field name="pemi_SNR_Samples_ext" descr="" subnode="pemi_SNR_Samples_ext" offset="0x0.0" selected_by="SNR_Samples" size="0xf8.0" />
</node>

<node name="pemrbt_ext" descr="" size="0x14.0" >
	<field name="protocol" descr="Protocol:\;0: IPv4\;1: IPv6" access="INDEX" offset="0x0.0" size="0x0.1" />
	<field name="op" descr="0: Bind ACL to MC group\;2: Add - will add the content of a given ACL group to the already existing bound group\;" access="RW" offset="0x0.20" size="0x0.3" />
	<field name="group_id" descr="ACL group identifier (acl_group_id) or ACL group element (acl_group_element).\;Default: group 0 for Spectrum only\;For ACL group identifier, range of group id is 0..cap_max_acl_groups-1.\;For ACL group element, range of group element is 0..cap_max_acl_tot_groups-1.\;Note: the group_id must be configured prior to enabling mc router" access="RW" offset="0x10.0" size="0x0.16" />
</node>

<node name="pepc_reg_ext" descr="" size="0x10.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="twisted_pair_an_mode" descr="twisted_pair operational mode in case of AN enabled: \;0x0: auto_Master_Slave_mode_for_AN_links\;0x1: Master_mode\;0x2: Slave_mode" access="RW" enum="auto_Master_Slave_mode_for_AN_links=0x0,Master_mode=0x1,Slave_mode=0x2" offset="0x4.0" size="0x0.2" />
	<field name="twisted_pair_force_mode" descr="twisted_pair operational mode in case of AN disabled: \;0x0: Master_mode\;0x1: Slave_mode" access="RW" enum="Master_mode=0x0,Slave_mode=0x1" offset="0x4.8" size="0x0.1" />
</node>

<node name="perar_ext" descr="" size="0x8.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="hw_region" descr="HW Region\;Range 0 .. cap_max_regions-1\;Spectrum-2 note: \;- For a 8 key block region, 2 consecutive regions are used\;- For a 12 key block region, 3 consecutive regions are used\;- For sensitivity (PACL.acl_type != 0): if any region (in the sensitivity) is 2 then all regions (in the sensitivity) are 2, if any region (in the sensitivity) is 3 then all regions (in the sensitivity) are 3\;" access="RW" offset="0x4.0" size="0x0.16" />
</node>

<node name="perb_base_classifier_ext" descr="" size="0x40.0" >
	<field name="inner_l2_type" descr="Bit0: others\;Bit1: Ethernet" access="RW" offset="0x0.0" size="0x0.2" />
	<field name="l3_mc" descr="L3 Multicast, according to DIP MSB:\;Bit0: MC \;Bit1: Not MC" access="RW" offset="0x0.16" size="0x0.2" />
	<field name="l2_mc" descr="L2 Multicast, according to DMAC[40]:\;Bit0: MC - packet is Ethernet and DMAC[40] = 1\;Bit1: Not MC\;Default {0, 0}" access="RW" offset="0x0.20" size="0x0.2" />
	<field name="l2_flood" descr="L2 Flooding based on prev FDB:\;Bit0: flooded \;Bit1: not flooded\;Reserved when iport, tunnel_iport and erif" access="RW" offset="0x0.24" size="0x0.2" />
	<field name="l3_type" descr="Ethertype\;Bit0: None \;Bit1: IPv4\;Bit2: IPv6\;Bit3: GRH\;Bit4: Fiber-Channel\;Bit5: ARP\;Bit6: Raw \;Bit7: MPLS\;" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="inner_l3_type" descr="same as for l3_type" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="inner_ip_frag" descr="same as for ip_frag" access="RW" offset="0xC.0" size="0x0.2" />
	<field name="ip_frag" descr="IP Packet is fragmented:\;Bit0: fragmented\;Bit1: not fragmented" access="RW" offset="0xC.8" size="0x0.2" />
	<field name="l4_type" descr="Bit0: others \;Bit1: Raw \;Bit2: TCP\;Bit3: UDP\;Bit4: BTH\;Bit5: BTH_over_UDP\;Bit6: ICMP\;Bit7: IGMP\;Bit8: AH\;Bit9: ESP" access="RW" offset="0x10.0" size="0x0.11" />
	<field name="inner_l4_type" descr="Bit0: others \;Bit1: Raw \;Bit2: TCP\;Bit3: UDP\;Bit6: ICMP\;Bit7: IGMP\;Bit8: AH\;Bit9: ESP" access="RW" offset="0x14.0" size="0x0.11" />
	<field name="tunnel_type" descr="Bit0: others\;Bit1: VxLAN\;Bit2: NVGRE\;Bit3: MPLS\;Bit4: IPinIP - no GRE\;Bit5: IPinGREinIP_Key - with GRE and a key\;Bit6: IPinGREinIP - with GRE, without a key\;Bit7: ARN\;Bit8: Flex" access="RW" offset="0x18.0" size="0x0.9" />
	<field name="tq_command" descr="tq command indicate the flow of the packet.\;Bit0: switch\;Bit1: ip_router\;Bit2: mpls_lsr\;Bit3: vxlan_encap\;Bit4: ipinip_encap\;Bit5: mpls_encap\;Bit6: router_vx_encap\;Bit9: arn_encap\;Bit13: ip_gw\;Bit14: mac_o_flex_encap\;Bit15: ip_o_flex_encap\;Bit17: router_flex_encap\;For don&apos;t care, SW will set all the bits to 1" access="RW" offset="0x1C.0" size="0x0.19" />
	<field name="decap_tq_command" descr="Bit0: If the packet is after decap - classify according to tq_command field\;Bit1: if packet is not after decap - classify according to tq_command field" access="RW" offset="0x1C.30" size="0x0.2" />
	<field name="fpp_index" descr="Bit0 : if set, fpp (flex parser program) was not used\;Bit1-Bit8: fpp index + 1" access="RW" offset="0x20.0" size="0x0.9" />
	<field name="inner_fpp_index" descr="Bit0 : if set, inner fpp was not used\;Bit1-Bit8: inner fpp index + 1" access="RW" offset="0x24.0" size="0x0.9" />
</node>

<node name="perb_classifier_entry_auto_ext" descr="" attr_is_union="1" size="0xc4.0" >
	<field name="perb_classifier_iport_ext" descr="" subnode="perb_classifier_iport_ext" offset="0x0.0" selected_by="iport" size="0xc4.0" />
	<field name="perb_classifier_irif_ext" descr="" subnode="perb_classifier_irif_ext" offset="0x0.0" selected_by="irif" size="0x44.0" />
	<field name="perb_classifier_erif_ext" descr="" subnode="perb_classifier_erif_ext" offset="0x0.0" selected_by="erif" size="0x44.0" />
	<field name="perb_classifier_eport_ext" descr="" subnode="perb_classifier_eport_ext" offset="0x0.0" selected_by="eport" size="0x48.0" />
</node>

<node name="perb_classifier_eport_ext" descr="" size="0x48.0" >
	<field name="base_classifier" descr="Base classifier\;See Table 2693, &quot;PERB base_classifier Layout,&quot; on page 2927" subnode="perb_base_classifier_ext" access="RW" offset="0x0.0" size="0x40.0" />
	<field name="rb_eport_group" descr="Per bit: rule-binding eport_group\;See Section 11.9.10, &quot;PERBEG - Policy-Engine Rule Binding Egress port Group&quot;, on page 2932" access="RW" offset="0x40.0" size="0x4.0" />
	<field name="tunnel_port" descr="Bitmask of egress tunnel port" access="RW" offset="0x44.0" size="0x0.4" />
</node>

<node name="perb_classifier_erif_ext" descr="" size="0x44.0" >
	<field name="base_classifier" descr="Base classifier\;See Table 2693, &quot;PERB base_classifier Layout,&quot; on page 2927" subnode="perb_base_classifier_ext" access="RW" offset="0x0.0" size="0x40.0" />
	<field name="rb_erif_group" descr="Per bit: rule-binding erif_group\;See Section 11.9.9, &quot;PERBRG - Policy-Engine Rule Binding Router Group&quot;, on page 2931" access="RW" offset="0x40.0" size="0x0.4" />
</node>

<node name="perb_classifier_iport_ext" descr="" size="0xc4.0" >
	<field name="base_classifier" descr="Base classifier\;See Table 2693, &quot;PERB base_classifier Layout,&quot; on page 2927" subnode="perb_base_classifier_ext" access="RW" offset="0x0.0" size="0x40.0" />
	<field name="ingress_local_port_list" descr="Local port\;Each bit represents a local port. Refer to Section 9.3, &quot;Port Numbering&quot;, on page 1710 for port numbering scheme.\;Ports order in the bitmask is from bottom to top. e.g for setting local port 1, bit 1 in the last DWORD (offset 0xBCh) should be set.\;CPU port is not supported.\;Router port is not supported" access="RW" high_bound="31" low_bound="0" offset="0x40.0" size="0x80.0" />
	<field name="tunnel_port" descr="Bitmask of ingress tunnel port" access="RW" offset="0xC0.0" size="0x0.4" />
</node>

<node name="perb_classifier_irif_ext" descr="" size="0x44.0" >
	<field name="base_classifier" descr="Base classifier\;See Table 2693, &quot;PERB base_classifier Layout,&quot; on page 2927" subnode="perb_base_classifier_ext" access="RW" offset="0x0.0" size="0x40.0" />
	<field name="rb_irif_group" descr="Per bit: rule-binding irif_group\;See Section 11.9.9, &quot;PERBRG - Policy-Engine Rule Binding Router Group&quot;, on page 2931" access="RW" offset="0x40.0" size="0x0.4" />
</node>

<node name="perb_ext" descr="" size="0xe4.0" >
	<field name="rule_profile_index" descr="Rule Index\;Range 0 - cap_max_rule_based_binding_profile - 1" access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="pipe_stage" descr="Pipe line stage:\;0: iport\;1: irif\;2: erif\;3: eport" access="INDEX" enum="iport=0x0,irif=0x1,erif=0x2,eport=0x3" offset="0x0.16" size="0x0.4" />
	<field name="op" descr="0: Configure classifier and bind interface to group_id.\;1: Unbind ACL from interface (classifier points to NULL group).\;2: Disable classifier." access="RW" offset="0x4.0" size="0x0.2" />
	<field name="group_id" descr="ACL group identifier (acl_group_id) or ACL group element (acl_group_element).\;For ACL group identifier, range of group id is 0..cap_max_acl_groups-1.\;For ACL group element, range of group element is 0..cap_max_acl_tot_groups-1" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="classifier_entry" descr="Classifier entry, related to pipe_stage:\;Table 2685, &quot;PERB classifier_iport Layout,&quot; on page 2923\;Table 2687, &quot;PERB classifier_irif Layout,&quot; on page 2924\;Table 2689, &quot;PERB classifier_erif Layout,&quot; on page 2925\;Table 2691, &quot;PERB classifier_eport Layout,&quot; on page 2926" subnode="perb_classifier_entry_auto_ext" access="RW" offset="0x20.0" size="0xc4.0" union_selector="$(parent).pipe_stage" />
</node>

<node name="perbeg_ext" descr="" size="0x10.0" >
	<field name="egress_lp_msb" descr="Egress local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="egress_local_port" descr="Egress local port\;Note: CPU port is supported." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="rb_eport_group" descr="Used by PERB classifier\;Default 0\;Range 0 - cap_max_rb_eport_group - 1" access="RW" offset="0xC.0" size="0x0.5" />
</node>

<node name="perbrg_ext" descr="" size="0x10.0" >
	<field name="rif" descr="Router Interface" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="dir" descr="Direction of rif interface:\;0: ingress rif\;1: egress rif" access="INDEX" offset="0x8.0" size="0x0.1" />
	<field name="rb_rif_group" descr="Value of rb_rif_group\;Used by PERB classifier\;Default 0\;Range 0 - cap_max_rb_rif_group - 1" access="RW" offset="0xC.0" size="0x0.5" />
</node>

<node name="percr_ext" descr="" size="0x80.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="bf_bypass" descr="Bloom filter bypass\;0: Bloom filter is used (default)\;1: Bypass BF, erps are used regardless of bloom filter\;The bypass is an OR condition of region_id or erp. See PERPT.bf_bypass\;\;Reserved when SwitchX/-2 and Spectrum" access="RW" offset="0x4.16" size="0x0.1" />
	<field name="ctcam_ignore_prune" descr="Ignore prune_ctcam by other A-TCAM rules\;Used e.g. for a new rule" access="RW" offset="0x4.24" size="0x0.1" />
	<field name="atcam_ignore_prune" descr="Ignore prune_vector by other A-TCAM rules\;Used e.g. for a new rule\;See PGCR.atcam_ignore_prune_vector, See Section 11.9.1, &quot;PGCR - Policy-Engine General Configuration Register&quot;, on page 2910" access="RW" offset="0x4.25" size="0x0.1" />
	<field name="master_mask" descr="Master mask, mask the ERPs, the delta_masks and the C-TCAM lookup.\;When there are no erp&apos;s (erpt_pointer_valid = 0) then this provides the mask\;Per bit:\;0: TCAM will ignore the bit in key\;1: TCAM will compare the bit in key\;Reserved when SwitchX/-2 and Spectrum\;\;" access="RW" high_bound="23" low_bound="0" offset="0x20.0" size="0x60.0" />
</node>

<node name="perd_ext" descr="" size="0x50.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="atcam_dup" descr="A-TCAM region duplication:\;0: dup 1\;1: dup 2\;2: dup 4\;3: dup 8\;4: dup 16" access="RW" offset="0x8.0" size="0x0.3" />
	<field name="region_id_dup" descr="Region ID for duplication\;Reserved when i &gt;= atcam_dup\;" subnode="region_id_dup" access="RW" high_bound="14" low_bound="0" offset="0x14.0" size="0x3c.0" />
</node>

<node name="pererp_ext" descr="" size="0x1c.0" >
	<field name="region_id" descr="Region identifier\;Range 0 .. cap_max_regions-1" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="ctcam_le" descr="C-TCAM Lookup enable\;Reserved when erpt_pointer_valid = 0\;" access="RW" offset="0x4.28" size="0x0.1" />
	<field name="erpt_pointer" descr="Pointer to erp table within the erp bank\;Can be changed for an existing region\;Range is 0.. cap_max_erp_table_size-1\;Reserved when erpt_pointer_valid = 0\;Note: the erpt_pointer can have the same value for different ACLs. However, the erpt_pointer must not point to a mid-entry of different ACL (e.g. if ACL1 uses erpt_pointer 100 with vector of 8 lsbs then ACL2 must not point to the range 101..107)" access="RW" offset="0x10.0" size="0x0.8" />
	<field name="erpt_bank_pointer" descr="Pointer to erp table bank\;Note: May be modified any time\;Range 0 .. cap_max_erp_table_banks-1\;Reserved when erpt_pointer_valid = 0" access="RW" offset="0x10.16" size="0x0.4" />
	<field name="ctcam_only" descr="C-TCAM only\;Lookup only in C-CTAM\;Reserved when erpt_pointer_valid = 1\;\;" access="RW" offset="0x10.30" size="0x0.1" />
	<field name="erpt_pointer_valid" descr="erpt_pointer is valid:\;0: exact match, erpt_pointer is not valid\;1: use erps, erpt_pointer is valid\;The non valid erpt is used as follows:\;- if ctcam_only = 0 then lookup only 1 time in A-TCAM, without erp, using master_mask. a.k.a. exact-match. No C-TCAM lookup\;- if ctcam_only = 1 then lookup only in C-TCAM, without erp\;" access="RW" offset="0x10.31" size="0x0.1" />
	<field name="erpt_vector" descr="Vector of allowed erp_indexes starting from erpt_pointer withing the erpt_bank_pointer\;Note that the allow is on erp_index and not on erp_id\;Used for speeding the lookups \;Next entries will be in next bank\;\;Reserved when erpt_pointer_valid = 0" access="RW" offset="0x14.0" size="0x0.16" />
	<field name="master_rp_id" descr="Master RP ID\;When there are no erp&apos;s then this provide the erp_id for the lookup\;Reserved when erpt_pointer_valid = 1\;Can be changed for an existing region\;" access="RW" offset="0x18.0" size="0x0.4" />
</node>

<node name="perla_ext" descr="" size="0x8.0" >
	<field name="hw_region" descr="HW Region\;Range 0 .. cap_max_regions-1\;" access="INDEX" offset="0x0.0" size="0x0.16" />
	<field name="lookup_region_id" descr="Region identifier used for ATCAM lookup\;Range 0 .. cap_max_regions-1" access="RW" offset="0x4.0" size="0x0.16" />
</node>

<node name="perpt_ext" descr="" size="0x80.0" >
	<field name="erpt_index" descr="Index to erp table within the erp bank\;Within an erp range pointed by an ACL the lower entries are searched before higher entries.\;Range is 0.. cap_max_erp_table_bank_size-1" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="erpt_bank" descr="Erp table bank\;Range 0 .. cap_max_erp_table_banks-1" access="INDEX" offset="0x0.16" size="0x0.4" />
	<field name="key_size" descr="0: 2 key blocks \;1: 4 key blocks \;2: 8 key blocks \;3: 12 key blocks" access="OP" offset="0x4.0" size="0x0.4" />
	<field name="erp_id" descr="erp ID for use by the rules\;Note that the erp_id may be modified by SW, even when the erp is in use.\;Note: ERP ID 0 with all-zero mask is a &quot;default&quot; ERP that always matches.\;" access="RW" offset="0x8.0" size="0x0.4" />
	<field name="bf_bypass" descr="Bloom Filter bypass\;0: This erp is used only if bloom filter state is set for the given rule \;1: This erp is used regardless of bloom filter state\;The bypass is an OR condition of region_id or erp. See PERCR.bf_bypass\;" access="RW" offset="0x8.8" size="0x0.1" />
	<field name="erpt_base_index" descr="Base Index to erp table within the erp bank\;Must align to erp_index_in_vector\;Range is 0.. cap_max_erp_table_bank_size-1" access="OP" offset="0xC.0" size="0x0.8" />
	<field name="erpt_base_bank" descr="Base Erp table bank, points to head of erp_vector\;Must align to erp_index_in_vector\;Range 0 .. cap_max_erp_table_banks-1" access="OP" offset="0xC.16" size="0x0.4" />
	<field name="erp_index_in_vector" descr="erp index in the vector\;Must align to {erpt_base_bank, erpt_base_index}\;" access="OP" offset="0x10.0" size="0x0.4" />
	<field name="erp_vector" descr="erp vector, needed for write operations\;" access="OP" offset="0x14.0" size="0x0.16" />
	<field name="mask" descr="Mask, at the same size as key. per bit:\;0: A-TCAM will ignore the bit in key\;1: A-TCAM will compare the bit in key\;" access="RW" high_bound="23" low_bound="0" offset="0x20.0" size="0x60.0" />
</node>

<node name="petcm_ext" descr="" size="0x20.0" >
	<field name="tx_command_val" descr="Tx command Value.\;Each element in the array will hold the corresponding value of the TX command\;Index 0: switch\;Index 1: ip_router\;Index 2: mpls_lsr\;Index 3: vxlan_encap\;Index 4: ipinip_encap\;Index 5: mpls_encap\;Index 6: router_vx_encap\;Index 7: arn_encap\;Index 8: ip_gw\;Index 9: mac_o_flex_encap\;Index 10: ip_o_flex_encap\;Index 11: router_flex_encap\;\;When value equals to 0xff this command is not valid." access="RO" high_bound="31" low_bound="0" offset="0x0.24" size="0x20.0" />
</node>

<node name="pevpb_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Ingress local port \;Not including CPU port in Spectrum-1.\;From Spectrum-2 and on CPU port is supported.\;Note: Spectrum-2: no VLAN binding for tunnel_port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="ev" descr="Enable VLAN binding from ingress port\;0: disable\;1: enable (default)" access="RW" offset="0x4.0" size="0x0.1" />
</node>

<node name="pfca_ext" descr="" size="0xc.0" >
	<field name="index" descr="Counter set index" access="INDEX" offset="0x0.0" size="0x0.9" />
	<field name="type" descr="Counter type:\;0: Bytes_counter\;1: Packets_counter\;" access="RW" enum="Bytes_counter=0x0,Packets_counter=0x1" offset="0x0.24" size="0x0.2" />
	<field name="op" descr="Operation:\;0: NOP\;1: Allocate\;2: Test\;3: Free" access="WO" enum="NOP=0x0,Allocate=0x1,Test=0x2,Free=0x3" offset="0x0.30" size="0x0.2" />
	<field name="counter_set" descr="Opaque object that represents the flow counter. Returned when allocating counter. Provided by software for action-set binding or any other counter operation." access="RO" offset="0x8.0" size="0x4.0" />
</node>

<node name="pfcc_reg_ext" descr="" size="0x20.0" >
	<field name="shl_opr" descr="Send to higher layers operation:\;0: Pause and PFC are handled by the port (default)\;1: Pause and PFC are handled by the port and are also been send to higher layers.\;Only valid if shl_cap = 1." access="RW" offset="0x0.0" size="0x0.1" />
	<field name="shl_cap" descr="Send to higher layers capabilities:\;0: No capability of sending Pause and PFC to higher layers\;1: Device has capability of send Pause and PFC to higher layers\;NOTE: This relates to IEEE 802.3 PAUSE and IEEE 802.3 PFC." access="RO" offset="0x0.1" size="0x0.1" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0: Local port number\;1: IB / label port number" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="prio_mask_rx" descr="Bit per prio indicating if RX flow control policy should be updated based on bit pfcrx ." access="WO" offset="0x4.0" size="0x0.8" />
	<field name="prio_mask_tx" descr="Bit per prio indicating if TX flow control policy should be updated based on bit pfctx ." access="WO" offset="0x4.16" size="0x0.8" />
	<field name="ppan" descr="Pause policy auto negotiation\;0: disabled - generate and ignore pause frames based on pptx, pprx\;1: enabled - when auto-negotiation is performed, set the pause policy based on the auto-negotiation resolution.\;\;" access="RW" enum="disabled=0x0,enabled=0x1" offset="0x4.28" size="0x0.4" />
	<field name="pfctx" descr="Priority based flow control policy on TX[7:0]. Per priority bit mask:\;0: never generate pause frames on the specified priority (default)\;1: generate pause frames according to RX buffer threshold on the specified priority\;pfctx, pptx must be mutually exclusive (for example, only one of them at most can be set)." access="RW" offset="0x8.16" size="0x0.8" />
	<field name="patx" descr="Peer advertisement pause policy on Tx\;0: Unknown\;1: Peer supports pause on Tx\;2: Peer doesn&apos;t support pause on Tx\;\;" access="RO" offset="0x8.27" size="0x0.2" />
	<field name="aptx" descr="Active (operational) pause policy on TX\;0: do not generate pause frames\;1: generate pause frames according to RX buffer threshold" access="RO" offset="0x8.30" size="0x0.1" />
	<field name="pptx" descr="Admin pause policy on TX (see also pfctx):\;0: never generate pause frames (default)\;1: generate pause frames according to RX buffer threshold" access="RW" offset="0x8.31" size="0x0.1" />
	<field name="pfcrx" descr="Priority based flow control policy on RX[7:0]. Per priority bit mask:\;0: ignore incoming pause frames on the specified priority (default)\;1: respect incoming pause frames on the specified priority" access="RW" offset="0xC.16" size="0x0.8" />
	<field name="parx" descr="Peer advertisement pause policy on Rx\;0: Unknown\;1: Peer supports pause on Rx\;2: Peer doesn&apos;t support pause on Rx\;\;" access="RO" offset="0xC.27" size="0x0.2" />
	<field name="aprx" descr="Active (operational) pause policy on RX\;0: ignore received pause frames\;1: respect received pause frames" access="RO" offset="0xC.30" size="0x0.1" />
	<field name="pprx" descr="Admin pause policy on RX (see also pfcrx):\;0: ignore received pause frames (default)\;1: respect received pause frames" access="RW" offset="0xC.31" size="0x0.1" />
</node>

<node name="pfcnt_ext" descr="" size="0x28.0" >
	<field name="counter_index" descr="counter index\;For Spectrum: see Section 5.2, &quot;Flow Counters&quot;, on page 1127\;Range 0 .. cap_shared_counter_pool_size - 1" access="INDEX" offset="0x0.0" size="0x0.24" />
	<field name="counter_set_type" descr="Counter Set Type\;For Spectrum: See Section 5.2.2, &quot;Counter Set Type&quot;, on page 1128" access="OP" offset="0x0.24" size="0x0.8" />
	<field name="clr" descr="Clear counters. Setting the clr bit will reset the counter value for relevant flow counter. \;Note: This bit can be set for both Write() and Read() operation to enable clear on read operation." access="OP" offset="0x4.31" size="0x0.1" />
	<field name="flow_counter_0" descr="Flow counter value" access="RO" high_bound="5" low_bound="0" offset="0x8.0" size="0x18.0" />
</node>

<node name="pfsc_reg_ext" descr="" size="0x10.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="fwd_admin" descr="Administratively configured of Forward switching for Egress:\;0: Allow cut-through forwarding\;1: Always Store and Forward" access="RW" offset="0x4.0" size="0x0.4" />
	<field name="fwd_oper" descr="Operational Egress Forward switching:\;0: Cut-Through forwarding operation is allowed\;1: Only Store and Forward operation" access="RO" offset="0x8.0" size="0x0.4" />
</node>

<node name="pgcr_ext" descr="" size="0x20.0" >
	<field name="pbs_table_size" descr="Number of PBS entries. This is a settable capability.\;Reserved for Spectrum family.\;" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="update_prune" descr="Update atcam_ignore_prune_vector only\;0: update all fields including atcam_ignore_prune_vector\;1: update only atcam_ignore_prune_vector\;Reserved when SwitchX/-2 and Spectrum" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="max_iacl" descr="Max Ingress ACL\;Maximum number of Ingress ACLs\;Reserved for Spectrum family." access="RO" offset="0x8.0" size="0x0.16" />
	<field name="max_eacl" descr="Max Egress ACL\;Maximum number of Egress ACLs\;Reserved for Spectrum family." access="RO" offset="0x8.16" size="0x0.16" />
	<field name="atcam_ignore_prune_vector" descr="When atcam_ignore_prune is set for a region, then the ignore is for ERP IDs according to this vector\;Each bit is per ERP ID\;0: do not ignore erp prune\;1: ignore erp prune\;\;Reserved when SwitchX/-2 and Spectrum\;" access="RW" offset="0x14.0" size="0x0.16" />
	<field name="default_action_pointer_base" descr="Default action pointer base\;Each region has a default action pointer which is equal to:\;default_action_pointer_base + region_id\;For Spectrum-2 pointer to policy engine actions array which is in the KVH Linear.\;Notes: \;1. may be changed on the fly, need fence to release old action entries\;2. pointer either to full action-set or to partial pointer 0\;3. when a multi-ACL the first region_id is used for all regions of the multi-ACL\;4. User must not set actions in the range of (default_action_pointer_base+cap_max_regions) ... (default_action_pointer_base+cap_max_default_actions-1)" access="RW" offset="0x1C.0" size="0x0.24" />
</node>

<node name="pgmr_ext" descr="" size="0x2c.0" >
	<field name="pg_sel" descr="Selection between an operation on a local port or a group, for &apos;set&apos; and &apos;get&apos; operations. \;0 - local port (group field is neglected even if set)\;1 - group (local_port field is neglected even if set)" access="OP" offset="0x0.0" size="0x0.1" />
	<field name="port_type" descr="For HCA supported only when indicated by PCAM \;0 - Network Port\;1 - Near-End Port (For Retimer/Gearbox - Host side)\;2 - Internal IC LR Port \;3 - Far-End Port (For Retimer/Gearbox - Line side)\;Other values are reserved." access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="group" descr="Group number" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. Determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number\;3 - Out of band / PCI" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="version" descr="0 - 16nm products" access="RO" offset="0x0.24" size="0x0.4" />
	<field name="status" descr="0 - Invalid\;1 - Valid" access="RO" offset="0x0.28" size="0x0.4" />
	<field name="group_of_port" descr="The corresponding group number for the local_port" access="RW" offset="0x4.4" size="0x0.4" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x4.8" size="0x0.4" />
	<field name="ports_mapping_of_group" descr="A bit map of all available local ports in the system (each bit represents a local port). \;The corresponding bits which represent the local ports for the specific group in the group field, are set to &apos;1&apos;.\;If set to &apos;0&apos; - not in that specific group or not available.\;Bit 0 - local_port 1\;Bit 1 - local_port 2\;..." access="RW" high_bound="8" low_bound="0" offset="0x8.0" size="0x24.0" />
</node>

<node name="pguid_reg_ext" descr="" size="0x60.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="local_port number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="sys_guid" descr="System GUID.\;Only 64 LSB are used. 64 MSB are reserved." access="RO" high_bound="3" low_bound="0" offset="0x4.0" size="0x10.0" />
	<field name="node_guid" descr="Node GUID.\;Only 64 LSB are used. 64 MSB are reserved." access="RO" high_bound="3" low_bound="0" offset="0x14.0" size="0x10.0" />
	<field name="port_guid" descr="Port GUID.\;Only 64 LSB are used. 64 MSB are reserved." access="RO" high_bound="3" low_bound="0" offset="0x24.0" size="0x10.0" />
	<field name="allocated_guid" descr="Allocated GUID.\;Only 64 LSB are used. 64 MSB are reserved." access="RO" high_bound="3" low_bound="0" offset="0x34.0" size="0x10.0" />
</node>

<node name="phbr_ext" descr="" size="0x1c.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="local_port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="hist_id" descr="Histogram id to bind\;from 0 to cap_max_port_hist_id - 1" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="hist_type" descr="Histogram Type.\;See Table 1983, &quot;Histogram Types,&quot; on page 2335" access="RW" offset="0x8.0" size="0x0.16" />
	<field name="mode" descr="Mode:\;0: Linear\;1: Exponential" access="RW" enum="Linear=0x0,Exponential=0x1" offset="0x8.28" size="0x0.3" />
	<field name="first_bin_thr" descr="First Bin Threshold.\;All values that are under this threshold will be counted in the first bin.\;Units according to the units of the hist_type.\;Range 1...(2^28) - 1" access="RW" offset="0xC.0" size="0x4.0" />
	<field name="bin_size" descr="Bin Size.\;bin_0 size will be first_bin_thr.\;If mode = 0, the size of bin 1-8 will be bin_size.\;If mode = 1, the size of bin_i will be 2^(i-1) * bin_size when 1 &lt; i &lt; 8.\;Range 1...(2^25) - 1\;Units according to the units of the hist_type" access="RW" offset="0x10.0" size="0x4.0" />
	<field name="hist_repeat_num" descr="Histogram Repeat Number.\;When this field equal to 0 the histogram will stop.\;When this field equal to 0xffffff the histogram will run infinite times.\;On other values the histogram will run hist_repeat_num times.\;Range 1...2^24 - 1" access="RW" offset="0x14.0" size="0x0.24" />
	<field name="sample_time" descr="Sample time interval. \;Allowed range for Switch-IB and Spectrum:\;time = 2^sample_time * 128nSec\;sample_time range is 0..cap_max_sample_time-1" access="RW" offset="0x18.0" size="0x0.6" />
</node>

<node name="phrr_reg_ext" descr="" size="0x68.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="local_port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="clr" descr="Clear:\;1: Clear the data in the histogram agent" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="hist_id" descr="see Table  1981, &quot;PHBR - Port Histogram Binding Register Layout,&quot; on page  2334" access="INDEX" offset="0x4.0" size="0x0.8" />
	<field name="bin" descr="Value of bin \;Units according to the units of the hist_type which is used for the hist_id" subnode="uint64" access="RO" high_bound="9" low_bound="0" offset="0x10.0" size="0x50.0" />
	<field name="min_watermark" descr="Min value while the histogram was working." access="RO" offset="0x60.0" size="0x4.0" />
	<field name="max_watermark" descr="Max value while the histogram was working." access="RO" offset="0x64.0" size="0x4.0" />
</node>

<node name="phys_layer_cntrs_ext" descr="" size="0xf8.0" >
	<field name="time_since_last_clear_high" descr="The time passed since the last counters clear event in msec." access="RO" offset="0x0.0" size="0x4.0" />
	<field name="time_since_last_clear_low" descr="The time passed since the last counters clear event in msec." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="symbol_errors_high" descr="Perf.PortCounters(SymbolErrorCounter) = Perf.PortCounters(UnknownSymbol)" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="symbol_errors_low" descr="Perf.PortCounters(SymbolErrorCounter) = Perf.PortCounters(UnknownSymbol)" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="sync_headers_errors_high" descr="Perf.PortExtendedSpeedsCounters(SynchHeaderErrorCounter)" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="sync_headers_errors_low" descr="Perf.PortExtendedSpeedsCounters(SynchHeaderErrorCounter)" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane0_high" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane0Counter) / BIP error counter, lane 0\;In PRBS test mode, indicates the number of PRBS errors\;on lane 0" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane0_low" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane0Counter) / BIP error counter, lane 0\;In PRBS test mode, indicates the number of PRBS errors\;on lane 0" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane1_high" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane1Counter) / BIP error counter, lane 1\;In PRBS test mode, indicates the number of PRBS errors\;on lane 1" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane1_low" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane1Counter) / BIP error counter, lane 1\;In PRBS test mode, indicates the number of PRBS errors\;on lane 1" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane2_high" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane2Counter) / BIP error counter, lane 2\;In PRBS test mode, indicates the number of PRBS errors\;on lane 2" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane2_low" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane2Counter) / BIP error counter, lane 2\;In PRBS test mode, indicates the number of PRBS errors\;on lane 2" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane3_high" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane3Counter) / BIP error counter, lane 3\;In PRBS test mode, indicates the number of PRBS errors\;on lane 3" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="edpl_bip_errors_lane3_low" descr="Perf.PortExtendedSpeedsCounters(ErrorDetectionPerLane3Counter) / BIP error counter, lane 3\;In PRBS test mode, indicates the number of PRBS errors\;on lane 3" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane0_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane0)" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane0_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane0)" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane1_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane1)" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane1_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane1)" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane2_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane2)" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane2_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane2)" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane3_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane3)" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="fc_fec_corrected_blocks_lane3_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane3)" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane0_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane0)" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane0_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane0)" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane1_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane1)" access="RO" offset="0x60.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane1_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane1)" access="RO" offset="0x64.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane2_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane2)" access="RO" offset="0x68.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane2_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane2)" access="RO" offset="0x6C.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane3_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane3)" access="RO" offset="0x70.0" size="0x4.0" />
	<field name="fc_fec_uncorrectable_blocks_lane3_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrectableBlockCounterLane3)" access="RO" offset="0x74.0" size="0x4.0" />
	<field name="rs_fec_corrected_blocks_high" descr="Perf.PortExtendedSpeedsCounters(FECCorrecableBlockCounter)" access="RO" offset="0x78.0" size="0x4.0" />
	<field name="rs_fec_corrected_blocks_low" descr="Perf.PortExtendedSpeedsCounters(FECCorrecableBlockCounter)" access="RO" offset="0x7C.0" size="0x4.0" />
	<field name="rs_fec_uncorrectable_blocks_high" descr="Perf.PortExtendedSpeedsCounters(FEUncorrecableBlockCounter)" access="RO" offset="0x80.0" size="0x4.0" />
	<field name="rs_fec_uncorrectable_blocks_low" descr="Perf.PortExtendedSpeedsCounters(FEUncorrecableBlockCounter)" access="RO" offset="0x84.0" size="0x4.0" />
	<field name="rs_fec_no_errors_blocks_high" descr="The number of RS-FEC blocks received that had no errors.\;Note: Total rs_fec blocks received = rs_fec_corrected_blocks + rs_fec_uncorrectable_blocks + rs_fec_no_errors_blocks" access="RO" offset="0x88.0" size="0x4.0" />
	<field name="rs_fec_no_errors_blocks_low" descr="The number of RS-FEC blocks received that had no errors.\;Note: Total rs_fec blocks received = rs_fec_corrected_blocks + rs_fec_uncorrectable_blocks + rs_fec_no_errors_blocks" access="RO" offset="0x8C.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_total_high" descr="Perf.PortExtendedSpeedCounters(PortFECCorrectedSymbolCounter)" access="RO" offset="0x98.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_total_low" descr="Perf.PortExtendedSpeedCounters(PortFECCorrectedSymbolCounter)" access="RO" offset="0x9C.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane0_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane0)" access="RO" offset="0xA0.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane0_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane0)" access="RO" offset="0xA4.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane1_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane1)" access="RO" offset="0xA8.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane1_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane1)" access="RO" offset="0xAC.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane2_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane2)" access="RO" offset="0xB0.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane2_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane2)" access="RO" offset="0xB4.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane3_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane3)" access="RO" offset="0xB8.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane3_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane3)" access="RO" offset="0xBC.0" size="0x4.0" />
	<field name="link_down_events" descr="Perf.PortCounters(LinkDownedCounter)" access="RO" offset="0xC0.0" size="0x4.0" />
	<field name="successful_recovery_events" descr="Perf.PortCounters(LinkErrorRecoveryCounter)\;Note: This counter is valid only for IB." access="RO" offset="0xC4.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane4_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane4)" access="RO" offset="0xC8.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane4_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane4)" access="RO" offset="0xCC.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane5_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane5)" access="RO" offset="0xD0.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane5_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane5)" access="RO" offset="0xD4.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane6_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane6)" access="RO" offset="0xD8.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane6_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane6)" access="RO" offset="0xDC.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane7_high" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane7)" access="RO" offset="0xE0.0" size="0x4.0" />
	<field name="rs_fec_corrected_symbols_lane7_low" descr="Perf.PortExtendedSpeedCounters(FECCorrectedSymbolCounterLane7)" access="RO" offset="0xE4.0" size="0x4.0" />
</node>

<node name="phys_layer_stat_cntrs_ext" descr="" size="0xf8.0" >
	<field name="time_since_last_clear_high" descr="The time passed since the last counters clear event in msec.\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="time_since_last_clear_low" descr="The time passed since the last counters clear event in msec.\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="phy_received_bits_high" descr="This counter provides information on the total amount of traffic (bits) received.\;" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="phy_received_bits_low" descr="This counter provides information on the total amount of traffic (bits) received.\;" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="phy_symbol_errors_high" descr="This counter provides information on error bits that were not corrected by phy correction mechanisms. (FEC + PLR)\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="phy_symbol_errors_low" descr="This counter provides information on error bits that were not corrected by phy correction mechanisms. (FEC + PLR)\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="phy_corrected_bits_high" descr="Corrected bits by FEC engine. \;" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="phy_corrected_bits_low" descr="Corrected bits by FEC engine. \;" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="phy_raw_errors_lane0_high" descr="This counter provides information on error bits that were identified on lane 0. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 0\;\;\;" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="phy_raw_errors_lane0_low" descr="This counter provides information on error bits that were identified on lane 0. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 0\;\;\;" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="phy_raw_errors_lane1_high" descr="This counter provides information on error bits that were identified on lane 1. \;When FEC is enabled this induction corresponds to corrected errors\;In PRBS test mode, indicates the number of PRBS errors\;on lane 1\;\;" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="phy_raw_errors_lane1_low" descr="This counter provides information on error bits that were identified on lane 1. \;When FEC is enabled this induction corresponds to corrected errors\;In PRBS test mode, indicates the number of PRBS errors\;on lane 1\;\;" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="phy_raw_errors_lane2_high" descr="This counter provides information on error bits that were identified on lane 2. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 2\;\;\;\;" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="phy_raw_errors_lane2_low" descr="This counter provides information on error bits that were identified on lane 2. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 2\;\;\;\;" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="phy_raw_errors_lane3_high" descr="This counter provides information on error bits that were identified on lane 3. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 3\;" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="phy_raw_errors_lane3_low" descr="This counter provides information on error bits that were identified on lane 3. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 3\;" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="phy_raw_errors_lane4_high" descr="This counter provides information on error bits that were identified on lane 4. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 4\;" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="phy_raw_errors_lane4_low" descr="This counter provides information on error bits that were identified on lane 4. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 4\;" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="phy_raw_errors_lane5_high" descr="This counter provides information on error bits that were identified on lane 5. \;When FEC is enabled this induction corresponds to corrected errors\;In PRBS test mode, indicates the number of PRBS errors\;on lane 5\;" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="phy_raw_errors_lane5_low" descr="This counter provides information on error bits that were identified on lane 5. \;When FEC is enabled this induction corresponds to corrected errors\;In PRBS test mode, indicates the number of PRBS errors\;on lane 5\;" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="phy_raw_errors_lane6_high" descr="This counter provides information on error bits that were identified on lane 6. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 6" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="phy_raw_errors_lane6_low" descr="This counter provides information on error bits that were identified on lane 6. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 6" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="phy_raw_errors_lane7_high" descr="This counter provides information on error bits that were identified on lane 7. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 7" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="phy_raw_errors_lane7_low" descr="This counter provides information on error bits that were identified on lane 7. \;When FEC is enabled this induction corresponds to corrected errors.\;In PRBS test mode, indicates the number of PRBS errors\;on lane 7" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="raw_ber_coef" descr="Raw_BER = raw_ber_coef  *10^(-raw_ber_magnitude)\;" access="RO" offset="0x60.0" size="0x0.4" />
	<field name="raw_ber_magnitude" descr="Raw_BER = raw_ber_coef  *10^(-raw_ber_magnitude)\;" access="RO" offset="0x60.8" size="0x0.8" />
	<field name="fc_zero_hist" descr="Valid for links with RS FEC histograms only.\;First histogram bin with value of 0 while all higher bins are only with 0 value as well.\;0 - No histogram active / N/A value" access="RO" offset="0x60.16" size="0x0.10" />
	<field name="effective_ber_coef" descr="effective_fec_BER = effective_fec_ber_coef *10^(-effective_fec_ber_magnitude)\;" access="RO" offset="0x64.0" size="0x0.4" />
	<field name="effective_ber_magnitude" descr="effective_fec_BER = effective_fec_ber_coef *10^(-effective_fec_ber_magnitude)\;" access="RO" offset="0x64.8" size="0x0.8" />
	<field name="estimated_effective_ber_coef" descr="estimated_effective_fec_BER = estimated_effective_fec_ber_coef estimated_effective_ber_coef_float*10^(-effective_fec_ber_magnitude)\;" access="RO" offset="0x64.16" size="0x0.4" />
	<field name="estimated_effective_ber_coef_float" descr="estimated_effective_fec_BER = estimated_effective_fec_ber_coef estimated_effective_ber_coef_float*10^(-effective_fec_ber_magnitude)\;" access="RO" offset="0x64.20" size="0x0.4" />
	<field name="estimated_effective_ber_magnitude" descr="estimated_effective_fec_BER = estimated_effective_fec_ber_coef estimated_effective_ber_coef_float*10^(-effective_fec_ber_magnitude)\;" access="RO" offset="0x64.24" size="0x0.8" />
	<field name="symbol_ber_coef" descr="Symbol_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x68.0" size="0x0.4" />
	<field name="symbol_ber_magnitude" descr="Symbol_BER = symbol_ber_coef*10^(-symbol_ber_magnitude)" access="RO" offset="0x68.8" size="0x0.8" />
	<field name="phy_effective_errors_high" descr="This counter provides information on error bits that were not corrected by FEC correction algorithm or that FEC is not active.\;" access="RO" offset="0x7C.0" size="0x4.0" />
	<field name="phy_effective_errors_low" descr="This counter provides information on error bits that were not corrected by FEC correction algorithm or that FEC is not active.\;" access="RO" offset="0x80.0" size="0x4.0" />
</node>

<node name="pifr_reg_ext" descr="" size="0x60.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Egress Local port number.\;Note: Port isolation is not supported to \ from port 0 (i.e CPU port)." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="table_id" descr="Table ID:\;0: GLOBAL table. Note that IGCR.pisbo affects the behavior of this table\;1: BRIDGE_ONLY table\;Supported only from spectrum-3" access="INDEX" offset="0x0.28" size="0x0.4" />
	<field name="port_filter" descr="Ingress Port filter bitmask\;0: Do not filter (default value for all local_port).\;1: Filter - Packets coming from port_filter&lt;i&gt; will not be transmitted to port local_port. \;All LAG ports must share the same configuration.\;Refer to the relevant section for port numbering scheme." access="RW" high_bound="7" low_bound="0" offset="0x20.0" size="0x20.0" />
	<field name="port_filter_update_en" descr="port_filter_update_en bitmask, see port_filter\;When port_filter_update_en&lt;i&gt; set, the filter value for local port i is updated according to port_filter&lt;i&gt;.\;When port_filter_update_en&lt;i&gt; is cleared, the filter value for local port i maintains its current value." access="WO" high_bound="7" low_bound="0" offset="0x40.0" size="0x20.0" />
</node>

<node name="pifr_v2_ext" descr="" size="0x120.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Egress Local port number.\;Note: Port isolation is not supported to \ from port 0 (i.e CPU port)." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="table_id" descr="Supported only from spectrum-3\;Table ID:\;0: GLOBAL_table - note that IGCR.pisbo affects the behavior of this table\;1: BRIDGE_ONLY" access="INDEX" enum="GLOBAL_table=0x0,BRIDGE_ONLY=0x1" offset="0x0.28" size="0x0.4" />
	<field name="port_filter" descr="Ingress Port filter bitmask\;0: Do not filter (default value for all local_port).\;1: Filter - Packets coming from port_filter&lt;i&gt; will not be transmitted to port local_port. \;All LAG ports must share the same configuration.\;Refer to the relevant section for port numbering scheme." access="RW" high_bound="31" low_bound="0" offset="0x20.0" size="0x80.0" />
	<field name="port_filter_update_en" descr="port_filter_update_en bitmask, see port_filter\;When port_filter_update_en&lt;i&gt; set, the filter value for local port i is updated according to port_filter&lt;i&gt;.\;When port_filter_update_en&lt;i&gt; is cleared, the filter value for local port i maintains its current value." access="WO" high_bound="31" low_bound="0" offset="0xA0.0" size="0x80.0" />
</node>

<node name="pipg_reg_ext" descr="" size="0x8.0" >
	<field name="dic1_1g" descr="This field is relevant for Spectrum devices only.\;In case this field is set to &apos;1&apos; and the operational speed is 1000BASE-X or SGMII, it will enable DIC1 for an average IPG size of 12 Bytes.\;\;" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="dic1_1g_write_en" descr="This field is relevant for Spectrum devices only.\;&apos;dic1_1g&apos; field write enable.\;Relevant for set operation only, while this bit is set to &apos;0&apos;- ignore &apos;dic1_1g&apos;." access="WO" offset="0x0.1" size="0x0.1" />
	<field name="ipg_oper" descr="Inter Packet Gap operational value in ipg_res_cap Bytes units.\;For example, in case of &apos;ipg_oper&apos; =3 and &apos;ipg_res_cap&apos;=0: 4 Bytes- the IPG operational size is 12 Bytes (3*4).\;If there is a mismatch between the operational IPG capabilities and the &apos;ipg&apos; field, &apos;ipg_oper&apos; will be configured to the IPG default value of the device.\;\;Note: Supported only when indicated by PCAM Bit 92: PIPG.ipg_oper_ipg_cap_idx_supported." access="RO" offset="0x0.2" size="0x0.8" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="ipg" descr="The Inter Packet Gap admin value for the port in &apos;ipg_res_cap&apos; Bytes units.\;For example, in case of &apos;ipg&apos; =4 and &apos;ipg_res_cap&apos;=0: 4 Bytes -the IPG size that will be configured will be 16 Bytes (4*4)\;\;Valid values for configuring the IPG field should meet to following two conditions:\;1. &apos;ipg&apos; = &apos;ipg_min_cap&apos; + &apos;ipg_res_cap&apos;*N. For N= 0,1,2, ..\;2. &apos;ipg&apos; must be in the range of ipg_min_cap and ipg_max_cap.\;\;The configured &apos;ipg&apos; value will take effect only after link negotiation and if there is no mismatch between the operational IPG capabilities and the configured value." access="RW" offset="0x4.2" size="0x0.8" />
	<field name="ipg_max_cap" descr="Maximum Inter Packet Gap supported on the port in &apos;ipg_res_cap&apos; bytes unit.\;The return value will be according the speed selected in the &apos;ipg_cap_index&quot;." access="RO" offset="0x4.10" size="0x0.8" />
	<field name="ipg_min_cap" descr="Minimum Inter Packet Gap supported on the port in &apos;ipg_res_cap&apos; bytes unit. \;The return value will be according the speed selected in the &apos;ipg_cap_index&quot;." access="RO" offset="0x4.18" size="0x0.4" />
	<field name="ipg_cap_index" descr="The &apos;ipg_min_cap&apos; and &apos;ipg_max_cap&apos; return value will be according to the selected speed index: \;\;0: The Minimum/Maximum capability of the device (Regardless of the operational link speed).\;1: SGMII_100M\;2: 1000BASE-X / SGMII\;4: 5GBASE-R\;5: XFI / XAUI-1 // 10G\;6: XLAUI-4/XLPPI-4 // 40G \;7: 25GAUI-1/ 25GBASE-CR / KR \;8: 50GAUI-2 / LAUI-2/ 50GBASE-CR2/KR2 \;9: 50GAUI-1 /50GBASE-CR / KR\;10: CAUI-4 / 100GBASE-CR4 / KR4\;11: 100GAUI-2 / 100GBASE-CR2 / KR2 \;12: 100GAUI-1 / 100GBASE-CR / KR\;13: 200GAUI-4 / 200GBASE-CR4/KR4\;14: 200GAUI-2 / 200GBASE-CR2/KR2\;15: Reserved [internal] Placeholder for 200GAUI-1\;16: 400GAUI-8/ 400GBASE-CR8\;17: 400GAUI-4/ 400GBASE-CR4\;18: Reserved [internal] Placeholder for 400GAUI-2\;19: Reserved [internal] Placeholder for 400GAUI-1\;20: 800GAUI-8 / 800GBASE-CR8 / KR8\;32: SGMII_10M\;\;Note: Supported only when indicated by PCAM Bit 92: PIPG.ipg_oper_ipg_cap_idx_supported." access="INDEX" offset="0x4.22" size="0x0.6" />
	<field name="ipg_res_cap" descr="IPG configurable resolution of the device in Bytes granularity.\;0: bytes_4x\;1: bytes_8x" access="RO" enum="bytes_4x=0x0,bytes_8x=0x1" offset="0x4.28" size="0x0.1" />
</node>

<node name="plbf_reg_ext" descr="" size="0x8.0" >
	<field name="lbf_mode" descr="Loop-back filter mode:\;0: Do not update loop-back filter mode\;1: Disable Bridge loop-back filtering\;2: Enable Bridge loop-back filtering (default)" access="RW" offset="0x0.0" size="0x0.3" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
</node>

<node name="pldc_ext" descr="" size="0x14.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="clr" descr="Clear Counters\;0: Don&apos;t clear counters\;1: Clear counters" access="OP" offset="0x0.31" size="0x0.1" />
	<field name="link_up_delay_cnt" descr="Counts the number of times that link up indication was delayed (ignored) due to timer not expired" access="RO" offset="0x4.0" size="0x0.16" />
	<field name="link_down_delay_cnt" descr="Counts the number of times that link down indication was delayed (ignored) due to timer not expired" access="RO" offset="0x8.0" size="0x0.16" />
	<field name="timer_expired_cnt" descr="Counts the number of times that timer expired (both for up and down events) which result in sending link indication" access="RO" offset="0xC.0" size="0x0.16" />
	<field name="timer_cancel_cnt" descr="Counts the number of times that timer was canceled to avoid sending redundant event (up or down)." access="RO" offset="0x10.0" size="0x0.16" />
</node>

<node name="pldt_ext" descr="" size="0xc.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="link_up_delay" descr="Link up delay. Units of 10 msec.\;Default value: 0 msec (link up delay is disabled. Link change indication will be sent immediately).\;Valid values: 0 ms - 5000 ms" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="link_down_delay" descr="Link down delay. Units of 10 msec.\;Default value: 0 msec (link down delay is disabled. Link change indication will be sent immediately).\;Valid values: 0 ms - 5000 ms" access="RW" offset="0x8.0" size="0x0.16" />
</node>

<node name="plib_reg_ext" descr="" size="0x10.0" >
	<field name="ib_port" descr="In IB port: InfiniBand port remapping for local_port\;In Ethernet port: Label port remapping for local_port\;Note: ib_port number can only be updated when a port admin state is DISABLED." access="RW" offset="0x0.0" size="0x0.10" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="split_num" descr="Valid only for Ethernet Switches. \;Label split mapping for local_port" access="RW" offset="0x4.0" size="0x0.4" />
</node>

<node name="plibdb_ext" descr="" size="0x10.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="ib_port_1x" descr="IB port remapping for local port when port is configured in width of 1x.\;Note: This value is theoretical and not the actual configuration\;Range: 1.. cap_max_switch_ports\;Value of 0 means port is unmapped." access="RO" offset="0x4.0" size="0x0.10" />
	<field name="ib_port_2x" descr="IB port remapping for local port when port is configured in width of 2x.\;Note: This value is theoretical and not the actual configuration\;Range: 1.. cap_max_switch_ports\;Value of 0 means port is unmapped" access="RO" offset="0x8.0" size="0x0.10" />
	<field name="ib_port_4x" descr="IB port remapping for local port when port is configured in width of 4x.\;Note: This value is theoretical and not the actual configuration\;Range: 1.. cap_max_switch_ports\;Value of 0 means port is unmapped" access="RO" offset="0xC.0" size="0x0.10" />
</node>

<node name="pllp_reg_ext" descr="" size="0x14.0" >
	<field name="label_port" descr="Front panel label of the port\;Note:\;PLIB.ib_port provides IB port in IB and label_port in Eth\;MOLP provides the 16bit mirror header value" access="RO" offset="0x0.0" size="0x0.10" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="split_num" descr="Port split mapping for local_port.\;The position of this local port within each splitted port.\;When no split: split_num should be 0\;When split to 2: split_num should be 0,1\;When split to 4: split_num should be 0   3\;When split to 8: split_num should be 0   7\;Split to 8 exists only for ETH" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="ipil_num" descr="Inter port in Label number.\;gives mapping of the basic port unit  inside the label (cage), From the lowest lanes of the module to the highest.\;e.g Label of 8x lanes, with 2 ipil\;ipil 1 - will be port mapped to lanes 1-4\;ipil 2 - will be port mapped to lanes 5-8\;\;When ipil_stat is 0 (no ipil): ipil_num should be 0\;When ipil_stat is 1: ipil_num should be 1,2\;When ipil_stat is 2: ipil_num should be 1   4\;When ipil_stat is 3: ipil_num should be 1   8" access="RO" offset="0x4.8" size="0x0.4" />
	<field name="split_stat" descr="Defines the IPIL split. The value is by how much to split each IPIL\;The local_port status is:\;0: no split\;1: split to 2\;2: split to 4\;3: split to 8\;" access="RO" offset="0x4.16" size="0x0.4" />
	<field name="ipil_stat" descr="Inter port in Label status.\;Number of basic port units inside the label (cage).\;0: 1 inter port in label\;1: 2 inter port in label\;2: 4 inter port in label\;3: 8 inter port in label" access="RO" offset="0x4.24" size="0x0.4" />
	<field name="slot_num" descr="Valid only for Ethernet Switches. \;Slot_number mapping for local_port" access="RO" offset="0x8.0" size="0x0.4" />
	<field name="conn_type" descr="Connectivity Type\;0: N/A\;1: not-wired \;2: wire to front panel\;3: wired to Switch\;4: wired to GPU\;5: wired to NIC\;\;Describes the internal wiring on the port.\;Supported from Quantum-3 and above" access="RO" offset="0xC.0" size="0x0.3" />
	<field name="rmt_id" descr="Remote ASIC Id\;Reserved when conn_type = 0/1/2\;Supported from Quantum-3 and above" access="RO" offset="0xC.8" size="0x0.8" />
	<field name="is_fnm" descr="0: Mission port\;1: FNM port\;Supported from Quantum-3 and above" access="RO" offset="0xC.16" size="0x0.1" />
	<field name="maf" descr="Mission Port as FNM \;0: Mission port\;1: Mission port treated as FNM port.\;\;When set, the port shall be configured as a FNM port. \;Reserved when is_fnm is set. \;Note: This configuration does not change port type as stated in is_fnm field. \;Supported from Quantum-3 and above." access="RO" offset="0xC.17" size="0x0.1" />
	<field name="protocol" descr="0: N/A (when FW has no info)\;1: ETH (for Eth devices)\;2: IB\;3: NVLink\;4: IBg2Eth\;Supported from Quantum-3 and above\;" access="RO" offset="0x10.0" size="0x0.3" />
</node>

<node name="pltc_reg_ext" descr="" size="0x10.0" >
	<field name="lane_mask" descr="for set operation, lane bitmask\;for query operation, one-hot key" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0: Local_port_number\;1: IB_port_number" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="precoding_cap_mask" descr="0x0 - no tx precoding available / no override capabilty\;\;Bit 0- tx precoding override possible via local_tx_precoding_admin field\;Bit 1- rx precoding override possible via local_rx_precoding_admin field" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="local_tx_precoding_admin" descr="0 - auto\;1 - force Tx precoding\;2 - force Tx without precoding" access="RW" offset="0x8.0" size="0x0.2" />
	<field name="local_rx_precoding_admin" descr="Rx configuration override for 100g Pam4 per lane protocols.\;0 - auto\;1 - Rx precoding enabled. \;if negotiated, request Tx precoding from peer.\;2 - Rx precoding disabled. \;if negotiated, request no Tx precoding from peer" access="RW" offset="0x8.16" size="0x0.2" />
	<field name="local_tx_precoding_oper" descr="0 - unknown / no active link\;1 - Tx precoding enabled.\;2 - Tx precoding disabled." access="RO" offset="0xC.0" size="0x0.2" />
	<field name="local_rx_precoding_oper" descr="Rx precoding operational mode\;0 - unknown / no active link\;1 - Rx precoding enabled. \;2 - Rx precoding disabled." access="RO" offset="0xC.16" size="0x0.2" />
</node>

<node name="pmaos_reg_ext" descr="" size="0x10.0" >
	<field name="oper_status" descr="Module state (reserved while admin_status is disabled):\;0: initializing\;1: plugged_enabled\;2: unplugged\;3: module_plugged_with_error - (details in error_type).\;5: unknown" access="RO" enum="initializing=0x0,plugged_enabled=0x1,unplugged=0x2,module_plugged_with_error=0x3,unknown=0x5" offset="0x0.0" size="0x0.4" />
	<field name="admin_status" descr="Module administrative state (the desired state of the module):\;1: enabled\;2: disabled_by_configuration\;3: enabled_once - if the module is active and then unplugged, or module experienced an error event, the operational status should go to &quot;disabled&quot; and can only be enabled upon explicit enable command.\;\;Note - To disable a module, all ports associated with the port must be disabled first.\;" access="RW" enum="enabled=0x1,disabled_by_configuration=0x2,enabled_once=0x3" offset="0x0.8" size="0x0.4" />
	<field name="module" descr="Module number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA\;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="rst" descr="Module Reset toggle\;NOTE: setting reset while module is plugged-in will result in transition of oper_status to initialization." access="OP" offset="0x0.31" size="0x0.1" />
	<field name="e" descr="Event Generation on operational state change:\;0: Do_not_generate_event\;1: Generate_Event\;2: Generate_Single_Event\;Not supported by secondary ASICs." access="RW" enum="Do_not_generate_event=0x0,Generate_Event=0x1,Generate_Single_Event=0x2" offset="0x4.0" size="0x0.2" />
	<field name="error_type" descr="Module error details:\;0x0: Power_Budget_Exceeded\;0x1: Long_Range_for_non_MLNX_cable_or_module\;0x2: Bus_stuck - (I2C Data or clock shorted)\;0x3: bad_or_unsupported_EEPROM\;0x4: Enforce_part_number_list\;0x5: unsupported_cable\;0x6: High_Temperature\;0x7: bad_cable - (Module/Cable is shorted)\;0x8: PMD_type_is_not_enabled - (see PMTPS)\;0xc: pcie_system_power_slot_Exceeded\;\;[DWIP] 0xf: Boot_error\;[DWIP] 0x10: Recovery_error\;[DWIP] 0x11: Submodule_failure\;Valid only when oper_status = 4&apos;b0011" access="RO" enum="Power_Budget_Exceeded=0x0,Long_Range_for_non_MLNX_cable_or_module=0x1,Bus_stuck=0x2,bad_or_unsupported_EEPROM=0x3,Enforce_part_number_list=0x4,unsupported_cable=0x5,High_Temperature=0x6,bad_cable=0x7,PMD_type_is_not_enabled=0x8,pcie_system_power_slot_Exceeded=0xc" offset="0x4.8" size="0x0.5" />
	<field name="operational_notification" descr="This notification can occur only if module passed initialization process\;0x0: No notifications.\;0x1: Speed degradation - the module is not enabled in its full speed due to incompatible transceiver/cable \;Valid only when oper_status = 4&apos;b0001." access="RO" offset="0x4.16" size="0x0.4" />
	<field name="rev_incompatible" descr="When in multi ASIC module sharing systems,\;This flag will be asserted in case primary and secondary FW versions are not compatible." access="RO" offset="0x4.28" size="0x0.1" />
	<field name="secondary" descr="Indicates whether the ASIC serves as a the modules secondary (=1) or primary (=0) device." access="RO" offset="0x4.29" size="0x0.1" />
	<field name="ee" descr="Event update enable. If this bit is set, event generation will be updated based on the e field. Only relevant on Set operations.\;Not supported by secondary ASICs." access="WO" offset="0x4.30" size="0x0.1" />
	<field name="ase" descr="Admin state update enable. If this bit is set, admin state will be updated based on admin_state field. Only relevant on Set() operations." access="WO" offset="0x4.31" size="0x0.1" />
</node>

<node name="pmcr_reg_ext" descr="" size="0x20.0" >
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="error_code_response" descr="Valid for CMIS modules.\;error code response on override values.\;0x0: ConfigUndefined\;0x1: ConfigSuccess\;0x2: ConfigRejected\;0x3: ConfigRejectedInvalidAppSel\;0x4: ConfigRejectedInvalidDataPath\;0x5: ConfigRejectedInvalidSI\;0x6: ConfigRejectedLanesInUse\;0x7: ConfigRejectedPartialDataPath\;0xC: ConfigInProgress" access="RO" enum="ConfigUndefined=0x0,ConfigSuccess=0x1,ConfigRejected=0x2,ConfigRejectedInvalidAppSel=0x3,ConfigRejectedInvalidDataPath=0x4,ConfigRejectedInvalidSI=0x5,ConfigRejectedLanesInUse=0x6,ConfigRejectedPartialDataPath=0x7,ConfigInProgress=0xc" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="cs_sel" descr="Valid only for CMIS (QSFP-DD / SFP-DD / OSFP) compliant modules.\;If Control Set 1 not implemented or non CMIS module ignore field.\;0 - Auto (default)\;1 - Use Control Set 0\;2 - Use Control Set 1" access="INDEX" offset="0x0.24" size="0x0.2" />
	<field name="cdr_override_cntl" descr="Module CDR override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - Override" access="RW" offset="0x4.0" size="0x0.2" />
	<field name="cdr_override_cap" descr="Module TX and RX override control capability.\;Bit 0 - RX CDR control is possible\;Bit 0 - TX CDR control is possible" access="RO" offset="0x4.2" size="0x0.2" />
	<field name="cdr_override_value" descr="Valid only in case CDR is configured to override mode by cdr_override_cntl: \;0 - RX OFF, TX OFF\;1 - RX ON , TX OFF\;2 - RX OFF, TX ON\;3 - RX ON, TX ON" access="RW" offset="0x4.8" size="0x0.4" />
	<field name="tx_disable_override_cntl" descr="In HCA, valid based on PCAM feature capabilities. \;Module TX_DISABLE override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - Override" access="RW" offset="0x4.16" size="0x0.2" />
	<field name="tx_disable_override_value" descr="Valid only in case TX_DISABLE is configured to override mode by tx_disable_override_cntl: \;0 - TX_DISABLE is low (i.e. TX is enabled)\;1 - TX_DISABLE is high (i.e. TX is disabled)" access="RW" offset="0x4.24" size="0x0.2" />
	<field name="rx_amp_override_cntl" descr="Module RX amplitude override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - Override" access="RW" offset="0x8.0" size="0x0.2" />
	<field name="rx_amp_override_cap" descr="Module rx_amp override control capability." access="RO" offset="0x8.2" size="0x0.1" />
	<field name="rx_amp_override_value" descr="Valid only in case RX amplitude is configured to override mode by rx_amp_override_cntl" access="RW" offset="0x8.8" size="0x0.4" />
	<field name="rx_amp_override_value_cap" descr="Module rx_amp bitmask of allowed values." access="RO" offset="0x8.12" size="0x0.4" />
	<field name="rx_los_override_cntl" descr="Valid only in case RX _LOS is configured to override mode by rx_los_override_admin" access="RW" offset="0x8.16" size="0x0.2" />
	<field name="rx_los_override_cap" descr="Module RX_LOS override control capability." access="RO" offset="0x8.18" size="0x0.1" />
	<field name="rx_los_override_admin" descr="Module RX _LOS override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - Override" access="RW" offset="0x8.24" size="0x0.2" />
	<field name="rx_emp_override_cntl" descr="Module RX emphasis override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - Override" access="RW" offset="0xC.0" size="0x0.2" />
	<field name="rx_emp_override_cap" descr="Module rx_emp override control capability." access="RO" offset="0xC.2" size="0x0.1" />
	<field name="rx_emp_override_value" descr="For CMIS modules, pre emphasis equalization value.\;For SFF modules, emphasis equalization value.\;Valid only in case RX emphasis is configured to override mode by rx_emp_override_cntl" access="RW" offset="0xC.8" size="0x0.4" />
	<field name="rx_emp_override_value_cap" descr="Module rx_emp max allowed values." access="RO" offset="0xC.12" size="0x0.4" />
	<field name="rx_post_emp_override_cntl" descr="Module RX emphasis override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - Override" access="RW" offset="0xC.16" size="0x0.2" />
	<field name="rx_post_emp_override_cap" descr="Module rx_post_emp override control capability." access="RO" offset="0xC.18" size="0x0.1" />
	<field name="rx_post_emp_override_value" descr="Valid for CMIS modules only.\;Post emphasis equalization value.\;Valid only in case RX emphasis is configured to override mode by rx_post_emp_override_cntl" access="RW" offset="0xC.24" size="0x0.4" />
	<field name="rx_post_emp_override_value_cap" descr="Module rx_post_emp max allowed values." access="RO" offset="0xC.28" size="0x0.4" />
	<field name="tx_equ_override_cntl" descr="Module TX equalization override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - Override" access="RW" offset="0x10.0" size="0x0.2" />
	<field name="tx_equ_override_cap" descr="Module TX equalization override control capability." access="RO" offset="0x10.2" size="0x0.1" />
	<field name="tx_equ_override_value" descr="Valid only in case TX equalization is configured to override mode by tx_equ_override_cntl." access="RW" offset="0x10.8" size="0x0.4" />
	<field name="tx_equ_override_value_cap" descr="Module tx_eq max allowed values." access="RO" offset="0x10.12" size="0x0.4" />
	<field name="tx_adaptive_override_value" descr="0 - disable adaptive Tx Equailization\;1 - enable adaptive Tx equalization\;Valid only in case TX equalization is configured to override mode by tx_adaptive_override_cntrl." access="RW" offset="0x10.17" size="0x0.1" />
	<field name="tx_adaptive_override_cntrl" descr="Module adaptive tuning flow override control:\;0 - Auto (default)\;1 - Keep the module configuration\;2 - override" access="RW" offset="0x10.24" size="0x0.2" />
	<field name="tx_adaptive_override_cap" descr="Module TX adaptive tuning flow override control capability." access="RO" offset="0x10.26" size="0x0.1" />
	<field name="ap_sel_override_cntrl" descr="Module Application select override control:\;0 - Auto (default)\;1 - Use Module&apos;s Default application value\;2 - Override" access="RW" offset="0x18.0" size="0x0.2" />
	<field name="ap_sel_override_value" descr="Application Select from the applications list advertised by the module. Up to 15 applications available.\;\;Values range from 1 to 15.\;\;Note: application can be set with default SI values defined by the module or SI defined by the host" access="RW" offset="0x18.8" size="0x0.4" />
</node>

<node name="pmecr_reg_ext" descr="" size="0x20.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="e" descr="Event generation on local port mapping change (PMLP):\;0: Do_not_generate_event\;1: Generate_Event \;2: Generate_Single_Event" access="RW" enum="Do_not_generate_event=0x0,Generate_Event=0x1,Generate_Single_Event=0x2" offset="0x4.0" size="0x0.2" />
	<field name="swi" descr="Software ignore.\;If this bit is set, the device shouldn&quot;t generate events in case of PMLP SET operation but only upon self local port mapping change (if applicable according to e configuration).\;This is supplementary configuration on top of e value." access="RW" offset="0x4.8" size="0x0.1" />
	<field name="eswi" descr="Software ignore enable bit.\;If this bit is set, the value if swi is used. \;If this bit is clear, the value of swi is ignored.\;Only relevant on Set operations." access="WO" offset="0x4.24" size="0x0.1" />
	<field name="ee" descr="Event update enable. If this bit is set, event generation will be updated based on the e field. Only relevant on Set operations." access="WO" offset="0x4.30" size="0x0.1" />
</node>

<node name="pmlp_reg_ext" descr="" size="0x40.0" >
	<field name="width" descr="0: unmap_local_port\;1: x1 - lane 0 is used\;2: x2 - lanes 0,1 are used\;4: x4 - lanes 0,1,2 and 3 are used\;8: x8 - lanes 0-7 are used\;\;Other - reserved" access="RW" enum="unmap_local_port=0x0,x1=0x1,x2=0x2,x4=0x4,x8=0x8" offset="0x0.0" size="0x0.8" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="m_lane_m" descr="Module lane mapping: \;0 - Local to Module mapping include module lanes mapping\;1 - Local to Module mapping only, without lane mapping\;\;When this operational is set (&apos;1&apos;), the following fields are ignored in SET command and should return the value &quot;0&quot; in GET commands: \;PMLP.rxtx\;PMLP.lane&lt;i&gt;_module_mapping.tx_lane\;PMLP.lane&lt;i&gt;_module_mapping.rx_lane" access="OP" offset="0x0.28" size="0x0.1" />
	<field name="rxtx" descr="Use different configuration for RX and TX.\;If this bit is cleared, the TX value is used for both RX and TX. When set, the RX configuration is taken from the separate field. This is to enable backward compatible implementation." access="RW" offset="0x0.31" size="0x0.1" />
	<field name="lane_module_mapping" descr="Module SerDes for lane &lt;i&gt;\;Up to 8 SerDeses in a module can be mapped to a local port." subnode="lane_2_module_mapping_ext" access="RW" high_bound="7" low_bound="0" offset="0x4.0" size="0x20.0" />
</node>

<node name="pmlpe_reg_ext" descr="" size="0x40.0" >
	<field name="width" descr="0: unmap_local_port\;1: x1 - lane 0 is used\;2: x2 - lanes 0,1 are used\;4: x4 - lanes 0,1,2 and 3 are used\;8: x8 - lanes 0-7 are used\;\;Other - reserved" access="RO" enum="unmap_local_port=0x0,x1=0x1,x2=0x2,x4=0x4,x8=0x8" offset="0x0.0" size="0x0.8" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="rxtx" descr="Use different configuration for RX and TX.\;If this bit is cleared, the TX value is used for both RX and TX. When set, the RX configuration is taken from the separate field. This is to enable backward compatible implementation." access="RO" offset="0x0.31" size="0x0.1" />
	<field name="lane_module_mapping" descr="Module SerDes for lane &lt;i&gt;\;Up to 8 SerDeses in a module can be mapped to a local port." subnode="lane_2_module_mapping_ext" access="RO" high_bound="7" low_bound="0" offset="0x4.0" size="0x20.0" />
</node>

<node name="pmmp_cmis_protocol_override_layout_ext" descr="" size="0xc.0" >
	<field name="host_electrical_compliance" descr="Host Electrical compliance code per CMIS byte 86 based on SFF-8024 table 4-5\;0 - unspecified\;1- 1000BASE - CX\;2 - XAUI\;3 - XFI\;4 - SFI\;5 - 25GAUI C2M\;6 - XLAUI C2M\;7 - XLPPI\;8 - LAUI-2 C2M\;9 - 50GAUI-2 C2M\;10 - 50GAUI-1 C2M\;11 - CAUI-4 C2M\;13 - 100GAUI-2 C2M\;15 - 200GAUI-4 C2M\;17 - 400GAUI-8 C2M\;20 - 25GBASE-CR CA-L\;21 - 25GBASE-CR CA-S\;22 - 25GBASE-CR CA-N\;23 - 40GBASE-CR4\;24 - 50GBASE-CR\;26 - 100GBASE-CR4\;27 - 100GBASE-CR2\;28 - 200GBASE-CR4\;29 - 400GBASE-CR8\;\;65 - CAUI-4 C2M no FEC\;66 - CAUI-4 C2M RS FEC\;67 - 50GBASE-CR2 RS FEC\;68 - 50GBASE-CR2 FC FEC\;69 - 50GBASE-CR2 no FEC" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="cable_breakout" descr="bits 7-0 as per byte 210 in CMIS, Near-End implementation\;Bit 0 - Channel 1 implementation \;Bit 1 - Channel 2 implementation\;Bit 2 - Channel 3 implementation\;Bit 3 - Channel 4 implementation\;Bit 4- Channel 5 implementation \;Bit 5- Channel 6 implementation\;Bit 6- Channel 7 implementation\;Bit 7- Channel 8 implementation\;\;for each channel:\;0 - Channel implemented \;1 - Channel not - implemented\;\;bit 12-8 as per byte 211 4-0 in CMIS, Far-End implementation\;" access="RW" offset="0x0.8" size="0x0.13" />
	<field name="media_type_encoding" descr="Byte 85 in CMIS. Media type encoding override\;0: undefined\;1: Optical_MMF\;2: Optical_SMF\;3: Passive_copper\;4: Active_cables\;5: BASE_T" access="RW" offset="0x0.21" size="0x0.4" />
	<field name="mod_pwrup_maxduration" descr="Module transition to high power maximum duration. coded according to table 8-29 of CMIS." access="RW" offset="0x0.28" size="0x0.4" />
	<field name="media_compliance" descr="Module media interface compliance for CMIS, per byte 87.\;Values taken according to module_media_type from SFF-8024:\;\;If MMF - SFF-8024 table 4-6, MM media interface codes\;If SMF - SFF-8024 table 4-7, SM media interface code\;\;If Active cable- SFF-8024 table 4-9 Active cable assembly code:\;0 -unspecified\;1 - Active cable assembly with BER &lt; 1e-12\;2 - Active cable assembly with BER &lt; 5e-5\;3 - Active cable assembly with BER &lt; 2.6e-4\;4 - Active cable assembly with BER &lt; 1e-6" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="module_media_type" descr="Module media type encoding, per byte 85 of CMIS:\;0 - undefined\;1 - MMF\;2 - SMF\;3 - passive Copper\;4 - Active cables\;5 - Base-T" access="RW" offset="0x4.8" size="0x0.8" />
	<field name="dp_tx_off_maxduration" descr="Data path turn off maximum duration. coded according to table 8-29 of CMIS 4.0." access="RW" offset="0x4.16" size="0x0.4" />
	<field name="dp_tx_on_maxduration" descr="Data path turn on maximum duration. coded according to table 8-29 of CMIS 4.0." access="RW" offset="0x4.20" size="0x0.4" />
	<field name="dp_init_maxduration" descr="Data path init maximum duration. coded according to table 8-29 of CMIS 4.0." access="RW" offset="0x4.28" size="0x0.4" />
	<field name="cmis_override_mask" descr="bitmask of override from CMIS protocol bytes page.\;Relevant only when Bit 9 is set in eeprom_override field.\;inverse polarity.\;0 - override\;1 - don&apos;t override\;\;Bit 0 - cable_breakout\;Bit 1 -host_electrical_compliance\;Bit 2 - module_media_type\;Bit 3 - media_compliance\;Bit 4 - mod_pwrup_maxDuration\;Bit 5 - dp_init_maxDuration\;Bit 6 - dp_tx_on_maxDuration\;Bit 7 - dp_tx_off_maxDuration\;Bit 9 - media_type_encoding" access="RW" offset="0x8.0" size="0x0.16" />
</node>

<node name="pmmp_qsfp_protocol_override_layout_ext" descr="" size="0xc.0" >
	<field name="ethernet_compliance_code" descr="Ethernet Compliance Codes bit mask (10/40G/100G)\;Override byte131 per SFF-8636:\;Bit 7 - Extended Specification Compliance valid\;Bit 6 - 10GBASE-LRM\;Bit 5 - 10GBASE-LR\;Bit 4 - 10GBASE-SR\;Bit 3 - 40GBASE-CR4\;Bit 2 - 40GBASE-SR4\;Bit 1 - 40GBASE-LR4\;Bit 0 - 40G Active Cable (XLPPI)" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="cable_breakout" descr="Override of byte113 per SFF-8636:\;Bit 6-4 (Far End):\;0 - Far end is unspecified\;1 - Cable with single far end with 4 channels implemented, or separable module with 4-channel connector\;2 - Cable with single far end with 2 channels implemented, or separable module with 2-channel connector\;3 - Cable with single far end with 1 channel implemented, or separable module with 1-channel connector\;4 - 4 far ends with 1 channel implemented in each (i.e. 4x1 break out)\;5 - 2 far ends with 2 channels implemented in each (i.e. 2x2 break out)\;6 - 2 far ends with 1 channel implemented in each (i.e. 2x1 break out)\;\;Bit 3-0 (Near End)\;Bit 0 - Channel 1 implementation \;Bit 1 - Channel 2 implementation\;Bit 2 - Channel 3 implementation\;Bit 3 - Channel 4 implementation\;\;for each channel:\;0 - Channel implemented \;1 - Channel not - implemented\;" access="RW" offset="0x0.8" size="0x0.8" />
	<field name="giga_ethernet_compliance_code" descr="Gigabit Ethernet Compliance Codes \;Override byte134 per SFF-8636:\;Bit 3 - 1000BASE-T\;Bit 2 - 1000BASE-CX\;Bit 1 - 1000BASE-LX\;Bit 0 - 1000BASE-SX" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="ext_ethernet_compliance_code" descr="Extended Specification Compliance Codes \;Override byte192 per SFF-8636:\;0 - Unspecified\;1 - 100G AOC (Active Optical Cable) or 25GAUI C2M AOC with FEC\;2 - 100GBASE-SR4 or 25GBASE-SR\;3 - 100GBASE-LR4 or 25GBASE-LR\;4 - 100GBASE-ER4 or 25GBASE-ER\;5 - 100GBASE-SR10\;6 - 100G CWDM4\;7 - 100G PSM4 Parallel SMF\;8 - 100G ACC (Active Copper Cable) or 25GAUI C2M ACC. with FEC\;11 - 100GBASE-CR4 or 25GBASE-CR CA-L\;12 - 25GBASE-CR CA-S\;13 - 25GBASE-CR CA-N\;16 - 40GBASE-ER4\;17 - 4 x 10GBASE-SR\;18 - 40G PSM4 Parallel SMF\;19 - G959.1 profile P1I1-2D1 (10709 MBd, 2km, 1310nm SM)\;20 - G959.1 profile P1S1-2D2 (10709 MBd, 40km, 1550nm SM)\;21 - G959.1 profile P1L1-2D2 (10709 MBd, 80km, 1550nm SM)\;22 - 10GBASE-T with SFI electrical interface\;23 - 100G CLR4\;24 - 100G AOC or 25GAUI C2M AOC. No FEC\;25 - 100G ACC or 25GAUI C2M ACC. No FEC" access="RW" offset="0x4.8" size="0x0.8" />
</node>

<node name="pmmp_reg_ext" descr="" size="0x2c.0" >
	<field name="sticky" descr="When set will keep eeprom_override values after plug out event" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="apply_im" descr="When set, override will be configured immediately without PMAOS toggle requirement if supported.\;for list supported overrides see eeprom_override description.\;supported if PCAM.bit 87 set" access="WO" offset="0x0.1" size="0x0.1" />
	<field name="module" descr="Module number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA\;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="eeprom_override" descr="Override/ignore EEPROM advertisement properties bitmask: \;Bit 0: Override_cable_protocols_and_technology_for_QSFP\;Bit 1: Override_cable_protocols_and_technology_for_SFP\;Bit 2: Ignore_Power_Class - set high power\;Bit 3: Override_Cable_Length \;Bit 4: Override_Attenuation\;Bit 8: Set_Module_to_Low_Power\;Bit 9: Override_cable_protocols_and_technology_for_CMIS - based modules QSFP-DD/ OSFP/ DSFP/ SFP-DD\;Bit 11: Override_module_type\;\;Supported overrides with apply_im is Bit 8.\;rest of overrides will be applied only after PMAOS toggle." access="RW" enum="Override_cable_protocols_and_technology_for_QSFP=0x1,Override_cable_protocols_and_technology_for_SFP=0x2,Ignore_Power_Class=0x4,Override_Cable_Length=0x8,Override_Attenuation=0x10,Set_Module_to_Low_Power=0x100,Override_cable_protocols_and_technology_for_CMIS=0x200,Override_module_type=0x800" offset="0x4.0" size="0x0.16" />
	<field name="eeprom_override_mask" descr="Write Mask bit (negative polarity):\;0 - allow write\;1 - ignore write\;On write commands, indicates which of the bits from eeprom_override field are updated.\;Reserved on read operations." access="WO" offset="0x4.16" size="0x0.16" />
	<field name="qsfp_cable_protocol_technology" descr="Protocol technology override for QSFP cable or CMIS based cable (QSFP-DD/OSFP)\;Valid only when the protocols and technology for QSFP is overridden as indicated by eeprom_override\;Table 1573, &quot;PMMP - QSFP Protocol Bytes Override Layout,&quot; on page 1879\;Table 1577, &quot;PMMP - CMIS Protocol Bytes Override Layout,&quot; on page 1884" subnode="pmmp_reg_qsfp_cable_protocol_technology_auto_ext" access="RW" offset="0x8.0" size="0xc.0" union_selector="$(parent).eeprom_override" />
	<field name="sfp_cable_protocol_technology" descr="Valid only when the protocols and technology is overridden as indicated by eeprom_override\;Table 1575, &quot;PMMP - SFP Protocol Bytes Override Layout,&quot; on page 1882" subnode="pmmp_reg_sfp_cable_protocol_technology_auto_ext" access="RW" offset="0x14.0" size="0xc.0" union_selector="$(parent).eeprom_override" />
	<field name="cable_length" descr="Length of cable assembly, units of 1 m for non CMIS cables.\;\;for CMIS cables, represents cable length field:\;bits 6:7 represent cable_length_multiplier for calculating cable length\;00 - 0.1 multiplier (0.1 to 6.3m)\;01- 1 multiplier (1 to 63m)\;10 - 10 multiplier (10 to 630m)\;11 - 100 multiplier (100 to 6300m)\;\;Valid only when the cable length is overridden as indicated by eeprom_override." access="RW" offset="0x20.0" size="0x0.8" />
	<field name="module_type" descr="0: passive_copper_cable\;1: active_copper_cable\;2: Liner_far_end_equlized_copper\;3: Linear_full_equlized_copper\;4: Linear_optical_module - Direct Drive\;5: active_optical_module\;6: on_board_retimer_over_transceiver" access="RW" offset="0x20.8" size="0x0.4" />
	<field name="attenuation_5g" descr="Valid only when the attenuation is overridden as indicated by eeprom_override.\;Attenuation - total channel attenuation @ 5GHz in db." access="RW" offset="0x24.0" size="0x0.8" />
	<field name="attenuation_7g" descr="Valid only when the attenuation is overridden as indicated by eeprom_override.\;Attenuation - total channel attenuation @ 7GHz in db." access="RW" offset="0x24.8" size="0x0.8" />
	<field name="attenuation_12g" descr="Valid only when the attenuation is overridden as indicated by eeprom_override.\;Attenuation - total channel attenuation @ 12GHz in db." access="RW" offset="0x24.16" size="0x0.8" />
	<field name="attenuation_25g" descr="Valid only when the attenuation is overridden as indicated by eeprom_override.\;Attenuation - total channel attenuation @ 25GHz in db." access="RW" offset="0x24.24" size="0x0.8" />
	<field name="attenuation_53g" descr="Valid only when the attenuation is overridden as indicated by eeprom_override.\;Attenuation - total channel attenuation @ 53GHz in db." access="RW" offset="0x28.8" size="0x0.8" />
</node>

<node name="pmmp_reg_qsfp_cable_protocol_technology_auto_ext" descr="" attr_is_union="1" size="0xc.0" >
	<field name="pmmp_qsfp_protocol_override_layout_ext" descr="" subnode="pmmp_qsfp_protocol_override_layout_ext" offset="0x0.0" selected_by="Override_cable_protocols_and_technology_for_QSFP" size="0xc.0" />
	<field name="pmmp_cmis_protocol_override_layout_ext" descr="" subnode="pmmp_cmis_protocol_override_layout_ext" offset="0x0.0" selected_by="Override_cable_protocols_and_technology_for_CMIS" size="0xc.0" />
</node>

<node name="pmmp_reg_sfp_cable_protocol_technology_auto_ext" descr="" attr_is_union="1" size="0xc.0" >
	<field name="pmmp_sfp_protocol_bytes_override_ext" descr="" subnode="pmmp_sfp_protocol_bytes_override_ext" offset="0x0.0" selected_by="Override_cable_protocols_and_technology_for_SFP" size="0xc.0" />
</node>

<node name="pmmp_sfp_protocol_bytes_override_ext" descr="" size="0xc.0" >
	<field name="tengig_ethernet_compliance_code" descr="10G Ethernet Compliance Codes\;Override byte3 per SFF-8472:\;Bit 7 - 10G Base-ER \;Bit 6 - 10G Base-LRM \;Bit 5 - 10G Base-LR \;Bit 4 - 10G Base-SR\;" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="cable_technology" descr="SFP+ Cable Technology\;Override byte8 per SFF-8472:\;Bit 3 - Active Cable\;Bit 2 - Passive Cable" access="RW" offset="0x0.8" size="0x0.8" />
	<field name="bit_rate" descr="Override byte12 per SFF-8472\;The nominal bit (signaling) rate (BR, nominal) is specified in units of 100 MBd, rounded off to the nearest 100 MBd.\;A value of FFh indicates the bit rate is greater than 25.0Gb/s" access="RW" offset="0x0.16" size="0x0.8" />
	<field name="ethernet_compliance_code" descr="Ethernet Compliance Codes \;Override byte6 per SFF-8472:\;Bit 7 - BASE-PX \;Bit 6 - BASE-BX10 \;Bit 5 - 100BASE-FX \;Bit 4 - 100BASE-LX/LX10 \;Bit 3 - 1000BASE-T \;Bit 2 - 1000BASE-CX \;Bit 1 - 1000BASE-LX \;Bit 0 - 1000BASE-SX\;" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="ext_ethernet_compliance_code" descr="Extended Specification Compliance Codes (25GE) \;Override byte36 per SFF-8472:\;0 - Unspecified\;1 - 100G AOC (Active Optical Cable) or 25GAUI C2M AOC with FEC\;2 - 100GBASE-SR4 or 25GBASE-SR\;3 - 100GBASE-LR4 or 25GBASE-LR\;4 - 100GBASE-ER4 or 25GBASE-ER\;5 - 100GBASE-SR10\;6 - 100G CWDM4\;7 - 100G PSM4 Parallel SMF\;8 - 100G ACC (Active Copper Cable) or 25GAUI C2M ACC. with FEC\;11 - 100GBASE-CR4 or 25GBASE-CR CA-L\;12 - 25GBASE-CR CA-S\;13 - 25GBASE-CR CA-N\;16 - 40GBASE-ER4\;17 - 4 x 10GBASE-SR\;18 - 40G PSM4 Parallel SMF\;19 - G959.1 profile P1I1-2D1 (10709 MBd, 2km, 1310nm SM)\;20 - G959.1 profile P1S1-2D2 (10709 MBd, 40km, 1550nm SM)\;21 - G959.1 profile P1L1-2D2 (10709 MBd, 80km, 1550nm SM)\;22 - 10GBASE-T with SFI electrical interface\;23 - 100G CLR4\;24 - 100G AOC or 25GAUI C2M AOC. No FEC\;25 - 100G ACC or 25GAUI C2M ACC. No FEC" access="RW" offset="0x4.8" size="0x0.8" />
</node>

<node name="pmpc_reg_ext" descr="" size="0x20.0" >
	<field name="module_state_updated" descr="On read operation:\;A bit vector where each bit represents a module (bit 0 represents module 0 etc). A set bit indicates one or more changes in the module state (plugged/unplugged/unknown) has happened since the last time the bit was cleared. The default is 1 in all relevant bits.\;On write operation:\;Used to clear the module_status_updated bits. Writing a set bit clears the relevant bit in the module_status_updated vector. Cleared bits in this field preserve the value of the relevant bit in the bit vector. The software cannot set a bit in the module_status_updated vector.\;Note: To prevent a case where an update is missed by the software, it is recommended to use the flow below:\;Read the module_status_updated vector\;Find a bit(s) relevant to a module(s) the software would like to handle\;Clear the relevant bit(s)\;Handle the module (e.g. read the module parameters using MCIA register)\;Read module_status_updated again to make sure the status did not change after reading the cable information." access="RW" high_bound="7" low_bound="0" offset="0x0.0" size="0x20.0" />
</node>

<node name="pmpd_reg_ext" descr="" size="0x30.0" >
	<field name="status" descr="0 - Diagnostic data not supported\;1 - Normal mission mode. \;2 - PRBS checker is not locked. \;3 - PRBS checker is locked." access="RO" offset="0x0.0" size="0x0.4" />
	<field name="cl" descr="clear counters" access="OP" offset="0x0.4" size="0x0.1" />
	<field name="lane" descr="Module lane number" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="host_media" descr="Host or Media lanes\;0 - Media lanes\;1 - Host lanes" access="INDEX" offset="0x0.12" size="0x0.1" />
	<field name="module" descr="module to access" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA\;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="errors_cap" descr="Bits Errors count capability" access="RO" offset="0x0.29" size="0x0.1" />
	<field name="ber_cap" descr="BER measure capability" access="RO" offset="0x0.30" size="0x0.1" />
	<field name="snr_cap" descr="SNR measure capability" access="RO" offset="0x0.31" size="0x0.1" />
	<field name="prbs_bits_high" descr="This counter provides information on the total amount of prbs traffic (bits) received on module&apos;s side." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="prbs_bits_low" descr="This counter provides information on the total amount of prbs traffic (bits) received on module&apos;s side." access="RO" offset="0x8.0" size="0x4.0" />
	<field name="prbs_errors_high" descr="This counter provides information on the total amount of prbs errors detected on module&apos;s side." access="RO" offset="0xC.0" size="0x4.0" />
	<field name="prbs_errors_low" descr="This counter provides information on the total amount of prbs errors detected on module&apos;s side." access="RO" offset="0x10.0" size="0x4.0" />
	<field name="measured_snr" descr="SNR in dB\;0 - not supported." access="RO" offset="0x14.16" size="0x0.16" />
	<field name="ber_coef" descr="BER = raw_ber_coef*10^(-raw_ber_magnitude)" access="RO" offset="0x18.0" size="0x0.4" />
	<field name="ber_magnitude" descr="BER = raw_ber_coef*10^(-raw_ber_magnitude)" access="RO" offset="0x18.8" size="0x0.8" />
</node>

<node name="pmpe_reg_ext" descr="" size="0x10.0" >
	<field name="module_status" descr="Port operational state:\;1: plugged_enabled\;2: unplugged\;3: module_plugged_error - details in error_type \;5: unknown" access="RO" enum="plugged_enabled=0x1,unplugged=0x2,module_plugged_error=0x3,unknown=0x5" offset="0x0.0" size="0x0.4" />
	<field name="module" descr="Module number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA\;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="error_type" descr="Module error details:\;0x0: Power_Budget_Exceeded\;0x1: Long_Range_for_non_MLNX_cable_or_module\;0x2: Bus_stuck - (I2C Data or clock shorted)\;0x3: bad_or_unsupported_EEPROM\;0x4: Enforce_part_number_list\;0x5: unsupported_cable\;0x6: High_Temperature\;0x7: bad_cable - (Module/Cable is shorted)\;0x8: PMD_type_is_not_enabled - (see PMTPS).\;0xc: pcie_system_power_slot_Exceeded\;0xf: Boot_error - [DWIP]\;0x10: Recovery_error - [DWIP]\;0x11: Submodule_failure - [DWIP]\;Valid only when (oper_status = 0x3)." access="RO" enum="Power_Budget_Exceeded=0x0,Long_Range_for_non_MLNX_cable_or_module=0x1,Bus_stuck=0x2,bad_or_unsupported_EEPROM=0x3,Enforce_part_number_list=0x4,unsupported_cable=0x5,High_Temperature=0x6,bad_cable=0x7,PMD_type_is_not_enabled=0x8,pcie_system_power_slot_Exceeded=0xc,Boot_error=0xf,Recovery_error=0x10,Submodule_failure=0x11" offset="0x4.8" size="0x0.5" />
</node>

<node name="pmpr_reg_ext" descr="" size="0x10.0" >
	<field name="module" descr="Module number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA \;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="attenuation_5g" descr="Attenuation - total channel attenuation @ 5GHz in db." access="RW" offset="0x4.0" size="0x0.8" />
	<field name="attenuation_7g" descr="Attenuation - total channel attenuation @ 7GHz in db. \;A 0 value implies that attenuation_5g is used also for 7GHz" access="RW" offset="0x8.0" size="0x0.8" />
	<field name="attenuation_53g" descr="Attenuation - total channel attenuation @ 53GHz in db.\;A 0 value implies that attenuation_5g is used also for 25GHz" access="RW" offset="0x8.16" size="0x0.8" />
	<field name="attenuation_12g" descr="Attenuation - total channel attenuation @ 12GHz in db.\;A 0 value implies that attenuation_5g is used also for 12GHz" access="RW" offset="0xC.0" size="0x0.8" />
	<field name="attenuation_25g" descr="Attenuation - total channel attenuation @ 25GHz in db.\;A 0 value implies that attenuation_5g is used also for 25GHz" access="RW" offset="0xC.16" size="0x0.8" />
</node>

<node name="pmpt_reg_ext" descr="" size="0x1c.0" >
	<field name="status" descr="0 - Normal mission mode. \;1 - Module is not connected OR module doesn&apos;t support PRBS and diagnostics data\;2 - unsupported configuration setting\;3 - PRBS Generator only\;4 - PRBS Checker only \;5 - PRBS traffic both Checker and Generator\;Note: For lock status on PRBS data see PMPD.status" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="lane_mask" descr="Reserved when (le=0 or ls = 0)\;Logical lane number mask.\;For Get operation One-Hot key (Only one bit set)" access="INDEX" offset="0x0.4" size="0x0.8" />
	<field name="host_media" descr="Host or Media lanes\;0 - Media lanes\;1 - Host lanes" access="INDEX" offset="0x0.12" size="0x0.1" />
	<field name="invt_cap" descr="PRBS inversion is supported" access="RO" offset="0x0.13" size="0x0.1" />
	<field name="swap_cap" descr="PAM4 MSB&lt;-&gt; LSB swapping is supported by the module" access="RO" offset="0x0.14" size="0x0.1" />
	<field name="module" descr="module index" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA\;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="le" descr="Per Lane configuration enable (can be set only if ls = 1):\;0 - No per lane configuration\;1 - Per lane configurations\;When le is cleared, lane index is reserved and all PMPT configurations are taking place on all lanes.\;When le is set, configurations are taking place per lane based on lane index\;Affects lane indexing for set operations only, ignored for get operations" access="OP" offset="0x0.29" size="0x0.1" />
	<field name="ls" descr="Per Lane configuration support/capability: \;0 - No support of per lane configuration\;1 - Support of per lane configuration" access="RO" offset="0x0.30" size="0x0.1" />
	<field name="e" descr="Enable PRBS test mode bit:\;0 - PRBS is disabled.\;1 - PRBS is enabled." access="RW" offset="0x0.31" size="0x0.1" />
	<field name="prbs_modes_cap" descr="Supported module&apos;s PRBS capability (bitmask)\;Bit 0 - PRBS31 (x^31 + x^28 + 1)\;Bit 1 - PRBS23 (x^23 + x^18 + 1)\;Bit 5 - PRBS7 (x^7 + x^6 + 1)\;Bit 6 - PRBS11 (x^11 + x^9 + 1)\;Bit 11 - PRBS9 (x^9 + x^5 + 1)\;Bit 17 - PRBS13 (x^13 + x^12 + x^2+ x + 1)\;Bit 21 - SSPR\;Bit 22 - SSPRQ" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="modulation" descr="Reserved for speeds below 53.125Gb/s (lane_rate_admin &lt; 7):\;0 - NRZ test pattern\;1 - PAM4 encoding" access="INDEX" offset="0x8.0" size="0x0.4" />
	<field name="ch_ge" descr="0 - Access is for both Checker and Generator (Can be used for Set operations only)\;1 - Access is for Generator\;2 - Access if for Checker\;Note: Checker and Generator must be in same rate" access="INDEX" offset="0x8.4" size="0x0.2" />
	<field name="invt_admin" descr="PRBS inversion enable bit, see ivnt_cap:\;0 - NO PRBS inversion\;1 - PRBS inversion" access="RW" offset="0x8.8" size="0x0.1" />
	<field name="swap_admin" descr="PAM4 MSB&lt;-&gt; LSB swapping enable bit, see swap_cap. \;0 - NO MSB&lt;-&gt; LSB swapping \;1 - MSB &lt;-&gt; LSB swapping" access="RW" offset="0x8.9" size="0x0.1" />
	<field name="prbs_mode_admin" descr="See prbs_mode_cap: \;0x0 - PRBS31 (x^31 + x^28 + 1)\;0x1 - PRBS23 (x^23 + x^18 + 1)\;0x5 - PRBS7 (x^7 + x^6 + 1)\;0x6 - PRBS11 (x^11 + x^9 + 1)\;0xB - PRBS9 (x^9 + x^5 + 1)\;0x11 - PRBS13 (x^13 + x^12 + x^2+ x + 1)\;0x15 - SSPR\;0x16 - SSPRQ" access="RW" offset="0x8.24" size="0x0.8" />
	<field name="lane_rate_cap" descr="Per lane rate capability (bitmask)\;Bit 0 - 1GE (1.25 Gb/s)\;Bit 1 - SDR (2.5 Gb/s) \;Bit 2 - Reserved\;Bit 3- 10GE/40GE (10.3125 Gb/s) \;Bit 4- FDR (14.0625 Gb/s) \;Bit 5- EDR / 25GE / 50GE / 100GE (25.78125 Gb/s) \;Bit 6- Reserved \;Bit 7- HDR /50GE / 100GE / 200GE / 400GE (26.5625Gbd / 53.125Gb/s) \;Bit 8- NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd / 106.25Gb/s)\;Bit 9 - XDR (106.25 Gbd / 212.5Gb/s)" access="RO" offset="0xC.16" size="0x0.16" />
	<field name="lane_rate_admin" descr="Lane rate be used in PRBS, see lane_rate_cap:\;0 - Non selected. \;1 - 1GE (1.25 Gb/s)\;2 - SDR (2.5 Gb/s) \;8 - 10GE/40GE (10.3125 Gb/s) \;16 - FDR (14.0625 Gb/s) \;32 - EDR / 25GE / 50GE / 100GE (25.78125 Gb/s) \;128 - HDR /50GE / 100GE / 200GE / 400GE (26.5625Gbd / 53.125Gb/s) \;256 - NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd / 106.25Gb/s)\;512 - XDR (106.25 Gbd / 212.5Gb/s)\;" access="RW" offset="0x10.16" size="0x0.16" />
</node>

<node name="pmsc_reg_ext" descr="" size="0x40.0" >
	<field name="port_mapping_updated" descr="On read operation:\;A bit vector where each bit represents a local port with +1 offset (bit 0 represents local port 1, bit 1 represent local port 2 etc). A set bit indicates one or more changes in the local port mapping (mapped/unmapped) has happened since the last time the bit was cleared. The default is 1 in all relevant bits.\;On write operation:\;Used to clear the port_mapping_updated bits. Writing a set bit clears the relevant bit in the port_mapping_updated vector. Cleared bits in this field preserve the value of the relevant bit in the bit vector. The software cannot set a bit in the port_mapping_updated vector.\;Note: To prevent a case where an update is missed by the software, it is recommended to use the flow below:\;Read the port_mapping_updated vector\;Find a bit(s) relevant to a local_port(s) the software would like to handle\;Clear the relevant bit(s)\;Handle the local port (e.g. read PMLPE)\;Read port_mapping_updated again to make sure the status did not change after reading the PMPLE information." access="RW" high_bound="7" low_bound="0" offset="0x0.0" size="0x20.0" />
</node>

<node name="pmtdb_reg_ext" descr="" size="0x40.0" >
	<field name="status" descr="0 - success\;1 - number of ports exceed the module width\;2 - Module was not instantiated (check ini/modular switch configuration flow)\;3 - ports combination is not allowed" access="RO" offset="0x0.0" size="0x0.4" />
	<field name="num_ports" descr="Number of ports in a single module (split/breakout)\;Examples: \;if num_ports = 1 than only port1 should contain local_port information. \;if num_ports = 4 than port1, port 2, port3 and port4 should contain local_port information. \;\;The combination of port_width and num_ports also detriments the mapping of port_num&lt;x&gt; to module&apos;s lanes.\;\;port_num&lt;x&gt; uses module lanes:\;(X-1)*port_width: X*port_width - 1 \;\;if num_ports&gt; 0 than port_num1 uses module lanes 0:port_width-1\;if num_ports&gt;1 than port_num2 uses modules lanes port_width: 2*port_width - 1.\;if num_ports&gt;2 than port_num3 uses modules lanes 2*port_width: 3*port_width - 1.\;and so on." access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="ports_width" descr="Port&apos;s width\;0 - per port&lt;x&gt;_width indexes\;1 - 1x \;2 - 2x\;4 - 4x\;8 - 8x" access="INDEX" offset="0x0.12" size="0x0.4" />
	<field name="module" descr="Module number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA\;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="port_num2" descr="Return the local_port value which can be assigned to the module." access="RO" offset="0x4.0" size="0x0.10" />
	<field name="port2_width" descr="port 2 width. valid only if port_width set to 0." access="INDEX" offset="0x4.12" size="0x0.4" />
	<field name="port_num1" descr="Return the local_port value which can be assigned to the module.\;In case of more than one port, port&lt;x&gt; represent the /&lt;x&gt; port of the module. \;Example: \;port1 represent the &lt;label_port&gt; /1\;port2 represent the &lt;label_port&gt; /2\;port3 represent the &lt;label_port&gt; /3\;" access="RO" offset="0x4.16" size="0x0.10" />
	<field name="port1_width" descr="port 1 width. valid only if port_width set to 0.\;1 - 1x \;2 - 2x\;4 - 4x\;8 - 8x" access="INDEX" offset="0x4.28" size="0x0.4" />
	<field name="port_num4" descr="Return the local_port value which can be assigned to the module." access="RO" offset="0x8.0" size="0x0.10" />
	<field name="port4_width" descr="port 4 width. valid only if port_width set to 0." access="INDEX" offset="0x8.12" size="0x0.4" />
	<field name="port_num3" descr="Return the local_port value which can be assigned to the module." access="RO" offset="0x8.16" size="0x0.10" />
	<field name="port3_width" descr="port 3 width. valid only if port_width set to 0." access="INDEX" offset="0x8.28" size="0x0.4" />
	<field name="port_num6" descr="Return the local_port value which can be assigned to the module." access="RO" offset="0xC.0" size="0x0.10" />
	<field name="port6_width" descr="port 6 width. valid only if port_width set to 0." access="INDEX" offset="0xC.12" size="0x0.4" />
	<field name="port_num5" descr="Return the local_port value which can be assigned to the module." access="RO" offset="0xC.16" size="0x0.10" />
	<field name="port5_width" descr="port 5 width. valid only if port_width set to 0." access="INDEX" offset="0xC.28" size="0x0.4" />
	<field name="port_num8" descr="Return the local_port value which can be assigned to the module." access="RO" offset="0x10.0" size="0x0.10" />
	<field name="port8_width" descr="port 8 width. valid only if port_width set to 0." access="INDEX" offset="0x10.12" size="0x0.4" />
	<field name="port_num7" descr="Return the local_port value which can be assigned to the module." access="RO" offset="0x10.16" size="0x0.10" />
	<field name="port7_width" descr="port 7 width. valid only if port_width set to 0." access="INDEX" offset="0x10.28" size="0x0.4" />
</node>

<node name="pmtm_reg_ext" descr="" size="0x10.0" >
	<field name="module" descr="module number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="slot_index" descr="Reserved for HCA\;Slot_index \;Slot_index = 0 represent the onboard (motherboard). \;In case of non modular system only slot_index = 0 is available." access="INDEX" offset="0x0.24" size="0x0.4" />
	<field name="module_type" descr="module_type: \;0: Backplane_with_4_lanes\;1: QSFP\;2: SFP\;3: No_Cage\;4: Backplane_with_single_lane\;8: Backplane_with_two_lanes\;10: Chip2Chip4x\;11: Chip2Chip2x \;12: Chip2Chip1x\;14: QSFP_DD \;15: OSFP\;16: SFP_DD\;17: DSFP \;18: Chip2Chip8x\;19: Twisted_Pair\;20: Backplane_with_8_lanes" access="RW" enum="Backplane_with_4_lanes=0x0,QSFP=0x1,SFP=0x2,No_Cage=0x3,Backplane_with_single_lane=0x4,Backplane_with_two_lanes=0x8,Chip2Chip4x=0xa,Chip2Chip2x=0xb,Chip2Chip1x=0xc,QSFP_DD=0xe,OSFP=0xf,SFP_DD=0x10,DSFP=0x11,Chip2Chip8x=0x12,Twisted_Pair=0x13,Backplane_with_8_lanes=0x14" offset="0x4.0" size="0x0.5" />
	<field name="module_width" descr="Number of module&apos;s electrical lanes\;\;NOTE: For SET command, this value should match the module type width in module_type field" access="RW" offset="0x4.8" size="0x0.5" />
</node>

<node name="pmtu_reg_ext" descr="" size="0x10.0" >
	<field name="itre" descr="Ingress Truncation enable, the admin_mtu is used as truncation:\;0: disable\;1: enable\;Reserved when NICs (NICs use only &apos;0&apos;)\;Reserved when SwitchX/-2 and IB Switches (use only &apos;0&apos;)\;Reserved when i_e = 0 or 2\;Reserved when GPUNet" access="RW" offset="0x0.0" size="0x0.1" />
	<field name="i_e" descr="Ingress/Egress:\;0: applies for both ingress and for egress, read from egress\;1: applies only for ingress\;2: applies only for egress\;Reserved when NICs (NICs use only &apos;0&apos;)\;Reserved when SwitchX/-2 and IB Switches (use only &apos;0&apos;)\;Reserved when GPUNet" access="INDEX" offset="0x0.4" size="0x0.2" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number\;Not including CPU port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="protocol" descr="[DWIP]:\;The protocol which the MTU is applied to. \;0: All protocols that are supported by the device. On get, it will return the value for IBg1\;1: IB (gen 1) \;2: NVLink\;3: IBg2\;4-15: Reserved\;Reserved when Eth switches\;Reserved when NIC\;Note: for GB100 IBg2 is not PoR, Nov 2023" access="INDEX" offset="0x0.28" size="0x0.4" />
	<field name="max_mtu" descr="Maximum MTU supported on the port (Read Only).\;MTU depends on the port type. When port type (Eth/IB/FC) is configured, the relevant MTU is reported. When the port type is not configured, the minimum between the max_mtu for the different types (Eth/IB/FC) is reported.\;Informative:- For GPUNet: IB is used for MADs, thus max MTU is 768B\;- NVLink max MTU is 320B" access="RO" offset="0x4.16" size="0x0.16" />
	<field name="admin_mtu" descr="Administratively configured MTU on the port. Must be smaller or equal to max_mtu.\;When IB: configuration is allowed only when port state is down.\;When itre=1 then must be at least 128B and granularity is 8B" access="RW" offset="0x8.16" size="0x0.16" />
	<field name="oper_mtu" descr="Operational MTU. This is the actual MTU configured on the ports. Packets exceeding this size will be dropped.\;Note: For NICs and for IB the actual operational MTU is reported which may be smaller than admin_mtu.\;For NICs: when PCAM.max_admin_mtu capability is set then oper_mtu will be the max of all admin_mtu" access="RO" offset="0xC.16" size="0x0.16" />
</node>

<node name="power_profile_config_ext" descr="" size="0x10.0" >
	<field name="max_integral" descr="The max value allowed for the integral calculation" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="power_allocation" descr="Power Allocation Threshold \;Units of Watt\;Can&apos;t change profile which is currently used by FW" access="RW" offset="0x0.16" size="0x0.11" />
	<field name="v" descr="Valid bit\;0: Profile configuration isn&apos;t valid\;1: Profile configuration is valid" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="Kd_factor" descr="Kd factor used for the FW PID controller" access="RW" offset="0x4.0" size="0x0.8" />
	<field name="Ki_factor" descr="Ki factor used for the FW PID controller" access="RW" offset="0x4.8" size="0x0.8" />
	<field name="Kp_factor" descr="Kp factor used for the FW PID controller" access="RW" offset="0x4.16" size="0x0.8" />
	<field name="avg_pwr_num_of_sampling" descr="Num of MPPGCR.sampling_time to be used for the window average calculation" access="RW" offset="0x4.24" size="0x0.8" />
	<field name="param_a" descr="reserved for future use" access="RW" high_bound="3" low_bound="0" offset="0x8.24" size="0x4.0" />
	<field name="pid_update_num_of_sampling" descr="Number of sampling to update PID output" access="RW" offset="0xC.0" size="0x0.8" />
	<field name="param_d" descr="reserved for future use" access="RW" offset="0xC.8" size="0x0.8" />
	<field name="param_c" descr="reserved for future use" access="RW" offset="0xC.16" size="0x0.8" />
	<field name="param_b" descr="reserved for future use" access="RW" offset="0xC.24" size="0x0.8" />
</node>

<node name="ppad_reg_ext" descr="" size="0x10.0" >
	<field name="mac_47_32" descr="If single_base_mac = 0 - base MAC address\;If single_base_mac = 1 - the per port MAC address" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="local_port" descr="Port number\;Reserved when single_base_mac = 0" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.24" size="0x0.2" />
	<field name="single_base_mac" descr="0: base_mac - Switch global MAC address. FW will set incremental MAC per port starting from the base_mac.\;1: single_mac - mac of the local_port\;Reserved for SwitchX/-2." access="OP" offset="0x0.28" size="0x0.1" />
	<field name="mac_31_0" descr="If single_base_mac = 0 - base MAC address\;If single_base_mac = 1 - the per port MAC address" access="RW" offset="0x4.0" size="0x4.0" />
</node>

<node name="ppaos_reg_ext" descr="" size="0x10.0" >
	<field name="phy_test_mode_status" descr="Port extended down status:\;0: regular_operation - (port down/up according to PAOS) \;1: phy_test_mode\;phy test mode can be valid only when PAOS.admin_status=2 and PAOS.oper_status=2 (i.e port is down)." access="RO" enum="regular_operation=0x0,phy_test_mode=0x1" offset="0x0.0" size="0x0.4" />
	<field name="port_type" descr="For HCA supported only when indicated by PCAM \;0 - Network Port\;1 - Near-End Port (For Retimer/Gearbox - Host side)\;2 - Internal IC LR Port \;3 - Far-End Port (For Retimer/Gearbox - Line side)\;Other values are reserved." access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="phy_test_mode_admin" descr="Port extended administrative down status:\;0: regular_operation (port down/up according to PAOS) \;1: phy_test_mode \;\;The phy test mode (1) can be set only when PAOS.admin_status=2 (i.e port configuration is down)." access="RW" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="swid" descr="For HCA: must always be 0.\;Switch partition ID with which to associate the port.\;Switch partitions are numbered from 0 to 7 inclusively.\;The swid field is only valid when the local_port is the router port. In this case, the swid indicates which of the router ports to configure/query." access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="phy_status" descr="rx phy status:\;0: rx_phy_down\;1: rx_phy_up\;2: rx_phy_down_by_command\;\;Note: The phy up indication is according to protocol (up == align_status=true)\;i.g. In PRBS test mode phy up is when PRB is lock (up== prbs lock)" access="RO" offset="0x4.0" size="0x0.4" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x4.4" size="0x0.4" />
	<field name="phy_status_admin" descr="rx phy port admin. Controls phy entities operational port status.\;valid for port_type &lt;&gt; &apos;0&apos;.\;to operate link status for port_type &apos;0&apos; use PAOS.admin_status.\;0: rx_phy_down\;1: rx_phy_up\;" access="RW" offset="0x4.8" size="0x0.4" />
	<field name="dc_cpl_port" descr="When set, indicates that ports trace is DC coupled.\;Enabling test mode in case of DC coupled port is allowed only when setting dc_cpl_allow and printing warning to user as specified in the description." access="RO" offset="0x4.28" size="0x0.1" />
	<field name="dc_cpl_allow" descr="Relevant only for DC couple ports, Ignored otherwise.\;Field must be set when entering test mode, otherwise command is ignored.\;When entering test mode in DC couple system the following message must be presented to user:\;&quot;Warning: DC couple system must be powered on both sides of the physical link prior to enabling test mode. System may be harmed and product lifetime may be shortened if not ensured.&quot;" access="WO" offset="0x4.29" size="0x0.1" />
</node>

<node name="ppbmc_reg_ext" descr="" size="0x10.0" >
	<field name="port_type" descr="For HCA supported only when indicated by PCAM \;0 - Network Port\;1 - Near-End Port (For Retimer/Gearbox - Host side)\;2 - Internal IC LR Port \;3 - Far-End Port (For Retimer/Gearbox - Line side)\;4 - USR Main\;5 - USR Tile\;Other values are reserved.\;Configuration 4,5 should use the same clock" access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="monitor_type" descr="Monitor type based on monitor_cntl setting and the operational mode of the link:\;Bit 0 - Post FEC / No FEC BER monitoring\;Bit 1 - Pre FEC BER monitoring\;Bit 2 - Symbol BER monitoring\;Bit 3 - Estimated Effective BER monitoring" access="RO" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="local_port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="monitor_state" descr="The monitor state of the port:\;0 - No BER Monitor support\;1 - Normal\;2 - Warning\;3 - Alarm\;* The init monitor state for each port upon link up is normal" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="est_ef_ber_cap" descr="Indicates Estimated Effective BER monitoring suppored" access="RO" offset="0x4.8" size="0x0.1" />
	<field name="clr_stat" descr="clear statistics from PPDR. link_down_info page of selected monitor type" access="OP" offset="0x4.9" size="0x0.1" />
	<field name="monitor_cntl" descr="Bitmask - monitor options:\;When multiple_monitor_cap is set, multiple bits can be set. Else, only 1 bit can be set\;Bit 0 - Raw BER monitor: \;When set, a link with FEC active will monitor Pre-FEC BER.\;Bit 1 - Effective FEC monitor\;Bit 2 - Symbol FEC monitor\;Bit 3 - Estimated Effective BER monitoring" access="RW" offset="0x4.16" size="0x0.4" />
	<field name="event_ctrl" descr="Bitmask - event generation on operational state change:\;Bit 0 - Normal state\;Bit 1 - Warning state\;Bit 2 - Alarm state\;Bit 3 - Reserved\;\;Note: Normal state events can be generated only if either Alarm and/or Warning events are enabled." access="RW" offset="0x4.24" size="0x0.4" />
	<field name="multiple_monitor_cap" descr="When set, multiple monitoring groups are possible. Hence, monitor_cntl can be set with multiple bits.\;else, monitor_cntl can be set with only 1 bits" access="RO" offset="0x4.28" size="0x0.1" />
	<field name="ievent" descr="Invoke event\;0: Read only\;1: Does both reading and invoke an event of type PPBME_TRAP\;\;Note: setting this field invokes an event, regardless to e and event_ctl fields, it has no effect on the event state." access="OP" offset="0x4.29" size="0x0.1" />
	<field name="e" descr="Event generation on operational state change:\;0 - Do not generate event\;1 - Generate Event \;2 - Generate Single Event\;Not Supported for HCA." access="RW" offset="0x4.30" size="0x0.2" />
</node>

<node name="ppbme_reg_ext" descr="" size="0x10.0" >
	<field name="monitor_type" descr="Monitor type based on monitor_options setting and the operational mode of the link:\;0 - Post FEC / No-FEC BER monitoring\;1 - Pre FEC BER monitoring\;2 - Symbol BER monitoring\;3 - Estimated Effective BER monitoring" access="RO" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="local_port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="monitor_state" descr="The monitor state of the port:\;0 - No BER Monitor on the port\;1 - Normal\;2 - Warning\;3 - Alarm" access="RO" offset="0x4.0" size="0x0.8" />
	<field name="ievent" descr="Invoke event\;0: Read only\;1: Does both reading and invoke an event of type PPBME_TRAP\;\;Note: setting this field invokes an event, regardless to e and event_ctl fields, it has no effect on the event state." access="OP" offset="0x4.29" size="0x0.1" />
</node>

<node name="ppbmi_ext" descr="" size="0x18.0" >
	<field name="ilm_index" descr="ILM entry Index\;For Spectrum, the index points to the KVD Linear, see Section A.4.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3813" access="INDEX" offset="0x4.0" size="0x0.24" />
	<field name="nhlfe_index" descr="NHLFE entry pointer\;Points to the NHLFE table. When using ECMP, points to the first entry in the ECMP list\;For Spectrum, the index is to the KVD linear, see Section A.4.1.2, &quot;KVD Central Database Linear Entries&quot;, on page 3813" access="RW" offset="0x8.0" size="0x0.24" />
	<field name="ecmp_size" descr="The amount of sequential entries starting from the nhlfe_ptr (the number of ECMPs)\;Values are according to the mixed ECMP scheme detailed in Table 2961, &quot;ECMP Sizes,&quot; on page 3175." access="RW" offset="0xC.0" size="0x0.13" />
	<field name="npop" descr="Number of labels to pop from the label stack.\;Range from 0 to cap_mpls_ilm_entry_pop" access="RW" offset="0xC.24" size="0x0.2" />
</node>

<node name="ppbmp_monitor_parameters_ext" descr="" size="0x8.0" >
	<field name="warning_th_exp" descr="BER threshold for warning state, when the monitor state is normal and the monitored BER crosses above the warning_threshold, the monitor state will is set to warning\;warning_threshold = warning_th_mantissa * 10^(-warning_th_exp)\;The warning_threshold shall be within the supported range for the monitor type" access="RW" offset="0x0.0" size="0x0.8" />
	<field name="warning_th_mantissa" descr="BER threshold for warning state, when the monitor state is normal and the monitored BER crosses above the warning_threshold, the monitor state will is set to warning\;warning_threshold = warning_th_mantissa * 10^(-warning_th_exp)\;The warning_threshold shall be within the supported range for the monitor type" access="RW" offset="0x0.8" size="0x0.4" />
	<field name="alarm_th_exp" descr="BER threshold for alarm state, when the monitored BER crosses above the alarm_threshold, the monitor state is set to alarm.\;alarm_threshold = alarm_th_mantissa * 10^(-alarm_th_exp)\;The alarm_threshold shall be within the supported range for the monitor type" access="RW" offset="0x0.16" size="0x0.8" />
	<field name="alarm_th_mantissa" descr="BER threshold for alarm state, when the monitored BER crosses above the alarm_threshold, the monitor state is set to alarm.\;alarm_threshold = alarm_th_mantissa * 10^(-alarm_th_exp)\;The alarm_threshold shall be within the supported range for the monitor type" access="RW" offset="0x0.24" size="0x0.4" />
	<field name="normal_th_exp" descr="BER threshold for normal state, when the monitored BER crosses below the normal_threshold, the monitor state is set to normal.\;normal_threshold = normal_th_mantissa * 10^(-normal_th_exp)\;The warning_threshold shall be within the supported range for the monitor type" access="RW" offset="0x4.16" size="0x0.8" />
	<field name="normal_th_mantissa" descr="BER threshold for normal state, when the monitored BER crosses below the normal_threshold, the monitor state is set to normal.\;normal_threshold = normal_th_mantissa * 10^(-normal_th_exp)\;The warning_threshold shall be within the supported range for the monitor type" access="RW" offset="0x4.24" size="0x0.4" />
</node>

<node name="ppbmp_reg_ext" descr="" size="0x30.0" >
	<field name="monitor_group" descr="Monitor Parameters Group\;0x0: Raw_BER_RS - Pre-FEC monitor parameters for RS-FEC links\;0x1: Raw_BER_FC - Pre-FEC monitor parameters for FC-FEC links\;0x2: Effective_BER - Post FEC monitor parameters\;0x5: Symbol_BER - BER after all phy correction mechanism: post FEC + PLR monitor parameters\;0x6: Estimated_Effective_BER_monitoring" access="INDEX" enum="Raw_BER_RS=0x0,Raw_BER_FC=0x1,Effective_BER=0x2,Symbol_BER=0x5,Estimated_Effective_BER_monitoring=0x6" offset="0x0.0" size="0x0.4" />
	<field name="grp_prf_set" descr="When set, grp_prf field will set local_port&apos;s group.\;Else, grp_prf field will be ignore in set operation" access="WO" offset="0x0.11" size="0x0.1" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="local_port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="grp_prf" descr="Group profile port is mapped to.\;when group_profile is set," access="RW" offset="0x0.24" size="0x0.3" />
	<field name="clr" descr="Supported if PCAM.feature_cap_mask bit 93 is set.\;0: override_thresholds - thresholds set according to monitor_parameters values.\;1: set_fw_default_thresholds - thresholds set in monitor_parameters are ignored" access="RW" enum="override_thresholds=0x0,set_fw_default_thresholds=0x1" offset="0x0.31" size="0x0.1" />
	<field name="monitor_parameters" descr="See Table 1815, &quot;PPBMP - Monitor Parameters Layout,&quot; on page 2185" subnode="ppbmp_reg_monitor_parameters_auto_ext" access="RW" offset="0x4.0" size="0x8.0" />
	<field name="time_window" descr="The time frame which the events are grouped. \;This is a tumbling window (not a sliding window), means that each window is uncorrelated to the adjacent windows events. \;For BER features the time window derived from \;the lowest threshold. \;Units of sampling_rate.\;Value of zero is means the BER monitor is not active or time window is unknown\;\;time window is adjustable only for Estimated Effective BER monitor type, otherwise ignored." access="RW" offset="0xC.0" size="0x0.24" />
	<field name="sampling_rate" descr="Time frame to measure warning threshold and error threshold. \;Units of 10mSec, range 0..1Sec. \;Value of zero is means the BER monitor is not active or sampling rate is unknown" access="RO" offset="0x10.0" size="0x0.8" />
</node>

<node name="ppbmp_reg_monitor_parameters_auto_ext" descr="" attr_is_union="1" size="0x8.0" >
	<field name="ppbmp_monitor_parameters_ext" descr="" subnode="ppbmp_monitor_parameters_ext" offset="0x0.0" size="0x8.0" />
</node>

<node name="ppbs_ext" descr="" size="0x1c.0" >
	<field name="type" descr="Entry type:\;0x0: Unicast_Record\;0x1: Unicast_LAG_Record\;0x2: Multicast_Record\;0xC: Unicast_Tunnel_Record\;0xF: Multicast_Tunnel_Record" access="RW" enum="Unicast_Record=0x0,Unicast_LAG_Record=0x1,Multicast_Record=0x2,Unicast_Tunnel_Record=0xc,Multicast_Tunnel_Record=0xf" offset="0x4.20" size="0x0.4" />
	<field name="swid" descr="Switch partition ID for queries. Reserved on Write.\;Reserved from Spectrum-1" access="INDEX" offset="0x4.24" size="0x0.8" />
	<field name="pbs_ptr" descr="Index into the PBS table. \;In SwitchX/-2 pbs_ptr is limited to 0 .. (pbs_table_size-1)\;For Spectrum family, the index points to the KVD Linear, see Appendix A.4.1.2, &quot;KVD Central Database Linear Entries&quot; (page 3813)" access="INDEX" offset="0x8.0" size="0x0.24" />
	<field name="pbs_record" descr="PBS Record. For full description see:\;Table 2745, &quot;Unicast PBS Record Layout,&quot; on page 2981\;Table 2747, &quot;Unicast LAG PBS Record Layout,&quot; on page 2982\;Table 2749, &quot;Multicast PBS Record Layout,&quot; on page 2983\;Table 2751, &quot;Unicast Tunnel PBS Record Layout,&quot; on page 2984\;Table 2753, &quot;Multicast Tunnel PBS Record Layout,&quot; on page 2986" subnode="ppbs_pbs_record_auto_ext" access="RW" offset="0xC.0" size="0x10.0" union_selector="$(parent).type" />
</node>

<node name="ppbs_multicast_ext" descr="" size="0x8.0" >
	<field name="fid" descr="Filtering identifier (FID)\;Reserved when v_fid = 0\;Reserved when ubridge=1\;Reserved when Spectrum-2 \;" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="pgi" descr="Multicast port group index - index into the Port Group Table.\;Value 0x1FFF indicates the pgi should point to the MID entry.\;For Spectrum family this value must be set to 0x1FFF" access="RW" offset="0x0.16" size="0x0.13" />
	<field name="v_fid" descr="valid FID:\;0: .1Q bridge\;1: .1D bridge\;Reserved when ubridge=1\;Reserved when Spectrum-2\;" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="mid" descr="Multicast port group index - index to the port group table." access="RW" offset="0x4.0" size="0x0.16" />
</node>

<node name="ppbs_pbs_record_auto_ext" descr="" attr_is_union="1" size="0x10.0" >
	<field name="ppbs_unicast_ext" descr="" subnode="ppbs_unicast_ext" offset="0x0.0" selected_by="Unicast_Record" size="0x8.0" />
	<field name="unicast_lag_ext" descr="" subnode="unicast_lag_ext" offset="0x0.0" selected_by="Unicast_LAG_Record" size="0x8.0" />
	<field name="ppbs_multicast_ext" descr="" subnode="ppbs_multicast_ext" offset="0x0.0" selected_by="Multicast_Record" size="0x8.0" />
	<field name="unicast_tunnel_ext" descr="" subnode="unicast_tunnel_ext" offset="0x0.0" selected_by="Unicast_Tunnel_Record" size="0x10.0" />
	<field name="multicast_tunnel_ext" descr="" subnode="multicast_tunnel_ext" offset="0x0.0" selected_by="Multicast_Tunnel_Record" size="0x10.0" />
</node>

<node name="ppbs_unicast_ext" descr="" size="0x8.0" >
	<field name="fid" descr="Filtering identifier (FID)\;Reserved when v_fid = 0\;Reserved when ubridge=1\;" access="RW" offset="0x0.0" size="0x0.16" />
	<field name="vid" descr="New VID when set_vid = 1\;Reserved when set_vid = 0\;Reserved when ubridge=0" access="RW" offset="0x0.16" size="0x0.12" />
	<field name="set_vid" descr="Set VID:\;0: do not update VID\;1: set VID\;For Spectrum-2 when set_vid=0 and smpe_valid=1 then the smpe will modify the vid\;Reserved when ubridge=0" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="v_fid" descr="valid FID:\;0: .1Q bridge, the VID is maintained\;1: .1D bridge, the VID is modified according to:\;{fid, system_port} -&gt; vid\;Where the mapping is according to SVFA register\;Reserved when ubridge=1" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="system_port" descr="Unique port identifier for the final destination of the packet\;Must be &apos;0&apos; when action is &apos;3&apos; - forward to IP router \;For SwitchX/-2 value of 0 is for drop\;Note: for Spectrum family, if action is 0 (forward) and system_port is 0 then the PPBS entry must not be used! (Must not be pointed by an ACL action)" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="action" descr="Action to apply on the packet:\;0: NOP - forward (based on the system_port destination)\;3: FORWARD_TO_IP_ROUTER\;4: FORWARD_TO_FCF - Reserved for Spectrum family.\;5: DISCARD - Reserved for Spectrum family.\;15: DISCARD_ERROR" access="RW" enum="NOP=0x0,FORWARD_TO_IP_ROUTER=0x3,FORWARD_TO_FCF=0x4,DISCARD=0x5,DISCARD_ERROR=0xf" offset="0x4.28" size="0x0.4" />
</node>

<node name="ppbt_ext" descr="" size="0x14.0" >
	<field name="lp_msb" descr="Local port[9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="When tport = 0:\;Local port \;Not including CPU port in Spectrum-1.\;From Spectrum-2 and on CPU port is supported.\;When tport = 1: Tunnel port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="tport" descr="Port is tunnel port\;Supported from Spectrum-2 and on" access="INDEX" offset="0x0.24" size="0x0.1" />
	<field name="op" descr="0: Bind ACL to Port\;1: Unbind ACL from Port (default)\;" access="RW" offset="0x0.28" size="0x0.3" />
	<field name="e" descr="0: iACL\;1: eACL" access="INDEX" enum="iACL=0x0,eACL=0x1" offset="0x0.31" size="0x0.1" />
	<field name="acl_id_group_id" descr="When g=0:\;ACL identifier (acl_id)\;Range of acl id is 0..cap_max_acl_regions-1\;When g=1:\;ACL group identifier (acl_group_id) or ACL group element (acl_group_element).\;For ACL group identifier, range of group id is 0..cap_max_acl_groups-1.\;For ACL group element, range of group element is 0..cap_max_acl_tot_groups-1." access="RW" offset="0x10.0" size="0x0.16" />
	<field name="g" descr="group\;0: bind an ACL\;1: bind an ACL group\;Must be set to 1 for Spectrum family" access="RW" offset="0x10.31" size="0x0.1" />
</node>

<node name="ppcnt_infiniband_general_counter_ext" descr="" size="0xf8.0" >
	<field name="rq_general_error_high" descr="The total number of packets that were dropped since it contained errors. Reasons for this include:\;1. dropped due to MPR mismatch.\;Supported only when indicated by PCAM.\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="rq_general_error_low" descr="The total number of packets that were dropped since it contained errors. Reasons for this include:\;1. dropped due to MPR mismatch.\;Supported only when indicated by PCAM.\;" access="RO" offset="0x14.0" size="0x4.0" />
</node>

<node name="ppcnt_infiniband_packets_counter_ext" descr="" size="0xf8.0" >
	<field name="time_since_last_clear_high" descr="The time passed since the last counters clear event in msec." access="RO" offset="0x0.0" size="0x4.0" />
	<field name="time_since_last_clear_low" descr="The time passed since the last counters clear event in msec." access="RO" offset="0x4.0" size="0x4.0" />
	<field name="port_unicast_xmit_pkts_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="port_unicast_xmit_pkts_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="port_unicast_rcv_pkts_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="port_unicast_rcv_pkts_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="sync_header_error_counter_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="sync_header_error_counter_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="port_local_physical_errors_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x20.0" size="0x4.0" />
	<field name="port_local_physical_errors_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x24.0" size="0x4.0" />
	<field name="port_malformed_packet_errors_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="port_malformed_packet_errors_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="port_buffer_overrun_errors_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="port_buffer_overrun_errors_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="port_dlid_mapping_errors_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="port_dlid_mapping_errors_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="port_vl_mapping_errors_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="port_vl_mapping_errors_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x44.0" size="0x4.0" />
	<field name="port_looping_errors_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x48.0" size="0x4.0" />
	<field name="port_looping_errors_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x4C.0" size="0x4.0" />
	<field name="port_inactive_discards_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x50.0" size="0x4.0" />
	<field name="port_inactive_discards_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x54.0" size="0x4.0" />
	<field name="port_neighbor_mtu_discards_high" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x58.0" size="0x4.0" />
	<field name="port_neighbor_mtu_discards_low" descr="For counter description please refer to the InfiniBand  Specification" access="RO" offset="0x5C.0" size="0x4.0" />
	<field name="port_llu_rx_icrc_error_high" descr="Total number of packets received on the port with ICRC error." access="RO" offset="0x60.0" size="0x4.0" />
	<field name="port_llu_rx_icrc_error_low" descr="Total number of packets received on the port with ICRC error." access="RO" offset="0x64.0" size="0x4.0" />
	<field name="port_tx_parity_error_high" descr="Total number of packets with parity error detected on the switch." access="RO" offset="0x68.0" size="0x4.0" />
	<field name="port_tx_parity_error_low" descr="Total number of packets with parity error detected on the switch." access="RO" offset="0x6C.0" size="0x4.0" />
</node>

<node name="ppcnt_plr_counters_ext" descr="" size="0xf8.0" >
	<field name="plr_rcv_codes_high" descr="Number of received PLR codewords\;\;" access="RO" offset="0x0.0" size="0x4.0" />
	<field name="plr_rcv_codes_low" descr="Number of received PLR codewords\;\;" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="plr_rcv_code_err_high" descr="The total number of rejected codewords received" access="RO" offset="0x8.0" size="0x4.0" />
	<field name="plr_rcv_code_err_low" descr="The total number of rejected codewords received" access="RO" offset="0xC.0" size="0x4.0" />
	<field name="plr_rcv_uncorrectable_code_high" descr="The number of uncorrectable codewords received\;" access="RO" offset="0x10.0" size="0x4.0" />
	<field name="plr_rcv_uncorrectable_code_low" descr="The number of uncorrectable codewords received\;" access="RO" offset="0x14.0" size="0x4.0" />
	<field name="plr_xmit_codes_high" descr="Number of transmitted PLR codewords" access="RO" offset="0x18.0" size="0x4.0" />
	<field name="plr_xmit_codes_low" descr="Number of transmitted PLR codewords" access="RO" offset="0x1C.0" size="0x4.0" />
	<field name="plr_xmit_retry_codes_high" descr="The total number of codewords retransmitted." access="RO" offset="0x20.0" size="0x4.0" />
	<field name="plr_xmit_retry_codes_low" descr="The total number of codewords retransmitted." access="RO" offset="0x24.0" size="0x4.0" />
	<field name="plr_xmit_retry_events_high" descr="The total number of retransmitted event. \;\;" access="RO" offset="0x28.0" size="0x4.0" />
	<field name="plr_xmit_retry_events_low" descr="The total number of retransmitted event. \;\;" access="RO" offset="0x2C.0" size="0x4.0" />
	<field name="plr_sync_events_high" descr="The number of sync events" access="RO" offset="0x30.0" size="0x4.0" />
	<field name="plr_sync_events_low" descr="The number of sync events" access="RO" offset="0x34.0" size="0x4.0" />
	<field name="plr_codes_loss_high" descr="Recieved bandwidth loss due to codes retransmission. calculated in resolution of \;(plr_rcv_code_err / plr_rcv_codes) * 10^10\;\;BW Loss % = (plr_codes_loss / 10^10 ) *100" access="RO" offset="0x38.0" size="0x4.0" />
	<field name="plr_codes_loss_low" descr="Recieved bandwidth loss due to codes retransmission. calculated in resolution of \;(plr_rcv_code_err / plr_rcv_codes) * 10^10\;\;BW Loss % = (plr_codes_loss / 10^10 ) *100" access="RO" offset="0x3C.0" size="0x4.0" />
	<field name="plr_xmit_retry_events_within_t_sec_max_high" descr="The maximum number of retransmitted events in t sec window\;" access="RO" offset="0x40.0" size="0x4.0" />
	<field name="plr_xmit_retry_events_within_t_sec_max_low" descr="The maximum number of retransmitted events in t sec window\;" access="RO" offset="0x44.0" size="0x4.0" />
</node>

<node name="ppcnt_reg_counter_set_auto_ext" descr="" attr_is_union="1" size="0xf8.0" >
	<field name="eth_802_3_cntrs_grp_data_layout_ext" descr="" subnode="eth_802_3_cntrs_grp_data_layout_ext" offset="0x0.0" selected_by="IEEE_802_3_Counters" size="0xf8.0" />
	<field name="eth_2863_cntrs_grp_data_layout_ext" descr="" subnode="eth_2863_cntrs_grp_data_layout_ext" offset="0x0.0" selected_by="RFC_2863_Counters" size="0xf8.0" />
	<field name="eth_2819_cntrs_grp_data_layout_ext" descr="" subnode="eth_2819_cntrs_grp_data_layout_ext" offset="0x0.0" selected_by="RFC_2819_Counters" size="0xf8.0" />
	<field name="eth_3635_cntrs_grp_data_layout_ext" descr="" subnode="eth_3635_cntrs_grp_data_layout_ext" offset="0x0.0" selected_by="RFC_3635_Counters" size="0xf8.0" />
	<field name="eth_extended_cntrs_grp_data_layout_ext" descr="" subnode="eth_extended_cntrs_grp_data_layout_ext" offset="0x0.0" selected_by="Ethernet_Extended_Counters" size="0xf8.0" />
	<field name="eth_discard_cntrs_grp_ext" descr="" subnode="eth_discard_cntrs_grp_ext" offset="0x0.0" selected_by="Ethernet_Discard_Counters" size="0xf8.0" />
	<field name="eth_per_prio_grp_data_layout_ext" descr="" subnode="eth_per_prio_grp_data_layout_ext" offset="0x0.0" selected_by="Per_Priority_Counters" size="0xf8.0" />
	<field name="eth_per_traffic_class_layout_ext" descr="" subnode="eth_per_traffic_class_layout_ext" offset="0x0.0" selected_by="Per_Traffic_Class_Counters" size="0xf8.0" />
	<field name="phys_layer_cntrs_ext" descr="" subnode="phys_layer_cntrs_ext" offset="0x0.0" selected_by="Physical_Layer_Counters" size="0xf8.0" />
	<field name="eth_per_traffic_class_cong_layout_ext" descr="" subnode="eth_per_traffic_class_cong_layout_ext" offset="0x0.0" selected_by="Per_Traffic_Class_Congestion_Counters" size="0xf8.0" />
	<field name="phys_layer_stat_cntrs_ext" descr="" subnode="phys_layer_stat_cntrs_ext" offset="0x0.0" selected_by="Physical_Layer_Statistical_Counters" size="0xf8.0" />
	<field name="IB_portcntrs_attribute_grp_data_ext" descr="" subnode="IB_portcntrs_attribute_grp_data_ext" offset="0x0.0" selected_by="InfiniBand_Port_Counters" size="0xf8.0" />
	<field name="IB_long_portcntrs_attribute_grp_data_ext" descr="" subnode="IB_long_portcntrs_attribute_grp_data_ext" offset="0x0.0" selected_by="InfiniBand_Extended_Port_Counters" size="0xf8.0" />
	<field name="ppcnt_plr_counters_ext" descr="" subnode="ppcnt_plr_counters_ext" offset="0x0.0" selected_by="PLR_counters_group" size="0xf8.0" />
	<field name="ppcnt_rs_fec_histograms_counters_ext" descr="" subnode="ppcnt_rs_fec_histograms_counters_ext" offset="0x0.0" selected_by="RS_FEC_Histogram_group" size="0xf8.0" />
	<field name="ppcnt_infiniband_packets_counter_ext" descr="" subnode="ppcnt_infiniband_packets_counter_ext" offset="0x0.0" selected_by="InfiniBand_pkts_counters" size="0xf8.0" />
	<field name="ppcnt_infiniband_general_counter_ext" descr="" subnode="ppcnt_infiniband_general_counter_ext" offset="0x0.0" selected_by="InfiniBand_General_Counters" size="0xf8.0" />
</node>

<node name="ppcnt_reg_ext" descr="" size="0x100.0" >
	<field name="grp" descr="Performance counter group.\;Group 63 indicates all groups (include all per priority/TC/Receive Buffer counters). Only valid on Set() operation with clr bit set.\;0x0: IEEE_802_3_Counters\;0x1: RFC_2863_Counters\;0x2: RFC_2819_Counters\;0x3: RFC_3635_Counters\;0x5: Ethernet_Extended_Counters\;0x6: Ethernet_Discard_Counters \;0x10: Per_Priority_Counters - \;0x11: Per_Traffic_Class_Counters - \;0x12: Physical_Layer_Counters\;0x13: Per_Traffic_Class_Congestion_Counters\;0x16: Physical_Layer_Statistical_Counters\;0x20: InfiniBand_Port_Counters\;0x21: InfiniBand_Extended_Port_Counters\;0x22: PLR_counters_group\;0x23: RS_FEC_Histogram_group\;0x25: InfiniBand_pkts_counters\;0x26: InfiniBand_General_Counters\;0x27: L1_General_Counters" access="INDEX" enum="IEEE_802_3_Counters=0x0,RFC_2863_Counters=0x1,RFC_2819_Counters=0x2,RFC_3635_Counters=0x3,Ethernet_Extended_Counters=0x5,Ethernet_Discard_Counters=0x6,Per_Priority_Counters=0x10,Per_Traffic_Class_Counters=0x11,Physical_Layer_Counters=0x12,Per_Traffic_Class_Congestion_Counters=0x13,Physical_Layer_Statistical_Counters=0x16,InfiniBand_Port_Counters=0x20,InfiniBand_Extended_Port_Counters=0x21,PLR_counters_group=0x22,RS_FEC_Histogram_group=0x23,InfiniBand_pkts_counters=0x25,InfiniBand_General_Counters=0x26" offset="0x0.0" size="0x0.6" />
	<field name="port_type" descr="Supported only when indicated by PCAM on FPGA based NICs:\;0 - Network Port\;1 - Near-End Port (For Retimer/Gearbox - Host side)\;2 - Internal IC LR Port \;3 - Far-End Port (For Retimer/Gearbox - Line side)" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type:\;0: Local_port_number\;1: IB_port_number\;2: host_port_number\;\;Note - pnat=2 is supported for &quot;Per Traffic Class Congestion Counters&quot; and &quot;Per Traffic Class Counters&quot; groups." access="INDEX" enum="Local_port_number=0x0,IB_port_number=0x1,host_port_number=0x2" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number. \;Note:\;when lp_gl = 0, 255 indicates all ports on the device, and is only allowed for Set() operation.\;when lp_gl = 1, the index is a global port number\;Note: for HCA this bit is not supported, ignored by device" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="swid" descr="For HCA: must be always 0.\;Switch partition ID to associate port with.\;Switch partitions are numbered from 0 to 7 inclusively.\;Switch partition 254 indicates stacking ports.\;Switch partition 255 indicates all switch partitions.\;Only valid on Set() operation with local_port=255." access="INDEX" offset="0x0.24" size="0x0.8" />
	<field name="prio_tc" descr="Priority index for per priority counter sets, valid values: 0-7\;For Spectrum-2 and on at tx side range can be 0 .. cap_max_tclass_data-1, see QGCR.tx_cnt_tclass\;\;Traffic class index for per traffic class counter set, valid values: \;For Switches, valid values: 0 .. cap_max_tclass_data-1 \;\;For HCA, valid values: 0.. HCA_CAP.max_tc\;\;Otherwise must be 0.\;" access="INDEX" offset="0x4.0" size="0x0.5" />
	<field name="grp_profile" descr="Supported only when indicated by PCAM: PPCNT_grp_profile_supported (bit 73).\;The group profile index. Relevant only if the clr bit is set.\;0: Will reset the counter value for all counters in the counter group.\;Else: Will point to the corresponding bit-map profile in the PPCGP register. The bit map will return the specific counters that will be reset in the group.\;\;NOTE: The grp_profile index is not supported for the following counters groups:\;1. 0x12: Physical_Layer_Counters\;2. 0x16: Physical_Layer_Statistical_Counters\;3. 0x22: PLR_counters_group\;" access="INDEX" offset="0x4.5" size="0x0.3" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x4.8" size="0x0.4" />
	<field name="counters_cap" descr="counters_cap is supported if PCAM.feature_cap_mask bit 85 is set.\;When set, each counter in the group will show in bit 0 if the counter is supported.\;&apos;0&apos; - not supported\;&apos;1&apos; - supported\;Note: To know which PPCNT groups are supported per device, listed in table TBD or PCAM fields with PPCNT can be queried." access="OP" offset="0x4.29" size="0x0.1" />
	<field name="lp_gl" descr="Local Port global variable\;0: local_port port 255 = all ports of the device.\;1: local_port index indicates Local port number.\;for HCA this bit is not supported, ignored by device" access="INDEX" offset="0x4.30" size="0x0.1" />
	<field name="clr" descr="Clear counters. Setting the clr bit will reset the counter value for all counters in the counter group. This bit can be set for both Set() and Get() operation.\;\;NOTE: Clearing a certain group&apos;s counters can influence another group&apos;s counters value." access="OP" offset="0x4.31" size="0x0.1" />
	<field name="counter_set" descr="Counter set as described in\;Table 1485, &quot;Ethernet IEEE 802.3 Counters Group Data Layout,&quot; on page 1766\;Table 1487, &quot;Ethernet RFC 2863 Counter Group Data Layout,&quot; on page 1771\;Table 1489, &quot;Ethernet RFC 2819 Counter Group Data Layout,&quot; on page 1775\;Table 1491, &quot;Ethernet RFC 3635 Counter Group Data Layout,&quot; on page 1780\;Table 1493, &quot;Ethernet Extended Counter Group Data Layout,&quot; on page 1784\;Table 1496, &quot;Ethernet Discard Counter Group Fields,&quot; on page 1789\;Table 1497, &quot;Ethernet Per Priority Group Data Layout,&quot; on page 1792\;Table 1501, &quot;Ethernet Per Traffic Class Group data layout,&quot; on page 1800\;Table 1513, &quot;Physical Layer Counters Data Layout,&quot; on page 1811\;Table 1503, &quot;Ethernet Per Traffic Class Congestion Group data layout,&quot; on page 1801\;Table 1517, &quot;Physical Layer Statistical Counters Data Layout,&quot; on page 1821\;Table 1509, &quot;InfiniBand PortCounters Attribute Group Data Layout,&quot; on page 1805\;Table 1511, &quot;InfiniBand Extended PortCounters Attribute Group Data Layout,&quot; on page 1807\;Table 1519, &quot;PLR Counters Data Layout,&quot; on page 1827 \;Table 1521, &quot;RS-Histograms Data Layout,&quot; on page 1829\;Table 1523, &quot;InfiniBand Packets Counters Data Layout,&quot; on page 1830\;Table 1525, &quot;InfiniBand General Counters Data Layout,&quot; on page 1833" subnode="ppcnt_reg_counter_set_auto_ext" access="RO" offset="0x8.0" size="0xf8.0" union_selector="$(parent).grp" />
</node>

<node name="ppcnt_rs_fec_histograms_counters_ext" descr="" size="0xf8.0" >
	<field name="hist" descr="Value of RS-hist\;In order to know bin errors distribution use PPHCR reg." subnode="uint64" access="RO" high_bound="20" low_bound="0" offset="0x0.0" size="0xa8.0" />
</node>

<node name="pphcr_bin_range_ext" descr="" size="0x4.0" >
	<field name="low_val" descr="low range of bin&apos;s measurement" access="RW" offset="0x0.0" size="0x0.4" />
	<field name="high_val" descr="high range of bin&apos;s measurement" access="RW" offset="0x0.16" size="0x0.4" />
</node>

<node name="pphcr_ext" descr="" size="0x50.0" >
	<field name="we" descr="Support of histogram bins configuration. \;In case this bit is cleared, the port doesn&apos;t support configuration of the histogram bins, for the specific hist_type." access="RO" offset="0x0.0" size="0x0.1" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="port_type" descr="0 - Network Port\;1 - Near-End Port (For Retimer/Gearbox - Host side)\;3 - Far-End Port (For Retimer/Gearbox - Line side)\;Other values are reserved." access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type:\;0: Local_port_number\;1: IB_port_number" access="INDEX" enum="Local_port_number=0x0,IB_port_number=0x1" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="local_port or DataPath number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="active_hist_type" descr="0 - Invalid (Link down / unsupported) \;1 - KP4 RS-FEC (544,514) errors \;2 - LL RS-FEC (271,257) / (272,257+1) errors\;3 - KR4 RS-FEC (528,514) errors\;4 - PRBS errors" access="RO" offset="0x0.28" size="0x0.4" />
	<field name="hist_type" descr="0: According to active link" access="INDEX" offset="0x4.0" size="0x0.4" />
	<field name="num_of_bins" descr="Available number of bins \;" access="RO" offset="0x4.16" size="0x0.8" />
	<field name="hist_min_measurement" descr="Lowest measurement/low limit of the histogram \;Example:\;In case of hist_type = 1, represent KP4 RS FEC symbol errors(= 0)\;In case of hist_type = 2, represent LL RS FEC symbol errors ( = 0)\;" access="RO" offset="0x8.0" size="0x0.8" />
	<field name="hist_max_measurement" descr="Highest measurement/high limit of the histogram:\;Example:\;In case of hist_type = 1, represent KP4 RS FEC symbol errors ( = 15)\;In case of hist_type = 2, represent LL RS FEC symbol errors ( = 7)" access="RO" offset="0x8.16" size="0x0.8" />
	<field name="bin_range_write_mask" descr="Valid only if we (write enable) = 1 \;Ignored on GET \;Write mask for the bin_range array. \;If bit X is set, bin_range [X] write should be execute\;Else if bit X is clear, ignored value in written to bin_range [X]" access="WO" offset="0xC.0" size="0x0.16" />
	<field name="bin_range" descr="Write to bin_range[x] is applicable only if we = 1 &amp; the corresponding bits in bin_range_write_mask is set.\;Mapping of measurement units to a bin.\;See Table 1797, &quot;PPHCR - Port Phy Bin Range Histogram Configuration Layout,&quot; on page 2166" subnode="pphcr_bin_range_ext" access="RW" high_bound="15" low_bound="0" offset="0x10.0" size="0x40.0" />
</node>

<node name="pplm_reg_ext" descr="" size="0x50.0" >
	<field name="test_mode" descr="0: Mission_mode_configuration_and_capabilities\;1: Test_mode_configuration_and_capabilities" access="INDEX" enum="Mission_mode_configuration_and_capabilities=0x0,Test_mode_configuration_and_capabilities=0x1" offset="0x0.1" size="0x0.1" />
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="port_type" descr="Supported only when indicated by PCAM \;0: Network_Port\;1: Near_End_Port - For Gearbox - Host side\;2: Internal_IC_Port \;3: Far_End_Port - For Gearbox - Line side\;\;Other values are reserved.\;\;Using port_type &apos;0&apos; will override all different parts of the link structure.\;Using port_type &apos;1&apos; will configure also port_type &apos;2&apos; accordingly and vise versa." access="INDEX" enum="Network_Port=0x0,Near_End_Port=0x1,Internal_IC_Port=0x2,Far_End_Port=0x3" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. \;0: Local_port_number\;1: IB_port_number" access="INDEX" enum="Local_port_number=0x0,IB_port_number=0x1" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="Local port number" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="fec_mode_active" descr="Active FEC (bitmask)\;For each enum, a short prefix for tools is presented in the row below.\;0: No_FEC \;1: Firecode_FEC\;FC_FEC\;2: Standard_RS_FEC - RS(528,514)\;KR4_FEC\;3: Standard_LL_RS_FEC - RS(271,257)\;LL_FEC\;5: reserved - [Internal]\;6: Interleaved_Standard_RS-FEC - (544,514)\;Int_KP4_FEC\;7: Standard_RS-FEC - (544,514)\;KP4_FEC\;9: Ethernet_Consortium_LL_50G_RS_FEC- (272,257+1)\;ELL_FEC\;10: Interleaved_Ethernet_Consortium_LL_50G_RS_FEC - (272,257+1)\;Int_ELL_FEC\;12: RS-FEC - (544,514) + PLR\;13: LL-FEC - (271,257) + PLR\;14: Ethernet_Consortium_LL_50G_RS_FEC_PLR - (272,257+1) [Internal] \;15: Interleaved_Ethernet_Consortium_LL_50G_RS_FEC_PLR - (272,257+1) [Internal]\;" access="RO" enum="No_FEC=0x0,Firecode_FEC=0x1,Standard_RS_FEC=0x2,Standard_LL_RS_FEC=0x3,Interleaved_Standard_RS=0x6,Standard_RS=0x7,Ethernet_Consortium_LL_50G_RS_FEC=0x9,Interleaved_Ethernet_Consortium_LL_50G_RS_FEC=0xa" offset="0xC.0" size="0x0.24" />
	<field name="fec_override_cap_10g_40g" descr="10GE/40GE Ethernet FEC override capability bitmask:\;Bit 0: No-FEC\;Bit 1: Firecode_FEC\;Bit 2: Reserved2\;Bit 3: Reserved3\;\;" access="RO" enum="No=0x1,Firecode_FEC=0x2,Reserved2=0x4,Reserved3=0x8" offset="0x10.0" size="0x0.4" />
	<field name="fec_override_cap_25g" descr="25GE Ethernet FEC override capability bitmask:\;Bit 0: No-FEC\;Bit 1: Firecode_FEC\;Bit 2: RS-FEC\;Bit 3: Reserved" access="RO" enum="No=0x1,Firecode_FEC=0x2,RS=0x4,Reserved=0x8" offset="0x10.4" size="0x0.4" />
	<field name="fec_override_cap_50g" descr="50GE (2 lanes) Ethernet FEC override capability bitmask:\;Bit 0: No-FEC\;Bit 1: Firecode_FEC\;Bit 2: RS-FEC\;Bit 3: Reserved" access="RO" enum="No=0x1,Firecode_FEC=0x2,RS=0x4,Reserved=0x8" offset="0x10.8" size="0x0.4" />
	<field name="fec_override_cap_100g" descr="100GE (4 lanes) Ethernet FEC override capability bitmask:\;Bit 0: No-FEC\;Bit 1: Reserved1\;Bit 2: RS-FEC - (528,514)\;Bit 3: Reserved3" access="RO" enum="No=0x1,Reserved1=0x2,RS=0x4,Reserved3=0x8" offset="0x10.12" size="0x0.4" />
	<field name="fec_override_cap_56g" descr="56GE Ethernet FEC override capability bitmask:\;Bit 0: No-FEC\;Bit 1: Firecode_FEC\;Bit 2: Reserved2\;Bit 3: Reserved3" access="RO" enum="No=0x1,Firecode_FEC=0x2,Reserved2=0x4,Reserved3=0x8" offset="0x10.16" size="0x0.4" />
	<field name="rs_fec_correction_bypass_cap" descr="RS-FEC correction bypass override capability:\;0: NO_correction_bypass\;1: RS-FEC_correction_bypass" access="RO" enum="NO_correction_bypass=0x0,RS=0x1" offset="0x10.28" size="0x0.4" />
	<field name="fec_override_admin_10g_40g" descr="10GE/40GE Ethernet FEC override admin, see 10g_40g_fec_override_cap.\;(one-hot setting): \;0: auto_mode - no override\;Bit 0: No_FEC\;Bit 1: Firecode_FEC\;\;" access="RW" enum="No_FEC=0x1,Firecode_FEC=0x2" offset="0x14.0" size="0x0.4" />
	<field name="fec_override_admin_25g" descr="25GE Ethernet FEC override admin, see 25g_fec_override_cap. (one-hot setting): \;0: auto_mode - no override\;Bit 0: No_FEC\;Bit 1: Firecode_FEC\;Bit 2: RS-FEC\;\;Note - 25g_fec_override_admin and 50g_fec_override_admin must be set with the same value." access="RW" enum="No_FEC=0x1,Firecode_FEC=0x2,RS=0x4" offset="0x14.4" size="0x0.4" />
	<field name="fec_override_admin_50g" descr="50GE Ethernet FEC override admin, see 50g_fec_override_cap. (one-hot setting): \;0: auto_mode - no override\;Bit 0: No_FEC\;Bit 1: Firecode_FEC\;Bit 2: RS-FEC\;\;Note - 25g_fec_override_admin and 50g_fec_override_admin must be set with the same value." access="RW" enum="No_FEC=0x1,Firecode_FEC=0x2,RS=0x4" offset="0x14.8" size="0x0.4" />
	<field name="fec_override_admin_100g" descr="100GE Ethernet FEC override admin, see 100g_fec_override_cap. (one-hot setting): \;0: auto_mode - no override\;Bit 0: No_FEC\;Bit 2: RS-FEC" access="RW" enum="No_FEC=0x1,RS=0x4" offset="0x14.12" size="0x0.4" />
	<field name="fec_override_admin_56g" descr="56GE Ethernet FEC override admin, see 56g_fec_override_cap. (one-hot setting): \;0: auto_mode - no override\;Bit 0: No_FEC\;Bit 1: Firecode_FEC" access="RW" enum="No_FEC=0x1,Firecode_FEC=0x2" offset="0x14.16" size="0x0.4" />
	<field name="rs_fec_correction_bypass_admin" descr="RS-FEC correction bypass override admin: (one-hot setting): \;0: auto_mode - no override \;1: NO_correction_bypass\;2: RS-FEC_correction_bypass" access="RW" enum="auto_mode=0x0,NO_correction_bypass=0x1,RS=0x2" offset="0x14.28" size="0x0.4" />
	<field name="fec_override_cap_200g_4x" descr="200GE FEC override capability bitmask:\;Bit 8: Zero_Latency_FEC\;Bit 9: Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1\;Others bits reserved" access="RO" enum="Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1=0x200" offset="0x18.0" size="0x0.16" />
	<field name="fec_override_cap_400g_8x" descr="400GE FEC override capability bitmask:\;Bit 8: Zero_Latency_FEC\;Bit 9: Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1\;All others are reserved" access="RO" enum="Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1=0x200" offset="0x18.16" size="0x0.16" />
	<field name="fec_override_cap_50g_1x" descr="50GE single lane override capability bitmask:\;Bit 8: Zero_Latency_FEC\;Bit 9: Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1\;All others are reserved" access="RO" enum="Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1=0x200" offset="0x1C.0" size="0x0.16" />
	<field name="fec_override_cap_100g_2x" descr="100GE over 2 lanes, FEC override capability bitmask:\;Bit 8: Zero_Latency_FEC\;Bit 9: Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1\;All others are reserved" access="RO" enum="Fifty50G_Ethernet_Consortium_LL_RS_FEC_272_257plus1=0x200" offset="0x1C.16" size="0x0.16" />
	<field name="fec_override_admin_200g_4x" descr="200GE FEC override admin bitmask (one-hot setting) \;0: Auto_mode\;Bit 7: RS_FEC_544_514 - (544,514)\;Bit 9: RS_FEC_272_257_plus_1 - (272,257+1)" access="RW" enum="RS_FEC_544_514=0x80,RS_FEC_272_257_plus_1=0x200" offset="0x20.0" size="0x0.16" />
	<field name="fec_override_admin_400g_8x" descr="400GE FEC override admin bitmast (one-hot setting): \;0: Auto_mode\;Bit7: RS_FEC_544_514\;Bit 9: RS_FEC_272_257_plus_1 - (272,257+1)" access="RW" enum="RS_FEC_544_514=0x80,RS_FEC_272_257_plus_1=0x200" offset="0x20.16" size="0x0.16" />
	<field name="fec_override_admin_50g_1x" descr="50GE, 1lanes FEC override admin bitmask (one-hot setting)\;0: Auto_mode\;Bit 7: RS_FEC_544_514 - (544,514)\;Bit 9: RS_FEC_272_257_plus_1 - (272,257+1)" access="RW" enum="RS_FEC_544_514=0x80,RS_FEC_272_257_plus_1=0x200" offset="0x24.0" size="0x0.16" />
	<field name="fec_override_admin_100g_2x" descr="100GE, 2 lanes FEC override admin bitmask (one-hot setting):\;0: Auto_mode\;Bit 7: RS_FEC_544_514 - (544,514)\;Bit 9: RS_FEC_272_257_plus_1 - (272,257+1)" access="RW" enum="RS_FEC_544_514=0x80,RS_FEC_272_257_plus_1=0x200" offset="0x24.16" size="0x0.16" />
	<field name="fec_override_cap_400g_4x" descr="400GE, 4 lanes FEC override capability bitmask:\;Bit 7: RS_FEC_544_514 - (544,514)\;Bit 9: Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1 - (272,257+1)\;Other bits Reserved" access="RO" enum="RS_FEC_544_514=0x80,Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1=0x200" offset="0x28.0" size="0x0.16" />
	<field name="fec_override_cap_800g_8x" descr="800GE, 8 lanes FEC override capability bitmask:\;Bit 7: RS_FEC_544_514 - RS-FEC (544,514)\;Bit 8: Reserved\;Bit 9: Ethernet_Consortium_LL_50G_RS_FEC- (272,257+1)\;Other bits Reserved" access="RO" enum="RS_FEC_544_514=0x80,Reserved=0x100,Ethernet_Consortium_LL_50G_RS_FEC=0x200" offset="0x28.16" size="0x0.16" />
	<field name="fec_override_cap_100g_1x" descr="100GE, 1 lane FEC override capability bitmask:\;Bit 6: Interleaved_RS_FEC_544_514\;Bit 7: RS_FEC_544_514\;Bit 9: Ethernet_Consortium_Low_Latency_RS_FEC_272_257_plus_1\;Bit 10: Interleaved_Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1\;Other bits reserved" access="RO" enum="Interleaved_RS_FEC_544_514=0x40,RS_FEC_544_514=0x80,Ethernet_Consortium_Low_Latency_RS_FEC_272_257_plus_1=0x200,Interleaved_Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1=0x400" offset="0x2C.0" size="0x0.16" />
	<field name="fec_override_cap_200g_2x" descr="200GE, 2 lanes FEC override capability bitmask:\;Bit 7: RS_FEC_544_514\;Bit 9: Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1\;Other bits Reserved" access="RO" enum="RS_FEC_544_514=0x80,Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1=0x200" offset="0x2C.16" size="0x0.16" />
	<field name="fec_override_admin_400g_4x" descr="400GE, 4 lanes FEC override admin bitmask (one-hot setting):\;0: Auto_mode\;Bit 7: RS_FEC_544_514\;Bit 9: Ethernet_Consortium_Low_Latency_RS_FEC_272_257plus_1\;Other bits Reserved" access="RW" enum="Auto_mode=0x0,RS_FEC_544_514=0x80,Ethernet_Consortium_Low_Latency_RS_FEC_272_257plus_1=0x200" offset="0x44.0" size="0x0.16" />
	<field name="fec_override_admin_800g_8x" descr="800GE, 8 lanes FEC override admin bitmask (one-hot setting):\;0: Auto_mode\;Bit 7: RS_FEC_544_514\;Bit 9: Ethernet_Consortium_Low_Latency_RS_FEC_272_257plus_1\;Other bits Reserved" access="RW" enum="Auto_mode=0x0,RS_FEC_544_514=0x80,Ethernet_Consortium_Low_Latency_RS_FEC_272_257plus_1=0x200" offset="0x44.16" size="0x0.16" />
	<field name="fec_override_admin_100g_1x" descr="100GE, 1 lane FEC override admin bitmask (one-hot setting):\;0: Auto_mode\;Bit 6: Interleaved_RS_FEC_544_514\;Bit 7: RS_FEC_544_514\;Bit 9: Ethernet_Consortium_50G_Low_Latency_RS_FEC_272_257_plus_1\;Bit 10: Interleaved_Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1\;Other bits Reserved" access="RW" enum="Auto_mode=0x0,Interleaved_RS_FEC_544_514=0x40,RS_FEC_544_514=0x80,Ethernet_Consortium_50G_Low_Latency_RS_FEC_272_257_plus_1=0x200,Interleaved_Ethernet_Consortium_LL_50G_RS_FEC_272_257_plus_1=0x400" offset="0x48.0" size="0x0.16" />
	<field name="fec_override_admin_200g_2x" descr="200GE, 2 lanes FEC override admin bitmask (one-hot setting):\;0: Auto_mode\;Bit 7: RS_FEC_544_514\;Bit 9: Ethernet_Consortium_Low_Latency_RS_FEC_272_257_plus_1\;Other bits Reserved" access="RW" enum="Auto_mode=0x0,RS_FEC_544_514=0x80,Ethernet_Consortium_Low_Latency_RS_FEC_272_257_plus_1=0x200" offset="0x48.16" size="0x0.16" />
</node>

<node name="pplr_reg_ext" descr="" size="0x8.0" >
	<field name="plane_ind" descr="Reserved for non-planarized port.\;Plane port index of the aggregated port. A value of 0 refers to the aggregated port only." access="INDEX" offset="0x0.0" size="0x0.4" />
	<field name="port_type" descr="For HCA supported only when indicated by PCAM \;0: Network_Port\;1: Near-End_Port- (For Retimer/Gearbox - Host side)\;2: Internal_IC_LR_Port \;3: Far-End_Port - (For Retimer/Gearbox - Line side)\;Other values are reserved." access="INDEX" enum="Network_Port=0x0,Near=0x1,Internal_IC_LR_Port=0x2,Far=0x3" offset="0x0.4" size="0x0.4" />
	<field name="op_mod" descr="operational mode for link configurations for phy_ local_loopback mode.\;0 - link will operate in optimal latency performance mode\;1 - link will operate in same configurations as operational port.\;\;Note: for FEC override via PPLM register, chosen FEC will be according to the PPLM configuration that was set and this bit will be ignored for FEC purposes" access="OP" offset="0x0.8" size="0x0.1" />
	<field name="apply_im" descr="Apply immediate: When set, the enabled/disabled loopback will be set immediately even if link is active.\;Note: Currently supported only for Bit 7: LL_local_loopback. in other loopbacks will be ignored" access="OP" offset="0x0.9" size="0x0.1" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="lb_en" descr="Loopback enable - One-hot key.\;Bit 0: Phy_remote_loopback\;Bit 1: Phy_local_loopback\;Bit 2: External_local_loopback\;Bit 7: LL_local_loopback\;\;\;" access="RW" enum="Phy_remote_loopback=0x1,Phy_local_loopback=0x2,External_local_loopback=0x4,LL_local_loopback=0x80" offset="0x4.0" size="0x0.12" />
	<field name="lb_cap" descr="Loopback capability - bitmask\;Bit 0: Phy_remote_loopback\;Bit 1: Phy_local_loopback - When set the port&apos;s egress traffic is looped back to the receiver and the port transmitter is disabled.\;Bit 2: External_local_loopback - Enables the port&apos;s transmitter to link with the port&apos;s receiver using an external loopback connector.\;Bit 4: Near_end_digital_loopback - [Internal]\;Bit 7: LL_local_loopback - When set the port&apos;s egress Link layer traffic is looped back to the receiver. Physical port in this loopback mode is down.\;\;Note - Phy remote loopback can be supported only for lane rate higher than 25Gbuad in the 16nm devices.\;\;In Ethernet, when LL_Local_loopback is set and physical link is not down, physical state may reach only up to Phy Up state and forced to send Local Faults. When released link may transition to LinkUp state" access="RO" enum="Phy_remote_loopback=0x1,Phy_local_loopback=0x2,External_local_loopback=0x4,LL_local_loopback=0x80" offset="0x4.16" size="0x0.12" />
</node>

<node name="pprr_ext" descr="" size="0x14.0" >
	<field name="register_index" descr="Index of Port Range Register being accessed\;Range is 0 .. cap_max_acl_l4_port_range-1" access="INDEX" offset="0x0.0" size="0x0.8" />
	<field name="ip_length" descr="Field type (ip_length is a legacy inadequate name). Reserved when SwitchX/-2\;Note: Values 0,1, apply to both inner and outer depending on outer_inner field. Values 2,3,4,5,6 are not supported when outer_inner is INNER\;\;0: L4_PORT\;1: IP_LENGTH\;2: TTL\;3: CUSTOM_BYTE_SET\;4: ING_LOCAL_PORT_USER_MEM\;5: UTC_29_14\;6: PRBS.\;15: None" access="RW" enum="L4_PORT=0x0,IP_LENGTH=0x1,TTL=0x2,CUSTOM_BYTE_SET=0x3,ING_LOCAL_PORT_USER_MEM=0x4,UTC_29_14=0x5,PRBS_=0x6,None=0xf" offset="0x0.16" size="0x0.4" />
	<field name="outer_inner" descr="0: OUTER - Apply port range register to outer IP header\;1: INNER - Apply port range register to inner IP header, Reserved when SwitchX/-2, supported by Spectrum family\;2: BOTH - Apply port range register to outer IP header or to inner IP header, Reserved when SwitchX/-2, and for Spectrum-2" access="RW" enum="OUTER=0x0,INNER=0x1,BOTH=0x2" offset="0x0.22" size="0x0.2" />
	<field name="ignore_l4" descr="Ignore L4. Apply port range register regardless of L4. When set tcp and udp are reserved. Default 0.\;Must not be set when ip_length points to layer 4 fields.\;Reserved when SwitchX/-2 or Spectrum" access="RW" offset="0x0.24" size="0x0.1" />
	<field name="ignore_l3" descr="Ignore L3. Apply port range register regardless of L3. When set ipv4 and ipv6 are reserved. Default 0.\;Must not be set when ip_length points to layer 3 fields.\;Reserved when SwitchX/-2 or Spectrum" access="RW" offset="0x0.25" size="0x0.1" />
	<field name="udp" descr="Apply port range register to UDP packets\;Default 0" access="RW" offset="0x0.26" size="0x0.1" />
	<field name="tcp" descr="Apply port range register to TCP packets\;Default 0" access="RW" offset="0x0.27" size="0x0.1" />
	<field name="dst" descr="Apply port range register to destination L4 ports\;Default 0" access="RW" offset="0x0.28" size="0x0.1" />
	<field name="src" descr="Apply port range register to source L4 ports\;Default 0" access="RW" offset="0x0.29" size="0x0.1" />
	<field name="ipv6" descr="Apply port range register to IPv6 packets\;Default 0" access="RW" offset="0x0.30" size="0x0.1" />
	<field name="ipv4" descr="Apply port range register to IPv4 packets\;Default 0" access="RW" offset="0x0.31" size="0x0.1" />
	<field name="port_range_max" descr="Maximum port range for comparison" access="RW" offset="0x4.0" size="0x0.16" />
	<field name="port_range_min" descr="Minimum port range for comparison.\;Match is defined as: \;port_range_min &lt;= packet_port &lt;= port_range_max" access="RW" offset="0x4.16" size="0x0.16" />
	<field name="comp_type" descr="Comparator type:\;0: Range - from port_range_min to port_range_max\;1: Match_Val - match either port_range_min or port_range_max, supported from Spectrum-4 and on\;[Spectrum-4]\;Supported from Spectrum-4 and above." access="RW" enum="Range=0x0,Match_Val=0x1" offset="0x8.0" size="0x0.2" />
	<field name="cbset" descr="Custom Bytes Set\;Range 0 .. cap_max_custom_byte_sets-1See encoding in Table 3329, &quot;Spectrum Custom Bytes Sets,&quot; on page 3572\;Note: at a given time no more than 2 cbsets can be used (for different register_index values)\;Reserved when ip_length != CUSTOM_BYTE_SET\;Reserved when SwitchX/-2 and Spectrum\;" access="RW" offset="0x10.0" size="0x0.8" />
</node>

<node name="pprt_reg_ext" descr="" size="0x24.0" >
	<field name="le" descr="Per Lane configuration enable (can be set only if ls = 1):\;0 - No per lane configuration\;1 - Per lane configurations\;When le is cleared, lane index is reserved and all PPRT configurations are taking place on all lanes.\;When le is set, configurations are taking place per lane based on lane index\;Affects lane indexing for set operations only, ignored for get operations." access="OP" offset="0x0.0" size="0x0.1" />
	<field name="ls" descr="Per Lane configuration support: \;0 - No support of per lane configuration\;1 - Support of per lane configuration" access="RO" offset="0x0.1" size="0x0.1" />
	<field name="port_type" descr="Supported only when indicated by PCAM \;0 - Network Port\;1 - Near-End Port (For Retimer/Gearbox - Host side)\;2 - Internal IC LR Port \;3 - Far-End Port (For Retimer/Gearbox - Line side)\;Other values are reserved.\;" access="INDEX" offset="0x0.4" size="0x0.4" />
	<field name="lane" descr="Reserved when (le=0 or ls = 0)\;Logical lane number" access="INDEX" offset="0x0.8" size="0x0.4" />
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="pnat" descr="Port number access type. determines the way local_port is interpreted:\;0 - Local port number\;1 - IB port number\;3 - Out of band / PCI" access="INDEX" offset="0x0.14" size="0x0.2" />
	<field name="local_port" descr="local_port" access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="sw_c" descr="PRBS MSB &lt;-&gt;LSB Swap for PAM4 symbols support\;if this bit is cleared - bit 25 (&apos;s&apos;) is ignored" access="RO" offset="0x0.24" size="0x0.1" />
	<field name="sw" descr="PRBS MSB &lt;-&gt;LSB Swap for PAM4 symbols\;0 - No Swap.\;1 - Swap MSB &lt;-&gt; LSB." access="RW" offset="0x0.25" size="0x0.1" />
	<field name="dm_ig" descr="disable mask ignore\;If set to 1, the port&quot;s and the cable&quot;s capabilities won&quot;t affect tuning" access="OP" offset="0x0.26" size="0x0.1" />
	<field name="p_c" descr="PRBS RX polarity support indication\;if this bit is cleared - bit 28 (&apos;p&apos;) is ignored" access="RO" offset="0x0.27" size="0x0.1" />
	<field name="p" descr="PRBS RX polarity - NOT gate in PRBS (not Physical lane Polarity)\;\;0 - No polarity inversion.\;1 - PRBS RX polarity inversion." access="RW" offset="0x0.28" size="0x0.1" />
	<field name="s" descr="start tuning:\;1 - start RX_tuning based on PRBS pattern \;Note: assuming peer transmitting PRBS. \;cannot be set when prbs_rx_tuning_status = 1 (during tuning)" access="OP" offset="0x0.30" size="0x0.1" />
	<field name="e" descr="Enable PRBS test mode bit:\;0 - PRBS RX is disabled.\;1 - PRBS RX is enabled." access="RW" offset="0x0.31" size="0x0.1" />
	<field name="prbs_modes_cap" descr="PRBS capability (bitmask)\;Bit 0 - PRBS31 (x^31 + x^28 + 1)\;Bit 1 - PRBS23A (x^23 + x^18 + 1)\;Bit 2 - PRBS23B (x^23 + x^18 + x^12+ x^6 + 1)\;Bit 3 - PRBS23C (x^23 + x^22 + x^19+ x^18 + 1)\;Bit 4 - PRBS23D (x^23 + x^19 + x^18+ x^11 + 1)\;Bit 5 - PRBS7 (x^7 + x^6 + 1)\;Bit 6 - PRBS11 (x^11 + x^9 + 1)\;Bit 7 - PRBS11A (x^11 + x^10 + x^6+ x^5 + 1)\;Bit 8 - PRBS11B (x^11 + x^9 + x^6+ x^5 + 1)\;Bit 9 - PRBS11C (x^11 + x^8 + x^6+ x^4 + 1)\;Bit 10 - PRBS11D (x^11 + x^7 + x^6+ x^4 + 1)\;Bit 11 - PRBS9 (x^9 + x^5 + 1)\;Bit 12 - IDLE using scramble58 (x^58+ x^39 + 1)\;Bit 13 - Square_wave : Non error based tune\;Bit 17 - PRBS13A (x^13 + x^12 + x^2+ x + 1)\;Bit 18 - PRBS13B (x^13 + x^7 + x^3+ x^2 + 1)\;Bit 19 - PRBS13C (x^13 + x^8 + x^4+ x^2 + 1)\;Bit 20 - PRBS13D (x^13 + x^9 + x^5+ x^2 + 1)\;Bit 21- SSPR\;Bit 22- SSPRQ\;Bit 23- LT frames (KR-startup frames)\;Bit 24 - PRBS15 - x^15 + x^14 + 1\;Bit 25 - PRBS28 - x^28 + x^25 + 1\;Bit 26 - Square wave3 (3ones, 3zeros)\;Bit 27 - Square wave13 (13ones, 13zeros)\;Bit 28 - Square wave30 (30ones, 30zeros)" access="RO" offset="0x4.0" size="0x4.0" />
	<field name="modulation" descr="Reserved for speeds below 53.125Gb/s (lane_rate_admin &lt; 13):\;0 - NRZ test pattern\;1 - PAM4 encoding [interlnal] with gray no precoding\;2 - PAM4 with precoding [internal] with gray\;3 - PAM4 without gray no precoding\;" access="RW" offset="0x8.0" size="0x0.4" />
	<field name="prbs_mode_admin" descr="See prbs_mode_cap: \;0x0 - PRBS31 (x^31 + x^28 + 1)\;0x1 - PRBS23A (x^23 + x^18 + 1)\;0x2 - PRBS23B (x^23 + x^18 + x^12+ x^6 + 1)\;0x3 - PRBS23C (x^23 + x^22 + x^19+ x^18 + 1)\;0x4 - PRBS23D (x^23 + x^19 + x^18+ x^11 + 1)\;0x5 - PRBS7 (x^7 + x^6 + 1)\;0x6 - PRBS11 (x^11 + x^9 + 1)\;0x7 - PRBS11A (x^11 + x^10 + x^6+ x^5 + 1)\;0x8 - PRBS11B (x^11 + x^9 + x^6+ x^5 + 1)\;0x9 - PRBS11C (x^11 + x^8 + x^6+ x^4 + 1)\;0xA - PRBS11D (x^11 + x^7 + x^6+ x^4 + 1)\;0xB - PRBS9 (x^9 + x^5 + 1)\;0xC - IDLEs using scramble58 (x^58+ x^39 + 1)\;0xD - Square_wave : Non error based tune \;0x11 - PRBS13A (x^13 + x^12 + x^2+ x + 1)\;0x12 - PRBS13B (x^13 + x^7 + x^3+ x^2 + 1)\;0x13 - PRBS13C (x^13 + x^8 + x^4+ x^2 + 1)\;0x14 - PRBS13D (x^13 + x^9 + x^5+ x^2 + 1)\;0x15 - SSPR\;0x16 - SSPRQ\;0x17 - LT frames (KR-startup frames)\;0x18 - PRBS15 - x^15 + x^14 + 1\;0x19 - PRBS28 - x^28 + x^25 + 1\;0x1A - Square wave3 (3ones, 3zeros)\;0x1B - Square wave13 (13ones, 13zeros)\;0x1C - Square wave30 (30ones, 30zeros)" access="RW" offset="0x8.24" size="0x0.8" />
	<field name="lane_rate_cap" descr="Per lane rate capability (bitmask)\;Bit 0 - 1GE (1.25 Gb/s) / Gen 1 PCIe (2.5 Gb/s)\;Bit 1 - SDR (2.5 Gb/s) / Gen 2 PCIe (5 Gb/s)\;Bit 2 - XAUI/2.5GE (3.125 Gb/s) / Gen 3 PCIe (8 Gb/s)\;Bit 3- DDR (5 Gb/s) / Gen 4 PCIe (16 Gb/s)\;Bit 4- QDR (10 Gb/s) / Gen 5 PCIe (32 Gb/s)\;Bit 5- FDR10 / 10GE/40GE (10.3125 Gb/s) / Gen 5 PCIe (64 Gb/s PAM4, 32Gbd)\;Bit 6- FDR (14.0625 Gb/s) \;Bit 7- EDR / 25GE / 50GE / 100GE (25.78125 Gb/s) \;Bit 8 - 50GE-KR4 (12.89 Gb/s) \;Bit 9 - HDR /50GE / 100GE / 200GE / 400GE (26.5625Gbd / 53.125Gb/s) \;Bit 10 - NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd / 106.25Gb/s)\;Bit 11 - XDR (106.25Gbd / 212.5Gb/s)\;\;Note: PCIe speeds are relevant when pnat = 3 only" access="RO" offset="0xC.16" size="0x0.16" />
	<field name="lane_rate_oper" descr="Lane rate to be used in PRBS, see lane_rate_cap:\;0 - SDR (2.5 Gb/s) / Gen 1 PCIe (2.5 Gb/s)\;1 - DDR (5 Gb/s) / Gen 2 PCIe (5 Gb/s)\;2 - QDR (10 Gb/s)\;3 - FDR10 / 10GE/4 0GE (10.3125 Gb/s) / Gen 3 PCIe (8 Gb/s)\;4 - FDR (14.0625 Gb/s) / Gen 4 PCIe (16 Gb/s)\;5 - EDR / 25GE / 50GE / 100GE (25.78125 Gb/s) / Gen 5 PCIe (32 Gb/s)\;6 - HDR /50GE / 100GE / 200GE / 400GE (26.5625Gbd / 53.125Gb/s / Gen 5 PCIe (64 Gb/s PAM4, 32Gbd)\;7 - NDR /100GE / 200GE / 400GE / 800GE (53.125 Gbd / 106.25Gb/s) \;8 - XDR (106.25Gbd / 212.5Gb/s)\;9 - reserved\;10 - 1GE (1.25 Gb/s)\;11 - XAUI/2.5GE (3.125 Gb/s)\;12 - 50GE-KR4 (12.89 Gb/s) \;\;Note: All lanes must be set to the same rate\;Note: PCIe speeds are relevant when pnat = 3 only" access="RW" offset="0x10.16" size="0x0.16" />
	<field name="prbs_lock_status_ext" descr="PRBS lock on PRBS pattern status for lanes 7-4: \;0 - Not locked\;1 - Locked\;\;Note: Once exiting prbs test mode the prbs_rx_tuning_status will return to 0 (Not locked)" access="RO" offset="0x14.20" size="0x0.4" />
	<field name="prbs_lock_status" descr="PRBS lock on PRBS pattern status for lanes 3-0: \;0 - Not locked\;1 - Locked\;\;Note: Once exiting prbs test mode the prbs_rx_tuning_status will return to 0 (Not locked)" access="RO" offset="0x14.24" size="0x0.4" />
	<field name="prbs_rx_tuning_status" descr="Tuning status: \;0 - PRBS mode tuning was not performed.\;1 - Performing PRBS mode tuning.\;2 - PRBS mode tuning completed.\;3 - Signal Detect in progress\;\;Note: Once exiting prbs test mode the prbs_rx_tuning_status will return to 0." access="RO" offset="0x14.28" size="0x0.4" />
</node>

<node name="ppsc_reg_ext" descr="" size="0x30.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="mod_pwr_opt" descr="See PCAM.feature_cap_mask bit 16 for support indication: \;Transceiver power optimization:\;0 - Disable\;1 - Enable" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="wrps_admin" descr="Width reduction power save admin state:\;0000: Disable Width Reduction - Force link to full width (Default)\;0001: Force Width Reduction - Force link to single lane\;0010: Auto - Automatic Width Reduction (based on traffic)." access="RW" offset="0x10.0" size="0x0.4" />
	<field name="wrps_status" descr="Link actual width:\;0000: Full width\;0001: Single lane\;1111: In transition" access="RO" offset="0x14.0" size="0x0.4" />
	<field name="down_threshold" descr="Link width down threshold, Values: 1%-100%\;The BW (In percent) before the link width is moved to single lane" access="RW" offset="0x18.0" size="0x0.8" />
	<field name="up_threshold" descr="Link width up threshold, Values: 1-5 (default 3)\;how aggressive/smoothed in response to high BW.\;1 - means aggressive response to every BW increase\;5 - means smoothened response to every BW increase" access="RW" offset="0x18.16" size="0x0.8" />
	<field name="down_th_vld" descr="Valid bit to update the down threshold\;if &apos;1&apos; update down_threshold" access="WO" offset="0x18.30" size="0x0.1" />
	<field name="up_th_vld" descr="Valid bit to update the up threshold\;if &apos;1&apos; update up_threshold" access="WO" offset="0x18.31" size="0x0.1" />
	<field name="srps_admin" descr="Speed reduction power save admin state:\;0000: Disable Speed Reduction - force link to full speed (Default)\;0001: Force Speed Reduction - force link to low speed" access="RW" offset="0x20.0" size="0x0.4" />
</node>

<node name="ppslc_ext" descr="" size="0x34.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="l1_req_en" descr="Enable L1 Request\;0: L1 Request is disabled on this port\;1: L1 Request is enabled on this port\;" access="RW" offset="0x4.0" size="0x0.1" />
	<field name="l1_fw_req_en" descr="Enable L1 FW Request\;0: Only L1 HW mode is supported (thermal throttling is disabled) \;1: support thermal throttling on this port \;Reserved for Switch." access="RW" offset="0x8.0" size="0x0.1" />
	<field name="l1_cap_adv" descr="L1 Capability Advertisement\;0: Port doesn&apos;t support L1\;1: Port supports L1 advertisement" access="RW" offset="0x8.4" size="0x0.1" />
	<field name="l1_fw_cap_adv" descr="L1 FW Capability Advertisement\;0: Port doesn&apos;t support L1 FW\;1: Port supports L1 FW advertisement\;Reserved for Switch." access="RW" offset="0x8.8" size="0x0.1" />
	<field name="ignore_pred_pm" descr="[DWIP] [SwitchOnly]:\;Ignore Predictor Post Mistake\;If the predictor decision is to move to L1 idle, but no traffic arrives, we will ignore the predictor until traffic arrives again\;0: don&apos;t ignore predictor\;1: ignore predictor" access="RW" offset="0xC.30" size="0x0.1" />
	<field name="pred_algo_en" descr="[DWIP] [SwitchOnly]:\;Predictive Algo Enable\;0: Predictive Algo&apos; is disabled\;1: Predictive Algo&apos; is enabled\;\;Relevant for Switch Only" access="RW" offset="0xC.31" size="0x0.1" />
	<field name="hp_queues_bitmap" descr="High Priority Queues Bitmap\;for each queue, \;0: Normal queue\;1: High priority queue\;\;Note: High priority queues can move to L1 active only when queue is fully empty. Normal queues can move to L1 active as long as the number of bytes within the queue is lower than MPSCR.queue_depth_th\;\;bits 17-31 are reserved" access="RW" offset="0x10.0" size="0x4.0" />
	<field name="l1_hw_active_time" descr="[DWIP]\;units of 50 usec minimum value of 50 usec\;" access="RW" offset="0x18.0" size="0x0.10" />
	<field name="l1_hw_inactive_time" descr="[DWIP]\;units of 50 usec. minimum value of 50 usec\;" access="RW" offset="0x1C.0" size="0x0.10" />
	<field name="qem" descr="Queue Desire (state) Exit Mode upon traffic arrival\;0: Move to L1 Idle immediately \;1: Wait for desire window completion before moving to L1 idle\;2: Ignore traffic arrival \;\;Note: \;For GB100, only index 0-7 are valid. \;For QM-3 only index 0-16 are valid." access="RW" high_bound="19" low_bound="0" offset="0x20.24" size="0x14.0" />
</node>

<node name="ppsld_ext" descr="" size="0x14.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="fw_mode" descr="FW Mode\;0: Trigger Once - \;1: Infinite L1 Idle \;2: Infinite L1 Force \;3: Toggle Always \;4: Disabled \;Note: can be changed only when device in not under thermal event. During thermal event, FW will override the use debug configuration." access="RW" offset="0x4.0" size="0x0.3" />
	<field name="trigger" descr="Trigger port to move to force mode one time\;0: No trigger\;1: Trigger port to move to force mode\;Valid only when fw_mode = Trigger Once" access="OP" offset="0x8.0" size="0x0.1" />
	<field name="ehld" descr="Exposed HW L1 desire\;The state of the controller2plu_l1_desire bit that controller publishes \;" access="RO" offset="0xC.0" size="0x0.1" />
	<field name="fw_idle_window_time" descr="FW Idle Window time\;units of 100uSec\;Relevant only for fw_mode = Toggle always (3)." access="RW" offset="0x10.0" size="0x0.8" />
	<field name="fw_desire_window_time" descr="FW Desire Window time\;units of 100uSec\;Relevant only for fw_mode = Trigger once (0) or Toggle always (3)." access="RW" offset="0x10.16" size="0x0.8" />
</node>

<node name="ppsls_ext" descr="" size="0x8.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="l1_fw_mode_cap" descr="0: Port doesn&apos;t support L1 fw mode\;1: Port supports L1 fw mode\;" access="RO" offset="0x4.16" size="0x0.1" />
	<field name="l1_cap" descr="0: Port doesn&apos;t support L1\;1: Port supports L1 \;" access="RO" offset="0x4.18" size="0x0.1" />
	<field name="fw_mode_remote" descr="FW mode remote indication\;0: N/A\;1: L1 fw mode remote capability is set \;2: L1 fw mode remote request is set \;3: L1 fw mode remote request and capability are set \;Valid only is l1_neg_status = 1 \;Reserved when link is down" access="RO" offset="0x4.27" size="0x0.2" />
	<field name="fw_mode_act" descr="Actual Mode \;0: HW mode\;1: FW mode\;Valid only is l1_neg_status = 1 \;Reserved when link is down\;Reserved for Switch." access="RO" offset="0x4.29" size="0x0.1" />
	<field name="fw_mode_neg_status" descr="FW mode negotiation status\;0: L1 fw mode negotiation failed\;1: L1 fw mode negotiation succeeded \;Valid only if l1_neg_status = 1 \;Reserved when link is down" access="RO" offset="0x4.30" size="0x0.1" />
	<field name="l1_neg_status" descr="L1 negotiation status\;0: L1 negotiation failed (L1 is not supported by both sides)\;1: L1 negotiation succeeded (supported on both sides)\;Reserved when link is down" access="RO" offset="0x4.31" size="0x0.1" />
</node>

<node name="ppspc_ext" descr="" size="0x28.0" >
	<field name="lp_msb" descr="Local port number [9:8]" access="INDEX" offset="0x0.12" size="0x0.2" />
	<field name="local_port" descr="Local port number." access="INDEX" offset="0x0.16" size="0x0.8" />
	<field name="windows_num" descr="Num of windows used for prediction.\;Valid values 1 .. 15" access="RW" offset="0x4.0" size="0x0.5" />
	<field name="predictor_inactive_window" descr="Predictor Idle Window\;Units of 100uSec\;Valid values 1-1023" access="RW" offset="0x4.16" size="0x0.10" />
	<field name="win_thr" descr="Units of 100 usec" access="OP" high_bound="15" low_bound="0" offset="0x8.16" size="0x20.0" />
</node>

<node name="ppspgc_ext" descr="" size="0xc.0" >
	<field name="sample_rate" descr="Units of 1ms. Valid values 5-100.\;Default read from INI." access="RW" offset="0x0.0" size="0x0.8" />
	<field name="max_score" descr="The max score allowed to be used for scoring table. When score reaches max_score it&apos;s not increased anymore.\;Min score for each window is 0.\;Init value for each window is max_score/2. Default read from INI." access="RW" offset="0x0.16" size="0x0.4" />
	<field name="min_score_dis" descr="The min score required in order to move the port to learning mode." access="RW" offset="0x0.24" size="0x0.4" />
	<field name="min_score_en" descr="The min score required in order to enable static/cyclic prediction. Init value for each window is max_score/2. Default read from INI." access="RW" offset="0x0.28" size="0x0.4" />
	<field name="l1_hw_inactive_cycles_pred_dis" descr="Units of 50uSec\;\;Defines the L1 inactive cycles to be used when the prediction algo&quot; is disabled.\;Fw has to hold different values for prediction en/dis since the L1 inactive cycles is expected to be longer when prediction is disabled" access="RW" offset="0x4.0" size="0x0.10" />
	<field name="too_long_pred_err_thr" descr="Defines the number of error count allowed (per port) before FW disables the prediction algo due to too many errors." access