/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.explain.FieldSelection;
import org.elasticsearch.xpack.core.ml.dataframe.explain.MemoryEstimation;

public class ExplainDataFrameAnalyticsAction
extends ActionType<Response> {
    public static final ExplainDataFrameAnalyticsAction INSTANCE = new ExplainDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/explain";

    private ExplainDataFrameAnalyticsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField TYPE = new ParseField("explain_data_frame_analytics_response", new String[0]);
        public static final ParseField FIELD_SELECTION = new ParseField("field_selection", new String[0]);
        public static final ParseField MEMORY_ESTIMATION = new ParseField("memory_estimation", new String[0]);
        static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), args -> new Response((List)args[0], (MemoryEstimation)args[1]));
        private final List<FieldSelection> fieldSelection;
        private final MemoryEstimation memoryEstimation;

        public Response(List<FieldSelection> fieldSelection, MemoryEstimation memoryEstimation) {
            this.fieldSelection = Objects.requireNonNull(fieldSelection);
            this.memoryEstimation = Objects.requireNonNull(memoryEstimation);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.fieldSelection = in.readList(FieldSelection::new);
            this.memoryEstimation = new MemoryEstimation(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.fieldSelection);
            this.memoryEstimation.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FIELD_SELECTION.getPreferredName(), this.fieldSelection);
            builder.field(MEMORY_ESTIMATION.getPreferredName(), (ToXContent)this.memoryEstimation);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            Response that = (Response)((Object)other);
            return Objects.equals(this.fieldSelection, that.fieldSelection) && Objects.equals(this.memoryEstimation, that.memoryEstimation);
        }

        public int hashCode() {
            return Objects.hash(this.fieldSelection, this.memoryEstimation);
        }

        public MemoryEstimation getMemoryEstimation() {
            return this.memoryEstimation;
        }

        public List<FieldSelection> getFieldSelection() {
            return this.fieldSelection;
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), FieldSelection.PARSER, FIELD_SELECTION);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), MemoryEstimation.PARSER, MEMORY_ESTIMATION);
        }
    }
}

