/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.pagerduty;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.actions.pagerduty.PagerDutyAction;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEvent;

public class SentEvent
implements ToXContentObject {
    final IncidentEvent event;
    @Nullable
    final HttpRequest request;
    @Nullable
    final HttpResponse response;
    @Nullable
    final String failureReason;

    public static SentEvent responded(IncidentEvent event, HttpRequest request, HttpResponse response) {
        String failureReason = SentEvent.resolveFailureReason(response);
        return new SentEvent(event, request, response, failureReason);
    }

    public static SentEvent error(IncidentEvent event, String reason) {
        return new SentEvent(event, null, null, reason);
    }

    private SentEvent(IncidentEvent event, HttpRequest request, HttpResponse response, String failureReason) {
        this.event = event;
        this.request = request;
        this.response = response;
        this.failureReason = failureReason;
    }

    public boolean successful() {
        return this.failureReason == null;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentEvent sentEvent = (SentEvent)o;
        return Objects.equals(this.event, sentEvent.event) && Objects.equals(this.request, sentEvent.request) && Objects.equals(this.failureReason, sentEvent.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.request, this.response, this.failureReason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(XField.EVENT.getPreferredName(), (ToXContent)this.event, params);
        if (!this.successful()) {
            builder.field(XField.REASON.getPreferredName(), this.failureReason);
            if (this.request != null) {
                if (WatcherParams.hideSecrets((ToXContent.Params)params)) {
                    try (InputStream is = HttpRequest.filterToXContent(this.request, builder.contentType().xContent(), params, "body");){
                        builder.rawField(XField.REQUEST.getPreferredName(), is, builder.contentType());
                    }
                } else {
                    builder.field(XField.REQUEST.getPreferredName());
                    this.request.toXContent(builder, params);
                }
            }
            if (this.response != null) {
                builder.field(XField.RESPONSE.getPreferredName(), (ToXContent)this.response, params);
            }
        }
        return builder.endObject();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String resolveFailureReason(HttpResponse response) {
        int status = response.status();
        if (status < 300) {
            return null;
        }
        try (StreamInput stream = response.body().streamInput();){
            String string;
            block31: {
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    XContentParser.Token token;
                    parser.nextToken();
                    String message = null;
                    ArrayList<String> errors = new ArrayList<String>();
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (XField.MESSAGE.match(currentFieldName, parser.getDeprecationHandler())) {
                            message = parser.text();
                            continue;
                        }
                        if (XField.CODE.match(currentFieldName, parser.getDeprecationHandler())) continue;
                        if (XField.ERRORS.match(currentFieldName, parser.getDeprecationHandler())) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                errors.add(parser.text());
                            }
                            continue;
                        }
                        throw new ElasticsearchParseException("could not parse pagerduty event response. unexpected field [{}]", new Object[]{currentFieldName});
                    }
                    StringBuilder sb = new StringBuilder();
                    if (message != null) {
                        sb.append(message);
                    }
                    if (!errors.isEmpty()) {
                        sb.append(":");
                        for (String error : errors) {
                            sb.append(" ").append(error).append(".");
                        }
                    }
                    string = sb.toString();
                    if (parser == null) break block31;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
        catch (Exception exception) {
            switch (status) {
                case 400: {
                    return "Bad Request";
                }
                case 401: {
                    return "Unauthorized. The account service api key is invalid.";
                }
                case 403: {
                    return "Forbidden. The account doesn't have permission to send this trigger.";
                }
                case 404: {
                    return "The account used invalid HipChat APIs";
                }
                case 408: {
                    return "Request Timeout. The request took too long to process.";
                }
                case 500: {
                    return "PagerDuty Server Error. Internal error occurred while processing request.";
                }
            }
            return "Unknown Error";
        }
    }

    public static interface XField {
        public static final ParseField EVENT = PagerDutyAction.XField.EVENT;
        public static final ParseField REASON = new ParseField("reason", new String[0]);
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField RESPONSE = new ParseField("response", new String[0]);
        public static final ParseField MESSAGE = new ParseField("message", new String[0]);
        public static final ParseField CODE = new ParseField("code", new String[0]);
        public static final ParseField ERRORS = new ParseField("errors", new String[0]);
    }
}

