/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.preallocate;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.security.AccessController;
import org.elasticsearch.xpack.searchablesnapshots.preallocate.Preallocator;

final class LinuxPreallocator
implements Preallocator {
    LinuxPreallocator() {
    }

    @Override
    public boolean useNative() {
        return Natives.NATIVES_AVAILABLE;
    }

    @Override
    public int preallocate(int fd, long currentSize, long fileSize) {
        int rc = Natives.fallocate(fd, 0, currentSize, fileSize - currentSize);
        return rc == 0 ? 0 : Native.getLastError();
    }

    @Override
    public String error(int errno) {
        return Natives.strerror(errno);
    }

    private static class Natives {
        public static final boolean NATIVES_AVAILABLE = AccessController.doPrivileged(() -> {
            try {
                Native.register(Natives.class, (String)Platform.C_LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError e) {
                return false;
            }
            return true;
        });

        private Natives() {
        }

        static native int fallocate(int var0, int var1, long var2, long var4);

        static native String strerror(int var0);
    }
}

