/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class ProtoUtils {
    private ProtoUtils() {
    }

    public static Object parseFieldsValue(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return parser.numberValue();
        }
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            return parser.booleanValue();
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token == XContentParser.Token.START_OBJECT) {
            return parser.mapOrdered();
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return parser.listOrderedMap();
        }
        String message = "Failed to parse object: unexpected token [%s] found";
        throw new IllegalStateException(String.format(Locale.ROOT, message, token));
    }

    public static String toString(XContentBuilder xContentBuilder) {
        byte[] byteArray = ((ByteArrayOutputStream)xContentBuilder.getOutputStream()).toByteArray();
        return new String(byteArray, StandardCharsets.UTF_8);
    }

    public static String toString(ToXContent toXContent) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            builder.close();
            return ProtoUtils.toString(builder);
        }
        catch (IOException e) {
            try {
                XContentBuilder builder = JsonXContent.contentBuilder();
                builder.startObject();
                builder.field("error", "error building toString out of XContent: " + e.getMessage());
                builder.endObject();
                builder.close();
                return ProtoUtils.toString(builder);
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("cannot generate error message for deserialization", e);
            }
        }
    }
}

