/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationResponse;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlRedirect;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;

public final class TransportSamlPrepareAuthenticationAction
extends HandledTransportAction<SamlPrepareAuthenticationRequest, SamlPrepareAuthenticationResponse> {
    private final Realms realms;

    @Inject
    public TransportSamlPrepareAuthenticationAction(TransportService transportService, ActionFilters actionFilters, Realms realms) {
        super("cluster:admin/xpack/security/saml/prepare", transportService, actionFilters, SamlPrepareAuthenticationRequest::new);
        this.realms = realms;
    }

    protected void doExecute(Task task, SamlPrepareAuthenticationRequest request, ActionListener<SamlPrepareAuthenticationResponse> listener) {
        List<SamlRealm> realms = SamlRealm.findSamlRealms(this.realms, request.getRealmName(), request.getAssertionConsumerServiceURL());
        if (realms.isEmpty()) {
            listener.onFailure((Exception)((Object)SamlUtils.samlException("Cannot find any matching realm for [{}]", request)));
        } else if (realms.size() > 1) {
            listener.onFailure((Exception)((Object)SamlUtils.samlException("Found multiple matching realms [{}] for [{}]", realms, request)));
        } else {
            this.prepareAuthentication(realms.get(0), request.getRelayState(), listener);
        }
    }

    private void prepareAuthentication(SamlRealm realm, String relayState, ActionListener<SamlPrepareAuthenticationResponse> listener) {
        AuthnRequest authnRequest = realm.buildAuthenticationRequest();
        try {
            String redirectUrl = new SamlRedirect((RequestAbstractType)authnRequest, realm.getSigningConfiguration()).getRedirectUrl(relayState);
            listener.onResponse((Object)new SamlPrepareAuthenticationResponse(realm.name(), authnRequest.getID(), redirectUrl));
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }
}

