#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn CloseHandle<P0>(hobject: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HANDLE>,
{
    ::windows_targets::link!("kernel32.dll" "system" fn CloseHandle(hobject : HANDLE) -> BOOL);
    CloseHandle(hobject.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn CompareObjectHandles<P0, P1>(hfirstobjecthandle: P0, hsecondobjecthandle: P1) -> BOOL
where
    P0: ::windows_core::IntoParam<HANDLE>,
    P1: ::windows_core::IntoParam<HANDLE>,
{
    ::windows_targets::link!("api-ms-win-core-handle-l1-1-0.dll" "system" fn CompareObjectHandles(hfirstobjecthandle : HANDLE, hsecondobjecthandle : HANDLE) -> BOOL);
    CompareObjectHandles(hfirstobjecthandle.into_param().abi(), hsecondobjecthandle.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn DuplicateHandle<P0, P1, P2, P3>(hsourceprocesshandle: P0, hsourcehandle: P1, htargetprocesshandle: P2, lptargethandle: *mut HANDLE, dwdesiredaccess: u32, binherithandle: P3, dwoptions: DUPLICATE_HANDLE_OPTIONS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HANDLE>,
    P1: ::windows_core::IntoParam<HANDLE>,
    P2: ::windows_core::IntoParam<HANDLE>,
    P3: ::windows_core::IntoParam<BOOL>,
{
    ::windows_targets::link!("kernel32.dll" "system" fn DuplicateHandle(hsourceprocesshandle : HANDLE, hsourcehandle : HANDLE, htargetprocesshandle : HANDLE, lptargethandle : *mut HANDLE, dwdesiredaccess : u32, binherithandle : BOOL, dwoptions : DUPLICATE_HANDLE_OPTIONS) -> BOOL);
    DuplicateHandle(hsourceprocesshandle.into_param().abi(), hsourcehandle.into_param().abi(), htargetprocesshandle.into_param().abi(), lptargethandle, dwdesiredaccess, binherithandle.into_param().abi(), dwoptions).ok()
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn FreeLibrary<P0>(hlibmodule: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HMODULE>,
{
    ::windows_targets::link!("kernel32.dll" "system" fn FreeLibrary(hlibmodule : HMODULE) -> BOOL);
    FreeLibrary(hlibmodule.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn GetHandleInformation<P0>(hobject: P0, lpdwflags: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HANDLE>,
{
    ::windows_targets::link!("kernel32.dll" "system" fn GetHandleInformation(hobject : HANDLE, lpdwflags : *mut u32) -> BOOL);
    GetHandleInformation(hobject.into_param().abi(), lpdwflags).ok()
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn GetLastError() -> ::windows_core::Result<()> {
    ::windows_targets::link!("kernel32.dll" "system" fn GetLastError() -> WIN32_ERROR);
    GetLastError().ok()
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn GlobalFree<P0>(hmem: P0) -> ::windows_core::Result<HGLOBAL>
where
    P0: ::windows_core::IntoParam<HGLOBAL>,
{
    ::windows_targets::link!("kernel32.dll" "system" fn GlobalFree(hmem : HGLOBAL) -> HGLOBAL);
    let result__ = GlobalFree(hmem.into_param().abi());
    (!result__.is_invalid()).then(|| result__).ok_or_else(::windows_core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn LocalFree<P0>(hmem: P0) -> ::windows_core::Result<HLOCAL>
where
    P0: ::windows_core::IntoParam<HLOCAL>,
{
    ::windows_targets::link!("kernel32.dll" "system" fn LocalFree(hmem : HLOCAL) -> HLOCAL);
    let result__ = LocalFree(hmem.into_param().abi());
    (!result__.is_invalid()).then(|| result__).ok_or_else(::windows_core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn RtlNtStatusToDosError<P0>(status: P0) -> u32
where
    P0: ::windows_core::IntoParam<NTSTATUS>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNtStatusToDosError(status : NTSTATUS) -> u32);
    RtlNtStatusToDosError(status.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SetHandleInformation<P0>(hobject: P0, dwmask: u32, dwflags: HANDLE_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HANDLE>,
{
    ::windows_targets::link!("kernel32.dll" "system" fn SetHandleInformation(hobject : HANDLE, dwmask : u32, dwflags : HANDLE_FLAGS) -> BOOL);
    SetHandleInformation(hobject.into_param().abi(), dwmask, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SetLastError(dwerrcode: WIN32_ERROR) {
    ::windows_targets::link!("kernel32.dll" "system" fn SetLastError(dwerrcode : WIN32_ERROR) -> ());
    SetLastError(dwerrcode)
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SetLastErrorEx(dwerrcode: WIN32_ERROR, dwtype: u32) {
    ::windows_targets::link!("user32.dll" "system" fn SetLastErrorEx(dwerrcode : WIN32_ERROR, dwtype : u32) -> ());
    SetLastErrorEx(dwerrcode, dwtype)
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysAddRefString<P0>(bstrstring: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::BSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysAddRefString(bstrstring : ::std::mem::MaybeUninit <::windows_core::BSTR >) -> ::windows_core::HRESULT);
    SysAddRefString(bstrstring.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysAllocString<P0>(psz: P0) -> ::windows_core::BSTR
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysAllocString(psz : ::windows_core::PCWSTR) -> ::windows_core::BSTR);
    SysAllocString(psz.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysAllocStringByteLen(psz: ::core::option::Option<&[u8]>) -> ::windows_core::BSTR {
    ::windows_targets::link!("oleaut32.dll" "system" fn SysAllocStringByteLen(psz : ::windows_core::PCSTR, len : u32) -> ::windows_core::BSTR);
    SysAllocStringByteLen(::core::mem::transmute(psz.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysAllocStringLen(strin: ::core::option::Option<&[u16]>) -> ::windows_core::BSTR {
    ::windows_targets::link!("oleaut32.dll" "system" fn SysAllocStringLen(strin : ::windows_core::PCWSTR, ui : u32) -> ::windows_core::BSTR);
    SysAllocStringLen(::core::mem::transmute(strin.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), strin.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysFreeString<P0>(bstrstring: P0)
where
    P0: ::windows_core::IntoParam<::windows_core::BSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysFreeString(bstrstring : ::std::mem::MaybeUninit <::windows_core::BSTR >) -> ());
    SysFreeString(bstrstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysReAllocString<P0>(pbstr: *mut ::windows_core::BSTR, psz: P0) -> i32
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysReAllocString(pbstr : *mut ::std::mem::MaybeUninit <::windows_core::BSTR >, psz : ::windows_core::PCWSTR) -> i32);
    SysReAllocString(::core::mem::transmute(pbstr), psz.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysReAllocStringLen<P0>(pbstr: *mut ::windows_core::BSTR, psz: P0, len: u32) -> i32
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysReAllocStringLen(pbstr : *mut ::std::mem::MaybeUninit <::windows_core::BSTR >, psz : ::windows_core::PCWSTR, len : u32) -> i32);
    SysReAllocStringLen(::core::mem::transmute(pbstr), psz.into_param().abi(), len)
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysReleaseString<P0>(bstrstring: P0)
where
    P0: ::windows_core::IntoParam<::windows_core::BSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysReleaseString(bstrstring : ::std::mem::MaybeUninit <::windows_core::BSTR >) -> ());
    SysReleaseString(bstrstring.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysStringByteLen<P0>(bstr: P0) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::BSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysStringByteLen(bstr : ::std::mem::MaybeUninit <::windows_core::BSTR >) -> u32);
    SysStringByteLen(bstr.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
#[inline]
pub unsafe fn SysStringLen<P0>(pbstr: P0) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::BSTR>,
{
    ::windows_targets::link!("oleaut32.dll" "system" fn SysStringLen(pbstr : ::std::mem::MaybeUninit <::windows_core::BSTR >) -> u32);
    SysStringLen(pbstr.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_DYNAMIC_PROPERTY_INVALID: WIN32_ERROR = WIN32_ERROR(15705u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_DYNAMIC_PROPERTY_READ_FAILED: WIN32_ERROR = WIN32_ERROR(15704u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_NO_APPLICATION: WIN32_ERROR = WIN32_ERROR(15703u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_NO_MUTABLE_DIRECTORY: WIN32_ERROR = WIN32_ERROR(15707u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_NO_PACKAGE: WIN32_ERROR = WIN32_ERROR(15700u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_PACKAGE_IDENTITY_CORRUPT: WIN32_ERROR = WIN32_ERROR(15702u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_PACKAGE_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(15706u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPMODEL_ERROR_PACKAGE_RUNTIME_CORRUPT: WIN32_ERROR = WIN32_ERROR(15701u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_BLOCK_HASH_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958841i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_CORRUPT_CONTENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958842i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_DELTA_APPENDED_PACKAGE_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958832i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_DELTA_BASELINE_VERSION_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958835i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_DELTA_PACKAGE_MISSING_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958834i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_DIGEST_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958823i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_FILE_COMPRESSION_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958828i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INTERLEAVING_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958847i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_APPINSTALLER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958836i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_BLOCKMAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958843i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_CONTENTGROUPMAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958837i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_DELTA_PACKAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958833i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_ENCRYPTION_EXCLUSION_FILE_LIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958826i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_KEY_INFO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958838i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_MANIFEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958844i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_PACKAGESIGNCONFIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958830i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_PACKAGE_FOLDER_ACLS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958825i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_PACKAGING_LAYOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958831i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_PAYLOAD_PACKAGE_EXTENSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958827i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_PUBLISHER_BRIDGING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958824i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_INVALID_SIP_CLIENT_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958839i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_MISSING_REQUIRED_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958845i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_PACKAGING_INTERNAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958848i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_RELATIONSHIPS_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958846i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_REQUESTED_RANGE_TOO_LARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958840i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APPX_E_RESOURCESPRI_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958829i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const APP_LOCAL_DEVICE_ID_SIZE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const BT_E_SPURIOUS_ACTIVATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146958592i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_E_FIRST: i32 = -2147221136i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_E_LAST: i32 = -2147221121i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_E_NOCACHE_UPDATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221136i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_S_FIRST: i32 = 262512i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_S_FORMATETC_NOTSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(262512i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_S_LAST: i32 = 262527i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_S_SAMECACHE: ::windows_core::HRESULT = ::windows_core::HRESULT(262513i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CACHE_S_SOMECACHES_NOTUPDATED: ::windows_core::HRESULT = ::windows_core::HRESULT(262514i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CAT_E_CATIDNOEXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221152i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CAT_E_FIRST: i32 = -2147221152i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CAT_E_LAST: i32 = -2147221151i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CAT_E_NODESCRIPTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221151i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ADMIN_DENIED_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877420i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ALIGNMENT_FAULT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877424i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ARCHIVED_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875388i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ARCHIVED_KEY_UNEXPECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875376i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877426i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_BAD_RENEWAL_SUBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875386i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_BAD_REQUESTSTATUS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877437i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_BAD_REQUESTSUBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877439i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877428i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_BAD_TEMPLATE_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875385i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_CERT_TYPE_OVERLAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875372i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_CORRUPT_KEY_ATTESTATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875365i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877421i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ENCODING_LENGTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877433i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ENCRYPTION_CERT_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877416i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ENROLL_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877423i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_EXPIRED_CHALLENGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875364i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_INVALID_ATTESTATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875367i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_INVALID_CA_CERTIFICATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877435i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_INVALID_EK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875369i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_INVALID_IDBINDING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875368i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_INVALID_REQUESTID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875362i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_INVALID_RESPONSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875363i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ISSUANCE_POLICY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875380i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877430i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_KEY_ATTESTATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875366i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_KEY_ATTESTATION_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877417i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_KEY_LENGTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875375i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_NO_CAADMIN_DEFINED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877427i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_NO_CERT_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875391i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_NO_DB_SESSIONS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877425i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_NO_POLICY_SERVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877419i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_NO_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_NO_VALID_KRA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877429i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_PENDING_CLIENT_RESPONSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875360i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_PROPERTY_EMPTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877436i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_RENEWAL_BAD_PUBLIC_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875370i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_REQUEST_PRECERTIFICATE_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875361i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_RESTRICTEDOFFICER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877431i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_ROLECONFLICT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877432i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SEC_EXT_DIRECTORY_SID_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875359i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SERVER_SUSPENDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877434i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SIGNATURE_COUNT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875382i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SIGNATURE_POLICY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875383i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SIGNATURE_REJECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875381i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SMIME_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875387i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875389i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875378i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SUBJECT_DNS_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875377i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SUBJECT_EMAIL_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875374i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_SUBJECT_UPN_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875379i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_TEMPLATE_CONFLICT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875390i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_TEMPLATE_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877422i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_TEMPLATE_POLICY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875384i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_TOO_MANY_SIGNATURES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875371i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_UNKNOWN_CERT_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875373i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_UNSUPPORTED_CERT_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146875392i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERTSRV_E_WEAK_SIGNATURE_OR_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146877418i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_CHAINING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762486i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_CN_NO_MATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762481i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_CRITICAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762491i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762495i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_INVALID_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762476i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_INVALID_POLICY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762477i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_ISSUERCHAINING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762489i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_MALFORMED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762488i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_PATHLENCONST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762492i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_PURPOSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762490i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_REVOCATION_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762482i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_REVOKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762484i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_ROLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762493i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_UNTRUSTEDCA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762478i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_UNTRUSTEDROOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762487i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_UNTRUSTEDTESTROOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762483i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_VALIDITYPERIODNESTING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762494i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CERT_E_WRONG_USAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762480i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_CORRUPT_CATALOG: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473535i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_CORRUPT_DATABASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473536i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_CORRUPT_FILTER_BUFFER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473529i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_ALREADY_INITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215350i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_BUFFERTOOSMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215348i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_CARDINALITY_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215321i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_CLIENT_FILTER_ABORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473500i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_CONFIG_DISK_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215320i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_DISK_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215343i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_DISTRIBUTED_GROUPBY_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215319i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_DUPLICATE_NOTIFICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215337i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_ENUMERATION_STARTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473502i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_FILTERING_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215344i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_INVALID_FLAGS_COMBINATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215335i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_INVALID_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215345i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_LOGON_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215332i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215339i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_NOT_INITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215349i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215328i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_NO_CATALOG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215331i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_OUTOFSEQ_INCREMENT_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215334i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_PROPERTY_NOT_CACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215347i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_PROPERTY_TOOLARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473501i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_SHARING_VIOLATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215333i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_SHUTDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215342i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_STRANGE_PAGEORSECTOR_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215330i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215329i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_UPDATES_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215336i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_USE_DEFAULT_PID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215338i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_E_WORKID_NOTVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215341i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_INCORRECT_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473503i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_INVALID_INDEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473528i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_INVALID_PARTITION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473534i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_INVALID_PRIORITY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473533i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_NO_CATALOG: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473530i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_NO_STARTING_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473532i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_OUT_OF_INDEX_IDS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473531i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_PROPSTORE_INCONSISTENCY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473527i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_S_CAT_STOPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(268326i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_S_END_OF_ENUMERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(268308i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_S_NO_DOCSTORE: ::windows_core::HRESULT = ::windows_core::HRESULT(268325i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CI_S_WORKID_DELETED: ::windows_core::HRESULT = ::windows_core::HRESULT(268302i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLASSFACTORY_E_FIRST: i32 = -2147221232i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLASSFACTORY_E_LAST: i32 = -2147221217i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLASSFACTORY_S_FIRST: i32 = 262416i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLASSFACTORY_S_LAST: i32 = 262431i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLASS_E_CLASSNOTAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221231i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLASS_E_NOAGGREGATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221232i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLASS_E_NOTLICENSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221230i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIENTSITE_E_FIRST: i32 = -2147221104i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIENTSITE_E_LAST: i32 = -2147221089i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIENTSITE_S_FIRST: i32 = 262544i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIENTSITE_S_LAST: i32 = 262559i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_E_BAD_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221037i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_E_CANT_CLOSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221036i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_E_CANT_EMPTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221039i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_E_CANT_OPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221040i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_E_CANT_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221038i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_E_FIRST: i32 = -2147221040i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_E_LAST: i32 = -2147221025i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_S_FIRST: i32 = 262608i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CLIPBRD_S_LAST: i32 = 262623i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_ALREADYINSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368508i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_AMBIGUOUS_APPLICATION_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368420i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_AMBIGUOUS_PARTITION_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368419i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_APPDIRNOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368481i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_APPLICATIONEXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368501i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_APPLID_MATCHES_CLSID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368442i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_APP_FILE_READFAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368504i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_APP_FILE_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368503i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_APP_FILE_WRITEFAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368505i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_APP_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367478i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_AUTHENTICATIONLEVEL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368493i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_BADPATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368502i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_BADREGISTRYLIBID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368482i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_BADREGISTRYPROGID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368494i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367457i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_BASE_PARTITION_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368432i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CANNOT_ALIAS_EVENTCLASS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367456i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CANTCOPYFILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368499i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CANTMAKEINPROCSERVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367468i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CANTRECYCLELIBRARYAPPS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367473i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CANTRECYCLESERVICEAPPS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367471i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368435i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAN_NOT_EXPORT_SYS_APP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368436i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAN_NOT_START_APP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368437i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_BITNESSMISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368382i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368425i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368421i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_INVALID_PARTITION_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368424i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_PARTITION_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368423i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368379i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_SERVERFAULT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368378i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_UNACCEPTABLEBITNESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368381i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CAT_WRONGAPPBITNESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368380i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_CLSIDORIIDMISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368488i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPFILE_BADTLB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368472i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPFILE_CLASSNOTAVAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368473i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPFILE_DOESNOTEXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368476i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPFILE_GETCLASSOBJ: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368474i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPFILE_LOADDLLFAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368475i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPFILE_NOREGISTRAR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368460i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPFILE_NOTINSTALLABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368471i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMPONENTEXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368455i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMP_MOVE_BAD_DEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368466i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMP_MOVE_DEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367459i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMP_MOVE_LOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368467i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMP_MOVE_PRIVATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367458i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COMP_MOVE_SOURCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367460i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_COREQCOMPINSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368459i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367466i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_DLLLOADFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368483i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_DLLREGISTERSERVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368486i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368434i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368422i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_INVALIDUSERIDS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368496i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_INVALID_PARTITION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367477i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_KEYMISSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368509i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367462i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367461i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368433i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_MIG_SCHEMANOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368383i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_MIG_VERSIONNOTSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368384i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_NOREGISTRYCLSID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368495i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_NOSERVERSHARE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368485i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_NOTCHANGEABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368470i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_NOTDELETEABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368469i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_NOTINREGISTRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368450i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_NOUSER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368497i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_OBJECTERRORS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368511i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_OBJECTEXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368456i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_OBJECTINVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368510i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_OBJECTNOTPOOLABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368449i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_OBJECT_DOES_NOT_EXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367479i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_OBJECT_PARENT_MISSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367480i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PARTITIONS_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367452i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PARTITION_ACCESSDENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367464i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PARTITION_MSI_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367463i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367469i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PRIVATE_ACCESSDENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367455i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PROCESSALREADYRECYCLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367470i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PROGIDINUSEBYCLSID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367467i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PROPERTYSAVEFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368457i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_PROPERTY_OVERFLOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368452i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367465i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGDB_ALREADYRUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368395i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGDB_NOTINITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368398i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGDB_NOTOPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368397i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGDB_SYSTEMERR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368396i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGFILE_CORRUPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368453i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGISTERTLB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368464i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGISTRARFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368477i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REGISTRY_ACCESSDENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367453i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REMOTEINTERFACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368487i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368439i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_ROLEEXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368500i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_ROLE_DOES_NOT_EXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368441i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_SAFERINVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367454i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_SERVICENOTINSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368458i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_SESSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368468i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_START_APP_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368431i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_START_APP_NEEDS_COMPONENTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368440i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367475i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_SYSTEMAPP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368461i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_USERPASSWDNOTVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368492i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMADMIN_E_USER_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367474i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMQC_E_APPLICATION_NOT_QUEUED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146368000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMQC_E_BAD_MESSAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367996i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMQC_E_NO_IPERSISTSTREAM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367997i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMQC_E_NO_QUEUEABLE_INTERFACES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367998i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMQC_E_UNAUTHENTICATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367995i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const COMQC_E_UNTRUSTED_ENQUEUER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367994i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_ABORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164158i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_ABORTING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164157i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_FIRST: i32 = -2147164160i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_LAST: i32 = -2147164113i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_NOCONTEXT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164156i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_NOJIT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164122i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_NOTRANSACTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164121i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_OLDREF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164153i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_ROLENOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164148i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_SYNCH_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164154i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_TMNOTAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164145i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_E_WOULD_DEADLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164155i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_S_FIRST: i32 = 319488i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTEXT_S_LAST: i32 = 319535i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONTROL_C_EXIT: NTSTATUS = NTSTATUS(-1073741510i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_FIRST: i32 = -2147221056i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_LAST: i32 = -2147221041i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_OLESTREAM_BITMAP_TO_DIB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221053i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_OLESTREAM_FMT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221054i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_OLESTREAM_GET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221056i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_OLESTREAM_PUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221055i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_STG_DIB_TO_BITMAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221050i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_STG_FMT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221052i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_E_STG_NO_STD_STREAM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221051i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_S_FIRST: i32 = 262592i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_S_LAST: i32 = 262607i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CONVERT10_S_NO_PRESENTATION: ::windows_core::HRESULT = ::windows_core::HRESULT(262592i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ACCESSCHECKFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ACESINWRONGORDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417798i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ACNOTINITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417793i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ACTIVATIONFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164127i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ACTIVATIONFAILED_CATALOGERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164125i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ACTIVATIONFAILED_EVENTLOGGED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164126i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ACTIVATIONFAILED_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164124i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ALREADYINITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_APPDIDNTREG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220994i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_APPNOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221003i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_APPSINGLEUSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221002i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ASYNC_WORK_REJECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467223i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467228i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_BAD_PATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959356i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_BAD_SERVER_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467244i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CALL_OUT_OF_TX_SCOPE_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164112i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CANCEL_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417792i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CANTDETERMINECLASS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221006i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CANT_REMOTE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467245i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CLASSSTRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221005i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CLASS_CREATE_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959359i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CLASS_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467225i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CLRNOTAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467224i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CLSREG_INCONSISTENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467233i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CONVERSIONFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_CREATEPROCESS_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467240i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_DBERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164117i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_DECODEFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417795i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_DLLNOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ELEVATION_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959337i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ERRORINAPP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221001i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ERRORINDLL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_EXCEEDSYSACLLIMIT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417799i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_EXIT_TRANSACTION_SCOPE_NOT_CALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164111i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOCLOSEHANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417800i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOCREATEFILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417801i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOGENUUID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417802i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOGETSECCTX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417820i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOGETTOKENINFO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417818i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOGETWINDIR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417804i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOIMPERSONATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417821i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOOPENPROCESSTOKEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417796i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOOPENTHREADTOKEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOQUERYCLIENTBLANKET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FAILEDTOSETDACL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_FIRST: i32 = -2147221008i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_IIDREG_INCONSISTENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467232i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_IIDSTRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221004i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INCOMPATIBLESTREAMVERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417797i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INITIALIZATIONFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164123i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_CLASS_CACHE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467255i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_MEMORY_ALLOCATOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467256i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_ONLY_SINGLE_THREADED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467246i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_RPC_CHANNEL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467254i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_SCM_EXEC_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467247i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_SCM_FILE_MAPPING_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467249i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_SCM_MAP_VIEW_OF_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467248i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_SCM_MUTEX_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467250i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_SHARED_ALLOCATOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467257i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_TLS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467258i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_TLS_CHANNEL_CONTROL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467252i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_TLS_SET_CHANNEL_CONTROL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467253i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INIT_UNACCEPTED_USER_ALLOCATOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467251i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_INVALIDSID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417811i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_ISOLEVELMISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164113i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_LAST: i32 = -2147220993i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_LAUNCH_PERMSSION_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467237i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_LOOKUPACCNAMEFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417806i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_LOOKUPACCSIDFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_MALFORMED_SPN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467213i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_MISSING_DISPLAYNAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959339i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_MSI_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467229i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NETACCESSAPIFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417813i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOCOOKIES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164118i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOIISINTRINSICS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164119i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOMATCHINGNAMEFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417807i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOMATCHINGSIDFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417809i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOSYNCHRONIZATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164114i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOTCONSTRUCTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164115i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOTINITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221008i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOTPOOLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164116i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467231i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_NO_SECCTX_IN_ACTIVATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467221i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_OBJISREG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220996i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_OBJNOTCONNECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220995i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_OBJNOTREG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220997i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_OBJSRV_RPC_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959354i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_OLE1DDE_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467242i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_PATHTOOLONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417803i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_PREMATURE_STUB_RUNDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467211i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_RELEASED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220993i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_RELOAD_DLL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467230i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_REMOTE_COMMUNICATION_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467235i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_RUNAS_CREATEPROCESS_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467239i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_RUNAS_LOGON_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467238i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_RUNAS_SYNTAX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467241i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_RUNAS_VALUE_MUST_BE_AAA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959338i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SCM_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959358i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SCM_RPC_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959357i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SERVER_EXEC_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959355i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SERVER_INIT_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467222i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SERVER_NOT_PAUSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467226i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SERVER_PAUSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467227i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SERVER_START_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467234i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SERVER_STOPPING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959352i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SETSERLHNDLFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417805i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_START_SERVICE_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467236i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_SXS_CONFIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467214i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_THREADINGMODEL_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147164120i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_THREADPOOL_CONFIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467215i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_TRACKER_CONFIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467216i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_TRUSTEEDOESNTMATCHCLIENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417817i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_UNREVOKED_REGISTRATION_ON_APARTMENT_SHUTDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467212i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_WRONGOSFORAPP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220998i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_WRONGTRUSTEENAMESYNTAX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417812i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_E_WRONG_SERVER_IDENTITY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467243i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_S_FIRST: i32 = 262640i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_S_LAST: i32 = 262655i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_S_MACHINENAMENOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(524307i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CO_S_NOTALLINTERFACES: ::windows_core::HRESULT = ::windows_core::HRESULT(524306i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ALREADY_DECRYPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889719i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_BADARGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881271i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_BADPDU: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881272i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_BADREAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881270i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_BADTAG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881269i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_CHOICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881268i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_CONSTRAINT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881275i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_CORRUPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881277i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_EOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881278i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881280i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_EXTENDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_INTERNAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881279i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_LARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881276i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881274i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_NOEOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_NYI: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881228i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_OVERFLOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881273i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_PDU_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881229i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_RULE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881267i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ASN1_UTF8: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881266i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ATTRIBUTES_MISSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889713i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_AUTH_ATTR_MISSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889722i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_BAD_ENCODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885630i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_BAD_LEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_BAD_MSG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885619i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_CONTROL_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889716i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_DELETED_PREV: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885624i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885627i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_FILERESIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885595i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_FILE_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885629i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_HASH_VALUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889721i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_INVALID_IA5_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885598i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_INVALID_INDEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889720i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_INVALID_MSG_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889724i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_INVALID_NUMERIC_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885600i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_INVALID_PRINTABLE_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885599i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_INVALID_X500_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885597i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_ISSUER_SERIALNUMBER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889715i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_MISSING_PUBKEY_PARA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885588i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_MSG_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889727i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NOT_CHAR_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885596i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NOT_DECRYPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889718i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885628i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NOT_IN_CTL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885590i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NOT_IN_REVOCATION_DATABASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885612i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_DECRYPT_CERT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885620i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_KEY_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885621i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_MATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885623i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_PROVIDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885626i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_REVOCATION_CHECK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885614i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_REVOCATION_DLL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885615i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_SIGNER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885618i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_TRUSTED_SIGNER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885589i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_VERIFY_USAGE_CHECK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885592i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_NO_VERIFY_USAGE_DLL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885593i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_OBJECT_LOCATOR_OBJECT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885587i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_OID_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889725i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_OSS_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881536i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_PENDING_CLOSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885617i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_RECIPIENT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889717i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_REVOCATION_OFFLINE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885613i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_REVOKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885616i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_SECURITY_SETTINGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885594i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_SELF_SIGNED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_SIGNER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889714i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_STREAM_INSUFFICIENT_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889711i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_STREAM_MSG_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889712i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_UNEXPECTED_ENCODING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889723i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_UNEXPECTED_MSG_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885622i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_UNKNOWN_ALGO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146889726i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_E_VERIFY_USAGE_OFFLINE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885591i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CRYPT_I_NEW_PROTECTION_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(593938i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_ADMIN_LIMIT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221139i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_CLASS_NOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221146i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_FIRST: i32 = -2147221148i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221137i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_INVALID_PATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221141i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_INVALID_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221145i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_LAST: i32 = -2147221137i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_NETWORK_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221140i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_NOT_DELETABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221147i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_NO_CLASSSTORE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221144i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_OBJECT_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221142i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_OBJECT_NOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221143i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_PACKAGE_NOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221148i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const CS_E_SCHEMA_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221138i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_BAD_NUMBER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238895i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_BITMAP_BOUND_AS_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238875i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_BITMAP_CANNOT_DRAW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238879i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_CYCLIC_GRAPH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238880i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_DISPLAY_FORMAT_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238903i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_DISPLAY_STATE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238906i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_EFFECT_IS_NOT_REGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238872i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_EXCEEDS_MAX_BITMAP_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238883i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INCOMPATIBLE_BRUSH_TYPES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238888i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INSUFFICIENT_DEVICE_CAPABILITIES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238874i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INTERMEDIATE_TOO_LARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238873i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238904i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INVALID_CALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238902i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INVALID_GLYPH_IMAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238866i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INVALID_GRAPH_CONFIGURATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238882i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INVALID_INTERNAL_GRAPH_CONFIGURATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238881i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INVALID_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238871i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_INVALID_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238876i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_LAYER_ALREADY_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238893i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_MAX_TEXTURE_SIZE_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238897i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_NOT_INITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238910i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_NO_HARDWARE_DEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238901i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_NO_SUBPROPERTIES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238870i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_ORIGINAL_TARGET_NOT_BOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238877i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_OUTSTANDING_BITMAP_REFERENCES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238878i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_POP_CALL_DID_NOT_MATCH_PUSH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238892i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_PRINT_FORMAT_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238868i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_PRINT_JOB_CLOSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238869i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_PUSH_POP_UNBALANCED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238890i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_RECREATE_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238900i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_RENDER_TARGET_HAS_LAYER_OR_CLIPRECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238889i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_SCANNER_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238908i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_SCREEN_ACCESS_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238907i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_SHADER_COMPILE_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238898i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_TARGET_NOT_GDI_COMPATIBLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238886i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_TEXT_EFFECT_IS_WRONG_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238885i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_TEXT_RENDERER_NOT_RELEASED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238884i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_TOO_MANY_SHADER_ELEMENTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238899i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_TOO_MANY_TRANSFORM_INPUTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238867i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_UNSUPPORTED_OPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238909i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_UNSUPPORTED_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238896i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_WIN32_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238887i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_WRONG_FACTORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238894i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_WRONG_RESOURCE_DOMAIN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238891i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_WRONG_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238911i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D2DERR_ZERO_VECTOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003238905i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D10_ERROR_FILE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005336062i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D10_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005336063i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005139452i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D11_ERROR_FILE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005139454i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005139455i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005139453i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D12_ERROR_ADAPTER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005008383i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D12_ERROR_DRIVER_VERSION_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005008382i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const D3D12_ERROR_INVALID_REDIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005008381i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DATA_E_FIRST: i32 = -2147221200i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DATA_E_LAST: i32 = -2147221185i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DATA_S_FIRST: i32 = 262448i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DATA_S_LAST: i32 = 262463i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DATA_S_SAMEFORMATETC: ::windows_core::HRESULT = ::windows_core::HRESULT(262448i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_APP_NOT_IDLE: NTSTATUS = NTSTATUS(-1073676286i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_COMMAND_EXCEPTION: NTSTATUS = NTSTATUS(1073807369i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_CONTINUE: NTSTATUS = NTSTATUS(65538i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_CONTROL_BREAK: NTSTATUS = NTSTATUS(1073807368i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_CONTROL_C: NTSTATUS = NTSTATUS(1073807365i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_EXCEPTION_HANDLED: NTSTATUS = NTSTATUS(65537i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_EXCEPTION_NOT_HANDLED: NTSTATUS = NTSTATUS(-2147418111i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_NO_STATE_CHANGE: NTSTATUS = NTSTATUS(-1073676287i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_PRINTEXCEPTION_C: NTSTATUS = NTSTATUS(1073807366i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_PRINTEXCEPTION_WIDE_C: NTSTATUS = NTSTATUS(1073807370i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_REPLY_LATER: NTSTATUS = NTSTATUS(1073807361i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_RIPEXCEPTION: NTSTATUS = NTSTATUS(1073807367i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_TERMINATE_PROCESS: NTSTATUS = NTSTATUS(1073807364i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_TERMINATE_THREAD: NTSTATUS = NTSTATUS(1073807363i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DBG_UNABLE_TO_PROVIDE_HANDLE: NTSTATUS = NTSTATUS(1073807362i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DCOMPOSITION_ERROR_SURFACE_BEING_RENDERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302399i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DCOMPOSITION_ERROR_SURFACE_NOT_BEING_RENDERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302398i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DCOMPOSITION_ERROR_WINDOW_ALREADY_COMPOSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302400i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DIGSIG_E_CRYPTO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762744i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DIGSIG_E_DECODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762746i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DIGSIG_E_ENCODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762747i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DIGSIG_E_EXTENSIBILITY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762745i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_ARRAYISLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352563i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_BADCALLEE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352560i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_BADINDEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352565i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_BADPARAMCOUNT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352562i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_BADVARTYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352568i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_BUFFERTOOSMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352557i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_DIVBYZERO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352558i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_EXCEPTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352567i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_MEMBERNOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352573i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_NONAMEDARGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352569i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_NOTACOLLECTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352559i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_OVERFLOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352566i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_PARAMNOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352572i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_PARAMNOTOPTIONAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352561i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_TYPEMISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352571i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_UNKNOWNINTERFACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352575i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_UNKNOWNLCID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352564i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DISP_E_UNKNOWNNAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352570i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ADDRESS_REQUIRED: WIN32_ERROR = WIN32_ERROR(9573u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ALIAS_LOOP: WIN32_ERROR = WIN32_ERROR(9722u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_AUTOZONE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9610u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_AXFR: WIN32_ERROR = WIN32_ERROR(9752u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_BACKGROUND_LOADING: WIN32_ERROR = WIN32_ERROR(9568u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_BAD_KEYMASTER: WIN32_ERROR = WIN32_ERROR(9122u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_BAD_PACKET: WIN32_ERROR = WIN32_ERROR(9502u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_CANNOT_FIND_ROOT_HINTS: WIN32_ERROR = WIN32_ERROR(9564u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_CLIENT_SUBNET_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9977u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_CLIENT_SUBNET_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9976u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_CLIENT_SUBNET_IS_ACCESSED: WIN32_ERROR = WIN32_ERROR(9975u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_CNAME_COLLISION: WIN32_ERROR = WIN32_ERROR(9709u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_CNAME_LOOP: WIN32_ERROR = WIN32_ERROR(9707u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DATABASE_BASE: WIN32_ERROR = WIN32_ERROR(9700u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DATAFILE_BASE: WIN32_ERROR = WIN32_ERROR(9650u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DATAFILE_OPEN_FAILURE: WIN32_ERROR = WIN32_ERROR(9653u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DATAFILE_PARSING: WIN32_ERROR = WIN32_ERROR(9655u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DEFAULT_SCOPE: WIN32_ERROR = WIN32_ERROR(9960u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DEFAULT_VIRTUALIZATION_INSTANCE: WIN32_ERROR = WIN32_ERROR(9925u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DEFAULT_ZONESCOPE: WIN32_ERROR = WIN32_ERROR(9953u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DELEGATION_REQUIRED: WIN32_ERROR = WIN32_ERROR(9571u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DNAME_COLLISION: WIN32_ERROR = WIN32_ERROR(9721u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DNSSEC_BASE: WIN32_ERROR = WIN32_ERROR(9100u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DNSSEC_IS_DISABLED: WIN32_ERROR = WIN32_ERROR(9125u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DP_ALREADY_ENLISTED: WIN32_ERROR = WIN32_ERROR(9904u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DP_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9902u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DP_BASE: WIN32_ERROR = WIN32_ERROR(9900u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DP_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9901u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DP_FSMO_ERROR: WIN32_ERROR = WIN32_ERROR(9906u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DP_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(9905u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DP_NOT_ENLISTED: WIN32_ERROR = WIN32_ERROR(9903u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DS_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(9717u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DS_ZONE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9718u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DWORD_VALUE_TOO_LARGE: WIN32_ERROR = WIN32_ERROR(9567u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_DWORD_VALUE_TOO_SMALL: WIN32_ERROR = WIN32_ERROR(9566u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_FILE_WRITEBACK_FAILED: WIN32_ERROR = WIN32_ERROR(9654u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_FORWARDER_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9619u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_GENERAL_API_BASE: WIN32_ERROR = WIN32_ERROR(9550u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INCONSISTENT_ROOT_HINTS: WIN32_ERROR = WIN32_ERROR(9565u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVAILD_VIRTUALIZATION_INSTANCE_NAME: WIN32_ERROR = WIN32_ERROR(9924u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_CLIENT_SUBNET_NAME: WIN32_ERROR = WIN32_ERROR(9984u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_DATA: WIN32_ERROR = WIN32_ERROR(13u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_DATAFILE_NAME: WIN32_ERROR = WIN32_ERROR(9652u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_INITIAL_ROLLOVER_OFFSET: WIN32_ERROR = WIN32_ERROR(9115u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_IP_ADDRESS: WIN32_ERROR = WIN32_ERROR(9552u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_KEY_SIZE: WIN32_ERROR = WIN32_ERROR(9106u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_NAME: WIN32_ERROR = WIN32_ERROR(123u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_NAME_CHAR: WIN32_ERROR = WIN32_ERROR(9560u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_NSEC3_ITERATION_COUNT: WIN32_ERROR = WIN32_ERROR(9124u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_POLICY_TABLE: WIN32_ERROR = WIN32_ERROR(9572u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_PROPERTY: WIN32_ERROR = WIN32_ERROR(9553u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_ROLLOVER_PERIOD: WIN32_ERROR = WIN32_ERROR(9114u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_SCOPE_NAME: WIN32_ERROR = WIN32_ERROR(9958u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_SCOPE_OPERATION: WIN32_ERROR = WIN32_ERROR(9961u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_SIGNATURE_VALIDITY_PERIOD: WIN32_ERROR = WIN32_ERROR(9123u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_TYPE: WIN32_ERROR = WIN32_ERROR(9551u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_XML: WIN32_ERROR = WIN32_ERROR(9126u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_ZONESCOPE_NAME: WIN32_ERROR = WIN32_ERROR(9954u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_ZONE_OPERATION: WIN32_ERROR = WIN32_ERROR(9603u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_INVALID_ZONE_TYPE: WIN32_ERROR = WIN32_ERROR(9611u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_KEYMASTER_REQUIRED: WIN32_ERROR = WIN32_ERROR(9101u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_KSP_DOES_NOT_SUPPORT_PROTECTION: WIN32_ERROR = WIN32_ERROR(9108u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_KSP_NOT_ACCESSIBLE: WIN32_ERROR = WIN32_ERROR(9112u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_LOAD_ZONESCOPE_FAILED: WIN32_ERROR = WIN32_ERROR(9956u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_MASK: WIN32_ERROR = WIN32_ERROR(9000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NAME_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9714u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NAME_NOT_IN_ZONE: WIN32_ERROR = WIN32_ERROR(9706u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NBSTAT_INIT_FAILED: WIN32_ERROR = WIN32_ERROR(9617u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NEED_SECONDARY_ADDRESSES: WIN32_ERROR = WIN32_ERROR(9614u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NEED_WINS_SERVERS: WIN32_ERROR = WIN32_ERROR(9616u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NODE_CREATION_FAILED: WIN32_ERROR = WIN32_ERROR(9703u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NODE_IS_CNAME: WIN32_ERROR = WIN32_ERROR(9708u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NODE_IS_DNAME: WIN32_ERROR = WIN32_ERROR(9720u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NON_RFC_NAME: WIN32_ERROR = WIN32_ERROR(9556u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_ON_ACTIVE_SKD: WIN32_ERROR = WIN32_ERROR(9119u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_ON_RODC: WIN32_ERROR = WIN32_ERROR(9569u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER: WIN32_ERROR = WIN32_ERROR(9562u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_ON_SIGNED_ZONE: WIN32_ERROR = WIN32_ERROR(9102u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_ON_UNSIGNED_ZONE: WIN32_ERROR = WIN32_ERROR(9121u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_ON_ZSK: WIN32_ERROR = WIN32_ERROR(9118u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION: WIN32_ERROR = WIN32_ERROR(9563u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_UNDER_DNAME: WIN32_ERROR = WIN32_ERROR(9570u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ALLOWED_WITH_ZONESCOPES: WIN32_ERROR = WIN32_ERROR(9955u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_ENOUGH_SIGNING_KEY_DESCRIPTORS: WIN32_ERROR = WIN32_ERROR(9104u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NOT_UNIQUE: WIN32_ERROR = WIN32_ERROR(9555u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE: WIN32_ERROR = WIN32_ERROR(9719u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_CREATE_CACHE_DATA: WIN32_ERROR = WIN32_ERROR(9713u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_DNS_SERVERS: WIN32_ERROR = WIN32_ERROR(9852u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_MEMORY: WIN32_ERROR = WIN32_ERROR(14u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_PACKET: WIN32_ERROR = WIN32_ERROR(9503u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_TCPIP: WIN32_ERROR = WIN32_ERROR(9851u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_VALID_TRUST_ANCHORS: WIN32_ERROR = WIN32_ERROR(9127u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NO_ZONE_INFO: WIN32_ERROR = WIN32_ERROR(9602u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NSEC3_INCOMPATIBLE_WITH_RSA_SHA1: WIN32_ERROR = WIN32_ERROR(9103u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NSEC3_NAME_COLLISION: WIN32_ERROR = WIN32_ERROR(9129u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NSEC_INCOMPATIBLE_WITH_NSEC3_RSA_SHA1: WIN32_ERROR = WIN32_ERROR(9130u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_NUMERIC_NAME: WIN32_ERROR = WIN32_ERROR(9561u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_OPERATION_BASE: WIN32_ERROR = WIN32_ERROR(9750u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_PACKET_FMT_BASE: WIN32_ERROR = WIN32_ERROR(9500u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9971u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9972u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA: WIN32_ERROR = WIN32_ERROR(9973u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA_CLIENT_SUBNET: WIN32_ERROR = WIN32_ERROR(9990u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA_FQDN: WIN32_ERROR = WIN32_ERROR(9994u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA_INTERFACE: WIN32_ERROR = WIN32_ERROR(9993u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA_NETWORK_PROTOCOL: WIN32_ERROR = WIN32_ERROR(9992u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA_QUERY_TYPE: WIN32_ERROR = WIN32_ERROR(9995u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA_TIME_OF_DAY: WIN32_ERROR = WIN32_ERROR(9996u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_CRITERIA_TRANSPORT_PROTOCOL: WIN32_ERROR = WIN32_ERROR(9991u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_NAME: WIN32_ERROR = WIN32_ERROR(9982u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_SETTINGS: WIN32_ERROR = WIN32_ERROR(9974u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_INVALID_WEIGHT: WIN32_ERROR = WIN32_ERROR(9981u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_LOCKED: WIN32_ERROR = WIN32_ERROR(9980u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_MISSING_CRITERIA: WIN32_ERROR = WIN32_ERROR(9983u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_PROCESSING_ORDER_INVALID: WIN32_ERROR = WIN32_ERROR(9985u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_SCOPE_MISSING: WIN32_ERROR = WIN32_ERROR(9986u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_POLICY_SCOPE_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(9987u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_PRIMARY_REQUIRES_DATAFILE: WIN32_ERROR = WIN32_ERROR(9651u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE: WIN32_ERROR = WIN32_ERROR(9504u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_BADKEY: WIN32_ERROR = WIN32_ERROR(9017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_BADSIG: WIN32_ERROR = WIN32_ERROR(9016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_BADTIME: WIN32_ERROR = WIN32_ERROR(9018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_FORMAT_ERROR: WIN32_ERROR = WIN32_ERROR(9001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_LAST: WIN32_ERROR = WIN32_ERROR(9018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_NAME_ERROR: WIN32_ERROR = WIN32_ERROR(9003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_NOTAUTH: WIN32_ERROR = WIN32_ERROR(9009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_NOTZONE: WIN32_ERROR = WIN32_ERROR(9010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_NOT_IMPLEMENTED: WIN32_ERROR = WIN32_ERROR(9004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_NO_ERROR: WIN32_ERROR = WIN32_ERROR(0u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_NXRRSET: WIN32_ERROR = WIN32_ERROR(9008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_REFUSED: WIN32_ERROR = WIN32_ERROR(9005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_SERVER_FAILURE: WIN32_ERROR = WIN32_ERROR(9002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_YXDOMAIN: WIN32_ERROR = WIN32_ERROR(9006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RCODE_YXRRSET: WIN32_ERROR = WIN32_ERROR(9007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RECORD_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9711u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RECORD_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9701u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RECORD_FORMAT: WIN32_ERROR = WIN32_ERROR(9702u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT: WIN32_ERROR = WIN32_ERROR(9710u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RECORD_TIMED_OUT: WIN32_ERROR = WIN32_ERROR(9705u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RESPONSE_CODES_BASE: WIN32_ERROR = WIN32_ERROR(9000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ROLLOVER_ALREADY_QUEUED: WIN32_ERROR = WIN32_ERROR(9120u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ROLLOVER_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(9116u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ROLLOVER_NOT_POKEABLE: WIN32_ERROR = WIN32_ERROR(9128u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RRL_INVALID_IPV4_PREFIX: WIN32_ERROR = WIN32_ERROR(9913u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RRL_INVALID_IPV6_PREFIX: WIN32_ERROR = WIN32_ERROR(9914u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RRL_INVALID_LEAK_RATE: WIN32_ERROR = WIN32_ERROR(9916u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RRL_INVALID_TC_RATE: WIN32_ERROR = WIN32_ERROR(9915u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RRL_INVALID_WINDOW_SIZE: WIN32_ERROR = WIN32_ERROR(9912u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RRL_LEAK_RATE_LESSTHAN_TC_RATE: WIN32_ERROR = WIN32_ERROR(9917u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_RRL_NOT_ENABLED: WIN32_ERROR = WIN32_ERROR(9911u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SCOPE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9963u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SCOPE_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9959u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SCOPE_LOCKED: WIN32_ERROR = WIN32_ERROR(9962u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SECONDARY_DATA: WIN32_ERROR = WIN32_ERROR(9712u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP: WIN32_ERROR = WIN32_ERROR(9612u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SECURE_BASE: WIN32_ERROR = WIN32_ERROR(9800u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SERVERSCOPE_IS_REFERENCED: WIN32_ERROR = WIN32_ERROR(9988u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SETUP_BASE: WIN32_ERROR = WIN32_ERROR(9850u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SIGNING_KEY_NOT_ACCESSIBLE: WIN32_ERROR = WIN32_ERROR(9107u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SOA_DELETE_INVALID: WIN32_ERROR = WIN32_ERROR(9618u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_STANDBY_KEY_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(9117u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SUBNET_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9979u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_SUBNET_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9978u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_TOO_MANY_SKDS: WIN32_ERROR = WIN32_ERROR(9113u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_TRY_AGAIN_LATER: WIN32_ERROR = WIN32_ERROR(9554u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_UNEXPECTED_CNG_ERROR: WIN32_ERROR = WIN32_ERROR(9110u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_UNEXPECTED_DATA_PROTECTION_ERROR: WIN32_ERROR = WIN32_ERROR(9109u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_UNKNOWN_RECORD_TYPE: WIN32_ERROR = WIN32_ERROR(9704u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_UNKNOWN_SIGNING_PARAMETER_VERSION: WIN32_ERROR = WIN32_ERROR(9111u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_UNSECURE_PACKET: WIN32_ERROR = WIN32_ERROR(9505u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_UNSUPPORTED_ALGORITHM: WIN32_ERROR = WIN32_ERROR(9105u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_VIRTUALIZATION_INSTANCE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9921u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_VIRTUALIZATION_INSTANCE_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9922u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_VIRTUALIZATION_TREE_LOCKED: WIN32_ERROR = WIN32_ERROR(9923u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_WINS_INIT_FAILED: WIN32_ERROR = WIN32_ERROR(9615u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONESCOPE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9951u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONESCOPE_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9952u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONESCOPE_FILE_WRITEBACK_FAILED: WIN32_ERROR = WIN32_ERROR(9957u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONESCOPE_IS_REFERENCED: WIN32_ERROR = WIN32_ERROR(9989u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(9609u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_BASE: WIN32_ERROR = WIN32_ERROR(9600u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_CONFIGURATION_ERROR: WIN32_ERROR = WIN32_ERROR(9604u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_CREATION_FAILED: WIN32_ERROR = WIN32_ERROR(9608u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(9601u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_HAS_NO_NS_RECORDS: WIN32_ERROR = WIN32_ERROR(9606u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_HAS_NO_SOA_RECORD: WIN32_ERROR = WIN32_ERROR(9605u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_IS_SHUTDOWN: WIN32_ERROR = WIN32_ERROR(9621u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_LOCKED: WIN32_ERROR = WIN32_ERROR(9607u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_LOCKED_FOR_SIGNING: WIN32_ERROR = WIN32_ERROR(9622u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_NOT_SECONDARY: WIN32_ERROR = WIN32_ERROR(9613u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_ERROR_ZONE_REQUIRES_MASTER_IP: WIN32_ERROR = WIN32_ERROR(9620u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_INFO_ADDED_LOCAL_WINS: i32 = 9753i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_INFO_AXFR_COMPLETE: i32 = 9751i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_INFO_NO_RECORDS: i32 = 9501i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_REQUEST_PENDING: i32 = 9506i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_STATUS_CONTINUE_NEEDED: i32 = 9801i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_STATUS_DOTTED_NAME: i32 = 9558i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_STATUS_FQDN: i32 = 9557i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_STATUS_SINGLE_PART_NAME: i32 = 9559i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_WARNING_DOMAIN_UNDELETED: i32 = 9716i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DNS_WARNING_PTR_CREATE_FAILED: i32 = 9715i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_E_ALREADYREGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221247i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_E_CONCURRENT_DRAG_ATTEMPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221245i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_E_FIRST: i32 = -2147221248i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_E_INVALIDHWND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221246i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_E_LAST: i32 = -2147221233i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_E_NOTREGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221248i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_S_CANCEL: ::windows_core::HRESULT = ::windows_core::HRESULT(262401i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_S_DROP: ::windows_core::HRESULT = ::windows_core::HRESULT(262400i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_S_FIRST: i32 = 262400i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_S_LAST: i32 = 262415i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DRAGDROP_S_USEDEFAULTCURSORS: ::windows_core::HRESULT = ::windows_core::HRESULT(262402i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DUPLICATE_CLOSE_SOURCE: DUPLICATE_HANDLE_OPTIONS = DUPLICATE_HANDLE_OPTIONS(1u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DUPLICATE_SAME_ACCESS: DUPLICATE_HANDLE_OPTIONS = DUPLICATE_HANDLE_OPTIONS(2u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_CLIPFORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221398i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_DVASPECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221397i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_DVTARGETDEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221403i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_DVTARGETDEVICE_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221396i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_FORMATETC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221404i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_LINDEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221400i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_NOIVIEWOBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221395i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_STATDATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221401i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_STGMEDIUM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221402i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DV_E_TYMED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221399i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWMERR_CATASTROPHIC_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302654i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWMERR_STATE_TRANSITION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302656i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWMERR_THEME_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302655i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_E_ADAPTER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144980987i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_E_COMPOSITIONDISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144980991i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_E_NOT_QUEUING_PRESENTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144980988i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_E_NO_REDIRECTION_SURFACE_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144980989i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_E_REMOTING_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144980990i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_E_TEXTURE_TOO_LARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144980985i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_S_GDI_REDIRECTION_SURFACE: ::windows_core::HRESULT = ::windows_core::HRESULT(2502661i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWM_S_GDI_REDIRECTION_SURFACE_BLT_VIA_GDI: ::windows_core::HRESULT = ::windows_core::HRESULT(2502664i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_ALREADYREGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283962i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_CACHEFORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283961i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_CACHEVERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283960i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_FILEACCESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283964i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_FILEFORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283968i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_FILENOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283965i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_FLOWDIRECTIONCONFLICTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283957i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_FONTCOLLECTIONOBSOLETE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283963i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_NOCOLOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283956i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_NOFONT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283966i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_TEXTRENDERERINCOMPATIBLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283958i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_UNEXPECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283967i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DWRITE_E_UNSUPPORTEDOPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003283959i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXCORE_ERROR_EVENT_NOT_UNREGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2004877311i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_DDI_ERR_NONEXCLUSIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005204989i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_DDI_ERR_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005204990i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_DDI_ERR_WASSTILLDRAWING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2005204991i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_CLIPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(142213122i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_DDA_WAS_STILL_DRAWING: ::windows_core::HRESULT = ::windows_core::HRESULT(142213130i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(142213126i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_MODE_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(142213127i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_MODE_CHANGE_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(142213128i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_NO_DESKTOP_ACCESS: ::windows_core::HRESULT = ::windows_core::HRESULT(142213125i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_NO_REDIRECTION: ::windows_core::HRESULT = ::windows_core::HRESULT(142213124i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_OCCLUDED: ::windows_core::HRESULT = ::windows_core::HRESULT(142213121i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_PRESENT_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(142213167i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const DXGI_STATUS_UNOCCLUDED: ::windows_core::HRESULT = ::windows_core::HRESULT(142213129i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_ADMINS_CANNOT_CHANGE_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913080i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_ADMINS_HAVE_BLANK_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913081i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_CONNECTED_ADMINS_NEED_TO_CHANGE_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913077i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_CURRENT_CONNECTED_USER_NEED_TO_CHANGE_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913075i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_CURRENT_USER_HAS_BLANK_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913084i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_LOCAL_CONTROLLED_USERS_CANNOT_CHANGE_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913079i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_PASSWORD_POLICY_NOT_ENFORCEABLE_FOR_CONNECTED_ADMINS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913078i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_PASSWORD_POLICY_NOT_ENFORCEABLE_FOR_CURRENT_CONNECTED_USER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913076i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_POLICY_COMPLIANT_WITH_ACTIONS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913086i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_POLICY_NOT_MANAGED_BY_OS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913087i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_REQUESTED_POLICY_NOT_ENFORCEABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913085i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_REQUESTED_POLICY_PASSWORD_EXPIRATION_INCOMPATIBLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913083i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EAS_E_USER_CANNOT_CHANGE_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141913082i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ENUM_E_FIRST: i32 = -2147221072i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ENUM_E_LAST: i32 = -2147221057i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ENUM_S_FIRST: i32 = 262576i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ENUM_S_LAST: i32 = 262591i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EPT_NT_CANT_CREATE: NTSTATUS = NTSTATUS(-1073610676i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EPT_NT_CANT_PERFORM_OP: NTSTATUS = NTSTATUS(-1073610699i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EPT_NT_INVALID_ENTRY: NTSTATUS = NTSTATUS(-1073610700i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EPT_NT_NOT_REGISTERED: NTSTATUS = NTSTATUS(-1073610698i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ABANDONED_WAIT_0: WIN32_ERROR = WIN32_ERROR(735u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ABANDONED_WAIT_63: WIN32_ERROR = WIN32_ERROR(736u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ABANDON_HIBERFILE: WIN32_ERROR = WIN32_ERROR(787u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ABIOS_ERROR: WIN32_ERROR = WIN32_ERROR(538u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCESS_AUDIT_BY_POLICY: WIN32_ERROR = WIN32_ERROR(785u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(5u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCESS_DENIED_APPDATA: WIN32_ERROR = WIN32_ERROR(502u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCESS_DISABLED_BY_POLICY: WIN32_ERROR = WIN32_ERROR(1260u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY: WIN32_ERROR = WIN32_ERROR(786u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCESS_DISABLED_WEBBLADE: WIN32_ERROR = WIN32_ERROR(1277u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER: WIN32_ERROR = WIN32_ERROR(1278u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCOUNT_DISABLED: WIN32_ERROR = WIN32_ERROR(1331u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCOUNT_EXPIRED: WIN32_ERROR = WIN32_ERROR(1793u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCOUNT_LOCKED_OUT: WIN32_ERROR = WIN32_ERROR(1909u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACCOUNT_RESTRICTION: WIN32_ERROR = WIN32_ERROR(1327u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACPI_ERROR: WIN32_ERROR = WIN32_ERROR(669u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACTIVATION_COUNT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(7059u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ACTIVE_CONNECTIONS: WIN32_ERROR = WIN32_ERROR(2402u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ADAP_HDW_ERR: WIN32_ERROR = WIN32_ERROR(57u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ADDRESS_ALREADY_ASSOCIATED: WIN32_ERROR = WIN32_ERROR(1227u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ADDRESS_NOT_ASSOCIATED: WIN32_ERROR = WIN32_ERROR(1228u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ADVANCED_INSTALLER_FAILED: WIN32_ERROR = WIN32_ERROR(14099u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALERTED: WIN32_ERROR = WIN32_ERROR(739u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALIAS_EXISTS: WIN32_ERROR = WIN32_ERROR(1379u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALLOCATE_BUCKET: WIN32_ERROR = WIN32_ERROR(602u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALLOTTED_SPACE_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1344u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALLOWED_PORT_TYPE_RESTRICTION: u32 = 941u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALL_NODES_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(5037u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALL_SIDS_FILTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073151998i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1933u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_ASSIGNED: WIN32_ERROR = WIN32_ERROR(85u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_CONNECTED: u32 = 901u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_CONNECTING: u32 = 910u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(183u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_FIBER: WIN32_ERROR = WIN32_ERROR(1280u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_HAS_STREAM_ID: WIN32_ERROR = WIN32_ERROR(4444u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_INITIALIZED: WIN32_ERROR = WIN32_ERROR(1247u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_REGISTERED: WIN32_ERROR = WIN32_ERROR(1242u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_RUNNING_LKG: WIN32_ERROR = WIN32_ERROR(1074u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_THREAD: WIN32_ERROR = WIN32_ERROR(1281u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_WAITING: WIN32_ERROR = WIN32_ERROR(1904u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ALREADY_WIN32: WIN32_ERROR = WIN32_ERROR(719u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AMBIGUOUS_SYSTEM_DEVICE: WIN32_ERROR = WIN32_ERROR(15250u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_API_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(15841u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPCONTAINER_REQUIRED: WIN32_ERROR = WIN32_ERROR(4251u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_APP_COMPAT_BLOCK: WIN32_ERROR = WIN32_ERROR(3068u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT: WIN32_ERROR = WIN32_ERROR(3069u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_LICENSING: WIN32_ERROR = WIN32_ERROR(3071u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_RESOURCES: WIN32_ERROR = WIN32_ERROR(3072u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_TERMINATION: WIN32_ERROR = WIN32_ERROR(3070u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_CONDITION_NOT_SATISFIED: WIN32_ERROR = WIN32_ERROR(3060u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_HANDLE_INVALIDATED: WIN32_ERROR = WIN32_ERROR(3061u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_HOST_ID_MISMATCH: WIN32_ERROR = WIN32_ERROR(3066u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_INVALID_HOST_GENERATION: WIN32_ERROR = WIN32_ERROR(3062u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_INVALID_HOST_STATE: WIN32_ERROR = WIN32_ERROR(3064u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_NO_DONOR: WIN32_ERROR = WIN32_ERROR(3065u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_UNEXPECTED_PROCESS_REGISTRATION: WIN32_ERROR = WIN32_ERROR(3063u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPEXEC_UNKNOWN_USER: WIN32_ERROR = WIN32_ERROR(3067u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPHELP_BLOCK: WIN32_ERROR = WIN32_ERROR(1259u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPINSTALLER_ACTIVATION_BLOCKED: WIN32_ERROR = WIN32_ERROR(15646u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPINSTALLER_IS_MANAGED_BY_SYSTEM: WIN32_ERROR = WIN32_ERROR(15672u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPINSTALLER_URI_IN_USE: WIN32_ERROR = WIN32_ERROR(15671u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPX_FILE_NOT_ENCRYPTED: WIN32_ERROR = WIN32_ERROR(409u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN: WIN32_ERROR = WIN32_ERROR(15624u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APPX_RAW_DATA_WRITE_FAILED: WIN32_ERROR = WIN32_ERROR(15648u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_DATA_CORRUPT: WIN32_ERROR = WIN32_ERROR(4402u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_DATA_EXPIRED: WIN32_ERROR = WIN32_ERROR(4401u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_DATA_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(4403u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_DATA_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4400u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_DATA_REBOOT_REQUIRED: WIN32_ERROR = WIN32_ERROR(4404u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_HANG: WIN32_ERROR = WIN32_ERROR(1298u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_INIT_FAILURE: WIN32_ERROR = WIN32_ERROR(575u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_APP_WRONG_OS: WIN32_ERROR = WIN32_ERROR(1151u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ARBITRATION_UNHANDLED: WIN32_ERROR = WIN32_ERROR(723u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ARENA_TRASHED: WIN32_ERROR = WIN32_ERROR(7u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ARITHMETIC_OVERFLOW: WIN32_ERROR = WIN32_ERROR(534u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ASSERTION_FAILURE: WIN32_ERROR = WIN32_ERROR(668u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ATOMIC_LOCKS_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(174u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ATTRIBUTE_NOT_PRESENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898422i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUDITING_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073151999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUDIT_FAILED: WIN32_ERROR = WIN32_ERROR(606u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUTHENTICATION_FIREWALL_FAILED: WIN32_ERROR = WIN32_ERROR(1935u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUTHENTICATOR_MISMATCH: u32 = 955u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUTHIP_FAILURE: WIN32_ERROR = WIN32_ERROR(1469u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUTH_PROTOCOL_REJECTED: u32 = 917u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUTH_PROTOCOL_RESTRICTION: u32 = 942u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUTH_SERVER_TIMEOUT: u32 = 930u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_AUTODATASEG_EXCEEDS_64k: WIN32_ERROR = WIN32_ERROR(199u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BACKUP_CONTROLLER: WIN32_ERROR = WIN32_ERROR(586u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BADDB: WIN32_ERROR = WIN32_ERROR(1009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BADKEY: WIN32_ERROR = WIN32_ERROR(1010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BADSTARTPOSITION: WIN32_ERROR = WIN32_ERROR(778u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_ACCESSOR_FLAGS: WIN32_ERROR = WIN32_ERROR(773u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_ARGUMENTS: WIN32_ERROR = WIN32_ERROR(160u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_CLUSTERS: WIN32_ERROR = WIN32_ERROR(6849u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_COMMAND: WIN32_ERROR = WIN32_ERROR(22u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_COMPRESSION_BUFFER: WIN32_ERROR = WIN32_ERROR(605u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_CONFIGURATION: WIN32_ERROR = WIN32_ERROR(1610u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_CURRENT_DIRECTORY: WIN32_ERROR = WIN32_ERROR(703u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_DESCRIPTOR_FORMAT: WIN32_ERROR = WIN32_ERROR(1361u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_DEVICE: WIN32_ERROR = WIN32_ERROR(1200u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_DEVICE_PATH: WIN32_ERROR = WIN32_ERROR(330u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_DEV_TYPE: WIN32_ERROR = WIN32_ERROR(66u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_DLL_ENTRYPOINT: WIN32_ERROR = WIN32_ERROR(609u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_DRIVER: WIN32_ERROR = WIN32_ERROR(2001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_DRIVER_LEVEL: WIN32_ERROR = WIN32_ERROR(119u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_ENVIRONMENT: WIN32_ERROR = WIN32_ERROR(10u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_EXE_FORMAT: WIN32_ERROR = WIN32_ERROR(193u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_FILE_TYPE: WIN32_ERROR = WIN32_ERROR(222u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_FORMAT: WIN32_ERROR = WIN32_ERROR(11u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_FUNCTION_TABLE: WIN32_ERROR = WIN32_ERROR(559u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_IMPERSONATION_LEVEL: WIN32_ERROR = WIN32_ERROR(1346u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_INHERITANCE_ACL: WIN32_ERROR = WIN32_ERROR(1340u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_LENGTH: WIN32_ERROR = WIN32_ERROR(24u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_LOGON_SESSION_STATE: WIN32_ERROR = WIN32_ERROR(1365u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_MCFG_TABLE: WIN32_ERROR = WIN32_ERROR(791u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_NETPATH: WIN32_ERROR = WIN32_ERROR(53u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_NET_NAME: WIN32_ERROR = WIN32_ERROR(67u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_NET_RESP: WIN32_ERROR = WIN32_ERROR(58u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_PATHNAME: WIN32_ERROR = WIN32_ERROR(161u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_PIPE: WIN32_ERROR = WIN32_ERROR(230u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_PROFILE: WIN32_ERROR = WIN32_ERROR(1206u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_PROVIDER: WIN32_ERROR = WIN32_ERROR(1204u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_QUERY_SYNTAX: WIN32_ERROR = WIN32_ERROR(1615u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_RECOVERY_POLICY: WIN32_ERROR = WIN32_ERROR(6012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_REM_ADAP: WIN32_ERROR = WIN32_ERROR(60u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_SERVICE_ENTRYPOINT: WIN32_ERROR = WIN32_ERROR(610u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_STACK: WIN32_ERROR = WIN32_ERROR(543u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_THREADID_ADDR: WIN32_ERROR = WIN32_ERROR(159u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_TOKEN_TYPE: WIN32_ERROR = WIN32_ERROR(1349u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_UNIT: WIN32_ERROR = WIN32_ERROR(20u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_USERNAME: WIN32_ERROR = WIN32_ERROR(2202u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_USER_PROFILE: WIN32_ERROR = WIN32_ERROR(1253u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAD_VALIDATION_CLASS: WIN32_ERROR = WIN32_ERROR(1348u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAP_DISCONNECTED: u32 = 936u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BAP_REQUIRED: u32 = 943u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BCD_NOT_ALL_ENTRIES_IMPORTED: WIN32_ERROR = WIN32_ERROR(2151219201u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED: WIN32_ERROR = WIN32_ERROR(2151219203u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BCD_TOO_MANY_ELEMENTS: WIN32_ERROR = WIN32_ERROR(3224961026u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BEGINNING_OF_MEDIA: WIN32_ERROR = WIN32_ERROR(1102u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BEYOND_VDL: WIN32_ERROR = WIN32_ERROR(1289u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT: WIN32_ERROR = WIN32_ERROR(585u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BIZRULES_NOT_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073151997i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BLOCKED_BY_PARENTAL_CONTROLS: WIN32_ERROR = WIN32_ERROR(346u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BLOCK_SHARED: WIN32_ERROR = WIN32_ERROR(514u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BLOCK_SOURCE_WEAK_REFERENCE_INVALID: WIN32_ERROR = WIN32_ERROR(512u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BLOCK_TARGET_WEAK_REFERENCE_INVALID: WIN32_ERROR = WIN32_ERROR(513u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BLOCK_TOO_MANY_REFERENCES: WIN32_ERROR = WIN32_ERROR(347u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BLOCK_WEAK_REFERENCE_INVALID: WIN32_ERROR = WIN32_ERROR(511u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BOOT_ALREADY_ACCEPTED: WIN32_ERROR = WIN32_ERROR(1076u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BROKEN_PIPE: WIN32_ERROR = WIN32_ERROR(109u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BUFFER_ALL_ZEROS: WIN32_ERROR = WIN32_ERROR(754u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BUFFER_OVERFLOW: WIN32_ERROR = WIN32_ERROR(111u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BUSY: WIN32_ERROR = WIN32_ERROR(170u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BUSY_DRIVE: WIN32_ERROR = WIN32_ERROR(142u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BUS_RESET: WIN32_ERROR = WIN32_ERROR(1111u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_BYPASSIO_FLT_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(506u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CACHE_PAGE_LOCKED: WIN32_ERROR = WIN32_ERROR(752u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CALLBACK_INVOKE_INLINE: WIN32_ERROR = WIN32_ERROR(812u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CALLBACK_POP_STACK: WIN32_ERROR = WIN32_ERROR(768u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CALLBACK_SUPPLIED_INVALID_DATA: WIN32_ERROR = WIN32_ERROR(1273u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CALL_NOT_IMPLEMENTED: WIN32_ERROR = WIN32_ERROR(120u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANCELLED: WIN32_ERROR = WIN32_ERROR(1223u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANCEL_VIOLATION: WIN32_ERROR = WIN32_ERROR(173u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_ABORT_TRANSACTIONS: WIN32_ERROR = WIN32_ERROR(6848u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_ACCEPT_TRANSACTED_WORK: WIN32_ERROR = WIN32_ERROR(6847u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_BREAK_OPLOCK: WIN32_ERROR = WIN32_ERROR(802u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_COPY: WIN32_ERROR = WIN32_ERROR(266u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_DETECT_DRIVER_FAILURE: WIN32_ERROR = WIN32_ERROR(1080u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_DETECT_PROCESS_ABORT: WIN32_ERROR = WIN32_ERROR(1081u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6838u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_FIND_WND_CLASS: WIN32_ERROR = WIN32_ERROR(1407u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_GRANT_REQUESTED_OPLOCK: WIN32_ERROR = WIN32_ERROR(801u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_IMPERSONATE: WIN32_ERROR = WIN32_ERROR(1368u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_LOAD_REGISTRY_FILE: WIN32_ERROR = WIN32_ERROR(589u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_MAKE: WIN32_ERROR = WIN32_ERROR(82u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_OPEN_PROFILE: WIN32_ERROR = WIN32_ERROR(1205u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANNOT_SWITCH_RUNLEVEL: WIN32_ERROR = WIN32_ERROR(15400u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANTFETCHBACKWARDS: WIN32_ERROR = WIN32_ERROR(770u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANTOPEN: WIN32_ERROR = WIN32_ERROR(1011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANTREAD: WIN32_ERROR = WIN32_ERROR(1012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANTSCROLLBACKWARDS: WIN32_ERROR = WIN32_ERROR(771u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANTWRITE: WIN32_ERROR = WIN32_ERROR(1013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_ACCESS_DOMAIN_INFO: WIN32_ERROR = WIN32_ERROR(1351u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_ACCESS_FILE: WIN32_ERROR = WIN32_ERROR(1920u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY: WIN32_ERROR = WIN32_ERROR(6824u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_CLEAR_ENCRYPTION_FLAG: WIN32_ERROR = WIN32_ERROR(432u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS: WIN32_ERROR = WIN32_ERROR(6812u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_CROSS_RM_BOUNDARY: WIN32_ERROR = WIN32_ERROR(6825u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_DELETE_LAST_ITEM: WIN32_ERROR = WIN32_ERROR(4335u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_DISABLE_MANDATORY: WIN32_ERROR = WIN32_ERROR(1310u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_ENABLE_DENY_ONLY: WIN32_ERROR = WIN32_ERROR(629u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_EVICT_ACTIVE_NODE: WIN32_ERROR = WIN32_ERROR(5009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_OPEN_ANONYMOUS: WIN32_ERROR = WIN32_ERROR(1347u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT: WIN32_ERROR = WIN32_ERROR(6811u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_RECOVER_WITH_HANDLE_OPEN: WIN32_ERROR = WIN32_ERROR(6818u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_RESOLVE_FILENAME: WIN32_ERROR = WIN32_ERROR(1921u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_TERMINATE_SELF: WIN32_ERROR = WIN32_ERROR(555u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CANT_WAIT: WIN32_ERROR = WIN32_ERROR(554u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAN_NOT_COMPLETE: WIN32_ERROR = WIN32_ERROR(1003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAN_NOT_DEL_LOCAL_WINS: WIN32_ERROR = WIN32_ERROR(4001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_CHANGE_TYPE: WIN32_ERROR = WIN32_ERROR(451u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_DB_CORRUPTED: WIN32_ERROR = WIN32_ERROR(455u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_NOT_AUTHORIZED: WIN32_ERROR = WIN32_ERROR(453u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_NOT_DEVUNLOCKED: WIN32_ERROR = WIN32_ERROR(450u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_NOT_PROVISIONED: WIN32_ERROR = WIN32_ERROR(452u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_NO_POLICY: WIN32_ERROR = WIN32_ERROR(454u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_SCCD_DEV_MODE_REQUIRED: WIN32_ERROR = WIN32_ERROR(459u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_SCCD_INVALID_CATALOG: WIN32_ERROR = WIN32_ERROR(456u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_SCCD_NO_AUTH_ENTITY: WIN32_ERROR = WIN32_ERROR(457u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_SCCD_NO_CAPABILITY_MATCH: WIN32_ERROR = WIN32_ERROR(460u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CAPAUTHZ_SCCD_PARSE_ERROR: WIN32_ERROR = WIN32_ERROR(458u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CARDBUS_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(724u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CASE_DIFFERING_NAMES_IN_DIR: WIN32_ERROR = WIN32_ERROR(424u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CASE_SENSITIVE_PATH: WIN32_ERROR = WIN32_ERROR(442u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CERTIFICATE_VALIDATION_PREFERENCE_CONFLICT: WIN32_ERROR = WIN32_ERROR(817u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CHECKING_FILE_SYSTEM: WIN32_ERROR = WIN32_ERROR(712u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CHECKOUT_REQUIRED: WIN32_ERROR = WIN32_ERROR(221u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CHILD_MUST_BE_VOLATILE: WIN32_ERROR = WIN32_ERROR(1021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CHILD_NOT_COMPLETE: WIN32_ERROR = WIN32_ERROR(129u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CHILD_PROCESS_BLOCKED: WIN32_ERROR = WIN32_ERROR(367u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CHILD_WINDOW_MENU: WIN32_ERROR = WIN32_ERROR(1436u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CIMFS_IMAGE_CORRUPT: WIN32_ERROR = WIN32_ERROR(470u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CIMFS_IMAGE_VERSION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(471u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CIRCULAR_DEPENDENCY: WIN32_ERROR = WIN32_ERROR(1059u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLASSIC_COMPAT_MODE_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(15667u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLASS_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(1410u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLASS_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(1411u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLASS_HAS_WINDOWS: WIN32_ERROR = WIN32_ERROR(1412u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLEANER_CARTRIDGE_INSTALLED: WIN32_ERROR = WIN32_ERROR(4340u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLEANER_CARTRIDGE_SPENT: WIN32_ERROR = WIN32_ERROR(4333u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLEANER_SLOT_NOT_SET: WIN32_ERROR = WIN32_ERROR(4332u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLEANER_SLOT_SET: WIN32_ERROR = WIN32_ERROR(4331u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIENT_INTERFACE_ALREADY_EXISTS: u32 = 915u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIENT_SERVER_PARAMETERS_INVALID: WIN32_ERROR = WIN32_ERROR(597u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIPBOARD_NOT_OPEN: WIN32_ERROR = WIN32_ERROR(1418u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIPPING_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(2005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_DEVICE_LICENSE_MISSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406397i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406395i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_LICENSE_DEVICE_ID_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406390i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_LICENSE_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406394i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406391i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_LICENSE_INVALID_SIGNATURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406396i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_LICENSE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406398i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_LICENSE_NOT_SIGNED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406392i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406393i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(395u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_ALREADY_CONNECTED: WIN32_ERROR = WIN32_ERROR(378u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_AUTHENTICATION_FAILED: WIN32_ERROR = WIN32_ERROR(386u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_CONNECTED_PROVIDER_ONLY: WIN32_ERROR = WIN32_ERROR(382u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_DEHYDRATION_DISALLOWED: WIN32_ERROR = WIN32_ERROR(434u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_INCOMPATIBLE_HARDLINKS: WIN32_ERROR = WIN32_ERROR(396u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_INSUFFICIENT_RESOURCES: WIN32_ERROR = WIN32_ERROR(387u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_INVALID_REQUEST: WIN32_ERROR = WIN32_ERROR(380u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_IN_USE: WIN32_ERROR = WIN32_ERROR(391u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_METADATA_CORRUPT: WIN32_ERROR = WIN32_ERROR(363u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_METADATA_TOO_LARGE: WIN32_ERROR = WIN32_ERROR(364u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_NETWORK_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(388u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_NOT_IN_SYNC: WIN32_ERROR = WIN32_ERROR(377u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(379u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_NOT_UNDER_SYNC_ROOT: WIN32_ERROR = WIN32_ERROR(390u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PINNED: WIN32_ERROR = WIN32_ERROR(392u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH: WIN32_ERROR = WIN32_ERROR(366u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE: WIN32_ERROR = WIN32_ERROR(365u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PROPERTY_CORRUPT: WIN32_ERROR = WIN32_ERROR(394u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PROPERTY_LOCK_CONFLICT: WIN32_ERROR = WIN32_ERROR(397u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PROPERTY_VERSION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(375u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PROVIDER_NOT_RUNNING: WIN32_ERROR = WIN32_ERROR(362u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_PROVIDER_TERMINATED: WIN32_ERROR = WIN32_ERROR(404u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_READ_ONLY_VOLUME: WIN32_ERROR = WIN32_ERROR(381u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_REQUEST_ABORTED: WIN32_ERROR = WIN32_ERROR(393u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_REQUEST_CANCELED: WIN32_ERROR = WIN32_ERROR(398u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_REQUEST_TIMEOUT: WIN32_ERROR = WIN32_ERROR(426u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_SYNC_ROOT_METADATA_CORRUPT: WIN32_ERROR = WIN32_ERROR(358u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_TOO_MANY_PROPERTY_BLOBS: WIN32_ERROR = WIN32_ERROR(374u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_UNSUCCESSFUL: WIN32_ERROR = WIN32_ERROR(389u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_US_MESSAGE_TIMEOUT: WIN32_ERROR = WIN32_ERROR(475u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLOUD_FILE_VALIDATION_FAILED: WIN32_ERROR = WIN32_ERROR(383u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSCFG_ALREADY_COMMITTED: WIN32_ERROR = WIN32_ERROR(5901u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSCFG_ROLLBACK_FAILED: WIN32_ERROR = WIN32_ERROR(5902u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT: WIN32_ERROR = WIN32_ERROR(5903u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5032u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTERLOG_CORRUPT: WIN32_ERROR = WIN32_ERROR(5029u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE: WIN32_ERROR = WIN32_ERROR(5031u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE: WIN32_ERROR = WIN32_ERROR(5033u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE: WIN32_ERROR = WIN32_ERROR(5030u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTERSET_MANAGEMENT_CLUSTER_UNREACHABLE: WIN32_ERROR = WIN32_ERROR(5999u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_AFFINITY_CONFLICT: WIN32_ERROR = WIN32_ERROR(5971u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_BACKUP_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(5949u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_CANNOT_RETURN_PROPERTIES: WIN32_ERROR = WIN32_ERROR(5968u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME: WIN32_ERROR = WIN32_ERROR(5900u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_CANT_DESERIALIZE_DATA: WIN32_ERROR = WIN32_ERROR(5923u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_CSV_INVALID_HANDLE: WIN32_ERROR = WIN32_ERROR(5989u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_CSV_IO_PAUSE_TIMEOUT: WIN32_ERROR = WIN32_ERROR(5979u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR: WIN32_ERROR = WIN32_ERROR(5990u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_DATABASE_SEQMISMATCH: WIN32_ERROR = WIN32_ERROR(5083u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(5918u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(5919u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_DATABASE_UPDATE_CONDITION_FAILED: WIN32_ERROR = WIN32_ERROR(5986u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_DISK_NOT_CONNECTED: WIN32_ERROR = WIN32_ERROR(5963u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_EVICT_INVALID_REQUEST: WIN32_ERROR = WIN32_ERROR(5939u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP: WIN32_ERROR = WIN32_ERROR(5896u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_FAULT_DOMAIN_FAILED_S2D_VALIDATION: WIN32_ERROR = WIN32_ERROR(5996u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_FAULT_DOMAIN_INVALID_HIERARCHY: WIN32_ERROR = WIN32_ERROR(5995u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_FAULT_DOMAIN_PARENT_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5994u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_FAULT_DOMAIN_S2D_CONNECTIVITY_LOSS: WIN32_ERROR = WIN32_ERROR(5997u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_GROUP_BUSY: WIN32_ERROR = WIN32_ERROR(5944u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_GROUP_MOVING: WIN32_ERROR = WIN32_ERROR(5908u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_GROUP_QUEUED: WIN32_ERROR = WIN32_ERROR(5959u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_GROUP_SINGLETON_RESOURCE: WIN32_ERROR = WIN32_ERROR(5941u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_GUM_NOT_LOCKER: WIN32_ERROR = WIN32_ERROR(5085u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INCOMPATIBLE_VERSIONS: WIN32_ERROR = WIN32_ERROR(5075u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INSTANCE_ID_MISMATCH: WIN32_ERROR = WIN32_ERROR(5893u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION: WIN32_ERROR = WIN32_ERROR(5912u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_INFRASTRUCTURE_FILESERVER_NAME: WIN32_ERROR = WIN32_ERROR(5998u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_IPV6_NETWORK: WIN32_ERROR = WIN32_ERROR(5926u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK: WIN32_ERROR = WIN32_ERROR(5927u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_NETWORK: WIN32_ERROR = WIN32_ERROR(5054u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_NETWORK_PROVIDER: WIN32_ERROR = WIN32_ERROR(5049u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_NODE: WIN32_ERROR = WIN32_ERROR(5039u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_NODE_WEIGHT: WIN32_ERROR = WIN32_ERROR(5954u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_REQUEST: WIN32_ERROR = WIN32_ERROR(5048u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_SECURITY_DESCRIPTOR: WIN32_ERROR = WIN32_ERROR(5946u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_STRING_FORMAT: WIN32_ERROR = WIN32_ERROR(5917u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_INVALID_STRING_TERMINATION: WIN32_ERROR = WIN32_ERROR(5916u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_IPADDR_IN_USE: WIN32_ERROR = WIN32_ERROR(5057u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_JOIN_ABORTED: WIN32_ERROR = WIN32_ERROR(5074u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_JOIN_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(5041u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(5053u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_LAST_INTERNAL_NETWORK: WIN32_ERROR = WIN32_ERROR(5066u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5043u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED: WIN32_ERROR = WIN32_ERROR(5076u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_MAX_NODES_IN_CLUSTER: WIN32_ERROR = WIN32_ERROR(5934u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_MEMBERSHIP_HALT: WIN32_ERROR = WIN32_ERROR(5892u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE: WIN32_ERROR = WIN32_ERROR(5890u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME: WIN32_ERROR = WIN32_ERROR(5905u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETINTERFACE_EXISTS: WIN32_ERROR = WIN32_ERROR(5046u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETINTERFACE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5047u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE: WIN32_ERROR = WIN32_ERROR(5064u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETWORK_ALREADY_ONLINE: WIN32_ERROR = WIN32_ERROR(5063u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETWORK_EXISTS: WIN32_ERROR = WIN32_ERROR(5044u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS: WIN32_ERROR = WIN32_ERROR(5067u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETWORK_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5045u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP: WIN32_ERROR = WIN32_ERROR(5894u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NETWORK_NOT_INTERNAL: WIN32_ERROR = WIN32_ERROR(5060u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_ALREADY_DOWN: WIN32_ERROR = WIN32_ERROR(5062u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT: WIN32_ERROR = WIN32_ERROR(5088u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_ALREADY_MEMBER: WIN32_ERROR = WIN32_ERROR(5065u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_ALREADY_UP: WIN32_ERROR = WIN32_ERROR(5061u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_DOWN: WIN32_ERROR = WIN32_ERROR(5050u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_DRAIN_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(5962u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_EXISTS: WIN32_ERROR = WIN32_ERROR(5040u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_IN_GRACE_PERIOD: WIN32_ERROR = WIN32_ERROR(5978u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_ISOLATED: WIN32_ERROR = WIN32_ERROR(5984u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5042u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_NOT_MEMBER: WIN32_ERROR = WIN32_ERROR(5052u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_NOT_PAUSED: WIN32_ERROR = WIN32_ERROR(5058u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_NOT_READY: WIN32_ERROR = WIN32_ERROR(5072u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_PAUSED: WIN32_ERROR = WIN32_ERROR(5070u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_QUARANTINED: WIN32_ERROR = WIN32_ERROR(5985u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_SHUTTING_DOWN: WIN32_ERROR = WIN32_ERROR(5073u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_UNREACHABLE: WIN32_ERROR = WIN32_ERROR(5051u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NODE_UP: WIN32_ERROR = WIN32_ERROR(5056u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(5932u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NOT_SHARED_VOLUME: WIN32_ERROR = WIN32_ERROR(5945u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NO_NET_ADAPTERS: WIN32_ERROR = WIN32_ERROR(5906u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NO_QUORUM: WIN32_ERROR = WIN32_ERROR(5925u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED: WIN32_ERROR = WIN32_ERROR(5081u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NO_SECURITY_CONTEXT: WIN32_ERROR = WIN32_ERROR(5059u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_NULL_DATA: WIN32_ERROR = WIN32_ERROR(5920u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_OBJECT_ALREADY_USED: WIN32_ERROR = WIN32_ERROR(5936u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_OBJECT_IS_CLUSTER_SET_VM: WIN32_ERROR = WIN32_ERROR(6250u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_OLD_VERSION: WIN32_ERROR = WIN32_ERROR(5904u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST: WIN32_ERROR = WIN32_ERROR(5082u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_PARAMETER_MISMATCH: WIN32_ERROR = WIN32_ERROR(5897u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS: WIN32_ERROR = WIN32_ERROR(5913u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_PARTIAL_READ: WIN32_ERROR = WIN32_ERROR(5921u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_PARTIAL_SEND: WIN32_ERROR = WIN32_ERROR(5914u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_PARTIAL_WRITE: WIN32_ERROR = WIN32_ERROR(5922u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_POISONED: WIN32_ERROR = WIN32_ERROR(5907u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH: WIN32_ERROR = WIN32_ERROR(5895u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_QUORUMLOG_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5891u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION: WIN32_ERROR = WIN32_ERROR(5915u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESNAME_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5080u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCES_MUST_BE_ONLINE_ON_THE_SAME_NODE: WIN32_ERROR = WIN32_ERROR(5933u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_CONFIGURATION_ERROR: WIN32_ERROR = WIN32_ERROR(5943u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_CONTAINS_UNSUPPORTED_DIFF_AREA_FOR_SHARED_VOLUMES: WIN32_ERROR = WIN32_ERROR(5969u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_DOES_NOT_SUPPORT_UNMONITORED: WIN32_ERROR = WIN32_ERROR(5982u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_IS_IN_MAINTENANCE_MODE: WIN32_ERROR = WIN32_ERROR(5970u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_IS_REPLICATED: WIN32_ERROR = WIN32_ERROR(5983u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_IS_REPLICA_VIRTUAL_MACHINE: WIN32_ERROR = WIN32_ERROR(5972u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_LOCKED_STATUS: WIN32_ERROR = WIN32_ERROR(5960u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_NOT_MONITORED: WIN32_ERROR = WIN32_ERROR(5981u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_PROVIDER_FAILED: WIN32_ERROR = WIN32_ERROR(5942u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_TYPE_BUSY: WIN32_ERROR = WIN32_ERROR(5909u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5078u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_VETOED_CALL: WIN32_ERROR = WIN32_ERROR(5955u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_INCOMPATIBLE_NODES: WIN32_ERROR = WIN32_ERROR(5953u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_DESTINATION: WIN32_ERROR = WIN32_ERROR(5957u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_SOURCE: WIN32_ERROR = WIN32_ERROR(5958u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(5079u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_RHS_FAILED_INITIALIZATION: WIN32_ERROR = WIN32_ERROR(5931u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SHARED_VOLUMES_IN_USE: WIN32_ERROR = WIN32_ERROR(5947u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SHARED_VOLUME_FAILOVER_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(5961u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SHARED_VOLUME_NOT_REDIRECTED: WIN32_ERROR = WIN32_ERROR(5967u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SHARED_VOLUME_REDIRECTED: WIN32_ERROR = WIN32_ERROR(5966u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SHUTTING_DOWN: WIN32_ERROR = WIN32_ERROR(5022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SINGLETON_RESOURCE: WIN32_ERROR = WIN32_ERROR(5940u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SPACE_DEGRADED: WIN32_ERROR = WIN32_ERROR(5987u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED: WIN32_ERROR = WIN32_ERROR(5077u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_TOKEN_DELEGATION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(5988u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_TOO_MANY_NODES: WIN32_ERROR = WIN32_ERROR(5935u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_UPGRADE_FIX_QUORUM_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(5974u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_UPGRADE_INCOMPATIBLE_VERSIONS: WIN32_ERROR = WIN32_ERROR(5973u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_UPGRADE_INCOMPLETE: WIN32_ERROR = WIN32_ERROR(5977u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_UPGRADE_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(5976u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_UPGRADE_RESTART_REQUIRED: WIN32_ERROR = WIN32_ERROR(5975u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_USE_SHARED_VOLUMES_API: WIN32_ERROR = WIN32_ERROR(5948u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_WATCHDOG_TERMINATING: WIN32_ERROR = WIN32_ERROR(5952u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CLUSTER_WRONG_OS_VERSION: WIN32_ERROR = WIN32_ERROR(5899u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COLORSPACE_MISMATCH: WIN32_ERROR = WIN32_ERROR(2021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COMMITMENT_LIMIT: WIN32_ERROR = WIN32_ERROR(1455u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COMMITMENT_MINIMUM: WIN32_ERROR = WIN32_ERROR(635u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COMPRESSED_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(335u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COMPRESSION_DISABLED: WIN32_ERROR = WIN32_ERROR(769u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6850u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COMPRESSION_NOT_BENEFICIAL: WIN32_ERROR = WIN32_ERROR(344u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COM_TASK_STOP_PENDING: WIN32_ERROR = WIN32_ERROR(15501u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTED_OTHER_PASSWORD: WIN32_ERROR = WIN32_ERROR(2108u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT: WIN32_ERROR = WIN32_ERROR(2109u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTION_ABORTED: WIN32_ERROR = WIN32_ERROR(1236u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTION_ACTIVE: WIN32_ERROR = WIN32_ERROR(1230u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTION_COUNT_LIMIT: WIN32_ERROR = WIN32_ERROR(1238u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTION_INVALID: WIN32_ERROR = WIN32_ERROR(1229u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTION_REFUSED: WIN32_ERROR = WIN32_ERROR(1225u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONNECTION_UNAVAIL: WIN32_ERROR = WIN32_ERROR(1201u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONTAINER_ASSIGNED: WIN32_ERROR = WIN32_ERROR(1504u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONTENT_BLOCKED: WIN32_ERROR = WIN32_ERROR(1296u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONTEXT_EXPIRED: WIN32_ERROR = WIN32_ERROR(1931u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONTINUE: WIN32_ERROR = WIN32_ERROR(1246u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONTROLLING_IEPORT: WIN32_ERROR = WIN32_ERROR(4329u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONTROL_C_EXIT: WIN32_ERROR = WIN32_ERROR(572u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONTROL_ID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1421u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CONVERT_TO_LARGE: WIN32_ERROR = WIN32_ERROR(600u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORE_RESOURCE: WIN32_ERROR = WIN32_ERROR(5026u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORRUPT_LOG_CLEARED: WIN32_ERROR = WIN32_ERROR(798u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORRUPT_LOG_CORRUPTED: WIN32_ERROR = WIN32_ERROR(795u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORRUPT_LOG_DELETED_FULL: WIN32_ERROR = WIN32_ERROR(797u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORRUPT_LOG_OVERFULL: WIN32_ERROR = WIN32_ERROR(794u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORRUPT_LOG_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(796u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CORRUPT_SYSTEM_FILE: WIN32_ERROR = WIN32_ERROR(634u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COULD_NOT_INTERPRET: WIN32_ERROR = WIN32_ERROR(552u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COULD_NOT_RESIZE_LOG: WIN32_ERROR = WIN32_ERROR(6629u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_COUNTER_TIMEOUT: WIN32_ERROR = WIN32_ERROR(1121u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CPU_SET_INVALID: WIN32_ERROR = WIN32_ERROR(813u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CRASH_DUMP: WIN32_ERROR = WIN32_ERROR(753u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CRC: WIN32_ERROR = WIN32_ERROR(23u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CREATE_FAILED: WIN32_ERROR = WIN32_ERROR(1631u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CRED_REQUIRES_CONFIRMATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865127i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CRM_PROTOCOL_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(6710u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CRM_PROTOCOL_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(6712u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CROSS_PARTITION_VIOLATION: WIN32_ERROR = WIN32_ERROR(1661u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CSCSHARE_OFFLINE: WIN32_ERROR = WIN32_ERROR(1262u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CSV_VOLUME_NOT_LOCAL: WIN32_ERROR = WIN32_ERROR(5951u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE: WIN32_ERROR = WIN32_ERROR(6019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CS_ENCRYPTION_FILE_NOT_CSE: WIN32_ERROR = WIN32_ERROR(6021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE: WIN32_ERROR = WIN32_ERROR(6017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE: WIN32_ERROR = WIN32_ERROR(6020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER: WIN32_ERROR = WIN32_ERROR(6018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTLOG_INCONSISTENT_TRACKING_FILE: WIN32_ERROR = WIN32_ERROR(3225026596u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTLOG_INVALID_TRACKING_STATE: WIN32_ERROR = WIN32_ERROR(3225026595u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE: WIN32_ERROR = WIN32_ERROR(3225026593u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTLOG_TRACKING_NOT_INITIALIZED: WIN32_ERROR = WIN32_ERROR(3225026592u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTLOG_VHD_CHANGED_OFFLINE: WIN32_ERROR = WIN32_ERROR(3225026594u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_ACCOUNT_RESTRICTION: WIN32_ERROR = WIN32_ERROR(7064u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_BAD_VIDEO_MODE: WIN32_ERROR = WIN32_ERROR(7025u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY: WIN32_ERROR = WIN32_ERROR(7005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CDM_CONNECT: WIN32_ERROR = WIN32_ERROR(7066u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CDM_DISCONNECT: WIN32_ERROR = WIN32_ERROR(7067u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CLIENT_LICENSE_IN_USE: WIN32_ERROR = WIN32_ERROR(7052u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CLIENT_LICENSE_NOT_SET: WIN32_ERROR = WIN32_ERROR(7053u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CLIENT_QUERY_TIMEOUT: WIN32_ERROR = WIN32_ERROR(7040u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CLOSE_PENDING: WIN32_ERROR = WIN32_ERROR(7007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CONSOLE_CONNECT: WIN32_ERROR = WIN32_ERROR(7042u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_CONSOLE_DISCONNECT: WIN32_ERROR = WIN32_ERROR(7041u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED: WIN32_ERROR = WIN32_ERROR(7061u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_GRAPHICS_INVALID: WIN32_ERROR = WIN32_ERROR(7035u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_INVALID_MODEMNAME: WIN32_ERROR = WIN32_ERROR(7010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_INVALID_PD: WIN32_ERROR = WIN32_ERROR(7002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_INVALID_WD: WIN32_ERROR = WIN32_ERROR(7049u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_LICENSE_CLIENT_INVALID: WIN32_ERROR = WIN32_ERROR(7055u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_LICENSE_EXPIRED: WIN32_ERROR = WIN32_ERROR(7056u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_LICENSE_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(7054u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_LOGON_DISABLED: WIN32_ERROR = WIN32_ERROR(7037u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_MODEM_INF_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(7009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_MODEM_RESPONSE_BUSY: WIN32_ERROR = WIN32_ERROR(7015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_MODEM_RESPONSE_ERROR: WIN32_ERROR = WIN32_ERROR(7011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_MODEM_RESPONSE_NO_CARRIER: WIN32_ERROR = WIN32_ERROR(7013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE: WIN32_ERROR = WIN32_ERROR(7014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_MODEM_RESPONSE_TIMEOUT: WIN32_ERROR = WIN32_ERROR(7012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_MODEM_RESPONSE_VOICE: WIN32_ERROR = WIN32_ERROR(7016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_NOT_CONSOLE: WIN32_ERROR = WIN32_ERROR(7038u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_NO_FORCE_LOGOFF: WIN32_ERROR = WIN32_ERROR(7063u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_NO_OUTBUF: WIN32_ERROR = WIN32_ERROR(7008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_PD_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(7003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SECURITY_LAYER_ERROR: WIN32_ERROR = WIN32_ERROR(7068u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SERVICE_NAME_COLLISION: WIN32_ERROR = WIN32_ERROR(7006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SESSION_IN_USE: WIN32_ERROR = WIN32_ERROR(7062u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SHADOW_DENIED: WIN32_ERROR = WIN32_ERROR(7044u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SHADOW_DISABLED: WIN32_ERROR = WIN32_ERROR(7051u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE: WIN32_ERROR = WIN32_ERROR(7058u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SHADOW_INVALID: WIN32_ERROR = WIN32_ERROR(7050u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_SHADOW_NOT_RUNNING: WIN32_ERROR = WIN32_ERROR(7057u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_TD_ERROR: WIN32_ERROR = WIN32_ERROR(7017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_WD_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(7004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_WINSTATIONS_DISABLED: WIN32_ERROR = WIN32_ERROR(7060u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_WINSTATION_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(7045u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_WINSTATION_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(7023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_WINSTATION_BUSY: WIN32_ERROR = WIN32_ERROR(7024u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_WINSTATION_NAME_INVALID: WIN32_ERROR = WIN32_ERROR(7001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CTX_WINSTATION_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(7022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CURRENT_DIRECTORY: WIN32_ERROR = WIN32_ERROR(16u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CURRENT_DOMAIN_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(1399u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_CURRENT_TRANSACTION_NOT_VALID: WIN32_ERROR = WIN32_ERROR(6714u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATABASE_BACKUP_CORRUPT: WIN32_ERROR = WIN32_ERROR(5087u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATABASE_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(1065u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATABASE_FAILURE: WIN32_ERROR = WIN32_ERROR(4313u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATABASE_FULL: WIN32_ERROR = WIN32_ERROR(4314u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATATYPE_MISMATCH: WIN32_ERROR = WIN32_ERROR(1629u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATA_CHECKSUM_ERROR: WIN32_ERROR = WIN32_ERROR(323u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATA_LOST_REPAIR: WIN32_ERROR = WIN32_ERROR(6843u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DATA_NOT_ACCEPTED: WIN32_ERROR = WIN32_ERROR(592u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DAX_MAPPING_EXISTS: WIN32_ERROR = WIN32_ERROR(361u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_ATTACH_PROCESS_FAILURE_LOCKDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2135949310i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_COMMAND_EXCEPTION: WIN32_ERROR = WIN32_ERROR(697u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_CONNECT_SERVER_FAILURE_LOCKDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2135949309i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_CONTINUE: WIN32_ERROR = WIN32_ERROR(767u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_CONTROL_BREAK: WIN32_ERROR = WIN32_ERROR(696u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_CONTROL_C: WIN32_ERROR = WIN32_ERROR(693u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_CREATE_PROCESS_FAILURE_LOCKDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2135949311i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_EXCEPTION_HANDLED: WIN32_ERROR = WIN32_ERROR(766u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_EXCEPTION_NOT_HANDLED: WIN32_ERROR = WIN32_ERROR(688u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_PRINTEXCEPTION_C: WIN32_ERROR = WIN32_ERROR(694u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_REPLY_LATER: WIN32_ERROR = WIN32_ERROR(689u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_RIPEXCEPTION: WIN32_ERROR = WIN32_ERROR(695u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_START_SERVER_FAILURE_LOCKDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2135949308i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_TERMINATE_PROCESS: WIN32_ERROR = WIN32_ERROR(692u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_TERMINATE_THREAD: WIN32_ERROR = WIN32_ERROR(691u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE: WIN32_ERROR = WIN32_ERROR(690u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DC_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1425u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DDE_FAIL: WIN32_ERROR = WIN32_ERROR(1156u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DDM_NOT_RUNNING: u32 = 903u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEBUGGER_INACTIVE: WIN32_ERROR = WIN32_ERROR(1284u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEBUG_ATTACH_FAILED: WIN32_ERROR = WIN32_ERROR(590u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DECRYPTION_FAILED: WIN32_ERROR = WIN32_ERROR(6001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DELAY_LOAD_FAILED: WIN32_ERROR = WIN32_ERROR(1285u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DELETE_PENDING: WIN32_ERROR = WIN32_ERROR(303u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED: WIN32_ERROR = WIN32_ERROR(15621u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DELETING_ICM_XFORM: WIN32_ERROR = WIN32_ERROR(2019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPENDENCY_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(5003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPENDENCY_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(5069u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPENDENCY_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPENDENCY_TREE_TOO_COMPLEX: WIN32_ERROR = WIN32_ERROR(5929u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPENDENT_RESOURCE_EXISTS: WIN32_ERROR = WIN32_ERROR(5001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT: WIN32_ERROR = WIN32_ERROR(5924u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPENDENT_SERVICES_RUNNING: WIN32_ERROR = WIN32_ERROR(1051u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPLOYMENT_BLOCKED_BY_POLICY: WIN32_ERROR = WIN32_ERROR(15617u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPLOYMENT_BLOCKED_BY_PROFILE_POLICY: WIN32_ERROR = WIN32_ERROR(15651u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPLOYMENT_BLOCKED_BY_USER_LOG_OFF: WIN32_ERROR = WIN32_ERROR(15641u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPLOYMENT_BLOCKED_BY_VOLUME_POLICY_MACHINE: WIN32_ERROR = WIN32_ERROR(15650u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPLOYMENT_BLOCKED_BY_VOLUME_POLICY_PACKAGE: WIN32_ERROR = WIN32_ERROR(15649u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPLOYMENT_FAILED_CONFLICTING_MUTABLE_PACKAGE_DIRECTORY: WIN32_ERROR = WIN32_ERROR(15652u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEPLOYMENT_OPTION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(15645u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DESTINATION_ELEMENT_FULL: WIN32_ERROR = WIN32_ERROR(1161u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DESTROY_OBJECT_OF_OTHER_THREAD: WIN32_ERROR = WIN32_ERROR(1435u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_ALREADY_ATTACHED: WIN32_ERROR = WIN32_ERROR(548u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_ALREADY_REMEMBERED: WIN32_ERROR = WIN32_ERROR(1202u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_DOOR_OPEN: WIN32_ERROR = WIN32_ERROR(1166u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_ENUMERATION_ERROR: WIN32_ERROR = WIN32_ERROR(648u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_FEATURE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(316u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_HARDWARE_ERROR: WIN32_ERROR = WIN32_ERROR(483u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_HINT_NAME_BUFFER_TOO_SMALL: WIN32_ERROR = WIN32_ERROR(355u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_IN_MAINTENANCE: WIN32_ERROR = WIN32_ERROR(359u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_IN_USE: WIN32_ERROR = WIN32_ERROR(2404u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(4319u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_NOT_CONNECTED: WIN32_ERROR = WIN32_ERROR(1167u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_NOT_PARTITIONED: WIN32_ERROR = WIN32_ERROR(1107u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_NO_RESOURCES: WIN32_ERROR = WIN32_ERROR(322u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_REINITIALIZATION_NEEDED: WIN32_ERROR = WIN32_ERROR(1164u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_REMOVED: WIN32_ERROR = WIN32_ERROR(1617u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_REQUIRES_CLEANING: WIN32_ERROR = WIN32_ERROR(1165u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_RESET_REQUIRED: WIN32_ERROR = WIN32_ERROR(507u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_SUPPORT_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(171u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEVICE_UNREACHABLE: WIN32_ERROR = WIN32_ERROR(321u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEV_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(55u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DEV_SIDELOAD_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(15633u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DHCP_ADDRESS_CONFLICT: WIN32_ERROR = WIN32_ERROR(4100u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIALIN_HOURS_RESTRICTION: u32 = 940u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIALOUT_HOURS_RESTRICTION: u32 = 944u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIFFERENT_PROFILE_RESOURCE_MANAGER_EXIST: WIN32_ERROR = WIN32_ERROR(15144u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIFFERENT_SERVICE_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1079u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIFFERENT_VERSION_OF_PACKAGED_SERVICE_INSTALLED: WIN32_ERROR = WIN32_ERROR(15654u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_BINDING_API_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3199u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_IOCALLBACK_NOT_REPLACED: WIN32_ERROR = WIN32_ERROR(3190u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_LIVEDUMP_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(3191u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_VOLATILE_DRIVER_HOTPATCHED: WIN32_ERROR = WIN32_ERROR(3193u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_VOLATILE_DRIVER_IS_NOT_RUNNING: WIN32_ERROR = WIN32_ERROR(3195u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_VOLATILE_INVALID_INFO: WIN32_ERROR = WIN32_ERROR(3194u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_VOLATILE_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(3198u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_VOLATILE_PLUGIN_CHANGE_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(3197u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_VOLATILE_PLUGIN_IS_NOT_RUNNING: WIN32_ERROR = WIN32_ERROR(3196u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIF_VOLATILE_SECTION_NOT_LOCKED: WIN32_ERROR = WIN32_ERROR(3192u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIRECTORY: WIN32_ERROR = WIN32_ERROR(267u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIRECTORY_NOT_RM: WIN32_ERROR = WIN32_ERROR(6803u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIRECTORY_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(336u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIRECT_ACCESS_HANDLE: WIN32_ERROR = WIN32_ERROR(130u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIR_EFS_DISALLOWED: WIN32_ERROR = WIN32_ERROR(6010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIR_NOT_EMPTY: WIN32_ERROR = WIN32_ERROR(145u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DIR_NOT_ROOT: WIN32_ERROR = WIN32_ERROR(144u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISCARDED: WIN32_ERROR = WIN32_ERROR(157u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_CHANGE: WIN32_ERROR = WIN32_ERROR(107u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_CORRUPT: WIN32_ERROR = WIN32_ERROR(1393u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_FULL: WIN32_ERROR = WIN32_ERROR(112u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_NOT_CSV_CAPABLE: WIN32_ERROR = WIN32_ERROR(5964u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_OPERATION_FAILED: WIN32_ERROR = WIN32_ERROR(1127u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1295u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_RECALIBRATE_FAILED: WIN32_ERROR = WIN32_ERROR(1126u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_REPAIR_DISABLED: WIN32_ERROR = WIN32_ERROR(780u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_REPAIR_REDIRECTED: WIN32_ERROR = WIN32_ERROR(792u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_REPAIR_UNSUCCESSFUL: WIN32_ERROR = WIN32_ERROR(793u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_RESET_FAILED: WIN32_ERROR = WIN32_ERROR(1128u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_RESOURCES_EXHAUSTED: WIN32_ERROR = WIN32_ERROR(314u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DISK_TOO_FRAGMENTED: WIN32_ERROR = WIN32_ERROR(302u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLL_INIT_FAILED: WIN32_ERROR = WIN32_ERROR(1114u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLL_INIT_FAILED_LOGOFF: WIN32_ERROR = WIN32_ERROR(624u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLL_MIGHT_BE_INCOMPATIBLE: WIN32_ERROR = WIN32_ERROR(687u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLL_MIGHT_BE_INSECURE: WIN32_ERROR = WIN32_ERROR(686u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLL_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1157u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLP_POLICY_DENIES_OPERATION: WIN32_ERROR = WIN32_ERROR(446u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLP_POLICY_SILENTLY_FAIL: WIN32_ERROR = WIN32_ERROR(449u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DLP_POLICY_WARNS_AGAINST_OPERATION: WIN32_ERROR = WIN32_ERROR(445u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DM_OPERATION_LIMIT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1070135808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOMAIN_CONTROLLER_EXISTS: WIN32_ERROR = WIN32_ERROR(1250u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOMAIN_CONTROLLER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1908u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOMAIN_CTRLR_CONFIG_ERROR: WIN32_ERROR = WIN32_ERROR(581u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOMAIN_EXISTS: WIN32_ERROR = WIN32_ERROR(1356u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOMAIN_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1357u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOMAIN_SID_SAME_AS_LOCAL_WORKSTATION: WIN32_ERROR = WIN32_ERROR(8644u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOMAIN_TRUST_INCONSISTENT: WIN32_ERROR = WIN32_ERROR(1810u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DOWNGRADE_DETECTED: WIN32_ERROR = WIN32_ERROR(1265u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DPL_NOT_SUPPORTED_FOR_USER: WIN32_ERROR = WIN32_ERROR(423u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVERS_LEAKING_LOCKED_PAGES: WIN32_ERROR = WIN32_ERROR(729u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVER_BLOCKED: WIN32_ERROR = WIN32_ERROR(1275u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVER_CANCEL_TIMEOUT: WIN32_ERROR = WIN32_ERROR(594u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVER_DATABASE_ERROR: WIN32_ERROR = WIN32_ERROR(652u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVER_FAILED_PRIOR_UNLOAD: WIN32_ERROR = WIN32_ERROR(654u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVER_FAILED_SLEEP: WIN32_ERROR = WIN32_ERROR(633u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVER_PROCESS_TERMINATED: WIN32_ERROR = WIN32_ERROR(1291u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVE_LOCKED: WIN32_ERROR = WIN32_ERROR(108u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DRIVE_MEDIA_MISMATCH: WIN32_ERROR = WIN32_ERROR(4303u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ADD_REPLICA_INHIBITED: WIN32_ERROR = WIN32_ERROR(8302u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ADMIN_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8228u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_AFFECTS_MULTIPLE_DSAS: WIN32_ERROR = WIN32_ERROR(8249u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER: WIN32_ERROR = WIN32_ERROR(8578u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ALIASED_OBJ_MISSING: WIN32_ERROR = WIN32_ERROR(8334u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ALIAS_DEREF_PROBLEM: WIN32_ERROR = WIN32_ERROR(8244u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ALIAS_POINTS_TO_ALIAS: WIN32_ERROR = WIN32_ERROR(8336u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ALIAS_PROBLEM: WIN32_ERROR = WIN32_ERROR(8241u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS: WIN32_ERROR = WIN32_ERROR(8205u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATTRIBUTE_OWNED_BY_SAM: WIN32_ERROR = WIN32_ERROR(8346u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED: WIN32_ERROR = WIN32_ERROR(8204u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATT_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(8318u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATT_IS_NOT_ON_OBJ: WIN32_ERROR = WIN32_ERROR(8310u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATT_NOT_DEF_FOR_CLASS: WIN32_ERROR = WIN32_ERROR(8317u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATT_NOT_DEF_IN_SCHEMA: WIN32_ERROR = WIN32_ERROR(8303u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATT_SCHEMA_REQ_ID: WIN32_ERROR = WIN32_ERROR(8399u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATT_SCHEMA_REQ_SYNTAX: WIN32_ERROR = WIN32_ERROR(8416u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ATT_VAL_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(8323u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_AUDIT_FAILURE: WIN32_ERROR = WIN32_ERROR(8625u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_AUTHORIZATION_FAILED: WIN32_ERROR = WIN32_ERROR(8599u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_AUTH_METHOD_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(8231u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_AUTH_UNKNOWN: WIN32_ERROR = WIN32_ERROR(8234u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_AUX_CLS_TEST_FAIL: WIN32_ERROR = WIN32_ERROR(8389u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BACKLINK_WITHOUT_LINK: WIN32_ERROR = WIN32_ERROR(8482u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BAD_ATT_SCHEMA_SYNTAX: WIN32_ERROR = WIN32_ERROR(8400u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BAD_HIERARCHY_FILE: WIN32_ERROR = WIN32_ERROR(8425u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BAD_INSTANCE_TYPE: WIN32_ERROR = WIN32_ERROR(8313u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BAD_NAME_SYNTAX: WIN32_ERROR = WIN32_ERROR(8335u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BAD_RDN_ATT_ID_SYNTAX: WIN32_ERROR = WIN32_ERROR(8392u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED: WIN32_ERROR = WIN32_ERROR(8426u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_BUSY: WIN32_ERROR = WIN32_ERROR(8206u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD: WIN32_ERROR = WIN32_ERROR(8585u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_ADD_ATT_VALUES: WIN32_ERROR = WIN32_ERROR(8320u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_ADD_SYSTEM_ONLY: WIN32_ERROR = WIN32_ERROR(8358u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_ADD_TO_GC: WIN32_ERROR = WIN32_ERROR(8550u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_CACHE_ATT: WIN32_ERROR = WIN32_ERROR(8401u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_CACHE_CLASS: WIN32_ERROR = WIN32_ERROR(8402u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC: WIN32_ERROR = WIN32_ERROR(8553u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_CREATE_UNDER_SCHEMA: WIN32_ERROR = WIN32_ERROR(8510u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_DELETE: WIN32_ERROR = WIN32_ERROR(8398u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_DELETE_DSA_OBJ: WIN32_ERROR = WIN32_ERROR(8340u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_DEL_MASTER_CROSSREF: WIN32_ERROR = WIN32_ERROR(8375u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC: WIN32_ERROR = WIN32_ERROR(8604u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_DEREF_ALIAS: WIN32_ERROR = WIN32_ERROR(8337u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN: WIN32_ERROR = WIN32_ERROR(8603u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF: WIN32_ERROR = WIN32_ERROR(8589u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN: WIN32_ERROR = WIN32_ERROR(8537u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_FIND_DSA_OBJ: WIN32_ERROR = WIN32_ERROR(8419u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_FIND_EXPECTED_NC: WIN32_ERROR = WIN32_ERROR(8420u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_FIND_NC_IN_CACHE: WIN32_ERROR = WIN32_ERROR(8421u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MIX_MASTER_AND_REPS: WIN32_ERROR = WIN32_ERROR(8331u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOD_OBJ_CLASS: WIN32_ERROR = WIN32_ERROR(8215u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOD_PRIMARYGROUPID: WIN32_ERROR = WIN32_ERROR(8506u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOD_SYSTEM_ONLY: WIN32_ERROR = WIN32_ERROR(8369u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOVE_ACCOUNT_GROUP: WIN32_ERROR = WIN32_ERROR(8498u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOVE_APP_BASIC_GROUP: WIN32_ERROR = WIN32_ERROR(8608u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOVE_APP_QUERY_GROUP: WIN32_ERROR = WIN32_ERROR(8609u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOVE_DELETED_OBJECT: WIN32_ERROR = WIN32_ERROR(8489u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_MOVE_RESOURCE_GROUP: WIN32_ERROR = WIN32_ERROR(8499u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_ON_NON_LEAF: WIN32_ERROR = WIN32_ERROR(8213u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_ON_RDN: WIN32_ERROR = WIN32_ERROR(8214u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_REMOVE_ATT_CACHE: WIN32_ERROR = WIN32_ERROR(8403u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_REMOVE_CLASS_CACHE: WIN32_ERROR = WIN32_ERROR(8404u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_REM_MISSING_ATT: WIN32_ERROR = WIN32_ERROR(8324u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_REM_MISSING_ATT_VAL: WIN32_ERROR = WIN32_ERROR(8325u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_REPLACE_HIDDEN_REC: WIN32_ERROR = WIN32_ERROR(8424u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_RETRIEVE_ATTS: WIN32_ERROR = WIN32_ERROR(8481u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_RETRIEVE_CHILD: WIN32_ERROR = WIN32_ERROR(8422u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_RETRIEVE_DN: WIN32_ERROR = WIN32_ERROR(8405u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_RETRIEVE_INSTANCE: WIN32_ERROR = WIN32_ERROR(8407u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_RETRIEVE_SD: WIN32_ERROR = WIN32_ERROR(8526u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_START: WIN32_ERROR = WIN32_ERROR(8531u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ: WIN32_ERROR = WIN32_ERROR(8560u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS: WIN32_ERROR = WIN32_ERROR(8493u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CHILDREN_EXIST: WIN32_ERROR = WIN32_ERROR(8332u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CLASS_MUST_BE_CONCRETE: WIN32_ERROR = WIN32_ERROR(8359u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CLASS_NOT_DSA: WIN32_ERROR = WIN32_ERROR(8343u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CLIENT_LOOP: WIN32_ERROR = WIN32_ERROR(8259u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CODE_INCONSISTENCY: WIN32_ERROR = WIN32_ERROR(8408u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_COMPARE_FALSE: WIN32_ERROR = WIN32_ERROR(8229u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_COMPARE_TRUE: WIN32_ERROR = WIN32_ERROR(8230u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CONFIDENTIALITY_REQUIRED: WIN32_ERROR = WIN32_ERROR(8237u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CONFIG_PARAM_MISSING: WIN32_ERROR = WIN32_ERROR(8427u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CONSTRAINT_VIOLATION: WIN32_ERROR = WIN32_ERROR(8239u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CONSTRUCTED_ATT_MOD: WIN32_ERROR = WIN32_ERROR(8475u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CONTROL_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(8258u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_COULDNT_CONTACT_FSMO: WIN32_ERROR = WIN32_ERROR(8367u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE: WIN32_ERROR = WIN32_ERROR(8503u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE: WIN32_ERROR = WIN32_ERROR(8502u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_COULDNT_UPDATE_SPNS: WIN32_ERROR = WIN32_ERROR(8525u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_COUNTING_AB_INDICES_FAILED: WIN32_ERROR = WIN32_ERROR(8428u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD: WIN32_ERROR = WIN32_ERROR(8491u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CROSS_DOM_MOVE_ERROR: WIN32_ERROR = WIN32_ERROR(8216u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CROSS_NC_DN_RENAME: WIN32_ERROR = WIN32_ERROR(8368u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CROSS_REF_BUSY: WIN32_ERROR = WIN32_ERROR(8602u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CROSS_REF_EXISTS: WIN32_ERROR = WIN32_ERROR(8374u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE: WIN32_ERROR = WIN32_ERROR(8495u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2: WIN32_ERROR = WIN32_ERROR(8586u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DATABASE_ERROR: WIN32_ERROR = WIN32_ERROR(8409u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DECODING_ERROR: WIN32_ERROR = WIN32_ERROR(8253u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED: WIN32_ERROR = WIN32_ERROR(8536u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST: WIN32_ERROR = WIN32_ERROR(8535u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DIFFERENT_REPL_EPOCHS: WIN32_ERROR = WIN32_ERROR(8593u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER: WIN32_ERROR = WIN32_ERROR(8615u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DISALLOWED_NC_REDIRECT: WIN32_ERROR = WIN32_ERROR(8640u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DNS_LOOKUP_FAILURE: WIN32_ERROR = WIN32_ERROR(8524u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST: WIN32_ERROR = WIN32_ERROR(8634u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DOMAIN_RENAME_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(8612u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DOMAIN_VERSION_TOO_HIGH: WIN32_ERROR = WIN32_ERROR(8564u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DOMAIN_VERSION_TOO_LOW: WIN32_ERROR = WIN32_ERROR(8566u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_ABANDON_SYNC: WIN32_ERROR = WIN32_ERROR(8462u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(8453u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_BAD_DN: WIN32_ERROR = WIN32_ERROR(8439u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_BAD_INSTANCE_TYPE: WIN32_ERROR = WIN32_ERROR(8445u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_BAD_NC: WIN32_ERROR = WIN32_ERROR(8440u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_BUSY: WIN32_ERROR = WIN32_ERROR(8438u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_CONNECTION_FAILED: WIN32_ERROR = WIN32_ERROR(8444u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_CORRUPT_UTD_VECTOR: WIN32_ERROR = WIN32_ERROR(8629u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_DB_ERROR: WIN32_ERROR = WIN32_ERROR(8451u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_DN_EXISTS: WIN32_ERROR = WIN32_ERROR(8441u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT: WIN32_ERROR = WIN32_ERROR(8544u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_EXTN_CONNECTION_FAILED: WIN32_ERROR = WIN32_ERROR(8466u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_GENERIC: WIN32_ERROR = WIN32_ERROR(8436u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET: WIN32_ERROR = WIN32_ERROR(8464u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_INCONSISTENT_DIT: WIN32_ERROR = WIN32_ERROR(8443u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_INTERNAL_ERROR: WIN32_ERROR = WIN32_ERROR(8442u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_INVALID_PARAMETER: WIN32_ERROR = WIN32_ERROR(8437u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_MAIL_PROBLEM: WIN32_ERROR = WIN32_ERROR(8447u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_MISSING_KRBTGT_SECRET: WIN32_ERROR = WIN32_ERROR(8633u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_MISSING_PARENT: WIN32_ERROR = WIN32_ERROR(8460u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_NAME_COLLISION: WIN32_ERROR = WIN32_ERROR(8458u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(8454u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_NO_REPLICA: WIN32_ERROR = WIN32_ERROR(8452u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_OBJ_IS_REP_SOURCE: WIN32_ERROR = WIN32_ERROR(8450u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_OBJ_NC_MISMATCH: WIN32_ERROR = WIN32_ERROR(8545u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_OUT_OF_MEM: WIN32_ERROR = WIN32_ERROR(8446u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_OUT_SCHEDULE_WINDOW: WIN32_ERROR = WIN32_ERROR(8617u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_PREEMPTED: WIN32_ERROR = WIN32_ERROR(8461u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_RECYCLED_TARGET: WIN32_ERROR = WIN32_ERROR(8639u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_REF_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(8448u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_REF_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(8449u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_REPL_PENDING: WIN32_ERROR = WIN32_ERROR(8477u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_RPC_CANCELLED: WIN32_ERROR = WIN32_ERROR(8455u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SCHEMA_CONFLICT: WIN32_ERROR = WIN32_ERROR(8543u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SCHEMA_INFO_SHIP: WIN32_ERROR = WIN32_ERROR(8542u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SCHEMA_MISMATCH: WIN32_ERROR = WIN32_ERROR(8418u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SECRETS_DENIED: WIN32_ERROR = WIN32_ERROR(8630u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SHUTDOWN: WIN32_ERROR = WIN32_ERROR(8463u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SINK_DISABLED: WIN32_ERROR = WIN32_ERROR(8457u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SOURCE_DISABLED: WIN32_ERROR = WIN32_ERROR(8456u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA: WIN32_ERROR = WIN32_ERROR(8465u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRA_SOURCE_REINSTALLED: WIN32_ERROR = WIN32_ERROR(8459u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DRS_EXTENSIONS_CHANGED: WIN32_ERROR = WIN32_ERROR(8594u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DSA_MUST_BE_INT_MASTER: WIN32_ERROR = WIN32_ERROR(8342u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DST_DOMAIN_NOT_NATIVE: WIN32_ERROR = WIN32_ERROR(8496u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DST_NC_MISMATCH: WIN32_ERROR = WIN32_ERROR(8486u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DS_REQUIRED: WIN32_ERROR = WIN32_ERROR(8478u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUPLICATE_ID_FOUND: WIN32_ERROR = WIN32_ERROR(8605u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUP_LDAP_DISPLAY_NAME: WIN32_ERROR = WIN32_ERROR(8382u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUP_LINK_ID: WIN32_ERROR = WIN32_ERROR(8468u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUP_MAPI_ID: WIN32_ERROR = WIN32_ERROR(8380u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUP_MSDS_INTID: WIN32_ERROR = WIN32_ERROR(8597u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUP_OID: WIN32_ERROR = WIN32_ERROR(8379u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUP_RDN: WIN32_ERROR = WIN32_ERROR(8378u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_DUP_SCHEMA_ID_GUID: WIN32_ERROR = WIN32_ERROR(8381u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ENCODING_ERROR: WIN32_ERROR = WIN32_ERROR(8252u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EPOCH_MISMATCH: WIN32_ERROR = WIN32_ERROR(8483u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EXISTING_AD_CHILD_NC: WIN32_ERROR = WIN32_ERROR(8613u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EXISTS_IN_AUX_CLS: WIN32_ERROR = WIN32_ERROR(8393u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EXISTS_IN_MAY_HAVE: WIN32_ERROR = WIN32_ERROR(8386u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EXISTS_IN_MUST_HAVE: WIN32_ERROR = WIN32_ERROR(8385u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EXISTS_IN_POSS_SUP: WIN32_ERROR = WIN32_ERROR(8395u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EXISTS_IN_RDNATTID: WIN32_ERROR = WIN32_ERROR(8598u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_EXISTS_IN_SUB_CLS: WIN32_ERROR = WIN32_ERROR(8394u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_FILTER_UNKNOWN: WIN32_ERROR = WIN32_ERROR(8254u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS: WIN32_ERROR = WIN32_ERROR(8555u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST: WIN32_ERROR = WIN32_ERROR(8635u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_FOREST_VERSION_TOO_HIGH: WIN32_ERROR = WIN32_ERROR(8563u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_FOREST_VERSION_TOO_LOW: WIN32_ERROR = WIN32_ERROR(8565u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GCVERIFY_ERROR: WIN32_ERROR = WIN32_ERROR(8417u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GC_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(8217u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GC_REQUIRED: WIN32_ERROR = WIN32_ERROR(8547u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GENERIC_ERROR: WIN32_ERROR = WIN32_ERROR(8341u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER: WIN32_ERROR = WIN32_ERROR(8519u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER: WIN32_ERROR = WIN32_ERROR(8516u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER: WIN32_ERROR = WIN32_ERROR(8517u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GOVERNSID_MISSING: WIN32_ERROR = WIN32_ERROR(8410u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_GROUP_CONVERSION_ERROR: WIN32_ERROR = WIN32_ERROR(8607u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_HAVE_PRIMARY_MEMBERS: WIN32_ERROR = WIN32_ERROR(8521u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED: WIN32_ERROR = WIN32_ERROR(8429u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_HIERARCHY_TABLE_TOO_DEEP: WIN32_ERROR = WIN32_ERROR(8628u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_HIGH_ADLDS_FFL: WIN32_ERROR = WIN32_ERROR(8641u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_HIGH_DSA_VERSION: WIN32_ERROR = WIN32_ERROR(8642u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD: WIN32_ERROR = WIN32_ERROR(8507u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ILLEGAL_MOD_OPERATION: WIN32_ERROR = WIN32_ERROR(8311u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ILLEGAL_SUPERIOR: WIN32_ERROR = WIN32_ERROR(8345u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION: WIN32_ERROR = WIN32_ERROR(8492u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INAPPROPRIATE_AUTH: WIN32_ERROR = WIN32_ERROR(8233u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INAPPROPRIATE_MATCHING: WIN32_ERROR = WIN32_ERROR(8238u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INCOMPATIBLE_CONTROLS_USED: WIN32_ERROR = WIN32_ERROR(8574u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INCOMPATIBLE_VERSION: WIN32_ERROR = WIN32_ERROR(8567u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INCORRECT_ROLE_OWNER: WIN32_ERROR = WIN32_ERROR(8210u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INIT_FAILURE: WIN32_ERROR = WIN32_ERROR(8532u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INIT_FAILURE_CONSOLE: WIN32_ERROR = WIN32_ERROR(8561u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE: WIN32_ERROR = WIN32_ERROR(8512u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INSTALL_NO_SRC_SCH_VERSION: WIN32_ERROR = WIN32_ERROR(8511u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INSTALL_SCHEMA_MISMATCH: WIN32_ERROR = WIN32_ERROR(8467u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT: WIN32_ERROR = WIN32_ERROR(8606u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INSUFF_ACCESS_RIGHTS: WIN32_ERROR = WIN32_ERROR(8344u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INTERNAL_FAILURE: WIN32_ERROR = WIN32_ERROR(8430u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_ATTRIBUTE_SYNTAX: WIN32_ERROR = WIN32_ERROR(8203u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_DMD: WIN32_ERROR = WIN32_ERROR(8360u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_DN_SYNTAX: WIN32_ERROR = WIN32_ERROR(8242u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_GROUP_TYPE: WIN32_ERROR = WIN32_ERROR(8513u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_LDAP_DISPLAY_NAME: WIN32_ERROR = WIN32_ERROR(8479u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_NAME_FOR_SPN: WIN32_ERROR = WIN32_ERROR(8554u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_ROLE_OWNER: WIN32_ERROR = WIN32_ERROR(8366u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_SCRIPT: WIN32_ERROR = WIN32_ERROR(8600u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_SEARCH_FLAG: WIN32_ERROR = WIN32_ERROR(8500u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE: WIN32_ERROR = WIN32_ERROR(8626u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_INVALID_SEARCH_FLAG_TUPLE: WIN32_ERROR = WIN32_ERROR(8627u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_IS_LEAF: WIN32_ERROR = WIN32_ERROR(8243u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_KEY_NOT_UNIQUE: WIN32_ERROR = WIN32_ERROR(8527u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LDAP_SEND_QUEUE_FULL: WIN32_ERROR = WIN32_ERROR(8616u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LINK_ID_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(8577u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER: WIN32_ERROR = WIN32_ERROR(8520u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LOCAL_ERROR: WIN32_ERROR = WIN32_ERROR(8251u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY: WIN32_ERROR = WIN32_ERROR(8548u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LOOP_DETECT: WIN32_ERROR = WIN32_ERROR(8246u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LOW_ADLDS_FFL: WIN32_ERROR = WIN32_ERROR(8643u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_LOW_DSA_VERSION: WIN32_ERROR = WIN32_ERROR(8568u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4: WIN32_ERROR = WIN32_ERROR(8572u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8557u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MAPI_ID_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(8632u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MASTERDSA_REQUIRED: WIN32_ERROR = WIN32_ERROR(8314u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MAX_OBJ_SIZE_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8304u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY: WIN32_ERROR = WIN32_ERROR(8201u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MISSING_EXPECTED_ATT: WIN32_ERROR = WIN32_ERROR(8411u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MISSING_FOREST_TRUST: WIN32_ERROR = WIN32_ERROR(8649u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MISSING_FSMO_SETTINGS: WIN32_ERROR = WIN32_ERROR(8434u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER: WIN32_ERROR = WIN32_ERROR(8497u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MISSING_REQUIRED_ATT: WIN32_ERROR = WIN32_ERROR(8316u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MISSING_SUPREF: WIN32_ERROR = WIN32_ERROR(8406u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG: WIN32_ERROR = WIN32_ERROR(8581u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE: WIN32_ERROR = WIN32_ERROR(8579u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MODIFYDN_WRONG_GRANDPARENT: WIN32_ERROR = WIN32_ERROR(8582u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_MUST_BE_RUN_ON_DST_DC: WIN32_ERROR = WIN32_ERROR(8558u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_ERROR_DOMAIN_ONLY: WIN32_ERROR = WIN32_ERROR(8473u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_ERROR_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(8470u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_ERROR_NOT_UNIQUE: WIN32_ERROR = WIN32_ERROR(8471u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_ERROR_NO_MAPPING: WIN32_ERROR = WIN32_ERROR(8472u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING: WIN32_ERROR = WIN32_ERROR(8474u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_ERROR_RESOLVING: WIN32_ERROR = WIN32_ERROR(8469u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_ERROR_TRUST_REFERRAL: WIN32_ERROR = WIN32_ERROR(8583u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_NOT_UNIQUE: WIN32_ERROR = WIN32_ERROR(8571u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_REFERENCE_INVALID: WIN32_ERROR = WIN32_ERROR(8373u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_TOO_LONG: WIN32_ERROR = WIN32_ERROR(8348u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_TOO_MANY_PARTS: WIN32_ERROR = WIN32_ERROR(8347u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_TYPE_UNKNOWN: WIN32_ERROR = WIN32_ERROR(8351u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_UNPARSEABLE: WIN32_ERROR = WIN32_ERROR(8350u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAME_VALUE_TOO_LONG: WIN32_ERROR = WIN32_ERROR(8349u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAMING_MASTER_GC: WIN32_ERROR = WIN32_ERROR(8523u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NAMING_VIOLATION: WIN32_ERROR = WIN32_ERROR(8247u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NCNAME_MISSING_CR_REF: WIN32_ERROR = WIN32_ERROR(8412u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NCNAME_MUST_BE_NC: WIN32_ERROR = WIN32_ERROR(8357u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NC_MUST_HAVE_NC_PARENT: WIN32_ERROR = WIN32_ERROR(8494u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NC_STILL_HAS_DSAS: WIN32_ERROR = WIN32_ERROR(8546u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NONEXISTENT_MAY_HAVE: WIN32_ERROR = WIN32_ERROR(8387u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NONEXISTENT_MUST_HAVE: WIN32_ERROR = WIN32_ERROR(8388u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NONEXISTENT_POSS_SUP: WIN32_ERROR = WIN32_ERROR(8390u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NONSAFE_SCHEMA_CHANGE: WIN32_ERROR = WIN32_ERROR(8508u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NON_ASQ_SEARCH: WIN32_ERROR = WIN32_ERROR(8624u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NON_BASE_SEARCH: WIN32_ERROR = WIN32_ERROR(8480u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX: WIN32_ERROR = WIN32_ERROR(8377u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOT_AN_OBJECT: WIN32_ERROR = WIN32_ERROR(8352u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC: WIN32_ERROR = WIN32_ERROR(8487u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOT_CLOSEST: WIN32_ERROR = WIN32_ERROR(8588u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(8200u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOT_ON_BACKLINK: WIN32_ERROR = WIN32_ERROR(8362u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(8256u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NOT_SUPPORTED_SORT_ORDER: WIN32_ERROR = WIN32_ERROR(8570u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_ATTRIBUTE_OR_VALUE: WIN32_ERROR = WIN32_ERROR(8202u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN: WIN32_ERROR = WIN32_ERROR(8569u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_CHAINED_EVAL: WIN32_ERROR = WIN32_ERROR(8328u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_CHAINING: WIN32_ERROR = WIN32_ERROR(8327u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_CHECKPOINT_WITH_PDC: WIN32_ERROR = WIN32_ERROR(8551u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_CROSSREF_FOR_NC: WIN32_ERROR = WIN32_ERROR(8363u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_DELETED_NAME: WIN32_ERROR = WIN32_ERROR(8355u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS: WIN32_ERROR = WIN32_ERROR(8549u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_MORE_RIDS: WIN32_ERROR = WIN32_ERROR(8209u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_MSDS_INTID: WIN32_ERROR = WIN32_ERROR(8596u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN: WIN32_ERROR = WIN32_ERROR(8514u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN: WIN32_ERROR = WIN32_ERROR(8515u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_NTDSA_OBJECT: WIN32_ERROR = WIN32_ERROR(8623u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC: WIN32_ERROR = WIN32_ERROR(8580u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_PARENT_OBJECT: WIN32_ERROR = WIN32_ERROR(8329u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION: WIN32_ERROR = WIN32_ERROR(8533u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA: WIN32_ERROR = WIN32_ERROR(8306u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_REF_DOMAIN: WIN32_ERROR = WIN32_ERROR(8575u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_REQUESTED_ATTS_FOUND: WIN32_ERROR = WIN32_ERROR(8308u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_RESULTS_RETURNED: WIN32_ERROR = WIN32_ERROR(8257u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_RIDS_ALLOCATED: WIN32_ERROR = WIN32_ERROR(8208u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_SERVER_OBJECT: WIN32_ERROR = WIN32_ERROR(8622u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_SUCH_OBJECT: WIN32_ERROR = WIN32_ERROR(8240u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NO_TREE_DELETE_ABOVE_NC: WIN32_ERROR = WIN32_ERROR(8501u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NTDSCRIPT_PROCESS_ERROR: WIN32_ERROR = WIN32_ERROR(8592u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_NTDSCRIPT_SYNTAX_ERROR: WIN32_ERROR = WIN32_ERROR(8591u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJECT_BEING_REMOVED: WIN32_ERROR = WIN32_ERROR(8339u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJECT_CLASS_REQUIRED: WIN32_ERROR = WIN32_ERROR(8315u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJECT_RESULTS_TOO_LARGE: WIN32_ERROR = WIN32_ERROR(8248u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJ_CLASS_NOT_DEFINED: WIN32_ERROR = WIN32_ERROR(8371u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJ_CLASS_NOT_SUBCLASS: WIN32_ERROR = WIN32_ERROR(8372u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJ_CLASS_VIOLATION: WIN32_ERROR = WIN32_ERROR(8212u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJ_GUID_EXISTS: WIN32_ERROR = WIN32_ERROR(8361u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJ_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(8333u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJ_STRING_NAME_EXISTS: WIN32_ERROR = WIN32_ERROR(8305u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OBJ_TOO_LARGE: WIN32_ERROR = WIN32_ERROR(8312u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OFFSET_RANGE_ERROR: WIN32_ERROR = WIN32_ERROR(8262u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS: WIN32_ERROR = WIN32_ERROR(8637u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(8638u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OPERATIONS_ERROR: WIN32_ERROR = WIN32_ERROR(8224u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OUT_OF_SCOPE: WIN32_ERROR = WIN32_ERROR(8338u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_OUT_OF_VERSION_STORE: WIN32_ERROR = WIN32_ERROR(8573u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_PARAM_ERROR: WIN32_ERROR = WIN32_ERROR(8255u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_PARENT_IS_AN_ALIAS: WIN32_ERROR = WIN32_ERROR(8330u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_PDC_OPERATION_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(8490u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_PER_ATTRIBUTE_AUTHZ_FAILED_DURING_ADD: WIN32_ERROR = WIN32_ERROR(8652u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_POLICY_NOT_KNOWN: WIN32_ERROR = WIN32_ERROR(8618u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_PROTOCOL_ERROR: WIN32_ERROR = WIN32_ERROR(8225u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_RANGE_CONSTRAINT: WIN32_ERROR = WIN32_ERROR(8322u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_RDN_DOESNT_MATCH_SCHEMA: WIN32_ERROR = WIN32_ERROR(8307u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_RECALCSCHEMA_FAILED: WIN32_ERROR = WIN32_ERROR(8396u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_REFERRAL: WIN32_ERROR = WIN32_ERROR(8235u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_REFERRAL_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8260u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_REFUSING_FSMO_ROLES: WIN32_ERROR = WIN32_ERROR(8433u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_REMOTE_CROSSREF_OP_FAILED: WIN32_ERROR = WIN32_ERROR(8601u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_REPLICATOR_ONLY: WIN32_ERROR = WIN32_ERROR(8370u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR: WIN32_ERROR = WIN32_ERROR(8595u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_REPL_LIFETIME_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8614u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_RESERVED_LINK_ID: WIN32_ERROR = WIN32_ERROR(8576u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_RESERVED_MAPI_ID: WIN32_ERROR = WIN32_ERROR(8631u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_RIDMGR_DISABLED: WIN32_ERROR = WIN32_ERROR(8263u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_RIDMGR_INIT_ERROR: WIN32_ERROR = WIN32_ERROR(8211u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ROLE_NOT_VERIFIED: WIN32_ERROR = WIN32_ERROR(8610u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ROOT_CANT_BE_SUBREF: WIN32_ERROR = WIN32_ERROR(8326u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ROOT_MUST_BE_NC: WIN32_ERROR = WIN32_ERROR(8301u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_ROOT_REQUIRES_CLASS_TOP: WIN32_ERROR = WIN32_ERROR(8432u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SAM_INIT_FAILURE: WIN32_ERROR = WIN32_ERROR(8504u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SAM_INIT_FAILURE_CONSOLE: WIN32_ERROR = WIN32_ERROR(8562u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY: WIN32_ERROR = WIN32_ERROR(8530u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD: WIN32_ERROR = WIN32_ERROR(8529u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SCHEMA_ALLOC_FAILED: WIN32_ERROR = WIN32_ERROR(8415u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SCHEMA_NOT_LOADED: WIN32_ERROR = WIN32_ERROR(8414u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SCHEMA_UPDATE_DISALLOWED: WIN32_ERROR = WIN32_ERROR(8509u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SECURITY_CHECKING_ERROR: WIN32_ERROR = WIN32_ERROR(8413u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SECURITY_ILLEGAL_MODIFY: WIN32_ERROR = WIN32_ERROR(8423u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SEC_DESC_INVALID: WIN32_ERROR = WIN32_ERROR(8354u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SEC_DESC_TOO_SHORT: WIN32_ERROR = WIN32_ERROR(8353u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SEMANTIC_ATT_TEST: WIN32_ERROR = WIN32_ERROR(8383u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SENSITIVE_GROUP_VIOLATION: WIN32_ERROR = WIN32_ERROR(8505u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SERVER_DOWN: WIN32_ERROR = WIN32_ERROR(8250u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SHUTTING_DOWN: WIN32_ERROR = WIN32_ERROR(8364u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SINGLE_USER_MODE_FAILED: WIN32_ERROR = WIN32_ERROR(8590u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SINGLE_VALUE_CONSTRAINT: WIN32_ERROR = WIN32_ERROR(8321u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SIZELIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8227u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SORT_CONTROL_MISSING: WIN32_ERROR = WIN32_ERROR(8261u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SOURCE_AUDITING_NOT_ENABLED: WIN32_ERROR = WIN32_ERROR(8552u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SOURCE_DOMAIN_IN_FOREST: WIN32_ERROR = WIN32_ERROR(8534u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SPN_VALUE_NOT_UNIQUE_IN_FOREST: WIN32_ERROR = WIN32_ERROR(8647u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SRC_AND_DST_NC_IDENTICAL: WIN32_ERROR = WIN32_ERROR(8485u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH: WIN32_ERROR = WIN32_ERROR(8540u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER: WIN32_ERROR = WIN32_ERROR(8559u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SRC_GUID_MISMATCH: WIN32_ERROR = WIN32_ERROR(8488u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SRC_NAME_MISMATCH: WIN32_ERROR = WIN32_ERROR(8484u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER: WIN32_ERROR = WIN32_ERROR(8538u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SRC_SID_EXISTS_IN_FOREST: WIN32_ERROR = WIN32_ERROR(8539u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_STRING_SD_CONVERSION_FAILED: WIN32_ERROR = WIN32_ERROR(8522u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_STRONG_AUTH_REQUIRED: WIN32_ERROR = WIN32_ERROR(8232u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SUBREF_MUST_HAVE_PARENT: WIN32_ERROR = WIN32_ERROR(8356u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD: WIN32_ERROR = WIN32_ERROR(8376u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SUB_CLS_TEST_FAIL: WIN32_ERROR = WIN32_ERROR(8391u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_SYNTAX_MISMATCH: WIN32_ERROR = WIN32_ERROR(8384u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_THREAD_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8587u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_TIMELIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(8226u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_TREE_DELETE_NOT_FINISHED: WIN32_ERROR = WIN32_ERROR(8397u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNABLE_TO_SURRENDER_ROLES: WIN32_ERROR = WIN32_ERROR(8435u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(8207u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNAVAILABLE_CRIT_EXTENSION: WIN32_ERROR = WIN32_ERROR(8236u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNDELETE_SAM_VALIDATION_FAILED: WIN32_ERROR = WIN32_ERROR(8645u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNICODEPWD_NOT_IN_QUOTES: WIN32_ERROR = WIN32_ERROR(8556u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER: WIN32_ERROR = WIN32_ERROR(8518u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNKNOWN_ERROR: WIN32_ERROR = WIN32_ERROR(8431u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNKNOWN_OPERATION: WIN32_ERROR = WIN32_ERROR(8365u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UNWILLING_TO_PERFORM: WIN32_ERROR = WIN32_ERROR(8245u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_UPN_VALUE_NOT_UNIQUE_IN_FOREST: WIN32_ERROR = WIN32_ERROR(8648u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_USER_BUFFER_TO_SMALL: WIN32_ERROR = WIN32_ERROR(8309u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_VALUE_KEY_NOT_UNIQUE: WIN32_ERROR = WIN32_ERROR(8650u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_VERSION_CHECK_FAILURE: WIN32_ERROR = WIN32_ERROR(643u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL: WIN32_ERROR = WIN32_ERROR(8611u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_WRONG_LINKED_ATT_SYNTAX: WIN32_ERROR = WIN32_ERROR(8528u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DS_WRONG_OM_OBJ_CLASS: WIN32_ERROR = WIN32_ERROR(8476u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DUPLICATE_PRIVILEGES: WIN32_ERROR = WIN32_ERROR(311u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DUPLICATE_SERVICE_NAME: WIN32_ERROR = WIN32_ERROR(1078u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DUPLICATE_TAG: WIN32_ERROR = WIN32_ERROR(2014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DUP_DOMAINNAME: WIN32_ERROR = WIN32_ERROR(1221u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DUP_NAME: WIN32_ERROR = WIN32_ERROR(52u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DYNAMIC_CODE_BLOCKED: WIN32_ERROR = WIN32_ERROR(1655u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_DYNLINK_FROM_INVALID_RING: WIN32_ERROR = WIN32_ERROR(196u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EAS_DIDNT_FIT: WIN32_ERROR = WIN32_ERROR(275u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EAS_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(282u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EA_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(994u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EA_FILE_CORRUPT: WIN32_ERROR = WIN32_ERROR(276u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EA_LIST_INCONSISTENT: WIN32_ERROR = WIN32_ERROR(255u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EA_TABLE_FULL: WIN32_ERROR = WIN32_ERROR(277u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EC_CIRCULAR_FORWARDING: WIN32_ERROR = WIN32_ERROR(15082u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EC_CREDSTORE_FULL: WIN32_ERROR = WIN32_ERROR(15083u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EC_CRED_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15084u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EC_LOG_DISABLED: WIN32_ERROR = WIN32_ERROR(15081u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EC_NO_ACTIVE_CHANNEL: WIN32_ERROR = WIN32_ERROR(15085u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE: WIN32_ERROR = WIN32_ERROR(15080u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EDP_DPL_POLICY_CANT_BE_SATISFIED: WIN32_ERROR = WIN32_ERROR(357u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EDP_POLICY_DENIES_OPERATION: WIN32_ERROR = WIN32_ERROR(356u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EFS_ALG_BLOB_TOO_BIG: WIN32_ERROR = WIN32_ERROR(6013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EFS_DISABLED: WIN32_ERROR = WIN32_ERROR(6015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6831u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EFS_SERVER_NOT_TRUSTED: WIN32_ERROR = WIN32_ERROR(6011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EFS_VERSION_NOT_SUPPORT: WIN32_ERROR = WIN32_ERROR(6016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ELEVATION_REQUIRED: WIN32_ERROR = WIN32_ERROR(740u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EMPTY: WIN32_ERROR = WIN32_ERROR(4306u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCLAVE_FAILURE: WIN32_ERROR = WIN32_ERROR(349u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCLAVE_NOT_TERMINATED: WIN32_ERROR = WIN32_ERROR(814u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCLAVE_VIOLATION: WIN32_ERROR = WIN32_ERROR(815u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCRYPTED_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(489u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCRYPTED_IO_NOT_POSSIBLE: WIN32_ERROR = WIN32_ERROR(808u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCRYPTING_METADATA_DISALLOWED: WIN32_ERROR = WIN32_ERROR(431u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCRYPTION_DISABLED: WIN32_ERROR = WIN32_ERROR(430u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCRYPTION_FAILED: WIN32_ERROR = WIN32_ERROR(6000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENCRYPTION_POLICY_DENIES_OPERATION: WIN32_ERROR = WIN32_ERROR(6022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_END_OF_MEDIA: WIN32_ERROR = WIN32_ERROR(1100u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENLISTMENT_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(6717u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENLISTMENT_NOT_SUPERIOR: WIN32_ERROR = WIN32_ERROR(6820u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ENVVAR_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(203u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EOM_OVERFLOW: WIN32_ERROR = WIN32_ERROR(1129u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ERRORS_ENCOUNTERED: WIN32_ERROR = WIN32_ERROR(774u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVALUATION_EXPIRATION: WIN32_ERROR = WIN32_ERROR(622u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVENTLOG_CANT_START: WIN32_ERROR = WIN32_ERROR(1501u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVENTLOG_FILE_CHANGED: WIN32_ERROR = WIN32_ERROR(1503u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVENTLOG_FILE_CORRUPT: WIN32_ERROR = WIN32_ERROR(1500u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVENT_DONE: WIN32_ERROR = WIN32_ERROR(710u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVENT_PENDING: WIN32_ERROR = WIN32_ERROR(711u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY: WIN32_ERROR = WIN32_ERROR(15036u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_CHANNEL_CANNOT_ACTIVATE: WIN32_ERROR = WIN32_ERROR(15025u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_CHANNEL_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_CONFIGURATION_ERROR: WIN32_ERROR = WIN32_ERROR(15010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_EVENT_DEFINITION_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15032u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_ALREADYSCOPED: WIN32_ERROR = WIN32_ERROR(15014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_INVARG: WIN32_ERROR = WIN32_ERROR(15016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_INVTEST: WIN32_ERROR = WIN32_ERROR(15017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_INVTYPE: WIN32_ERROR = WIN32_ERROR(15018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_NOTELTSET: WIN32_ERROR = WIN32_ERROR(15015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_OUT_OF_RANGE: WIN32_ERROR = WIN32_ERROR(15038u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_PARSEERR: WIN32_ERROR = WIN32_ERROR(15019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_TOO_COMPLEX: WIN32_ERROR = WIN32_ERROR(15026u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_UNEXPECTEDTOKEN: WIN32_ERROR = WIN32_ERROR(15021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_FILTER_UNSUPPORTEDOP: WIN32_ERROR = WIN32_ERROR(15020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_INVALID_CHANNEL_PATH: WIN32_ERROR = WIN32_ERROR(15000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE: WIN32_ERROR = WIN32_ERROR(15023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_INVALID_EVENT_DATA: WIN32_ERROR = WIN32_ERROR(15005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL: WIN32_ERROR = WIN32_ERROR(15022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_INVALID_PUBLISHER_NAME: WIN32_ERROR = WIN32_ERROR(15004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE: WIN32_ERROR = WIN32_ERROR(15024u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_INVALID_QUERY: WIN32_ERROR = WIN32_ERROR(15001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_MALFORMED_XML_TEXT: WIN32_ERROR = WIN32_ERROR(15008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_MAX_INSERTS_REACHED: WIN32_ERROR = WIN32_ERROR(15031u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_MESSAGE_ID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15028u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15033u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_MESSAGE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15027u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_NON_VALIDATING_MSXML: WIN32_ERROR = WIN32_ERROR(15013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_PUBLISHER_DISABLED: WIN32_ERROR = WIN32_ERROR(15037u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_QUERY_RESULT_INVALID_POSITION: WIN32_ERROR = WIN32_ERROR(15012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_QUERY_RESULT_STALE: WIN32_ERROR = WIN32_ERROR(15011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL: WIN32_ERROR = WIN32_ERROR(15009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_UNRESOLVED_PARAMETER_INSERT: WIN32_ERROR = WIN32_ERROR(15030u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_UNRESOLVED_VALUE_INSERT: WIN32_ERROR = WIN32_ERROR(15029u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_VERSION_TOO_NEW: WIN32_ERROR = WIN32_ERROR(15035u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EVT_VERSION_TOO_OLD: WIN32_ERROR = WIN32_ERROR(15034u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXCEPTION_IN_RESOURCE_CALL: WIN32_ERROR = WIN32_ERROR(5930u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXCEPTION_IN_SERVICE: WIN32_ERROR = WIN32_ERROR(1064u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXCL_SEM_ALREADY_OWNED: WIN32_ERROR = WIN32_ERROR(101u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY: WIN32_ERROR = WIN32_ERROR(217u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY: WIN32_ERROR = WIN32_ERROR(218u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXE_MACHINE_TYPE_MISMATCH: WIN32_ERROR = WIN32_ERROR(216u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXE_MARKED_INVALID: WIN32_ERROR = WIN32_ERROR(192u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXPIRED_HANDLE: WIN32_ERROR = WIN32_ERROR(6854u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXTENDED_ERROR: WIN32_ERROR = WIN32_ERROR(1208u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXTERNAL_BACKING_PROVIDER_UNKNOWN: WIN32_ERROR = WIN32_ERROR(343u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXTERNAL_SYSKEY_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(399u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_EXTRANEOUS_INFORMATION: WIN32_ERROR = WIN32_ERROR(677u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAILED_DRIVER_ENTRY: WIN32_ERROR = WIN32_ERROR(647u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAILED_SERVICE_CONTROLLER_CONNECT: WIN32_ERROR = WIN32_ERROR(1063u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAIL_FAST_EXCEPTION: WIN32_ERROR = WIN32_ERROR(1653u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAIL_I24: WIN32_ERROR = WIN32_ERROR(83u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAIL_NOACTION_REBOOT: WIN32_ERROR = WIN32_ERROR(350u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAIL_REBOOT_INITIATED: WIN32_ERROR = WIN32_ERROR(3018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAIL_REBOOT_REQUIRED: WIN32_ERROR = WIN32_ERROR(3017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAIL_RESTART: WIN32_ERROR = WIN32_ERROR(352u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FAIL_SHUTDOWN: WIN32_ERROR = WIN32_ERROR(351u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FATAL_APP_EXIT: WIN32_ERROR = WIN32_ERROR(713u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILEMARK_DETECTED: WIN32_ERROR = WIN32_ERROR(1101u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILENAME_EXCED_RANGE: WIN32_ERROR = WIN32_ERROR(206u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_CHECKED_OUT: WIN32_ERROR = WIN32_ERROR(220u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_CORRUPT: WIN32_ERROR = WIN32_ERROR(1392u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_ENCRYPTED: WIN32_ERROR = WIN32_ERROR(6002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_EXISTS: WIN32_ERROR = WIN32_ERROR(80u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_HANDLE_REVOKED: WIN32_ERROR = WIN32_ERROR(806u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_IDENTITY_NOT_PERSISTENT: WIN32_ERROR = WIN32_ERROR(6823u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_INVALID: WIN32_ERROR = WIN32_ERROR(1006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_LEVEL_TRIM_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(326u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_METADATA_OPTIMIZATION_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(809u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_NOT_ENCRYPTED: WIN32_ERROR = WIN32_ERROR(6007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(2u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(425u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_OFFLINE: WIN32_ERROR = WIN32_ERROR(4350u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_PROTECTED_UNDER_DPL: WIN32_ERROR = WIN32_ERROR(406u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_READ_ONLY: WIN32_ERROR = WIN32_ERROR(6009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SHARE_RESOURCE_CONFLICT: WIN32_ERROR = WIN32_ERROR(5938u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SNAP_INVALID_PARAMETER: WIN32_ERROR = WIN32_ERROR(440u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SNAP_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(435u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SNAP_IO_NOT_COORDINATED: WIN32_ERROR = WIN32_ERROR(438u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SNAP_MODIFY_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(437u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SNAP_UNEXPECTED_ERROR: WIN32_ERROR = WIN32_ERROR(439u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SNAP_USER_SECTION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(436u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SYSTEM_LIMITATION: WIN32_ERROR = WIN32_ERROR(665u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SYSTEM_VIRTUALIZATION_BUSY: WIN32_ERROR = WIN32_ERROR(371u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SYSTEM_VIRTUALIZATION_INVALID_OPERATION: WIN32_ERROR = WIN32_ERROR(385u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SYSTEM_VIRTUALIZATION_METADATA_CORRUPT: WIN32_ERROR = WIN32_ERROR(370u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SYSTEM_VIRTUALIZATION_PROVIDER_UNKNOWN: WIN32_ERROR = WIN32_ERROR(372u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_SYSTEM_VIRTUALIZATION_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(369u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FILE_TOO_LARGE: WIN32_ERROR = WIN32_ERROR(223u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FIRMWARE_UPDATED: WIN32_ERROR = WIN32_ERROR(728u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOATED_SECTION: WIN32_ERROR = WIN32_ERROR(6846u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOAT_MULTIPLE_FAULTS: WIN32_ERROR = WIN32_ERROR(630u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOAT_MULTIPLE_TRAPS: WIN32_ERROR = WIN32_ERROR(631u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOPPY_BAD_REGISTERS: WIN32_ERROR = WIN32_ERROR(1125u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOPPY_ID_MARK_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1122u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOPPY_UNKNOWN_ERROR: WIN32_ERROR = WIN32_ERROR(1124u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOPPY_VOLUME: WIN32_ERROR = WIN32_ERROR(584u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLOPPY_WRONG_CYLINDER: WIN32_ERROR = WIN32_ERROR(1123u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_ALREADY_ENLISTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452005i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_CBDQ_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452018i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452010i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_CONTEXT_ALREADY_DEFINED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452030i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_CONTEXT_ALREADY_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452004i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_DELETING_OBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452021i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_DISALLOW_FAST_IO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452028i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_DO_NOT_ATTACH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452017i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_DO_NOT_DETACH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452016i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_DUPLICATE_ENTRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452019i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_FILTER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452013i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_FILTER_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452024i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_INSTANCE_ALTITUDE_COLLISION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452015i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_INSTANCE_NAME_COLLISION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452014i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_INSTANCE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452011i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452029i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_INVALID_CONTEXT_REGISTRATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452009i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_INVALID_NAME_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452027i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_IO_COMPLETE: ::windows_core::HRESULT = ::windows_core::HRESULT(2031617i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_MUST_BE_NONPAGED_POOL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452020i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_NAME_CACHE_MISS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452008i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_NOT_INITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452025i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_NOT_SAFE_TO_POST_OPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452026i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_NO_DEVICE_OBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_NO_HANDLER_DEFINED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452031i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_NO_WAITER_FOR_REPLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_POST_OPERATION_CLEANUP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_REGISTRATION_BUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145451997i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_VOLUME_ALREADY_MOUNTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452006i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_VOLUME_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145452012i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FLT_WCOS_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145451996i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FORMS_AUTH_REQUIRED: WIN32_ERROR = WIN32_ERROR(224u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FOUND_OUT_OF_SCOPE: WIN32_ERROR = WIN32_ERROR(601u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY: WIN32_ERROR = WIN32_ERROR(762u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FS_DRIVER_REQUIRED: WIN32_ERROR = WIN32_ERROR(588u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FS_METADATA_INCONSISTENT: WIN32_ERROR = WIN32_ERROR(510u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FT_DI_SCAN_REQUIRED: WIN32_ERROR = WIN32_ERROR(339u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FT_READ_FAILURE: WIN32_ERROR = WIN32_ERROR(415u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FT_READ_FROM_COPY_FAILURE: WIN32_ERROR = WIN32_ERROR(818u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FT_READ_RECOVERY_FROM_BACKUP: WIN32_ERROR = WIN32_ERROR(704u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FT_WRITE_FAILURE: WIN32_ERROR = WIN32_ERROR(338u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FT_WRITE_RECOVERY: WIN32_ERROR = WIN32_ERROR(705u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FULLSCREEN_MODE: WIN32_ERROR = WIN32_ERROR(1007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FULL_BACKUP: WIN32_ERROR = WIN32_ERROR(4004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FUNCTION_FAILED: WIN32_ERROR = WIN32_ERROR(1627u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_FUNCTION_NOT_CALLED: WIN32_ERROR = WIN32_ERROR(1626u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GDI_HANDLE_LEAK: WIN32_ERROR = WIN32_ERROR(373u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GENERIC_COMMAND_FAILED: WIN32_ERROR = WIN32_ERROR(14109u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GENERIC_NOT_MAPPED: WIN32_ERROR = WIN32_ERROR(1360u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GEN_FAILURE: WIN32_ERROR = WIN32_ERROR(31u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GLOBAL_ONLY_HOOK: WIN32_ERROR = WIN32_ERROR(1429u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GPIO_CLIENT_INFORMATION_INVALID: WIN32_ERROR = WIN32_ERROR(15322u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE: WIN32_ERROR = WIN32_ERROR(15326u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED: WIN32_ERROR = WIN32_ERROR(15327u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GPIO_INVALID_REGISTRATION_PACKET: WIN32_ERROR = WIN32_ERROR(15324u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GPIO_OPERATION_DENIED: WIN32_ERROR = WIN32_ERROR(15325u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GPIO_VERSION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(15323u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRACEFUL_DISCONNECT: WIN32_ERROR = WIN32_ERROR(1226u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242181i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242189i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242456i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242455i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ADAPTER_WAS_RESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243261i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ALLOCATION_BUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243006i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ALLOCATION_CLOSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242990i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242986i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ALLOCATION_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243002i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242406i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CANNOTCOLORCONVERT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243256i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242429i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CANT_LOCK_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242991i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242190i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242187i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242188i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242239i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_CLIENTVIDPN_NOT_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242404i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_COPP_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241983i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DATASET_IS_EMPTY: ::windows_core::HRESULT = ::windows_core::HRESULT(2499403i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DDCCI_CURRENT_CURRENT_VALUE_GREATER_THAN_MAXIMUM_VALUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241768i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DDCCI_INVALID_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241851i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241845i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241847i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241846i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241850i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241852i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DEPENDABLE_CHILD_STATUS: ::windows_core::HRESULT = ::windows_core::HRESULT(1076241468i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241758i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_DRIVER_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243255i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242459i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242465i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242467i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242424i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242752i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241855i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241853i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241854i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_I2C_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241856i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242411i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242186i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INDIRECT_DISPLAY_ABANDON_SWAPCHAIN: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243246i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INDIRECT_DISPLAY_DEVICE_STOPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243245i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243263i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241753i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_ACTIVE_REGION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242485i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242988i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242989i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242992i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_CLIENT_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242405i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_COLORBASIS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242434i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242417i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243262i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_DRIVER_MODEL: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243260i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_FREQUENCY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242486i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_GAMMA_RAMP: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242425i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242410i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242453i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242454i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242409i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242468i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242469i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242408i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242463i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242462i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242427i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242418i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242428i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241844i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_PIXELFORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242435i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242433i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_POINTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241756i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242414i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_STRIDE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242436i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_TOTAL_REGION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242484i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242475i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242474i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242492i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242480i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242491i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242479i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDPN: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242493i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242471i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242488i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242487i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242449i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242496i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242419i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242437i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242191i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_LEADLINK_START_DEFERRED: ::windows_core::HRESULT = ::windows_core::HRESULT(1076241463i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_LINK_CONFIGURATION_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243241i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MAX_NUM_PATHS_REACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242407i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241848i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241849i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241762i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_INVALID_VCP_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241767i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_MCCS_VERSION_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241765i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241766i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_UNSUPPORTED_COLOR_TEMPERATURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241761i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MCA_UNSUPPORTED_MCCS_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241764i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241757i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242476i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242460i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MODE_NOT_IN_MODESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242422i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MODE_NOT_PINNED: ::windows_core::HRESULT = ::windows_core::HRESULT(2499335i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242451i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242450i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242452i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242444i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MONITOR_NOT_CONNECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242440i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MONITOR_NO_LONGER_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241843i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MPO_ALLOCATION_UNPINNED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243240i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242423i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242192i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243264i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242184i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_ACTIVE_VIDPN: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242442i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242412i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242445i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241759i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242431i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241755i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET: ::windows_core::HRESULT = ::windows_core::HRESULT(2499404i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_PREFERRED_MODE: ::windows_core::HRESULT = ::windows_core::HRESULT(2499358i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242461i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242470i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_VIDEO_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243008i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_NO_VIDPNMGR: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242443i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241760i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241960i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241954i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241962i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241973i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241951i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241981i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_INVALID_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241972i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241955i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_INVALID_SRM: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241966i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241984i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241979i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241964i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241963i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241965i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241961i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241957i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241952i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241969i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241968i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241956i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241953i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241958i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241754i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PARTIAL_DATA_POPULATED: ::windows_core::HRESULT = ::windows_core::HRESULT(1076240394i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242477i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED: ::windows_core::HRESULT = ::windows_core::HRESULT(2499409i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242426i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242457i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242478i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY: ::windows_core::HRESULT = ::windows_core::HRESULT(1076241465i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PRESENT_BUFFER_NOT_BOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243248i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PRESENT_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243257i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PRESENT_INVALID_WINDOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243249i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PRESENT_MODE_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243259i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PRESENT_OCCLUDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243258i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PRESENT_REDIRECTION_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243253i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PRESENT_UNOCCLUDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243252i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PVP_HFS_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241967i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241970i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_RESOURCES_NOT_RELATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242448i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071249944i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_SKIP_ALLOCATION_PREPARATION: ::windows_core::HRESULT = ::windows_core::HRESULT(1076240897i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242473i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242447i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242439i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242240i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_STALE_MODESET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242464i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242441i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_START_DEFERRED: ::windows_core::HRESULT = ::windows_core::HRESULT(1076241466i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_TARGET_ALREADY_IN_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242472i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242446i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242432i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_TOO_MANY_REFERENCES: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243005i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242413i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_TRY_AGAIN_LATER: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243004i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_TRY_AGAIN_NOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243003i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_UAB_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071241982i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242416i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_UNKNOWN_CHILD_STATUS: ::windows_core::HRESULT = ::windows_core::HRESULT(1076241455i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243001i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VAIL_FAILED_TO_SEND_COMPOSITION_WINDOW_DPI_MESSAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243242i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VAIL_FAILED_TO_SEND_CREATE_SUPERWETINK_MESSAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243244i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VAIL_FAILED_TO_SEND_DESTROY_SUPERWETINK_MESSAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243243i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VAIL_STATE_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243247i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242458i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242490i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242430i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242494i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242495i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_WINDOWDC_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243251i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_WINDOWLESS_PRESENT_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071243250i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071242987i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GROUPSET_CANT_PROVIDE: WIN32_ERROR = WIN32_ERROR(5993u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GROUPSET_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(5991u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GROUPSET_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5992u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GROUP_EXISTS: WIN32_ERROR = WIN32_ERROR(1318u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GROUP_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(5012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GROUP_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GROUP_NOT_ONLINE: WIN32_ERROR = WIN32_ERROR(5014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_GUID_SUBSTITUTION_MADE: WIN32_ERROR = WIN32_ERROR(680u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HANDLES_CLOSED: WIN32_ERROR = WIN32_ERROR(676u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HANDLE_DISK_FULL: WIN32_ERROR = WIN32_ERROR(39u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HANDLE_EOF: WIN32_ERROR = WIN32_ERROR(38u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HANDLE_NO_LONGER_VALID: WIN32_ERROR = WIN32_ERROR(6815u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HANDLE_REVOKED: WIN32_ERROR = WIN32_ERROR(811u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HASH_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(15301u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HASH_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(15300u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HAS_SYSTEM_CRITICAL_FILES: WIN32_ERROR = WIN32_ERROR(488u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HEURISTIC_DAMAGE_POSSIBLE: WIN32_ERROR = WIN32_ERROR(6731u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HIBERNATED: WIN32_ERROR = WIN32_ERROR(726u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HIBERNATION_FAILURE: WIN32_ERROR = WIN32_ERROR(656u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOOK_NEEDS_HMOD: WIN32_ERROR = WIN32_ERROR(1428u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOOK_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(1431u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOOK_TYPE_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(1458u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOST_DOWN: WIN32_ERROR = WIN32_ERROR(1256u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOST_NODE_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(5005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOST_NODE_NOT_GROUP_OWNER: WIN32_ERROR = WIN32_ERROR(5016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOST_NODE_NOT_RESOURCE_OWNER: WIN32_ERROR = WIN32_ERROR(5015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOST_UNREACHABLE: WIN32_ERROR = WIN32_ERROR(1232u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOTKEY_ALREADY_REGISTERED: WIN32_ERROR = WIN32_ERROR(1409u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HOTKEY_NOT_REGISTERED: WIN32_ERROR = WIN32_ERROR(1419u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HUNG_DISPLAY_DRIVER_THREAD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144993279i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(3224698886u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_ACKNOWLEDGED: WIN32_ERROR = WIN32_ERROR(3224698902u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_CPUID_FEATURE_VALIDATION: WIN32_ERROR = WIN32_ERROR(3224698940u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_CPUID_XSAVE_FEATURE_VALIDATION: WIN32_ERROR = WIN32_ERROR(3224698941u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_DEVICE_NOT_IN_DOMAIN: WIN32_ERROR = WIN32_ERROR(3224698998u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_EVENT_BUFFER_ALREADY_FREED: WIN32_ERROR = WIN32_ERROR(3224698996u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_FEATURE_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(3224698910u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INACTIVE: WIN32_ERROR = WIN32_ERROR(3224698908u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_BUFFER: WIN32_ERROR = WIN32_ERROR(3224698931u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_BUFFERS: WIN32_ERROR = WIN32_ERROR(3224698899u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_CONTIGUOUS_MEMORY: WIN32_ERROR = WIN32_ERROR(3224698997u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_CONTIGUOUS_MEMORY_MIRRORING: WIN32_ERROR = WIN32_ERROR(3224699010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_CONTIGUOUS_ROOT_MEMORY: WIN32_ERROR = WIN32_ERROR(3224699011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_CONTIGUOUS_ROOT_MEMORY_MIRRORING: WIN32_ERROR = WIN32_ERROR(3224699013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_DEVICE_DOMAINS: WIN32_ERROR = WIN32_ERROR(3224698936u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_MEMORY: WIN32_ERROR = WIN32_ERROR(3224698891u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_MEMORY_MIRRORING: WIN32_ERROR = WIN32_ERROR(3224699009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_ROOT_MEMORY: WIN32_ERROR = WIN32_ERROR(3224698995u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INSUFFICIENT_ROOT_MEMORY_MIRRORING: WIN32_ERROR = WIN32_ERROR(3224699012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_ALIGNMENT: WIN32_ERROR = WIN32_ERROR(3224698884u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_CONNECTION_ID: WIN32_ERROR = WIN32_ERROR(3224698898u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_CPU_GROUP_ID: WIN32_ERROR = WIN32_ERROR(3224698991u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_CPU_GROUP_STATE: WIN32_ERROR = WIN32_ERROR(3224698992u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_DEVICE_ID: WIN32_ERROR = WIN32_ERROR(3224698967u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_DEVICE_STATE: WIN32_ERROR = WIN32_ERROR(3224698968u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_HYPERCALL_CODE: WIN32_ERROR = WIN32_ERROR(3224698882u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_HYPERCALL_INPUT: WIN32_ERROR = WIN32_ERROR(3224698883u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_LP_INDEX: WIN32_ERROR = WIN32_ERROR(3224698945u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_PARAMETER: WIN32_ERROR = WIN32_ERROR(3224698885u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_PARTITION_ID: WIN32_ERROR = WIN32_ERROR(3224698893u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_PARTITION_STATE: WIN32_ERROR = WIN32_ERROR(3224698887u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_PORT_ID: WIN32_ERROR = WIN32_ERROR(3224698897u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_PROXIMITY_DOMAIN_INFO: WIN32_ERROR = WIN32_ERROR(3224698906u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_REGISTER_VALUE: WIN32_ERROR = WIN32_ERROR(3224698960u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_SAVE_RESTORE_STATE: WIN32_ERROR = WIN32_ERROR(3224698903u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_SYNIC_STATE: WIN32_ERROR = WIN32_ERROR(3224698904u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_VP_INDEX: WIN32_ERROR = WIN32_ERROR(3224698894u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_VP_STATE: WIN32_ERROR = WIN32_ERROR(3224698901u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_INVALID_VTL_STATE: WIN32_ERROR = WIN32_ERROR(3224698961u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_MSR_ACCESS_FAILED: WIN32_ERROR = WIN32_ERROR(3224699008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_NESTED_VM_EXIT: WIN32_ERROR = WIN32_ERROR(3224698999u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_NOT_ACKNOWLEDGED: WIN32_ERROR = WIN32_ERROR(3224698900u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_NOT_ALLOWED_WITH_NESTED_VIRT_ACTIVE: WIN32_ERROR = WIN32_ERROR(3224698994u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(3224702976u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_NO_DATA: WIN32_ERROR = WIN32_ERROR(3224698907u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_NO_RESOURCES: WIN32_ERROR = WIN32_ERROR(3224698909u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_NX_NOT_DETECTED: WIN32_ERROR = WIN32_ERROR(3224698965u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_OBJECT_IN_USE: WIN32_ERROR = WIN32_ERROR(3224698905u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_OPERATION_DENIED: WIN32_ERROR = WIN32_ERROR(3224698888u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_OPERATION_FAILED: WIN32_ERROR = WIN32_ERROR(3224698993u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_PAGE_REQUEST_INVALID: WIN32_ERROR = WIN32_ERROR(3224698976u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_PARTITION_TOO_DEEP: WIN32_ERROR = WIN32_ERROR(3224698892u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_PENDING_PAGE_REQUESTS: WIN32_ERROR = WIN32_ERROR(3473497u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_PROCESSOR_STARTUP_TIMEOUT: WIN32_ERROR = WIN32_ERROR(3224698942u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_PROPERTY_VALUE_OUT_OF_RANGE: WIN32_ERROR = WIN32_ERROR(3224698890u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_SMX_ENABLED: WIN32_ERROR = WIN32_ERROR(3224698943u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HV_UNKNOWN_PROPERTY: WIN32_ERROR = WIN32_ERROR(3224698889u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_HWNDS_HAVE_DIFF_PARENT: WIN32_ERROR = WIN32_ERROR(1441u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ICM_NOT_ENABLED: WIN32_ERROR = WIN32_ERROR(2018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IDLE_DISCONNECTED: u32 = 926u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IEPORT_FULL: WIN32_ERROR = WIN32_ERROR(4341u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ILLEGAL_CHARACTER: WIN32_ERROR = WIN32_ERROR(582u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ILLEGAL_DLL_RELOCATION: WIN32_ERROR = WIN32_ERROR(623u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ILLEGAL_ELEMENT_ADDRESS: WIN32_ERROR = WIN32_ERROR(1162u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ILLEGAL_FLOAT_CONTEXT: WIN32_ERROR = WIN32_ERROR(579u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ILL_FORMED_PASSWORD: WIN32_ERROR = WIN32_ERROR(1324u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IMAGE_AT_DIFFERENT_BASE: WIN32_ERROR = WIN32_ERROR(807u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IMAGE_MACHINE_TYPE_MISMATCH: WIN32_ERROR = WIN32_ERROR(706u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE: WIN32_ERROR = WIN32_ERROR(720u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IMAGE_NOT_AT_BASE: WIN32_ERROR = WIN32_ERROR(700u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(308u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IMPLEMENTATION_LIMIT: WIN32_ERROR = WIN32_ERROR(1292u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(6725u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE: WIN32_ERROR = WIN32_ERROR(1297u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INCOMPATIBLE_SERVICE_SID_TYPE: WIN32_ERROR = WIN32_ERROR(1290u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING: WIN32_ERROR = WIN32_ERROR(304u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INCORRECT_ACCOUNT_TYPE: WIN32_ERROR = WIN32_ERROR(8646u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INCORRECT_ADDRESS: WIN32_ERROR = WIN32_ERROR(1241u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INCORRECT_SIZE: WIN32_ERROR = WIN32_ERROR(1462u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INC_BACKUP: WIN32_ERROR = WIN32_ERROR(4003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INDEX_ABSENT: WIN32_ERROR = WIN32_ERROR(1611u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INDEX_OUT_OF_BOUNDS: WIN32_ERROR = WIN32_ERROR(474u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INDIGENOUS_TYPE: WIN32_ERROR = WIN32_ERROR(4338u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INDOUBT_TRANSACTIONS_EXIST: WIN32_ERROR = WIN32_ERROR(6827u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INFLOOP_IN_RELOC_CHAIN: WIN32_ERROR = WIN32_ERROR(202u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_ALREADY_RUNNING: WIN32_ERROR = WIN32_ERROR(1618u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_CANCEL: WIN32_ERROR = WIN32_ERROR(15608u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_DEREGISTRATION_FAILURE: WIN32_ERROR = WIN32_ERROR(15607u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_FAILED: WIN32_ERROR = WIN32_ERROR(15609u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_FAILURE: WIN32_ERROR = WIN32_ERROR(1603u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_FIREWALL_SERVICE_NOT_RUNNING: WIN32_ERROR = WIN32_ERROR(15626u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_FULLTRUST_HOSTRUNTIME_REQUIRES_MAIN_PACKAGE_FULLTRUST_CAPABILITY: WIN32_ERROR = WIN32_ERROR(15663u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_INVALID_PACKAGE: WIN32_ERROR = WIN32_ERROR(15602u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_INVALID_RELATED_SET_UPDATE: WIN32_ERROR = WIN32_ERROR(15639u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_LANGUAGE_UNSUPPORTED: WIN32_ERROR = WIN32_ERROR(1623u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_LOG_FAILURE: WIN32_ERROR = WIN32_ERROR(1622u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_NETWORK_FAILURE: WIN32_ERROR = WIN32_ERROR(15605u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_NOTUSED: WIN32_ERROR = WIN32_ERROR(1634u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_OPEN_PACKAGE_FAILED: WIN32_ERROR = WIN32_ERROR(15600u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_OPTIONAL_PACKAGE_APPLICATIONID_NOT_UNIQUE: WIN32_ERROR = WIN32_ERROR(15637u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE: WIN32_ERROR = WIN32_ERROR(15634u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE_FULLTRUST_CAPABILITY: WIN32_ERROR = WIN32_ERROR(15640u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_OUT_OF_DISK_SPACE: WIN32_ERROR = WIN32_ERROR(15604u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PACKAGE_DOWNGRADE: WIN32_ERROR = WIN32_ERROR(15622u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PACKAGE_INVALID: WIN32_ERROR = WIN32_ERROR(1620u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PACKAGE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15601u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PACKAGE_OPEN_FAILED: WIN32_ERROR = WIN32_ERROR(1619u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PACKAGE_REJECTED: WIN32_ERROR = WIN32_ERROR(1625u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PACKAGE_VERSION: WIN32_ERROR = WIN32_ERROR(1613u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PLATFORM_UNSUPPORTED: WIN32_ERROR = WIN32_ERROR(1633u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_POLICY_FAILURE: WIN32_ERROR = WIN32_ERROR(15615u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_PREREQUISITE_FAILED: WIN32_ERROR = WIN32_ERROR(15613u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_REGISTRATION_FAILURE: WIN32_ERROR = WIN32_ERROR(15606u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_REJECTED: WIN32_ERROR = WIN32_ERROR(1654u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_REMOTE_DISALLOWED: WIN32_ERROR = WIN32_ERROR(1640u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_REMOTE_PROHIBITED: WIN32_ERROR = WIN32_ERROR(1645u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_RESOLVE_DEPENDENCY_FAILED: WIN32_ERROR = WIN32_ERROR(15603u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_RESOLVE_HOSTRUNTIME_DEPENDENCY_FAILED: WIN32_ERROR = WIN32_ERROR(15665u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_SERVICE_FAILURE: WIN32_ERROR = WIN32_ERROR(1601u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_SERVICE_SAFEBOOT: WIN32_ERROR = WIN32_ERROR(1652u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_SOURCE_ABSENT: WIN32_ERROR = WIN32_ERROR(1612u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_SUSPEND: WIN32_ERROR = WIN32_ERROR(1604u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_TEMP_UNWRITABLE: WIN32_ERROR = WIN32_ERROR(1632u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_TRANSFORM_FAILURE: WIN32_ERROR = WIN32_ERROR(1624u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_TRANSFORM_REJECTED: WIN32_ERROR = WIN32_ERROR(1644u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_UI_FAILURE: WIN32_ERROR = WIN32_ERROR(1621u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_USEREXIT: WIN32_ERROR = WIN32_ERROR(1602u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_VOLUME_CORRUPT: WIN32_ERROR = WIN32_ERROR(15630u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_VOLUME_NOT_EMPTY: WIN32_ERROR = WIN32_ERROR(15628u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_VOLUME_OFFLINE: WIN32_ERROR = WIN32_ERROR(15629u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTALL_WRONG_PROCESSOR_ARCHITECTURE: WIN32_ERROR = WIN32_ERROR(15632u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSTRUCTION_MISALIGNMENT: WIN32_ERROR = WIN32_ERROR(549u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSUFFICIENT_BUFFER: WIN32_ERROR = WIN32_ERROR(122u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSUFFICIENT_LOGON_INFO: WIN32_ERROR = WIN32_ERROR(608u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSUFFICIENT_POWER: WIN32_ERROR = WIN32_ERROR(639u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE: WIN32_ERROR = WIN32_ERROR(781u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INSUFFICIENT_VIRTUAL_ADDR_RESOURCES: WIN32_ERROR = WIN32_ERROR(473u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_ALREADY_EXISTS: u32 = 904u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_CONFIGURATION: u32 = 912u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_CONNECTED: u32 = 908u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_DISABLED: u32 = 916u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_DISCONNECTED: u32 = 929u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_HAS_NO_DEVICES: u32 = 925u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_NOT_CONNECTED: u32 = 906u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERFACE_UNREACHABLE: u32 = 927u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERMIXED_KERNEL_EA_OPERATION: WIN32_ERROR = WIN32_ERROR(324u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERNAL_DB_CORRUPTION: WIN32_ERROR = WIN32_ERROR(1358u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERNAL_DB_ERROR: WIN32_ERROR = WIN32_ERROR(1383u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERNAL_ERROR: WIN32_ERROR = WIN32_ERROR(1359u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERRUPT_STILL_CONNECTED: WIN32_ERROR = WIN32_ERROR(764u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED: WIN32_ERROR = WIN32_ERROR(763u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ACCEL_HANDLE: WIN32_ERROR = WIN32_ERROR(1403u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ACCESS: WIN32_ERROR = WIN32_ERROR(12u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ACCOUNT_NAME: WIN32_ERROR = WIN32_ERROR(1315u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ACE_CONDITION: WIN32_ERROR = WIN32_ERROR(805u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ACL: WIN32_ERROR = WIN32_ERROR(1336u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ADDRESS: WIN32_ERROR = WIN32_ERROR(487u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ATTRIBUTE_LENGTH: u32 = 953u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_AT_INTERRUPT_TIME: WIN32_ERROR = WIN32_ERROR(104u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_BLOCK: WIN32_ERROR = WIN32_ERROR(9u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_BLOCK_LENGTH: WIN32_ERROR = WIN32_ERROR(1106u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_CAP: WIN32_ERROR = WIN32_ERROR(320u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_CATEGORY: WIN32_ERROR = WIN32_ERROR(117u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_CLEANER: WIN32_ERROR = WIN32_ERROR(4310u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_CLUSTER_IPV6_ADDRESS: WIN32_ERROR = WIN32_ERROR(5911u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_CMM: WIN32_ERROR = WIN32_ERROR(2010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_COLORINDEX: WIN32_ERROR = WIN32_ERROR(2022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_COLORSPACE: WIN32_ERROR = WIN32_ERROR(2017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_COMBOBOX_MESSAGE: WIN32_ERROR = WIN32_ERROR(1422u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_COMMAND_LINE: WIN32_ERROR = WIN32_ERROR(1639u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_COMPUTERNAME: WIN32_ERROR = WIN32_ERROR(1210u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_CRUNTIME_PARAMETER: WIN32_ERROR = WIN32_ERROR(1288u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_CURSOR_HANDLE: WIN32_ERROR = WIN32_ERROR(1402u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DATA: WIN32_ERROR = WIN32_ERROR(13u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DATATYPE: WIN32_ERROR = WIN32_ERROR(1804u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DEVICE_OBJECT_PARAMETER: WIN32_ERROR = WIN32_ERROR(650u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DLL: WIN32_ERROR = WIN32_ERROR(1154u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DOMAINNAME: WIN32_ERROR = WIN32_ERROR(1212u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DOMAIN_ROLE: WIN32_ERROR = WIN32_ERROR(1354u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DOMAIN_STATE: WIN32_ERROR = WIN32_ERROR(1353u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DRIVE: WIN32_ERROR = WIN32_ERROR(15u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DRIVE_OBJECT: WIN32_ERROR = WIN32_ERROR(4321u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_DWP_HANDLE: WIN32_ERROR = WIN32_ERROR(1405u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_EA_HANDLE: WIN32_ERROR = WIN32_ERROR(278u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_EA_NAME: WIN32_ERROR = WIN32_ERROR(254u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_EDIT_HEIGHT: WIN32_ERROR = WIN32_ERROR(1424u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ENVIRONMENT: WIN32_ERROR = WIN32_ERROR(1805u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_EVENTNAME: WIN32_ERROR = WIN32_ERROR(1211u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_EVENT_COUNT: WIN32_ERROR = WIN32_ERROR(151u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_EXCEPTION_HANDLER: WIN32_ERROR = WIN32_ERROR(310u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_EXE_SIGNATURE: WIN32_ERROR = WIN32_ERROR(191u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FIELD: WIN32_ERROR = WIN32_ERROR(1616u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FIELD_IN_PARAMETER_LIST: WIN32_ERROR = WIN32_ERROR(328u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FILTER_PROC: WIN32_ERROR = WIN32_ERROR(1427u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FLAGS: WIN32_ERROR = WIN32_ERROR(1004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FLAG_NUMBER: WIN32_ERROR = WIN32_ERROR(186u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FORM_NAME: WIN32_ERROR = WIN32_ERROR(1902u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FORM_SIZE: WIN32_ERROR = WIN32_ERROR(1903u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_FUNCTION: WIN32_ERROR = WIN32_ERROR(1u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_GROUPNAME: WIN32_ERROR = WIN32_ERROR(1209u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_GROUP_ATTRIBUTES: WIN32_ERROR = WIN32_ERROR(1345u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_GW_COMMAND: WIN32_ERROR = WIN32_ERROR(1443u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_HANDLE: WIN32_ERROR = WIN32_ERROR(6u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_HANDLE_STATE: WIN32_ERROR = WIN32_ERROR(1609u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_HOOK_FILTER: WIN32_ERROR = WIN32_ERROR(1426u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_HOOK_HANDLE: WIN32_ERROR = WIN32_ERROR(1404u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_HW_PROFILE: WIN32_ERROR = WIN32_ERROR(619u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ICON_HANDLE: WIN32_ERROR = WIN32_ERROR(1414u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ID_AUTHORITY: WIN32_ERROR = WIN32_ERROR(1343u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_IMAGE_HASH: WIN32_ERROR = WIN32_ERROR(577u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_IMPORT_OF_NON_DLL: WIN32_ERROR = WIN32_ERROR(1276u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_INDEX: WIN32_ERROR = WIN32_ERROR(1413u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_KERNEL_INFO_VERSION: WIN32_ERROR = WIN32_ERROR(340u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_KEYBOARD_HANDLE: WIN32_ERROR = WIN32_ERROR(1457u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LABEL: WIN32_ERROR = WIN32_ERROR(1299u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LB_MESSAGE: WIN32_ERROR = WIN32_ERROR(1432u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LDT_DESCRIPTOR: WIN32_ERROR = WIN32_ERROR(564u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LDT_OFFSET: WIN32_ERROR = WIN32_ERROR(563u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LDT_SIZE: WIN32_ERROR = WIN32_ERROR(561u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LEVEL: WIN32_ERROR = WIN32_ERROR(124u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LIBRARY: WIN32_ERROR = WIN32_ERROR(4301u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LIST_FORMAT: WIN32_ERROR = WIN32_ERROR(153u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LOCK_RANGE: WIN32_ERROR = WIN32_ERROR(307u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LOGON_HOURS: WIN32_ERROR = WIN32_ERROR(1328u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_LOGON_TYPE: WIN32_ERROR = WIN32_ERROR(1367u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MEDIA: WIN32_ERROR = WIN32_ERROR(4300u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MEDIA_POOL: WIN32_ERROR = WIN32_ERROR(4302u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MEMBER: WIN32_ERROR = WIN32_ERROR(1388u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MENU_HANDLE: WIN32_ERROR = WIN32_ERROR(1401u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MESSAGE: WIN32_ERROR = WIN32_ERROR(1002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MESSAGEDEST: WIN32_ERROR = WIN32_ERROR(1218u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MESSAGENAME: WIN32_ERROR = WIN32_ERROR(1217u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MINALLOCSIZE: WIN32_ERROR = WIN32_ERROR(195u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MODULETYPE: WIN32_ERROR = WIN32_ERROR(190u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MONITOR_HANDLE: WIN32_ERROR = WIN32_ERROR(1461u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_MSGBOX_STYLE: WIN32_ERROR = WIN32_ERROR(1438u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_NAME: WIN32_ERROR = WIN32_ERROR(123u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_NETNAME: WIN32_ERROR = WIN32_ERROR(1214u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_OPERATION: WIN32_ERROR = WIN32_ERROR(4317u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_OPERATION_ON_QUORUM: WIN32_ERROR = WIN32_ERROR(5068u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_OPLOCK_PROTOCOL: WIN32_ERROR = WIN32_ERROR(301u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_ORDINAL: WIN32_ERROR = WIN32_ERROR(182u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_OWNER: WIN32_ERROR = WIN32_ERROR(1307u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PACKAGE_SID_LENGTH: WIN32_ERROR = WIN32_ERROR(4253u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PACKET: u32 = 954u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PACKET_LENGTH_OR_ID: u32 = 952u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PARAMETER: WIN32_ERROR = WIN32_ERROR(87u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PASSWORD: WIN32_ERROR = WIN32_ERROR(86u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PASSWORDNAME: WIN32_ERROR = WIN32_ERROR(1216u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PATCH_XML: WIN32_ERROR = WIN32_ERROR(1650u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PEP_INFO_VERSION: WIN32_ERROR = WIN32_ERROR(341u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PIXEL_FORMAT: WIN32_ERROR = WIN32_ERROR(2000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PLUGPLAY_DEVICE_PATH: WIN32_ERROR = WIN32_ERROR(620u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PORT_ATTRIBUTES: WIN32_ERROR = WIN32_ERROR(545u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PRIMARY_GROUP: WIN32_ERROR = WIN32_ERROR(1308u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PRINTER_COMMAND: WIN32_ERROR = WIN32_ERROR(1803u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PRINTER_DRIVER_MANIFEST: WIN32_ERROR = WIN32_ERROR(3021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PRINTER_NAME: WIN32_ERROR = WIN32_ERROR(1801u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PRINTER_STATE: WIN32_ERROR = WIN32_ERROR(1906u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PRINT_MONITOR: WIN32_ERROR = WIN32_ERROR(3007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PRIORITY: WIN32_ERROR = WIN32_ERROR(1800u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_PROFILE: WIN32_ERROR = WIN32_ERROR(2011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_QUOTA_LOWER: WIN32_ERROR = WIN32_ERROR(547u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_RADIUS_RESPONSE: u32 = 939u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_REPARSE_DATA: WIN32_ERROR = WIN32_ERROR(4392u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_RUNLEVEL_SETTING: WIN32_ERROR = WIN32_ERROR(15401u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SCROLLBAR_RANGE: WIN32_ERROR = WIN32_ERROR(1448u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SECURITY_DESCR: WIN32_ERROR = WIN32_ERROR(1338u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SEGDPL: WIN32_ERROR = WIN32_ERROR(198u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SEGMENT_NUMBER: WIN32_ERROR = WIN32_ERROR(180u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SEPARATOR_FILE: WIN32_ERROR = WIN32_ERROR(1799u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SERVER_STATE: WIN32_ERROR = WIN32_ERROR(1352u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SERVICENAME: WIN32_ERROR = WIN32_ERROR(1213u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SERVICE_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1057u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SERVICE_CONTROL: WIN32_ERROR = WIN32_ERROR(1052u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SERVICE_LOCK: WIN32_ERROR = WIN32_ERROR(1071u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SHARENAME: WIN32_ERROR = WIN32_ERROR(1215u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SHOWWIN_COMMAND: WIN32_ERROR = WIN32_ERROR(1449u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SID: WIN32_ERROR = WIN32_ERROR(1337u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SIGNAL_NUMBER: WIN32_ERROR = WIN32_ERROR(209u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SIGNATURE: u32 = 950u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SIGNATURE_LENGTH: u32 = 949u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SPI_VALUE: WIN32_ERROR = WIN32_ERROR(1439u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_STACKSEG: WIN32_ERROR = WIN32_ERROR(189u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_STAGED_SIGNATURE: WIN32_ERROR = WIN32_ERROR(15620u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_STARTING_CODESEG: WIN32_ERROR = WIN32_ERROR(188u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_STATE: WIN32_ERROR = WIN32_ERROR(5023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_SUB_AUTHORITY: WIN32_ERROR = WIN32_ERROR(1335u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TABLE: WIN32_ERROR = WIN32_ERROR(1628u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TARGET_HANDLE: WIN32_ERROR = WIN32_ERROR(114u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TASK_INDEX: WIN32_ERROR = WIN32_ERROR(1551u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TASK_NAME: WIN32_ERROR = WIN32_ERROR(1550u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_THREAD_ID: WIN32_ERROR = WIN32_ERROR(1444u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TIME: WIN32_ERROR = WIN32_ERROR(1901u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TOKEN: WIN32_ERROR = WIN32_ERROR(315u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6700u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_TRANSFORM: WIN32_ERROR = WIN32_ERROR(2020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_UNWIND_TARGET: WIN32_ERROR = WIN32_ERROR(544u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_USER_BUFFER: WIN32_ERROR = WIN32_ERROR(1784u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_USER_PRINCIPAL_NAME: WIN32_ERROR = WIN32_ERROR(8636u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_VARIANT: WIN32_ERROR = WIN32_ERROR(604u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_VERIFY_SWITCH: WIN32_ERROR = WIN32_ERROR(118u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_WINDOW_HANDLE: WIN32_ERROR = WIN32_ERROR(1400u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_WINDOW_STYLE: WIN32_ERROR = WIN32_ERROR(2002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_INVALID_WORKSTATION: WIN32_ERROR = WIN32_ERROR(1329u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IOPL_NOT_ENABLED: WIN32_ERROR = WIN32_ERROR(197u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IO_DEVICE: WIN32_ERROR = WIN32_ERROR(1117u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IO_INCOMPLETE: WIN32_ERROR = WIN32_ERROR(996u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IO_PENDING: WIN32_ERROR = WIN32_ERROR(997u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IO_PREEMPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1996423167i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IO_PRIVILEGE_FAILED: WIN32_ERROR = WIN32_ERROR(571u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IO_REISSUE_AS_CACHED: WIN32_ERROR = WIN32_ERROR(3950u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_AUTH_FIREWALL_DROP: WIN32_ERROR = WIN32_ERROR(13917u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_BAD_SPI: WIN32_ERROR = WIN32_ERROR(13910u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_CLEAR_TEXT_DROP: WIN32_ERROR = WIN32_ERROR(13916u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_BLOCK: WIN32_ERROR = WIN32_ERROR(13925u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_INVALID_PACKET: WIN32_ERROR = WIN32_ERROR(13927u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(13930u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_MAX_ENTRIES: WIN32_ERROR = WIN32_ERROR(13929u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES: WIN32_ERROR = WIN32_ERROR(13932u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(13931u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_RECEIVED_MULTICAST: WIN32_ERROR = WIN32_ERROR(13926u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED: WIN32_ERROR = WIN32_ERROR(13928u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED: WIN32_ERROR = WIN32_ERROR(13860u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_ATTRIB_FAIL: WIN32_ERROR = WIN32_ERROR(13802u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE: WIN32_ERROR = WIN32_ERROR(13905u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY: WIN32_ERROR = WIN32_ERROR(13907u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_AUTH_FAIL: WIN32_ERROR = WIN32_ERROR(13801u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_BENIGN_REINIT: WIN32_ERROR = WIN32_ERROR(13878u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH: WIN32_ERROR = WIN32_ERROR(13887u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_CGA_AUTH_FAILED: WIN32_ERROR = WIN32_ERROR(13892u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS: WIN32_ERROR = WIN32_ERROR(13902u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED: WIN32_ERROR = WIN32_ERROR(13823u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_CRL_FAILED: WIN32_ERROR = WIN32_ERROR(13817u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_DECRYPT: WIN32_ERROR = WIN32_ERROR(13867u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_DH_FAIL: WIN32_ERROR = WIN32_ERROR(13822u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_DH_FAILURE: WIN32_ERROR = WIN32_ERROR(13864u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_DOS_COOKIE_SENT: WIN32_ERROR = WIN32_ERROR(13890u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_DROP_NO_RESPONSE: WIN32_ERROR = WIN32_ERROR(13813u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_ENCRYPT: WIN32_ERROR = WIN32_ERROR(13866u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_ERROR: WIN32_ERROR = WIN32_ERROR(13816u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_FAILQUERYSSP: WIN32_ERROR = WIN32_ERROR(13854u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_FAILSSPINIT: WIN32_ERROR = WIN32_ERROR(13853u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR: WIN32_ERROR = WIN32_ERROR(13804u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_GETSPIFAIL: WIN32_ERROR = WIN32_ERROR(13857u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE: WIN32_ERROR = WIN32_ERROR(13899u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_AUTH_ALG: WIN32_ERROR = WIN32_ERROR(13874u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD: WIN32_ERROR = WIN32_ERROR(13889u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN: WIN32_ERROR = WIN32_ERROR(13881u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_CERT_TYPE: WIN32_ERROR = WIN32_ERROR(13819u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_COOKIE: WIN32_ERROR = WIN32_ERROR(13846u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG: WIN32_ERROR = WIN32_ERROR(13873u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_FILTER: WIN32_ERROR = WIN32_ERROR(13858u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_GROUP: WIN32_ERROR = WIN32_ERROR(13865u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_HASH: WIN32_ERROR = WIN32_ERROR(13870u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_HASH_ALG: WIN32_ERROR = WIN32_ERROR(13871u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_HASH_SIZE: WIN32_ERROR = WIN32_ERROR(13872u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_HEADER: WIN32_ERROR = WIN32_ERROR(13824u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_KEY_USAGE: WIN32_ERROR = WIN32_ERROR(13818u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION: WIN32_ERROR = WIN32_ERROR(13880u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_MM_FOR_QM: WIN32_ERROR = WIN32_ERROR(13894u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_PAYLOAD: WIN32_ERROR = WIN32_ERROR(13843u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_POLICY: WIN32_ERROR = WIN32_ERROR(13861u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY: WIN32_ERROR = WIN32_ERROR(13879u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_SIG: WIN32_ERROR = WIN32_ERROR(13875u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_SIGNATURE: WIN32_ERROR = WIN32_ERROR(13826u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_INVALID_SITUATION: WIN32_ERROR = WIN32_ERROR(13863u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_KERBEROS_ERROR: WIN32_ERROR = WIN32_ERROR(13827u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL: WIN32_ERROR = WIN32_ERROR(13898u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_LOAD_FAILED: WIN32_ERROR = WIN32_ERROR(13876u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_LOAD_SOFT_SA: WIN32_ERROR = WIN32_ERROR(13844u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_MM_ACQUIRE_DROP: WIN32_ERROR = WIN32_ERROR(13809u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_MM_DELAY_DROP: WIN32_ERROR = WIN32_ERROR(13814u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_MM_EXPIRED: WIN32_ERROR = WIN32_ERROR(13885u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_MM_LIMIT: WIN32_ERROR = WIN32_ERROR(13882u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NEGOTIATION_DISABLED: WIN32_ERROR = WIN32_ERROR(13883u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NEGOTIATION_PENDING: WIN32_ERROR = WIN32_ERROR(13803u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NEG_STATUS_BEGIN: WIN32_ERROR = WIN32_ERROR(13800u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NEG_STATUS_END: WIN32_ERROR = WIN32_ERROR(13897u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END: WIN32_ERROR = WIN32_ERROR(13909u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NOTCBPRIV: WIN32_ERROR = WIN32_ERROR(13851u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NO_CERT: WIN32_ERROR = WIN32_ERROR(13806u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NO_MM_POLICY: WIN32_ERROR = WIN32_ERROR(13850u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NO_PEER_CERT: WIN32_ERROR = WIN32_ERROR(13847u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NO_POLICY: WIN32_ERROR = WIN32_ERROR(13825u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NO_PRIVATE_KEY: WIN32_ERROR = WIN32_ERROR(13820u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_NO_PUBLIC_KEY: WIN32_ERROR = WIN32_ERROR(13828u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_OUT_OF_MEMORY: WIN32_ERROR = WIN32_ERROR(13859u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PEER_CRL_FAILED: WIN32_ERROR = WIN32_ERROR(13848u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE: WIN32_ERROR = WIN32_ERROR(13904u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID: WIN32_ERROR = WIN32_ERROR(13886u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_POLICY_CHANGE: WIN32_ERROR = WIN32_ERROR(13849u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_POLICY_MATCH: WIN32_ERROR = WIN32_ERROR(13868u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR: WIN32_ERROR = WIN32_ERROR(13829u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_CERT: WIN32_ERROR = WIN32_ERROR(13835u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ: WIN32_ERROR = WIN32_ERROR(13836u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_DELETE: WIN32_ERROR = WIN32_ERROR(13841u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_HASH: WIN32_ERROR = WIN32_ERROR(13837u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_ID: WIN32_ERROR = WIN32_ERROR(13834u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_KE: WIN32_ERROR = WIN32_ERROR(13833u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NATOA: WIN32_ERROR = WIN32_ERROR(13893u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NONCE: WIN32_ERROR = WIN32_ERROR(13839u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY: WIN32_ERROR = WIN32_ERROR(13840u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_PROP: WIN32_ERROR = WIN32_ERROR(13831u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_SA: WIN32_ERROR = WIN32_ERROR(13830u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_SIG: WIN32_ERROR = WIN32_ERROR(13838u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_TRANS: WIN32_ERROR = WIN32_ERROR(13832u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR: WIN32_ERROR = WIN32_ERROR(13842u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_QM_ACQUIRE_DROP: WIN32_ERROR = WIN32_ERROR(13810u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_QM_DELAY_DROP: WIN32_ERROR = WIN32_ERROR(13815u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_QM_EXPIRED: WIN32_ERROR = WIN32_ERROR(13895u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_QM_LIMIT: WIN32_ERROR = WIN32_ERROR(13884u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_QUEUE_DROP_MM: WIN32_ERROR = WIN32_ERROR(13811u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM: WIN32_ERROR = WIN32_ERROR(13812u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_RATELIMIT_DROP: WIN32_ERROR = WIN32_ERROR(13903u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING: WIN32_ERROR = WIN32_ERROR(13900u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_RPC_DELETE: WIN32_ERROR = WIN32_ERROR(13877u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SA_DELETED: WIN32_ERROR = WIN32_ERROR(13807u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SA_REAPED: WIN32_ERROR = WIN32_ERROR(13808u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SECLOADFAIL: WIN32_ERROR = WIN32_ERROR(13852u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SHUTTING_DOWN: WIN32_ERROR = WIN32_ERROR(13891u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY: WIN32_ERROR = WIN32_ERROR(13821u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN: WIN32_ERROR = WIN32_ERROR(13845u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SRVACQFAIL: WIN32_ERROR = WIN32_ERROR(13855u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_SRVQUERYCRED: WIN32_ERROR = WIN32_ERROR(13856u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE: WIN32_ERROR = WIN32_ERROR(13908u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE: WIN32_ERROR = WIN32_ERROR(13906u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_TIMED_OUT: WIN32_ERROR = WIN32_ERROR(13805u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_TOO_MANY_FILTERS: WIN32_ERROR = WIN32_ERROR(13896u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID: WIN32_ERROR = WIN32_ERROR(13888u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_UNKNOWN_DOI: WIN32_ERROR = WIN32_ERROR(13862u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_IKE_UNSUPPORTED_ID: WIN32_ERROR = WIN32_ERROR(13869u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_INTEGRITY_CHECK_FAILED: WIN32_ERROR = WIN32_ERROR(13915u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_INVALID_PACKET: WIN32_ERROR = WIN32_ERROR(13914u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING: WIN32_ERROR = WIN32_ERROR(13901u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_AUTH_EXISTS: WIN32_ERROR = WIN32_ERROR(13010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_AUTH_IN_USE: WIN32_ERROR = WIN32_ERROR(13012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_AUTH_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_AUTH_PENDING_DELETION: WIN32_ERROR = WIN32_ERROR(13022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_FILTER_EXISTS: WIN32_ERROR = WIN32_ERROR(13006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_FILTER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_FILTER_PENDING_DELETION: WIN32_ERROR = WIN32_ERROR(13018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_POLICY_EXISTS: WIN32_ERROR = WIN32_ERROR(13003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_POLICY_IN_USE: WIN32_ERROR = WIN32_ERROR(13005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_POLICY_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_MM_POLICY_PENDING_DELETION: WIN32_ERROR = WIN32_ERROR(13021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_QM_POLICY_EXISTS: WIN32_ERROR = WIN32_ERROR(13000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_QM_POLICY_IN_USE: WIN32_ERROR = WIN32_ERROR(13002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_QM_POLICY_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_QM_POLICY_PENDING_DELETION: WIN32_ERROR = WIN32_ERROR(13023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_REPLAY_CHECK_FAILED: WIN32_ERROR = WIN32_ERROR(13913u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_SA_LIFETIME_EXPIRED: WIN32_ERROR = WIN32_ERROR(13911u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_THROTTLE_DROP: WIN32_ERROR = WIN32_ERROR(13918u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_TRANSPORT_FILTER_EXISTS: WIN32_ERROR = WIN32_ERROR(13008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION: WIN32_ERROR = WIN32_ERROR(13019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_TUNNEL_FILTER_EXISTS: WIN32_ERROR = WIN32_ERROR(13016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(13017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION: WIN32_ERROR = WIN32_ERROR(13020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IPSEC_WRONG_SA: WIN32_ERROR = WIN32_ERROR(13912u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IP_ADDRESS_CONFLICT1: WIN32_ERROR = WIN32_ERROR(611u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IP_ADDRESS_CONFLICT2: WIN32_ERROR = WIN32_ERROR(612u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IRQ_BUSY: WIN32_ERROR = WIN32_ERROR(1119u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IS_JOINED: WIN32_ERROR = WIN32_ERROR(134u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IS_JOIN_PATH: WIN32_ERROR = WIN32_ERROR(147u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IS_JOIN_TARGET: WIN32_ERROR = WIN32_ERROR(133u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IS_SUBSTED: WIN32_ERROR = WIN32_ERROR(135u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IS_SUBST_PATH: WIN32_ERROR = WIN32_ERROR(146u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_IS_SUBST_TARGET: WIN32_ERROR = WIN32_ERROR(149u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ITERATED_DATA_EXCEEDS_64k: WIN32_ERROR = WIN32_ERROR(194u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_JOB_NO_CONTAINER: WIN32_ERROR = WIN32_ERROR(1505u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_JOIN_TO_JOIN: WIN32_ERROR = WIN32_ERROR(138u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_JOIN_TO_SUBST: WIN32_ERROR = WIN32_ERROR(140u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_JOURNAL_DELETE_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(1178u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_JOURNAL_ENTRY_DELETED: WIN32_ERROR = WIN32_ERROR(1181u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_JOURNAL_HOOK_SET: WIN32_ERROR = WIN32_ERROR(1430u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_JOURNAL_NOT_ACTIVE: WIN32_ERROR = WIN32_ERROR(1179u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_KERNEL_APC: WIN32_ERROR = WIN32_ERROR(738u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_KEY_DELETED: WIN32_ERROR = WIN32_ERROR(1018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_KEY_HAS_CHILDREN: WIN32_ERROR = WIN32_ERROR(1020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_KM_DRIVER_BLOCKED: WIN32_ERROR = WIN32_ERROR(1930u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LABEL_TOO_LONG: WIN32_ERROR = WIN32_ERROR(154u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LAST_ADMIN: WIN32_ERROR = WIN32_ERROR(1322u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LB_WITHOUT_TABSTOPS: WIN32_ERROR = WIN32_ERROR(1434u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LIBRARY_FULL: WIN32_ERROR = WIN32_ERROR(4322u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LIBRARY_OFFLINE: WIN32_ERROR = WIN32_ERROR(4305u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LICENSE_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1395u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LINUX_SUBSYSTEM_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(414u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LINUX_SUBSYSTEM_UPDATE_REQUIRED: WIN32_ERROR = WIN32_ERROR(444u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LISTBOX_ID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1416u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LM_CROSS_ENCRYPTION_REQUIRED: WIN32_ERROR = WIN32_ERROR(1390u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOCAL_POLICY_MODIFICATION_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(8653u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOCAL_USER_SESSION_KEY: WIN32_ERROR = WIN32_ERROR(1303u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOCKED: WIN32_ERROR = WIN32_ERROR(212u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOCK_FAILED: WIN32_ERROR = WIN32_ERROR(167u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOCK_VIOLATION: WIN32_ERROR = WIN32_ERROR(33u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGIN_TIME_RESTRICTION: WIN32_ERROR = WIN32_ERROR(1239u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGIN_WKSTA_RESTRICTION: WIN32_ERROR = WIN32_ERROR(1240u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGON_FAILURE: WIN32_ERROR = WIN32_ERROR(1326u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGON_NOT_GRANTED: WIN32_ERROR = WIN32_ERROR(1380u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGON_SERVER_CONFLICT: WIN32_ERROR = WIN32_ERROR(568u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGON_SESSION_COLLISION: WIN32_ERROR = WIN32_ERROR(1366u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGON_SESSION_EXISTS: WIN32_ERROR = WIN32_ERROR(1363u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOGON_TYPE_NOT_GRANTED: WIN32_ERROR = WIN32_ERROR(1385u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_APPENDED_FLUSH_FAILED: WIN32_ERROR = WIN32_ERROR(6647u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_ARCHIVE_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(6633u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(6632u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_BLOCKS_EXHAUSTED: WIN32_ERROR = WIN32_ERROR(6605u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_BLOCK_INCOMPLETE: WIN32_ERROR = WIN32_ERROR(6603u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_BLOCK_INVALID: WIN32_ERROR = WIN32_ERROR(6609u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_BLOCK_VERSION: WIN32_ERROR = WIN32_ERROR(6608u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CANT_DELETE: WIN32_ERROR = WIN32_ERROR(6616u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CLIENT_ALREADY_REGISTERED: WIN32_ERROR = WIN32_ERROR(6636u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CLIENT_NOT_REGISTERED: WIN32_ERROR = WIN32_ERROR(6637u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CONTAINER_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(6617u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CONTAINER_OPEN_FAILED: WIN32_ERROR = WIN32_ERROR(6641u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CONTAINER_READ_FAILED: WIN32_ERROR = WIN32_ERROR(6639u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CONTAINER_STATE_INVALID: WIN32_ERROR = WIN32_ERROR(6642u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CONTAINER_WRITE_FAILED: WIN32_ERROR = WIN32_ERROR(6640u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_CORRUPTION_DETECTED: WIN32_ERROR = WIN32_ERROR(6817u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_DEDICATED: WIN32_ERROR = WIN32_ERROR(6631u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_EPHEMERAL: WIN32_ERROR = WIN32_ERROR(6634u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_FILE_FULL: WIN32_ERROR = WIN32_ERROR(1502u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_FULL: WIN32_ERROR = WIN32_ERROR(6628u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_FULL_HANDLER_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(6638u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_GROWTH_FAILED: WIN32_ERROR = WIN32_ERROR(6833u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_HARD_ERROR: WIN32_ERROR = WIN32_ERROR(718u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_INCONSISTENT_SECURITY: WIN32_ERROR = WIN32_ERROR(6646u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_INVALID_RANGE: WIN32_ERROR = WIN32_ERROR(6604u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_METADATA_CORRUPT: WIN32_ERROR = WIN32_ERROR(6612u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_METADATA_FLUSH_FAILED: WIN32_ERROR = WIN32_ERROR(6645u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_METADATA_INCONSISTENT: WIN32_ERROR = WIN32_ERROR(6614u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_METADATA_INVALID: WIN32_ERROR = WIN32_ERROR(6613u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_MULTIPLEXED: WIN32_ERROR = WIN32_ERROR(6630u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_NOT_ENOUGH_CONTAINERS: WIN32_ERROR = WIN32_ERROR(6635u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_NO_RESTART: WIN32_ERROR = WIN32_ERROR(6611u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_PINNED: WIN32_ERROR = WIN32_ERROR(6644u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_PINNED_ARCHIVE_TAIL: WIN32_ERROR = WIN32_ERROR(6623u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_PINNED_RESERVATION: WIN32_ERROR = WIN32_ERROR(6648u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_POLICY_ALREADY_INSTALLED: WIN32_ERROR = WIN32_ERROR(6619u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_POLICY_CONFLICT: WIN32_ERROR = WIN32_ERROR(6622u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_POLICY_INVALID: WIN32_ERROR = WIN32_ERROR(6621u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_POLICY_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(6620u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_READ_CONTEXT_INVALID: WIN32_ERROR = WIN32_ERROR(6606u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_READ_MODE_INVALID: WIN32_ERROR = WIN32_ERROR(6610u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_RECORDS_RESERVED_INVALID: WIN32_ERROR = WIN32_ERROR(6625u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_RECORD_NONEXISTENT: WIN32_ERROR = WIN32_ERROR(6624u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_RESERVATION_INVALID: WIN32_ERROR = WIN32_ERROR(6615u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_RESIZE_INVALID_SIZE: WIN32_ERROR = WIN32_ERROR(6806u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_RESTART_INVALID: WIN32_ERROR = WIN32_ERROR(6607u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_SECTOR_INVALID: WIN32_ERROR = WIN32_ERROR(6600u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_SECTOR_PARITY_INVALID: WIN32_ERROR = WIN32_ERROR(6601u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_SECTOR_REMAPPED: WIN32_ERROR = WIN32_ERROR(6602u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_SPACE_RESERVED_INVALID: WIN32_ERROR = WIN32_ERROR(6626u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_START_OF_LOG: WIN32_ERROR = WIN32_ERROR(6618u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_STATE_INVALID: WIN32_ERROR = WIN32_ERROR(6643u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOG_TAIL_INVALID: WIN32_ERROR = WIN32_ERROR(6627u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LONGJUMP: WIN32_ERROR = WIN32_ERROR(682u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOST_MODE_LOGON_RESTRICTION: WIN32_ERROR = WIN32_ERROR(1939u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOST_WRITEBEHIND_DATA: WIN32_ERROR = WIN32_ERROR(596u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR: WIN32_ERROR = WIN32_ERROR(790u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED: WIN32_ERROR = WIN32_ERROR(788u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR: WIN32_ERROR = WIN32_ERROR(789u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_LUIDS_EXHAUSTED: WIN32_ERROR = WIN32_ERROR(1334u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MACHINE_LOCKED: WIN32_ERROR = WIN32_ERROR(1271u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MACHINE_SCOPE_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(15666u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MAGAZINE_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(1163u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MALFORMED_SUBSTITUTION_STRING: WIN32_ERROR = WIN32_ERROR(14094u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MAPPED_ALIGNMENT: WIN32_ERROR = WIN32_ERROR(1132u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MARKED_TO_DISALLOW_WRITES: WIN32_ERROR = WIN32_ERROR(348u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MARSHALL_OVERFLOW: WIN32_ERROR = WIN32_ERROR(603u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MAX_CLIENT_INTERFACE_LIMIT: u32 = 935u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MAX_LAN_INTERFACE_LIMIT: u32 = 933u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MAX_SESSIONS_REACHED: WIN32_ERROR = WIN32_ERROR(353u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MAX_THRDS_REACHED: WIN32_ERROR = WIN32_ERROR(164u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MAX_WAN_INTERFACE_LIMIT: u32 = 934u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_EXCEPTION: WIN32_ERROR = WIN32_ERROR(784u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_INTERNAL_ERROR: WIN32_ERROR = WIN32_ERROR(15205u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_INVALID_CAPABILITIES_STRING: WIN32_ERROR = WIN32_ERROR(15200u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED: WIN32_ERROR = WIN32_ERROR(15206u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_INVALID_VCP_VERSION: WIN32_ERROR = WIN32_ERROR(15201u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_MCCS_VERSION_MISMATCH: WIN32_ERROR = WIN32_ERROR(15203u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION: WIN32_ERROR = WIN32_ERROR(15202u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_OCCURED: WIN32_ERROR = WIN32_ERROR(651u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE: WIN32_ERROR = WIN32_ERROR(15207u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MCA_UNSUPPORTED_MCCS_VERSION: WIN32_ERROR = WIN32_ERROR(15204u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEDIA_CHANGED: WIN32_ERROR = WIN32_ERROR(1110u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEDIA_CHECK: WIN32_ERROR = WIN32_ERROR(679u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEDIA_INCOMPATIBLE: WIN32_ERROR = WIN32_ERROR(4315u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEDIA_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(4318u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEDIA_OFFLINE: WIN32_ERROR = WIN32_ERROR(4304u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEDIA_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(4308u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEDIUM_NOT_ACCESSIBLE: WIN32_ERROR = WIN32_ERROR(4323u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEMBERS_PRIMARY_GROUP: WIN32_ERROR = WIN32_ERROR(1374u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEMBER_IN_ALIAS: WIN32_ERROR = WIN32_ERROR(1378u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEMBER_IN_GROUP: WIN32_ERROR = WIN32_ERROR(1320u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEMBER_NOT_IN_ALIAS: WIN32_ERROR = WIN32_ERROR(1377u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEMBER_NOT_IN_GROUP: WIN32_ERROR = WIN32_ERROR(1321u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MEMORY_HARDWARE: WIN32_ERROR = WIN32_ERROR(779u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MENU_ITEM_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1456u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MESSAGE_EXCEEDS_MAX_SIZE: WIN32_ERROR = WIN32_ERROR(4336u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MESSAGE_SYNC_ONLY: WIN32_ERROR = WIN32_ERROR(1159u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_METAFILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(2003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_META_EXPANSION_TOO_LONG: WIN32_ERROR = WIN32_ERROR(208u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6810u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MISSING_SYSTEMFILE: WIN32_ERROR = WIN32_ERROR(573u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MOD_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(126u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247357i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247351i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_INVALID_MANUFACTURE_DATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247350i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247354i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247356i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247353i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_NO_DESCRIPTOR: ::windows_core::HRESULT = ::windows_core::HRESULT(2494465i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247352i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(2494466i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1071247355i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MORE_DATA: WIN32_ERROR = WIN32_ERROR(234u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MORE_WRITES: WIN32_ERROR = WIN32_ERROR(1120u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MOUNT_POINT_NOT_RESOLVED: WIN32_ERROR = WIN32_ERROR(649u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MP_PROCESSOR_MISMATCH: WIN32_ERROR = WIN32_ERROR(725u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_AUTOMERGE_ENABLED: WIN32_ERROR = WIN32_ERROR(15139u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_DIRECT_REF_TO_NON_DEFAULT_RESOURCE: WIN32_ERROR = WIN32_ERROR(15146u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_DUPLICATE_ENTRY: WIN32_ERROR = WIN32_ERROR(15119u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_DUPLICATE_MAP_NAME: WIN32_ERROR = WIN32_ERROR(15118u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_FILEPATH_TOO_LONG: WIN32_ERROR = WIN32_ERROR(15121u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_GENERATION_COUNT_MISMATCH: WIN32_ERROR = WIN32_ERROR(15147u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_INDETERMINATE_QUALIFIER_VALUE: WIN32_ERROR = WIN32_ERROR(15138u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_INVALID_FILE_TYPE: WIN32_ERROR = WIN32_ERROR(15112u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_INVALID_PRICONFIG: WIN32_ERROR = WIN32_ERROR(15111u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_INVALID_PRI_FILE: WIN32_ERROR = WIN32_ERROR(15126u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_INVALID_QUALIFIER_OPERATOR: WIN32_ERROR = WIN32_ERROR(15137u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_INVALID_QUALIFIER_VALUE: WIN32_ERROR = WIN32_ERROR(15114u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_INVALID_RESOURCE_IDENTIFIER: WIN32_ERROR = WIN32_ERROR(15120u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_MAP_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15135u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_MISSING_DEFAULT_LANGUAGE: WIN32_ERROR = WIN32_ERROR(15160u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_NAMED_RESOURCE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15127u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_NO_CANDIDATE: WIN32_ERROR = WIN32_ERROR(15115u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_NO_CURRENT_VIEW_ON_THREAD: WIN32_ERROR = WIN32_ERROR(15143u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_NO_MATCH_OR_DEFAULT_CANDIDATE: WIN32_ERROR = WIN32_ERROR(15116u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_PACKAGE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15159u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_RESOURCE_TYPE_MISMATCH: WIN32_ERROR = WIN32_ERROR(15117u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE: WIN32_ERROR = WIN32_ERROR(15110u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_SCOPE_ITEM_CONFLICT: WIN32_ERROR = WIN32_ERROR(15161u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_TOO_MANY_RESOURCES: WIN32_ERROR = WIN32_ERROR(15140u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_UNKNOWN_QUALIFIER: WIN32_ERROR = WIN32_ERROR(15113u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_UNSUPPORTED_DIRECTORY_TYPE: WIN32_ERROR = WIN32_ERROR(15122u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_LOAD_UNLOAD_PRI_FILE: WIN32_ERROR = WIN32_ERROR(15142u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_MERGE: WIN32_ERROR = WIN32_ERROR(15141u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MRM_UNSUPPORTED_PROFILE_TYPE: WIN32_ERROR = WIN32_ERROR(15136u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MR_MID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(317u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_FILE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15100u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_FILE_NOT_LOADED: WIN32_ERROR = WIN32_ERROR(15105u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME: WIN32_ERROR = WIN32_ERROR(15108u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(15107u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_INVALID_FILE: WIN32_ERROR = WIN32_ERROR(15101u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_INVALID_LOCALE_NAME: WIN32_ERROR = WIN32_ERROR(15103u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_INVALID_RC_CONFIG: WIN32_ERROR = WIN32_ERROR(15102u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME: WIN32_ERROR = WIN32_ERROR(15104u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MULTIPLE_FAULT_VIOLATION: WIN32_ERROR = WIN32_ERROR(640u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUTANT_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(587u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_MUTUAL_AUTH_FAILED: WIN32_ERROR = WIN32_ERROR(1397u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_ADAPTER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(2150891526u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_ADAPTER_NOT_READY: WIN32_ERROR = WIN32_ERROR(2150891537u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_ADAPTER_REMOVED: WIN32_ERROR = WIN32_ERROR(2150891544u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_ALREADY_MAPPED: WIN32_ERROR = WIN32_ERROR(2150891549u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_BAD_CHARACTERISTICS: WIN32_ERROR = WIN32_ERROR(2150891525u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_BAD_VERSION: WIN32_ERROR = WIN32_ERROR(2150891524u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_BUFFER_TOO_SHORT: WIN32_ERROR = WIN32_ERROR(2150891542u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DEVICE_FAILED: WIN32_ERROR = WIN32_ERROR(2150891528u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DOT11_AP_BAND_CURRENTLY_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(2150899718u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DOT11_AP_BAND_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(2150899720u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DOT11_AP_CHANNEL_CURRENTLY_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(2150899717u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DOT11_AP_CHANNEL_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(2150899719u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED: WIN32_ERROR = WIN32_ERROR(2150899712u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DOT11_MEDIA_IN_USE: WIN32_ERROR = WIN32_ERROR(2150899713u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_DOT11_POWER_STATE_INVALID: WIN32_ERROR = WIN32_ERROR(2150899714u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_ERROR_READING_FILE: WIN32_ERROR = WIN32_ERROR(2150891548u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_FILE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(2150891547u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_GROUP_ADDRESS_IN_USE: WIN32_ERROR = WIN32_ERROR(2150891546u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INDICATION_REQUIRED: WIN32_ERROR = WIN32_ERROR(3407873u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INTERFACE_CLOSING: WIN32_ERROR = WIN32_ERROR(2150891522u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INTERFACE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(2150891563u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_ADDRESS: WIN32_ERROR = WIN32_ERROR(2150891554u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_DATA: WIN32_ERROR = WIN32_ERROR(2150891541u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_DEVICE_REQUEST: WIN32_ERROR = WIN32_ERROR(2150891536u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_LENGTH: WIN32_ERROR = WIN32_ERROR(2150891540u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_OID: WIN32_ERROR = WIN32_ERROR(2150891543u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_PACKET: WIN32_ERROR = WIN32_ERROR(2150891535u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_PORT: WIN32_ERROR = WIN32_ERROR(2150891565u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_INVALID_PORT_STATE: WIN32_ERROR = WIN32_ERROR(2150891566u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_LOW_POWER_STATE: WIN32_ERROR = WIN32_ERROR(2150891567u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_MEDIA_DISCONNECTED: WIN32_ERROR = WIN32_ERROR(2150891551u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_MULTICAST_EXISTS: WIN32_ERROR = WIN32_ERROR(2150891530u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_MULTICAST_FULL: WIN32_ERROR = WIN32_ERROR(2150891529u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_MULTICAST_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(2150891531u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(2150891707u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_NO_QUEUES: WIN32_ERROR = WIN32_ERROR(2150891569u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_OFFLOAD_CONNECTION_REJECTED: WIN32_ERROR = WIN32_ERROR(3224637458u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_OFFLOAD_PATH_REJECTED: WIN32_ERROR = WIN32_ERROR(3224637459u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_OFFLOAD_POLICY: WIN32_ERROR = WIN32_ERROR(3224637455u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_OPEN_FAILED: WIN32_ERROR = WIN32_ERROR(2150891527u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_PAUSED: WIN32_ERROR = WIN32_ERROR(2150891562u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL: WIN32_ERROR = WIN32_ERROR(2150899716u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_PM_WOL_PATTERN_LIST_FULL: WIN32_ERROR = WIN32_ERROR(2150899715u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_REINIT_REQUIRED: WIN32_ERROR = WIN32_ERROR(2150891568u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_REQUEST_ABORTED: WIN32_ERROR = WIN32_ERROR(2150891532u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_RESET_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(2150891533u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_RESOURCE_CONFLICT: WIN32_ERROR = WIN32_ERROR(2150891550u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_UNSUPPORTED_MEDIA: WIN32_ERROR = WIN32_ERROR(2150891545u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NDIS_UNSUPPORTED_REVISION: WIN32_ERROR = WIN32_ERROR(2150891564u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NEEDS_REGISTRATION: WIN32_ERROR = WIN32_ERROR(15631u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NEEDS_REMEDIATION: WIN32_ERROR = WIN32_ERROR(15612u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NEGATIVE_SEEK: WIN32_ERROR = WIN32_ERROR(131u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NESTING_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(215u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETLOGON_NOT_STARTED: WIN32_ERROR = WIN32_ERROR(1792u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETNAME_DELETED: WIN32_ERROR = WIN32_ERROR(64u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETWORK_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(65u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETWORK_ACCESS_DENIED_EDP: WIN32_ERROR = WIN32_ERROR(354u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETWORK_AUTHENTICATION_PROMPT_CANCELED: WIN32_ERROR = WIN32_ERROR(3024u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETWORK_BUSY: WIN32_ERROR = WIN32_ERROR(54u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETWORK_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(5035u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NETWORK_UNREACHABLE: WIN32_ERROR = WIN32_ERROR(1231u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NET_OPEN_FAILED: WIN32_ERROR = WIN32_ERROR(570u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NET_WRITE_FAULT: WIN32_ERROR = WIN32_ERROR(88u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOACCESS: WIN32_ERROR = WIN32_ERROR(998u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NODE_CANNOT_BE_CLUSTERED: WIN32_ERROR = WIN32_ERROR(5898u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NODE_CANT_HOST_RESOURCE: WIN32_ERROR = WIN32_ERROR(5071u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NODE_NOT_ACTIVE_CLUSTER_MEMBER: WIN32_ERROR = WIN32_ERROR(5980u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NODE_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(5036u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOINTERFACE: WIN32_ERROR = WIN32_ERROR(632u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1807u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOLOGON_SERVER_TRUST_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1809u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1808u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NONCORE_GROUPS_FOUND: WIN32_ERROR = WIN32_ERROR(5937u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NONE_MAPPED: WIN32_ERROR = WIN32_ERROR(1332u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NONPAGED_SYSTEM_RESOURCES: WIN32_ERROR = WIN32_ERROR(1451u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NON_ACCOUNT_SID: WIN32_ERROR = WIN32_ERROR(1257u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NON_CSV_PATH: WIN32_ERROR = WIN32_ERROR(5950u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NON_DOMAIN_SID: WIN32_ERROR = WIN32_ERROR(1258u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NON_MDICHILD_WINDOW: WIN32_ERROR = WIN32_ERROR(1445u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOTHING_TO_TERMINATE: WIN32_ERROR = WIN32_ERROR(758u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOTIFICATION_GUID_ALREADY_DEFINED: WIN32_ERROR = WIN32_ERROR(309u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOTIFY_CLEANUP: WIN32_ERROR = WIN32_ERROR(745u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOTIFY_ENUM_DIR: WIN32_ERROR = WIN32_ERROR(1022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_ALLOWED_ON_SYSTEM_FILE: WIN32_ERROR = WIN32_ERROR(313u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_ALL_ASSIGNED: WIN32_ERROR = WIN32_ERROR(1300u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_APPCONTAINER: WIN32_ERROR = WIN32_ERROR(4250u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_AUTHENTICATED: WIN32_ERROR = WIN32_ERROR(1244u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_A_CLOUD_FILE: WIN32_ERROR = WIN32_ERROR(376u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_A_CLOUD_SYNC_ROOT: WIN32_ERROR = WIN32_ERROR(405u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_A_DAX_VOLUME: WIN32_ERROR = WIN32_ERROR(420u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_A_REPARSE_POINT: WIN32_ERROR = WIN32_ERROR(4390u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_A_TIERED_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898423i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_CAPABLE: WIN32_ERROR = WIN32_ERROR(775u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_CHILD_WINDOW: WIN32_ERROR = WIN32_ERROR(1442u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_CLIENT_PORT: u32 = 913u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_CONNECTED: WIN32_ERROR = WIN32_ERROR(2250u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_CONTAINER: WIN32_ERROR = WIN32_ERROR(1207u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_DAX_MAPPABLE: WIN32_ERROR = WIN32_ERROR(421u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_DOS_DISK: WIN32_ERROR = WIN32_ERROR(26u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_EMPTY: WIN32_ERROR = WIN32_ERROR(4307u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_ENOUGH_MEMORY: WIN32_ERROR = WIN32_ERROR(8u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_ENOUGH_QUOTA: WIN32_ERROR = WIN32_ERROR(1816u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_ENOUGH_SERVER_MEMORY: WIN32_ERROR = WIN32_ERROR(1130u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_EXPORT_FORMAT: WIN32_ERROR = WIN32_ERROR(6008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1168u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_GUI_PROCESS: WIN32_ERROR = WIN32_ERROR(1471u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_JOINED: WIN32_ERROR = WIN32_ERROR(136u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_LOCKED: WIN32_ERROR = WIN32_ERROR(158u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_LOGGED_ON: WIN32_ERROR = WIN32_ERROR(1245u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_LOGON_PROCESS: WIN32_ERROR = WIN32_ERROR(1362u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_OWNER: WIN32_ERROR = WIN32_ERROR(288u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_QUORUM_CAPABLE: WIN32_ERROR = WIN32_ERROR(5021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_QUORUM_CLASS: WIN32_ERROR = WIN32_ERROR(5025u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_READY: WIN32_ERROR = WIN32_ERROR(21u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_READ_FROM_COPY: WIN32_ERROR = WIN32_ERROR(337u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_REDUNDANT_STORAGE: WIN32_ERROR = WIN32_ERROR(333u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_REGISTRY_FILE: WIN32_ERROR = WIN32_ERROR(1017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_ROUTER_PORT: u32 = 914u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SAFEBOOT_SERVICE: WIN32_ERROR = WIN32_ERROR(1084u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SAFE_MODE_DRIVER: WIN32_ERROR = WIN32_ERROR(646u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SAME_DEVICE: WIN32_ERROR = WIN32_ERROR(17u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SAME_OBJECT: WIN32_ERROR = WIN32_ERROR(1656u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SNAPSHOT_VOLUME: WIN32_ERROR = WIN32_ERROR(6841u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUBSTED: WIN32_ERROR = WIN32_ERROR(137u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(50u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_IN_APPCONTAINER: WIN32_ERROR = WIN32_ERROR(4252u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_ON_DAX: WIN32_ERROR = WIN32_ERROR(360u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_ON_SBS: WIN32_ERROR = WIN32_ERROR(1254u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER: WIN32_ERROR = WIN32_ERROR(8584u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_AUDITING: WIN32_ERROR = WIN32_ERROR(499u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_BTT: WIN32_ERROR = WIN32_ERROR(429u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_BYPASSIO: WIN32_ERROR = WIN32_ERROR(493u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_CACHED_HANDLE: WIN32_ERROR = WIN32_ERROR(509u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_COMPRESSION: WIN32_ERROR = WIN32_ERROR(496u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_DEDUPLICATION: WIN32_ERROR = WIN32_ERROR(498u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_ENCRYPTION: WIN32_ERROR = WIN32_ERROR(495u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_MONITORING: WIN32_ERROR = WIN32_ERROR(503u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_REPLICATION: WIN32_ERROR = WIN32_ERROR(497u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_SNAPSHOT: WIN32_ERROR = WIN32_ERROR(504u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_SUPPORTED_WITH_VIRTUALIZATION: WIN32_ERROR = WIN32_ERROR(505u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NOT_TINY_STREAM: WIN32_ERROR = WIN32_ERROR(598u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_ACE_CONDITION: WIN32_ERROR = WIN32_ERROR(804u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_ADMIN_ACCESS_POINT: WIN32_ERROR = WIN32_ERROR(5090u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_APPLICABLE_APP_LICENSES_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058406399i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_ASSOCIATION: WIN32_ERROR = WIN32_ERROR(1155u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_AUTH_PROTOCOL_AVAILABLE: u32 = 918u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_BROWSER_SERVERS_FOUND: WIN32_ERROR = WIN32_ERROR(6118u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_BYPASSIO_DRIVER_SUPPORT: WIN32_ERROR = WIN32_ERROR(494u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_CALLBACK_ACTIVE: WIN32_ERROR = WIN32_ERROR(614u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_DATA: WIN32_ERROR = WIN32_ERROR(232u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_DATA_DETECTED: WIN32_ERROR = WIN32_ERROR(1104u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_EFS: WIN32_ERROR = WIN32_ERROR(6004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_EVENT_PAIR: WIN32_ERROR = WIN32_ERROR(580u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_GUID_TRANSLATION: WIN32_ERROR = WIN32_ERROR(560u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_IMPERSONATION_TOKEN: WIN32_ERROR = WIN32_ERROR(1309u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_INHERITANCE: WIN32_ERROR = WIN32_ERROR(1391u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_INTERFACE_CREDENTIALS_SET: u32 = 909u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_LINK_TRACKING_IN_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6852u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_LOGON_SERVERS: WIN32_ERROR = WIN32_ERROR(1311u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_LOG_SPACE: WIN32_ERROR = WIN32_ERROR(1019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MATCH: WIN32_ERROR = WIN32_ERROR(1169u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MEDIA_IN_DRIVE: WIN32_ERROR = WIN32_ERROR(1112u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MORE_DEVICES: WIN32_ERROR = WIN32_ERROR(1248u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MORE_FILES: WIN32_ERROR = WIN32_ERROR(18u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MORE_ITEMS: WIN32_ERROR = WIN32_ERROR(259u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MORE_MATCHES: WIN32_ERROR = WIN32_ERROR(626u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MORE_SEARCH_HANDLES: WIN32_ERROR = WIN32_ERROR(113u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_MORE_USER_HANDLES: WIN32_ERROR = WIN32_ERROR(1158u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_NETWORK: WIN32_ERROR = WIN32_ERROR(1222u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_NET_OR_BAD_PATH: WIN32_ERROR = WIN32_ERROR(1203u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_NVRAM_RESOURCES: WIN32_ERROR = WIN32_ERROR(1470u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_PAGEFILE: WIN32_ERROR = WIN32_ERROR(578u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_PHYSICALLY_ALIGNED_FREE_SPACE_FOUND: WIN32_ERROR = WIN32_ERROR(408u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_PROC_SLOTS: WIN32_ERROR = WIN32_ERROR(89u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_PROMOTION_ACTIVE: WIN32_ERROR = WIN32_ERROR(8222u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_QUOTAS_FOR_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1302u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_RADIUS_SERVERS: u32 = 938u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_RANGES_PROCESSED: WIN32_ERROR = WIN32_ERROR(312u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_RECOVERY_POLICY: WIN32_ERROR = WIN32_ERROR(6003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_RECOVERY_PROGRAM: WIN32_ERROR = WIN32_ERROR(1082u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SAVEPOINT_WITH_OPEN_FILES: WIN32_ERROR = WIN32_ERROR(6842u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SCROLLBARS: WIN32_ERROR = WIN32_ERROR(1447u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SECRETS: WIN32_ERROR = WIN32_ERROR(8620u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SECURITY_ON_OBJECT: WIN32_ERROR = WIN32_ERROR(1350u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SHUTDOWN_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(1116u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SIGNAL_SENT: WIN32_ERROR = WIN32_ERROR(205u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SIGNATURE: u32 = 951u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SITENAME: WIN32_ERROR = WIN32_ERROR(1919u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SITE_SETTINGS_OBJECT: WIN32_ERROR = WIN32_ERROR(8619u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SPOOL_SPACE: WIN32_ERROR = WIN32_ERROR(62u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_ALIAS: WIN32_ERROR = WIN32_ERROR(1376u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_DEVICE: WIN32_ERROR = WIN32_ERROR(433u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_DOMAIN: WIN32_ERROR = WIN32_ERROR(1355u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_GROUP: WIN32_ERROR = WIN32_ERROR(1319u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_INTERFACE: u32 = 905u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_LOGON_SESSION: WIN32_ERROR = WIN32_ERROR(1312u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_MEMBER: WIN32_ERROR = WIN32_ERROR(1387u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_PACKAGE: WIN32_ERROR = WIN32_ERROR(1364u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_PRIVILEGE: WIN32_ERROR = WIN32_ERROR(1313u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_SITE: WIN32_ERROR = WIN32_ERROR(1249u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUCH_USER: WIN32_ERROR = WIN32_ERROR(1317u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SUPPORTING_DRIVES: WIN32_ERROR = WIN32_ERROR(4339u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SYSTEM_MENU: WIN32_ERROR = WIN32_ERROR(1437u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_SYSTEM_RESOURCES: WIN32_ERROR = WIN32_ERROR(1450u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_TASK_QUEUE: WIN32_ERROR = WIN32_ERROR(427u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_TOKEN: WIN32_ERROR = WIN32_ERROR(1008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_TRACKING_SERVICE: WIN32_ERROR = WIN32_ERROR(1172u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_TRUST_LSA_SECRET: WIN32_ERROR = WIN32_ERROR(1786u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_TRUST_SAM_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1787u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_TXF_METADATA: WIN32_ERROR = WIN32_ERROR(6816u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_UNICODE_TRANSLATION: WIN32_ERROR = WIN32_ERROR(1113u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_USER_KEYS: WIN32_ERROR = WIN32_ERROR(6006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_USER_SESSION_KEY: WIN32_ERROR = WIN32_ERROR(1394u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_VOLUME_ID: WIN32_ERROR = WIN32_ERROR(1173u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_VOLUME_LABEL: WIN32_ERROR = WIN32_ERROR(125u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_WILDCARD_CHARACTERS: WIN32_ERROR = WIN32_ERROR(1417u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_WORK_DONE: WIN32_ERROR = WIN32_ERROR(235u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_WRITABLE_DC_FOUND: WIN32_ERROR = WIN32_ERROR(8621u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NO_YIELD_PERFORMED: WIN32_ERROR = WIN32_ERROR(721u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NTLM_BLOCKED: WIN32_ERROR = WIN32_ERROR(1937u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NT_CROSS_ENCRYPTION_REQUIRED: WIN32_ERROR = WIN32_ERROR(1386u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_NULL_LM_PASSWORD: WIN32_ERROR = WIN32_ERROR(1304u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OBJECT_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(5010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OBJECT_IN_LIST: WIN32_ERROR = WIN32_ERROR(5011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OBJECT_IS_IMMUTABLE: WIN32_ERROR = WIN32_ERROR(4449u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OBJECT_NAME_EXISTS: WIN32_ERROR = WIN32_ERROR(698u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OBJECT_NOT_EXTERNALLY_BACKED: WIN32_ERROR = WIN32_ERROR(342u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OBJECT_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4312u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OBJECT_NO_LONGER_EXISTS: WIN32_ERROR = WIN32_ERROR(6807u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OFFLOAD_READ_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(4442u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OFFLOAD_READ_FLT_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(4440u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OFFLOAD_WRITE_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(4443u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OFFLOAD_WRITE_FLT_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(4441u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OFFSET_ALIGNMENT_VIOLATION: WIN32_ERROR = WIN32_ERROR(327u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OLD_WIN_VERSION: WIN32_ERROR = WIN32_ERROR(1150u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ONLY_IF_CONNECTED: WIN32_ERROR = WIN32_ERROR(1251u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPEN_FAILED: WIN32_ERROR = WIN32_ERROR(110u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPEN_FILES: WIN32_ERROR = WIN32_ERROR(2401u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPERATION_ABORTED: WIN32_ERROR = WIN32_ERROR(995u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPERATION_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(329u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPERATION_NOT_ALLOWED_FROM_SYSTEM_COMPONENT: WIN32_ERROR = WIN32_ERROR(15145u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6853u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPLOCK_BREAK_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(742u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPLOCK_HANDLE_CLOSED: WIN32_ERROR = WIN32_ERROR(803u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPLOCK_NOT_GRANTED: WIN32_ERROR = WIN32_ERROR(300u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE: WIN32_ERROR = WIN32_ERROR(800u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ORPHAN_NAME_EXHAUSTED: WIN32_ERROR = WIN32_ERROR(799u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OUTOFMEMORY: WIN32_ERROR = WIN32_ERROR(14u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OUT_OF_PAPER: WIN32_ERROR = WIN32_ERROR(28u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OUT_OF_STRUCTURES: WIN32_ERROR = WIN32_ERROR(84u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_OVERRIDE_NOCHANGES: WIN32_ERROR = WIN32_ERROR(1252u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGED_SERVICE_REQUIRES_ADMIN_PRIVILEGES: WIN32_ERROR = WIN32_ERROR(15656u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGES_IN_USE: WIN32_ERROR = WIN32_ERROR(15618u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGES_REPUTATION_CHECK_FAILED: WIN32_ERROR = WIN32_ERROR(15643u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGES_REPUTATION_CHECK_TIMEDOUT: WIN32_ERROR = WIN32_ERROR(15644u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(15611u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_EXTERNAL_LOCATION_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(15662u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_LACKS_CAPABILITY_FOR_MANDATORY_STARTUPTASKS: WIN32_ERROR = WIN32_ERROR(15664u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_LACKS_CAPABILITY_TO_DEPLOY_ON_HOST: WIN32_ERROR = WIN32_ERROR(15658u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_MOVE_BLOCKED_BY_STREAMING: WIN32_ERROR = WIN32_ERROR(15636u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_MOVE_FAILED: WIN32_ERROR = WIN32_ERROR(15627u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_NAME_MISMATCH: WIN32_ERROR = WIN32_ERROR(15670u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_NOT_REGISTERED_FOR_USER: WIN32_ERROR = WIN32_ERROR(15669u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_NOT_SUPPORTED_ON_FILESYSTEM: WIN32_ERROR = WIN32_ERROR(15635u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_REPOSITORY_CORRUPTED: WIN32_ERROR = WIN32_ERROR(15614u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_STAGING_ONHOLD: WIN32_ERROR = WIN32_ERROR(15638u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PACKAGE_UPDATING: WIN32_ERROR = WIN32_ERROR(15616u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGED_SYSTEM_RESOURCES: WIN32_ERROR = WIN32_ERROR(1452u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGEFILE_CREATE_FAILED: WIN32_ERROR = WIN32_ERROR(576u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGEFILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(491u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGEFILE_QUOTA: WIN32_ERROR = WIN32_ERROR(1454u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGEFILE_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(567u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGE_FAULT_COPY_ON_WRITE: WIN32_ERROR = WIN32_ERROR(749u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGE_FAULT_DEMAND_ZERO: WIN32_ERROR = WIN32_ERROR(748u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGE_FAULT_GUARD_PAGE: WIN32_ERROR = WIN32_ERROR(750u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGE_FAULT_PAGING_FILE: WIN32_ERROR = WIN32_ERROR(751u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PAGE_FAULT_TRANSITION: WIN32_ERROR = WIN32_ERROR(747u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PARAMETER_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1283u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PARTIAL_COPY: WIN32_ERROR = WIN32_ERROR(299u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PARTITION_FAILURE: WIN32_ERROR = WIN32_ERROR(1105u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PARTITION_TERMINATING: WIN32_ERROR = WIN32_ERROR(1184u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PASSWORD_CHANGE_REQUIRED: WIN32_ERROR = WIN32_ERROR(1938u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PASSWORD_EXPIRED: WIN32_ERROR = WIN32_ERROR(1330u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PASSWORD_MUST_CHANGE: WIN32_ERROR = WIN32_ERROR(1907u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PASSWORD_RESTRICTION: WIN32_ERROR = WIN32_ERROR(1325u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT: WIN32_ERROR = WIN32_ERROR(1651u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_NO_SEQUENCE: WIN32_ERROR = WIN32_ERROR(1648u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_PACKAGE_INVALID: WIN32_ERROR = WIN32_ERROR(1636u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_PACKAGE_OPEN_FAILED: WIN32_ERROR = WIN32_ERROR(1635u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_PACKAGE_REJECTED: WIN32_ERROR = WIN32_ERROR(1643u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_PACKAGE_UNSUPPORTED: WIN32_ERROR = WIN32_ERROR(1637u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_REMOVAL_DISALLOWED: WIN32_ERROR = WIN32_ERROR(1649u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_REMOVAL_UNSUPPORTED: WIN32_ERROR = WIN32_ERROR(1646u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATCH_TARGET_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1642u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATH_BUSY: WIN32_ERROR = WIN32_ERROR(148u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PATH_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PEER_REFUSED_AUTH: u32 = 919u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PER_USER_TRUST_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1932u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PIPE_BUSY: WIN32_ERROR = WIN32_ERROR(231u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PIPE_CONNECTED: WIN32_ERROR = WIN32_ERROR(535u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PIPE_LISTENING: WIN32_ERROR = WIN32_ERROR(536u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PIPE_LOCAL: WIN32_ERROR = WIN32_ERROR(229u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PIPE_NOT_CONNECTED: WIN32_ERROR = WIN32_ERROR(233u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PKINIT_FAILURE: WIN32_ERROR = WIN32_ERROR(1263u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLATFORM_MANIFEST_BINARY_ID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4574u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLATFORM_MANIFEST_CATALOG_NOT_AUTHORIZED: WIN32_ERROR = WIN32_ERROR(4573u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLATFORM_MANIFEST_FILE_NOT_AUTHORIZED: WIN32_ERROR = WIN32_ERROR(4572u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLATFORM_MANIFEST_INVALID: WIN32_ERROR = WIN32_ERROR(4571u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLATFORM_MANIFEST_NOT_ACTIVE: WIN32_ERROR = WIN32_ERROR(4575u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLATFORM_MANIFEST_NOT_AUTHORIZED: WIN32_ERROR = WIN32_ERROR(4570u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLATFORM_MANIFEST_NOT_SIGNED: WIN32_ERROR = WIN32_ERROR(4576u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PLUGPLAY_QUERY_VETOED: WIN32_ERROR = WIN32_ERROR(683u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_BAD_MPS_TABLE: WIN32_ERROR = WIN32_ERROR(671u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_INVALID_ID: WIN32_ERROR = WIN32_ERROR(674u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_IRQ_TRANSLATION_FAILED: WIN32_ERROR = WIN32_ERROR(673u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_QUERY_REMOVE_DEVICE_TIMEOUT: WIN32_ERROR = WIN32_ERROR(480u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_QUERY_REMOVE_RELATED_DEVICE_TIMEOUT: WIN32_ERROR = WIN32_ERROR(481u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_QUERY_REMOVE_UNRELATED_DEVICE_TIMEOUT: WIN32_ERROR = WIN32_ERROR(482u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_REBOOT_REQUIRED: WIN32_ERROR = WIN32_ERROR(638u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_RESTART_ENUMERATION: WIN32_ERROR = WIN32_ERROR(636u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PNP_TRANSLATION_FAILED: WIN32_ERROR = WIN32_ERROR(672u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_POINT_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1171u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_POLICY_OBJECT_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(8219u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_POLICY_ONLY_IN_DS: WIN32_ERROR = WIN32_ERROR(8220u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_POPUP_ALREADY_ACTIVE: WIN32_ERROR = WIN32_ERROR(1446u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PORT_LIMIT_REACHED: u32 = 931u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PORT_MESSAGE_TOO_LONG: WIN32_ERROR = WIN32_ERROR(546u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PORT_NOT_SET: WIN32_ERROR = WIN32_ERROR(642u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PORT_UNREACHABLE: WIN32_ERROR = WIN32_ERROR(1234u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_POSSIBLE_DEADLOCK: WIN32_ERROR = WIN32_ERROR(1131u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_POTENTIAL_FILE_FOUND: WIN32_ERROR = WIN32_ERROR(1180u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PPP_SESSION_TIMEOUT: u32 = 932u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PREDEFINED_HANDLE: WIN32_ERROR = WIN32_ERROR(714u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED: WIN32_ERROR = WIN32_ERROR(746u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(1802u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_DELETED: WIN32_ERROR = WIN32_ERROR(1905u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_DRIVER_ALREADY_INSTALLED: WIN32_ERROR = WIN32_ERROR(1795u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_DRIVER_BLOCKED: WIN32_ERROR = WIN32_ERROR(3014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED: WIN32_ERROR = WIN32_ERROR(3019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_DRIVER_IN_USE: WIN32_ERROR = WIN32_ERROR(3001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_DRIVER_PACKAGE_IN_USE: WIN32_ERROR = WIN32_ERROR(3015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_DRIVER_WARNED: WIN32_ERROR = WIN32_ERROR(3013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_HAS_JOBS_QUEUED: WIN32_ERROR = WIN32_ERROR(3009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTER_NOT_SHAREABLE: WIN32_ERROR = WIN32_ERROR(3022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINTQ_FULL: WIN32_ERROR = WIN32_ERROR(61u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINT_CANCELLED: WIN32_ERROR = WIN32_ERROR(63u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINT_JOB_RESTART_REQUIRED: WIN32_ERROR = WIN32_ERROR(3020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINT_MONITOR_ALREADY_INSTALLED: WIN32_ERROR = WIN32_ERROR(3006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINT_MONITOR_IN_USE: WIN32_ERROR = WIN32_ERROR(3008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED: WIN32_ERROR = WIN32_ERROR(3005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRIVATE_DIALOG_INDEX: WIN32_ERROR = WIN32_ERROR(1415u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRIVILEGE_NOT_HELD: WIN32_ERROR = WIN32_ERROR(1314u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_ADD_FILE_FAILED: WIN32_ERROR = WIN32_ERROR(15151u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_BUNDLE_PACKAGES_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(15155u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_INVALID_FILE_NAME: WIN32_ERROR = WIN32_ERROR(15158u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_LOAD_FILE_FAILED: WIN32_ERROR = WIN32_ERROR(15150u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_MAIN_PACKAGE_REQUIRED: WIN32_ERROR = WIN32_ERROR(15156u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_MISSING_SCHEMA: WIN32_ERROR = WIN32_ERROR(15149u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_MULTIPLE_MAIN_PACKAGES_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(15154u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_MULTIPLE_PACKAGE_FAMILIES_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(15153u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_RESOURCE_PACKAGE_REQUIRED: WIN32_ERROR = WIN32_ERROR(15157u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_VERSION_MISMATCH: WIN32_ERROR = WIN32_ERROR(15148u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRI_MERGE_WRITE_FILE_FAILED: WIN32_ERROR = WIN32_ERROR(15152u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROCESS_ABORTED: WIN32_ERROR = WIN32_ERROR(1067u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROCESS_IN_JOB: WIN32_ERROR = WIN32_ERROR(760u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROCESS_IS_PROTECTED: WIN32_ERROR = WIN32_ERROR(1293u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROCESS_MODE_ALREADY_BACKGROUND: WIN32_ERROR = WIN32_ERROR(402u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROCESS_MODE_NOT_BACKGROUND: WIN32_ERROR = WIN32_ERROR(403u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROCESS_NOT_IN_JOB: WIN32_ERROR = WIN32_ERROR(759u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROC_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(127u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRODUCT_UNINSTALLED: WIN32_ERROR = WIN32_ERROR(1614u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PRODUCT_VERSION: WIN32_ERROR = WIN32_ERROR(1638u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROFILE_DOES_NOT_MATCH_DEVICE: WIN32_ERROR = WIN32_ERROR(2023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE: WIN32_ERROR = WIN32_ERROR(2015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROFILE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(2016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROFILING_AT_LIMIT: WIN32_ERROR = WIN32_ERROR(553u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROFILING_NOT_STARTED: WIN32_ERROR = WIN32_ERROR(550u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROFILING_NOT_STOPPED: WIN32_ERROR = WIN32_ERROR(551u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROMOTION_ACTIVE: WIN32_ERROR = WIN32_ERROR(8221u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROTOCOL_ALREADY_INSTALLED: u32 = 948u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROTOCOL_STOP_PENDING: u32 = 907u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROTOCOL_UNREACHABLE: WIN32_ERROR = WIN32_ERROR(1233u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PROVISION_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE_PROVISIONED: WIN32_ERROR = WIN32_ERROR(15642u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PWD_HISTORY_CONFLICT: WIN32_ERROR = WIN32_ERROR(617u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PWD_TOO_LONG: WIN32_ERROR = WIN32_ERROR(657u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PWD_TOO_RECENT: WIN32_ERROR = WIN32_ERROR(616u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_PWD_TOO_SHORT: WIN32_ERROR = WIN32_ERROR(615u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUERY_STORAGE_ERROR: WIN32_ERROR = WIN32_ERROR(2151284737u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_ALPN_NEG_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223801i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_CONNECTION_IDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223803i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_CONNECTION_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223802i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_HANDSHAKE_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223805i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_PROTOCOL_VIOLATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223804i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_USER_CANCELED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223806i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUIC_VER_NEG_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143223807i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUORUMLOG_OPEN_FAILED: WIN32_ERROR = WIN32_ERROR(5028u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUORUM_DISK_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5086u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP: WIN32_ERROR = WIN32_ERROR(5928u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUORUM_OWNER_ALIVE: WIN32_ERROR = WIN32_ERROR(5034u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUORUM_RESOURCE: WIN32_ERROR = WIN32_ERROR(5020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUORUM_RESOURCE_ONLINE_FAILED: WIN32_ERROR = WIN32_ERROR(5027u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUOTA_ACTIVITY: WIN32_ERROR = WIN32_ERROR(810u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_QUOTA_LIST_INCONSISTENT: WIN32_ERROR = WIN32_ERROR(621u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RANGE_LIST_CONFLICT: WIN32_ERROR = WIN32_ERROR(627u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RANGE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(644u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RDP_PROTOCOL_ERROR: WIN32_ERROR = WIN32_ERROR(7065u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_READ_FAULT: WIN32_ERROR = WIN32_ERROR(30u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RECEIVE_EXPEDITED: WIN32_ERROR = WIN32_ERROR(708u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RECEIVE_PARTIAL: WIN32_ERROR = WIN32_ERROR(707u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RECEIVE_PARTIAL_EXPEDITED: WIN32_ERROR = WIN32_ERROR(709u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RECOVERY_FAILURE: WIN32_ERROR = WIN32_ERROR(1279u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RECOVERY_FILE_CORRUPT: WIN32_ERROR = WIN32_ERROR(15619u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RECOVERY_NOT_NEEDED: WIN32_ERROR = WIN32_ERROR(6821u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REC_NON_EXISTENT: WIN32_ERROR = WIN32_ERROR(4005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REDIRECTION_TO_DEFAULT_ACCOUNT_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(15657u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REDIRECTOR_HAS_OPEN_HANDLES: WIN32_ERROR = WIN32_ERROR(1794u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REDIR_PAUSED: WIN32_ERROR = WIN32_ERROR(72u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REGISTRATION_FROM_REMOTE_DRIVE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(15647u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REGISTRY_CORRUPT: WIN32_ERROR = WIN32_ERROR(1015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REGISTRY_HIVE_RECOVERED: WIN32_ERROR = WIN32_ERROR(685u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REGISTRY_IO_FAILED: WIN32_ERROR = WIN32_ERROR(1016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REGISTRY_QUOTA_LIMIT: WIN32_ERROR = WIN32_ERROR(613u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REGISTRY_RECOVERED: WIN32_ERROR = WIN32_ERROR(1014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REG_NAT_CONSUMPTION: WIN32_ERROR = WIN32_ERROR(1261u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RELOC_CHAIN_XEEDS_SEGLIM: WIN32_ERROR = WIN32_ERROR(201u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTEACCESS_NOT_CONFIGURED: u32 = 956u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_ACCT_DISABLED: u32 = 922u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_AUTHENTICATION_FAILURE: u32 = 924u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_FILE_VERSION_MISMATCH: WIN32_ERROR = WIN32_ERROR(6814u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_NO_DIALIN_PERMISSION: u32 = 920u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_PASSWD_EXPIRED: u32 = 921u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED: WIN32_ERROR = WIN32_ERROR(1936u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_RESTRICTED_LOGON_HOURS: u32 = 923u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_SESSION_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1220u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_STORAGE_MEDIA_ERROR: WIN32_ERROR = WIN32_ERROR(4352u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOTE_STORAGE_NOT_ACTIVE: WIN32_ERROR = WIN32_ERROR(4351u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REMOVE_FAILED: WIN32_ERROR = WIN32_ERROR(15610u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REM_NOT_LIST: WIN32_ERROR = WIN32_ERROR(51u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REPARSE: WIN32_ERROR = WIN32_ERROR(741u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REPARSE_ATTRIBUTE_CONFLICT: WIN32_ERROR = WIN32_ERROR(4391u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REPARSE_OBJECT: WIN32_ERROR = WIN32_ERROR(755u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REPARSE_POINT_ENCOUNTERED: WIN32_ERROR = WIN32_ERROR(4395u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REPARSE_TAG_INVALID: WIN32_ERROR = WIN32_ERROR(4393u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REPARSE_TAG_MISMATCH: WIN32_ERROR = WIN32_ERROR(4394u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REPLY_MESSAGE_MISMATCH: WIN32_ERROR = WIN32_ERROR(595u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REQUEST_ABORTED: WIN32_ERROR = WIN32_ERROR(1235u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REQUEST_OUT_OF_SEQUENCE: WIN32_ERROR = WIN32_ERROR(776u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REQUEST_PAUSED: WIN32_ERROR = WIN32_ERROR(3050u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REQUEST_REFUSED: WIN32_ERROR = WIN32_ERROR(4320u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION: WIN32_ERROR = WIN32_ERROR(1459u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REQ_NOT_ACCEP: WIN32_ERROR = WIN32_ERROR(71u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESIDENT_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(334u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESILIENCY_FILE_CORRUPT: WIN32_ERROR = WIN32_ERROR(15625u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESMON_CREATE_FAILED: WIN32_ERROR = WIN32_ERROR(5017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESMON_INVALID_STATE: WIN32_ERROR = WIN32_ERROR(5084u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESMON_ONLINE_FAILED: WIN32_ERROR = WIN32_ERROR(5018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESMON_SYSTEM_RESOURCES_LACKING: WIN32_ERROR = WIN32_ERROR(5956u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCEMANAGER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(6716u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCEMANAGER_READ_ONLY: WIN32_ERROR = WIN32_ERROR(6707u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_CALL_TIMED_OUT: WIN32_ERROR = WIN32_ERROR(5910u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_DATA_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1812u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_DISABLED: WIN32_ERROR = WIN32_ERROR(4309u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_ENUM_USER_STOP: WIN32_ERROR = WIN32_ERROR(15106u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_FAILED: WIN32_ERROR = WIN32_ERROR(5038u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_LANG_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1815u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_NAME_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1814u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(5006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(5007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_NOT_IN_AVAILABLE_STORAGE: WIN32_ERROR = WIN32_ERROR(5965u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_NOT_ONLINE: WIN32_ERROR = WIN32_ERROR(5004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(4316u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_ONLINE: WIN32_ERROR = WIN32_ERROR(5019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_PROPERTIES_STORED: WIN32_ERROR = WIN32_ERROR(5024u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_PROPERTY_UNCHANGEABLE: WIN32_ERROR = WIN32_ERROR(5089u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_REQUIREMENTS_CHANGED: WIN32_ERROR = WIN32_ERROR(756u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESOURCE_TYPE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1813u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESTART_APPLICATION: WIN32_ERROR = WIN32_ERROR(1467u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RESUME_HIBERNATION: WIN32_ERROR = WIN32_ERROR(727u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RETRY: WIN32_ERROR = WIN32_ERROR(1237u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RETURN_ADDRESS_HIJACK_ATTEMPT: WIN32_ERROR = WIN32_ERROR(1662u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_REVISION_MISMATCH: WIN32_ERROR = WIN32_ERROR(1306u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RING2SEG_MUST_BE_MOVABLE: WIN32_ERROR = WIN32_ERROR(200u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RING2_STACK_IN_USE: WIN32_ERROR = WIN32_ERROR(207u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RMODE_APP: WIN32_ERROR = WIN32_ERROR(1153u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RM_ALREADY_STARTED: WIN32_ERROR = WIN32_ERROR(6822u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT: WIN32_ERROR = WIN32_ERROR(6728u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RM_DISCONNECTED: WIN32_ERROR = WIN32_ERROR(6819u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RM_METADATA_CORRUPT: WIN32_ERROR = WIN32_ERROR(6802u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RM_NOT_ACTIVE: WIN32_ERROR = WIN32_ERROR(6801u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ROLLBACK_TIMER_EXPIRED: WIN32_ERROR = WIN32_ERROR(6829u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ROUTER_CONFIG_INCOMPATIBLE: u32 = 945u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ROUTER_STOPPED: u32 = 900u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_ROWSNOTRELEASED: WIN32_ERROR = WIN32_ERROR(772u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RPL_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(4006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT: WIN32_ERROR = WIN32_ERROR(15403u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RUNLEVEL_SWITCH_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(15404u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RUNLEVEL_SWITCH_TIMEOUT: WIN32_ERROR = WIN32_ERROR(15402u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RWRAW_ENCRYPTED_FILE_NOT_ENCRYPTED: WIN32_ERROR = WIN32_ERROR(410u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILEOFFSET: WIN32_ERROR = WIN32_ERROR(411u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILERANGE: WIN32_ERROR = WIN32_ERROR(412u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_PARAMETER: WIN32_ERROR = WIN32_ERROR(413u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RXACT_COMMITTED: WIN32_ERROR = WIN32_ERROR(744u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RXACT_COMMIT_FAILURE: WIN32_ERROR = WIN32_ERROR(1370u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RXACT_COMMIT_NECESSARY: WIN32_ERROR = WIN32_ERROR(678u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RXACT_INVALID_STATE: WIN32_ERROR = WIN32_ERROR(1369u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_RXACT_STATE_CREATED: WIN32_ERROR = WIN32_ERROR(701u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SAME_DRIVE: WIN32_ERROR = WIN32_ERROR(143u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SAM_INIT_FAILURE: WIN32_ERROR = WIN32_ERROR(8541u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SCOPE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(318u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SCREEN_ALREADY_LOCKED: WIN32_ERROR = WIN32_ERROR(1440u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SCRUB_DATA_DISABLED: WIN32_ERROR = WIN32_ERROR(332u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECCORE_INVALID_COMMAND: ::windows_core::HRESULT = ::windows_core::HRESULT(-1058537472i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED: WIN32_ERROR = WIN32_ERROR(15321u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECRET_TOO_LONG: WIN32_ERROR = WIN32_ERROR(1382u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECTION_DIRECT_MAP_ONLY: WIN32_ERROR = WIN32_ERROR(819u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECTOR_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(27u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_FILE_REPLACED: WIN32_ERROR = WIN32_ERROR(4426u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_INVALID_POLICY: WIN32_ERROR = WIN32_ERROR(4422u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_NOT_BASE_POLICY: WIN32_ERROR = WIN32_ERROR(4434u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_NOT_ENABLED: WIN32_ERROR = WIN32_ERROR(4425u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_NOT_SUPPLEMENTAL_POLICY: WIN32_ERROR = WIN32_ERROR(4435u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_PLATFORM_ID_MISMATCH: WIN32_ERROR = WIN32_ERROR(4430u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_MISSING_ANTIROLLBACKVERSION: WIN32_ERROR = WIN32_ERROR(4429u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_NOT_AUTHORIZED: WIN32_ERROR = WIN32_ERROR(4427u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_NOT_SIGNED: WIN32_ERROR = WIN32_ERROR(4424u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4423u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_ROLLBACK_DETECTED: WIN32_ERROR = WIN32_ERROR(4431u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_UNKNOWN: WIN32_ERROR = WIN32_ERROR(4428u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_UPGRADE_MISMATCH: WIN32_ERROR = WIN32_ERROR(4432u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_POLICY_VIOLATION: WIN32_ERROR = WIN32_ERROR(4421u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_REQUIRED_POLICY_FILE_MISSING: WIN32_ERROR = WIN32_ERROR(4433u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECUREBOOT_ROLLBACK_DETECTED: WIN32_ERROR = WIN32_ERROR(4420u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECURITY_DENIES_OPERATION: WIN32_ERROR = WIN32_ERROR(447u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SECURITY_STREAM_IS_INCONSISTENT: WIN32_ERROR = WIN32_ERROR(306u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEEK: WIN32_ERROR = WIN32_ERROR(25u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEEK_ON_DEVICE: WIN32_ERROR = WIN32_ERROR(132u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEGMENT_NOTIFICATION: WIN32_ERROR = WIN32_ERROR(702u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEM_IS_SET: WIN32_ERROR = WIN32_ERROR(102u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEM_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(187u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEM_OWNER_DIED: WIN32_ERROR = WIN32_ERROR(105u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEM_TIMEOUT: WIN32_ERROR = WIN32_ERROR(121u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SEM_USER_LIMIT: WIN32_ERROR = WIN32_ERROR(106u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERIAL_NO_DEVICE: WIN32_ERROR = WIN32_ERROR(1118u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVER_DISABLED: WIN32_ERROR = WIN32_ERROR(1341u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVER_HAS_OPEN_HANDLES: WIN32_ERROR = WIN32_ERROR(1811u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVER_NOT_DISABLED: WIN32_ERROR = WIN32_ERROR(1342u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVER_SERVICE_CALL_REQUIRES_SMB1: WIN32_ERROR = WIN32_ERROR(3023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVER_SHUTDOWN_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(1255u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVER_SID_MISMATCH: WIN32_ERROR = WIN32_ERROR(628u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVER_TRANSPORT_CONFLICT: WIN32_ERROR = WIN32_ERROR(816u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICES_FAILED_AUTOSTART: WIN32_ERROR = WIN32_ERROR(15405u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_ALREADY_RUNNING: WIN32_ERROR = WIN32_ERROR(1056u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_CANNOT_ACCEPT_CTRL: WIN32_ERROR = WIN32_ERROR(1061u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_DATABASE_LOCKED: WIN32_ERROR = WIN32_ERROR(1055u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_DEPENDENCY_DELETED: WIN32_ERROR = WIN32_ERROR(1075u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_DEPENDENCY_FAIL: WIN32_ERROR = WIN32_ERROR(1068u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_DISABLED: WIN32_ERROR = WIN32_ERROR(1058u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(1060u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_EXISTS: WIN32_ERROR = WIN32_ERROR(1073u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_EXISTS_AS_NON_PACKAGED_SERVICE: WIN32_ERROR = WIN32_ERROR(15655u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_IS_PAUSED: u32 = 928u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_LOGON_FAILED: WIN32_ERROR = WIN32_ERROR(1069u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_MARKED_FOR_DELETE: WIN32_ERROR = WIN32_ERROR(1072u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_NEVER_STARTED: WIN32_ERROR = WIN32_ERROR(1077u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_NOTIFICATION: WIN32_ERROR = WIN32_ERROR(716u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_NOTIFY_CLIENT_LAGGING: WIN32_ERROR = WIN32_ERROR(1294u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_NOT_ACTIVE: WIN32_ERROR = WIN32_ERROR(1062u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1243u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_NOT_IN_EXE: WIN32_ERROR = WIN32_ERROR(1083u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_NO_THREAD: WIN32_ERROR = WIN32_ERROR(1054u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_REQUEST_TIMEOUT: WIN32_ERROR = WIN32_ERROR(1053u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_SPECIFIC_ERROR: WIN32_ERROR = WIN32_ERROR(1066u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SERVICE_START_HANG: WIN32_ERROR = WIN32_ERROR(1070u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SESSION_CREDENTIAL_CONFLICT: WIN32_ERROR = WIN32_ERROR(1219u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SESSION_KEY_TOO_SHORT: WIN32_ERROR = WIN32_ERROR(501u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SETCOUNT_ON_BAD_LB: WIN32_ERROR = WIN32_ERROR(1433u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SETMARK_DETECTED: WIN32_ERROR = WIN32_ERROR(1103u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SET_CONTEXT_DENIED: WIN32_ERROR = WIN32_ERROR(1660u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SET_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(1170u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SET_POWER_STATE_FAILED: WIN32_ERROR = WIN32_ERROR(1141u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SET_POWER_STATE_VETOED: WIN32_ERROR = WIN32_ERROR(1140u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHARED_POLICY: WIN32_ERROR = WIN32_ERROR(8218u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHARING_BUFFER_EXCEEDED: WIN32_ERROR = WIN32_ERROR(36u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHARING_PAUSED: WIN32_ERROR = WIN32_ERROR(70u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHARING_VIOLATION: WIN32_ERROR = WIN32_ERROR(32u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME: WIN32_ERROR = WIN32_ERROR(305u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHUTDOWN_CLUSTER: WIN32_ERROR = WIN32_ERROR(5008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHUTDOWN_DISKS_NOT_IN_MAINTENANCE_MODE: WIN32_ERROR = WIN32_ERROR(1192u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHUTDOWN_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(1115u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHUTDOWN_IS_SCHEDULED: WIN32_ERROR = WIN32_ERROR(1190u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SHUTDOWN_USERS_LOGGED_ON: WIN32_ERROR = WIN32_ERROR(1191u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SIGNAL_PENDING: WIN32_ERROR = WIN32_ERROR(162u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SIGNAL_REFUSED: WIN32_ERROR = WIN32_ERROR(156u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SIGNED_PACKAGE_INVALID_PUBLISHER_NAMESPACE: WIN32_ERROR = WIN32_ERROR(15661u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SINGLETON_RESOURCE_INSTALLED_IN_ACTIVE_USER: WIN32_ERROR = WIN32_ERROR(15653u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SINGLE_INSTANCE_APP: WIN32_ERROR = WIN32_ERROR(1152u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMARTCARD_SUBSYSTEM_FAILURE: WIN32_ERROR = WIN32_ERROR(1264u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMB1_NOT_AVAILABLE: WIN32_ERROR = WIN32_ERROR(384u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMB_BAD_CLUSTER_DIALECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067646975i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMB_GUEST_LOGON_BLOCKED: WIN32_ERROR = WIN32_ERROR(1272u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067646976i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMB_NO_SIGNING_ALGORITHM_OVERLAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067646974i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMI_PRIMITIVE_INSTALLER_FAILED: WIN32_ERROR = WIN32_ERROR(14108u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SMR_GARBAGE_COLLECTION_REQUIRED: WIN32_ERROR = WIN32_ERROR(4445u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SOME_NOT_MAPPED: WIN32_ERROR = WIN32_ERROR(1301u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SOURCE_ELEMENT_EMPTY: WIN32_ERROR = WIN32_ERROR(1160u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_ALLOCATION_SIZE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344818i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_CACHE_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344794i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_CORRUPT_METADATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_DRIVE_LOST_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344801i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_DRIVE_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344803i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_DRIVE_OPERATIONAL_STATE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_DRIVE_REDUNDANCY_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344826i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_DRIVE_SECTOR_SIZE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344828i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_DRIVE_SPLIT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344802i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_DRT_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344807i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_ENCLOSURE_AWARE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344817i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_ENTRY_INCOMPLETE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344813i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_ENTRY_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344812i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_EXTENDED_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344820i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_FAULT_DOMAIN_TYPE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344831i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_FLUSH_METADATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344795i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_INCONSISTENCY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344806i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_INTERLEAVE_LENGTH_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344823i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344830i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_LOG_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344805i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_MAP_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_MARK_DIRTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344800i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_NOT_ENOUGH_DRIVES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344821i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_NO_REDUNDANCY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344804i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_NUMBER_OF_COLUMNS_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344822i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_NUMBER_OF_DATA_COPIES_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344825i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_NUMBER_OF_GROUPS_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_PARITY_LAYOUT_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344824i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_POOL_WAS_DELETED: ::windows_core::HRESULT = ::windows_core::HRESULT(15138817i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_PROVISIONING_TYPE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_REPAIR_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344793i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_RESILIENCY_TYPE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344829i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_UNSUPPORTED_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344809i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_UPDATE_COLUMN_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344811i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPACES_WRITE_CACHE_SIZE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2132344816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPARSE_FILE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(490u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION: WIN32_ERROR = WIN32_ERROR(6844u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPECIAL_ACCOUNT: WIN32_ERROR = WIN32_ERROR(1371u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPECIAL_GROUP: WIN32_ERROR = WIN32_ERROR(1372u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPECIAL_USER: WIN32_ERROR = WIN32_ERROR(1373u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPL_NO_ADDJOB: WIN32_ERROR = WIN32_ERROR(3004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPL_NO_STARTDOC: WIN32_ERROR = WIN32_ERROR(3003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SPOOL_FILE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SRC_SRV_DLL_LOAD_FAILED: WIN32_ERROR = WIN32_ERROR(428u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STACK_BUFFER_OVERRUN: WIN32_ERROR = WIN32_ERROR(1282u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STACK_OVERFLOW: WIN32_ERROR = WIN32_ERROR(1001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STACK_OVERFLOW_READ: WIN32_ERROR = WIN32_ERROR(599u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STAGEFROMUPDATEAGENT_PACKAGE_NOT_APPLICABLE: WIN32_ERROR = WIN32_ERROR(15668u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(15815u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(15818u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_CREATE_CONTAINER_FAILED: WIN32_ERROR = WIN32_ERROR(15805u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_DELETE_CONTAINER_FAILED: WIN32_ERROR = WIN32_ERROR(15806u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_DELETE_SETTING_FAILED: WIN32_ERROR = WIN32_ERROR(15809u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_ENUMERATE_CONTAINER_FAILED: WIN32_ERROR = WIN32_ERROR(15813u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_ENUMERATE_SETTINGS_FAILED: WIN32_ERROR = WIN32_ERROR(15814u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_GET_VERSION_FAILED: WIN32_ERROR = WIN32_ERROR(15801u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_LOAD_STORE_FAILED: WIN32_ERROR = WIN32_ERROR(15800u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_OPEN_CONTAINER_FAILED: WIN32_ERROR = WIN32_ERROR(15804u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_QUERY_SETTING_FAILED: WIN32_ERROR = WIN32_ERROR(15810u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_READ_COMPOSITE_SETTING_FAILED: WIN32_ERROR = WIN32_ERROR(15811u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_READ_SETTING_FAILED: WIN32_ERROR = WIN32_ERROR(15807u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(15817u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(15816u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_SET_VERSION_FAILED: WIN32_ERROR = WIN32_ERROR(15802u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_STRUCTURED_RESET_FAILED: WIN32_ERROR = WIN32_ERROR(15803u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_WRITE_COMPOSITE_SETTING_FAILED: WIN32_ERROR = WIN32_ERROR(15812u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATE_WRITE_SETTING_FAILED: WIN32_ERROR = WIN32_ERROR(15808u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STATIC_INIT: WIN32_ERROR = WIN32_ERROR(4002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STOPPED_ON_SYMLINK: WIN32_ERROR = WIN32_ERROR(681u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STORAGE_LOST_DATA_PERSISTENCE: WIN32_ERROR = WIN32_ERROR(368u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STORAGE_RESERVE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(418u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STORAGE_RESERVE_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(417u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STORAGE_RESERVE_ID_INVALID: WIN32_ERROR = WIN32_ERROR(416u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STORAGE_RESERVE_NOT_EMPTY: WIN32_ERROR = WIN32_ERROR(419u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STORAGE_STACK_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(472u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STORAGE_TOPOLOGY_ID_MISMATCH: WIN32_ERROR = WIN32_ERROR(345u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STREAM_MINIVERSION_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(6808u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STREAM_MINIVERSION_NOT_VALID: WIN32_ERROR = WIN32_ERROR(6809u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_STRICT_CFG_VIOLATION: WIN32_ERROR = WIN32_ERROR(1657u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SUBST_TO_JOIN: WIN32_ERROR = WIN32_ERROR(141u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SUBST_TO_SUBST: WIN32_ERROR = WIN32_ERROR(139u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SUCCESS: WIN32_ERROR = WIN32_ERROR(0u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SUCCESS_REBOOT_INITIATED: WIN32_ERROR = WIN32_ERROR(1641u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SUCCESS_REBOOT_REQUIRED: WIN32_ERROR = WIN32_ERROR(3010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SUCCESS_RESTART_REQUIRED: WIN32_ERROR = WIN32_ERROR(3011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_ERROR_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647232i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_ERROR_STORED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067712512i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_NO_INITIATOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647221i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_RESERVATION_CONFLICT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647225i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_UNIT_ATTENTION_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647231i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647230i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647226i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647227i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647229i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647228i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_VERSION_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647223i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SVHDX_WRONG_FILE_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647224i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SWAPERROR: WIN32_ERROR = WIN32_ERROR(999u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_ACTIVATION_CONTEXT_DISABLED: WIN32_ERROR = WIN32_ERROR(14006u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT: WIN32_ERROR = WIN32_ERROR(14103u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_ASSEMBLY_MISSING: WIN32_ERROR = WIN32_ERROR(14081u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_ASSEMBLY_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(14003u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_ASSEMBLY_NOT_LOCKED: WIN32_ERROR = WIN32_ERROR(14097u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_CANT_GEN_ACTCTX: WIN32_ERROR = WIN32_ERROR(14001u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_COMPONENT_STORE_CORRUPT: WIN32_ERROR = WIN32_ERROR(14098u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_CORRUPTION: WIN32_ERROR = WIN32_ERROR(14083u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_CORRUPT_ACTIVATION_STACK: WIN32_ERROR = WIN32_ERROR(14082u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_ACTIVATABLE_CLASS: WIN32_ERROR = WIN32_ERROR(14111u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_ASSEMBLY_NAME: WIN32_ERROR = WIN32_ERROR(14027u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_CLSID: WIN32_ERROR = WIN32_ERROR(14023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_DLL_NAME: WIN32_ERROR = WIN32_ERROR(14021u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_IID: WIN32_ERROR = WIN32_ERROR(14024u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_PROGID: WIN32_ERROR = WIN32_ERROR(14026u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_TLBID: WIN32_ERROR = WIN32_ERROR(14025u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME: WIN32_ERROR = WIN32_ERROR(14022u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_EARLY_DEACTIVATION: WIN32_ERROR = WIN32_ERROR(14084u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_FILE_HASH_MISMATCH: WIN32_ERROR = WIN32_ERROR(14028u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_FILE_HASH_MISSING: WIN32_ERROR = WIN32_ERROR(14110u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY: WIN32_ERROR = WIN32_ERROR(14104u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_IDENTITIES_DIFFERENT: WIN32_ERROR = WIN32_ERROR(14102u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE: WIN32_ERROR = WIN32_ERROR(14092u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_IDENTITY_PARSE_ERROR: WIN32_ERROR = WIN32_ERROR(14093u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN: WIN32_ERROR = WIN32_ERROR(14095u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INVALID_ACTCTXDATA_FORMAT: WIN32_ERROR = WIN32_ERROR(14002u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE: WIN32_ERROR = WIN32_ERROR(14017u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME: WIN32_ERROR = WIN32_ERROR(14080u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INVALID_DEACTIVATION: WIN32_ERROR = WIN32_ERROR(14085u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME: WIN32_ERROR = WIN32_ERROR(14091u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE: WIN32_ERROR = WIN32_ERROR(14090u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_INVALID_XML_NAMESPACE_URI: WIN32_ERROR = WIN32_ERROR(14014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_KEY_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(14007u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(14016u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MANIFEST_FORMAT_ERROR: WIN32_ERROR = WIN32_ERROR(14004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT: WIN32_ERROR = WIN32_ERROR(14101u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE: WIN32_ERROR = WIN32_ERROR(14019u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE: WIN32_ERROR = WIN32_ERROR(14018u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MANIFEST_PARSE_ERROR: WIN32_ERROR = WIN32_ERROR(14005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MANIFEST_TOO_BIG: WIN32_ERROR = WIN32_ERROR(14105u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE: WIN32_ERROR = WIN32_ERROR(14079u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_MULTIPLE_DEACTIVATION: WIN32_ERROR = WIN32_ERROR(14086u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_POLICY_PARSE_ERROR: WIN32_ERROR = WIN32_ERROR(14029u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT: WIN32_ERROR = WIN32_ERROR(14020u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET: WIN32_ERROR = WIN32_ERROR(14011u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_PROCESS_TERMINATION_REQUESTED: WIN32_ERROR = WIN32_ERROR(14087u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING: WIN32_ERROR = WIN32_ERROR(14078u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_PROTECTION_CATALOG_NOT_VALID: WIN32_ERROR = WIN32_ERROR(14076u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT: WIN32_ERROR = WIN32_ERROR(14075u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_PROTECTION_RECOVERY_FAILED: WIN32_ERROR = WIN32_ERROR(14074u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_RELEASE_ACTIVATION_CONTEXT: WIN32_ERROR = WIN32_ERROR(14088u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(14015u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_SECTION_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(14000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_SETTING_NOT_REGISTERED: WIN32_ERROR = WIN32_ERROR(14106u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY: WIN32_ERROR = WIN32_ERROR(14089u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_THREAD_QUERIES_DISABLED: WIN32_ERROR = WIN32_ERROR(14010u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE: WIN32_ERROR = WIN32_ERROR(14107u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_UNKNOWN_ENCODING: WIN32_ERROR = WIN32_ERROR(14013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_UNKNOWN_ENCODING_GROUP: WIN32_ERROR = WIN32_ERROR(14012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_UNTRANSLATABLE_HRESULT: WIN32_ERROR = WIN32_ERROR(14077u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_VERSION_CONFLICT: WIN32_ERROR = WIN32_ERROR(14008u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_WRONG_SECTION_TYPE: WIN32_ERROR = WIN32_ERROR(14009u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_BADCHARDATA: WIN32_ERROR = WIN32_ERROR(14036u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_BADCHARINSTRING: WIN32_ERROR = WIN32_ERROR(14034u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_BADNAMECHAR: WIN32_ERROR = WIN32_ERROR(14033u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_BADPEREFINSUBSET: WIN32_ERROR = WIN32_ERROR(14059u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_BADSTARTNAMECHAR: WIN32_ERROR = WIN32_ERROR(14032u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_BADXMLCASE: WIN32_ERROR = WIN32_ERROR(14069u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_BADXMLDECL: WIN32_ERROR = WIN32_ERROR(14056u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_COMMENTSYNTAX: WIN32_ERROR = WIN32_ERROR(14031u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_DUPLICATEATTRIBUTE: WIN32_ERROR = WIN32_ERROR(14053u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE: WIN32_ERROR = WIN32_ERROR(14045u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_EXPECTINGTAGEND: WIN32_ERROR = WIN32_ERROR(14038u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INCOMPLETE_ENCODING: WIN32_ERROR = WIN32_ERROR(14043u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INTERNALERROR: WIN32_ERROR = WIN32_ERROR(14041u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALIDATROOTLEVEL: WIN32_ERROR = WIN32_ERROR(14055u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALIDENCODING: WIN32_ERROR = WIN32_ERROR(14067u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALIDSWITCH: WIN32_ERROR = WIN32_ERROR(14068u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALID_DECIMAL: WIN32_ERROR = WIN32_ERROR(14047u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALID_HEXIDECIMAL: WIN32_ERROR = WIN32_ERROR(14048u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALID_STANDALONE: WIN32_ERROR = WIN32_ERROR(14070u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALID_UNICODE: WIN32_ERROR = WIN32_ERROR(14049u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_INVALID_VERSION: WIN32_ERROR = WIN32_ERROR(14072u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MISSINGEQUALS: WIN32_ERROR = WIN32_ERROR(14073u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MISSINGQUOTE: WIN32_ERROR = WIN32_ERROR(14030u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MISSINGROOT: WIN32_ERROR = WIN32_ERROR(14057u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MISSINGSEMICOLON: WIN32_ERROR = WIN32_ERROR(14039u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MISSINGWHITESPACE: WIN32_ERROR = WIN32_ERROR(14037u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MISSING_PAREN: WIN32_ERROR = WIN32_ERROR(14044u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MULTIPLEROOTS: WIN32_ERROR = WIN32_ERROR(14054u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_MULTIPLE_COLONS: WIN32_ERROR = WIN32_ERROR(14046u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_RESERVEDNAMESPACE: WIN32_ERROR = WIN32_ERROR(14066u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNBALANCEDPAREN: WIN32_ERROR = WIN32_ERROR(14040u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNCLOSEDCDATA: WIN32_ERROR = WIN32_ERROR(14065u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNCLOSEDCOMMENT: WIN32_ERROR = WIN32_ERROR(14063u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNCLOSEDDECL: WIN32_ERROR = WIN32_ERROR(14064u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNCLOSEDENDTAG: WIN32_ERROR = WIN32_ERROR(14061u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNCLOSEDSTARTTAG: WIN32_ERROR = WIN32_ERROR(14060u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNCLOSEDSTRING: WIN32_ERROR = WIN32_ERROR(14062u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNCLOSEDTAG: WIN32_ERROR = WIN32_ERROR(14052u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNEXPECTEDENDTAG: WIN32_ERROR = WIN32_ERROR(14051u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNEXPECTEDEOF: WIN32_ERROR = WIN32_ERROR(14058u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNEXPECTED_STANDALONE: WIN32_ERROR = WIN32_ERROR(14071u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE: WIN32_ERROR = WIN32_ERROR(14042u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK: WIN32_ERROR = WIN32_ERROR(14050u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SXS_XML_E_XMLDECLSYNTAX: WIN32_ERROR = WIN32_ERROR(14035u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYMLINK_CLASS_DISABLED: WIN32_ERROR = WIN32_ERROR(1463u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYMLINK_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(1464u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYNCHRONIZATION_REQUIRED: WIN32_ERROR = WIN32_ERROR(569u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED: WIN32_ERROR = WIN32_ERROR(1274u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_DEVICE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(15299u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_HIVE_TOO_LARGE: WIN32_ERROR = WIN32_ERROR(653u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_IMAGE_BAD_SIGNATURE: WIN32_ERROR = WIN32_ERROR(637u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_INVALID_POLICY: WIN32_ERROR = WIN32_ERROR(4552u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED: WIN32_ERROR = WIN32_ERROR(4553u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_POLICY_VIOLATION: WIN32_ERROR = WIN32_ERROR(4551u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_REPUTATION_DANGEROUS_EXT: WIN32_ERROR = WIN32_ERROR(4558u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_REPUTATION_MALICIOUS: WIN32_ERROR = WIN32_ERROR(4556u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_REPUTATION_OFFLINE: WIN32_ERROR = WIN32_ERROR(4559u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_REPUTATION_PUA: WIN32_ERROR = WIN32_ERROR(4557u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_REPUTATION_UNATTAINABLE: WIN32_ERROR = WIN32_ERROR(4581u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_REPUTATION_UNFRIENDLY_FILE: WIN32_ERROR = WIN32_ERROR(4580u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_ROLLBACK_DETECTED: WIN32_ERROR = WIN32_ERROR(4550u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_SUPPLEMENTAL_POLICY_NOT_AUTHORIZED: WIN32_ERROR = WIN32_ERROR(4555u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_INTEGRITY_TOO_MANY_POLICIES: WIN32_ERROR = WIN32_ERROR(4554u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_NEEDS_REMEDIATION: WIN32_ERROR = WIN32_ERROR(15623u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION: WIN32_ERROR = WIN32_ERROR(783u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_POWERSTATE_TRANSITION: WIN32_ERROR = WIN32_ERROR(782u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_PROCESS_TERMINATED: WIN32_ERROR = WIN32_ERROR(591u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_SHUTDOWN: WIN32_ERROR = WIN32_ERROR(641u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_SYSTEM_TRACE: WIN32_ERROR = WIN32_ERROR(150u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TAG_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(2012u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TAG_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(2013u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_THREAD_1_INACTIVE: WIN32_ERROR = WIN32_ERROR(210u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_THREAD_ALREADY_IN_TASK: WIN32_ERROR = WIN32_ERROR(1552u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_THREAD_MODE_ALREADY_BACKGROUND: WIN32_ERROR = WIN32_ERROR(400u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_THREAD_MODE_NOT_BACKGROUND: WIN32_ERROR = WIN32_ERROR(401u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_THREAD_NOT_IN_PROCESS: WIN32_ERROR = WIN32_ERROR(566u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_THREAD_WAS_SUSPENDED: WIN32_ERROR = WIN32_ERROR(699u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_ALREADY_PROCESSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898426i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_CANNOT_PIN_OBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898425i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_FILE_IS_NOT_PINNED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898424i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_INVALID_FILE_ID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898428i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_NOT_SUPPORTED_ON_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898431i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_STORAGE_TIER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898429i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_VOLUME_DISMOUNT_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898430i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIERING_WRONG_CLUSTER_NODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138898427i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIMEOUT: WIN32_ERROR = WIN32_ERROR(1460u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIMER_NOT_CANCELED: WIN32_ERROR = WIN32_ERROR(541u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIMER_RESOLUTION_NOT_SET: WIN32_ERROR = WIN32_ERROR(607u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIMER_RESUME_IGNORED: WIN32_ERROR = WIN32_ERROR(722u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIME_SENSITIVE_THREAD: WIN32_ERROR = WIN32_ERROR(422u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TIME_SKEW: WIN32_ERROR = WIN32_ERROR(1398u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TLW_WITH_WSCHILD: WIN32_ERROR = WIN32_ERROR(1406u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TM_IDENTITY_MISMATCH: WIN32_ERROR = WIN32_ERROR(6845u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TM_INITIALIZATION_FAILED: WIN32_ERROR = WIN32_ERROR(6706u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TM_VOLATILE: WIN32_ERROR = WIN32_ERROR(6828u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOKEN_ALREADY_IN_USE: WIN32_ERROR = WIN32_ERROR(1375u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_CMDS: WIN32_ERROR = WIN32_ERROR(56u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_CONTEXT_IDS: WIN32_ERROR = WIN32_ERROR(1384u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_DESCRIPTORS: WIN32_ERROR = WIN32_ERROR(331u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_LINKS: WIN32_ERROR = WIN32_ERROR(1142u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_LUIDS_REQUESTED: WIN32_ERROR = WIN32_ERROR(1333u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_MODULES: WIN32_ERROR = WIN32_ERROR(214u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_MUXWAITERS: WIN32_ERROR = WIN32_ERROR(152u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_NAMES: WIN32_ERROR = WIN32_ERROR(68u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_OPEN_FILES: WIN32_ERROR = WIN32_ERROR(4u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_POSTS: WIN32_ERROR = WIN32_ERROR(298u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_SECRETS: WIN32_ERROR = WIN32_ERROR(1381u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_SEMAPHORES: WIN32_ERROR = WIN32_ERROR(100u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_SEM_REQUESTS: WIN32_ERROR = WIN32_ERROR(103u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_SESS: WIN32_ERROR = WIN32_ERROR(69u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_SIDS: WIN32_ERROR = WIN32_ERROR(1389u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_TCBS: WIN32_ERROR = WIN32_ERROR(155u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TOO_MANY_THREADS: WIN32_ERROR = WIN32_ERROR(565u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE: WIN32_ERROR = WIN32_ERROR(6834u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONAL_CONFLICT: WIN32_ERROR = WIN32_ERROR(6800u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED: WIN32_ERROR = WIN32_ERROR(6832u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH: WIN32_ERROR = WIN32_ERROR(6727u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONMANAGER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(6718u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONMANAGER_NOT_ONLINE: WIN32_ERROR = WIN32_ERROR(6719u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION: WIN32_ERROR = WIN32_ERROR(6720u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONS_NOT_FROZEN: WIN32_ERROR = WIN32_ERROR(6839u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE: WIN32_ERROR = WIN32_ERROR(6805u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_ALREADY_ABORTED: WIN32_ERROR = WIN32_ERROR(6704u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_ALREADY_COMMITTED: WIN32_ERROR = WIN32_ERROR(6705u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_FREEZE_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(6840u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_INTEGRITY_VIOLATED: WIN32_ERROR = WIN32_ERROR(6726u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER: WIN32_ERROR = WIN32_ERROR(6713u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_MUST_WRITETHROUGH: WIN32_ERROR = WIN32_ERROR(6729u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_NOT_ACTIVE: WIN32_ERROR = WIN32_ERROR(6701u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_NOT_ENLISTED: WIN32_ERROR = WIN32_ERROR(6855u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(6715u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_NOT_JOINED: WIN32_ERROR = WIN32_ERROR(6708u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_NOT_REQUESTED: WIN32_ERROR = WIN32_ERROR(6703u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_NOT_ROOT: WIN32_ERROR = WIN32_ERROR(6721u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_NO_SUPERIOR: WIN32_ERROR = WIN32_ERROR(6730u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_OBJECT_EXPIRED: WIN32_ERROR = WIN32_ERROR(6722u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_PROPAGATION_FAILED: WIN32_ERROR = WIN32_ERROR(6711u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_RECORD_TOO_LONG: WIN32_ERROR = WIN32_ERROR(6724u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_REQUEST_NOT_VALID: WIN32_ERROR = WIN32_ERROR(6702u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_REQUIRED_PROMOTION: WIN32_ERROR = WIN32_ERROR(6837u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED: WIN32_ERROR = WIN32_ERROR(6723u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET: WIN32_ERROR = WIN32_ERROR(6836u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSACTION_SUPERIOR_EXISTS: WIN32_ERROR = WIN32_ERROR(6709u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSFORM_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(2004u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSLATION_COMPLETE: WIN32_ERROR = WIN32_ERROR(757u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRANSPORT_FULL: WIN32_ERROR = WIN32_ERROR(4328u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRUSTED_DOMAIN_FAILURE: WIN32_ERROR = WIN32_ERROR(1788u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRUSTED_RELATIONSHIP_FAILURE: WIN32_ERROR = WIN32_ERROR(1789u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TRUST_FAILURE: WIN32_ERROR = WIN32_ERROR(1790u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TS_INCOMPATIBLE_SESSIONS: WIN32_ERROR = WIN32_ERROR(7069u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TS_VIDEO_SUBSYSTEM_ERROR: WIN32_ERROR = WIN32_ERROR(7070u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TXF_ATTRIBUTE_CORRUPT: WIN32_ERROR = WIN32_ERROR(6830u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TXF_DIR_NOT_EMPTY: WIN32_ERROR = WIN32_ERROR(6826u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_TXF_METADATA_ALREADY_PRESENT: WIN32_ERROR = WIN32_ERROR(6835u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_CLEAN: WIN32_ERROR = WIN32_ERROR(4311u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA: WIN32_ERROR = WIN32_ERROR(4330u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_INVENTORY_DRIVE: WIN32_ERROR = WIN32_ERROR(4325u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_INVENTORY_SLOT: WIN32_ERROR = WIN32_ERROR(4326u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_INVENTORY_TRANSPORT: WIN32_ERROR = WIN32_ERROR(4327u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_LOAD_MEDIUM: WIN32_ERROR = WIN32_ERROR(4324u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_LOCK_MEDIA: WIN32_ERROR = WIN32_ERROR(1108u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_MOVE_REPLACEMENT: WIN32_ERROR = WIN32_ERROR(1176u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_MOVE_REPLACEMENT_2: WIN32_ERROR = WIN32_ERROR(1177u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_REMOVE_REPLACED: WIN32_ERROR = WIN32_ERROR(1175u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNABLE_TO_UNLOAD_MEDIA: WIN32_ERROR = WIN32_ERROR(1109u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNDEFINED_CHARACTER: WIN32_ERROR = WIN32_ERROR(583u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNDEFINED_SCOPE: WIN32_ERROR = WIN32_ERROR(319u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNEXPECTED_MM_CREATE_ERR: WIN32_ERROR = WIN32_ERROR(556u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNEXPECTED_MM_EXTEND_ERR: WIN32_ERROR = WIN32_ERROR(558u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNEXPECTED_MM_MAP_ERROR: WIN32_ERROR = WIN32_ERROR(557u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNEXPECTED_NTCACHEMANAGER_ERROR: WIN32_ERROR = WIN32_ERROR(443u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNEXPECTED_OMID: WIN32_ERROR = WIN32_ERROR(4334u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNEXP_NET_ERR: WIN32_ERROR = WIN32_ERROR(59u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNHANDLED_EXCEPTION: WIN32_ERROR = WIN32_ERROR(574u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNIDENTIFIED_ERROR: WIN32_ERROR = WIN32_ERROR(1287u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_COMPONENT: WIN32_ERROR = WIN32_ERROR(1607u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_FEATURE: WIN32_ERROR = WIN32_ERROR(1606u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PATCH: WIN32_ERROR = WIN32_ERROR(1647u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PORT: WIN32_ERROR = WIN32_ERROR(1796u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PRINTER_DRIVER: WIN32_ERROR = WIN32_ERROR(1797u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PRINTPROCESSOR: WIN32_ERROR = WIN32_ERROR(1798u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PRINT_MONITOR: WIN32_ERROR = WIN32_ERROR(3000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PRODUCT: WIN32_ERROR = WIN32_ERROR(1605u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PROPERTY: WIN32_ERROR = WIN32_ERROR(1608u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_PROTOCOL_ID: u32 = 902u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNKNOWN_REVISION: WIN32_ERROR = WIN32_ERROR(1305u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNMAPPED_SUBSTITUTION_STRING: WIN32_ERROR = WIN32_ERROR(14096u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNRECOGNIZED_MEDIA: WIN32_ERROR = WIN32_ERROR(1785u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNRECOGNIZED_VOLUME: WIN32_ERROR = WIN32_ERROR(1005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNSATISFIED_DEPENDENCIES: WIN32_ERROR = WIN32_ERROR(441u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNSIGNED_PACKAGE_INVALID_CONTENT: WIN32_ERROR = WIN32_ERROR(15659u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNSIGNED_PACKAGE_INVALID_PUBLISHER_NAMESPACE: WIN32_ERROR = WIN32_ERROR(15660u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNSUPPORTED_COMPRESSION: WIN32_ERROR = WIN32_ERROR(618u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNSUPPORTED_TYPE: WIN32_ERROR = WIN32_ERROR(1630u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNTRUSTED_MOUNT_POINT: WIN32_ERROR = WIN32_ERROR(448u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNWIND: WIN32_ERROR = WIN32_ERROR(542u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UNWIND_CONSOLIDATE: WIN32_ERROR = WIN32_ERROR(684u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_UPDATE_IN_PROGRESS: u32 = 911u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_USER_APC: WIN32_ERROR = WIN32_ERROR(737u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED: WIN32_ERROR = WIN32_ERROR(1934u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_USER_EXISTS: WIN32_ERROR = WIN32_ERROR(1316u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_USER_LIMIT: u32 = 937u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_USER_MAPPED_FILE: WIN32_ERROR = WIN32_ERROR(1224u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_USER_PROFILE_LOAD: WIN32_ERROR = WIN32_ERROR(500u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VALIDATE_CONTINUE: WIN32_ERROR = WIN32_ERROR(625u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VC_DISCONNECTED: WIN32_ERROR = WIN32_ERROR(240u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VDM_DISALLOWED: WIN32_ERROR = WIN32_ERROR(1286u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VDM_HARD_ERROR: WIN32_ERROR = WIN32_ERROR(593u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VERIFIER_STOP: WIN32_ERROR = WIN32_ERROR(537u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VERSION_PARSE_ERROR: WIN32_ERROR = WIN32_ERROR(777u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHDSET_BACKING_STORAGE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647220i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE: WIN32_ERROR = WIN32_ERROR(3225026599u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_BITMAP_MISMATCH: WIN32_ERROR = WIN32_ERROR(3225026572u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_BLOCK_ALLOCATION_FAILURE: WIN32_ERROR = WIN32_ERROR(3225026569u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT: WIN32_ERROR = WIN32_ERROR(3225026570u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_CHANGE_TRACKING_DISABLED: WIN32_ERROR = WIN32_ERROR(3225026602u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_CHILD_PARENT_ID_MISMATCH: WIN32_ERROR = WIN32_ERROR(3225026574u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_CHILD_PARENT_SIZE_MISMATCH: WIN32_ERROR = WIN32_ERROR(3225026583u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH: WIN32_ERROR = WIN32_ERROR(3225026575u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE: WIN32_ERROR = WIN32_ERROR(3225026598u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED: WIN32_ERROR = WIN32_ERROR(3225026584u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT: WIN32_ERROR = WIN32_ERROR(3225026585u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH: WIN32_ERROR = WIN32_ERROR(3225026562u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_DRIVE_FOOTER_CORRUPT: WIN32_ERROR = WIN32_ERROR(3225026563u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_DRIVE_FOOTER_MISSING: WIN32_ERROR = WIN32_ERROR(3225026561u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_FORMAT_UNKNOWN: WIN32_ERROR = WIN32_ERROR(3225026564u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_FORMAT_UNSUPPORTED_VERSION: WIN32_ERROR = WIN32_ERROR(3225026565u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_INVALID_BLOCK_SIZE: WIN32_ERROR = WIN32_ERROR(3225026571u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_INVALID_CHANGE_TRACKING_ID: WIN32_ERROR = WIN32_ERROR(3225026601u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_INVALID_FILE_SIZE: WIN32_ERROR = WIN32_ERROR(3225026579u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_INVALID_SIZE: WIN32_ERROR = WIN32_ERROR(3225026578u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_INVALID_STATE: WIN32_ERROR = WIN32_ERROR(3225026588u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_INVALID_TYPE: WIN32_ERROR = WIN32_ERROR(3225026587u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_METADATA_FULL: WIN32_ERROR = WIN32_ERROR(3225026600u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_METADATA_READ_FAILURE: WIN32_ERROR = WIN32_ERROR(3225026576u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_METADATA_WRITE_FAILURE: WIN32_ERROR = WIN32_ERROR(3225026577u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_MISSING_CHANGE_TRACKING_INFORMATION: WIN32_ERROR = WIN32_ERROR(3225026608u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_PARENT_VHD_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(3225026582u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_PARENT_VHD_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3225026573u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_RESIZE_WOULD_TRUNCATE_DATA: WIN32_ERROR = WIN32_ERROR(3225026597u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_SHARED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1067647222i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH: WIN32_ERROR = WIN32_ERROR(3225026566u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_SPARSE_HEADER_CORRUPT: WIN32_ERROR = WIN32_ERROR(3225026568u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION: WIN32_ERROR = WIN32_ERROR(3225026567u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_CHILD_GPA_PAGE_SET_CORRUPTED: WIN32_ERROR = WIN32_ERROR(3224829966u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_DUPLICATE_HANDLER: WIN32_ERROR = WIN32_ERROR(3224829953u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT: WIN32_ERROR = WIN32_ERROR(3224829982u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT: WIN32_ERROR = WIN32_ERROR(3224829964u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_HANDLER_NOT_PRESENT: WIN32_ERROR = WIN32_ERROR(3224829956u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INSUFFICIENT_RESOURCES_HV_DEPOSIT: WIN32_ERROR = WIN32_ERROR(3224829997u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INSUFFICIENT_RESOURCES_PHYSICAL_BUFFER: WIN32_ERROR = WIN32_ERROR(3224829996u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INSUFFICIENT_RESOURCES_RESERVE: WIN32_ERROR = WIN32_ERROR(3224829995u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INSUFFICIENT_RESOURCES_WITHDRAW: WIN32_ERROR = WIN32_ERROR(3224829999u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_CHILD_GPA_PAGE_SET: WIN32_ERROR = WIN32_ERROR(3224829986u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_GPA_RANGE_HANDLE: WIN32_ERROR = WIN32_ERROR(3224829973u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_MEMORY_BLOCK_HANDLE: WIN32_ERROR = WIN32_ERROR(3224829970u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_MESSAGE_QUEUE_HANDLE: WIN32_ERROR = WIN32_ERROR(3224829972u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_NUMA_NODE_INDEX: WIN32_ERROR = WIN32_ERROR(3224829968u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_NUMA_SETTINGS: WIN32_ERROR = WIN32_ERROR(3224829967u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_OBJECT_NAME: WIN32_ERROR = WIN32_ERROR(3224829957u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_PPM_HANDLE: WIN32_ERROR = WIN32_ERROR(3224829976u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_INVALID_PROCESSOR_STATE: WIN32_ERROR = WIN32_ERROR(3224829981u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_KM_INTERFACE_ALREADY_INITIALIZED: WIN32_ERROR = WIN32_ERROR(3224829983u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MBPS_ARE_LOCKED: WIN32_ERROR = WIN32_ERROR(3224829977u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE: WIN32_ERROR = WIN32_ERROR(3224829989u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MBP_COUNT_EXCEEDED_LIMIT: WIN32_ERROR = WIN32_ERROR(3224829990u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MB_PROPERTY_ALREADY_SET_RESET: WIN32_ERROR = WIN32_ERROR(3224829984u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MB_STILL_REFERENCED: WIN32_ERROR = WIN32_ERROR(3224829965u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(3224829975u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MEMORY_TYPE_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(3224829998u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MESSAGE_QUEUE_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(3224829963u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MESSAGE_QUEUE_CLOSED: WIN32_ERROR = WIN32_ERROR(3224829978u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MESSAGE_QUEUE_NAME_TOO_LONG: WIN32_ERROR = WIN32_ERROR(3224829959u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_MMIO_RANGE_DESTROYED: WIN32_ERROR = WIN32_ERROR(3224829985u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED: WIN32_ERROR = WIN32_ERROR(3224829969u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE: WIN32_ERROR = WIN32_ERROR(3224829974u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_PAGE_RANGE_OVERFLOW: WIN32_ERROR = WIN32_ERROR(3224829971u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_PARTITION_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(3224829960u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_PARTITION_DOES_NOT_EXIST: WIN32_ERROR = WIN32_ERROR(3224829961u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_PARTITION_NAME_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3224829962u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_PARTITION_NAME_TOO_LONG: WIN32_ERROR = WIN32_ERROR(3224829958u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_PROCESS_ALREADY_SET: WIN32_ERROR = WIN32_ERROR(3224830000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_QUEUE_FULL: WIN32_ERROR = WIN32_ERROR(3224829955u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED: WIN32_ERROR = WIN32_ERROR(2151088129u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_RESERVE_PAGE_SET_IS_BEING_USED: WIN32_ERROR = WIN32_ERROR(3224829987u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_RESERVE_PAGE_SET_TOO_SMALL: WIN32_ERROR = WIN32_ERROR(3224829988u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_SAVED_STATE_CORRUPT: WIN32_ERROR = WIN32_ERROR(3224829991u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_SAVED_STATE_INCOMPATIBLE: WIN32_ERROR = WIN32_ERROR(3224829993u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_SAVED_STATE_UNRECOGNIZED_ITEM: WIN32_ERROR = WIN32_ERROR(3224829992u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_STOP_PENDING: WIN32_ERROR = WIN32_ERROR(3224829980u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_TOO_MANY_HANDLERS: WIN32_ERROR = WIN32_ERROR(3224829954u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED: WIN32_ERROR = WIN32_ERROR(3224829979u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VID_VTL_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(3224829994u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRTDISK_DISK_ALREADY_OWNED: WIN32_ERROR = WIN32_ERROR(3225026590u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRTDISK_DISK_ONLINE_AND_WRITABLE: WIN32_ERROR = WIN32_ERROR(3225026591u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRTDISK_NOT_VIRTUAL_DISK: WIN32_ERROR = WIN32_ERROR(3225026581u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRTDISK_PROVIDER_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3225026580u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE: WIN32_ERROR = WIN32_ERROR(3225026589u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRTUAL_DISK_LIMITATION: WIN32_ERROR = WIN32_ERROR(3225026586u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRUS_DELETED: WIN32_ERROR = WIN32_ERROR(226u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VIRUS_INFECTED: WIN32_ERROR = WIN32_ERROR(225u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_CONNECTION_CLOSED: WIN32_ERROR = WIN32_ERROR(3224830218u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_CONNECT_FAILED: WIN32_ERROR = WIN32_ERROR(3224830216u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_HYPERV_NOT_INSTALLED: WIN32_ERROR = WIN32_ERROR(3224830210u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_IMAGE_MISMATCH: WIN32_ERROR = WIN32_ERROR(3224830209u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_INVALID_JSON: WIN32_ERROR = WIN32_ERROR(3224830221u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_INVALID_LAYER: WIN32_ERROR = WIN32_ERROR(3224830226u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_INVALID_STATE: WIN32_ERROR = WIN32_ERROR(3224830213u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_OPERATION_PENDING: WIN32_ERROR = WIN32_ERROR(3224830211u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_PROTOCOL_ERROR: WIN32_ERROR = WIN32_ERROR(3224830225u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_SYSTEM_ALREADY_EXISTS: WIN32_ERROR = WIN32_ERROR(3224830223u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_SYSTEM_ALREADY_STOPPED: WIN32_ERROR = WIN32_ERROR(3224830224u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_SYSTEM_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3224830222u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_TERMINATED: WIN32_ERROR = WIN32_ERROR(3224830215u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_TERMINATED_DURING_START: WIN32_ERROR = WIN32_ERROR(3224830208u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_TIMEOUT: WIN32_ERROR = WIN32_ERROR(3224830217u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_TOO_MANY_NOTIFICATIONS: WIN32_ERROR = WIN32_ERROR(3224830212u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_UNEXPECTED_EXIT: WIN32_ERROR = WIN32_ERROR(3224830214u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_UNKNOWN_MESSAGE: WIN32_ERROR = WIN32_ERROR(3224830219u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_UNSUPPORTED_PROTOCOL_VERSION: WIN32_ERROR = WIN32_ERROR(3224830220u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VMCOMPUTE_WINDOWS_INSIDER_REQUIRED: WIN32_ERROR = WIN32_ERROR(3224830227u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VNET_VIRTUAL_SWITCH_NAME_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3224830464u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_ALL_DISKS_FAILED: WIN32_ERROR = WIN32_ERROR(3224895529u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_BAD_BOOT_DISK: WIN32_ERROR = WIN32_ERROR(3224895567u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DATABASE_FULL: WIN32_ERROR = WIN32_ERROR(3224895489u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DIFFERENT_SECTOR_SIZE: WIN32_ERROR = WIN32_ERROR(3224895566u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_CONFIGURATION_CORRUPTED: WIN32_ERROR = WIN32_ERROR(3224895490u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC: WIN32_ERROR = WIN32_ERROR(3224895491u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME: WIN32_ERROR = WIN32_ERROR(3224895493u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_DUPLICATE: WIN32_ERROR = WIN32_ERROR(3224895494u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_DYNAMIC: WIN32_ERROR = WIN32_ERROR(3224895495u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_ID_INVALID: WIN32_ERROR = WIN32_ERROR(3224895496u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_INVALID: WIN32_ERROR = WIN32_ERROR(3224895497u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_LAST_VOTER: WIN32_ERROR = WIN32_ERROR(3224895498u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_LAYOUT_INVALID: WIN32_ERROR = WIN32_ERROR(3224895499u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS: WIN32_ERROR = WIN32_ERROR(3224895500u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED: WIN32_ERROR = WIN32_ERROR(3224895501u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL: WIN32_ERROR = WIN32_ERROR(3224895502u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS: WIN32_ERROR = WIN32_ERROR(3224895503u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS: WIN32_ERROR = WIN32_ERROR(3224895504u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_MISSING: WIN32_ERROR = WIN32_ERROR(3224895505u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_NOT_EMPTY: WIN32_ERROR = WIN32_ERROR(3224895506u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_NOT_ENOUGH_SPACE: WIN32_ERROR = WIN32_ERROR(3224895507u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_REVECTORING_FAILED: WIN32_ERROR = WIN32_ERROR(3224895508u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_SECTOR_SIZE_INVALID: WIN32_ERROR = WIN32_ERROR(3224895509u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_SET_NOT_CONTAINED: WIN32_ERROR = WIN32_ERROR(3224895510u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS: WIN32_ERROR = WIN32_ERROR(3224895511u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES: WIN32_ERROR = WIN32_ERROR(3224895512u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(3224895513u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_EXTENT_ALREADY_USED: WIN32_ERROR = WIN32_ERROR(3224895514u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_EXTENT_NOT_CONTIGUOUS: WIN32_ERROR = WIN32_ERROR(3224895515u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION: WIN32_ERROR = WIN32_ERROR(3224895516u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED: WIN32_ERROR = WIN32_ERROR(3224895517u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION: WIN32_ERROR = WIN32_ERROR(3224895518u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH: WIN32_ERROR = WIN32_ERROR(3224895519u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(3224895520u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_INCOMPLETE_DISK_MIGRATION: WIN32_ERROR = WIN32_ERROR(2151153666u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_INCOMPLETE_REGENERATION: WIN32_ERROR = WIN32_ERROR(2151153665u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_INTERLEAVE_LENGTH_INVALID: WIN32_ERROR = WIN32_ERROR(3224895521u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MAXIMUM_REGISTERED_USERS: WIN32_ERROR = WIN32_ERROR(3224895522u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MEMBER_INDEX_DUPLICATE: WIN32_ERROR = WIN32_ERROR(3224895524u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MEMBER_INDEX_INVALID: WIN32_ERROR = WIN32_ERROR(3224895525u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MEMBER_IN_SYNC: WIN32_ERROR = WIN32_ERROR(3224895523u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MEMBER_MISSING: WIN32_ERROR = WIN32_ERROR(3224895526u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MEMBER_NOT_DETACHED: WIN32_ERROR = WIN32_ERROR(3224895527u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MEMBER_REGENERATING: WIN32_ERROR = WIN32_ERROR(3224895528u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_MIRROR_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(3224895579u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NOTIFICATION_RESET: WIN32_ERROR = WIN32_ERROR(3224895532u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NOT_PRIMARY_PACK: WIN32_ERROR = WIN32_ERROR(3224895570u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NO_REGISTERED_USERS: WIN32_ERROR = WIN32_ERROR(3224895530u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NO_SUCH_USER: WIN32_ERROR = WIN32_ERROR(3224895531u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NO_VALID_LOG_COPIES: WIN32_ERROR = WIN32_ERROR(3224895576u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NUMBER_OF_DISKS_INVALID: WIN32_ERROR = WIN32_ERROR(3224895578u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID: WIN32_ERROR = WIN32_ERROR(3224895573u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID: WIN32_ERROR = WIN32_ERROR(3224895572u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NUMBER_OF_EXTENTS_INVALID: WIN32_ERROR = WIN32_ERROR(3224895565u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NUMBER_OF_MEMBERS_INVALID: WIN32_ERROR = WIN32_ERROR(3224895533u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_NUMBER_OF_PLEXES_INVALID: WIN32_ERROR = WIN32_ERROR(3224895534u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_CONFIG_OFFLINE: WIN32_ERROR = WIN32_ERROR(3224895568u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_CONFIG_ONLINE: WIN32_ERROR = WIN32_ERROR(3224895569u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_CONFIG_UPDATE_FAILED: WIN32_ERROR = WIN32_ERROR(3224895492u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_DUPLICATE: WIN32_ERROR = WIN32_ERROR(3224895535u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_HAS_QUORUM: WIN32_ERROR = WIN32_ERROR(3224895540u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_ID_INVALID: WIN32_ERROR = WIN32_ERROR(3224895536u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_INVALID: WIN32_ERROR = WIN32_ERROR(3224895537u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_LOG_UPDATE_FAILED: WIN32_ERROR = WIN32_ERROR(3224895571u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_NAME_INVALID: WIN32_ERROR = WIN32_ERROR(3224895538u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_OFFLINE: WIN32_ERROR = WIN32_ERROR(3224895539u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PACK_WITHOUT_QUORUM: WIN32_ERROR = WIN32_ERROR(3224895541u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PARTITION_STYLE_INVALID: WIN32_ERROR = WIN32_ERROR(3224895542u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PARTITION_UPDATE_FAILED: WIN32_ERROR = WIN32_ERROR(3224895543u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_INDEX_DUPLICATE: WIN32_ERROR = WIN32_ERROR(3224895545u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_INDEX_INVALID: WIN32_ERROR = WIN32_ERROR(3224895546u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_IN_SYNC: WIN32_ERROR = WIN32_ERROR(3224895544u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_LAST_ACTIVE: WIN32_ERROR = WIN32_ERROR(3224895547u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_MISSING: WIN32_ERROR = WIN32_ERROR(3224895548u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_NOT_RAID5: WIN32_ERROR = WIN32_ERROR(3224895551u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_NOT_SIMPLE: WIN32_ERROR = WIN32_ERROR(3224895552u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_NOT_SIMPLE_SPANNED: WIN32_ERROR = WIN32_ERROR(3224895575u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_REGENERATING: WIN32_ERROR = WIN32_ERROR(3224895549u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PLEX_TYPE_INVALID: WIN32_ERROR = WIN32_ERROR(3224895550u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_PRIMARY_PACK_PRESENT: WIN32_ERROR = WIN32_ERROR(3224895577u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_RAID5_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(3224895580u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_STRUCTURE_SIZE_INVALID: WIN32_ERROR = WIN32_ERROR(3224895553u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS: WIN32_ERROR = WIN32_ERROR(3224895554u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_TRANSACTION_IN_PROGRESS: WIN32_ERROR = WIN32_ERROR(3224895555u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE: WIN32_ERROR = WIN32_ERROR(3224895556u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_CONTAINS_MISSING_DISK: WIN32_ERROR = WIN32_ERROR(3224895557u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_ID_INVALID: WIN32_ERROR = WIN32_ERROR(3224895558u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_LENGTH_INVALID: WIN32_ERROR = WIN32_ERROR(3224895559u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE: WIN32_ERROR = WIN32_ERROR(3224895560u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_MIRRORED: WIN32_ERROR = WIN32_ERROR(3224895574u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_NOT_MIRRORED: WIN32_ERROR = WIN32_ERROR(3224895561u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_NOT_RETAINED: WIN32_ERROR = WIN32_ERROR(3224895562u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_OFFLINE: WIN32_ERROR = WIN32_ERROR(3224895563u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLMGR_VOLUME_RETAINED: WIN32_ERROR = WIN32_ERROR(3224895564u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLSNAP_ACTIVATION_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138963966i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLSNAP_BOOTFILE_NOT_VALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138963967i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLSNAP_HIBERNATE_READY: WIN32_ERROR = WIN32_ERROR(761u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLSNAP_NO_BYPASSIO_WITH_SNAPSHOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138963965i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLSNAP_PREPARE_HIBERNATE: WIN32_ERROR = WIN32_ERROR(655u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_CONTAINS_SYS_FILES: WIN32_ERROR = WIN32_ERROR(4337u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_DIRTY: WIN32_ERROR = WIN32_ERROR(6851u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_MOUNTED: WIN32_ERROR = WIN32_ERROR(743u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_NOT_CLUSTER_ALIGNED: WIN32_ERROR = WIN32_ERROR(407u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_NOT_SIS_ENABLED: WIN32_ERROR = WIN32_ERROR(4500u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_NOT_SUPPORTED: WIN32_ERROR = WIN32_ERROR(492u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_NOT_SUPPORT_EFS: WIN32_ERROR = WIN32_ERROR(6014u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VOLUME_WRITE_ACCESS_DENIED: WIN32_ERROR = WIN32_ERROR(508u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_CFG_AND_IO_ENABLED: WIN32_ERROR = WIN32_ERROR(3080u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_NMI_REGISTERED: WIN32_ERROR = WIN32_ERROR(3086u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_NOT_RUNNABLE_SYSTEM: WIN32_ERROR = WIN32_ERROR(3083u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_NOT_STOPPABLE: WIN32_ERROR = WIN32_ERROR(3081u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_NOT_SUPPORTED_RULECLASS: WIN32_ERROR = WIN32_ERROR(3084u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_PROTECTED_DRIVER: WIN32_ERROR = WIN32_ERROR(3085u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_SAFE_MODE: WIN32_ERROR = WIN32_ERROR(3082u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VRF_VOLATILE_SETTINGS_CONFLICT: WIN32_ERROR = WIN32_ERROR(3087u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VSMB_SAVED_STATE_CORRUPT: WIN32_ERROR = WIN32_ERROR(3224830977u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VSMB_SAVED_STATE_FILE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(3224830976u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VSM_DMA_PROTECTION_NOT_IN_USE: WIN32_ERROR = WIN32_ERROR(4561u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_VSM_NOT_INITIALIZED: WIN32_ERROR = WIN32_ERROR(4560u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAIT_1: WIN32_ERROR = WIN32_ERROR(731u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAIT_2: WIN32_ERROR = WIN32_ERROR(732u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAIT_3: WIN32_ERROR = WIN32_ERROR(733u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAIT_63: WIN32_ERROR = WIN32_ERROR(734u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAIT_FOR_OPLOCK: WIN32_ERROR = WIN32_ERROR(765u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAIT_NO_CHILDREN: WIN32_ERROR = WIN32_ERROR(128u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAKE_SYSTEM: WIN32_ERROR = WIN32_ERROR(730u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAKE_SYSTEM_DEBUGGER: WIN32_ERROR = WIN32_ERROR(675u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAS_LOCKED: WIN32_ERROR = WIN32_ERROR(717u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WAS_UNLOCKED: WIN32_ERROR = WIN32_ERROR(715u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WEAK_WHFBKEY_BLOCKED: WIN32_ERROR = WIN32_ERROR(8651u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WINDOW_NOT_COMBOBOX: WIN32_ERROR = WIN32_ERROR(1423u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WINDOW_NOT_DIALOG: WIN32_ERROR = WIN32_ERROR(1420u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WINDOW_OF_OTHER_THREAD: WIN32_ERROR = WIN32_ERROR(1408u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WINS_INTERNAL: WIN32_ERROR = WIN32_ERROR(4000u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WIP_ENCRYPTION_FAILED: WIN32_ERROR = WIN32_ERROR(6023u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_ALREADY_DISABLED: WIN32_ERROR = WIN32_ERROR(4212u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_ALREADY_ENABLED: WIN32_ERROR = WIN32_ERROR(4206u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_DP_FAILED: WIN32_ERROR = WIN32_ERROR(4209u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_DP_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4204u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_GUID_DISCONNECTED: WIN32_ERROR = WIN32_ERROR(4207u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_GUID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4200u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_INSTANCE_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4201u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_INVALID_MOF: WIN32_ERROR = WIN32_ERROR(4210u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_INVALID_REGINFO: WIN32_ERROR = WIN32_ERROR(4211u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_ITEMID_NOT_FOUND: WIN32_ERROR = WIN32_ERROR(4202u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_READ_ONLY: WIN32_ERROR = WIN32_ERROR(4213u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_SERVER_UNAVAILABLE: WIN32_ERROR = WIN32_ERROR(4208u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_SET_FAILURE: WIN32_ERROR = WIN32_ERROR(4214u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_TRY_AGAIN: WIN32_ERROR = WIN32_ERROR(4203u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WMI_UNRESOLVED_INSTANCE_REF: WIN32_ERROR = WIN32_ERROR(4205u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WOF_FILE_RESOURCE_TABLE_CORRUPT: WIN32_ERROR = WIN32_ERROR(4448u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WOF_WIM_HEADER_CORRUPT: WIN32_ERROR = WIN32_ERROR(4446u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WOF_WIM_RESOURCE_TABLE_CORRUPT: WIN32_ERROR = WIN32_ERROR(4447u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WORKING_SET_QUOTA: WIN32_ERROR = WIN32_ERROR(1453u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WOW_ASSERTION: WIN32_ERROR = WIN32_ERROR(670u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WRITE_FAULT: WIN32_ERROR = WIN32_ERROR(29u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WRITE_PROTECT: WIN32_ERROR = WIN32_ERROR(19u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WRONG_COMPARTMENT: WIN32_ERROR = WIN32_ERROR(1468u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WRONG_DISK: WIN32_ERROR = WIN32_ERROR(34u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WRONG_EFS: WIN32_ERROR = WIN32_ERROR(6005u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WRONG_PASSWORD: WIN32_ERROR = WIN32_ERROR(1323u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WRONG_TARGET_NAME: WIN32_ERROR = WIN32_ERROR(1396u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WX86_ERROR: WIN32_ERROR = WIN32_ERROR(540u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_WX86_WARNING: WIN32_ERROR = WIN32_ERROR(539u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_XMLDSIG_ERROR: WIN32_ERROR = WIN32_ERROR(1466u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_XML_ENCODING_MISMATCH: WIN32_ERROR = WIN32_ERROR(14100u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ERROR_XML_PARSE_ERROR: WIN32_ERROR = WIN32_ERROR(1465u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_ALL_SUBSCRIBERS_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220991i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220978i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220979i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_COMPLUS_NOT_INSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220980i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_FIRST: i32 = -2147220992i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_INTERNALERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220986i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_INTERNALEXCEPTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220987i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_INVALID_EVENT_CLASS_PARTITION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220977i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_INVALID_PER_USER_SID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220985i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_LAST: i32 = -2147220961i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_MISSING_EVENTCLASS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220982i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_NOT_ALL_REMOVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220981i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_PER_USER_SID_NOT_LOGGED_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220976i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_QUERYFIELD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220988i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_QUERYSYNTAX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220989i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_TOO_MANY_METHODS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220983i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_E_USER_EXCEPTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147220984i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_S_FIRST: i32 = 262656i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_S_LAST: i32 = 262687i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_S_NOSUBSCRIBERS: ::windows_core::HRESULT = ::windows_core::HRESULT(262658i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EVENT_S_SOME_SUBSCRIBERS_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(262656i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_ACCESS_VIOLATION: NTSTATUS = NTSTATUS(-1073741819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_ARRAY_BOUNDS_EXCEEDED: NTSTATUS = NTSTATUS(-1073741684i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_BREAKPOINT: NTSTATUS = NTSTATUS(-2147483645i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_DATATYPE_MISALIGNMENT: NTSTATUS = NTSTATUS(-2147483646i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_FLT_DENORMAL_OPERAND: NTSTATUS = NTSTATUS(-1073741683i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_FLT_DIVIDE_BY_ZERO: NTSTATUS = NTSTATUS(-1073741682i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_FLT_INEXACT_RESULT: NTSTATUS = NTSTATUS(-1073741681i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_FLT_INVALID_OPERATION: NTSTATUS = NTSTATUS(-1073741680i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_FLT_OVERFLOW: NTSTATUS = NTSTATUS(-1073741679i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_FLT_STACK_CHECK: NTSTATUS = NTSTATUS(-1073741678i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_FLT_UNDERFLOW: NTSTATUS = NTSTATUS(-1073741677i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_GUARD_PAGE: NTSTATUS = NTSTATUS(-2147483647i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_ILLEGAL_INSTRUCTION: NTSTATUS = NTSTATUS(-1073741795i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_INT_DIVIDE_BY_ZERO: NTSTATUS = NTSTATUS(-1073741676i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_INT_OVERFLOW: NTSTATUS = NTSTATUS(-1073741675i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_INVALID_DISPOSITION: NTSTATUS = NTSTATUS(-1073741786i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_INVALID_HANDLE: NTSTATUS = NTSTATUS(-1073741816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_IN_PAGE_ERROR: NTSTATUS = NTSTATUS(-1073741818i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_NONCONTINUABLE_EXCEPTION: NTSTATUS = NTSTATUS(-1073741787i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_POSSIBLE_DEADLOCK: NTSTATUS = NTSTATUS(-1073741420i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_PRIV_INSTRUCTION: NTSTATUS = NTSTATUS(-1073741674i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_SINGLE_STEP: NTSTATUS = NTSTATUS(-2147483644i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const EXCEPTION_STACK_OVERFLOW: NTSTATUS = NTSTATUS(-1073741571i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_ABORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467260i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_ACCESSDENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147024891i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_ACTIVATION_EXEC_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927141i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_ACTIVATION_TIMED_OUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927142i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_EXITING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483622i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_MANAGER_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927145i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_NOT_REGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927148i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_TEMPORARY_LICENSE_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927140i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_TRIAL_LICENSE_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927139i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_APPLICATION_VIEW_EXITING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483621i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_ASYNC_OPERATION_NOT_STARTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483623i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_AUDIO_ENGINE_NODE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140798975i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_ATTRIBUTE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864502i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_ATTRIBUTE_NOT_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864501i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INSUFFICIENT_AUTHENTICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864507i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INSUFFICIENT_AUTHORIZATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864504i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864497i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864500i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INSUFFICIENT_RESOURCES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864495i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864499i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INVALID_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864511i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INVALID_OFFSET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864505i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_INVALID_PDU: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864508i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_PREPARE_QUEUE_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864503i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_READ_NOT_PERMITTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864510i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_REQUEST_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864506i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_UNKNOWN_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140860416i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_UNLIKELY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864498i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_UNSUPPORTED_GROUP_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864496i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BLUETOOTH_ATT_WRITE_NOT_PERMITTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140864509i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_BOUNDS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483637i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_CHANGED_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483636i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_ELEVATED_ACTIVATION_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927151i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_FAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467259i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_FULL_ADMIN_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927149i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147024890i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140798973i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_HDAUDIO_EMPTY_CONNECTION_LIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140798974i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_HDAUDIO_NO_LOGICAL_DEVICES_CREATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140798972i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_HDAUDIO_NULL_LINKED_LIST_ENTRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140798971i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_ILLEGAL_DELEGATE_ASSIGNMENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483624i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_ILLEGAL_METHOD_CALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483634i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_ILLEGAL_STATE_CHANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483635i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_INVALIDARG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147024809i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_INVALID_PROTOCOL_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2089418750i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_INVALID_PROTOCOL_OPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2089418751i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_BAD_SIM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945342i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_CONTEXT_NOT_ACTIVATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945343i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_DATA_CLASS_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945341i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_DEFAULT_PROFILE_EXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945319i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945326i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_INVALID_ACCESS_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945340i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_INVALID_CACHE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945332i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_INVALID_PROFILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945320i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_MAX_ACTIVATED_CONTEXTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945339i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_NOT_REGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945331i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_PACKET_SVC_DETACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945338i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_PIN_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945327i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_PIN_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945329i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_PIN_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945328i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_PROVIDERS_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945330i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_PROVIDER_NOT_VISIBLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945337i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_RADIO_POWER_OFF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945336i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SERVICE_NOT_ACTIVATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945335i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SIM_NOT_INSERTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945334i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_ENCODING_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945312i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_FILTER_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945311i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_FORMAT_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945305i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_INVALID_MEMORY_INDEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945310i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_LANG_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945309i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_MEMORY_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945308i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_MEMORY_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945303i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_NETWORK_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945307i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_OPERATION_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945304i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_SMS_UNKNOWN_SMSC_ADDRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945306i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MBN_VOICE_CALL_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2141945333i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MONITOR_RESOLUTION_TOO_LOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927152i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MULTIPLE_EXTENSIONS_FOR_APPLICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927147i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_MULTIPLE_PACKAGES_FOR_FAMILY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927146i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_NOINTERFACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467262i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_NOTIMPL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467263i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_OUTOFMEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147024882i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_POINTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147467261i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_PROTOCOL_EXTENSIONS_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2089418749i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_PROTOCOL_VERSION_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2089418747i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SKYDRIVE_FILE_NOT_UPLOADED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927133i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SKYDRIVE_ROOT_TARGET_CANNOT_INDEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927134i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SKYDRIVE_ROOT_TARGET_FILE_SYSTEM_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927136i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SKYDRIVE_ROOT_TARGET_OVERLAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927135i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SKYDRIVE_ROOT_TARGET_VOLUME_ROOT_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927131i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SKYDRIVE_UPDATE_AVAILABILITY_FAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927132i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_STRING_NOT_NULL_TERMINATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SUBPROTOCOL_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2089418748i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_CLIENT_UPDATE_NEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081594i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_FILE_IDENTIFIER_UNKNOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013085694i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_FILE_SIZE_EXCEEDS_REMAINING_QUOTA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013089790i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_FILE_SIZE_OVER_LIMIT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013089791i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_FILE_SYNC_PARTNER_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013089787i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_FOLDER_INACCESSIBLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081599i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_FOLDER_IN_REDIRECTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081589i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_FOLDER_ITEM_COUNT_LIMIT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013089788i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_PATH_LENGTH_LIMIT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081596i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_PROXY_AUTHENTICATION_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081593i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_REMOTE_PATH_LENGTH_LIMIT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081595i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_REQUEST_BLOCKED_BY_SERVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013085690i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_REQUEST_BLOCKED_DUE_TO_CLIENT_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013085689i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_SERVICE_AUTHENTICATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013085693i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_SERVICE_RETURNED_UNEXPECTED_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013085691i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_STORAGE_SERVICE_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081590i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_STORAGE_SERVICE_PROVISIONING_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081592i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_SYNC_PAUSED_BY_SERVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013089786i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_UNKNOWN_SERVICE_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013085692i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_UNSUPPORTED_FILE_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013089789i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_UNSUPPORTED_FOLDER_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081598i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_UNSUPPORTED_MARKET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081597i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_SYNCENGINE_UNSUPPORTED_REPARSE_POINT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2013081591i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_UAC_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927150i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const E_UNEXPECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418113i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_ACPI_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(20u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_APP_EXEC: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(236u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_AUDIO_KERNEL: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(68u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_BCD_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(57u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_BTH_ATT: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(66u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_CLUSTER_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(19u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_CODCLASS_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(6u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_COMMONLOG: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(26u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_DEBUGGER: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(1u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_DRIVER_FRAMEWORK: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(32u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_FILTER_MANAGER: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(28u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_FIREWIRE_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(18u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_FVE_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(33u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_FWP_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(34u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_GRAPHICS_KERNEL: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(30u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_HID_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(17u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_HYPERVISOR: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(53u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_INTERIX: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(153u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_IO_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(4u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_IPSEC: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(54u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_LICENSING: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(234u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_MAXIMUM_VALUE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(237u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_MCA_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(5u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_MONITOR: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(29u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_NDIS_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(35u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_NTCERT: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(8u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_NTSSPI: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(9u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_NTWIN32: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(7u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_NT_IORING: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(70u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_PLATFORM_MANIFEST: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(235u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_QUIC_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(36u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_RDBSS: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(65u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_RESUME_KEY_FILTER: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(64u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_RPC_RUNTIME: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(2u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_RPC_STUBS: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(3u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_RTPM: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(42u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SDBUS: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(81u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SECUREBOOT: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(67u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SECURITY_CORE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(232u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SHARED_VHDX: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(92u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SMB: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(93u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SPACES: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(231u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SXS_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(21u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_SYSTEM_INTEGRITY: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(233u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_TERMINAL_SERVER: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(10u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_TPM: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(41u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_TRANSACTION: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(25u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_USB_ERROR_CODE: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(16u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_VIDEO: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(27u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_VIRTUALIZATION: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(55u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_VOLMGR: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(56u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_VOLSNAP: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(80u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_VSM: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(69u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_WIN32K_NTGDI: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(63u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_WIN32K_NTUSER: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(62u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILITY_XVS: NTSTATUS_FACILITY_CODE = NTSTATUS_FACILITY_CODE(94u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FACILTIY_MUI_ERROR_CODE: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FALSE: BOOL = BOOL(0i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FA_E_HOMEGROUP_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927198i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FA_E_MAX_PERSISTED_ITEMS_REACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927200i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_E_CHANGEUPDATEFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215740i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_E_FATALERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215742i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_E_LOWRESOURCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215743i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_E_NOWORDLIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215737i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_E_PARTITIONDELETED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215741i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_E_TOOMANYFILTEREDBLOCKS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215736i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_E_WORDLISTCOMMITFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215738i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_W_EMPTYWORDLIST: ::windows_core::HRESULT = ::windows_core::HRESULT(267909i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FDAEMON_W_WORDLISTFULL: ::windows_core::HRESULT = ::windows_core::HRESULT(267904i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_ALREADY_OPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215562i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_CONTENTINDEXCORRUPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473740i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215560i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_NOT_OPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215559i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_NO_SUCH_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215557i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_OFFLINE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215555i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_PARTIALLY_FILTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215554i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_TOO_BIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215568i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_E_UNREACHABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215561i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_S_CONTENTSCAN_DELAYED: ::windows_core::HRESULT = ::windows_core::HRESULT(268083i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_S_DISK_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(268085i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_S_FULL_CONTENTSCAN_IMMEDIATE: ::windows_core::HRESULT = ::windows_core::HRESULT(268082i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_S_NO_PROPSETS: ::windows_core::HRESULT = ::windows_core::HRESULT(268090i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_S_NO_SECURITY_DESCRIPTOR: ::windows_core::HRESULT = ::windows_core::HRESULT(268092i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FILTER_S_PARTIAL_CONTENTSCAN_IMMEDIATE: ::windows_core::HRESULT = ::windows_core::HRESULT(268081i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_AUTHENTICATION: i32 = 8008i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_CHILD_TO_PARENT_COMM: i32 = 8011i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_INSUFFICIENT_PRIV: i32 = 8007i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_INTERNAL: i32 = 8005i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_INTERNAL_API: i32 = 8004i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_INVALID_API_SEQUENCE: i32 = 8001i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_INVALID_SERVICE_PARAMETER: i32 = 8017i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_PARENT_AUTHENTICATION: i32 = 8010i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_PARENT_INSUFFICIENT_PRIV: i32 = 8009i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_PARENT_TO_CHILD_COMM: i32 = 8012i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_SERVICE_COMM: i32 = 8006i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_STARTING_SERVICE: i32 = 8002i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_STOPPING_SERVICE: i32 = 8003i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_SYSVOL_DEMOTE: i32 = 8016i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_SYSVOL_IS_BUSY: i32 = 8015i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_SYSVOL_POPULATE: i32 = 8013i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FRS_ERR_SYSVOL_POPULATE_TIMEOUT: i32 = 8014i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AAD_ENDPOINT_BUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272159i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AAD_SERVER_FAIL_BACKOFF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272150i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AAD_SERVER_FAIL_RETRY_AFTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272151i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_ACTION_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272375i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_ADBACKUP_NOT_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272171i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_ATTR_NOT_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272370i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_FIXED_DRIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272165i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_OS_DRIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272166i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_BACKUP_REQUIRED_POLICY_NOT_SET_REMOVABLE_DRIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272164i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_GUID_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272369i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_INSUFFICIENT_BUFFER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272358i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_INVALID_DATASIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272372i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_INVALID_DATATYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272373i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_NO_VALUES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272371i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AD_SCHEMA_NOT_INSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272374i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AUTH_INVALID_APPLICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272316i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AUTH_INVALID_CONFIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272315i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_AUTOUNLOCK_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272343i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_BAD_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272362i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_BAD_INFORMATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272368i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_BAD_PARTITION_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272364i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_BCD_APPLICATIONS_PATH_INCORRECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272302i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_BOOTABLE_CDDVD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272336i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_BUFFER_TOO_LARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272177i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_CANNOT_ENCRYPT_NO_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272338i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_CANNOT_SET_FVEK_ENCRYPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272339i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_CANT_LOCK_AUTOUNLOCK_ENABLED_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272233i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_CLUSTERING_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272354i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_CONV_READ: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272357i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_CONV_RECOVERY_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272248i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_CONV_WRITE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272356i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DATASET_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272149i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DEBUGGER_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272305i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DEVICELOCKOUT_COUNTER_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272178i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DEVICE_LOCKOUT_COUNTER_UNAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272179i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DEVICE_NOT_JOINED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272160i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_DEVICE_LOCKEDOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272182i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_FIXED_DATA_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272187i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_HARDWARE_NOT_COMPLIANT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272186i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_OS_VOLUME_NOT_PROTECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272183i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_PREVENTED_FOR_OS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272175i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_PROTECTION_NOT_YET_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272181i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_PROTECTION_SUSPENDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272184i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_VOLUME_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272173i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_VOLUME_OPTED_OUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272174i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DE_WINRE_NOT_CONFIGURED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272185i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DRY_RUN_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272307i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DV_NOT_ALLOWED_BY_GP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272271i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_DV_NOT_SUPPORTED_ON_FS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272272i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_BAND_ENUMERATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272157i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_BAND_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272208i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_DISALLOWED_BY_GP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272207i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_DRY_RUN_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272196i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_DV_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272204i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_INCOMPATIBLE_FIRMWARE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272193i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_INCOMPATIBLE_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272206i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EDRIVE_NO_FAILOVER_TO_SW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272209i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EFI_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272228i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_ENH_PIN_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272231i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EOW_NOT_SUPPORTED_IN_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272172i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_EXECUTE_REQUEST_SENT_TOO_SOON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272162i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FAILED_AUTHENTICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272345i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FAILED_SECTOR_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272346i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FAILED_WRONG_FS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272365i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FIPS_DISABLE_PROTECTION_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272314i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FIPS_HASH_KDF_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272232i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FIPS_PREVENTS_EXTERNAL_KEY_EXPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272328i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FIPS_PREVENTS_PASSPHRASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272276i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FIPS_PREVENTS_RECOVERY_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272329i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FIPS_RNG_CHECK_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272330i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FIRMWARE_TYPE_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272312i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FOREIGN_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272349i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FS_MOUNTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272309i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FS_NOT_EXTENDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272313i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272219i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_HIDDEN_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272298i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_BITLOCKER_OID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272274i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_DATUM_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272229i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_KEY_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272332i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_NBP_CERT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272158i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_NKP_CERT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272225i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_PASSWORD_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272331i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_PIN_CHARS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272230i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_PIN_CHARS_DETAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272180i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_PROTECTOR_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272326i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_INVALID_STARTUP_OPTIONS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272293i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEYFILE_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272323i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEYFILE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272324i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEYFILE_NO_VMK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272322i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEY_LENGTH_NOT_SUPPORTED_BY_EDRIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272217i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEY_PROTECTOR_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272279i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272355i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEY_ROTATION_NOT_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272161i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_KEY_ROTATION_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272163i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_LIVEID_ACCOUNT_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272189i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_LIVEID_ACCOUNT_SUSPENDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272190i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_LOCKED_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272384i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_METADATA_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272148i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_MOR_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272299i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_MULTIPLE_NKP_CERTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272227i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NON_BITLOCKER_KU: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272237i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NON_BITLOCKER_OID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272251i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ACTIVATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272376i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ALLOWED_IN_SAFE_MODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272320i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ALLOWED_IN_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272301i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ALLOWED_ON_CLUSTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272210i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ALLOWED_ON_CSV_STACK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272211i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272205i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_DATA_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272359i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_DECRYPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272327i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_DE_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272169i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ENCRYPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272383i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_ON_STACK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272310i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_OS_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272344i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_PROVISIONED_ON_ALL_VOLUMES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272188i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272363i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_AUTOUNLOCK_MASTER_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272300i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_BOOTMGR_METRIC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272379i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_BOOTSECTOR_METRIC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272380i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_EXISTING_PASSPHRASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272216i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_EXISTING_PIN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272224i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_FEATURE_LICENSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272294i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_LICENSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272311i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_MBR_METRIC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272381i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_PASSPHRASE_WITH_TPM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272213i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_PREBOOT_KEYBOARD_DETECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272203i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_PREBOOT_KEYBOARD_OR_WINRE_DETECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272202i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_PROTECTORS_TO_TEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272325i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_SUCH_CAPABILITY_ON_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272176i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_TPM_BIOS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272382i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_NO_TPM_WITH_PASSPHRASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272212i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_OPERATION_NOT_SUPPORTED_ON_VISTA_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272234i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_OSV_KSR_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272167i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_OS_NOT_PROTECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272352i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_OS_VOLUME_PASSPHRASE_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272275i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_OVERLAPPED_UPDATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272348i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PASSPHRASE_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272191i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PASSPHRASE_TOO_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272214i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PIN_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272317i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PIN_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272222i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_CONFLICT_FDV_RK_OFF_AUK_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272253i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_CONFLICT_FDV_RP_OFF_ADB_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272239i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_CONFLICT_OSV_RP_OFF_ADB_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272240i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_CONFLICT_RDV_RK_OFF_AUK_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272252i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_CONFLICT_RDV_RP_OFF_ADB_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272238i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_CONFLICT_RO_AND_STARTUP_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272249i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_INVALID_ENHANCED_BCD_SETTINGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272194i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_INVALID_PASSPHRASE_LENGTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272256i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_INVALID_PIN_LENGTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272280i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_ON_RDV_EXCLUSION_LIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272156i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_PASSPHRASE_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272278i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_PASSPHRASE_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272277i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_PASSPHRASE_REQUIRES_ASCII: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272220i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_PASSPHRASE_TOO_SIMPLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272255i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_PASSWORD_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272340i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_PROHIBITS_SELFSIGNED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272250i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_RECOVERY_KEY_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272290i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_RECOVERY_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272289i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_RECOVERY_PASSWORD_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272292i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_RECOVERY_PASSWORD_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272291i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_REQUIRES_RECOVERY_PASSWORD_ON_TOUCH_DEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272200i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_REQUIRES_STARTUP_PIN_ON_TOUCH_DEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272201i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_KEY_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272286i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272285i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_PIN_KEY_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272284i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_PIN_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272283i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_PIN_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272288i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_PIN_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272287i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_TPM_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272282i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_STARTUP_TPM_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272281i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_CERTIFICATE_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272270i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_CERTIFICATE_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272269i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_CERT_MUST_BE_HW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272268i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_CONFIGURE_FDV_AUTOUNLOCK_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272267i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_CONFIGURE_RDV_AUTOUNLOCK_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272266i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_CONFIGURE_RDV_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272265i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_DISABLE_RDV_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272263i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_POLICY_USER_ENABLE_RDV_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272264i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PREDICTED_TPM_PROTECTOR_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272155i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PRIVATEKEY_AUTH_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272236i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTION_CANNOT_BE_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272168i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTION_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272351i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTOR_CHANGE_MAX_PASSPHRASE_CHANGE_ATTEMPTS_REACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272192i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTOR_CHANGE_MAX_PIN_CHANGE_ATTEMPTS_REACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272221i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTOR_CHANGE_PASSPHRASE_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272215i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTOR_CHANGE_PIN_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272223i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTOR_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272335i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PROTECTOR_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272333i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_PUBKEY_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272296i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_RAW_ACCESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272304i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_RAW_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272303i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_REBOOT_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272306i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_RECOVERY_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272350i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_RECOVERY_PARTITION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272254i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_RELATIVE_PATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272334i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_REMOVAL_OF_DRA_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272235i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_REMOVAL_OF_NKP_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272226i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_SECUREBOOT_CONFIGURATION_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272197i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_SECUREBOOT_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272198i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_SECURE_KEY_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272377i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_SETUP_TPM_CALLBACK_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272154i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_SHADOW_COPY_PRESENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272195i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_SYSTEM_VOLUME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272366i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TOKEN_NOT_IMPERSONATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272308i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272367i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TPM_CONTEXT_SETUP_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272153i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TPM_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272321i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TPM_INVALID_PCR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272319i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TPM_NOT_OWNED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272360i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TPM_NO_VMK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272318i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TPM_SRK_AUTH_NOT_ZERO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272347i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_TRANSIENT_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272297i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_UPDATE_INVALID_CONFIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272152i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_VIRTUALIZED_SPACE_TOO_BIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272247i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_VOLUME_BOUND_ALREADY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272353i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272170i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_VOLUME_HANDLE_OPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272295i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_VOLUME_NOT_BOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272361i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_VOLUME_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272273i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_WIPE_CANCEL_NOT_APPLICABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272199i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_WIPE_NOT_ALLOWED_ON_TP_STORAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272218i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_WRONG_BOOTMGR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272378i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_WRONG_BOOTSECTOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272342i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FVE_E_WRONG_SYSTEM_FS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144272341i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206804i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206803i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206839i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_BUILTIN_OBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206825i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_CALLOUT_NOTIFICATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206793i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_CALLOUT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206847i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_CONDITION_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206846i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_CONNECTIONS_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206783i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206801i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206802i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_DROP_NOICMP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206588i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_DUPLICATE_AUTH_METHOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206788i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_DUPLICATE_CONDITION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206806i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_DUPLICATE_KEYMOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206805i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_DYNAMIC_SESSION_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206837i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_EM_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206798i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_FILTER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206845i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_IKEEXT_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206780i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INCOMPATIBLE_AUTH_METHOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206800i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INCOMPATIBLE_CIPHER_TRANSFORM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206790i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INCOMPATIBLE_DH_GROUP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206799i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INCOMPATIBLE_LAYER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206828i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INCOMPATIBLE_SA_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206821i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INCOMPATIBLE_TXN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206831i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_ACTION_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206812i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_AUTH_TRANSFORM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206792i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_CIPHER_TRANSFORM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206791i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_DNS_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206782i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_ENUMERATOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_FLAGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206818i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_INTERVAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_NET_MASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206817i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_PARAMETER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206795i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_RANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_TRANSFORM_COMBINATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206789i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_TUNNEL_ENDPOINT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206787i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_INVALID_WEIGHT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206811i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206838i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_KEY_DICTATION_INVALID_KEYING_MATERIAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206784i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_KEY_DICTATOR_ALREADY_REGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206785i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_KM_CLIENTS_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206827i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_L2_DRIVER_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206786i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_LAYER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206844i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_LIFETIME_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206826i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_MATCH_TYPE_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_NET_EVENTS_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206829i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_NEVER_MATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206797i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_NOTIFICATION_DROPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206823i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206840i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_NO_TXN_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206835i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_NULL_DISPLAY_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206813i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_NULL_POINTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206820i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_OUT_OF_BOUNDS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_PROVIDER_CONTEXT_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206796i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_PROVIDER_CONTEXT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206842i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_PROVIDER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206843i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_RESERVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206807i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_SESSION_ABORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206832i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_STILL_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206781i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_SUBLAYER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206841i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206830i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_TOO_MANY_CALLOUTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206824i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_TOO_MANY_SUBLAYERS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206794i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_TRAFFIC_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206822i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_TXN_ABORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206833i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_TXN_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206834i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_TYPE_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206809i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_WRONG_SESSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206836i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const FWP_E_ZERO_LENGTH_ARRAY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144206814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_DEFAULTNAMESPACE_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616983i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_MODULE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616991i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_NETADAPTER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616986i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_NETADAPTER_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616987i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_NETCOMPARTMENT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616985i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_NETINTERFACE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616984i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_NO_REQUEST_HANDLERS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616990i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_REQUEST_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616989i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GCN_E_RUNTIMEKEYS_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616988i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GENERIC_ALL: GENERIC_ACCESS_RIGHTS = GENERIC_ACCESS_RIGHTS(268435456u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GENERIC_EXECUTE: GENERIC_ACCESS_RIGHTS = GENERIC_ACCESS_RIGHTS(536870912u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GENERIC_READ: GENERIC_ACCESS_RIGHTS = GENERIC_ACCESS_RIGHTS(2147483648u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const GENERIC_WRITE: GENERIC_ACCESS_RIGHTS = GENERIC_ACCESS_RIGHTS(1073741824u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HANDLE_FLAG_INHERIT: HANDLE_FLAGS = HANDLE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HANDLE_FLAG_PROTECT_FROM_CLOSE: HANDLE_FLAGS = HANDLE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ADAPTER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617018i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ADDR_INVALID_OR_RESERVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616977i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_DEGRADED_OPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617001i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ENDPOINT_ALREADY_ATTACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617004i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ENDPOINT_NAMESPACE_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616981i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ENDPOINT_NOT_ATTACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616972i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ENDPOINT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ENDPOINT_NOT_LOCAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616971i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ENDPOINT_SHARING_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616995i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ENTITY_HAS_REFERENCES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616980i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_GUID_CONVERSION_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_ICS_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616982i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_ENDPOINT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617012i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_INTERNAL_PORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616979i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_IP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616994i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_IP_SUBNET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616973i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_JSON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616997i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_JSON_REFERENCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616996i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_NETWORK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617014i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_NETWORK_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617013i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_POLICY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617011i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_POLICY_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617010i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_PREFIX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616976i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_REMOTE_ENDPOINT_OPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617009i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_INVALID_SUBNET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616974i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_LAYER_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_LAYER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617021i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_MANAGER_STOPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616992i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_MAPPING_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617002i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_NAMESPACE_ATTACH_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616978i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_NETWORK_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617008i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_NETWORK_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_OBJECT_USED_AFTER_UNLOAD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616975i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_POLICY_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617006i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_POLICY_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617016i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_PORT_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617005i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_PORT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617017i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_REGKEY_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616998i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_REQUEST_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617003i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_SHARED_SWITCH_MODIFICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_SUBNET_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617019i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_SWITCH_EXTENSION_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616993i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_SWITCH_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617020i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_VFP_NOT_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616969i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_E_VFP_PORTSETTING_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143617015i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCN_INTERFACEPARAMETERS_ALREADY_APPLIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143616970i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_ACCESS_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878885i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_CONNECTION_CLOSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878902i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_CONNECTION_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878903i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_CONNECT_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878904i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_GUEST_CRITICAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878884i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_HYPERV_NOT_INSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878910i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_IMAGE_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878911i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_INVALID_JSON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878899i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_INVALID_LAYER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878894i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_INVALID_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878907i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_OPERATION_ALREADY_CANCELLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878879i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_OPERATION_ALREADY_STARTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878890i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_OPERATION_NOT_STARTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878891i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_OPERATION_PENDING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878889i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_OPERATION_RESULT_ALLOCATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878886i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_OPERATION_SYSTEM_CALLBACK_ALREADY_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878887i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_OPERATION_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878888i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_PROCESS_ALREADY_STOPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878881i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_PROCESS_INFO_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878883i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_PROTOCOL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878895i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_SERVICE_DISCONNECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878882i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_SERVICE_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878892i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_SYSTEM_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878897i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_SYSTEM_ALREADY_STOPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878896i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_SYSTEM_NOT_CONFIGURED_FOR_OPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878880i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_SYSTEM_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878898i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_TERMINATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878905i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_TERMINATED_DURING_START: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878912i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_UNEXPECTED_EXIT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878906i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_UNKNOWN_MESSAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878901i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_UNSUPPORTED_PROTOCOL_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878900i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HCS_E_WINDOWS_INSIDER_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143878893i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_BASE_ERROR_MASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128019200i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_BASE_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018945i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_BS_ERROR_MASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128080896i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_BS_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128080641i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_DRV_ERROR_MASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128019456i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_DRV_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128019201i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_E_ERROR_MASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128084992i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_E_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128080897i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_ALGORITHM_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018935i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_BUFFER_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018939i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_DEVICE_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018943i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_ERROR_MASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018944i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018689i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_INVALID_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018937i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_INVALID_FLAGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018936i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_INVALID_KEY_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018941i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_INVALID_KEY_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018932i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_INVALID_PARAMETER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018940i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_INVALID_PROVIDER_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018942i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_KEY_ALREADY_FINALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018934i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_KEY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018923i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_KEY_LOAD_FAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018921i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_KEY_MISSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018922i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_KEY_NOT_FINALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018933i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018938i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_NO_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018928i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_NO_MORE_ITEMS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018920i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HSP_KSP_PARAMETER_NOT_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2128018927i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_AMBIGUOUS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844948i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_BAD_GATEWAY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844746i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_BAD_METHOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844843i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_BAD_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844848i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_CONFLICT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844839i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844847i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_EXPECTATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844831i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_FORBIDDEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844845i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_GATEWAY_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844744i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_GONE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844838i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_LENGTH_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844837i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_MOVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844947i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_NONE_ACCEPTABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844842i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844844i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_NOT_MODIFIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844944i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844747i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_PAYMENT_REQ: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844846i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_PRECOND_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844836i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_PROXY_AUTH_REQ: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844841i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_RANGE_NOT_SATISFIABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844832i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_REDIRECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844946i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_REDIRECT_KEEP_VERB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844941i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_REDIRECT_METHOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844945i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_REQUEST_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844840i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_REQUEST_TOO_LARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844835i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_SERVER_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844748i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_SERVICE_UNAVAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844745i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_UNEXPECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145845247i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_UNEXPECTED_CLIENT_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145845244i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_UNEXPECTED_REDIRECTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145845245i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_UNEXPECTED_SERVER_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145845243i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_UNSUPPORTED_MEDIA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844833i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_URI_TOO_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844834i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_USE_PROXY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844943i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const HTTP_E_STATUS_VERSION_NOT_SUP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2145844743i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPLACE_E_FIRST: i32 = -2147221088i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPLACE_E_LAST: i32 = -2147221073i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPLACE_E_NOTOOLSPACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221087i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPLACE_E_NOTUNDOABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221088i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPLACE_S_FIRST: i32 = 262560i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPLACE_S_LAST: i32 = 262575i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPLACE_S_TRUNCATED: ::windows_core::HRESULT = ::windows_core::HRESULT(262560i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_DEVICE_INFO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289338i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_DEVICE_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289336i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_FRAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289340i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_HISTORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289339i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_MULTIMODAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289342i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_OUT_OF_ORDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289344i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_PACKET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289341i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_REENTRANCY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289343i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INPUT_E_TRANSFORM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2143289337i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const INVALID_HANDLE_VALUE: HANDLE = HANDLE(-1i32 as _);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_COMPLETION_QUEUE_TOO_BIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896123i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_COMPLETION_QUEUE_TOO_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896120i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_CORRUPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896121i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_REQUIRED_FLAG_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896127i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_SUBMISSION_QUEUE_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896126i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_SUBMISSION_QUEUE_TOO_BIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896124i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_SUBMIT_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896122i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IORING_E_VERSION_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2142896125i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_BAD_BLOCK_WITH_NAME: NTSTATUS = NTSTATUS(-1073479649i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_CDROM_EXCLUSIVE_LOCK: NTSTATUS = NTSTATUS(1074004101i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DRIVER_CANCEL_TIMEOUT: NTSTATUS = NTSTATUS(-2147221450i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_CALLBACK_EXCEPTION: NTSTATUS = NTSTATUS(-1073479517i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_CREATION_SUCCESS: NTSTATUS = NTSTATUS(262306i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_DIRECT_CONFIG_FAILED: NTSTATUS = NTSTATUS(-1073479632i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_DRIVER_LOAD_FAILURE: NTSTATUS = NTSTATUS(-1073479635i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_DUMPFILE_CONFLICT: NTSTATUS = NTSTATUS(-1073479633i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_INITIALIZATION_FAILURE: NTSTATUS = NTSTATUS(-1073479634i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_INIT_DEDICATED_DUMP_FAILURE: NTSTATUS = NTSTATUS(-1073479516i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_PAGE_CONFIG_FAILED: NTSTATUS = NTSTATUS(-1073479631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_DUMP_POINTER_FAILURE: NTSTATUS = NTSTATUS(-1073479636i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERROR_DISK_RESOURCES_EXHAUSTED: NTSTATUS = NTSTATUS(-1073479530i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERROR_DUMP_CREATION_ERROR: NTSTATUS = NTSTATUS(-1073479519i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERROR_IO_HARDWARE_ERROR: NTSTATUS = NTSTATUS(-1073479526i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_BAD_BLOCK: NTSTATUS = NTSTATUS(-1073479673i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_BAD_FIRMWARE: NTSTATUS = NTSTATUS(-1073479655i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_CONFIGURATION_ERROR: NTSTATUS = NTSTATUS(-1073479677i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_CONTROLLER_ERROR: NTSTATUS = NTSTATUS(-1073479669i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_DMA_CONFLICT_DETECTED: NTSTATUS = NTSTATUS(-1073479657i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_DMA_RESOURCE_CONFLICT: NTSTATUS = NTSTATUS(-1073479653i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_DRIVER_ERROR: NTSTATUS = NTSTATUS(-1073479676i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_INCORRECT_IRQL: NTSTATUS = NTSTATUS(-1073479667i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_INSUFFICIENT_RESOURCES: NTSTATUS = NTSTATUS(-1073479678i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_INTERNAL_ERROR: NTSTATUS = NTSTATUS(-1073479668i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_INTERRUPT_RESOURCE_CONFLICT: NTSTATUS = NTSTATUS(-1073479652i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_INVALID_IOBASE: NTSTATUS = NTSTATUS(-1073479666i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_INVALID_REQUEST: NTSTATUS = NTSTATUS(-1073479664i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_IRQ_CONFLICT_DETECTED: NTSTATUS = NTSTATUS(-1073479656i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_LAYERED_FAILURE: NTSTATUS = NTSTATUS(-1073479662i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_MEMORY_CONFLICT_DETECTED: NTSTATUS = NTSTATUS(-1073479659i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_MEMORY_RESOURCE_CONFLICT: NTSTATUS = NTSTATUS(-1073479651i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_NOT_READY: NTSTATUS = NTSTATUS(-1073479665i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_OVERRUN_ERROR: NTSTATUS = NTSTATUS(-1073479672i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_PARITY: NTSTATUS = NTSTATUS(-1073479675i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_PORT_CONFLICT_DETECTED: NTSTATUS = NTSTATUS(-1073479658i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_PORT_RESOURCE_CONFLICT: NTSTATUS = NTSTATUS(-1073479650i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_PORT_TIMEOUT: NTSTATUS = NTSTATUS(-1073479563i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_PROTOCOL: NTSTATUS = NTSTATUS(-1073479660i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_RESET: NTSTATUS = NTSTATUS(-1073479661i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_RETRY_SUCCEEDED: NTSTATUS = NTSTATUS(262145i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_SEEK_ERROR: NTSTATUS = NTSTATUS(-1073479674i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_SEQUENCE: NTSTATUS = NTSTATUS(-1073479670i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_THREAD_STUCK_IN_DEVICE_DRIVER: NTSTATUS = NTSTATUS(-1073479572i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_TIMEOUT: NTSTATUS = NTSTATUS(-1073479671i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_ERR_VERSION: NTSTATUS = NTSTATUS(-1073479663i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_QUOTA_CORRUPT: NTSTATUS = NTSTATUS(-1073479638i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_QUOTA_FAILED: NTSTATUS = NTSTATUS(-2147221464i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_QUOTA_LIMIT: NTSTATUS = NTSTATUS(1074004005i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_QUOTA_STARTED: NTSTATUS = NTSTATUS(1074004006i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_QUOTA_SUCCEEDED: NTSTATUS = NTSTATUS(1074004007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_QUOTA_THRESHOLD: NTSTATUS = NTSTATUS(1074004004i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_SYSTEM_CORRUPT: NTSTATUS = NTSTATUS(-1073479639i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_FILE_SYSTEM_CORRUPT_WITH_NAME: NTSTATUS = NTSTATUS(-1073479625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_INFO_THROTTLE_COMPLETE: NTSTATUS = NTSTATUS(1074004087i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_LOST_DELAYED_WRITE: NTSTATUS = NTSTATUS(-2147221454i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_LOST_DELAYED_WRITE_NETWORK_DISCONNECTED: NTSTATUS = NTSTATUS(-2147221365i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_LOST_DELAYED_WRITE_NETWORK_LOCAL_DISK_ERROR: NTSTATUS = NTSTATUS(-2147221363i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_LOST_DELAYED_WRITE_NETWORK_SERVER_ERROR: NTSTATUS = NTSTATUS(-2147221364i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_RECOVERED_VIA_ECC: NTSTATUS = NTSTATUS(-2147221471i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_SYSTEM_SLEEP_FAILED: NTSTATUS = NTSTATUS(-1073479637i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_ADAPTER_FIRMWARE_UPDATED: NTSTATUS = NTSTATUS(1074004128i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_ALLOCATION_FAILED: NTSTATUS = NTSTATUS(-2147221448i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_BUS_RESET: NTSTATUS = NTSTATUS(-2147221386i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_COMPLETION_TIME: NTSTATUS = NTSTATUS(-2147221349i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DEVICE_HAS_INTERNAL_DUMP: NTSTATUS = NTSTATUS(-2147221361i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DISK_CAPACITY_CHANGED: NTSTATUS = NTSTATUS(-2147221353i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DISK_FIRMWARE_UPDATED: NTSTATUS = NTSTATUS(1074004127i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DISK_PROVISIONING_TYPE_CHANGED: NTSTATUS = NTSTATUS(-2147221352i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DISK_SURPRISE_REMOVED: NTSTATUS = NTSTATUS(-2147221347i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DUMP_DISABLED_DEVICE_GONE: NTSTATUS = NTSTATUS(-2147221348i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DUPLICATE_PATH: NTSTATUS = NTSTATUS(-2147221445i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_DUPLICATE_SIGNATURE: NTSTATUS = NTSTATUS(-2147221446i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_INTERRUPT_STILL_PENDING: NTSTATUS = NTSTATUS(-2147221451i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_IO_OPERATION_RETRIED: NTSTATUS = NTSTATUS(-2147221351i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_LOG_FLUSH_FAILED: NTSTATUS = NTSTATUS(-2147221447i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_PAGING_FAILURE: NTSTATUS = NTSTATUS(-2147221453i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_REPEATED_DISK_GUID: NTSTATUS = NTSTATUS(-2147221346i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_RESET: NTSTATUS = NTSTATUS(-2147221375i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED: NTSTATUS = NTSTATUS(-2147221360i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX: NTSTATUS = NTSTATUS(-2147221359i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_LUN_LUN: NTSTATUS = NTSTATUS(-2147221358i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_LUN_POOL: NTSTATUS = NTSTATUS(-2147221357i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_POOL_LUN: NTSTATUS = NTSTATUS(-2147221356i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_SOFT_THRESHOLD_REACHED_EX_POOL_POOL: NTSTATUS = NTSTATUS(-2147221355i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_VOLUME_LOST_DISK_EXTENT: NTSTATUS = NTSTATUS(-2147221362i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WARNING_WRITE_FUA_PROBLEM: NTSTATUS = NTSTATUS(-2147221372i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WRITE_CACHE_DISABLED: NTSTATUS = NTSTATUS(-2147221470i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WRITE_CACHE_ENABLED: NTSTATUS = NTSTATUS(-2147221472i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WRN_BAD_FIRMWARE: NTSTATUS = NTSTATUS(-2147221478i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const IO_WRN_FAILURE_PREDICTED: NTSTATUS = NTSTATUS(-2147221452i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const JSCRIPT_E_CANTEXECUTE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1996357631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const LANGUAGE_E_DATABASE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215484i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const LANGUAGE_S_LARGE_WORD: ::windows_core::HRESULT = ::windows_core::HRESULT(268161i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MARSHAL_E_FIRST: i32 = -2147221216i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MARSHAL_E_LAST: i32 = -2147221201i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MARSHAL_S_FIRST: i32 = 262432i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MARSHAL_S_LAST: i32 = 262447i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MAX_PATH: u32 = 260u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_BUS_ERROR: NTSTATUS = NTSTATUS(-1073414022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_BUS_TIMEOUT_ERROR: NTSTATUS = NTSTATUS(-1073414021i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_CACHE: NTSTATUS = NTSTATUS(-1073414083i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_CPU: NTSTATUS = NTSTATUS(-1073414030i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_CPU_BUS: NTSTATUS = NTSTATUS(-1073414079i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_MAS: NTSTATUS = NTSTATUS(-1073414075i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_MEM_1_2: NTSTATUS = NTSTATUS(-1073414071i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_MEM_1_2_5: NTSTATUS = NTSTATUS(-1073414069i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_MEM_1_2_5_4: NTSTATUS = NTSTATUS(-1073414067i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_MEM_UNKNOWN: NTSTATUS = NTSTATUS(-1073414073i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_MASTER_ABORT: NTSTATUS = NTSTATUS(-1073414055i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_MASTER_ABORT_NO_INFO: NTSTATUS = NTSTATUS(-1073414053i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_PARITY: NTSTATUS = NTSTATUS(-1073414063i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_PARITY_NO_INFO: NTSTATUS = NTSTATUS(-1073414061i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_SERR: NTSTATUS = NTSTATUS(-1073414059i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_SERR_NO_INFO: NTSTATUS = NTSTATUS(-1073414057i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_TIMEOUT: NTSTATUS = NTSTATUS(-1073414051i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_TIMEOUT_NO_INFO: NTSTATUS = NTSTATUS(-1073414049i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_BUS_UNKNOWN: NTSTATUS = NTSTATUS(-1073414047i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PCI_DEVICE: NTSTATUS = NTSTATUS(-1073414045i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_PLATFORM_SPECIFIC: NTSTATUS = NTSTATUS(-1073414041i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_REGISTER_FILE: NTSTATUS = NTSTATUS(-1073414077i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_SMBIOS: NTSTATUS = NTSTATUS(-1073414043i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_SYSTEM_EVENT: NTSTATUS = NTSTATUS(-1073414065i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_TLB: NTSTATUS = NTSTATUS(-1073414081i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_UNKNOWN: NTSTATUS = NTSTATUS(-1073414039i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_ERROR_UNKNOWN_NO_CPU: NTSTATUS = NTSTATUS(-1073414037i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_EXTERNAL_ERROR: NTSTATUS = NTSTATUS(-1073414017i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_FRC_ERROR: NTSTATUS = NTSTATUS(-1073414016i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_INFO_CPU_THERMAL_THROTTLING_REMOVED: NTSTATUS = NTSTATUS(1074069616i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_INFO_MEMORY_PAGE_MARKED_BAD: NTSTATUS = NTSTATUS(1074069620i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_INFO_NO_MORE_CORRECTED_ERROR_LOGS: NTSTATUS = NTSTATUS(1074069619i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_INTERNALTIMER_ERROR: NTSTATUS = NTSTATUS(-1073414020i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_MEMORYHIERARCHY_ERROR: NTSTATUS = NTSTATUS(-1073414024i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_MICROCODE_ROM_PARITY_ERROR: NTSTATUS = NTSTATUS(-1073414018i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_TLB_ERROR: NTSTATUS = NTSTATUS(-1073414023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_CACHE: NTSTATUS = NTSTATUS(-2147155908i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_CMC_THRESHOLD_EXCEEDED: NTSTATUS = NTSTATUS(-2147155859i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_CPE_THRESHOLD_EXCEEDED: NTSTATUS = NTSTATUS(-2147155858i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_CPU: NTSTATUS = NTSTATUS(-2147155855i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_CPU_BUS: NTSTATUS = NTSTATUS(-2147155904i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_CPU_THERMAL_THROTTLED: NTSTATUS = NTSTATUS(-2147155857i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_MAS: NTSTATUS = NTSTATUS(-2147155900i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_MEM_1_2: NTSTATUS = NTSTATUS(-2147155896i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_MEM_1_2_5: NTSTATUS = NTSTATUS(-2147155894i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_MEM_1_2_5_4: NTSTATUS = NTSTATUS(-2147155892i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_MEM_UNKNOWN: NTSTATUS = NTSTATUS(-2147155898i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_MASTER_ABORT: NTSTATUS = NTSTATUS(-2147155880i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_MASTER_ABORT_NO_INFO: NTSTATUS = NTSTATUS(-2147155878i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_PARITY: NTSTATUS = NTSTATUS(-2147155888i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_PARITY_NO_INFO: NTSTATUS = NTSTATUS(-2147155886i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_SERR: NTSTATUS = NTSTATUS(-2147155884i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_SERR_NO_INFO: NTSTATUS = NTSTATUS(-2147155882i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_TIMEOUT: NTSTATUS = NTSTATUS(-2147155876i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_TIMEOUT_NO_INFO: NTSTATUS = NTSTATUS(-2147155874i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_BUS_UNKNOWN: NTSTATUS = NTSTATUS(-2147155872i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PCI_DEVICE: NTSTATUS = NTSTATUS(-2147155870i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_PLATFORM_SPECIFIC: NTSTATUS = NTSTATUS(-2147155866i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_REGISTER_FILE: NTSTATUS = NTSTATUS(-2147155902i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_SMBIOS: NTSTATUS = NTSTATUS(-2147155868i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_SYSTEM_EVENT: NTSTATUS = NTSTATUS(-2147155890i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_TLB: NTSTATUS = NTSTATUS(-2147155906i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_UNKNOWN: NTSTATUS = NTSTATUS(-2147155864i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MCA_WARNING_UNKNOWN_NO_CPU: NTSTATUS = NTSTATUS(-2147155862i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MEM_E_INVALID_LINK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959344i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MEM_E_INVALID_ROOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959351i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MEM_E_INVALID_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959343i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MENROLL_S_ENROLLMENT_SUSPENDED: ::windows_core::HRESULT = ::windows_core::HRESULT(1572881i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_INSUFFICIENTVIDEORESOURCES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303160i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_INVALIDWMPVERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303161i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_MEDIAPLAYERCLOSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303155i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_MODULENOTLOADED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303163i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_NOCLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303168i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_NOMEDIATYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303167i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_NOREADYFRAMES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303164i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_NOVIDEOMIXER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303166i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_NOVIDEOPRESENTER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303165i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_REQUESTEDTEXTURETOOBIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303158i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_SEEKFAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303157i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_UNEXPECTEDWMPFAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303156i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_UNKNOWNHARDWAREERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303154i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_VIDEOACCELERATIONNOTAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303159i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILAVERR_WMPFACTORYNOTREGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003303162i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_ALREADYATTACHEDTOLISTENER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302888i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_CONNECTORNOTASSOCIATEDWITHEFFECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302894i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_CONNECTORNOTCONNECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302895i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_CYCLEDETECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302892i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_EFFECTALREADYINAGRAPH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302890i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_EFFECTHASNOCHILDREN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302889i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_EFFECTINMORETHANONEGRAPH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302891i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_EFFECTNOTPARTOFGROUP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302897i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_EMPTYBOUNDS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302886i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_NOINPUTSOURCEATTACHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302896i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_NOTAFFINETRANSFORM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302887i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_OUTPUTSIZETOOLARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302885i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_RESERVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302893i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILEFFECTSERR_UNKNOWNPROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003302898i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_ADAPTER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304290i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_ALREADYLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304314i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_ALREADY_INITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304305i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_BADNUMBER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_COLORSPACE_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304289i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_DEVICECANNOTRENDERTEXT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304312i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_DISPLAYFORMATNOTSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304316i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_DISPLAYID_ACCESS_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304287i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_DISPLAYSTATEINVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304442i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_DXGI_ENUMERATION_OUT_OF_SYNC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304291i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_GENERIC_IGNORE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304309i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_GLYPHBITMAPMISSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304311i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_INSUFFICIENTBUFFER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304446i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_INTERNALERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304320i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_INVALIDCALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304315i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_MALFORMEDGLYPHCACHE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304310i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_MALFORMED_GUIDELINE_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304308i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_MAX_TEXTURE_SIZE_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304294i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_MISMATCHED_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304304i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_MROW_READLOCK_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304297i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_MROW_UPDATE_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304296i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_NEED_RECREATE_AND_PRESENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304306i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_NONINVERTIBLEMATRIX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304441i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_NOTLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304313i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_NOT_QUEUING_PRESENTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304300i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_NO_HARDWARE_DEVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304307i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_NO_REDIRECTION_SURFACE_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304303i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_NO_REDIRECTION_SURFACE_RETRY_LATER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304299i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_OBJECTBUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304447i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_PREFILTER_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304288i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_QPC_TIME_WENT_BACKWARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304293i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_QUEUED_PRESENT_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304301i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_REMOTING_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304302i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_SCANNER_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304444i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_SCREENACCESSDENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304443i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_SHADER_COMPILE_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304295i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_TERMINATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304439i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_TOOMANYSHADERELEMNTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304298i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_WIN32ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304445i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MILERR_ZEROVECTOR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2003304440i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_CANTOPENFILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221014i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_CONNECTMANUALLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221024i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_ENUMERATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221009i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_EXCEEDEDDEADLINE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_FIRST: i32 = -2147221024i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_INTERMEDIATEINTERFACENOTSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221017i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_INVALIDEXTENSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221018i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_LAST: i32 = -2147221009i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_MUSTBOTHERUSER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221013i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NEEDGENERIC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NOINVERSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221012i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NOOBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221019i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NOPREFIX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221010i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NOSTORAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221011i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NOTBINDABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221016i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NOTBOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221015i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_NO_NORMALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146959353i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_SYNTAX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221020i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_E_UNAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221021i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_S_FIRST: i32 = 262624i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_S_HIM: ::windows_core::HRESULT = ::windows_core::HRESULT(262629i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_S_LAST: i32 = 262639i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_S_ME: ::windows_core::HRESULT = ::windows_core::HRESULT(262628i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_S_MONIKERALREADYREGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(262631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_S_REDUCED_TO_SELF: ::windows_core::HRESULT = ::windows_core::HRESULT(262626i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MK_S_US: ::windows_core::HRESULT = ::windows_core::HRESULT(262630i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSDTC_E_DUPLICATE_RESOURCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146367743i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_BADVERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865131i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865144i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_BAD_MAGICNUMBER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865148i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_BAD_OFFSET_TABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865147i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_CANTGETOBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865150i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_CRYPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865132i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_DSIG_STRUCTURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865130i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_FAILED_HINTS_CHECK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865135i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_FAILED_POLICY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865136i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865133i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_FILETOOSMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865141i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_FILE_CHECKSUM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865139i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_NOHEADTABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865149i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_NOT_OPENTYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865134i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_OUTOFMEMRANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865151i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_PCONST_CHECK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865129i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_STRUCTURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865128i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_TABLES_OVERLAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865143i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_TABLE_CHECKSUM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865140i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_TABLE_LONGWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865145i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_TABLE_PADBYTES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865142i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const MSSIPOTF_E_TABLE_TAGORDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146865146i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_CONFLICTING_ID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927741i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_ENTITY_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927730i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_ID_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927734i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_INVALID_PACKET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927743i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_MAXSIZE_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927733i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_MISMATCHED_ID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927736i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_MISSING_SOH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927742i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_NETSH_GROUPPOLICY_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927729i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_NOT_INITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927737i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_NOT_PENDING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927735i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_NOT_REGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927738i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_NO_CACHED_SOH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927740i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_SERVICE_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927732i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_SHV_CONFIG_EXISTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927727i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_SHV_CONFIG_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927726i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_SHV_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927725i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_STILL_BOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927739i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_E_TOO_MANY_CALLS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144927728i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NAP_S_CERT_ALREADY_PRESENT: ::windows_core::HRESULT = ::windows_core::HRESULT(2555917i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NOERROR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NOT_AN_ERROR1: ::windows_core::HRESULT = ::windows_core::HRESULT(529920i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NO_ERROR: WIN32_ERROR = WIN32_ERROR(0u32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTDDI_MAXVER: u32 = 2560u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_AUTHENTICATION_IGNORED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893775i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_ALGID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_FLAGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_HASH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893822i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_HASH_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893812i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893821i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_KEYSET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893802i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_KEYSET_PARAM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893793i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_KEY_STATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893813i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_LEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893820i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_PROVIDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893805i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_PROV_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893804i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_PUBLIC_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893803i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_SIGNATURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893818i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_UID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893823i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BAD_VER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893817i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BUFFERS_OVERLAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893781i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_BUFFER_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893784i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_DECRYPTION_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893780i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_DEVICE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893771i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_DEVICE_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893776i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_DOUBLE_ENCRYPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893806i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_ENCRYPTION_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893772i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893809i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_FAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893792i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_FIXEDPARAMETER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893787i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_HMAC_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893777i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_INCORRECT_PASSWORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893773i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893779i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_INVALID_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893786i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_INVALID_PARAMETER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893785i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_KEYSET_ENTRY_BAD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893798i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_KEYSET_NOT_DEF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893799i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_NOT_ACTIVE_CONSOLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893768i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893807i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893783i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_NO_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893811i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_NO_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_NO_MORE_ITEMS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893782i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_OP_OK: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_PASSWORD_CHANGE_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893769i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_PERM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_PROVIDER_DLL_FAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893795i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_PROV_DLL_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893794i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_PROV_TYPE_ENTRY_BAD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893800i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_PROV_TYPE_NOT_DEF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893801i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_PROV_TYPE_NO_MATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893797i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_SIGNATURE_FILE_BAD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893796i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_SILENT_CONTEXT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893790i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_SYS_ERR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893791i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_TEMPORARY_PROFILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893788i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_TOKEN_KEYSET_STORAGE_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893789i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_UI_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893778i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_USER_CANCELLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893770i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const NTE_VALIDATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893774i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_E_FIRST: i32 = -2147221120i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_E_INVALIDVERB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221119i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_E_LAST: i32 = -2147221105i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_E_NOVERBS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221120i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_S_CANNOT_DOVERB_NOW: ::windows_core::HRESULT = ::windows_core::HRESULT(262529i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_S_FIRST: i32 = 262528i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_S_INVALIDHWND: ::windows_core::HRESULT = ::windows_core::HRESULT(262530i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_S_INVALIDVERB: ::windows_core::HRESULT = ::windows_core::HRESULT(262528i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLEOBJ_S_LAST: i32 = 262543i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_ADVF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221503i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_ADVISENOTSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221501i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_BLANK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221497i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_CANTCONVERT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221487i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_CANT_BINDTOSOURCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221494i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_CANT_GETMONIKER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221495i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_CLASSDIFF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221496i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_ENUM_NOMORE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221502i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_FIRST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221504i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_INVALIDHWND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221489i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_INVALIDRECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221491i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_LAST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221249i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_NOCACHE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221498i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_NOCONNECTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221500i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_NOSTORAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221486i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_NOTRUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221499i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_NOT_INPLACEACTIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221488i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_OLEVERB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221504i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_PROMPTSAVECANCELLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221492i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_STATIC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221493i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_E_WRONGCOMPOBJ: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221490i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_S_FIRST: ::windows_core::HRESULT = ::windows_core::HRESULT(262144i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_S_LAST: ::windows_core::HRESULT = ::windows_core::HRESULT(262399i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_S_MAC_CLIPFORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(262146i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_S_STATIC: ::windows_core::HRESULT = ::windows_core::HRESULT(262145i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OLE_S_USEREG: ::windows_core::HRESULT = ::windows_core::HRESULT(262144i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_CONNECTION_COUNT_LIMIT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701811i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_ACCESS_DENIED_BY_TOU: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701822i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_ACCOUNT_LOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701817i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_ACCOUNT_SUSPENDED_ABUSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701813i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_ACCOUNT_SUSPENDED_COMPROIMISE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_ACCOUNT_UPDATE_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_ACTION_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701812i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_CONNECTED_ACCOUNT_CAN_NOT_SIGNOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_EMAIL_VERIFICATION_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_FORCESIGNIN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701818i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_INVALID_APPLICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701821i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_INVALID_AUTHENTICATION_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701823i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_PARENTAL_CONSENT_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_PASSWORD_UPDATE_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701820i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_REQUEST_THROTTLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ONL_E_USER_AUTHENTICATION_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2138701809i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OR_INVALID_OID: i32 = 1911i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OR_INVALID_OXID: i32 = 1910i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OR_INVALID_SET: i32 = 1912i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_ACCESS_SERIALIZATION_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881517i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_API_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881495i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_BAD_ARG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881530i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_BAD_ENCRULES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881514i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_BAD_PTR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881525i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_BAD_TABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881521i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_BAD_TIME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881524i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_BAD_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881529i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_BERDER_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881494i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_CANT_CLOSE_TRACE_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881490i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_CANT_OPEN_TRACE_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881509i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_CANT_OPEN_TRACE_WINDOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881512i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_COMPARATOR_CODE_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881499i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_COMPARATOR_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881500i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_CONSTRAINT_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881501i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_CONSTRAINT_VIOLATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881519i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_COPIER_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881502i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_DATA_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881531i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_FATAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881518i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_INDEFINITE_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881523i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_LIMITED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881526i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_MEM_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881522i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_MEM_MGR_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881498i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_MORE_BUF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881535i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_MORE_INPUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881532i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_MUTEX_NOT_CREATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881491i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_NEGATIVE_UINTEGER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881534i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_NULL_FCN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881515i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_NULL_TBL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881516i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_OID_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881510i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_OPEN_TYPE_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881492i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_OUT_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881528i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_OUT_OF_RANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881503i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_PDU_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881527i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_PDU_RANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881533i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_PDV_CODE_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881496i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_PDV_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881497i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_PER_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881493i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_REAL_CODE_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881504i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_REAL_DLL_NOT_LINKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881505i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_TABLE_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881507i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_TOO_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881520i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_TRACE_FILE_ALREADY_OPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881508i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_TYPE_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881506i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_UNAVAIL_ENCRULES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881513i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const OSS_UNIMPLEMENTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146881511i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_ALREADY_COMPLETED: i32 = 4060i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_ALREADY_EXISTS: i32 = 4058i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_ALREADY_INITIALIZED: i32 = 4055i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO: i32 = 4051i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED: i32 = 4050i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_INVALIDATED: i32 = 4057i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_INVALID_CONFIGURATION: i32 = 4063i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_MISSING_DATA: i32 = 4052i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_NOT_INITIALIZED: i32 = 4054i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_NOT_LICENSED: i32 = 4064i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_NO_MORE: i32 = 4053i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_OPERATION_NOTFOUND: i32 = 4059i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_OUT_OF_BOUNDS: i32 = 4061i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_SERVICE_UNAVAILABLE: i32 = 4065i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS: i32 = 4056i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_TRUST_FAILURE: i32 = 4066i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEERDIST_ERROR_VERSION_UNSUPPORTED: i32 = 4062i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_ALREADY_LISTENING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995321i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CANNOT_CONVERT_PEER_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140979199i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CANNOT_START_SERVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995581i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CERT_STORE_CORRUPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140993535i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CHAIN_TOO_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140993789i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CIRCULAR_CHAIN_DETECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140993786i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CLASSIFIER_TOO_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995071i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CLOUD_NAME_AMBIGUOUS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140991483i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CONNECTION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995319i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CONNECTION_NOT_AUTHENTICATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995318i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CONNECTION_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995325i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CONNECTION_REFUSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995317i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CONNECT_SELF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995322i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_CONTACT_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140971007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_DATABASE_ACCESSDENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_DATABASE_ALREADY_PRESENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994811i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_DATABASE_NOT_PRESENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_DBINITIALIZATION_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994813i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_DBNAME_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995567i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_DEFERRED_VALIDATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987344i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_DUPLICATE_GRAPH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995566i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_EVENT_HANDLE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994303i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_FW_BLOCKED_BY_POLICY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966903i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_FW_BLOCKED_BY_SHIELDS_UP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966902i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_FW_DECLINED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966901i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_FW_EXCEPTION_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966904i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_GRAPH_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995563i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_GRAPH_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995565i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_GRAPH_SHUTTING_DOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995564i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_GROUPS_EXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995068i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_GROUP_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987246i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_GROUP_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987247i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_IDENTITY_DELETED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987232i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_IDENTITY_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994559i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_ADDRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966905i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_ATTRIBUTES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994046i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_CLASSIFIER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987296i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_CLASSIFIER_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987278i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_CREDENTIAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987262i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_CREDENTIAL_INFO: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987263i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_DATABASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995562i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_FRIENDLY_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987280i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_GRAPH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995568i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_GROUP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987245i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_GROUP_PROPERTIES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987328i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_PEER_HOST_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140979198i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_PEER_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987312i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_RECORD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987376i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_RECORD_EXPIRATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987264i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_RECORD_SIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987261i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_ROLE_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987279i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_SEARCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994047i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVALID_TIME_PERIOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140993787i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVITATION_NOT_TRUSTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140993791i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVITE_CANCELLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966912i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_INVITE_RESPONSE_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966911i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_IPV6_NOT_INSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995583i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_MAX_RECORD_SIZE_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994812i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NODE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995320i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NOT_AUTHORIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987360i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NOT_INITIALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995582i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NOT_LICENSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995580i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NOT_SIGNED_IN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966909i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NO_CLOUD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140991487i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NO_KEY_ACCESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995069i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NO_MEMBERS_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987244i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NO_MEMBER_CONNECTIONS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987243i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_NO_MORE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140979197i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_PASSWORD_DOES_NOT_MEET_POLICY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987359i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_PNRP_DUPLICATE_PEER_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140979195i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_PRIVACY_DECLINED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966908i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_RECORD_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140994815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_SERVICE_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987231i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140966907i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_TOO_MANY_ATTRIBUTES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995561i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_TOO_MANY_IDENTITIES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140995070i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_UNABLE_TO_LISTEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987242i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_E_UNSUPPORTED_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140987248i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_S_ALREADY_A_MEMBER: ::windows_core::HRESULT = ::windows_core::HRESULT(6488070i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_S_ALREADY_CONNECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(6496256i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_S_GRAPH_DATA_CREATED: ::windows_core::HRESULT = ::windows_core::HRESULT(6488065i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_S_NO_CONNECTIVITY: ::windows_core::HRESULT = ::windows_core::HRESULT(6488069i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_S_NO_EVENT_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(6488066i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PEER_S_SUBSCRIPTION_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(6512640i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PERSIST_E_NOTSELFSIZING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762741i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PERSIST_E_SIZEDEFINITE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762743i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PERSIST_E_SIZEINDEFINITE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146762742i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_CABAPI_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337645i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_CONFLICT_INCL_EXCL_API: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337659i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_CREDENTIALS_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337661i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DCS_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337737i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DCS_IN_USE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337750i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DCS_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337918i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DCS_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337660i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DCS_SINGLETON_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337662i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DCS_START_WAIT_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337654i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DC_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337655i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_DC_START_WAIT_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337653i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_EXE_ALREADY_CONFIGURED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337657i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_EXE_FULL_PATH_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337650i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_EXE_PATH_NOT_VALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337656i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_INVALID_SESSION_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337649i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_NETWORK_EXE_NOT_VALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337658i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_NO_DUPLICATES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337651i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_NO_MIN_DISK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_PLA_CHANNEL_NOT_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337648i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_PROPERTY_CONFLICT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337663i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_REPORT_WAIT_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337652i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_RULES_MANAGER_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337646i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_TASKSCHED_CHANNEL_NOT_ENABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337647i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_E_TOO_MANY_FOLDERS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2144337851i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PLA_S_PROPERTY_IGNORED: ::windows_core::HRESULT = ::windows_core::HRESULT(3145984i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PRESENTATION_ERROR_LOST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2004811775i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PSINK_E_INDEX_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215471i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PSINK_E_LARGE_ATTACHMENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215470i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PSINK_E_QUERY_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215472i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const PSINK_S_LARGE_WORD: ::windows_core::HRESULT = ::windows_core::HRESULT(268179i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_BRACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215770i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_COMMA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215759i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_CURRENCY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215772i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_DATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215773i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_EOS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215760i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_GUID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215771i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_INTEGER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215775i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_PAREN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215769i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_PHRASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215766i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215768i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_REAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215774i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_REGEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215764i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_EXPECTING_REGEX_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215763i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_INVALID_GROUPING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215753i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_INVALID_LITERAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215762i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_INVALID_QUERY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215750i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_INVALID_RANKMETHOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215749i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_INVALID_SORT_ORDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215755i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_NOT_YET_IMPLEMENTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215767i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_NO_SUCH_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215761i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_NO_SUCH_SORT_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215756i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_UNEXPECTED_EOS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215758i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_UNEXPECTED_NOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215776i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_UNSUPPORTED_PROPERTY_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215765i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPARSE_E_WEIGHT_OUT_OF_RANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215757i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_BAD_GUID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215783i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_BYREF_USED_WITHOUT_PTRTYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215778i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_CANT_OPEN_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215791i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_CANT_SET_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215781i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_DUPLICATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215780i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_EXPECTING_CLOSE_PAREN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215785i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_EXPECTING_GUID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215784i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_EXPECTING_INTEGER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215786i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_EXPECTING_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215789i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_EXPECTING_PROP_SPEC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215782i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_EXPECTING_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215788i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_READ_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215790i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_UNRECOGNIZED_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215787i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_E_VECTORBYREF_USED_ALONE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215779i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QPLIST_S_DUPLICATE: ::windows_core::HRESULT = ::windows_core::HRESULT(267897i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_ALLNOISE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215867i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_DIR_ON_REMOVABLE_DRIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215861i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_DUPLICATE_OUTPUT_COLUMN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215864i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215872i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_INVALIDCATEGORIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215868i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_INVALIDQUERY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215871i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_INVALIDRESTRICTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215870i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_INVALIDSORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215869i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_INVALID_DIRECTORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215862i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_INVALID_OUTPUT_COLUMN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215863i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_TIMEDOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215865i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_E_TOOCOMPLEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215866i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUERY_S_NO_QUERY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215860i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUTIL_E_CANT_CONVERT_VROOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215754i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const QUTIL_E_INVALID_CODEPAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073473928i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_BADTHREADINGMODEL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221162i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_CLASSNOTREG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221164i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_FIRST: i32 = -2147221168i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_IIDNOTREG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221163i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_INVALIDVALUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221165i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_KEYMISSING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221166i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_LAST: i32 = -2147221153i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_PACKAGEPOLICYVIOLATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221161i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_READREGDB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221168i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_E_WRITEREGDB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147221167i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_S_FIRST: i32 = 262480i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const REGDB_S_LAST: i32 = 262495i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ROUTEBASE: u32 = 900u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const ROUTEBASEEND: u32 = 957u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_BLOCKED_CROSS_ASTA_CALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483617i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_CANNOT_ACTIVATE_FULL_TRUST_SERVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483616i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_CANNOT_ACTIVATE_UNIVERSAL_APPLICATION_SERVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483615i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_CHANGE_NOTIFICATION_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483627i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_CLOSED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483629i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_COMMITTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483618i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_ERROR_STRING_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483626i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_EXCLUSIVE_WRITE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483628i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_INVALID_METADATA_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483630i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_METADATA_INVALID_TYPE_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_METADATA_NAME_IS_NAMESPACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483632i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_METADATA_NAME_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483633i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_MUST_BE_AGILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483620i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RO_E_UNSUPPORTED_FROM_MTA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147483619i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_ACCESS_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417829i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_ATTEMPTED_MULTITHREAD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417854i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CALL_CANCELED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418110i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CALL_COMPLETE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417833i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CALL_REJECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418111i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CANTCALLOUT_AGAIN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418095i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CANTCALLOUT_INASYNCCALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418108i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CANTCALLOUT_INEXTERNALCALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418107i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CANTCALLOUT_ININPUTSYNCCALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417843i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CANTPOST_INSENDCALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418109i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CANTTRANSMIT_CALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418102i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CHANGED_MODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417850i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CLIENT_CANTMARSHAL_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418101i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CLIENT_CANTUNMARSHAL_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418100i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CLIENT_DIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418104i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_CONNECTION_TERMINATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418106i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_DISCONNECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417848i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_FAULT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417852i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_FULLSIC_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417823i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALIDMETHOD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417849i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_CALLDATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417844i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418097i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_DATAPACKET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418103i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_EXTENSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417838i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_HEADER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417839i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_IPID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417837i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_OBJECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417836i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_OBJREF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417827i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_PARAMETER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418096i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_INVALID_STD_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417822i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_NOT_REGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417853i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_NO_CONTEXT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417826i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_NO_GOOD_SECURITY_PACKAGES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417830i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_NO_SYNC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417824i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_OUT_OF_RESOURCES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417855i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_REMOTE_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417828i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_RETRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417847i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SERVERCALL_REJECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417845i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SERVERCALL_RETRYLATER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417846i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SERVERFAULT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417851i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SERVER_CANTMARSHAL_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418099i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SERVER_CANTUNMARSHAL_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418098i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SERVER_DIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418105i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SERVER_DIED_DNE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147418094i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_SYS_CALL_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417856i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_THREAD_NOT_INIT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417841i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417825i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_TOO_LATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417831i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_UNEXPECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147352577i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_UNSECURE_CALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417832i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_VERSION_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417840i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_E_WRONG_THREAD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417842i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_ADDRESS_ERROR: NTSTATUS = NTSTATUS(-1073610683i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_ALREADY_LISTENING: NTSTATUS = NTSTATUS(-1073610738i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_ALREADY_REGISTERED: NTSTATUS = NTSTATUS(-1073610740i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_BAD_STUB_DATA: NTSTATUS = NTSTATUS(-1073545204i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_BINDING_HAS_NO_AUTH: NTSTATUS = NTSTATUS(-1073610705i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_BINDING_INCOMPLETE: NTSTATUS = NTSTATUS(-1073610671i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_BYTE_COUNT_TOO_SMALL: NTSTATUS = NTSTATUS(-1073545205i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_CALL_CANCELLED: NTSTATUS = NTSTATUS(-1073610672i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_CALL_FAILED: NTSTATUS = NTSTATUS(-1073610725i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_CALL_FAILED_DNE: NTSTATUS = NTSTATUS(-1073610724i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_CALL_IN_PROGRESS: NTSTATUS = NTSTATUS(-1073610679i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_CANNOT_SUPPORT: NTSTATUS = NTSTATUS(-1073610687i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_CANT_CREATE_ENDPOINT: NTSTATUS = NTSTATUS(-1073610731i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_COMM_FAILURE: NTSTATUS = NTSTATUS(-1073610670i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_COOKIE_AUTH_FAILED: NTSTATUS = NTSTATUS(-1073610651i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_DUPLICATE_ENDPOINT: NTSTATUS = NTSTATUS(-1073610711i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_ENTRY_ALREADY_EXISTS: NTSTATUS = NTSTATUS(-1073610691i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_ENTRY_NOT_FOUND: NTSTATUS = NTSTATUS(-1073610690i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_ENUM_VALUE_OUT_OF_RANGE: NTSTATUS = NTSTATUS(-1073545206i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_FP_DIV_ZERO: NTSTATUS = NTSTATUS(-1073610682i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_FP_OVERFLOW: NTSTATUS = NTSTATUS(-1073610680i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_FP_UNDERFLOW: NTSTATUS = NTSTATUS(-1073610681i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_GROUP_MEMBER_NOT_FOUND: NTSTATUS = NTSTATUS(-1073610677i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INCOMPLETE_NAME: NTSTATUS = NTSTATUS(-1073610696i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INTERFACE_NOT_FOUND: NTSTATUS = NTSTATUS(-1073610692i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INTERNAL_ERROR: NTSTATUS = NTSTATUS(-1073610685i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_ASYNC_CALL: NTSTATUS = NTSTATUS(-1073610653i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_ASYNC_HANDLE: NTSTATUS = NTSTATUS(-1073610654i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_AUTH_IDENTITY: NTSTATUS = NTSTATUS(-1073610702i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_BINDING: NTSTATUS = NTSTATUS(-1073610749i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_BOUND: NTSTATUS = NTSTATUS(-1073610717i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_ENDPOINT_FORMAT: NTSTATUS = NTSTATUS(-1073610745i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_ES_ACTION: NTSTATUS = NTSTATUS(-1073545127i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_NAF_ID: NTSTATUS = NTSTATUS(-1073610688i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_NAME_SYNTAX: NTSTATUS = NTSTATUS(-1073610715i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_NETWORK_OPTIONS: NTSTATUS = NTSTATUS(-1073610727i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_NET_ADDR: NTSTATUS = NTSTATUS(-1073610744i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_OBJECT: NTSTATUS = NTSTATUS(-1073610675i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_PIPE_OBJECT: NTSTATUS = NTSTATUS(-1073545124i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_PIPE_OPERATION: NTSTATUS = NTSTATUS(-1073545123i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_RPC_PROTSEQ: NTSTATUS = NTSTATUS(-1073610747i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_STRING_BINDING: NTSTATUS = NTSTATUS(-1073610751i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_STRING_UUID: NTSTATUS = NTSTATUS(-1073610746i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_TAG: NTSTATUS = NTSTATUS(-1073610718i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_TIMEOUT: NTSTATUS = NTSTATUS(-1073610742i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_INVALID_VERS_OPTION: NTSTATUS = NTSTATUS(-1073610695i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_MAX_CALLS_TOO_SMALL: NTSTATUS = NTSTATUS(-1073610709i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NAME_SERVICE_UNAVAILABLE: NTSTATUS = NTSTATUS(-1073610689i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NOTHING_TO_EXPORT: NTSTATUS = NTSTATUS(-1073610697i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NOT_ALL_OBJS_UNEXPORTED: NTSTATUS = NTSTATUS(-1073610693i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NOT_CANCELLED: NTSTATUS = NTSTATUS(-1073610664i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NOT_LISTENING: NTSTATUS = NTSTATUS(-1073610736i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NOT_RPC_ERROR: NTSTATUS = NTSTATUS(-1073610667i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_BINDINGS: NTSTATUS = NTSTATUS(-1073610733i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_CALL_ACTIVE: NTSTATUS = NTSTATUS(-1073610726i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_CONTEXT_AVAILABLE: NTSTATUS = NTSTATUS(-1073610686i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_ENDPOINT_FOUND: NTSTATUS = NTSTATUS(-1073610743i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_ENTRY_NAME: NTSTATUS = NTSTATUS(-1073610716i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_INTERFACES: NTSTATUS = NTSTATUS(-1073610673i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_MORE_BINDINGS: NTSTATUS = NTSTATUS(-1073610678i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_MORE_ENTRIES: NTSTATUS = NTSTATUS(-1073545215i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_MORE_MEMBERS: NTSTATUS = NTSTATUS(-1073610694i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_PRINC_NAME: NTSTATUS = NTSTATUS(-1073610668i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_PROTSEQS: NTSTATUS = NTSTATUS(-1073610732i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NO_PROTSEQS_REGISTERED: NTSTATUS = NTSTATUS(-1073610737i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_NULL_REF_POINTER: NTSTATUS = NTSTATUS(-1073545207i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_OBJECT_NOT_FOUND: NTSTATUS = NTSTATUS(-1073610741i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_OUT_OF_RESOURCES: NTSTATUS = NTSTATUS(-1073610730i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PIPE_CLOSED: NTSTATUS = NTSTATUS(-1073545121i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PIPE_DISCIPLINE_ERROR: NTSTATUS = NTSTATUS(-1073545120i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PIPE_EMPTY: NTSTATUS = NTSTATUS(-1073545119i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PROCNUM_OUT_OF_RANGE: NTSTATUS = NTSTATUS(-1073610706i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PROTOCOL_ERROR: NTSTATUS = NTSTATUS(-1073610723i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PROTSEQ_NOT_FOUND: NTSTATUS = NTSTATUS(-1073610707i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PROTSEQ_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073610748i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_PROXY_ACCESS_DENIED: NTSTATUS = NTSTATUS(-1073610652i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SEC_PKG_ERROR: NTSTATUS = NTSTATUS(-1073610665i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SEND_INCOMPLETE: NTSTATUS = NTSTATUS(1073873071i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SERVER_TOO_BUSY: NTSTATUS = NTSTATUS(-1073610728i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SERVER_UNAVAILABLE: NTSTATUS = NTSTATUS(-1073610729i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SS_CANNOT_GET_CALL_HANDLE: NTSTATUS = NTSTATUS(-1073545208i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SS_CHAR_TRANS_OPEN_FAIL: NTSTATUS = NTSTATUS(-1073545214i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SS_CHAR_TRANS_SHORT_FILE: NTSTATUS = NTSTATUS(-1073545213i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SS_CONTEXT_DAMAGED: NTSTATUS = NTSTATUS(-1073545210i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SS_CONTEXT_MISMATCH: NTSTATUS = NTSTATUS(-1073545211i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SS_HANDLES_MISMATCH: NTSTATUS = NTSTATUS(-1073545209i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_SS_IN_NULL_CONTEXT: NTSTATUS = NTSTATUS(-1073545212i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_STRING_TOO_LONG: NTSTATUS = NTSTATUS(-1073610708i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_TYPE_ALREADY_REGISTERED: NTSTATUS = NTSTATUS(-1073610739i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNKNOWN_AUTHN_LEVEL: NTSTATUS = NTSTATUS(-1073610703i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNKNOWN_AUTHN_SERVICE: NTSTATUS = NTSTATUS(-1073610704i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNKNOWN_AUTHN_TYPE: NTSTATUS = NTSTATUS(-1073610710i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNKNOWN_AUTHZ_SERVICE: NTSTATUS = NTSTATUS(-1073610701i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNKNOWN_IF: NTSTATUS = NTSTATUS(-1073610734i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNKNOWN_MGR_TYPE: NTSTATUS = NTSTATUS(-1073610735i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNSUPPORTED_AUTHN_LEVEL: NTSTATUS = NTSTATUS(-1073610669i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNSUPPORTED_NAME_SYNTAX: NTSTATUS = NTSTATUS(-1073610714i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNSUPPORTED_TRANS_SYN: NTSTATUS = NTSTATUS(-1073610721i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UNSUPPORTED_TYPE: NTSTATUS = NTSTATUS(-1073610719i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UUID_LOCAL_ONLY: NTSTATUS = NTSTATUS(1073872982i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_UUID_NO_ADDRESS: NTSTATUS = NTSTATUS(-1073610712i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_WRONG_ES_VERSION: NTSTATUS = NTSTATUS(-1073545126i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_WRONG_KIND_OF_BINDING: NTSTATUS = NTSTATUS(-1073610750i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_WRONG_PIPE_VERSION: NTSTATUS = NTSTATUS(-1073545122i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_WRONG_STUB_VERSION: NTSTATUS = NTSTATUS(-1073545125i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_NT_ZERO_DIVIDE: NTSTATUS = NTSTATUS(-1073610684i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_S_CALLPENDING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417835i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_S_WAITONTIMER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147417834i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_BAD_STUB_DATA: i32 = 1783i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_BYTE_COUNT_TOO_SMALL: i32 = 1782i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_ENUM_VALUE_OUT_OF_RANGE: i32 = 1781i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_INVALID_ES_ACTION: i32 = 1827i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_INVALID_PIPE_OBJECT: i32 = 1830i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_NO_MORE_ENTRIES: i32 = 1772i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_NULL_REF_POINTER: i32 = 1780i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_PIPE_CLOSED: i32 = 1916i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_PIPE_DISCIPLINE_ERROR: i32 = 1917i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_PIPE_EMPTY: i32 = 1918i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_SS_CANNOT_GET_CALL_HANDLE: i32 = 1779i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_SS_CHAR_TRANS_OPEN_FAIL: i32 = 1773i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_SS_CHAR_TRANS_SHORT_FILE: i32 = 1774i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_SS_CONTEXT_DAMAGED: i32 = 1777i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_SS_HANDLES_MISMATCH: i32 = 1778i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_SS_IN_NULL_CONTEXT: i32 = 1775i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_WRONG_ES_VERSION: i32 = 1828i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_WRONG_PIPE_ORDER: i32 = 1831i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_WRONG_PIPE_VERSION: i32 = 1832i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const RPC_X_WRONG_STUB_VERSION: i32 = 1829i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_BAD_SEEK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435031i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_CANCELLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435070i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_CANT_DISPOSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435058i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_CARD_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435044i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_CERTIFICATE_UNAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435027i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_COMM_DATA_LOST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435025i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_DIR_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435037i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_DUPLICATE_READER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435045i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_FILE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435036i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_ICC_CREATEORDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435039i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_ICC_INSTALLATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435040i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_INSUFFICIENT_BUFFER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435064i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_INVALID_ATR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435051i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_INVALID_CHV: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435030i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_INVALID_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435069i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_INVALID_PARAMETER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435068i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_INVALID_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435067i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_INVALID_VALUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435055i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435056i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NOT_TRANSACTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435050i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_ACCESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435033i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_DIR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435035i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_FILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435034i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_KEY_CONTAINER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435024i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435066i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_PIN_CACHE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435021i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_READERS_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435026i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_SERVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435043i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_SMARTCARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435060i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_NO_SUCH_CERTIFICATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435028i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_PCI_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435047i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_PIN_CACHE_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_PROTO_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435057i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_READER_UNAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435049i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_READER_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435046i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_READ_ONLY_CARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435020i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_SERVER_TOO_BUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_SERVICE_STOPPED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435042i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_SHARING_VIOLATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435061i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_SYSTEM_CANCELLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435054i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_TIMEOUT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435062i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_UNEXPECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435041i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_UNKNOWN_CARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435059i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_UNKNOWN_READER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435063i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_UNKNOWN_RES_MNG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435029i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_UNSUPPORTED_FEATURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435038i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_E_WRITE_TOO_MANY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435032i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_F_COMM_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435053i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_F_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435071i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_F_UNKNOWN_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435052i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_F_WAITED_TOO_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435065i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_P_SHUTDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146435048i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_CACHE_ITEM_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434960i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_CACHE_ITEM_STALE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434959i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_CACHE_ITEM_TOO_BIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434958i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_CANCELLED_BY_USER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434962i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_CARD_NOT_AUTHENTICATED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434961i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_CHV_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434964i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_EOF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434963i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_REMOVED_CARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434967i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_RESET_CARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434968i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_SECURITY_VIOLATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434966i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_UNPOWERED_CARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434969i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_UNRESPONSIVE_CARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434970i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_UNSUPPORTED_CARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434971i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCARD_W_WRONG_CHV: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146434965i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_ACCOUNT_DBASE_CORRUPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216623i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_ACCOUNT_INFORMATION_NOT_SET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_ACCOUNT_NAME_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216624i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_ALREADY_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216609i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_CANNOT_OPEN_TASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216627i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_DEPRECATED_FEATURE_USED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216592i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_INVALIDVALUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216616i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_INVALID_TASK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216626i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_INVALID_TASK_HASH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216607i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_MALFORMEDXML: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216614i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_MISSINGNODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216615i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_NAMESPACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216617i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_NO_SECURITY_SERVICES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216622i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_PAST_END_BOUNDARY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216610i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_SERVICE_NOT_AVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216606i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_SERVICE_NOT_INSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216628i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_SERVICE_NOT_LOCALSYSTEM: i32 = 6200i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_SERVICE_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216619i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_SERVICE_TOO_BUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216605i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_START_ON_DEMAND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216600i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TASK_ATTEMPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216604i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TASK_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216602i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TASK_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216630i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TASK_NOT_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216629i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TASK_NOT_UBPM_COMPAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216599i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TASK_NOT_V1_COMPAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216601i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TOO_MANY_NODES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216611i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_TRIGGER_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_UNEXPECTEDNODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216618i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_UNKNOWN_OBJECT_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216621i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_UNSUPPORTED_ACCOUNT_OPTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216620i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_E_USER_NOT_LOGGED_ON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147216608i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_BATCH_LOGON_PROBLEM: ::windows_core::HRESULT = ::windows_core::HRESULT(267036i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_EVENT_TRIGGER: ::windows_core::HRESULT = ::windows_core::HRESULT(267016i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_SOME_TRIGGERS_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(267035i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(267010i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_HAS_NOT_RUN: ::windows_core::HRESULT = ::windows_core::HRESULT(267011i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_NOT_SCHEDULED: ::windows_core::HRESULT = ::windows_core::HRESULT(267013i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_NO_MORE_RUNS: ::windows_core::HRESULT = ::windows_core::HRESULT(267012i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_NO_VALID_TRIGGERS: ::windows_core::HRESULT = ::windows_core::HRESULT(267015i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_QUEUED: ::windows_core::HRESULT = ::windows_core::HRESULT(267045i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(267008i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_RUNNING: ::windows_core::HRESULT = ::windows_core::HRESULT(267009i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SCHED_S_TASK_TERMINATED: ::windows_core::HRESULT = ::windows_core::HRESULT(267014i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_CANCELLED: i32 = -2143551232i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_CANNOTRUN: i32 = -2143551224i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_DISABLED: i32 = -2143551226i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_MANAGEDHOST: i32 = -2143551229i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_NOVERIFIER: i32 = -2143551228i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_POWERSHELL: i32 = -2143551230i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_RESOURCE: i32 = -2143551222i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_ROOTCAUSE: i32 = -2143551221i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_SCRIPT: i32 = -2143551231i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_TRUST: i32 = -2143551225i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_E_VERSION: i32 = -2143551223i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SDIAG_S_CANNOTRUN: i32 = 3932421i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEARCH_E_NOMONIKER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215711i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEARCH_E_NOREGION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2147215710i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEARCH_S_NOMOREHITS: ::windows_core::HRESULT = ::windows_core::HRESULT(267936i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_ALGORITHM_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_APPLICATION_PROTOCOL_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892953i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_BAD_BINDINGS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892986i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_BAD_PKGID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893034i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_BUFFER_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CANNOT_INSTALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893049i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CANNOT_PACK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893047i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CERT_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893016i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CERT_UNKNOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893017i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CERT_WRONG_USAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892983i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CONTEXT_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893033i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CROSSREALM_DELEGATION_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892969i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_CRYPTO_SYSTEM_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893001i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_DECRYPT_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893008i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_DELEGATION_POLICY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892962i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_DELEGATION_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892987i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_DOWNGRADE_DETECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892976i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_ENCRYPT_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893015i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_EXT_BUFFER_TOO_SMALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892950i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_ILLEGAL_MESSAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893018i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INCOMPLETE_CREDENTIALS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893024i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INCOMPLETE_MESSAGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893032i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INSUFFICIENT_BUFFERS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892949i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INSUFFICIENT_MEMORY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893056i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INTERNAL_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893052i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INVALID_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893055i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INVALID_PARAMETER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892963i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INVALID_TOKEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893048i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_INVALID_UPN_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892951i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_ISSUING_CA_UNTRUSTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892974i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_ISSUING_CA_UNTRUSTED_KDC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892967i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_KDC_CERT_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892966i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_KDC_CERT_REVOKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892965i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_KDC_INVALID_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892992i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_KDC_UNABLE_TO_REFER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892991i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_KDC_UNKNOWN_ETYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892990i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_LOGON_DENIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893044i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_MAX_REFERRALS_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_MESSAGE_ALTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893041i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_MULTIPLE_ACCOUNTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892985i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_MUST_BE_KDC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_MUTUAL_AUTH_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892957i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NOT_OWNER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893050i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NOT_SUPPORTED: i32 = -2146893054i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_AUTHENTICATING_AUTHORITY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893039i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_CONTEXT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892959i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_CREDENTIALS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893042i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_IMPERSONATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893045i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_IP_ADDRESSES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893003i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_KERB_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892984i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_PA_DATA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892996i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_S4U_PROT_SUPPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892970i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_SPM: i32 = -2146893052i32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_NO_TGT_REPLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893004i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_OK: ::windows_core::HRESULT = ::windows_core::HRESULT(0i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_ONLY_HTTPS_ALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892955i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_OUT_OF_SEQUENCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893040i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_PKINIT_CLIENT_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892972i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_PKINIT_NAME_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892995i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_PKU2U_CERT_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892958i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_POLICY_NLTM_ONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892961i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_QOP_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893046i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_REVOCATION_OFFLINE_C: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892973i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_REVOCATION_OFFLINE_KDC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892968i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_SECPKG_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893051i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_SECURITY_QOS_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893006i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_SHUTDOWN_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892993i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_SMARTCARD_CERT_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892971i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_SMARTCARD_CERT_REVOKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892975i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_SMARTCARD_LOGON_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892994i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_STRONG_CRYPTO_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892998i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_TARGET_UNKNOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893053i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_TIME_SKEW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893020i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_TOO_MANY_PRINCIPALS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892997i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_UNFINISHED_CONTEXT_DELETED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893005i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_UNKNOWN_CREDENTIALS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893043i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_UNSUPPORTED_FUNCTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893054i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_UNSUPPORTED_PREAUTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146892989i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_UNTRUSTED_ROOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893019i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_WRONG_CREDENTIAL_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893002i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_E_WRONG_PRINCIPAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146893022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_ASYNC_CALL_PENDING: ::windows_core::HRESULT = ::windows_core::HRESULT(590696i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_COMPLETE_AND_CONTINUE: ::windows_core::HRESULT = ::windows_core::HRESULT(590612i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_COMPLETE_NEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(590611i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_CONTEXT_EXPIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(590615i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_CONTINUE_NEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(590610i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_CONTINUE_NEEDED_MESSAGE_OK: ::windows_core::HRESULT = ::windows_core::HRESULT(590694i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_GENERIC_EXTENSION_RECEIVED: ::windows_core::HRESULT = ::windows_core::HRESULT(590614i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_INCOMPLETE_CREDENTIALS: ::windows_core::HRESULT = ::windows_core::HRESULT(590624i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_LOCAL_LOGON: ::windows_core::HRESULT = ::windows_core::HRESULT(590613i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_MESSAGE_FRAGMENT: ::windows_core::HRESULT = ::windows_core::HRESULT(590692i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_NO_LSA_CONTEXT: ::windows_core::HRESULT = ::windows_core::HRESULT(590627i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_NO_RENEGOTIATION: ::windows_core::HRESULT = ::windows_core::HRESULT(590688i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_RENEGOTIATE: ::windows_core::HRESULT = ::windows_core::HRESULT(590625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEC_I_SIGNATURE_NEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(590684i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEVERITY_ERROR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SEVERITY_SUCCESS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_AUTHENTICODE_DISALLOWED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500032i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500029i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500031i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500030i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_BAD_INTERFACE_INSTALLSECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500067i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_BAD_SECTION_NAME_LINE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500607i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_BAD_SERVICE_INSTALLSECT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500073i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_CANT_LOAD_CLASS_ICON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500084i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_CANT_REMOVE_DEVINST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500046i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_CLASS_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500095i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVICE_INSTALLER_NOT_READY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500026i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVICE_INSTALL_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500024i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVICE_INTERFACE_ACTIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500069i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVICE_INTERFACE_REMOVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500068i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVINFO_DATA_LOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500077i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVINFO_LIST_LOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500078i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVINFO_NOT_REGISTERED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500088i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500048i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DEVINST_ALREADY_EXISTS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500089i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DI_BAD_PATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500076i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DI_DONT_INSTALL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500053i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DI_DO_DEFAULT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500082i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DI_FUNCTION_OBSOLETE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500034i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DI_NOFILECOPY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500081i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DI_POSTPROCESSING_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500058i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DRIVER_INSTALL_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500023i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DRIVER_NONNATIVE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500044i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DRIVER_STORE_ADD_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500025i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DRIVER_STORE_DELETE_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500020i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_DUPLICATE_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500094i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_ERROR_NOT_INSTALLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146496512i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_EXPECTED_SECTION_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500608i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_FILEQUEUE_LOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500074i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_FILE_HASH_NOT_IN_CATALOG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500021i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_GENERAL_SYNTAX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500605i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INCORRECTLY_COPIED_INF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500041i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INF_IN_USE_BY_DEVICES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500035i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_CLASS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500090i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_CLASS_INSTALLER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500083i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_COINSTALLER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500057i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_DEVINST_NAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500091i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_FILTER_DRIVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500052i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_HWPROFILE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500080i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_INF_LOGCONFIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500054i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_MACHINENAME: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500064i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_PROPPAGE_PROVIDER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500060i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_REFERENCE_STRING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500065i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_REG_PROPERTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500087i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_INVALID_TARGET: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500045i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_IN_WOW64: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500043i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_KEY_DOES_NOT_EXIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500092i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_LINE_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500350i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_MACHINE_UNAVAILABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500062i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NON_WINDOWS_DRIVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500050i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NON_WINDOWS_NT_DRIVER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500051i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NOT_AN_INSTALLED_OEM_INF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500036i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NOT_DISABLEABLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500047i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_ASSOCIATED_CLASS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500096i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_ASSOCIATED_SERVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500071i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_AUTHENTICODE_CATALOG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500033i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_BACKUP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500349i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_CATALOG_FOR_OEM_INF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500049i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_CLASSINSTALL_PARAMS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500075i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_CLASS_DRIVER_LIST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500072i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_COMPAT_DRIVERS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500056i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_CONFIGMGR_SERVICES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500061i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500070i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_DEVICE_ICON: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500055i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_DEVICE_SELECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500079i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_DRIVER_SELECTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500093i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_INF: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500086i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_SUCH_DEVICE_INTERFACE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500059i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_SUCH_DEVINST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500085i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_NO_SUCH_INTERFACE_CLASS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500066i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500027i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_PNP_REGISTRY_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500038i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_REMOTE_COMM_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500063i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_REMOTE_REQUEST_UNSUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500037i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_SCE_DISABLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500040i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_SECTION_NAME_TOO_LONG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500606i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_SECTION_NOT_FOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500351i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_SET_SYSTEM_RESTORE_POINT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500042i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500028i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_UNKNOWN_EXCEPTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500039i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146499840i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_WRONG_INF_STYLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500352i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SPAPI_E_WRONG_INF_TYPE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146500022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_ABORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574332i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_ABORT_ROLLBACK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573820i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_AUTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574313i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_BUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574331i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_BUSY_RECOVERY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574075i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_BUSY_SNAPSHOT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CANTOPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574322i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CANTOPEN_CONVPATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573298i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CANTOPEN_FULLPATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573554i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CANTOPEN_ISDIR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CANTOPEN_NOTEMPDIR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574066i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574317i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_CHECK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574061i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_COMMITHOOK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573805i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_FOREIGNKEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573549i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_FUNCTION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573293i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_NOTNULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573037i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_PRIMARYKEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572781i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_ROWID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018571757i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_TRIGGER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572525i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_UNIQUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572269i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CONSTRAINT_VTAB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572013i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CORRUPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574325i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_CORRUPT_VTAB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574069i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_DONE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574235i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_EMPTY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574320i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_ERROR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574335i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_FORMAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574312i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_FULL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574323i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_INTERNAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574334i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_INTERRUPT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574327i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574326i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_ACCESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018570998i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_AUTH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018567677i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018571510i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_CHECKRESERVEDLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018570742i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_CLOSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018570230i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_CONVPATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018567670i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_DELETE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018571766i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_DELETE_NOENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018568438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_DIR_CLOSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018569974i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_DIR_FSYNC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573046i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_FSTAT: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572534i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_FSYNC: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573302i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_GETTEMPPATH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018567926i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_LOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018570486i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_MMAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018568182i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_NOMEM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018571254i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_RDLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572022i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_READ: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574070i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_SEEK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018568694i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_SHMLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018569206i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_SHMMAP: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018568950i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_SHMOPEN: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018569718i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_SHMSIZE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018569462i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_SHORT_READ: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_TRUNCATE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572790i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_UNLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018572278i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_VNODE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018567678i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_IOERR_WRITE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573558i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_LOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574330i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_LOCKED_SHAREDCACHE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574074i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_MISMATCH: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574316i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_MISUSE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574315i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_NOLFS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574314i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_NOMEM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574329i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_NOTADB: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574310i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_NOTFOUND: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574324i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_NOTICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574309i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_NOTICE_RECOVER_ROLLBACK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573797i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_NOTICE_RECOVER_WAL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574053i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_PERM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574333i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_PROTOCOL: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574321i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_RANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574311i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_READONLY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574328i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_READONLY_CANTLOCK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_READONLY_DBMOVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573304i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_READONLY_RECOVERY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574072i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_READONLY_ROLLBACK: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018573560i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_ROW: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574236i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_SCHEMA: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574319i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_TOOBIG: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574318i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_WARNING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574308i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const SQLITE_E_WARNING_AUTOINDEX: ::windows_core::HRESULT = ::windows_core::HRESULT(-2018574052i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_ERROR_CACHE_CORRUPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733422i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_ERROR_DICTIONARY_CORRUPTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733435i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_BLOCKED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733434i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_BUSY_RECOVERY_RETRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733432i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_BUSY_RECOVERY_TIMEOUT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733427i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_BUSY_RETRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733433i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_BUSY_TIMEOUT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733428i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_CACHE_NOT_INIITALIZED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733419i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_CONCURRENCY_LOCKING_FAILURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733439i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_CONFIGURATION_INVALID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733437i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_DEPENDENCY_NOT_RESOLVED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733418i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_LOCKED_RETRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733431i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_LOCKED_SHAREDCACHE_RETRY: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733430i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_LOCKED_SHAREDCACHE_TIMEOUT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733425i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_LOCKED_TIMEOUT_EXCEEDED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733426i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_SERVICE_STOP_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733424i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_STATEMENT_INPROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_TRANSACTION_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733429i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_E_UNKNOWN_SCHEMA_VERSION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733436i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_TRANSACTION_CALLER_ID_CHANGED: ::windows_core::HRESULT = ::windows_core::HRESULT(6750227i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSITORY_TRANSACTION_IN_PROGRESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733420i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATEREPOSTORY_E_NESTED_TRANSACTION_NOT_SUPPORTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2140733423i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABANDONED: NTSTATUS = NTSTATUS(128i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABANDONED_WAIT_0: NTSTATUS = NTSTATUS(128i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABANDONED_WAIT_63: NTSTATUS = NTSTATUS(191i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABANDON_HIBERFILE: NTSTATUS = NTSTATUS(1073741875i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_INVALID_COMMAND: NTSTATUS = NTSTATUS(-1073741549i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_INVALID_LID: NTSTATUS = NTSTATUS(-1073741548i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_INVALID_SELECTOR: NTSTATUS = NTSTATUS(-1073741546i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_LID_ALREADY_OWNED: NTSTATUS = NTSTATUS(-1073741551i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_LID_NOT_EXIST: NTSTATUS = NTSTATUS(-1073741552i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_NOT_LID_OWNER: NTSTATUS = NTSTATUS(-1073741550i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_NOT_PRESENT: NTSTATUS = NTSTATUS(-1073741553i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ABIOS_SELECTOR_NOT_AVAILABLE: NTSTATUS = NTSTATUS(-1073741547i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_AUDIT_BY_POLICY: NTSTATUS = NTSTATUS(1073741874i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_DENIED: NTSTATUS = NTSTATUS(-1073741790i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT: NTSTATUS = NTSTATUS(-1073740959i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_DISABLED_BY_POLICY_OTHER: NTSTATUS = NTSTATUS(-1073740956i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_DISABLED_BY_POLICY_PATH: NTSTATUS = NTSTATUS(-1073740958i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER: NTSTATUS = NTSTATUS(-1073740957i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY: NTSTATUS = NTSTATUS(-1073740942i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACCESS_VIOLATION: NTSTATUS = NTSTATUS(-1073741819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_ACQUIRE_GLOBAL_LOCK: NTSTATUS = NTSTATUS(-1072431086i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_ADDRESS_NOT_MAPPED: NTSTATUS = NTSTATUS(-1072431092i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_ALREADY_INITIALIZED: NTSTATUS = NTSTATUS(-1072431085i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_ASSERT_FAILED: NTSTATUS = NTSTATUS(-1072431101i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_FATAL: NTSTATUS = NTSTATUS(-1072431098i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_HANDLER_COLLISION: NTSTATUS = NTSTATUS(-1072431090i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INCORRECT_ARGUMENT_COUNT: NTSTATUS = NTSTATUS(-1072431093i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_ACCESS_SIZE: NTSTATUS = NTSTATUS(-1072431087i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_ARGTYPE: NTSTATUS = NTSTATUS(-1072431096i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_ARGUMENT: NTSTATUS = NTSTATUS(-1072431099i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_DATA: NTSTATUS = NTSTATUS(-1072431089i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_EVENTTYPE: NTSTATUS = NTSTATUS(-1072431091i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_INDEX: NTSTATUS = NTSTATUS(-1072431100i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_MUTEX_LEVEL: NTSTATUS = NTSTATUS(-1072431083i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_OBJTYPE: NTSTATUS = NTSTATUS(-1072431095i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_OPCODE: NTSTATUS = NTSTATUS(-1072431103i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_REGION: NTSTATUS = NTSTATUS(-1072431088i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_SUPERNAME: NTSTATUS = NTSTATUS(-1072431097i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_TABLE: NTSTATUS = NTSTATUS(-1072431079i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_INVALID_TARGETTYPE: NTSTATUS = NTSTATUS(-1072431094i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_MUTEX_NOT_OWNED: NTSTATUS = NTSTATUS(-1072431082i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_MUTEX_NOT_OWNER: NTSTATUS = NTSTATUS(-1072431081i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_NOT_INITIALIZED: NTSTATUS = NTSTATUS(-1072431084i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_POWER_REQUEST_FAILED: NTSTATUS = NTSTATUS(-1072431071i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_REG_HANDLER_FAILED: NTSTATUS = NTSTATUS(-1072431072i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_RS_ACCESS: NTSTATUS = NTSTATUS(-1072431080i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ACPI_STACK_OVERFLOW: NTSTATUS = NTSTATUS(-1072431102i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ADAPTER_HARDWARE_ERROR: NTSTATUS = NTSTATUS(-1073741630i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ADDRESS_ALREADY_ASSOCIATED: NTSTATUS = NTSTATUS(-1073741256i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ADDRESS_ALREADY_EXISTS: NTSTATUS = NTSTATUS(-1073741302i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ADDRESS_CLOSED: NTSTATUS = NTSTATUS(-1073741301i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ADDRESS_NOT_ASSOCIATED: NTSTATUS = NTSTATUS(-1073741255i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ADMINLESS_ACCESS_DENIED: NTSTATUS = NTSTATUS(-1073700348i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ADVANCED_INSTALLER_FAILED: NTSTATUS = NTSTATUS(-1072365536i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_AGENTS_EXHAUSTED: NTSTATUS = NTSTATUS(-1073741691i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALERTED: NTSTATUS = NTSTATUS(257i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALIAS_EXISTS: NTSTATUS = NTSTATUS(-1073741484i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALLOCATE_BUCKET: NTSTATUS = NTSTATUS(-1073741265i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALLOTTED_SPACE_EXCEEDED: NTSTATUS = NTSTATUS(-1073741671i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALL_SIDS_FILTERED: NTSTATUS = NTSTATUS(-1073740962i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED: NTSTATUS = NTSTATUS(-1073740798i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALPC_CHECK_COMPLETION_LIST: NTSTATUS = NTSTATUS(1073741872i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALREADY_COMMITTED: NTSTATUS = NTSTATUS(-1073741791i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALREADY_COMPLETE: NTSTATUS = NTSTATUS(255i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALREADY_DISCONNECTED: NTSTATUS = NTSTATUS(-2147483611i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALREADY_HAS_STREAM_ID: NTSTATUS = NTSTATUS(-1073740530i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALREADY_INITIALIZED: NTSTATUS = NTSTATUS(-1073740528i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALREADY_REGISTERED: NTSTATUS = NTSTATUS(-1073740008i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ALREADY_WIN32: NTSTATUS = NTSTATUS(1073741851i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_AMBIGUOUS_SYSTEM_DEVICE: NTSTATUS = NTSTATUS(-1073740719i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APC_RETURNED_WHILE_IMPERSONATING: NTSTATUS = NTSTATUS(-1073740015i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APISET_NOT_HOSTED: NTSTATUS = NTSTATUS(-1073740671i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APISET_NOT_PRESENT: NTSTATUS = NTSTATUS(-1073740670i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_APP_COMPAT_BLOCK: NTSTATUS = NTSTATUS(-1058275320i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_CALLER_WAIT_TIMEOUT: NTSTATUS = NTSTATUS(-1058275319i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_CALLER_WAIT_TIMEOUT_LICENSING: NTSTATUS = NTSTATUS(-1058275317i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_CALLER_WAIT_TIMEOUT_RESOURCES: NTSTATUS = NTSTATUS(-1058275316i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_CALLER_WAIT_TIMEOUT_TERMINATION: NTSTATUS = NTSTATUS(-1058275318i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_CONDITION_NOT_SATISFIED: NTSTATUS = NTSTATUS(-1058275328i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_HANDLE_INVALIDATED: NTSTATUS = NTSTATUS(-1058275327i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_HOST_ID_MISMATCH: NTSTATUS = NTSTATUS(-1058275322i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_INVALID_HOST_GENERATION: NTSTATUS = NTSTATUS(-1058275326i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_INVALID_HOST_STATE: NTSTATUS = NTSTATUS(-1058275324i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_NO_DONOR: NTSTATUS = NTSTATUS(-1058275323i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_UNEXPECTED_PROCESS_REGISTRATION: NTSTATUS = NTSTATUS(-1058275325i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPEXEC_UNKNOWN_USER: NTSTATUS = NTSTATUS(-1058275321i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPHELP_BLOCK: NTSTATUS = NTSTATUS(-1073740963i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPX_FILE_NOT_ENCRYPTED: NTSTATUS = NTSTATUS(-1073740634i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APPX_INTEGRITY_FAILURE_CLR_NGEN: NTSTATUS = NTSTATUS(-1073740673i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APP_DATA_CORRUPT: NTSTATUS = NTSTATUS(-1073700221i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APP_DATA_EXPIRED: NTSTATUS = NTSTATUS(-1073700222i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APP_DATA_LIMIT_EXCEEDED: NTSTATUS = NTSTATUS(-1073700220i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APP_DATA_NOT_FOUND: NTSTATUS = NTSTATUS(-1073700223i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APP_DATA_REBOOT_REQUIRED: NTSTATUS = NTSTATUS(-1073700219i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_APP_INIT_FAILURE: NTSTATUS = NTSTATUS(-1073741499i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ARBITRATION_UNHANDLED: NTSTATUS = NTSTATUS(1073741862i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ARRAY_BOUNDS_EXCEEDED: NTSTATUS = NTSTATUS(-1073741684i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ASSERTION_FAILURE: NTSTATUS = NTSTATUS(-1073740768i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ATTACHED_EXECUTABLE_MEMORY_WRITE: NTSTATUS = NTSTATUS(-1073739995i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ATTRIBUTE_NOT_PRESENT: NTSTATUS = NTSTATUS(-1073740532i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_AUDIO_ENGINE_NODE_NOT_FOUND: NTSTATUS = NTSTATUS(-1069285375i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_AUDITING_DISABLED: NTSTATUS = NTSTATUS(-1073740970i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_AUDIT_FAILED: NTSTATUS = NTSTATUS(-1073741244i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_AUTHIP_FAILURE: NTSTATUS = NTSTATUS(-1073700730i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_AUTH_TAG_MISMATCH: NTSTATUS = NTSTATUS(-1073700862i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BACKUP_CONTROLLER: NTSTATUS = NTSTATUS(-1073741433i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_BINDINGS: NTSTATUS = NTSTATUS(-1073740965i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_CLUSTERS: NTSTATUS = NTSTATUS(-1073739771i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_COMPRESSION_BUFFER: NTSTATUS = NTSTATUS(-1073741246i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_CURRENT_DIRECTORY: NTSTATUS = NTSTATUS(1073741831i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_DATA: NTSTATUS = NTSTATUS(-1073739509i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_DESCRIPTOR_FORMAT: NTSTATUS = NTSTATUS(-1073741593i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_DEVICE_TYPE: NTSTATUS = NTSTATUS(-1073741621i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_DLL_ENTRYPOINT: NTSTATUS = NTSTATUS(-1073741231i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_FILE_TYPE: NTSTATUS = NTSTATUS(-1073739517i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_FUNCTION_TABLE: NTSTATUS = NTSTATUS(-1073741569i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_IMPERSONATION_LEVEL: NTSTATUS = NTSTATUS(-1073741659i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_INHERITANCE_ACL: NTSTATUS = NTSTATUS(-1073741699i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_INITIAL_PC: NTSTATUS = NTSTATUS(-1073741814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_INITIAL_STACK: NTSTATUS = NTSTATUS(-1073741815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_KEY: NTSTATUS = NTSTATUS(-1073739510i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_LOGON_SESSION_STATE: NTSTATUS = NTSTATUS(-1073741564i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_MASTER_BOOT_RECORD: NTSTATUS = NTSTATUS(-1073741655i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_MCFG_TABLE: NTSTATUS = NTSTATUS(-1073739512i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_NETWORK_NAME: NTSTATUS = NTSTATUS(-1073741620i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_NETWORK_PATH: NTSTATUS = NTSTATUS(-1073741634i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_REMOTE_ADAPTER: NTSTATUS = NTSTATUS(-1073741627i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_SERVICE_ENTRYPOINT: NTSTATUS = NTSTATUS(-1073741230i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_STACK: NTSTATUS = NTSTATUS(-1073741784i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_TOKEN_TYPE: NTSTATUS = NTSTATUS(-1073741656i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_VALIDATION_CLASS: NTSTATUS = NTSTATUS(-1073741657i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BAD_WORKING_SET_LIMIT: NTSTATUS = NTSTATUS(-1073741748i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BCD_NOT_ALL_ENTRIES_IMPORTED: NTSTATUS = NTSTATUS(-2143748095i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED: NTSTATUS = NTSTATUS(-2143748093i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BCD_TOO_MANY_ELEMENTS: NTSTATUS = NTSTATUS(-1070006270i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BEGINNING_OF_MEDIA: NTSTATUS = NTSTATUS(-2147483617i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BEYOND_VDL: NTSTATUS = NTSTATUS(-1073740750i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT: NTSTATUS = NTSTATUS(-1073741458i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BIZRULES_NOT_ENABLED: NTSTATUS = NTSTATUS(1073741876i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BLOCKED_BY_PARENTAL_CONTROLS: NTSTATUS = NTSTATUS(-1073740664i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BLOCK_SHARED: NTSTATUS = NTSTATUS(-1073739499i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BLOCK_SOURCE_WEAK_REFERENCE_INVALID: NTSTATUS = NTSTATUS(-1073739501i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BLOCK_TARGET_WEAK_REFERENCE_INVALID: NTSTATUS = NTSTATUS(-1073739500i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BLOCK_TOO_MANY_REFERENCES: NTSTATUS = NTSTATUS(-1073740660i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BLOCK_WEAK_REFERENCE_INVALID: NTSTATUS = NTSTATUS(-1073739502i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BREAKPOINT: NTSTATUS = NTSTATUS(-2147483645i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_ATTRIBUTE_NOT_FOUND: NTSTATUS = NTSTATUS(-1069416438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_ATTRIBUTE_NOT_LONG: NTSTATUS = NTSTATUS(-1069416437i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INSUFFICIENT_AUTHENTICATION: NTSTATUS = NTSTATUS(-1069416443i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INSUFFICIENT_AUTHORIZATION: NTSTATUS = NTSTATUS(-1069416440i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION: NTSTATUS = NTSTATUS(-1069416433i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE: NTSTATUS = NTSTATUS(-1069416436i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INSUFFICIENT_RESOURCES: NTSTATUS = NTSTATUS(-1069416431i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH: NTSTATUS = NTSTATUS(-1069416435i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INVALID_HANDLE: NTSTATUS = NTSTATUS(-1069416447i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INVALID_OFFSET: NTSTATUS = NTSTATUS(-1069416441i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_INVALID_PDU: NTSTATUS = NTSTATUS(-1069416444i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_PREPARE_QUEUE_FULL: NTSTATUS = NTSTATUS(-1069416439i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_READ_NOT_PERMITTED: NTSTATUS = NTSTATUS(-1069416446i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_REQUEST_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1069416442i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_UNKNOWN_ERROR: NTSTATUS = NTSTATUS(-1069412352i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_UNLIKELY: NTSTATUS = NTSTATUS(-1069416434i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_UNSUPPORTED_GROUP_TYPE: NTSTATUS = NTSTATUS(-1069416432i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BTH_ATT_WRITE_NOT_PERMITTED: NTSTATUS = NTSTATUS(-1069416445i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BUFFER_ALL_ZEROS: NTSTATUS = NTSTATUS(279i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BUFFER_OVERFLOW: NTSTATUS = NTSTATUS(-2147483643i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BUFFER_TOO_SMALL: NTSTATUS = NTSTATUS(-1073741789i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BUS_RESET: NTSTATUS = NTSTATUS(-2147483619i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_BYPASSIO_FLT_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073740590i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CACHE_PAGE_LOCKED: NTSTATUS = NTSTATUS(277i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_BYPASS: NTSTATUS = NTSTATUS(-1073740541i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_INVOKE_INLINE: NTSTATUS = NTSTATUS(-1073740661i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_POP_STACK: NTSTATUS = NTSTATUS(-1073740765i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_RETURNED_LANG: NTSTATUS = NTSTATUS(-1073740001i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_RETURNED_LDR_LOCK: NTSTATUS = NTSTATUS(-1073740002i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_RETURNED_PRI_BACK: NTSTATUS = NTSTATUS(-1073740000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_RETURNED_THREAD_AFFINITY: NTSTATUS = NTSTATUS(-1073739999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_RETURNED_THREAD_PRIORITY: NTSTATUS = NTSTATUS(-1073740005i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_RETURNED_TRANSACTION: NTSTATUS = NTSTATUS(-1073740003i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING: NTSTATUS = NTSTATUS(-1073740016i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANCELLED: NTSTATUS = NTSTATUS(-1073741536i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_ABORT_TRANSACTIONS: NTSTATUS = NTSTATUS(-1072103347i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_ACCEPT_TRANSACTED_WORK: NTSTATUS = NTSTATUS(-1072103348i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_BREAK_OPLOCK: NTSTATUS = NTSTATUS(-1073739511i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_DELETE: NTSTATUS = NTSTATUS(-1073741535i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION: NTSTATUS = NTSTATUS(-1072103356i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_GRANT_REQUESTED_OPLOCK: NTSTATUS = NTSTATUS(-2147483602i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_IMPERSONATE: NTSTATUS = NTSTATUS(-1073741555i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_LOAD_REGISTRY_FILE: NTSTATUS = NTSTATUS(-1073741288i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_MAKE: NTSTATUS = NTSTATUS(-1073741078i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANNOT_SWITCH_RUNLEVEL: NTSTATUS = NTSTATUS(-1073700543i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_ACCESS_DOMAIN_INFO: NTSTATUS = NTSTATUS(-1073741606i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY: NTSTATUS = NTSTATUS(-1072103369i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_CLEAR_ENCRYPTION_FLAG: NTSTATUS = NTSTATUS(-1073740616i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS: NTSTATUS = NTSTATUS(-1072103386i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_CROSS_RM_BOUNDARY: NTSTATUS = NTSTATUS(-1072103368i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_DISABLE_MANDATORY: NTSTATUS = NTSTATUS(-1073741731i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_ENABLE_DENY_ONLY: NTSTATUS = NTSTATUS(-1073741133i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_OPEN_ANONYMOUS: NTSTATUS = NTSTATUS(-1073741658i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT: NTSTATUS = NTSTATUS(-1072103387i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_RECOVER_WITH_HANDLE_OPEN: NTSTATUS = NTSTATUS(-2145845199i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_TERMINATE_SELF: NTSTATUS = NTSTATUS(-1073741605i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CANT_WAIT: NTSTATUS = NTSTATUS(-1073741608i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CARDBUS_NOT_SUPPORTED: NTSTATUS = NTSTATUS(1073741863i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CASE_DIFFERING_NAMES_IN_DIR: NTSTATUS = NTSTATUS(-1073740621i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CASE_SENSITIVE_PATH: NTSTATUS = NTSTATUS(-1073740614i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CC_NEEDS_CALLBACK_SECTION_DRAIN: NTSTATUS = NTSTATUS(-1073700856i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE: NTSTATUS = NTSTATUS(-1073740012i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CERTIFICATE_VALIDATION_PREFERENCE_CONFLICT: NTSTATUS = NTSTATUS(-1073741387i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CHECKING_FILE_SYSTEM: NTSTATUS = NTSTATUS(1073741844i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CHECKOUT_REQUIRED: NTSTATUS = NTSTATUS(-1073739518i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CHILD_MUST_BE_VOLATILE: NTSTATUS = NTSTATUS(-1073741439i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CHILD_PROCESS_BLOCKED: NTSTATUS = NTSTATUS(-1073740643i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CIMFS_IMAGE_CORRUPT: NTSTATUS = NTSTATUS(-1073692671i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CIMFS_IMAGE_VERSION_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073692670i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLEANER_CARTRIDGE_INSTALLED: NTSTATUS = NTSTATUS(-2147483609i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIENT_SERVER_PARAMETERS_INVALID: NTSTATUS = NTSTATUS(-1073741277i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_DEVICE_LICENSE_MISSING: NTSTATUS = NTSTATUS(-1058406397i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_KEYHOLDER_LICENSE_MISSING_OR_INVALID: NTSTATUS = NTSTATUS(-1058406395i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_LICENSE_DEVICE_ID_MISMATCH: NTSTATUS = NTSTATUS(-1058406390i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_LICENSE_EXPIRED: NTSTATUS = NTSTATUS(-1058406394i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_LICENSE_HARDWARE_ID_OUT_OF_TOLERANCE: NTSTATUS = NTSTATUS(-1058406391i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_LICENSE_INVALID_SIGNATURE: NTSTATUS = NTSTATUS(-1058406396i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_LICENSE_NOT_FOUND: NTSTATUS = NTSTATUS(-1058406398i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_LICENSE_NOT_SIGNED: NTSTATUS = NTSTATUS(-1058406392i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLIP_LICENSE_SIGNED_BY_UNKNOWN_SOURCE: NTSTATUS = NTSTATUS(-1058406393i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_ACCESS_DENIED: NTSTATUS = NTSTATUS(-1073688808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_ALREADY_CONNECTED: NTSTATUS = NTSTATUS(-1073688823i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_AUTHENTICATION_FAILED: NTSTATUS = NTSTATUS(-1073688817i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_CONNECTED_PROVIDER_ONLY: NTSTATUS = NTSTATUS(-1073688819i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_DEHYDRATION_DISALLOWED: NTSTATUS = NTSTATUS(-1073688800i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_INCOMPATIBLE_HARDLINKS: NTSTATUS = NTSTATUS(-1073688807i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_INSUFFICIENT_RESOURCES: NTSTATUS = NTSTATUS(-1073688816i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_INVALID_REQUEST: NTSTATUS = NTSTATUS(-1073688821i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_IN_USE: NTSTATUS = NTSTATUS(-1073688812i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_METADATA_CORRUPT: NTSTATUS = NTSTATUS(-1073688830i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_METADATA_TOO_LARGE: NTSTATUS = NTSTATUS(-1073688829i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_NETWORK_UNAVAILABLE: NTSTATUS = NTSTATUS(-1073688815i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_NOT_IN_SYNC: NTSTATUS = NTSTATUS(-1073688824i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073688822i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_NOT_UNDER_SYNC_ROOT: NTSTATUS = NTSTATUS(-1073688813i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PINNED: NTSTATUS = NTSTATUS(-1073688811i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH: NTSTATUS = NTSTATUS(-2147430656i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE: NTSTATUS = NTSTATUS(-2147430652i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PROPERTY_CORRUPT: NTSTATUS = NTSTATUS(-1073688809i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PROPERTY_LOCK_CONFLICT: NTSTATUS = NTSTATUS(-1073688806i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PROPERTY_VERSION_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073688826i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PROVIDER_NOT_RUNNING: NTSTATUS = NTSTATUS(-1073688831i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_PROVIDER_TERMINATED: NTSTATUS = NTSTATUS(-1073688803i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_READ_ONLY_VOLUME: NTSTATUS = NTSTATUS(-1073688820i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_REQUEST_ABORTED: NTSTATUS = NTSTATUS(-1073688810i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_REQUEST_CANCELED: NTSTATUS = NTSTATUS(-1073688805i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_REQUEST_TIMEOUT: NTSTATUS = NTSTATUS(-1073688801i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_SYNC_ROOT_METADATA_CORRUPT: NTSTATUS = NTSTATUS(-1073688832i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_TOO_MANY_PROPERTY_BLOBS: NTSTATUS = NTSTATUS(-2147430651i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_UNSUCCESSFUL: NTSTATUS = NTSTATUS(-1073688814i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_US_MESSAGE_TIMEOUT: NTSTATUS = NTSTATUS(-1073688799i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLOUD_FILE_VALIDATION_FAILED: NTSTATUS = NTSTATUS(-1073688818i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CAM_TICKET_REPLAY_DETECTED: NTSTATUS = NTSTATUS(-1072496591i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_AUTO_PAUSE_ERROR: NTSTATUS = NTSTATUS(-1072496607i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_INVALID_HANDLE: NTSTATUS = NTSTATUS(-1072496599i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_NOT_REDIRECTED: NTSTATUS = NTSTATUS(-1072496605i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_NO_SNAPSHOTS: NTSTATUS = NTSTATUS(-1072496601i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_READ_OPLOCK_BREAK_IN_PROGRESS: NTSTATUS = NTSTATUS(-1072496608i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_REDIRECTED: NTSTATUS = NTSTATUS(-1072496606i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_SNAPSHOT_CREATION_IN_PROGRESS: NTSTATUS = NTSTATUS(-1072496603i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR: NTSTATUS = NTSTATUS(-1072496592i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_VOLUME_DRAINING: NTSTATUS = NTSTATUS(-1072496604i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_VOLUME_DRAINING_SUCCEEDED_DOWNLEVEL: NTSTATUS = NTSTATUS(-1072496602i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_CSV_VOLUME_NOT_LOCAL: NTSTATUS = NTSTATUS(-1072496615i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_INVALID_NETWORK: NTSTATUS = NTSTATUS(-1072496624i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_INVALID_NETWORK_PROVIDER: NTSTATUS = NTSTATUS(-1072496629i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_INVALID_NODE: NTSTATUS = NTSTATUS(-1072496639i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_INVALID_REQUEST: NTSTATUS = NTSTATUS(-1072496630i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_JOIN_IN_PROGRESS: NTSTATUS = NTSTATUS(-1072496637i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS: NTSTATUS = NTSTATUS(-1072496625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND: NTSTATUS = NTSTATUS(-1072496635i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NETINTERFACE_EXISTS: NTSTATUS = NTSTATUS(-1072496632i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NETINTERFACE_NOT_FOUND: NTSTATUS = NTSTATUS(-1072496631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE: NTSTATUS = NTSTATUS(-2146238460i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NETWORK_ALREADY_ONLINE: NTSTATUS = NTSTATUS(-2146238461i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NETWORK_EXISTS: NTSTATUS = NTSTATUS(-1072496634i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NETWORK_NOT_FOUND: NTSTATUS = NTSTATUS(-1072496633i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NETWORK_NOT_INTERNAL: NTSTATUS = NTSTATUS(-1072496618i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_ALREADY_DOWN: NTSTATUS = NTSTATUS(-2146238462i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_ALREADY_MEMBER: NTSTATUS = NTSTATUS(-2146238459i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_ALREADY_UP: NTSTATUS = NTSTATUS(-2146238463i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_DOWN: NTSTATUS = NTSTATUS(-1072496628i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_EXISTS: NTSTATUS = NTSTATUS(-1072496638i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_NOT_FOUND: NTSTATUS = NTSTATUS(-1072496636i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_NOT_MEMBER: NTSTATUS = NTSTATUS(-1072496626i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_NOT_PAUSED: NTSTATUS = NTSTATUS(-1072496620i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_PAUSED: NTSTATUS = NTSTATUS(-1072496621i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_UNREACHABLE: NTSTATUS = NTSTATUS(-1072496627i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NODE_UP: NTSTATUS = NTSTATUS(-1072496622i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NON_CSV_PATH: NTSTATUS = NTSTATUS(-1072496616i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NO_NET_ADAPTERS: NTSTATUS = NTSTATUS(-1072496623i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_NO_SECURITY_CONTEXT: NTSTATUS = NTSTATUS(-1072496619i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CLUSTER_POISONED: NTSTATUS = NTSTATUS(-1072496617i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COMMITMENT_LIMIT: NTSTATUS = NTSTATUS(-1073741523i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COMMITMENT_MINIMUM: NTSTATUS = NTSTATUS(-1073741112i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COMPRESSED_FILE_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073740677i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COMPRESSION_DISABLED: NTSTATUS = NTSTATUS(-1073740762i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION: NTSTATUS = NTSTATUS(-1072103338i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COMPRESSION_NOT_BENEFICIAL: NTSTATUS = NTSTATUS(-1073740689i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONFLICTING_ADDRESSES: NTSTATUS = NTSTATUS(-1073741800i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_ABORTED: NTSTATUS = NTSTATUS(-1073741247i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_ACTIVE: NTSTATUS = NTSTATUS(-1073741253i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_COUNT_LIMIT: NTSTATUS = NTSTATUS(-1073741242i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_DISCONNECTED: NTSTATUS = NTSTATUS(-1073741300i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_INVALID: NTSTATUS = NTSTATUS(-1073741254i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_IN_USE: NTSTATUS = NTSTATUS(-1073741560i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_REFUSED: NTSTATUS = NTSTATUS(-1073741258i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONNECTION_RESET: NTSTATUS = NTSTATUS(-1073741299i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONTAINER_ASSIGNED: NTSTATUS = NTSTATUS(-1073740536i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONTENT_BLOCKED: NTSTATUS = NTSTATUS(-1073739772i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONTEXT_MISMATCH: NTSTATUS = NTSTATUS(-1073740007i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONTEXT_STOWED_EXCEPTION: NTSTATUS = NTSTATUS(-1073741188i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONTROL_C_EXIT: NTSTATUS = NTSTATUS(-1073741510i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONTROL_STACK_VIOLATION: NTSTATUS = NTSTATUS(-1073741390i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CONVERT_TO_LARGE: NTSTATUS = NTSTATUS(-1073741268i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COPY_PROTECTION_FAILURE: NTSTATUS = NTSTATUS(-1073741051i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CORRUPT_LOG_CLEARED: NTSTATUS = NTSTATUS(-1073739763i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CORRUPT_LOG_CORRUPTED: NTSTATUS = NTSTATUS(-1073739766i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CORRUPT_LOG_DELETED_FULL: NTSTATUS = NTSTATUS(-1073739764i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CORRUPT_LOG_OVERFULL: NTSTATUS = NTSTATUS(-1073739767i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CORRUPT_LOG_UNAVAILABLE: NTSTATUS = NTSTATUS(-1073739765i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CORRUPT_LOG_UPLEVEL_RECORDS: NTSTATUS = NTSTATUS(-1073739759i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CORRUPT_SYSTEM_FILE: NTSTATUS = NTSTATUS(-1073741116i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COULD_NOT_INTERPRET: NTSTATUS = NTSTATUS(-1073741639i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_COULD_NOT_RESIZE_LOG: NTSTATUS = NTSTATUS(-2145845239i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CPU_SET_INVALID: NTSTATUS = NTSTATUS(-1073741393i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CRASH_DUMP: NTSTATUS = NTSTATUS(278i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CRC_ERROR: NTSTATUS = NTSTATUS(-1073741761i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CRED_REQUIRES_CONFIRMATION: NTSTATUS = NTSTATUS(-1073740736i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CRM_PROTOCOL_ALREADY_EXISTS: NTSTATUS = NTSTATUS(-1072103409i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CRM_PROTOCOL_NOT_FOUND: NTSTATUS = NTSTATUS(-1072103407i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CROSSREALM_DELEGATION_FAILURE: NTSTATUS = NTSTATUS(-1073740789i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CROSS_PARTITION_VIOLATION: NTSTATUS = NTSTATUS(-1073740277i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CRYPTO_SYSTEM_INVALID: NTSTATUS = NTSTATUS(-1073741069i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CSS_AUTHENTICATION_FAILURE: NTSTATUS = NTSTATUS(-1073741050i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CSS_KEY_NOT_ESTABLISHED: NTSTATUS = NTSTATUS(-1073741048i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CSS_KEY_NOT_PRESENT: NTSTATUS = NTSTATUS(-1073741049i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CSS_REGION_MISMATCH: NTSTATUS = NTSTATUS(-1073741046i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CSS_RESETS_EXHAUSTED: NTSTATUS = NTSTATUS(-1073741045i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CSS_SCRAMBLED_SECTOR: NTSTATUS = NTSTATUS(-1073741047i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CSV_IO_PAUSE_TIMEOUT: NTSTATUS = NTSTATUS(-1072496600i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE: NTSTATUS = NTSTATUS(-1073740733i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CS_ENCRYPTION_FILE_NOT_CSE: NTSTATUS = NTSTATUS(-1073740731i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE: NTSTATUS = NTSTATUS(-1073740735i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE: NTSTATUS = NTSTATUS(-1073740732i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER: NTSTATUS = NTSTATUS(-1073740734i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTLOG_INCONSISTENT_TRACKING_FILE: NTSTATUS = NTSTATUS(-1069940700i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTLOG_INVALID_TRACKING_STATE: NTSTATUS = NTSTATUS(-1069940701i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE: NTSTATUS = NTSTATUS(-1069940703i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTLOG_TRACKING_NOT_INITIALIZED: NTSTATUS = NTSTATUS(-1069940704i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTLOG_VHD_CHANGED_OFFLINE: NTSTATUS = NTSTATUS(-1069940702i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTL_FILE_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073741737i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_BAD_VIDEO_MODE: NTSTATUS = NTSTATUS(-1073086440i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CDM_CONNECT: NTSTATUS = NTSTATUS(1074397188i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CDM_DISCONNECT: NTSTATUS = NTSTATUS(1074397189i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CLIENT_LICENSE_IN_USE: NTSTATUS = NTSTATUS(-1073086412i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CLIENT_LICENSE_NOT_SET: NTSTATUS = NTSTATUS(-1073086413i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CLIENT_QUERY_TIMEOUT: NTSTATUS = NTSTATUS(-1073086426i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CLOSE_PENDING: NTSTATUS = NTSTATUS(-1073086458i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CONSOLE_CONNECT: NTSTATUS = NTSTATUS(-1073086424i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_CONSOLE_DISCONNECT: NTSTATUS = NTSTATUS(-1073086425i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_GRAPHICS_INVALID: NTSTATUS = NTSTATUS(-1073086430i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_INVALID_MODEMNAME: NTSTATUS = NTSTATUS(-1073086455i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_INVALID_PD: NTSTATUS = NTSTATUS(-1073086462i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_INVALID_WD: NTSTATUS = NTSTATUS(-1073086418i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_LICENSE_CLIENT_INVALID: NTSTATUS = NTSTATUS(-1073086446i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_LICENSE_EXPIRED: NTSTATUS = NTSTATUS(-1073086444i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_LICENSE_NOT_AVAILABLE: NTSTATUS = NTSTATUS(-1073086445i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_LOGON_DISABLED: NTSTATUS = NTSTATUS(-1073086409i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_MODEM_INF_NOT_FOUND: NTSTATUS = NTSTATUS(-1073086456i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_MODEM_RESPONSE_BUSY: NTSTATUS = NTSTATUS(-1073086450i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_MODEM_RESPONSE_NO_CARRIER: NTSTATUS = NTSTATUS(-1073086452i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE: NTSTATUS = NTSTATUS(-1073086451i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_MODEM_RESPONSE_TIMEOUT: NTSTATUS = NTSTATUS(-1073086453i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_MODEM_RESPONSE_VOICE: NTSTATUS = NTSTATUS(-1073086449i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_NOT_CONSOLE: NTSTATUS = NTSTATUS(-1073086428i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_NO_OUTBUF: NTSTATUS = NTSTATUS(-1073086457i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_PD_NOT_FOUND: NTSTATUS = NTSTATUS(-1073086461i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_RESPONSE_ERROR: NTSTATUS = NTSTATUS(-1073086454i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_SECURITY_LAYER_ERROR: NTSTATUS = NTSTATUS(-1073086408i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_SHADOW_DENIED: NTSTATUS = NTSTATUS(-1073086422i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_SHADOW_DISABLED: NTSTATUS = NTSTATUS(-1073086415i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE: NTSTATUS = NTSTATUS(-1073086411i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_SHADOW_INVALID: NTSTATUS = NTSTATUS(-1073086416i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_SHADOW_NOT_RUNNING: NTSTATUS = NTSTATUS(-1073086410i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_TD_ERROR: NTSTATUS = NTSTATUS(-1073086448i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_WD_NOT_FOUND: NTSTATUS = NTSTATUS(-1073086417i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_WINSTATION_ACCESS_DENIED: NTSTATUS = NTSTATUS(-1073086421i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_WINSTATION_BUSY: NTSTATUS = NTSTATUS(-1073086441i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_WINSTATION_NAME_COLLISION: NTSTATUS = NTSTATUS(-1073086442i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_WINSTATION_NAME_INVALID: NTSTATUS = NTSTATUS(-1073086463i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CTX_WINSTATION_NOT_FOUND: NTSTATUS = NTSTATUS(-1073086443i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CURRENT_DOMAIN_NOT_ALLOWED: NTSTATUS = NTSTATUS(-1073741079i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_CURRENT_TRANSACTION_NOT_VALID: NTSTATUS = NTSTATUS(-1072103400i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATATYPE_MISALIGNMENT: NTSTATUS = NTSTATUS(-2147483646i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATATYPE_MISALIGNMENT_ERROR: NTSTATUS = NTSTATUS(-1073741115i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATA_CHECKSUM_ERROR: NTSTATUS = NTSTATUS(-1073740688i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATA_ERROR: NTSTATUS = NTSTATUS(-1073741762i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATA_LATE_ERROR: NTSTATUS = NTSTATUS(-1073741763i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATA_LOST_REPAIR: NTSTATUS = NTSTATUS(-2147481597i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATA_NOT_ACCEPTED: NTSTATUS = NTSTATUS(-1073741285i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATA_OVERRUN: NTSTATUS = NTSTATUS(-1073741764i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DATA_OVERWRITTEN: NTSTATUS = NTSTATUS(304i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DAX_MAPPING_EXISTS: NTSTATUS = NTSTATUS(-1073740644i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEBUGGER_INACTIVE: NTSTATUS = NTSTATUS(-1073740972i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEBUG_ATTACH_FAILED: NTSTATUS = NTSTATUS(-1073741287i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DECRYPTION_FAILED: NTSTATUS = NTSTATUS(-1073741173i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DELAY_LOAD_FAILED: NTSTATUS = NTSTATUS(-1073740782i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DELETE_PENDING: NTSTATUS = NTSTATUS(-1073741738i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DESTINATION_ELEMENT_FULL: NTSTATUS = NTSTATUS(-1073741180i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_ALREADY_ATTACHED: NTSTATUS = NTSTATUS(-1073741768i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_BUSY: NTSTATUS = NTSTATUS(-2147483631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_CONFIGURATION_ERROR: NTSTATUS = NTSTATUS(-1073741438i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_DATA_ERROR: NTSTATUS = NTSTATUS(-1073741668i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_DOES_NOT_EXIST: NTSTATUS = NTSTATUS(-1073741632i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_DOOR_OPEN: NTSTATUS = NTSTATUS(-2147482999i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_ENUMERATION_ERROR: NTSTATUS = NTSTATUS(-1073740954i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_FEATURE_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073740701i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_HARDWARE_ERROR: NTSTATUS = NTSTATUS(-1073740669i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_HINT_NAME_BUFFER_TOO_SMALL: NTSTATUS = NTSTATUS(-1073740650i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_HUNG: NTSTATUS = NTSTATUS(-1073740537i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_INSUFFICIENT_RESOURCES: NTSTATUS = NTSTATUS(-1073740696i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_IN_MAINTENANCE: NTSTATUS = NTSTATUS(-1073740647i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_NOT_CONNECTED: NTSTATUS = NTSTATUS(-1073741667i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_NOT_PARTITIONED: NTSTATUS = NTSTATUS(-1073741452i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_NOT_READY: NTSTATUS = NTSTATUS(-1073741661i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_OFF_LINE: NTSTATUS = NTSTATUS(-2147483632i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_PAPER_EMPTY: NTSTATUS = NTSTATUS(-2147483634i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_POWERED_OFF: NTSTATUS = NTSTATUS(-2147483633i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_POWER_CYCLE_REQUIRED: NTSTATUS = NTSTATUS(-2147483599i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_POWER_FAILURE: NTSTATUS = NTSTATUS(-1073741666i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_PROTOCOL_ERROR: NTSTATUS = NTSTATUS(-1073741434i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_REMOVED: NTSTATUS = NTSTATUS(-1073741130i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_REQUIRES_CLEANING: NTSTATUS = NTSTATUS(-2147483000i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_RESET_REQUIRED: NTSTATUS = NTSTATUS(-2147483210i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_SUPPORT_IN_PROGRESS: NTSTATUS = NTSTATUS(-2147483600i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_UNREACHABLE: NTSTATUS = NTSTATUS(-1073740700i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DEVICE_UNRESPONSIVE: NTSTATUS = NTSTATUS(-1073740534i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DFS_EXIT_PATH_FOUND: NTSTATUS = NTSTATUS(-1073741669i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DFS_UNAVAILABLE: NTSTATUS = NTSTATUS(-1073741203i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_BINDING_API_NOT_FOUND: NTSTATUS = NTSTATUS(-1073738625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_IOCALLBACK_NOT_REPLACED: NTSTATUS = NTSTATUS(-1073738634i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_LIVEDUMP_LIMIT_EXCEEDED: NTSTATUS = NTSTATUS(-1073738633i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_VOLATILE_DRIVER_HOTPATCHED: NTSTATUS = NTSTATUS(-1073738631i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_VOLATILE_DRIVER_IS_NOT_RUNNING: NTSTATUS = NTSTATUS(-1073738629i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_VOLATILE_INVALID_INFO: NTSTATUS = NTSTATUS(-1073738630i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_VOLATILE_NOT_ALLOWED: NTSTATUS = NTSTATUS(-1073738626i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_VOLATILE_PLUGIN_CHANGE_NOT_ALLOWED: NTSTATUS = NTSTATUS(-1073738627i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_VOLATILE_PLUGIN_IS_NOT_RUNNING: NTSTATUS = NTSTATUS(-1073738628i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIF_VOLATILE_SECTION_NOT_LOCKED: NTSTATUS = NTSTATUS(-1073738632i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIRECTORY_IS_A_REPARSE_POINT: NTSTATUS = NTSTATUS(-1073741183i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIRECTORY_NOT_EMPTY: NTSTATUS = NTSTATUS(-1073741567i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIRECTORY_NOT_RM: NTSTATUS = NTSTATUS(-1072103416i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIRECTORY_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073740676i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DIRECTORY_SERVICE_REQUIRED: NTSTATUS = NTSTATUS(-1073741135i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_CORRUPT_ERROR: NTSTATUS = NTSTATUS(-1073741774i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_FULL: NTSTATUS = NTSTATUS(-1073741697i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_OPERATION_FAILED: NTSTATUS = NTSTATUS(-1073741462i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_QUOTA_EXCEEDED: NTSTATUS = NTSTATUS(-1073739774i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_RECALIBRATE_FAILED: NTSTATUS = NTSTATUS(-1073741463i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_REPAIR_DISABLED: NTSTATUS = NTSTATUS(-1073739776i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_REPAIR_REDIRECTED: NTSTATUS = NTSTATUS(1073743879i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_REPAIR_UNSUCCESSFUL: NTSTATUS = NTSTATUS(-1073739768i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_RESET_FAILED: NTSTATUS = NTSTATUS(-1073741461i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DISK_RESOURCES_EXHAUSTED: NTSTATUS = NTSTATUS(-1073740703i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DLL_INIT_FAILED: NTSTATUS = NTSTATUS(-1073741502i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DLL_INIT_FAILED_LOGOFF: NTSTATUS = NTSTATUS(-1073741205i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DLL_MIGHT_BE_INCOMPATIBLE: NTSTATUS = NTSTATUS(-2147483604i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DLL_MIGHT_BE_INSECURE: NTSTATUS = NTSTATUS(-2147483605i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DLL_NOT_FOUND: NTSTATUS = NTSTATUS(-1073741515i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DM_OPERATION_LIMIT_EXCEEDED: NTSTATUS = NTSTATUS(-1070135808i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DOMAIN_CONTROLLER_NOT_FOUND: NTSTATUS = NTSTATUS(-1073741261i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DOMAIN_CTRLR_CONFIG_ERROR: NTSTATUS = NTSTATUS(-1073741474i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DOMAIN_EXISTS: NTSTATUS = NTSTATUS(-1073741600i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DOMAIN_LIMIT_EXCEEDED: NTSTATUS = NTSTATUS(-1073741599i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DOMAIN_TRUST_INCONSISTENT: NTSTATUS = NTSTATUS(-1073741413i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVERS_LEAKING_LOCKED_PAGES: NTSTATUS = NTSTATUS(1073741869i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_BLOCKED: NTSTATUS = NTSTATUS(-1073740948i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_BLOCKED_CRITICAL: NTSTATUS = NTSTATUS(-1073740949i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_CANCEL_TIMEOUT: NTSTATUS = NTSTATUS(-1073741282i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_DATABASE_ERROR: NTSTATUS = NTSTATUS(-1073740947i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_ENTRYPOINT_NOT_FOUND: NTSTATUS = NTSTATUS(-1073741213i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_FAILED_PRIOR_UNLOAD: NTSTATUS = NTSTATUS(-1073740914i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_FAILED_SLEEP: NTSTATUS = NTSTATUS(-1073741118i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_INTERNAL_ERROR: NTSTATUS = NTSTATUS(-1073741437i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_ORDINAL_NOT_FOUND: NTSTATUS = NTSTATUS(-1073741214i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_PROCESS_TERMINATED: NTSTATUS = NTSTATUS(-1073740720i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DRIVER_UNABLE_TO_LOAD: NTSTATUS = NTSTATUS(-1073741204i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_ADMIN_LIMIT_EXCEEDED: NTSTATUS = NTSTATUS(-1073741119i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER: NTSTATUS = NTSTATUS(-1073740968i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS: NTSTATUS = NTSTATUS(-1073741148i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED: NTSTATUS = NTSTATUS(-1073741149i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_BUSY: NTSTATUS = NTSTATUS(-1073741147i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_CANT_MOD_OBJ_CLASS: NTSTATUS = NTSTATUS(-1073741138i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_CANT_MOD_PRIMARYGROUPID: NTSTATUS = NTSTATUS(-1073741104i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_CANT_ON_NON_LEAF: NTSTATUS = NTSTATUS(-1073741140i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_CANT_ON_RDN: NTSTATUS = NTSTATUS(-1073741139i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_CANT_START: NTSTATUS = NTSTATUS(-1073741087i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_CROSS_DOM_MOVE_FAILED: NTSTATUS = NTSTATUS(-1073741137i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST: NTSTATUS = NTSTATUS(-1073740774i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_DOMAIN_RENAME_IN_PROGRESS: NTSTATUS = NTSTATUS(-1073739775i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_DUPLICATE_ID_FOUND: NTSTATUS = NTSTATUS(-1073740795i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST: NTSTATUS = NTSTATUS(-1073740773i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_GC_NOT_AVAILABLE: NTSTATUS = NTSTATUS(-1073741136i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_GC_REQUIRED: NTSTATUS = NTSTATUS(-1073741084i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER: NTSTATUS = NTSTATUS(-1073741094i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER: NTSTATUS = NTSTATUS(-1073741097i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER: NTSTATUS = NTSTATUS(-1073741096i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_GROUP_CONVERSION_ERROR: NTSTATUS = NTSTATUS(-1073740794i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_HAVE_PRIMARY_MEMBERS: NTSTATUS = NTSTATUS(-1073741092i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_INCORRECT_ROLE_OWNER: NTSTATUS = NTSTATUS(-1073741143i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_INIT_FAILURE: NTSTATUS = NTSTATUS(-1073741086i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_INIT_FAILURE_CONSOLE: NTSTATUS = NTSTATUS(-1073741076i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_INVALID_ATTRIBUTE_SYNTAX: NTSTATUS = NTSTATUS(-1073741150i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_INVALID_GROUP_TYPE: NTSTATUS = NTSTATUS(-1073741100i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER: NTSTATUS = NTSTATUS(-1073741093i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY: NTSTATUS = NTSTATUS(-1073741083i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED: NTSTATUS = NTSTATUS(-1073741081i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY: NTSTATUS = NTSTATUS(289i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_NAME_NOT_UNIQUE: NTSTATUS = NTSTATUS(-1073740796i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_NO_ATTRIBUTE_OR_VALUE: NTSTATUS = NTSTATUS(-1073741151i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS: NTSTATUS = NTSTATUS(-1073741082i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_NO_MORE_RIDS: NTSTATUS = NTSTATUS(-1073741144i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN: NTSTATUS = NTSTATUS(-1073741099i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN: NTSTATUS = NTSTATUS(-1073741098i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_NO_RIDS_ALLOCATED: NTSTATUS = NTSTATUS(-1073741145i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_OBJ_CLASS_VIOLATION: NTSTATUS = NTSTATUS(-1073741141i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS: NTSTATUS = NTSTATUS(-1073700729i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_OID_NOT_FOUND: NTSTATUS = NTSTATUS(-1073700728i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_RIDMGR_DISABLED: NTSTATUS = NTSTATUS(-1073741126i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_RIDMGR_INIT_ERROR: NTSTATUS = NTSTATUS(-1073741142i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_SAM_INIT_FAILURE: NTSTATUS = NTSTATUS(-1073741109i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_SAM_INIT_FAILURE_CONSOLE: NTSTATUS = NTSTATUS(-1073741075i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_SENSITIVE_GROUP_VIOLATION: NTSTATUS = NTSTATUS(-1073741107i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_SHUTTING_DOWN: NTSTATUS = NTSTATUS(1073742704i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_SRC_SID_EXISTS_IN_FOREST: NTSTATUS = NTSTATUS(-1073740775i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_UNAVAILABLE: NTSTATUS = NTSTATUS(-1073741146i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER: NTSTATUS = NTSTATUS(-1073741095i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DS_VERSION_CHECK_FAILURE: NTSTATUS = NTSTATUS(-1073740971i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DUPLICATE_NAME: NTSTATUS = NTSTATUS(-1073741635i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DUPLICATE_OBJECTID: NTSTATUS = NTSTATUS(-1073741270i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DUPLICATE_PRIVILEGES: NTSTATUS = NTSTATUS(-1073741402i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_DYNAMIC_CODE_BLOCKED: NTSTATUS = NTSTATUS(-1073740284i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EAS_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073741745i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EA_CORRUPT_ERROR: NTSTATUS = NTSTATUS(-1073741741i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EA_LIST_INCONSISTENT: NTSTATUS = NTSTATUS(-2147483628i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EA_TOO_LARGE: NTSTATUS = NTSTATUS(-1073741744i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EFS_ALG_BLOB_TOO_BIG: NTSTATUS = NTSTATUS(-1073740974i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION: NTSTATUS = NTSTATUS(-1072103362i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ELEVATION_REQUIRED: NTSTATUS = NTSTATUS(-1073740756i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EMULATION_BREAKPOINT: NTSTATUS = NTSTATUS(1073741880i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EMULATION_SYSCALL: NTSTATUS = NTSTATUS(1073741881i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCLAVE_FAILURE: NTSTATUS = NTSTATUS(-1073740657i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCLAVE_IS_TERMINATING: NTSTATUS = NTSTATUS(-1073740526i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCLAVE_NOT_TERMINATED: NTSTATUS = NTSTATUS(-1073740527i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCLAVE_VIOLATION: NTSTATUS = NTSTATUS(-1073740638i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCOUNTERED_WRITE_IN_PROGRESS: NTSTATUS = NTSTATUS(-1073740749i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCRYPTED_FILE_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073740605i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCRYPTED_IO_NOT_POSSIBLE: NTSTATUS = NTSTATUS(-1073739760i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCRYPTING_METADATA_DISALLOWED: NTSTATUS = NTSTATUS(-1073740617i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCRYPTION_DISABLED: NTSTATUS = NTSTATUS(-1073740618i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENCRYPTION_FAILED: NTSTATUS = NTSTATUS(-1073741174i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_END_OF_FILE: NTSTATUS = NTSTATUS(-1073741807i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_END_OF_MEDIA: NTSTATUS = NTSTATUS(-2147483618i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENLISTMENT_NOT_FOUND: NTSTATUS = NTSTATUS(-1072103344i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENLISTMENT_NOT_SUPERIOR: NTSTATUS = NTSTATUS(-1072103373i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ENTRYPOINT_NOT_FOUND: NTSTATUS = NTSTATUS(-1073741511i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EOF_ON_GHOSTED_RANGE: NTSTATUS = NTSTATUS(-1073700857i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EOM_OVERFLOW: NTSTATUS = NTSTATUS(-1073741449i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_ERROR_PROCESS_NOT_IN_JOB: NTSTATUS = NTSTATUS(-1073741394i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EVALUATION_EXPIRATION: NTSTATUS = NTSTATUS(-1073741208i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EVENTLOG_CANT_START: NTSTATUS = NTSTATUS(-1073741425i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EVENTLOG_FILE_CHANGED: NTSTATUS = NTSTATUS(-1073741417i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EVENTLOG_FILE_CORRUPT: NTSTATUS = NTSTATUS(-1073741426i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EVENT_DONE: NTSTATUS = NTSTATUS(1073741842i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EVENT_PENDING: NTSTATUS = NTSTATUS(1073741843i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EXECUTABLE_MEMORY_WRITE: NTSTATUS = NTSTATUS(-1073739997i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EXPIRED_HANDLE: NTSTATUS = NTSTATUS(-1072103328i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EXTERNAL_BACKING_PROVIDER_UNKNOWN: NTSTATUS = NTSTATUS(-1073740690i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EXTERNAL_SYSKEY_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073740639i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_EXTRANEOUS_INFORMATION: NTSTATUS = NTSTATUS(-2147483625i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FAILED_DRIVER_ENTRY: NTSTATUS = NTSTATUS(-1073740955i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FAILED_STACK_SWITCH: NTSTATUS = NTSTATUS(-1073740941i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FAIL_CHECK: NTSTATUS = NTSTATUS(-1073741271i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FAIL_FAST_EXCEPTION: NTSTATUS = NTSTATUS(-1073740286i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FASTPATH_REJECTED: NTSTATUS = NTSTATUS(-1073700844i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FATAL_APP_EXIT: NTSTATUS = NTSTATUS(1073741845i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FATAL_MEMORY_EXHAUSTION: NTSTATUS = NTSTATUS(-1073741395i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FATAL_USER_CALLBACK_EXCEPTION: NTSTATUS = NTSTATUS(-1073740771i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILEMARK_DETECTED: NTSTATUS = NTSTATUS(-2147483621i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILES_OPEN: NTSTATUS = NTSTATUS(-1073741561i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_CHECKED_OUT: NTSTATUS = NTSTATUS(-1073739519i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_CLOSED: NTSTATUS = NTSTATUS(-1073741528i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_CORRUPT_ERROR: NTSTATUS = NTSTATUS(-1073741566i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_DELETED: NTSTATUS = NTSTATUS(-1073741533i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_ENCRYPTED: NTSTATUS = NTSTATUS(-1073741165i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_FORCED_CLOSED: NTSTATUS = NTSTATUS(-1073741642i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_HANDLE_REVOKED: NTSTATUS = NTSTATUS(-1073739504i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_IDENTITY_NOT_PERSISTENT: NTSTATUS = NTSTATUS(-1072103370i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_INVALID: NTSTATUS = NTSTATUS(-1073741672i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_IS_A_DIRECTORY: NTSTATUS = NTSTATUS(-1073741638i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_IS_OFFLINE: NTSTATUS = NTSTATUS(-1073741209i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_LOCKED_WITH_ONLY_READERS: NTSTATUS = NTSTATUS(298i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_LOCKED_WITH_WRITERS: NTSTATUS = NTSTATUS(299i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_LOCK_CONFLICT: NTSTATUS = NTSTATUS(-1073741740i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_METADATA_OPTIMIZATION_IN_PROGRESS: NTSTATUS = NTSTATUS(-1073741397i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_NOT_AVAILABLE: NTSTATUS = NTSTATUS(-1073740697i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_NOT_ENCRYPTED: NTSTATUS = NTSTATUS(-1073741167i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073740620i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_PROTECTED_UNDER_DPL: NTSTATUS = NTSTATUS(-1073740637i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_RENAMED: NTSTATUS = NTSTATUS(-1073741611i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_SNAP_INVALID_PARAMETER: NTSTATUS = NTSTATUS(-1073679099i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_SNAP_IN_PROGRESS: NTSTATUS = NTSTATUS(-1073679104i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_SNAP_IO_NOT_COORDINATED: NTSTATUS = NTSTATUS(-1073679101i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_SNAP_MODIFY_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073679102i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_SNAP_UNEXPECTED_ERROR: NTSTATUS = NTSTATUS(-1073679100i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_SNAP_USER_SECTION_NOT_SUPPORTED: NTSTATUS = NTSTATUS(-1073679103i32);
#[doc = "*Required features: `\"Win32_Foundation\"`*"]
pub const STATUS_FILE_SYST