/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CLOG_H
#define CLOG_H

#define LOG_SUCCESS	( 0)
#define LOG_FAILURE	(-1)

#include <unistd.h>
extern "C" {
#include <syslog.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
}

using namespace std;

typedef enum _msgtype_ {
	msg_alert=LOG_ALERT,
	msg_critical=LOG_CRIT,
	msg_error=LOG_ERR,
	msg_warning=LOG_WARNING,
	msg_notice=LOG_NOTICE,
	msg_info=LOG_INFO
} msgtype;

/**
@author Tomasz Fiszer
*/
class CLog{
private:
	char	*logname,		/* syslog name - only used when syslog option is set */
			*filepath,		/* full path to log file */
			*data_buff;		/* data buffer for buffered mode */
	bool	bsyslog,		/* use syslog to log events. can be used together with private log */
			bprvlog,		/* use private log to log events. can be used together with syslog */
			bread,			/* opened for read only */
			bbuffered;		/* buffered mode */
	FILE	*fprvlog;		/* private log file stream */
	long	data_length;
	int	openprvlog(char *fp);
	
public:

	CLog();
	CLog(char *fp, char *ln) {
		filepath = fp;
		logname = ln;
		bbuffered=bprvlog=bsyslog=false;
		if (fp!=NULL) {
			bprvlog=true;
			openprvlog(filepath);
		}
		if (ln!=NULL) {
			bsyslog=true;
			openlog(logname, LOG_PID|LOG_NDELAY, LOG_DAEMON);
		}
	};
	~CLog();

	// open for write
	int open(char *fp, char *ln);
	// open for read
	int open_read(char *fp);
	int open_read_buff(char *fp);
	int new_msg(msgtype t, char *content, ...);
	int new_syslog_msg(msgtype t, char *content, ...);
	int read_msg(struct tm *evtime, msgtype *t, char *buff, int buffsize, long *line);
	int get_linecount(long *lines);
	char* token(char *src, char *res, char delim);
	char* token(char *src, char *res, char delim, int tokidx);
	int close() {
		if (bbuffered) {
			free(data_buff);
			data_length=0;
			bbuffered = false;
		}
		if (bsyslog) {
			closelog();
			bsyslog=false;
		}
		if (bprvlog && fprvlog!=NULL) {
			if (fclose(fprvlog)==0) fprvlog=NULL;
			bprvlog=false;
		}
		return LOG_SUCCESS;
	};
};

#endif/*CLOG_H*/
