//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;

use crate::*;

/// Returns an array of unique PostScript font names.
///
///
/// Returns: An array of CFStrings.
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCopyAvailablePostScriptNames() -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontManagerCopyAvailablePostScriptNames() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontManagerCopyAvailablePostScriptNames() };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

/// Returns an array of visible font family names sorted for UI display.
///
///
/// Returns: An array of CFStrings.
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCopyAvailableFontFamilyNames() -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontManagerCopyAvailableFontFamilyNames() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontManagerCopyAvailableFontFamilyNames() };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

/// Returns an array of font URLs.
///
///
/// Returns: An array of CFURLs.
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCopyAvailableFontURLs() -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontManagerCopyAvailableFontURLs() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontManagerCopyAvailableFontURLs() };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    /// A CFComparatorFunction to compare font family names and sort them according to Apple guidelines.
    ///
    /// This function compares font family names and sorts them in the preferred order for display in user interfaces.
    ///
    /// Parameter `family1`: The first localized font family name, as CFStringRef.
    ///
    /// Parameter `family2`: The second localized font family name, as CFStringRef.
    ///
    /// Parameter `context`: Unused. Can be NULL.
    ///
    /// Returns: A CFComparisonResult value indicating the sort order for the two family names. kCFComparisonResultGreaterThan if family1 is greater than family2, kCFComparisonResultLessThan if family1 is less than family2, and kCFComparisonResultEqualTo if they are equal.
    ///
    /// # Safety
    ///
    /// - `family1` must be a valid pointer.
    /// - `family2` must be a valid pointer.
    /// - `context` must be a valid pointer or null.
    pub fn CTFontManagerCompareFontFamilyNames(
        family1: NonNull<c_void>,
        family2: NonNull<c_void>,
        context: *mut c_void,
    ) -> CFComparisonResult;
}

/// Returns an array of font descriptors representing each of the fonts in the specified URL.
/// Note: these font descriptors are not available through font descriptor matching.
///
///
/// Parameter `fileURL`: A file system URL referencing a valid font file.
///
///
/// Returns: An array of CTFontDescriptors or NULL if there are no valid fonts.
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCreateFontDescriptorsFromURL(
    file_url: &CFURL,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontManagerCreateFontDescriptorsFromURL(file_url: &CFURL) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontManagerCreateFontDescriptorsFromURL(file_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns a font descriptor representing the font in the supplied data.
/// Note: the font descriptor is not available through font descriptor matching.
///
///
/// If the data contains a font collection (TTC or OTC), only the first font in the collection will be returned.
///
///
/// Parameter `data`: A CFData containing font data.
///
///
/// Returns: A font descriptor created from the data or NULL if it is not a valid font.
#[cfg(feature = "CTFontDescriptor")]
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCreateFontDescriptorFromData(
    data: &CFData,
) -> Option<CFRetained<CTFontDescriptor>> {
    extern "C-unwind" {
        fn CTFontManagerCreateFontDescriptorFromData(
            data: &CFData,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe { CTFontManagerCreateFontDescriptorFromData(data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns an array of font descriptors for the fonts in the supplied data.
/// Note: the font descriptors are not available through font descriptor matching.
///
///
/// Parameter `data`: A CFData containing font data.
///
///
/// Returns: An array of font descriptors. This can be an empty array in the event of invalid or unsupported font data.
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCreateFontDescriptorsFromData(
    data: &CFData,
) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontManagerCreateFontDescriptorsFromData(data: &CFData) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontManagerCreateFontDescriptorsFromData(data) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

/// Scope for font registration. A uses session refers to a login session in macOS, and the current booted session in iOS.
///
/// The font is not registered and does not participate in font descriptor matching. This isn't a valid scope to specify while registering fonts.
///
/// The font is available to the current process for the duration of the process unless directly unregistered.
///
/// The font is available to all processes for the current user session and will be available in subsequent sessions unless unregistered.
///
/// The font is available to the current user session, and will not be available in subsequent sessions.
/// Session scope is only available in macOS.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontmanagerscope?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontManagerScope(pub u32);
impl CTFontManagerScope {
    #[doc(alias = "kCTFontManagerScopeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "kCTFontManagerScopeProcess")]
    pub const Process: Self = Self(1);
    #[doc(alias = "kCTFontManagerScopePersistent")]
    pub const Persistent: Self = Self(2);
    #[doc(alias = "kCTFontManagerScopeSession")]
    pub const Session: Self = Self(3);
    #[doc(alias = "kCTFontManagerScopeUser")]
    pub const User: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontManagerScope {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontManagerScope {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// kCTFontRegistrationUserInfoAttribute
    ///
    /// Optional user defined information that can be attached to an entry in the Font Manager registration catalog.
    ///
    /// This is the key for accessing font registration user information for the font descriptor. This information can be used in descriptor matching to disambiguate between two fonts with equivalent Postscript names. The value associated with this key is a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontregistrationuserinfoattribute?language=objc)
    pub static kCTFontRegistrationUserInfoAttribute: &'static CFString;
}

extern "C-unwind" {
    /// Registers fonts from the specified font URL with the font manager. Registered fonts participate in font descriptor matching.
    ///
    ///
    /// Parameter `fontURL`: A file URL for the font or collection (TTC or OTC) to be registered. Once fonts have been registered from a file, it shouldn't be moved or renamed.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. See scope constants for more details.
    ///
    ///
    /// Parameter `error`: Pointer to receive CFError in the case of failed registration.
    ///
    ///
    /// Returns: Returns true if registration of the fonts was successful.
    ///
    /// # Safety
    ///
    /// `error` must be a valid pointer or null.
    pub fn CTFontManagerRegisterFontsForURL(
        font_url: &CFURL,
        scope: CTFontManagerScope,
        error: *mut *mut CFError,
    ) -> bool;
}

extern "C-unwind" {
    /// Unregisters fonts from the specified font URL with the font manager. Unregistered fonts do not participate in font descriptor matching.
    /// iOS note: only fonts registered with CTFontManagerRegisterFontsForURL or CTFontManagerRegisterFontsForURLs can be unregistered with this API.
    ///
    ///
    /// Parameter `fontURL`: Font URL.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. Should match the scope the fonts are registered in. See scope constants for more details.
    ///
    ///
    /// Parameter `error`: Pointer to receive CFError in the case of failed unregistration.
    ///
    ///
    /// Returns: Returns true if unregistration of the fonts was successful.
    ///
    /// # Safety
    ///
    /// `error` must be a valid pointer or null.
    pub fn CTFontManagerUnregisterFontsForURL(
        font_url: &CFURL,
        scope: CTFontManagerScope,
        error: *mut *mut CFError,
    ) -> bool;
}

extern "C-unwind" {
    /// Registers the specified graphics font with the font manager. Registered fonts participate in font descriptor matching.
    ///
    ///
    /// Attempts to register a font that is either already registered or contains the same PostScript name of an already registered font will fail.
    /// This functionality is intended for fonts that may be embedded in documents or present/constructed in memory. A graphics font is obtained
    /// by calling CGFontCreateWithDataProvider. Fonts that are backed by files should be registered using CTFontManagerRegisterFontsForURL.
    ///
    ///
    /// Parameter `font`: Graphics font to be registered.
    ///
    ///
    /// Parameter `error`: Pointer to receive CFError in the case of failed registration.
    ///
    ///
    /// Returns: Returns true if registration of the fonts was successful.
    ///
    /// # Safety
    ///
    /// `error` must be a valid pointer or null.
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "Use CTFontManagerCreateFontDescriptorsFromData or CTFontManagerRegisterFontsForURL"]
    pub fn CTFontManagerRegisterGraphicsFont(font: &CGFont, error: *mut *mut CFError) -> bool;
}

extern "C-unwind" {
    /// Unregisters the specified graphics font with the font manager. Unregistered fonts do not participate in font descriptor matching.
    ///
    ///
    /// Parameter `font`: Graphics font to be unregistered.
    ///
    ///
    /// Parameter `error`: Pointer to receive CFError in the case of failed unregistration.
    ///
    ///
    /// Returns: Returns true if unregistration of the font was successful.
    ///
    /// # Safety
    ///
    /// `error` must be a valid pointer or null.
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "Use the API corresponding to the one used to register the font"]
    pub fn CTFontManagerUnregisterGraphicsFont(font: &CGFont, error: *mut *mut CFError) -> bool;
}

extern "C-unwind" {
    /// Registers fonts from the specified font URLs with the font manager. Registered fonts are discoverable through font descriptor matching.
    ///
    ///
    /// Parameter `fontURLs`: An array of file URLs for the fonts or collections (TTC or OTC) to be registered. Once fonts have been registered from a file, it shouldn't be moved or renamed.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. See scope constants for more details.
    ///
    ///
    /// Parameter `errors`: Pointer to CFArrayRef to receive array of CFError references. Each error will contain a CFArray of font URLs corresponding to kCTFontManagerErrorFontURLsKey. These URLs represent the font files that caused the error, and were not successfully registered. Must be released by caller. Can be NULL.
    ///
    ///
    /// Returns: Returns true if registration of all font URLs was successful. Otherwise false.
    ///
    /// # Safety
    ///
    /// - `font_ur_ls` generic must be of the correct type.
    /// - `errors` must be a valid pointer or null.
    #[deprecated]
    pub fn CTFontManagerRegisterFontsForURLs(
        font_ur_ls: &CFArray,
        scope: CTFontManagerScope,
        errors: *mut *const CFArray,
    ) -> bool;
}

extern "C-unwind" {
    /// Unregisters fonts from the specified font URLs with the font manager. Unregistered fonts do not participate in font descriptor matching.
    /// iOS note: only fonts registered with CTFontManagerRegisterFontsForURL or CTFontManagerRegisterFontsForURLs can be unregistered with this API.
    ///
    ///
    /// Parameter `fontURLs`: Array of font URLs.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. Should match the scope the fonts are registered in. See scope constants for more details.
    ///
    ///
    /// Parameter `errors`: Pointer to CFArrayRef to receive array of CFError references. Each error will contain a CFArray of font URLs corresponding to kCTFontManagerErrorFontURLsKey. These URLs represent the font files that caused the error, and were not successfully unregistered. Must be released by caller. Can be NULL.
    ///
    ///
    /// Returns: Returns true if unregistration of all font URLs was successful. Otherwise false.
    ///
    /// # Safety
    ///
    /// - `font_ur_ls` generic must be of the correct type.
    /// - `errors` must be a valid pointer or null.
    #[deprecated]
    pub fn CTFontManagerUnregisterFontsForURLs(
        font_ur_ls: &CFArray,
        scope: CTFontManagerScope,
        errors: *mut *const CFArray,
    ) -> bool;
}

extern "C-unwind" {
    /// Registers fonts from the specified font URLs with the font manager. Registered fonts are discoverable through font descriptor matching in the calling process
    ///
    ///
    /// In iOS, fonts registered with the persistent scope are not automatically available to other processes. Other process may call CTFontManagerRequestFonts to get access to these fonts.
    ///
    ///
    /// Parameter `fontURLs`: A file URL for the fonts or collections (TTC or OTC) to be registered. Once fonts have been registered from a file, it shouldn't be moved or renamed.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. See scope constants for more details.
    ///
    ///
    /// Parameter `enabled`: Boolean value indicating whether the font derived from the URL should be enabled for font descriptor matching and/or discoverable via CTFontManagerRequestFonts.
    ///
    ///
    /// Parameter `registrationHandler`: Block called as errors are discovered or upon completion. The errors parameter contains an array of CFError references. An empty array indicates no errors. Each error reference will contain a CFArray of font URLs corresponding to kCTFontManagerErrorFontURLsKey. These URLs represent the font files that caused the error, and were not successfully registered. Note, the handler may be called multiple times during the registration process. The done parameter will be set to true when the registration process has completed. The handler should return false if the operation is to be stopped. This may be desirable after receiving an error.
    ///
    /// # Safety
    ///
    /// `font_ur_ls` generic must be of the correct type.
    #[cfg(feature = "block2")]
    pub fn CTFontManagerRegisterFontURLs(
        font_ur_ls: &CFArray,
        scope: CTFontManagerScope,
        enabled: bool,
        registration_handler: Option<&block2::DynBlock<dyn Fn(NonNull<CFArray>, bool) -> bool>>,
    );
}

extern "C-unwind" {
    /// Unregisters fonts from the specified font URLs with the font manager. Unregistered fonts do not participate in font descriptor matching.
    /// iOS note: only fonts registered with CTFontManagerRegisterFontsForURL or CTFontManagerRegisterFontsForURLs can be unregistered with this API.
    ///
    ///
    /// Parameter `fontURLs`: Array of font URLs.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. Should match the scope the fonts are registered in. See scope constants for more details.
    ///
    ///
    /// Parameter `registrationHandler`: Block called as errors are discovered or upon completion. The errors parameter will be an empty array if all files are unregistered. Otherwise, it will contain an array of CFError references. Each error reference will contain a CFArray of font URLs corresponding to kCTFontManagerErrorFontURLsKey. These URLs represent the font files that caused the error, and were not successfully unregistered. Note, the handler may be called multiple times during the unregistration process. The done parameter will be set to true when the unregistration process has completed. The handler should return false if the operation is to be stopped. This may be desirable after receiving an error.
    ///
    /// # Safety
    ///
    /// `font_ur_ls` generic must be of the correct type.
    #[cfg(feature = "block2")]
    pub fn CTFontManagerUnregisterFontURLs(
        font_ur_ls: &CFArray,
        scope: CTFontManagerScope,
        registration_handler: Option<&block2::DynBlock<dyn Fn(NonNull<CFArray>, bool) -> bool>>,
    );
}

extern "C-unwind" {
    /// Registers font descriptors with the font manager. Registered fonts are discoverable through font descriptor matching in the calling process.
    ///
    ///
    /// Fonts descriptors registered in disabled state are not immediately available for descriptor matching but the font manager will know the descriptors could be made available if necessary. These decriptors can be enabled by making this called again with the enabled parameter set to true. This operation may fail if there is another font registered and enabled with the same Postscript name. In iOS, fonts registered with the persistent scope are not automatically available to other processes. Other process may call CTFontManagerRequestFonts to get access to these fonts.
    ///
    ///
    /// Parameter `fontDescriptors`: Array of font descriptors to register. Font descriptor keys used for registration are: kCTFontURLAttribute, kCTFontNameAttribute, kCTFontFamilyNameAttribute, or kCTFontRegistrationUserInfoAttribute.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. See scope constants for more details.
    ///
    ///
    /// Parameter `enabled`: Boolean value indicating whether the font descriptors should be enabled for font descriptor matching and/or discoverable via CTFontManagerRequestFonts.
    ///
    ///
    /// Parameter `registrationHandler`: Block called as errors are discovered or upon completion. The errors parameter contains an array of CFError references. An empty array indicates no errors. Each error reference will contain a CFArray of font descriptors corresponding to kCTFontManagerErrorFontDescriptorsKey. These represent the font descriptors that caused the error, and were not successfully registered. Note, the handler may be called multiple times during the registration process. The done parameter will be set to true when the registration process has completed. The handler should return false if the operation is to be stopped. This may be desirable after receiving an error.
    ///
    /// # Safety
    ///
    /// `font_descriptors` generic must be of the correct type.
    #[cfg(feature = "block2")]
    pub fn CTFontManagerRegisterFontDescriptors(
        font_descriptors: &CFArray,
        scope: CTFontManagerScope,
        enabled: bool,
        registration_handler: Option<&block2::DynBlock<dyn Fn(NonNull<CFArray>, bool) -> bool>>,
    );
}

extern "C-unwind" {
    /// Unregisters font descriptors with the font manager. Unregistered fonts do not participate in font descriptor matching.
    ///
    ///
    /// Parameter `fontDescriptors`: Array of font descriptors to unregister.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. See scope constants for more details.
    ///
    ///
    /// Parameter `registrationHandler`: Block called as errors are discovered or upon completion. The errors parameter will be an empty array if all font descriptors are unregistered. Otherwise, it will contain an array of CFError references. Each error reference will contain a CFArray of font descriptors corresponding to kCTFontManagerErrorFontDescriptorsKey. These represent the font descriptors that caused the error, and were not successfully unregistered. Note, the handler may be called multiple times during the unregistration process. The done parameter will be set to true when the unregistration process has completed. The handler should return false if the operation is to be stopped. This may be desirable after receiving an error.
    ///
    /// # Safety
    ///
    /// `font_descriptors` generic must be of the correct type.
    #[cfg(feature = "block2")]
    pub fn CTFontManagerUnregisterFontDescriptors(
        font_descriptors: &CFArray,
        scope: CTFontManagerScope,
        registration_handler: Option<&block2::DynBlock<dyn Fn(NonNull<CFArray>, bool) -> bool>>,
    );
}

extern "C-unwind" {
    /// Registers named font assets in the specified bundle with the font manager. Registered fonts are discoverable through font descriptor matching in the calling process.
    ///
    ///
    /// Font assets are extracted from the asset catalog and registered. This call must be made after the completion handler of either NSBundleResourceRequest beginAccessingResourcesWithCompletionHandler: or conditionallyBeginAccessingResourcesWithCompletionHandler: is called successfully.
    /// Name the assets using Postscript names for individual faces, or family names for variable/collection fonts. The same names can be used to unregister the fonts with CTFontManagerUnregisterFontDescriptors. In iOS, fonts registered with the persistent scope are not automatically available to other processes. Other process may call CTFontManagerRequestFonts to get access to these fonts.
    ///
    ///
    /// Parameter `fontAssetNames`: Array of font name assets in asset catalog.
    ///
    ///
    /// Parameter `bundle`: Bundle containing asset catalog. A null value resolves to the main bundle.
    ///
    ///
    /// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. kCTFontManagerScopePersistent is the only supported scope for iOS.
    ///
    ///
    /// Parameter `enabled`: Boolean value indicating whether the font assets should be enabled for font descriptor matching and/or discoverable via CTFontManagerRequestFonts.
    ///
    ///
    /// Parameter `registrationHandler`: Block called as errors are discovered, or upon completion. The errors parameter contains an array of CFError references. An empty array indicates no errors. Each error reference will contain a CFArray of font asset names corresponding to kCTFontManagerErrorFontAssetNameKey. These represent the font asset names that were not successfully registered. Note, the handler may be called multiple times during the registration process. The done parameter will be set to true when the registration process has completed. The handler should return false if the operation is to be stopped. This may be desirable after receiving an error.
    ///
    /// # Safety
    ///
    /// `font_asset_names` generic must be of the correct type.
    #[cfg(feature = "block2")]
    pub fn CTFontManagerRegisterFontsWithAssetNames(
        font_asset_names: &CFArray,
        bundle: Option<&CFBundle>,
        scope: CTFontManagerScope,
        enabled: bool,
        registration_handler: Option<&block2::DynBlock<dyn Fn(NonNull<CFArray>, bool) -> bool>>,
    );
}

extern "C-unwind" {
    /// Enables or disables the matching font descriptors for font descriptor matching.
    ///
    ///
    /// Parameter `descriptors`: Array of font descriptors.
    ///
    ///
    /// Parameter `enable`: Boolean value indicating whether the fonts matching descriptors should be enabled for font descriptor matching.
    ///
    /// # Safety
    ///
    /// `descriptors` generic must be of the correct type.
    pub fn CTFontManagerEnableFontDescriptors(descriptors: &CFArray, enable: bool);
}

extern "C-unwind" {
    /// Returns the registration scope of the specified URL.
    ///
    ///
    /// Parameter `fontURL`: Font URL.
    ///
    ///
    /// Returns: Returns the registration scope of the specified URL, will return kCTFontManagerScopeNone if not currently registered.
    pub fn CTFontManagerGetScopeForURL(font_url: &CFURL) -> CTFontManagerScope;
}

/// Returns the font descriptors that were registered with the font manager.
///
///
/// In the case the persistent scope is specified, only macOS can return fonts registered by any process. Other platforms can only return font descriptors registered by the application's process.
///
///
/// Parameter `scope`: Scope constant defining the availability and lifetime of the registration. See scope constants for more details.
///
///
/// Parameter `enabled`: Boolean value indicating if the caller is interested in registered font descriptors that are enabled or disabled.
///
///
/// Returns: Array of of font descriptors registered by the application. Array may be empty if nothing is registered.
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCopyRegisteredFontDescriptors(
    scope: CTFontManagerScope,
    enabled: bool,
) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontManagerCopyRegisteredFontDescriptors(
            scope: CTFontManagerScope,
            enabled: bool,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontManagerCopyRegisteredFontDescriptors(scope, enabled) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    /// Resolves font descriptors specified on input. On iOS only, if the font descriptors cannot be found, the user is presented with a dialog indicating fonts that could not be resolved. The user may optionally be provided with a way to resolve the missing fonts if the font manager has a way to enable them.
    ///
    ///
    /// On iOS, fonts registered by font provider applications in the persistent scope are not automatically available to other applications. Client applications must call this function to make the requested fonts available for font descriptor matching.
    ///
    ///
    /// Parameter `fontDescriptors`: Array of font descriptors to make available to the process.  Keys used to describe the fonts may be a combination of: kCTFontNameAttribute, kCTFontFamilyNameAttribute, or kCTFontRegistrationUserInfoAttribute.
    ///
    ///
    /// Parameter `completionHandler`: Block called after request operation completes. Block takes a single parameter containing an array of those descriptors that could not be resolved/found. The array can be empty if all descriptors were resolved.
    ///
    /// # Safety
    ///
    /// `font_descriptors` generic must be of the correct type.
    #[cfg(feature = "block2")]
    pub fn CTFontManagerRequestFonts(
        font_descriptors: &CFArray,
        completion_handler: &block2::DynBlock<dyn Fn(NonNull<CFArray>)>,
    );
}

extern "C-unwind" {
    /// Determines whether a file is in a supported font format.
    ///
    ///
    /// This function does not validate any font data, so clients using it must still be prepared to handle failed registration or font descriptor creation.
    ///
    ///
    /// Parameter `fontURL`: A file URL.
    ///
    ///
    /// Returns: This function returns true if the file is in a supported font format.
    pub fn CTFontManagerIsSupportedFont(font_url: &CFURL) -> bool;
}

/// Creates a CFRunLoopSourceRef that will be used to convey font requests from CTFontManager.
///
/// Parameter `sourceOrder`: The order of the created run loop source.
///
/// Parameter `createMatchesCallback`: A block to handle the font request.
///
/// Returns: A CFRunLoopSourceRef that should be added to the run loop. To stop receiving requests, invalidate this run loop source. Will return NULL on error, in the case of a duplicate requestPortName or invalid context structure.
///
/// # Safety
///
/// `create_matches_callback` block's return must be a valid pointer.
#[cfg(all(feature = "block2", feature = "libc"))]
#[deprecated = "This functionality will be removed in a future release"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontManagerCreateFontRequestRunLoopSource(
    source_order: CFIndex,
    create_matches_callback: &block2::DynBlock<
        dyn Fn(NonNull<CFDictionary>, libc::pid_t) -> NonNull<CFArray>,
    >,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CTFontManagerCreateFontRequestRunLoopSource(
            source_order: CFIndex,
            create_matches_callback: &block2::DynBlock<
                dyn Fn(NonNull<CFDictionary>, libc::pid_t) -> NonNull<CFArray>,
            >,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe {
        CTFontManagerCreateFontRequestRunLoopSource(source_order, create_matches_callback)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// CTFontManage bundle identifier
    ///
    /// The CTFontManager bundle identifier to be used with get or set global auto-activation settings.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmanagerbundleidentifier?language=objc)
    pub static kCTFontManagerBundleIdentifier: &'static CFString;
}

/// Auto-activation settings.
///
/// Default auto-activation setting. When specified, the application will use the global setting.
///
/// Disables auto-activation.
///
/// Enables auto-activation.
///
/// Requires user input for auto-activation. A dialog will be presented to the user to confirm auto
/// activation of the font.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontmanagerautoactivationsetting?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontManagerAutoActivationSetting(pub u32);
impl CTFontManagerAutoActivationSetting {
    #[doc(alias = "kCTFontManagerAutoActivationDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "kCTFontManagerAutoActivationDisabled")]
    pub const Disabled: Self = Self(1);
    #[doc(alias = "kCTFontManagerAutoActivationEnabled")]
    pub const Enabled: Self = Self(2);
    #[doc(alias = "kCTFontManagerAutoActivationPromptUser")]
    #[deprecated = "Deprecated"]
    pub const PromptUser: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontManagerAutoActivationSetting {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontManagerAutoActivationSetting {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// Sets the auto-activation for the specified bundle identifier.
    ///
    /// Parameter `bundleIdentifier`: The bundle identifier. Used to specify a particular application bundle. If NULL,
    /// the current application bundle will be used. If kCTFontManagerBundleIdentifier is specified,
    /// will set the global auto-activation settings.
    ///
    /// Parameter `setting`: The new setting.
    ///
    /// Function will apply the setting to the appropriate preferences location.
    pub fn CTFontManagerSetAutoActivationSetting(
        bundle_identifier: Option<&CFString>,
        setting: CTFontManagerAutoActivationSetting,
    );
}

extern "C-unwind" {
    /// Accessor for the auto-activation setting.
    ///
    /// Parameter `bundleIdentifier`: The bundle identifier. Used to specify a particular application bundle. If NULL,
    /// the current application bundle will be used. If kCTFontManagerBundleIdentifier is specified,
    /// will set the global auto-activation settings.
    ///
    /// Returns: Will return the auto-activation setting for specified bundle identifier.
    pub fn CTFontManagerGetAutoActivationSetting(
        bundle_identifier: Option<&CFString>,
    ) -> CTFontManagerAutoActivationSetting;
}

extern "C" {
    /// Notification name for font registry changes.
    ///
    /// This is the string to use as the notification name when subscribing
    /// to CTFontManager notifications.  This notification will be posted when fonts are added or removed.
    /// OS X clients should register as an observer of the notification with the distributed notification center
    /// for changes in session or persistent scopes and with the local notification center for changes in process scope.
    /// iOS clients should register as an observer of the notification with the local notification center for all changes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmanagerregisteredfontschangednotification?language=objc)
    pub static kCTFontManagerRegisteredFontsChangedNotification: &'static CFString;
}
