#
# PySNMP MIB module RAQMON-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/RAQMON-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:25:50 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueSizeConstraint, ConstraintsIntersection, SingleValueConstraint, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueSizeConstraint", "ConstraintsIntersection", "SingleValueConstraint", "ValueRangeConstraint")
( InetAddressType, InetAddress, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddressType", "InetAddress", "InetPortNumber")
( rmon, ) = mibBuilder.importSymbols("RMON-MIB", "rmon")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( Counter32, Integer32, Bits, MibIdentifier, IpAddress, Unsigned32, Counter64, NotificationType, Gauge32, iso, TimeTicks, ObjectIdentity, ModuleIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter32", "Integer32", "Bits", "MibIdentifier", "IpAddress", "Unsigned32", "Counter64", "NotificationType", "Gauge32", "iso", "TimeTicks", "ObjectIdentity", "ModuleIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn")
( DisplayString, TruthValue, RowPointer, TextualConvention, RowStatus, DateAndTime, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TruthValue", "RowPointer", "TextualConvention", "RowStatus", "DateAndTime")
raqmonMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 31)).setRevisions(("2006-10-10 00:00",))
if mibBuilder.loadTexts: raqmonMIB.setLastUpdated('200610100000Z')
if mibBuilder.loadTexts: raqmonMIB.setOrganization('IETF RMON MIB Working Group')
if mibBuilder.loadTexts: raqmonMIB.setContactInfo('WG Charter:\n             http://www.ietf.org/html.charters/rmonmib-charter.html\n\n             Mailing lists:\n                 General Discussion: rmonmib@ietf.org\n                 To Subscribe: rmonmib-requests@ietf.org\n                 In Body: subscribe your_email_address\n\n             Chair: Andy Bierman\n                    Email: ietf@andybierman.com\n\n             Editor: Dan Romascanu\n                     Avaya\n                     Email:  dromasca@avaya.com')
if mibBuilder.loadTexts: raqmonMIB.setDescription('Real-Time Application QoS Monitoring MIB.\n\n             Copyright (c) The Internet Society (2006).\n             This version of this MIB module is part of\n             RFC 4711; See the RFC itself for full legal notices.')
raqmonNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 0))
raqmonSessionAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 31, 0, 1)).setObjects(*(("RAQMON-MIB", "raqmonParticipantAddr"), ("RAQMON-MIB", "raqmonParticipantName"), ("RAQMON-MIB", "raqmonParticipantPeerAddrType"), ("RAQMON-MIB", "raqmonParticipantPeerAddr"), ("RAQMON-MIB", "raqmonQoSEnd2EndNetDelay"), ("RAQMON-MIB", "raqmonQoSInterArrivalJitter"), ("RAQMON-MIB", "raqmonQosLostPackets"), ("RAQMON-MIB", "raqmonQosRcvdPackets"),))
if mibBuilder.loadTexts: raqmonSessionAlarm.setDescription('A notification generated by an entry in the\n             raqmonSessionExceptionTable.')
raqmonMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1))
raqmonSession = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1, 1))
raqmonParticipantTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1), )
if mibBuilder.loadTexts: raqmonParticipantTable.setDescription('This table contains information about participants in\n             both active and closed (terminated) sessions.')
raqmonParticipantEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1), ).setIndexNames((0, "RAQMON-MIB", "raqmonParticipantStartDate"), (0, "RAQMON-MIB", "raqmonParticipantIndex"))
if mibBuilder.loadTexts: raqmonParticipantEntry.setDescription('Each row contains information for a single session\n             (application) run by one participant.\n             Indexation by the start time of the session aims\n             to ease sorting by management applications.  Agents MUST\n             NOT report identical start times for any two sessions\n             on the same host.\n             Rows are removed for inactive sessions\n             when implementation-specific age or space limits are\n             reached.')
raqmonParticipantStartDate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 1), DateAndTime())
if mibBuilder.loadTexts: raqmonParticipantStartDate.setDescription('The date and time of this entry.\n             It will be the date and time\n             of the first report received.')
raqmonParticipantIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: raqmonParticipantIndex.setDescription('The index of the conceptual row, which is for SNMP\n             purposes only and has no relation to any protocol value.\n\n             There is no requirement that these rows be created or\n             maintained sequentially.  The index will be unique for a\n             particular date and time.')
raqmonParticipantReportCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 3), Bits().clone(namedValues=NamedValues(("raqmonPartRepDsrcName", 0), ("raqmonPartRepRecvName", 1), ("raqmonPartRepDsrcPort", 2), ("raqmonPartRepRecvPort", 3), ("raqmonPartRepSetupTime", 4), ("raqmonPartRepSetupDelay", 5), ("raqmonPartRepSessionDuration", 6), ("raqmonPartRepSetupStatus", 7), ("raqmonPartRepRTEnd2EndNetDelay", 8), ("raqmonPartRepOWEnd2EndNetDelay", 9), ("raqmonPartApplicationDelay", 10), ("raqmonPartRepIAJitter", 11), ("raqmonPartRepIPDV", 12), ("raqmonPartRepRcvdPackets", 13), ("raqmonPartRepRcvdOctets", 14), ("raqmonPartRepSentPackets", 15), ("raqmonPartRepSentOctets", 16), ("raqmonPartRepCumPacketsLoss", 17), ("raqmonPartRepFractionPacketsLoss", 18), ("raqmonPartRepCumDiscards", 19), ("raqmonPartRepFractionDiscards", 20), ("raqmonPartRepSrcPayloadType", 21), ("raqmonPartRepDestPayloadType", 22), ("raqmonPartRepSrcLayer2Priority", 23), ("raqmonPartRepSrcTosDscp", 24), ("raqmonPartRepDestLayer2Priority", 25), ("raqmonPartRepDestTosDscp", 26), ("raqmonPartRepCPU", 27), ("raqmonPartRepMemory", 28), ("raqmonPartRepAppName", 29),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantReportCaps.setDescription('The Report capabilities of the participant, as perceived\n             by the Collector.\n\n             If the participant can report the Data Source Name as\n             defined in [RFC4710], Section 5.3, then the\n             raqmonPartRepDsrcName bit will be set.\n\n             If the participant can report the Receiver Name as\n             defined in [RFC4710], Section 5.4, then the\n             raqmonPartRepRecvName bit will be set.\n\n             If the participant can report the Data Source Port as\n             defined in [RFC4710], Section 5.5, then the\n             raqmonPartRepDsrcPort bit will be set.\n\n             If the participant can report the Receiver Port as\n             defined in [RFC4710], Section 5.6, then the\n             raqmonPartRepRecvPort bit will be set.\n\n             If the participant can report the Session Setup Time as\n             defined in [RFC4710], Section 5.7, then the\n             raqmonPartRepSetupTime bit will be set.\n\n             If the participant can report the Session Setup Delay as\n             defined in [RFC4710], Section 5.8, then the\n             raqmonPartRepSetupDelay bit will be set.\n\n\n\n\n             If the participant can report the Session Duration as\n             defined in [RFC4710], Section 5.9, then the\n             raqmonPartRepSessionDuration bit will be set.\n\n             If the participant can report the Setup Status as\n             defined in [RFC4710], Section 5.10, then the\n             raqmonPartRepSetupStatus bit will be set.\n\n             If the participant can report the Round-Trip End-to-end\n             Network Delay as defined in [RFC4710], Section 5.11,\n             then the raqmonPartRepRTEnd2EndNetDelay bit will be set.\n\n             If the participant can report the One-way End-to-end\n             Network Delay as defined in [RFC4710], Section 5.12,\n             then the raqmonPartRepOWEnd2EndNetDelay bit will be set.\n\n             If the participant can report the Application Delay as\n             defined in [RFC4710], Section 5.13, then the\n             raqmonPartApplicationDelay bit will be set.\n\n             If the participant can report the Inter-Arrival Jitter\n             as defined in [RFC4710], Section 5.14, then the\n             raqmonPartRepIAJitter bit will be set.\n\n             If the participant can report the IP Packet Delay\n             Variation as defined in [RFC4710], Section 5.15, then\n             the raqmonPartRepIPDV bit will be set.\n\n             If the participant can report the number of application\n             packets received as defined in [RFC4710], Section 5.16,\n             then the raqmonPartRepRcvdPackets bit will be set.\n\n             If the participant can report the number of application\n             octets received as defined in [RFC4710], Section 5.17,\n             then the raqmonPartRepRcvdOctets bit will be set.\n\n             If the participant can report the number of application\n             packets sent as defined in [RFC4710], Section 5.18, then\n             the raqmonPartRepSentPackets bit will be set.\n\n             If the participant can report the number of application\n             octets sent as defined in [RFC4710], Section 5.19, then\n             the raqmonPartRepSentOctets bit will be set.\n\n             If the participant can report the number of cumulative\n             packets lost as defined in [RFC4710], Section 5.20, then\n             the raqmonPartRepCumPacketsLoss bit will be set.\n\n\n\n\n             If the participant can report the fraction of packet\n             loss as defined in [RFC4710], Section 5.21, then the\n             raqmonPartRepFractionPacketsLoss bit will be set.\n\n             If the participant can report the number of cumulative\n             discards as defined in [RFC4710], Section 5.22, then the\n             raqmonPartRepCumDiscards bit will be set.\n\n             If the participant can report the fraction of discards\n             as defined in [RFC4710], Section 5.23, then the\n             raqmonPartRepFractionDiscards bit will be set.\n\n             If the participant can report the Source Payload Type as\n             defined in [RFC4710], Section 5.24, then the\n             raqmonPartRepSrcPayloadType bit will be set.\n\n             If the participant can report the Destination Payload\n             Type as defined in [RFC4710], Section 5.25, then the\n             raqmonPartRepDestPayloadType bit will be set.\n\n             If the participant can report the Source Layer 2\n             Priority as defined in [RFC4710], Section 5.26, then the\n             raqmonPartRepSrcLayer2Priority bit will be set.\n\n             If the participant can report the Source DSCP/ToS value\n             as defined in [RFC4710], Section 5.27, then the\n             raqmonPartRepSrcToSDscp bit will be set.\n\n             If the participant can report the Destination Layer 2\n             Priority as defined in [RFC4710], Section 5.28, then the\n             raqmonPartRepDestLayer2Priority bit will be set.\n\n             If the participant can report the Destination DSCP/ToS\n             Value as defined in [RFC4710], Section 5.29, then the\n             raqmonPartRepDestToSDscp bit will be set.\n\n             If the participant can report the CPU utilization as\n             defined in [RFC4710], Section 5.30, then the\n             raqmonPartRepCPU bit will be set.\n\n             If the participant can report the memory utilization as\n             defined in [RFC4710], Section 5.31, then the\n             raqmonPartRepMemory bit will be set.\n\n             If the participant can report the Application Name as\n             defined in [RFC4710], Section 5.32, then the\n             raqmonPartRepAppName bit will be set.\n\n\n\n\n             The capability of reporting of a specific metric does\n             not mandate that the metric must be reported permanently\n             by the data source to the respective collector.  Some\n             data sources MAY be configured not to send a metric, or\n             some metrics may not be relevant to the specific\n             application.')
raqmonParticipantAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAddrType.setDescription('The type of the Internet address of the participant for\n             this session.')
raqmonParticipantAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAddr.setDescription('The Internet Address of the participant for this\n             session.  Formatting of this object is determined\n             by the value of raqmonParticipantAddrType.')
raqmonParticipantSendPort = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 6), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSendPort.setDescription('Port from which session data is sent.\n             If the value was not reported to the collector,\n             this object will have the value 0.')
raqmonParticipantRecvPort = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 7), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantRecvPort.setDescription('Port on which session data is received.\n             If the value was not reported to the collector,\n             this object will have the value 0.')
raqmonParticipantSetupDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSetupDelay.setDescription('Session setup time.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantName.setDescription('The data source name for the participant.')
raqmonParticipantAppName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 10), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppName.setDescription("A string giving the name and possibly the version\n             of the application generating the stream, e.g.,\n             'videotool 1.2.'\n\n             This information may be useful for debugging purposes\n             and is similar to the Mailer or Mail-System-Version SMTP\n             headers.  The tool value is expected to remain constant\n             for the duration of the session.")
raqmonParticipantQosCount = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 11), Gauge32()).setUnits('entries').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantQosCount.setDescription('The current number of entries in the raqmonQosTable\n             for this participant and session.')
raqmonParticipantEndDate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 12), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantEndDate.setDescription('The date and time of the most recent report received.')
raqmonParticipantDestPayloadType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 13), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,127),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDestPayloadType.setDescription('Destination Payload Type.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantSrcPayloadType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 14), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,127),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSrcPayloadType.setDescription('Source Payload Type.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantActive = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantActive.setDescription("Value 'true' indicates that the session\n             for this participant is active (open).\n             Value 'false' indicates that the session\n             is closed (terminated).")
raqmonParticipantPeer = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 16), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPeer.setDescription('The pointer to the corresponding entry in this table for\n             the other peer participant.  If there is no such entry\n             in the participant table of the collector represented by\n             this SNMP agent, then the value will be { 0 0 }.\n            ')
raqmonParticipantPeerAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 17), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPeerAddrType.setDescription('The type of the Internet address of the peer participant\n             for this session.')
raqmonParticipantPeerAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 18), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPeerAddr.setDescription('The Internet Address of the peer participant for this\n             session.  Formatting of this object is determined by\n             the value of raqmonParticipantPeerAddrType.')
raqmonParticipantSrcL2Priority = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 19), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,7),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSrcL2Priority.setDescription('Source Layer 2 Priority.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantDestL2Priority = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 20), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,7),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDestL2Priority.setDescription('Destination Layer 2 Priority.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantSrcDSCP = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,63),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSrcDSCP.setDescription('Source Layer 3 DSCP value.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantDestDSCP = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 22), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,63),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDestDSCP.setDescription('Destination Layer 3 DSCP value.')
raqmonParticipantCpuMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 23), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantCpuMean.setDescription('Mean CPU utilization.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantCpuMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 24), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantCpuMin.setDescription('Minimum CPU utilization.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantCpuMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 25), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantCpuMax.setDescription('Maximum CPU utilization.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantMemoryMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 26), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantMemoryMean.setDescription('Mean memory utilization.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantMemoryMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 27), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantMemoryMin.setDescription('Minimum memory utilization.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantMemoryMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 28), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantMemoryMax.setDescription('Maximum memory utilization.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantNetRTTMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 29), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetRTTMean.setDescription('Mean round-trip end-to-end network\n             delay over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantNetRTTMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 30), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetRTTMin.setDescription('Minimum round-trip end-to-end network delay\n             over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantNetRTTMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 31), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetRTTMax.setDescription('Maximum round-trip end-to-end network delay\n             over the entire session.\n             If the value was not reported to the collector,\n\n\n\n             this object will have the value -1.')
raqmonParticipantIAJitterMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 32), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIAJitterMean.setDescription('Mean inter-arrival jitter over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantIAJitterMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 33), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIAJitterMin.setDescription('Minimum inter-arrival jitter over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantIAJitterMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 34), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIAJitterMax.setDescription('Maximum inter-arrival jitter over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantIPDVMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 35), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIPDVMean.setDescription('Mean IP packet delay variation over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantIPDVMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 36), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIPDVMin.setDescription('Minimum IP packet delay variation over the entire\n             session.  If the value was not reported to the\n             collector, this object will have the value -1.')
raqmonParticipantIPDVMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 37), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIPDVMax.setDescription('Maximum IP packet delay variation over the entire\n             session.  If the value was not reported to the\n             collector, this object will have the value -1.')
raqmonParticipantNetOwdMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 38), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetOwdMean.setDescription('Mean Network one-way delay over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantNetOwdMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 39), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetOwdMin.setDescription('Minimum Network one-way delay over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantNetOwdMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 40), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetOwdMax.setDescription('Maximum Network one-way delay over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantAppDelayMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 41), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppDelayMean.setDescription('Mean application delay over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantAppDelayMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 42), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppDelayMin.setDescription('Minimum application delay over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantAppDelayMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 43), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppDelayMax.setDescription('Maximum application delay over the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantPacketsRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 44), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPacketsRcvd.setDescription('Count of packets received for the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantPacketsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 45), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPacketsSent.setDescription('Count of packets sent for the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantOctetsRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 46), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantOctetsRcvd.setDescription('Count of octets received for the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantOctetsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 47), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('Octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantOctetsSent.setDescription('Count of octets sent for the entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantLostPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 48), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantLostPackets.setDescription('Count of packets lost by this receiver for the entire\n             session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantLostPacketsFrct = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 49), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantLostPacketsFrct.setDescription('Fraction of lost packets out of total packets received.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 50), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDiscards.setDescription('Count of packets discarded by this receiver for the\n             entire session.\n             If the value was not reported to the collector,\n             this object will have the value -1.')
raqmonParticipantDiscardsFrct = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 51), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,100),))).setUnits('percents').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDiscardsFrct.setDescription('Fraction of discarded packets out of total packets\n             received.  If the value was not reported to the\n             collector, this object will have the value -1.')
raqmonQosTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2), )
if mibBuilder.loadTexts: raqmonQosTable.setDescription('Table of historical information about quality-of-service\n             data during sessions.')
raqmonQosEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1), ).setIndexNames((0, "RAQMON-MIB", "raqmonParticipantStartDate"), (0, "RAQMON-MIB", "raqmonParticipantIndex"), (0, "RAQMON-MIB", "raqmonQosTime"))
if mibBuilder.loadTexts: raqmonQosEntry.setDescription('Each entry contains information from a single RAQMON\n             packet, related to a single session\n             (application) run by one participant.\n             Indexation by the start time of the session aims\n             to ease sorting by management applications.  Agents MUST\n             NOT report identical start times for any two sessions\n\n\n\n             on the same host.\n             Rows are removed for inactive sessions when\n             implementation-specific time or space limits are\n             reached.')
raqmonQosTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setUnits('seconds')
if mibBuilder.loadTexts: raqmonQosTime.setDescription('Time of this entry measured from the start of the\n             corresponding participant session.')
raqmonQoSEnd2EndNetDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQoSEnd2EndNetDelay.setDescription('The round-trip time.\n             Will contain the previous value if there was no report\n             for this time, or -1 if the value has never\n             been reported.')
raqmonQoSInterArrivalJitter = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQoSInterArrivalJitter.setDescription('An estimate of delay variation as observed by this\n             receiver.  Will contain the previous value if there\n             was no report for this time, or -1 if the value\n             has never been reported.')
raqmonQosRcvdPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosRcvdPackets.setDescription('Count of packets received by this receiver since the\n             previous entry.  Will contain the previous value if\n             there was no report for this time, or -1 if the value\n             has never been reported.')
raqmonQosRcvdOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosRcvdOctets.setDescription('Count of octets received by this receiver since the\n             previous report.  Will contain the previous value if\n             there was no report for this time, or -1 if the value\n             has never been reported.')
raqmonQosSentPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosSentPackets.setDescription('Count of packets sent since the previous report.\n             Will contain the previous value if there\n\n\n\n             was no report for this time, or -1 if the value\n             has never been reported.')
raqmonQosSentOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosSentOctets.setDescription('Count of octets sent since the previous report.\n             Will contain the previous value if there\n             was no report for this time, or -1 if the value\n             has never been reported.')
raqmonQosLostPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(-1,-1),ValueRangeConstraint(0,2147483647),))).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosLostPackets.setDescription('A count of packets lost as observed by this receiver\n             since the previous report.  Will contain the previous\n             value if there was no report for this time, or -1 if\n             the value has never been reported.')
raqmonQosSessionStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosSessionStatus.setDescription('The session status.  Will contain the previous value\n             if there was no report for this time or the zero-length\n             string if no value was ever reported.')
raqmonParticipantAddrTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 3), )
if mibBuilder.loadTexts: raqmonParticipantAddrTable.setDescription('Maps raqmonParticipantAddr to the index of the\n             raqmonParticipantTable.  This table allows\n             management applications to find entries\n             sorted by raqmonParticipantAddr rather than\n             raqmonParticipantStartDate.')
raqmonParticipantAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 3, 1), ).setIndexNames((0, "RAQMON-MIB", "raqmonParticipantAddrType"), (0, "RAQMON-MIB", "raqmonParticipantAddr"), (0, "RAQMON-MIB", "raqmonParticipantStartDate"), (0, "RAQMON-MIB", "raqmonParticipantIndex"))
if mibBuilder.loadTexts: raqmonParticipantAddrEntry.setDescription('Each entry corresponds to exactly one entry in the\n             raqmonParticipantEntry: the entry containing the\n             index pair raqmonParticipantStartDate,\n             raqmonParticipantIndex.\n\n             Note that there is no concern about the indexation of\n             this table exceeding the limits defined by RFC 2578,\n             Section 3.5.  According to [RFC4710], Section\n             5.1, only IPv4 and IPv6 addresses can be reported as\n             participant addresses.')
raqmonParticipantAddrEndDate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 3, 1, 1), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAddrEndDate.setDescription('The value of raqmonParticipantEndDate for the\n             corresponding raqmonParticipantEntry.')
raqmonException = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1, 2))
raqmonSessionExceptionTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2), )
if mibBuilder.loadTexts: raqmonSessionExceptionTable.setDescription('This table defines thresholds for the management\n             station to get notifications about sessions that\n             encountered poor quality of service.\n\n             The information in this table MUST be persistent\n             across agent reboots.')
raqmonSessionExceptionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1), ).setIndexNames((0, "RAQMON-MIB", "raqmonSessionExceptionIndex"))
if mibBuilder.loadTexts: raqmonSessionExceptionEntry.setDescription('A conceptual row in the raqmonSessionExceptionTable.')
raqmonSessionExceptionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: raqmonSessionExceptionIndex.setDescription('An index that uniquely identifies an\n             entry in the raqmonSessionExceptionTable.\n             Management applications can determine unused indices\n             by performing GetNext or GetBulk operations on the\n             Table.')
raqmonSessionExceptionIAJitterThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 3), Unsigned32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionIAJitterThreshold.setDescription('Threshold for jitter.\n             The value during a session must be greater than or\n             equal to this value for an exception to be created.')
raqmonSessionExceptionNetRTTThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 4), Unsigned32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionNetRTTThreshold.setDescription('Threshold for round-trip time.\n             The value during a session must be greater than or\n             equal to this value for an exception to be created.')
raqmonSessionExceptionLostPacketsThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,1000))).setUnits('tenth of a percent').setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionLostPacketsThreshold.setDescription('Threshold for lost packets in units of tenths\n             of a percent.  The value during a session must\n             be greater than or equal to this value for an\n             exception to be created.')
raqmonSessionExceptionRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionRowStatus.setDescription("This object has a value of 'active' when\n             exceptions are being monitored by the system.\n             A newly-created conceptual row must have all\n             the read-create objects initialized before\n             becoming 'active'.  A conceptual row that is in\n             the 'notReady' or 'notInService' state MAY be\n             removed after 5 minutes.  No writeable objects\n             can be changed while the row is active.")
raqmonConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1, 3))
raqmonConfigPort = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 1), InetPortNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: raqmonConfigPort.setDescription('The UDP port to listen on for RAQMON reports,\n             running on transport protocols other than SNMP.\n             If the RAQMON PDU transport protocol is SNMP,\n             a write operation on this object has no effect, as\n             the standard port 162 is always used.\n             The value of this object MUST be persistent across\n             agent reboots.')
raqmonConfigPduTransport = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 2), Bits().clone(namedValues=NamedValues(("other", 0), ("tcp", 1), ("snmp", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonConfigPduTransport.setDescription('The PDU transport(s) used by this collector.\n             If other(0) is set, the collector supports a\n             transport other than SNMP or TCP.\n             If tcp(1) is set, the collector supports TCP as a\n             transport protocol.\n             If snmp(2) is set, the collector supports SNMP as a\n             transport protocol.')
raqmonConfigRaqmonPdus = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 3), Counter32()).setUnits('PDUs').setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonConfigRaqmonPdus.setDescription('Count of RAQMON PDUs received by the Collector.')
raqmonConfigRDSTimeout = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 4), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: raqmonConfigRDSTimeout.setDescription('The number of seconds since the reception of the\n             last RAQMON PDU from a RDS after which a session\n\n\n\n             between the respective RDS and the collector will be\n             considered terminated.\n             The value of this object MUST be persistent across\n             agent reboots.')
raqmonConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 2))
raqmonCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 2, 1))
raqmonGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 2, 2))
raqmonCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 31, 2, 1, 1)).setObjects(*(("RAQMON-MIB", "raqmonCollectorGroup"), ("RAQMON-MIB", "raqmonCollectorNotificationsGroup"),))
if mibBuilder.loadTexts: raqmonCompliance.setDescription('Describes the requirements for conformance to the\n             RAQMON MIB.')
raqmonCollectorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 31, 2, 2, 1)).setObjects(*(("RAQMON-MIB", "raqmonParticipantReportCaps"), ("RAQMON-MIB", "raqmonParticipantAddrType"), ("RAQMON-MIB", "raqmonParticipantAddr"), ("RAQMON-MIB", "raqmonParticipantSendPort"), ("RAQMON-MIB", "raqmonParticipantRecvPort"), ("RAQMON-MIB", "raqmonParticipantSetupDelay"), ("RAQMON-MIB", "raqmonParticipantName"), ("RAQMON-MIB", "raqmonParticipantAppName"), ("RAQMON-MIB", "raqmonParticipantQosCount"), ("RAQMON-MIB", "raqmonParticipantEndDate"), ("RAQMON-MIB", "raqmonParticipantDestPayloadType"), ("RAQMON-MIB", "raqmonParticipantSrcPayloadType"), ("RAQMON-MIB", "raqmonParticipantActive"), ("RAQMON-MIB", "raqmonParticipantPeer"), ("RAQMON-MIB", "raqmonParticipantPeerAddrType"), ("RAQMON-MIB", "raqmonParticipantPeerAddr"), ("RAQMON-MIB", "raqmonParticipantSrcL2Priority"), ("RAQMON-MIB", "raqmonParticipantDestL2Priority"), ("RAQMON-MIB", "raqmonParticipantSrcDSCP"), ("RAQMON-MIB", "raqmonParticipantDestDSCP"), ("RAQMON-MIB", "raqmonParticipantCpuMean"), ("RAQMON-MIB", "raqmonParticipantCpuMin"), ("RAQMON-MIB", "raqmonParticipantCpuMax"), ("RAQMON-MIB", "raqmonParticipantMemoryMean"), ("RAQMON-MIB", "raqmonParticipantMemoryMin"), ("RAQMON-MIB", "raqmonParticipantMemoryMax"), ("RAQMON-MIB", "raqmonParticipantNetRTTMean"), ("RAQMON-MIB", "raqmonParticipantNetRTTMin"), ("RAQMON-MIB", "raqmonParticipantNetRTTMax"), ("RAQMON-MIB", "raqmonParticipantIAJitterMean"), ("RAQMON-MIB", "raqmonParticipantIAJitterMin"), ("RAQMON-MIB", "raqmonParticipantIAJitterMax"), ("RAQMON-MIB", "raqmonParticipantIPDVMean"), ("RAQMON-MIB", "raqmonParticipantIPDVMin"), ("RAQMON-MIB", "raqmonParticipantIPDVMax"), ("RAQMON-MIB", "raqmonParticipantNetOwdMean"), ("RAQMON-MIB", "raqmonParticipantNetOwdMin"), ("RAQMON-MIB", "raqmonParticipantNetOwdMax"), ("RAQMON-MIB", "raqmonParticipantAppDelayMean"), ("RAQMON-MIB", "raqmonParticipantAppDelayMin"), ("RAQMON-MIB", "raqmonParticipantAppDelayMax"), ("RAQMON-MIB", "raqmonParticipantPacketsRcvd"), ("RAQMON-MIB", "raqmonParticipantPacketsSent"), ("RAQMON-MIB", "raqmonParticipantOctetsRcvd"), ("RAQMON-MIB", "raqmonParticipantOctetsSent"), ("RAQMON-MIB", "raqmonParticipantLostPackets"), ("RAQMON-MIB", "raqmonParticipantLostPacketsFrct"), ("RAQMON-MIB", "raqmonParticipantDiscards"), ("RAQMON-MIB", "raqmonParticipantDiscardsFrct"), ("RAQMON-MIB", "raqmonQoSEnd2EndNetDelay"), ("RAQMON-MIB", "raqmonQoSInterArrivalJitter"), ("RAQMON-MIB", "raqmonQosRcvdPackets"), ("RAQMON-MIB", "raqmonQosRcvdOctets"), ("RAQMON-MIB", "raqmonQosSentPackets"), ("RAQMON-MIB", "raqmonQosSentOctets"), ("RAQMON-MIB", "raqmonQosLostPackets"), ("RAQMON-MIB", "raqmonQosSessionStatus"), ("RAQMON-MIB", "raqmonParticipantAddrEndDate"), ("RAQMON-MIB", "raqmonConfigPort"), ("RAQMON-MIB", "raqmonSessionExceptionIAJitterThreshold"), ("RAQMON-MIB", "raqmonSessionExceptionNetRTTThreshold"), ("RAQMON-MIB", "raqmonSessionExceptionLostPacketsThreshold"), ("RAQMON-MIB", "raqmonSessionExceptionRowStatus"), ("RAQMON-MIB", "raqmonConfigPduTransport"), ("RAQMON-MIB", "raqmonConfigRaqmonPdus"), ("RAQMON-MIB", "raqmonConfigRDSTimeout"),))
if mibBuilder.loadTexts: raqmonCollectorGroup.setDescription('Objects used in RAQMON by a collector.')
raqmonCollectorNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 16, 31, 2, 2, 2)).setObjects(*(("RAQMON-MIB", "raqmonSessionAlarm"),))
if mibBuilder.loadTexts: raqmonCollectorNotificationsGroup.setDescription('Notifications emitted by a RAQMON collector.')
mibBuilder.exportSymbols("RAQMON-MIB", raqmonParticipantSrcDSCP=raqmonParticipantSrcDSCP, raqmonCollectorGroup=raqmonCollectorGroup, raqmonParticipantSrcL2Priority=raqmonParticipantSrcL2Priority, raqmonSessionExceptionTable=raqmonSessionExceptionTable, raqmonParticipantCpuMin=raqmonParticipantCpuMin, raqmonSessionExceptionLostPacketsThreshold=raqmonSessionExceptionLostPacketsThreshold, raqmonParticipantIPDVMean=raqmonParticipantIPDVMean, raqmonParticipantIndex=raqmonParticipantIndex, raqmonConfigRDSTimeout=raqmonConfigRDSTimeout, raqmonCollectorNotificationsGroup=raqmonCollectorNotificationsGroup, raqmonSessionExceptionIndex=raqmonSessionExceptionIndex, raqmonParticipantDiscardsFrct=raqmonParticipantDiscardsFrct, raqmonParticipantAddr=raqmonParticipantAddr, raqmonParticipantTable=raqmonParticipantTable, raqmonParticipantNetOwdMean=raqmonParticipantNetOwdMean, raqmonQosTable=raqmonQosTable, raqmonConfig=raqmonConfig, raqmonParticipantDestDSCP=raqmonParticipantDestDSCP, raqmonConfigRaqmonPdus=raqmonConfigRaqmonPdus, raqmonParticipantIAJitterMax=raqmonParticipantIAJitterMax, raqmonCompliance=raqmonCompliance, raqmonSessionExceptionEntry=raqmonSessionExceptionEntry, PYSNMP_MODULE_ID=raqmonMIB, raqmonParticipantEndDate=raqmonParticipantEndDate, raqmonParticipantRecvPort=raqmonParticipantRecvPort, raqmonException=raqmonException, raqmonQoSEnd2EndNetDelay=raqmonQoSEnd2EndNetDelay, raqmonParticipantAppName=raqmonParticipantAppName, raqmonParticipantIAJitterMean=raqmonParticipantIAJitterMean, raqmonQosSentOctets=raqmonQosSentOctets, raqmonParticipantAppDelayMax=raqmonParticipantAppDelayMax, raqmonParticipantPacketsRcvd=raqmonParticipantPacketsRcvd, raqmonParticipantCpuMax=raqmonParticipantCpuMax, raqmonParticipantNetRTTMean=raqmonParticipantNetRTTMean, raqmonParticipantName=raqmonParticipantName, raqmonParticipantAppDelayMin=raqmonParticipantAppDelayMin, raqmonParticipantNetOwdMax=raqmonParticipantNetOwdMax, raqmonParticipantAppDelayMean=raqmonParticipantAppDelayMean, raqmonMIBObjects=raqmonMIBObjects, raqmonParticipantReportCaps=raqmonParticipantReportCaps, raqmonParticipantDestPayloadType=raqmonParticipantDestPayloadType, raqmonParticipantAddrType=raqmonParticipantAddrType, raqmonParticipantOctetsSent=raqmonParticipantOctetsSent, raqmonCompliances=raqmonCompliances, raqmonConfigPort=raqmonConfigPort, raqmonParticipantNetRTTMax=raqmonParticipantNetRTTMax, raqmonQosTime=raqmonQosTime, raqmonParticipantPacketsSent=raqmonParticipantPacketsSent, raqmonMIB=raqmonMIB, raqmonQosRcvdOctets=raqmonQosRcvdOctets, raqmonQosLostPackets=raqmonQosLostPackets, raqmonParticipantOctetsRcvd=raqmonParticipantOctetsRcvd, raqmonQoSInterArrivalJitter=raqmonQoSInterArrivalJitter, raqmonParticipantLostPacketsFrct=raqmonParticipantLostPacketsFrct, raqmonParticipantMemoryMean=raqmonParticipantMemoryMean, raqmonParticipantPeerAddr=raqmonParticipantPeerAddr, raqmonParticipantAddrEndDate=raqmonParticipantAddrEndDate, raqmonQosSessionStatus=raqmonQosSessionStatus, raqmonConfigPduTransport=raqmonConfigPduTransport, raqmonParticipantAddrTable=raqmonParticipantAddrTable, raqmonParticipantDiscards=raqmonParticipantDiscards, raqmonParticipantEntry=raqmonParticipantEntry, raqmonParticipantDestL2Priority=raqmonParticipantDestL2Priority, raqmonQosSentPackets=raqmonQosSentPackets, raqmonParticipantSendPort=raqmonParticipantSendPort, raqmonSessionAlarm=raqmonSessionAlarm, raqmonQosRcvdPackets=raqmonQosRcvdPackets, raqmonSessionExceptionIAJitterThreshold=raqmonSessionExceptionIAJitterThreshold, raqmonParticipantStartDate=raqmonParticipantStartDate, raqmonSessionExceptionNetRTTThreshold=raqmonSessionExceptionNetRTTThreshold, raqmonParticipantSrcPayloadType=raqmonParticipantSrcPayloadType, raqmonParticipantQosCount=raqmonParticipantQosCount, raqmonParticipantPeer=raqmonParticipantPeer, raqmonNotifications=raqmonNotifications, raqmonSession=raqmonSession, raqmonParticipantNetOwdMin=raqmonParticipantNetOwdMin, raqmonParticipantPeerAddrType=raqmonParticipantPeerAddrType, raqmonParticipantIAJitterMin=raqmonParticipantIAJitterMin, raqmonConformance=raqmonConformance, raqmonGroups=raqmonGroups, raqmonParticipantIPDVMax=raqmonParticipantIPDVMax, raqmonParticipantSetupDelay=raqmonParticipantSetupDelay, raqmonParticipantLostPackets=raqmonParticipantLostPackets, raqmonParticipantNetRTTMin=raqmonParticipantNetRTTMin, raqmonParticipantMemoryMax=raqmonParticipantMemoryMax, raqmonParticipantCpuMean=raqmonParticipantCpuMean, raqmonSessionExceptionRowStatus=raqmonSessionExceptionRowStatus, raqmonQosEntry=raqmonQosEntry, raqmonParticipantAddrEntry=raqmonParticipantAddrEntry, raqmonParticipantMemoryMin=raqmonParticipantMemoryMin, raqmonParticipantActive=raqmonParticipantActive, raqmonParticipantIPDVMin=raqmonParticipantIPDVMin)
