/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.views;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKeyColumnTable;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class GenericTableForeignKeyConfigurator
implements DBEObjectConfigurator<GenericTableForeignKey> {
    public GenericTableForeignKey configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object table, @NotNull GenericTableForeignKey foreignKey, @NotNull Map<String, Object> options) {
        return (GenericTableForeignKey)UITask.run(() -> {
            EditForeignKeyPage editPage = new EditForeignKeyPage("Create foreign key", (DBSEntityAssociation)foreignKey, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT}, options);
            if (!editPage.edit()) {
                return null;
            }
            foreignKey.setDeleteRule(editPage.getOnDeleteRule());
            foreignKey.setUpdateRule(editPage.getOnUpdateRule());
            foreignKey.setReferencedConstraint((DBSEntityConstraint)((DBSEntityReferrer)editPage.getUniqueConstraint()));
            foreignKey.setDeferability(DBSForeignKeyDeferability.NOT_DEFERRABLE);
            int colIndex = 1;
            for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                foreignKey.addColumn(new GenericTableForeignKeyColumnTable(foreignKey, (GenericTableColumn)tableColumn.getOrCreateOwnColumn(monitor, commandContext, (DBSEntity)foreignKey.getTable()), colIndex++, (GenericTableColumn)tableColumn.getRefColumn()));
            }
            SQLForeignKeyManager.updateForeignKeyName((DBRProgressMonitor)monitor, (AbstractTableConstraint)foreignKey);
            return foreignKey;
        });
    }
}

