/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.util.ArrayList;
import org.apache.log4j.pattern.DatePatternConverter;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.IntegerPatternConverter;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.OptionHandler;

public abstract class RollingPolicyBase
extends ComponentBase
implements RollingPolicy,
OptionHandler {
    private static final String FNP_NOT_SET = "The FileNamePattern option must be set before using RollingPolicy. ";
    private static final String SEE_FNP_NOT_SET = "See also http://logging.apache.org/log4j/codes.html#tbr_fnp_not_set";
    private PatternConverter[] patternConverters;
    private FormattingInfo[] patternFields;
    private String fileNamePatternStr;
    protected String activeFileName;

    public void activateOptions() {
        if (this.fileNamePatternStr == null) {
            this.getLogger().warn(FNP_NOT_SET);
            this.getLogger().warn(SEE_FNP_NOT_SET);
            throw new IllegalStateException("The FileNamePattern option must be set before using RollingPolicy. See also http://logging.apache.org/log4j/codes.html#tbr_fnp_not_set");
        }
        this.parseFileNamePattern();
    }

    public void setFileNamePattern(String fnp) {
        this.fileNamePatternStr = fnp;
    }

    public String getFileNamePattern() {
        return this.fileNamePatternStr;
    }

    public void setActiveFileName(String afn) {
        this.activeFileName = afn;
    }

    public String getActiveFileName() {
        return this.activeFileName;
    }

    protected final void parseFileNamePattern() {
        ArrayList converters = new ArrayList();
        ArrayList fields = new ArrayList();
        PatternParser.parse(this.fileNamePatternStr, converters, fields, null, PatternParser.getFileNamePatternRules(), this.getLogger());
        this.patternConverters = new PatternConverter[converters.size()];
        this.patternConverters = converters.toArray(this.patternConverters);
        this.patternFields = new FormattingInfo[converters.size()];
        this.patternFields = fields.toArray(this.patternFields);
    }

    protected final void formatFileName(Object obj, StringBuffer buf) {
        int i = 0;
        while (i < this.patternConverters.length) {
            int fieldStart = buf.length();
            this.patternConverters[i].format(obj, buf);
            if (this.patternFields[i] != null) {
                this.patternFields[i].format(fieldStart, buf);
            }
            ++i;
        }
    }

    protected final PatternConverter getDatePatternConverter() {
        int i = 0;
        while (i < this.patternConverters.length) {
            if (this.patternConverters[i] instanceof DatePatternConverter) {
                return this.patternConverters[i];
            }
            ++i;
        }
        return null;
    }

    protected final PatternConverter getIntegerPatternConverter() {
        int i = 0;
        while (i < this.patternConverters.length) {
            if (this.patternConverters[i] instanceof IntegerPatternConverter) {
                return this.patternConverters[i];
            }
            ++i;
        }
        return null;
    }

    public abstract RolloverDescription rollover(String var1) throws SecurityException;

    public abstract RolloverDescription initialize(String var1, boolean var2) throws SecurityException;
}

