// artist_name_filter.cc
//
// Project: Ampache Browser
// License: GNU GPLv3
//
// Copyright (C) 2015 - 2024 Róbert Čerňanský



#include <cctype>
#include <algorithm>
#include <string>

#include "../data_objects/artist_data.h"
#include "data/filters/filter.h"
#include "data/filters/name_filter_for_artists.h"



namespace data {

NameFilterForArtists::NameFilterForArtists(const std::string& namePattern):
myNamePattern(namePattern) {
}



void NameFilterForArtists::processUpdatedSourceData(int offset, int length) {
    myFilteredData.clear();

    for (auto& artistData: *mySourceData) {
        if (artistData == nullptr) {
            continue;
        }
        auto name = artistData->getArtist().getName();
        if (search(name.begin(), name.end(), myNamePattern.begin(), myNamePattern.end(),
            [](char c1, char c2) {return toupper(c1) == toupper(c2); }) != name.end()) {

            myFilteredData.push_back(artistData.get());
        }
    }

    Filter<ArtistData>::processUpdatedSourceData(offset, length);
}

}
