// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StopStreamEncryption`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::set_stream_name):<br>required: **false**<br><p>The name of the stream on which to stop encrypting records.</p><br>
    ///   - [`encryption_type(EncryptionType)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::encryption_type) / [`set_encryption_type(Option<EncryptionType>)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::set_encryption_type):<br>required: **true**<br><p>The encryption type. The only valid value is <code>KMS</code>.</p><br>
    ///   - [`key_id(impl Into<String>)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::set_key_id):<br>required: **true**<br><p>The GUID for the customer-managed Amazon Web Services KMS key to use for encryption. This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code>.</p> <ul>  <li>   <p>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></p></li>  <li>   <p>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></p></li>  <li>   <p>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></p></li>  <li>   <p>Alias name example: <code>alias/MyAliasName</code></p></li>  <li>   <p>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></p></li> </ul><br>
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::set_stream_arn):<br>required: **false**<br><p>The ARN of the stream.</p><br>
    /// - On success, responds with [`StopStreamEncryptionOutput`](crate::operation::stop_stream_encryption::StopStreamEncryptionOutput)
    /// - On failure, responds with [`SdkError<StopStreamEncryptionError>`](crate::operation::stop_stream_encryption::StopStreamEncryptionError)
    pub fn stop_stream_encryption(&self) -> crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder {
        crate::operation::stop_stream_encryption::builders::StopStreamEncryptionFluentBuilder::new(self.handle.clone())
    }
}
