pub const ext = @import("ext.zig");
const gstvulkan = @This();

const std = @import("std");
const compat = @import("compat");
const vulkan = @import("vulkan1");
const gstvideo = @import("gstvideo1");
const gstbase = @import("gstbase1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
pub const VulkanHandleTypedef = u64;

/// Opaque `gstvulkan.VulkanBufferMemoryAllocator` struct
pub const VulkanBufferMemoryAllocator = extern struct {
    pub const Parent = gst.Allocator;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanBufferMemoryAllocatorClass;
    /// the parent `gst.Allocator`
    f_parent: gst.Allocator,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_buffer_memory_allocator_get_type() usize;
    pub const getGObjectType = gst_vulkan_buffer_memory_allocator_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanBufferMemoryAllocator) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanBufferMemoryAllocator) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanBufferMemoryAllocator, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Opaque `gstvulkan.VulkanBufferPool` struct
pub const VulkanBufferPool = extern struct {
    pub const Parent = gst.BufferPool;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanBufferPoolClass;
    /// the parent `gst.BufferPool`
    f_bufferpool: gst.BufferPool,
    /// the `gstvulkan.VulkanDevice` to allocate Vulkan buffers from
    f_device: ?*gstvulkan.VulkanDevice,
    f__padding: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Sets the `usage` of the buffers to setup.
    extern fn gst_vulkan_buffer_pool_config_set_allocation_params(p_config: *gst.Structure, p_usage: vulkan.BufferUsageFlags, p_mem_properties: vulkan.MemoryPropertyFlags) void;
    pub const configSetAllocationParams = gst_vulkan_buffer_pool_config_set_allocation_params;

    extern fn gst_vulkan_buffer_pool_new(p_device: *gstvulkan.VulkanDevice) *gstvulkan.VulkanBufferPool;
    pub const new = gst_vulkan_buffer_pool_new;

    extern fn gst_vulkan_buffer_pool_get_type() usize;
    pub const getGObjectType = gst_vulkan_buffer_pool_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanBufferPool) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanBufferPool) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanBufferPool, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanCommandPool = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanCommandPoolClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the `gstvulkan.VulkanQueue` to command buffers will be allocated from
    f_queue: ?*gstvulkan.VulkanQueue,
    /// the vulkan command pool handle
    f_pool: vulkan.CommandPool,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_command_pool_create(p_pool: *VulkanCommandPool, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanCommandBuffer;
    pub const create = gst_vulkan_command_pool_create;

    extern fn gst_vulkan_command_pool_get_queue(p_pool: *VulkanCommandPool) *gstvulkan.VulkanQueue;
    pub const getQueue = gst_vulkan_command_pool_get_queue;

    /// This should be called to ensure no other thread will attempt to access
    /// the pool's internal resources.  Any modification of any of the allocated
    /// `gstvulkan.VulkanCommandBuffer`'s need to be encapsulated in a
    /// `gstvulkan.VulkanCommandPool.lock`/`gstvulkan.VulkanCommandPool.unlock` pair to meet
    /// the Vulkan API requirements that host access to the command pool is
    /// externally synchronised.
    extern fn gst_vulkan_command_pool_lock(p_pool: *VulkanCommandPool) void;
    pub const lock = gst_vulkan_command_pool_lock;

    /// See the documentation for `gstvulkan.VulkanCommandPool.lock` for when you would
    /// need to use this function.
    extern fn gst_vulkan_command_pool_unlock(p_pool: *VulkanCommandPool) void;
    pub const unlock = gst_vulkan_command_pool_unlock;

    extern fn gst_vulkan_command_pool_get_type() usize;
    pub const getGObjectType = gst_vulkan_command_pool_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanCommandPool) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanCommandPool) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanCommandPool, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDecoder = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanDecoderClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the `gstvulkan.VulkanQueue` to command buffers will be allocated from
    f_queue: ?*gstvulkan.VulkanQueue,
    /// the configured video codec operation
    f_codec: c_uint,
    /// the configured `gstvulkan.VulkanVideoProfile`
    f_profile: gstvulkan.VulkanVideoProfile,
    /// the buffer to upload the bitstream to decode
    f_input_buffer: ?*gst.Buffer,
    f_layered_buffer: ?*gst.Buffer,
    /// if decoder needs a dedicated DPB
    f_dedicated_dpb: c_int,
    /// if decoder's dedicated DPB has to be a layered image
    f_layered_dpb: c_int,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Appends slices's `data` bitstream into `pic` internal input buffer.
    extern fn gst_vulkan_decoder_append_slice(p_self: *VulkanDecoder, p_pic: *gstvulkan.VulkanDecoderPicture, p_data: *const u8, p_size: usize, p_add_startcode: c_int) c_int;
    pub const appendSlice = gst_vulkan_decoder_append_slice;

    /// Gets the Vulkan decoding capabilities of the current video session.
    extern fn gst_vulkan_decoder_caps(p_self: *VulkanDecoder, p_caps: *gstvulkan.VulkanVideoCapabilities) c_int;
    pub const caps = gst_vulkan_decoder_caps;

    /// Instantiates an internal Vulkan image pool for driver decoders whose output
    /// buffers cannot be used as DPB buffers.
    extern fn gst_vulkan_decoder_create_dpb_pool(p_self: *VulkanDecoder, p_caps: *gst.Caps) c_int;
    pub const createDpbPool = gst_vulkan_decoder_create_dpb_pool;

    /// Decodes `pic`.
    extern fn gst_vulkan_decoder_decode(p_self: *VulkanDecoder, p_pic: *gstvulkan.VulkanDecoderPicture, p_error: ?*?*glib.Error) c_int;
    pub const decode = gst_vulkan_decoder_decode;

    /// Initializes the decoder at driver level and set its DPB slots to the inactive
    /// state.
    extern fn gst_vulkan_decoder_flush(p_self: *VulkanDecoder, p_error: ?*?*glib.Error) c_int;
    pub const flush = gst_vulkan_decoder_flush;

    extern fn gst_vulkan_decoder_is_started(p_self: *VulkanDecoder) c_int;
    pub const isStarted = gst_vulkan_decoder_is_started;

    /// Gets the Vulkan format properties of the output frames.
    extern fn gst_vulkan_decoder_out_format(p_self: *VulkanDecoder, p_format: *vulkan.VideoFormatPropertiesKHR) c_int;
    pub const outFormat = gst_vulkan_decoder_out_format;

    /// Creates a `gstvulkan.VulkanImageView` for `buf` for decoding, with the internal Ycbcr
    /// sampler, if available.
    extern fn gst_vulkan_decoder_picture_create_view(p_self: *VulkanDecoder, p_buf: *gst.Buffer, p_is_out: c_int) ?*gstvulkan.VulkanImageView;
    pub const pictureCreateView = gst_vulkan_decoder_picture_create_view;

    /// Initializes `pic` with `out` as output buffer.
    extern fn gst_vulkan_decoder_picture_init(p_self: *VulkanDecoder, p_pic: *gstvulkan.VulkanDecoderPicture, p_out: *gst.Buffer) c_int;
    pub const pictureInit = gst_vulkan_decoder_picture_init;

    extern fn gst_vulkan_decoder_profile_caps(p_self: *VulkanDecoder) *gst.Caps;
    pub const profileCaps = gst_vulkan_decoder_profile_caps;

    /// It creates a Vulkan video session for the given `profile`. If an error occurs,
    /// `error` is filled.
    extern fn gst_vulkan_decoder_start(p_self: *VulkanDecoder, p_profile: *gstvulkan.VulkanVideoProfile, p_error: ?*?*glib.Error) c_int;
    pub const start = gst_vulkan_decoder_start;

    /// Destroys the video session created at `gstvulkan.VulkanDecoder.start` and clean up
    /// the internal objects.
    extern fn gst_vulkan_decoder_stop(p_self: *VulkanDecoder) c_int;
    pub const stop = gst_vulkan_decoder_stop;

    /// Update the internal codec parameters for the current video session.
    extern fn gst_vulkan_decoder_update_video_session_parameters(p_self: *VulkanDecoder, p_params: *gstvulkan.VulkanDecoderParameters, p_error: ?*?*glib.Error) c_int;
    pub const updateVideoSessionParameters = gst_vulkan_decoder_update_video_session_parameters;

    /// Update the internal Ycbcr sampler for the output images.
    extern fn gst_vulkan_decoder_update_ycbcr_sampler(p_self: *VulkanDecoder, p_range: vulkan.SamplerYcbcrRange, p_xloc: vulkan.ChromaLocation, p_yloc: vulkan.ChromaLocation, p_error: ?*?*glib.Error) c_int;
    pub const updateYcbcrSampler = gst_vulkan_decoder_update_ycbcr_sampler;

    /// Waits indefinitely for decoding fences to signal, and queries the operation
    /// result if available.
    extern fn gst_vulkan_decoder_wait(p_self: *VulkanDecoder) c_int;
    pub const wait = gst_vulkan_decoder_wait;

    extern fn gst_vulkan_decoder_get_type() usize;
    pub const getGObjectType = gst_vulkan_decoder_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanDecoder) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanDecoder) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanDecoder, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDescriptorCache = extern struct {
    pub const Parent = gstvulkan.VulkanHandlePool;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanDescriptorCacheClass;
    /// the parent `gstvulkan.VulkanHandlePool`
    f_parent: gstvulkan.VulkanHandlePool,
    /// the `gstvulkan.VulkanDescriptorPool` to cache descriptor sets for
    f_pool: ?*gstvulkan.VulkanDescriptorPool,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_descriptor_cache_new(p_pool: *gstvulkan.VulkanDescriptorPool, p_n_layouts: c_uint, p_layouts: [*]*gstvulkan.VulkanHandle) *gstvulkan.VulkanDescriptorCache;
    pub const new = gst_vulkan_descriptor_cache_new;

    extern fn gst_vulkan_descriptor_cache_acquire(p_cache: *VulkanDescriptorCache, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanDescriptorSet;
    pub const acquire = gst_vulkan_descriptor_cache_acquire;

    extern fn gst_vulkan_descriptor_cache_get_type() usize;
    pub const getGObjectType = gst_vulkan_descriptor_cache_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanDescriptorCache) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanDescriptorCache) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanDescriptorCache, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDescriptorPool = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanDescriptorPoolClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the `gstvulkan.VulkanDevice` for descriptor sets
    f_device: ?*gstvulkan.VulkanDevice,
    /// the vulksn descriptor pool handle
    f_pool: vulkan.DescriptorPool,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_descriptor_pool_new_wrapped(p_device: *gstvulkan.VulkanDevice, p_pool: vulkan.DescriptorPool, p_max_sets: usize) *gstvulkan.VulkanDescriptorPool;
    pub const newWrapped = gst_vulkan_descriptor_pool_new_wrapped;

    extern fn gst_vulkan_descriptor_pool_create(p_pool: *VulkanDescriptorPool, p_n_layouts: c_uint, p_layouts: [*]*gstvulkan.VulkanHandle, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanDescriptorSet;
    pub const create = gst_vulkan_descriptor_pool_create;

    extern fn gst_vulkan_descriptor_pool_get_device(p_pool: *VulkanDescriptorPool) *gstvulkan.VulkanDevice;
    pub const getDevice = gst_vulkan_descriptor_pool_get_device;

    extern fn gst_vulkan_descriptor_pool_get_max_sets(p_pool: *VulkanDescriptorPool) usize;
    pub const getMaxSets = gst_vulkan_descriptor_pool_get_max_sets;

    extern fn gst_vulkan_descriptor_pool_get_type() usize;
    pub const getGObjectType = gst_vulkan_descriptor_pool_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanDescriptorPool) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanDescriptorPool) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanDescriptorPool, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDevice = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanDeviceClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the `gstvulkan.VulkanInstance` this device was allocated with
    f_instance: ?*gstvulkan.VulkanInstance,
    /// the `gstvulkan.VulkanPhysicalDevice` this device was allocated with
    f_physical_device: ?*gstvulkan.VulkanPhysicalDevice,
    /// the vulkan device handle
    f_device: vulkan.Device,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const instance = struct {
            pub const name = "instance";

            pub const Type = ?*gstvulkan.VulkanInstance;
        };

        pub const physical_device = struct {
            pub const name = "physical-device";

            pub const Type = ?*gstvulkan.VulkanPhysicalDevice;
        };
    };

    pub const signals = struct {};

    /// If a `gstvulkan.VulkanDevice` is requested in `query`, sets `device` as the reply.
    ///
    /// Intended for use with element query handlers to respond to `GST_QUERY_CONTEXT`
    /// for a `gstvulkan.VulkanDevice`.
    extern fn gst_vulkan_device_handle_context_query(p_element: *gst.Element, p_query: *gst.Query, p_device: *gstvulkan.VulkanDevice) c_int;
    pub const handleContextQuery = gst_vulkan_device_handle_context_query;

    /// Attempt to retrieve a `gstvulkan.VulkanDevice` using `GST_QUERY_CONTEXT` from the
    /// surrounding elements of `element`.
    extern fn gst_vulkan_device_run_context_query(p_element: *gst.Element, p_device: **gstvulkan.VulkanDevice) c_int;
    pub const runContextQuery = gst_vulkan_device_run_context_query;

    extern fn gst_vulkan_device_new(p_physical_device: *gstvulkan.VulkanPhysicalDevice) *gstvulkan.VulkanDevice;
    pub const new = gst_vulkan_device_new;

    extern fn gst_vulkan_device_new_with_index(p_instance: *gstvulkan.VulkanInstance, p_device_index: c_uint) *gstvulkan.VulkanDevice;
    pub const newWithIndex = gst_vulkan_device_new_with_index;

    extern fn gst_vulkan_device_create_fence(p_device: *VulkanDevice, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanFence;
    pub const createFence = gst_vulkan_device_create_fence;

    /// Disable an Vulkan extension by `name`.  Disabling an extension will only have
    /// an effect before the call to `gstvulkan.VulkanDevice.open`.
    extern fn gst_vulkan_device_disable_extension(p_device: *VulkanDevice, p_name: [*:0]const u8) c_int;
    pub const disableExtension = gst_vulkan_device_disable_extension;

    /// Enable an Vulkan extension by `name`.  Enabling an extension will
    /// only have an effect before the call to `gstvulkan.VulkanDevice.open`.
    extern fn gst_vulkan_device_enable_extension(p_device: *VulkanDevice, p_name: [*:0]const u8) c_int;
    pub const enableExtension = gst_vulkan_device_enable_extension;

    /// Enable an Vulkan layer by `name`.  Enabling a layer will
    /// only have an effect before the call to `gstvulkan.VulkanDevice.open`.
    extern fn gst_vulkan_device_enable_layer(p_device: *VulkanDevice, p_name: [*:0]const u8) c_int;
    pub const enableLayer = gst_vulkan_device_enable_layer;

    /// Iterate over each queue family available on `gstvulkan.VulkanDevice`
    extern fn gst_vulkan_device_foreach_queue(p_device: *VulkanDevice, p_func: gstvulkan.VulkanDeviceForEachQueueFunc, p_user_data: ?*anyopaque) void;
    pub const foreachQueue = gst_vulkan_device_foreach_queue;

    extern fn gst_vulkan_device_get_instance(p_device: *VulkanDevice) ?*gstvulkan.VulkanInstance;
    pub const getInstance = gst_vulkan_device_get_instance;

    extern fn gst_vulkan_device_get_physical_device(p_device: *VulkanDevice) vulkan.PhysicalDevice;
    pub const getPhysicalDevice = gst_vulkan_device_get_physical_device;

    /// Performs ``vkGetDeviceProcAddr`` with `device` and `name`
    extern fn gst_vulkan_device_get_proc_address(p_device: *VulkanDevice, p_name: [*:0]const u8) ?*anyopaque;
    pub const getProcAddress = gst_vulkan_device_get_proc_address;

    extern fn gst_vulkan_device_get_queue(p_device: *VulkanDevice, p_queue_family: u32, p_queue_i: u32) *gstvulkan.VulkanQueue;
    pub const getQueue = gst_vulkan_device_get_queue;

    extern fn gst_vulkan_device_is_extension_enabled(p_device: *VulkanDevice, p_name: [*:0]const u8) c_int;
    pub const isExtensionEnabled = gst_vulkan_device_is_extension_enabled;

    extern fn gst_vulkan_device_is_layer_enabled(p_device: *VulkanDevice, p_name: [*:0]const u8) c_int;
    pub const isLayerEnabled = gst_vulkan_device_is_layer_enabled;

    /// Attempts to create the internal `VkDevice` object.
    extern fn gst_vulkan_device_open(p_device: *VulkanDevice, p_error: ?*?*glib.Error) c_int;
    pub const open = gst_vulkan_device_open;

    extern fn gst_vulkan_device_queue_family_indices(p_device: *VulkanDevice) *glib.Array;
    pub const queueFamilyIndices = gst_vulkan_device_queue_family_indices;

    /// Select a compatible queue from the `device` supporting the `expected_flags`.
    extern fn gst_vulkan_device_select_queue(p_device: *VulkanDevice, p_expected_flags: vulkan.QueueFlagBits) *gstvulkan.VulkanQueue;
    pub const selectQueue = gst_vulkan_device_select_queue;

    extern fn gst_vulkan_device_get_type() usize;
    pub const getGObjectType = gst_vulkan_device_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanDevice) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanDevice) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanDevice, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The contents of a `gstvulkan.VulkanDisplay` are private and should only be accessed
/// through the provided API
pub const VulkanDisplay = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanDisplayClass;
    f_object: gst.Object,
    f_type: gstvulkan.VulkanDisplayType,
    f_instance: ?*gstvulkan.VulkanInstance,
    f_windows: ?*glib.List,
    f_main_context: ?*glib.MainContext,
    f_main_loop: ?*glib.MainLoop,
    f_event_source: ?*glib.Source,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {
        /// create a window
        pub const create_window = struct {
            pub fn call(p_class: anytype, p_display: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?*gstvulkan.VulkanWindow {
                return gobject.ext.as(VulkanDisplay.Class, p_class).f_create_window.?(gobject.ext.as(VulkanDisplay, p_display));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_display: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?*gstvulkan.VulkanWindow) void {
                gobject.ext.as(VulkanDisplay.Class, p_class).f_create_window = @ptrCast(p_implementation);
            }
        };

        /// get the native handle to the display
        pub const get_handle = struct {
            pub fn call(p_class: anytype, p_display: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?*anyopaque {
                return gobject.ext.as(VulkanDisplay.Class, p_class).f_get_handle.?(gobject.ext.as(VulkanDisplay, p_display));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_display: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?*anyopaque) void {
                gobject.ext.as(VulkanDisplay.Class, p_class).f_get_handle = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    /// This function will read the `GST_VULKAN_WINDOW` environment variable for
    /// a user choice or choose the first supported implementation.
    ///
    /// `gstvulkan.VulkanInstance.fillInfo` must have been called prior to this function.
    extern fn gst_vulkan_display_choose_type(p_instance: *gstvulkan.VulkanInstance) gstvulkan.VulkanDisplayType;
    pub const chooseType = gst_vulkan_display_choose_type;

    /// If a `gstvulkan.VulkanDisplay` is requested in `query`, sets `device` as the reply.
    ///
    /// Intended for use with element query handlers to respond to `GST_QUERY_CONTEXT`
    /// for a `gstvulkan.VulkanDisplay`.
    extern fn gst_vulkan_display_handle_context_query(p_element: *gst.Element, p_query: *gst.Query, p_display: ?*gstvulkan.VulkanDisplay) c_int;
    pub const handleContextQuery = gst_vulkan_display_handle_context_query;

    /// Attempt to retrieve a `gstvulkan.VulkanDisplay` using `GST_QUERY_CONTEXT` from the
    /// surrounding elements of `element`.
    extern fn gst_vulkan_display_run_context_query(p_element: *gst.Element, p_display: **gstvulkan.VulkanDisplay) c_int;
    pub const runContextQuery = gst_vulkan_display_run_context_query;

    extern fn gst_vulkan_display_new(p_instance: *gstvulkan.VulkanInstance) *gstvulkan.VulkanDisplay;
    pub const new = gst_vulkan_display_new;

    extern fn gst_vulkan_display_new_with_type(p_instance: *gstvulkan.VulkanInstance, p_type: gstvulkan.VulkanDisplayType) ?*gstvulkan.VulkanDisplay;
    pub const newWithType = gst_vulkan_display_new_with_type;

    extern fn gst_vulkan_display_create_window(p_display: *VulkanDisplay) ?*gstvulkan.VulkanWindow;
    pub const createWindow = gst_vulkan_display_create_window;

    /// Execute `compare_func` over the list of windows stored by `display`.  The
    /// first argument to `compare_func` is the `gstvulkan.VulkanWindow` being checked and the
    /// second argument is `data`.
    extern fn gst_vulkan_display_find_window(p_display: *VulkanDisplay, p_data: ?*anyopaque, p_compare_func: glib.CompareFunc) ?*gstvulkan.VulkanWindow;
    pub const findWindow = gst_vulkan_display_find_window;

    extern fn gst_vulkan_display_get_handle(p_display: *VulkanDisplay) ?*anyopaque;
    pub const getHandle = gst_vulkan_display_get_handle;

    extern fn gst_vulkan_display_get_handle_type(p_display: *VulkanDisplay) gstvulkan.VulkanDisplayType;
    pub const getHandleType = gst_vulkan_display_get_handle_type;

    extern fn gst_vulkan_display_remove_window(p_display: *VulkanDisplay, p_window: *gstvulkan.VulkanWindow) c_int;
    pub const removeWindow = gst_vulkan_display_remove_window;

    extern fn gst_vulkan_display_get_type() usize;
    pub const getGObjectType = gst_vulkan_display_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanDisplay) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanDisplay) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanDisplay, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanFenceCache = extern struct {
    pub const Parent = gstvulkan.VulkanHandlePool;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanFenceCacheClass;
    /// the parent `gstvulkan.VulkanHandlePool`
    f_parent: gstvulkan.VulkanHandlePool,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_fence_cache_new(p_device: *gstvulkan.VulkanDevice) *gstvulkan.VulkanFenceCache;
    pub const new = gst_vulkan_fence_cache_new;

    extern fn gst_vulkan_fence_cache_get_type() usize;
    pub const getGObjectType = gst_vulkan_fence_cache_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanFenceCache) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanFenceCache) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanFenceCache, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanFullScreenQuad = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanFullScreenQuadClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the configured output `gstvideo.VideoInfo`
    f_out_info: gstvideo.VideoInfo,
    /// the configured input `gstvideo.VideoInfo`
    f_in_info: gstvideo.VideoInfo,
    /// the `gstvulkan.VulkanQueue` to submit `gstvulkan.VulkanCommandBuffer`'s on
    f_queue: ?*gstvulkan.VulkanQueue,
    /// the configured `VkRenderPass`
    f_render_pass: ?*gstvulkan.VulkanHandle,
    /// the configured `VkPipelineLayout`
    f_pipeline_layout: ?*gstvulkan.VulkanHandle,
    /// the configured `VkPipeline`
    f_graphics_pipeline: ?*gstvulkan.VulkanHandle,
    /// the configured `VkDescriptorSetLayout`
    f_descriptor_set_layout: ?*gstvulkan.VulkanHandle,
    /// the configured `gstvulkan.VulkanDescriptorCache`
    f_descriptor_cache: ?*gstvulkan.VulkanDescriptorCache,
    /// the configured `gstvulkan.VulkanDescriptorSet`
    f_descriptor_set: ?*gstvulkan.VulkanDescriptorSet,
    /// the configured `VkFramebuffer`
    f_framebuffer: ?*gstvulkan.VulkanHandle,
    /// the configured `VkSampler`
    f_sampler: ?*gstvulkan.VulkanHandle,
    /// the `gstvulkan.VulkanCommandPool` to allocate `gstvulkan.VulkanCommandBuffer`'s from
    f_cmd_pool: ?*gstvulkan.VulkanCommandPool,
    /// the `gstvulkan.VulkanTrashList` for freeing unused resources
    f_trash_list: ?*gstvulkan.VulkanTrashList,
    /// the last configured `GstVulkanFences`
    f_last_fence: ?*gstvulkan.VulkanFence,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_full_screen_quad_new(p_queue: *gstvulkan.VulkanQueue) *gstvulkan.VulkanFullScreenQuad;
    pub const new = gst_vulkan_full_screen_quad_new;

    /// Helper function for creation and submission of a command buffer that draws
    /// a full screen quad.  If you need to add other things to the command buffer,
    /// create the command buffer manually and call
    /// `gstvulkan.VulkanFullScreenQuad.prepareDraw`,
    /// `gstvulkan.VulkanFullScreenQuad.fillCommandBuffer` and
    /// `gstvulkan.VulkanFullScreenQuad.submit` instead.
    extern fn gst_vulkan_full_screen_quad_draw(p_self: *VulkanFullScreenQuad, p_error: ?*?*glib.Error) c_int;
    pub const draw = gst_vulkan_full_screen_quad_draw;

    /// Enables blending of the input image to the output image.
    ///
    /// See also: `gstvulkan.VulkanFullScreenQuad.setBlendOperation` and
    /// `gstvulkan.VulkanFullScreenQuad.setBlendFactors`.
    extern fn gst_vulkan_full_screen_quad_enable_blend(p_self: *VulkanFullScreenQuad, p_enable_blend: c_int) void;
    pub const enableBlend = gst_vulkan_full_screen_quad_enable_blend;

    extern fn gst_vulkan_full_screen_quad_enable_clear(p_self: *VulkanFullScreenQuad, p_enable_clear: c_int) void;
    pub const enableClear = gst_vulkan_full_screen_quad_enable_clear;

    extern fn gst_vulkan_full_screen_quad_fill_command_buffer(p_self: *VulkanFullScreenQuad, p_cmd: *gstvulkan.VulkanCommandBuffer, p_fence: *gstvulkan.VulkanFence, p_error: ?*?*glib.Error) c_int;
    pub const fillCommandBuffer = gst_vulkan_full_screen_quad_fill_command_buffer;

    extern fn gst_vulkan_full_screen_quad_get_last_fence(p_self: *VulkanFullScreenQuad) *gstvulkan.VulkanFence;
    pub const getLastFence = gst_vulkan_full_screen_quad_get_last_fence;

    extern fn gst_vulkan_full_screen_quad_prepare_draw(p_self: *VulkanFullScreenQuad, p_fence: *gstvulkan.VulkanFence, p_error: ?*?*glib.Error) c_int;
    pub const prepareDraw = gst_vulkan_full_screen_quad_prepare_draw;

    /// You need to enable blend with `gstvulkan.VulkanFullScreenQuad.enableBlend`.
    ///
    /// See also: `gstvulkan.VulkanFullScreenQuad.setBlendOperation`.
    extern fn gst_vulkan_full_screen_quad_set_blend_factors(p_self: *VulkanFullScreenQuad, p_src_blend_factor: vulkan.BlendFactor, p_dst_blend_factor: vulkan.BlendFactor, p_src_alpha_blend_factor: vulkan.BlendFactor, p_dst_alpha_blend_factor: vulkan.BlendFactor) void;
    pub const setBlendFactors = gst_vulkan_full_screen_quad_set_blend_factors;

    /// You need to enable blend with `gstvulkan.VulkanFullScreenQuad.enableBlend`.
    ///
    /// See also: `gstvulkan.VulkanFullScreenQuad.setBlendFactors`.
    extern fn gst_vulkan_full_screen_quad_set_blend_operation(p_self: *VulkanFullScreenQuad, p_colour_blend_op: vulkan.BlendOp, p_alpha_blend_op: vulkan.BlendOp) void;
    pub const setBlendOperation = gst_vulkan_full_screen_quad_set_blend_operation;

    /// See also `gstvulkan.VulkanFullScreenQuad.setVertexBuffer`
    extern fn gst_vulkan_full_screen_quad_set_index_buffer(p_self: *VulkanFullScreenQuad, p_indices: *gst.Memory, p_n_indices: usize, p_error: ?*?*glib.Error) c_int;
    pub const setIndexBuffer = gst_vulkan_full_screen_quad_set_index_buffer;

    extern fn gst_vulkan_full_screen_quad_set_info(p_self: *VulkanFullScreenQuad, p_in_info: *gstvideo.VideoInfo, p_out_info: *gstvideo.VideoInfo) c_int;
    pub const setInfo = gst_vulkan_full_screen_quad_set_info;

    extern fn gst_vulkan_full_screen_quad_set_input_buffer(p_self: *VulkanFullScreenQuad, p_buffer: *gst.Buffer, p_error: ?*?*glib.Error) c_int;
    pub const setInputBuffer = gst_vulkan_full_screen_quad_set_input_buffer;

    extern fn gst_vulkan_full_screen_quad_set_output_buffer(p_self: *VulkanFullScreenQuad, p_buffer: *gst.Buffer, p_error: ?*?*glib.Error) c_int;
    pub const setOutputBuffer = gst_vulkan_full_screen_quad_set_output_buffer;

    extern fn gst_vulkan_full_screen_quad_set_shaders(p_self: *VulkanFullScreenQuad, p_vert: *gstvulkan.VulkanHandle, p_frag: *gstvulkan.VulkanHandle) c_int;
    pub const setShaders = gst_vulkan_full_screen_quad_set_shaders;

    extern fn gst_vulkan_full_screen_quad_set_uniform_buffer(p_self: *VulkanFullScreenQuad, p_uniforms: *gst.Memory, p_error: ?*?*glib.Error) c_int;
    pub const setUniformBuffer = gst_vulkan_full_screen_quad_set_uniform_buffer;

    extern fn gst_vulkan_full_screen_quad_set_vertex_buffer(p_self: *VulkanFullScreenQuad, p_vertices: *gst.Memory, p_error: ?*?*glib.Error) c_int;
    pub const setVertexBuffer = gst_vulkan_full_screen_quad_set_vertex_buffer;

    extern fn gst_vulkan_full_screen_quad_submit(p_self: *VulkanFullScreenQuad, p_cmd: *gstvulkan.VulkanCommandBuffer, p_fence: *gstvulkan.VulkanFence, p_error: ?*?*glib.Error) c_int;
    pub const submit = gst_vulkan_full_screen_quad_submit;

    extern fn gst_vulkan_full_screen_quad_get_type() usize;
    pub const getGObjectType = gst_vulkan_full_screen_quad_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanFullScreenQuad) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanFullScreenQuad) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanFullScreenQuad, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanHandlePool = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanHandlePoolClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the `gstvulkan.VulkanDevice` handles are allocated from
    f_device: ?*gstvulkan.VulkanDevice,
    /// the collection of outstanding handles
    f_outstanding: ?*glib.PtrArray,
    /// the collection of allocated and available handles
    f_available: ?*glib.PtrArray,
    f__padding: [4]*anyopaque,

    pub const virtual_methods = struct {
        /// acquire a handle for usage
        pub const acquire = struct {
            pub fn call(p_class: anytype, p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) ?*anyopaque {
                return gobject.ext.as(VulkanHandlePool.Class, p_class).f_acquire.?(gobject.ext.as(VulkanHandlePool, p_pool), p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) callconv(.C) ?*anyopaque) void {
                gobject.ext.as(VulkanHandlePool.Class, p_class).f_acquire = @ptrCast(p_implementation);
            }
        };

        /// allocate a new handle
        pub const alloc = struct {
            pub fn call(p_class: anytype, p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) ?*anyopaque {
                return gobject.ext.as(VulkanHandlePool.Class, p_class).f_alloc.?(gobject.ext.as(VulkanHandlePool, p_pool), p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) callconv(.C) ?*anyopaque) void {
                gobject.ext.as(VulkanHandlePool.Class, p_class).f_alloc = @ptrCast(p_implementation);
            }
        };

        /// free a handle
        pub const free = struct {
            pub fn call(p_class: anytype, p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle: ?*anyopaque) void {
                return gobject.ext.as(VulkanHandlePool.Class, p_class).f_free.?(gobject.ext.as(VulkanHandlePool, p_pool), p_handle);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle: ?*anyopaque) callconv(.C) void) void {
                gobject.ext.as(VulkanHandlePool.Class, p_class).f_free = @ptrCast(p_implementation);
            }
        };

        /// release a handle for possible reuse at the next call to `acquire`
        pub const release = struct {
            pub fn call(p_class: anytype, p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle: ?*anyopaque) void {
                return gobject.ext.as(VulkanHandlePool.Class, p_class).f_release.?(gobject.ext.as(VulkanHandlePool, p_pool), p_handle);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle: ?*anyopaque) callconv(.C) void) void {
                gobject.ext.as(VulkanHandlePool.Class, p_class).f_release = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_handle_pool_acquire(p_pool: *VulkanHandlePool, p_error: ?*?*glib.Error) ?*anyopaque;
    pub const acquire = gst_vulkan_handle_pool_acquire;

    extern fn gst_vulkan_handle_pool_alloc(p_pool: *VulkanHandlePool, p_error: ?*?*glib.Error) ?*anyopaque;
    pub const alloc = gst_vulkan_handle_pool_alloc;

    extern fn gst_vulkan_handle_pool_release(p_pool: *VulkanHandlePool, p_handle: ?*anyopaque) void;
    pub const release = gst_vulkan_handle_pool_release;

    extern fn gst_vulkan_handle_pool_get_type() usize;
    pub const getGObjectType = gst_vulkan_handle_pool_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanHandlePool) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanHandlePool) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanHandlePool, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanImageBufferPool = extern struct {
    pub const Parent = gst.BufferPool;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanImageBufferPoolClass;
    /// parent `gst.BufferPool`
    f_bufferpool: gst.BufferPool,
    /// the `gstvulkan.VulkanDevice` to allocate images from
    f_device: ?*gstvulkan.VulkanDevice,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Sets the `usage` and `mem_properties` of the images to setup.
    extern fn gst_vulkan_image_buffer_pool_config_set_allocation_params(p_config: *gst.Structure, p_usage: vulkan.ImageUsageFlags, p_mem_properties: vulkan.MemoryPropertyFlags, p_initial_layout: vulkan.ImageLayout, p_initial_access: u64) void;
    pub const configSetAllocationParams = gst_vulkan_image_buffer_pool_config_set_allocation_params;

    /// Decode `caps` are used when the buffers are going to be used either as decoded
    /// dest or DPB images.
    extern fn gst_vulkan_image_buffer_pool_config_set_decode_caps(p_config: *gst.Structure, p_caps: *gst.Caps) void;
    pub const configSetDecodeCaps = gst_vulkan_image_buffer_pool_config_set_decode_caps;

    extern fn gst_vulkan_image_buffer_pool_new(p_device: *gstvulkan.VulkanDevice) *gstvulkan.VulkanImageBufferPool;
    pub const new = gst_vulkan_image_buffer_pool_new;

    extern fn gst_vulkan_image_buffer_pool_get_type() usize;
    pub const getGObjectType = gst_vulkan_image_buffer_pool_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanImageBufferPool) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanImageBufferPool) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanImageBufferPool, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Opaque `gstvulkan.VulkanImageMemoryAllocator` struct
pub const VulkanImageMemoryAllocator = extern struct {
    pub const Parent = gst.Allocator;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanImageMemoryAllocatorClass;
    /// the parent `gst.Allocator`
    f_parent: gst.Allocator,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_image_memory_allocator_get_type() usize;
    pub const getGObjectType = gst_vulkan_image_memory_allocator_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanImageMemoryAllocator) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanImageMemoryAllocator) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanImageMemoryAllocator, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanInstance = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanInstanceClass;
    /// parent `gst.Object`
    f_parent: gst.Object,
    /// the Vulkan instance handle
    f_instance: vulkan.Instance,
    /// list of vulkan physical device handles
    f_physical_devices: ?*vulkan.PhysicalDevice,
    f_n_physical_devices: u32,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const requested_api_major = struct {
            pub const name = "requested-api-major";

            pub const Type = c_uint;
        };

        pub const requested_api_minor = struct {
            pub const name = "requested-api-minor";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {
        /// Overrides the `gstvulkan.VulkanDevice` creation mechanism.
        /// It can be called from any thread.
        pub const create_device = struct {
            pub const name = "create-device";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) *gstvulkan.VulkanDevice, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(VulkanInstance, p_instance))),
                    gobject.signalLookup("create-device", VulkanInstance.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// If a `gstvulkan.VulkanInstance` is requested in `query`, sets `instance` as the reply.
    ///
    /// Intended for use with element query handlers to respond to `GST_QUERY_CONTEXT`
    /// for a `gstvulkan.VulkanInstance`.
    extern fn gst_vulkan_instance_handle_context_query(p_element: *gst.Element, p_query: *gst.Query, p_instance: ?*gstvulkan.VulkanInstance) c_int;
    pub const handleContextQuery = gst_vulkan_instance_handle_context_query;

    /// Attempt to retrieve a `gstvulkan.VulkanInstance` using `GST_QUERY_CONTEXT` from the
    /// surrounding elements of `element`.
    extern fn gst_vulkan_instance_run_context_query(p_element: *gst.Element, p_instance: **gstvulkan.VulkanInstance) c_int;
    pub const runContextQuery = gst_vulkan_instance_run_context_query;

    extern fn gst_vulkan_instance_new() *gstvulkan.VulkanInstance;
    pub const new = gst_vulkan_instance_new;

    /// Check if the configured vulkan instance supports the specified version.
    /// Will not work prior to opening the instance with `gstvulkan.VulkanInstance.open`.
    /// If a specific version is requested, the `patch` level is ignored.
    extern fn gst_vulkan_instance_check_version(p_instance: *VulkanInstance, p_major: c_uint, p_minor: c_uint, p_patch: c_uint) c_int;
    pub const checkVersion = gst_vulkan_instance_check_version;

    extern fn gst_vulkan_instance_create_device(p_instance: *VulkanInstance, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanDevice;
    pub const createDevice = gst_vulkan_instance_create_device;

    /// Disable an Vulkan extension by `name`.  Disabling an extension will only have
    /// an effect before the call to `gstvulkan.VulkanInstance.open`.
    extern fn gst_vulkan_instance_disable_extension(p_instance: *VulkanInstance, p_name: [*:0]const u8) c_int;
    pub const disableExtension = gst_vulkan_instance_disable_extension;

    /// Enable an Vulkan extension by `name`.  Extensions cannot be enabled until
    /// `gstvulkan.VulkanInstance.fillInfo` has been called.  Enabling an extension will
    /// only have an effect before the call to `gstvulkan.VulkanInstance.open`.
    extern fn gst_vulkan_instance_enable_extension(p_instance: *VulkanInstance, p_name: [*:0]const u8) c_int;
    pub const enableExtension = gst_vulkan_instance_enable_extension;

    /// Enable an Vulkan layer by `name`.  Layer cannot be enabled until
    /// `gstvulkan.VulkanInstance.fillInfo` has been called.  Enabling a layer will
    /// only have an effect before the call to `gstvulkan.VulkanInstance.open`.
    extern fn gst_vulkan_instance_enable_layer(p_instance: *VulkanInstance, p_name: [*:0]const u8) c_int;
    pub const enableLayer = gst_vulkan_instance_enable_layer;

    /// Retrieve as much information about the available Vulkan instance without
    /// actually creating an Vulkan instance.  Will not do anything while `instance`
    /// is open.
    extern fn gst_vulkan_instance_fill_info(p_instance: *VulkanInstance, p_error: ?*?*glib.Error) c_int;
    pub const fillInfo = gst_vulkan_instance_fill_info;

    /// Retrieves information about an extension.
    ///
    /// Will not find any extensions before `gstvulkan.VulkanInstance.fillInfo` has been
    /// called.
    extern fn gst_vulkan_instance_get_extension_info(p_instance: *VulkanInstance, p_name: [*:0]const u8, p_spec_version: ?*u32) c_int;
    pub const getExtensionInfo = gst_vulkan_instance_get_extension_info;

    /// Retrieves information about a layer.
    ///
    /// Will not find any layers before `gstvulkan.VulkanInstance.fillInfo` has been
    /// called.
    extern fn gst_vulkan_instance_get_layer_info(p_instance: *VulkanInstance, p_name: [*:0]const u8, p_description: ?*[*:0]u8, p_spec_version: ?*u32, p_implementation_version: ?*u32) c_int;
    pub const getLayerInfo = gst_vulkan_instance_get_layer_info;

    /// Performs ``vkGetInstanceProcAddr`` with `instance` and `name`
    extern fn gst_vulkan_instance_get_proc_address(p_instance: *VulkanInstance, p_name: [*:0]const u8) ?*anyopaque;
    pub const getProcAddress = gst_vulkan_instance_get_proc_address;

    /// Retrieve the vulkan instance configured version.  Only returns the supported
    /// API version by the instance without taking into account the requested API
    /// version.  This means `gstvulkan.VulkanInstance.checkVersion` will return
    /// different values if a specific version has been requested (which is the
    /// default) than a version check that is performed manually by retrieving the
    /// version with this function.
    extern fn gst_vulkan_instance_get_version(p_instance: *VulkanInstance, p_major: *c_uint, p_minor: *c_uint, p_patch: *c_uint) void;
    pub const getVersion = gst_vulkan_instance_get_version;

    extern fn gst_vulkan_instance_is_extension_enabled(p_instance: *VulkanInstance, p_name: [*:0]const u8) c_int;
    pub const isExtensionEnabled = gst_vulkan_instance_is_extension_enabled;

    extern fn gst_vulkan_instance_is_layer_enabled(p_instance: *VulkanInstance, p_name: [*:0]const u8) c_int;
    pub const isLayerEnabled = gst_vulkan_instance_is_layer_enabled;

    extern fn gst_vulkan_instance_open(p_instance: *VulkanInstance, p_error: ?*?*glib.Error) c_int;
    pub const open = gst_vulkan_instance_open;

    extern fn gst_vulkan_instance_get_type() usize;
    pub const getGObjectType = gst_vulkan_instance_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanInstance) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanInstance) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanInstance, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Opaque `gstvulkan.VulkanMemoryAllocator` struct
pub const VulkanMemoryAllocator = extern struct {
    pub const Parent = gst.Allocator;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanMemoryAllocatorClass;
    /// the parent `gst.Allocator`
    f_parent: gst.Allocator,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_memory_allocator_get_type() usize;
    pub const getGObjectType = gst_vulkan_memory_allocator_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanMemoryAllocator) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanMemoryAllocator) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanMemoryAllocator, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// When using the operation `cmd_buf`, you should lock it using
/// `gst_vulkan_command_buffer_lock`, but you have to unlock it, with
/// `gst_vulkan_command_buffer_unlock`, when calling any of `gstvulkan.VulkanOperation`
/// methods.
pub const VulkanOperation = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanOperationClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the current `gstvulkan.VulkanCommandBuffer`
    f_cmd_buf: ?*gstvulkan.VulkanCommandBuffer,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const command_pool = struct {
            pub const name = "command-pool";

            pub const Type = ?*gstvulkan.VulkanCommandPool;
        };
    };

    pub const signals = struct {};

    extern fn gst_vulkan_operation_new(p_cmd_pool: *gstvulkan.VulkanCommandPool) *gstvulkan.VulkanOperation;
    pub const new = gst_vulkan_operation_new;

    /// Add `frame` as an operation dependency by adding the timeline semaphores in
    /// each memory of `frame` into either the wait semaphore array. The signal array
    /// hold the same semaphores but increasing their current value.
    extern fn gst_vulkan_operation_add_dependency_frame(p_self: *VulkanOperation, p_frame: *gst.Buffer, p_wait_stage: u64, p_signal_stage: u64) c_int;
    pub const addDependencyFrame = gst_vulkan_operation_add_dependency_frame;

    /// See also: `gstvulkan.VulkanOperation.useSync2`,
    ///     `gstvulkan.VulkanOperation.newExtraImageBarriers` and
    ///     `gstvulkan.VulkanOperation.updateFrame`
    ///
    /// Any non-repeated image barrier in `extra` is appended to the internal barrier
    /// list.
    ///
    /// Remember to call `gstvulkan.VulkanOperation.updateFrame` on those frames with
    /// images in `extra_barriers`.
    extern fn gst_vulkan_operation_add_extra_image_barriers(p_self: *VulkanOperation, p_extra_barriers: *glib.Array) void;
    pub const addExtraImageBarriers = gst_vulkan_operation_add_extra_image_barriers;

    /// See also: `gstvulkan.VulkanOperation.updateFrame`
    ///
    /// Adds an image memory barrier per memory in `frame` with its future state. And
    /// it updates the `frame` barrier state by calling internally
    /// `gstvulkan.VulkanOperation.updateFrame`.
    extern fn gst_vulkan_operation_add_frame_barrier(p_self: *VulkanOperation, p_frame: *gst.Buffer, p_dst_stage: u64, p_new_access: u64, p_new_layout: vulkan.ImageLayout, p_new_queue: ?*gstvulkan.VulkanQueue) c_int;
    pub const addFrameBarrier = gst_vulkan_operation_add_frame_barrier;

    /// See also: `gstvulkan.VulkanOperation.end` and `gstvulkan.VulkanOperation.reset`
    ///
    /// Attempts to set the operation ready to work. It instantiates the common
    /// command buffer in `self` and calls vkBeginCommandBuffer.
    ///
    /// After calling this function you can register commands in the command buffer,
    /// and finally call `gstvulkan.VulkanOperation.end`. `gstvulkan.VulkanOperation.reset` is
    /// called internally if something failed.
    extern fn gst_vulkan_operation_begin(p_self: *VulkanOperation, p_error: ?*?*glib.Error) c_int;
    pub const begin = gst_vulkan_operation_begin;

    /// Begins a query operation in the current command buffer.
    extern fn gst_vulkan_operation_begin_query(p_self: *VulkanOperation, p_id: u32) c_int;
    pub const beginQuery = gst_vulkan_operation_begin_query;

    /// Discards barriers, and all the semaphore arrays populated by
    /// `gstvulkan.VulkanOperation.addDependencyFrame`.
    extern fn gst_vulkan_operation_discard_dependencies(p_self: *VulkanOperation) void;
    pub const discardDependencies = gst_vulkan_operation_discard_dependencies;

    /// Tries to enable the query pool for the current operation.
    extern fn gst_vulkan_operation_enable_query(p_self: *VulkanOperation, p_query_type: u32, p_n_queries: c_uint, p_pnext: ?*anyopaque, p_error: ?*?*glib.Error) c_int;
    pub const enableQuery = gst_vulkan_operation_enable_query;

    /// See also: `gstvulkan.VulkanOperation.begin` and `gstvulkan.VulkanOperation.reset`
    ///
    /// It calls vkEndCommandBuffer, and later either vkQueueSubmit or
    /// vkQueueSubmit2KHR filling up the semaphores from images declared as
    /// dependencies.
    ///
    /// You have called `gstvulkan.VulkanOperation.begin` before.
    /// `gstvulkan.VulkanOperation.reset` is called internally if something fails
    extern fn gst_vulkan_operation_end(p_self: *VulkanOperation, p_error: ?*?*glib.Error) c_int;
    pub const end = gst_vulkan_operation_end;

    /// Ends a query operation in the current command buffer.
    extern fn gst_vulkan_operation_end_query(p_self: *VulkanOperation, p_id: u32) c_int;
    pub const endQuery = gst_vulkan_operation_end_query;

    /// Gets the latest operation results of all the queries in `data`. API users have
    /// to parse the binary array of `data` according of their needs (usually is a
    /// guint32 array of size of n_query).
    ///
    /// Don't free `data`.
    extern fn gst_vulkan_operation_get_query(p_self: *VulkanOperation, p_data: ?*anyopaque, p_error: ?*?*glib.Error) c_int;
    pub const getQuery = gst_vulkan_operation_get_query;

    /// See also: `gstvulkan.VulkanOperation.useSync2`,
    ///     `gstvulkan.VulkanOperation.addExtraImageBarriers` and
    ///     `gstvulkan.VulkanOperation.updateFrame`
    ///
    /// If it's required to add custom image memory barriers this function will
    /// allocate a new array to append in it the extra image memory barriers to
    /// handle.
    ///
    /// Remember to call `gstvulkan.VulkanOperation.updateFrame` after adding the barrier
    /// related with that frame.
    extern fn gst_vulkan_operation_new_extra_image_barriers(p_self: *VulkanOperation) *glib.Array;
    pub const newExtraImageBarriers = gst_vulkan_operation_new_extra_image_barriers;

    /// It's a wrapper to vkCmdPipelineBarrier2{KHR} if it's available.
    extern fn gst_vulkan_operation_pipeline_barrier2(p_self: *VulkanOperation, p_dependency_info: ?*anyopaque) c_int;
    pub const pipelineBarrier2 = gst_vulkan_operation_pipeline_barrier2;

    /// Resets the operation to a clean state.
    extern fn gst_vulkan_operation_reset(p_self: *VulkanOperation) void;
    pub const reset = gst_vulkan_operation_reset;

    /// Retrieves a copy of the current defined barriers internally, which will be
    /// used by vkCmdPipelineBarrier or vkCmdPipelineBarrier2KHR by the API user.
    ///
    /// The element type of the array might be, depending on if synchronization2
    /// extension is used, either VkImageMemoryBarrier or VkImageMemoryBarrier2KHR.
    extern fn gst_vulkan_operation_retrieve_image_barriers(p_self: *VulkanOperation) *glib.Array;
    pub const retrieveImageBarriers = gst_vulkan_operation_retrieve_image_barriers;

    /// Add or update the internal list of the future state of `frame`. This state
    /// will be set after `gstvulkan.VulkanOperation.end`.
    ///
    /// This method is useful when new barriers are added to the array without using
    /// `gstvulkan.VulkanOperation.addFrameBarrier`.
    extern fn gst_vulkan_operation_update_frame(p_self: *VulkanOperation, p_frame: *gst.Buffer, p_dst_stage: u64, p_new_access: u64, p_new_layout: vulkan.ImageLayout, p_new_queue: ?*gstvulkan.VulkanQueue) void;
    pub const updateFrame = gst_vulkan_operation_update_frame;

    extern fn gst_vulkan_operation_use_sync2(p_self: *VulkanOperation) c_int;
    pub const useSync2 = gst_vulkan_operation_use_sync2;

    /// Waits for the operation's fence to signal.
    extern fn gst_vulkan_operation_wait(p_self: *VulkanOperation) c_int;
    pub const wait = gst_vulkan_operation_wait;

    extern fn gst_vulkan_operation_get_type() usize;
    pub const getGObjectType = gst_vulkan_operation_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanOperation) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanOperation) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanOperation, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanPhysicalDevice = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanPhysicalDeviceClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the parent `gstvulkan.VulkanInstance` for this physical device
    f_instance: ?*gstvulkan.VulkanInstance,
    /// the index into the physical device list in `instance`
    f_device_index: c_uint,
    /// the vulkan physical device handle
    f_device: vulkan.PhysicalDevice,
    /// retrieved physical device properties
    f_properties: vulkan.PhysicalDeviceProperties,
    /// retrieved physical device features
    f_features: vulkan.PhysicalDeviceFeatures,
    /// retrieved physical device memory properties
    f_memory_properties: vulkan.PhysicalDeviceMemoryProperties,
    /// vulkan family properties
    f_queue_family_props: ?*vulkan.QueueFamilyProperties,
    /// number of elements in `queue_family_props`
    f_n_queue_families: u32,
    /// vulkan operations allowed per queue family
    f_queue_family_ops: ?*gstvulkan.VulkanQueueFamilyOps,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const device_index = struct {
            pub const name = "device-index";

            pub const Type = c_uint;
        };

        pub const instance = struct {
            pub const name = "instance";

            pub const Type = ?*gstvulkan.VulkanInstance;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    extern fn gst_vulkan_physical_device_type_to_string(p_type: vulkan.PhysicalDeviceType) [*:0]const u8;
    pub const typeToString = gst_vulkan_physical_device_type_to_string;

    extern fn gst_vulkan_physical_device_new(p_instance: *gstvulkan.VulkanInstance, p_device_index: c_uint) *gstvulkan.VulkanPhysicalDevice;
    pub const new = gst_vulkan_physical_device_new;

    /// Retrieves information about a device extension.
    ///
    /// Will not find any extensions before `gstvulkan.VulkanInstance.fillInfo` has been
    /// called.
    extern fn gst_vulkan_physical_device_get_extension_info(p_device: *VulkanPhysicalDevice, p_name: [*:0]const u8, p_spec_version: ?*u32) c_int;
    pub const getExtensionInfo = gst_vulkan_physical_device_get_extension_info;

    extern fn gst_vulkan_physical_device_get_handle(p_device: *VulkanPhysicalDevice) vulkan.PhysicalDevice;
    pub const getHandle = gst_vulkan_physical_device_get_handle;

    extern fn gst_vulkan_physical_device_get_instance(p_device: *VulkanPhysicalDevice) *gstvulkan.VulkanInstance;
    pub const getInstance = gst_vulkan_physical_device_get_instance;

    /// Retrieves information about a layer.
    ///
    /// Will not find any layers before `gstvulkan.VulkanInstance.fillInfo` has been
    /// called.
    extern fn gst_vulkan_physical_device_get_layer_info(p_device: *VulkanPhysicalDevice, p_name: [*:0]const u8, p_description: ?*[*:0]u8, p_spec_version: ?*u32, p_implementation_version: ?*u32) c_int;
    pub const getLayerInfo = gst_vulkan_physical_device_get_layer_info;

    extern fn gst_vulkan_physical_device_get_type() usize;
    pub const getGObjectType = gst_vulkan_physical_device_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanPhysicalDevice) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanPhysicalDevice) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanPhysicalDevice, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanQueue = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanQueueClass;
    /// the parent `gst.Object`
    f_parent: gst.Object,
    /// the `gstvulkan.VulkanDevice` this queue was allocated from
    f_device: ?*gstvulkan.VulkanDevice,
    /// the vulkan queue handle
    f_queue: vulkan.Queue,
    /// the vulkan queue family
    f_family: u32,
    /// the vulkan queue index
    f_index: u32,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_queue_flags_to_string(p_queue_bits: vulkan.QueueFlags) [*:0]u8;
    pub const flagsToString = gst_vulkan_queue_flags_to_string;

    /// If a `gstvulkan.VulkanQueue` is requested in `query`, sets `queue` as the reply.
    ///
    /// Intended for use with element query handlers to respond to `GST_QUERY_CONTEXT`
    /// for a `gstvulkan.VulkanQueue`.
    extern fn gst_vulkan_queue_handle_context_query(p_element: *gst.Element, p_query: *gst.Query, p_queue: ?*gstvulkan.VulkanQueue) c_int;
    pub const handleContextQuery = gst_vulkan_queue_handle_context_query;

    /// Attempt to retrieve a `gstvulkan.VulkanQueue` using `GST_QUERY_CONTEXT` from the
    /// surrounding elements of `element`.
    extern fn gst_vulkan_queue_run_context_query(p_element: *gst.Element, p_queue: **gstvulkan.VulkanQueue) c_int;
    pub const runContextQuery = gst_vulkan_queue_run_context_query;

    extern fn gst_vulkan_queue_create_command_pool(p_queue: *VulkanQueue, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanCommandPool;
    pub const createCommandPool = gst_vulkan_queue_create_command_pool;

    /// Creates a `gstvulkan.VulkanDecoder` object if `codec` decoding is supported by `queue`
    extern fn gst_vulkan_queue_create_decoder(p_queue: *VulkanQueue, p_codec: c_uint) ?*gstvulkan.VulkanDecoder;
    pub const createDecoder = gst_vulkan_queue_create_decoder;

    extern fn gst_vulkan_queue_get_device(p_queue: *VulkanQueue) ?*gstvulkan.VulkanDevice;
    pub const getDevice = gst_vulkan_queue_get_device;

    /// Locks the queue for command submission using ``vkQueueSubmit`` to meet the
    /// Vulkan requirements for externally synchronised resources.
    extern fn gst_vulkan_queue_submit_lock(p_queue: *VulkanQueue) void;
    pub const submitLock = gst_vulkan_queue_submit_lock;

    /// Unlocks the queue for command submission using ``vkQueueSubmit``.
    ///
    /// See `gstvulkan.VulkanQueue.submitLock` for details on when this call is needed.
    extern fn gst_vulkan_queue_submit_unlock(p_queue: *VulkanQueue) void;
    pub const submitUnlock = gst_vulkan_queue_submit_unlock;

    extern fn gst_vulkan_queue_get_type() usize;
    pub const getGObjectType = gst_vulkan_queue_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanQueue) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanQueue) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanQueue, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanSwapper = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanSwapperClass;
    /// parent `gst.Object`
    f_parent: gst.Object,
    /// the `gstvulkan.VulkanDevice`
    f_device: ?*gstvulkan.VulkanDevice,
    /// the `gstvulkan.VulkanWindow` to display into
    f_window: ?*gstvulkan.VulkanWindow,
    /// the `gstvulkan.VulkanQueue` to display with
    f_queue: ?*gstvulkan.VulkanQueue,
    /// the `gstvulkan.VulkanCommandPool` to allocate command buffers from
    f_cmd_pool: ?*gstvulkan.VulkanCommandPool,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const force_aspect_ratio = struct {
            pub const name = "force-aspect-ratio";

            pub const Type = c_int;
        };

        pub const pixel_aspect_ratio = struct {
            pub const name = "pixel-aspect-ratio";

            pub const Type = ?*gst.Fraction;
        };
    };

    pub const signals = struct {};

    extern fn gst_vulkan_swapper_new(p_device: *gstvulkan.VulkanDevice, p_window: *gstvulkan.VulkanWindow) *gstvulkan.VulkanSwapper;
    pub const new = gst_vulkan_swapper_new;

    extern fn gst_vulkan_swapper_choose_queue(p_swapper: *VulkanSwapper, p_available_queue: *gstvulkan.VulkanQueue, p_error: ?*?*glib.Error) c_int;
    pub const chooseQueue = gst_vulkan_swapper_choose_queue;

    extern fn gst_vulkan_swapper_get_supported_caps(p_swapper: *VulkanSwapper, p_error: ?*?*glib.Error) ?*gst.Caps;
    pub const getSupportedCaps = gst_vulkan_swapper_get_supported_caps;

    extern fn gst_vulkan_swapper_get_surface_rectangles(p_swapper: *VulkanSwapper, p_input_image: ?*gstvideo.VideoRectangle, p_surface_location: ?*gstvideo.VideoRectangle, p_display_rect: ?*gstvideo.VideoRectangle) void;
    pub const getSurfaceRectangles = gst_vulkan_swapper_get_surface_rectangles;

    extern fn gst_vulkan_swapper_render_buffer(p_swapper: *VulkanSwapper, p_buffer: *gst.Buffer, p_error: ?*?*glib.Error) c_int;
    pub const renderBuffer = gst_vulkan_swapper_render_buffer;

    extern fn gst_vulkan_swapper_set_caps(p_swapper: *VulkanSwapper, p_caps: *gst.Caps, p_error: ?*?*glib.Error) c_int;
    pub const setCaps = gst_vulkan_swapper_set_caps;

    extern fn gst_vulkan_swapper_get_type() usize;
    pub const getGObjectType = gst_vulkan_swapper_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanSwapper) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanSwapper) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanSwapper, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanTrashFenceList = opaque {
    pub const Parent = gstvulkan.VulkanTrashList;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanTrashFenceListClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_trash_fence_list_new() *gstvulkan.VulkanTrashFenceList;
    pub const new = gst_vulkan_trash_fence_list_new;

    extern fn gst_vulkan_trash_fence_list_get_type() usize;
    pub const getGObjectType = gst_vulkan_trash_fence_list_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanTrashFenceList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanTrashFenceList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanTrashFenceList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanTrashList = extern struct {
    pub const Parent = gstvulkan.VulkanHandlePool;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanTrashListClass;
    /// the parent `gstvulkan.VulkanHandle`
    f_parent: gstvulkan.VulkanHandlePool,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {
        /// the `gstvulkan.VulkanTrashListAdd` functions
        pub const add_func = struct {
            pub fn call(p_class: anytype, p_trash_list: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_trash: *gstvulkan.VulkanTrash) c_int {
                return gobject.ext.as(VulkanTrashList.Class, p_class).f_add_func.?(gobject.ext.as(VulkanTrashList, p_trash_list), p_trash);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_trash_list: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_trash: *gstvulkan.VulkanTrash) callconv(.C) c_int) void {
                gobject.ext.as(VulkanTrashList.Class, p_class).f_add_func = @ptrCast(p_implementation);
            }
        };

        /// the `gstvulkan.VulkanTrashListGC` function
        pub const gc_func = struct {
            pub fn call(p_class: anytype, p_trash_list: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(VulkanTrashList.Class, p_class).f_gc_func.?(gobject.ext.as(VulkanTrashList, p_trash_list));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_trash_list: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(VulkanTrashList.Class, p_class).f_gc_func = @ptrCast(p_implementation);
            }
        };

        /// the `gstvulkan.VulkanTrashListWait` function
        pub const wait_func = struct {
            pub fn call(p_class: anytype, p_trash_list: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_timeout: u64) c_int {
                return gobject.ext.as(VulkanTrashList.Class, p_class).f_wait_func.?(gobject.ext.as(VulkanTrashList, p_trash_list), p_timeout);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_trash_list: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_timeout: u64) callconv(.C) c_int) void {
                gobject.ext.as(VulkanTrashList.Class, p_class).f_wait_func = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_trash_list_acquire(p_trash_list: *VulkanTrashList, p_fence: *gstvulkan.VulkanFence, p_notify: gstvulkan.VulkanTrashNotify, p_user_data: ?*anyopaque) *gstvulkan.VulkanTrash;
    pub const acquire = gst_vulkan_trash_list_acquire;

    extern fn gst_vulkan_trash_list_add(p_trash_list: *VulkanTrashList, p_trash: *gstvulkan.VulkanTrash) c_int;
    pub const add = gst_vulkan_trash_list_add;

    /// Remove any stored `gstvulkan.VulkanTrash` objects that have had their associated
    /// `gstvulkan.VulkanFence` signalled.
    extern fn gst_vulkan_trash_list_gc(p_trash_list: *VulkanTrashList) void;
    pub const gc = gst_vulkan_trash_list_gc;

    extern fn gst_vulkan_trash_list_wait(p_trash_list: *VulkanTrashList, p_timeout: u64) c_int;
    pub const wait = gst_vulkan_trash_list_wait;

    extern fn gst_vulkan_trash_list_get_type() usize;
    pub const getGObjectType = gst_vulkan_trash_list_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanTrashList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanTrashList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanTrashList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanVideoFilter = extern struct {
    pub const Parent = gstbase.BaseTransform;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanVideoFilterClass;
    /// the parent `gstbase.BaseTransform`
    f_parent: gstbase.BaseTransform,
    /// the configured `gstvulkan.VulkanInstance`
    f_instance: ?*gstvulkan.VulkanInstance,
    /// the configured `gstvulkan.VulkanDevice`
    f_device: ?*gstvulkan.VulkanDevice,
    /// the configured `gstvulkan.VulkanQueue`
    f_queue: ?*gstvulkan.VulkanQueue,
    /// the configured input `gst.Caps`
    f_in_caps: ?*gst.Caps,
    /// the configured input `gstvideo.VideoInfo`
    f_in_info: gstvideo.VideoInfo,
    /// the configured output `gst.Caps`
    f_out_caps: ?*gst.Caps,
    /// the configured output `gstvideo.VideoInfo`
    f_out_info: gstvideo.VideoInfo,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_vulkan_video_filter_get_type() usize;
    pub const getGObjectType = gst_vulkan_video_filter_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanVideoFilter) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanVideoFilter) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanVideoFilter, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstvulkan.VulkanWindow` is an opaque struct and should only be accessed through the
/// provided api.
pub const VulkanWindow = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstvulkan.VulkanWindowClass;
    f_parent: gst.Object,
    f_display: ?*gstvulkan.VulkanDisplay,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {
        /// Attempt to close the window.
        pub const close = struct {
            pub fn call(p_class: anytype, p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(VulkanWindow.Class, p_class).f_close.?(gobject.ext.as(VulkanWindow, p_window));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(VulkanWindow.Class, p_class).f_close = @ptrCast(p_implementation);
            }
        };

        /// retrieve whether this window supports presentation
        pub const get_presentation_support = struct {
            pub fn call(p_class: anytype, p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_device: *gstvulkan.VulkanDevice, p_queue_family_idx: u32) c_int {
                return gobject.ext.as(VulkanWindow.Class, p_class).f_get_presentation_support.?(gobject.ext.as(VulkanWindow, p_window), p_device, p_queue_family_idx);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_device: *gstvulkan.VulkanDevice, p_queue_family_idx: u32) callconv(.C) c_int) void {
                gobject.ext.as(VulkanWindow.Class, p_class).f_get_presentation_support = @ptrCast(p_implementation);
            }
        };

        /// retrieve the vulkan surface for this window
        pub const get_surface = struct {
            pub fn call(p_class: anytype, p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) vulkan.SurfaceKHR {
                return gobject.ext.as(VulkanWindow.Class, p_class).f_get_surface.?(gobject.ext.as(VulkanWindow, p_window), p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) callconv(.C) vulkan.SurfaceKHR) void {
                gobject.ext.as(VulkanWindow.Class, p_class).f_get_surface = @ptrCast(p_implementation);
            }
        };

        /// retrieve the current size of the window
        pub const get_surface_dimensions = struct {
            pub fn call(p_class: anytype, p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: *c_uint, p_height: *c_uint) void {
                return gobject.ext.as(VulkanWindow.Class, p_class).f_get_surface_dimensions.?(gobject.ext.as(VulkanWindow, p_window), p_width, p_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_width: *c_uint, p_height: *c_uint) callconv(.C) void) void {
                gobject.ext.as(VulkanWindow.Class, p_class).f_get_surface_dimensions = @ptrCast(p_implementation);
            }
        };

        /// Tell a `window` that it should handle events from the window system. These
        /// events are forwarded upstream as navigation events. In some window systems
        /// events are not propagated in the window hierarchy if a client is listening
        /// for them. This method allows you to disable events handling completely
        /// from the `window`.
        pub const handle_events = struct {
            pub fn call(p_class: anytype, p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle_events: c_int) void {
                return gobject.ext.as(VulkanWindow.Class, p_class).f_handle_events.?(gobject.ext.as(VulkanWindow, p_window), p_handle_events);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle_events: c_int) callconv(.C) void) void {
                gobject.ext.as(VulkanWindow.Class, p_class).f_handle_events = @ptrCast(p_implementation);
            }
        };

        /// open the connection to the display
        pub const open = struct {
            pub fn call(p_class: anytype, p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) c_int {
                return gobject.ext.as(VulkanWindow.Class, p_class).f_open.?(gobject.ext.as(VulkanWindow, p_window), p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) callconv(.C) c_int) void {
                gobject.ext.as(VulkanWindow.Class, p_class).f_open = @ptrCast(p_implementation);
            }
        };

        /// set the external window handle to render into
        pub const set_window_handle = struct {
            pub fn call(p_class: anytype, p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle: usize) void {
                return gobject.ext.as(VulkanWindow.Class, p_class).f_set_window_handle.?(gobject.ext.as(VulkanWindow, p_window), p_handle);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_window: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_handle: usize) callconv(.C) void) void {
                gobject.ext.as(VulkanWindow.Class, p_class).f_set_window_handle = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        pub const display = struct {
            pub const name = "display";

            pub const Type = ?*gstvulkan.VulkanDisplay;
        };
    };

    pub const signals = struct {
        pub const close = struct {
            pub const name = "close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(VulkanWindow, p_instance))),
                    gobject.signalLookup("close", VulkanWindow.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const draw = struct {
            pub const name = "draw";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(VulkanWindow, p_instance))),
                    gobject.signalLookup("draw", VulkanWindow.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Will be emitted when a key event is received by the `gstvulkan.VulkanWindow`.
        pub const key_event = struct {
            pub const name = "key-event";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_id: [*:0]u8, p_key: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(VulkanWindow, p_instance))),
                    gobject.signalLookup("key-event", VulkanWindow.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Will be emitted when a mouse event is received by the `gstvulkan.VulkanWindow`.
        pub const mouse_event = struct {
            pub const name = "mouse-event";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_id: [*:0]u8, p_button: c_int, p_x: f64, p_y: f64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(VulkanWindow, p_instance))),
                    gobject.signalLookup("mouse-event", VulkanWindow.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const resize = struct {
            pub const name = "resize";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_object: c_uint, p_p0: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(VulkanWindow, p_instance))),
                    gobject.signalLookup("resize", VulkanWindow.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    extern fn gst_vulkan_window_new(p_display: *gstvulkan.VulkanDisplay) *gstvulkan.VulkanWindow;
    pub const new = gst_vulkan_window_new;

    /// Attempt to close the window.
    extern fn gst_vulkan_window_close(p_window: *VulkanWindow) void;
    pub const close = gst_vulkan_window_close;

    extern fn gst_vulkan_window_get_display(p_window: *VulkanWindow) *gstvulkan.VulkanDisplay;
    pub const getDisplay = gst_vulkan_window_get_display;

    extern fn gst_vulkan_window_get_presentation_support(p_window: *VulkanWindow, p_device: *gstvulkan.VulkanDevice, p_queue_family_idx: u32) c_int;
    pub const getPresentationSupport = gst_vulkan_window_get_presentation_support;

    extern fn gst_vulkan_window_get_surface(p_window: *VulkanWindow, p_error: ?*?*glib.Error) vulkan.SurfaceKHR;
    pub const getSurface = gst_vulkan_window_get_surface;

    extern fn gst_vulkan_window_get_surface_dimensions(p_window: *VulkanWindow, p_width: *c_uint, p_height: *c_uint) void;
    pub const getSurfaceDimensions = gst_vulkan_window_get_surface_dimensions;

    /// Tell a `window` that it should handle events from the window system. These
    /// events are forwarded upstream as navigation events. In some window systems
    /// events are not propagated in the window hierarchy if a client is listening
    /// for them. This method allows you to disable events handling completely
    /// from the `window`.
    extern fn gst_vulkan_window_handle_events(p_window: *VulkanWindow, p_handle_events: c_int) void;
    pub const handleEvents = gst_vulkan_window_handle_events;

    extern fn gst_vulkan_window_open(p_window: *VulkanWindow, p_error: ?*?*glib.Error) c_int;
    pub const open = gst_vulkan_window_open;

    /// Ask the `window` to redraw its contents
    extern fn gst_vulkan_window_redraw(p_window: *VulkanWindow) void;
    pub const redraw = gst_vulkan_window_redraw;

    /// Resize the output surface.
    ///
    /// Currently intended for subclasses to update internal state.
    extern fn gst_vulkan_window_resize(p_window: *VulkanWindow, p_width: c_int, p_height: c_int) void;
    pub const resize = gst_vulkan_window_resize;

    extern fn gst_vulkan_window_send_key_event(p_window: *VulkanWindow, p_event_type: [*:0]const u8, p_key_str: [*:0]const u8) void;
    pub const sendKeyEvent = gst_vulkan_window_send_key_event;

    extern fn gst_vulkan_window_send_mouse_event(p_window: *VulkanWindow, p_event_type: [*:0]const u8, p_button: c_int, p_posx: f64, p_posy: f64) void;
    pub const sendMouseEvent = gst_vulkan_window_send_mouse_event;

    extern fn gst_vulkan_window_set_window_handle(p_window: *VulkanWindow, p_handle: usize) void;
    pub const setWindowHandle = gst_vulkan_window_set_window_handle;

    extern fn gst_vulkan_window_get_type() usize;
    pub const getGObjectType = gst_vulkan_window_get_type;

    extern fn g_object_ref(p_self: *gstvulkan.VulkanWindow) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkan.VulkanWindow) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanWindow, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanBarrierBufferInfo = extern struct {
    /// parent `gstvulkan.VulkanBarrierMemoryInfo`
    f_parent: gstvulkan.VulkanBarrierMemoryInfo,
    /// offset into the vulkan buffer to execute the barrier with
    f_offset: vulkan.DeviceSize,
    /// size of memory to execute barrier over
    f_size: vulkan.DeviceSize,
};

pub const VulkanBarrierImageInfo = extern struct {
    /// parent `gstvulkan.VulkanBarrierMemoryInfo`
    f_parent: gstvulkan.VulkanBarrierMemoryInfo,
    /// the image layout of this barrier
    f_image_layout: vulkan.ImageLayout,
    /// what subresource the barrier applies to
    f_subresource_range: vulkan.ImageSubresourceRange,
};

pub const VulkanBarrierMemoryInfo = extern struct {
    /// the `gstvulkan.VulkanBarrierType` of the barrier
    /// `flags` the `gstvulkan.VulkanBarrierFlags` of the barrier
    f_type: gstvulkan.VulkanBarrierType,
    f_flags: gstvulkan.VulkanBarrierFlags,
    /// the `gstvulkan.VulkanQueue` this barrier is to execute with
    f_queue: ?*gstvulkan.VulkanQueue,
    /// the stages in the graphics pipeline to execute the barrier
    f_pipeline_stages: u64,
    /// access flags
    f_access_flags: u64,
    /// Timeline semaphore
    f_semaphore: vulkan.Semaphore,
    /// Current value of the timeline semaphore
    f_semaphore_value: u64,
    f__reserved: [4]*anyopaque,
};

pub const VulkanBufferMemory = extern struct {
    /// parent `gst.Memory`
    f_parent: gst.Memory,
    /// the `gstvulkan.VulkanDevice` this vulkan buffer is allocated from
    f_device: ?*gstvulkan.VulkanDevice,
    /// Vulkan buffer object
    f_buffer: vulkan.Buffer,
    /// backing `gstvulkan.VulkanMemory` for `buffer`
    f_vk_mem: ?*gstvulkan.VulkanMemory,
    /// allocation requirements for `buffer`
    f_requirements: vulkan.MemoryRequirements,
    /// intended usage for `buffer`
    f_usage: vulkan.BufferUsageFlags,
    /// the last set barrier information
    f_barrier: gstvulkan.VulkanBarrierBufferInfo,
    f_lock: glib.Mutex,
    f_wrapped: c_int,
    f_notify: ?glib.DestroyNotify,
    f_user_data: ?*anyopaque,

    /// Allocate a new `gstvulkan.VulkanBufferMemory`.
    extern fn gst_vulkan_buffer_memory_alloc(p_device: *gstvulkan.VulkanDevice, p_size: usize, p_usage: vulkan.BufferUsageFlags, p_mem_prop_flags: vulkan.MemoryPropertyFlags) *gst.Memory;
    pub const alloc = gst_vulkan_buffer_memory_alloc;

    /// Allocate a new `gstvulkan.VulkanBufferMemory`.
    extern fn gst_vulkan_buffer_memory_alloc_with_buffer_info(p_device: *gstvulkan.VulkanDevice, p_buffer_info: *vulkan.BufferCreateInfo, p_mem_prop_flags: vulkan.MemoryPropertyFlags) *gst.Memory;
    pub const allocWithBufferInfo = gst_vulkan_buffer_memory_alloc_with_buffer_info;

    /// Initializes the Vulkan buffer memory allocator. It is safe to call this function
    /// multiple times.  This must be called before any other `gstvulkan.VulkanBufferMemory` operation.
    extern fn gst_vulkan_buffer_memory_init_once() void;
    pub const initOnce = gst_vulkan_buffer_memory_init_once;

    /// Allocated a new wrapped `gstvulkan.VulkanBufferMemory` with `buffer`.
    extern fn gst_vulkan_buffer_memory_wrapped(p_device: *gstvulkan.VulkanDevice, p_buffer: vulkan.Buffer, p_usage: vulkan.BufferUsageFlags, p_user_data: ?*anyopaque, p_notify: ?glib.DestroyNotify) *gst.Memory;
    pub const wrapped = gst_vulkan_buffer_memory_wrapped;
};

/// The `gstvulkan.VulkanBufferMemoryAllocatorClass` only contains private data
pub const VulkanBufferMemoryAllocatorClass = extern struct {
    pub const Instance = gstvulkan.VulkanBufferMemoryAllocator;

    /// the parent `gst.AllocatorClass`
    f_parent_class: gst.AllocatorClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanBufferMemoryAllocatorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `gstvulkan.VulkanBufferPoolClass` structure contains only private data
pub const VulkanBufferPoolClass = extern struct {
    pub const Instance = gstvulkan.VulkanBufferPool;

    /// the parent `gst.BufferPoolClass`
    f_parent_class: gst.BufferPoolClass,
    f__padding: [4]*anyopaque,

    pub fn as(p_instance: *VulkanBufferPoolClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanBufferPoolPrivate = opaque {};

pub const VulkanCommandBuffer = extern struct {
    /// the parent `gst.MiniObject`
    f_parent: gst.MiniObject,
    /// the vulkan command buffer handle
    f_cmd: vulkan.CommandBuffer,
    /// the parent `gstvulkan.VulkanCommandPool` for command buffer reuse and locking
    f_pool: ?*gstvulkan.VulkanCommandPool,
    /// the level of the vulkan command buffer
    f_level: vulkan.CommandBufferLevel,
    f__reserved: [4]*anyopaque,

    extern fn gst_vulkan_command_buffer_new_wrapped(p_cmd: vulkan.CommandBuffer, p_level: vulkan.CommandBufferLevel) *gstvulkan.VulkanCommandBuffer;
    pub const newWrapped = gst_vulkan_command_buffer_new_wrapped;

    /// Increases the refcount of the given buffer by one.
    extern fn gst_vulkan_command_buffer_ref(p_cmd: *VulkanCommandBuffer) *gstvulkan.VulkanCommandBuffer;
    pub const ref = gst_vulkan_command_buffer_ref;

    extern fn gst_vulkan_command_buffer_get_type() usize;
    pub const getGObjectType = gst_vulkan_command_buffer_get_type;
};

pub const VulkanCommandPoolClass = extern struct {
    pub const Instance = gstvulkan.VulkanCommandPool;

    /// the parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanCommandPoolClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanCommandPoolPrivate = opaque {};

pub const VulkanDecoderClass = extern struct {
    pub const Instance = gstvulkan.VulkanDecoder;

    f_parent: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanDecoderClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// It contains the whole state for decoding a single picture.
pub const VulkanDecoderPicture = extern struct {
    /// output buffer
    f_out: ?*gst.Buffer,
    /// DPB representation of `out` if needed by driver
    f_dpb: ?*gst.Buffer,
    /// image view for reference
    f_img_view_ref: ?*gstvulkan.VulkanImageView,
    /// image view for output
    f_img_view_out: ?*gstvulkan.VulkanImageView,
    /// array of offsets of each uploaded slice
    f_slice_offs: ?*glib.Array,
    /// references required to decode current pictures
    f_refs: [36]*gstvulkan.VulkanDecoderPicture,
    f_pics_res: [36]vulkan.VideoPictureResourceInfoKHR,
    f_slots: [36]vulkan.VideoReferenceSlotInfoKHR,
    f_pic_res: vulkan.VideoPictureResourceInfoKHR,
    f_slot: vulkan.VideoReferenceSlotInfoKHR,
    f_decode_info: vulkan.VideoDecodeInfoKHR,

    /// Releases the internal resource of `pic`.
    extern fn gst_vulkan_decoder_picture_release(p_pic: *VulkanDecoderPicture) void;
    pub const release = gst_vulkan_decoder_picture_release;
};

pub const VulkanDecoderPrivate = opaque {};

pub const VulkanDescriptorCacheClass = extern struct {
    pub const Instance = gstvulkan.VulkanDescriptorCache;

    /// the parent `gst.ObjectClass`
    f_parent_class: gstvulkan.VulkanHandlePoolClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanDescriptorCacheClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDescriptorCachePrivate = opaque {};

pub const VulkanDescriptorPoolClass = extern struct {
    pub const Instance = gstvulkan.VulkanDescriptorPool;

    /// the parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanDescriptorPoolClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDescriptorPoolPrivate = opaque {};

pub const VulkanDescriptorSet = extern struct {
    /// the parent `gst.MiniObject`
    f_parent: gst.MiniObject,
    /// the vulkan descriptor set handle
    f_set: vulkan.DescriptorSet,
    /// the parent `gstvulkan.VulkanDescriptorPool` for pooling
    f_pool: ?*gstvulkan.VulkanDescriptorPool,
    /// the parent `gstvulkan.VulkanDescriptorCache` for reuse
    f_cache: ?*gstvulkan.VulkanDescriptorCache,
    /// number of layouts applied to this descriptor set
    f_n_layouts: c_uint,
    /// layouts applied to this descriptor set
    f_layouts: ?**gstvulkan.VulkanHandle,
    f__reserved: [4]*anyopaque,

    extern fn gst_vulkan_descriptor_set_new_wrapped(p_pool: *gstvulkan.VulkanDescriptorPool, p_set: vulkan.DescriptorSet, p_n_layouts: c_uint, p_layouts: [*]*gstvulkan.VulkanHandle) *gstvulkan.VulkanDescriptorSet;
    pub const newWrapped = gst_vulkan_descriptor_set_new_wrapped;

    /// Increases the refcount of the given buffer by one.
    extern fn gst_vulkan_descriptor_set_ref(p_set: *VulkanDescriptorSet) *gstvulkan.VulkanDescriptorSet;
    pub const ref = gst_vulkan_descriptor_set_ref;

    extern fn gst_vulkan_descriptor_set_get_type() usize;
    pub const getGObjectType = gst_vulkan_descriptor_set_get_type;
};

pub const VulkanDeviceClass = extern struct {
    pub const Instance = gstvulkan.VulkanDevice;

    /// the parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanDeviceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDevicePrivate = opaque {};

pub const VulkanDisplayClass = extern struct {
    pub const Instance = gstvulkan.VulkanDisplay;

    /// parent `gst.ObjectClass`
    f_object_class: gst.ObjectClass,
    /// get the native handle to the display
    f_get_handle: ?*const fn (p_display: *gstvulkan.VulkanDisplay) callconv(.C) ?*anyopaque,
    /// create a window
    f_create_window: ?*const fn (p_display: *gstvulkan.VulkanDisplay) callconv(.C) ?*gstvulkan.VulkanWindow,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanDisplayClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDisplayPrivate = opaque {};

pub const VulkanFence = extern struct {
    /// the parent `gst.MiniObject`
    f_parent: gst.MiniObject,
    /// the `gstvulkan.VulkanDevice` this fence is allocated from
    f_device: ?*gstvulkan.VulkanDevice,
    /// the parent `gstvulkan.VulkanFenceCache` for fence reuse
    f_cache: ?*gstvulkan.VulkanFenceCache,
    /// the vulkan fence handle
    f_fence: vulkan.Fence,
    f__reserved: [4]*anyopaque,

    extern fn gst_vulkan_fence_new(p_device: *gstvulkan.VulkanDevice, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanFence;
    pub const new = gst_vulkan_fence_new;

    extern fn gst_vulkan_fence_new_always_signalled(p_device: *gstvulkan.VulkanDevice) *gstvulkan.VulkanFence;
    pub const newAlwaysSignalled = gst_vulkan_fence_new_always_signalled;

    extern fn gst_vulkan_fence_is_signaled(p_fence: *VulkanFence) c_int;
    pub const isSignaled = gst_vulkan_fence_is_signaled;

    extern fn gst_vulkan_fence_reset(p_fence: *VulkanFence) void;
    pub const reset = gst_vulkan_fence_reset;

    extern fn gst_vulkan_fence_get_type() usize;
    pub const getGObjectType = gst_vulkan_fence_get_type;
};

pub const VulkanFenceCacheClass = extern struct {
    pub const Instance = gstvulkan.VulkanFenceCache;

    /// the parent `gstvulkan.VulkanHandlePoolClass`
    f_parent_class: gstvulkan.VulkanHandlePoolClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanFenceCacheClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanFormatInfo = extern struct {
    /// the Vulkan format being described
    f_format: vulkan.Format,
    /// name of this format
    f_name: ?[*:0]const u8,
    /// how raw data is interpreted and scaled
    f_scaling: gstvulkan.VulkanFormatScaling,
    /// flags that apply to this format
    f_flags: gstvulkan.VulkanFormatFlags,
    /// The number of bits used to pack data items. This can be less than
    ///        8 when multiple pixels are stored in a byte. for values > 8 multiple
    ///        bytes should be read according to the endianness flag before
    ///        applying the shift and mask.
    /// `n_components`; number of components in this format
    f_bits: c_uint,
    f_n_components: c_uint,
    /// the number of bits to shift away to get the component data
    f_shift: [4]u8,
    /// the depth in bits for each component
    f_depth: [4]u8,
    f_pixel_stride: [4]i8,
    /// the number of planes for this format. The number of planes can
    ///            be less than the amount of components when multiple components
    ///            are packed into one plane.
    f_n_planes: c_uint,
    /// the plane number where a component can be found
    f_plane: [4]u8,
    /// the offset in the plane where the first pixel of the components
    ///           can be found.
    f_poffset: [4]u8,
    /// subsampling factor of the width for the component.
    ///         Use GST_VIDEO_SUB_SCALE to scale a width.
    f_w_sub: [4]u8,
    /// subsampling factor of the height for the component.
    ///         Use GST_VIDEO_SUB_SCALE to scale a height.
    f_h_sub: [4]u8,
    /// image aspect of this format
    f_aspect: vulkan.ImageAspectFlags,
};

pub const VulkanFullScreenQuadClass = extern struct {
    pub const Instance = gstvulkan.VulkanFullScreenQuad;

    /// the parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanFullScreenQuadClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanFullScreenQuadPrivate = opaque {};

/// Holds information about a vulkan non dispatchable handle that only has
/// a vulkan device as a parent and no specific host synchronisation
/// requirements.  Command buffers have extra requirements that are serviced by
/// more specific implementations (`gstvulkan.VulkanCommandBuffer`, `gstvulkan.VulkanCommandPool`).
pub const VulkanHandle = extern struct {
    /// the parent `gst.MiniObject`
    f_parent: gst.MiniObject,
    /// the `gstvulkan.VulkanDevice` for this handle
    f_device: ?*gstvulkan.VulkanDevice,
    /// the type of handle
    f_type: gstvulkan.VulkanHandleType,
    /// the handle value
    f_handle: gstvulkan.VulkanHandleTypedef,
    f_notify: ?gstvulkan.VulkanHandleDestroyNotify,
    f_user_data: ?*anyopaque,
    f__reserved: [4]*anyopaque,

    extern fn gst_vulkan_handle_context_query(p_element: *gst.Element, p_query: *gst.Query, p_display: ?*gstvulkan.VulkanDisplay, p_instance: ?*gstvulkan.VulkanInstance, p_device: ?*gstvulkan.VulkanDevice) c_int;
    pub const contextQuery = gst_vulkan_handle_context_query;

    /// Helper function for implementing `gst.ElementClass.virtual_methods.set_context` in
    /// Vulkan capable elements.
    ///
    /// Retrieve's the `gstvulkan.VulkanDisplay` or `gstvulkan.VulkanInstance` in `context` and places
    /// the result in `display` or `instance` respectively.
    extern fn gst_vulkan_handle_set_context(p_element: *gst.Element, p_context: *gst.Context, p_display: ?**gstvulkan.VulkanDisplay, p_instance: **gstvulkan.VulkanInstance) c_int;
    pub const setContext = gst_vulkan_handle_set_context;

    extern fn gst_vulkan_handle_new_wrapped(p_device: *gstvulkan.VulkanDevice, p_type: gstvulkan.VulkanHandleType, p_handle: gstvulkan.VulkanHandleTypedef, p_notify: gstvulkan.VulkanHandleDestroyNotify, p_user_data: ?*anyopaque) *gstvulkan.VulkanHandle;
    pub const newWrapped = gst_vulkan_handle_new_wrapped;

    /// Frees the descriptor set layout in `handle`
    extern fn gst_vulkan_handle_free_descriptor_set_layout(p_handle: *VulkanHandle, p_user_data: ?*anyopaque) void;
    pub const freeDescriptorSetLayout = gst_vulkan_handle_free_descriptor_set_layout;

    /// Frees the framebuffer in `handle`
    extern fn gst_vulkan_handle_free_framebuffer(p_handle: *VulkanHandle, p_user_data: ?*anyopaque) void;
    pub const freeFramebuffer = gst_vulkan_handle_free_framebuffer;

    /// Frees the pipeline in `handle`
    extern fn gst_vulkan_handle_free_pipeline(p_handle: *VulkanHandle, p_user_data: ?*anyopaque) void;
    pub const freePipeline = gst_vulkan_handle_free_pipeline;

    /// Frees the pipeline layout in `handle`
    extern fn gst_vulkan_handle_free_pipeline_layout(p_handle: *VulkanHandle, p_user_data: ?*anyopaque) void;
    pub const freePipelineLayout = gst_vulkan_handle_free_pipeline_layout;

    /// Frees the render pass in `handle`
    extern fn gst_vulkan_handle_free_render_pass(p_handle: *VulkanHandle, p_user_data: ?*anyopaque) void;
    pub const freeRenderPass = gst_vulkan_handle_free_render_pass;

    /// Frees the sampler in `handle`
    extern fn gst_vulkan_handle_free_sampler(p_handle: *VulkanHandle, p_user_data: ?*anyopaque) void;
    pub const freeSampler = gst_vulkan_handle_free_sampler;

    /// Frees the shader in `handle`
    extern fn gst_vulkan_handle_free_shader(p_handle: *VulkanHandle, p_user_data: ?*anyopaque) void;
    pub const freeShader = gst_vulkan_handle_free_shader;

    /// Increases the refcount of the given handle by one.
    extern fn gst_vulkan_handle_ref(p_handle: *VulkanHandle) *gstvulkan.VulkanHandle;
    pub const ref = gst_vulkan_handle_ref;

    extern fn gst_vulkan_handle_get_type() usize;
    pub const getGObjectType = gst_vulkan_handle_get_type;
};

pub const VulkanHandlePoolClass = extern struct {
    pub const Instance = gstvulkan.VulkanHandlePool;

    /// the parent `gst.ObjectClass`
    f_parent: gst.ObjectClass,
    /// allocate a new handle
    f_alloc: ?*const fn (p_pool: *gstvulkan.VulkanHandlePool, p_error: ?*?*glib.Error) callconv(.C) ?*anyopaque,
    /// acquire a handle for usage
    f_acquire: ?*const fn (p_pool: *gstvulkan.VulkanHandlePool, p_error: ?*?*glib.Error) callconv(.C) ?*anyopaque,
    /// release a handle for possible reuse at the next call to `acquire`
    f_release: ?*const fn (p_pool: *gstvulkan.VulkanHandlePool, p_handle: ?*anyopaque) callconv(.C) void,
    /// free a handle
    f_free: ?*const fn (p_pool: *gstvulkan.VulkanHandlePool, p_handle: ?*anyopaque) callconv(.C) void,
    f__padding: [4]*anyopaque,

    pub fn as(p_instance: *VulkanHandlePoolClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `gstvulkan.VulkanImageBufferPoolClass` structure contains only private data
pub const VulkanImageBufferPoolClass = extern struct {
    pub const Instance = gstvulkan.VulkanImageBufferPool;

    /// parent `gst.BufferPoolClass`
    f_parent_class: gst.BufferPoolClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanImageBufferPoolClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanImageBufferPoolPrivate = opaque {};

pub const VulkanImageMemory = extern struct {
    /// parent `gst.Memory`
    f_parent: gst.Memory,
    /// the `gstvulkan.VulkanDevice` to allocate images from
    f_device: ?*gstvulkan.VulkanDevice,
    /// the Vulkan image handle
    f_image: vulkan.Image,
    /// the backing `gstvulkan.VulkanMemory` for `image`
    f_vk_mem: ?*gstvulkan.VulkanMemory,
    /// creation information for `image`
    f_create_info: vulkan.ImageCreateInfo,
    /// memory requirements for `image`
    f_requirements: vulkan.MemoryRequirements,
    /// format properties
    f_format_properties: vulkan.ImageFormatProperties,
    /// intended usage for `image`
    f_usage: vulkan.ImageUsageFlags,
    /// last set barrier for `image`
    f_barrier: gstvulkan.VulkanBarrierImageInfo,
    f_lock: glib.Mutex,
    f_wrapped: c_int,
    f_notify: ?glib.DestroyNotify,
    f_user_data: ?*anyopaque,
    f_views: ?*glib.PtrArray,
    f_outstanding_views: ?*glib.PtrArray,
    f__padding: [4]*anyopaque,

    /// Allocated a new `gstvulkan.VulkanImageMemory`.
    extern fn gst_vulkan_image_memory_alloc(p_device: *gstvulkan.VulkanDevice, p_format: vulkan.Format, p_width: usize, p_height: usize, p_tiling: vulkan.ImageTiling, p_usage: vulkan.ImageUsageFlags, p_mem_prop_flags: vulkan.MemoryPropertyFlags) *gst.Memory;
    pub const alloc = gst_vulkan_image_memory_alloc;

    extern fn gst_vulkan_image_memory_alloc_with_image_info(p_device: *gstvulkan.VulkanDevice, p_image_info: *vulkan.ImageCreateInfo, p_mem_prop_flags: vulkan.MemoryPropertyFlags) *gst.Memory;
    pub const allocWithImageInfo = gst_vulkan_image_memory_alloc_with_image_info;

    /// Initializes the Vulkan image memory allocator. It is safe to call this function
    /// multiple times.  This must be called before any other `gstvulkan.VulkanImageMemory` operation.
    extern fn gst_vulkan_image_memory_init_once() void;
    pub const initOnce = gst_vulkan_image_memory_init_once;

    extern fn gst_vulkan_image_memory_wrapped(p_device: *gstvulkan.VulkanDevice, p_image: vulkan.Image, p_format: vulkan.Format, p_width: usize, p_height: usize, p_tiling: vulkan.ImageTiling, p_usage: vulkan.ImageUsageFlags, p_user_data: ?*anyopaque, p_notify: glib.DestroyNotify) *gst.Memory;
    pub const wrapped = gst_vulkan_image_memory_wrapped;

    extern fn gst_vulkan_image_memory_add_view(p_image: *VulkanImageMemory, p_view: *gstvulkan.VulkanImageView) void;
    pub const addView = gst_vulkan_image_memory_add_view;

    extern fn gst_vulkan_image_memory_find_view(p_image: *VulkanImageMemory, p_find_func: gstvulkan.VulkanImageMemoryFindViewFunc, p_user_data: ?*anyopaque) ?*gstvulkan.VulkanImageView;
    pub const findView = gst_vulkan_image_memory_find_view;

    extern fn gst_vulkan_image_memory_get_height(p_image: *VulkanImageMemory) u32;
    pub const getHeight = gst_vulkan_image_memory_get_height;

    extern fn gst_vulkan_image_memory_get_width(p_image: *VulkanImageMemory) u32;
    pub const getWidth = gst_vulkan_image_memory_get_width;

    extern fn gst_vulkan_image_memory_init(p_mem: *VulkanImageMemory, p_allocator: *gst.Allocator, p_parent: *gst.Memory, p_device: *gstvulkan.VulkanDevice, p_format: vulkan.Format, p_usage: vulkan.ImageUsageFlags, p_initial_layout: vulkan.ImageLayout, p_params: *gst.AllocationParams, p_size: usize, p_user_data: ?*anyopaque, p_notify: glib.DestroyNotify) c_int;
    pub const init = gst_vulkan_image_memory_init;
};

/// The `gstvulkan.VulkanImageMemoryAllocatorClass` only contains private data
pub const VulkanImageMemoryAllocatorClass = extern struct {
    pub const Instance = gstvulkan.VulkanImageMemoryAllocator;

    /// the parent `gst.AllocatorClass`
    f_parent_class: gst.AllocatorClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanImageMemoryAllocatorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanImageView = extern struct {
    /// the parent `gst.MiniObject`
    f_parent: gst.MiniObject,
    /// the `gstvulkan.VulkanDevice`
    f_device: ?*gstvulkan.VulkanDevice,
    /// the associated `gstvulkan.VulkanImageMemory` for this view
    f_image: ?*gstvulkan.VulkanImageMemory,
    /// the vulkan image view handle
    f_view: vulkan.ImageView,
    /// the creation information for this view
    f_create_info: vulkan.ImageViewCreateInfo,
    f__reserved: [4]*anyopaque,

    extern fn gst_vulkan_image_view_new(p_image: *gstvulkan.VulkanImageMemory, p_create_info: *const vulkan.ImageViewCreateInfo) *gstvulkan.VulkanImageView;
    pub const new = gst_vulkan_image_view_new;

    /// Increases the refcount of the given trash object by one.
    extern fn gst_vulkan_image_view_ref(p_trash: *VulkanImageView) *gstvulkan.VulkanImageView;
    pub const ref = gst_vulkan_image_view_ref;

    extern fn gst_vulkan_image_view_get_type() usize;
    pub const getGObjectType = gst_vulkan_image_view_get_type;
};

pub const VulkanInstanceClass = extern struct {
    pub const Instance = gstvulkan.VulkanInstance;

    /// parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanInstanceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanInstancePrivate = opaque {};

pub const VulkanMemory = extern struct {
    /// the parent `gst.Memory`
    f_mem: gst.Memory,
    /// the `gstvulkan.VulkanDevice` this memory is allocated from
    f_device: ?*gstvulkan.VulkanDevice,
    /// the vulkan memory handle
    f_mem_ptr: vulkan.DeviceMemory,
    /// lock for accessing/changing memory informat
    f_lock: glib.Mutex,
    /// number of times this memory is mapped
    f_map_count: c_uint,
    /// internal pointer to already mapped memory
    f_mapping: ?*anyopaque,
    f_notify: ?glib.DestroyNotify,
    f_user_data: ?*anyopaque,
    f_alloc_info: vulkan.MemoryAllocateInfo,
    f_properties: vulkan.MemoryPropertyFlags,
    f_vk_offset: u64,
    f_wrapped: c_int,
    f__reserved: [4]*anyopaque,

    /// Allocated a new `gstvulkan.VulkanMemory`.
    extern fn gst_vulkan_memory_alloc(p_device: *gstvulkan.VulkanDevice, p_memory_type_index: u32, p_params: *gst.AllocationParams, p_size: usize, p_mem_prop_flags: vulkan.MemoryPropertyFlags) *gst.Memory;
    pub const alloc = gst_vulkan_memory_alloc;

    extern fn gst_vulkan_memory_find_memory_type_index_with_requirements(p_device: *gstvulkan.VulkanDevice, p_req: *vulkan.MemoryRequirements, p_properties: vulkan.MemoryPropertyFlags, p_type_index: *u32) c_int;
    pub const findMemoryTypeIndexWithRequirements = gst_vulkan_memory_find_memory_type_index_with_requirements;

    extern fn gst_vulkan_memory_heap_flags_to_string(p_prop_bits: vulkan.MemoryHeapFlags) [*:0]u8;
    pub const heapFlagsToString = gst_vulkan_memory_heap_flags_to_string;

    /// Initializes the Vulkan memory allocator. It is safe to call this function
    /// multiple times.  This must be called before any other `gstvulkan.VulkanMemory` operation.
    extern fn gst_vulkan_memory_init_once() void;
    pub const initOnce = gst_vulkan_memory_init_once;

    extern fn gst_vulkan_memory_property_flags_to_string(p_prop_bits: vulkan.MemoryPropertyFlags) [*:0]u8;
    pub const propertyFlagsToString = gst_vulkan_memory_property_flags_to_string;
};

/// The `gstvulkan.VulkanMemoryAllocatorClass` only contains private data
pub const VulkanMemoryAllocatorClass = extern struct {
    pub const Instance = gstvulkan.VulkanMemoryAllocator;

    /// the parent `gst.AllocatorClass`
    f_parent_class: gst.AllocatorClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanMemoryAllocatorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanOperationClass = extern struct {
    pub const Instance = gstvulkan.VulkanOperation;

    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanOperationClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanOperationPrivate = opaque {};

pub const VulkanPhysicalDeviceClass = extern struct {
    pub const Instance = gstvulkan.VulkanPhysicalDevice;

    /// the parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanPhysicalDeviceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanPhysicalDevicePrivate = opaque {};

pub const VulkanQueueClass = extern struct {
    pub const Instance = gstvulkan.VulkanQueue;

    /// the parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanQueueClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanQueueFamilyOps = extern struct {
    /// video operation supported by queue family
    f_video: u32,
    /// if queue family supports queries
    f_query: c_int,
};

pub const VulkanQueuePrivate = opaque {};

pub const VulkanSwapperClass = extern struct {
    pub const Instance = gstvulkan.VulkanSwapper;

    /// parent `gst.ObjectClass`
    f_parent_class: gst.ObjectClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanSwapperClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanSwapperPrivate = opaque {};

pub const VulkanTrash = extern struct {
    f_parent: gst.MiniObject,
    f_cache: ?*gstvulkan.VulkanTrashList,
    f_fence: ?*gstvulkan.VulkanFence,
    f_notify: ?gstvulkan.VulkanTrashNotify,
    f_user_data: ?*anyopaque,
    f__padding: [4]*anyopaque,

    /// A `gstvulkan.VulkanTrashNotify` implementation for unreffing a `gst.MiniObject` when the
    /// associated `gstvulkan.VulkanFence` is signalled
    extern fn gst_vulkan_trash_mini_object_unref(p_device: *gstvulkan.VulkanDevice, p_user_data: ?*anyopaque) void;
    pub const miniObjectUnref = gst_vulkan_trash_mini_object_unref;

    /// A `gstvulkan.VulkanTrashNotify` implementation for unreffing a `gst.Object` when the
    /// associated `gstvulkan.VulkanFence` is signalled
    extern fn gst_vulkan_trash_object_unref(p_device: *gstvulkan.VulkanDevice, p_user_data: ?*anyopaque) void;
    pub const objectUnref = gst_vulkan_trash_object_unref;

    /// Create and return a new `gstvulkan.VulkanTrash` object that will stores a callback
    /// to call when `fence` is signalled.
    extern fn gst_vulkan_trash_new(p_fence: *gstvulkan.VulkanFence, p_notify: gstvulkan.VulkanTrashNotify, p_user_data: ?*anyopaque) *gstvulkan.VulkanTrash;
    pub const new = gst_vulkan_trash_new;

    extern fn gst_vulkan_trash_new_free_semaphore(p_fence: *gstvulkan.VulkanFence, p_semaphore: vulkan.Semaphore) *gstvulkan.VulkanTrash;
    pub const newFreeSemaphore = gst_vulkan_trash_new_free_semaphore;

    /// Increases the refcount of the given trash object by one.
    extern fn gst_vulkan_trash_ref(p_trash: *VulkanTrash) *gstvulkan.VulkanTrash;
    pub const ref = gst_vulkan_trash_ref;

    extern fn gst_vulkan_trash_get_type() usize;
    pub const getGObjectType = gst_vulkan_trash_get_type;
};

pub const VulkanTrashFenceListClass = extern struct {
    pub const Instance = gstvulkan.VulkanTrashFenceList;

    f_parent_class: gstvulkan.VulkanTrashListClass,

    pub fn as(p_instance: *VulkanTrashFenceListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanTrashListClass = extern struct {
    pub const Instance = gstvulkan.VulkanTrashList;

    /// the `gstvulkan.VulkanHandlePoolClass`
    f_parent_class: gstvulkan.VulkanHandlePoolClass,
    /// the `gstvulkan.VulkanTrashListAdd` functions
    f_add_func: ?gstvulkan.VulkanTrashListAdd,
    /// the `gstvulkan.VulkanTrashListGC` function
    f_gc_func: ?gstvulkan.VulkanTrashListGC,
    /// the `gstvulkan.VulkanTrashListWait` function
    f_wait_func: ?gstvulkan.VulkanTrashListWait,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanTrashListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanVideoCapabilities = extern struct {
    f_caps: vulkan.VideoCapabilitiesKHR,
    anon0: extern union {
        f_base: vulkan.BaseInStructure,
        f_h264dec: vulkan.VideoDecodeH264CapabilitiesKHR,
        f_h265dec: vulkan.VideoDecodeH265CapabilitiesKHR,
    },
    f__reserved: [4]*anyopaque,
};

pub const VulkanVideoFilterClass = extern struct {
    pub const Instance = gstvulkan.VulkanVideoFilter;

    /// the parent `gstbase.BaseTransformClass`
    f_parent_class: gstbase.BaseTransformClass,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanVideoFilterClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanVideoProfile = extern struct {
    /// the generic vulkan video profile
    f_profile: vulkan.VideoProfileInfoKHR,
    anon0: extern union {
        f_decode: vulkan.VideoDecodeUsageInfoKHR,
    },
    anon1: extern union {
        f_base: vulkan.BaseInStructure,
        f_h264dec: vulkan.VideoDecodeH264ProfileInfoKHR,
        f_h265dec: vulkan.VideoDecodeH265ProfileInfoKHR,
    },
    f__reserved: [4]*anyopaque,

    extern fn gst_vulkan_video_profile_from_caps(p_profile: *gstvulkan.VulkanVideoProfile, p_caps: *gst.Caps, p_video_operation: gstvulkan.VulkanVideoOperation) c_int;
    pub const fromCaps = gst_vulkan_video_profile_from_caps;

    extern fn gst_vulkan_video_profile_is_equal(p_a: *const VulkanVideoProfile, p_b: *const gstvulkan.VulkanVideoProfile) c_int;
    pub const isEqual = gst_vulkan_video_profile_is_equal;

    extern fn gst_vulkan_video_profile_is_valid(p_profile: *VulkanVideoProfile, p_codec: c_uint) c_int;
    pub const isValid = gst_vulkan_video_profile_is_valid;

    extern fn gst_vulkan_video_profile_to_caps(p_profile: *const VulkanVideoProfile) *gst.Caps;
    pub const toCaps = gst_vulkan_video_profile_to_caps;
};

pub const VulkanWindowClass = extern struct {
    pub const Instance = gstvulkan.VulkanWindow;

    /// Parent class
    f_parent_class: gst.ObjectClass,
    /// open the connection to the display
    f_open: ?*const fn (p_window: *gstvulkan.VulkanWindow, p_error: ?*?*glib.Error) callconv(.C) c_int,
    /// close the connection to the display
    f_close: ?*const fn (p_window: *gstvulkan.VulkanWindow) callconv(.C) void,
    /// retrieve the vulkan surface for this window
    f_get_surface: ?*const fn (p_window: *gstvulkan.VulkanWindow, p_error: ?*?*glib.Error) callconv(.C) vulkan.SurfaceKHR,
    /// retrieve whether this window supports presentation
    f_get_presentation_support: ?*const fn (p_window: *gstvulkan.VulkanWindow, p_device: *gstvulkan.VulkanDevice, p_queue_family_idx: u32) callconv(.C) c_int,
    /// set the external window handle to render into
    f_set_window_handle: ?*const fn (p_window: *gstvulkan.VulkanWindow, p_handle: usize) callconv(.C) void,
    /// retrieve the current size of the window
    f_get_surface_dimensions: ?*const fn (p_window: *gstvulkan.VulkanWindow, p_width: *c_uint, p_height: *c_uint) callconv(.C) void,
    f_handle_events: ?*const fn (p_window: *gstvulkan.VulkanWindow, p_handle_events: c_int) callconv(.C) void,
    f__reserved: [4]*anyopaque,

    pub fn as(p_instance: *VulkanWindowClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanWindowPrivate = opaque {};

/// Codec specific parameters.
pub const VulkanDecoderParameters = extern union {
    f_h264: vulkan.VideoDecodeH264SessionParametersCreateInfoKHR,
    f_h265: vulkan.VideoDecodeH265SessionParametersCreateInfoKHR,
};

pub const VulkanBarrierFlags = enum(c_int) {
    none = 0,
    _,

    extern fn gst_vulkan_barrier_flags_get_type() usize;
    pub const getGObjectType = gst_vulkan_barrier_flags_get_type;
};

pub const VulkanBarrierType = enum(c_int) {
    none = 0,
    type_memory = 1,
    type_buffer = 2,
    type_image = 3,
    _,

    extern fn gst_vulkan_barrier_type_get_type() usize;
    pub const getGObjectType = gst_vulkan_barrier_type_get_type;
};

pub const VulkanError = enum(c_int) {
    failed = 0,
    _,

    extern fn gst_vulkan_error_quark() glib.Quark;
    pub const quark = gst_vulkan_error_quark;

    /// if `result` indicates an error condition, fills out `glib.Error` with details of
    /// the error
    extern fn gst_vulkan_error_to_g_error(p_result: vulkan.Result, p_error: ?**glib.Error, p_format: [*:0]const u8, ...) vulkan.Result;
    pub const toGError = gst_vulkan_error_to_g_error;

    extern fn gst_vulkan_error_get_type() usize;
    pub const getGObjectType = gst_vulkan_error_get_type;
};

pub const VulkanFormatScaling = enum(c_int) {
    unorm = 1,
    snorm = 2,
    uscaled = 3,
    sscaled = 4,
    uint = 5,
    sint = 6,
    srgb = 7,
    _,

    extern fn gst_vulkan_format_scaling_get_type() usize;
    pub const getGObjectType = gst_vulkan_format_scaling_get_type;
};

pub const VulkanHandleType = enum(c_int) {
    descriptor_set_layout = 1,
    pipeline_layout = 2,
    pipeline = 3,
    render_pass = 4,
    sampler = 5,
    framebuffer = 6,
    shader = 7,
    video_session = 8,
    video_session_parameters = 9,
    sampler_ycbcr_conversion = 10,
    _,

    extern fn gst_vulkan_handle_type_get_type() usize;
    pub const getGObjectType = gst_vulkan_handle_type_get_type;
};

/// The type of video operation.
pub const VulkanVideoOperation = enum(c_int) {
    decode = 0,
    encode = 1,
    unknown = 2,
    _,

    extern fn gst_vulkan_video_operation_get_type() usize;
    pub const getGObjectType = gst_vulkan_video_operation_get_type;
};

pub const VulkanWindowError = enum(c_int) {
    failed = 0,
    old_libs = 1,
    resource_unavailable = 2,
    _,

    extern fn gst_vulkan_window_error_quark() glib.Quark;
    pub const quark = gst_vulkan_window_error_quark;

    extern fn gst_vulkan_window_error_get_type() usize;
    pub const getGObjectType = gst_vulkan_window_error_get_type;
};

pub const VulkanDisplayType = packed struct(c_uint) {
    xcb: bool = false,
    wayland: bool = false,
    cocoa: bool = false,
    ios: bool = false,
    win32: bool = false,
    android: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: VulkanDisplayType = @bitCast(@as(c_uint, 0));
    const flags_xcb: VulkanDisplayType = @bitCast(@as(c_uint, 1));
    const flags_wayland: VulkanDisplayType = @bitCast(@as(c_uint, 2));
    const flags_cocoa: VulkanDisplayType = @bitCast(@as(c_uint, 4));
    const flags_ios: VulkanDisplayType = @bitCast(@as(c_uint, 8));
    const flags_win32: VulkanDisplayType = @bitCast(@as(c_uint, 16));
    const flags_android: VulkanDisplayType = @bitCast(@as(c_uint, 32));
    const flags_any: VulkanDisplayType = @bitCast(@as(c_uint, 4294967295));
    extern fn gst_vulkan_display_type_to_extension_string(p_type: gstvulkan.VulkanDisplayType) ?[*:0]const u8;
    pub const toExtensionString = gst_vulkan_display_type_to_extension_string;

    extern fn gst_vulkan_display_type_get_type() usize;
    pub const getGObjectType = gst_vulkan_display_type_get_type;
};

pub const VulkanFormatFlags = packed struct(c_uint) {
    yuv: bool = false,
    rgb: bool = false,
    alpha: bool = false,
    le: bool = false,
    complex: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_yuv: VulkanFormatFlags = @bitCast(@as(c_uint, 1));
    const flags_rgb: VulkanFormatFlags = @bitCast(@as(c_uint, 2));
    const flags_alpha: VulkanFormatFlags = @bitCast(@as(c_uint, 4));
    const flags_le: VulkanFormatFlags = @bitCast(@as(c_uint, 8));
    const flags_complex: VulkanFormatFlags = @bitCast(@as(c_uint, 16));
    extern fn gst_vulkan_format_flags_get_type() usize;
    pub const getGObjectType = gst_vulkan_format_flags_get_type;
};

extern fn gst_context_get_vulkan_device(p_context: *gst.Context, p_device: **gstvulkan.VulkanDevice) c_int;
pub const contextGetVulkanDevice = gst_context_get_vulkan_device;

extern fn gst_context_get_vulkan_display(p_context: *gst.Context, p_display: **gstvulkan.VulkanDisplay) c_int;
pub const contextGetVulkanDisplay = gst_context_get_vulkan_display;

extern fn gst_context_get_vulkan_instance(p_context: *gst.Context, p_instance: **gstvulkan.VulkanInstance) c_int;
pub const contextGetVulkanInstance = gst_context_get_vulkan_instance;

extern fn gst_context_get_vulkan_queue(p_context: *gst.Context, p_queue: **gstvulkan.VulkanQueue) c_int;
pub const contextGetVulkanQueue = gst_context_get_vulkan_queue;

/// Sets `device` on `context`
extern fn gst_context_set_vulkan_device(p_context: *gst.Context, p_device: *gstvulkan.VulkanDevice) void;
pub const contextSetVulkanDevice = gst_context_set_vulkan_device;

/// Sets `display` on `context`
extern fn gst_context_set_vulkan_display(p_context: *gst.Context, p_display: *gstvulkan.VulkanDisplay) void;
pub const contextSetVulkanDisplay = gst_context_set_vulkan_display;

/// Sets `instance` on `context`
extern fn gst_context_set_vulkan_instance(p_context: *gst.Context, p_instance: *gstvulkan.VulkanInstance) void;
pub const contextSetVulkanInstance = gst_context_set_vulkan_instance;

/// Sets `queue` on `context`
extern fn gst_context_set_vulkan_queue(p_context: *gst.Context, p_queue: *gstvulkan.VulkanQueue) void;
pub const contextSetVulkanQueue = gst_context_set_vulkan_queue;

extern fn gst_is_vulkan_buffer_memory(p_mem: *gst.Memory) c_int;
pub const isVulkanBufferMemory = gst_is_vulkan_buffer_memory;

extern fn gst_is_vulkan_image_memory(p_mem: *gst.Memory) c_int;
pub const isVulkanImageMemory = gst_is_vulkan_image_memory;

extern fn gst_is_vulkan_memory(p_mem: *gst.Memory) c_int;
pub const isVulkanMemory = gst_is_vulkan_memory;

extern fn gst_vulkan_create_shader(p_device: *gstvulkan.VulkanDevice, p_code: [*:0]const u8, p_size: usize, p_error: ?*?*glib.Error) ?*gstvulkan.VulkanHandle;
pub const vulkanCreateShader = gst_vulkan_create_shader;

/// Perform the steps necessary for retrieving a `gstvulkan.VulkanInstance` and
/// (optionally) an `gstvulkan.VulkanDisplay` from the surrounding elements or from
/// the application using the `gst.Context` mechanism.
///
/// If the contents of `display_ptr` or `instance_ptr` are not `NULL`, then no
/// `gst.Context` query is necessary and no `gstvulkan.VulkanInstance` or `gstvulkan.VulkanDisplay`
/// retrieval is performed.
extern fn gst_vulkan_ensure_element_data(p_element: *gst.Element, p_display_ptr: ?**gstvulkan.VulkanDisplay, p_instance_ptr: **gstvulkan.VulkanInstance) c_int;
pub const vulkanEnsureElementData = gst_vulkan_ensure_element_data;

extern fn gst_vulkan_format_from_video_info(p_v_info: *gstvideo.VideoInfo, p_plane: c_uint) vulkan.Format;
pub const vulkanFormatFromVideoInfo = gst_vulkan_format_from_video_info;

extern fn gst_vulkan_format_from_video_info_2(p_physical_device: *gstvulkan.VulkanPhysicalDevice, p_info: *gstvideo.VideoInfo, p_tiling: vulkan.ImageTiling, p_no_multiplane: c_int, p_requested_usage: vulkan.ImageUsageFlags, p_fmts: *[4]vulkan.Format, p_n_imgs: *c_int, p_usage: *vulkan.ImageUsageFlags) c_int;
pub const vulkanFormatFromVideoInfo2 = gst_vulkan_format_from_video_info_2;

extern fn gst_vulkan_format_get_aspect(p_format: vulkan.Format) c_uint;
pub const vulkanFormatGetAspect = gst_vulkan_format_get_aspect;

extern fn gst_vulkan_format_get_info(p_format: vulkan.Format) ?*const gstvulkan.VulkanFormatInfo;
pub const vulkanFormatGetInfo = gst_vulkan_format_get_info;

extern fn gst_vulkan_format_to_video_format(p_vk_format: vulkan.Format) gstvideo.VideoFormat;
pub const vulkanFormatToVideoFormat = gst_vulkan_format_to_video_format;

extern fn gst_vulkan_get_or_create_image_view(p_image: *gstvulkan.VulkanImageMemory) *gstvulkan.VulkanImageView;
pub const vulkanGetOrCreateImageView = gst_vulkan_get_or_create_image_view;

/// Create a new `gstvulkan.VulkanImageView` with a specific `create_info`.
extern fn gst_vulkan_get_or_create_image_view_with_info(p_image: *gstvulkan.VulkanImageMemory, p_create_info: ?*vulkan.ImageViewCreateInfo) *gstvulkan.VulkanImageView;
pub const vulkanGetOrCreateImageViewWithInfo = gst_vulkan_get_or_create_image_view_with_info;

/// Performs the steps necessary for executing a context query including
/// posting a message for the application to respond.
extern fn gst_vulkan_global_context_query(p_element: *gst.Element, p_context_type: [*:0]const u8) void;
pub const vulkanGlobalContextQuery = gst_vulkan_global_context_query;

/// Performs the steps necessary for executing a context query between only
/// other elements in the pipeline
extern fn gst_vulkan_local_context_query(p_element: *gst.Element, p_context_type: [*:0]const u8) *gst.Query;
pub const vulkanLocalContextQuery = gst_vulkan_local_context_query;

extern fn gst_vulkan_present_mode_to_string(p_present_mode: vulkan.PresentModeKHR) [*:0]const u8;
pub const vulkanPresentModeToString = gst_vulkan_present_mode_to_string;

extern fn gst_vulkan_result_to_string(p_result: vulkan.Result) [*:0]const u8;
pub const vulkanResultToString = gst_vulkan_result_to_string;

extern fn gst_vulkan_run_query(p_element: *gst.Element, p_query: *gst.Query, p_direction: gst.PadDirection) c_int;
pub const vulkanRunQuery = gst_vulkan_run_query;

extern fn gst_vulkan_sample_count_flags_to_string(p_sample_count_bits: vulkan.SampleCountFlags) [*:0]u8;
pub const vulkanSampleCountFlagsToString = gst_vulkan_sample_count_flags_to_string;

pub const VulkanDeviceForEachQueueFunc = *const fn (p_device: *gstvulkan.VulkanDevice, p_queue: *gstvulkan.VulkanQueue, p_user_data: ?*anyopaque) callconv(.C) c_int;

/// Function definition called when the `gstvulkan.VulkanHandle` is no longer in use.
/// All implementations of this callback must free the internal handle stored
/// inside `handle`.
pub const VulkanHandleDestroyNotify = *const fn (p_handle: *gstvulkan.VulkanHandle, p_user_data: ?*anyopaque) callconv(.C) void;

/// Function definition used to find views.  Return `TRUE` if `view` matches the
/// criteria.
pub const VulkanImageMemoryFindViewFunc = *const fn (p_view: *gstvulkan.VulkanImageView, p_user_data: ?*anyopaque) callconv(.C) c_int;

/// Add `trash` to `trash_list` for tracking
pub const VulkanTrashListAdd = *const fn (p_trash_list: *gstvulkan.VulkanTrashList, p_trash: *gstvulkan.VulkanTrash) callconv(.C) c_int;

/// Remove any memory allocated by any signalled objects.
pub const VulkanTrashListGC = *const fn (p_trash_list: *gstvulkan.VulkanTrashList) callconv(.C) void;

/// Wait for a most `timeout` to pass for all `gstvulkan.VulkanTrash` objects to be
/// signalled and freed.
pub const VulkanTrashListWait = *const fn (p_trash_list: *gstvulkan.VulkanTrashList, p_timeout: u64) callconv(.C) c_int;

pub const VulkanTrashNotify = *const fn (p_device: *gstvulkan.VulkanDevice, p_user_data: ?*anyopaque) callconv(.C) void;

pub const CAPS_FEATURE_MEMORY_VULKAN_BUFFER = "memory:VulkanBuffer";
pub const CAPS_FEATURE_MEMORY_VULKAN_IMAGE = "memory:VulkanImage";
pub const VULKAN_BUFFER_MEMORY_ALLOCATOR_NAME = "VulkanBuffer";
pub const VULKAN_DEVICE_CONTEXT_TYPE_STR = "gst.vulkan.device";
pub const VULKAN_DISPLAY_CONTEXT_TYPE_STR = "gst.vulkan.display";
pub const VULKAN_IMAGE_MEMORY_ALLOCATOR_NAME = "VulkanImage";
pub const VULKAN_INSTANCE_CONTEXT_TYPE_STR = "gst.vulkan.instance";
pub const VULKAN_MAX_COMPONENTS = 4;
pub const VULKAN_MEMORY_ALLOCATOR_NAME = "Vulkan";
pub const VULKAN_QUEUE_CONTEXT_TYPE_STR = "gst.vulkan.queue";
pub const VULKAN_SWAPPER_VIDEO_FORMATS = " { RGBA, BGRA, RGB, BGR } ";
