/*
************************************************************************
*
*   FMInit.c - init FrameMaker device
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/01/25
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/fm/SCCS/s.FMInit.c
*   SCCS identification       : 1.7
*
************************************************************************
*/

#include "fm_init.h"

#include <sg_plot.h>
#include "fm_color.h"

static void
writeDefAttr(void)
{
  SgPlotOutputStr("<HeadCap Round>\n");
  SgPlotOutputStr("<TailCap Round>\n");
  SgPlotOutputStr("<Units Uin>\n");
  SgPlotOutputStr("<Font <FFamily Helvetica>>\n");
}

SgRes
SgFM3Init(int *argcP, char *argv[])
{
  SgPlotOutputStr("<MIFFile 3.00> # Generated by MOLMOL\n");
  writeDefAttr();

  return SG_RES_OK;
}

SgRes
SgFM4Init(int *argcP, char *argv[])
{
  SgPlotOutputStr("<MIFFile 4.00> # Generated by MOLMOL\n");
  FM4WriteColorCatalog();
  writeDefAttr();

  return SG_RES_OK;
}

SgRes
SgFMCleanup(void)
{
  return SG_RES_OK;
}
