/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * encoding_arg;	/**< @brief specify character set encoding.  */
  char * encoding_orig;	/**< @brief specify character set encoding original value given at command line.  */
  const char *encoding_help; /**< @brief specify character set encoding help description.  */
  int whole_words_flag;	/**< @brief whole words (OLD-TEXT matches on word boundaries only) (default=off).  */
  const char *whole_words_help; /**< @brief whole words (OLD-TEXT matches on word boundaries only) help description.  */
  int backup_flag;	/**< @brief rename original FILE to FILE~ before replacing (default=off).  */
  const char *backup_help; /**< @brief rename original FILE to FILE~ before replacing help description.  */
  int quiet_flag;	/**< @brief quiet mode (default=off).  */
  const char *quiet_help; /**< @brief quiet mode help description.  */
  int verbose_flag;	/**< @brief verbose mode (default=off).  */
  const char *verbose_help; /**< @brief verbose mode help description.  */
  int dry_run_flag;	/**< @brief simulation mode (default=off).  */
  const char *dry_run_help; /**< @brief simulation mode help description.  */
  int fixed_strings_flag;	/**< @brief treat OLD-TEXT and NEW-TEXT as fixed strings, not regular expressions (default=off).  */
  const char *fixed_strings_help; /**< @brief treat OLD-TEXT and NEW-TEXT as fixed strings, not regular expressions help description.  */
  int files_flag;	/**< @brief OLD-TEXT and NEW-TEXT are file names to read patterns from (default=off).  */
  const char *files_help; /**< @brief OLD-TEXT and NEW-TEXT are file names to read patterns from help description.  */
  char ** glob_arg;	/**< @brief modify only files matching the given glob (may be given more than once) (default='*').  */
  char ** glob_orig;	/**< @brief modify only files matching the given glob (may be given more than once) original value given at command line.  */
  unsigned int glob_min; /**< @brief modify only files matching the given glob (may be given more than once)'s minimum occurreces */
  unsigned int glob_max; /**< @brief modify only files matching the given glob (may be given more than once)'s maximum occurreces */
  const char *glob_help; /**< @brief modify only files matching the given glob (may be given more than once) help description.  */
  int recursive_flag;	/**< @brief search recursively (default=off).  */
  const char *recursive_help; /**< @brief search recursively help description.  */
  int prompt_flag;	/**< @brief prompt before modifying each file (default=off).  */
  const char *prompt_help; /**< @brief prompt before modifying each file help description.  */
  int force_flag;	/**< @brief ignore errors when trying to preserve attributes (default=off).  */
  const char *force_help; /**< @brief ignore errors when trying to preserve attributes help description.  */
  int keep_times_flag;	/**< @brief keep the modification times on modified files (default=off).  */
  const char *keep_times_help; /**< @brief keep the modification times on modified files help description.  */
  int extended_regex_flag;	/**< @brief use extended regex syntax [IGNORED] (default=off).  */
  const char *extended_regex_help; /**< @brief use extended regex syntax [IGNORED] help description.  */
  const char *ignore_case_help; /**< @brief search case-insensitively help description.  */
  const char *match_case_help; /**< @brief ignore case when searching, but try to match case of replacement to case of original, either capitalized, all upper-case, or mixed help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int encoding_given ;	/**< @brief Whether encoding was given.  */
  unsigned int whole_words_given ;	/**< @brief Whether whole-words was given.  */
  unsigned int backup_given ;	/**< @brief Whether backup was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int dry_run_given ;	/**< @brief Whether dry-run was given.  */
  unsigned int fixed_strings_given ;	/**< @brief Whether fixed-strings was given.  */
  unsigned int files_given ;	/**< @brief Whether files was given.  */
  unsigned int glob_given ;	/**< @brief Whether glob was given.  */
  unsigned int recursive_given ;	/**< @brief Whether recursive was given.  */
  unsigned int prompt_given ;	/**< @brief Whether prompt was given.  */
  unsigned int force_given ;	/**< @brief Whether force was given.  */
  unsigned int keep_times_given ;	/**< @brief Whether keep-times was given.  */
  unsigned int extended_regex_given ;	/**< @brief Whether extended-regex was given.  */
  unsigned int ignore_case_given ;	/**< @brief Whether ignore-case was given.  */
  unsigned int match_case_given ;	/**< @brief Whether match-case was given.  */

  char **inputs ; /**< @brief unnamed options (options without names) */
  unsigned inputs_num ; /**< @brief unnamed options number */
  int case_group_counter; /**< @brief Counter for group case */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
