// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package trustedadvisor

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchUpdateRecommendationResourceExclusion = "BatchUpdateRecommendationResourceExclusion"

// BatchUpdateRecommendationResourceExclusionRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateRecommendationResourceExclusion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateRecommendationResourceExclusion for more information on using the BatchUpdateRecommendationResourceExclusion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateRecommendationResourceExclusionRequest method.
//	req, resp := client.BatchUpdateRecommendationResourceExclusionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/BatchUpdateRecommendationResourceExclusion
func (c *TrustedAdvisor) BatchUpdateRecommendationResourceExclusionRequest(input *BatchUpdateRecommendationResourceExclusionInput) (req *request.Request, output *BatchUpdateRecommendationResourceExclusionOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateRecommendationResourceExclusion,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/batch-update-recommendation-resource-exclusion",
	}

	if input == nil {
		input = &BatchUpdateRecommendationResourceExclusionInput{}
	}

	output = &BatchUpdateRecommendationResourceExclusionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateRecommendationResourceExclusion API operation for TrustedAdvisor Public API.
//
// # Update one or more exclusion status for a list of recommendation resources
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation BatchUpdateRecommendationResourceExclusion for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - ConflictException
//     Exception that the request was denied due to conflictions in state
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/BatchUpdateRecommendationResourceExclusion
func (c *TrustedAdvisor) BatchUpdateRecommendationResourceExclusion(input *BatchUpdateRecommendationResourceExclusionInput) (*BatchUpdateRecommendationResourceExclusionOutput, error) {
	req, out := c.BatchUpdateRecommendationResourceExclusionRequest(input)
	return out, req.Send()
}

// BatchUpdateRecommendationResourceExclusionWithContext is the same as BatchUpdateRecommendationResourceExclusion with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateRecommendationResourceExclusion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) BatchUpdateRecommendationResourceExclusionWithContext(ctx aws.Context, input *BatchUpdateRecommendationResourceExclusionInput, opts ...request.Option) (*BatchUpdateRecommendationResourceExclusionOutput, error) {
	req, out := c.BatchUpdateRecommendationResourceExclusionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOrganizationRecommendation = "GetOrganizationRecommendation"

// GetOrganizationRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetOrganizationRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrganizationRecommendation for more information on using the GetOrganizationRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOrganizationRecommendationRequest method.
//	req, resp := client.GetOrganizationRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetOrganizationRecommendation
func (c *TrustedAdvisor) GetOrganizationRecommendationRequest(input *GetOrganizationRecommendationInput) (req *request.Request, output *GetOrganizationRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetOrganizationRecommendation,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/organization-recommendations/{organizationRecommendationIdentifier}",
	}

	if input == nil {
		input = &GetOrganizationRecommendationInput{}
	}

	output = &GetOrganizationRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrganizationRecommendation API operation for TrustedAdvisor Public API.
//
// Get a specific recommendation within an AWS Organizations organization. This
// API supports only prioritized recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation GetOrganizationRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ResourceNotFoundException
//     Exception that the requested resource has not been found
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetOrganizationRecommendation
func (c *TrustedAdvisor) GetOrganizationRecommendation(input *GetOrganizationRecommendationInput) (*GetOrganizationRecommendationOutput, error) {
	req, out := c.GetOrganizationRecommendationRequest(input)
	return out, req.Send()
}

// GetOrganizationRecommendationWithContext is the same as GetOrganizationRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrganizationRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) GetOrganizationRecommendationWithContext(ctx aws.Context, input *GetOrganizationRecommendationInput, opts ...request.Option) (*GetOrganizationRecommendationOutput, error) {
	req, out := c.GetOrganizationRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommendation = "GetRecommendation"

// GetRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommendation for more information on using the GetRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecommendationRequest method.
//	req, resp := client.GetRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetRecommendation
func (c *TrustedAdvisor) GetRecommendationRequest(input *GetRecommendationInput) (req *request.Request, output *GetRecommendationOutput) {
	op := &request.Operation{
		Name:       opGetRecommendation,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/recommendations/{recommendationIdentifier}",
	}

	if input == nil {
		input = &GetRecommendationInput{}
	}

	output = &GetRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommendation API operation for TrustedAdvisor Public API.
//
// # Get a specific Recommendation
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation GetRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ResourceNotFoundException
//     Exception that the requested resource has not been found
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetRecommendation
func (c *TrustedAdvisor) GetRecommendation(input *GetRecommendationInput) (*GetRecommendationOutput, error) {
	req, out := c.GetRecommendationRequest(input)
	return out, req.Send()
}

// GetRecommendationWithContext is the same as GetRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) GetRecommendationWithContext(ctx aws.Context, input *GetRecommendationInput, opts ...request.Option) (*GetRecommendationOutput, error) {
	req, out := c.GetRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChecks = "ListChecks"

// ListChecksRequest generates a "aws/request.Request" representing the
// client's request for the ListChecks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChecks for more information on using the ListChecks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChecksRequest method.
//	req, resp := client.ListChecksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks
func (c *TrustedAdvisor) ListChecksRequest(input *ListChecksInput) (req *request.Request, output *ListChecksOutput) {
	op := &request.Operation{
		Name:       opListChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/checks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChecksInput{}
	}

	output = &ListChecksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChecks API operation for TrustedAdvisor Public API.
//
// # List a filterable set of Checks
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation ListChecks for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks
func (c *TrustedAdvisor) ListChecks(input *ListChecksInput) (*ListChecksOutput, error) {
	req, out := c.ListChecksRequest(input)
	return out, req.Send()
}

// ListChecksWithContext is the same as ListChecks with the addition of
// the ability to pass a context and additional request options.
//
// See ListChecks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListChecksWithContext(ctx aws.Context, input *ListChecksInput, opts ...request.Option) (*ListChecksOutput, error) {
	req, out := c.ListChecksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChecksPages iterates over the pages of a ListChecks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChecks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChecks operation.
//	pageNum := 0
//	err := client.ListChecksPages(params,
//	    func(page *trustedadvisor.ListChecksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TrustedAdvisor) ListChecksPages(input *ListChecksInput, fn func(*ListChecksOutput, bool) bool) error {
	return c.ListChecksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChecksPagesWithContext same as ListChecksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListChecksPagesWithContext(ctx aws.Context, input *ListChecksInput, fn func(*ListChecksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChecksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChecksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChecksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationRecommendationAccounts = "ListOrganizationRecommendationAccounts"

// ListOrganizationRecommendationAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationRecommendationAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationRecommendationAccounts for more information on using the ListOrganizationRecommendationAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOrganizationRecommendationAccountsRequest method.
//	req, resp := client.ListOrganizationRecommendationAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts
func (c *TrustedAdvisor) ListOrganizationRecommendationAccountsRequest(input *ListOrganizationRecommendationAccountsInput) (req *request.Request, output *ListOrganizationRecommendationAccountsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationRecommendationAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/organization-recommendations/{organizationRecommendationIdentifier}/accounts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationRecommendationAccountsInput{}
	}

	output = &ListOrganizationRecommendationAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationRecommendationAccounts API operation for TrustedAdvisor Public API.
//
// Lists the accounts that own the resources for an organization aggregate recommendation.
// This API only supports prioritized recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation ListOrganizationRecommendationAccounts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ResourceNotFoundException
//     Exception that the requested resource has not been found
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts
func (c *TrustedAdvisor) ListOrganizationRecommendationAccounts(input *ListOrganizationRecommendationAccountsInput) (*ListOrganizationRecommendationAccountsOutput, error) {
	req, out := c.ListOrganizationRecommendationAccountsRequest(input)
	return out, req.Send()
}

// ListOrganizationRecommendationAccountsWithContext is the same as ListOrganizationRecommendationAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationRecommendationAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListOrganizationRecommendationAccountsWithContext(ctx aws.Context, input *ListOrganizationRecommendationAccountsInput, opts ...request.Option) (*ListOrganizationRecommendationAccountsOutput, error) {
	req, out := c.ListOrganizationRecommendationAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationRecommendationAccountsPages iterates over the pages of a ListOrganizationRecommendationAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationRecommendationAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOrganizationRecommendationAccounts operation.
//	pageNum := 0
//	err := client.ListOrganizationRecommendationAccountsPages(params,
//	    func(page *trustedadvisor.ListOrganizationRecommendationAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TrustedAdvisor) ListOrganizationRecommendationAccountsPages(input *ListOrganizationRecommendationAccountsInput, fn func(*ListOrganizationRecommendationAccountsOutput, bool) bool) error {
	return c.ListOrganizationRecommendationAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationRecommendationAccountsPagesWithContext same as ListOrganizationRecommendationAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListOrganizationRecommendationAccountsPagesWithContext(ctx aws.Context, input *ListOrganizationRecommendationAccountsInput, fn func(*ListOrganizationRecommendationAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationRecommendationAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationRecommendationAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationRecommendationAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationRecommendationResources = "ListOrganizationRecommendationResources"

// ListOrganizationRecommendationResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationRecommendationResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationRecommendationResources for more information on using the ListOrganizationRecommendationResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOrganizationRecommendationResourcesRequest method.
//	req, resp := client.ListOrganizationRecommendationResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources
func (c *TrustedAdvisor) ListOrganizationRecommendationResourcesRequest(input *ListOrganizationRecommendationResourcesInput) (req *request.Request, output *ListOrganizationRecommendationResourcesOutput) {
	op := &request.Operation{
		Name:       opListOrganizationRecommendationResources,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/organization-recommendations/{organizationRecommendationIdentifier}/resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationRecommendationResourcesInput{}
	}

	output = &ListOrganizationRecommendationResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationRecommendationResources API operation for TrustedAdvisor Public API.
//
// List Resources of a Recommendation within an Organization. This API only
// supports prioritized recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation ListOrganizationRecommendationResources for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ResourceNotFoundException
//     Exception that the requested resource has not been found
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources
func (c *TrustedAdvisor) ListOrganizationRecommendationResources(input *ListOrganizationRecommendationResourcesInput) (*ListOrganizationRecommendationResourcesOutput, error) {
	req, out := c.ListOrganizationRecommendationResourcesRequest(input)
	return out, req.Send()
}

// ListOrganizationRecommendationResourcesWithContext is the same as ListOrganizationRecommendationResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationRecommendationResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListOrganizationRecommendationResourcesWithContext(ctx aws.Context, input *ListOrganizationRecommendationResourcesInput, opts ...request.Option) (*ListOrganizationRecommendationResourcesOutput, error) {
	req, out := c.ListOrganizationRecommendationResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationRecommendationResourcesPages iterates over the pages of a ListOrganizationRecommendationResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationRecommendationResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOrganizationRecommendationResources operation.
//	pageNum := 0
//	err := client.ListOrganizationRecommendationResourcesPages(params,
//	    func(page *trustedadvisor.ListOrganizationRecommendationResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TrustedAdvisor) ListOrganizationRecommendationResourcesPages(input *ListOrganizationRecommendationResourcesInput, fn func(*ListOrganizationRecommendationResourcesOutput, bool) bool) error {
	return c.ListOrganizationRecommendationResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationRecommendationResourcesPagesWithContext same as ListOrganizationRecommendationResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListOrganizationRecommendationResourcesPagesWithContext(ctx aws.Context, input *ListOrganizationRecommendationResourcesInput, fn func(*ListOrganizationRecommendationResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationRecommendationResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationRecommendationResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationRecommendationResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationRecommendations = "ListOrganizationRecommendations"

// ListOrganizationRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationRecommendations for more information on using the ListOrganizationRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOrganizationRecommendationsRequest method.
//	req, resp := client.ListOrganizationRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations
func (c *TrustedAdvisor) ListOrganizationRecommendationsRequest(input *ListOrganizationRecommendationsInput) (req *request.Request, output *ListOrganizationRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationRecommendations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/organization-recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationRecommendationsInput{}
	}

	output = &ListOrganizationRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationRecommendations API operation for TrustedAdvisor Public API.
//
// List a filterable set of Recommendations within an Organization. This API
// only supports prioritized recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation ListOrganizationRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations
func (c *TrustedAdvisor) ListOrganizationRecommendations(input *ListOrganizationRecommendationsInput) (*ListOrganizationRecommendationsOutput, error) {
	req, out := c.ListOrganizationRecommendationsRequest(input)
	return out, req.Send()
}

// ListOrganizationRecommendationsWithContext is the same as ListOrganizationRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListOrganizationRecommendationsWithContext(ctx aws.Context, input *ListOrganizationRecommendationsInput, opts ...request.Option) (*ListOrganizationRecommendationsOutput, error) {
	req, out := c.ListOrganizationRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationRecommendationsPages iterates over the pages of a ListOrganizationRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOrganizationRecommendations operation.
//	pageNum := 0
//	err := client.ListOrganizationRecommendationsPages(params,
//	    func(page *trustedadvisor.ListOrganizationRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TrustedAdvisor) ListOrganizationRecommendationsPages(input *ListOrganizationRecommendationsInput, fn func(*ListOrganizationRecommendationsOutput, bool) bool) error {
	return c.ListOrganizationRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationRecommendationsPagesWithContext same as ListOrganizationRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListOrganizationRecommendationsPagesWithContext(ctx aws.Context, input *ListOrganizationRecommendationsInput, fn func(*ListOrganizationRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendationResources = "ListRecommendationResources"

// ListRecommendationResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendationResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendationResources for more information on using the ListRecommendationResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendationResourcesRequest method.
//	req, resp := client.ListRecommendationResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources
func (c *TrustedAdvisor) ListRecommendationResourcesRequest(input *ListRecommendationResourcesInput) (req *request.Request, output *ListRecommendationResourcesOutput) {
	op := &request.Operation{
		Name:       opListRecommendationResources,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/recommendations/{recommendationIdentifier}/resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationResourcesInput{}
	}

	output = &ListRecommendationResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendationResources API operation for TrustedAdvisor Public API.
//
// # List Resources of a Recommendation
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation ListRecommendationResources for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ResourceNotFoundException
//     Exception that the requested resource has not been found
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources
func (c *TrustedAdvisor) ListRecommendationResources(input *ListRecommendationResourcesInput) (*ListRecommendationResourcesOutput, error) {
	req, out := c.ListRecommendationResourcesRequest(input)
	return out, req.Send()
}

// ListRecommendationResourcesWithContext is the same as ListRecommendationResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendationResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListRecommendationResourcesWithContext(ctx aws.Context, input *ListRecommendationResourcesInput, opts ...request.Option) (*ListRecommendationResourcesOutput, error) {
	req, out := c.ListRecommendationResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationResourcesPages iterates over the pages of a ListRecommendationResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendationResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendationResources operation.
//	pageNum := 0
//	err := client.ListRecommendationResourcesPages(params,
//	    func(page *trustedadvisor.ListRecommendationResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TrustedAdvisor) ListRecommendationResourcesPages(input *ListRecommendationResourcesInput, fn func(*ListRecommendationResourcesOutput, bool) bool) error {
	return c.ListRecommendationResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationResourcesPagesWithContext same as ListRecommendationResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListRecommendationResourcesPagesWithContext(ctx aws.Context, input *ListRecommendationResourcesInput, fn func(*ListRecommendationResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendations = "ListRecommendations"

// ListRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendations for more information on using the ListRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendationsRequest method.
//	req, resp := client.ListRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations
func (c *TrustedAdvisor) ListRecommendationsRequest(input *ListRecommendationsInput) (req *request.Request, output *ListRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListRecommendations,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationsInput{}
	}

	output = &ListRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendations API operation for TrustedAdvisor Public API.
//
// # List a filterable set of Recommendations
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation ListRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations
func (c *TrustedAdvisor) ListRecommendations(input *ListRecommendationsInput) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	return out, req.Send()
}

// ListRecommendationsWithContext is the same as ListRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListRecommendationsWithContext(ctx aws.Context, input *ListRecommendationsInput, opts ...request.Option) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationsPages iterates over the pages of a ListRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendations operation.
//	pageNum := 0
//	err := client.ListRecommendationsPages(params,
//	    func(page *trustedadvisor.ListRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TrustedAdvisor) ListRecommendationsPages(input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool) error {
	return c.ListRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationsPagesWithContext same as ListRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) ListRecommendationsPagesWithContext(ctx aws.Context, input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateOrganizationRecommendationLifecycle = "UpdateOrganizationRecommendationLifecycle"

// UpdateOrganizationRecommendationLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationRecommendationLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationRecommendationLifecycle for more information on using the UpdateOrganizationRecommendationLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOrganizationRecommendationLifecycleRequest method.
//	req, resp := client.UpdateOrganizationRecommendationLifecycleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateOrganizationRecommendationLifecycle
func (c *TrustedAdvisor) UpdateOrganizationRecommendationLifecycleRequest(input *UpdateOrganizationRecommendationLifecycleInput) (req *request.Request, output *UpdateOrganizationRecommendationLifecycleOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationRecommendationLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/organization-recommendations/{organizationRecommendationIdentifier}/lifecycle",
	}

	if input == nil {
		input = &UpdateOrganizationRecommendationLifecycleInput{}
	}

	output = &UpdateOrganizationRecommendationLifecycleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrganizationRecommendationLifecycle API operation for TrustedAdvisor Public API.
//
// Update the lifecycle of a Recommendation within an Organization. This API
// only supports prioritized recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation UpdateOrganizationRecommendationLifecycle for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - ConflictException
//     Exception that the request was denied due to conflictions in state
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ResourceNotFoundException
//     Exception that the requested resource has not been found
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateOrganizationRecommendationLifecycle
func (c *TrustedAdvisor) UpdateOrganizationRecommendationLifecycle(input *UpdateOrganizationRecommendationLifecycleInput) (*UpdateOrganizationRecommendationLifecycleOutput, error) {
	req, out := c.UpdateOrganizationRecommendationLifecycleRequest(input)
	return out, req.Send()
}

// UpdateOrganizationRecommendationLifecycleWithContext is the same as UpdateOrganizationRecommendationLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationRecommendationLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) UpdateOrganizationRecommendationLifecycleWithContext(ctx aws.Context, input *UpdateOrganizationRecommendationLifecycleInput, opts ...request.Option) (*UpdateOrganizationRecommendationLifecycleOutput, error) {
	req, out := c.UpdateOrganizationRecommendationLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecommendationLifecycle = "UpdateRecommendationLifecycle"

// UpdateRecommendationLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecommendationLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecommendationLifecycle for more information on using the UpdateRecommendationLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRecommendationLifecycleRequest method.
//	req, resp := client.UpdateRecommendationLifecycleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateRecommendationLifecycle
func (c *TrustedAdvisor) UpdateRecommendationLifecycleRequest(input *UpdateRecommendationLifecycleInput) (req *request.Request, output *UpdateRecommendationLifecycleOutput) {
	op := &request.Operation{
		Name:       opUpdateRecommendationLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/recommendations/{recommendationIdentifier}/lifecycle",
	}

	if input == nil {
		input = &UpdateRecommendationLifecycleInput{}
	}

	output = &UpdateRecommendationLifecycleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRecommendationLifecycle API operation for TrustedAdvisor Public API.
//
// Update the lifecyle of a Recommendation. This API only supports prioritized
// recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for TrustedAdvisor Public API's
// API operation UpdateRecommendationLifecycle for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Exception that access has been denied due to insufficient access
//
//   - ConflictException
//     Exception that the request was denied due to conflictions in state
//
//   - InternalServerException
//     Exception to notify that an unexpected internal error occurred during processing
//     of the request
//
//   - ValidationException
//     Exception that the request failed to satisfy service constraints
//
//   - ResourceNotFoundException
//     Exception that the requested resource has not been found
//
//   - ThrottlingException
//     Exception to notify that requests are being throttled
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateRecommendationLifecycle
func (c *TrustedAdvisor) UpdateRecommendationLifecycle(input *UpdateRecommendationLifecycleInput) (*UpdateRecommendationLifecycleOutput, error) {
	req, out := c.UpdateRecommendationLifecycleRequest(input)
	return out, req.Send()
}

// UpdateRecommendationLifecycleWithContext is the same as UpdateRecommendationLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecommendationLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TrustedAdvisor) UpdateRecommendationLifecycleWithContext(ctx aws.Context, input *UpdateRecommendationLifecycleInput, opts ...request.Option) (*UpdateRecommendationLifecycleOutput, error) {
	req, out := c.UpdateRecommendationLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Exception that access has been denied due to insufficient access
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary of an AccountRecommendationLifecycle for an Organization Recommendation
type AccountRecommendationLifecycleSummary struct {
	_ struct{} `type:"structure"`

	// The AWS account ID
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The Recommendation ARN
	AccountRecommendationArn *string `locationName:"accountRecommendationArn" min:"20" type:"string"`

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage *string `locationName:"lifecycleStage" type:"string" enum:"RecommendationLifecycleStage"`

	// Reason for the lifecycle stage change
	//
	// UpdateReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AccountRecommendationLifecycleSummary's
	// String and GoString methods.
	UpdateReason *string `locationName:"updateReason" min:"10" type:"string" sensitive:"true"`

	// Reason code for the lifecycle state change
	UpdateReasonCode *string `locationName:"updateReasonCode" type:"string" enum:"UpdateRecommendationLifecycleStageReasonCode"`

	// The person on whose behalf a Technical Account Manager (TAM) updated the
	// recommendation. This information is only available when a Technical Account
	// Manager takes an action on a recommendation managed by AWS Trusted Advisor
	// Priority
	UpdatedOnBehalfOf *string `locationName:"updatedOnBehalfOf" type:"string"`

	// The job title of the person on whose behalf a Technical Account Manager (TAM)
	// updated the recommendation. This information is only available when a Technical
	// Account Manager takes an action on a recommendation managed by AWS Trusted
	// Advisor Priority
	UpdatedOnBehalfOfJobTitle *string `locationName:"updatedOnBehalfOfJobTitle" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountRecommendationLifecycleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountRecommendationLifecycleSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountRecommendationLifecycleSummary) SetAccountId(v string) *AccountRecommendationLifecycleSummary {
	s.AccountId = &v
	return s
}

// SetAccountRecommendationArn sets the AccountRecommendationArn field's value.
func (s *AccountRecommendationLifecycleSummary) SetAccountRecommendationArn(v string) *AccountRecommendationLifecycleSummary {
	s.AccountRecommendationArn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *AccountRecommendationLifecycleSummary) SetLastUpdatedAt(v time.Time) *AccountRecommendationLifecycleSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetLifecycleStage sets the LifecycleStage field's value.
func (s *AccountRecommendationLifecycleSummary) SetLifecycleStage(v string) *AccountRecommendationLifecycleSummary {
	s.LifecycleStage = &v
	return s
}

// SetUpdateReason sets the UpdateReason field's value.
func (s *AccountRecommendationLifecycleSummary) SetUpdateReason(v string) *AccountRecommendationLifecycleSummary {
	s.UpdateReason = &v
	return s
}

// SetUpdateReasonCode sets the UpdateReasonCode field's value.
func (s *AccountRecommendationLifecycleSummary) SetUpdateReasonCode(v string) *AccountRecommendationLifecycleSummary {
	s.UpdateReasonCode = &v
	return s
}

// SetUpdatedOnBehalfOf sets the UpdatedOnBehalfOf field's value.
func (s *AccountRecommendationLifecycleSummary) SetUpdatedOnBehalfOf(v string) *AccountRecommendationLifecycleSummary {
	s.UpdatedOnBehalfOf = &v
	return s
}

// SetUpdatedOnBehalfOfJobTitle sets the UpdatedOnBehalfOfJobTitle field's value.
func (s *AccountRecommendationLifecycleSummary) SetUpdatedOnBehalfOfJobTitle(v string) *AccountRecommendationLifecycleSummary {
	s.UpdatedOnBehalfOfJobTitle = &v
	return s
}

type BatchUpdateRecommendationResourceExclusionInput struct {
	_ struct{} `type:"structure"`

	// A list of recommendation resource ARNs and exclusion status to update
	//
	// RecommendationResourceExclusions is a required field
	RecommendationResourceExclusions []*RecommendationResourceExclusion `locationName:"recommendationResourceExclusions" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationResourceExclusionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationResourceExclusionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateRecommendationResourceExclusionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateRecommendationResourceExclusionInput"}
	if s.RecommendationResourceExclusions == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationResourceExclusions"))
	}
	if s.RecommendationResourceExclusions != nil && len(s.RecommendationResourceExclusions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationResourceExclusions", 1))
	}
	if s.RecommendationResourceExclusions != nil {
		for i, v := range s.RecommendationResourceExclusions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecommendationResourceExclusions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommendationResourceExclusions sets the RecommendationResourceExclusions field's value.
func (s *BatchUpdateRecommendationResourceExclusionInput) SetRecommendationResourceExclusions(v []*RecommendationResourceExclusion) *BatchUpdateRecommendationResourceExclusionInput {
	s.RecommendationResourceExclusions = v
	return s
}

type BatchUpdateRecommendationResourceExclusionOutput struct {
	_ struct{} `type:"structure"`

	// A list of recommendation resource ARNs whose exclusion status failed to update,
	// if any
	//
	// BatchUpdateRecommendationResourceExclusionErrors is a required field
	BatchUpdateRecommendationResourceExclusionErrors []*UpdateRecommendationResourceExclusionError `locationName:"batchUpdateRecommendationResourceExclusionErrors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationResourceExclusionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateRecommendationResourceExclusionOutput) GoString() string {
	return s.String()
}

// SetBatchUpdateRecommendationResourceExclusionErrors sets the BatchUpdateRecommendationResourceExclusionErrors field's value.
func (s *BatchUpdateRecommendationResourceExclusionOutput) SetBatchUpdateRecommendationResourceExclusionErrors(v []*UpdateRecommendationResourceExclusionError) *BatchUpdateRecommendationResourceExclusionOutput {
	s.BatchUpdateRecommendationResourceExclusionErrors = v
	return s
}

// A summary of an AWS Trusted Advisor Check
type CheckSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Trusted Advisor Check
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The AWS Services that the Check applies to
	//
	// AwsServices is a required field
	AwsServices []*string `locationName:"awsServices" type:"list" required:"true"`

	// A description of what the AWS Trusted Advisor Check is monitoring
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The unique identifier of the AWS Trusted Advisor Check
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The column headings for the metadata returned in the resource
	//
	// Metadata is a required field
	Metadata map[string]*string `locationName:"metadata" type:"map" required:"true"`

	// The name of the AWS Trusted Advisor Check
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Recommendation pillars that the AWS Trusted Advisor Check falls under
	//
	// Pillars is a required field
	Pillars []*string `locationName:"pillars" type:"list" required:"true" enum:"RecommendationPillar"`

	// The source of the Recommendation
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true" enum:"RecommendationSource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CheckSummary) SetArn(v string) *CheckSummary {
	s.Arn = &v
	return s
}

// SetAwsServices sets the AwsServices field's value.
func (s *CheckSummary) SetAwsServices(v []*string) *CheckSummary {
	s.AwsServices = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CheckSummary) SetDescription(v string) *CheckSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CheckSummary) SetId(v string) *CheckSummary {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CheckSummary) SetMetadata(v map[string]*string) *CheckSummary {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *CheckSummary) SetName(v string) *CheckSummary {
	s.Name = &v
	return s
}

// SetPillars sets the Pillars field's value.
func (s *CheckSummary) SetPillars(v []*string) *CheckSummary {
	s.Pillars = v
	return s
}

// SetSource sets the Source field's value.
func (s *CheckSummary) SetSource(v string) *CheckSummary {
	s.Source = &v
	return s
}

// Exception that the request was denied due to conflictions in state
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetOrganizationRecommendationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Recommendation identifier
	//
	// OrganizationRecommendationIdentifier is a required field
	OrganizationRecommendationIdentifier *string `location:"uri" locationName:"organizationRecommendationIdentifier" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOrganizationRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOrganizationRecommendationInput"}
	if s.OrganizationRecommendationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationRecommendationIdentifier"))
	}
	if s.OrganizationRecommendationIdentifier != nil && len(*s.OrganizationRecommendationIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationRecommendationIdentifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationRecommendationIdentifier sets the OrganizationRecommendationIdentifier field's value.
func (s *GetOrganizationRecommendationInput) SetOrganizationRecommendationIdentifier(v string) *GetOrganizationRecommendationInput {
	s.OrganizationRecommendationIdentifier = &v
	return s
}

type GetOrganizationRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The Recommendation
	OrganizationRecommendation *OrganizationRecommendation `locationName:"organizationRecommendation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationRecommendationOutput) GoString() string {
	return s.String()
}

// SetOrganizationRecommendation sets the OrganizationRecommendation field's value.
func (s *GetOrganizationRecommendationOutput) SetOrganizationRecommendation(v *OrganizationRecommendation) *GetOrganizationRecommendationOutput {
	s.OrganizationRecommendation = v
	return s
}

type GetRecommendationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Recommendation identifier
	//
	// RecommendationIdentifier is a required field
	RecommendationIdentifier *string `location:"uri" locationName:"recommendationIdentifier" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecommendationInput"}
	if s.RecommendationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationIdentifier"))
	}
	if s.RecommendationIdentifier != nil && len(*s.RecommendationIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationIdentifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecommendationIdentifier sets the RecommendationIdentifier field's value.
func (s *GetRecommendationInput) SetRecommendationIdentifier(v string) *GetRecommendationInput {
	s.RecommendationIdentifier = &v
	return s
}

type GetRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The Recommendation
	Recommendation *Recommendation `locationName:"recommendation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationOutput) GoString() string {
	return s.String()
}

// SetRecommendation sets the Recommendation field's value.
func (s *GetRecommendationOutput) SetRecommendation(v *Recommendation) *GetRecommendationOutput {
	s.Recommendation = v
	return s
}

// Exception to notify that an unexpected internal error occurred during processing
// of the request
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChecksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The aws service associated with the check
	AwsService *string `location:"querystring" locationName:"awsService" min:"2" type:"string"`

	// The ISO 639-1 code for the language that you want your checks to appear in.
	Language *string `location:"querystring" locationName:"language" type:"string" enum:"RecommendationLanguage"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"4" type:"string"`

	// The pillar of the check
	Pillar *string `location:"querystring" locationName:"pillar" type:"string" enum:"RecommendationPillar"`

	// The source of the check
	Source *string `location:"querystring" locationName:"source" type:"string" enum:"RecommendationSource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChecksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChecksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChecksInput"}
	if s.AwsService != nil && len(*s.AwsService) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("AwsService", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsService sets the AwsService field's value.
func (s *ListChecksInput) SetAwsService(v string) *ListChecksInput {
	s.AwsService = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *ListChecksInput) SetLanguage(v string) *ListChecksInput {
	s.Language = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChecksInput) SetMaxResults(v int64) *ListChecksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChecksInput) SetNextToken(v string) *ListChecksInput {
	s.NextToken = &v
	return s
}

// SetPillar sets the Pillar field's value.
func (s *ListChecksInput) SetPillar(v string) *ListChecksInput {
	s.Pillar = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ListChecksInput) SetSource(v string) *ListChecksInput {
	s.Source = &v
	return s
}

type ListChecksOutput struct {
	_ struct{} `type:"structure"`

	// The list of Checks
	//
	// CheckSummaries is a required field
	CheckSummaries []*CheckSummary `locationName:"checkSummaries" type:"list" required:"true"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChecksOutput) GoString() string {
	return s.String()
}

// SetCheckSummaries sets the CheckSummaries field's value.
func (s *ListChecksOutput) SetCheckSummaries(v []*CheckSummary) *ListChecksOutput {
	s.CheckSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChecksOutput) SetNextToken(v string) *ListChecksOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationRecommendationAccountsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An account affected by this organization recommendation
	AffectedAccountId *string `location:"querystring" locationName:"affectedAccountId" min:"12" type:"string"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"4" type:"string"`

	// The Recommendation identifier
	//
	// OrganizationRecommendationIdentifier is a required field
	OrganizationRecommendationIdentifier *string `location:"uri" locationName:"organizationRecommendationIdentifier" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationRecommendationAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationRecommendationAccountsInput"}
	if s.AffectedAccountId != nil && len(*s.AffectedAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AffectedAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.OrganizationRecommendationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationRecommendationIdentifier"))
	}
	if s.OrganizationRecommendationIdentifier != nil && len(*s.OrganizationRecommendationIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationRecommendationIdentifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAffectedAccountId sets the AffectedAccountId field's value.
func (s *ListOrganizationRecommendationAccountsInput) SetAffectedAccountId(v string) *ListOrganizationRecommendationAccountsInput {
	s.AffectedAccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationRecommendationAccountsInput) SetMaxResults(v int64) *ListOrganizationRecommendationAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationRecommendationAccountsInput) SetNextToken(v string) *ListOrganizationRecommendationAccountsInput {
	s.NextToken = &v
	return s
}

// SetOrganizationRecommendationIdentifier sets the OrganizationRecommendationIdentifier field's value.
func (s *ListOrganizationRecommendationAccountsInput) SetOrganizationRecommendationIdentifier(v string) *ListOrganizationRecommendationAccountsInput {
	s.OrganizationRecommendationIdentifier = &v
	return s
}

type ListOrganizationRecommendationAccountsOutput struct {
	_ struct{} `type:"structure"`

	// The account recommendations lifecycles that are applicable to the Recommendation
	//
	// AccountRecommendationLifecycleSummaries is a required field
	AccountRecommendationLifecycleSummaries []*AccountRecommendationLifecycleSummary `locationName:"accountRecommendationLifecycleSummaries" type:"list" required:"true"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationAccountsOutput) GoString() string {
	return s.String()
}

// SetAccountRecommendationLifecycleSummaries sets the AccountRecommendationLifecycleSummaries field's value.
func (s *ListOrganizationRecommendationAccountsOutput) SetAccountRecommendationLifecycleSummaries(v []*AccountRecommendationLifecycleSummary) *ListOrganizationRecommendationAccountsOutput {
	s.AccountRecommendationLifecycleSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationRecommendationAccountsOutput) SetNextToken(v string) *ListOrganizationRecommendationAccountsOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationRecommendationResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An account affected by this organization recommendation
	AffectedAccountId *string `location:"querystring" locationName:"affectedAccountId" min:"12" type:"string"`

	// The exclusion status of the resource
	ExclusionStatus *string `location:"querystring" locationName:"exclusionStatus" type:"string" enum:"ExclusionStatus"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"4" type:"string"`

	// The AWS Organization organization's Recommendation identifier
	//
	// OrganizationRecommendationIdentifier is a required field
	OrganizationRecommendationIdentifier *string `location:"uri" locationName:"organizationRecommendationIdentifier" min:"20" type:"string" required:"true"`

	// The AWS Region code of the resource
	RegionCode *string `location:"querystring" locationName:"regionCode" type:"string"`

	// The status of the resource
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"ResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationRecommendationResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationRecommendationResourcesInput"}
	if s.AffectedAccountId != nil && len(*s.AffectedAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AffectedAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.OrganizationRecommendationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationRecommendationIdentifier"))
	}
	if s.OrganizationRecommendationIdentifier != nil && len(*s.OrganizationRecommendationIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationRecommendationIdentifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAffectedAccountId sets the AffectedAccountId field's value.
func (s *ListOrganizationRecommendationResourcesInput) SetAffectedAccountId(v string) *ListOrganizationRecommendationResourcesInput {
	s.AffectedAccountId = &v
	return s
}

// SetExclusionStatus sets the ExclusionStatus field's value.
func (s *ListOrganizationRecommendationResourcesInput) SetExclusionStatus(v string) *ListOrganizationRecommendationResourcesInput {
	s.ExclusionStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationRecommendationResourcesInput) SetMaxResults(v int64) *ListOrganizationRecommendationResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationRecommendationResourcesInput) SetNextToken(v string) *ListOrganizationRecommendationResourcesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationRecommendationIdentifier sets the OrganizationRecommendationIdentifier field's value.
func (s *ListOrganizationRecommendationResourcesInput) SetOrganizationRecommendationIdentifier(v string) *ListOrganizationRecommendationResourcesInput {
	s.OrganizationRecommendationIdentifier = &v
	return s
}

// SetRegionCode sets the RegionCode field's value.
func (s *ListOrganizationRecommendationResourcesInput) SetRegionCode(v string) *ListOrganizationRecommendationResourcesInput {
	s.RegionCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListOrganizationRecommendationResourcesInput) SetStatus(v string) *ListOrganizationRecommendationResourcesInput {
	s.Status = &v
	return s
}

type ListOrganizationRecommendationResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// A list of Recommendation Resources
	//
	// OrganizationRecommendationResourceSummaries is a required field
	OrganizationRecommendationResourceSummaries []*OrganizationRecommendationResourceSummary `locationName:"organizationRecommendationResourceSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationRecommendationResourcesOutput) SetNextToken(v string) *ListOrganizationRecommendationResourcesOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationRecommendationResourceSummaries sets the OrganizationRecommendationResourceSummaries field's value.
func (s *ListOrganizationRecommendationResourcesOutput) SetOrganizationRecommendationResourceSummaries(v []*OrganizationRecommendationResourceSummary) *ListOrganizationRecommendationResourcesOutput {
	s.OrganizationRecommendationResourceSummaries = v
	return s
}

type ListOrganizationRecommendationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// After the last update of the Recommendation
	AfterLastUpdatedAt *time.Time `location:"querystring" locationName:"afterLastUpdatedAt" type:"timestamp"`

	// The aws service associated with the Recommendation
	AwsService *string `location:"querystring" locationName:"awsService" min:"2" type:"string"`

	// Before the last update of the Recommendation
	BeforeLastUpdatedAt *time.Time `location:"querystring" locationName:"beforeLastUpdatedAt" type:"timestamp"`

	// The check identifier of the Recommendation
	CheckIdentifier *string `location:"querystring" locationName:"checkIdentifier" min:"20" type:"string"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"4" type:"string"`

	// The pillar of the Recommendation
	Pillar *string `location:"querystring" locationName:"pillar" type:"string" enum:"RecommendationPillar"`

	// The source of the Recommendation
	Source *string `location:"querystring" locationName:"source" type:"string" enum:"RecommendationSource"`

	// The status of the Recommendation
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"RecommendationStatus"`

	// The type of the Recommendation
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"RecommendationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationRecommendationsInput"}
	if s.AwsService != nil && len(*s.AwsService) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("AwsService", 2))
	}
	if s.CheckIdentifier != nil && len(*s.CheckIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CheckIdentifier", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterLastUpdatedAt sets the AfterLastUpdatedAt field's value.
func (s *ListOrganizationRecommendationsInput) SetAfterLastUpdatedAt(v time.Time) *ListOrganizationRecommendationsInput {
	s.AfterLastUpdatedAt = &v
	return s
}

// SetAwsService sets the AwsService field's value.
func (s *ListOrganizationRecommendationsInput) SetAwsService(v string) *ListOrganizationRecommendationsInput {
	s.AwsService = &v
	return s
}

// SetBeforeLastUpdatedAt sets the BeforeLastUpdatedAt field's value.
func (s *ListOrganizationRecommendationsInput) SetBeforeLastUpdatedAt(v time.Time) *ListOrganizationRecommendationsInput {
	s.BeforeLastUpdatedAt = &v
	return s
}

// SetCheckIdentifier sets the CheckIdentifier field's value.
func (s *ListOrganizationRecommendationsInput) SetCheckIdentifier(v string) *ListOrganizationRecommendationsInput {
	s.CheckIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationRecommendationsInput) SetMaxResults(v int64) *ListOrganizationRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationRecommendationsInput) SetNextToken(v string) *ListOrganizationRecommendationsInput {
	s.NextToken = &v
	return s
}

// SetPillar sets the Pillar field's value.
func (s *ListOrganizationRecommendationsInput) SetPillar(v string) *ListOrganizationRecommendationsInput {
	s.Pillar = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ListOrganizationRecommendationsInput) SetSource(v string) *ListOrganizationRecommendationsInput {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListOrganizationRecommendationsInput) SetStatus(v string) *ListOrganizationRecommendationsInput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListOrganizationRecommendationsInput) SetType(v string) *ListOrganizationRecommendationsInput {
	s.Type = &v
	return s
}

type ListOrganizationRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The list of Recommendations
	//
	// OrganizationRecommendationSummaries is a required field
	OrganizationRecommendationSummaries []*OrganizationRecommendationSummary `locationName:"organizationRecommendationSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOrganizationRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationRecommendationsOutput) SetNextToken(v string) *ListOrganizationRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationRecommendationSummaries sets the OrganizationRecommendationSummaries field's value.
func (s *ListOrganizationRecommendationsOutput) SetOrganizationRecommendationSummaries(v []*OrganizationRecommendationSummary) *ListOrganizationRecommendationsOutput {
	s.OrganizationRecommendationSummaries = v
	return s
}

type ListRecommendationResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The exclusion status of the resource
	ExclusionStatus *string `location:"querystring" locationName:"exclusionStatus" type:"string" enum:"ExclusionStatus"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"4" type:"string"`

	// The Recommendation identifier
	//
	// RecommendationIdentifier is a required field
	RecommendationIdentifier *string `location:"uri" locationName:"recommendationIdentifier" min:"20" type:"string" required:"true"`

	// The AWS Region code of the resource
	RegionCode *string `location:"querystring" locationName:"regionCode" type:"string"`

	// The status of the resource
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"ResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.RecommendationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationIdentifier"))
	}
	if s.RecommendationIdentifier != nil && len(*s.RecommendationIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationIdentifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusionStatus sets the ExclusionStatus field's value.
func (s *ListRecommendationResourcesInput) SetExclusionStatus(v string) *ListRecommendationResourcesInput {
	s.ExclusionStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendationResourcesInput) SetMaxResults(v int64) *ListRecommendationResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationResourcesInput) SetNextToken(v string) *ListRecommendationResourcesInput {
	s.NextToken = &v
	return s
}

// SetRecommendationIdentifier sets the RecommendationIdentifier field's value.
func (s *ListRecommendationResourcesInput) SetRecommendationIdentifier(v string) *ListRecommendationResourcesInput {
	s.RecommendationIdentifier = &v
	return s
}

// SetRegionCode sets the RegionCode field's value.
func (s *ListRecommendationResourcesInput) SetRegionCode(v string) *ListRecommendationResourcesInput {
	s.RegionCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRecommendationResourcesInput) SetStatus(v string) *ListRecommendationResourcesInput {
	s.Status = &v
	return s
}

type ListRecommendationResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// A list of Recommendation Resources
	//
	// RecommendationResourceSummaries is a required field
	RecommendationResourceSummaries []*RecommendationResourceSummary `locationName:"recommendationResourceSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationResourcesOutput) SetNextToken(v string) *ListRecommendationResourcesOutput {
	s.NextToken = &v
	return s
}

// SetRecommendationResourceSummaries sets the RecommendationResourceSummaries field's value.
func (s *ListRecommendationResourcesOutput) SetRecommendationResourceSummaries(v []*RecommendationResourceSummary) *ListRecommendationResourcesOutput {
	s.RecommendationResourceSummaries = v
	return s
}

type ListRecommendationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// After the last update of the Recommendation
	AfterLastUpdatedAt *time.Time `location:"querystring" locationName:"afterLastUpdatedAt" type:"timestamp"`

	// The aws service associated with the Recommendation
	AwsService *string `location:"querystring" locationName:"awsService" min:"2" type:"string"`

	// Before the last update of the Recommendation
	BeforeLastUpdatedAt *time.Time `location:"querystring" locationName:"beforeLastUpdatedAt" type:"timestamp"`

	// The check identifier of the Recommendation
	CheckIdentifier *string `location:"querystring" locationName:"checkIdentifier" min:"20" type:"string"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"4" type:"string"`

	// The pillar of the Recommendation
	Pillar *string `location:"querystring" locationName:"pillar" type:"string" enum:"RecommendationPillar"`

	// The source of the Recommendation
	Source *string `location:"querystring" locationName:"source" type:"string" enum:"RecommendationSource"`

	// The status of the Recommendation
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"RecommendationStatus"`

	// The type of the Recommendation
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"RecommendationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationsInput"}
	if s.AwsService != nil && len(*s.AwsService) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("AwsService", 2))
	}
	if s.CheckIdentifier != nil && len(*s.CheckIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CheckIdentifier", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterLastUpdatedAt sets the AfterLastUpdatedAt field's value.
func (s *ListRecommendationsInput) SetAfterLastUpdatedAt(v time.Time) *ListRecommendationsInput {
	s.AfterLastUpdatedAt = &v
	return s
}

// SetAwsService sets the AwsService field's value.
func (s *ListRecommendationsInput) SetAwsService(v string) *ListRecommendationsInput {
	s.AwsService = &v
	return s
}

// SetBeforeLastUpdatedAt sets the BeforeLastUpdatedAt field's value.
func (s *ListRecommendationsInput) SetBeforeLastUpdatedAt(v time.Time) *ListRecommendationsInput {
	s.BeforeLastUpdatedAt = &v
	return s
}

// SetCheckIdentifier sets the CheckIdentifier field's value.
func (s *ListRecommendationsInput) SetCheckIdentifier(v string) *ListRecommendationsInput {
	s.CheckIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecommendationsInput) SetMaxResults(v int64) *ListRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsInput) SetNextToken(v string) *ListRecommendationsInput {
	s.NextToken = &v
	return s
}

// SetPillar sets the Pillar field's value.
func (s *ListRecommendationsInput) SetPillar(v string) *ListRecommendationsInput {
	s.Pillar = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ListRecommendationsInput) SetSource(v string) *ListRecommendationsInput {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListRecommendationsInput) SetStatus(v string) *ListRecommendationsInput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListRecommendationsInput) SetType(v string) *ListRecommendationsInput {
	s.Type = &v
	return s
}

type ListRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The list of Recommendations
	//
	// RecommendationSummaries is a required field
	RecommendationSummaries []*RecommendationSummary `locationName:"recommendationSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsOutput) SetNextToken(v string) *ListRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendationSummaries sets the RecommendationSummaries field's value.
func (s *ListRecommendationsOutput) SetRecommendationSummaries(v []*RecommendationSummary) *ListRecommendationsOutput {
	s.RecommendationSummaries = v
	return s
}

// A Recommendation for accounts within an Organization
type OrganizationRecommendation struct {
	_ struct{} `type:"structure"`

	// The ARN of the Recommendation
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The AWS Services that the Recommendation applies to
	AwsServices []*string `locationName:"awsServices" type:"list"`

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string `locationName:"checkArn" type:"string"`

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The creator, if created by AWS Trusted Advisor Priority
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// A description for AWS Trusted Advisor recommendations
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The ID which identifies where the Recommendation was produced
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage *string `locationName:"lifecycleStage" type:"string" enum:"RecommendationLifecycleStage"`

	// The name of the AWS Trusted Advisor Recommendation
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates `locationName:"pillarSpecificAggregates" type:"structure"`

	// The Pillars that the Recommendation is optimizing
	//
	// Pillars is a required field
	Pillars []*string `locationName:"pillars" type:"list" required:"true" enum:"RecommendationPillar"`

	// When the Recommendation was resolved
	ResolvedAt *time.Time `locationName:"resolvedAt" type:"timestamp" timestampFormat:"iso8601"`

	// An aggregation of all resources
	//
	// ResourcesAggregates is a required field
	ResourcesAggregates *RecommendationResourcesAggregates `locationName:"resourcesAggregates" type:"structure" required:"true"`

	// The source of the Recommendation
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true" enum:"RecommendationSource"`

	// The status of the Recommendation
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RecommendationStatus"`

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RecommendationType"`

	// Reason for the lifecycle stage change
	//
	// UpdateReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OrganizationRecommendation's
	// String and GoString methods.
	UpdateReason *string `locationName:"updateReason" min:"10" type:"string" sensitive:"true"`

	// Reason code for the lifecycle state change
	UpdateReasonCode *string `locationName:"updateReasonCode" type:"string" enum:"UpdateRecommendationLifecycleStageReasonCode"`

	// The person on whose behalf a Technical Account Manager (TAM) updated the
	// recommendation. This information is only available when a Technical Account
	// Manager takes an action on a recommendation managed by AWS Trusted Advisor
	// Priority
	UpdatedOnBehalfOf *string `locationName:"updatedOnBehalfOf" type:"string"`

	// The job title of the person on whose behalf a Technical Account Manager (TAM)
	// updated the recommendation. This information is only available when a Technical
	// Account Manager takes an action on a recommendation managed by AWS Trusted
	// Advisor Priority
	UpdatedOnBehalfOfJobTitle *string `locationName:"updatedOnBehalfOfJobTitle" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationRecommendation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OrganizationRecommendation) SetArn(v string) *OrganizationRecommendation {
	s.Arn = &v
	return s
}

// SetAwsServices sets the AwsServices field's value.
func (s *OrganizationRecommendation) SetAwsServices(v []*string) *OrganizationRecommendation {
	s.AwsServices = v
	return s
}

// SetCheckArn sets the CheckArn field's value.
func (s *OrganizationRecommendation) SetCheckArn(v string) *OrganizationRecommendation {
	s.CheckArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *OrganizationRecommendation) SetCreatedAt(v time.Time) *OrganizationRecommendation {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *OrganizationRecommendation) SetCreatedBy(v string) *OrganizationRecommendation {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *OrganizationRecommendation) SetDescription(v string) *OrganizationRecommendation {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *OrganizationRecommendation) SetId(v string) *OrganizationRecommendation {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *OrganizationRecommendation) SetLastUpdatedAt(v time.Time) *OrganizationRecommendation {
	s.LastUpdatedAt = &v
	return s
}

// SetLifecycleStage sets the LifecycleStage field's value.
func (s *OrganizationRecommendation) SetLifecycleStage(v string) *OrganizationRecommendation {
	s.LifecycleStage = &v
	return s
}

// SetName sets the Name field's value.
func (s *OrganizationRecommendation) SetName(v string) *OrganizationRecommendation {
	s.Name = &v
	return s
}

// SetPillarSpecificAggregates sets the PillarSpecificAggregates field's value.
func (s *OrganizationRecommendation) SetPillarSpecificAggregates(v *RecommendationPillarSpecificAggregates) *OrganizationRecommendation {
	s.PillarSpecificAggregates = v
	return s
}

// SetPillars sets the Pillars field's value.
func (s *OrganizationRecommendation) SetPillars(v []*string) *OrganizationRecommendation {
	s.Pillars = v
	return s
}

// SetResolvedAt sets the ResolvedAt field's value.
func (s *OrganizationRecommendation) SetResolvedAt(v time.Time) *OrganizationRecommendation {
	s.ResolvedAt = &v
	return s
}

// SetResourcesAggregates sets the ResourcesAggregates field's value.
func (s *OrganizationRecommendation) SetResourcesAggregates(v *RecommendationResourcesAggregates) *OrganizationRecommendation {
	s.ResourcesAggregates = v
	return s
}

// SetSource sets the Source field's value.
func (s *OrganizationRecommendation) SetSource(v string) *OrganizationRecommendation {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationRecommendation) SetStatus(v string) *OrganizationRecommendation {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *OrganizationRecommendation) SetType(v string) *OrganizationRecommendation {
	s.Type = &v
	return s
}

// SetUpdateReason sets the UpdateReason field's value.
func (s *OrganizationRecommendation) SetUpdateReason(v string) *OrganizationRecommendation {
	s.UpdateReason = &v
	return s
}

// SetUpdateReasonCode sets the UpdateReasonCode field's value.
func (s *OrganizationRecommendation) SetUpdateReasonCode(v string) *OrganizationRecommendation {
	s.UpdateReasonCode = &v
	return s
}

// SetUpdatedOnBehalfOf sets the UpdatedOnBehalfOf field's value.
func (s *OrganizationRecommendation) SetUpdatedOnBehalfOf(v string) *OrganizationRecommendation {
	s.UpdatedOnBehalfOf = &v
	return s
}

// SetUpdatedOnBehalfOfJobTitle sets the UpdatedOnBehalfOfJobTitle field's value.
func (s *OrganizationRecommendation) SetUpdatedOnBehalfOfJobTitle(v string) *OrganizationRecommendation {
	s.UpdatedOnBehalfOfJobTitle = &v
	return s
}

// Organization Recommendation Resource Summary
type OrganizationRecommendationResourceSummary struct {
	_ struct{} `type:"structure"`

	// The AWS account ID
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The ARN of the Recommendation Resource
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The AWS resource identifier
	//
	// AwsResourceId is a required field
	AwsResourceId *string `locationName:"awsResourceId" type:"string" required:"true"`

	// The exclusion status of the Recommendation Resource
	ExclusionStatus *string `locationName:"exclusionStatus" type:"string" enum:"ExclusionStatus"`

	// The ID of the Recommendation Resource
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When the Recommendation Resource was last updated
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Metadata associated with the Recommendation Resource
	//
	// Metadata is a required field
	Metadata map[string]*string `locationName:"metadata" type:"map" required:"true"`

	// The Recommendation ARN
	//
	// RecommendationArn is a required field
	RecommendationArn *string `locationName:"recommendationArn" min:"20" type:"string" required:"true"`

	// The AWS Region code that the Recommendation Resource is in
	//
	// RegionCode is a required field
	RegionCode *string `locationName:"regionCode" min:"9" type:"string" required:"true"`

	// The current status of the Recommendation Resource
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationRecommendationResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationRecommendationResourceSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *OrganizationRecommendationResourceSummary) SetAccountId(v string) *OrganizationRecommendationResourceSummary {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *OrganizationRecommendationResourceSummary) SetArn(v string) *OrganizationRecommendationResourceSummary {
	s.Arn = &v
	return s
}

// SetAwsResourceId sets the AwsResourceId field's value.
func (s *OrganizationRecommendationResourceSummary) SetAwsResourceId(v string) *OrganizationRecommendationResourceSummary {
	s.AwsResourceId = &v
	return s
}

// SetExclusionStatus sets the ExclusionStatus field's value.
func (s *OrganizationRecommendationResourceSummary) SetExclusionStatus(v string) *OrganizationRecommendationResourceSummary {
	s.ExclusionStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *OrganizationRecommendationResourceSummary) SetId(v string) *OrganizationRecommendationResourceSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *OrganizationRecommendationResourceSummary) SetLastUpdatedAt(v time.Time) *OrganizationRecommendationResourceSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *OrganizationRecommendationResourceSummary) SetMetadata(v map[string]*string) *OrganizationRecommendationResourceSummary {
	s.Metadata = v
	return s
}

// SetRecommendationArn sets the RecommendationArn field's value.
func (s *OrganizationRecommendationResourceSummary) SetRecommendationArn(v string) *OrganizationRecommendationResourceSummary {
	s.RecommendationArn = &v
	return s
}

// SetRegionCode sets the RegionCode field's value.
func (s *OrganizationRecommendationResourceSummary) SetRegionCode(v string) *OrganizationRecommendationResourceSummary {
	s.RegionCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationRecommendationResourceSummary) SetStatus(v string) *OrganizationRecommendationResourceSummary {
	s.Status = &v
	return s
}

// Summary of recommendation for accounts within an Organization
type OrganizationRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the Recommendation
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The AWS Services that the Recommendation applies to
	AwsServices []*string `locationName:"awsServices" type:"list"`

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string `locationName:"checkArn" type:"string"`

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID which identifies where the Recommendation was produced
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage *string `locationName:"lifecycleStage" type:"string" enum:"RecommendationLifecycleStage"`

	// The name of the AWS Trusted Advisor Recommendation
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates `locationName:"pillarSpecificAggregates" type:"structure"`

	// The Pillars that the Recommendation is optimizing
	//
	// Pillars is a required field
	Pillars []*string `locationName:"pillars" type:"list" required:"true" enum:"RecommendationPillar"`

	// An aggregation of all resources
	//
	// ResourcesAggregates is a required field
	ResourcesAggregates *RecommendationResourcesAggregates `locationName:"resourcesAggregates" type:"structure" required:"true"`

	// The source of the Recommendation
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true" enum:"RecommendationSource"`

	// The status of the Recommendation
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RecommendationStatus"`

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RecommendationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationRecommendationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OrganizationRecommendationSummary) SetArn(v string) *OrganizationRecommendationSummary {
	s.Arn = &v
	return s
}

// SetAwsServices sets the AwsServices field's value.
func (s *OrganizationRecommendationSummary) SetAwsServices(v []*string) *OrganizationRecommendationSummary {
	s.AwsServices = v
	return s
}

// SetCheckArn sets the CheckArn field's value.
func (s *OrganizationRecommendationSummary) SetCheckArn(v string) *OrganizationRecommendationSummary {
	s.CheckArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *OrganizationRecommendationSummary) SetCreatedAt(v time.Time) *OrganizationRecommendationSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *OrganizationRecommendationSummary) SetId(v string) *OrganizationRecommendationSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *OrganizationRecommendationSummary) SetLastUpdatedAt(v time.Time) *OrganizationRecommendationSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetLifecycleStage sets the LifecycleStage field's value.
func (s *OrganizationRecommendationSummary) SetLifecycleStage(v string) *OrganizationRecommendationSummary {
	s.LifecycleStage = &v
	return s
}

// SetName sets the Name field's value.
func (s *OrganizationRecommendationSummary) SetName(v string) *OrganizationRecommendationSummary {
	s.Name = &v
	return s
}

// SetPillarSpecificAggregates sets the PillarSpecificAggregates field's value.
func (s *OrganizationRecommendationSummary) SetPillarSpecificAggregates(v *RecommendationPillarSpecificAggregates) *OrganizationRecommendationSummary {
	s.PillarSpecificAggregates = v
	return s
}

// SetPillars sets the Pillars field's value.
func (s *OrganizationRecommendationSummary) SetPillars(v []*string) *OrganizationRecommendationSummary {
	s.Pillars = v
	return s
}

// SetResourcesAggregates sets the ResourcesAggregates field's value.
func (s *OrganizationRecommendationSummary) SetResourcesAggregates(v *RecommendationResourcesAggregates) *OrganizationRecommendationSummary {
	s.ResourcesAggregates = v
	return s
}

// SetSource sets the Source field's value.
func (s *OrganizationRecommendationSummary) SetSource(v string) *OrganizationRecommendationSummary {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationRecommendationSummary) SetStatus(v string) *OrganizationRecommendationSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *OrganizationRecommendationSummary) SetType(v string) *OrganizationRecommendationSummary {
	s.Type = &v
	return s
}

// A Recommendation for an Account
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The ARN of the Recommendation
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The AWS Services that the Recommendation applies to
	AwsServices []*string `locationName:"awsServices" type:"list"`

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string `locationName:"checkArn" type:"string"`

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The creator, if created by AWS Trusted Advisor Priority
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// A description for AWS Trusted Advisor recommendations
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The ID which identifies where the Recommendation was produced
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage *string `locationName:"lifecycleStage" type:"string" enum:"RecommendationLifecycleStage"`

	// The name of the AWS Trusted Advisor Recommendation
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates `locationName:"pillarSpecificAggregates" type:"structure"`

	// The Pillars that the Recommendation is optimizing
	//
	// Pillars is a required field
	Pillars []*string `locationName:"pillars" type:"list" required:"true" enum:"RecommendationPillar"`

	// When the Recommendation was resolved
	ResolvedAt *time.Time `locationName:"resolvedAt" type:"timestamp" timestampFormat:"iso8601"`

	// An aggregation of all resources
	//
	// ResourcesAggregates is a required field
	ResourcesAggregates *RecommendationResourcesAggregates `locationName:"resourcesAggregates" type:"structure" required:"true"`

	// The source of the Recommendation
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true" enum:"RecommendationSource"`

	// The status of the Recommendation
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RecommendationStatus"`

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RecommendationType"`

	// Reason for the lifecycle stage change
	//
	// UpdateReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Recommendation's
	// String and GoString methods.
	UpdateReason *string `locationName:"updateReason" min:"10" type:"string" sensitive:"true"`

	// Reason code for the lifecycle state change
	UpdateReasonCode *string `locationName:"updateReasonCode" type:"string" enum:"UpdateRecommendationLifecycleStageReasonCode"`

	// The person on whose behalf a Technical Account Manager (TAM) updated the
	// recommendation. This information is only available when a Technical Account
	// Manager takes an action on a recommendation managed by AWS Trusted Advisor
	// Priority
	UpdatedOnBehalfOf *string `locationName:"updatedOnBehalfOf" type:"string"`

	// The job title of the person on whose behalf a Technical Account Manager (TAM)
	// updated the recommendation. This information is only available when a Technical
	// Account Manager takes an action on a recommendation managed by AWS Trusted
	// Advisor Priority
	UpdatedOnBehalfOfJobTitle *string `locationName:"updatedOnBehalfOfJobTitle" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Recommendation) SetArn(v string) *Recommendation {
	s.Arn = &v
	return s
}

// SetAwsServices sets the AwsServices field's value.
func (s *Recommendation) SetAwsServices(v []*string) *Recommendation {
	s.AwsServices = v
	return s
}

// SetCheckArn sets the CheckArn field's value.
func (s *Recommendation) SetCheckArn(v string) *Recommendation {
	s.CheckArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Recommendation) SetCreatedAt(v time.Time) *Recommendation {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Recommendation) SetCreatedBy(v string) *Recommendation {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Recommendation) SetDescription(v string) *Recommendation {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Recommendation) SetId(v string) *Recommendation {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *Recommendation) SetLastUpdatedAt(v time.Time) *Recommendation {
	s.LastUpdatedAt = &v
	return s
}

// SetLifecycleStage sets the LifecycleStage field's value.
func (s *Recommendation) SetLifecycleStage(v string) *Recommendation {
	s.LifecycleStage = &v
	return s
}

// SetName sets the Name field's value.
func (s *Recommendation) SetName(v string) *Recommendation {
	s.Name = &v
	return s
}

// SetPillarSpecificAggregates sets the PillarSpecificAggregates field's value.
func (s *Recommendation) SetPillarSpecificAggregates(v *RecommendationPillarSpecificAggregates) *Recommendation {
	s.PillarSpecificAggregates = v
	return s
}

// SetPillars sets the Pillars field's value.
func (s *Recommendation) SetPillars(v []*string) *Recommendation {
	s.Pillars = v
	return s
}

// SetResolvedAt sets the ResolvedAt field's value.
func (s *Recommendation) SetResolvedAt(v time.Time) *Recommendation {
	s.ResolvedAt = &v
	return s
}

// SetResourcesAggregates sets the ResourcesAggregates field's value.
func (s *Recommendation) SetResourcesAggregates(v *RecommendationResourcesAggregates) *Recommendation {
	s.ResourcesAggregates = v
	return s
}

// SetSource sets the Source field's value.
func (s *Recommendation) SetSource(v string) *Recommendation {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Recommendation) SetStatus(v string) *Recommendation {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Recommendation) SetType(v string) *Recommendation {
	s.Type = &v
	return s
}

// SetUpdateReason sets the UpdateReason field's value.
func (s *Recommendation) SetUpdateReason(v string) *Recommendation {
	s.UpdateReason = &v
	return s
}

// SetUpdateReasonCode sets the UpdateReasonCode field's value.
func (s *Recommendation) SetUpdateReasonCode(v string) *Recommendation {
	s.UpdateReasonCode = &v
	return s
}

// SetUpdatedOnBehalfOf sets the UpdatedOnBehalfOf field's value.
func (s *Recommendation) SetUpdatedOnBehalfOf(v string) *Recommendation {
	s.UpdatedOnBehalfOf = &v
	return s
}

// SetUpdatedOnBehalfOfJobTitle sets the UpdatedOnBehalfOfJobTitle field's value.
func (s *Recommendation) SetUpdatedOnBehalfOfJobTitle(v string) *Recommendation {
	s.UpdatedOnBehalfOfJobTitle = &v
	return s
}

// Cost optimizing aggregates for a Recommendation
type RecommendationCostOptimizingAggregates struct {
	_ struct{} `type:"structure"`

	// The estimated monthly savings
	//
	// EstimatedMonthlySavings is a required field
	EstimatedMonthlySavings *float64 `locationName:"estimatedMonthlySavings" type:"double" required:"true"`

	// The estimated percently monthly savings
	//
	// EstimatedPercentMonthlySavings is a required field
	EstimatedPercentMonthlySavings *float64 `locationName:"estimatedPercentMonthlySavings" type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationCostOptimizingAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationCostOptimizingAggregates) GoString() string {
	return s.String()
}

// SetEstimatedMonthlySavings sets the EstimatedMonthlySavings field's value.
func (s *RecommendationCostOptimizingAggregates) SetEstimatedMonthlySavings(v float64) *RecommendationCostOptimizingAggregates {
	s.EstimatedMonthlySavings = &v
	return s
}

// SetEstimatedPercentMonthlySavings sets the EstimatedPercentMonthlySavings field's value.
func (s *RecommendationCostOptimizingAggregates) SetEstimatedPercentMonthlySavings(v float64) *RecommendationCostOptimizingAggregates {
	s.EstimatedPercentMonthlySavings = &v
	return s
}

// Recommendation pillar aggregates
type RecommendationPillarSpecificAggregates struct {
	_ struct{} `type:"structure"`

	// Cost optimizing aggregates
	CostOptimizing *RecommendationCostOptimizingAggregates `locationName:"costOptimizing" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationPillarSpecificAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationPillarSpecificAggregates) GoString() string {
	return s.String()
}

// SetCostOptimizing sets the CostOptimizing field's value.
func (s *RecommendationPillarSpecificAggregates) SetCostOptimizing(v *RecommendationCostOptimizingAggregates) *RecommendationPillarSpecificAggregates {
	s.CostOptimizing = v
	return s
}

// The request entry for Recommendation Resource exclusion. Each entry is a
// combination of Recommendation Resource ARN and corresponding exclusion status
type RecommendationResourceExclusion struct {
	_ struct{} `type:"structure"`

	// The ARN of the Recommendation Resource
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The exclusion status
	//
	// IsExcluded is a required field
	IsExcluded *bool `locationName:"isExcluded" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationResourceExclusion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationResourceExclusion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecommendationResourceExclusion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecommendationResourceExclusion"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.IsExcluded == nil {
		invalidParams.Add(request.NewErrParamRequired("IsExcluded"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *RecommendationResourceExclusion) SetArn(v string) *RecommendationResourceExclusion {
	s.Arn = &v
	return s
}

// SetIsExcluded sets the IsExcluded field's value.
func (s *RecommendationResourceExclusion) SetIsExcluded(v bool) *RecommendationResourceExclusion {
	s.IsExcluded = &v
	return s
}

// Summary of a Recommendation Resource
type RecommendationResourceSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the Recommendation Resource
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The AWS resource identifier
	//
	// AwsResourceId is a required field
	AwsResourceId *string `locationName:"awsResourceId" type:"string" required:"true"`

	// The exclusion status of the Recommendation Resource
	ExclusionStatus *string `locationName:"exclusionStatus" type:"string" enum:"ExclusionStatus"`

	// The ID of the Recommendation Resource
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When the Recommendation Resource was last updated
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Metadata associated with the Recommendation Resource
	//
	// Metadata is a required field
	Metadata map[string]*string `locationName:"metadata" type:"map" required:"true"`

	// The Recommendation ARN
	//
	// RecommendationArn is a required field
	RecommendationArn *string `locationName:"recommendationArn" min:"20" type:"string" required:"true"`

	// The AWS Region code that the Recommendation Resource is in
	//
	// RegionCode is a required field
	RegionCode *string `locationName:"regionCode" min:"9" type:"string" required:"true"`

	// The current status of the Recommendation Resource
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationResourceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RecommendationResourceSummary) SetArn(v string) *RecommendationResourceSummary {
	s.Arn = &v
	return s
}

// SetAwsResourceId sets the AwsResourceId field's value.
func (s *RecommendationResourceSummary) SetAwsResourceId(v string) *RecommendationResourceSummary {
	s.AwsResourceId = &v
	return s
}

// SetExclusionStatus sets the ExclusionStatus field's value.
func (s *RecommendationResourceSummary) SetExclusionStatus(v string) *RecommendationResourceSummary {
	s.ExclusionStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *RecommendationResourceSummary) SetId(v string) *RecommendationResourceSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *RecommendationResourceSummary) SetLastUpdatedAt(v time.Time) *RecommendationResourceSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *RecommendationResourceSummary) SetMetadata(v map[string]*string) *RecommendationResourceSummary {
	s.Metadata = v
	return s
}

// SetRecommendationArn sets the RecommendationArn field's value.
func (s *RecommendationResourceSummary) SetRecommendationArn(v string) *RecommendationResourceSummary {
	s.RecommendationArn = &v
	return s
}

// SetRegionCode sets the RegionCode field's value.
func (s *RecommendationResourceSummary) SetRegionCode(v string) *RecommendationResourceSummary {
	s.RegionCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecommendationResourceSummary) SetStatus(v string) *RecommendationResourceSummary {
	s.Status = &v
	return s
}

// Aggregation of Recommendation Resources
type RecommendationResourcesAggregates struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources that were flagged to have errors according to
	// the Trusted Advisor check
	//
	// ErrorCount is a required field
	ErrorCount *int64 `locationName:"errorCount" type:"long" required:"true"`

	// The number of AWS resources that were flagged to be OK according to the Trusted
	// Advisor check
	//
	// OkCount is a required field
	OkCount *int64 `locationName:"okCount" type:"long" required:"true"`

	// The number of AWS resources that were flagged to have warning according to
	// the Trusted Advisor check
	//
	// WarningCount is a required field
	WarningCount *int64 `locationName:"warningCount" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationResourcesAggregates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationResourcesAggregates) GoString() string {
	return s.String()
}

// SetErrorCount sets the ErrorCount field's value.
func (s *RecommendationResourcesAggregates) SetErrorCount(v int64) *RecommendationResourcesAggregates {
	s.ErrorCount = &v
	return s
}

// SetOkCount sets the OkCount field's value.
func (s *RecommendationResourcesAggregates) SetOkCount(v int64) *RecommendationResourcesAggregates {
	s.OkCount = &v
	return s
}

// SetWarningCount sets the WarningCount field's value.
func (s *RecommendationResourcesAggregates) SetWarningCount(v int64) *RecommendationResourcesAggregates {
	s.WarningCount = &v
	return s
}

// Summary of Recommendation for an Account
type RecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the Recommendation
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The AWS Services that the Recommendation applies to
	AwsServices []*string `locationName:"awsServices" type:"list"`

	// The AWS Trusted Advisor Check ARN that relates to the Recommendation
	CheckArn *string `locationName:"checkArn" type:"string"`

	// When the Recommendation was created, if created by AWS Trusted Advisor Priority
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID which identifies where the Recommendation was produced
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When the Recommendation was last updated
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The lifecycle stage from AWS Trusted Advisor Priority
	LifecycleStage *string `locationName:"lifecycleStage" type:"string" enum:"RecommendationLifecycleStage"`

	// The name of the AWS Trusted Advisor Recommendation
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The pillar aggregations for cost savings
	PillarSpecificAggregates *RecommendationPillarSpecificAggregates `locationName:"pillarSpecificAggregates" type:"structure"`

	// The Pillars that the Recommendation is optimizing
	//
	// Pillars is a required field
	Pillars []*string `locationName:"pillars" type:"list" required:"true" enum:"RecommendationPillar"`

	// An aggregation of all resources
	//
	// ResourcesAggregates is a required field
	ResourcesAggregates *RecommendationResourcesAggregates `locationName:"resourcesAggregates" type:"structure" required:"true"`

	// The source of the Recommendation
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true" enum:"RecommendationSource"`

	// The status of the Recommendation
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RecommendationStatus"`

	// Whether the Recommendation was automated or generated by AWS Trusted Advisor
	// Priority
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RecommendationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RecommendationSummary) SetArn(v string) *RecommendationSummary {
	s.Arn = &v
	return s
}

// SetAwsServices sets the AwsServices field's value.
func (s *RecommendationSummary) SetAwsServices(v []*string) *RecommendationSummary {
	s.AwsServices = v
	return s
}

// SetCheckArn sets the CheckArn field's value.
func (s *RecommendationSummary) SetCheckArn(v string) *RecommendationSummary {
	s.CheckArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RecommendationSummary) SetCreatedAt(v time.Time) *RecommendationSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *RecommendationSummary) SetId(v string) *RecommendationSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *RecommendationSummary) SetLastUpdatedAt(v time.Time) *RecommendationSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetLifecycleStage sets the LifecycleStage field's value.
func (s *RecommendationSummary) SetLifecycleStage(v string) *RecommendationSummary {
	s.LifecycleStage = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecommendationSummary) SetName(v string) *RecommendationSummary {
	s.Name = &v
	return s
}

// SetPillarSpecificAggregates sets the PillarSpecificAggregates field's value.
func (s *RecommendationSummary) SetPillarSpecificAggregates(v *RecommendationPillarSpecificAggregates) *RecommendationSummary {
	s.PillarSpecificAggregates = v
	return s
}

// SetPillars sets the Pillars field's value.
func (s *RecommendationSummary) SetPillars(v []*string) *RecommendationSummary {
	s.Pillars = v
	return s
}

// SetResourcesAggregates sets the ResourcesAggregates field's value.
func (s *RecommendationSummary) SetResourcesAggregates(v *RecommendationResourcesAggregates) *RecommendationSummary {
	s.ResourcesAggregates = v
	return s
}

// SetSource sets the Source field's value.
func (s *RecommendationSummary) SetSource(v string) *RecommendationSummary {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecommendationSummary) SetStatus(v string) *RecommendationSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecommendationSummary) SetType(v string) *RecommendationSummary {
	s.Type = &v
	return s
}

// Exception that the requested resource has not been found
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception to notify that requests are being throttled
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateOrganizationRecommendationLifecycleInput struct {
	_ struct{} `type:"structure"`

	// The new lifecycle stage
	//
	// LifecycleStage is a required field
	LifecycleStage *string `locationName:"lifecycleStage" type:"string" required:"true" enum:"UpdateRecommendationLifecycleStage"`

	// The Recommendation identifier for AWS Trusted Advisor Priority recommendations
	//
	// OrganizationRecommendationIdentifier is a required field
	OrganizationRecommendationIdentifier *string `location:"uri" locationName:"organizationRecommendationIdentifier" min:"20" type:"string" required:"true"`

	// Reason for the lifecycle stage change
	//
	// UpdateReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateOrganizationRecommendationLifecycleInput's
	// String and GoString methods.
	UpdateReason *string `locationName:"updateReason" min:"10" type:"string" sensitive:"true"`

	// Reason code for the lifecycle state change
	UpdateReasonCode *string `locationName:"updateReasonCode" type:"string" enum:"UpdateRecommendationLifecycleStageReasonCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationRecommendationLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationRecommendationLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationRecommendationLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationRecommendationLifecycleInput"}
	if s.LifecycleStage == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleStage"))
	}
	if s.OrganizationRecommendationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationRecommendationIdentifier"))
	}
	if s.OrganizationRecommendationIdentifier != nil && len(*s.OrganizationRecommendationIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationRecommendationIdentifier", 20))
	}
	if s.UpdateReason != nil && len(*s.UpdateReason) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateReason", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLifecycleStage sets the LifecycleStage field's value.
func (s *UpdateOrganizationRecommendationLifecycleInput) SetLifecycleStage(v string) *UpdateOrganizationRecommendationLifecycleInput {
	s.LifecycleStage = &v
	return s
}

// SetOrganizationRecommendationIdentifier sets the OrganizationRecommendationIdentifier field's value.
func (s *UpdateOrganizationRecommendationLifecycleInput) SetOrganizationRecommendationIdentifier(v string) *UpdateOrganizationRecommendationLifecycleInput {
	s.OrganizationRecommendationIdentifier = &v
	return s
}

// SetUpdateReason sets the UpdateReason field's value.
func (s *UpdateOrganizationRecommendationLifecycleInput) SetUpdateReason(v string) *UpdateOrganizationRecommendationLifecycleInput {
	s.UpdateReason = &v
	return s
}

// SetUpdateReasonCode sets the UpdateReasonCode field's value.
func (s *UpdateOrganizationRecommendationLifecycleInput) SetUpdateReasonCode(v string) *UpdateOrganizationRecommendationLifecycleInput {
	s.UpdateReasonCode = &v
	return s
}

type UpdateOrganizationRecommendationLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationRecommendationLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOrganizationRecommendationLifecycleOutput) GoString() string {
	return s.String()
}

type UpdateRecommendationLifecycleInput struct {
	_ struct{} `type:"structure"`

	// The new lifecycle stage
	//
	// LifecycleStage is a required field
	LifecycleStage *string `locationName:"lifecycleStage" type:"string" required:"true" enum:"UpdateRecommendationLifecycleStage"`

	// The Recommendation identifier for AWS Trusted Advisor Priority recommendations
	//
	// RecommendationIdentifier is a required field
	RecommendationIdentifier *string `location:"uri" locationName:"recommendationIdentifier" min:"20" type:"string" required:"true"`

	// Reason for the lifecycle stage change
	//
	// UpdateReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateRecommendationLifecycleInput's
	// String and GoString methods.
	UpdateReason *string `locationName:"updateReason" min:"10" type:"string" sensitive:"true"`

	// Reason code for the lifecycle state change
	UpdateReasonCode *string `locationName:"updateReasonCode" type:"string" enum:"UpdateRecommendationLifecycleStageReasonCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecommendationLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecommendationLifecycleInput"}
	if s.LifecycleStage == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleStage"))
	}
	if s.RecommendationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationIdentifier"))
	}
	if s.RecommendationIdentifier != nil && len(*s.RecommendationIdentifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RecommendationIdentifier", 20))
	}
	if s.UpdateReason != nil && len(*s.UpdateReason) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateReason", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLifecycleStage sets the LifecycleStage field's value.
func (s *UpdateRecommendationLifecycleInput) SetLifecycleStage(v string) *UpdateRecommendationLifecycleInput {
	s.LifecycleStage = &v
	return s
}

// SetRecommendationIdentifier sets the RecommendationIdentifier field's value.
func (s *UpdateRecommendationLifecycleInput) SetRecommendationIdentifier(v string) *UpdateRecommendationLifecycleInput {
	s.RecommendationIdentifier = &v
	return s
}

// SetUpdateReason sets the UpdateReason field's value.
func (s *UpdateRecommendationLifecycleInput) SetUpdateReason(v string) *UpdateRecommendationLifecycleInput {
	s.UpdateReason = &v
	return s
}

// SetUpdateReasonCode sets the UpdateReasonCode field's value.
func (s *UpdateRecommendationLifecycleInput) SetUpdateReasonCode(v string) *UpdateRecommendationLifecycleInput {
	s.UpdateReasonCode = &v
	return s
}

type UpdateRecommendationLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationLifecycleOutput) GoString() string {
	return s.String()
}

// The error entry for Recommendation Resource exclusion. Each entry is a combination
// of Recommendation Resource ARN, error code and error message
type UpdateRecommendationResourceExclusionError struct {
	_ struct{} `type:"structure"`

	// The ARN of the Recommendation Resource
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The error code
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The error message
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationResourceExclusionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRecommendationResourceExclusionError) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateRecommendationResourceExclusionError) SetArn(v string) *UpdateRecommendationResourceExclusionError {
	s.Arn = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UpdateRecommendationResourceExclusionError) SetErrorCode(v string) *UpdateRecommendationResourceExclusionError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UpdateRecommendationResourceExclusionError) SetErrorMessage(v string) *UpdateRecommendationResourceExclusionError {
	s.ErrorMessage = &v
	return s
}

// Exception that the request failed to satisfy service constraints
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ExclusionStatusExcluded is a ExclusionStatus enum value
	ExclusionStatusExcluded = "excluded"

	// ExclusionStatusIncluded is a ExclusionStatus enum value
	ExclusionStatusIncluded = "included"
)

// ExclusionStatus_Values returns all elements of the ExclusionStatus enum
func ExclusionStatus_Values() []string {
	return []string{
		ExclusionStatusExcluded,
		ExclusionStatusIncluded,
	}
}

const (
	// RecommendationLanguageEn is a RecommendationLanguage enum value
	RecommendationLanguageEn = "en"

	// RecommendationLanguageJa is a RecommendationLanguage enum value
	RecommendationLanguageJa = "ja"

	// RecommendationLanguageZh is a RecommendationLanguage enum value
	RecommendationLanguageZh = "zh"

	// RecommendationLanguageFr is a RecommendationLanguage enum value
	RecommendationLanguageFr = "fr"

	// RecommendationLanguageDe is a RecommendationLanguage enum value
	RecommendationLanguageDe = "de"

	// RecommendationLanguageKo is a RecommendationLanguage enum value
	RecommendationLanguageKo = "ko"

	// RecommendationLanguageZhTw is a RecommendationLanguage enum value
	RecommendationLanguageZhTw = "zh_TW"

	// RecommendationLanguageIt is a RecommendationLanguage enum value
	RecommendationLanguageIt = "it"

	// RecommendationLanguageEs is a RecommendationLanguage enum value
	RecommendationLanguageEs = "es"

	// RecommendationLanguagePtBr is a RecommendationLanguage enum value
	RecommendationLanguagePtBr = "pt_BR"

	// RecommendationLanguageId is a RecommendationLanguage enum value
	RecommendationLanguageId = "id"
)

// RecommendationLanguage_Values returns all elements of the RecommendationLanguage enum
func RecommendationLanguage_Values() []string {
	return []string{
		RecommendationLanguageEn,
		RecommendationLanguageJa,
		RecommendationLanguageZh,
		RecommendationLanguageFr,
		RecommendationLanguageDe,
		RecommendationLanguageKo,
		RecommendationLanguageZhTw,
		RecommendationLanguageIt,
		RecommendationLanguageEs,
		RecommendationLanguagePtBr,
		RecommendationLanguageId,
	}
}

const (
	// RecommendationLifecycleStageInProgress is a RecommendationLifecycleStage enum value
	RecommendationLifecycleStageInProgress = "in_progress"

	// RecommendationLifecycleStagePendingResponse is a RecommendationLifecycleStage enum value
	RecommendationLifecycleStagePendingResponse = "pending_response"

	// RecommendationLifecycleStageDismissed is a RecommendationLifecycleStage enum value
	RecommendationLifecycleStageDismissed = "dismissed"

	// RecommendationLifecycleStageResolved is a RecommendationLifecycleStage enum value
	RecommendationLifecycleStageResolved = "resolved"
)

// RecommendationLifecycleStage_Values returns all elements of the RecommendationLifecycleStage enum
func RecommendationLifecycleStage_Values() []string {
	return []string{
		RecommendationLifecycleStageInProgress,
		RecommendationLifecycleStagePendingResponse,
		RecommendationLifecycleStageDismissed,
		RecommendationLifecycleStageResolved,
	}
}

const (
	// RecommendationPillarCostOptimizing is a RecommendationPillar enum value
	RecommendationPillarCostOptimizing = "cost_optimizing"

	// RecommendationPillarPerformance is a RecommendationPillar enum value
	RecommendationPillarPerformance = "performance"

	// RecommendationPillarSecurity is a RecommendationPillar enum value
	RecommendationPillarSecurity = "security"

	// RecommendationPillarServiceLimits is a RecommendationPillar enum value
	RecommendationPillarServiceLimits = "service_limits"

	// RecommendationPillarFaultTolerance is a RecommendationPillar enum value
	RecommendationPillarFaultTolerance = "fault_tolerance"

	// RecommendationPillarOperationalExcellence is a RecommendationPillar enum value
	RecommendationPillarOperationalExcellence = "operational_excellence"
)

// RecommendationPillar_Values returns all elements of the RecommendationPillar enum
func RecommendationPillar_Values() []string {
	return []string{
		RecommendationPillarCostOptimizing,
		RecommendationPillarPerformance,
		RecommendationPillarSecurity,
		RecommendationPillarServiceLimits,
		RecommendationPillarFaultTolerance,
		RecommendationPillarOperationalExcellence,
	}
}

const (
	// RecommendationSourceAwsConfig is a RecommendationSource enum value
	RecommendationSourceAwsConfig = "aws_config"

	// RecommendationSourceComputeOptimizer is a RecommendationSource enum value
	RecommendationSourceComputeOptimizer = "compute_optimizer"

	// RecommendationSourceCostExplorer is a RecommendationSource enum value
	RecommendationSourceCostExplorer = "cost_explorer"

	// RecommendationSourceLse is a RecommendationSource enum value
	RecommendationSourceLse = "lse"

	// RecommendationSourceManual is a RecommendationSource enum value
	RecommendationSourceManual = "manual"

	// RecommendationSourcePse is a RecommendationSource enum value
	RecommendationSourcePse = "pse"

	// RecommendationSourceRds is a RecommendationSource enum value
	RecommendationSourceRds = "rds"

	// RecommendationSourceResilience is a RecommendationSource enum value
	RecommendationSourceResilience = "resilience"

	// RecommendationSourceResilienceHub is a RecommendationSource enum value
	RecommendationSourceResilienceHub = "resilience_hub"

	// RecommendationSourceSecurityHub is a RecommendationSource enum value
	RecommendationSourceSecurityHub = "security_hub"

	// RecommendationSourceStir is a RecommendationSource enum value
	RecommendationSourceStir = "stir"

	// RecommendationSourceTaCheck is a RecommendationSource enum value
	RecommendationSourceTaCheck = "ta_check"

	// RecommendationSourceWellArchitected is a RecommendationSource enum value
	RecommendationSourceWellArchitected = "well_architected"
)

// RecommendationSource_Values returns all elements of the RecommendationSource enum
func RecommendationSource_Values() []string {
	return []string{
		RecommendationSourceAwsConfig,
		RecommendationSourceComputeOptimizer,
		RecommendationSourceCostExplorer,
		RecommendationSourceLse,
		RecommendationSourceManual,
		RecommendationSourcePse,
		RecommendationSourceRds,
		RecommendationSourceResilience,
		RecommendationSourceResilienceHub,
		RecommendationSourceSecurityHub,
		RecommendationSourceStir,
		RecommendationSourceTaCheck,
		RecommendationSourceWellArchitected,
	}
}

const (
	// RecommendationStatusOk is a RecommendationStatus enum value
	RecommendationStatusOk = "ok"

	// RecommendationStatusWarning is a RecommendationStatus enum value
	RecommendationStatusWarning = "warning"

	// RecommendationStatusError is a RecommendationStatus enum value
	RecommendationStatusError = "error"
)

// RecommendationStatus_Values returns all elements of the RecommendationStatus enum
func RecommendationStatus_Values() []string {
	return []string{
		RecommendationStatusOk,
		RecommendationStatusWarning,
		RecommendationStatusError,
	}
}

const (
	// RecommendationTypeStandard is a RecommendationType enum value
	RecommendationTypeStandard = "standard"

	// RecommendationTypePriority is a RecommendationType enum value
	RecommendationTypePriority = "priority"
)

// RecommendationType_Values returns all elements of the RecommendationType enum
func RecommendationType_Values() []string {
	return []string{
		RecommendationTypeStandard,
		RecommendationTypePriority,
	}
}

const (
	// ResourceStatusOk is a ResourceStatus enum value
	ResourceStatusOk = "ok"

	// ResourceStatusWarning is a ResourceStatus enum value
	ResourceStatusWarning = "warning"

	// ResourceStatusError is a ResourceStatus enum value
	ResourceStatusError = "error"
)

// ResourceStatus_Values returns all elements of the ResourceStatus enum
func ResourceStatus_Values() []string {
	return []string{
		ResourceStatusOk,
		ResourceStatusWarning,
		ResourceStatusError,
	}
}

const (
	// UpdateRecommendationLifecycleStagePendingResponse is a UpdateRecommendationLifecycleStage enum value
	UpdateRecommendationLifecycleStagePendingResponse = "pending_response"

	// UpdateRecommendationLifecycleStageInProgress is a UpdateRecommendationLifecycleStage enum value
	UpdateRecommendationLifecycleStageInProgress = "in_progress"

	// UpdateRecommendationLifecycleStageDismissed is a UpdateRecommendationLifecycleStage enum value
	UpdateRecommendationLifecycleStageDismissed = "dismissed"

	// UpdateRecommendationLifecycleStageResolved is a UpdateRecommendationLifecycleStage enum value
	UpdateRecommendationLifecycleStageResolved = "resolved"
)

// UpdateRecommendationLifecycleStage_Values returns all elements of the UpdateRecommendationLifecycleStage enum
func UpdateRecommendationLifecycleStage_Values() []string {
	return []string{
		UpdateRecommendationLifecycleStagePendingResponse,
		UpdateRecommendationLifecycleStageInProgress,
		UpdateRecommendationLifecycleStageDismissed,
		UpdateRecommendationLifecycleStageResolved,
	}
}

const (
	// UpdateRecommendationLifecycleStageReasonCodeNonCriticalAccount is a UpdateRecommendationLifecycleStageReasonCode enum value
	UpdateRecommendationLifecycleStageReasonCodeNonCriticalAccount = "non_critical_account"

	// UpdateRecommendationLifecycleStageReasonCodeTemporaryAccount is a UpdateRecommendationLifecycleStageReasonCode enum value
	UpdateRecommendationLifecycleStageReasonCodeTemporaryAccount = "temporary_account"

	// UpdateRecommendationLifecycleStageReasonCodeValidBusinessCase is a UpdateRecommendationLifecycleStageReasonCode enum value
	UpdateRecommendationLifecycleStageReasonCodeValidBusinessCase = "valid_business_case"

	// UpdateRecommendationLifecycleStageReasonCodeOtherMethodsAvailable is a UpdateRecommendationLifecycleStageReasonCode enum value
	UpdateRecommendationLifecycleStageReasonCodeOtherMethodsAvailable = "other_methods_available"

	// UpdateRecommendationLifecycleStageReasonCodeLowPriority is a UpdateRecommendationLifecycleStageReasonCode enum value
	UpdateRecommendationLifecycleStageReasonCodeLowPriority = "low_priority"

	// UpdateRecommendationLifecycleStageReasonCodeNotApplicable is a UpdateRecommendationLifecycleStageReasonCode enum value
	UpdateRecommendationLifecycleStageReasonCodeNotApplicable = "not_applicable"

	// UpdateRecommendationLifecycleStageReasonCodeOther is a UpdateRecommendationLifecycleStageReasonCode enum value
	UpdateRecommendationLifecycleStageReasonCodeOther = "other"
)

// UpdateRecommendationLifecycleStageReasonCode_Values returns all elements of the UpdateRecommendationLifecycleStageReasonCode enum
func UpdateRecommendationLifecycleStageReasonCode_Values() []string {
	return []string{
		UpdateRecommendationLifecycleStageReasonCodeNonCriticalAccount,
		UpdateRecommendationLifecycleStageReasonCodeTemporaryAccount,
		UpdateRecommendationLifecycleStageReasonCodeValidBusinessCase,
		UpdateRecommendationLifecycleStageReasonCodeOtherMethodsAvailable,
		UpdateRecommendationLifecycleStageReasonCodeLowPriority,
		UpdateRecommendationLifecycleStageReasonCodeNotApplicable,
		UpdateRecommendationLifecycleStageReasonCodeOther,
	}
}
