/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.file.attribute.FileTime;
import org.jruby.util.JarResource;
import org.jruby.util.ResourceException;

class JarDirectoryResource
extends JarResource {
    private final String path;
    private final String[] contents;

    JarDirectoryResource(String jarPath, boolean rootSlashPrefix, String path2, String[] contents) {
        super(jarPath, rootSlashPrefix);
        this.path = path2;
        this.contents = contents;
    }

    @Override
    public String entryName() {
        return this.path;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FileTime creationTime() {
        return null;
    }

    @Override
    public FileTime lastAccessTime() {
        return null;
    }

    @Override
    public FileTime lastModifiedTime() {
        return null;
    }

    @Override
    public String[] list() {
        return this.contents;
    }

    public boolean isRoot() {
        return "/".equals(this.path);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        throw new ResourceException.FileIsDirectory(this.path);
    }

    @Override
    public Channel openChannel(int flags2, int perm) throws ResourceException {
        throw new ResourceException.PermissionDenied(this.absolutePath());
    }

    @Override
    public <T> T unwrap(Class<T> type2) {
        throw new UnsupportedOperationException("unwrap: " + type2.getName());
    }
}

