/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.unicode.UnicodeCodeRange;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHelper;
import org.jruby.util.StringSupport;
import org.jruby.util.SymbolNameType;

public final class IdUtil {
    private static int[] globalPunctuationBits = new int[3];
    private static final int[] globalNamePunctuationBits = new int[]{IdUtil.SPECIAL_PUNCT(0), IdUtil.SPECIAL_PUNCT(1), IdUtil.SPECIAL_PUNCT(2)};

    public static boolean isConstant(String id2) {
        return Character.isUpperCase(id2.charAt(0));
    }

    public static boolean isClassVariable(String id2) {
        return id2.length() > 1 && id2.charAt(0) == '@' && id2.charAt(1) == '@';
    }

    public static boolean isInstanceVariable(String id2) {
        return id2.length() > 0 && id2.charAt(0) == '@' && (id2.length() < 2 || id2.charAt(1) != '@');
    }

    public static boolean isGlobal(String id2) {
        return id2.length() > 0 && id2.charAt(0) == '$';
    }

    public static boolean isPredicate(String id2) {
        return id2.endsWith("?");
    }

    @Deprecated
    public static boolean isLocal(String id2) {
        return !IdUtil.isGlobal(id2) && !IdUtil.isClassVariable(id2) && !IdUtil.isInstanceVariable(id2) && !IdUtil.isConstant(id2) && !IdUtil.isPredicate(id2) && !IdUtil.isSpecial(id2);
    }

    public static boolean isSpecial(String id2) {
        return id2.startsWith("%");
    }

    public static boolean isAttrSet(String id2) {
        return id2.endsWith("=");
    }

    public static boolean isValidConstantName(String id2) {
        char c;
        int len = id2.length();
        if (len > 0 && (c = id2.charAt(0)) <= 'Z' && c >= 'A') {
            return IdUtil.isNameString(id2, 1, len);
        }
        return false;
    }

    public static boolean isValidInstanceVariableName(String id2) {
        int len = id2.length();
        if (len > 1 && '@' == id2.charAt(0) && IdUtil.isInitialCharacter(id2.charAt(1))) {
            return IdUtil.isNameString(id2, 2, len);
        }
        return false;
    }

    public static boolean isValidClassVariableName(String id2) {
        int len = id2.length();
        if (len > 2 && '@' == id2.charAt(0) && '@' == id2.charAt(1) && IdUtil.isInitialCharacter(id2.charAt(2))) {
            return IdUtil.isNameString(id2, 3, len);
        }
        return false;
    }

    public static boolean isInitialCharacter(int c) {
        return Character.isAlphabetic(c) || c == 95;
    }

    public static boolean isNameCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isNameString(String id2, int start2, int limit2) {
        for (int i2 = start2; i2 < limit2; ++i2) {
            if (IdUtil.isNameCharacter(id2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isRubyVariable(String name2) {
        char c;
        return name2.length() > 0 && ((c = name2.charAt(0)) == '@' || c <= 'Z' && c >= 'A');
    }

    public static boolean isConstantInitial(ByteList byteList) {
        int end2;
        int begin2;
        int nlen = byteList.realSize();
        Encoding enc = byteList.getEncoding();
        if (nlen < 1) {
            return false;
        }
        int byte0 = byteList.get(0);
        if (byte0 < 128) {
            return enc.isUpper(byte0);
        }
        byte[] bytes2 = byteList.getUnsafeBytes();
        int c = StringSupport.preciseLength(enc, bytes2, begin2 = byteList.begin(), end2 = begin2 + nlen);
        if (!StringSupport.MBCLEN_CHARFOUND_P(c)) {
            return false;
        }
        int len = StringSupport.MBCLEN_CHARFOUND_LEN(c);
        c = StringSupport.codePoint(enc, bytes2, begin2, end2);
        if (enc.isUnicode()) {
            if (enc.isUpper(c)) {
                return true;
            }
            if (enc.isLower(c)) {
                return false;
            }
            if (enc.isCodeCType(c, UnicodeCodeRange.TITLECASELETTER.getCType())) {
                return true;
            }
        } else {
            IntHolder holder = new IntHolder();
            holder.value = begin2;
            byte[] fold = new byte[13];
            int r = enc.mbcCaseFold(524288, bytes2, holder, end2, fold);
            if (r > 0 && (r != len || ByteList.memcmp(fold, 0, bytes2, begin2, r) != 0)) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isValidConstantName19(String id2) {
        return IdUtil.isValidConstantName(id2);
    }

    @Deprecated
    public static boolean isNameCharacter19(char c) {
        return IdUtil.isNameCharacter(c);
    }

    @Deprecated
    public static boolean isNameString19(String id2, int start2, int limit2) {
        return IdUtil.isNameString(id2, start2, limit2);
    }

    public static SymbolNameType determineSymbolNameType(Ruby runtime2, ByteList data2) {
        int e;
        int m;
        SymbolNameType type2;
        block43: {
            block45: {
                ByteList chopped;
                int length2;
                block44: {
                    Encoding encoding2 = data2.getEncoding();
                    if (!encoding2.isAsciiCompatible()) {
                        return SymbolNameType.OTHER;
                    }
                    if (data2.isEmpty()) {
                        return SymbolNameType.OTHER;
                    }
                    length2 = data2.length();
                    type2 = SymbolNameType.OTHER;
                    boolean idCheck = false;
                    m = 0;
                    e = length2 - 1;
                    block0 : switch ((byte)data2.get(m)) {
                        case 0: {
                            return SymbolNameType.OTHER;
                        }
                        case 36: {
                            type2 = SymbolNameType.GLOBAL;
                            if (++m < e && IdUtil.isSpecialGlobalName((byte)data2.get(m))) {
                                return type2;
                            }
                            idCheck = true;
                            break;
                        }
                        case 64: {
                            type2 = SymbolNameType.INSTANCE;
                            if (++m < e && data2.get(m) == 64) {
                                ++m;
                                type2 = SymbolNameType.CLASS;
                            }
                            idCheck = true;
                            break;
                        }
                        case 60: {
                            if (++m >= e) break;
                            switch (data2.get(m)) {
                                case 60: {
                                    ++m;
                                    break;
                                }
                                case 61: {
                                    if (++m >= e || data2.get(m) != 62) break block0;
                                    ++m;
                                    break;
                                }
                            }
                            break;
                        }
                        case 62: {
                            if (++m >= e) break;
                            switch (data2.get(m)) {
                                case 61: 
                                case 62: {
                                    ++m;
                                }
                            }
                            break;
                        }
                        case 61: {
                            if (++m >= e) break;
                            switch (data2.get(m)) {
                                case 126: {
                                    ++m;
                                    break block0;
                                }
                                case 61: {
                                    if (++m >= e || data2.get(m + 1) != 61) break block0;
                                    ++m;
                                    break block0;
                                }
                                default: {
                                    return SymbolNameType.OTHER;
                                }
                            }
                        }
                        case 42: {
                            if (++m >= e || data2.get(m + 1) != 42) break;
                            ++m;
                            break;
                        }
                        case 43: 
                        case 45: {
                            if (++m >= e || data2.get(m + 1) != 64) break;
                            ++m;
                            break;
                        }
                        case 37: 
                        case 38: 
                        case 47: 
                        case 94: 
                        case 96: 
                        case 124: 
                        case 126: {
                            ++m;
                            break;
                        }
                        case 91: {
                            if (++m < e && data2.get(m) != 93) {
                                idCheck = true;
                                break;
                            }
                            if (++m >= e || data2.get(m + 1) == 61) break;
                            ++m;
                            break;
                        }
                        case 33: {
                            ++m;
                            if (length2 == 1) {
                                return SymbolNameType.JUNK;
                            }
                            switch (data2.get(m)) {
                                case 61: 
                                case 126: {
                                    ++m;
                                    break block0;
                                }
                            }
                            return SymbolNameType.OTHER;
                        }
                        default: {
                            type2 = IdUtil.isConstantInitial(data2) ? SymbolNameType.CONST : SymbolNameType.LOCAL;
                            idCheck = true;
                        }
                    }
                    if (!idCheck) break block43;
                    if (m > e) break block44;
                    if (data2.get(m) == 95) break block45;
                    if (!Encoding.isMbcAscii((byte)data2.get(m)) || encoding2.isAlpha(data2.get(m))) break block45;
                }
                if (length2 > 1 && data2.get(length2 - 1) == 61 && (type2 = IdUtil.determineSymbolNameType(runtime2, chopped = new ByteList(data2.unsafeBytes(), data2.begin(), length2 - 1, data2.getEncoding(), false))) != SymbolNameType.ATTRSET) {
                    return SymbolNameType.ATTRSET;
                }
                return SymbolNameType.OTHER;
            }
            if ((m = ByteListHelper.eachCodePointWhile(runtime2, data2, m, (index2, codepoint, enc) -> enc.isAlnum(codepoint) || codepoint == 95 || !Encoding.isAscii(codepoint))) > e) {
                return type2;
            }
            switch (data2.get(m)) {
                case 33: 
                case 63: {
                    if (type2 == SymbolNameType.GLOBAL || type2 == SymbolNameType.CLASS || type2 == SymbolNameType.INSTANCE) {
                        return SymbolNameType.OTHER;
                    }
                    type2 = SymbolNameType.JUNK;
                    if (++m + 1 < e || m < e && data2.get(m) != 61) break;
                }
                case 61: {
                    return SymbolNameType.OTHER;
                }
            }
        }
        return m == e + 1 ? type2 : SymbolNameType.OTHER;
    }

    private static int BIT(int c, int index2) {
        return c / 31 - 1 == index2 ? 1 << c % 32 : 0;
    }

    private static int SPECIAL_PUNCT(int idx) {
        return IdUtil.BIT(126, idx) | IdUtil.BIT(42, idx) | IdUtil.BIT(36, idx) | IdUtil.BIT(63, idx) | IdUtil.BIT(33, idx) | IdUtil.BIT(64, idx) | IdUtil.BIT(47, idx) | IdUtil.BIT(92, idx) | IdUtil.BIT(59, idx) | IdUtil.BIT(44, idx) | IdUtil.BIT(46, idx) | IdUtil.BIT(61, idx) | IdUtil.BIT(58, idx) | IdUtil.BIT(60, idx) | IdUtil.BIT(62, idx) | IdUtil.BIT(34, idx) | IdUtil.BIT(38, idx) | IdUtil.BIT(96, idx) | IdUtil.BIT(39, idx) | IdUtil.BIT(43, idx) | IdUtil.BIT(48, idx);
    }

    private static boolean isSpecialGlobalName(byte c) {
        if (c <= 32 || 114 < c) {
            return false;
        }
        return (globalNamePunctuationBits[(c - 32) / 32] >> c % 32 & 1) != 0;
    }
}

