/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.InvokeFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.EmbedEvalUnitImpl;
import org.jruby.embed.internal.EmbedRubyRuntimeAdapterImpl;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class EmbedRubyObjectAdapterImpl
implements EmbedRubyObjectAdapter {
    private final RubyObjectAdapter adapter = JavaEmbedUtils.newObjectAdapter();
    private final ScriptingContainer container;
    private final boolean wrapExceptions;

    public EmbedRubyObjectAdapterImpl(ScriptingContainer container) {
        this(container, false);
    }

    public EmbedRubyObjectAdapterImpl(ScriptingContainer container, boolean wrapExceptions) {
        this.container = container;
        this.wrapExceptions = wrapExceptions;
    }

    @Override
    public boolean isKindOf(IRubyObject value2, RubyModule rubyModule) {
        return this.adapter.isKindOf(value2, rubyModule);
    }

    @Override
    public IRubyObject[] convertToJavaArray(IRubyObject array2) {
        return this.adapter.convertToJavaArray(array2);
    }

    @Override
    public RubyInteger convertToRubyInteger(IRubyObject obj) {
        return this.adapter.convertToRubyInteger(obj);
    }

    @Override
    public RubyString convertToRubyString(IRubyObject obj) {
        return this.adapter.convertToRubyString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject setInstanceVariable(IRubyObject obj, String variableName, IRubyObject value2) {
        BiVariableMap map2;
        BiVariableMap biVariableMap = map2 = this.container.getVarMap();
        synchronized (biVariableMap) {
            if (map2.containsKey(variableName)) {
                BiVariable bv = map2.getVariable((RubyObject)this.getTopSelf(), variableName);
                bv.setRubyObject(value2);
            } else {
                InstanceVariable iv = new InstanceVariable(obj, variableName, value2);
                map2.update(variableName, iv);
            }
        }
        return obj.getInstanceVariables().setInstanceVariable(variableName, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject getInstanceVariable(IRubyObject obj, String variableName) {
        BiVariableMap map2;
        BiVariableMap biVariableMap = map2 = this.container.getVarMap();
        synchronized (biVariableMap) {
            if (map2.containsKey(variableName)) {
                BiVariable bv = map2.getVariable((RubyObject)this.getTopSelf(), variableName);
                return bv.getRubyObject();
            }
        }
        return null;
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName) {
        return this.adapter.callMethod(receiver2, methodName);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject singleArg) {
        return this.adapter.callMethod(receiver2, methodName, singleArg);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2) {
        return this.adapter.callMethod(receiver2, methodName, args2);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2, Block block) {
        return this.adapter.callMethod(receiver2, methodName, args2, block);
    }

    @Override
    public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2) {
        return this.adapter.callSuper(receiver2, args2);
    }

    @Override
    public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2, Block block) {
        return this.adapter.callSuper(receiver2, args2, block);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType) {
        return this.doInvokeMethod(returnType, this.getReceiverObject(receiver2), methodName, Block.NULL_BLOCK, null, new Object[0]);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object singleArg, Class<T> returnType) {
        return this.doInvokeMethod(returnType, this.getReceiverObject(receiver2), methodName, Block.NULL_BLOCK, null, singleArg);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType) {
        return this.doInvokeMethod(returnType, this.getReceiverObject(receiver2), methodName, Block.NULL_BLOCK, null, args2);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType) {
        return this.doInvokeMethod(returnType, this.getReceiverObject(receiver2), methodName, block, null, args2);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType, EmbedEvalUnit unit) {
        return this.doInvokeMethod(returnType, this.getReceiverObject(receiver2), methodName, Block.NULL_BLOCK, unit, new Object[0]);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType, EmbedEvalUnit unit) {
        return this.doInvokeMethod(returnType, this.getReceiverObject(receiver2), methodName, Block.NULL_BLOCK, unit, args2);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType, EmbedEvalUnit unit) {
        return this.doInvokeMethod(returnType, this.getReceiverObject(receiver2), methodName, block, unit, args2);
    }

    @Override
    public <T> T callSuper(Object receiver2, Object[] args2, Class<T> returnType) {
        return this.doInvokeSuper(returnType, this.getReceiverObject(receiver2), Block.NULL_BLOCK, null, args2);
    }

    @Override
    public <T> T callSuper(Object receiver2, Object[] args2, Block block, Class<T> returnType) {
        return this.doInvokeSuper(returnType, this.getReceiverObject(receiver2), block, null, args2);
    }

    @Override
    public Object callMethod(Object receiver2, String methodName, Object ... args2) {
        return this.doInvokeMethod(Object.class, this.getReceiverObject(receiver2), methodName, Block.NULL_BLOCK, null, args2);
    }

    @Override
    public Object callMethod(Object receiver2, String methodName, Block block, Object ... args2) {
        return this.doInvokeMethod(Object.class, this.getReceiverObject(receiver2), methodName, block, null, args2);
    }

    @Override
    public <T> T runRubyMethod(Class<T> returnType, Object receiver2, String methodName, Block block, Object ... args2) {
        assert (block != null);
        IRubyObject rubyReceiver = JavaEmbedUtils.javaToRuby(this.container.getProvider().getRuntime(), receiver2);
        return this.doInvokeMethod(returnType, rubyReceiver, methodName, block, null, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doInvokeSuper(Class<T> returnType, IRubyObject rubyReceiver, Block block, EmbedEvalUnit unit, Object ... args2) {
        Ruby runtime2 = this.container.getProvider().getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        boolean sharing_variables = EmbedEvalUnitImpl.isSharingVariables(this.container);
        if (sharing_variables) {
            this.beforeSharingVariablesCall(context, unit);
        }
        try {
            IRubyObject result2 = Helpers.invokeSuper(context, rubyReceiver, EmbedRubyObjectAdapterImpl.convertArgs(runtime2, args2), block);
            if (sharing_variables) {
                this.container.getVarMap().retrieve(rubyReceiver);
            }
            if (returnType != null) {
                T ret = JavaEmbedUtils.rubyToJava(runtime2, result2, returnType);
                T t = returnType.cast(ret);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            if (e instanceof InvokeFailedException) {
                throw e;
            }
            if (this.wrapExceptions) {
                throw new InvokeFailedException(e);
            }
            Helpers.throwException(e);
            T t = null;
            return t;
        }
        finally {
            if (sharing_variables) {
                this.afterSharingVariablesCall(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doInvokeMethod(Class<T> returnType, IRubyObject rubyReceiver, String methodName, Block block, EmbedEvalUnit unit, Object ... args2) {
        Ruby runtime2 = this.container.getProvider().getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        boolean sharing_variables = EmbedEvalUnitImpl.isSharingVariables(this.container);
        if (sharing_variables) {
            this.beforeSharingVariablesCall(context, unit);
        }
        try {
            IRubyObject result2 = Helpers.invoke(context, rubyReceiver, methodName, EmbedRubyObjectAdapterImpl.convertArgs(runtime2, args2), block);
            if (sharing_variables) {
                this.container.getVarMap().retrieve(rubyReceiver);
            }
            if (returnType != null) {
                T ret = JavaEmbedUtils.rubyToJava(runtime2, result2, returnType);
                T t = returnType.cast(ret);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            if (e instanceof InvokeFailedException) {
                throw e;
            }
            if (this.wrapExceptions) {
                throw new InvokeFailedException(e);
            }
            Helpers.throwException(e);
            T t = null;
            return t;
        }
        finally {
            if (sharing_variables) {
                this.afterSharingVariablesCall(context);
            }
        }
    }

    private void beforeSharingVariablesCall(ThreadContext context, EmbedEvalUnit unit) {
        DynamicScope scope = unit != null && unit.getLocalVarScope() != null ? unit.getLocalVarScope() : EmbedRubyRuntimeAdapterImpl.createLocalVarScope(context.runtime, this.container.getVarMap().getLocalVarNames());
        this.container.getVarMap().inject(scope);
        context.pushScope(scope);
    }

    private void afterSharingVariablesCall(ThreadContext context) {
        context.popScope();
    }

    private IRubyObject getReceiverObject(Object receiver2) {
        if (receiver2 instanceof IRubyObject) {
            return (IRubyObject)receiver2;
        }
        return this.getTopSelf();
    }

    private IRubyObject getTopSelf() {
        return this.container.getProvider().getRuntime().getTopSelf();
    }

    private static IRubyObject[] convertArgs(Ruby runtime2, Object[] args2) {
        IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime2, args2);
        for (int i2 = 0; i2 < rubyArgs.length; ++i2) {
            IRubyObject obj = rubyArgs[i2];
            if (!(obj instanceof JavaObject)) continue;
            rubyArgs[i2] = Java.wrap(runtime2, obj);
        }
        return rubyArgs;
    }

    @Deprecated
    public static enum MethodType {
        CALLMETHOD,
        CALLSUPER,
        CALLMETHOD_NOARG,
        CALLMETHOD_WITHBLOCK,
        CALLSUPER_WITHBLOCK;

    }
}

