/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.windows;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Signal implements Constant
{
    SIGINT(2L),
    SIGILL(4L),
    SIGABRT(22L),
    SIGFPE(8L),
    SIGSEGV(11L),
    SIGTERM(15L),
    NSIG(23L);

    private final long value;
    public static final long MIN_VALUE = 2L;
    public static final long MAX_VALUE = 23L;

    private Signal(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Signal, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Signal, String> generateTable() {
            EnumMap<Signal, String> map2 = new EnumMap<Signal, String>(Signal.class);
            map2.put(SIGINT, "SIGINT");
            map2.put(SIGILL, "SIGILL");
            map2.put(SIGABRT, "SIGABRT");
            map2.put(SIGFPE, "SIGFPE");
            map2.put(SIGSEGV, "SIGSEGV");
            map2.put(SIGTERM, "SIGTERM");
            map2.put(NSIG, "NSIG");
            return map2;
        }
    }
}

