/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.fasterxml.aalto.impl;

import java.util.HashMap;

public abstract class CommonConfig {
    static final HashMap<String, Integer> sStdProperties = new HashMap(16);
    protected int _flags;
    protected int _flagMods;

    protected CommonConfig(int flags, int flagMods) {
        this._flags = flags;
        this._flagMods = flagMods;
    }

    public Object getProperty(String propName, boolean isMandatory) {
        Integer I = sStdProperties.get(propName);
        if (I != null) {
            switch (I) {
                case 1: {
                    return "aalto";
                }
                case 2: {
                    return "0.9";
                }
                case 3: {
                    return Boolean.FALSE;
                }
                case 4: {
                    return Boolean.FALSE;
                }
            }
        }
        if (isMandatory) {
            throw new IllegalArgumentException("Unrecognized property '" + propName + "'");
        }
        return null;
    }

    public boolean setProperty(String propName, Object value2) {
        Integer I = sStdProperties.get(propName);
        if (I != null) {
            return false;
        }
        throw new IllegalArgumentException("Unrecognized property '" + propName + "'");
    }

    protected final boolean hasFlag(int flagMask) {
        return (this._flags & flagMask) != 0;
    }

    protected final void setFlag(int flagMask, boolean state) {
        this._flags = state ? (this._flags |= flagMask) : (this._flags &= ~flagMask);
        this._flagMods |= flagMask;
    }

    static {
        sStdProperties.put("org.jetbrains.kotlin.org.codehaus.stax2.implName", 1);
        sStdProperties.put("org.jetbrains.kotlin.org.codehaus.stax2.implVersion", 2);
        sStdProperties.put("org.jetbrains.kotlin.org.codehaus.stax2.supportsXml11", 3);
        sStdProperties.put("org.jetbrains.kotlin.org.codehaus.stax2.supportXmlId", 4);
        sStdProperties.put("http://java.sun.com/xml/stream/properties/implementation-name", 1);
    }
}

