// Code generated by radius-dict-gen. DO NOT EDIT.

package microsoft

import (
	"crypto/rand"
	"errors"
	"net"
	"strconv"

	"layeh.com/radius"
	"layeh.com/radius/rfc2865"
)

const (
	_Microsoft_VendorID = 311
)

func _Microsoft_AddVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	var vsa radius.Attribute
	vendor := make(radius.Attribute, 2+len(attr))
	vendor[0] = typ
	vendor[1] = byte(len(vendor))
	copy(vendor[2:], attr)
	vsa, err = radius.NewVendorSpecific(_Microsoft_VendorID, vendor)
	if err != nil {
		return
	}
	p.Add(rfc2865.VendorSpecific_Type, vsa)
	return
}

func _Microsoft_GetsVendor(p *radius.Packet, typ byte) (values []radius.Attribute) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _Microsoft_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				values = append(values, vsa[2:int(vsaLen)])
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _Microsoft_LookupVendor(p *radius.Packet, typ byte) (attr radius.Attribute, ok bool) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _Microsoft_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				return vsa[2:int(vsaLen)], true
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _Microsoft_SetVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _Microsoft_VendorID {
			i++
			continue
		}
		for j := 0; len(vsa[j:]) >= 3; {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa[j:]) || vsaLen < 3 {
				i++
				break
			}
			if vsaTyp == typ {
				vsa = append(vsa[:j], vsa[j+int(vsaLen):]...)
			}
			j += int(vsaLen)
		}
		if len(vsa) > 0 {
			copy(avp.Attribute[4:], vsa)
			i++
		} else {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+i:]...)
		}
	}
	return _Microsoft_AddVendor(p, typ, attr)
}

func _Microsoft_DelVendor(p *radius.Packet, typ byte) {
vsaLoop:
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _Microsoft_VendorID {
			i++
			continue
		}
		offset := 0
		for len(vsa[offset:]) >= 3 {
			vsaTyp, vsaLen := vsa[offset], vsa[offset+1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				continue vsaLoop
			}
			if vsaTyp == typ {
				copy(vsa[offset:], vsa[offset+int(vsaLen):])
				vsa = vsa[:len(vsa)-int(vsaLen)]
			} else {
				offset += int(vsaLen)
			}
		}
		if offset == 0 {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+1:]...)
		} else {
			i++
		}
	}
	return
}

func MSCHAPResponse_Add(p *radius.Packet, value []byte) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 1, a)
}

func MSCHAPResponse_AddString(p *radius.Packet, value string) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 1, a)
}

func MSCHAPResponse_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPResponse_Lookup(p)
	return
}

func MSCHAPResponse_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPResponse_LookupString(p)
	return
}

func MSCHAPResponse_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 1) {
		i = radius.Bytes(attr)
		if err == nil && len(i) != 50 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPResponse_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 1) {
		i = radius.String(attr)
		if err == nil && len(i) != 50 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPResponse_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 1)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	if err == nil && len(value) != 50 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPResponse_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 1)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	if err == nil && len(value) != 50 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPResponse_Set(p *radius.Packet, value []byte) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 1, a)
}

func MSCHAPResponse_SetString(p *radius.Packet, value string) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 1, a)
}

func MSCHAPResponse_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 1)
}

func MSCHAPError_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 2, a)
}

func MSCHAPError_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 2, a)
}

func MSCHAPError_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPError_Lookup(p)
	return
}

func MSCHAPError_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPError_LookupString(p)
	return
}

func MSCHAPError_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 2) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPError_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 2) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPError_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 2)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSCHAPError_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 2)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSCHAPError_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 2, a)
}

func MSCHAPError_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 2, a)
}

func MSCHAPError_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 2)
}

func MSCHAPCPW1_Add(p *radius.Packet, value []byte) (err error) {
	if len(value) != 70 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 3, a)
}

func MSCHAPCPW1_AddString(p *radius.Packet, value string) (err error) {
	if len(value) != 70 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 3, a)
}

func MSCHAPCPW1_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPCPW1_Lookup(p)
	return
}

func MSCHAPCPW1_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPCPW1_LookupString(p)
	return
}

func MSCHAPCPW1_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 3) {
		i = radius.Bytes(attr)
		if err == nil && len(i) != 70 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPCPW1_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 3) {
		i = radius.String(attr)
		if err == nil && len(i) != 70 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPCPW1_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 3)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	if err == nil && len(value) != 70 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPCPW1_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 3)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	if err == nil && len(value) != 70 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPCPW1_Set(p *radius.Packet, value []byte) (err error) {
	if len(value) != 70 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 3, a)
}

func MSCHAPCPW1_SetString(p *radius.Packet, value string) (err error) {
	if len(value) != 70 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 3, a)
}

func MSCHAPCPW1_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 3)
}

func MSCHAPCPW2_Add(p *radius.Packet, value []byte) (err error) {
	if len(value) != 84 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 4, a)
}

func MSCHAPCPW2_AddString(p *radius.Packet, value string) (err error) {
	if len(value) != 84 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 4, a)
}

func MSCHAPCPW2_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPCPW2_Lookup(p)
	return
}

func MSCHAPCPW2_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPCPW2_LookupString(p)
	return
}

func MSCHAPCPW2_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 4) {
		i = radius.Bytes(attr)
		if err == nil && len(i) != 84 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPCPW2_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 4) {
		i = radius.String(attr)
		if err == nil && len(i) != 84 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPCPW2_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 4)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	if err == nil && len(value) != 84 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPCPW2_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 4)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	if err == nil && len(value) != 84 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPCPW2_Set(p *radius.Packet, value []byte) (err error) {
	if len(value) != 84 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 4, a)
}

func MSCHAPCPW2_SetString(p *radius.Packet, value string) (err error) {
	if len(value) != 84 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 4, a)
}

func MSCHAPCPW2_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 4)
}

func MSCHAPLMEncPW_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 5, a)
}

func MSCHAPLMEncPW_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 5, a)
}

func MSCHAPLMEncPW_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPLMEncPW_Lookup(p)
	return
}

func MSCHAPLMEncPW_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPLMEncPW_LookupString(p)
	return
}

func MSCHAPLMEncPW_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 5) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPLMEncPW_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 5) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPLMEncPW_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 5)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSCHAPLMEncPW_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 5)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSCHAPLMEncPW_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 5, a)
}

func MSCHAPLMEncPW_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 5, a)
}

func MSCHAPLMEncPW_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 5)
}

func MSCHAPNTEncPW_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 6, a)
}

func MSCHAPNTEncPW_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 6, a)
}

func MSCHAPNTEncPW_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPNTEncPW_Lookup(p)
	return
}

func MSCHAPNTEncPW_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPNTEncPW_LookupString(p)
	return
}

func MSCHAPNTEncPW_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 6) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPNTEncPW_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 6) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPNTEncPW_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 6)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSCHAPNTEncPW_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 6)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSCHAPNTEncPW_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 6, a)
}

func MSCHAPNTEncPW_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 6, a)
}

func MSCHAPNTEncPW_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 6)
}

type MSMPPEEncryptionPolicy uint32

const (
	MSMPPEEncryptionPolicy_Value_EncryptionAllowed  MSMPPEEncryptionPolicy = 1
	MSMPPEEncryptionPolicy_Value_EncryptionRequired MSMPPEEncryptionPolicy = 2
)

var MSMPPEEncryptionPolicy_Strings = map[MSMPPEEncryptionPolicy]string{
	MSMPPEEncryptionPolicy_Value_EncryptionAllowed:  "Encryption-Allowed",
	MSMPPEEncryptionPolicy_Value_EncryptionRequired: "Encryption-Required",
}

func (a MSMPPEEncryptionPolicy) String() string {
	if str, ok := MSMPPEEncryptionPolicy_Strings[a]; ok {
		return str
	}
	return "MSMPPEEncryptionPolicy(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSMPPEEncryptionPolicy_Add(p *radius.Packet, value MSMPPEEncryptionPolicy) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 7, a)
}

func MSMPPEEncryptionPolicy_Get(p *radius.Packet) (value MSMPPEEncryptionPolicy) {
	value, _ = MSMPPEEncryptionPolicy_Lookup(p)
	return
}

func MSMPPEEncryptionPolicy_Gets(p *radius.Packet) (values []MSMPPEEncryptionPolicy, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 7) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSMPPEEncryptionPolicy(i))
	}
	return
}

func MSMPPEEncryptionPolicy_Lookup(p *radius.Packet) (value MSMPPEEncryptionPolicy, err error) {
	a, ok := _Microsoft_LookupVendor(p, 7)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSMPPEEncryptionPolicy(i)
	return
}

func MSMPPEEncryptionPolicy_Set(p *radius.Packet, value MSMPPEEncryptionPolicy) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 7, a)
}

func MSMPPEEncryptionPolicy_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 7)
}

type MSMPPEEncryptionType uint32

var MSMPPEEncryptionType_Strings = map[MSMPPEEncryptionType]string{}

func (a MSMPPEEncryptionType) String() string {
	if str, ok := MSMPPEEncryptionType_Strings[a]; ok {
		return str
	}
	return "MSMPPEEncryptionType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSMPPEEncryptionType_Add(p *radius.Packet, value MSMPPEEncryptionType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 8, a)
}

func MSMPPEEncryptionType_Get(p *radius.Packet) (value MSMPPEEncryptionType) {
	value, _ = MSMPPEEncryptionType_Lookup(p)
	return
}

func MSMPPEEncryptionType_Gets(p *radius.Packet) (values []MSMPPEEncryptionType, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 8) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSMPPEEncryptionType(i))
	}
	return
}

func MSMPPEEncryptionType_Lookup(p *radius.Packet) (value MSMPPEEncryptionType, err error) {
	a, ok := _Microsoft_LookupVendor(p, 8)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSMPPEEncryptionType(i)
	return
}

func MSMPPEEncryptionType_Set(p *radius.Packet, value MSMPPEEncryptionType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 8, a)
}

func MSMPPEEncryptionType_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 8)
}

type MSMPPEEncryptionTypes uint32

const (
	MSMPPEEncryptionTypes_Value_RC440bitAllowed      MSMPPEEncryptionTypes = 1
	MSMPPEEncryptionTypes_Value_RC4128bitAllowed     MSMPPEEncryptionTypes = 2
	MSMPPEEncryptionTypes_Value_RC440or128BitAllowed MSMPPEEncryptionTypes = 6
)

var MSMPPEEncryptionTypes_Strings = map[MSMPPEEncryptionTypes]string{
	MSMPPEEncryptionTypes_Value_RC440bitAllowed:      "RC4-40bit-Allowed",
	MSMPPEEncryptionTypes_Value_RC4128bitAllowed:     "RC4-128bit-Allowed",
	MSMPPEEncryptionTypes_Value_RC440or128BitAllowed: "RC4-40or128-bit-Allowed",
}

func (a MSMPPEEncryptionTypes) String() string {
	if str, ok := MSMPPEEncryptionTypes_Strings[a]; ok {
		return str
	}
	return "MSMPPEEncryptionTypes(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSMPPEEncryptionTypes_Add(p *radius.Packet, value MSMPPEEncryptionTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 8, a)
}

func MSMPPEEncryptionTypes_Get(p *radius.Packet) (value MSMPPEEncryptionTypes) {
	value, _ = MSMPPEEncryptionTypes_Lookup(p)
	return
}

func MSMPPEEncryptionTypes_Gets(p *radius.Packet) (values []MSMPPEEncryptionTypes, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 8) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSMPPEEncryptionTypes(i))
	}
	return
}

func MSMPPEEncryptionTypes_Lookup(p *radius.Packet) (value MSMPPEEncryptionTypes, err error) {
	a, ok := _Microsoft_LookupVendor(p, 8)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSMPPEEncryptionTypes(i)
	return
}

func MSMPPEEncryptionTypes_Set(p *radius.Packet, value MSMPPEEncryptionTypes) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 8, a)
}

func MSMPPEEncryptionTypes_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 8)
}

type MSRASVendor uint32

var MSRASVendor_Strings = map[MSRASVendor]string{}

func (a MSRASVendor) String() string {
	if str, ok := MSRASVendor_Strings[a]; ok {
		return str
	}
	return "MSRASVendor(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSRASVendor_Add(p *radius.Packet, value MSRASVendor) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 9, a)
}

func MSRASVendor_Get(p *radius.Packet) (value MSRASVendor) {
	value, _ = MSRASVendor_Lookup(p)
	return
}

func MSRASVendor_Gets(p *radius.Packet) (values []MSRASVendor, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 9) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSRASVendor(i))
	}
	return
}

func MSRASVendor_Lookup(p *radius.Packet) (value MSRASVendor, err error) {
	a, ok := _Microsoft_LookupVendor(p, 9)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSRASVendor(i)
	return
}

func MSRASVendor_Set(p *radius.Packet, value MSRASVendor) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 9, a)
}

func MSRASVendor_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 9)
}

func MSCHAPDomain_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 10, a)
}

func MSCHAPDomain_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 10, a)
}

func MSCHAPDomain_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPDomain_Lookup(p)
	return
}

func MSCHAPDomain_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPDomain_LookupString(p)
	return
}

func MSCHAPDomain_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 10) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPDomain_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 10) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPDomain_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 10)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSCHAPDomain_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 10)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSCHAPDomain_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 10, a)
}

func MSCHAPDomain_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 10, a)
}

func MSCHAPDomain_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 10)
}

func MSCHAPChallenge_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 11, a)
}

func MSCHAPChallenge_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 11, a)
}

func MSCHAPChallenge_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPChallenge_Lookup(p)
	return
}

func MSCHAPChallenge_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPChallenge_LookupString(p)
	return
}

func MSCHAPChallenge_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 11) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPChallenge_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 11) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPChallenge_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 11)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSCHAPChallenge_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 11)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSCHAPChallenge_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 11, a)
}

func MSCHAPChallenge_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 11, a)
}

func MSCHAPChallenge_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 11)
}

func MSCHAPMPPEKeys_Add(p *radius.Packet, value []byte) (err error) {
	if len(value) != 24 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewUserPassword(value, p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 12, a)
}

func MSCHAPMPPEKeys_AddString(p *radius.Packet, value string) (err error) {
	if len(value) != 24 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewUserPassword([]byte(value), p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 12, a)
}

func MSCHAPMPPEKeys_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAPMPPEKeys_Lookup(p)
	return
}

func MSCHAPMPPEKeys_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAPMPPEKeys_LookupString(p)
	return
}

func MSCHAPMPPEKeys_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 12) {
		i, err = radius.UserPassword(attr, p.Secret, p.Authenticator[:])
		if err == nil && len(i) != 24 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPMPPEKeys_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 12) {
		var up []byte
		up, err = radius.UserPassword(attr, p.Secret, p.Authenticator[:])
		if err == nil {
			i = string(up)
		}
		if err == nil && len(i) != 24 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAPMPPEKeys_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 12)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.UserPassword(a, p.Secret, p.Authenticator[:])
	if err == nil && len(value) != 24 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPMPPEKeys_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 12)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var b []byte
	b, err = radius.UserPassword(a, p.Secret, p.Authenticator[:])
	if err == nil {
		value = string(b)
	}
	if err == nil && len(value) != 24 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAPMPPEKeys_Set(p *radius.Packet, value []byte) (err error) {
	if len(value) != 24 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewUserPassword(value, p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 12, a)
}

func MSCHAPMPPEKeys_SetString(p *radius.Packet, value string) (err error) {
	if len(value) != 24 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewUserPassword([]byte(value), p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 12, a)
}

func MSCHAPMPPEKeys_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 12)
}

type MSBAPUsage uint32

const (
	MSBAPUsage_Value_NotAllowed MSBAPUsage = 0
	MSBAPUsage_Value_Allowed    MSBAPUsage = 1
	MSBAPUsage_Value_Required   MSBAPUsage = 2
)

var MSBAPUsage_Strings = map[MSBAPUsage]string{
	MSBAPUsage_Value_NotAllowed: "Not-Allowed",
	MSBAPUsage_Value_Allowed:    "Allowed",
	MSBAPUsage_Value_Required:   "Required",
}

func (a MSBAPUsage) String() string {
	if str, ok := MSBAPUsage_Strings[a]; ok {
		return str
	}
	return "MSBAPUsage(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSBAPUsage_Add(p *radius.Packet, value MSBAPUsage) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 13, a)
}

func MSBAPUsage_Get(p *radius.Packet) (value MSBAPUsage) {
	value, _ = MSBAPUsage_Lookup(p)
	return
}

func MSBAPUsage_Gets(p *radius.Packet) (values []MSBAPUsage, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 13) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSBAPUsage(i))
	}
	return
}

func MSBAPUsage_Lookup(p *radius.Packet) (value MSBAPUsage, err error) {
	a, ok := _Microsoft_LookupVendor(p, 13)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSBAPUsage(i)
	return
}

func MSBAPUsage_Set(p *radius.Packet, value MSBAPUsage) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 13, a)
}

func MSBAPUsage_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 13)
}

type MSLinkUtilizationThreshold uint32

var MSLinkUtilizationThreshold_Strings = map[MSLinkUtilizationThreshold]string{}

func (a MSLinkUtilizationThreshold) String() string {
	if str, ok := MSLinkUtilizationThreshold_Strings[a]; ok {
		return str
	}
	return "MSLinkUtilizationThreshold(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSLinkUtilizationThreshold_Add(p *radius.Packet, value MSLinkUtilizationThreshold) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 14, a)
}

func MSLinkUtilizationThreshold_Get(p *radius.Packet) (value MSLinkUtilizationThreshold) {
	value, _ = MSLinkUtilizationThreshold_Lookup(p)
	return
}

func MSLinkUtilizationThreshold_Gets(p *radius.Packet) (values []MSLinkUtilizationThreshold, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 14) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSLinkUtilizationThreshold(i))
	}
	return
}

func MSLinkUtilizationThreshold_Lookup(p *radius.Packet) (value MSLinkUtilizationThreshold, err error) {
	a, ok := _Microsoft_LookupVendor(p, 14)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSLinkUtilizationThreshold(i)
	return
}

func MSLinkUtilizationThreshold_Set(p *radius.Packet, value MSLinkUtilizationThreshold) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 14, a)
}

func MSLinkUtilizationThreshold_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 14)
}

type MSLinkDropTimeLimit uint32

var MSLinkDropTimeLimit_Strings = map[MSLinkDropTimeLimit]string{}

func (a MSLinkDropTimeLimit) String() string {
	if str, ok := MSLinkDropTimeLimit_Strings[a]; ok {
		return str
	}
	return "MSLinkDropTimeLimit(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSLinkDropTimeLimit_Add(p *radius.Packet, value MSLinkDropTimeLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 15, a)
}

func MSLinkDropTimeLimit_Get(p *radius.Packet) (value MSLinkDropTimeLimit) {
	value, _ = MSLinkDropTimeLimit_Lookup(p)
	return
}

func MSLinkDropTimeLimit_Gets(p *radius.Packet) (values []MSLinkDropTimeLimit, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 15) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSLinkDropTimeLimit(i))
	}
	return
}

func MSLinkDropTimeLimit_Lookup(p *radius.Packet) (value MSLinkDropTimeLimit, err error) {
	a, ok := _Microsoft_LookupVendor(p, 15)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSLinkDropTimeLimit(i)
	return
}

func MSLinkDropTimeLimit_Set(p *radius.Packet, value MSLinkDropTimeLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 15, a)
}

func MSLinkDropTimeLimit_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 15)
}

func MSMPPESendKey_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword(value, salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 16, a)
}

func MSMPPESendKey_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword([]byte(value), salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 16, a)
}

func MSMPPESendKey_Get(p, q *radius.Packet) (value []byte) {
	value, _ = MSMPPESendKey_Lookup(p, q)
	return
}

func MSMPPESendKey_GetString(p, q *radius.Packet) (value string) {
	value, _ = MSMPPESendKey_LookupString(p, q)
	return
}

func MSMPPESendKey_Gets(p, q *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 16) {
		i, _, err = radius.TunnelPassword(attr, p.Secret, q.Authenticator[:])
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSMPPESendKey_GetStrings(p, q *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 16) {
		var up []byte
		up, _, err = radius.TunnelPassword(attr, p.Secret, q.Authenticator[:])
		if err == nil {
			i = string(up)
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSMPPESendKey_Lookup(p, q *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 16)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, _, err = radius.TunnelPassword(a, p.Secret, q.Authenticator[:])
	return
}

func MSMPPESendKey_LookupString(p, q *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 16)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var b []byte
	b, _, err = radius.TunnelPassword(a, p.Secret, q.Authenticator[:])
	if err == nil {
		value = string(b)
	}
	return
}

func MSMPPESendKey_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword(value, salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 16, a)
}

func MSMPPESendKey_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword([]byte(value), salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 16, a)
}

func MSMPPESendKey_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 16)
}

func MSMPPERecvKey_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword(value, salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 17, a)
}

func MSMPPERecvKey_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword([]byte(value), salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 17, a)
}

func MSMPPERecvKey_Get(p, q *radius.Packet) (value []byte) {
	value, _ = MSMPPERecvKey_Lookup(p, q)
	return
}

func MSMPPERecvKey_GetString(p, q *radius.Packet) (value string) {
	value, _ = MSMPPERecvKey_LookupString(p, q)
	return
}

func MSMPPERecvKey_Gets(p, q *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 17) {
		i, _, err = radius.TunnelPassword(attr, p.Secret, q.Authenticator[:])
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSMPPERecvKey_GetStrings(p, q *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 17) {
		var up []byte
		up, _, err = radius.TunnelPassword(attr, p.Secret, q.Authenticator[:])
		if err == nil {
			i = string(up)
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSMPPERecvKey_Lookup(p, q *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 17)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, _, err = radius.TunnelPassword(a, p.Secret, q.Authenticator[:])
	return
}

func MSMPPERecvKey_LookupString(p, q *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 17)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var b []byte
	b, _, err = radius.TunnelPassword(a, p.Secret, q.Authenticator[:])
	if err == nil {
		value = string(b)
	}
	return
}

func MSMPPERecvKey_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword(value, salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 17, a)
}

func MSMPPERecvKey_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword([]byte(value), salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 17, a)
}

func MSMPPERecvKey_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 17)
}

func MSRASVersion_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 18, a)
}

func MSRASVersion_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 18, a)
}

func MSRASVersion_Get(p *radius.Packet) (value []byte) {
	value, _ = MSRASVersion_Lookup(p)
	return
}

func MSRASVersion_GetString(p *radius.Packet) (value string) {
	value, _ = MSRASVersion_LookupString(p)
	return
}

func MSRASVersion_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 18) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASVersion_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 18) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASVersion_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 18)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSRASVersion_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 18)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSRASVersion_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 18, a)
}

func MSRASVersion_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 18, a)
}

func MSRASVersion_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 18)
}

func MSOldARAPPassword_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 19, a)
}

func MSOldARAPPassword_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 19, a)
}

func MSOldARAPPassword_Get(p *radius.Packet) (value []byte) {
	value, _ = MSOldARAPPassword_Lookup(p)
	return
}

func MSOldARAPPassword_GetString(p *radius.Packet) (value string) {
	value, _ = MSOldARAPPassword_LookupString(p)
	return
}

func MSOldARAPPassword_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 19) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSOldARAPPassword_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 19) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSOldARAPPassword_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 19)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSOldARAPPassword_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 19)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSOldARAPPassword_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 19, a)
}

func MSOldARAPPassword_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 19, a)
}

func MSOldARAPPassword_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 19)
}

func MSNewARAPPassword_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 20, a)
}

func MSNewARAPPassword_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 20, a)
}

func MSNewARAPPassword_Get(p *radius.Packet) (value []byte) {
	value, _ = MSNewARAPPassword_Lookup(p)
	return
}

func MSNewARAPPassword_GetString(p *radius.Packet) (value string) {
	value, _ = MSNewARAPPassword_LookupString(p)
	return
}

func MSNewARAPPassword_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 20) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSNewARAPPassword_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 20) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSNewARAPPassword_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 20)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSNewARAPPassword_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 20)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSNewARAPPassword_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 20, a)
}

func MSNewARAPPassword_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 20, a)
}

func MSNewARAPPassword_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 20)
}

type MSARAPPWChangeReason uint32

const (
	MSARAPPWChangeReason_Value_JustChangePassword          MSARAPPWChangeReason = 1
	MSARAPPWChangeReason_Value_ExpiredPassword             MSARAPPWChangeReason = 2
	MSARAPPWChangeReason_Value_AdminRequiresPasswordChange MSARAPPWChangeReason = 3
	MSARAPPWChangeReason_Value_PasswordTooShort            MSARAPPWChangeReason = 4
)

var MSARAPPWChangeReason_Strings = map[MSARAPPWChangeReason]string{
	MSARAPPWChangeReason_Value_JustChangePassword:          "Just-Change-Password",
	MSARAPPWChangeReason_Value_ExpiredPassword:             "Expired-Password",
	MSARAPPWChangeReason_Value_AdminRequiresPasswordChange: "Admin-Requires-Password-Change",
	MSARAPPWChangeReason_Value_PasswordTooShort:            "Password-Too-Short",
}

func (a MSARAPPWChangeReason) String() string {
	if str, ok := MSARAPPWChangeReason_Strings[a]; ok {
		return str
	}
	return "MSARAPPWChangeReason(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSARAPPWChangeReason_Add(p *radius.Packet, value MSARAPPWChangeReason) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 21, a)
}

func MSARAPPWChangeReason_Get(p *radius.Packet) (value MSARAPPWChangeReason) {
	value, _ = MSARAPPWChangeReason_Lookup(p)
	return
}

func MSARAPPWChangeReason_Gets(p *radius.Packet) (values []MSARAPPWChangeReason, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 21) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSARAPPWChangeReason(i))
	}
	return
}

func MSARAPPWChangeReason_Lookup(p *radius.Packet) (value MSARAPPWChangeReason, err error) {
	a, ok := _Microsoft_LookupVendor(p, 21)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSARAPPWChangeReason(i)
	return
}

func MSARAPPWChangeReason_Set(p *radius.Packet, value MSARAPPWChangeReason) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 21, a)
}

func MSARAPPWChangeReason_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 21)
}

func MSFilter_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 22, a)
}

func MSFilter_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 22, a)
}

func MSFilter_Get(p *radius.Packet) (value []byte) {
	value, _ = MSFilter_Lookup(p)
	return
}

func MSFilter_GetString(p *radius.Packet) (value string) {
	value, _ = MSFilter_LookupString(p)
	return
}

func MSFilter_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 22) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSFilter_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 22) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSFilter_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 22)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSFilter_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 22)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSFilter_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 22, a)
}

func MSFilter_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 22, a)
}

func MSFilter_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 22)
}

type MSAcctAuthType uint32

const (
	MSAcctAuthType_Value_PAP     MSAcctAuthType = 1
	MSAcctAuthType_Value_CHAP    MSAcctAuthType = 2
	MSAcctAuthType_Value_MSCHAP1 MSAcctAuthType = 3
	MSAcctAuthType_Value_MSCHAP2 MSAcctAuthType = 4
	MSAcctAuthType_Value_EAP     MSAcctAuthType = 5
)

var MSAcctAuthType_Strings = map[MSAcctAuthType]string{
	MSAcctAuthType_Value_PAP:     "PAP",
	MSAcctAuthType_Value_CHAP:    "CHAP",
	MSAcctAuthType_Value_MSCHAP1: "MS-CHAP-1",
	MSAcctAuthType_Value_MSCHAP2: "MS-CHAP-2",
	MSAcctAuthType_Value_EAP:     "EAP",
}

func (a MSAcctAuthType) String() string {
	if str, ok := MSAcctAuthType_Strings[a]; ok {
		return str
	}
	return "MSAcctAuthType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSAcctAuthType_Add(p *radius.Packet, value MSAcctAuthType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 23, a)
}

func MSAcctAuthType_Get(p *radius.Packet) (value MSAcctAuthType) {
	value, _ = MSAcctAuthType_Lookup(p)
	return
}

func MSAcctAuthType_Gets(p *radius.Packet) (values []MSAcctAuthType, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 23) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSAcctAuthType(i))
	}
	return
}

func MSAcctAuthType_Lookup(p *radius.Packet) (value MSAcctAuthType, err error) {
	a, ok := _Microsoft_LookupVendor(p, 23)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSAcctAuthType(i)
	return
}

func MSAcctAuthType_Set(p *radius.Packet, value MSAcctAuthType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 23, a)
}

func MSAcctAuthType_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 23)
}

type MSAcctEAPType uint32

const (
	MSAcctEAPType_Value_MD5              MSAcctEAPType = 4
	MSAcctEAPType_Value_OTP              MSAcctEAPType = 5
	MSAcctEAPType_Value_GenericTokenCard MSAcctEAPType = 6
	MSAcctEAPType_Value_TLS              MSAcctEAPType = 13
)

var MSAcctEAPType_Strings = map[MSAcctEAPType]string{
	MSAcctEAPType_Value_MD5:              "MD5",
	MSAcctEAPType_Value_OTP:              "OTP",
	MSAcctEAPType_Value_GenericTokenCard: "Generic-Token-Card",
	MSAcctEAPType_Value_TLS:              "TLS",
}

func (a MSAcctEAPType) String() string {
	if str, ok := MSAcctEAPType_Strings[a]; ok {
		return str
	}
	return "MSAcctEAPType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSAcctEAPType_Add(p *radius.Packet, value MSAcctEAPType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 24, a)
}

func MSAcctEAPType_Get(p *radius.Packet) (value MSAcctEAPType) {
	value, _ = MSAcctEAPType_Lookup(p)
	return
}

func MSAcctEAPType_Gets(p *radius.Packet) (values []MSAcctEAPType, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 24) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSAcctEAPType(i))
	}
	return
}

func MSAcctEAPType_Lookup(p *radius.Packet) (value MSAcctEAPType, err error) {
	a, ok := _Microsoft_LookupVendor(p, 24)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSAcctEAPType(i)
	return
}

func MSAcctEAPType_Set(p *radius.Packet, value MSAcctEAPType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 24, a)
}

func MSAcctEAPType_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 24)
}

func MSCHAP2Response_Add(p *radius.Packet, value []byte) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 25, a)
}

func MSCHAP2Response_AddString(p *radius.Packet, value string) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 25, a)
}

func MSCHAP2Response_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAP2Response_Lookup(p)
	return
}

func MSCHAP2Response_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAP2Response_LookupString(p)
	return
}

func MSCHAP2Response_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 25) {
		i = radius.Bytes(attr)
		if err == nil && len(i) != 50 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAP2Response_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 25) {
		i = radius.String(attr)
		if err == nil && len(i) != 50 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAP2Response_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 25)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	if err == nil && len(value) != 50 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAP2Response_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 25)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	if err == nil && len(value) != 50 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAP2Response_Set(p *radius.Packet, value []byte) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 25, a)
}

func MSCHAP2Response_SetString(p *radius.Packet, value string) (err error) {
	if len(value) != 50 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 25, a)
}

func MSCHAP2Response_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 25)
}

func MSCHAP2Success_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 26, a)
}

func MSCHAP2Success_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 26, a)
}

func MSCHAP2Success_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAP2Success_Lookup(p)
	return
}

func MSCHAP2Success_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAP2Success_LookupString(p)
	return
}

func MSCHAP2Success_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 26) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAP2Success_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 26) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAP2Success_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 26)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSCHAP2Success_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 26)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSCHAP2Success_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 26, a)
}

func MSCHAP2Success_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 26, a)
}

func MSCHAP2Success_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 26)
}

func MSCHAP2CPW_Add(p *radius.Packet, value []byte) (err error) {
	if len(value) != 68 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 27, a)
}

func MSCHAP2CPW_AddString(p *radius.Packet, value string) (err error) {
	if len(value) != 68 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 27, a)
}

func MSCHAP2CPW_Get(p *radius.Packet) (value []byte) {
	value, _ = MSCHAP2CPW_Lookup(p)
	return
}

func MSCHAP2CPW_GetString(p *radius.Packet) (value string) {
	value, _ = MSCHAP2CPW_LookupString(p)
	return
}

func MSCHAP2CPW_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 27) {
		i = radius.Bytes(attr)
		if err == nil && len(i) != 68 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAP2CPW_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 27) {
		i = radius.String(attr)
		if err == nil && len(i) != 68 {
			err = errors.New("invalid value length")
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSCHAP2CPW_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 27)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	if err == nil && len(value) != 68 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAP2CPW_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 27)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	if err == nil && len(value) != 68 {
		err = errors.New("invalid value length")
	}
	return
}

func MSCHAP2CPW_Set(p *radius.Packet, value []byte) (err error) {
	if len(value) != 68 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 27, a)
}

func MSCHAP2CPW_SetString(p *radius.Packet, value string) (err error) {
	if len(value) != 68 {
		err = errors.New("invalid value length")
		return
	}
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 27, a)
}

func MSCHAP2CPW_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 27)
}

func MSPrimaryDNSServer_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 28, a)
}

func MSPrimaryDNSServer_Get(p *radius.Packet) (value net.IP) {
	value, _ = MSPrimaryDNSServer_Lookup(p)
	return
}

func MSPrimaryDNSServer_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Microsoft_GetsVendor(p, 28) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSPrimaryDNSServer_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Microsoft_LookupVendor(p, 28)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func MSPrimaryDNSServer_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 28, a)
}

func MSPrimaryDNSServer_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 28)
}

func MSSecondaryDNSServer_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 29, a)
}

func MSSecondaryDNSServer_Get(p *radius.Packet) (value net.IP) {
	value, _ = MSSecondaryDNSServer_Lookup(p)
	return
}

func MSSecondaryDNSServer_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Microsoft_GetsVendor(p, 29) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSSecondaryDNSServer_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Microsoft_LookupVendor(p, 29)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func MSSecondaryDNSServer_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 29, a)
}

func MSSecondaryDNSServer_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 29)
}

func MSPrimaryNBNSServer_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 30, a)
}

func MSPrimaryNBNSServer_Get(p *radius.Packet) (value net.IP) {
	value, _ = MSPrimaryNBNSServer_Lookup(p)
	return
}

func MSPrimaryNBNSServer_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Microsoft_GetsVendor(p, 30) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSPrimaryNBNSServer_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Microsoft_LookupVendor(p, 30)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func MSPrimaryNBNSServer_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 30, a)
}

func MSPrimaryNBNSServer_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 30)
}

func MSSecondaryNBNSServer_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 31, a)
}

func MSSecondaryNBNSServer_Get(p *radius.Packet) (value net.IP) {
	value, _ = MSSecondaryNBNSServer_Lookup(p)
	return
}

func MSSecondaryNBNSServer_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Microsoft_GetsVendor(p, 31) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSSecondaryNBNSServer_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Microsoft_LookupVendor(p, 31)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func MSSecondaryNBNSServer_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 31, a)
}

func MSSecondaryNBNSServer_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 31)
}

func MSRASClientName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 34, a)
}

func MSRASClientName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 34, a)
}

func MSRASClientName_Get(p *radius.Packet) (value []byte) {
	value, _ = MSRASClientName_Lookup(p)
	return
}

func MSRASClientName_GetString(p *radius.Packet) (value string) {
	value, _ = MSRASClientName_LookupString(p)
	return
}

func MSRASClientName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 34) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASClientName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 34) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASClientName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 34)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSRASClientName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 34)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSRASClientName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 34, a)
}

func MSRASClientName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 34, a)
}

func MSRASClientName_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 34)
}

func MSRASClientVersion_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 35, a)
}

func MSRASClientVersion_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 35, a)
}

func MSRASClientVersion_Get(p *radius.Packet) (value []byte) {
	value, _ = MSRASClientVersion_Lookup(p)
	return
}

func MSRASClientVersion_GetString(p *radius.Packet) (value string) {
	value, _ = MSRASClientVersion_LookupString(p)
	return
}

func MSRASClientVersion_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 35) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASClientVersion_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 35) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASClientVersion_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 35)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSRASClientVersion_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 35)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSRASClientVersion_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 35, a)
}

func MSRASClientVersion_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 35, a)
}

func MSRASClientVersion_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 35)
}

func MSQuarantineIPFilter_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 36, a)
}

func MSQuarantineIPFilter_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 36, a)
}

func MSQuarantineIPFilter_Get(p *radius.Packet) (value []byte) {
	value, _ = MSQuarantineIPFilter_Lookup(p)
	return
}

func MSQuarantineIPFilter_GetString(p *radius.Packet) (value string) {
	value, _ = MSQuarantineIPFilter_LookupString(p)
	return
}

func MSQuarantineIPFilter_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 36) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSQuarantineIPFilter_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 36) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSQuarantineIPFilter_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 36)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSQuarantineIPFilter_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 36)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSQuarantineIPFilter_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 36, a)
}

func MSQuarantineIPFilter_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 36, a)
}

func MSQuarantineIPFilter_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 36)
}

type MSQuarantineSessionTimeout uint32

var MSQuarantineSessionTimeout_Strings = map[MSQuarantineSessionTimeout]string{}

func (a MSQuarantineSessionTimeout) String() string {
	if str, ok := MSQuarantineSessionTimeout_Strings[a]; ok {
		return str
	}
	return "MSQuarantineSessionTimeout(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSQuarantineSessionTimeout_Add(p *radius.Packet, value MSQuarantineSessionTimeout) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 37, a)
}

func MSQuarantineSessionTimeout_Get(p *radius.Packet) (value MSQuarantineSessionTimeout) {
	value, _ = MSQuarantineSessionTimeout_Lookup(p)
	return
}

func MSQuarantineSessionTimeout_Gets(p *radius.Packet) (values []MSQuarantineSessionTimeout, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 37) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSQuarantineSessionTimeout(i))
	}
	return
}

func MSQuarantineSessionTimeout_Lookup(p *radius.Packet) (value MSQuarantineSessionTimeout, err error) {
	a, ok := _Microsoft_LookupVendor(p, 37)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSQuarantineSessionTimeout(i)
	return
}

func MSQuarantineSessionTimeout_Set(p *radius.Packet, value MSQuarantineSessionTimeout) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 37, a)
}

func MSQuarantineSessionTimeout_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 37)
}

func MSUserSecurityIdentity_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 40, a)
}

func MSUserSecurityIdentity_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 40, a)
}

func MSUserSecurityIdentity_Get(p *radius.Packet) (value []byte) {
	value, _ = MSUserSecurityIdentity_Lookup(p)
	return
}

func MSUserSecurityIdentity_GetString(p *radius.Packet) (value string) {
	value, _ = MSUserSecurityIdentity_LookupString(p)
	return
}

func MSUserSecurityIdentity_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 40) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSUserSecurityIdentity_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 40) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSUserSecurityIdentity_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 40)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSUserSecurityIdentity_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 40)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSUserSecurityIdentity_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 40, a)
}

func MSUserSecurityIdentity_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 40, a)
}

func MSUserSecurityIdentity_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 40)
}

type MSIdentityType uint32

const (
	MSIdentityType_Value_MachineHealthCheck      MSIdentityType = 1
	MSIdentityType_Value_IgnoreUserLookupFailure MSIdentityType = 2
)

var MSIdentityType_Strings = map[MSIdentityType]string{
	MSIdentityType_Value_MachineHealthCheck:      "Machine-Health-Check",
	MSIdentityType_Value_IgnoreUserLookupFailure: "Ignore-User-Lookup-Failure",
}

func (a MSIdentityType) String() string {
	if str, ok := MSIdentityType_Strings[a]; ok {
		return str
	}
	return "MSIdentityType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSIdentityType_Add(p *radius.Packet, value MSIdentityType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 41, a)
}

func MSIdentityType_Get(p *radius.Packet) (value MSIdentityType) {
	value, _ = MSIdentityType_Lookup(p)
	return
}

func MSIdentityType_Gets(p *radius.Packet) (values []MSIdentityType, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 41) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSIdentityType(i))
	}
	return
}

func MSIdentityType_Lookup(p *radius.Packet) (value MSIdentityType, err error) {
	a, ok := _Microsoft_LookupVendor(p, 41)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSIdentityType(i)
	return
}

func MSIdentityType_Set(p *radius.Packet, value MSIdentityType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 41, a)
}

func MSIdentityType_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 41)
}

func MSServiceClass_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 42, a)
}

func MSServiceClass_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 42, a)
}

func MSServiceClass_Get(p *radius.Packet) (value []byte) {
	value, _ = MSServiceClass_Lookup(p)
	return
}

func MSServiceClass_GetString(p *radius.Packet) (value string) {
	value, _ = MSServiceClass_LookupString(p)
	return
}

func MSServiceClass_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 42) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSServiceClass_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 42) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSServiceClass_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 42)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSServiceClass_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 42)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSServiceClass_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 42, a)
}

func MSServiceClass_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 42, a)
}

func MSServiceClass_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 42)
}

func MSQuarantineUserClass_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 44, a)
}

func MSQuarantineUserClass_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 44, a)
}

func MSQuarantineUserClass_Get(p *radius.Packet) (value []byte) {
	value, _ = MSQuarantineUserClass_Lookup(p)
	return
}

func MSQuarantineUserClass_GetString(p *radius.Packet) (value string) {
	value, _ = MSQuarantineUserClass_LookupString(p)
	return
}

func MSQuarantineUserClass_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 44) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSQuarantineUserClass_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 44) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSQuarantineUserClass_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 44)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSQuarantineUserClass_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 44)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSQuarantineUserClass_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 44, a)
}

func MSQuarantineUserClass_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 44, a)
}

func MSQuarantineUserClass_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 44)
}

type MSQuarantineState uint32

const (
	MSQuarantineState_Value_FullAccess MSQuarantineState = 0
	MSQuarantineState_Value_Quarantine MSQuarantineState = 1
	MSQuarantineState_Value_Probation  MSQuarantineState = 2
)

var MSQuarantineState_Strings = map[MSQuarantineState]string{
	MSQuarantineState_Value_FullAccess: "Full-Access",
	MSQuarantineState_Value_Quarantine: "Quarantine",
	MSQuarantineState_Value_Probation:  "Probation",
}

func (a MSQuarantineState) String() string {
	if str, ok := MSQuarantineState_Strings[a]; ok {
		return str
	}
	return "MSQuarantineState(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSQuarantineState_Add(p *radius.Packet, value MSQuarantineState) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 45, a)
}

func MSQuarantineState_Get(p *radius.Packet) (value MSQuarantineState) {
	value, _ = MSQuarantineState_Lookup(p)
	return
}

func MSQuarantineState_Gets(p *radius.Packet) (values []MSQuarantineState, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 45) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSQuarantineState(i))
	}
	return
}

func MSQuarantineState_Lookup(p *radius.Packet) (value MSQuarantineState, err error) {
	a, ok := _Microsoft_LookupVendor(p, 45)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSQuarantineState(i)
	return
}

func MSQuarantineState_Set(p *radius.Packet, value MSQuarantineState) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 45, a)
}

func MSQuarantineState_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 45)
}

type MSQuarantineGraceTime uint32

var MSQuarantineGraceTime_Strings = map[MSQuarantineGraceTime]string{}

func (a MSQuarantineGraceTime) String() string {
	if str, ok := MSQuarantineGraceTime_Strings[a]; ok {
		return str
	}
	return "MSQuarantineGraceTime(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSQuarantineGraceTime_Add(p *radius.Packet, value MSQuarantineGraceTime) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 46, a)
}

func MSQuarantineGraceTime_Get(p *radius.Packet) (value MSQuarantineGraceTime) {
	value, _ = MSQuarantineGraceTime_Lookup(p)
	return
}

func MSQuarantineGraceTime_Gets(p *radius.Packet) (values []MSQuarantineGraceTime, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 46) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSQuarantineGraceTime(i))
	}
	return
}

func MSQuarantineGraceTime_Lookup(p *radius.Packet) (value MSQuarantineGraceTime, err error) {
	a, ok := _Microsoft_LookupVendor(p, 46)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSQuarantineGraceTime(i)
	return
}

func MSQuarantineGraceTime_Set(p *radius.Packet, value MSQuarantineGraceTime) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 46, a)
}

func MSQuarantineGraceTime_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 46)
}

type MSNetworkAccessServerType uint32

const (
	MSNetworkAccessServerType_Value_Unspecified           MSNetworkAccessServerType = 0
	MSNetworkAccessServerType_Value_TerminalServerGateway MSNetworkAccessServerType = 1
	MSNetworkAccessServerType_Value_RemoteAccessServer    MSNetworkAccessServerType = 2
	MSNetworkAccessServerType_Value_DHCPServer            MSNetworkAccessServerType = 3
	MSNetworkAccessServerType_Value_WirelessAccessPoint   MSNetworkAccessServerType = 4
	MSNetworkAccessServerType_Value_HRA                   MSNetworkAccessServerType = 5
	MSNetworkAccessServerType_Value_HCAPServer            MSNetworkAccessServerType = 6
)

var MSNetworkAccessServerType_Strings = map[MSNetworkAccessServerType]string{
	MSNetworkAccessServerType_Value_Unspecified:           "Unspecified",
	MSNetworkAccessServerType_Value_TerminalServerGateway: "Terminal-Server-Gateway",
	MSNetworkAccessServerType_Value_RemoteAccessServer:    "Remote-Access-Server",
	MSNetworkAccessServerType_Value_DHCPServer:            "DHCP-Server",
	MSNetworkAccessServerType_Value_WirelessAccessPoint:   "Wireless-Access-Point",
	MSNetworkAccessServerType_Value_HRA:                   "HRA",
	MSNetworkAccessServerType_Value_HCAPServer:            "HCAP-Server",
}

func (a MSNetworkAccessServerType) String() string {
	if str, ok := MSNetworkAccessServerType_Strings[a]; ok {
		return str
	}
	return "MSNetworkAccessServerType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSNetworkAccessServerType_Add(p *radius.Packet, value MSNetworkAccessServerType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 47, a)
}

func MSNetworkAccessServerType_Get(p *radius.Packet) (value MSNetworkAccessServerType) {
	value, _ = MSNetworkAccessServerType_Lookup(p)
	return
}

func MSNetworkAccessServerType_Gets(p *radius.Packet) (values []MSNetworkAccessServerType, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 47) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSNetworkAccessServerType(i))
	}
	return
}

func MSNetworkAccessServerType_Lookup(p *radius.Packet) (value MSNetworkAccessServerType, err error) {
	a, ok := _Microsoft_LookupVendor(p, 47)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSNetworkAccessServerType(i)
	return
}

func MSNetworkAccessServerType_Set(p *radius.Packet, value MSNetworkAccessServerType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 47, a)
}

func MSNetworkAccessServerType_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 47)
}

type MSAFWZone uint32

const (
	MSAFWZone_Value_MSAFWZoneBoundaryPolicy    MSAFWZone = 1
	MSAFWZone_Value_MSAFWZoneUnprotectedPolicy MSAFWZone = 2
	MSAFWZone_Value_MSAFWZoneProtectedPolicy   MSAFWZone = 3
)

var MSAFWZone_Strings = map[MSAFWZone]string{
	MSAFWZone_Value_MSAFWZoneBoundaryPolicy:    "MS-AFW-Zone-Boundary-Policy",
	MSAFWZone_Value_MSAFWZoneUnprotectedPolicy: "MS-AFW-Zone-Unprotected-Policy",
	MSAFWZone_Value_MSAFWZoneProtectedPolicy:   "MS-AFW-Zone-Protected-Policy",
}

func (a MSAFWZone) String() string {
	if str, ok := MSAFWZone_Strings[a]; ok {
		return str
	}
	return "MSAFWZone(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSAFWZone_Add(p *radius.Packet, value MSAFWZone) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 48, a)
}

func MSAFWZone_Get(p *radius.Packet) (value MSAFWZone) {
	value, _ = MSAFWZone_Lookup(p)
	return
}

func MSAFWZone_Gets(p *radius.Packet) (values []MSAFWZone, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 48) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSAFWZone(i))
	}
	return
}

func MSAFWZone_Lookup(p *radius.Packet) (value MSAFWZone, err error) {
	a, ok := _Microsoft_LookupVendor(p, 48)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSAFWZone(i)
	return
}

func MSAFWZone_Set(p *radius.Packet, value MSAFWZone) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 48, a)
}

func MSAFWZone_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 48)
}

type MSAFWProtectionLevel uint32

const (
	MSAFWProtectionLevel_Value_HECPResponseSignOnly       MSAFWProtectionLevel = 1
	MSAFWProtectionLevel_Value_HECPResponseSignAndEncrypt MSAFWProtectionLevel = 2
)

var MSAFWProtectionLevel_Strings = map[MSAFWProtectionLevel]string{
	MSAFWProtectionLevel_Value_HECPResponseSignOnly:       "HECP-Response-Sign-Only",
	MSAFWProtectionLevel_Value_HECPResponseSignAndEncrypt: "HECP-Response-Sign-And-Encrypt",
}

func (a MSAFWProtectionLevel) String() string {
	if str, ok := MSAFWProtectionLevel_Strings[a]; ok {
		return str
	}
	return "MSAFWProtectionLevel(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSAFWProtectionLevel_Add(p *radius.Packet, value MSAFWProtectionLevel) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 49, a)
}

func MSAFWProtectionLevel_Get(p *radius.Packet) (value MSAFWProtectionLevel) {
	value, _ = MSAFWProtectionLevel_Lookup(p)
	return
}

func MSAFWProtectionLevel_Gets(p *radius.Packet) (values []MSAFWProtectionLevel, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 49) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSAFWProtectionLevel(i))
	}
	return
}

func MSAFWProtectionLevel_Lookup(p *radius.Packet) (value MSAFWProtectionLevel, err error) {
	a, ok := _Microsoft_LookupVendor(p, 49)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSAFWProtectionLevel(i)
	return
}

func MSAFWProtectionLevel_Set(p *radius.Packet, value MSAFWProtectionLevel) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 49, a)
}

func MSAFWProtectionLevel_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 49)
}

func MSMachineName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 50, a)
}

func MSMachineName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 50, a)
}

func MSMachineName_Get(p *radius.Packet) (value []byte) {
	value, _ = MSMachineName_Lookup(p)
	return
}

func MSMachineName_GetString(p *radius.Packet) (value string) {
	value, _ = MSMachineName_LookupString(p)
	return
}

func MSMachineName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 50) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSMachineName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 50) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSMachineName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 50)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSMachineName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 50)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSMachineName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 50, a)
}

func MSMachineName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 50, a)
}

func MSMachineName_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 50)
}

func MSIPv6Filter_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 51, a)
}

func MSIPv6Filter_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 51, a)
}

func MSIPv6Filter_Get(p *radius.Packet) (value []byte) {
	value, _ = MSIPv6Filter_Lookup(p)
	return
}

func MSIPv6Filter_GetString(p *radius.Packet) (value string) {
	value, _ = MSIPv6Filter_LookupString(p)
	return
}

func MSIPv6Filter_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 51) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSIPv6Filter_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 51) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSIPv6Filter_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 51)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSIPv6Filter_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 51)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSIPv6Filter_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 51, a)
}

func MSIPv6Filter_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 51, a)
}

func MSIPv6Filter_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 51)
}

func MSIPv4RemediationServers_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 52, a)
}

func MSIPv4RemediationServers_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 52, a)
}

func MSIPv4RemediationServers_Get(p *radius.Packet) (value []byte) {
	value, _ = MSIPv4RemediationServers_Lookup(p)
	return
}

func MSIPv4RemediationServers_GetString(p *radius.Packet) (value string) {
	value, _ = MSIPv4RemediationServers_LookupString(p)
	return
}

func MSIPv4RemediationServers_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 52) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSIPv4RemediationServers_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 52) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSIPv4RemediationServers_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 52)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSIPv4RemediationServers_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 52)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSIPv4RemediationServers_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 52, a)
}

func MSIPv4RemediationServers_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 52, a)
}

func MSIPv4RemediationServers_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 52)
}

func MSIPv6RemediationServers_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 53, a)
}

func MSIPv6RemediationServers_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 53, a)
}

func MSIPv6RemediationServers_Get(p *radius.Packet) (value []byte) {
	value, _ = MSIPv6RemediationServers_Lookup(p)
	return
}

func MSIPv6RemediationServers_GetString(p *radius.Packet) (value string) {
	value, _ = MSIPv6RemediationServers_LookupString(p)
	return
}

func MSIPv6RemediationServers_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 53) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSIPv6RemediationServers_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 53) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSIPv6RemediationServers_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 53)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSIPv6RemediationServers_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 53)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSIPv6RemediationServers_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 53, a)
}

func MSIPv6RemediationServers_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 53, a)
}

func MSIPv6RemediationServers_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 53)
}

type MSRNAPNotQuarantineCapable uint32

const (
	MSRNAPNotQuarantineCapable_Value_SoHSent    MSRNAPNotQuarantineCapable = 0
	MSRNAPNotQuarantineCapable_Value_SoHNotSent MSRNAPNotQuarantineCapable = 1
)

var MSRNAPNotQuarantineCapable_Strings = map[MSRNAPNotQuarantineCapable]string{
	MSRNAPNotQuarantineCapable_Value_SoHSent:    "SoH-Sent",
	MSRNAPNotQuarantineCapable_Value_SoHNotSent: "SoH-Not-Sent",
}

func (a MSRNAPNotQuarantineCapable) String() string {
	if str, ok := MSRNAPNotQuarantineCapable_Strings[a]; ok {
		return str
	}
	return "MSRNAPNotQuarantineCapable(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSRNAPNotQuarantineCapable_Add(p *radius.Packet, value MSRNAPNotQuarantineCapable) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 54, a)
}

func MSRNAPNotQuarantineCapable_Get(p *radius.Packet) (value MSRNAPNotQuarantineCapable) {
	value, _ = MSRNAPNotQuarantineCapable_Lookup(p)
	return
}

func MSRNAPNotQuarantineCapable_Gets(p *radius.Packet) (values []MSRNAPNotQuarantineCapable, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 54) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSRNAPNotQuarantineCapable(i))
	}
	return
}

func MSRNAPNotQuarantineCapable_Lookup(p *radius.Packet) (value MSRNAPNotQuarantineCapable, err error) {
	a, ok := _Microsoft_LookupVendor(p, 54)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSRNAPNotQuarantineCapable(i)
	return
}

func MSRNAPNotQuarantineCapable_Set(p *radius.Packet, value MSRNAPNotQuarantineCapable) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 54, a)
}

func MSRNAPNotQuarantineCapable_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 54)
}

func MSQuarantineSOH_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 55, a)
}

func MSQuarantineSOH_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 55, a)
}

func MSQuarantineSOH_Get(p *radius.Packet) (value []byte) {
	value, _ = MSQuarantineSOH_Lookup(p)
	return
}

func MSQuarantineSOH_GetString(p *radius.Packet) (value string) {
	value, _ = MSQuarantineSOH_LookupString(p)
	return
}

func MSQuarantineSOH_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 55) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSQuarantineSOH_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 55) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSQuarantineSOH_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 55)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSQuarantineSOH_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 55)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSQuarantineSOH_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 55, a)
}

func MSQuarantineSOH_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 55, a)
}

func MSQuarantineSOH_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 55)
}

func MSRASCorrelation_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 56, a)
}

func MSRASCorrelation_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 56, a)
}

func MSRASCorrelation_Get(p *radius.Packet) (value []byte) {
	value, _ = MSRASCorrelation_Lookup(p)
	return
}

func MSRASCorrelation_GetString(p *radius.Packet) (value string) {
	value, _ = MSRASCorrelation_LookupString(p)
	return
}

func MSRASCorrelation_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 56) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASCorrelation_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 56) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSRASCorrelation_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 56)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSRASCorrelation_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 56)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSRASCorrelation_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 56, a)
}

func MSRASCorrelation_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 56, a)
}

func MSRASCorrelation_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 56)
}

type MSExtendedQuarantineState uint32

const (
	MSExtendedQuarantineState_Value_Transition MSExtendedQuarantineState = 1
	MSExtendedQuarantineState_Value_Infected   MSExtendedQuarantineState = 2
	MSExtendedQuarantineState_Value_Unknown    MSExtendedQuarantineState = 3
	MSExtendedQuarantineState_Value_NoData     MSExtendedQuarantineState = 4
)

var MSExtendedQuarantineState_Strings = map[MSExtendedQuarantineState]string{
	MSExtendedQuarantineState_Value_Transition: "Transition",
	MSExtendedQuarantineState_Value_Infected:   "Infected",
	MSExtendedQuarantineState_Value_Unknown:    "Unknown",
	MSExtendedQuarantineState_Value_NoData:     "No-Data",
}

func (a MSExtendedQuarantineState) String() string {
	if str, ok := MSExtendedQuarantineState_Strings[a]; ok {
		return str
	}
	return "MSExtendedQuarantineState(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSExtendedQuarantineState_Add(p *radius.Packet, value MSExtendedQuarantineState) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 57, a)
}

func MSExtendedQuarantineState_Get(p *radius.Packet) (value MSExtendedQuarantineState) {
	value, _ = MSExtendedQuarantineState_Lookup(p)
	return
}

func MSExtendedQuarantineState_Gets(p *radius.Packet) (values []MSExtendedQuarantineState, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 57) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSExtendedQuarantineState(i))
	}
	return
}

func MSExtendedQuarantineState_Lookup(p *radius.Packet) (value MSExtendedQuarantineState, err error) {
	a, ok := _Microsoft_LookupVendor(p, 57)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSExtendedQuarantineState(i)
	return
}

func MSExtendedQuarantineState_Set(p *radius.Packet, value MSExtendedQuarantineState) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 57, a)
}

func MSExtendedQuarantineState_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 57)
}

func MSHCAPUserGroups_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 58, a)
}

func MSHCAPUserGroups_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 58, a)
}

func MSHCAPUserGroups_Get(p *radius.Packet) (value []byte) {
	value, _ = MSHCAPUserGroups_Lookup(p)
	return
}

func MSHCAPUserGroups_GetString(p *radius.Packet) (value string) {
	value, _ = MSHCAPUserGroups_LookupString(p)
	return
}

func MSHCAPUserGroups_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 58) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSHCAPUserGroups_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 58) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSHCAPUserGroups_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 58)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSHCAPUserGroups_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 58)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSHCAPUserGroups_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 58, a)
}

func MSHCAPUserGroups_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 58, a)
}

func MSHCAPUserGroups_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 58)
}

func MSHCAPLocationGroupName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 59, a)
}

func MSHCAPLocationGroupName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 59, a)
}

func MSHCAPLocationGroupName_Get(p *radius.Packet) (value []byte) {
	value, _ = MSHCAPLocationGroupName_Lookup(p)
	return
}

func MSHCAPLocationGroupName_GetString(p *radius.Packet) (value string) {
	value, _ = MSHCAPLocationGroupName_LookupString(p)
	return
}

func MSHCAPLocationGroupName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 59) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSHCAPLocationGroupName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 59) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSHCAPLocationGroupName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 59)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSHCAPLocationGroupName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 59)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSHCAPLocationGroupName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 59, a)
}

func MSHCAPLocationGroupName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 59, a)
}

func MSHCAPLocationGroupName_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 59)
}

func MSHCAPUserName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 60, a)
}

func MSHCAPUserName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 60, a)
}

func MSHCAPUserName_Get(p *radius.Packet) (value []byte) {
	value, _ = MSHCAPUserName_Lookup(p)
	return
}

func MSHCAPUserName_GetString(p *radius.Packet) (value string) {
	value, _ = MSHCAPUserName_LookupString(p)
	return
}

func MSHCAPUserName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Microsoft_GetsVendor(p, 60) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSHCAPUserName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Microsoft_GetsVendor(p, 60) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSHCAPUserName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Microsoft_LookupVendor(p, 60)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MSHCAPUserName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Microsoft_LookupVendor(p, 60)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MSHCAPUserName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 60, a)
}

func MSHCAPUserName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 60, a)
}

func MSHCAPUserName_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 60)
}

func MSUserIPv4Address_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 61, a)
}

func MSUserIPv4Address_Get(p *radius.Packet) (value net.IP) {
	value, _ = MSUserIPv4Address_Lookup(p)
	return
}

func MSUserIPv4Address_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Microsoft_GetsVendor(p, 61) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSUserIPv4Address_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Microsoft_LookupVendor(p, 61)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func MSUserIPv4Address_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 61, a)
}

func MSUserIPv4Address_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 61)
}

func MSUserIPv6Address_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Addr(value)
	if err != nil {
		return
	}
	return _Microsoft_AddVendor(p, 62, a)
}

func MSUserIPv6Address_Get(p *radius.Packet) (value net.IP) {
	value, _ = MSUserIPv6Address_Lookup(p)
	return
}

func MSUserIPv6Address_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Microsoft_GetsVendor(p, 62) {
		i, err = radius.IPv6Addr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MSUserIPv6Address_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Microsoft_LookupVendor(p, 62)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPv6Addr(a)
	return
}

func MSUserIPv6Address_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPv6Addr(value)
	if err != nil {
		return
	}
	return _Microsoft_SetVendor(p, 62, a)
}

func MSUserIPv6Address_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 62)
}

type MSTSGDeviceRedirection uint32

var MSTSGDeviceRedirection_Strings = map[MSTSGDeviceRedirection]string{}

func (a MSTSGDeviceRedirection) String() string {
	if str, ok := MSTSGDeviceRedirection_Strings[a]; ok {
		return str
	}
	return "MSTSGDeviceRedirection(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MSTSGDeviceRedirection_Add(p *radius.Packet, value MSTSGDeviceRedirection) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_AddVendor(p, 63, a)
}

func MSTSGDeviceRedirection_Get(p *radius.Packet) (value MSTSGDeviceRedirection) {
	value, _ = MSTSGDeviceRedirection_Lookup(p)
	return
}

func MSTSGDeviceRedirection_Gets(p *radius.Packet) (values []MSTSGDeviceRedirection, err error) {
	var i uint32
	for _, attr := range _Microsoft_GetsVendor(p, 63) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MSTSGDeviceRedirection(i))
	}
	return
}

func MSTSGDeviceRedirection_Lookup(p *radius.Packet) (value MSTSGDeviceRedirection, err error) {
	a, ok := _Microsoft_LookupVendor(p, 63)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MSTSGDeviceRedirection(i)
	return
}

func MSTSGDeviceRedirection_Set(p *radius.Packet, value MSTSGDeviceRedirection) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Microsoft_SetVendor(p, 63, a)
}

func MSTSGDeviceRedirection_Del(p *radius.Packet) {
	_Microsoft_DelVendor(p, 63)
}
