// Code generated by radius-dict-gen. DO NOT EDIT.

package rfc5904

import (
	"strconv"

	"layeh.com/radius"
)

const (
	PKMSSCert_Type          radius.Type = 137
	PKMCACert_Type          radius.Type = 138
	PKMConfigSettings_Type  radius.Type = 139
	PKMCryptosuiteList_Type radius.Type = 140
	PKMSAID_Type            radius.Type = 141
	PKMSADescriptor_Type    radius.Type = 142
	PKMAuthKey_Type         radius.Type = 143
)

func PKMSSCert_Get(p *radius.Packet) (value []byte) {
	value, _ = PKMSSCert_Lookup(p)
	return
}

func PKMSSCert_GetString(p *radius.Packet) (value string) {
	value, _ = PKMSSCert_LookupString(p)
	return
}

func PKMSSCert_Lookup(p *radius.Packet) (value []byte, err error) {
	var i []byte
	var valid bool
	for _, avp := range p.Attributes {
		if avp.Type != PKMSSCert_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		value = append(value, i...)
		valid = true
	}
	if !valid {
		err = radius.ErrNoAttribute
	}
	return
}

func PKMSSCert_LookupString(p *radius.Packet) (value string, err error) {
	var i string
	var valid bool
	for _, avp := range p.Attributes {
		if avp.Type != PKMSSCert_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		value += i
		valid = true
	}
	if !valid {
		err = radius.ErrNoAttribute
	}
	return
}

func PKMSSCert_Set(p *radius.Packet, value []byte) (err error) {
	const maximumChunkSize = 253
	var attrs []*radius.AVP
	for len(value) > 0 {
		var a radius.Attribute
		n := len(value)
		if n > maximumChunkSize {
			n = maximumChunkSize
		}
		a, err = radius.NewBytes(value[:n])
		if err != nil {
			return
		}
		attrs = append(attrs, &radius.AVP{
			Type:      PKMSSCert_Type,
			Attribute: a,
		})
		value = value[n:]
	}
	p.Attributes = append(p.Attributes, attrs...)
	return
}

func PKMSSCert_SetString(p *radius.Packet, value string) (err error) {
	const maximumChunkSize = 253
	var attrs []*radius.AVP
	for len(value) > 0 {
		var a radius.Attribute
		n := len(value)
		if n > maximumChunkSize {
			n = maximumChunkSize
		}
		a, err = radius.NewString(value[:n])
		if err != nil {
			return
		}
		attrs = append(attrs, &radius.AVP{
			Type:      PKMSSCert_Type,
			Attribute: a,
		})
		value = value[n:]
	}
	p.Attributes = append(p.Attributes, attrs...)
	return
}

func PKMSSCert_Del(p *radius.Packet) {
	p.Attributes.Del(PKMSSCert_Type)
}

func PKMCACert_Get(p *radius.Packet) (value []byte) {
	value, _ = PKMCACert_Lookup(p)
	return
}

func PKMCACert_GetString(p *radius.Packet) (value string) {
	value, _ = PKMCACert_LookupString(p)
	return
}

func PKMCACert_Lookup(p *radius.Packet) (value []byte, err error) {
	var i []byte
	var valid bool
	for _, avp := range p.Attributes {
		if avp.Type != PKMCACert_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		value = append(value, i...)
		valid = true
	}
	if !valid {
		err = radius.ErrNoAttribute
	}
	return
}

func PKMCACert_LookupString(p *radius.Packet) (value string, err error) {
	var i string
	var valid bool
	for _, avp := range p.Attributes {
		if avp.Type != PKMCACert_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		value += i
		valid = true
	}
	if !valid {
		err = radius.ErrNoAttribute
	}
	return
}

func PKMCACert_Set(p *radius.Packet, value []byte) (err error) {
	const maximumChunkSize = 253
	var attrs []*radius.AVP
	for len(value) > 0 {
		var a radius.Attribute
		n := len(value)
		if n > maximumChunkSize {
			n = maximumChunkSize
		}
		a, err = radius.NewBytes(value[:n])
		if err != nil {
			return
		}
		attrs = append(attrs, &radius.AVP{
			Type:      PKMCACert_Type,
			Attribute: a,
		})
		value = value[n:]
	}
	p.Attributes = append(p.Attributes, attrs...)
	return
}

func PKMCACert_SetString(p *radius.Packet, value string) (err error) {
	const maximumChunkSize = 253
	var attrs []*radius.AVP
	for len(value) > 0 {
		var a radius.Attribute
		n := len(value)
		if n > maximumChunkSize {
			n = maximumChunkSize
		}
		a, err = radius.NewString(value[:n])
		if err != nil {
			return
		}
		attrs = append(attrs, &radius.AVP{
			Type:      PKMCACert_Type,
			Attribute: a,
		})
		value = value[n:]
	}
	p.Attributes = append(p.Attributes, attrs...)
	return
}

func PKMCACert_Del(p *radius.Packet) {
	p.Attributes.Del(PKMCACert_Type)
}

func PKMConfigSettings_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(PKMConfigSettings_Type, a)
	return
}

func PKMConfigSettings_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(PKMConfigSettings_Type, a)
	return
}

func PKMConfigSettings_Get(p *radius.Packet) (value []byte) {
	value, _ = PKMConfigSettings_Lookup(p)
	return
}

func PKMConfigSettings_GetString(p *radius.Packet) (value string) {
	value, _ = PKMConfigSettings_LookupString(p)
	return
}

func PKMConfigSettings_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != PKMConfigSettings_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMConfigSettings_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != PKMConfigSettings_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMConfigSettings_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(PKMConfigSettings_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func PKMConfigSettings_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(PKMConfigSettings_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func PKMConfigSettings_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(PKMConfigSettings_Type, a)
	return
}

func PKMConfigSettings_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(PKMConfigSettings_Type, a)
	return
}

func PKMConfigSettings_Del(p *radius.Packet) {
	p.Attributes.Del(PKMConfigSettings_Type)
}

func PKMCryptosuiteList_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(PKMCryptosuiteList_Type, a)
	return
}

func PKMCryptosuiteList_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(PKMCryptosuiteList_Type, a)
	return
}

func PKMCryptosuiteList_Get(p *radius.Packet) (value []byte) {
	value, _ = PKMCryptosuiteList_Lookup(p)
	return
}

func PKMCryptosuiteList_GetString(p *radius.Packet) (value string) {
	value, _ = PKMCryptosuiteList_LookupString(p)
	return
}

func PKMCryptosuiteList_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != PKMCryptosuiteList_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMCryptosuiteList_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != PKMCryptosuiteList_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMCryptosuiteList_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(PKMCryptosuiteList_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func PKMCryptosuiteList_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(PKMCryptosuiteList_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func PKMCryptosuiteList_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(PKMCryptosuiteList_Type, a)
	return
}

func PKMCryptosuiteList_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(PKMCryptosuiteList_Type, a)
	return
}

func PKMCryptosuiteList_Del(p *radius.Packet) {
	p.Attributes.Del(PKMCryptosuiteList_Type)
}

type PKMSAID uint16

var PKMSAID_Strings = map[PKMSAID]string{}

func (a PKMSAID) String() string {
	if str, ok := PKMSAID_Strings[a]; ok {
		return str
	}
	return "PKMSAID(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func PKMSAID_Add(p *radius.Packet, value PKMSAID) (err error) {
	a := radius.NewShort(uint16(value))
	p.Add(PKMSAID_Type, a)
	return
}

func PKMSAID_Get(p *radius.Packet) (value PKMSAID) {
	value, _ = PKMSAID_Lookup(p)
	return
}

func PKMSAID_Gets(p *radius.Packet) (values []PKMSAID, err error) {
	var i uint16
	for _, avp := range p.Attributes {
		if avp.Type != PKMSAID_Type {
			continue
		}
		attr := avp.Attribute
		i, err = radius.Short(attr)
		if err != nil {
			return
		}
		values = append(values, PKMSAID(i))
	}
	return
}

func PKMSAID_Lookup(p *radius.Packet) (value PKMSAID, err error) {
	a, ok := p.Lookup(PKMSAID_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint16
	i, err = radius.Short(a)
	if err != nil {
		return
	}
	value = PKMSAID(i)
	return
}

func PKMSAID_Set(p *radius.Packet, value PKMSAID) (err error) {
	a := radius.NewShort(uint16(value))
	p.Set(PKMSAID_Type, a)
	return
}

func PKMSAID_Del(p *radius.Packet) {
	p.Attributes.Del(PKMSAID_Type)
}

func PKMSADescriptor_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(PKMSADescriptor_Type, a)
	return
}

func PKMSADescriptor_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(PKMSADescriptor_Type, a)
	return
}

func PKMSADescriptor_Get(p *radius.Packet) (value []byte) {
	value, _ = PKMSADescriptor_Lookup(p)
	return
}

func PKMSADescriptor_GetString(p *radius.Packet) (value string) {
	value, _ = PKMSADescriptor_LookupString(p)
	return
}

func PKMSADescriptor_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != PKMSADescriptor_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMSADescriptor_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != PKMSADescriptor_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMSADescriptor_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(PKMSADescriptor_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func PKMSADescriptor_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(PKMSADescriptor_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func PKMSADescriptor_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(PKMSADescriptor_Type, a)
	return
}

func PKMSADescriptor_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(PKMSADescriptor_Type, a)
	return
}

func PKMSADescriptor_Del(p *radius.Packet) {
	p.Attributes.Del(PKMSADescriptor_Type)
}

func PKMAuthKey_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Add(PKMAuthKey_Type, a)
	return
}

func PKMAuthKey_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Add(PKMAuthKey_Type, a)
	return
}

func PKMAuthKey_Get(p *radius.Packet) (value []byte) {
	value, _ = PKMAuthKey_Lookup(p)
	return
}

func PKMAuthKey_GetString(p *radius.Packet) (value string) {
	value, _ = PKMAuthKey_LookupString(p)
	return
}

func PKMAuthKey_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, avp := range p.Attributes {
		if avp.Type != PKMAuthKey_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMAuthKey_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, avp := range p.Attributes {
		if avp.Type != PKMAuthKey_Type {
			continue
		}
		attr := avp.Attribute
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func PKMAuthKey_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := p.Lookup(PKMAuthKey_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func PKMAuthKey_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := p.Lookup(PKMAuthKey_Type)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func PKMAuthKey_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	p.Set(PKMAuthKey_Type, a)
	return
}

func PKMAuthKey_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	p.Set(PKMAuthKey_Type, a)
	return
}

func PKMAuthKey_Del(p *radius.Packet) {
	p.Attributes.Del(PKMAuthKey_Type)
}
