# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_probes__probes_probe_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the probes.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /probes/probe/config/name (string)

    YANG Description: The name of the probe.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /probes/probe/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the probe.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /probes/probe/config/enabled (boolean)

    YANG Description: Whether the probe is enabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /probes/probe/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Whether the probe is enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ])


class yc_state_openconfig_probes__probes_probe_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /probes/probe/state/name (string)

    YANG Description: The name of the probe.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /probes/probe/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the probe.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /probes/probe/state/enabled (boolean)

    YANG Description: Whether the probe is enabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /probes/probe/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Whether the probe is enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)

  name = __builtin__.property(_get_name)
  enabled = __builtin__.property(_get_enabled)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ])


class yc_config_openconfig_probes__probes_probe_tests_test_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the test of this probe.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled','__test_type','__count','__interval','__source','__history_size','__source_port','__dscp',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)
    self.__test_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=True)
    self.__count = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)
    self.__source = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)
    self.__history_size = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)
    self.__source_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /probes/probe/tests/test/config/name (string)

    YANG Description: The name of the test probe
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /probes/probe/tests/test/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the test probe
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /probes/probe/tests/test/config/enabled (boolean)

    YANG Description: Whether the test is enabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /probes/probe/tests/test/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Whether the test is enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=True)


  def _get_test_type(self):
    """
    Getter method for test_type, mapped from YANG variable /probes/probe/tests/test/config/test_type (oc-probes-types:test-type)

    YANG Description: The type of the probe test.
    """
    return self.__test_type
      
  def _set_test_type(self, v, load=False):
    """
    Setter method for test_type, mapped from YANG variable /probes/probe/tests/test/config/test_type (oc-probes-types:test-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_test_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_test_type() directly.

    YANG Description: The type of the probe test.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """test_type must be of a type compatible with oc-probes-types:test-type""",
          'defined-type': "oc-probes-types:test-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=True)""",
        })

    self.__test_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_test_type(self):
    self.__test_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=True)


  def _get_count(self):
    """
    Getter method for count, mapped from YANG variable /probes/probe/tests/test/config/count (yang:counter64)

    YANG Description: The number of probes per test.
    """
    return self.__count
      
  def _set_count(self, v, load=False):
    """
    Setter method for count, mapped from YANG variable /probes/probe/tests/test/config/count (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_count() directly.

    YANG Description: The number of probes per test.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """count must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)""",
        })

    self.__count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_count(self):
    self.__count = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /probes/probe/tests/test/config/interval (yang:counter64)

    YANG Description: Time between two consecutive probes.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /probes/probe/tests/test/config/interval (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: Time between two consecutive probes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)


  def _get_source(self):
    """
    Getter method for source, mapped from YANG variable /probes/probe/tests/test/config/source (oc-inet:ip-address)

    YANG Description: Source address used when probing, either IPv4 or IPv6.
    """
    return self.__source
      
  def _set_source(self, v, load=False):
    """
    Setter method for source, mapped from YANG variable /probes/probe/tests/test/config/source (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source() directly.

    YANG Description: Source address used when probing, either IPv4 or IPv6.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source(self):
    self.__source = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)


  def _get_history_size(self):
    """
    Getter method for history_size, mapped from YANG variable /probes/probe/tests/test/config/history_size (yang:counter64)

    YANG Description: The number of history entries stored.
    """
    return self.__history_size
      
  def _set_history_size(self, v, load=False):
    """
    Setter method for history_size, mapped from YANG variable /probes/probe/tests/test/config/history_size (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_history_size is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_history_size() directly.

    YANG Description: The number of history entries stored.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """history_size must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)""",
        })

    self.__history_size = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_history_size(self):
    self.__history_size = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=True)


  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /probes/probe/tests/test/config/source_port (oc-inet:port-number)

    YANG Description: Source number used.
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /probes/probe/tests/test/config/source_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source number used.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /probes/probe/tests/test/config/dscp (oc-inet:dscp)

    YANG Description: DSCP code points
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /probes/probe/tests/test/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: DSCP code points
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  enabled = __builtin__.property(_get_enabled, _set_enabled)
  test_type = __builtin__.property(_get_test_type, _set_test_type)
  count = __builtin__.property(_get_count, _set_count)
  interval = __builtin__.property(_get_interval, _set_interval)
  source = __builtin__.property(_get_source, _set_source)
  history_size = __builtin__.property(_get_history_size, _set_history_size)
  source_port = __builtin__.property(_get_source_port, _set_source_port)
  dscp = __builtin__.property(_get_dscp, _set_dscp)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ('test_type', test_type), ('count', count), ('interval', interval), ('source', source), ('history_size', history_size), ('source_port', source_port), ('dscp', dscp), ])


class yc_state_openconfig_probes__probes_probe_tests_test_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enabled','__test_type','__count','__interval','__source','__history_size','__source_port','__dscp',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)
    self.__test_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=False)
    self.__count = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__source = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)
    self.__history_size = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__source_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /probes/probe/tests/test/state/name (string)

    YANG Description: The name of the test probe
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /probes/probe/tests/test/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the test probe
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /probes/probe/tests/test/state/enabled (boolean)

    YANG Description: Whether the test is enabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /probes/probe/tests/test/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Whether the test is enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)


  def _get_test_type(self):
    """
    Getter method for test_type, mapped from YANG variable /probes/probe/tests/test/state/test_type (oc-probes-types:test-type)

    YANG Description: The type of the probe test.
    """
    return self.__test_type
      
  def _set_test_type(self, v, load=False):
    """
    Setter method for test_type, mapped from YANG variable /probes/probe/tests/test/state/test_type (oc-probes-types:test-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_test_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_test_type() directly.

    YANG Description: The type of the probe test.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """test_type must be of a type compatible with oc-probes-types:test-type""",
          'defined-type': "oc-probes-types:test-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=False)""",
        })

    self.__test_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_test_type(self):
    self.__test_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ICMP': {}, 'ICMP6': {}, 'ICMP_TIMESTAMP': {}, 'ICMP6_TIMESTAMP': {}, 'TCP': {}, 'UDP': {}, 'UDP_TIMESTAMP': {}, 'HTTP_GET': {}, 'HTTP_GET_META': {}},), is_leaf=True, yang_name="test-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-probes-types:test-type', is_config=False)


  def _get_count(self):
    """
    Getter method for count, mapped from YANG variable /probes/probe/tests/test/state/count (yang:counter64)

    YANG Description: The number of probes per test.
    """
    return self.__count
      
  def _set_count(self, v, load=False):
    """
    Setter method for count, mapped from YANG variable /probes/probe/tests/test/state/count (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_count() directly.

    YANG Description: The number of probes per test.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """count must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_count(self):
    self.__count = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /probes/probe/tests/test/state/interval (yang:counter64)

    YANG Description: Time between two consecutive probes.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /probes/probe/tests/test/state/interval (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: Time between two consecutive probes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_source(self):
    """
    Getter method for source, mapped from YANG variable /probes/probe/tests/test/state/source (oc-inet:ip-address)

    YANG Description: Source address used when probing, either IPv4 or IPv6.
    """
    return self.__source
      
  def _set_source(self, v, load=False):
    """
    Setter method for source, mapped from YANG variable /probes/probe/tests/test/state/source (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source() directly.

    YANG Description: Source address used when probing, either IPv4 or IPv6.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source(self):
    self.__source = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)


  def _get_history_size(self):
    """
    Getter method for history_size, mapped from YANG variable /probes/probe/tests/test/state/history_size (yang:counter64)

    YANG Description: The number of history entries stored.
    """
    return self.__history_size
      
  def _set_history_size(self, v, load=False):
    """
    Setter method for history_size, mapped from YANG variable /probes/probe/tests/test/state/history_size (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_history_size is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_history_size() directly.

    YANG Description: The number of history entries stored.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """history_size must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__history_size = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_history_size(self):
    self.__history_size = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="history-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /probes/probe/tests/test/state/source_port (oc-inet:port-number)

    YANG Description: Source number used.
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /probes/probe/tests/test/state/source_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source number used.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /probes/probe/tests/test/state/dscp (oc-inet:dscp)

    YANG Description: DSCP code points
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /probes/probe/tests/test/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: DSCP code points
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:dscp', is_config=False)

  name = __builtin__.property(_get_name)
  enabled = __builtin__.property(_get_enabled)
  test_type = __builtin__.property(_get_test_type)
  count = __builtin__.property(_get_count)
  interval = __builtin__.property(_get_interval)
  source = __builtin__.property(_get_source)
  history_size = __builtin__.property(_get_history_size)
  source_port = __builtin__.property(_get_source_port)
  dscp = __builtin__.property(_get_dscp)


  _pyangbind_elements = OrderedDict([('name', name), ('enabled', enabled), ('test_type', test_type), ('count', count), ('interval', interval), ('source', source), ('history_size', history_size), ('source_port', source_port), ('dscp', dscp), ])


class yc_config_openconfig_probes__probes_probe_tests_test_target_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/target/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the test target.
  """
  __slots__ = ('_path_helper', '_extmethods', '__address','__port','__url',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)
    self.__url = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'target', 'config']

  def _get_address(self):
    """
    Getter method for address, mapped from YANG variable /probes/probe/tests/test/target/config/address (oc-inet:ip-address)

    YANG Description: IP address of the target, either IPv4 or IPv6.
    """
    return self.__address
      
  def _set_address(self, v, load=False):
    """
    Setter method for address, mapped from YANG variable /probes/probe/tests/test/target/config/address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_address() directly.

    YANG Description: IP address of the target, either IPv4 or IPv6.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_address(self):
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=True)


  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /probes/probe/tests/test/target/config/port (oc-inet:port-number)

    YANG Description: Destination port.
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /probes/probe/tests/test/target/config/port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: Destination port.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=True)


  def _get_url(self):
    """
    Getter method for url, mapped from YANG variable /probes/probe/tests/test/target/config/url (oc-inet:url)

    YANG Description: Target URL to probe.
    """
    return self.__url
      
  def _set_url(self, v, load=False):
    """
    Setter method for url, mapped from YANG variable /probes/probe/tests/test/target/config/url (oc-inet:url)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_url is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_url() directly.

    YANG Description: Target URL to probe.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """url must be of a type compatible with oc-inet:url""",
          'defined-type': "oc-inet:url",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=True)""",
        })

    self.__url = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_url(self):
    self.__url = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=True)

  address = __builtin__.property(_get_address, _set_address)
  port = __builtin__.property(_get_port, _set_port)
  url = __builtin__.property(_get_url, _set_url)


  _pyangbind_elements = OrderedDict([('address', address), ('port', port), ('url', url), ])


class yc_state_openconfig_probes__probes_probe_tests_test_target_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/target/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational data for the test target.
  """
  __slots__ = ('_path_helper', '_extmethods', '__address','__port','__url',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)
    self.__url = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'target', 'state']

  def _get_address(self):
    """
    Getter method for address, mapped from YANG variable /probes/probe/tests/test/target/state/address (oc-inet:ip-address)

    YANG Description: IP address of the target, either IPv4 or IPv6.
    """
    return self.__address
      
  def _set_address(self, v, load=False):
    """
    Setter method for address, mapped from YANG variable /probes/probe/tests/test/target/state/address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_address() directly.

    YANG Description: IP address of the target, either IPv4 or IPv6.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_address(self):
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:ip-address', is_config=False)


  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /probes/probe/tests/test/target/state/port (oc-inet:port-number)

    YANG Description: Destination port.
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /probes/probe/tests/test/target/state/port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: Destination port.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:port-number', is_config=False)


  def _get_url(self):
    """
    Getter method for url, mapped from YANG variable /probes/probe/tests/test/target/state/url (oc-inet:url)

    YANG Description: Target URL to probe.
    """
    return self.__url
      
  def _set_url(self, v, load=False):
    """
    Setter method for url, mapped from YANG variable /probes/probe/tests/test/target/state/url (oc-inet:url)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_url is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_url() directly.

    YANG Description: Target URL to probe.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """url must be of a type compatible with oc-inet:url""",
          'defined-type': "oc-inet:url",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=False)""",
        })

    self.__url = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_url(self):
    self.__url = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="url", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-inet:url', is_config=False)

  address = __builtin__.property(_get_address)
  port = __builtin__.property(_get_port)
  url = __builtin__.property(_get_url)


  _pyangbind_elements = OrderedDict([('address', address), ('port', port), ('url', url), ])


class yc_target_openconfig_probes__probes_probe_tests_test_target(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/target. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The target configuration of the test.
The nature of the target depends on the probe type:
for HTTP probes we need to provide an URL to poll,
while ICMP probes require an IP address to monitor.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'target'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_probes__probes_probe_tests_test_target_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_target_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'target']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /probes/probe/tests/test/target/config (container)

    YANG Description: Configuration data for the test target.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /probes/probe/tests/test/target/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the test target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_probes__probes_probe_tests_test_target_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_probes__probes_probe_tests_test_target_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_probes__probes_probe_tests_test_target_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /probes/probe/tests/test/target/state (container)

    YANG Description: Operational data for the test target.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /probes/probe/tests/test/target/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational data for the test target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_probes__probes_probe_tests_test_target_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_target_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_target_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_state_openconfig_probes__probes_probe_tests_test_results_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/results/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Results of this test: operational data only
  """
  __slots__ = ('_path_helper', '_extmethods', '__timestamp','__start_timestamp','__last_test_timestamp','__test_duration','__failed','__probes_sent','__probes_received','__loss_percentage','__jitter','__min_delay','__max_delay','__avg_delay','__stddev_delay',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    self.__start_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    self.__last_test_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-test-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    self.__test_duration = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__failed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)
    self.__probes_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__probes_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__loss_percentage = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)
    self.__jitter = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__min_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__max_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__avg_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__stddev_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'results', 'state']

  def _get_timestamp(self):
    """
    Getter method for timestamp, mapped from YANG variable /probes/probe/tests/test/results/state/timestamp (oc-types:timeticks64)

    YANG Description: The test timestamp.
This is not the timestamp when the test
was actually executed nither when it finished.
Should be the timestamp when the test has been scheduled.
It may not be the same with start-timestamp.
    """
    return self.__timestamp
      
  def _set_timestamp(self, v, load=False):
    """
    Setter method for timestamp, mapped from YANG variable /probes/probe/tests/test/results/state/timestamp (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timestamp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timestamp() directly.

    YANG Description: The test timestamp.
This is not the timestamp when the test
was actually executed nither when it finished.
Should be the timestamp when the test has been scheduled.
It may not be the same with start-timestamp.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timestamp must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__timestamp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timestamp(self):
    self.__timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)


  def _get_start_timestamp(self):
    """
    Getter method for start_timestamp, mapped from YANG variable /probes/probe/tests/test/results/state/start_timestamp (oc-types:timeticks64)

    YANG Description: The timestamp when the test started.
    """
    return self.__start_timestamp
      
  def _set_start_timestamp(self, v, load=False):
    """
    Setter method for start_timestamp, mapped from YANG variable /probes/probe/tests/test/results/state/start_timestamp (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_timestamp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_timestamp() directly.

    YANG Description: The timestamp when the test started.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_timestamp must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__start_timestamp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_timestamp(self):
    self.__start_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)


  def _get_last_test_timestamp(self):
    """
    Getter method for last_test_timestamp, mapped from YANG variable /probes/probe/tests/test/results/state/last_test_timestamp (oc-types:timeticks64)

    YANG Description: The timestamp when the test finished.
    """
    return self.__last_test_timestamp
      
  def _set_last_test_timestamp(self, v, load=False):
    """
    Setter method for last_test_timestamp, mapped from YANG variable /probes/probe/tests/test/results/state/last_test_timestamp (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_test_timestamp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_test_timestamp() directly.

    YANG Description: The timestamp when the test finished.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-test-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_test_timestamp must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-test-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_test_timestamp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_test_timestamp(self):
    self.__last_test_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-test-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)


  def _get_test_duration(self):
    """
    Getter method for test_duration, mapped from YANG variable /probes/probe/tests/test/results/state/test_duration (yang:counter64)

    YANG Description: The duration of the test, in microseconds.
    """
    return self.__test_duration
      
  def _set_test_duration(self, v, load=False):
    """
    Setter method for test_duration, mapped from YANG variable /probes/probe/tests/test/results/state/test_duration (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_test_duration is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_test_duration() directly.

    YANG Description: The duration of the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """test_duration must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__test_duration = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_test_duration(self):
    self.__test_duration = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_failed(self):
    """
    Getter method for failed, mapped from YANG variable /probes/probe/tests/test/results/state/failed (boolean)

    YANG Description: Whether the test failed or succeeded.
    """
    return self.__failed
      
  def _set_failed(self, v, load=False):
    """
    Setter method for failed, mapped from YANG variable /probes/probe/tests/test/results/state/failed (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_failed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_failed() directly.

    YANG Description: Whether the test failed or succeeded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """failed must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)""",
        })

    self.__failed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_failed(self):
    self.__failed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)


  def _get_probes_sent(self):
    """
    Getter method for probes_sent, mapped from YANG variable /probes/probe/tests/test/results/state/probes_sent (yang:counter64)

    YANG Description: Number of test probes sent.
    """
    return self.__probes_sent
      
  def _set_probes_sent(self, v, load=False):
    """
    Setter method for probes_sent, mapped from YANG variable /probes/probe/tests/test/results/state/probes_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_probes_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_probes_sent() directly.

    YANG Description: Number of test probes sent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """probes_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__probes_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_probes_sent(self):
    self.__probes_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_probes_received(self):
    """
    Getter method for probes_received, mapped from YANG variable /probes/probe/tests/test/results/state/probes_received (yang:counter64)

    YANG Description: Number of test probes received.
    """
    return self.__probes_received
      
  def _set_probes_received(self, v, load=False):
    """
    Setter method for probes_received, mapped from YANG variable /probes/probe/tests/test/results/state/probes_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_probes_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_probes_received() directly.

    YANG Description: Number of test probes received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """probes_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__probes_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_probes_received(self):
    self.__probes_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_loss_percentage(self):
    """
    Getter method for loss_percentage, mapped from YANG variable /probes/probe/tests/test/results/state/loss_percentage (oc-types:percentage)

    YANG Description: The loss percentage.
    """
    return self.__loss_percentage
      
  def _set_loss_percentage(self, v, load=False):
    """
    Setter method for loss_percentage, mapped from YANG variable /probes/probe/tests/test/results/state/loss_percentage (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loss_percentage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loss_percentage() directly.

    YANG Description: The loss percentage.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loss_percentage must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__loss_percentage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loss_percentage(self):
    self.__loss_percentage = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)


  def _get_jitter(self):
    """
    Getter method for jitter, mapped from YANG variable /probes/probe/tests/test/results/state/jitter (yang:counter64)

    YANG Description: The round trip jitter, in microseconds.
    """
    return self.__jitter
      
  def _set_jitter(self, v, load=False):
    """
    Setter method for jitter, mapped from YANG variable /probes/probe/tests/test/results/state/jitter (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_jitter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_jitter() directly.

    YANG Description: The round trip jitter, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """jitter must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__jitter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_jitter(self):
    self.__jitter = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_min_delay(self):
    """
    Getter method for min_delay, mapped from YANG variable /probes/probe/tests/test/results/state/min_delay (yang:counter64)

    YANG Description: The minimum delay recorded during the test, in microseconds.
    """
    return self.__min_delay
      
  def _set_min_delay(self, v, load=False):
    """
    Setter method for min_delay, mapped from YANG variable /probes/probe/tests/test/results/state/min_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_delay() directly.

    YANG Description: The minimum delay recorded during the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__min_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_delay(self):
    self.__min_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_max_delay(self):
    """
    Getter method for max_delay, mapped from YANG variable /probes/probe/tests/test/results/state/max_delay (yang:counter64)

    YANG Description: The maximum delay recorded during the test, in microseconds.
    """
    return self.__max_delay
      
  def _set_max_delay(self, v, load=False):
    """
    Setter method for max_delay, mapped from YANG variable /probes/probe/tests/test/results/state/max_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_delay() directly.

    YANG Description: The maximum delay recorded during the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__max_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_delay(self):
    self.__max_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_avg_delay(self):
    """
    Getter method for avg_delay, mapped from YANG variable /probes/probe/tests/test/results/state/avg_delay (yang:counter64)

    YANG Description: The average delay recorded during the test, in microseconds.
    """
    return self.__avg_delay
      
  def _set_avg_delay(self, v, load=False):
    """
    Setter method for avg_delay, mapped from YANG variable /probes/probe/tests/test/results/state/avg_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_delay() directly.

    YANG Description: The average delay recorded during the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__avg_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_delay(self):
    self.__avg_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_stddev_delay(self):
    """
    Getter method for stddev_delay, mapped from YANG variable /probes/probe/tests/test/results/state/stddev_delay (yang:counter64)

    YANG Description: The standard deviation of the delay of the test.
    """
    return self.__stddev_delay
      
  def _set_stddev_delay(self, v, load=False):
    """
    Setter method for stddev_delay, mapped from YANG variable /probes/probe/tests/test/results/state/stddev_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_stddev_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_stddev_delay() directly.

    YANG Description: The standard deviation of the delay of the test.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """stddev_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__stddev_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_stddev_delay(self):
    self.__stddev_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)

  timestamp = __builtin__.property(_get_timestamp)
  start_timestamp = __builtin__.property(_get_start_timestamp)
  last_test_timestamp = __builtin__.property(_get_last_test_timestamp)
  test_duration = __builtin__.property(_get_test_duration)
  failed = __builtin__.property(_get_failed)
  probes_sent = __builtin__.property(_get_probes_sent)
  probes_received = __builtin__.property(_get_probes_received)
  loss_percentage = __builtin__.property(_get_loss_percentage)
  jitter = __builtin__.property(_get_jitter)
  min_delay = __builtin__.property(_get_min_delay)
  max_delay = __builtin__.property(_get_max_delay)
  avg_delay = __builtin__.property(_get_avg_delay)
  stddev_delay = __builtin__.property(_get_stddev_delay)


  _pyangbind_elements = OrderedDict([('timestamp', timestamp), ('start_timestamp', start_timestamp), ('last_test_timestamp', last_test_timestamp), ('test_duration', test_duration), ('failed', failed), ('probes_sent', probes_sent), ('probes_received', probes_received), ('loss_percentage', loss_percentage), ('jitter', jitter), ('min_delay', min_delay), ('max_delay', max_delay), ('avg_delay', avg_delay), ('stddev_delay', stddev_delay), ])


class yc_state_openconfig_probes__probes_probe_tests_test_results_history_items_item_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/results/history/items/item/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A history item of the probe results: operational data only.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__timestamp','__start_timestamp','__end_timestamp','__test_duration','__failed','__probes_sent','__probes_received','__loss_percentage','__jitter','__min_delay','__max_delay','__avg_delay','__stddev_delay',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    self.__start_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    self.__end_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    self.__test_duration = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__failed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)
    self.__probes_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__probes_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__loss_percentage = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)
    self.__jitter = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__min_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__max_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__avg_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    self.__stddev_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'results', 'history', 'items', 'item', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/id (yang:counter64)

    YANG Description: The test item ID.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/id (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: The test item ID.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_timestamp(self):
    """
    Getter method for timestamp, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/timestamp (oc-types:timeticks64)

    YANG Description: The test timestamp.
This is not the timestamp when the test
was actually executed nither when it finished.
Should be the timestamp when the test has been scheduled.
It may not be the same with start-timestamp.
    """
    return self.__timestamp
      
  def _set_timestamp(self, v, load=False):
    """
    Setter method for timestamp, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/timestamp (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timestamp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timestamp() directly.

    YANG Description: The test timestamp.
This is not the timestamp when the test
was actually executed nither when it finished.
Should be the timestamp when the test has been scheduled.
It may not be the same with start-timestamp.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timestamp must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__timestamp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timestamp(self):
    self.__timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)


  def _get_start_timestamp(self):
    """
    Getter method for start_timestamp, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/start_timestamp (oc-types:timeticks64)

    YANG Description: The timestamp when the test started.
    """
    return self.__start_timestamp
      
  def _set_start_timestamp(self, v, load=False):
    """
    Setter method for start_timestamp, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/start_timestamp (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_timestamp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_timestamp() directly.

    YANG Description: The timestamp when the test started.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_timestamp must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__start_timestamp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_timestamp(self):
    self.__start_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)


  def _get_end_timestamp(self):
    """
    Getter method for end_timestamp, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/end_timestamp (oc-types:timeticks64)

    YANG Description: The timestamp when the test finished.
    """
    return self.__end_timestamp
      
  def _set_end_timestamp(self, v, load=False):
    """
    Setter method for end_timestamp, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/end_timestamp (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_timestamp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_timestamp() directly.

    YANG Description: The timestamp when the test finished.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_timestamp must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__end_timestamp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_timestamp(self):
    self.__end_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="end-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:timeticks64', is_config=False)


  def _get_test_duration(self):
    """
    Getter method for test_duration, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/test_duration (yang:counter64)

    YANG Description: The duration of the test, in microseconds.
    """
    return self.__test_duration
      
  def _set_test_duration(self, v, load=False):
    """
    Setter method for test_duration, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/test_duration (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_test_duration is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_test_duration() directly.

    YANG Description: The duration of the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """test_duration must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__test_duration = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_test_duration(self):
    self.__test_duration = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="test-duration", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_failed(self):
    """
    Getter method for failed, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/failed (boolean)

    YANG Description: Whether the test failed or succeeded.
    """
    return self.__failed
      
  def _set_failed(self, v, load=False):
    """
    Setter method for failed, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/failed (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_failed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_failed() directly.

    YANG Description: Whether the test failed or succeeded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """failed must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)""",
        })

    self.__failed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_failed(self):
    self.__failed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="failed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='boolean', is_config=False)


  def _get_probes_sent(self):
    """
    Getter method for probes_sent, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/probes_sent (yang:counter64)

    YANG Description: Number of test probes sent.
    """
    return self.__probes_sent
      
  def _set_probes_sent(self, v, load=False):
    """
    Setter method for probes_sent, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/probes_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_probes_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_probes_sent() directly.

    YANG Description: Number of test probes sent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """probes_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__probes_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_probes_sent(self):
    self.__probes_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_probes_received(self):
    """
    Getter method for probes_received, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/probes_received (yang:counter64)

    YANG Description: Number of test probes received.
    """
    return self.__probes_received
      
  def _set_probes_received(self, v, load=False):
    """
    Setter method for probes_received, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/probes_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_probes_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_probes_received() directly.

    YANG Description: Number of test probes received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """probes_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__probes_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_probes_received(self):
    self.__probes_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="probes-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_loss_percentage(self):
    """
    Getter method for loss_percentage, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/loss_percentage (oc-types:percentage)

    YANG Description: The loss percentage.
    """
    return self.__loss_percentage
      
  def _set_loss_percentage(self, v, load=False):
    """
    Setter method for loss_percentage, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/loss_percentage (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loss_percentage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loss_percentage() directly.

    YANG Description: The loss percentage.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loss_percentage must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__loss_percentage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loss_percentage(self):
    self.__loss_percentage = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="loss-percentage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='oc-types:percentage', is_config=False)


  def _get_jitter(self):
    """
    Getter method for jitter, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/jitter (yang:counter64)

    YANG Description: The round trip jitter, in microseconds.
    """
    return self.__jitter
      
  def _set_jitter(self, v, load=False):
    """
    Setter method for jitter, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/jitter (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_jitter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_jitter() directly.

    YANG Description: The round trip jitter, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """jitter must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__jitter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_jitter(self):
    self.__jitter = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="jitter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_min_delay(self):
    """
    Getter method for min_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/min_delay (yang:counter64)

    YANG Description: The minimum delay recorded during the test, in microseconds.
    """
    return self.__min_delay
      
  def _set_min_delay(self, v, load=False):
    """
    Setter method for min_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/min_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_delay() directly.

    YANG Description: The minimum delay recorded during the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__min_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_delay(self):
    self.__min_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_max_delay(self):
    """
    Getter method for max_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/max_delay (yang:counter64)

    YANG Description: The maximum delay recorded during the test, in microseconds.
    """
    return self.__max_delay
      
  def _set_max_delay(self, v, load=False):
    """
    Setter method for max_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/max_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_delay() directly.

    YANG Description: The maximum delay recorded during the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__max_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_delay(self):
    self.__max_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_avg_delay(self):
    """
    Getter method for avg_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/avg_delay (yang:counter64)

    YANG Description: The average delay recorded during the test, in microseconds.
    """
    return self.__avg_delay
      
  def _set_avg_delay(self, v, load=False):
    """
    Setter method for avg_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/avg_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg_delay() directly.

    YANG Description: The average delay recorded during the test, in microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__avg_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg_delay(self):
    self.__avg_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="avg-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)


  def _get_stddev_delay(self):
    """
    Getter method for stddev_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/stddev_delay (yang:counter64)

    YANG Description: The standard deviation of the delay of the test.
    """
    return self.__stddev_delay
      
  def _set_stddev_delay(self, v, load=False):
    """
    Setter method for stddev_delay, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state/stddev_delay (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_stddev_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_stddev_delay() directly.

    YANG Description: The standard deviation of the delay of the test.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """stddev_delay must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)""",
        })

    self.__stddev_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_stddev_delay(self):
    self.__stddev_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="stddev-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='yang:counter64', is_config=False)

  id = __builtin__.property(_get_id)
  timestamp = __builtin__.property(_get_timestamp)
  start_timestamp = __builtin__.property(_get_start_timestamp)
  end_timestamp = __builtin__.property(_get_end_timestamp)
  test_duration = __builtin__.property(_get_test_duration)
  failed = __builtin__.property(_get_failed)
  probes_sent = __builtin__.property(_get_probes_sent)
  probes_received = __builtin__.property(_get_probes_received)
  loss_percentage = __builtin__.property(_get_loss_percentage)
  jitter = __builtin__.property(_get_jitter)
  min_delay = __builtin__.property(_get_min_delay)
  max_delay = __builtin__.property(_get_max_delay)
  avg_delay = __builtin__.property(_get_avg_delay)
  stddev_delay = __builtin__.property(_get_stddev_delay)


  _pyangbind_elements = OrderedDict([('id', id), ('timestamp', timestamp), ('start_timestamp', start_timestamp), ('end_timestamp', end_timestamp), ('test_duration', test_duration), ('failed', failed), ('probes_sent', probes_sent), ('probes_received', probes_received), ('loss_percentage', loss_percentage), ('jitter', jitter), ('min_delay', min_delay), ('max_delay', max_delay), ('avg_delay', avg_delay), ('stddev_delay', stddev_delay), ])


class yc_item_openconfig_probes__probes_probe_tests_test_results_history_items_item(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/results/history/items/item. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of history items.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state',)

  _yang_name = 'item'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_results_history_items_item_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'results', 'history', 'items', 'item']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/id (leafref)

    YANG Description: Reference to the history entry ID.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to the history entry ID.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state (container)

    YANG Description: A history item of the probe results: operational data only.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /probes/probe/tests/test/results/history/items/item/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: A history item of the probe results: operational data only.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_probes__probes_probe_tests_test_results_history_items_item_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_results_history_items_item_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_results_history_items_item_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ])


class yc_items_openconfig_probes__probes_probe_tests_test_results_history_items(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/results/history/items. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The list of items in the probe history.
The length depends on the history size.
  """
  __slots__ = ('_path_helper', '_extmethods', '__item',)

  _yang_name = 'items'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__item = YANGDynClass(base=YANGListType("id",yc_item_openconfig_probes__probes_probe_tests_test_results_history_items_item, yang_name="item", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="item", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'results', 'history', 'items']

  def _get_item(self):
    """
    Getter method for item, mapped from YANG variable /probes/probe/tests/test/results/history/items/item (list)

    YANG Description: List of history items.
    """
    return self.__item
      
  def _set_item(self, v, load=False):
    """
    Setter method for item, mapped from YANG variable /probes/probe/tests/test/results/history/items/item (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_item is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_item() directly.

    YANG Description: List of history items.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_item_openconfig_probes__probes_probe_tests_test_results_history_items_item, yang_name="item", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="item", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """item must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_item_openconfig_probes__probes_probe_tests_test_results_history_items_item, yang_name="item", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="item", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=False)""",
        })

    self.__item = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_item(self):
    self.__item = YANGDynClass(base=YANGListType("id",yc_item_openconfig_probes__probes_probe_tests_test_results_history_items_item, yang_name="item", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="item", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=False)

  item = __builtin__.property(_get_item)


  _pyangbind_elements = OrderedDict([('item', item), ])


class yc_history_openconfig_probes__probes_probe_tests_test_results_history(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/results/history. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Historical data of the tests.
  """
  __slots__ = ('_path_helper', '_extmethods', '__items',)

  _yang_name = 'history'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__items = YANGDynClass(base=yc_items_openconfig_probes__probes_probe_tests_test_results_history_items, is_container='container', yang_name="items", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'results', 'history']

  def _get_items(self):
    """
    Getter method for items, mapped from YANG variable /probes/probe/tests/test/results/history/items (container)

    YANG Description: The list of items in the probe history.
The length depends on the history size.
    """
    return self.__items
      
  def _set_items(self, v, load=False):
    """
    Setter method for items, mapped from YANG variable /probes/probe/tests/test/results/history/items (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_items is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_items() directly.

    YANG Description: The list of items in the probe history.
The length depends on the history size.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_items_openconfig_probes__probes_probe_tests_test_results_history_items, is_container='container', yang_name="items", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """items must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_items_openconfig_probes__probes_probe_tests_test_results_history_items, is_container='container', yang_name="items", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)""",
        })

    self.__items = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_items(self):
    self.__items = YANGDynClass(base=yc_items_openconfig_probes__probes_probe_tests_test_results_history_items, is_container='container', yang_name="items", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=False)

  items = __builtin__.property(_get_items)


  _pyangbind_elements = OrderedDict([('items', items), ])


class yc_results_openconfig_probes__probes_probe_tests_test_results(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test/results. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Contains the results of the tests.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state','__history',)

  _yang_name = 'results'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_results_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    self.__history = YANGDynClass(base=yc_history_openconfig_probes__probes_probe_tests_test_results_history, is_container='container', yang_name="history", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test', 'results']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /probes/probe/tests/test/results/state (container)

    YANG Description: Results of this test: operational data only
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /probes/probe/tests/test/results/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Results of this test: operational data only
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_probes__probes_probe_tests_test_results_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_results_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_results_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)


  def _get_history(self):
    """
    Getter method for history, mapped from YANG variable /probes/probe/tests/test/results/history (container)

    YANG Description: Historical data of the tests.
    """
    return self.__history
      
  def _set_history(self, v, load=False):
    """
    Setter method for history, mapped from YANG variable /probes/probe/tests/test/results/history (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_history is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_history() directly.

    YANG Description: Historical data of the tests.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_history_openconfig_probes__probes_probe_tests_test_results_history, is_container='container', yang_name="history", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """history must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_history_openconfig_probes__probes_probe_tests_test_results_history, is_container='container', yang_name="history", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__history = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_history(self):
    self.__history = YANGDynClass(base=yc_history_openconfig_probes__probes_probe_tests_test_results_history, is_container='container', yang_name="history", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

  state = __builtin__.property(_get_state, _set_state)
  history = __builtin__.property(_get_history, _set_history)


  _pyangbind_elements = OrderedDict([('state', state), ('history', history), ])


class yc_test_openconfig_probes__probes_probe_tests_test(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests/test. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of tests associated with this probe.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__target','__results',)

  _yang_name = 'test'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_probes__probes_probe_tests_test_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    self.__target = YANGDynClass(base=yc_target_openconfig_probes__probes_probe_tests_test_target, is_container='container', yang_name="target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    self.__results = YANGDynClass(base=yc_results_openconfig_probes__probes_probe_tests_test_results, is_container='container', yang_name="results", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests', 'test']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /probes/probe/tests/test/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /probes/probe/tests/test/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /probes/probe/tests/test/config (container)

    YANG Description: Configuration data for the test of this probe.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /probes/probe/tests/test/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the test of this probe.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_probes__probes_probe_tests_test_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_probes__probes_probe_tests_test_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_probes__probes_probe_tests_test_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /probes/probe/tests/test/state (container)

    YANG Description: Operational state data
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /probes/probe/tests/test/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_probes__probes_probe_tests_test_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_tests_test_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)


  def _get_target(self):
    """
    Getter method for target, mapped from YANG variable /probes/probe/tests/test/target (container)

    YANG Description: The target configuration of the test.
The nature of the target depends on the probe type:
for HTTP probes we need to provide an URL to poll,
while ICMP probes require an IP address to monitor.
    """
    return self.__target
      
  def _set_target(self, v, load=False):
    """
    Setter method for target, mapped from YANG variable /probes/probe/tests/test/target (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_target is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_target() directly.

    YANG Description: The target configuration of the test.
The nature of the target depends on the probe type:
for HTTP probes we need to provide an URL to poll,
while ICMP probes require an IP address to monitor.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_target_openconfig_probes__probes_probe_tests_test_target, is_container='container', yang_name="target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """target must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_target_openconfig_probes__probes_probe_tests_test_target, is_container='container', yang_name="target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__target = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_target(self):
    self.__target = YANGDynClass(base=yc_target_openconfig_probes__probes_probe_tests_test_target, is_container='container', yang_name="target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)


  def _get_results(self):
    """
    Getter method for results, mapped from YANG variable /probes/probe/tests/test/results (container)

    YANG Description: Contains the results of the tests.
    """
    return self.__results
      
  def _set_results(self, v, load=False):
    """
    Setter method for results, mapped from YANG variable /probes/probe/tests/test/results (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_results is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_results() directly.

    YANG Description: Contains the results of the tests.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_results_openconfig_probes__probes_probe_tests_test_results, is_container='container', yang_name="results", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """results must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_results_openconfig_probes__probes_probe_tests_test_results, is_container='container', yang_name="results", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__results = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_results(self):
    self.__results = YANGDynClass(base=yc_results_openconfig_probes__probes_probe_tests_test_results, is_container='container', yang_name="results", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  target = __builtin__.property(_get_target, _set_target)
  results = __builtin__.property(_get_results, _set_results)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('target', target), ('results', results), ])


class yc_tests_openconfig_probes__probes_probe_tests(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe/tests. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The tests associated to be executed for the probe.
  """
  __slots__ = ('_path_helper', '_extmethods', '__test',)

  _yang_name = 'tests'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__test = YANGDynClass(base=YANGListType("name",yc_test_openconfig_probes__probes_probe_tests_test, yang_name="test", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="test", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe', 'tests']

  def _get_test(self):
    """
    Getter method for test, mapped from YANG variable /probes/probe/tests/test (list)

    YANG Description: List of tests associated with this probe.
    """
    return self.__test
      
  def _set_test(self, v, load=False):
    """
    Setter method for test, mapped from YANG variable /probes/probe/tests/test (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_test is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_test() directly.

    YANG Description: List of tests associated with this probe.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_test_openconfig_probes__probes_probe_tests_test, yang_name="test", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="test", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """test must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_test_openconfig_probes__probes_probe_tests_test, yang_name="test", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="test", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)""",
        })

    self.__test = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_test(self):
    self.__test = YANGDynClass(base=YANGListType("name",yc_test_openconfig_probes__probes_probe_tests_test, yang_name="test", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="test", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)

  test = __builtin__.property(_get_test, _set_test)


  _pyangbind_elements = OrderedDict([('test', test), ])


class yc_probe_openconfig_probes__probes_probe(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes/probe. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of probes configured.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__tests',)

  _yang_name = 'probe'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_probes__probes_probe_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    self.__tests = YANGDynClass(base=yc_tests_openconfig_probes__probes_probe_tests, is_container='container', yang_name="tests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes', 'probe']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /probes/probe/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /probes/probe/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /probes/probe/config (container)

    YANG Description: Configuration data for the probes.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /probes/probe/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the probes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_probes__probes_probe_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_probes__probes_probe_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_probes__probes_probe_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /probes/probe/state (container)

    YANG Description: Operational state data
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /probes/probe/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_probes__probes_probe_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_probes__probes_probe_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_probes__probes_probe_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)


  def _get_tests(self):
    """
    Getter method for tests, mapped from YANG variable /probes/probe/tests (container)

    YANG Description: The tests associated to be executed for the probe.
    """
    return self.__tests
      
  def _set_tests(self, v, load=False):
    """
    Setter method for tests, mapped from YANG variable /probes/probe/tests (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tests is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tests() directly.

    YANG Description: The tests associated to be executed for the probe.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_tests_openconfig_probes__probes_probe_tests, is_container='container', yang_name="tests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tests must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_tests_openconfig_probes__probes_probe_tests, is_container='container', yang_name="tests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__tests = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tests(self):
    self.__tests = YANGDynClass(base=yc_tests_openconfig_probes__probes_probe_tests, is_container='container', yang_name="tests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  tests = __builtin__.property(_get_tests, _set_tests)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('tests', tests), ])


class yc_probes_openconfig_probes__probes(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /probes. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The container containing the list of probes.
  """
  __slots__ = ('_path_helper', '_extmethods', '__probe',)

  _yang_name = 'probes'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__probe = YANGDynClass(base=YANGListType("name",yc_probe_openconfig_probes__probes_probe, yang_name="probe", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="probe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['probes']

  def _get_probe(self):
    """
    Getter method for probe, mapped from YANG variable /probes/probe (list)

    YANG Description: List of probes configured.
    """
    return self.__probe
      
  def _set_probe(self, v, load=False):
    """
    Setter method for probe, mapped from YANG variable /probes/probe (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_probe is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_probe() directly.

    YANG Description: List of probes configured.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_probe_openconfig_probes__probes_probe, yang_name="probe", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="probe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """probe must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_probe_openconfig_probes__probes_probe, yang_name="probe", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="probe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)""",
        })

    self.__probe = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_probe(self):
    self.__probe = YANGDynClass(base=YANGListType("name",yc_probe_openconfig_probes__probes_probe, yang_name="probe", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="probe", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='list', is_config=True)

  probe = __builtin__.property(_get_probe, _set_probe)


  _pyangbind_elements = OrderedDict([('probe', probe), ])


class openconfig_probes(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes - based on the path /openconfig-probes. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
for the probes.
A probe consists on a group of tests, each test being a
source-destination pair to poll. The destination can be either
IP Address (and eventually port) or URL, depending on the
nature of the test. The test can send ICMP, UDP, TCP, or HTTP
requests.
Each test groups a list of test items, the test results
being an overall view or average of the items list.
However, the test preserves only a limited set of history
items, whose length can be controlled using the history-size.
  """
  __slots__ = ('_path_helper', '_extmethods', '__probes',)

  _yang_name = 'openconfig-probes'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__probes = YANGDynClass(base=yc_probes_openconfig_probes__probes, is_container='container', yang_name="probes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_probes(self):
    """
    Getter method for probes, mapped from YANG variable /probes (container)

    YANG Description: The container containing the list of probes.
    """
    return self.__probes
      
  def _set_probes(self, v, load=False):
    """
    Setter method for probes, mapped from YANG variable /probes (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_probes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_probes() directly.

    YANG Description: The container containing the list of probes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_probes_openconfig_probes__probes, is_container='container', yang_name="probes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """probes must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_probes_openconfig_probes__probes, is_container='container', yang_name="probes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)""",
        })

    self.__probes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_probes(self):
    self.__probes = YANGDynClass(base=yc_probes_openconfig_probes__probes, is_container='container', yang_name="probes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/probes', defining_module='openconfig-probes', yang_type='container', is_config=True)

  probes = __builtin__.property(_get_probes, _set_probes)


  _pyangbind_elements = OrderedDict([('probes', probes), ])


class openconfig_probes_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-probes-types - based on the path /openconfig-probes-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines types related to the probes.
  """
  _pyangbind_elements = {}

  

