package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDirectories invokes the vs.DescribeDirectories API synchronously
func (client *Client) DescribeDirectories(request *DescribeDirectoriesRequest) (response *DescribeDirectoriesResponse, err error) {
	response = CreateDescribeDirectoriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDirectoriesWithChan invokes the vs.DescribeDirectories API asynchronously
func (client *Client) DescribeDirectoriesWithChan(request *DescribeDirectoriesRequest) (<-chan *DescribeDirectoriesResponse, <-chan error) {
	responseChan := make(chan *DescribeDirectoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDirectories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDirectoriesWithCallback invokes the vs.DescribeDirectories API asynchronously
func (client *Client) DescribeDirectoriesWithCallback(request *DescribeDirectoriesRequest, callback func(response *DescribeDirectoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDirectoriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDirectories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDirectoriesRequest is the request struct for api DescribeDirectories
type DescribeDirectoriesRequest struct {
	*requests.RpcRequest
	SortDirection string           `position:"Query" name:"SortDirection"`
	PageNum       requests.Integer `position:"Query" name:"PageNum"`
	NoPagination  requests.Boolean `position:"Query" name:"NoPagination"`
	ParentId      string           `position:"Query" name:"ParentId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	GroupId       string           `position:"Query" name:"GroupId"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SortBy        string           `position:"Query" name:"SortBy"`
}

// DescribeDirectoriesResponse is the response struct for api DescribeDirectories
type DescribeDirectoriesResponse struct {
	*responses.BaseResponse
	PageNum     int64       `json:"PageNum" xml:"PageNum"`
	PageSize    int64       `json:"PageSize" xml:"PageSize"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	PageCount   int64       `json:"PageCount" xml:"PageCount"`
	Directories []Directory `json:"Directories" xml:"Directories"`
}

// CreateDescribeDirectoriesRequest creates a request to invoke DescribeDirectories API
func CreateDescribeDirectoriesRequest() (request *DescribeDirectoriesRequest) {
	request = &DescribeDirectoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeDirectories", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDirectoriesResponse creates a response to parse from DescribeDirectories response
func CreateDescribeDirectoriesResponse() (response *DescribeDirectoriesResponse) {
	response = &DescribeDirectoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
