package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUnbindTemplates invokes the vs.BatchUnbindTemplates API synchronously
func (client *Client) BatchUnbindTemplates(request *BatchUnbindTemplatesRequest) (response *BatchUnbindTemplatesResponse, err error) {
	response = CreateBatchUnbindTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUnbindTemplatesWithChan invokes the vs.BatchUnbindTemplates API asynchronously
func (client *Client) BatchUnbindTemplatesWithChan(request *BatchUnbindTemplatesRequest) (<-chan *BatchUnbindTemplatesResponse, <-chan error) {
	responseChan := make(chan *BatchUnbindTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUnbindTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUnbindTemplatesWithCallback invokes the vs.BatchUnbindTemplates API asynchronously
func (client *Client) BatchUnbindTemplatesWithCallback(request *BatchUnbindTemplatesRequest, callback func(response *BatchUnbindTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUnbindTemplatesResponse
		var err error
		defer close(result)
		response, err = client.BatchUnbindTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUnbindTemplatesRequest is the request struct for api BatchUnbindTemplates
type BatchUnbindTemplatesRequest struct {
	*requests.RpcRequest
	TemplateType string           `position:"Query" name:"TemplateType"`
	InstanceType string           `position:"Query" name:"InstanceType"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId   string           `position:"Query" name:"TemplateId"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
}

// BatchUnbindTemplatesResponse is the response struct for api BatchUnbindTemplates
type BatchUnbindTemplatesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateBatchUnbindTemplatesRequest creates a request to invoke BatchUnbindTemplates API
func CreateBatchUnbindTemplatesRequest() (request *BatchUnbindTemplatesRequest) {
	request = &BatchUnbindTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchUnbindTemplates", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchUnbindTemplatesResponse creates a response to parse from BatchUnbindTemplates response
func CreateBatchUnbindTemplatesResponse() (response *BatchUnbindTemplatesResponse) {
	response = &BatchUnbindTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
