package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTagKeysForExpressConnect invokes the vpc.DescribeTagKeysForExpressConnect API synchronously
func (client *Client) DescribeTagKeysForExpressConnect(request *DescribeTagKeysForExpressConnectRequest) (response *DescribeTagKeysForExpressConnectResponse, err error) {
	response = CreateDescribeTagKeysForExpressConnectResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTagKeysForExpressConnectWithChan invokes the vpc.DescribeTagKeysForExpressConnect API asynchronously
func (client *Client) DescribeTagKeysForExpressConnectWithChan(request *DescribeTagKeysForExpressConnectRequest) (<-chan *DescribeTagKeysForExpressConnectResponse, <-chan error) {
	responseChan := make(chan *DescribeTagKeysForExpressConnectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTagKeysForExpressConnect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTagKeysForExpressConnectWithCallback invokes the vpc.DescribeTagKeysForExpressConnect API asynchronously
func (client *Client) DescribeTagKeysForExpressConnectWithCallback(request *DescribeTagKeysForExpressConnectRequest, callback func(response *DescribeTagKeysForExpressConnectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTagKeysForExpressConnectResponse
		var err error
		defer close(result)
		response, err = client.DescribeTagKeysForExpressConnect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTagKeysForExpressConnectRequest is the request struct for api DescribeTagKeysForExpressConnect
type DescribeTagKeysForExpressConnectRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	Keyword              string           `position:"Query" name:"Keyword"`
	ResourceId           *[]string        `position:"Query" name:"ResourceId"  type:"Repeated"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	MaxResult            requests.Integer `position:"Query" name:"MaxResult"`
}

// DescribeTagKeysForExpressConnectResponse is the response struct for api DescribeTagKeysForExpressConnect
type DescribeTagKeysForExpressConnectResponse struct {
	*responses.BaseResponse
	NextToken string                                    `json:"NextToken" xml:"NextToken"`
	RequestId string                                    `json:"RequestId" xml:"RequestId"`
	TagKeys   TagKeysInDescribeTagKeysForExpressConnect `json:"TagKeys" xml:"TagKeys"`
}

// CreateDescribeTagKeysForExpressConnectRequest creates a request to invoke DescribeTagKeysForExpressConnect API
func CreateDescribeTagKeysForExpressConnectRequest() (request *DescribeTagKeysForExpressConnectRequest) {
	request = &DescribeTagKeysForExpressConnectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeTagKeysForExpressConnect", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTagKeysForExpressConnectResponse creates a response to parse from DescribeTagKeysForExpressConnect response
func CreateDescribeTagKeysForExpressConnectResponse() (response *DescribeTagKeysForExpressConnectResponse) {
	response = &DescribeTagKeysForExpressConnectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
