package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEcGrantRelation invokes the vpc.DescribeEcGrantRelation API synchronously
func (client *Client) DescribeEcGrantRelation(request *DescribeEcGrantRelationRequest) (response *DescribeEcGrantRelationResponse, err error) {
	response = CreateDescribeEcGrantRelationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEcGrantRelationWithChan invokes the vpc.DescribeEcGrantRelation API asynchronously
func (client *Client) DescribeEcGrantRelationWithChan(request *DescribeEcGrantRelationRequest) (<-chan *DescribeEcGrantRelationResponse, <-chan error) {
	responseChan := make(chan *DescribeEcGrantRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEcGrantRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEcGrantRelationWithCallback invokes the vpc.DescribeEcGrantRelation API asynchronously
func (client *Client) DescribeEcGrantRelationWithCallback(request *DescribeEcGrantRelationRequest, callback func(response *DescribeEcGrantRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEcGrantRelationResponse
		var err error
		defer close(result)
		response, err = client.DescribeEcGrantRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEcGrantRelationRequest is the request struct for api DescribeEcGrantRelation
type DescribeEcGrantRelationRequest struct {
	*requests.RpcRequest
	VbrRegionNo  string           `position:"Query" name:"VbrRegionNo"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	InstanceType string           `position:"Query" name:"InstanceType"`
}

// DescribeEcGrantRelationResponse is the response struct for api DescribeEcGrantRelation
type DescribeEcGrantRelationResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	TotalCount       int                    `json:"TotalCount" xml:"TotalCount"`
	Count            int                    `json:"Count" xml:"Count"`
	Page             int                    `json:"Page" xml:"Page"`
	PageSize         int                    `json:"PageSize" xml:"PageSize"`
	EcGrantRelations []EcGrantRelationModel `json:"EcGrantRelations" xml:"EcGrantRelations"`
}

// CreateDescribeEcGrantRelationRequest creates a request to invoke DescribeEcGrantRelation API
func CreateDescribeEcGrantRelationRequest() (request *DescribeEcGrantRelationRequest) {
	request = &DescribeEcGrantRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeEcGrantRelation", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEcGrantRelationResponse creates a response to parse from DescribeEcGrantRelation response
func CreateDescribeEcGrantRelationResponse() (response *DescribeEcGrantRelationResponse) {
	response = &DescribeEcGrantRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
