package threedvision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EstimateMonocularVideoDepth invokes the threedvision.EstimateMonocularVideoDepth API synchronously
func (client *Client) EstimateMonocularVideoDepth(request *EstimateMonocularVideoDepthRequest) (response *EstimateMonocularVideoDepthResponse, err error) {
	response = CreateEstimateMonocularVideoDepthResponse()
	err = client.DoAction(request, response)
	return
}

// EstimateMonocularVideoDepthWithChan invokes the threedvision.EstimateMonocularVideoDepth API asynchronously
func (client *Client) EstimateMonocularVideoDepthWithChan(request *EstimateMonocularVideoDepthRequest) (<-chan *EstimateMonocularVideoDepthResponse, <-chan error) {
	responseChan := make(chan *EstimateMonocularVideoDepthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EstimateMonocularVideoDepth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EstimateMonocularVideoDepthWithCallback invokes the threedvision.EstimateMonocularVideoDepth API asynchronously
func (client *Client) EstimateMonocularVideoDepthWithCallback(request *EstimateMonocularVideoDepthRequest, callback func(response *EstimateMonocularVideoDepthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EstimateMonocularVideoDepthResponse
		var err error
		defer close(result)
		response, err = client.EstimateMonocularVideoDepth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EstimateMonocularVideoDepthRequest is the request struct for api EstimateMonocularVideoDepth
type EstimateMonocularVideoDepthRequest struct {
	*requests.RpcRequest
	SampleRate string           `position:"Body" name:"SampleRate"`
	Async      requests.Boolean `position:"Body" name:"Async"`
	VideoURL   string           `position:"Body" name:"VideoURL"`
}

// EstimateMonocularVideoDepthResponse is the response struct for api EstimateMonocularVideoDepth
type EstimateMonocularVideoDepthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEstimateMonocularVideoDepthRequest creates a request to invoke EstimateMonocularVideoDepth API
func CreateEstimateMonocularVideoDepthRequest() (request *EstimateMonocularVideoDepthRequest) {
	request = &EstimateMonocularVideoDepthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("threedvision", "2021-01-31", "EstimateMonocularVideoDepth", "threedvision", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEstimateMonocularVideoDepthResponse creates a response to parse from EstimateMonocularVideoDepth response
func CreateEstimateMonocularVideoDepthResponse() (response *EstimateMonocularVideoDepthResponse) {
	response = &EstimateMonocularVideoDepthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
