package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSimilarSecurityEventsQueryTask invokes the sas.CreateSimilarSecurityEventsQueryTask API synchronously
func (client *Client) CreateSimilarSecurityEventsQueryTask(request *CreateSimilarSecurityEventsQueryTaskRequest) (response *CreateSimilarSecurityEventsQueryTaskResponse, err error) {
	response = CreateCreateSimilarSecurityEventsQueryTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSimilarSecurityEventsQueryTaskWithChan invokes the sas.CreateSimilarSecurityEventsQueryTask API asynchronously
func (client *Client) CreateSimilarSecurityEventsQueryTaskWithChan(request *CreateSimilarSecurityEventsQueryTaskRequest) (<-chan *CreateSimilarSecurityEventsQueryTaskResponse, <-chan error) {
	responseChan := make(chan *CreateSimilarSecurityEventsQueryTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSimilarSecurityEventsQueryTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSimilarSecurityEventsQueryTaskWithCallback invokes the sas.CreateSimilarSecurityEventsQueryTask API asynchronously
func (client *Client) CreateSimilarSecurityEventsQueryTaskWithCallback(request *CreateSimilarSecurityEventsQueryTaskRequest, callback func(response *CreateSimilarSecurityEventsQueryTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSimilarSecurityEventsQueryTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateSimilarSecurityEventsQueryTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSimilarSecurityEventsQueryTaskRequest is the request struct for api CreateSimilarSecurityEventsQueryTask
type CreateSimilarSecurityEventsQueryTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId          requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp                 string           `position:"Query" name:"SourceIp"`
	SecurityEventId          requests.Integer `position:"Query" name:"SecurityEventId"`
	SimilarEventScenarioCode string           `position:"Query" name:"SimilarEventScenarioCode"`
}

// CreateSimilarSecurityEventsQueryTaskResponse is the response struct for api CreateSimilarSecurityEventsQueryTask
type CreateSimilarSecurityEventsQueryTaskResponse struct {
	*responses.BaseResponse
	RequestId                                        string                                           `json:"RequestId" xml:"RequestId"`
	CreateSimilarSecurityEventsQueryTaskResponseItem CreateSimilarSecurityEventsQueryTaskResponseItem `json:"CreateSimilarSecurityEventsQueryTaskResponse" xml:"CreateSimilarSecurityEventsQueryTaskResponse"`
}

// CreateCreateSimilarSecurityEventsQueryTaskRequest creates a request to invoke CreateSimilarSecurityEventsQueryTask API
func CreateCreateSimilarSecurityEventsQueryTaskRequest() (request *CreateSimilarSecurityEventsQueryTaskRequest) {
	request = &CreateSimilarSecurityEventsQueryTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "CreateSimilarSecurityEventsQueryTask", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSimilarSecurityEventsQueryTaskResponse creates a response to parse from CreateSimilarSecurityEventsQueryTask response
func CreateCreateSimilarSecurityEventsQueryTaskResponse() (response *CreateSimilarSecurityEventsQueryTaskResponse) {
	response = &CreateSimilarSecurityEventsQueryTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
