package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQualityCheckScheme invokes the qualitycheck.ListQualityCheckScheme API synchronously
func (client *Client) ListQualityCheckScheme(request *ListQualityCheckSchemeRequest) (response *ListQualityCheckSchemeResponse, err error) {
	response = CreateListQualityCheckSchemeResponse()
	err = client.DoAction(request, response)
	return
}

// ListQualityCheckSchemeWithChan invokes the qualitycheck.ListQualityCheckScheme API asynchronously
func (client *Client) ListQualityCheckSchemeWithChan(request *ListQualityCheckSchemeRequest) (<-chan *ListQualityCheckSchemeResponse, <-chan error) {
	responseChan := make(chan *ListQualityCheckSchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQualityCheckScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQualityCheckSchemeWithCallback invokes the qualitycheck.ListQualityCheckScheme API asynchronously
func (client *Client) ListQualityCheckSchemeWithCallback(request *ListQualityCheckSchemeRequest, callback func(response *ListQualityCheckSchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQualityCheckSchemeResponse
		var err error
		defer close(result)
		response, err = client.ListQualityCheckScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQualityCheckSchemeRequest is the request struct for api ListQualityCheckScheme
type ListQualityCheckSchemeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// ListQualityCheckSchemeResponse is the response struct for api ListQualityCheckScheme
type ListQualityCheckSchemeResponse struct {
	*responses.BaseResponse
	RequestId     string                         `json:"RequestId" xml:"RequestId"`
	Success       bool                           `json:"Success" xml:"Success"`
	ResultCountId string                         `json:"ResultCountId" xml:"ResultCountId"`
	Code          string                         `json:"Code" xml:"Code"`
	Message       string                         `json:"Message" xml:"Message"`
	PageNumber    int                            `json:"PageNumber" xml:"PageNumber"`
	PageSize      int                            `json:"PageSize" xml:"PageSize"`
	Count         int                            `json:"Count" xml:"Count"`
	Data          []DataInListQualityCheckScheme `json:"Data" xml:"Data"`
}

// CreateListQualityCheckSchemeRequest creates a request to invoke ListQualityCheckScheme API
func CreateListQualityCheckSchemeRequest() (request *ListQualityCheckSchemeRequest) {
	request = &ListQualityCheckSchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListQualityCheckScheme", "", "")
	request.Method = requests.POST
	return
}

// CreateListQualityCheckSchemeResponse creates a response to parse from ListQualityCheckScheme response
func CreateListQualityCheckSchemeResponse() (response *ListQualityCheckSchemeResponse) {
	response = &ListQualityCheckSchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
