package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScaleOutMigrateTaskList invokes the polardbx.DescribeScaleOutMigrateTaskList API synchronously
func (client *Client) DescribeScaleOutMigrateTaskList(request *DescribeScaleOutMigrateTaskListRequest) (response *DescribeScaleOutMigrateTaskListResponse, err error) {
	response = CreateDescribeScaleOutMigrateTaskListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScaleOutMigrateTaskListWithChan invokes the polardbx.DescribeScaleOutMigrateTaskList API asynchronously
func (client *Client) DescribeScaleOutMigrateTaskListWithChan(request *DescribeScaleOutMigrateTaskListRequest) (<-chan *DescribeScaleOutMigrateTaskListResponse, <-chan error) {
	responseChan := make(chan *DescribeScaleOutMigrateTaskListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScaleOutMigrateTaskList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScaleOutMigrateTaskListWithCallback invokes the polardbx.DescribeScaleOutMigrateTaskList API asynchronously
func (client *Client) DescribeScaleOutMigrateTaskListWithCallback(request *DescribeScaleOutMigrateTaskListRequest, callback func(response *DescribeScaleOutMigrateTaskListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScaleOutMigrateTaskListResponse
		var err error
		defer close(result)
		response, err = client.DescribeScaleOutMigrateTaskList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScaleOutMigrateTaskListRequest is the request struct for api DescribeScaleOutMigrateTaskList
type DescribeScaleOutMigrateTaskListRequest struct {
	*requests.RpcRequest
	DBInstanceName       string           `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScaleOutMigrateTaskListResponse is the response struct for api DescribeScaleOutMigrateTaskList
type DescribeScaleOutMigrateTaskListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Progress  int    `json:"Progress" xml:"Progress"`
}

// CreateDescribeScaleOutMigrateTaskListRequest creates a request to invoke DescribeScaleOutMigrateTaskList API
func CreateDescribeScaleOutMigrateTaskListRequest() (request *DescribeScaleOutMigrateTaskListRequest) {
	request = &DescribeScaleOutMigrateTaskListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeScaleOutMigrateTaskList", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeScaleOutMigrateTaskListResponse creates a response to parse from DescribeScaleOutMigrateTaskList response
func CreateDescribeScaleOutMigrateTaskListResponse() (response *DescribeScaleOutMigrateTaskListResponse) {
	response = &DescribeScaleOutMigrateTaskListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
