package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseSortScript invokes the opensearch.ReleaseSortScript API synchronously
func (client *Client) ReleaseSortScript(request *ReleaseSortScriptRequest) (response *ReleaseSortScriptResponse, err error) {
	response = CreateReleaseSortScriptResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseSortScriptWithChan invokes the opensearch.ReleaseSortScript API asynchronously
func (client *Client) ReleaseSortScriptWithChan(request *ReleaseSortScriptRequest) (<-chan *ReleaseSortScriptResponse, <-chan error) {
	responseChan := make(chan *ReleaseSortScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseSortScript(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseSortScriptWithCallback invokes the opensearch.ReleaseSortScript API asynchronously
func (client *Client) ReleaseSortScriptWithCallback(request *ReleaseSortScriptRequest, callback func(response *ReleaseSortScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseSortScriptResponse
		var err error
		defer close(result)
		response, err = client.ReleaseSortScript(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseSortScriptRequest is the request struct for api ReleaseSortScript
type ReleaseSortScriptRequest struct {
	*requests.RoaRequest
	AppVersionId     string `position:"Path" name:"appVersionId"`
	ScriptName       string `position:"Path" name:"scriptName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// ReleaseSortScriptResponse is the response struct for api ReleaseSortScript
type ReleaseSortScriptResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateReleaseSortScriptRequest creates a request to invoke ReleaseSortScript API
func CreateReleaseSortScriptRequest() (request *ReleaseSortScriptRequest) {
	request = &ReleaseSortScriptRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ReleaseSortScript", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appVersionId]/sort-scripts/[scriptName]/actions/release", "", "")
	request.Method = requests.POST
	return
}

// CreateReleaseSortScriptResponse creates a response to parse from ReleaseSortScript response
func CreateReleaseSortScriptResponse() (response *ReleaseSortScriptResponse) {
	response = &ReleaseSortScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
