package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateABTestExperiment invokes the opensearch.CreateABTestExperiment API synchronously
func (client *Client) CreateABTestExperiment(request *CreateABTestExperimentRequest) (response *CreateABTestExperimentResponse, err error) {
	response = CreateCreateABTestExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateABTestExperimentWithChan invokes the opensearch.CreateABTestExperiment API asynchronously
func (client *Client) CreateABTestExperimentWithChan(request *CreateABTestExperimentRequest) (<-chan *CreateABTestExperimentResponse, <-chan error) {
	responseChan := make(chan *CreateABTestExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateABTestExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateABTestExperimentWithCallback invokes the opensearch.CreateABTestExperiment API asynchronously
func (client *Client) CreateABTestExperimentWithCallback(request *CreateABTestExperimentRequest, callback func(response *CreateABTestExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateABTestExperimentResponse
		var err error
		defer close(result)
		response, err = client.CreateABTestExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateABTestExperimentRequest is the request struct for api CreateABTestExperiment
type CreateABTestExperimentRequest struct {
	*requests.RoaRequest
	GroupId          requests.Integer `position:"Path" name:"groupId"`
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// CreateABTestExperimentResponse is the response struct for api CreateABTestExperiment
type CreateABTestExperimentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateCreateABTestExperimentRequest creates a request to invoke CreateABTestExperiment API
func CreateCreateABTestExperimentRequest() (request *CreateABTestExperimentRequest) {
	request = &CreateABTestExperimentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "CreateABTestExperiment", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]/groups/[groupId]/experiments", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateABTestExperimentResponse creates a response to parse from CreateABTestExperiment response
func CreateCreateABTestExperimentResponse() (response *CreateABTestExperimentResponse) {
	response = &CreateABTestExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
