package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyProtocolService invokes the nas.ModifyProtocolService API synchronously
func (client *Client) ModifyProtocolService(request *ModifyProtocolServiceRequest) (response *ModifyProtocolServiceResponse, err error) {
	response = CreateModifyProtocolServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyProtocolServiceWithChan invokes the nas.ModifyProtocolService API asynchronously
func (client *Client) ModifyProtocolServiceWithChan(request *ModifyProtocolServiceRequest) (<-chan *ModifyProtocolServiceResponse, <-chan error) {
	responseChan := make(chan *ModifyProtocolServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyProtocolService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyProtocolServiceWithCallback invokes the nas.ModifyProtocolService API asynchronously
func (client *Client) ModifyProtocolServiceWithCallback(request *ModifyProtocolServiceRequest, callback func(response *ModifyProtocolServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyProtocolServiceResponse
		var err error
		defer close(result)
		response, err = client.ModifyProtocolService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyProtocolServiceRequest is the request struct for api ModifyProtocolService
type ModifyProtocolServiceRequest struct {
	*requests.RpcRequest
	ProtocolServiceId string           `position:"Query" name:"ProtocolServiceId"`
	ClientToken       string           `position:"Query" name:"ClientToken"`
	Description       string           `position:"Query" name:"Description"`
	Throughput        string           `position:"Query" name:"Throughput"`
	FileSystemId      string           `position:"Query" name:"FileSystemId"`
	DryRun            requests.Boolean `position:"Query" name:"DryRun"`
	ProtocolSpec      string           `position:"Query" name:"ProtocolSpec"`
}

// ModifyProtocolServiceResponse is the response struct for api ModifyProtocolService
type ModifyProtocolServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyProtocolServiceRequest creates a request to invoke ModifyProtocolService API
func CreateModifyProtocolServiceRequest() (request *ModifyProtocolServiceRequest) {
	request = &ModifyProtocolServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ModifyProtocolService", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyProtocolServiceResponse creates a response to parse from ModifyProtocolService response
func CreateModifyProtocolServiceResponse() (response *ModifyProtocolServiceResponse) {
	response = &ModifyProtocolServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
