package multimediaai

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFacePerson invokes the multimediaai.DeleteFacePerson API synchronously
// api document: https://help.aliyun.com/api/multimediaai/deletefaceperson.html
func (client *Client) DeleteFacePerson(request *DeleteFacePersonRequest) (response *DeleteFacePersonResponse, err error) {
	response = CreateDeleteFacePersonResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFacePersonWithChan invokes the multimediaai.DeleteFacePerson API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/deletefaceperson.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFacePersonWithChan(request *DeleteFacePersonRequest) (<-chan *DeleteFacePersonResponse, <-chan error) {
	responseChan := make(chan *DeleteFacePersonResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFacePerson(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFacePersonWithCallback invokes the multimediaai.DeleteFacePerson API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/deletefaceperson.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFacePersonWithCallback(request *DeleteFacePersonRequest, callback func(response *DeleteFacePersonResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFacePersonResponse
		var err error
		defer close(result)
		response, err = client.DeleteFacePerson(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFacePersonRequest is the request struct for api DeleteFacePerson
type DeleteFacePersonRequest struct {
	*requests.RpcRequest
	FaceGroupId  requests.Integer `position:"Query" name:"FaceGroupId"`
	FacePersonId requests.Integer `position:"Query" name:"FacePersonId"`
}

// DeleteFacePersonResponse is the response struct for api DeleteFacePerson
type DeleteFacePersonResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFacePersonRequest creates a request to invoke DeleteFacePerson API
func CreateDeleteFacePersonRequest() (request *DeleteFacePersonRequest) {
	request = &DeleteFacePersonRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("multimediaai", "2019-08-10", "DeleteFacePerson", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteFacePersonResponse creates a response to parse from DeleteFacePerson response
func CreateDeleteFacePersonResponse() (response *DeleteFacePersonResponse) {
	response = &DeleteFacePersonResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
